h11563
s 00005/00016/00074
d D 1.14 99/12/06 16:33:39 shannon 15 14
c Update copyright for SCSL release
e
s 00008/00000/00082
d D 1.13 99/05/11 09:20:01 shannon 14 13
c add missing javadoc @param and @return clauses
e
s 00025/00022/00057
d D 1.12 99/03/25 17:34:58 shannon 13 12
c clean up code and javadocs
e
s 00001/00001/00078
d D 1.11 98/01/16 20:22:14 bhc 12 11
c swapped the names of the obj and os variables to make a little more sense! ;-)
c 
e
s 00003/00001/00076
d D 1.10 97/12/19 14:33:30 bhc 11 10
c javadoc fixes
c 
e
s 00020/00009/00057
d D 1.9 97/12/09 10:32:42 bhc 10 9
c updated javadocs
e
s 00001/00001/00065
d D 1.8 97/10/28 13:50:43 bhc 9 8
c changed putByteStream to writeTo
e
s 00000/00002/00066
d D 1.7 97/10/20 18:04:34 bhc 8 7
c ...
c 
e
s 00014/00005/00054
d D 1.6 97/10/20 18:03:53 bhc 7 6
c made some doc improvements and added IOException to getContent
c 
e
s 00003/00004/00056
d D 1.5 97/10/13 11:24:33 bhc 6 5
c updated for latest API changes
c 
e
s 00001/00001/00059
d D 1.4 97/10/06 18:28:09 bhc 5 4
c change for putByteStream apo
e
s 00003/00001/00057
d D 1.3 97/10/06 18:06:28 bhc 4 3
c change putByteStream to take a mimeType
e
s 00002/00002/00056
d D 1.2 97/10/06 10:55:14 bhc 3 1
c changed to reflect api change from IS to DS in getTransferFlavor
e
s 00000/00000/00000
d R 1.2 97/09/05 16:22:24 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 2 1 src/share/classes/javax/activation/DataContentHandler.java
c Name history : 1 0 src/classes/javax/activation/DataContentHandler.java
e
s 00058/00000/00000
d D 1.1 97/09/05 16:22:23 bhc 1 0
c date and time created 97/09/05 16:22:23 by bhc
e
u
U
f e 0
t
T
I 1
/*
 * %W% %E%
D 13
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
E 13
I 13
 *
D 15
 * Copyright (c) 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 *
E 13
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
D 13
 * 
E 13
I 13
 *
E 13
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
D 13
 * 
E 13
I 13
 *
E 13
 * @author Bart Calder
E 15
I 15
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
E 15
 */

package javax.activation;

import java.awt.datatransfer.DataFlavor;
I 7
import java.awt.datatransfer.UnsupportedFlavorException;
E 7
import java.io.InputStream;
I 4
import java.io.IOException;
E 4
import java.io.OutputStream;
I 3
import javax.activation.DataSource;
E 3

I 7
/**
 * The DataContentHandler interface is implemented by objects that can
 * be used to extend the capabilities of the DataHandler's implementation
D 10
 * of the Transferable interface. 
E 10
I 10
D 11
 * of the Transferable interface. <p>
E 11
I 11
 * of the Transferable interface. Through <code>DataContentHandlers</code>
D 13
 * the framework can be extended to convert streams in to objects, and 
 * to write data to objects. (see below)<p>
E 13
I 13
 * the framework can be extended to convert streams in to objects, and
 * to write objects to streams. <p>
E 13
E 11
 *
 * Applications don't generally call the methods in DataContentHandlers
D 13
 * directly. Instead an application calls the equivalent methods in 
E 13
I 13
 * directly. Instead, an application calls the equivalent methods in
E 13
 * DataHandler. The DataHandler will attempt to find an appropriate
D 13
 * DataContentHandler that corresponds to it's MIME type in it's
E 13
I 13
 * DataContentHandler that corresponds to its MIME type using the
E 13
 * current DataContentHandlerFactory. The DataHandler then calls
D 13
 * through to the methods in DataContentHandler.
E 13
I 13
 * through to the methods in the DataContentHandler.
E 13
E 10
 */

E 7
D 3

E 3
public interface DataContentHandler {
    /**
D 7
     * return the DataFlavors for this <code>DataContentHandler</code>
E 7
I 7
D 10
     * Return the DataFlavors for this <code>DataContentHandler</code>.
     * This method should return a <i>non null</i> array of zero or
     * more DataFlavors that can created by this object.
E 10
I 10
     * Returns an array of DataFlavor objects indicating the flavors the
     * data can be provided in. The array should be ordered according to
D 13
     * preference for providing the data (from most richly descriptive to 
E 13
I 13
     * preference for providing the data (from most richly descriptive to
E 13
     * least descriptive).
I 13
     *
E 13
E 10
E 7
     * @return The DataFlavors.
     */
D 13
    public DataFlavor[] getTransferDataFlavors(); // throws Exception;
    
E 13
I 13
    public DataFlavor[] getTransferDataFlavors();

E 13
    /**
D 10
     * return the Transfer Data of type DataFlavor from InputStream
E 10
I 10
D 13
     * Returns an object which represents the data to be transferred. 
E 13
I 13
     * Returns an object which represents the data to be transferred.
E 13
     * The class of the object returned is defined by the representation class
D 13
     * of the flavor. 
E 10
D 7
     * @param df The DataFlavor.
     * @param ins The InputStream corresponding to the data.
E 7
I 7
     * @param df The DataFlavor representing the requested type..
E 13
I 13
     * of the flavor.
     *
     * @param df The DataFlavor representing the requested type.
E 13
     * @param ds The DataSource representing the data to be converted.
E 7
     * @return The constructed Object.
     */
D 3
    public Object getTransferData(DataFlavor df, InputStream ins);
E 3
I 3
D 7
    public Object getTransferData(DataFlavor df, DataSource ds);
E 7
I 7
D 13
    public Object getTransferData(DataFlavor df, DataSource ds) throws UnsupportedFlavorException, IOException;
E 7
E 3
    
E 13
I 13
    public Object getTransferData(DataFlavor df, DataSource ds)
				throws UnsupportedFlavorException, IOException;

E 13
    /**
D 6
     * return the InputStream, throws an exception if it cannot
     * construct an InputStream from the object type.
E 6
I 6
D 10
     * Return the content.
E 10
I 10
     * Return an object representing the data in its most preferred form.
     * Generally this will be the form described by the first DataFlavor
D 13
     * returned by the getTransferDataFlavors method.
E 13
I 13
     * returned by the <code>getTransferDataFlavors</code> method.
I 14
     *
     * @param ds The DataSource representing the data to be converted.
     * @return The constructed Object.
E 14
E 13
E 10
E 6
     */
D 6
    public InputStream getInputStream(Object obj); // throws Exception;
E 6
I 6
D 7
    public Object getContent(DataSource ds);
E 7
I 7
    public Object getContent(DataSource ds) throws IOException;
E 7
E 6
D 13
    
E 13
I 13

E 13
    /**
D 10
     * construct an object from a byte stream
E 10
I 10
     * Convert the object to a byte stream of the specified MIME type
     * and write it to the output stream.
I 14
     *
     * @param obj	The object to be converted.
     * @param mimeType	The requested MIME type of the resulting byte stream.
     * @param os	The output stream into which to write the converted
     *			byte stream.
E 14
E 10
D 8
     * (similar semantically to previous method, we are deciding
     *  which one to support)
E 8
     */
D 4
    public void putByteStream(Object obj, OutputStream os) ;
E 4
I 4
D 5
    public void putByteStream(Object obj, OutputStream os, String mimeType) 
E 5
I 5
D 6
    public void putByteStream(OutputStream os, Object obj, String mimeType) 
E 6
I 6
D 9
    public void putByteStream(Object os, String mimeType, OutputStream obj ) 
E 9
I 9
D 12
    public void writeTo(Object os, String mimeType, OutputStream obj ) 
E 12
I 12
D 13
    public void writeTo(Object obj, String mimeType, OutputStream os ) 
E 12
E 9
E 6
E 5
	                                               throws IOException ;
E 13
I 13
    public void writeTo(Object obj, String mimeType, OutputStream os)
	                                               throws IOException;
E 13
E 4
D 10
	// throws Exception;
    
E 10
}
E 1
