h58868
s 00000/00015/00320
d D 1.16 99/12/06 16:35:40 shannon 17 16
c fix copyright
e
s 00009/00000/00326
d D 1.15 99/12/06 16:33:42 shannon 16 15
c Update copyright for SCSL release
e
s 00034/00000/00292
d D 1.14 99/05/11 09:20:03 shannon 15 14
c add missing javadoc @param and @return clauses
e
s 00057/00056/00235
d D 1.13 99/03/25 17:35:00 shannon 14 13
c clean up code and javadocs
e
s 00001/00000/00290
d D 1.12 98/03/05 17:20:56 bhc 13 12
c flush output in write external
c 
e
s 00012/00012/00278
d D 1.11 98/02/06 15:26:50 bhc 12 11
c javadoc overhaul
e
s 00002/00003/00288
d D 1.10 97/10/22 11:27:07 jmoore 11 10
c Change Externalizable support again...
e
s 00003/00015/00288
d D 1.9 97/10/20 18:05:43 jmoore 10 9
c Recode the Externalization support yet again!
e
s 00015/00002/00288
d D 1.8 97/10/20 17:03:26 jmoore 9 8
c Fix up the Externalizable support to reflect Bill and Larry's comments
e
s 00007/00013/00283
d D 1.7 97/10/20 15:27:48 jmoore 8 7
c Remove support for specifying a MimeType with a String that only had a primary type in it.
e
s 00034/00085/00262
d D 1.6 97/10/20 14:28:38 jmoore 7 6
c Clean up the code in respose to Bill's comments
e
s 00254/00483/00093
d D 1.5 97/10/20 10:42:44 jmoore 6 5
c Update MimeType to the latest code.
e
s 00004/00020/00572
d D 1.4 97/10/07 15:30:44 jmoore 5 4
c Update to support new MimeTypeParameterList object and related objects.
e
s 00063/00052/00529
d D 1.3 97/10/07 11:55:18 jmoore 4 3
c Tweak the code a little to fix some problems in toString().
e
s 00189/00011/00392
d D 1.2 97/10/07 11:35:24 jmoore 3 1
c -update parsing methods to use new tokenizer
c -fix toString to support proper quoting and escaping
c -add toShortString() to return a string that only contains the primary/subtype
e
s 00000/00000/00000
d R 1.2 97/10/06 10:54:25 Codemgr 2 1
c SunPro Code Manager data about conflicts, renames, etc...
c Name history : 2 1 src/share/classes/javax/activation/MimeType.java
c Name history : 1 0 src/classes/javax/activation/MimeType.java
e
s 00403/00000/00000
d D 1.1 97/10/06 10:54:24 bhc 1 0
c date and time created 97/10/06 10:54:24 by bhc
e
u
U
f e 0
t
T
I 1
/*
 * %W% %E%
 *
I 16
 * Copyright 1997-1999 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the proprietary information of Sun Microsystems, Inc.  
 * Use is subject to license terms.
 * 
 */
D 17
/*
 * %W% %E%
 *
E 16
D 14
 * Copyright 1993-1997 Sun Microsystems, Inc. 901 San Antonio Road,
E 14
I 14
 * Copyright 1993-1999 Sun Microsystems, Inc. 901 San Antonio Road,
E 14
 * Palo Alto, California, 94303, U.S.A.  All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * CopyrightVersion 1.2
 *
 */
E 17

package javax.activation;

D 6
import	java.io.*;
import	java.util.*;
I 3
import	com.sun.activation.mime.*;
E 6
I 6
import java.io.ObjectOutput;
import java.io.ObjectInput;
import java.io.IOException;
import java.io.*;
E 6
E 3

/**
D 6
 * <p>A Multipurpose Internet Mail Extension (MIME) type, as defined
 * in <a //href="http://ds.internic.net/rfc/rfc2046.txt">RFC 2046</a>.
E 6
I 6
 * A Multipurpose Internet Mail Extension (MIME) type, as defined
 * in RFC 2045 and 2046.
E 6
 */
I 6
public class MimeType implements Externalizable {
E 6

I 14
    private String    primaryType;
    private String    subType;
    private MimeTypeParameterList parameters;

E 14
D 6
public class MimeType implements Serializable {

    /* the canonical null parameters table, for efficiency */

    private static final Hashtable hashtable = new Hashtable();

E 6
    /**
I 14
     * A string that holds all the special chars.
     */
    private static final String TSPECIALS = "()<>@,;:/[]?=\\\"";

    /**
E 14
D 6
     * Construct a full MIME type, with subtype and parameters. The
     * table should contain the parameters, with the key as the
     * parameter names and the values as the parameter values. Both
     * keys and values should be of type <code>java.lang.String</a>.
     * Note that the table will be copied, and that a
     * <code>MimeType</code> object, once created, is immutable.
     *
     * @param primaryType the type of the MimeType (i.e. text).
     *
     * @param subType the subtype of the MimeType (i.e. plain).
     *
     * @param parameters the parameters of the MimeType, as a table
     * of key value, where key is the parameter name (i.e. charset) and
     * the value is the value of the parameter (i.e. iso-8859-1).  
     *
     * @exception IllegalArgumentException if the parameters are of
     * incorrect type.
E 6
I 6
     * Default constructor.
E 6
     */
D 6

    public MimeType(String primaryType, String subType, Hashtable
parameters) {
	this.primaryType = primaryType.toLowerCase().trim();
	this.subType     = subType.toLowerCase().trim();

	this.parameters  = copyParameters(parameters);
E 6
I 6
    public MimeType() {
        primaryType = "application";
        subType = "*";
        parameters = new MimeTypeParameterList();
E 6
    }

    /**
D 6
     * Construct a MIME type with primaryType, subType and no parameters
     * (i.e. text/plain).
     *
     * @param primaryType the type of the MimeType (i.e. text).
     *
     * @param subType the subtype of the MimeType (i.e. plain).
E 6
I 6
     * Constructor that builds a MimeType from a String.
I 15
     *
     * @param rawdata	the MIME type string
E 15
E 6
     */
D 6

    public MimeType(String primaryType, String subType) {
	this(primaryType, subType, hashtable);
E 6
I 6
    public MimeType(String rawdata) throws MimeTypeParseException {
        parse(rawdata);
E 6
    }

    /**
D 6
     *	Construct a MIME type from a string respresentation of the
     *	MIME type. This constructor parses the MIME type string into
     *	its component parts: primaryType, subtype and parameters, if
     *	any.
     *
     *	@param type a MIME type string (i.e. \"text/plain;
     *	charset=iso-8859-1\") 
E 6
I 6
     * Constructor that builds a MimeType with the given primary and sub type
     * but has an empty parameter list.
I 15
     *
     * @param primary	the primary MIME type
     * @param sub	the MIME sub-type
E 15
E 6
     */
D 6

D 3
    public MimeType(String type) throws IOException {
E 3
I 3
    public MimeType(String type) throws MimeTypeParseException {
E 3
	this("", "");
	parse(type);
E 6
I 6
    public MimeType(String primary, String sub) throws MimeTypeParseException {
        //    check to see if primary is valid
D 7
        if(primary.length() > 0) {
            for(int i = 0; i < primary.length(); ++i) {
                if(!isTokenChar(primary.charAt(i))) {
                    throw new MimeTypeParseException("Primary type is invalid.");
                }
            }
E 7
I 7
D 14
        if(isValidToken(primary)) {
E 14
I 14
        if (isValidToken(primary)) {
E 14
E 7
            primaryType = primary.toLowerCase();
        } else {
            throw new MimeTypeParseException("Primary type is invalid.");
        }
D 14
        
E 14
I 14

E 14
        //    check to see if sub is valid
D 7
        if(sub.length() > 0) {
            for(int i = 0; i < sub.length(); ++i) {
                if(!isTokenChar(sub.charAt(i))) {
                    throw new MimeTypeParseException("Sub type is invalid.");
                }
            }
E 7
I 7
D 14
        if(isValidToken(sub)) {
E 14
I 14
        if (isValidToken(sub)) {
E 14
E 7
            subType = sub.toLowerCase();
        } else {
            throw new MimeTypeParseException("Sub type is invalid.");
        }
D 14
        
E 14
I 14

E 14
        parameters = new MimeTypeParameterList();
E 6
    }
I 3
D 14
    
E 14
I 14

E 14
D 6
    protected void	parse(String type) throws MimeTypeParseException
    {
	    ContentTypeTokenizer tokenizer = new ContentTypeTokenizer(type);
	    
	    //	parse the required data which consists of the primary type, a slash, and then the sub type
	    
	    //	parse the primary type
	    int currentToken = tokenizer.nextToken();
	    if(currentToken != ContentTypeTokenizer.STRING_TOKEN)
	    {
	    	reportParseError(ContentTypeTokenizer.STRING_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
	    }
	    primaryType = tokenizer.getCurrentTokenValue().toLowerCase();
	    
	    //	parse the '/' between primary and sub
	    currentToken = tokenizer.nextToken();
D 4
	    if(currentToken != ContentTypeTokenizer.SLASH_TOKEN)
E 4
I 4
	    if((currentToken != ContentTypeTokenizer.SLASH_TOKEN) && (currentToken != ContentTypeTokenizer.EOI_TOKEN))
E 4
	    {
D 4
	    	reportParseError(ContentTypeTokenizer.SLASH_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
E 4
I 4
	    	reportParseError(ContentTypeTokenizer.SLASH_TOKEN, ContentTypeTokenizer.EOI_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
E 4
	    }
D 4
	    //	eat it
E 4
	    
D 4
	    //	parse the sub type
	    currentToken = tokenizer.nextToken();
	    if(currentToken != ContentTypeTokenizer.STRING_TOKEN)
E 4
I 4
	    //	if we have an EOI token then we have a primary-only situation which while not strictly legal, is common
	    if(currentToken == ContentTypeTokenizer.EOI_TOKEN)
E 4
	    {
D 4
	    	reportParseError(ContentTypeTokenizer.STRING_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
E 4
I 4
	    	subType = "*";
E 4
	    }
D 4
	    subType = tokenizer.getCurrentTokenValue();
	    
	    //	parse the optional parameter list
	    
	    //	look for a ';' which will indicate whether a parameter list is present or not
	    currentToken = tokenizer.nextToken();
	    if(currentToken == ContentTypeTokenizer.SEMICOLON_TOKEN)
E 4
I 4
	    else
E 4
	    {
D 4
	    	do
	    	{
		    	//	eat the ';'
		    	
			    //	parse the parameter name
			    currentToken = tokenizer.nextToken();
			    if(currentToken != ContentTypeTokenizer.STRING_TOKEN)
			    {
			    	reportParseError(ContentTypeTokenizer.STRING_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
E 4
I 4
		    //	eat it
		    
		    //	parse the sub type
		    currentToken = tokenizer.nextToken();
		    if(currentToken != ContentTypeTokenizer.STRING_TOKEN)
		    {
		    	reportParseError(ContentTypeTokenizer.STRING_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
		    }
		    subType = tokenizer.getCurrentTokenValue();
		    
		    //	parse the optional parameter list
		    
		    //	look for a ';' which will indicate whether a parameter list is present or not
		    currentToken = tokenizer.nextToken();
		    if(currentToken == ContentTypeTokenizer.SEMICOLON_TOKEN)
		    {
		    	do
		    	{
			    	//	eat the ';'
			    	
				    //	parse the parameter name
				    currentToken = tokenizer.nextToken();
				    if(currentToken != ContentTypeTokenizer.STRING_TOKEN)
				    {
				    	reportParseError(ContentTypeTokenizer.STRING_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
				    }
				    String paramName = tokenizer.getCurrentTokenValue().toLowerCase();
				    
				    //	parse the '=' which separates the name from the value
				    currentToken = tokenizer.nextToken();
				    if(currentToken != ContentTypeTokenizer.EQUALS_TOKEN)
				    {
				    	reportParseError(ContentTypeTokenizer.EQUALS_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
				    }
				    //	eat it
				    
				    //	parse the parameter value (which can be quoted)
				    currentToken = tokenizer.nextToken();
				    if((currentToken != ContentTypeTokenizer.STRING_TOKEN) && (currentToken != ContentTypeTokenizer.QUOTED_STRING_TOKEN))
				    {
				    	reportParseError(ContentTypeTokenizer.STRING_TOKEN, ContentTypeTokenizer.QUOTED_STRING_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
				    }
				    String paramValue = tokenizer.getCurrentTokenValue();
				    
				    //	add the name=value pair to the parameter list
				    parameters.put(paramName, paramValue);
				    
				    //	set up the next iteration
				    currentToken = tokenizer.nextToken();
E 4
			    }
D 4
			    String paramName = tokenizer.getCurrentTokenValue().toLowerCase();
			    
			    //	parse the '=' which separates the name from the value
			    currentToken = tokenizer.nextToken();
			    if(currentToken != ContentTypeTokenizer.EQUALS_TOKEN)
			    {
			    	reportParseError(ContentTypeTokenizer.EQUALS_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
			    }
			    //	eat it
			    
			    //	parse the parameter value (which can be quoted)
			    currentToken = tokenizer.nextToken();
			    if((currentToken != ContentTypeTokenizer.STRING_TOKEN) || (currentToken != ContentTypeTokenizer.QUOTED_STRING_TOKEN))
			    {
			    	reportParseError(ContentTypeTokenizer.STRING_TOKEN, ContentTypeTokenizer.QUOTED_STRING_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
			    }
			    String paramValue = tokenizer.getCurrentTokenValue();
			    
			    //	add the name=value pair to the parameter list
			    parameters.put(paramName, paramValue);
			    
			    //	set up the next iteration
			    currentToken = tokenizer.nextToken();
E 4
I 4
			    while(currentToken == ContentTypeTokenizer.SEMICOLON_TOKEN);
E 4
		    }
D 4
		    while(currentToken == ContentTypeTokenizer.SEMICOLON_TOKEN);
	    }
	    else if(currentToken != ContentTypeTokenizer.EOI_TOKEN)
	    {
	    	reportParseError(ContentTypeTokenizer.EOI_TOKEN, ContentTypeTokenizer.SEMICOLON_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
	    }
E 4
I 4
		    else if(currentToken != ContentTypeTokenizer.EOI_TOKEN)
		    {
		    	reportParseError(ContentTypeTokenizer.EOI_TOKEN, ContentTypeTokenizer.SEMICOLON_TOKEN, currentToken, tokenizer.getCurrentTokenValue());
		    }
		}
E 6
I 6
    /**
     * A routine for parsing the MIME type out of a String.
     */
    private void parse(String rawdata) throws MimeTypeParseException {
        int slashIndex = rawdata.indexOf('/');
        int semIndex = rawdata.indexOf(';');
D 14
        if((slashIndex < 0) && (semIndex < 0)) {
E 14
I 14
        if ((slashIndex < 0) && (semIndex < 0)) {
E 14
D 8
            //    neither character is present, so treat everything as
            //    the primary type and the sub type as '*'
            primaryType = rawdata.trim().toLowerCase();
            subType = "*";
            parameters = new MimeTypeParameterList();
E 8
I 8
            //    neither character is present, so treat it
            //    as an error
            throw new MimeTypeParseException("Unable to find a sub type.");
E 8
D 14
        } else if((slashIndex < 0) && (semIndex >= 0)) {
E 14
I 14
        } else if ((slashIndex < 0) && (semIndex >= 0)) {
E 14
D 8
            //    we have a ';' (and therefore a parameter list)
            //    but everything before the ';' is the primary type
            primaryType = rawdata.substring(0, semIndex).trim().toLowerCase();
            subType = "*";
            parameters = new MimeTypeParameterList(rawdata.substring(semIndex));
E 8
I 8
            //    we have a ';' (and therefore a parameter list),
D 14
            //    but now '/' indicating a sub type is present
E 14
I 14
            //    but no '/' indicating a sub type is present
E 14
            throw new MimeTypeParseException("Unable to find a sub type.");
E 8
D 14
        } else if((slashIndex >= 0) && (semIndex < 0)) {
E 14
I 14
        } else if ((slashIndex >= 0) && (semIndex < 0)) {
E 14
            //    we have a primary and sub type but no parameter list
            primaryType = rawdata.substring(0, slashIndex).trim().toLowerCase();
            subType = rawdata.substring(slashIndex + 1).trim().toLowerCase();
            parameters = new MimeTypeParameterList();
        } else if (slashIndex < semIndex) {
            //    we have all three items in the proper sequence
            primaryType = rawdata.substring(0, slashIndex).trim().toLowerCase();
D 14
            subType = rawdata.substring(slashIndex + 1, semIndex).trim().toLowerCase();
E 14
I 14
            subType = rawdata.substring(slashIndex + 1,
						semIndex).trim().toLowerCase();
E 14
            parameters = new MimeTypeParameterList(rawdata.substring(semIndex));
        } else {
D 14
            //    we have a ';' lexically before a '/' which means we have a primary type
            //    & a parameter list but no sub type
E 14
I 14
            // we have a ';' lexically before a '/' which means we
	    // have a primary type and a parameter list but no sub type
E 14
D 8
            primaryType = rawdata.substring(0, semIndex).trim().toLowerCase();
            subType = "*";
            parameters = new MimeTypeParameterList(rawdata.substring(semIndex));
E 8
I 8
            throw new MimeTypeParseException("Unable to find a sub type.");
E 8
        }
D 14
        
E 14
I 14

E 14
        //    now validate the primary and sub types
D 14
        
E 14
I 14

E 14
        //    check to see if primary is valid
D 7
        if(primaryType.length() > 0) {
            for(int i = 0; i < primaryType.length(); ++i) {
                if(!isTokenChar(primaryType.charAt(i))) {
                    throw new MimeTypeParseException("Primary type is invalid.");
                }
            }
        } else {
E 7
I 7
D 14
        if(!isValidToken(primaryType)) {
E 14
I 14
        if (!isValidToken(primaryType))
E 14
E 7
            throw new MimeTypeParseException("Primary type is invalid.");
D 14
        }
        
E 14
I 14

E 14
        //    check to see if sub is valid
D 7
        if(subType.length() > 0) {
            for(int i = 0; i < subType.length(); ++i) {
                if(!isTokenChar(subType.charAt(i))) {
                    throw new MimeTypeParseException("Sub type is invalid.");
                }
            }
        } else {
E 7
I 7
D 14
        if(!isValidToken(subType)) {
E 14
I 14
        if (!isValidToken(subType))
E 14
E 7
            throw new MimeTypeParseException("Sub type is invalid.");
D 14
        }
E 14
E 6
E 4
    }
D 6
    
    protected static void	reportParseError(int expectedToken, int actualToken, String actualTokenValue) throws MimeTypeParseException
    {
    	throw new MimeTypeParseException("Encountered a " + ContentTypeTokenizer.nameForToken(actualToken) + " token (" + actualTokenValue + ") while expecting a " + ContentTypeTokenizer.nameForToken(expectedToken) + " token.");
    }
    
    protected static void	reportParseError(int expectedToken, int otherExpectedToken, int actualToken, String actualTokenValue) throws MimeTypeParseException
    {
    	throw new MimeTypeParseException("Encountered a " + ContentTypeTokenizer.nameForToken(actualToken) + " token (" + actualTokenValue + ") while expecting a " + ContentTypeTokenizer.nameForToken(expectedToken) + " or a " + ContentTypeTokenizer.nameForToken(otherExpectedToken) + " token.");
    }
E 6
E 3

D 3
    protected void parse(String type) throws IOException {
E 3
I 3
D 6
/*    protected void parse(String type) throws IOException {
E 3
	int typeIndex    = type.indexOf('/');
	int paramIndex   = type.indexOf(';');
	int subTypeIndex =  paramIndex == -1 ? type.length() : paramIndex;
	
	if (typeIndex == -1) {
	    throw new IOException("invalid MIME type: no / separator found: "+
				  type);
	}
	
	primaryType = type.substring(0, typeIndex).toLowerCase().trim();
	subType     = type.substring(++typeIndex,
subTypeIndex).toLowerCase().trim();
	
	if (paramIndex != -1) {
	    parseParams(type.substring(paramIndex));
	}
E 6
I 6
    /**
     * Retrieve the primary type of this object.
I 15
     *
     * @return	the primary MIME type
E 15
     */
    public String getPrimaryType() {
        return primaryType;
E 6
    }

D 6
    protected void parseParams(String type) throws IOException {
	StringTokenizer tokenizer = new StringTokenizer(type, "=;");
	while(tokenizer.hasMoreTokens()) {
	    String key = tokenizer.nextToken();
	    if (!tokenizer.hasMoreTokens()) {
		throw new IOException("invalid parameter specification: " +
				      key);
	    }
	    String value = tokenizer.nextToken();

D 3
	    /* remove the spaces and normalize case */
E 3
I 3
	    // remove the spaces and normalize case
E 3

	    key   = key.toLowerCase().trim();
	    value = (key.equals("charset") ? value.toLowerCase() : value).trim();

	    parameters.put(key, value);
	}
E 6
I 6
    /**
     * Set the primary type for this object to the given String.
I 15
     *
     * @param primary	the primary MIME type
E 15
     */
    public void setPrimaryType(String primary) throws MimeTypeParseException {
        //    check to see if primary is valid
D 7
        for(int i = 0; i < primary.length(); ++i) {
            if(!isTokenChar(primary.charAt(i))) {
                throw new MimeTypeParseException("Primary type is invalid.");
            }
E 7
I 7
D 14
        if(!isValidToken(primaryType)) {
E 14
I 14
        if (!isValidToken(primaryType))
E 14
            throw new MimeTypeParseException("Primary type is invalid.");
E 7
D 14
        }
E 14
        primaryType = primary.toLowerCase();
E 6
    }
I 3
D 6
*/
E 6
E 3

    /**
D 6
     * take a copy of the parameters
E 6
I 6
     * Retrieve the sub type of this object.
I 15
     *
     * @return	the MIME sub-type
E 15
E 6
     */
D 6

    protected Hashtable copyParameters(Hashtable src) {
	Hashtable    result  = (Hashtable)new Hashtable();
	Enumeration keys = src.keys();

	while (keys.hasMoreElements()) {
	    String key = (String)keys.nextElement();
	    result.put(key.toLowerCase().trim(), src.get(key));
	}

	return result;
E 6
I 6
    public String getSubType() {
        return subType;
E 6
    }

    /**
D 6
     * Retrieve the primary type.
     *
 the primary type of the MIME type (i.e. text)
E 6
I 6
     * Set the sub type for this object to the given String.
I 15
     *
     * @param sub	the MIME sub-type
E 15
E 6
     */
D 6
    public String getPrimaryType() {
	return primaryType;
E 6
I 6
    public void setSubType(String sub) throws MimeTypeParseException {
        //    check to see if sub is valid
D 7
        for(int i = 0; i < sub.length(); ++i) {
            if(!isTokenChar(sub.charAt(i))) {
                throw new MimeTypeParseException("Sub type is invalid.");
            }
E 7
I 7
D 14
        if(!isValidToken(subType)) {
E 14
I 14
        if (!isValidToken(subType))
E 14
            throw new MimeTypeParseException("Sub type is invalid.");
E 7
D 14
        }
E 14
        subType = sub.toLowerCase();
E 6
    }

    /**
D 6
     *	Retrieve the subtype.
     *
     * @return the subtype of the MIME type (i.e. plain)
E 6
I 6
     * Retrieve this object's parameter list.
I 15
     *
     * @return	a MimeTypeParameterList object representing the parameters
E 15
E 6
     */
D 6
    public String getSubType() {
	return subType;
E 6
I 6
    public MimeTypeParameterList getParameters() {
        return parameters;
E 6
    }

    /**
D 6
     * Retrieve a given parameter.
     *
     * @param paramName the name of the parameter to lookup (i.e. charset).
     *
     * @return the value of the parameter being looked up (i.e.
iso-8859-1).
E 6
I 6
D 7
     * Use the given parameter list with this object.
E 6
     */
D 6
    public String getParameter(String paramName) {
	/* normalize param name */
	paramName = paramName.toLowerCase().trim();
	return (String)parameters.get(paramName);
E 6
I 6
    public void setParameters(MimeTypeParameterList newParameters) {
        parameters = newParameters;
E 6
    }

    /**
E 7
D 5
     * Retrieve the parameters as an array of strings in the form
"key=value" 
     *
     * @return the parameters as an array of strings in the form
"key=value".
E 5
I 5
D 6
     * Retrieve a list of all parameters
E 6
I 6
     * Retrieve the value associated with the given name, or null if there
     * is no current association.
I 15
     *
     * @param name	the parameter name
     * @return		the paramter's value
E 15
E 6
E 5
     */
I 6
    public String getParameter(String name) {
        return parameters.get(name);
    }
E 6

D 5
    public String[] getParameters() {
E 5
I 5
D 6
    public MimeTypeParameterList getParameters() {
E 5
    
D 5
    //	allocate the return value
    String[] answer = new String[parameters.size()];
    
	Enumeration keys = parameters.keys();
	int i = 0;
	
	while (keys.hasMoreElements()) {
	    String key = (String)keys.nextElement();
	    answer[i++] = key.toLowerCase().trim() + "=" + parameters.get(key);
	}
    
	return answer;
E 5
I 5
    return new MimeTypeParameterList(parameters);
E 6
I 6
    /**
     * Set the value to be associated with the given name, replacing
     * any previous association.
I 15
     *
     * @param name	the parameter name
     * @param value	the paramter's value
E 15
     */
    public void setParameter(String name, String value) {
        parameters.set(name, value);
E 6
E 5
    }

    /**
D 6
     * Retrieve a <code>String</code> representation of this
     * MimeType. This output is RFC 2046-compliant, and is parsable by the
     * <code>String</code> contructor.
     *
     * @return a standard string representation for this MIME type, for 
     *         example: audio/aiff or text/plain; charset=unicode 
E 6
I 6
     * Remove any value associated with the given name.
I 15
     *
     * @param name	the parameter name
E 15
E 6
     */
I 6
    public void removeParameter(String name) {
        parameters.remove(name);
    }
E 6

I 6
    /**
     * Return the String representation of this object.
     */
E 6
    public String toString() {
D 3
	String result = primaryType + "/" + subType;
E 3
I 3
D 6
    	StringBuffer buffer = new StringBuffer();
    	buffer.ensureCapacity(16 + (parameters.size() * 8));	//	heuristic: 8 characters per field
    	
    	buffer.append(primaryType);
    	buffer.append('/');
    	buffer.append(subType);
    	
    	Enumeration keys = parameters.keys();
    	while(keys.hasMoreElements())
    	{
    		buffer.append("; ");
    		
    		String key = (String)keys.nextElement();
    		buffer.append(key);
I 4
    		buffer.append('=');
E 4
       		buffer.append(quote((String)parameters.get(key)));
    	}
    	
    	return buffer.toString();
E 6
I 6
        return getBaseType() + parameters.toString();
E 6
    }
E 3

D 3
	Enumeration keys = parameters.keys();
	while(keys.hasMoreElements()) {
	    String key = (String)keys.nextElement();
	    String value = (String)parameters.get(key);
	    result += "; " + key + "=" + value;
	}
	return result;
E 3
I 3
    /**
D 6
     * Retrieve a <code>String</code> representation of this
     * MimeType that excludes the parameter list. This output
     * is RFC 2046-compliant, and is parsable by the
     * <code>String</code> contructor.
     *
     * @return a standard string representation for this MIME type, for 
     *         example: audio/aiff or text/plain; charset=unicode 
E 6
I 6
     * Return a String representation of this object
     * without the parameter list.
I 15
     *
     * @return	the MIME type and sub-type
E 15
E 6
     */
D 6

    public String toShortString() {
    	StringBuffer buffer = new StringBuffer();
    	buffer.ensureCapacity(16 + (parameters.size() * 8));	//	heuristic: 8 characters per field
    	
    	buffer.append(primaryType);
    	buffer.append('/');
    	buffer.append(subType);
    	
    	return buffer.toString();
E 6
I 6
    public String getBaseType() {
        return primaryType + "/" + subType;
E 6
E 3
    }
I 3
D 14
    
E 14
I 14

E 14
D 6
    protected static String	quote(String value)
    {
    	boolean needsQuotes = false;
    	
    	//	check to see if we actually have to quote this thing
    	int length = value.length();
    	for(int i = 0; (i < length) && !needsQuotes; ++i)
    	{
    		needsQuotes = !ContentTypeTokenizer.isStringTokenChar(value.charAt(i));
    	}
    	
    	if(needsQuotes)
    	{
    		StringBuffer buffer = new StringBuffer();
    		buffer.ensureCapacity((int)(length * 1.5));
    		
    		//	add the initial quote
    		buffer.append('"');
    		
    		//	add the properly escaped text
	    	for(int i = 0; i < length; ++i)
	    	{
	    		char c = value.charAt(i);
	    		if((c == '\\') || (c == '"'))
	    		{
	    			buffer.append('\\');
	    		}
	    		buffer.append(c);
	    	}
    		
    		//	add the closing quote
    		buffer.append('"');
    		
    		return buffer.toString();
    	}
    	else
    	{
    		return value;
    	}
E 6
I 6
    /**
D 14
     * Determine of the primary and sub type of this object is
     * the same as the what is in the given type.
E 14
I 14
     * Determine if the primary and sub type of this object is
     * the same as what is in the given type.
I 15
     *
     * @param type	the MimeType object to compare with
     * @return		true if they match
E 15
E 14
     */
    public boolean match(MimeType type) {
        return primaryType.equals(type.getPrimaryType())
D 7
                    && (primaryType.equals("*")
E 7
I 7
                    && (subType.equals("*")
E 7
                            || type.getSubType().equals("*")
D 7
                            || (primaryType.equals(type.getSubType())));
E 7
I 7
                            || (subType.equals(type.getSubType())));
E 7
E 6
    }
E 3
D 6

E 6
I 6
D 14
    
E 14
I 14

E 14
E 6
    /**
D 6
     * Compare two objects for equality. If the argument is a MIME
     * type object, the equals(MimeType, boolean) method is invoked with
     * Object and false, and the result is returned. Otherwise, this
     * method returns false.
     *
     * @param Object the object to compare this against.  
E 6
I 6
D 14
     * Determine of the primary and sub type of this object is
E 14
I 14
     * Determine if the primary and sub type of this object is
E 14
     * the same as the content type described in rawdata.
I 15
     *
     * @param rawdata	the MIME type string to compare with
     * @return		true if they match
E 15
E 6
     */
D 6

    public boolean equals(Object object) {
	if (object == this) {
	    return true;
	}
	if (object == null || (! (object instanceof MimeType))) {
	    return false;
	}
	
	MimeType type = (MimeType)object;
	return equals(type, false);
E 6
I 6
    public boolean match(String rawdata) throws MimeTypeParseException {
        return match(new MimeType(rawdata));
E 6
    }
D 6

E 6
I 6
D 14
    
E 14
I 14

E 14
E 6
    /**
D 6
     * Compare two MIME type. MIME types are equals if and only if:
     *
     * <ul>
     *
     * <li>Their primary type is equals
     *
     * <li>Their subtype is equal, or one or both of the subtypes are
     * wildcards (\"*\" character).
     *
     * <li>If the compareParams argument is true, they have the same
     * number of parameters, and if they have any parameters, they
     * have the same parameter keys and values.
     *
     * @param type the object to compare this against.
     *
     * @param boolean whether or not to take parameters into account.  
E 6
I 6
     * The object implements the writeExternal method to save its contents
     * by calling the methods of DataOutput for its primitive values or
     * calling the writeObject method of ObjectOutput for objects, strings
     * and arrays.
I 14
     *
I 15
     * @param out	the ObjectOutput object to write to
E 15
E 14
     * @exception IOException Includes any I/O exceptions that may occur
E 6
     */
D 6

    public boolean equals(MimeType type, boolean compareParams) {

	/* compare the primary type */

	if (!this.primaryType.equals(type.primaryType)) {
	    return false;
	}

	/* compare the subtypes */

	boolean oneIsWildCard = this.subType.equals("*") ||
type.subType.equals("*");
	if (!(this.subType.equals(type.subType) || oneIsWildCard)) { 
	    return false;
	}

	/* if we're not comparing the params, or they're both null, we're done */
	if (!compareParams ||
	    parameters == null && type.parameters == null) {
	    return true;
	}

	if (parameters != null && type.parameters == null ||
	    parameters == null && type.parameters != null) {
	    return false;
	}

	int count = parameters.size();

	if (count != type.parameters.size()) {
	    return false;
	}

	if (compareParams) {
		Enumeration keys = parameters.keys();
		while(keys.hasMoreElements()) {
		String key      = (String)keys.nextElement();
		String data     = (String)parameters.get(key);
		String TypeData = type.getParameter(key);

		if (data.equals(TypeData)) {
		    return false;
		}
	    }
	}

	return true;
E 6
I 6
    public void writeExternal(ObjectOutput out) throws IOException {
D 9
        out.writeObject(toString());
E 9
I 9
D 10
        byte[] buffer = toString().getBytes("us-ascii");
        out.write(buffer);
        out.writeByte(0);
E 10
I 10
D 11
        out.writeBytes(toString());
E 11
I 11
        out.writeUTF(toString());
I 13
	out.flush();
E 13
E 11
E 10
E 9
E 6
    }

    /**
D 6
     * Compare two MIME type. MIME types are equals if and only if:
     *
     * <ul>
     *
     * <li>Their primary type is equals
     *
     * <li>Their subtype is equal, or one or both of the subtypes are
     * wildcards (\"*\" character).
     *
     * <li>The parameters specified in significantParams (with optional
     * default values) are equal
     *
     * @param type the object to compare this against.
     *
     * @param significantParams an array of Strings that specify the
parameters
     * to consider significant in the comparison. Each significant may have
     * parameter may have a default value associated with it by appending
     * "=value" to it. For instance, "foo=bar" specifies a parameter named
     * "foo" which has a default value of "bar".
E 6
I 6
     * The object implements the readExternal method to restore its
     * contents by calling the methods of DataInput for primitive
     * types and readObject for objects, strings and arrays.  The
     * readExternal method must read the values in the same sequence
     * and with the same types as were written by writeExternal.
I 15
     *
     * @param in	the IbjectInput object to read from
E 15
     * @exception ClassNotFoundException If the class for an object being
     *              restored cannot be found.
E 6
     */
D 6

    public boolean equals(MimeType type, String[] significantParams) {
    
    //	account for the simple case
    boolean answer = this.equals(type);
    
    //	compare the parameters
    if(significantParams != null) {
	    for(int i = 0; answer && (i < significantParams.length); ++i) {
	    	String[] keyvalue = this.parseKeyValuePair(significantParams[i]);
	    	
	    	//	retrieve the values to compare
	    	String myValue = this.getParameter(keyvalue[0]);
	    	String theirValue = type.getParameter(keyvalue[0]);
	    	
	    	//	do default replacement if necessary
	    	if(keyvalue[1] != null) {
	    		if(myValue == null) {
	    			myValue = keyvalue[1];
	    		}
	    		if(theirValue == null) {
	    			theirValue = keyvalue[1];
	    		}
	    	}
	    	
	    	//	compare them
	    	if(myValue != null) {
	    		answer = myValue.equals(theirValue);
	    	} else {
	    		answer = theirValue != null;
	    	}
E 6
I 6
D 14
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
E 14
I 14
    public void readExternal(ObjectInput in)
				throws IOException, ClassNotFoundException {
E 14
I 9
D 10
        StringBuffer buffer = new StringBuffer();
        buffer.ensureCapacity(64);
        
        int currentByte = in.readByte();
        while(currentByte != 0) {
            // manually shove the byte in as a char since
            // we assume that the thing is in us-ascii.
            buffer.append((char)currentByte);
            currentByte = in.readByte();
        }
        
E 10
I 10
D 11
        String data = in.readLine();
E 11
E 10
E 9
D 7
    	try {
	        parse((String)in.readObject());
	    } catch(MimeTypeParseException e) {
	        throw new IOException(e.toString());
E 6
	    }
E 7
I 7
        try {
D 9
            parse((String)in.readObject());
E 9
I 9
D 10
            parse(buffer.toString());
E 10
I 10
D 11
            parse(data);
E 11
I 11
            parse(in.readUTF());
E 11
E 10
E 9
D 14
        } catch(MimeTypeParseException e) {
E 14
I 14
        } catch (MimeTypeParseException e) {
E 14
            throw new IOException(e.toString());
        }
E 7
D 6
	}
    
    return answer;
    
E 6
    }

D 6
    /*
     * Parse a string of the form "key=value" and return an array of
     * size 2 that contains the key at index 0 and the value at index 1.
     */
    private String[] parseKeyValuePair(String keyvalue)
    {
E 6
I 6
D 14
    private String    primaryType;
    private String    subType;
    private MimeTypeParameterList parameters;
E 6
    
E 14
D 6
    //	allocate the return value
    String[] answer = new String[2];
    
    //	find the '='
    int indexOfEquals = keyvalue.indexOf('=');
    
    //	break the string apart now
    if((indexOfEquals > 0) && (indexOfEquals < (keyvalue.length() - 1))) {
	    answer[0] = keyvalue.substring(0, indexOfEquals).toLowerCase().trim();
	    answer[1] = keyvalue.substring(indexOfEquals + 1);
	} else {
		answer[0] = keyvalue.toLowerCase().trim();
		answer[1] = null;
	}
    
    return answer;
    
E 6
I 6
    //    below here be scary parsing related things

    /**
     * Determine whether or not a given character belongs to a legal token.
     */
    private static boolean isTokenChar(char c) {
D 7
        boolean answer = !Character.isISOControl(c) && !Character.isWhitespace(c);
        
        if(answer) {
            switch(c) {
                case '(':
                case ')':
                case '<':
                case '>':
                case '@':
                case ',':
                case ';':
                case ':':
                case '\\':
                case '"':
                case '/':
                case '[':
                case ']':
                case '?':
                case '=':
                    answer = false;
                    break;
            }
        }
        
        return answer;
E 7
I 7
        return ((c > 040) && (c < 0177)) && (TSPECIALS.indexOf(c) < 0);
E 7
E 6
    }
D 7

E 7
I 7
D 14
    
E 14
I 14

E 14
E 7
D 6
    /*
     *
E 6
I 6
    /**
D 7
     * return the index of the first non white space character in
     * rawdata at or after index i.
E 7
I 7
     * Determine whether or not a given string is a legal token.
E 7
E 6
     */
I 6
D 7
    private static int skipWhiteSpace(String rawdata, int i) {
        int length = rawdata.length();
        if (i < length) {
            char c =  rawdata.charAt(i);
            while ((i < length) && Character.isWhitespace(c)) {
                ++i;
                c = rawdata.charAt(i);
E 7
I 7
    private boolean isValidToken(String s) {
        int len = s.length();
D 14
        if(len > 0) {
E 14
I 14
        if (len > 0) {
E 14
            for (int i = 0; i < len; ++i) {
                char c = s.charAt(i);
                if (!isTokenChar(c)) {
                    return false;
                }
E 7
            }
I 7
            return true;
        } else {
            return false;
E 7
        }
D 7
        
        return i;
E 7
    }
E 6

D 6
    private String primaryType;
    private String subType;
    private Hashtable  parameters;

E 6
I 3
D 5
    /*
E 5
I 5
D 12
    /**
E 5
     * A simple parser test.
D 6
     *
     *	@parameter	args
     *					Strings to parse.
E 6
     */
D 6
	public static void	main(String[] args) throws MimeTypeParseException
	{
		for(int i = 0; i < args.length; ++i)
		{
			MimeType type = new MimeType(args[i]);
			
			System.out.println("Original: " + args[i]);
I 4
			System.out.println("Short:    " + type.toShortString());
E 4
			System.out.println("Parsed:   " + type.toString());
		}
	}
E 6
I 6
    public static void main(String[] args) throws MimeTypeParseException, IOException {
        for(int i = 0; i < args.length; ++i) {
            System.out.println("Original: " + args[i]);
E 12
I 12
D 14
//     /**
//      * A simple parser test.
//      */
//     public static void main(String[] args) throws MimeTypeParseException, IOException {
//         for(int i = 0; i < args.length; ++i) {
//             System.out.println("Original: " + args[i]);
E 14
I 14
    /**
     * A simple parser test,
     * for debugging...
     *
    public static void main(String[] args)
				throws MimeTypeParseException, IOException {
        for (int i = 0; i < args.length; ++i) {
            System.out.println("Original: " + args[i]);
E 14
E 12

D 12
            MimeType type = new MimeType(args[i]);
E 12
I 12
D 14
//             MimeType type = new MimeType(args[i]);
E 14
I 14
            MimeType type = new MimeType(args[i]);
E 14
E 12

D 12
            System.out.println("Short:    " + type.getBaseType());
            System.out.println("Parsed:   " + type.toString());
            System.out.println("");
        }
    }
E 12
I 12
D 14
//             System.out.println("Short:    " + type.getBaseType());
//             System.out.println("Parsed:   " + type.toString());
//             System.out.println("");
//         }
//     }
E 12
    
I 7
    /**
     * A string that holds all the special chars.
     */
    private static final String TSPECIALS = "()<>@,;:\\\"/[]?=";
    
E 14
I 14
            System.out.println("Short:    " + type.getBaseType());
            System.out.println("Parsed:   " + type.toString());
            System.out.println();
        }
    }
    */
E 14
E 7
E 6
D 5

E 5
E 3
}
E 1
