# Authors: Rob Crittenden <rcritten@redhat.com>
#
# Copyright (C) 2007  Red Hat
# see file 'COPYING' for use and warranty information
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#

# The full version including strings
VERSION = "4.9.8"

# A fuller version including the vendor tag (e.g. 3.3.3-34.fc20)
VENDOR_VERSION = "4.9.8"


# Just the numeric portion of the version so one can do direct numeric
# comparisons to see if the API is compatible.
#
# How NUM_VERSION was generated changed over time:
# Before IPA 3.1.3, it was simply concatenated decimal numbers:
#   IPA 2.2.2:  NUM_VERSION=222
#   IPA 2.2.99: NUM_VERSION=2299 (development version)
#   IPA 3.1.0:  NUM_VERSION=310
#   IPA 3.1.3:  NUM_VERSION=313
# In IPA 3.1.4 and 3.2.0, the version was taken as an octal number due to a bug
# (https://fedorahosted.org/freeipa/ticket/3622):
#   IPA 3.1.4:  NUM_VERSION=12356 (octal 030104)
#   IPA 3.2.0:  NUM_VERSION=12416 (octal 030200)
# After IPA 3.2.0, it is decimal number where each part has two digits:
#   IPA 3.2.1:  NUM_VERSION=30201
#   IPA 3.2.99: NUM_VERSION=30299 (development version)
#   IPA 3.3.0:  NUM_VERSION=30300
NUM_VERSION = 40908


# The version of the API.
API_VERSION = "2.245"


DEFAULT_PLUGINS = frozenset(l.strip() for l in """
aci/1
aci_add/1
aci_del/1
aci_find/1
aci_mod/1
aci_rename/1
aci_show/1
adtrust_is_enabled/1
automember/1
automember_add/1
automember_add_condition/1
automember_default_group/1
automember_default_group_remove/1
automember_default_group_set/1
automember_default_group_show/1
automember_del/1
automember_find/1
automember_find_orphans/1
automember_mod/1
automember_rebuild/1
automember_remove_condition/1
automember_show/1
automember_task/1
automountkey/1
automountkey_add/1
automountkey_del/1
automountkey_find/1
automountkey_mod/1
automountkey_show/1
automountlocation/1
automountlocation_add/1
automountlocation_del/1
automountlocation_find/1
automountlocation_show/1
automountlocation_tofiles/1
automountmap/1
automountmap_add/1
automountmap_add_indirect/1
automountmap_del/1
automountmap_find/1
automountmap_mod/1
automountmap_show/1
batch/1
ca/1
ca_add/1
ca_del/1
ca_disable/1
ca_enable/1
ca_find/1
ca_is_enabled/1
ca_mod/1
ca_show/1
caacl/1
caacl_add/1
caacl_add_ca/1
caacl_add_host/1
caacl_add_profile/1
caacl_add_service/1
caacl_add_user/1
caacl_del/1
caacl_disable/1
caacl_enable/1
caacl_find/1
caacl_mod/1
caacl_remove_ca/1
caacl_remove_host/1
caacl_remove_profile/1
caacl_remove_service/1
caacl_remove_user/1
caacl_show/1
cert/1
cert_find/1
cert_remove_hold/1
cert_request/1
cert_revoke/1
cert_show/1
cert_status/1
certmap/1
certmap_match/1
certmapconfig/1
certmapconfig_mod/1
certmapconfig_show/1
certmaprule/1
certmaprule_add/1
certmaprule_del/1
certmaprule_disable/1
certmaprule_enable/1
certmaprule_find/1
certmaprule_mod/1
certmaprule_show/1
certprofile/1
certprofile_del/1
certprofile_find/1
certprofile_import/1
certprofile_mod/1
certprofile_show/1
certreq/1
class/1
class_find/1
class_show/1
command/1
command_defaults/1
command_find/1
command_show/1
compat_is_enabled/1
config/1
config_mod/1
config_show/1
cosentry/1
cosentry_add/1
cosentry_del/1
cosentry_find/1
cosentry_mod/1
cosentry_show/1
delegation/1
delegation_add/1
delegation_del/1
delegation_find/1
delegation_mod/1
delegation_show/1
dns_is_enabled/1
dns_resolve/1
dns_system_records/1
dns_update_system_records/1
dnsa6record/1
dnsaaaarecord/1
dnsafsdbrecord/1
dnsaplrecord/1
dnsarecord/1
dnscertrecord/1
dnscnamerecord/1
dnsconfig/1
dnsconfig_mod/1
dnsconfig_show/1
dnsdhcidrecord/1
dnsdlvrecord/1
dnsdnamerecord/1
dnsdsrecord/1
dnsforwardzone/1
dnsforwardzone_add/1
dnsforwardzone_add_permission/1
dnsforwardzone_del/1
dnsforwardzone_disable/1
dnsforwardzone_enable/1
dnsforwardzone_find/1
dnsforwardzone_mod/1
dnsforwardzone_remove_permission/1
dnsforwardzone_show/1
dnshiprecord/1
dnsipseckeyrecord/1
dnskeyrecord/1
dnskxrecord/1
dnslocrecord/1
dnsmxrecord/1
dnsnaptrrecord/1
dnsnsecrecord/1
dnsnsrecord/1
dnsptrrecord/1
dnsrecord/1
dnsrecord_add/1
dnsrecord_del/1
dnsrecord_delentry/1
dnsrecord_find/1
dnsrecord_mod/1
dnsrecord_show/1
dnsrecord_split_parts/1
dnsrprecord/1
dnsrrsigrecord/1
dnsserver/1
dnsserver_add/1
dnsserver_del/1
dnsserver_find/1
dnsserver_mod/1
dnsserver_show/1
dnssigrecord/1
dnsspfrecord/1
dnssrvrecord/1
dnssshfprecord/1
dnstlsarecord/1
dnstxtrecord/1
dnsurirecord/1
dnszone/1
dnszone_add/1
dnszone_add_permission/1
dnszone_del/1
dnszone_disable/1
dnszone_enable/1
dnszone_find/1
dnszone_mod/1
dnszone_remove_permission/1
dnszone_show/1
domainlevel_get/1
domainlevel_set/1
env/1
group/1
group_add/1
group_add_member/1
group_add_member_manager/1
group_del/1
group_detach/1
group_find/1
group_mod/1
group_remove_member/1
group_remove_member_manager/1
group_show/1
hbacrule/1
hbacrule_add/1
hbacrule_add_host/1
hbacrule_add_service/1
hbacrule_add_sourcehost/1
hbacrule_add_user/1
hbacrule_del/1
hbacrule_disable/1
hbacrule_enable/1
hbacrule_find/1
hbacrule_mod/1
hbacrule_remove_host/1
hbacrule_remove_service/1
hbacrule_remove_sourcehost/1
hbacrule_remove_user/1
hbacrule_show/1
hbacsvc/1
hbacsvc_add/1
hbacsvc_del/1
hbacsvc_find/1
hbacsvc_mod/1
hbacsvc_show/1
hbacsvcgroup/1
hbacsvcgroup_add/1
hbacsvcgroup_add_member/1
hbacsvcgroup_del/1
hbacsvcgroup_find/1
hbacsvcgroup_mod/1
hbacsvcgroup_remove_member/1
hbacsvcgroup_show/1
hbactest/1
host/1
host_add/1
host_add_cert/1
host_add_managedby/1
host_add_principal/1
host_allow_create_keytab/1
host_allow_retrieve_keytab/1
host_del/1
host_disable/1
host_disallow_create_keytab/1
host_disallow_retrieve_keytab/1
host_find/1
host_mod/1
host_remove_cert/1
host_remove_managedby/1
host_remove_principal/1
host_show/1
hostgroup/1
hostgroup_add/1
hostgroup_add_member/1
hostgroup_add_member_manager/1
hostgroup_del/1
hostgroup_find/1
hostgroup_mod/1
hostgroup_remove_member/1
hostgroup_remove_member_manager/1
hostgroup_show/1
i18n_messages/1
idoverridegroup/1
idoverridegroup_add/1
idoverridegroup_del/1
idoverridegroup_find/1
idoverridegroup_mod/1
idoverridegroup_show/1
idoverrideuser/1
idoverrideuser_add/1
idoverrideuser_add_cert/1
idoverrideuser_del/1
idoverrideuser_find/1
idoverrideuser_mod/1
idoverrideuser_remove_cert/1
idoverrideuser_show/1
idrange/1
idrange_add/1
idrange_del/1
idrange_find/1
idrange_mod/1
idrange_show/1
idview/1
idview_add/1
idview_apply/1
idview_del/1
idview_find/1
idview_mod/1
idview_show/1
idview_unapply/1
join/1
json_metadata/1
kra_is_enabled/1
krbtpolicy/1
krbtpolicy_mod/1
krbtpolicy_reset/1
krbtpolicy_show/1
location/1
location_add/1
location_del/1
location_find/1
location_mod/1
location_show/1
metaobject/1
migrate_ds/1
netgroup/1
netgroup_add/1
netgroup_add_member/1
netgroup_del/1
netgroup_find/1
netgroup_mod/1
netgroup_remove_member/1
netgroup_show/1
otpconfig/1
otpconfig_mod/1
otpconfig_show/1
otptoken/1
otptoken_add/1
otptoken_add_managedby/1
otptoken_del/1
otptoken_find/1
otptoken_mod/1
otptoken_remove_managedby/1
otptoken_show/1
output/1
output_find/1
output_show/1
param/1
param_find/1
param_show/1
passwd/1
permission/1
permission_add/1
permission_add_member/1
permission_add_noaci/1
permission_del/1
permission_find/1
permission_mod/1
permission_remove_member/1
permission_show/1
ping/1
pkinit/1
pkinit_status/1
plugins/1
privilege/1
privilege_add/1
privilege_add_member/1
privilege_add_permission/1
privilege_del/1
privilege_find/1
privilege_mod/1
privilege_remove_member/1
privilege_remove_permission/1
privilege_show/1
pwpolicy/1
pwpolicy_add/1
pwpolicy_del/1
pwpolicy_find/1
pwpolicy_mod/1
pwpolicy_show/1
radiusproxy/1
radiusproxy_add/1
radiusproxy_del/1
radiusproxy_find/1
radiusproxy_mod/1
radiusproxy_show/1
realmdomains/1
realmdomains_mod/1
realmdomains_show/1
role/1
role_add/1
role_add_member/1
role_add_privilege/1
role_del/1
role_find/1
role_mod/1
role_remove_member/1
role_remove_privilege/1
role_show/1
schema/1
selfservice/1
selfservice_add/1
selfservice_del/1
selfservice_find/1
selfservice_mod/1
selfservice_show/1
selinuxusermap/1
selinuxusermap_add/1
selinuxusermap_add_host/1
selinuxusermap_add_user/1
selinuxusermap_del/1
selinuxusermap_disable/1
selinuxusermap_enable/1
selinuxusermap_find/1
selinuxusermap_mod/1
selinuxusermap_remove_host/1
selinuxusermap_remove_user/1
selinuxusermap_show/1
server/1
server_conncheck/1
server_del/1
server_find/1
server_mod/1
server_role/1
server_role_find/1
server_role_show/1
server_show/1
server_state/1
service/1
service_add/1
service_add_cert/1
service_add_host/1
service_add_principal/1
service_add_smb/1
service_allow_create_keytab/1
service_allow_retrieve_keytab/1
service_del/1
service_disable/1
service_disallow_create_keytab/1
service_disallow_retrieve_keytab/1
service_find/1
service_mod/1
service_remove_cert/1
service_remove_host/1
service_remove_principal/1
service_show/1
servicedelegationrule/1
servicedelegationrule_add/1
servicedelegationrule_add_member/1
servicedelegationrule_add_target/1
servicedelegationrule_del/1
servicedelegationrule_find/1
servicedelegationrule_remove_member/1
servicedelegationrule_remove_target/1
servicedelegationrule_show/1
servicedelegationtarget/1
servicedelegationtarget_add/1
servicedelegationtarget_add_member/1
servicedelegationtarget_del/1
servicedelegationtarget_find/1
servicedelegationtarget_remove_member/1
servicedelegationtarget_show/1
servrole/1
session_logout/1
sidgen_was_run/1
stageuser/1
stageuser_activate/1
stageuser_add/1
stageuser_add_cert/1
stageuser_add_certmapdata/1
stageuser_add_manager/1
stageuser_add_principal/1
stageuser_del/1
stageuser_find/1
stageuser_mod/1
stageuser_remove_cert/1
stageuser_remove_certmapdata/1
stageuser_remove_manager/1
stageuser_remove_principal/1
stageuser_show/1
subid/1
subid_add/1
subid_del/1
subid_find/1
subid_generate/1
subid_match/1
subid_mod/1
subid_show/1
subid_stats/1
sudocmd/1
sudocmd_add/1
sudocmd_del/1
sudocmd_find/1
sudocmd_mod/1
sudocmd_show/1
sudocmdgroup/1
sudocmdgroup_add/1
sudocmdgroup_add_member/1
sudocmdgroup_del/1
sudocmdgroup_find/1
sudocmdgroup_mod/1
sudocmdgroup_remove_member/1
sudocmdgroup_show/1
sudorule/1
sudorule_add/1
sudorule_add_allow_command/1
sudorule_add_deny_command/1
sudorule_add_host/1
sudorule_add_option/1
sudorule_add_runasgroup/1
sudorule_add_runasuser/1
sudorule_add_user/1
sudorule_del/1
sudorule_disable/1
sudorule_enable/1
sudorule_find/1
sudorule_mod/1
sudorule_remove_allow_command/1
sudorule_remove_deny_command/1
sudorule_remove_host/1
sudorule_remove_option/1
sudorule_remove_runasgroup/1
sudorule_remove_runasuser/1
sudorule_remove_user/1
sudorule_show/1
topic/1
topic_find/1
topic_show/1
topologysegment/1
topologysegment_add/1
topologysegment_del/1
topologysegment_find/1
topologysegment_mod/1
topologysegment_reinitialize/1
topologysegment_show/1
topologysuffix/1
topologysuffix_add/1
topologysuffix_del/1
topologysuffix_find/1
topologysuffix_mod/1
topologysuffix_show/1
topologysuffix_verify/1
trust/1
trust_add/1
trust_del/1
trust_enable_agent/1
trust_fetch_domains/1
trust_find/1
trust_mod/1
trust_resolve/1
trust_show/1
trustconfig/1
trustconfig_mod/1
trustconfig_show/1
trustdomain/1
trustdomain_add/1
trustdomain_del/1
trustdomain_disable/1
trustdomain_enable/1
trustdomain_find/1
trustdomain_mod/1
user/1
user_add/1
user_add_cert/1
user_add_certmapdata/1
user_add_manager/1
user_add_principal/1
user_del/1
user_disable/1
user_enable/1
user_find/1
user_mod/1
user_remove_cert/1
user_remove_certmapdata/1
user_remove_manager/1
user_remove_principal/1
user_show/1
user_stage/1
user_status/1
user_undel/1
user_unlock/1
userstatus/1
vault/1
vault_add_internal/1
vault_add_member/1
vault_add_owner/1
vault_archive_internal/1
vault_del/1
vault_find/1
vault_mod_internal/1
vault_remove_member/1
vault_remove_owner/1
vault_retrieve_internal/1
vault_show/1
vaultconfig/1
vaultconfig_show/1
vaultcontainer/1
vaultcontainer_add_owner/1
vaultcontainer_del/1
vaultcontainer_remove_owner/1
vaultcontainer_show/1
whoami/1
""".strip().splitlines())
