/* iconwidget.c generated by valac 0.20.1, the Vala compiler
 * generated from iconwidget.vala, do not modify */

/* vim:set et sts=4 sw=4:
 *
 * ibus - The Input Bus
 *
 * Copyright(c) 2011 Peng Huang <shawn.p.huang@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307  USA
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>


#define TYPE_ICON_WIDGET (icon_widget_get_type ())
#define ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_WIDGET, IconWidget))
#define ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_WIDGET, IconWidgetClass))
#define IS_ICON_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_WIDGET))
#define IS_ICON_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_WIDGET))
#define ICON_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_WIDGET, IconWidgetClass))

typedef struct _IconWidget IconWidget;
typedef struct _IconWidgetClass IconWidgetClass;
typedef struct _IconWidgetPrivate IconWidgetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _IconWidget {
	GtkImage parent_instance;
	IconWidgetPrivate * priv;
};

struct _IconWidgetClass {
	GtkImageClass parent_class;
};


static gpointer icon_widget_parent_class = NULL;

GType icon_widget_get_type (void) G_GNUC_CONST;
enum  {
	ICON_WIDGET_DUMMY_PROPERTY
};
IconWidget* icon_widget_new (const gchar* icon_name_or_path, GtkIconSize size);
IconWidget* icon_widget_construct (GType object_type, const gchar* icon_name_or_path, GtkIconSize size);


/**
     * IconWidget:
     * @icon_name_or_path: Can be a name or path but not stock id
     *     because gtk_icon_theme_load_icon() cannot fallback the
     *     stock id to a real file name against
     *     gtk_image_new_from_stock().
     * @size: #Gtk.IconSize
     */
static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


IconWidget* icon_widget_construct (GType object_type, const gchar* icon_name_or_path, GtkIconSize size) {
	IconWidget * self = NULL;
	GdkPixbuf* pixbuf;
	gint fixed_width = 0;
	gint fixed_height = 0;
	GtkIconSize _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GdkPixbuf* _tmp22_;
	GdkPixbuf* _tmp23_;
	gint _tmp24_ = 0;
	gfloat width;
	GdkPixbuf* _tmp25_;
	gint _tmp26_ = 0;
	gfloat height;
	gfloat _tmp27_ = 0.0F;
	gfloat _tmp28_;
	gfloat _tmp29_;
	gint _tmp32_;
	gfloat _tmp33_;
	gfloat scale;
	gfloat _tmp34_;
	gfloat _tmp35_;
	gfloat _tmp36_;
	gfloat _tmp37_;
	GdkPixbuf* _tmp38_;
	gfloat _tmp39_;
	gfloat _tmp40_;
	GdkPixbuf* _tmp41_ = NULL;
	GdkPixbuf* _tmp42_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (icon_name_or_path != NULL, NULL);
	self = (IconWidget*) g_object_new (object_type, NULL);
	pixbuf = NULL;
	_tmp0_ = size;
	gtk_icon_size_lookup (_tmp0_, &_tmp1_, &_tmp2_);
	fixed_width = _tmp1_;
	fixed_height = _tmp2_;
	{
		const gchar* _tmp3_;
		gchar _tmp4_ = '\0';
		_tmp3_ = icon_name_or_path;
		_tmp4_ = string_get (_tmp3_, (glong) 0);
		if (_tmp4_ == '/') {
			const gchar* _tmp5_;
			GdkPixbuf* _tmp6_;
			GdkPixbuf* _tmp7_;
			_tmp5_ = icon_name_or_path;
			_tmp6_ = gdk_pixbuf_new_from_file (_tmp5_, &_inner_error_);
			_tmp7_ = _tmp6_;
			if (_inner_error_ != NULL) {
				goto __catch0_g_error;
			}
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp7_;
		} else {
			GtkIconTheme* _tmp8_ = NULL;
			GtkIconTheme* _tmp9_;
			GtkIconTheme* theme;
			GtkIconTheme* _tmp10_;
			const gchar* _tmp11_;
			gint _tmp12_;
			GdkPixbuf* _tmp13_ = NULL;
			GdkPixbuf* _tmp14_;
			_tmp8_ = gtk_icon_theme_get_default ();
			_tmp9_ = _g_object_ref0 (_tmp8_);
			theme = _tmp9_;
			_tmp10_ = theme;
			_tmp11_ = icon_name_or_path;
			_tmp12_ = fixed_width;
			_tmp13_ = gtk_icon_theme_load_icon (_tmp10_, _tmp11_, _tmp12_, 0, &_inner_error_);
			_tmp14_ = _tmp13_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (theme);
				goto __catch0_g_error;
			}
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp14_;
			_g_object_unref0 (theme);
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			GtkIconTheme* _tmp15_ = NULL;
			GtkIconTheme* _tmp16_;
			GtkIconTheme* theme;
			GtkIconTheme* _tmp17_;
			gint _tmp18_;
			GdkPixbuf* _tmp19_ = NULL;
			GdkPixbuf* _tmp20_;
			_tmp15_ = gtk_icon_theme_get_default ();
			_tmp16_ = _g_object_ref0 (_tmp15_);
			theme = _tmp16_;
			_tmp17_ = theme;
			_tmp18_ = fixed_width;
			_tmp19_ = gtk_icon_theme_load_icon (_tmp17_, "ibus-engine", _tmp18_, 0, &_inner_error_);
			_tmp20_ = _tmp19_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (theme);
				goto __catch1_g_error;
			}
			_g_object_unref0 (pixbuf);
			pixbuf = _tmp20_;
			_g_object_unref0 (theme);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GtkIconSize _tmp21_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp21_ = size;
			gtk_image_set_from_stock ((GtkImage*) self, GTK_STOCK_MISSING_IMAGE, _tmp21_);
			_g_error_free0 (e);
			_g_error_free0 (e);
			_g_object_unref0 (pixbuf);
			return self;
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_error_free0 (e);
			_g_error_free0 (e);
			_g_object_unref0 (pixbuf);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (pixbuf);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp22_ = pixbuf;
	if (_tmp22_ == NULL) {
		_g_object_unref0 (pixbuf);
		return self;
	}
	_tmp23_ = pixbuf;
	_tmp24_ = gdk_pixbuf_get_width (_tmp23_);
	width = (gfloat) _tmp24_;
	_tmp25_ = pixbuf;
	_tmp26_ = gdk_pixbuf_get_height (_tmp25_);
	height = (gfloat) _tmp26_;
	_tmp28_ = width;
	_tmp29_ = height;
	if (_tmp28_ > _tmp29_) {
		gfloat _tmp30_;
		_tmp30_ = width;
		_tmp27_ = _tmp30_;
	} else {
		gfloat _tmp31_;
		_tmp31_ = height;
		_tmp27_ = _tmp31_;
	}
	_tmp32_ = fixed_width;
	_tmp33_ = _tmp27_;
	scale = _tmp32_ / _tmp33_;
	_tmp34_ = width;
	_tmp35_ = scale;
	width = _tmp34_ * _tmp35_;
	_tmp36_ = height;
	_tmp37_ = scale;
	height = _tmp36_ * _tmp37_;
	_tmp38_ = pixbuf;
	_tmp39_ = width;
	_tmp40_ = height;
	_tmp41_ = gdk_pixbuf_scale_simple (_tmp38_, (gint) _tmp39_, (gint) _tmp40_, GDK_INTERP_BILINEAR);
	_g_object_unref0 (pixbuf);
	pixbuf = _tmp41_;
	_tmp42_ = pixbuf;
	gtk_image_set_from_pixbuf ((GtkImage*) self, _tmp42_);
	gtk_widget_show ((GtkWidget*) self);
	_g_object_unref0 (pixbuf);
	return self;
}


IconWidget* icon_widget_new (const gchar* icon_name_or_path, GtkIconSize size) {
	return icon_widget_construct (TYPE_ICON_WIDGET, icon_name_or_path, size);
}


static void icon_widget_class_init (IconWidgetClass * klass) {
	icon_widget_parent_class = g_type_class_peek_parent (klass);
}


static void icon_widget_instance_init (IconWidget * self) {
}


GType icon_widget_get_type (void) {
	static volatile gsize icon_widget_type_id__volatile = 0;
	if (g_once_init_enter (&icon_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (IconWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) icon_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IconWidget), 0, (GInstanceInitFunc) icon_widget_instance_init, NULL };
		GType icon_widget_type_id;
		icon_widget_type_id = g_type_register_static (GTK_TYPE_IMAGE, "IconWidget", &g_define_type_info, 0);
		g_once_init_leave (&icon_widget_type_id__volatile, icon_widget_type_id);
	}
	return icon_widget_type_id__volatile;
}



