#!/bin/bash

# --------------------------------------------
# Check whether we can use gtk's utilities

if [ -x /usr/X11R6/bin/xtest ] \
  && [ xtest ] \
  && [ -x /usr/X11R6/bin/gmessage ] \
  && [ -x /usr/X11R6/bin/gchooser ] 
then
  XWIN=Y
else
  XWIN=N
fi
#XWIN=N


# --------------------------------------------
# Display a message box. The message should be
# in stdin
# --------------------------------------------
message() {
  if [ $XWIN = Y ] ; then
    gmessage -center -file /dev/stdin
  else
    cat /dev/stdin
  fi
}


# --------------------------------------------
# Display a list of choices. $1 is the prompt.
# The other parameters are the individual
# choices.
# --------------------------------------------
choose() {
  PROMPT=$1
  shift

  if [ $XWIN = Y ] ; then
    gchooser "$PROMPT" "$@"
    export CHOICE=$?
  else
    C=0
    for A in $* ; do
      let C++
      echo $C - $A
    done
    read -n 1 -p "$PROMPT"
    export CHOICE=$REPLY
    echo ""
  fi
}

lprint() {
  if [ $LINGWA == M ] ; then 
    echo $1
  else
    echo $2
  fi
}

# ------------------------------------------
# Check that this script is executed as root
# ------------------------------------------
if [ "`whoami`" != "root" ]; then
	message <<EOM

Dan il-programm irid jithaddem bhala "root". Uza l-kmand "su"
biex taqleb ghall-user "root" u erga' pprova.

This script must be run as "root". Use the "su" command to switch to
the root user, then try again.

EOM
	exit
fi


choose "Aghzel Lingwa - Select language:" "Struzzjonijiet bil-Malti" "Instructions in English"
case $CHOICE in
  0) exit 0 ;;
  1) LINGWA=M ;;
  2) LINGWA=E ;;
esac

if [ $LINGWA == M ] ; then message <<EOM

"Spell Checker" bil-Malti

    awtur:    Ramon Casha <ramon.casha@linux.org.mt>
    verzjoni: 0.2
    kliem:    madwar 530,000
    website:  http://linux.org.mt/projects/spellcheck

----------------------------------------------------------

Dan il-programm jinstalla dizzjunaru ta' kliem Malti ghal diversi "spell
checkers" fil-Linux. Dan huwa ppubblikat taht il-licenzja LGPL.

Dan id-dizzjunarju jista' jkun fih zbalji, u l-awtur ma jaghti ebda
garanzija dwar il-kwalità tal-konetut.

EOM
fi
if [ $LINGWA == E ] ; then message <<EOM

Maltese Spell Checker

    author:   Ramon Casha <ramon.casha@linux.org.mt>
    version:  0.2
    words:    around 530,000
    website:  http://linux.org.mt/projects/spellcheck

----------------------------------------------------------

This program will install a dictionary of Maltese words for
various spell checkers under Linux. These are published under
the LGPL license.

This dictionary may contain errors, and the author makes no
warranty regarding the quality of the content.

EOM
fi

if [ "$LINGWA" == "M" ] ; then PRMPT="Aghzel: " ;fi
if [ "$LINGWA" == "E" ] ; then PRMPT="Choose: " ;fi

choose "$PRMPT" aspell ispell "aspell+ispell"
if [ $CHOICE == 1 ] ; then INST_A=Y ; fi
if [ $CHOICE == 2 ] ; then INST_I=Y ; fi
if [ $CHOICE == 3 ] ; then INST_A=Y ; INST_I=Y ; fi


if [ "$INST_A" == "Y" ] ; then
  if [ ! -d /usr/share/aspell ] ; then
    lprint	"PROBLEMA: aspell jidher li mhux installat." \
    		"ERROR: aspell does not seem to be installed."
  else
    cp malti_phonet.dat /usr/share/aspell/
    cp malti.dat /usr/share/aspell/
    lprint	"Qed nikkompila d-dizzjunarju ta' ASPELL... stenna ftit..." \
    		"Compiling word list for ASPELL... please wait..."
    aspell --lang=malti create master malti < words.iso8859-3
  fi

fi

if [ "$INST_I" == "Y" ] ; then
  if [ ! -d /usr/lib/ispell ] ; then
    lprint	"PROBLEMA: ispell jidher li mhux installat." \
    		"ERROR: ispell does not seem to be installed."
  else
    cp malti.aff /usr/lib/ispell/
    lprint	"Qed nikkompila d-dizzjunarju ta' ISPELL... stenna ftit..." \
    		"Compiling word list for ISPELL... please wait..."
    buildhash words.iso8859-3 /usr/lib/ispell/malti.aff /usr/lib/ispell/malti.hash
  fi

fi

if [ $LINGWA == E ] ; then message <<EOM

READY!

You can now use the spell checker in your application. Remember to select
the ISO8859-3 character set when you configure the spell-checker in your
applications.
  
EOM
fi

if [ $LINGWA == M ] ; then message <<EOM

LEST!

Issa tista' tuza l-ispell checker fil-programmi. Biex tuzah trid taghzel
is-sett ta' karattri ISO8859-3 meta tissettja l-ispell checker fil-
programmi.
  
EOM
fi
