/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class IterablesTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testAddAllToList() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testAddAllToList();
}

public void testAll() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testAll();
}

public void testAny() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testAny();
}

public void testConcatIterable() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testConcatIterable();
}

public void testConcatNullPointerException() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testConcatNullPointerException();
}

public void testConcatPeformingFiniteCycle() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testConcatPeformingFiniteCycle();
}

public void testConcatVarargs() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testConcatVarargs();
}

public void testConsumingIterable() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testConsumingIterable();
}

public void testConsumingIterable_noIteratorCall() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testConsumingIterable_noIteratorCall();
}

public void testConsumingIterable_queue_iterator() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testConsumingIterable_queue_iterator();
}

public void testConsumingIterable_queue_removesFromQueue() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testConsumingIterable_queue_removesFromQueue();
}

public void testCycle() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testCycle();
}

public void testElementsEqual() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testElementsEqual();
}

public void testFind() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testFind();
}

public void testFind_withDefault() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testFind_withDefault();
}

public void testFrequency_list() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testFrequency_list();
}

public void testFrequency_multiset() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testFrequency_multiset();
}

public void testFrequency_set() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testFrequency_set();
}

public void testGetFirst_withDefault_empty() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetFirst_withDefault_empty();
}

public void testGetFirst_withDefault_empty_null() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetFirst_withDefault_empty_null();
}

public void testGetFirst_withDefault_multiple() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetFirst_withDefault_multiple();
}

public void testGetFirst_withDefault_singleton() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetFirst_withDefault_singleton();
}

public void testGetLast_emptyIterable() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetLast_emptyIterable();
}

public void testGetLast_emptyList() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetLast_emptyList();
}

public void testGetLast_emptySortedSet() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetLast_emptySortedSet();
}

public void testGetLast_iterable() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetLast_iterable();
}

public void testGetLast_list() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetLast_list();
}

public void testGetLast_sortedSet() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetLast_sortedSet();
}

public void testGetLast_withDefault_empty() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetLast_withDefault_empty();
}

public void testGetLast_withDefault_empty_null() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetLast_withDefault_empty_null();
}

public void testGetLast_withDefault_multiple() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetLast_withDefault_multiple();
}

public void testGetLast_withDefault_not_empty_list() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetLast_withDefault_not_empty_list();
}

public void testGetLast_withDefault_singleton() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetLast_withDefault_singleton();
}

public void testGetOnlyElement_noDefault_empty() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetOnlyElement_noDefault_empty();
}

public void testGetOnlyElement_noDefault_multiple() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetOnlyElement_noDefault_multiple();
}

public void testGetOnlyElement_noDefault_valid() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetOnlyElement_noDefault_valid();
}

public void testGetOnlyElement_withDefault_empty() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetOnlyElement_withDefault_empty();
}

public void testGetOnlyElement_withDefault_empty_null() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetOnlyElement_withDefault_empty_null();
}

public void testGetOnlyElement_withDefault_multiple() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetOnlyElement_withDefault_multiple();
}

public void testGetOnlyElement_withDefault_singleton() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGetOnlyElement_withDefault_singleton();
}

public void testGet_emptyIterable() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGet_emptyIterable();
}

public void testGet_emptyList() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGet_emptyList();
}

public void testGet_emptySortedSet() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGet_emptySortedSet();
}

public void testGet_iterable() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGet_iterable();
}

public void testGet_list() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGet_list();
}

public void testGet_sortedSet() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGet_sortedSet();
}

public void testGet_withDefault_doesntIterate() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGet_withDefault_doesntIterate();
}

public void testGet_withDefault_iterable() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGet_withDefault_iterable();
}

public void testGet_withDefault_last() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGet_withDefault_last();
}

public void testGet_withDefault_lastPlusOne() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGet_withDefault_lastPlusOne();
}

public void testGet_withDefault_negativePosition() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGet_withDefault_negativePosition();
}

public void testGet_withDefault_simple() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testGet_withDefault_simple();
}

public void testIndexOf_empty() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testIndexOf_empty();
}

public void testIndexOf_genericPredicate() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testIndexOf_genericPredicate();
}

public void testIndexOf_genericPredicate2() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testIndexOf_genericPredicate2();
}

public void testIndexOf_oneElement() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testIndexOf_oneElement();
}

public void testIndexOf_twoElements() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testIndexOf_twoElements();
}

public void testIndexOf_withDuplicates() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testIndexOf_withDuplicates();
}

public void testIsEmpty() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testIsEmpty();
}

public void testIterableWithToString() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testIterableWithToString();
}

public void testIterableWithToStringNull() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testIterableWithToStringNull();
}

public void testLimit() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testLimit();
}

public void testLimit_illegalArgument() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testLimit_illegalArgument();
}

public void testMergeSorted_empty() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testMergeSorted_empty();
}

public void testMergeSorted_pyramid() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testMergeSorted_pyramid();
}

public void testMergeSorted_single() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testMergeSorted_single();
}

public void testMergeSorted_single_empty() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testMergeSorted_single_empty();
}

public void testMergeSorted_skipping_pyramid() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testMergeSorted_skipping_pyramid();
}

public void testNullFriendlyTransform() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testNullFriendlyTransform();
}

public void testPaddedPartitionNonRandomAccessInput() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testPaddedPartitionNonRandomAccessInput();
}

public void testPaddedPartitionRandomAccessInput() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testPaddedPartitionRandomAccessInput();
}

public void testPaddedPartition_basic() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testPaddedPartition_basic();
}

public void testPartition_badSize() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testPartition_badSize();
}

public void testPartition_empty() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testPartition_empty();
}

public void testPartition_singleton1() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testPartition_singleton1();
}

public void testPartition_view() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testPartition_view();
}

public void testPoorlyBehavedTransform() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testPoorlyBehavedTransform();
}

public void testRemoveAll_collection() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testRemoveAll_collection();
}

public void testRemoveAll_iterable() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testRemoveAll_iterable();
}

public void testRemoveIf_iterable() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testRemoveIf_iterable();
}

public void testRemoveIf_noRandomAccess() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testRemoveIf_noRandomAccess();
}

public void testRemoveIf_randomAccess() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testRemoveIf_randomAccess();
}

public void testRemoveIf_randomAccess_notPermittingDuplicates() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testRemoveIf_randomAccess_notPermittingDuplicates();
}

public void testRemoveIf_transformedList() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testRemoveIf_transformedList();
}

public void testRetainAll_collection() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testRetainAll_collection();
}

public void testRetainAll_iterable() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testRetainAll_iterable();
}

public void testSize0() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testSize0();
}

public void testSize1Collection() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testSize1Collection();
}

public void testSize2NonCollection() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testSize2NonCollection();
}

public void testSize_collection_doesntIterate() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testSize_collection_doesntIterate();
}

public void testSkip_allOfImmutableList_modifiable() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testSkip_allOfImmutableList_modifiable();
}

public void testSkip_allOfMutableList_modifiable() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testSkip_allOfMutableList_modifiable();
}

public void testSkip_illegalArgument() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testSkip_illegalArgument();
}

public void testSkip_nonStructurallyModifiedList() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testSkip_nonStructurallyModifiedList();
}

public void testSkip_pastEnd() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testSkip_pastEnd();
}

public void testSkip_pastEndList() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testSkip_pastEndList();
}

public void testSkip_removal() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testSkip_removal();
}

public void testSkip_simple() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testSkip_simple();
}

public void testSkip_simpleList() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testSkip_simpleList();
}

public void testSkip_skipNone() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testSkip_skipNone();
}

public void testSkip_skipNoneList() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testSkip_skipNoneList();
}

public void testSkip_structurallyModifiedSkipAll() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testSkip_structurallyModifiedSkipAll();
}

public void testSkip_structurallyModifiedSkipAllList() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testSkip_structurallyModifiedSkipAllList();
}

public void testSkip_structurallyModifiedSkipSome() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testSkip_structurallyModifiedSkipSome();
}

public void testSkip_structurallyModifiedSkipSomeList() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testSkip_structurallyModifiedSkipSomeList();
}

public void testToString() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testToString();
}

public void testTransform() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testTransform();
}

public void testTryFind() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testTryFind();
}

public void testUnmodifiableIterable() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testUnmodifiableIterable();
}

public void testUnmodifiableIterableShortCircuit() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.testUnmodifiableIterableShortCircuit();
}

public void test_contains_nonnull_iterable_no() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.test_contains_nonnull_iterable_no();
}

public void test_contains_nonnull_iterable_yes() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.test_contains_nonnull_iterable_yes();
}

public void test_contains_nonnull_set_no() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.test_contains_nonnull_set_no();
}

public void test_contains_nonnull_set_yes() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.test_contains_nonnull_set_yes();
}

public void test_contains_null_iterable_no() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.test_contains_null_iterable_no();
}

public void test_contains_null_iterable_yes() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.test_contains_null_iterable_yes();
}

public void test_contains_null_set_no() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.test_contains_null_set_no();
}

public void test_contains_null_set_yes() throws Exception {
  com.google.common.collect.IterablesTest testCase = new com.google.common.collect.IterablesTest();
  testCase.test_contains_null_set_yes();
}
}
