/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class GeneralRangeTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testCreateEmptyRangeClosedOpenSucceeds() throws Exception {
  com.google.common.collect.GeneralRangeTest testCase = new com.google.common.collect.GeneralRangeTest();
  testCase.testCreateEmptyRangeClosedOpenSucceeds();
}

public void testCreateEmptyRangeFails() throws Exception {
  com.google.common.collect.GeneralRangeTest testCase = new com.google.common.collect.GeneralRangeTest();
  testCase.testCreateEmptyRangeFails();
}

public void testCreateEmptyRangeOpenClosedSucceeds() throws Exception {
  com.google.common.collect.GeneralRangeTest testCase = new com.google.common.collect.GeneralRangeTest();
  testCase.testCreateEmptyRangeOpenClosedSucceeds();
}

public void testCreateEmptyRangeOpenOpenFails() throws Exception {
  com.google.common.collect.GeneralRangeTest testCase = new com.google.common.collect.GeneralRangeTest();
  testCase.testCreateEmptyRangeOpenOpenFails();
}

public void testCreateSingletonRangeSucceeds() throws Exception {
  com.google.common.collect.GeneralRangeTest testCase = new com.google.common.collect.GeneralRangeTest();
  testCase.testCreateSingletonRangeSucceeds();
}

public void testDoublyBoundedAgainstRange() throws Exception {
  com.google.common.collect.GeneralRangeTest testCase = new com.google.common.collect.GeneralRangeTest();
  testCase.testDoublyBoundedAgainstRange();
}

public void testFromRangeAll() throws Exception {
  com.google.common.collect.GeneralRangeTest testCase = new com.google.common.collect.GeneralRangeTest();
  testCase.testFromRangeAll();
}

public void testFromRangeOneEnd() throws Exception {
  com.google.common.collect.GeneralRangeTest testCase = new com.google.common.collect.GeneralRangeTest();
  testCase.testFromRangeOneEnd();
}

public void testFromRangeTwoEnds() throws Exception {
  com.google.common.collect.GeneralRangeTest testCase = new com.google.common.collect.GeneralRangeTest();
  testCase.testFromRangeTwoEnds();
}

public void testIntersectAgainstBiggerRange() throws Exception {
  com.google.common.collect.GeneralRangeTest testCase = new com.google.common.collect.GeneralRangeTest();
  testCase.testIntersectAgainstBiggerRange();
}

public void testIntersectAgainstMatchingEndpointsRange() throws Exception {
  com.google.common.collect.GeneralRangeTest testCase = new com.google.common.collect.GeneralRangeTest();
  testCase.testIntersectAgainstMatchingEndpointsRange();
}

public void testIntersectAgainstSmallerRange() throws Exception {
  com.google.common.collect.GeneralRangeTest testCase = new com.google.common.collect.GeneralRangeTest();
  testCase.testIntersectAgainstSmallerRange();
}

public void testIntersectNonOverlappingRange() throws Exception {
  com.google.common.collect.GeneralRangeTest testCase = new com.google.common.collect.GeneralRangeTest();
  testCase.testIntersectNonOverlappingRange();
}

public void testIntersectOverlappingRange() throws Exception {
  com.google.common.collect.GeneralRangeTest testCase = new com.google.common.collect.GeneralRangeTest();
  testCase.testIntersectOverlappingRange();
}

public void testLowerRange() throws Exception {
  com.google.common.collect.GeneralRangeTest testCase = new com.google.common.collect.GeneralRangeTest();
  testCase.testLowerRange();
}

public void testReverse() throws Exception {
  com.google.common.collect.GeneralRangeTest testCase = new com.google.common.collect.GeneralRangeTest();
  testCase.testReverse();
}

public void testSingletonRange() throws Exception {
  com.google.common.collect.GeneralRangeTest testCase = new com.google.common.collect.GeneralRangeTest();
  testCase.testSingletonRange();
}

public void testUpperRange() throws Exception {
  com.google.common.collect.GeneralRangeTest testCase = new com.google.common.collect.GeneralRangeTest();
  testCase.testUpperRange();
}
}
