import { action } from '@storybook/addon-actions';
import { Story } from '@storybook/react';
import React from 'react';

import { Alert, AlertVariant, VerticalGroup } from '@grafana/ui';

import { StoryExample } from '../../utils/storybook/StoryExample';
import { withCenteredStory, withHorizontallyCenteredStory } from '../../utils/storybook/withCenteredStory';
import mdx from '../Alert/Alert.mdx';

import { Props } from './Alert';

const severities: AlertVariant[] = ['error', 'warning', 'info', 'success'];

export default {
  title: 'Overlays/Alert',
  component: Alert,
  decorators: [withCenteredStory, withHorizontallyCenteredStory],
  parameters: {
    docs: {
      page: mdx,
    },
    knobs: {
      disable: true,
    },
    controls: {
      exclude: ['onRemove'],
    },
  },
  argTypes: {
    severity: { control: { type: 'select', options: severities } },
  },
};

export const Examples: Story<Props> = ({ severity, title, buttonContent }) => {
  return (
    <VerticalGroup>
      <StoryExample name="With buttonContent and children">
        <Alert
          title={title}
          severity={severity}
          buttonContent={<span>{buttonContent}</span>}
          onRemove={action('Remove button clicked')}
        >
          <VerticalGroup>
            <div>Child content that includes some alert details, like maybe what actually happened.</div>
          </VerticalGroup>
        </Alert>
      </StoryExample>
      <StoryExample name="No dismiss">
        <Alert title={title} severity={severity} />
      </StoryExample>
      <StoryExample name="Elevated alert used for absolute positioned alerts">
        <Alert title={title} severity={severity} elevated />
      </StoryExample>
      <StoryExample name="Severities">
        <VerticalGroup>
          {severities.map((severity) => (
            <Alert
              title={`Severity: ${severity}`}
              severity={severity}
              key={severity}
              onRemove={action('Remove button clicked')}
            />
          ))}
        </VerticalGroup>
      </StoryExample>
      <StoryExample name="With huge payload">
        <Alert title={title} severity={severity}>
          Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam metus urna, aliquam eu scelerisque non,
          facilisis eget est. Morbi eleifend egestas massa id vulputate. Fusce dignissim magna lacus, ut molestie odio
          feugiat sed. Cras fringilla justo sit amet turpis scelerisque, a volutpat purus iaculis. Nunc sagittis
          molestie faucibus. Curabitur at neque luctus, pellentesque urna eget, posuere urna. Nunc malesuada elit in
          ipsum dictum egestas. Praesent convallis mauris massa, porta mattis ex gravida ut. Proin consectetur ultrices
          tortor sit amet efficitur. Suspendisse nec turpis dapibus mauris venenatis maximus quis eget orci. Ut semper
          enim magna, ullamcorper elementum sapien pharetra vitae. Vivamus at nulla ut metus bibendum ornare et ut leo.
          Proin ante turpis, ornare a malesuada et, rutrum nec lorem. Maecenas vestibulum orci vel nibh convallis
          eleifend. Quisque vitae consectetur massa, vitae elementum mauris. Pellentesque sit amet ligula lorem. Fusce
          sit amet lorem non augue rutrum varius. Donec sed imperdiet libero, eget venenatis elit. Fusce porttitor
          dapibus urna. Duis fringilla ante vel tempor tincidunt. In euismod vestibulum odio sit amet iaculis. Donec vel
          dapibus libero. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi lacinia commodo lectus. Aenean
          in magna eget lectus luctus suscipit et vitae erat. Pellentesque quis ligula id lorem egestas sollicitudin sit
          amet sed sem. Nullam et nibh a odio rhoncus efficitur sed nec est. Sed commodo lacus vitae sem congue,
          accumsan dignissim metus iaculis. Praesent in dignissim nisl. Aliquam facilisis, sapien eget porttitor
          ultrices, massa libero bibendum odio, at ornare diam arcu ac massa. Vestibulum egestas leo eget lorem congue
          condimentum. Praesent egestas, neque id gravida vehicula, augue ex scelerisque lectus, finibus pellentesque
          enim dolor vel ante. Cras convallis, sem at malesuada tincidunt, diam urna auctor leo, sed laoreet est ex in
          libero. Ut condimentum ante eget ex gravida, id tempus metus ultricies. Pellentesque placerat, massa id
          laoreet molestie, justo nisl varius metus, maximus vehicula erat libero vitae nulla. Mauris rhoncus ligula
          vitae volutpat auctor. Suspendisse potenti. Quisque quis orci faucibus, ullamcorper dolor eget, mollis massa.
          Etiam eu molestie ipsum. Sed laoreet diam metus, luctus maximus erat viverra quis. Ut eu felis dictum,
          tincidunt erat sit amet, scelerisque neque. Orci varius natoque penatibus et magnis dis parturient montes,
          nascetur ridiculus mus. Phasellus sit amet est tristique, fermentum massa ut, viverra metus. Interdum et
          malesuada fames ac ante ipsum primis in faucibus. Nunc iaculis nunc elit, ut feugiat ipsum egestas eget.
          Vestibulum pulvinar ligula mi, quis lacinia diam suscipit eget. Etiam consectetur vel nunc at hendrerit.
          Pellentesque blandit eleifend aliquam. Etiam et malesuada purus, et bibendum sapien. Phasellus tincidunt
          consequat eros consequat sodales. Vestibulum quis viverra neque. Integer sit amet lacinia nunc. Ut cursus,
          elit id faucibus elementum, elit nunc dapibus tellus, non ornare nisi sapien et eros. Nunc sit amet suscipit
          arcu. Nulla ut nunc tempor, auctor massa sed, consectetur orci. Pellentesque erat ante, placerat eget dictum
          elementum, dapibus et ipsum. Nunc sit amet nulla gravida, finibus felis vel, tempus sem. In urna purus,
          accumsan quis aliquam et, condimentum ac urna. Nullam volutpat ullamcorper sapien, quis ultricies purus
          dignissim aliquam. Mauris quis enim ante. Etiam vulputate faucibus placerat. Ut pellentesque, purus vitae
          euismod cursus, lacus enim vulputate sapien, in porttitor erat dui eu lectus. Duis eleifend, massa vel
          vehicula gravida, magna urna rutrum ligula, vitae mollis ipsum neque id enim. Donec varius tristique nisi, et
          vestibulum dolor efficitur eget. Cras mauris leo, bibendum eget pretium a, tincidunt faucibus massa.
          Vestibulum hendrerit arcu magna, vel consequat est euismod nec. Vestibulum non lacus porttitor, congue tortor
          ut, venenatis elit. Duis at lectus arcu. Nunc quis sapien eu ipsum rutrum accumsan. Orci varius natoque
          penatibus et magnis dis parturient montes, nascetur ridiculus mus. Vivamus quis sapien luctus, volutpat nulla
          eget, gravida nunc. Aenean placerat a felis quis imperdiet. Sed sapien tellus, ultrices non ipsum eget,
          pretium rhoncus quam. Aliquam erat volutpat. Maecenas at interdum turpis, eu mattis ligula. Class aptent
          taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. In lobortis felis a leo
          ultricies, venenatis mollis felis lobortis. Suspendisse placerat vel ante vel euismod. Aenean sit amet
          ullamcorper mauris, id consectetur est. Ut ultricies enim non quam condimentum, et congue arcu commodo.
          Praesent convallis eleifend turpis, vitae feugiat turpis imperdiet sit amet. Class aptent taciti sociosqu ad
          litora torquent per conubia nostra, per inceptos himenaeos. Quisque vulputate porttitor mattis. Pellentesque
          sed ullamcorper lectus. Suspendisse velit tortor, viverra eget facilisis condimentum, accumsan sit amet felis.
          Cras lobortis mi fermentum ligula consectetur, vitae tincidunt mauris scelerisque. Aenean ac condimentum erat,
          quis lacinia lacus. Ut magna nibh, tempor et ligula suscipit, placerat laoreet ipsum. In semper semper nisl.
          Donec risus lorem, tempor sed sollicitudin vitae, fringilla et mi. Vivamus pulvinar quam nisl, et tincidunt
          justo tempus quis. Duis semper magna nunc, vitae faucibus lectus facilisis sed. Phasellus consequat arcu vel
          interdum fermentum. In condimentum euismod neque, sed aliquet mauris posuere nec. Etiam metus eros,
          pellentesque eget scelerisque id, porttitor at ligula. Curabitur eget nibh maximus enim lobortis sodales.
          Etiam vulputate ligula lobortis vestibulum pulvinar. Curabitur eros justo, accumsan sed elit ac, mattis
          lacinia nisi. Suspendisse ullamcorper lectus sit amet tellus condimentum porttitor. Duis cursus, neque et
          aliquam congue, odio lectus porta elit, id lacinia dolor justo non leo. Aliquam vehicula at tellus ullamcorper
          tincidunt. Phasellus neque nibh, convallis sit amet arcu sit amet, convallis egestas tortor. Etiam sit amet
          vehicula quam. Praesent id consequat lacus, ac facilisis quam. Integer tristique lorem eros, id consequat
          lorem lobortis vitae. Aliquam luctus purus eget sem molestie iaculis. Duis nisl risus, sodales sit amet nunc
          vitae, volutpat cursus augue. Pellentesque congue massa eu metus pellentesque consectetur at vel neque. Donec
          bibendum hendrerit erat, vitae dictum enim lobortis a. Quisque ac dapibus tellus, sit amet facilisis orci.
          Cras pretium tortor non condimentum semper. Phasellus mollis condimentum blandit. Pellentesque at arcu risus.
          Vivamus sit amet dui semper, suscipit est nec, elementum arcu. Praesent ante turpis, convallis ac leo eget,
          rutrum bibendum ante. Sed venenatis vehicula lobortis. Phasellus consectetur velit nec congue venenatis.
          Interdum et malesuada fames ac ante ipsum primis in faucibus. Nullam sagittis, arcu quis sagittis vestibulum,
          odio lorem tempus massa, non condimentum enim turpis ut orci. Vivamus sit amet dignissim eros. Vestibulum ante
          ipsum primis in faucibus orci luctus et ultrices posuere cubilia curae; Phasellus efficitur est eu semper
          luctus. Nunc gravida tristique urna, et mollis leo porttitor suscipit. In hac habitasse platea dictumst. Etiam
          tempus varius mattis. Suspendisse potenti. Duis finibus ornare tortor, a auctor lacus dictum id. Suspendisse
          eget auctor lorem, sollicitudin placerat ipsum. Aliquam suscipit ante at gravida tincidunt. Donec vel turpis
          dui. Ut facilisis, dui id fermentum ultrices, nunc mi pretium ex, eu lobortis sem tellus porttitor nulla. Nam
          sit amet mauris justo. Maecenas libero est, dignissim vel dolor ac, rutrum accumsan tellus. Nulla in lacinia
          orci, facilisis feugiat mi. Nunc sit amet ultricies dolor. Sed ac interdum lacus. Quisque facilisis viverra
          orci vel tincidunt. Suspendisse feugiat ligula non justo molestie viverra. Cras sed ultricies quam. Duis
          aliquam ante lacus, non posuere neque pretium id. Fusce at orci facilisis, pretium justo eu, vestibulum sem.
          Orci varius natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Duis at lorem ultrices,
          tincidunt nulla ac, molestie ligula. Phasellus erat nunc, consectetur ut velit vel, porta fringilla ante.
          Vestibulum laoreet lorem erat, ultricies porta ex venenatis vel. Donec vestibulum enim id suscipit
          pellentesque. Donec vitae dictum arcu. In ac tellus dignissim, imperdiet tellus quis, malesuada nisl. Aliquam
          finibus urna commodo purus ultricies, non vulputate risus ullamcorper. Cras semper ultrices posuere. Etiam
          massa nisi, vehicula sit amet volutpat sit amet, commodo vel mi. Maecenas commodo consectetur ipsum nec
          ultrices. Sed hendrerit quam nulla, ut tincidunt tortor commodo eget. Vestibulum euismod condimentum
          porttitor. Mauris egestas posuere justo ac suscipit. Nulla auctor tellus nec eros rhoncus, a congue odio
          accumsan. Phasellus tempus risus ut orci commodo, sed lobortis ex porta. Nullam ligula erat, pretium ut nibh
          volutpat, tincidunt pellentesque purus. Vivamus cursus eget nisi id ornare. Phasellus ut aliquet turpis.
          Vestibulum ornare ex eros, quis accumsan neque porta id. Pellentesque eleifend, tortor eget dignissim
          convallis, nisl felis fringilla dolor, dapibus bibendum mauris lacus dignissim metus. Cras cursus faucibus
          condimentum. Curabitur non libero risus. Morbi nisi augue, aliquam quis neque sit amet, commodo ullamcorper
          justo. Aenean pulvinar accumsan nibh, vel bibendum turpis rutrum vitae. Donec condimentum justo vel luctus
          consectetur. Donec id nisl eu erat sollicitudin venenatis at eget justo. Mauris ac nulla laoreet, semper
          tortor sed, egestas odio. Fusce ex ligula, aliquet sed tortor sit amet, porta malesuada libero. Aenean varius
          tellus in enim fringilla tristique. Duis risus diam, condimentum ac ornare sed, imperdiet non lectus. Mauris
          auctor condimentum pulvinar. Pellentesque dapibus ultricies neque eu egestas. Phasellus molestie volutpat
          tincidunt. Aenean tristique felis aliquam consectetur fringilla. Pellentesque a mauris nibh. Maecenas commodo
          dignissim sem, eget laoreet purus laoreet eu. Sed arcu mi, facilisis quis finibus ac, pulvinar ut sem. Nulla
          facilisi. Maecenas in elit diam. Vivamus aliquam enim eget enim condimentum fermentum. Sed convallis tellus
          nisl, eget congue diam hendrerit et. Nulla posuere, sem non condimentum aliquet, leo arcu scelerisque leo, sit
          amet maximus ante massa in odio. Nunc dictum nibh ac dui luctus, sit amet tempor massa imperdiet. Nunc dictum
          ligula augue, a auctor odio rutrum a. Cras auctor, mi vitae maximus dictum, purus mauris ornare libero, ac
          consequat mauris diam sit amet mauris. In egestas eu felis ut volutpat. Etiam dignissim justo vitae sagittis
          venenatis. Vestibulum fermentum lectus nisl, vitae tempor ipsum lobortis nec. Nam porttitor est vel libero
          mollis, vel accumsan nisi iaculis. Suspendisse interdum consequat sapien, quis aliquam leo condimentum ut. In
          ut risus sit amet quam viverra facilisis. Mauris dapibus tortor id purus egestas mollis. Quisque vitae ornare
          ex. Vivamus non accumsan lectus. Mauris at iaculis ex. Curabitur rutrum magna nibh, eu accumsan felis
          tristique in. Donec in fringilla orci. Quisque ante dolor, tempor vitae lacinia non, malesuada at dui. Ut
          tincidunt bibendum magna vitae ornare. Suspendisse a ipsum ut nulla ornare pretium. Donec malesuada rhoncus
          facilisis. Integer nulla mi, sagittis vel purus non, viverra sodales lectus. Pellentesque habitant morbi
          tristique senectus et netus et malesuada fames ac turpis egestas. Aenean tristique turpis neque, nec elementum
          ipsum condimentum tempor. Pellentesque mauris magna, venenatis ac sodales et, fermentum sed nunc. Pellentesque
          dignissim lacinia suscipit. Pellentesque mollis tellus justo, eu facilisis neque tempor a. Aenean id metus
          gravida, consectetur ligula eget, tincidunt sapien. Morbi in tellus id ex vestibulum sagittis sed vitae risus.
          In vehicula sed arcu auctor ullamcorper. Etiam elementum mollis fringilla.
        </Alert>
      </StoryExample>
    </VerticalGroup>
  );
};

Examples.args = {
  severity: 'error',
  title: 'Some very important message',
  buttonContent: 'Close',
};
