+++
# -----------------------------------------------------------------------
# Do not edit this file. It is automatically generated by API Documenter.
# -----------------------------------------------------------------------
title = "@grafana/ui"
keywords = ["grafana","documentation","sdk","@grafana/ui"]
type = "docs"
draft = true
+++

## @grafana/ui package

A library containing the different design components of the Grafana ecosystem.

## Classes

|  Class | Description |
|  --- | --- |
|  [ansicolor](./ansicolor/) | Represents an ANSI-escaped string. |
|  [AsyncSelect](./asyncselect/) |  |
|  [BarGauge](./bargauge/) |  |
|  [BigValue](./bigvalue/) |  |
|  [ButtonSelect](./buttonselect/) |  |
|  [Cascader](./cascader/) |  |
|  [ClickOutsideWrapper](./clickoutsidewrapper/) |  |
|  [CustomScrollbar](./customscrollbar/) | Wraps component into <Scrollbars> component from <code>react-custom-scrollbars</code> |
|  [ErrorBoundary](./errorboundary/) |  |
|  [ErrorBoundaryAlert](./errorboundaryalert/) |  |
|  [FieldDisplayEditor](./fielddisplayeditor/) |  |
|  [Gauge](./gauge/) |  |
|  [Graph](./graph/) |  |
|  [GraphSeriesToggler](./graphseriestoggler/) |  |
|  [Input](./input/) |  |
|  [JsonExplorer](./jsonexplorer/) |  JsonExplorer<!-- -->JsonExplorer allows you to render JSON objects in HTML with a \*\*collapsible\*\* navigation. |
|  [JSONFormatter](./jsonformatter/) |  |
|  [List](./list/) |  |
|  [PieChart](./piechart/) |  |
|  [Popover](./popover/) |  |
|  [PopoverController](./popovercontroller/) |  |
|  [Portal](./portal/) |  |
|  [QueryField](./queryfield/) | Renders an editor field. Pass initial value as initialQuery and listen to changes in props.onValueChanged. This component can only process strings. Internally it uses Slate Value. Implement props.onTypeahead to use suggestions, see PromQueryField.tsx as an example. |
|  [Select](./select/) |  |
|  [SetInterval](./setinterval/) |  |
|  [StatsPicker](./statspicker/) |  |
|  [Switch](./switch/) |  |
|  [TableInputCSV](./tableinputcsv/) | Expects the container div to have size set and will fill it 100% |
|  [TagsInput](./tagsinput/) |  |
|  [ThresholdsEditor](./thresholdseditor/) |  |
|  [ToggleButtonGroup](./togglebuttongroup/) |  |
|  [TransformationsEditor](./transformationseditor/) |  |
|  [UnitPicker](./unitpicker/) |  |
|  [ValueMappingsEditor](./valuemappingseditor/) |  |
|  [VizRepeater](./vizrepeater/) |  |

## Enumerations

|  Enumeration | Description |
|  --- | --- |
|  [BarGaugeDisplayMode](./bargaugedisplaymode/) |  |
|  [BigValueColorMode](./bigvaluecolormode/) |  |
|  [BigValueGraphMode](./bigvaluegraphmode/) |  |
|  [BigValueJustifyMode](./bigvaluejustifymode/) |  |
|  [CompletionItemKind](./completionitemkind/) |  |
|  [EventsWithValidation](./eventswithvalidation/) |  |
|  [InputStatus](./inputstatus/) |  |
|  [LegendDisplayMode](./legenddisplaymode/) |  |
|  [PieChartType](./piecharttype/) |  |

## Functions

|  Function | Description |
|  --- | --- |
|  [BracesPlugin()](./bracesplugin/) |  |
|  [calculateFontSize(text, width, height, lineHeight, maxSize)](./calculatefontsize/) |  |
|  [ClearPlugin()](./clearplugin/) |  |
|  [ClipboardPlugin()](./clipboardplugin/) |  |
|  [convertOldAngularValueMapping(panel)](./convertoldangularvaluemapping/) | Convert the angular single stat mapping to new react style |
|  [FadeTransition(props)](./fadetransition/) |  |
|  [getTagColorsFromName(name)](./gettagcolorsfromname/) | Returns tag badge background and border colors based on hashed tag name. |
|  [IndentationPlugin()](./indentationplugin/) |  |
|  [measureText(text, fontSize)](./measuretext/) |  |
|  [NewlinePlugin()](./newlineplugin/) |  |
|  [resetSelectStyles()](./resetselectstyles/) |  |
|  [RunnerPlugin({ handler })](./runnerplugin/) |  |
|  [Segment({ options, value, onChange, Component, className, allowCustomValue, placeholder, })](./segment/) |  |
|  [SegmentAsync({ value, onChange, loadOptions, Component, className, allowCustomValue, placeholder, })](./segmentasync/) |  |
|  [SegmentInput({ value: initialValue, onChange, Component, className, placeholder, autofocus, })](./segmentinput/) |  |
|  [SegmentSelect({ value, options, onChange, onClickOutside, width, noOptionsMessage, allowCustomValue, })](./segmentselect/) |  |
|  [SelectionShortcutsPlugin()](./selectionshortcutsplugin/) |  |
|  [sharedSingleStatMigrationHandler(panel)](./sharedsinglestatmigrationhandler/) |  |
|  [sharedSingleStatPanelChangedHandler(options, prevPluginId, prevOptions)](./sharedsinglestatpanelchangedhandler/) |  |
|  [SlatePrism(optsParam)](./slateprism/) | A Slate plugin to highlight code syntax. |
|  [SlideOutTransition(props)](./slideouttransition/) |  |
|  [stylesFactory(stylesCreator)](./stylesfactory/) | Creates memoized version of styles creator |
|  [SuggestionsPlugin({ onTypeahead, cleanText, onWillApplySuggestion, portalOrigin, })](./suggestionsplugin/) |  |
|  [useTheme()](./usetheme/) |  |
|  [ValuePicker({ label, icon, options, onChange, variant })](./valuepicker/) |  |

## Interfaces

|  Interface | Description |
|  --- | --- |
|  [BigValueSparkline](./bigvaluesparkline/) |  |
|  [CascaderOption](./cascaderoption/) |  |
|  [CompletionItem](./completionitem/) |  |
|  [CompletionItemGroup](./completionitemgroup/) |  |
|  [ContextMenuGroup](./contextmenugroup/) |  |
|  [ContextMenuItem](./contextmenuitem/) |  |
|  [ContextMenuProps](./contextmenuprops/) |  |
|  [GraphSeriesTogglerAPI](./graphseriestogglerapi/) |  |
|  [GraphTooltipOptions](./graphtooltipoptions/) |  |
|  [LegendBasicOptions](./legendbasicoptions/) |  |
|  [LegendItem](./legenditem/) |  |
|  [LegendOptions](./legendoptions/) |  |
|  [LegendRenderOptions](./legendrenderoptions/) |  |
|  [NumberFieldConfigSettings](./numberfieldconfigsettings/) |  |
|  [SelectFieldConfigSettings](./selectfieldconfigsettings/) |  |
|  [SingleStatBaseOptions](./singlestatbaseoptions/) |  |
|  [StringFieldConfigSettings](./stringfieldconfigsettings/) |  |
|  [SuggestionsState](./suggestionsstate/) |  |
|  [Themeable](./themeable/) |  |
|  [TypeaheadInput](./typeaheadinput/) |  |
|  [TypeaheadOutput](./typeaheadoutput/) |  |
|  [ValidationEvents](./validationevents/) |  |
|  [ValidationRule](./validationrule/) |  |

## Namespaces

|  Namespace | Description |
|  --- | --- |
|  [DOMUtil](./domutil/) |  |
|  [styleMixins](./stylemixins/) |  |

## Variables

|  Variable | Description |
|  --- | --- |
|  [Alert](./alert/) |  |
|  [ALERTING\_COLOR](./alerting_color/) |  |
|  [AlphaNotice](./alphanotice/) |  |
|  [Button](./button/) |  |
|  [ButtonCascader](./buttoncascader/) |  |
|  [CallToActionCard](./calltoactioncard/) |  |
|  [Chart](./chart/) |  |
|  [Collapse](./collapse/) |  |
|  [ColorPicker](./colorpicker/) |  |
|  [colors](./colors/) |  |
|  [ConfirmButton](./confirmbutton/) |  |
|  [ConfirmModal](./confirmmodal/) |  |
|  [ContextMenu](./contextmenu/) |  |
|  [ControlledCollapse](./controlledcollapse/) |  |
|  [DataLinkBuiltInVars](./datalinkbuiltinvars/) |  |
|  [DataLinkInput](./datalinkinput/) |  |
|  [DataLinksContextMenu](./datalinkscontextmenu/) |  |
|  [DataLinksEditor](./datalinkseditor/) |  |
|  [DataSourceHttpSettings](./datasourcehttpsettings/) |  |
|  [DEFAULT\_ANNOTATION\_COLOR](./default_annotation_color/) |  |
|  [DeleteButton](./deletebutton/) |  |
|  [Drawer](./drawer/) |  |
|  [EmptySearchResult](./emptysearchresult/) |  |
|  [ErrorWithStack](./errorwithstack/) |  |
|  [fieldMatchersUI](./fieldmatchersui/) |  |
|  [FieldPropertiesEditor](./fieldpropertieseditor/) |  |
|  [FormField](./formfield/) | Default form field including label used in Grafana UI. Default input element is simple <input />. You can also pass custom inputEl if required in which case inputWidth and inputProps are ignored. |
|  [FormLabel](./formlabel/) |  |
|  [Forms](./forms/) |  |
|  [FullWidthButtonContainer](./fullwidthbuttoncontainer/) |  |
|  [getLogRowStyles](./getlogrowstyles/) |  |
|  [getStandardFieldConfigs](./getstandardfieldconfigs/) |  |
|  [getTheme](./gettheme/) |  |
|  [GraphContextMenu](./graphcontextmenu/) |  |
|  [GraphLegend](./graphlegend/) |  |
|  [GraphWithLegend](./graphwithlegend/) |  |
|  [hasValidationEvent](./hasvalidationevent/) |  |
|  [HorizontalGroup](./horizontalgroup/) |  |
|  [Icon](./icon/) |  |
|  [IndicatorsContainer](./indicatorscontainer/) |  |
|  [LegendList](./legendlist/) |  |
|  [LegendTable](./legendtable/) |  |
|  [LinkButton](./linkbutton/) |  |
|  [linkModelToContextMenuItems](./linkmodeltocontextmenuitems/) | Delays creating links until we need to open the ContextMenu |
|  [LoadingPlaceholder](./loadingplaceholder/) |  |
|  [LogLabels](./loglabels/) |  |
|  [LogRows](./logrows/) |  |
|  [makeFragment](./makefragment/) |  |
|  [makeValue](./makevalue/) |  |
|  [mockTheme](./mocktheme/) |  |
|  [mockThemeContext](./mockthemecontext/) | Enables theme context mocking |
|  [Modal](./modal/) |  |
|  [NO\_DATA\_COLOR](./no_data_color/) |  |
|  [NoOptionsMessage](./nooptionsmessage/) |  |
|  [NumberOverrideEditor](./numberoverrideeditor/) |  |
|  [numberOverrideProcessor](./numberoverrideprocessor/) |  |
|  [NumberValueEditor](./numbervalueeditor/) |  |
|  [OK\_COLOR](./ok_color/) |  |
|  [PALETTE\_COLUMNS](./palette_columns/) |  |
|  [PALETTE\_ROWS](./palette_rows/) |  |
|  [PanelOptionsGrid](./paneloptionsgrid/) |  |
|  [PanelOptionsGroup](./paneloptionsgroup/) |  |
|  [PENDING\_COLOR](./pending_color/) |  |
|  [RefreshPicker](./refreshpicker/) |  |
|  [regexValidation](./regexvalidation/) |  |
|  [REGION\_FILL\_ALPHA](./region_fill_alpha/) |  |
|  [SCHEMA](./schema/) |  |
|  [SecretFormField](./secretformfield/) | Form field that has 2 states configured and not configured. If configured it will not show its contents and adds a reset button that will clear the input and makes it accessible. In non configured state it behaves like normal form field. This is used for passwords or anything that is encrypted on the server and is later returned encrypted to the user (like datasource passwords). |
|  [SelectOverrideEditor](./selectoverrideeditor/) |  |
|  [selectOverrideProcessor](./selectoverrideprocessor/) |  |
|  [selectThemeVariant](./selectthemevariant/) |  |
|  [SelectValueEditor](./selectvalueeditor/) |  |
|  [SeriesColorPicker](./seriescolorpicker/) |  |
|  [SeriesColorPickerPopover](./seriescolorpickerpopover/) |  |
|  [SeriesColorPickerPopoverWithTheme](./seriescolorpickerpopoverwiththeme/) |  |
|  [SeriesIcon](./seriesicon/) |  |
|  [sortedColors](./sortedcolors/) |  |
|  [Spinner](./spinner/) |  |
|  [StringOverrideEditor](./stringoverrideeditor/) |  |
|  [stringOverrideProcessor](./stringoverrideprocessor/) |  |
|  [StringValueEditor](./stringvalueeditor/) |  |
|  [Tab](./tab/) |  |
|  [TabContent](./tabcontent/) |  |
|  [Table](./table/) |  |
|  [TabsBar](./tabsbar/) |  |
|  [ThemeContext](./themecontext/) |  |
|  [TimeOfDayPicker](./timeofdaypicker/) |  |
|  [TimePicker](./timepicker/) |  |
|  [ToggleButton](./togglebutton/) |  |
|  [Tooltip](./tooltip/) |  |
|  [TransformationRow](./transformationrow/) |  |
|  [transformersUIRegistry](./transformersuiregistry/) |  |
|  [validate](./validate/) |  |
|  [VerticalGroup](./verticalgroup/) |  |
|  [withTheme](./withtheme/) |  |

## Type Aliases

|  Type Alias | Description |
|  --- | --- |
|  [AlertVariant](./alertvariant/) |  |
|  [LegendPlacement](./legendplacement/) |  |
|  [PopoverContent](./popovercontent/) |  |
|  [Renderable](./renderable/) |  |
|  [RenderFunction](./renderfunction/) |  |

