+++
# -----------------------------------------------------------------------
# Do not edit this file. It is automatically generated by API Documenter.
# -----------------------------------------------------------------------
title = "AppendedVectors"
keywords = ["grafana","documentation","sdk","@grafana/data"]
type = "docs"
draft = true
+++

## AppendedVectors class

This may be more trouble than it is worth. This trades some computation time for RAM -- rather than allocate a new array the size of all previous arrays, this just points the correct index to their original array values

<b>Signature</b>

```typescript
export declare class AppendedVectors<T = any> implements Vector<T> 
```
<b>Import</b>

```typescript
import { AppendedVectors } from '@grafana/data';
```
<b>Constructors</b>

|  Constructor | Modifiers | Description |
|  --- | --- | --- |
|  [constructor(startAt)](#constructor-startat) |  | Constructs a new instance of the <code>AppendedVectors</code> class |

<b>Properties</b>

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [length](#length-property) |  | <code>number</code> |  |
|  [source](#source-property) |  | <code>Array&lt;AppendedVectorInfo&lt;T&gt;&gt;</code> |  |

<b>Methods</b>

|  Method | Modifiers | Description |
|  --- | --- | --- |
|  [append(v)](#append-method) |  |  |
|  [get(index)](#get-method) |  |  |
|  [setLength(length)](#setlength-method) |  | Make the vector look like it is this long |
|  [toArray()](#toarray-method) |  |  |
|  [toJSON()](#tojson-method) |  |  |

### constructor(startAt)

Constructs a new instance of the `AppendedVectors` class

<b>Signature</b>

```typescript
constructor(startAt?: number);
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  startAt | <code>number</code> |  |

### length property

<b>Signature</b>

```typescript
length: number;
```

### source property

<b>Signature</b>

```typescript
source: Array<AppendedVectorInfo<T>>;
```

### append method

<b>Signature</b>

```typescript
append(v: Vector<T>): AppendedVectorInfo<T>;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  v | <code>Vector&lt;T&gt;</code> |  |

<b>Returns:</b>

`AppendedVectorInfo<T>`

### get method

<b>Signature</b>

```typescript
get(index: number): T;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  index | <code>number</code> |  |

<b>Returns:</b>

`T`

### setLength method

Make the vector look like it is this long

<b>Signature</b>

```typescript
setLength(length: number): void;
```
<b>Parameters</b>

|  Parameter | Type | Description |
|  --- | --- | --- |
|  length | <code>number</code> |  |

<b>Returns:</b>

`void`

### toArray method

<b>Signature</b>

```typescript
toArray(): T[];
```
<b>Returns:</b>

`T[]`

### toJSON method

<b>Signature</b>

```typescript
toJSON(): T[];
```
<b>Returns:</b>

`T[]`

