/*
  Copyright (c) 2007-2016 Red Hat, Inc. <http://www.redhat.com>
  This file is part of GlusterFS.

  This file is licensed to you under your choice of the GNU Lesser
  General Public License, version 3 or any later version (LGPLv3 or
  later), or the GNU General Public License, version 2 (GPLv2), in all
  cases as published by the Free Software Foundation.
*/

#include "compat.h"

#if defined(__GNUC__)
#if __GNUC__ >= 4
#if !defined(__clang__)
#if !defined(__NetBSD__)
#pragma GCC diagnostic ignored "-Wunused-but-set-variable"
#pragma GCC diagnostic ignored "-Wunused-variable"
#endif
#else
#pragma clang diagnostic ignored "-Wunused-variable"
#pragma clang diagnostic ignored "-Wunused-value"
#endif
#endif
#endif

/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _CHANGELOG_XDR_H_RPCGEN
#define _CHANGELOG_XDR_H_RPCGEN

#include <rpc/rpc.h>


#ifdef __cplusplus
extern "C" {
#endif


struct changelog_probe_req {
	u_int filter;
	char sock[UNIX_PATH_MAX];
};
typedef struct changelog_probe_req changelog_probe_req;

struct changelog_probe_rsp {
	int op_ret;
};
typedef struct changelog_probe_rsp changelog_probe_rsp;

struct changelog_event_req {
	u_long seq;
	u_long tv_sec;
	u_long tv_usec;
};
typedef struct changelog_event_req changelog_event_req;

struct changelog_event_rsp {
	int op_ret;
	u_long seq;
};
typedef struct changelog_event_rsp changelog_event_rsp;

/* the xdr functions */

#if defined(__STDC__) || defined(__cplusplus)
extern  bool_t xdr_changelog_probe_req (XDR *, changelog_probe_req*);
extern  bool_t xdr_changelog_probe_rsp (XDR *, changelog_probe_rsp*);
extern  bool_t xdr_changelog_event_req (XDR *, changelog_event_req*);
extern  bool_t xdr_changelog_event_rsp (XDR *, changelog_event_rsp*);

#else /* K&R C */
extern bool_t xdr_changelog_probe_req ();
extern bool_t xdr_changelog_probe_rsp ();
extern bool_t xdr_changelog_event_req ();
extern bool_t xdr_changelog_event_rsp ();

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_CHANGELOG-XDR_H_RPCGEN */
