## How to contribute to gluster-block

#### **Did you find a bug?**


* **Ensure the bug was not already reported** by searching on GitHub under [Issues](https://github.com/gluster/gluster-block/issues).

* If you're unable to find an open issue addressing the problem, [open a new one](https://github.com/gluster/gluster-block/issues/new). Be sure to include a **title and clear description**, as much relevant information as possible, and a **code sample** or an **executable test case** demonstrating the expected behavior that is not occurring.

* Please use the issue template to create the issue.
  * [**Issue Template**](https://github.com/gluster/gluster-block/blob/master/.github/ISSUE_TEMPLATE.md)

#### **Did you write a patch ?**

* Open a new GitHub pull request with the patch.

* Ensure the PR description clearly describes the problem and solution. Include the relevant issue number if applicable.

* Please use the PR template to create the new PR.
  * [**PR Template**](https://github.com/gluster/gluster-block/blob/master/.github/PULL_REQUEST_TEMPLATE.md)

* Please ensure that you validate your changes by running our basic test case [tests/basic.t](https://github.com/gluster/gluster-block/blob/master/tests/basic.t)

* Please help with steps to test your changes and/or add a simple test case.

#### **Do you intend to add a new feature or change an existing one?**

* Suggest your change in the [gluster-devel mailing list](https://lists.gluster.org/mailman/listinfo/gluster-devel) and wait for acknowledgement from the maintainer[s].

* Alternatively you can use github issue for proposing the idea or design.

* Once the design/idea is approved, you can start writing the code (or choose to get this done by others)

* Please follow [submitting new PR guide](https://github.com/gluster/gluster-block/blob/master/CONTRIBUTING.md#did-you-write-a-patch-) when your code is ready for review.

#### **Do you have questions about the source code?**

* Ask any question about how to use gluster-block in the [gluster-users mailing list](https://lists.gluster.org/mailman/listinfo/gluster-users).

#### **Do you want to contribute to the gluster documentation?**

* Please walk through our documentation here [gluster documentation](https://github.com/gluster/glusterfs/tree/master/doc) and [gluster-block documentation](https://github.com/gluster/gluster-block/tree/master/docs)

We encourage you to pitch in and [join the team](https://www.gluster.org/)!


Thanks! :heart: :heart: :heart:

Gluster-block Team!
