/**
 * FreeRDP: A Remote Desktop Protocol Client
 * Hex Dump Utils
 *
 * Copyright 2011 Marc-Andre Moreau <marcandre.moreau@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <stdio.h>
#include <string.h>

#include <freerdp/types.h>

#include <freerdp/utils/hexdump.h>

void freerdp_hexdump(uint8* data, int length)
{
	uint8* p = data;
	int i, line, offset = 0;

	while (offset < length)
	{
		printf("%04x ", offset);

		line = length - offset;

		if (line > FREERDP_HEXDUMP_LINE_LENGTH)
			line = FREERDP_HEXDUMP_LINE_LENGTH;

		for (i = 0; i < line; i++)
			printf("%02x ", p[i]);

		for (; i < FREERDP_HEXDUMP_LINE_LENGTH; i++)
			printf("   ");

		for (i = 0; i < line; i++)
			printf("%c", (p[i] >= 0x20 && p[i] < 0x7F) ? p[i] : '.');

		printf("\n");

		offset += line;
		p += line;
	}
}

