/*************************************************************************/
/*                                                                       */
/*                  Language Technologies Institute                      */
/*                     Carnegie Mellon University                        */
/*                         Copyright (c) 2001                            */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission is hereby granted, free of charge, to use and distribute  */
/*  this software and its documentation without restriction, including   */
/*  without limitation the rights to use, copy, modify, merge, publish,  */
/*  distribute, sublicense, and/or sell copies of this work, and to      */
/*  permit persons to whom this work is furnished to do so, subject to   */
/*  the following conditions:                                            */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*   4. The authors' names are not used to endorse or promote products   */
/*      derived from this software without specific prior written        */
/*      permission.                                                      */
/*                                                                       */
/*  CARNEGIE MELLON UNIVERSITY AND THE CONTRIBUTORS TO THIS WORK         */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL CARNEGIE MELLON UNIVERSITY NOR THE CONTRIBUTORS BE LIABLE      */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*             Author:  Alan W Black (awb@cs.cmu.edu)                    */
/*               Date:  January 2001                                     */
/*************************************************************************/
/*                                                                       */
/*  US Text analysis                                                     */
/*                                                                       */
/*************************************************************************/
#ifndef _US_TEXT_H__
#define _US_TEXT_H__

#include "cst_val.h"
#include "cst_hrg.h"
#include "cst_cart.h"

cst_val *en_exp_number(const char *numstring);
cst_val *en_exp_digits(const char *numstring);
cst_val *en_exp_id(const char *numstring);
cst_val *en_exp_ordinal(const char *numstring);
cst_val *en_exp_letters(const char *lets);
cst_val *en_exp_real(const char *numstring);
int en_exp_roman(const char *roman);

extern const cst_cart us_nums_cart;

void us_text_init();
cst_utterance *us_textanalysis(cst_utterance *u);
cst_val *us_tokentowords(cst_item *token);

int us_aswd(const char *w);

extern const char *us_english_punctuation;
extern const char *us_english_prepunctuation;
extern const char *us_english_singlecharsymbols;
extern const char *us_english_whitespace;

#endif

