// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package ec2_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/ec2"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleEC2_AcceptReservedInstancesExchangeQuote() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.AcceptReservedInstancesExchangeQuoteInput{
		ReservedInstanceIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		DryRun: aws.Bool(true),
		TargetConfigurations: []*ec2.TargetConfigurationRequest{
			{ // Required
				OfferingId:    aws.String("String"), // Required
				InstanceCount: aws.Int64(1),
			},
			// More values...
		},
	}
	resp, err := svc.AcceptReservedInstancesExchangeQuote(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_AcceptVpcPeeringConnection() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.AcceptVpcPeeringConnectionInput{
		DryRun:                 aws.Bool(true),
		VpcPeeringConnectionId: aws.String("String"),
	}
	resp, err := svc.AcceptVpcPeeringConnection(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_AllocateAddress() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.AllocateAddressInput{
		Domain: aws.String("DomainType"),
		DryRun: aws.Bool(true),
	}
	resp, err := svc.AllocateAddress(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_AllocateHosts() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.AllocateHostsInput{
		AvailabilityZone: aws.String("String"), // Required
		InstanceType:     aws.String("String"), // Required
		Quantity:         aws.Int64(1),         // Required
		AutoPlacement:    aws.String("AutoPlacement"),
		ClientToken:      aws.String("String"),
	}
	resp, err := svc.AllocateHosts(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_AssignIpv6Addresses() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.AssignIpv6AddressesInput{
		NetworkInterfaceId: aws.String("String"), // Required
		Ipv6AddressCount:   aws.Int64(1),
		Ipv6Addresses: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.AssignIpv6Addresses(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_AssignPrivateIpAddresses() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.AssignPrivateIpAddressesInput{
		NetworkInterfaceId: aws.String("String"), // Required
		AllowReassignment:  aws.Bool(true),
		PrivateIpAddresses: []*string{
			aws.String("String"), // Required
			// More values...
		},
		SecondaryPrivateIpAddressCount: aws.Int64(1),
	}
	resp, err := svc.AssignPrivateIpAddresses(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_AssociateAddress() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.AssociateAddressInput{
		AllocationId:       aws.String("String"),
		AllowReassociation: aws.Bool(true),
		DryRun:             aws.Bool(true),
		InstanceId:         aws.String("String"),
		NetworkInterfaceId: aws.String("String"),
		PrivateIpAddress:   aws.String("String"),
		PublicIp:           aws.String("String"),
	}
	resp, err := svc.AssociateAddress(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_AssociateDhcpOptions() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.AssociateDhcpOptionsInput{
		DhcpOptionsId: aws.String("String"), // Required
		VpcId:         aws.String("String"), // Required
		DryRun:        aws.Bool(true),
	}
	resp, err := svc.AssociateDhcpOptions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_AssociateRouteTable() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.AssociateRouteTableInput{
		RouteTableId: aws.String("String"), // Required
		SubnetId:     aws.String("String"), // Required
		DryRun:       aws.Bool(true),
	}
	resp, err := svc.AssociateRouteTable(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_AssociateSubnetCidrBlock() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.AssociateSubnetCidrBlockInput{
		Ipv6CidrBlock: aws.String("String"), // Required
		SubnetId:      aws.String("String"), // Required
	}
	resp, err := svc.AssociateSubnetCidrBlock(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_AssociateVpcCidrBlock() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.AssociateVpcCidrBlockInput{
		VpcId: aws.String("String"), // Required
		AmazonProvidedIpv6CidrBlock: aws.Bool(true),
	}
	resp, err := svc.AssociateVpcCidrBlock(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_AttachClassicLinkVpc() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.AttachClassicLinkVpcInput{
		Groups: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		InstanceId: aws.String("String"), // Required
		VpcId:      aws.String("String"), // Required
		DryRun:     aws.Bool(true),
	}
	resp, err := svc.AttachClassicLinkVpc(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_AttachInternetGateway() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.AttachInternetGatewayInput{
		InternetGatewayId: aws.String("String"), // Required
		VpcId:             aws.String("String"), // Required
		DryRun:            aws.Bool(true),
	}
	resp, err := svc.AttachInternetGateway(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_AttachNetworkInterface() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.AttachNetworkInterfaceInput{
		DeviceIndex:        aws.Int64(1),         // Required
		InstanceId:         aws.String("String"), // Required
		NetworkInterfaceId: aws.String("String"), // Required
		DryRun:             aws.Bool(true),
	}
	resp, err := svc.AttachNetworkInterface(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_AttachVolume() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.AttachVolumeInput{
		Device:     aws.String("String"), // Required
		InstanceId: aws.String("String"), // Required
		VolumeId:   aws.String("String"), // Required
		DryRun:     aws.Bool(true),
	}
	resp, err := svc.AttachVolume(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_AttachVpnGateway() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.AttachVpnGatewayInput{
		VpcId:        aws.String("String"), // Required
		VpnGatewayId: aws.String("String"), // Required
		DryRun:       aws.Bool(true),
	}
	resp, err := svc.AttachVpnGateway(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_AuthorizeSecurityGroupEgress() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.AuthorizeSecurityGroupEgressInput{
		GroupId:  aws.String("String"), // Required
		CidrIp:   aws.String("String"),
		DryRun:   aws.Bool(true),
		FromPort: aws.Int64(1),
		IpPermissions: []*ec2.IpPermission{
			{ // Required
				FromPort:   aws.Int64(1),
				IpProtocol: aws.String("String"),
				IpRanges: []*ec2.IpRange{
					{ // Required
						CidrIp: aws.String("String"),
					},
					// More values...
				},
				Ipv6Ranges: []*ec2.Ipv6Range{
					{ // Required
						CidrIpv6: aws.String("String"),
					},
					// More values...
				},
				PrefixListIds: []*ec2.PrefixListId{
					{ // Required
						PrefixListId: aws.String("String"),
					},
					// More values...
				},
				ToPort: aws.Int64(1),
				UserIdGroupPairs: []*ec2.UserIdGroupPair{
					{ // Required
						GroupId:       aws.String("String"),
						GroupName:     aws.String("String"),
						PeeringStatus: aws.String("String"),
						UserId:        aws.String("String"),
						VpcId:         aws.String("String"),
						VpcPeeringConnectionId: aws.String("String"),
					},
					// More values...
				},
			},
			// More values...
		},
		IpProtocol:                 aws.String("String"),
		SourceSecurityGroupName:    aws.String("String"),
		SourceSecurityGroupOwnerId: aws.String("String"),
		ToPort: aws.Int64(1),
	}
	resp, err := svc.AuthorizeSecurityGroupEgress(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_AuthorizeSecurityGroupIngress() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.AuthorizeSecurityGroupIngressInput{
		CidrIp:    aws.String("String"),
		DryRun:    aws.Bool(true),
		FromPort:  aws.Int64(1),
		GroupId:   aws.String("String"),
		GroupName: aws.String("String"),
		IpPermissions: []*ec2.IpPermission{
			{ // Required
				FromPort:   aws.Int64(1),
				IpProtocol: aws.String("String"),
				IpRanges: []*ec2.IpRange{
					{ // Required
						CidrIp: aws.String("String"),
					},
					// More values...
				},
				Ipv6Ranges: []*ec2.Ipv6Range{
					{ // Required
						CidrIpv6: aws.String("String"),
					},
					// More values...
				},
				PrefixListIds: []*ec2.PrefixListId{
					{ // Required
						PrefixListId: aws.String("String"),
					},
					// More values...
				},
				ToPort: aws.Int64(1),
				UserIdGroupPairs: []*ec2.UserIdGroupPair{
					{ // Required
						GroupId:       aws.String("String"),
						GroupName:     aws.String("String"),
						PeeringStatus: aws.String("String"),
						UserId:        aws.String("String"),
						VpcId:         aws.String("String"),
						VpcPeeringConnectionId: aws.String("String"),
					},
					// More values...
				},
			},
			// More values...
		},
		IpProtocol:                 aws.String("String"),
		SourceSecurityGroupName:    aws.String("String"),
		SourceSecurityGroupOwnerId: aws.String("String"),
		ToPort: aws.Int64(1),
	}
	resp, err := svc.AuthorizeSecurityGroupIngress(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_BundleInstance() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.BundleInstanceInput{
		InstanceId: aws.String("String"), // Required
		Storage: &ec2.Storage{ // Required
			S3: &ec2.S3Storage{
				AWSAccessKeyId:        aws.String("String"),
				Bucket:                aws.String("String"),
				Prefix:                aws.String("String"),
				UploadPolicy:          []byte("PAYLOAD"),
				UploadPolicySignature: aws.String("String"),
			},
		},
		DryRun: aws.Bool(true),
	}
	resp, err := svc.BundleInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CancelBundleTask() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CancelBundleTaskInput{
		BundleId: aws.String("String"), // Required
		DryRun:   aws.Bool(true),
	}
	resp, err := svc.CancelBundleTask(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CancelConversionTask() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CancelConversionTaskInput{
		ConversionTaskId: aws.String("String"), // Required
		DryRun:           aws.Bool(true),
		ReasonMessage:    aws.String("String"),
	}
	resp, err := svc.CancelConversionTask(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CancelExportTask() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CancelExportTaskInput{
		ExportTaskId: aws.String("String"), // Required
	}
	resp, err := svc.CancelExportTask(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CancelImportTask() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CancelImportTaskInput{
		CancelReason: aws.String("String"),
		DryRun:       aws.Bool(true),
		ImportTaskId: aws.String("String"),
	}
	resp, err := svc.CancelImportTask(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CancelReservedInstancesListing() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CancelReservedInstancesListingInput{
		ReservedInstancesListingId: aws.String("String"), // Required
	}
	resp, err := svc.CancelReservedInstancesListing(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CancelSpotFleetRequests() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CancelSpotFleetRequestsInput{
		SpotFleetRequestIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		TerminateInstances: aws.Bool(true), // Required
		DryRun:             aws.Bool(true),
	}
	resp, err := svc.CancelSpotFleetRequests(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CancelSpotInstanceRequests() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CancelSpotInstanceRequestsInput{
		SpotInstanceRequestIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		DryRun: aws.Bool(true),
	}
	resp, err := svc.CancelSpotInstanceRequests(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ConfirmProductInstance() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ConfirmProductInstanceInput{
		InstanceId:  aws.String("String"), // Required
		ProductCode: aws.String("String"), // Required
		DryRun:      aws.Bool(true),
	}
	resp, err := svc.ConfirmProductInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CopyImage() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CopyImageInput{
		Name:          aws.String("String"), // Required
		SourceImageId: aws.String("String"), // Required
		SourceRegion:  aws.String("String"), // Required
		ClientToken:   aws.String("String"),
		Description:   aws.String("String"),
		DryRun:        aws.Bool(true),
		Encrypted:     aws.Bool(true),
		KmsKeyId:      aws.String("String"),
	}
	resp, err := svc.CopyImage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CopySnapshot() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CopySnapshotInput{
		SourceRegion:      aws.String("String"), // Required
		SourceSnapshotId:  aws.String("String"), // Required
		Description:       aws.String("String"),
		DestinationRegion: aws.String("String"),
		DryRun:            aws.Bool(true),
		Encrypted:         aws.Bool(true),
		KmsKeyId:          aws.String("String"),
		PresignedUrl:      aws.String("String"),
	}
	resp, err := svc.CopySnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateCustomerGateway() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateCustomerGatewayInput{
		BgpAsn:   aws.Int64(1),              // Required
		PublicIp: aws.String("String"),      // Required
		Type:     aws.String("GatewayType"), // Required
		DryRun:   aws.Bool(true),
	}
	resp, err := svc.CreateCustomerGateway(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateDhcpOptions() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateDhcpOptionsInput{
		DhcpConfigurations: []*ec2.NewDhcpConfiguration{ // Required
			{ // Required
				Key: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		DryRun: aws.Bool(true),
	}
	resp, err := svc.CreateDhcpOptions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateEgressOnlyInternetGateway() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateEgressOnlyInternetGatewayInput{
		VpcId:       aws.String("String"), // Required
		ClientToken: aws.String("String"),
		DryRun:      aws.Bool(true),
	}
	resp, err := svc.CreateEgressOnlyInternetGateway(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateFlowLogs() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateFlowLogsInput{
		DeliverLogsPermissionArn: aws.String("String"), // Required
		LogGroupName:             aws.String("String"), // Required
		ResourceIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		ResourceType: aws.String("FlowLogsResourceType"), // Required
		TrafficType:  aws.String("TrafficType"),          // Required
		ClientToken:  aws.String("String"),
	}
	resp, err := svc.CreateFlowLogs(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateImage() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateImageInput{
		InstanceId: aws.String("String"), // Required
		Name:       aws.String("String"), // Required
		BlockDeviceMappings: []*ec2.BlockDeviceMapping{
			{ // Required
				DeviceName: aws.String("String"),
				Ebs: &ec2.EbsBlockDevice{
					DeleteOnTermination: aws.Bool(true),
					Encrypted:           aws.Bool(true),
					Iops:                aws.Int64(1),
					SnapshotId:          aws.String("String"),
					VolumeSize:          aws.Int64(1),
					VolumeType:          aws.String("VolumeType"),
				},
				NoDevice:    aws.String("String"),
				VirtualName: aws.String("String"),
			},
			// More values...
		},
		Description: aws.String("String"),
		DryRun:      aws.Bool(true),
		NoReboot:    aws.Bool(true),
	}
	resp, err := svc.CreateImage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateInstanceExportTask() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateInstanceExportTaskInput{
		InstanceId:  aws.String("String"), // Required
		Description: aws.String("String"),
		ExportToS3Task: &ec2.ExportToS3TaskSpecification{
			ContainerFormat: aws.String("ContainerFormat"),
			DiskImageFormat: aws.String("DiskImageFormat"),
			S3Bucket:        aws.String("String"),
			S3Prefix:        aws.String("String"),
		},
		TargetEnvironment: aws.String("ExportEnvironment"),
	}
	resp, err := svc.CreateInstanceExportTask(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateInternetGateway() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateInternetGatewayInput{
		DryRun: aws.Bool(true),
	}
	resp, err := svc.CreateInternetGateway(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateKeyPair() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateKeyPairInput{
		KeyName: aws.String("String"), // Required
		DryRun:  aws.Bool(true),
	}
	resp, err := svc.CreateKeyPair(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateNatGateway() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateNatGatewayInput{
		AllocationId: aws.String("String"), // Required
		SubnetId:     aws.String("String"), // Required
		ClientToken:  aws.String("String"),
	}
	resp, err := svc.CreateNatGateway(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateNetworkAcl() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateNetworkAclInput{
		VpcId:  aws.String("String"), // Required
		DryRun: aws.Bool(true),
	}
	resp, err := svc.CreateNetworkAcl(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateNetworkAclEntry() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateNetworkAclEntryInput{
		Egress:       aws.Bool(true),           // Required
		NetworkAclId: aws.String("String"),     // Required
		Protocol:     aws.String("String"),     // Required
		RuleAction:   aws.String("RuleAction"), // Required
		RuleNumber:   aws.Int64(1),             // Required
		CidrBlock:    aws.String("String"),
		DryRun:       aws.Bool(true),
		IcmpTypeCode: &ec2.IcmpTypeCode{
			Code: aws.Int64(1),
			Type: aws.Int64(1),
		},
		Ipv6CidrBlock: aws.String("String"),
		PortRange: &ec2.PortRange{
			From: aws.Int64(1),
			To:   aws.Int64(1),
		},
	}
	resp, err := svc.CreateNetworkAclEntry(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateNetworkInterface() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateNetworkInterfaceInput{
		SubnetId:    aws.String("String"), // Required
		Description: aws.String("String"),
		DryRun:      aws.Bool(true),
		Groups: []*string{
			aws.String("String"), // Required
			// More values...
		},
		Ipv6AddressCount: aws.Int64(1),
		Ipv6Addresses: []*ec2.InstanceIpv6Address{
			{ // Required
				Ipv6Address: aws.String("String"),
			},
			// More values...
		},
		PrivateIpAddress: aws.String("String"),
		PrivateIpAddresses: []*ec2.PrivateIpAddressSpecification{
			{ // Required
				PrivateIpAddress: aws.String("String"), // Required
				Primary:          aws.Bool(true),
			},
			// More values...
		},
		SecondaryPrivateIpAddressCount: aws.Int64(1),
	}
	resp, err := svc.CreateNetworkInterface(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreatePlacementGroup() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreatePlacementGroupInput{
		GroupName: aws.String("String"),            // Required
		Strategy:  aws.String("PlacementStrategy"), // Required
		DryRun:    aws.Bool(true),
	}
	resp, err := svc.CreatePlacementGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateReservedInstancesListing() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateReservedInstancesListingInput{
		ClientToken:   aws.String("String"), // Required
		InstanceCount: aws.Int64(1),         // Required
		PriceSchedules: []*ec2.PriceScheduleSpecification{ // Required
			{ // Required
				CurrencyCode: aws.String("CurrencyCodeValues"),
				Price:        aws.Float64(1.0),
				Term:         aws.Int64(1),
			},
			// More values...
		},
		ReservedInstancesId: aws.String("String"), // Required
	}
	resp, err := svc.CreateReservedInstancesListing(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateRoute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateRouteInput{
		RouteTableId:             aws.String("String"), // Required
		DestinationCidrBlock:     aws.String("String"),
		DestinationIpv6CidrBlock: aws.String("String"),
		DryRun: aws.Bool(true),
		EgressOnlyInternetGatewayId: aws.String("String"),
		GatewayId:                   aws.String("String"),
		InstanceId:                  aws.String("String"),
		NatGatewayId:                aws.String("String"),
		NetworkInterfaceId:          aws.String("String"),
		VpcPeeringConnectionId:      aws.String("String"),
	}
	resp, err := svc.CreateRoute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateRouteTable() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateRouteTableInput{
		VpcId:  aws.String("String"), // Required
		DryRun: aws.Bool(true),
	}
	resp, err := svc.CreateRouteTable(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateSecurityGroup() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateSecurityGroupInput{
		Description: aws.String("String"), // Required
		GroupName:   aws.String("String"), // Required
		DryRun:      aws.Bool(true),
		VpcId:       aws.String("String"),
	}
	resp, err := svc.CreateSecurityGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateSnapshot() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateSnapshotInput{
		VolumeId:    aws.String("String"), // Required
		Description: aws.String("String"),
		DryRun:      aws.Bool(true),
	}
	resp, err := svc.CreateSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateSpotDatafeedSubscription() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateSpotDatafeedSubscriptionInput{
		Bucket: aws.String("String"), // Required
		DryRun: aws.Bool(true),
		Prefix: aws.String("String"),
	}
	resp, err := svc.CreateSpotDatafeedSubscription(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateSubnet() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateSubnetInput{
		CidrBlock:        aws.String("String"), // Required
		VpcId:            aws.String("String"), // Required
		AvailabilityZone: aws.String("String"),
		DryRun:           aws.Bool(true),
		Ipv6CidrBlock:    aws.String("String"),
	}
	resp, err := svc.CreateSubnet(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateTags() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateTagsInput{
		Resources: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		Tags: []*ec2.Tag{ // Required
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
		DryRun: aws.Bool(true),
	}
	resp, err := svc.CreateTags(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateVolume() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateVolumeInput{
		AvailabilityZone: aws.String("String"), // Required
		DryRun:           aws.Bool(true),
		Encrypted:        aws.Bool(true),
		Iops:             aws.Int64(1),
		KmsKeyId:         aws.String("String"),
		Size:             aws.Int64(1),
		SnapshotId:       aws.String("String"),
		VolumeType:       aws.String("VolumeType"),
	}
	resp, err := svc.CreateVolume(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateVpc() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateVpcInput{
		CidrBlock:                   aws.String("String"), // Required
		AmazonProvidedIpv6CidrBlock: aws.Bool(true),
		DryRun:          aws.Bool(true),
		InstanceTenancy: aws.String("Tenancy"),
	}
	resp, err := svc.CreateVpc(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateVpcEndpoint() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateVpcEndpointInput{
		ServiceName:    aws.String("String"), // Required
		VpcId:          aws.String("String"), // Required
		ClientToken:    aws.String("String"),
		DryRun:         aws.Bool(true),
		PolicyDocument: aws.String("String"),
		RouteTableIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.CreateVpcEndpoint(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateVpcPeeringConnection() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateVpcPeeringConnectionInput{
		DryRun:      aws.Bool(true),
		PeerOwnerId: aws.String("String"),
		PeerVpcId:   aws.String("String"),
		VpcId:       aws.String("String"),
	}
	resp, err := svc.CreateVpcPeeringConnection(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateVpnConnection() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateVpnConnectionInput{
		CustomerGatewayId: aws.String("String"), // Required
		Type:              aws.String("String"), // Required
		VpnGatewayId:      aws.String("String"), // Required
		DryRun:            aws.Bool(true),
		Options: &ec2.VpnConnectionOptionsSpecification{
			StaticRoutesOnly: aws.Bool(true),
		},
	}
	resp, err := svc.CreateVpnConnection(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateVpnConnectionRoute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateVpnConnectionRouteInput{
		DestinationCidrBlock: aws.String("String"), // Required
		VpnConnectionId:      aws.String("String"), // Required
	}
	resp, err := svc.CreateVpnConnectionRoute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_CreateVpnGateway() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.CreateVpnGatewayInput{
		Type:             aws.String("GatewayType"), // Required
		AvailabilityZone: aws.String("String"),
		DryRun:           aws.Bool(true),
	}
	resp, err := svc.CreateVpnGateway(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteCustomerGateway() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteCustomerGatewayInput{
		CustomerGatewayId: aws.String("String"), // Required
		DryRun:            aws.Bool(true),
	}
	resp, err := svc.DeleteCustomerGateway(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteDhcpOptions() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteDhcpOptionsInput{
		DhcpOptionsId: aws.String("String"), // Required
		DryRun:        aws.Bool(true),
	}
	resp, err := svc.DeleteDhcpOptions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteEgressOnlyInternetGateway() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteEgressOnlyInternetGatewayInput{
		EgressOnlyInternetGatewayId: aws.String("EgressOnlyInternetGatewayId"), // Required
		DryRun: aws.Bool(true),
	}
	resp, err := svc.DeleteEgressOnlyInternetGateway(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteFlowLogs() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteFlowLogsInput{
		FlowLogIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DeleteFlowLogs(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteInternetGateway() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteInternetGatewayInput{
		InternetGatewayId: aws.String("String"), // Required
		DryRun:            aws.Bool(true),
	}
	resp, err := svc.DeleteInternetGateway(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteKeyPair() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteKeyPairInput{
		KeyName: aws.String("String"), // Required
		DryRun:  aws.Bool(true),
	}
	resp, err := svc.DeleteKeyPair(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteNatGateway() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteNatGatewayInput{
		NatGatewayId: aws.String("String"), // Required
	}
	resp, err := svc.DeleteNatGateway(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteNetworkAcl() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteNetworkAclInput{
		NetworkAclId: aws.String("String"), // Required
		DryRun:       aws.Bool(true),
	}
	resp, err := svc.DeleteNetworkAcl(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteNetworkAclEntry() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteNetworkAclEntryInput{
		Egress:       aws.Bool(true),       // Required
		NetworkAclId: aws.String("String"), // Required
		RuleNumber:   aws.Int64(1),         // Required
		DryRun:       aws.Bool(true),
	}
	resp, err := svc.DeleteNetworkAclEntry(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteNetworkInterface() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteNetworkInterfaceInput{
		NetworkInterfaceId: aws.String("String"), // Required
		DryRun:             aws.Bool(true),
	}
	resp, err := svc.DeleteNetworkInterface(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeletePlacementGroup() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeletePlacementGroupInput{
		GroupName: aws.String("String"), // Required
		DryRun:    aws.Bool(true),
	}
	resp, err := svc.DeletePlacementGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteRoute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteRouteInput{
		RouteTableId:             aws.String("String"), // Required
		DestinationCidrBlock:     aws.String("String"),
		DestinationIpv6CidrBlock: aws.String("String"),
		DryRun: aws.Bool(true),
	}
	resp, err := svc.DeleteRoute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteRouteTable() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteRouteTableInput{
		RouteTableId: aws.String("String"), // Required
		DryRun:       aws.Bool(true),
	}
	resp, err := svc.DeleteRouteTable(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteSecurityGroup() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteSecurityGroupInput{
		DryRun:    aws.Bool(true),
		GroupId:   aws.String("String"),
		GroupName: aws.String("String"),
	}
	resp, err := svc.DeleteSecurityGroup(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteSnapshot() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteSnapshotInput{
		SnapshotId: aws.String("String"), // Required
		DryRun:     aws.Bool(true),
	}
	resp, err := svc.DeleteSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteSpotDatafeedSubscription() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteSpotDatafeedSubscriptionInput{
		DryRun: aws.Bool(true),
	}
	resp, err := svc.DeleteSpotDatafeedSubscription(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteSubnet() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteSubnetInput{
		SubnetId: aws.String("String"), // Required
		DryRun:   aws.Bool(true),
	}
	resp, err := svc.DeleteSubnet(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteTags() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteTagsInput{
		Resources: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		DryRun: aws.Bool(true),
		Tags: []*ec2.Tag{
			{ // Required
				Key:   aws.String("String"),
				Value: aws.String("String"),
			},
			// More values...
		},
	}
	resp, err := svc.DeleteTags(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteVolume() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteVolumeInput{
		VolumeId: aws.String("String"), // Required
		DryRun:   aws.Bool(true),
	}
	resp, err := svc.DeleteVolume(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteVpc() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteVpcInput{
		VpcId:  aws.String("String"), // Required
		DryRun: aws.Bool(true),
	}
	resp, err := svc.DeleteVpc(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteVpcEndpoints() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteVpcEndpointsInput{
		VpcEndpointIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		DryRun: aws.Bool(true),
	}
	resp, err := svc.DeleteVpcEndpoints(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteVpcPeeringConnection() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteVpcPeeringConnectionInput{
		VpcPeeringConnectionId: aws.String("String"), // Required
		DryRun:                 aws.Bool(true),
	}
	resp, err := svc.DeleteVpcPeeringConnection(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteVpnConnection() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteVpnConnectionInput{
		VpnConnectionId: aws.String("String"), // Required
		DryRun:          aws.Bool(true),
	}
	resp, err := svc.DeleteVpnConnection(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteVpnConnectionRoute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteVpnConnectionRouteInput{
		DestinationCidrBlock: aws.String("String"), // Required
		VpnConnectionId:      aws.String("String"), // Required
	}
	resp, err := svc.DeleteVpnConnectionRoute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeleteVpnGateway() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeleteVpnGatewayInput{
		VpnGatewayId: aws.String("String"), // Required
		DryRun:       aws.Bool(true),
	}
	resp, err := svc.DeleteVpnGateway(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DeregisterImage() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DeregisterImageInput{
		ImageId: aws.String("String"), // Required
		DryRun:  aws.Bool(true),
	}
	resp, err := svc.DeregisterImage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeAccountAttributes() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeAccountAttributesInput{
		AttributeNames: []*string{
			aws.String("AccountAttributeName"), // Required
			// More values...
		},
		DryRun: aws.Bool(true),
	}
	resp, err := svc.DescribeAccountAttributes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeAddresses() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeAddressesInput{
		AllocationIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		PublicIps: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeAddresses(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeAvailabilityZones() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeAvailabilityZonesInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		ZoneNames: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeAvailabilityZones(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeBundleTasks() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeBundleTasksInput{
		BundleIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
	}
	resp, err := svc.DescribeBundleTasks(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeClassicLinkInstances() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeClassicLinkInstancesInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		InstanceIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
	}
	resp, err := svc.DescribeClassicLinkInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeConversionTasks() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeConversionTasksInput{
		ConversionTaskIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		DryRun: aws.Bool(true),
	}
	resp, err := svc.DescribeConversionTasks(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeCustomerGateways() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeCustomerGatewaysInput{
		CustomerGatewayIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
	}
	resp, err := svc.DescribeCustomerGateways(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeDhcpOptions() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeDhcpOptionsInput{
		DhcpOptionsIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
	}
	resp, err := svc.DescribeDhcpOptions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeEgressOnlyInternetGateways() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeEgressOnlyInternetGatewaysInput{
		DryRun: aws.Bool(true),
		EgressOnlyInternetGatewayIds: []*string{
			aws.String("EgressOnlyInternetGatewayId"), // Required
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
	}
	resp, err := svc.DescribeEgressOnlyInternetGateways(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeExportTasks() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeExportTasksInput{
		ExportTaskIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeExportTasks(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeFlowLogs() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeFlowLogsInput{
		Filter: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		FlowLogIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
	}
	resp, err := svc.DescribeFlowLogs(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeHostReservationOfferings() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeHostReservationOfferingsInput{
		Filter: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxDuration: aws.Int64(1),
		MaxResults:  aws.Int64(1),
		MinDuration: aws.Int64(1),
		NextToken:   aws.String("String"),
		OfferingId:  aws.String("String"),
	}
	resp, err := svc.DescribeHostReservationOfferings(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeHostReservations() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeHostReservationsInput{
		Filter: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		HostReservationIdSet: []*string{
			aws.String("String"), // Required
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
	}
	resp, err := svc.DescribeHostReservations(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeHosts() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeHostsInput{
		Filter: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		HostIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
	}
	resp, err := svc.DescribeHosts(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeIdFormat() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeIdFormatInput{
		Resource: aws.String("String"),
	}
	resp, err := svc.DescribeIdFormat(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeIdentityIdFormat() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeIdentityIdFormatInput{
		PrincipalArn: aws.String("String"), // Required
		Resource:     aws.String("String"),
	}
	resp, err := svc.DescribeIdentityIdFormat(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeImageAttribute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeImageAttributeInput{
		Attribute: aws.String("ImageAttributeName"), // Required
		ImageId:   aws.String("String"),             // Required
		DryRun:    aws.Bool(true),
	}
	resp, err := svc.DescribeImageAttribute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeImages() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeImagesInput{
		DryRun: aws.Bool(true),
		ExecutableUsers: []*string{
			aws.String("String"), // Required
			// More values...
		},
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		ImageIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		Owners: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeImages(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeImportImageTasks() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeImportImageTasksInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		ImportTaskIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
	}
	resp, err := svc.DescribeImportImageTasks(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeImportSnapshotTasks() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeImportSnapshotTasksInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		ImportTaskIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
	}
	resp, err := svc.DescribeImportSnapshotTasks(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeInstanceAttribute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeInstanceAttributeInput{
		Attribute:  aws.String("InstanceAttributeName"), // Required
		InstanceId: aws.String("String"),                // Required
		DryRun:     aws.Bool(true),
	}
	resp, err := svc.DescribeInstanceAttribute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeInstanceStatus() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeInstanceStatusInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		IncludeAllInstances: aws.Bool(true),
		InstanceIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
	}
	resp, err := svc.DescribeInstanceStatus(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeInstances() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeInstancesInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		InstanceIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
	}
	resp, err := svc.DescribeInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeInternetGateways() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeInternetGatewaysInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		InternetGatewayIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeInternetGateways(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeKeyPairs() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeKeyPairsInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		KeyNames: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeKeyPairs(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeMovingAddresses() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeMovingAddressesInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
		PublicIps: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeMovingAddresses(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeNatGateways() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeNatGatewaysInput{
		Filter: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NatGatewayIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		NextToken: aws.String("String"),
	}
	resp, err := svc.DescribeNatGateways(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeNetworkAcls() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeNetworkAclsInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		NetworkAclIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeNetworkAcls(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeNetworkInterfaceAttribute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeNetworkInterfaceAttributeInput{
		NetworkInterfaceId: aws.String("String"), // Required
		Attribute:          aws.String("NetworkInterfaceAttribute"),
		DryRun:             aws.Bool(true),
	}
	resp, err := svc.DescribeNetworkInterfaceAttribute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeNetworkInterfaces() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeNetworkInterfacesInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		NetworkInterfaceIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeNetworkInterfaces(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribePlacementGroups() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribePlacementGroupsInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		GroupNames: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribePlacementGroups(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribePrefixLists() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribePrefixListsInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
		PrefixListIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribePrefixLists(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeRegions() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeRegionsInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		RegionNames: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeRegions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeReservedInstances() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeReservedInstancesInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		OfferingClass: aws.String("OfferingClassType"),
		OfferingType:  aws.String("OfferingTypeValues"),
		ReservedInstancesIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeReservedInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeReservedInstancesListings() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeReservedInstancesListingsInput{
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		ReservedInstancesId:        aws.String("String"),
		ReservedInstancesListingId: aws.String("String"),
	}
	resp, err := svc.DescribeReservedInstancesListings(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeReservedInstancesModifications() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeReservedInstancesModificationsInput{
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		NextToken: aws.String("String"),
		ReservedInstancesModificationIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeReservedInstancesModifications(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeReservedInstancesOfferings() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeReservedInstancesOfferingsInput{
		AvailabilityZone: aws.String("String"),
		DryRun:           aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		IncludeMarketplace: aws.Bool(true),
		InstanceTenancy:    aws.String("Tenancy"),
		InstanceType:       aws.String("InstanceType"),
		MaxDuration:        aws.Int64(1),
		MaxInstanceCount:   aws.Int64(1),
		MaxResults:         aws.Int64(1),
		MinDuration:        aws.Int64(1),
		NextToken:          aws.String("String"),
		OfferingClass:      aws.String("OfferingClassType"),
		OfferingType:       aws.String("OfferingTypeValues"),
		ProductDescription: aws.String("RIProductDescription"),
		ReservedInstancesOfferingIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeReservedInstancesOfferings(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeRouteTables() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeRouteTablesInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		RouteTableIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeRouteTables(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeScheduledInstanceAvailability() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeScheduledInstanceAvailabilityInput{
		FirstSlotStartTimeRange: &ec2.SlotDateTimeRangeRequest{ // Required
			EarliestTime: aws.Time(time.Now()), // Required
			LatestTime:   aws.Time(time.Now()), // Required
		},
		Recurrence: &ec2.ScheduledInstanceRecurrenceRequest{ // Required
			Frequency: aws.String("String"),
			Interval:  aws.Int64(1),
			OccurrenceDays: []*int64{
				aws.Int64(1), // Required
				// More values...
			},
			OccurrenceRelativeToEnd: aws.Bool(true),
			OccurrenceUnit:          aws.String("String"),
		},
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults:             aws.Int64(1),
		MaxSlotDurationInHours: aws.Int64(1),
		MinSlotDurationInHours: aws.Int64(1),
		NextToken:              aws.String("String"),
	}
	resp, err := svc.DescribeScheduledInstanceAvailability(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeScheduledInstances() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeScheduledInstancesInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
		ScheduledInstanceIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		SlotStartTimeRange: &ec2.SlotStartTimeRangeRequest{
			EarliestTime: aws.Time(time.Now()),
			LatestTime:   aws.Time(time.Now()),
		},
	}
	resp, err := svc.DescribeScheduledInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeSecurityGroupReferences() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeSecurityGroupReferencesInput{
		GroupId: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		DryRun: aws.Bool(true),
	}
	resp, err := svc.DescribeSecurityGroupReferences(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeSecurityGroups() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeSecurityGroupsInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		GroupIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		GroupNames: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeSecurityGroups(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeSnapshotAttribute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeSnapshotAttributeInput{
		Attribute:  aws.String("SnapshotAttributeName"), // Required
		SnapshotId: aws.String("String"),                // Required
		DryRun:     aws.Bool(true),
	}
	resp, err := svc.DescribeSnapshotAttribute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeSnapshots() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeSnapshotsInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
		OwnerIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		RestorableByUserIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		SnapshotIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeSnapshots(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeSpotDatafeedSubscription() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeSpotDatafeedSubscriptionInput{
		DryRun: aws.Bool(true),
	}
	resp, err := svc.DescribeSpotDatafeedSubscription(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeSpotFleetInstances() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeSpotFleetInstancesInput{
		SpotFleetRequestId: aws.String("String"), // Required
		DryRun:             aws.Bool(true),
		MaxResults:         aws.Int64(1),
		NextToken:          aws.String("String"),
	}
	resp, err := svc.DescribeSpotFleetInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeSpotFleetRequestHistory() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeSpotFleetRequestHistoryInput{
		SpotFleetRequestId: aws.String("String"), // Required
		StartTime:          aws.Time(time.Now()), // Required
		DryRun:             aws.Bool(true),
		EventType:          aws.String("EventType"),
		MaxResults:         aws.Int64(1),
		NextToken:          aws.String("String"),
	}
	resp, err := svc.DescribeSpotFleetRequestHistory(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeSpotFleetRequests() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeSpotFleetRequestsInput{
		DryRun:     aws.Bool(true),
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
		SpotFleetRequestIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeSpotFleetRequests(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeSpotInstanceRequests() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeSpotInstanceRequestsInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		SpotInstanceRequestIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeSpotInstanceRequests(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeSpotPriceHistory() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeSpotPriceHistoryInput{
		AvailabilityZone: aws.String("String"),
		DryRun:           aws.Bool(true),
		EndTime:          aws.Time(time.Now()),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		InstanceTypes: []*string{
			aws.String("InstanceType"), // Required
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
		ProductDescriptions: []*string{
			aws.String("String"), // Required
			// More values...
		},
		StartTime: aws.Time(time.Now()),
	}
	resp, err := svc.DescribeSpotPriceHistory(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeStaleSecurityGroups() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeStaleSecurityGroupsInput{
		VpcId:      aws.String("String"), // Required
		DryRun:     aws.Bool(true),
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
	}
	resp, err := svc.DescribeStaleSecurityGroups(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeSubnets() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeSubnetsInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		SubnetIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeSubnets(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeTags() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeTagsInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
	}
	resp, err := svc.DescribeTags(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeVolumeAttribute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeVolumeAttributeInput{
		VolumeId:  aws.String("String"), // Required
		Attribute: aws.String("VolumeAttributeName"),
		DryRun:    aws.Bool(true),
	}
	resp, err := svc.DescribeVolumeAttribute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeVolumeStatus() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeVolumeStatusInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
		VolumeIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeVolumeStatus(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeVolumes() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeVolumesInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
		VolumeIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeVolumes(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeVpcAttribute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeVpcAttributeInput{
		Attribute: aws.String("VpcAttributeName"), // Required
		VpcId:     aws.String("String"),           // Required
		DryRun:    aws.Bool(true),
	}
	resp, err := svc.DescribeVpcAttribute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeVpcClassicLink() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeVpcClassicLinkInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		VpcIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeVpcClassicLink(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeVpcClassicLinkDnsSupport() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeVpcClassicLinkDnsSupportInput{
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("NextToken"),
		VpcIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeVpcClassicLinkDnsSupport(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeVpcEndpointServices() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeVpcEndpointServicesInput{
		DryRun:     aws.Bool(true),
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
	}
	resp, err := svc.DescribeVpcEndpointServices(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeVpcEndpoints() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeVpcEndpointsInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		MaxResults: aws.Int64(1),
		NextToken:  aws.String("String"),
		VpcEndpointIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeVpcEndpoints(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeVpcPeeringConnections() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeVpcPeeringConnectionsInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		VpcPeeringConnectionIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeVpcPeeringConnections(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeVpcs() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeVpcsInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		VpcIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeVpcs(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeVpnConnections() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeVpnConnectionsInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		VpnConnectionIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeVpnConnections(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DescribeVpnGateways() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DescribeVpnGatewaysInput{
		DryRun: aws.Bool(true),
		Filters: []*ec2.Filter{
			{ // Required
				Name: aws.String("String"),
				Values: []*string{
					aws.String("String"), // Required
					// More values...
				},
			},
			// More values...
		},
		VpnGatewayIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.DescribeVpnGateways(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DetachClassicLinkVpc() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DetachClassicLinkVpcInput{
		InstanceId: aws.String("String"), // Required
		VpcId:      aws.String("String"), // Required
		DryRun:     aws.Bool(true),
	}
	resp, err := svc.DetachClassicLinkVpc(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DetachInternetGateway() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DetachInternetGatewayInput{
		InternetGatewayId: aws.String("String"), // Required
		VpcId:             aws.String("String"), // Required
		DryRun:            aws.Bool(true),
	}
	resp, err := svc.DetachInternetGateway(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DetachNetworkInterface() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DetachNetworkInterfaceInput{
		AttachmentId: aws.String("String"), // Required
		DryRun:       aws.Bool(true),
		Force:        aws.Bool(true),
	}
	resp, err := svc.DetachNetworkInterface(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DetachVolume() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DetachVolumeInput{
		VolumeId:   aws.String("String"), // Required
		Device:     aws.String("String"),
		DryRun:     aws.Bool(true),
		Force:      aws.Bool(true),
		InstanceId: aws.String("String"),
	}
	resp, err := svc.DetachVolume(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DetachVpnGateway() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DetachVpnGatewayInput{
		VpcId:        aws.String("String"), // Required
		VpnGatewayId: aws.String("String"), // Required
		DryRun:       aws.Bool(true),
	}
	resp, err := svc.DetachVpnGateway(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DisableVgwRoutePropagation() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DisableVgwRoutePropagationInput{
		GatewayId:    aws.String("String"), // Required
		RouteTableId: aws.String("String"), // Required
	}
	resp, err := svc.DisableVgwRoutePropagation(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DisableVpcClassicLink() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DisableVpcClassicLinkInput{
		VpcId:  aws.String("String"), // Required
		DryRun: aws.Bool(true),
	}
	resp, err := svc.DisableVpcClassicLink(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DisableVpcClassicLinkDnsSupport() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DisableVpcClassicLinkDnsSupportInput{
		VpcId: aws.String("String"),
	}
	resp, err := svc.DisableVpcClassicLinkDnsSupport(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DisassociateAddress() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DisassociateAddressInput{
		AssociationId: aws.String("String"),
		DryRun:        aws.Bool(true),
		PublicIp:      aws.String("String"),
	}
	resp, err := svc.DisassociateAddress(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DisassociateRouteTable() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DisassociateRouteTableInput{
		AssociationId: aws.String("String"), // Required
		DryRun:        aws.Bool(true),
	}
	resp, err := svc.DisassociateRouteTable(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DisassociateSubnetCidrBlock() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DisassociateSubnetCidrBlockInput{
		AssociationId: aws.String("String"), // Required
	}
	resp, err := svc.DisassociateSubnetCidrBlock(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_DisassociateVpcCidrBlock() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.DisassociateVpcCidrBlockInput{
		AssociationId: aws.String("String"), // Required
	}
	resp, err := svc.DisassociateVpcCidrBlock(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_EnableVgwRoutePropagation() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.EnableVgwRoutePropagationInput{
		GatewayId:    aws.String("String"), // Required
		RouteTableId: aws.String("String"), // Required
	}
	resp, err := svc.EnableVgwRoutePropagation(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_EnableVolumeIO() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.EnableVolumeIOInput{
		VolumeId: aws.String("String"), // Required
		DryRun:   aws.Bool(true),
	}
	resp, err := svc.EnableVolumeIO(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_EnableVpcClassicLink() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.EnableVpcClassicLinkInput{
		VpcId:  aws.String("String"), // Required
		DryRun: aws.Bool(true),
	}
	resp, err := svc.EnableVpcClassicLink(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_EnableVpcClassicLinkDnsSupport() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.EnableVpcClassicLinkDnsSupportInput{
		VpcId: aws.String("String"),
	}
	resp, err := svc.EnableVpcClassicLinkDnsSupport(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_GetConsoleOutput() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.GetConsoleOutputInput{
		InstanceId: aws.String("String"), // Required
		DryRun:     aws.Bool(true),
	}
	resp, err := svc.GetConsoleOutput(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_GetConsoleScreenshot() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.GetConsoleScreenshotInput{
		InstanceId: aws.String("String"), // Required
		DryRun:     aws.Bool(true),
		WakeUp:     aws.Bool(true),
	}
	resp, err := svc.GetConsoleScreenshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_GetHostReservationPurchasePreview() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.GetHostReservationPurchasePreviewInput{
		HostIdSet: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		OfferingId: aws.String("String"), // Required
	}
	resp, err := svc.GetHostReservationPurchasePreview(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_GetPasswordData() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.GetPasswordDataInput{
		InstanceId: aws.String("String"), // Required
		DryRun:     aws.Bool(true),
	}
	resp, err := svc.GetPasswordData(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_GetReservedInstancesExchangeQuote() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.GetReservedInstancesExchangeQuoteInput{
		ReservedInstanceIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		DryRun: aws.Bool(true),
		TargetConfigurations: []*ec2.TargetConfigurationRequest{
			{ // Required
				OfferingId:    aws.String("String"), // Required
				InstanceCount: aws.Int64(1),
			},
			// More values...
		},
	}
	resp, err := svc.GetReservedInstancesExchangeQuote(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ImportImage() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ImportImageInput{
		Architecture: aws.String("String"),
		ClientData: &ec2.ClientData{
			Comment:     aws.String("String"),
			UploadEnd:   aws.Time(time.Now()),
			UploadSize:  aws.Float64(1.0),
			UploadStart: aws.Time(time.Now()),
		},
		ClientToken: aws.String("String"),
		Description: aws.String("String"),
		DiskContainers: []*ec2.ImageDiskContainer{
			{ // Required
				Description: aws.String("String"),
				DeviceName:  aws.String("String"),
				Format:      aws.String("String"),
				SnapshotId:  aws.String("String"),
				Url:         aws.String("String"),
				UserBucket: &ec2.UserBucket{
					S3Bucket: aws.String("String"),
					S3Key:    aws.String("String"),
				},
			},
			// More values...
		},
		DryRun:      aws.Bool(true),
		Hypervisor:  aws.String("String"),
		LicenseType: aws.String("String"),
		Platform:    aws.String("String"),
		RoleName:    aws.String("String"),
	}
	resp, err := svc.ImportImage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ImportInstance() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ImportInstanceInput{
		Platform:    aws.String("PlatformValues"), // Required
		Description: aws.String("String"),
		DiskImages: []*ec2.DiskImage{
			{ // Required
				Description: aws.String("String"),
				Image: &ec2.DiskImageDetail{
					Bytes:             aws.Int64(1),                  // Required
					Format:            aws.String("DiskImageFormat"), // Required
					ImportManifestUrl: aws.String("String"),          // Required
				},
				Volume: &ec2.VolumeDetail{
					Size: aws.Int64(1), // Required
				},
			},
			// More values...
		},
		DryRun: aws.Bool(true),
		LaunchSpecification: &ec2.ImportInstanceLaunchSpecification{
			AdditionalInfo: aws.String("String"),
			Architecture:   aws.String("ArchitectureValues"),
			GroupIds: []*string{
				aws.String("String"), // Required
				// More values...
			},
			GroupNames: []*string{
				aws.String("String"), // Required
				// More values...
			},
			InstanceInitiatedShutdownBehavior: aws.String("ShutdownBehavior"),
			InstanceType:                      aws.String("InstanceType"),
			Monitoring:                        aws.Bool(true),
			Placement: &ec2.Placement{
				Affinity:         aws.String("String"),
				AvailabilityZone: aws.String("String"),
				GroupName:        aws.String("String"),
				HostId:           aws.String("String"),
				Tenancy:          aws.String("Tenancy"),
			},
			PrivateIpAddress: aws.String("String"),
			SubnetId:         aws.String("String"),
			UserData: &ec2.UserData{
				Data: aws.String("String"),
			},
		},
	}
	resp, err := svc.ImportInstance(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ImportKeyPair() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ImportKeyPairInput{
		KeyName:           aws.String("String"), // Required
		PublicKeyMaterial: []byte("PAYLOAD"),    // Required
		DryRun:            aws.Bool(true),
	}
	resp, err := svc.ImportKeyPair(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ImportSnapshot() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ImportSnapshotInput{
		ClientData: &ec2.ClientData{
			Comment:     aws.String("String"),
			UploadEnd:   aws.Time(time.Now()),
			UploadSize:  aws.Float64(1.0),
			UploadStart: aws.Time(time.Now()),
		},
		ClientToken: aws.String("String"),
		Description: aws.String("String"),
		DiskContainer: &ec2.SnapshotDiskContainer{
			Description: aws.String("String"),
			Format:      aws.String("String"),
			Url:         aws.String("String"),
			UserBucket: &ec2.UserBucket{
				S3Bucket: aws.String("String"),
				S3Key:    aws.String("String"),
			},
		},
		DryRun:   aws.Bool(true),
		RoleName: aws.String("String"),
	}
	resp, err := svc.ImportSnapshot(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ImportVolume() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ImportVolumeInput{
		AvailabilityZone: aws.String("String"), // Required
		Image: &ec2.DiskImageDetail{ // Required
			Bytes:             aws.Int64(1),                  // Required
			Format:            aws.String("DiskImageFormat"), // Required
			ImportManifestUrl: aws.String("String"),          // Required
		},
		Volume: &ec2.VolumeDetail{ // Required
			Size: aws.Int64(1), // Required
		},
		Description: aws.String("String"),
		DryRun:      aws.Bool(true),
	}
	resp, err := svc.ImportVolume(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ModifyHosts() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ModifyHostsInput{
		AutoPlacement: aws.String("AutoPlacement"), // Required
		HostIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.ModifyHosts(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ModifyIdFormat() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ModifyIdFormatInput{
		Resource:   aws.String("String"), // Required
		UseLongIds: aws.Bool(true),       // Required
	}
	resp, err := svc.ModifyIdFormat(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ModifyIdentityIdFormat() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ModifyIdentityIdFormatInput{
		PrincipalArn: aws.String("String"), // Required
		Resource:     aws.String("String"), // Required
		UseLongIds:   aws.Bool(true),       // Required
	}
	resp, err := svc.ModifyIdentityIdFormat(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ModifyImageAttribute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ModifyImageAttributeInput{
		ImageId:   aws.String("String"), // Required
		Attribute: aws.String("String"),
		Description: &ec2.AttributeValue{
			Value: aws.String("String"),
		},
		DryRun: aws.Bool(true),
		LaunchPermission: &ec2.LaunchPermissionModifications{
			Add: []*ec2.LaunchPermission{
				{ // Required
					Group:  aws.String("PermissionGroup"),
					UserId: aws.String("String"),
				},
				// More values...
			},
			Remove: []*ec2.LaunchPermission{
				{ // Required
					Group:  aws.String("PermissionGroup"),
					UserId: aws.String("String"),
				},
				// More values...
			},
		},
		OperationType: aws.String("OperationType"),
		ProductCodes: []*string{
			aws.String("String"), // Required
			// More values...
		},
		UserGroups: []*string{
			aws.String("String"), // Required
			// More values...
		},
		UserIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		Value: aws.String("String"),
	}
	resp, err := svc.ModifyImageAttribute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ModifyInstanceAttribute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ModifyInstanceAttributeInput{
		InstanceId: aws.String("String"), // Required
		Attribute:  aws.String("InstanceAttributeName"),
		BlockDeviceMappings: []*ec2.InstanceBlockDeviceMappingSpecification{
			{ // Required
				DeviceName: aws.String("String"),
				Ebs: &ec2.EbsInstanceBlockDeviceSpecification{
					DeleteOnTermination: aws.Bool(true),
					VolumeId:            aws.String("String"),
				},
				NoDevice:    aws.String("String"),
				VirtualName: aws.String("String"),
			},
			// More values...
		},
		DisableApiTermination: &ec2.AttributeBooleanValue{
			Value: aws.Bool(true),
		},
		DryRun: aws.Bool(true),
		EbsOptimized: &ec2.AttributeBooleanValue{
			Value: aws.Bool(true),
		},
		EnaSupport: &ec2.AttributeBooleanValue{
			Value: aws.Bool(true),
		},
		Groups: []*string{
			aws.String("String"), // Required
			// More values...
		},
		InstanceInitiatedShutdownBehavior: &ec2.AttributeValue{
			Value: aws.String("String"),
		},
		InstanceType: &ec2.AttributeValue{
			Value: aws.String("String"),
		},
		Kernel: &ec2.AttributeValue{
			Value: aws.String("String"),
		},
		Ramdisk: &ec2.AttributeValue{
			Value: aws.String("String"),
		},
		SourceDestCheck: &ec2.AttributeBooleanValue{
			Value: aws.Bool(true),
		},
		SriovNetSupport: &ec2.AttributeValue{
			Value: aws.String("String"),
		},
		UserData: &ec2.BlobAttributeValue{
			Value: []byte("PAYLOAD"),
		},
		Value: aws.String("String"),
	}
	resp, err := svc.ModifyInstanceAttribute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ModifyInstancePlacement() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ModifyInstancePlacementInput{
		InstanceId: aws.String("String"), // Required
		Affinity:   aws.String("Affinity"),
		HostId:     aws.String("String"),
		Tenancy:    aws.String("HostTenancy"),
	}
	resp, err := svc.ModifyInstancePlacement(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ModifyNetworkInterfaceAttribute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ModifyNetworkInterfaceAttributeInput{
		NetworkInterfaceId: aws.String("String"), // Required
		Attachment: &ec2.NetworkInterfaceAttachmentChanges{
			AttachmentId:        aws.String("String"),
			DeleteOnTermination: aws.Bool(true),
		},
		Description: &ec2.AttributeValue{
			Value: aws.String("String"),
		},
		DryRun: aws.Bool(true),
		Groups: []*string{
			aws.String("String"), // Required
			// More values...
		},
		SourceDestCheck: &ec2.AttributeBooleanValue{
			Value: aws.Bool(true),
		},
	}
	resp, err := svc.ModifyNetworkInterfaceAttribute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ModifyReservedInstances() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ModifyReservedInstancesInput{
		ReservedInstancesIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		TargetConfigurations: []*ec2.ReservedInstancesConfiguration{ // Required
			{ // Required
				AvailabilityZone: aws.String("String"),
				InstanceCount:    aws.Int64(1),
				InstanceType:     aws.String("InstanceType"),
				Platform:         aws.String("String"),
				Scope:            aws.String("scope"),
			},
			// More values...
		},
		ClientToken: aws.String("String"),
	}
	resp, err := svc.ModifyReservedInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ModifySnapshotAttribute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ModifySnapshotAttributeInput{
		SnapshotId: aws.String("String"), // Required
		Attribute:  aws.String("SnapshotAttributeName"),
		CreateVolumePermission: &ec2.CreateVolumePermissionModifications{
			Add: []*ec2.CreateVolumePermission{
				{ // Required
					Group:  aws.String("PermissionGroup"),
					UserId: aws.String("String"),
				},
				// More values...
			},
			Remove: []*ec2.CreateVolumePermission{
				{ // Required
					Group:  aws.String("PermissionGroup"),
					UserId: aws.String("String"),
				},
				// More values...
			},
		},
		DryRun: aws.Bool(true),
		GroupNames: []*string{
			aws.String("String"), // Required
			// More values...
		},
		OperationType: aws.String("OperationType"),
		UserIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.ModifySnapshotAttribute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ModifySpotFleetRequest() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ModifySpotFleetRequestInput{
		SpotFleetRequestId:              aws.String("String"), // Required
		ExcessCapacityTerminationPolicy: aws.String("ExcessCapacityTerminationPolicy"),
		TargetCapacity:                  aws.Int64(1),
	}
	resp, err := svc.ModifySpotFleetRequest(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ModifySubnetAttribute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ModifySubnetAttributeInput{
		SubnetId: aws.String("String"), // Required
		AssignIpv6AddressOnCreation: &ec2.AttributeBooleanValue{
			Value: aws.Bool(true),
		},
		MapPublicIpOnLaunch: &ec2.AttributeBooleanValue{
			Value: aws.Bool(true),
		},
	}
	resp, err := svc.ModifySubnetAttribute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ModifyVolumeAttribute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ModifyVolumeAttributeInput{
		VolumeId: aws.String("String"), // Required
		AutoEnableIO: &ec2.AttributeBooleanValue{
			Value: aws.Bool(true),
		},
		DryRun: aws.Bool(true),
	}
	resp, err := svc.ModifyVolumeAttribute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ModifyVpcAttribute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ModifyVpcAttributeInput{
		VpcId: aws.String("String"), // Required
		EnableDnsHostnames: &ec2.AttributeBooleanValue{
			Value: aws.Bool(true),
		},
		EnableDnsSupport: &ec2.AttributeBooleanValue{
			Value: aws.Bool(true),
		},
	}
	resp, err := svc.ModifyVpcAttribute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ModifyVpcEndpoint() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ModifyVpcEndpointInput{
		VpcEndpointId: aws.String("String"), // Required
		AddRouteTableIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		DryRun:         aws.Bool(true),
		PolicyDocument: aws.String("String"),
		RemoveRouteTableIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		ResetPolicy: aws.Bool(true),
	}
	resp, err := svc.ModifyVpcEndpoint(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ModifyVpcPeeringConnectionOptions() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ModifyVpcPeeringConnectionOptionsInput{
		VpcPeeringConnectionId: aws.String("String"), // Required
		AccepterPeeringConnectionOptions: &ec2.PeeringConnectionOptionsRequest{
			AllowDnsResolutionFromRemoteVpc:            aws.Bool(true),
			AllowEgressFromLocalClassicLinkToRemoteVpc: aws.Bool(true),
			AllowEgressFromLocalVpcToRemoteClassicLink: aws.Bool(true),
		},
		DryRun: aws.Bool(true),
		RequesterPeeringConnectionOptions: &ec2.PeeringConnectionOptionsRequest{
			AllowDnsResolutionFromRemoteVpc:            aws.Bool(true),
			AllowEgressFromLocalClassicLinkToRemoteVpc: aws.Bool(true),
			AllowEgressFromLocalVpcToRemoteClassicLink: aws.Bool(true),
		},
	}
	resp, err := svc.ModifyVpcPeeringConnectionOptions(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_MonitorInstances() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.MonitorInstancesInput{
		InstanceIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		DryRun: aws.Bool(true),
	}
	resp, err := svc.MonitorInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_MoveAddressToVpc() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.MoveAddressToVpcInput{
		PublicIp: aws.String("String"), // Required
		DryRun:   aws.Bool(true),
	}
	resp, err := svc.MoveAddressToVpc(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_PurchaseHostReservation() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.PurchaseHostReservationInput{
		HostIdSet: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		OfferingId:   aws.String("String"), // Required
		ClientToken:  aws.String("String"),
		CurrencyCode: aws.String("CurrencyCodeValues"),
		LimitPrice:   aws.String("String"),
	}
	resp, err := svc.PurchaseHostReservation(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_PurchaseReservedInstancesOffering() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.PurchaseReservedInstancesOfferingInput{
		InstanceCount:               aws.Int64(1),         // Required
		ReservedInstancesOfferingId: aws.String("String"), // Required
		DryRun: aws.Bool(true),
		LimitPrice: &ec2.ReservedInstanceLimitPrice{
			Amount:       aws.Float64(1.0),
			CurrencyCode: aws.String("CurrencyCodeValues"),
		},
	}
	resp, err := svc.PurchaseReservedInstancesOffering(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_PurchaseScheduledInstances() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.PurchaseScheduledInstancesInput{
		PurchaseRequests: []*ec2.PurchaseRequest{ // Required
			{ // Required
				InstanceCount: aws.Int64(1),         // Required
				PurchaseToken: aws.String("String"), // Required
			},
			// More values...
		},
		ClientToken: aws.String("String"),
		DryRun:      aws.Bool(true),
	}
	resp, err := svc.PurchaseScheduledInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_RebootInstances() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.RebootInstancesInput{
		InstanceIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		DryRun: aws.Bool(true),
	}
	resp, err := svc.RebootInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_RegisterImage() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.RegisterImageInput{
		Name:         aws.String("String"), // Required
		Architecture: aws.String("ArchitectureValues"),
		BlockDeviceMappings: []*ec2.BlockDeviceMapping{
			{ // Required
				DeviceName: aws.String("String"),
				Ebs: &ec2.EbsBlockDevice{
					DeleteOnTermination: aws.Bool(true),
					Encrypted:           aws.Bool(true),
					Iops:                aws.Int64(1),
					SnapshotId:          aws.String("String"),
					VolumeSize:          aws.Int64(1),
					VolumeType:          aws.String("VolumeType"),
				},
				NoDevice:    aws.String("String"),
				VirtualName: aws.String("String"),
			},
			// More values...
		},
		Description:        aws.String("String"),
		DryRun:             aws.Bool(true),
		EnaSupport:         aws.Bool(true),
		ImageLocation:      aws.String("String"),
		KernelId:           aws.String("String"),
		RamdiskId:          aws.String("String"),
		RootDeviceName:     aws.String("String"),
		SriovNetSupport:    aws.String("String"),
		VirtualizationType: aws.String("String"),
	}
	resp, err := svc.RegisterImage(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_RejectVpcPeeringConnection() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.RejectVpcPeeringConnectionInput{
		VpcPeeringConnectionId: aws.String("String"), // Required
		DryRun:                 aws.Bool(true),
	}
	resp, err := svc.RejectVpcPeeringConnection(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ReleaseAddress() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ReleaseAddressInput{
		AllocationId: aws.String("String"),
		DryRun:       aws.Bool(true),
		PublicIp:     aws.String("String"),
	}
	resp, err := svc.ReleaseAddress(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ReleaseHosts() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ReleaseHostsInput{
		HostIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.ReleaseHosts(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ReplaceNetworkAclAssociation() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ReplaceNetworkAclAssociationInput{
		AssociationId: aws.String("String"), // Required
		NetworkAclId:  aws.String("String"), // Required
		DryRun:        aws.Bool(true),
	}
	resp, err := svc.ReplaceNetworkAclAssociation(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ReplaceNetworkAclEntry() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ReplaceNetworkAclEntryInput{
		Egress:       aws.Bool(true),           // Required
		NetworkAclId: aws.String("String"),     // Required
		Protocol:     aws.String("String"),     // Required
		RuleAction:   aws.String("RuleAction"), // Required
		RuleNumber:   aws.Int64(1),             // Required
		CidrBlock:    aws.String("String"),
		DryRun:       aws.Bool(true),
		IcmpTypeCode: &ec2.IcmpTypeCode{
			Code: aws.Int64(1),
			Type: aws.Int64(1),
		},
		Ipv6CidrBlock: aws.String("String"),
		PortRange: &ec2.PortRange{
			From: aws.Int64(1),
			To:   aws.Int64(1),
		},
	}
	resp, err := svc.ReplaceNetworkAclEntry(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ReplaceRoute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ReplaceRouteInput{
		RouteTableId:             aws.String("String"), // Required
		DestinationCidrBlock:     aws.String("String"),
		DestinationIpv6CidrBlock: aws.String("String"),
		DryRun: aws.Bool(true),
		EgressOnlyInternetGatewayId: aws.String("String"),
		GatewayId:                   aws.String("String"),
		InstanceId:                  aws.String("String"),
		NatGatewayId:                aws.String("String"),
		NetworkInterfaceId:          aws.String("String"),
		VpcPeeringConnectionId:      aws.String("String"),
	}
	resp, err := svc.ReplaceRoute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ReplaceRouteTableAssociation() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ReplaceRouteTableAssociationInput{
		AssociationId: aws.String("String"), // Required
		RouteTableId:  aws.String("String"), // Required
		DryRun:        aws.Bool(true),
	}
	resp, err := svc.ReplaceRouteTableAssociation(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ReportInstanceStatus() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ReportInstanceStatusInput{
		Instances: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		ReasonCodes: []*string{ // Required
			aws.String("ReportInstanceReasonCodes"), // Required
			// More values...
		},
		Status:      aws.String("ReportStatusType"), // Required
		Description: aws.String("String"),
		DryRun:      aws.Bool(true),
		EndTime:     aws.Time(time.Now()),
		StartTime:   aws.Time(time.Now()),
	}
	resp, err := svc.ReportInstanceStatus(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_RequestSpotFleet() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.RequestSpotFleetInput{
		SpotFleetRequestConfig: &ec2.SpotFleetRequestConfigData{ // Required
			IamFleetRole: aws.String("String"), // Required
			LaunchSpecifications: []*ec2.SpotFleetLaunchSpecification{ // Required
				{ // Required
					AddressingType: aws.String("String"),
					BlockDeviceMappings: []*ec2.BlockDeviceMapping{
						{ // Required
							DeviceName: aws.String("String"),
							Ebs: &ec2.EbsBlockDevice{
								DeleteOnTermination: aws.Bool(true),
								Encrypted:           aws.Bool(true),
								Iops:                aws.Int64(1),
								SnapshotId:          aws.String("String"),
								VolumeSize:          aws.Int64(1),
								VolumeType:          aws.String("VolumeType"),
							},
							NoDevice:    aws.String("String"),
							VirtualName: aws.String("String"),
						},
						// More values...
					},
					EbsOptimized: aws.Bool(true),
					IamInstanceProfile: &ec2.IamInstanceProfileSpecification{
						Arn:  aws.String("String"),
						Name: aws.String("String"),
					},
					ImageId:      aws.String("String"),
					InstanceType: aws.String("InstanceType"),
					KernelId:     aws.String("String"),
					KeyName:      aws.String("String"),
					Monitoring: &ec2.SpotFleetMonitoring{
						Enabled: aws.Bool(true),
					},
					NetworkInterfaces: []*ec2.InstanceNetworkInterfaceSpecification{
						{ // Required
							AssociatePublicIpAddress: aws.Bool(true),
							DeleteOnTermination:      aws.Bool(true),
							Description:              aws.String("String"),
							DeviceIndex:              aws.Int64(1),
							Groups: []*string{
								aws.String("String"), // Required
								// More values...
							},
							Ipv6AddressCount: aws.Int64(1),
							Ipv6Addresses: []*ec2.InstanceIpv6Address{
								{ // Required
									Ipv6Address: aws.String("String"),
								},
								// More values...
							},
							NetworkInterfaceId: aws.String("String"),
							PrivateIpAddress:   aws.String("String"),
							PrivateIpAddresses: []*ec2.PrivateIpAddressSpecification{
								{ // Required
									PrivateIpAddress: aws.String("String"), // Required
									Primary:          aws.Bool(true),
								},
								// More values...
							},
							SecondaryPrivateIpAddressCount: aws.Int64(1),
							SubnetId:                       aws.String("String"),
						},
						// More values...
					},
					Placement: &ec2.SpotPlacement{
						AvailabilityZone: aws.String("String"),
						GroupName:        aws.String("String"),
						Tenancy:          aws.String("Tenancy"),
					},
					RamdiskId: aws.String("String"),
					SecurityGroups: []*ec2.GroupIdentifier{
						{ // Required
							GroupId:   aws.String("String"),
							GroupName: aws.String("String"),
						},
						// More values...
					},
					SpotPrice:        aws.String("String"),
					SubnetId:         aws.String("String"),
					UserData:         aws.String("String"),
					WeightedCapacity: aws.Float64(1.0),
				},
				// More values...
			},
			SpotPrice:                        aws.String("String"), // Required
			TargetCapacity:                   aws.Int64(1),         // Required
			AllocationStrategy:               aws.String("AllocationStrategy"),
			ClientToken:                      aws.String("String"),
			ExcessCapacityTerminationPolicy:  aws.String("ExcessCapacityTerminationPolicy"),
			FulfilledCapacity:                aws.Float64(1.0),
			TerminateInstancesWithExpiration: aws.Bool(true),
			Type:       aws.String("FleetType"),
			ValidFrom:  aws.Time(time.Now()),
			ValidUntil: aws.Time(time.Now()),
		},
		DryRun: aws.Bool(true),
	}
	resp, err := svc.RequestSpotFleet(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_RequestSpotInstances() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.RequestSpotInstancesInput{
		SpotPrice:             aws.String("String"), // Required
		AvailabilityZoneGroup: aws.String("String"),
		BlockDurationMinutes:  aws.Int64(1),
		ClientToken:           aws.String("String"),
		DryRun:                aws.Bool(true),
		InstanceCount:         aws.Int64(1),
		LaunchGroup:           aws.String("String"),
		LaunchSpecification: &ec2.RequestSpotLaunchSpecification{
			AddressingType: aws.String("String"),
			BlockDeviceMappings: []*ec2.BlockDeviceMapping{
				{ // Required
					DeviceName: aws.String("String"),
					Ebs: &ec2.EbsBlockDevice{
						DeleteOnTermination: aws.Bool(true),
						Encrypted:           aws.Bool(true),
						Iops:                aws.Int64(1),
						SnapshotId:          aws.String("String"),
						VolumeSize:          aws.Int64(1),
						VolumeType:          aws.String("VolumeType"),
					},
					NoDevice:    aws.String("String"),
					VirtualName: aws.String("String"),
				},
				// More values...
			},
			EbsOptimized: aws.Bool(true),
			IamInstanceProfile: &ec2.IamInstanceProfileSpecification{
				Arn:  aws.String("String"),
				Name: aws.String("String"),
			},
			ImageId:      aws.String("String"),
			InstanceType: aws.String("InstanceType"),
			KernelId:     aws.String("String"),
			KeyName:      aws.String("String"),
			Monitoring: &ec2.RunInstancesMonitoringEnabled{
				Enabled: aws.Bool(true), // Required
			},
			NetworkInterfaces: []*ec2.InstanceNetworkInterfaceSpecification{
				{ // Required
					AssociatePublicIpAddress: aws.Bool(true),
					DeleteOnTermination:      aws.Bool(true),
					Description:              aws.String("String"),
					DeviceIndex:              aws.Int64(1),
					Groups: []*string{
						aws.String("String"), // Required
						// More values...
					},
					Ipv6AddressCount: aws.Int64(1),
					Ipv6Addresses: []*ec2.InstanceIpv6Address{
						{ // Required
							Ipv6Address: aws.String("String"),
						},
						// More values...
					},
					NetworkInterfaceId: aws.String("String"),
					PrivateIpAddress:   aws.String("String"),
					PrivateIpAddresses: []*ec2.PrivateIpAddressSpecification{
						{ // Required
							PrivateIpAddress: aws.String("String"), // Required
							Primary:          aws.Bool(true),
						},
						// More values...
					},
					SecondaryPrivateIpAddressCount: aws.Int64(1),
					SubnetId:                       aws.String("String"),
				},
				// More values...
			},
			Placement: &ec2.SpotPlacement{
				AvailabilityZone: aws.String("String"),
				GroupName:        aws.String("String"),
				Tenancy:          aws.String("Tenancy"),
			},
			RamdiskId: aws.String("String"),
			SecurityGroupIds: []*string{
				aws.String("String"), // Required
				// More values...
			},
			SecurityGroups: []*string{
				aws.String("String"), // Required
				// More values...
			},
			SubnetId: aws.String("String"),
			UserData: aws.String("String"),
		},
		Type:       aws.String("SpotInstanceType"),
		ValidFrom:  aws.Time(time.Now()),
		ValidUntil: aws.Time(time.Now()),
	}
	resp, err := svc.RequestSpotInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ResetImageAttribute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ResetImageAttributeInput{
		Attribute: aws.String("ResetImageAttributeName"), // Required
		ImageId:   aws.String("String"),                  // Required
		DryRun:    aws.Bool(true),
	}
	resp, err := svc.ResetImageAttribute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ResetInstanceAttribute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ResetInstanceAttributeInput{
		Attribute:  aws.String("InstanceAttributeName"), // Required
		InstanceId: aws.String("String"),                // Required
		DryRun:     aws.Bool(true),
	}
	resp, err := svc.ResetInstanceAttribute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ResetNetworkInterfaceAttribute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ResetNetworkInterfaceAttributeInput{
		NetworkInterfaceId: aws.String("String"), // Required
		DryRun:             aws.Bool(true),
		SourceDestCheck:    aws.String("String"),
	}
	resp, err := svc.ResetNetworkInterfaceAttribute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_ResetSnapshotAttribute() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.ResetSnapshotAttributeInput{
		Attribute:  aws.String("SnapshotAttributeName"), // Required
		SnapshotId: aws.String("String"),                // Required
		DryRun:     aws.Bool(true),
	}
	resp, err := svc.ResetSnapshotAttribute(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_RestoreAddressToClassic() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.RestoreAddressToClassicInput{
		PublicIp: aws.String("String"), // Required
		DryRun:   aws.Bool(true),
	}
	resp, err := svc.RestoreAddressToClassic(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_RevokeSecurityGroupEgress() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.RevokeSecurityGroupEgressInput{
		GroupId:  aws.String("String"), // Required
		CidrIp:   aws.String("String"),
		DryRun:   aws.Bool(true),
		FromPort: aws.Int64(1),
		IpPermissions: []*ec2.IpPermission{
			{ // Required
				FromPort:   aws.Int64(1),
				IpProtocol: aws.String("String"),
				IpRanges: []*ec2.IpRange{
					{ // Required
						CidrIp: aws.String("String"),
					},
					// More values...
				},
				Ipv6Ranges: []*ec2.Ipv6Range{
					{ // Required
						CidrIpv6: aws.String("String"),
					},
					// More values...
				},
				PrefixListIds: []*ec2.PrefixListId{
					{ // Required
						PrefixListId: aws.String("String"),
					},
					// More values...
				},
				ToPort: aws.Int64(1),
				UserIdGroupPairs: []*ec2.UserIdGroupPair{
					{ // Required
						GroupId:       aws.String("String"),
						GroupName:     aws.String("String"),
						PeeringStatus: aws.String("String"),
						UserId:        aws.String("String"),
						VpcId:         aws.String("String"),
						VpcPeeringConnectionId: aws.String("String"),
					},
					// More values...
				},
			},
			// More values...
		},
		IpProtocol:                 aws.String("String"),
		SourceSecurityGroupName:    aws.String("String"),
		SourceSecurityGroupOwnerId: aws.String("String"),
		ToPort: aws.Int64(1),
	}
	resp, err := svc.RevokeSecurityGroupEgress(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_RevokeSecurityGroupIngress() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.RevokeSecurityGroupIngressInput{
		CidrIp:    aws.String("String"),
		DryRun:    aws.Bool(true),
		FromPort:  aws.Int64(1),
		GroupId:   aws.String("String"),
		GroupName: aws.String("String"),
		IpPermissions: []*ec2.IpPermission{
			{ // Required
				FromPort:   aws.Int64(1),
				IpProtocol: aws.String("String"),
				IpRanges: []*ec2.IpRange{
					{ // Required
						CidrIp: aws.String("String"),
					},
					// More values...
				},
				Ipv6Ranges: []*ec2.Ipv6Range{
					{ // Required
						CidrIpv6: aws.String("String"),
					},
					// More values...
				},
				PrefixListIds: []*ec2.PrefixListId{
					{ // Required
						PrefixListId: aws.String("String"),
					},
					// More values...
				},
				ToPort: aws.Int64(1),
				UserIdGroupPairs: []*ec2.UserIdGroupPair{
					{ // Required
						GroupId:       aws.String("String"),
						GroupName:     aws.String("String"),
						PeeringStatus: aws.String("String"),
						UserId:        aws.String("String"),
						VpcId:         aws.String("String"),
						VpcPeeringConnectionId: aws.String("String"),
					},
					// More values...
				},
			},
			// More values...
		},
		IpProtocol:                 aws.String("String"),
		SourceSecurityGroupName:    aws.String("String"),
		SourceSecurityGroupOwnerId: aws.String("String"),
		ToPort: aws.Int64(1),
	}
	resp, err := svc.RevokeSecurityGroupIngress(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_RunInstances() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.RunInstancesInput{
		ImageId:        aws.String("String"), // Required
		MaxCount:       aws.Int64(1),         // Required
		MinCount:       aws.Int64(1),         // Required
		AdditionalInfo: aws.String("String"),
		BlockDeviceMappings: []*ec2.BlockDeviceMapping{
			{ // Required
				DeviceName: aws.String("String"),
				Ebs: &ec2.EbsBlockDevice{
					DeleteOnTermination: aws.Bool(true),
					Encrypted:           aws.Bool(true),
					Iops:                aws.Int64(1),
					SnapshotId:          aws.String("String"),
					VolumeSize:          aws.Int64(1),
					VolumeType:          aws.String("VolumeType"),
				},
				NoDevice:    aws.String("String"),
				VirtualName: aws.String("String"),
			},
			// More values...
		},
		ClientToken:           aws.String("String"),
		DisableApiTermination: aws.Bool(true),
		DryRun:                aws.Bool(true),
		EbsOptimized:          aws.Bool(true),
		IamInstanceProfile: &ec2.IamInstanceProfileSpecification{
			Arn:  aws.String("String"),
			Name: aws.String("String"),
		},
		InstanceInitiatedShutdownBehavior: aws.String("ShutdownBehavior"),
		InstanceType:                      aws.String("InstanceType"),
		Ipv6AddressCount:                  aws.Int64(1),
		Ipv6Addresses: []*ec2.InstanceIpv6Address{
			{ // Required
				Ipv6Address: aws.String("String"),
			},
			// More values...
		},
		KernelId: aws.String("String"),
		KeyName:  aws.String("String"),
		Monitoring: &ec2.RunInstancesMonitoringEnabled{
			Enabled: aws.Bool(true), // Required
		},
		NetworkInterfaces: []*ec2.InstanceNetworkInterfaceSpecification{
			{ // Required
				AssociatePublicIpAddress: aws.Bool(true),
				DeleteOnTermination:      aws.Bool(true),
				Description:              aws.String("String"),
				DeviceIndex:              aws.Int64(1),
				Groups: []*string{
					aws.String("String"), // Required
					// More values...
				},
				Ipv6AddressCount: aws.Int64(1),
				Ipv6Addresses: []*ec2.InstanceIpv6Address{
					{ // Required
						Ipv6Address: aws.String("String"),
					},
					// More values...
				},
				NetworkInterfaceId: aws.String("String"),
				PrivateIpAddress:   aws.String("String"),
				PrivateIpAddresses: []*ec2.PrivateIpAddressSpecification{
					{ // Required
						PrivateIpAddress: aws.String("String"), // Required
						Primary:          aws.Bool(true),
					},
					// More values...
				},
				SecondaryPrivateIpAddressCount: aws.Int64(1),
				SubnetId:                       aws.String("String"),
			},
			// More values...
		},
		Placement: &ec2.Placement{
			Affinity:         aws.String("String"),
			AvailabilityZone: aws.String("String"),
			GroupName:        aws.String("String"),
			HostId:           aws.String("String"),
			Tenancy:          aws.String("Tenancy"),
		},
		PrivateIpAddress: aws.String("String"),
		RamdiskId:        aws.String("String"),
		SecurityGroupIds: []*string{
			aws.String("String"), // Required
			// More values...
		},
		SecurityGroups: []*string{
			aws.String("String"), // Required
			// More values...
		},
		SubnetId: aws.String("String"),
		UserData: aws.String("String"),
	}
	resp, err := svc.RunInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_RunScheduledInstances() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.RunScheduledInstancesInput{
		LaunchSpecification: &ec2.ScheduledInstancesLaunchSpecification{ // Required
			ImageId: aws.String("String"), // Required
			BlockDeviceMappings: []*ec2.ScheduledInstancesBlockDeviceMapping{
				{ // Required
					DeviceName: aws.String("String"),
					Ebs: &ec2.ScheduledInstancesEbs{
						DeleteOnTermination: aws.Bool(true),
						Encrypted:           aws.Bool(true),
						Iops:                aws.Int64(1),
						SnapshotId:          aws.String("String"),
						VolumeSize:          aws.Int64(1),
						VolumeType:          aws.String("String"),
					},
					NoDevice:    aws.String("String"),
					VirtualName: aws.String("String"),
				},
				// More values...
			},
			EbsOptimized: aws.Bool(true),
			IamInstanceProfile: &ec2.ScheduledInstancesIamInstanceProfile{
				Arn:  aws.String("String"),
				Name: aws.String("String"),
			},
			InstanceType: aws.String("String"),
			KernelId:     aws.String("String"),
			KeyName:      aws.String("String"),
			Monitoring: &ec2.ScheduledInstancesMonitoring{
				Enabled: aws.Bool(true),
			},
			NetworkInterfaces: []*ec2.ScheduledInstancesNetworkInterface{
				{ // Required
					AssociatePublicIpAddress: aws.Bool(true),
					DeleteOnTermination:      aws.Bool(true),
					Description:              aws.String("String"),
					DeviceIndex:              aws.Int64(1),
					Groups: []*string{
						aws.String("String"), // Required
						// More values...
					},
					Ipv6AddressCount: aws.Int64(1),
					Ipv6Addresses: []*ec2.ScheduledInstancesIpv6Address{
						{ // Required
							Ipv6Address: aws.String("Ipv6Address"),
						},
						// More values...
					},
					NetworkInterfaceId: aws.String("String"),
					PrivateIpAddress:   aws.String("String"),
					PrivateIpAddressConfigs: []*ec2.ScheduledInstancesPrivateIpAddressConfig{
						{ // Required
							Primary:          aws.Bool(true),
							PrivateIpAddress: aws.String("String"),
						},
						// More values...
					},
					SecondaryPrivateIpAddressCount: aws.Int64(1),
					SubnetId:                       aws.String("String"),
				},
				// More values...
			},
			Placement: &ec2.ScheduledInstancesPlacement{
				AvailabilityZone: aws.String("String"),
				GroupName:        aws.String("String"),
			},
			RamdiskId: aws.String("String"),
			SecurityGroupIds: []*string{
				aws.String("String"), // Required
				// More values...
			},
			SubnetId: aws.String("String"),
			UserData: aws.String("String"),
		},
		ScheduledInstanceId: aws.String("String"), // Required
		ClientToken:         aws.String("String"),
		DryRun:              aws.Bool(true),
		InstanceCount:       aws.Int64(1),
	}
	resp, err := svc.RunScheduledInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_StartInstances() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.StartInstancesInput{
		InstanceIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		AdditionalInfo: aws.String("String"),
		DryRun:         aws.Bool(true),
	}
	resp, err := svc.StartInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_StopInstances() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.StopInstancesInput{
		InstanceIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		DryRun: aws.Bool(true),
		Force:  aws.Bool(true),
	}
	resp, err := svc.StopInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_TerminateInstances() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.TerminateInstancesInput{
		InstanceIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		DryRun: aws.Bool(true),
	}
	resp, err := svc.TerminateInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_UnassignIpv6Addresses() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.UnassignIpv6AddressesInput{
		Ipv6Addresses: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		NetworkInterfaceId: aws.String("String"), // Required
	}
	resp, err := svc.UnassignIpv6Addresses(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_UnassignPrivateIpAddresses() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.UnassignPrivateIpAddressesInput{
		NetworkInterfaceId: aws.String("String"), // Required
		PrivateIpAddresses: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.UnassignPrivateIpAddresses(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleEC2_UnmonitorInstances() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := ec2.New(sess)

	params := &ec2.UnmonitorInstancesInput{
		InstanceIds: []*string{ // Required
			aws.String("String"), // Required
			// More values...
		},
		DryRun: aws.Bool(true),
	}
	resp, err := svc.UnmonitorInstances(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
