// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

package elastictranscoder_test

import (
	"bytes"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/elastictranscoder"
)

var _ time.Duration
var _ bytes.Buffer

func ExampleElasticTranscoder_CancelJob() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elastictranscoder.New(sess)

	params := &elastictranscoder.CancelJobInput{
		Id: aws.String("Id"), // Required
	}
	resp, err := svc.CancelJob(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticTranscoder_CreateJob() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elastictranscoder.New(sess)

	params := &elastictranscoder.CreateJobInput{
		PipelineId: aws.String("Id"), // Required
		Input: &elastictranscoder.JobInput{
			AspectRatio: aws.String("AspectRatio"),
			Container:   aws.String("JobContainer"),
			DetectedProperties: &elastictranscoder.DetectedProperties{
				DurationMillis: aws.Int64(1),
				FileSize:       aws.Int64(1),
				FrameRate:      aws.String("FloatString"),
				Height:         aws.Int64(1),
				Width:          aws.Int64(1),
			},
			Encryption: &elastictranscoder.Encryption{
				InitializationVector: aws.String("ZeroTo255String"),
				Key:                  aws.String("Base64EncodedString"),
				KeyMd5:               aws.String("Base64EncodedString"),
				Mode:                 aws.String("EncryptionMode"),
			},
			FrameRate: aws.String("FrameRate"),
			InputCaptions: &elastictranscoder.InputCaptions{
				CaptionSources: []*elastictranscoder.CaptionSource{
					{ // Required
						Encryption: &elastictranscoder.Encryption{
							InitializationVector: aws.String("ZeroTo255String"),
							Key:                  aws.String("Base64EncodedString"),
							KeyMd5:               aws.String("Base64EncodedString"),
							Mode:                 aws.String("EncryptionMode"),
						},
						Key:        aws.String("LongKey"),
						Label:      aws.String("Name"),
						Language:   aws.String("Key"),
						TimeOffset: aws.String("TimeOffset"),
					},
					// More values...
				},
				MergePolicy: aws.String("CaptionMergePolicy"),
			},
			Interlaced: aws.String("Interlaced"),
			Key:        aws.String("LongKey"),
			Resolution: aws.String("Resolution"),
			TimeSpan: &elastictranscoder.TimeSpan{
				Duration:  aws.String("Time"),
				StartTime: aws.String("Time"),
			},
		},
		Inputs: []*elastictranscoder.JobInput{
			{ // Required
				AspectRatio: aws.String("AspectRatio"),
				Container:   aws.String("JobContainer"),
				DetectedProperties: &elastictranscoder.DetectedProperties{
					DurationMillis: aws.Int64(1),
					FileSize:       aws.Int64(1),
					FrameRate:      aws.String("FloatString"),
					Height:         aws.Int64(1),
					Width:          aws.Int64(1),
				},
				Encryption: &elastictranscoder.Encryption{
					InitializationVector: aws.String("ZeroTo255String"),
					Key:                  aws.String("Base64EncodedString"),
					KeyMd5:               aws.String("Base64EncodedString"),
					Mode:                 aws.String("EncryptionMode"),
				},
				FrameRate: aws.String("FrameRate"),
				InputCaptions: &elastictranscoder.InputCaptions{
					CaptionSources: []*elastictranscoder.CaptionSource{
						{ // Required
							Encryption: &elastictranscoder.Encryption{
								InitializationVector: aws.String("ZeroTo255String"),
								Key:                  aws.String("Base64EncodedString"),
								KeyMd5:               aws.String("Base64EncodedString"),
								Mode:                 aws.String("EncryptionMode"),
							},
							Key:        aws.String("LongKey"),
							Label:      aws.String("Name"),
							Language:   aws.String("Key"),
							TimeOffset: aws.String("TimeOffset"),
						},
						// More values...
					},
					MergePolicy: aws.String("CaptionMergePolicy"),
				},
				Interlaced: aws.String("Interlaced"),
				Key:        aws.String("LongKey"),
				Resolution: aws.String("Resolution"),
				TimeSpan: &elastictranscoder.TimeSpan{
					Duration:  aws.String("Time"),
					StartTime: aws.String("Time"),
				},
			},
			// More values...
		},
		Output: &elastictranscoder.CreateJobOutput{
			AlbumArt: &elastictranscoder.JobAlbumArt{
				Artwork: []*elastictranscoder.Artwork{
					{ // Required
						AlbumArtFormat: aws.String("JpgOrPng"),
						Encryption: &elastictranscoder.Encryption{
							InitializationVector: aws.String("ZeroTo255String"),
							Key:                  aws.String("Base64EncodedString"),
							KeyMd5:               aws.String("Base64EncodedString"),
							Mode:                 aws.String("EncryptionMode"),
						},
						InputKey:      aws.String("WatermarkKey"),
						MaxHeight:     aws.String("DigitsOrAuto"),
						MaxWidth:      aws.String("DigitsOrAuto"),
						PaddingPolicy: aws.String("PaddingPolicy"),
						SizingPolicy:  aws.String("SizingPolicy"),
					},
					// More values...
				},
				MergePolicy: aws.String("MergePolicy"),
			},
			Captions: &elastictranscoder.Captions{
				CaptionFormats: []*elastictranscoder.CaptionFormat{
					{ // Required
						Encryption: &elastictranscoder.Encryption{
							InitializationVector: aws.String("ZeroTo255String"),
							Key:                  aws.String("Base64EncodedString"),
							KeyMd5:               aws.String("Base64EncodedString"),
							Mode:                 aws.String("EncryptionMode"),
						},
						Format:  aws.String("CaptionFormatFormat"),
						Pattern: aws.String("CaptionFormatPattern"),
					},
					// More values...
				},
				CaptionSources: []*elastictranscoder.CaptionSource{
					{ // Required
						Encryption: &elastictranscoder.Encryption{
							InitializationVector: aws.String("ZeroTo255String"),
							Key:                  aws.String("Base64EncodedString"),
							KeyMd5:               aws.String("Base64EncodedString"),
							Mode:                 aws.String("EncryptionMode"),
						},
						Key:        aws.String("LongKey"),
						Label:      aws.String("Name"),
						Language:   aws.String("Key"),
						TimeOffset: aws.String("TimeOffset"),
					},
					// More values...
				},
				MergePolicy: aws.String("CaptionMergePolicy"),
			},
			Composition: []*elastictranscoder.Clip{
				{ // Required
					TimeSpan: &elastictranscoder.TimeSpan{
						Duration:  aws.String("Time"),
						StartTime: aws.String("Time"),
					},
				},
				// More values...
			},
			Encryption: &elastictranscoder.Encryption{
				InitializationVector: aws.String("ZeroTo255String"),
				Key:                  aws.String("Base64EncodedString"),
				KeyMd5:               aws.String("Base64EncodedString"),
				Mode:                 aws.String("EncryptionMode"),
			},
			Key:             aws.String("Key"),
			PresetId:        aws.String("Id"),
			Rotate:          aws.String("Rotate"),
			SegmentDuration: aws.String("FloatString"),
			ThumbnailEncryption: &elastictranscoder.Encryption{
				InitializationVector: aws.String("ZeroTo255String"),
				Key:                  aws.String("Base64EncodedString"),
				KeyMd5:               aws.String("Base64EncodedString"),
				Mode:                 aws.String("EncryptionMode"),
			},
			ThumbnailPattern: aws.String("ThumbnailPattern"),
			Watermarks: []*elastictranscoder.JobWatermark{
				{ // Required
					Encryption: &elastictranscoder.Encryption{
						InitializationVector: aws.String("ZeroTo255String"),
						Key:                  aws.String("Base64EncodedString"),
						KeyMd5:               aws.String("Base64EncodedString"),
						Mode:                 aws.String("EncryptionMode"),
					},
					InputKey:          aws.String("WatermarkKey"),
					PresetWatermarkId: aws.String("PresetWatermarkId"),
				},
				// More values...
			},
		},
		OutputKeyPrefix: aws.String("Key"),
		Outputs: []*elastictranscoder.CreateJobOutput{
			{ // Required
				AlbumArt: &elastictranscoder.JobAlbumArt{
					Artwork: []*elastictranscoder.Artwork{
						{ // Required
							AlbumArtFormat: aws.String("JpgOrPng"),
							Encryption: &elastictranscoder.Encryption{
								InitializationVector: aws.String("ZeroTo255String"),
								Key:                  aws.String("Base64EncodedString"),
								KeyMd5:               aws.String("Base64EncodedString"),
								Mode:                 aws.String("EncryptionMode"),
							},
							InputKey:      aws.String("WatermarkKey"),
							MaxHeight:     aws.String("DigitsOrAuto"),
							MaxWidth:      aws.String("DigitsOrAuto"),
							PaddingPolicy: aws.String("PaddingPolicy"),
							SizingPolicy:  aws.String("SizingPolicy"),
						},
						// More values...
					},
					MergePolicy: aws.String("MergePolicy"),
				},
				Captions: &elastictranscoder.Captions{
					CaptionFormats: []*elastictranscoder.CaptionFormat{
						{ // Required
							Encryption: &elastictranscoder.Encryption{
								InitializationVector: aws.String("ZeroTo255String"),
								Key:                  aws.String("Base64EncodedString"),
								KeyMd5:               aws.String("Base64EncodedString"),
								Mode:                 aws.String("EncryptionMode"),
							},
							Format:  aws.String("CaptionFormatFormat"),
							Pattern: aws.String("CaptionFormatPattern"),
						},
						// More values...
					},
					CaptionSources: []*elastictranscoder.CaptionSource{
						{ // Required
							Encryption: &elastictranscoder.Encryption{
								InitializationVector: aws.String("ZeroTo255String"),
								Key:                  aws.String("Base64EncodedString"),
								KeyMd5:               aws.String("Base64EncodedString"),
								Mode:                 aws.String("EncryptionMode"),
							},
							Key:        aws.String("LongKey"),
							Label:      aws.String("Name"),
							Language:   aws.String("Key"),
							TimeOffset: aws.String("TimeOffset"),
						},
						// More values...
					},
					MergePolicy: aws.String("CaptionMergePolicy"),
				},
				Composition: []*elastictranscoder.Clip{
					{ // Required
						TimeSpan: &elastictranscoder.TimeSpan{
							Duration:  aws.String("Time"),
							StartTime: aws.String("Time"),
						},
					},
					// More values...
				},
				Encryption: &elastictranscoder.Encryption{
					InitializationVector: aws.String("ZeroTo255String"),
					Key:                  aws.String("Base64EncodedString"),
					KeyMd5:               aws.String("Base64EncodedString"),
					Mode:                 aws.String("EncryptionMode"),
				},
				Key:             aws.String("Key"),
				PresetId:        aws.String("Id"),
				Rotate:          aws.String("Rotate"),
				SegmentDuration: aws.String("FloatString"),
				ThumbnailEncryption: &elastictranscoder.Encryption{
					InitializationVector: aws.String("ZeroTo255String"),
					Key:                  aws.String("Base64EncodedString"),
					KeyMd5:               aws.String("Base64EncodedString"),
					Mode:                 aws.String("EncryptionMode"),
				},
				ThumbnailPattern: aws.String("ThumbnailPattern"),
				Watermarks: []*elastictranscoder.JobWatermark{
					{ // Required
						Encryption: &elastictranscoder.Encryption{
							InitializationVector: aws.String("ZeroTo255String"),
							Key:                  aws.String("Base64EncodedString"),
							KeyMd5:               aws.String("Base64EncodedString"),
							Mode:                 aws.String("EncryptionMode"),
						},
						InputKey:          aws.String("WatermarkKey"),
						PresetWatermarkId: aws.String("PresetWatermarkId"),
					},
					// More values...
				},
			},
			// More values...
		},
		Playlists: []*elastictranscoder.CreateJobPlaylist{
			{ // Required
				Format: aws.String("PlaylistFormat"),
				HlsContentProtection: &elastictranscoder.HlsContentProtection{
					InitializationVector:  aws.String("ZeroTo255String"),
					Key:                   aws.String("Base64EncodedString"),
					KeyMd5:                aws.String("Base64EncodedString"),
					KeyStoragePolicy:      aws.String("KeyStoragePolicy"),
					LicenseAcquisitionUrl: aws.String("ZeroTo512String"),
					Method:                aws.String("HlsContentProtectionMethod"),
				},
				Name: aws.String("Filename"),
				OutputKeys: []*string{
					aws.String("Key"), // Required
					// More values...
				},
				PlayReadyDrm: &elastictranscoder.PlayReadyDrm{
					Format:                aws.String("PlayReadyDrmFormatString"),
					InitializationVector:  aws.String("ZeroTo255String"),
					Key:                   aws.String("NonEmptyBase64EncodedString"),
					KeyId:                 aws.String("KeyIdGuid"),
					KeyMd5:                aws.String("NonEmptyBase64EncodedString"),
					LicenseAcquisitionUrl: aws.String("OneTo512String"),
				},
			},
			// More values...
		},
		UserMetadata: map[string]*string{
			"Key": aws.String("String"), // Required
			// More values...
		},
	}
	resp, err := svc.CreateJob(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticTranscoder_CreatePipeline() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elastictranscoder.New(sess)

	params := &elastictranscoder.CreatePipelineInput{
		InputBucket:  aws.String("BucketName"), // Required
		Name:         aws.String("Name"),       // Required
		Role:         aws.String("Role"),       // Required
		AwsKmsKeyArn: aws.String("KeyArn"),
		ContentConfig: &elastictranscoder.PipelineOutputConfig{
			Bucket: aws.String("BucketName"),
			Permissions: []*elastictranscoder.Permission{
				{ // Required
					Access: []*string{
						aws.String("AccessControl"), // Required
						// More values...
					},
					Grantee:     aws.String("Grantee"),
					GranteeType: aws.String("GranteeType"),
				},
				// More values...
			},
			StorageClass: aws.String("StorageClass"),
		},
		Notifications: &elastictranscoder.Notifications{
			Completed:   aws.String("SnsTopic"),
			Error:       aws.String("SnsTopic"),
			Progressing: aws.String("SnsTopic"),
			Warning:     aws.String("SnsTopic"),
		},
		OutputBucket: aws.String("BucketName"),
		ThumbnailConfig: &elastictranscoder.PipelineOutputConfig{
			Bucket: aws.String("BucketName"),
			Permissions: []*elastictranscoder.Permission{
				{ // Required
					Access: []*string{
						aws.String("AccessControl"), // Required
						// More values...
					},
					Grantee:     aws.String("Grantee"),
					GranteeType: aws.String("GranteeType"),
				},
				// More values...
			},
			StorageClass: aws.String("StorageClass"),
		},
	}
	resp, err := svc.CreatePipeline(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticTranscoder_CreatePreset() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elastictranscoder.New(sess)

	params := &elastictranscoder.CreatePresetInput{
		Container: aws.String("PresetContainer"), // Required
		Name:      aws.String("Name"),            // Required
		Audio: &elastictranscoder.AudioParameters{
			AudioPackingMode: aws.String("AudioPackingMode"),
			BitRate:          aws.String("AudioBitRate"),
			Channels:         aws.String("AudioChannels"),
			Codec:            aws.String("AudioCodec"),
			CodecOptions: &elastictranscoder.AudioCodecOptions{
				BitDepth: aws.String("AudioBitDepth"),
				BitOrder: aws.String("AudioBitOrder"),
				Profile:  aws.String("AudioCodecProfile"),
				Signed:   aws.String("AudioSigned"),
			},
			SampleRate: aws.String("AudioSampleRate"),
		},
		Description: aws.String("Description"),
		Thumbnails: &elastictranscoder.Thumbnails{
			AspectRatio:   aws.String("AspectRatio"),
			Format:        aws.String("JpgOrPng"),
			Interval:      aws.String("Digits"),
			MaxHeight:     aws.String("DigitsOrAuto"),
			MaxWidth:      aws.String("DigitsOrAuto"),
			PaddingPolicy: aws.String("PaddingPolicy"),
			Resolution:    aws.String("ThumbnailResolution"),
			SizingPolicy:  aws.String("SizingPolicy"),
		},
		Video: &elastictranscoder.VideoParameters{
			AspectRatio: aws.String("AspectRatio"),
			BitRate:     aws.String("VideoBitRate"),
			Codec:       aws.String("VideoCodec"),
			CodecOptions: map[string]*string{
				"Key": aws.String("CodecOption"), // Required
				// More values...
			},
			DisplayAspectRatio: aws.String("AspectRatio"),
			FixedGOP:           aws.String("FixedGOP"),
			FrameRate:          aws.String("FrameRate"),
			KeyframesMaxDist:   aws.String("KeyframesMaxDist"),
			MaxFrameRate:       aws.String("MaxFrameRate"),
			MaxHeight:          aws.String("DigitsOrAuto"),
			MaxWidth:           aws.String("DigitsOrAuto"),
			PaddingPolicy:      aws.String("PaddingPolicy"),
			Resolution:         aws.String("Resolution"),
			SizingPolicy:       aws.String("SizingPolicy"),
			Watermarks: []*elastictranscoder.PresetWatermark{
				{ // Required
					HorizontalAlign:  aws.String("HorizontalAlign"),
					HorizontalOffset: aws.String("PixelsOrPercent"),
					Id:               aws.String("PresetWatermarkId"),
					MaxHeight:        aws.String("PixelsOrPercent"),
					MaxWidth:         aws.String("PixelsOrPercent"),
					Opacity:          aws.String("Opacity"),
					SizingPolicy:     aws.String("WatermarkSizingPolicy"),
					Target:           aws.String("Target"),
					VerticalAlign:    aws.String("VerticalAlign"),
					VerticalOffset:   aws.String("PixelsOrPercent"),
				},
				// More values...
			},
		},
	}
	resp, err := svc.CreatePreset(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticTranscoder_DeletePipeline() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elastictranscoder.New(sess)

	params := &elastictranscoder.DeletePipelineInput{
		Id: aws.String("Id"), // Required
	}
	resp, err := svc.DeletePipeline(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticTranscoder_DeletePreset() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elastictranscoder.New(sess)

	params := &elastictranscoder.DeletePresetInput{
		Id: aws.String("Id"), // Required
	}
	resp, err := svc.DeletePreset(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticTranscoder_ListJobsByPipeline() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elastictranscoder.New(sess)

	params := &elastictranscoder.ListJobsByPipelineInput{
		PipelineId: aws.String("Id"), // Required
		Ascending:  aws.String("Ascending"),
		PageToken:  aws.String("Id"),
	}
	resp, err := svc.ListJobsByPipeline(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticTranscoder_ListJobsByStatus() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elastictranscoder.New(sess)

	params := &elastictranscoder.ListJobsByStatusInput{
		Status:    aws.String("JobStatus"), // Required
		Ascending: aws.String("Ascending"),
		PageToken: aws.String("Id"),
	}
	resp, err := svc.ListJobsByStatus(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticTranscoder_ListPipelines() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elastictranscoder.New(sess)

	params := &elastictranscoder.ListPipelinesInput{
		Ascending: aws.String("Ascending"),
		PageToken: aws.String("Id"),
	}
	resp, err := svc.ListPipelines(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticTranscoder_ListPresets() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elastictranscoder.New(sess)

	params := &elastictranscoder.ListPresetsInput{
		Ascending: aws.String("Ascending"),
		PageToken: aws.String("Id"),
	}
	resp, err := svc.ListPresets(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticTranscoder_ReadJob() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elastictranscoder.New(sess)

	params := &elastictranscoder.ReadJobInput{
		Id: aws.String("Id"), // Required
	}
	resp, err := svc.ReadJob(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticTranscoder_ReadPipeline() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elastictranscoder.New(sess)

	params := &elastictranscoder.ReadPipelineInput{
		Id: aws.String("Id"), // Required
	}
	resp, err := svc.ReadPipeline(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticTranscoder_ReadPreset() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elastictranscoder.New(sess)

	params := &elastictranscoder.ReadPresetInput{
		Id: aws.String("Id"), // Required
	}
	resp, err := svc.ReadPreset(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticTranscoder_TestRole() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elastictranscoder.New(sess)

	params := &elastictranscoder.TestRoleInput{
		InputBucket:  aws.String("BucketName"), // Required
		OutputBucket: aws.String("BucketName"), // Required
		Role:         aws.String("Role"),       // Required
		Topics: []*string{ // Required
			aws.String("SnsTopic"), // Required
			// More values...
		},
	}
	resp, err := svc.TestRole(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticTranscoder_UpdatePipeline() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elastictranscoder.New(sess)

	params := &elastictranscoder.UpdatePipelineInput{
		Id:           aws.String("Id"), // Required
		AwsKmsKeyArn: aws.String("KeyArn"),
		ContentConfig: &elastictranscoder.PipelineOutputConfig{
			Bucket: aws.String("BucketName"),
			Permissions: []*elastictranscoder.Permission{
				{ // Required
					Access: []*string{
						aws.String("AccessControl"), // Required
						// More values...
					},
					Grantee:     aws.String("Grantee"),
					GranteeType: aws.String("GranteeType"),
				},
				// More values...
			},
			StorageClass: aws.String("StorageClass"),
		},
		InputBucket: aws.String("BucketName"),
		Name:        aws.String("Name"),
		Notifications: &elastictranscoder.Notifications{
			Completed:   aws.String("SnsTopic"),
			Error:       aws.String("SnsTopic"),
			Progressing: aws.String("SnsTopic"),
			Warning:     aws.String("SnsTopic"),
		},
		Role: aws.String("Role"),
		ThumbnailConfig: &elastictranscoder.PipelineOutputConfig{
			Bucket: aws.String("BucketName"),
			Permissions: []*elastictranscoder.Permission{
				{ // Required
					Access: []*string{
						aws.String("AccessControl"), // Required
						// More values...
					},
					Grantee:     aws.String("Grantee"),
					GranteeType: aws.String("GranteeType"),
				},
				// More values...
			},
			StorageClass: aws.String("StorageClass"),
		},
	}
	resp, err := svc.UpdatePipeline(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticTranscoder_UpdatePipelineNotifications() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elastictranscoder.New(sess)

	params := &elastictranscoder.UpdatePipelineNotificationsInput{
		Id: aws.String("Id"), // Required
		Notifications: &elastictranscoder.Notifications{ // Required
			Completed:   aws.String("SnsTopic"),
			Error:       aws.String("SnsTopic"),
			Progressing: aws.String("SnsTopic"),
			Warning:     aws.String("SnsTopic"),
		},
	}
	resp, err := svc.UpdatePipelineNotifications(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}

func ExampleElasticTranscoder_UpdatePipelineStatus() {
	sess, err := session.NewSession()
	if err != nil {
		fmt.Println("failed to create session,", err)
		return
	}

	svc := elastictranscoder.New(sess)

	params := &elastictranscoder.UpdatePipelineStatusInput{
		Id:     aws.String("Id"),             // Required
		Status: aws.String("PipelineStatus"), // Required
	}
	resp, err := svc.UpdatePipelineStatus(params)

	if err != nil {
		// Print the error, cast err to awserr.Error to get the Code and
		// Message from an error.
		fmt.Println(err.Error())
		return
	}

	// Pretty-print the response data.
	fmt.Println(resp)
}
