/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package v1

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg1_unversioned "k8s.io/kubernetes/pkg/api/unversioned"
	pkg2_v1 "k8s.io/kubernetes/pkg/api/v1"
	pkg3_types "k8s.io/kubernetes/pkg/types"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg1_unversioned.Time
		var v1 pkg2_v1.ObjectMeta
		var v2 pkg3_types.UID
		var v3 time.Time
		_, _, _, _ = v0, v1, v2, v3
	}
}

func (x *CrossVersionObjectReference) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[2] = x.APIVersion != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("kind"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym7 := z.EncBinary()
				_ = yym7
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CrossVersionObjectReference) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym12 := z.DecBinary()
	_ = yym12
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct13 := r.ContainerType()
		if yyct13 == codecSelferValueTypeMap1234 {
			yyl13 := r.ReadMapStart()
			if yyl13 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl13, d)
			}
		} else if yyct13 == codecSelferValueTypeArray1234 {
			yyl13 := r.ReadArrayStart()
			if yyl13 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl13, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CrossVersionObjectReference) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys14Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys14Slc
	var yyhl14 bool = l >= 0
	for yyj14 := 0; ; yyj14++ {
		if yyhl14 {
			if yyj14 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys14Slc = r.DecodeBytes(yys14Slc, true, true)
		yys14 := string(yys14Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys14 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				x.Name = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys14)
		} // end switch yys14
	} // end for yyj14
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CrossVersionObjectReference) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj18 int
	var yyb18 bool
	var yyhl18 bool = l >= 0
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		x.Name = string(r.DecodeString())
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	for {
		yyj18++
		if yyhl18 {
			yyb18 = yyj18 > l
		} else {
			yyb18 = r.CheckBreak()
		}
		if yyb18 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj18-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscalerSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym22 := z.EncBinary()
		_ = yym22
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep23 := !z.EncBinary()
			yy2arr23 := z.EncBasicHandle().StructToArray
			var yyq23 [4]bool
			_, _, _ = yysep23, yyq23, yy2arr23
			const yyr23 bool = false
			yyq23[1] = x.MinReplicas != nil
			yyq23[3] = x.TargetCPUUtilizationPercentage != nil
			var yynn23 int
			if yyr23 || yy2arr23 {
				r.EncodeArrayStart(4)
			} else {
				yynn23 = 2
				for _, b := range yyq23 {
					if b {
						yynn23++
					}
				}
				r.EncodeMapStart(yynn23)
				yynn23 = 0
			}
			if yyr23 || yy2arr23 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy25 := &x.ScaleTargetRef
				yy25.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("scaleTargetRef"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy26 := &x.ScaleTargetRef
				yy26.CodecEncodeSelf(e)
			}
			if yyr23 || yy2arr23 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq23[1] {
					if x.MinReplicas == nil {
						r.EncodeNil()
					} else {
						yy28 := *x.MinReplicas
						yym29 := z.EncBinary()
						_ = yym29
						if false {
						} else {
							r.EncodeInt(int64(yy28))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq23[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("minReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.MinReplicas == nil {
						r.EncodeNil()
					} else {
						yy30 := *x.MinReplicas
						yym31 := z.EncBinary()
						_ = yym31
						if false {
						} else {
							r.EncodeInt(int64(yy30))
						}
					}
				}
			}
			if yyr23 || yy2arr23 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym33 := z.EncBinary()
				_ = yym33
				if false {
				} else {
					r.EncodeInt(int64(x.MaxReplicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("maxReplicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym34 := z.EncBinary()
				_ = yym34
				if false {
				} else {
					r.EncodeInt(int64(x.MaxReplicas))
				}
			}
			if yyr23 || yy2arr23 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq23[3] {
					if x.TargetCPUUtilizationPercentage == nil {
						r.EncodeNil()
					} else {
						yy36 := *x.TargetCPUUtilizationPercentage
						yym37 := z.EncBinary()
						_ = yym37
						if false {
						} else {
							r.EncodeInt(int64(yy36))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq23[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("targetCPUUtilizationPercentage"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TargetCPUUtilizationPercentage == nil {
						r.EncodeNil()
					} else {
						yy38 := *x.TargetCPUUtilizationPercentage
						yym39 := z.EncBinary()
						_ = yym39
						if false {
						} else {
							r.EncodeInt(int64(yy38))
						}
					}
				}
			}
			if yyr23 || yy2arr23 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscalerSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym40 := z.DecBinary()
	_ = yym40
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct41 := r.ContainerType()
		if yyct41 == codecSelferValueTypeMap1234 {
			yyl41 := r.ReadMapStart()
			if yyl41 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl41, d)
			}
		} else if yyct41 == codecSelferValueTypeArray1234 {
			yyl41 := r.ReadArrayStart()
			if yyl41 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl41, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscalerSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys42Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys42Slc
	var yyhl42 bool = l >= 0
	for yyj42 := 0; ; yyj42++ {
		if yyhl42 {
			if yyj42 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys42Slc = r.DecodeBytes(yys42Slc, true, true)
		yys42 := string(yys42Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys42 {
		case "scaleTargetRef":
			if r.TryDecodeAsNil() {
				x.ScaleTargetRef = CrossVersionObjectReference{}
			} else {
				yyv43 := &x.ScaleTargetRef
				yyv43.CodecDecodeSelf(d)
			}
		case "minReplicas":
			if r.TryDecodeAsNil() {
				if x.MinReplicas != nil {
					x.MinReplicas = nil
				}
			} else {
				if x.MinReplicas == nil {
					x.MinReplicas = new(int32)
				}
				yym45 := z.DecBinary()
				_ = yym45
				if false {
				} else {
					*((*int32)(x.MinReplicas)) = int32(r.DecodeInt(32))
				}
			}
		case "maxReplicas":
			if r.TryDecodeAsNil() {
				x.MaxReplicas = 0
			} else {
				x.MaxReplicas = int32(r.DecodeInt(32))
			}
		case "targetCPUUtilizationPercentage":
			if r.TryDecodeAsNil() {
				if x.TargetCPUUtilizationPercentage != nil {
					x.TargetCPUUtilizationPercentage = nil
				}
			} else {
				if x.TargetCPUUtilizationPercentage == nil {
					x.TargetCPUUtilizationPercentage = new(int32)
				}
				yym48 := z.DecBinary()
				_ = yym48
				if false {
				} else {
					*((*int32)(x.TargetCPUUtilizationPercentage)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys42)
		} // end switch yys42
	} // end for yyj42
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscalerSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj49 int
	var yyb49 bool
	var yyhl49 bool = l >= 0
	yyj49++
	if yyhl49 {
		yyb49 = yyj49 > l
	} else {
		yyb49 = r.CheckBreak()
	}
	if yyb49 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ScaleTargetRef = CrossVersionObjectReference{}
	} else {
		yyv50 := &x.ScaleTargetRef
		yyv50.CodecDecodeSelf(d)
	}
	yyj49++
	if yyhl49 {
		yyb49 = yyj49 > l
	} else {
		yyb49 = r.CheckBreak()
	}
	if yyb49 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.MinReplicas != nil {
			x.MinReplicas = nil
		}
	} else {
		if x.MinReplicas == nil {
			x.MinReplicas = new(int32)
		}
		yym52 := z.DecBinary()
		_ = yym52
		if false {
		} else {
			*((*int32)(x.MinReplicas)) = int32(r.DecodeInt(32))
		}
	}
	yyj49++
	if yyhl49 {
		yyb49 = yyj49 > l
	} else {
		yyb49 = r.CheckBreak()
	}
	if yyb49 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MaxReplicas = 0
	} else {
		x.MaxReplicas = int32(r.DecodeInt(32))
	}
	yyj49++
	if yyhl49 {
		yyb49 = yyj49 > l
	} else {
		yyb49 = r.CheckBreak()
	}
	if yyb49 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TargetCPUUtilizationPercentage != nil {
			x.TargetCPUUtilizationPercentage = nil
		}
	} else {
		if x.TargetCPUUtilizationPercentage == nil {
			x.TargetCPUUtilizationPercentage = new(int32)
		}
		yym55 := z.DecBinary()
		_ = yym55
		if false {
		} else {
			*((*int32)(x.TargetCPUUtilizationPercentage)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj49++
		if yyhl49 {
			yyb49 = yyj49 > l
		} else {
			yyb49 = r.CheckBreak()
		}
		if yyb49 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj49-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscalerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym56 := z.EncBinary()
		_ = yym56
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep57 := !z.EncBinary()
			yy2arr57 := z.EncBasicHandle().StructToArray
			var yyq57 [5]bool
			_, _, _ = yysep57, yyq57, yy2arr57
			const yyr57 bool = false
			yyq57[0] = x.ObservedGeneration != nil
			yyq57[1] = x.LastScaleTime != nil
			yyq57[4] = x.CurrentCPUUtilizationPercentage != nil
			var yynn57 int
			if yyr57 || yy2arr57 {
				r.EncodeArrayStart(5)
			} else {
				yynn57 = 2
				for _, b := range yyq57 {
					if b {
						yynn57++
					}
				}
				r.EncodeMapStart(yynn57)
				yynn57 = 0
			}
			if yyr57 || yy2arr57 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq57[0] {
					if x.ObservedGeneration == nil {
						r.EncodeNil()
					} else {
						yy59 := *x.ObservedGeneration
						yym60 := z.EncBinary()
						_ = yym60
						if false {
						} else {
							r.EncodeInt(int64(yy59))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq57[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ObservedGeneration == nil {
						r.EncodeNil()
					} else {
						yy61 := *x.ObservedGeneration
						yym62 := z.EncBinary()
						_ = yym62
						if false {
						} else {
							r.EncodeInt(int64(yy61))
						}
					}
				}
			}
			if yyr57 || yy2arr57 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq57[1] {
					if x.LastScaleTime == nil {
						r.EncodeNil()
					} else {
						yym64 := z.EncBinary()
						_ = yym64
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LastScaleTime) {
						} else if yym64 {
							z.EncBinaryMarshal(x.LastScaleTime)
						} else if !yym64 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.LastScaleTime)
						} else {
							z.EncFallback(x.LastScaleTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq57[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastScaleTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LastScaleTime == nil {
						r.EncodeNil()
					} else {
						yym65 := z.EncBinary()
						_ = yym65
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LastScaleTime) {
						} else if yym65 {
							z.EncBinaryMarshal(x.LastScaleTime)
						} else if !yym65 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.LastScaleTime)
						} else {
							z.EncFallback(x.LastScaleTime)
						}
					}
				}
			}
			if yyr57 || yy2arr57 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym67 := z.EncBinary()
				_ = yym67
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentReplicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("currentReplicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym68 := z.EncBinary()
				_ = yym68
				if false {
				} else {
					r.EncodeInt(int64(x.CurrentReplicas))
				}
			}
			if yyr57 || yy2arr57 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym70 := z.EncBinary()
				_ = yym70
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredReplicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("desiredReplicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym71 := z.EncBinary()
				_ = yym71
				if false {
				} else {
					r.EncodeInt(int64(x.DesiredReplicas))
				}
			}
			if yyr57 || yy2arr57 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq57[4] {
					if x.CurrentCPUUtilizationPercentage == nil {
						r.EncodeNil()
					} else {
						yy73 := *x.CurrentCPUUtilizationPercentage
						yym74 := z.EncBinary()
						_ = yym74
						if false {
						} else {
							r.EncodeInt(int64(yy73))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq57[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("currentCPUUtilizationPercentage"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CurrentCPUUtilizationPercentage == nil {
						r.EncodeNil()
					} else {
						yy75 := *x.CurrentCPUUtilizationPercentage
						yym76 := z.EncBinary()
						_ = yym76
						if false {
						} else {
							r.EncodeInt(int64(yy75))
						}
					}
				}
			}
			if yyr57 || yy2arr57 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscalerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym77 := z.DecBinary()
	_ = yym77
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct78 := r.ContainerType()
		if yyct78 == codecSelferValueTypeMap1234 {
			yyl78 := r.ReadMapStart()
			if yyl78 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl78, d)
			}
		} else if yyct78 == codecSelferValueTypeArray1234 {
			yyl78 := r.ReadArrayStart()
			if yyl78 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl78, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscalerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys79Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys79Slc
	var yyhl79 bool = l >= 0
	for yyj79 := 0; ; yyj79++ {
		if yyhl79 {
			if yyj79 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys79Slc = r.DecodeBytes(yys79Slc, true, true)
		yys79 := string(yys79Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys79 {
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				if x.ObservedGeneration != nil {
					x.ObservedGeneration = nil
				}
			} else {
				if x.ObservedGeneration == nil {
					x.ObservedGeneration = new(int64)
				}
				yym81 := z.DecBinary()
				_ = yym81
				if false {
				} else {
					*((*int64)(x.ObservedGeneration)) = int64(r.DecodeInt(64))
				}
			}
		case "lastScaleTime":
			if r.TryDecodeAsNil() {
				if x.LastScaleTime != nil {
					x.LastScaleTime = nil
				}
			} else {
				if x.LastScaleTime == nil {
					x.LastScaleTime = new(pkg1_unversioned.Time)
				}
				yym83 := z.DecBinary()
				_ = yym83
				if false {
				} else if z.HasExtensions() && z.DecExt(x.LastScaleTime) {
				} else if yym83 {
					z.DecBinaryUnmarshal(x.LastScaleTime)
				} else if !yym83 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.LastScaleTime)
				} else {
					z.DecFallback(x.LastScaleTime, false)
				}
			}
		case "currentReplicas":
			if r.TryDecodeAsNil() {
				x.CurrentReplicas = 0
			} else {
				x.CurrentReplicas = int32(r.DecodeInt(32))
			}
		case "desiredReplicas":
			if r.TryDecodeAsNil() {
				x.DesiredReplicas = 0
			} else {
				x.DesiredReplicas = int32(r.DecodeInt(32))
			}
		case "currentCPUUtilizationPercentage":
			if r.TryDecodeAsNil() {
				if x.CurrentCPUUtilizationPercentage != nil {
					x.CurrentCPUUtilizationPercentage = nil
				}
			} else {
				if x.CurrentCPUUtilizationPercentage == nil {
					x.CurrentCPUUtilizationPercentage = new(int32)
				}
				yym87 := z.DecBinary()
				_ = yym87
				if false {
				} else {
					*((*int32)(x.CurrentCPUUtilizationPercentage)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys79)
		} // end switch yys79
	} // end for yyj79
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscalerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj88 int
	var yyb88 bool
	var yyhl88 bool = l >= 0
	yyj88++
	if yyhl88 {
		yyb88 = yyj88 > l
	} else {
		yyb88 = r.CheckBreak()
	}
	if yyb88 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ObservedGeneration != nil {
			x.ObservedGeneration = nil
		}
	} else {
		if x.ObservedGeneration == nil {
			x.ObservedGeneration = new(int64)
		}
		yym90 := z.DecBinary()
		_ = yym90
		if false {
		} else {
			*((*int64)(x.ObservedGeneration)) = int64(r.DecodeInt(64))
		}
	}
	yyj88++
	if yyhl88 {
		yyb88 = yyj88 > l
	} else {
		yyb88 = r.CheckBreak()
	}
	if yyb88 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.LastScaleTime != nil {
			x.LastScaleTime = nil
		}
	} else {
		if x.LastScaleTime == nil {
			x.LastScaleTime = new(pkg1_unversioned.Time)
		}
		yym92 := z.DecBinary()
		_ = yym92
		if false {
		} else if z.HasExtensions() && z.DecExt(x.LastScaleTime) {
		} else if yym92 {
			z.DecBinaryUnmarshal(x.LastScaleTime)
		} else if !yym92 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.LastScaleTime)
		} else {
			z.DecFallback(x.LastScaleTime, false)
		}
	}
	yyj88++
	if yyhl88 {
		yyb88 = yyj88 > l
	} else {
		yyb88 = r.CheckBreak()
	}
	if yyb88 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CurrentReplicas = 0
	} else {
		x.CurrentReplicas = int32(r.DecodeInt(32))
	}
	yyj88++
	if yyhl88 {
		yyb88 = yyj88 > l
	} else {
		yyb88 = r.CheckBreak()
	}
	if yyb88 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DesiredReplicas = 0
	} else {
		x.DesiredReplicas = int32(r.DecodeInt(32))
	}
	yyj88++
	if yyhl88 {
		yyb88 = yyj88 > l
	} else {
		yyb88 = r.CheckBreak()
	}
	if yyb88 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CurrentCPUUtilizationPercentage != nil {
			x.CurrentCPUUtilizationPercentage = nil
		}
	} else {
		if x.CurrentCPUUtilizationPercentage == nil {
			x.CurrentCPUUtilizationPercentage = new(int32)
		}
		yym96 := z.DecBinary()
		_ = yym96
		if false {
		} else {
			*((*int32)(x.CurrentCPUUtilizationPercentage)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj88++
		if yyhl88 {
			yyb88 = yyj88 > l
		} else {
			yyb88 = r.CheckBreak()
		}
		if yyb88 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj88-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscaler) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym97 := z.EncBinary()
		_ = yym97
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep98 := !z.EncBinary()
			yy2arr98 := z.EncBasicHandle().StructToArray
			var yyq98 [5]bool
			_, _, _ = yysep98, yyq98, yy2arr98
			const yyr98 bool = false
			yyq98[0] = x.Kind != ""
			yyq98[1] = x.APIVersion != ""
			yyq98[2] = true
			yyq98[3] = true
			yyq98[4] = true
			var yynn98 int
			if yyr98 || yy2arr98 {
				r.EncodeArrayStart(5)
			} else {
				yynn98 = 0
				for _, b := range yyq98 {
					if b {
						yynn98++
					}
				}
				r.EncodeMapStart(yynn98)
				yynn98 = 0
			}
			if yyr98 || yy2arr98 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq98[0] {
					yym100 := z.EncBinary()
					_ = yym100
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq98[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym101 := z.EncBinary()
					_ = yym101
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr98 || yy2arr98 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq98[1] {
					yym103 := z.EncBinary()
					_ = yym103
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq98[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym104 := z.EncBinary()
					_ = yym104
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr98 || yy2arr98 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq98[2] {
					yy106 := &x.ObjectMeta
					yy106.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq98[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy107 := &x.ObjectMeta
					yy107.CodecEncodeSelf(e)
				}
			}
			if yyr98 || yy2arr98 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq98[3] {
					yy109 := &x.Spec
					yy109.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq98[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy110 := &x.Spec
					yy110.CodecEncodeSelf(e)
				}
			}
			if yyr98 || yy2arr98 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq98[4] {
					yy112 := &x.Status
					yy112.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq98[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy113 := &x.Status
					yy113.CodecEncodeSelf(e)
				}
			}
			if yyr98 || yy2arr98 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscaler) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym114 := z.DecBinary()
	_ = yym114
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct115 := r.ContainerType()
		if yyct115 == codecSelferValueTypeMap1234 {
			yyl115 := r.ReadMapStart()
			if yyl115 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl115, d)
			}
		} else if yyct115 == codecSelferValueTypeArray1234 {
			yyl115 := r.ReadArrayStart()
			if yyl115 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl115, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscaler) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys116Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys116Slc
	var yyhl116 bool = l >= 0
	for yyj116 := 0; ; yyj116++ {
		if yyhl116 {
			if yyj116 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys116Slc = r.DecodeBytes(yys116Slc, true, true)
		yys116 := string(yys116Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys116 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv119 := &x.ObjectMeta
				yyv119.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = HorizontalPodAutoscalerSpec{}
			} else {
				yyv120 := &x.Spec
				yyv120.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = HorizontalPodAutoscalerStatus{}
			} else {
				yyv121 := &x.Status
				yyv121.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys116)
		} // end switch yys116
	} // end for yyj116
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscaler) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj122 int
	var yyb122 bool
	var yyhl122 bool = l >= 0
	yyj122++
	if yyhl122 {
		yyb122 = yyj122 > l
	} else {
		yyb122 = r.CheckBreak()
	}
	if yyb122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj122++
	if yyhl122 {
		yyb122 = yyj122 > l
	} else {
		yyb122 = r.CheckBreak()
	}
	if yyb122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj122++
	if yyhl122 {
		yyb122 = yyj122 > l
	} else {
		yyb122 = r.CheckBreak()
	}
	if yyb122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv125 := &x.ObjectMeta
		yyv125.CodecDecodeSelf(d)
	}
	yyj122++
	if yyhl122 {
		yyb122 = yyj122 > l
	} else {
		yyb122 = r.CheckBreak()
	}
	if yyb122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = HorizontalPodAutoscalerSpec{}
	} else {
		yyv126 := &x.Spec
		yyv126.CodecDecodeSelf(d)
	}
	yyj122++
	if yyhl122 {
		yyb122 = yyj122 > l
	} else {
		yyb122 = r.CheckBreak()
	}
	if yyb122 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = HorizontalPodAutoscalerStatus{}
	} else {
		yyv127 := &x.Status
		yyv127.CodecDecodeSelf(d)
	}
	for {
		yyj122++
		if yyhl122 {
			yyb122 = yyj122 > l
		} else {
			yyb122 = r.CheckBreak()
		}
		if yyb122 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj122-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HorizontalPodAutoscalerList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym128 := z.EncBinary()
		_ = yym128
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep129 := !z.EncBinary()
			yy2arr129 := z.EncBasicHandle().StructToArray
			var yyq129 [4]bool
			_, _, _ = yysep129, yyq129, yy2arr129
			const yyr129 bool = false
			yyq129[0] = x.Kind != ""
			yyq129[1] = x.APIVersion != ""
			yyq129[2] = true
			var yynn129 int
			if yyr129 || yy2arr129 {
				r.EncodeArrayStart(4)
			} else {
				yynn129 = 1
				for _, b := range yyq129 {
					if b {
						yynn129++
					}
				}
				r.EncodeMapStart(yynn129)
				yynn129 = 0
			}
			if yyr129 || yy2arr129 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq129[0] {
					yym131 := z.EncBinary()
					_ = yym131
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq129[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym132 := z.EncBinary()
					_ = yym132
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr129 || yy2arr129 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq129[1] {
					yym134 := z.EncBinary()
					_ = yym134
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq129[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym135 := z.EncBinary()
					_ = yym135
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr129 || yy2arr129 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq129[2] {
					yy137 := &x.ListMeta
					yym138 := z.EncBinary()
					_ = yym138
					if false {
					} else if z.HasExtensions() && z.EncExt(yy137) {
					} else {
						z.EncFallback(yy137)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq129[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy139 := &x.ListMeta
					yym140 := z.EncBinary()
					_ = yym140
					if false {
					} else if z.HasExtensions() && z.EncExt(yy139) {
					} else {
						z.EncFallback(yy139)
					}
				}
			}
			if yyr129 || yy2arr129 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym142 := z.EncBinary()
					_ = yym142
					if false {
					} else {
						h.encSliceHorizontalPodAutoscaler(([]HorizontalPodAutoscaler)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym143 := z.EncBinary()
					_ = yym143
					if false {
					} else {
						h.encSliceHorizontalPodAutoscaler(([]HorizontalPodAutoscaler)(x.Items), e)
					}
				}
			}
			if yyr129 || yy2arr129 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HorizontalPodAutoscalerList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym144 := z.DecBinary()
	_ = yym144
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct145 := r.ContainerType()
		if yyct145 == codecSelferValueTypeMap1234 {
			yyl145 := r.ReadMapStart()
			if yyl145 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl145, d)
			}
		} else if yyct145 == codecSelferValueTypeArray1234 {
			yyl145 := r.ReadArrayStart()
			if yyl145 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl145, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HorizontalPodAutoscalerList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys146Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys146Slc
	var yyhl146 bool = l >= 0
	for yyj146 := 0; ; yyj146++ {
		if yyhl146 {
			if yyj146 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys146Slc = r.DecodeBytes(yys146Slc, true, true)
		yys146 := string(yys146Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys146 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg1_unversioned.ListMeta{}
			} else {
				yyv149 := &x.ListMeta
				yym150 := z.DecBinary()
				_ = yym150
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv149) {
				} else {
					z.DecFallback(yyv149, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv151 := &x.Items
				yym152 := z.DecBinary()
				_ = yym152
				if false {
				} else {
					h.decSliceHorizontalPodAutoscaler((*[]HorizontalPodAutoscaler)(yyv151), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys146)
		} // end switch yys146
	} // end for yyj146
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HorizontalPodAutoscalerList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj153 int
	var yyb153 bool
	var yyhl153 bool = l >= 0
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg1_unversioned.ListMeta{}
	} else {
		yyv156 := &x.ListMeta
		yym157 := z.DecBinary()
		_ = yym157
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv156) {
		} else {
			z.DecFallback(yyv156, false)
		}
	}
	yyj153++
	if yyhl153 {
		yyb153 = yyj153 > l
	} else {
		yyb153 = r.CheckBreak()
	}
	if yyb153 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv158 := &x.Items
		yym159 := z.DecBinary()
		_ = yym159
		if false {
		} else {
			h.decSliceHorizontalPodAutoscaler((*[]HorizontalPodAutoscaler)(yyv158), d)
		}
	}
	for {
		yyj153++
		if yyhl153 {
			yyb153 = yyj153 > l
		} else {
			yyb153 = r.CheckBreak()
		}
		if yyb153 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj153-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Scale) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym160 := z.EncBinary()
		_ = yym160
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep161 := !z.EncBinary()
			yy2arr161 := z.EncBasicHandle().StructToArray
			var yyq161 [5]bool
			_, _, _ = yysep161, yyq161, yy2arr161
			const yyr161 bool = false
			yyq161[0] = x.Kind != ""
			yyq161[1] = x.APIVersion != ""
			yyq161[2] = true
			yyq161[3] = true
			yyq161[4] = true
			var yynn161 int
			if yyr161 || yy2arr161 {
				r.EncodeArrayStart(5)
			} else {
				yynn161 = 0
				for _, b := range yyq161 {
					if b {
						yynn161++
					}
				}
				r.EncodeMapStart(yynn161)
				yynn161 = 0
			}
			if yyr161 || yy2arr161 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq161[0] {
					yym163 := z.EncBinary()
					_ = yym163
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq161[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym164 := z.EncBinary()
					_ = yym164
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr161 || yy2arr161 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq161[1] {
					yym166 := z.EncBinary()
					_ = yym166
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq161[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym167 := z.EncBinary()
					_ = yym167
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr161 || yy2arr161 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq161[2] {
					yy169 := &x.ObjectMeta
					yy169.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq161[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy170 := &x.ObjectMeta
					yy170.CodecEncodeSelf(e)
				}
			}
			if yyr161 || yy2arr161 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq161[3] {
					yy172 := &x.Spec
					yy172.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq161[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy173 := &x.Spec
					yy173.CodecEncodeSelf(e)
				}
			}
			if yyr161 || yy2arr161 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq161[4] {
					yy175 := &x.Status
					yy175.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq161[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy176 := &x.Status
					yy176.CodecEncodeSelf(e)
				}
			}
			if yyr161 || yy2arr161 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Scale) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym177 := z.DecBinary()
	_ = yym177
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct178 := r.ContainerType()
		if yyct178 == codecSelferValueTypeMap1234 {
			yyl178 := r.ReadMapStart()
			if yyl178 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl178, d)
			}
		} else if yyct178 == codecSelferValueTypeArray1234 {
			yyl178 := r.ReadArrayStart()
			if yyl178 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl178, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Scale) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys179Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys179Slc
	var yyhl179 bool = l >= 0
	for yyj179 := 0; ; yyj179++ {
		if yyhl179 {
			if yyj179 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys179Slc = r.DecodeBytes(yys179Slc, true, true)
		yys179 := string(yys179Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys179 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				x.Kind = string(r.DecodeString())
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				x.APIVersion = string(r.DecodeString())
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv182 := &x.ObjectMeta
				yyv182.CodecDecodeSelf(d)
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ScaleSpec{}
			} else {
				yyv183 := &x.Spec
				yyv183.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ScaleStatus{}
			} else {
				yyv184 := &x.Status
				yyv184.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys179)
		} // end switch yys179
	} // end for yyj179
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Scale) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj185 int
	var yyb185 bool
	var yyhl185 bool = l >= 0
	yyj185++
	if yyhl185 {
		yyb185 = yyj185 > l
	} else {
		yyb185 = r.CheckBreak()
	}
	if yyb185 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		x.Kind = string(r.DecodeString())
	}
	yyj185++
	if yyhl185 {
		yyb185 = yyj185 > l
	} else {
		yyb185 = r.CheckBreak()
	}
	if yyb185 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		x.APIVersion = string(r.DecodeString())
	}
	yyj185++
	if yyhl185 {
		yyb185 = yyj185 > l
	} else {
		yyb185 = r.CheckBreak()
	}
	if yyb185 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv188 := &x.ObjectMeta
		yyv188.CodecDecodeSelf(d)
	}
	yyj185++
	if yyhl185 {
		yyb185 = yyj185 > l
	} else {
		yyb185 = r.CheckBreak()
	}
	if yyb185 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ScaleSpec{}
	} else {
		yyv189 := &x.Spec
		yyv189.CodecDecodeSelf(d)
	}
	yyj185++
	if yyhl185 {
		yyb185 = yyj185 > l
	} else {
		yyb185 = r.CheckBreak()
	}
	if yyb185 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ScaleStatus{}
	} else {
		yyv190 := &x.Status
		yyv190.CodecDecodeSelf(d)
	}
	for {
		yyj185++
		if yyhl185 {
			yyb185 = yyj185 > l
		} else {
			yyb185 = r.CheckBreak()
		}
		if yyb185 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj185-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ScaleSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym191 := z.EncBinary()
		_ = yym191
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep192 := !z.EncBinary()
			yy2arr192 := z.EncBasicHandle().StructToArray
			var yyq192 [1]bool
			_, _, _ = yysep192, yyq192, yy2arr192
			const yyr192 bool = false
			yyq192[0] = x.Replicas != 0
			var yynn192 int
			if yyr192 || yy2arr192 {
				r.EncodeArrayStart(1)
			} else {
				yynn192 = 0
				for _, b := range yyq192 {
					if b {
						yynn192++
					}
				}
				r.EncodeMapStart(yynn192)
				yynn192 = 0
			}
			if yyr192 || yy2arr192 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq192[0] {
					yym194 := z.EncBinary()
					_ = yym194
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq192[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym195 := z.EncBinary()
					_ = yym195
					if false {
					} else {
						r.EncodeInt(int64(x.Replicas))
					}
				}
			}
			if yyr192 || yy2arr192 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ScaleSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym196 := z.DecBinary()
	_ = yym196
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct197 := r.ContainerType()
		if yyct197 == codecSelferValueTypeMap1234 {
			yyl197 := r.ReadMapStart()
			if yyl197 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl197, d)
			}
		} else if yyct197 == codecSelferValueTypeArray1234 {
			yyl197 := r.ReadArrayStart()
			if yyl197 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl197, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ScaleSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys198Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys198Slc
	var yyhl198 bool = l >= 0
	for yyj198 := 0; ; yyj198++ {
		if yyhl198 {
			if yyj198 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys198Slc = r.DecodeBytes(yys198Slc, true, true)
		yys198 := string(yys198Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys198 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		default:
			z.DecStructFieldNotFound(-1, yys198)
		} // end switch yys198
	} // end for yyj198
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ScaleSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj200 int
	var yyb200 bool
	var yyhl200 bool = l >= 0
	yyj200++
	if yyhl200 {
		yyb200 = yyj200 > l
	} else {
		yyb200 = r.CheckBreak()
	}
	if yyb200 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	for {
		yyj200++
		if yyhl200 {
			yyb200 = yyj200 > l
		} else {
			yyb200 = r.CheckBreak()
		}
		if yyb200 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj200-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ScaleStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym202 := z.EncBinary()
		_ = yym202
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep203 := !z.EncBinary()
			yy2arr203 := z.EncBasicHandle().StructToArray
			var yyq203 [2]bool
			_, _, _ = yysep203, yyq203, yy2arr203
			const yyr203 bool = false
			yyq203[1] = x.Selector != ""
			var yynn203 int
			if yyr203 || yy2arr203 {
				r.EncodeArrayStart(2)
			} else {
				yynn203 = 1
				for _, b := range yyq203 {
					if b {
						yynn203++
					}
				}
				r.EncodeMapStart(yynn203)
				yynn203 = 0
			}
			if yyr203 || yy2arr203 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym205 := z.EncBinary()
				_ = yym205
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym206 := z.EncBinary()
				_ = yym206
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr203 || yy2arr203 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq203[1] {
					yym208 := z.EncBinary()
					_ = yym208
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Selector))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq203[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym209 := z.EncBinary()
					_ = yym209
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Selector))
					}
				}
			}
			if yyr203 || yy2arr203 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ScaleStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym210 := z.DecBinary()
	_ = yym210
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct211 := r.ContainerType()
		if yyct211 == codecSelferValueTypeMap1234 {
			yyl211 := r.ReadMapStart()
			if yyl211 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl211, d)
			}
		} else if yyct211 == codecSelferValueTypeArray1234 {
			yyl211 := r.ReadArrayStart()
			if yyl211 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl211, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ScaleStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys212Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys212Slc
	var yyhl212 bool = l >= 0
	for yyj212 := 0; ; yyj212++ {
		if yyhl212 {
			if yyj212 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys212Slc = r.DecodeBytes(yys212Slc, true, true)
		yys212 := string(yys212Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys212 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				x.Replicas = int32(r.DecodeInt(32))
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = ""
			} else {
				x.Selector = string(r.DecodeString())
			}
		default:
			z.DecStructFieldNotFound(-1, yys212)
		} // end switch yys212
	} // end for yyj212
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ScaleStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj215 int
	var yyb215 bool
	var yyhl215 bool = l >= 0
	yyj215++
	if yyhl215 {
		yyb215 = yyj215 > l
	} else {
		yyb215 = r.CheckBreak()
	}
	if yyb215 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		x.Replicas = int32(r.DecodeInt(32))
	}
	yyj215++
	if yyhl215 {
		yyb215 = yyj215 > l
	} else {
		yyb215 = r.CheckBreak()
	}
	if yyb215 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = ""
	} else {
		x.Selector = string(r.DecodeString())
	}
	for {
		yyj215++
		if yyhl215 {
			yyb215 = yyj215 > l
		} else {
			yyb215 = r.CheckBreak()
		}
		if yyb215 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj215-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) encSliceHorizontalPodAutoscaler(v []HorizontalPodAutoscaler, e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	r.EncodeArrayStart(len(v))
	for _, yyv218 := range v {
		z.EncSendContainerState(codecSelfer_containerArrayElem1234)
		yy219 := &yyv218
		yy219.CodecEncodeSelf(e)
	}
	z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x codecSelfer1234) decSliceHorizontalPodAutoscaler(v *[]HorizontalPodAutoscaler, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r

	yyv220 := *v
	yyh220, yyl220 := z.DecSliceHelperStart()
	var yyc220 bool
	if yyl220 == 0 {
		if yyv220 == nil {
			yyv220 = []HorizontalPodAutoscaler{}
			yyc220 = true
		} else if len(yyv220) != 0 {
			yyv220 = yyv220[:0]
			yyc220 = true
		}
	} else if yyl220 > 0 {
		var yyrr220, yyrl220 int
		var yyrt220 bool
		if yyl220 > cap(yyv220) {

			yyrg220 := len(yyv220) > 0
			yyv2220 := yyv220
			yyrl220, yyrt220 = z.DecInferLen(yyl220, z.DecBasicHandle().MaxInitLen, 360)
			if yyrt220 {
				if yyrl220 <= cap(yyv220) {
					yyv220 = yyv220[:yyrl220]
				} else {
					yyv220 = make([]HorizontalPodAutoscaler, yyrl220)
				}
			} else {
				yyv220 = make([]HorizontalPodAutoscaler, yyrl220)
			}
			yyc220 = true
			yyrr220 = len(yyv220)
			if yyrg220 {
				copy(yyv220, yyv2220)
			}
		} else if yyl220 != len(yyv220) {
			yyv220 = yyv220[:yyl220]
			yyc220 = true
		}
		yyj220 := 0
		for ; yyj220 < yyrr220; yyj220++ {
			yyh220.ElemContainerState(yyj220)
			if r.TryDecodeAsNil() {
				yyv220[yyj220] = HorizontalPodAutoscaler{}
			} else {
				yyv221 := &yyv220[yyj220]
				yyv221.CodecDecodeSelf(d)
			}

		}
		if yyrt220 {
			for ; yyj220 < yyl220; yyj220++ {
				yyv220 = append(yyv220, HorizontalPodAutoscaler{})
				yyh220.ElemContainerState(yyj220)
				if r.TryDecodeAsNil() {
					yyv220[yyj220] = HorizontalPodAutoscaler{}
				} else {
					yyv222 := &yyv220[yyj220]
					yyv222.CodecDecodeSelf(d)
				}

			}
		}

	} else {
		yyj220 := 0
		for ; !r.CheckBreak(); yyj220++ {

			if yyj220 >= len(yyv220) {
				yyv220 = append(yyv220, HorizontalPodAutoscaler{}) // var yyz220 HorizontalPodAutoscaler
				yyc220 = true
			}
			yyh220.ElemContainerState(yyj220)
			if yyj220 < len(yyv220) {
				if r.TryDecodeAsNil() {
					yyv220[yyj220] = HorizontalPodAutoscaler{}
				} else {
					yyv223 := &yyv220[yyj220]
					yyv223.CodecDecodeSelf(d)
				}

			} else {
				z.DecSwallow()
			}

		}
		if yyj220 < len(yyv220) {
			yyv220 = yyv220[:yyj220]
			yyc220 = true
		} else if yyj220 == 0 && yyv220 == nil {
			yyv220 = []HorizontalPodAutoscaler{}
			yyc220 = true
		}
	}
	yyh220.End()
	if yyc220 {
		*v = yyv220
	}
}
