// THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT.

// Package elasticsearchservice provides a client for Amazon Elasticsearch Service.
package elasticsearchservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAddTags = "AddTags"

// AddTagsRequest generates a "aws/request.Request" representing the
// client's request for the AddTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See AddTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the AddTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the AddTagsRequest method.
//    req, resp := client.AddTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/AddTags
func (c *ElasticsearchService) AddTagsRequest(input *AddTagsInput) (req *request.Request, output *AddTagsOutput) {
	op := &request.Operation{
		Name:       opAddTags,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/tags",
	}

	if input == nil {
		input = &AddTagsInput{}
	}

	output = &AddTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// AddTags API operation for Amazon Elasticsearch Service.
//
// Attaches tags to an existing Elasticsearch domain. Tags are a set of case-sensitive
// key value pairs. An Elasticsearch domain may have up to 10 tags. See  Tagging
// Amazon Elasticsearch Service Domains for more information. (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-awsresorcetagging)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation AddTags for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * LimitExceededException
//   An exception for trying to create more than allowed resources or sub-resources.
//   Gives http status code of 409.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/AddTags
func (c *ElasticsearchService) AddTags(input *AddTagsInput) (*AddTagsOutput, error) {
	req, out := c.AddTagsRequest(input)
	err := req.Send()
	return out, err
}

const opCreateElasticsearchDomain = "CreateElasticsearchDomain"

// CreateElasticsearchDomainRequest generates a "aws/request.Request" representing the
// client's request for the CreateElasticsearchDomain operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See CreateElasticsearchDomain for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the CreateElasticsearchDomain method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the CreateElasticsearchDomainRequest method.
//    req, resp := client.CreateElasticsearchDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/CreateElasticsearchDomain
func (c *ElasticsearchService) CreateElasticsearchDomainRequest(input *CreateElasticsearchDomainInput) (req *request.Request, output *CreateElasticsearchDomainOutput) {
	op := &request.Operation{
		Name:       opCreateElasticsearchDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/domain",
	}

	if input == nil {
		input = &CreateElasticsearchDomainInput{}
	}

	output = &CreateElasticsearchDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateElasticsearchDomain API operation for Amazon Elasticsearch Service.
//
// Creates a new Elasticsearch domain. For more information, see Creating Elasticsearch
// Domains (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains)
// in the Amazon Elasticsearch Service Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation CreateElasticsearchDomain for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * DisabledOperationException
//   An error occured because the client wanted to access a not supported operation.
//   Gives http status code of 409.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * InvalidTypeException
//   An exception for trying to create or access sub-resource that is either invalid
//   or not supported. Gives http status code of 409.
//
//   * LimitExceededException
//   An exception for trying to create more than allowed resources or sub-resources.
//   Gives http status code of 409.
//
//   * ResourceAlreadyExistsException
//   An exception for creating a resource that already exists. Gives http status
//   code of 400.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/CreateElasticsearchDomain
func (c *ElasticsearchService) CreateElasticsearchDomain(input *CreateElasticsearchDomainInput) (*CreateElasticsearchDomainOutput, error) {
	req, out := c.CreateElasticsearchDomainRequest(input)
	err := req.Send()
	return out, err
}

const opDeleteElasticsearchDomain = "DeleteElasticsearchDomain"

// DeleteElasticsearchDomainRequest generates a "aws/request.Request" representing the
// client's request for the DeleteElasticsearchDomain operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DeleteElasticsearchDomain for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DeleteElasticsearchDomain method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DeleteElasticsearchDomainRequest method.
//    req, resp := client.DeleteElasticsearchDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/DeleteElasticsearchDomain
func (c *ElasticsearchService) DeleteElasticsearchDomainRequest(input *DeleteElasticsearchDomainInput) (req *request.Request, output *DeleteElasticsearchDomainOutput) {
	op := &request.Operation{
		Name:       opDeleteElasticsearchDomain,
		HTTPMethod: "DELETE",
		HTTPPath:   "/2015-01-01/es/domain/{DomainName}",
	}

	if input == nil {
		input = &DeleteElasticsearchDomainInput{}
	}

	output = &DeleteElasticsearchDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteElasticsearchDomain API operation for Amazon Elasticsearch Service.
//
// Permanently deletes the specified Elasticsearch domain and all of its data.
// Once a domain is deleted, it cannot be recovered.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DeleteElasticsearchDomain for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/DeleteElasticsearchDomain
func (c *ElasticsearchService) DeleteElasticsearchDomain(input *DeleteElasticsearchDomainInput) (*DeleteElasticsearchDomainOutput, error) {
	req, out := c.DeleteElasticsearchDomainRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeElasticsearchDomain = "DescribeElasticsearchDomain"

// DescribeElasticsearchDomainRequest generates a "aws/request.Request" representing the
// client's request for the DescribeElasticsearchDomain operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeElasticsearchDomain for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeElasticsearchDomain method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeElasticsearchDomainRequest method.
//    req, resp := client.DescribeElasticsearchDomainRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/DescribeElasticsearchDomain
func (c *ElasticsearchService) DescribeElasticsearchDomainRequest(input *DescribeElasticsearchDomainInput) (req *request.Request, output *DescribeElasticsearchDomainOutput) {
	op := &request.Operation{
		Name:       opDescribeElasticsearchDomain,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/domain/{DomainName}",
	}

	if input == nil {
		input = &DescribeElasticsearchDomainInput{}
	}

	output = &DescribeElasticsearchDomainOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeElasticsearchDomain API operation for Amazon Elasticsearch Service.
//
// Returns domain configuration information about the specified Elasticsearch
// domain, including the domain ID, domain endpoint, and domain ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeElasticsearchDomain for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/DescribeElasticsearchDomain
func (c *ElasticsearchService) DescribeElasticsearchDomain(input *DescribeElasticsearchDomainInput) (*DescribeElasticsearchDomainOutput, error) {
	req, out := c.DescribeElasticsearchDomainRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeElasticsearchDomainConfig = "DescribeElasticsearchDomainConfig"

// DescribeElasticsearchDomainConfigRequest generates a "aws/request.Request" representing the
// client's request for the DescribeElasticsearchDomainConfig operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeElasticsearchDomainConfig for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeElasticsearchDomainConfig method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeElasticsearchDomainConfigRequest method.
//    req, resp := client.DescribeElasticsearchDomainConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/DescribeElasticsearchDomainConfig
func (c *ElasticsearchService) DescribeElasticsearchDomainConfigRequest(input *DescribeElasticsearchDomainConfigInput) (req *request.Request, output *DescribeElasticsearchDomainConfigOutput) {
	op := &request.Operation{
		Name:       opDescribeElasticsearchDomainConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/domain/{DomainName}/config",
	}

	if input == nil {
		input = &DescribeElasticsearchDomainConfigInput{}
	}

	output = &DescribeElasticsearchDomainConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeElasticsearchDomainConfig API operation for Amazon Elasticsearch Service.
//
// Provides cluster configuration information about the specified Elasticsearch
// domain, such as the state, creation date, update version, and update date
// for cluster options.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeElasticsearchDomainConfig for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/DescribeElasticsearchDomainConfig
func (c *ElasticsearchService) DescribeElasticsearchDomainConfig(input *DescribeElasticsearchDomainConfigInput) (*DescribeElasticsearchDomainConfigOutput, error) {
	req, out := c.DescribeElasticsearchDomainConfigRequest(input)
	err := req.Send()
	return out, err
}

const opDescribeElasticsearchDomains = "DescribeElasticsearchDomains"

// DescribeElasticsearchDomainsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeElasticsearchDomains operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See DescribeElasticsearchDomains for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the DescribeElasticsearchDomains method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the DescribeElasticsearchDomainsRequest method.
//    req, resp := client.DescribeElasticsearchDomainsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/DescribeElasticsearchDomains
func (c *ElasticsearchService) DescribeElasticsearchDomainsRequest(input *DescribeElasticsearchDomainsInput) (req *request.Request, output *DescribeElasticsearchDomainsOutput) {
	op := &request.Operation{
		Name:       opDescribeElasticsearchDomains,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/domain-info",
	}

	if input == nil {
		input = &DescribeElasticsearchDomainsInput{}
	}

	output = &DescribeElasticsearchDomainsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeElasticsearchDomains API operation for Amazon Elasticsearch Service.
//
// Returns domain configuration information about the specified Elasticsearch
// domains, including the domain ID, domain endpoint, and domain ARN.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation DescribeElasticsearchDomains for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/DescribeElasticsearchDomains
func (c *ElasticsearchService) DescribeElasticsearchDomains(input *DescribeElasticsearchDomainsInput) (*DescribeElasticsearchDomainsOutput, error) {
	req, out := c.DescribeElasticsearchDomainsRequest(input)
	err := req.Send()
	return out, err
}

const opListDomainNames = "ListDomainNames"

// ListDomainNamesRequest generates a "aws/request.Request" representing the
// client's request for the ListDomainNames operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListDomainNames for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListDomainNames method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListDomainNamesRequest method.
//    req, resp := client.ListDomainNamesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/ListDomainNames
func (c *ElasticsearchService) ListDomainNamesRequest(input *ListDomainNamesInput) (req *request.Request, output *ListDomainNamesOutput) {
	op := &request.Operation{
		Name:       opListDomainNames,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/domain",
	}

	if input == nil {
		input = &ListDomainNamesInput{}
	}

	output = &ListDomainNamesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDomainNames API operation for Amazon Elasticsearch Service.
//
// Returns the name of all Elasticsearch domains owned by the current user's
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation ListDomainNames for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/ListDomainNames
func (c *ElasticsearchService) ListDomainNames(input *ListDomainNamesInput) (*ListDomainNamesOutput, error) {
	req, out := c.ListDomainNamesRequest(input)
	err := req.Send()
	return out, err
}

const opListTags = "ListTags"

// ListTagsRequest generates a "aws/request.Request" representing the
// client's request for the ListTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See ListTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the ListTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the ListTagsRequest method.
//    req, resp := client.ListTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/ListTags
func (c *ElasticsearchService) ListTagsRequest(input *ListTagsInput) (req *request.Request, output *ListTagsOutput) {
	op := &request.Operation{
		Name:       opListTags,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/tags/",
	}

	if input == nil {
		input = &ListTagsInput{}
	}

	output = &ListTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTags API operation for Amazon Elasticsearch Service.
//
// Returns all tags for the given Elasticsearch domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation ListTags for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/ListTags
func (c *ElasticsearchService) ListTags(input *ListTagsInput) (*ListTagsOutput, error) {
	req, out := c.ListTagsRequest(input)
	err := req.Send()
	return out, err
}

const opRemoveTags = "RemoveTags"

// RemoveTagsRequest generates a "aws/request.Request" representing the
// client's request for the RemoveTags operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See RemoveTags for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the RemoveTags method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the RemoveTagsRequest method.
//    req, resp := client.RemoveTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/RemoveTags
func (c *ElasticsearchService) RemoveTagsRequest(input *RemoveTagsInput) (req *request.Request, output *RemoveTagsOutput) {
	op := &request.Operation{
		Name:       opRemoveTags,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/tags-removal",
	}

	if input == nil {
		input = &RemoveTagsInput{}
	}

	output = &RemoveTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return
}

// RemoveTags API operation for Amazon Elasticsearch Service.
//
// Removes the specified set of tags from the specified Elasticsearch domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation RemoveTags for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/RemoveTags
func (c *ElasticsearchService) RemoveTags(input *RemoveTagsInput) (*RemoveTagsOutput, error) {
	req, out := c.RemoveTagsRequest(input)
	err := req.Send()
	return out, err
}

const opUpdateElasticsearchDomainConfig = "UpdateElasticsearchDomainConfig"

// UpdateElasticsearchDomainConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateElasticsearchDomainConfig operation. The "output" return
// value can be used to capture response data after the request's "Send" method
// is called.
//
// See UpdateElasticsearchDomainConfig for usage and error information.
//
// Creating a request object using this method should be used when you want to inject
// custom logic into the request's lifecycle using a custom handler, or if you want to
// access properties on the request object before or after sending the request. If
// you just want the service response, call the UpdateElasticsearchDomainConfig method directly
// instead.
//
// Note: You must call the "Send" method on the returned request object in order
// to execute the request.
//
//    // Example sending a request using the UpdateElasticsearchDomainConfigRequest method.
//    req, resp := client.UpdateElasticsearchDomainConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/UpdateElasticsearchDomainConfig
func (c *ElasticsearchService) UpdateElasticsearchDomainConfigRequest(input *UpdateElasticsearchDomainConfigInput) (req *request.Request, output *UpdateElasticsearchDomainConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateElasticsearchDomainConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/2015-01-01/es/domain/{DomainName}/config",
	}

	if input == nil {
		input = &UpdateElasticsearchDomainConfigInput{}
	}

	output = &UpdateElasticsearchDomainConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateElasticsearchDomainConfig API operation for Amazon Elasticsearch Service.
//
// Modifies the cluster configuration of the specified Elasticsearch domain,
// setting as setting the instance type and the number of instances.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Elasticsearch Service's
// API operation UpdateElasticsearchDomainConfig for usage and error information.
//
// Returned Error Codes:
//   * BaseException
//   An error occurred while processing the request.
//
//   * InternalException
//   The request processing has failed because of an unknown error, exception
//   or failure (the failure is internal to the service) . Gives http status code
//   of 500.
//
//   * InvalidTypeException
//   An exception for trying to create or access sub-resource that is either invalid
//   or not supported. Gives http status code of 409.
//
//   * LimitExceededException
//   An exception for trying to create more than allowed resources or sub-resources.
//   Gives http status code of 409.
//
//   * ResourceNotFoundException
//   An exception for accessing or deleting a resource that does not exist. Gives
//   http status code of 400.
//
//   * ValidationException
//   An exception for missing / invalid input fields. Gives http status code of
//   400.
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/UpdateElasticsearchDomainConfig
func (c *ElasticsearchService) UpdateElasticsearchDomainConfig(input *UpdateElasticsearchDomainConfigInput) (*UpdateElasticsearchDomainConfigOutput, error) {
	req, out := c.UpdateElasticsearchDomainConfigRequest(input)
	err := req.Send()
	return out, err
}

// The configured access rules for the domain's document and search endpoints,
// and the current status of those rules.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/AccessPoliciesStatus
type AccessPoliciesStatus struct {
	_ struct{} `type:"structure"`

	// The access policy configured for the Elasticsearch domain. Access policies
	// may be resource-based, IP-based, or IAM-based. See  Configuring Access Policies
	// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-access-policies)for
	// more information.
	//
	// Options is a required field
	Options *string `type:"string" required:"true"`

	// The status of the access policy for the Elasticsearch domain. See OptionStatus
	// for the status information that's included.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s AccessPoliciesStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessPoliciesStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *AccessPoliciesStatus) SetOptions(v string) *AccessPoliciesStatus {
	s.Options = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AccessPoliciesStatus) SetStatus(v *OptionStatus) *AccessPoliciesStatus {
	s.Status = v
	return s
}

// Container for the parameters to the AddTags operation. Specify the tags that
// you want to attach to the Elasticsearch domain.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/AddTagsRequest
type AddTagsInput struct {
	_ struct{} `type:"structure"`

	// Specify the ARN for which you want to add the tags.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// List of Tag that need to be added for the Elasticsearch domain.
	//
	// TagList is a required field
	TagList []*Tag `type:"list" required:"true"`
}

// String returns the string representation
func (s AddTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AddTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AddTagsInput"}
	if s.ARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ARN"))
	}
	if s.TagList == nil {
		invalidParams.Add(request.NewErrParamRequired("TagList"))
	}
	if s.TagList != nil {
		for i, v := range s.TagList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *AddTagsInput) SetARN(v string) *AddTagsInput {
	s.ARN = &v
	return s
}

// SetTagList sets the TagList field's value.
func (s *AddTagsInput) SetTagList(v []*Tag) *AddTagsInput {
	s.TagList = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/AddTagsOutput
type AddTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s AddTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AddTagsOutput) GoString() string {
	return s.String()
}

// Status of the advanced options for the specified Elasticsearch domain. Currently,
// the following advanced options are available:
//
//    * Option to allow references to indices in an HTTP request body. Must
//    be false when configuring access to individual sub-resources. By default,
//    the value is true. See Configuration Advanced Options (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options)
//    for more information.
//    * Option to specify the percentage of heap space that is allocated to
//    field data. By default, this setting is unbounded.
// For more information, see Configuring Advanced Options (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/AdvancedOptionsStatus
type AdvancedOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the status of advanced options for the specified Elasticsearch
	// domain.
	//
	// Options is a required field
	Options map[string]*string `type:"map" required:"true"`

	// Specifies the status of OptionStatus for advanced options for the specified
	// Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s AdvancedOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AdvancedOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *AdvancedOptionsStatus) SetOptions(v map[string]*string) *AdvancedOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *AdvancedOptionsStatus) SetStatus(v *OptionStatus) *AdvancedOptionsStatus {
	s.Status = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/CreateElasticsearchDomainRequest
type CreateElasticsearchDomainInput struct {
	_ struct{} `type:"structure"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *string `type:"string"`

	// Option to allow references to indices in an HTTP request body. Must be false
	// when configuring access to individual sub-resources. By default, the value
	// is true. See Configuration Advanced Options (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options)
	// for more information.
	AdvancedOptions map[string]*string `type:"map"`

	// The name of the Elasticsearch domain that you are creating. Domain names
	// are unique across the domains owned by an account within an AWS region. Domain
	// names must start with a letter or number and can contain the following characters:
	// a-z (lowercase), 0-9, and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// Options to enable, disable and specify the type and size of EBS storage volumes.
	EBSOptions *EBSOptions `type:"structure"`

	// Configuration options for an Elasticsearch domain. Specifies the instance
	// type and number of instances in the domain cluster.
	ElasticsearchClusterConfig *ElasticsearchClusterConfig `type:"structure"`

	// String of format X.Y to specify version for the Elasticsearch domain eg.
	// "1.5" or "2.3". For more information, see Creating Elasticsearch Domains
	// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomains)
	// in the Amazon Elasticsearch Service Developer Guide.
	ElasticsearchVersion *string `type:"string"`

	// Option to set time, in UTC format, of the daily automated snapshot. Default
	// value is 0 hours.
	SnapshotOptions *SnapshotOptions `type:"structure"`
}

// String returns the string representation
func (s CreateElasticsearchDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateElasticsearchDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateElasticsearchDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateElasticsearchDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *CreateElasticsearchDomainInput) SetAccessPolicies(v string) *CreateElasticsearchDomainInput {
	s.AccessPolicies = &v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *CreateElasticsearchDomainInput) SetAdvancedOptions(v map[string]*string) *CreateElasticsearchDomainInput {
	s.AdvancedOptions = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateElasticsearchDomainInput) SetDomainName(v string) *CreateElasticsearchDomainInput {
	s.DomainName = &v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *CreateElasticsearchDomainInput) SetEBSOptions(v *EBSOptions) *CreateElasticsearchDomainInput {
	s.EBSOptions = v
	return s
}

// SetElasticsearchClusterConfig sets the ElasticsearchClusterConfig field's value.
func (s *CreateElasticsearchDomainInput) SetElasticsearchClusterConfig(v *ElasticsearchClusterConfig) *CreateElasticsearchDomainInput {
	s.ElasticsearchClusterConfig = v
	return s
}

// SetElasticsearchVersion sets the ElasticsearchVersion field's value.
func (s *CreateElasticsearchDomainInput) SetElasticsearchVersion(v string) *CreateElasticsearchDomainInput {
	s.ElasticsearchVersion = &v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *CreateElasticsearchDomainInput) SetSnapshotOptions(v *SnapshotOptions) *CreateElasticsearchDomainInput {
	s.SnapshotOptions = v
	return s
}

// The result of a CreateElasticsearchDomain operation. Contains the status
// of the newly created Elasticsearch domain.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/CreateElasticsearchDomainResponse
type CreateElasticsearchDomainOutput struct {
	_ struct{} `type:"structure"`

	// The status of the newly created Elasticsearch domain.
	DomainStatus *ElasticsearchDomainStatus `type:"structure"`
}

// String returns the string representation
func (s CreateElasticsearchDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateElasticsearchDomainOutput) GoString() string {
	return s.String()
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *CreateElasticsearchDomainOutput) SetDomainStatus(v *ElasticsearchDomainStatus) *CreateElasticsearchDomainOutput {
	s.DomainStatus = v
	return s
}

// Container for the parameters to the DeleteElasticsearchDomain operation.
// Specifies the name of the Elasticsearch domain that you want to delete.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/DeleteElasticsearchDomainRequest
type DeleteElasticsearchDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the Elasticsearch domain that you want to permanently delete.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteElasticsearchDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteElasticsearchDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteElasticsearchDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteElasticsearchDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteElasticsearchDomainInput) SetDomainName(v string) *DeleteElasticsearchDomainInput {
	s.DomainName = &v
	return s
}

// The result of a DeleteElasticsearchDomain request. Contains the status of
// the pending deletion, or no status if the domain and all of its resources
// have been deleted.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/DeleteElasticsearchDomainResponse
type DeleteElasticsearchDomainOutput struct {
	_ struct{} `type:"structure"`

	// The status of the Elasticsearch domain being deleted.
	DomainStatus *ElasticsearchDomainStatus `type:"structure"`
}

// String returns the string representation
func (s DeleteElasticsearchDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteElasticsearchDomainOutput) GoString() string {
	return s.String()
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *DeleteElasticsearchDomainOutput) SetDomainStatus(v *ElasticsearchDomainStatus) *DeleteElasticsearchDomainOutput {
	s.DomainStatus = v
	return s
}

// Container for the parameters to the DescribeElasticsearchDomainConfig operation.
// Specifies the domain name for which you want configuration information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/DescribeElasticsearchDomainConfigRequest
type DescribeElasticsearchDomainConfigInput struct {
	_ struct{} `type:"structure"`

	// The Elasticsearch domain that you want to get information about.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchDomainConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeElasticsearchDomainConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeElasticsearchDomainConfigInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeElasticsearchDomainConfigInput) SetDomainName(v string) *DescribeElasticsearchDomainConfigInput {
	s.DomainName = &v
	return s
}

// The result of a DescribeElasticsearchDomainConfig request. Contains the configuration
// information of the requested domain.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/DescribeElasticsearchDomainConfigResponse
type DescribeElasticsearchDomainConfigOutput struct {
	_ struct{} `type:"structure"`

	// The configuration information of the domain requested in the DescribeElasticsearchDomainConfig
	// request.
	//
	// DomainConfig is a required field
	DomainConfig *ElasticsearchDomainConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchDomainConfigOutput) GoString() string {
	return s.String()
}

// SetDomainConfig sets the DomainConfig field's value.
func (s *DescribeElasticsearchDomainConfigOutput) SetDomainConfig(v *ElasticsearchDomainConfig) *DescribeElasticsearchDomainConfigOutput {
	s.DomainConfig = v
	return s
}

// Container for the parameters to the DescribeElasticsearchDomain operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/DescribeElasticsearchDomainRequest
type DescribeElasticsearchDomainInput struct {
	_ struct{} `type:"structure"`

	// The name of the Elasticsearch domain for which you want information.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchDomainInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeElasticsearchDomainInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeElasticsearchDomainInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DescribeElasticsearchDomainInput) SetDomainName(v string) *DescribeElasticsearchDomainInput {
	s.DomainName = &v
	return s
}

// The result of a DescribeElasticsearchDomain request. Contains the status
// of the domain specified in the request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/DescribeElasticsearchDomainResponse
type DescribeElasticsearchDomainOutput struct {
	_ struct{} `type:"structure"`

	// The current status of the Elasticsearch domain.
	//
	// DomainStatus is a required field
	DomainStatus *ElasticsearchDomainStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchDomainOutput) GoString() string {
	return s.String()
}

// SetDomainStatus sets the DomainStatus field's value.
func (s *DescribeElasticsearchDomainOutput) SetDomainStatus(v *ElasticsearchDomainStatus) *DescribeElasticsearchDomainOutput {
	s.DomainStatus = v
	return s
}

// Container for the parameters to the DescribeElasticsearchDomains operation.
// By default, the API returns the status of all Elasticsearch domains.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/DescribeElasticsearchDomainsRequest
type DescribeElasticsearchDomainsInput struct {
	_ struct{} `type:"structure"`

	// The Elasticsearch domains for which you want information.
	//
	// DomainNames is a required field
	DomainNames []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchDomainsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeElasticsearchDomainsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeElasticsearchDomainsInput"}
	if s.DomainNames == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainNames"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainNames sets the DomainNames field's value.
func (s *DescribeElasticsearchDomainsInput) SetDomainNames(v []*string) *DescribeElasticsearchDomainsInput {
	s.DomainNames = v
	return s
}

// The result of a DescribeElasticsearchDomains request. Contains the status
// of the specified domains or all domains owned by the account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/DescribeElasticsearchDomainsResponse
type DescribeElasticsearchDomainsOutput struct {
	_ struct{} `type:"structure"`

	// The status of the domains requested in the DescribeElasticsearchDomains request.
	//
	// DomainStatusList is a required field
	DomainStatusList []*ElasticsearchDomainStatus `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeElasticsearchDomainsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeElasticsearchDomainsOutput) GoString() string {
	return s.String()
}

// SetDomainStatusList sets the DomainStatusList field's value.
func (s *DescribeElasticsearchDomainsOutput) SetDomainStatusList(v []*ElasticsearchDomainStatus) *DescribeElasticsearchDomainsOutput {
	s.DomainStatusList = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/DomainInfo
type DomainInfo struct {
	_ struct{} `type:"structure"`

	// Specifies the DomainName.
	DomainName *string `min:"3" type:"string"`
}

// String returns the string representation
func (s DomainInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainInfo) GoString() string {
	return s.String()
}

// SetDomainName sets the DomainName field's value.
func (s *DomainInfo) SetDomainName(v string) *DomainInfo {
	s.DomainName = &v
	return s
}

// Options to enable, disable, and specify the properties of EBS storage volumes.
// For more information, see  Configuring EBS-based Storage (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/EBSOptions
type EBSOptions struct {
	_ struct{} `type:"structure"`

	// Specifies whether EBS-based storage is enabled.
	EBSEnabled *bool `type:"boolean"`

	// Specifies the IOPD for a Provisioned IOPS EBS volume (SSD).
	Iops *int64 `type:"integer"`

	// Integer to specify the size of an EBS volume.
	VolumeSize *int64 `type:"integer"`

	// Specifies the volume type for EBS-based storage.
	VolumeType *string `type:"string" enum:"VolumeType"`
}

// String returns the string representation
func (s EBSOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EBSOptions) GoString() string {
	return s.String()
}

// SetEBSEnabled sets the EBSEnabled field's value.
func (s *EBSOptions) SetEBSEnabled(v bool) *EBSOptions {
	s.EBSEnabled = &v
	return s
}

// SetIops sets the Iops field's value.
func (s *EBSOptions) SetIops(v int64) *EBSOptions {
	s.Iops = &v
	return s
}

// SetVolumeSize sets the VolumeSize field's value.
func (s *EBSOptions) SetVolumeSize(v int64) *EBSOptions {
	s.VolumeSize = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *EBSOptions) SetVolumeType(v string) *EBSOptions {
	s.VolumeType = &v
	return s
}

// Status of the EBS options for the specified Elasticsearch domain.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/EBSOptionsStatus
type EBSOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the EBS options for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *EBSOptions `type:"structure" required:"true"`

	// Specifies the status of the EBS options for the specified Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s EBSOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EBSOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *EBSOptionsStatus) SetOptions(v *EBSOptions) *EBSOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *EBSOptionsStatus) SetStatus(v *OptionStatus) *EBSOptionsStatus {
	s.Status = v
	return s
}

// Specifies the configuration for the domain cluster, such as the type and
// number of instances.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/ElasticsearchClusterConfig
type ElasticsearchClusterConfig struct {
	_ struct{} `type:"structure"`

	// Total number of dedicated master nodes, active and on standby, for the cluster.
	DedicatedMasterCount *int64 `type:"integer"`

	// A boolean value to indicate whether a dedicated master node is enabled. See
	// About Dedicated Master Nodes (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-dedicatedmasternodes)
	// for more information.
	DedicatedMasterEnabled *bool `type:"boolean"`

	// The instance type for a dedicated master node.
	DedicatedMasterType *string `type:"string" enum:"ESPartitionInstanceType"`

	// The number of instances in the specified domain cluster.
	InstanceCount *int64 `type:"integer"`

	// The instance type for an Elasticsearch cluster.
	InstanceType *string `type:"string" enum:"ESPartitionInstanceType"`

	// A boolean value to indicate whether zone awareness is enabled. See About
	// Zone Awareness (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-managedomains.html#es-managedomains-zoneawareness)
	// for more information.
	ZoneAwarenessEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s ElasticsearchClusterConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchClusterConfig) GoString() string {
	return s.String()
}

// SetDedicatedMasterCount sets the DedicatedMasterCount field's value.
func (s *ElasticsearchClusterConfig) SetDedicatedMasterCount(v int64) *ElasticsearchClusterConfig {
	s.DedicatedMasterCount = &v
	return s
}

// SetDedicatedMasterEnabled sets the DedicatedMasterEnabled field's value.
func (s *ElasticsearchClusterConfig) SetDedicatedMasterEnabled(v bool) *ElasticsearchClusterConfig {
	s.DedicatedMasterEnabled = &v
	return s
}

// SetDedicatedMasterType sets the DedicatedMasterType field's value.
func (s *ElasticsearchClusterConfig) SetDedicatedMasterType(v string) *ElasticsearchClusterConfig {
	s.DedicatedMasterType = &v
	return s
}

// SetInstanceCount sets the InstanceCount field's value.
func (s *ElasticsearchClusterConfig) SetInstanceCount(v int64) *ElasticsearchClusterConfig {
	s.InstanceCount = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *ElasticsearchClusterConfig) SetInstanceType(v string) *ElasticsearchClusterConfig {
	s.InstanceType = &v
	return s
}

// SetZoneAwarenessEnabled sets the ZoneAwarenessEnabled field's value.
func (s *ElasticsearchClusterConfig) SetZoneAwarenessEnabled(v bool) *ElasticsearchClusterConfig {
	s.ZoneAwarenessEnabled = &v
	return s
}

// Specifies the configuration status for the specified Elasticsearch domain.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/ElasticsearchClusterConfigStatus
type ElasticsearchClusterConfigStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the cluster configuration for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *ElasticsearchClusterConfig `type:"structure" required:"true"`

	// Specifies the status of the configuration for the specified Elasticsearch
	// domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s ElasticsearchClusterConfigStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchClusterConfigStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *ElasticsearchClusterConfigStatus) SetOptions(v *ElasticsearchClusterConfig) *ElasticsearchClusterConfigStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ElasticsearchClusterConfigStatus) SetStatus(v *OptionStatus) *ElasticsearchClusterConfigStatus {
	s.Status = v
	return s
}

// The configuration of an Elasticsearch domain.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/ElasticsearchDomainConfig
type ElasticsearchDomainConfig struct {
	_ struct{} `type:"structure"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *AccessPoliciesStatus `type:"structure"`

	// Specifies the AdvancedOptions for the domain. See Configuring Advanced Options
	// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options)
	// for more information.
	AdvancedOptions *AdvancedOptionsStatus `type:"structure"`

	// Specifies the EBSOptions for the Elasticsearch domain.
	EBSOptions *EBSOptionsStatus `type:"structure"`

	// Specifies the ElasticsearchClusterConfig for the Elasticsearch domain.
	ElasticsearchClusterConfig *ElasticsearchClusterConfigStatus `type:"structure"`

	// String of format X.Y to specify version for the Elasticsearch domain.
	ElasticsearchVersion *ElasticsearchVersionStatus `type:"structure"`

	// Specifies the SnapshotOptions for the Elasticsearch domain.
	SnapshotOptions *SnapshotOptionsStatus `type:"structure"`
}

// String returns the string representation
func (s ElasticsearchDomainConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchDomainConfig) GoString() string {
	return s.String()
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *ElasticsearchDomainConfig) SetAccessPolicies(v *AccessPoliciesStatus) *ElasticsearchDomainConfig {
	s.AccessPolicies = v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *ElasticsearchDomainConfig) SetAdvancedOptions(v *AdvancedOptionsStatus) *ElasticsearchDomainConfig {
	s.AdvancedOptions = v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *ElasticsearchDomainConfig) SetEBSOptions(v *EBSOptionsStatus) *ElasticsearchDomainConfig {
	s.EBSOptions = v
	return s
}

// SetElasticsearchClusterConfig sets the ElasticsearchClusterConfig field's value.
func (s *ElasticsearchDomainConfig) SetElasticsearchClusterConfig(v *ElasticsearchClusterConfigStatus) *ElasticsearchDomainConfig {
	s.ElasticsearchClusterConfig = v
	return s
}

// SetElasticsearchVersion sets the ElasticsearchVersion field's value.
func (s *ElasticsearchDomainConfig) SetElasticsearchVersion(v *ElasticsearchVersionStatus) *ElasticsearchDomainConfig {
	s.ElasticsearchVersion = v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *ElasticsearchDomainConfig) SetSnapshotOptions(v *SnapshotOptionsStatus) *ElasticsearchDomainConfig {
	s.SnapshotOptions = v
	return s
}

// The current status of an Elasticsearch domain.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/ElasticsearchDomainStatus
type ElasticsearchDomainStatus struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) of an Elasticsearch domain. See Identifiers
	// for IAM Entities (http://docs.aws.amazon.com/IAM/latest/UserGuide/index.html?Using_Identifiers.html)
	// in Using AWS Identity and Access Management for more information.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *string `type:"string"`

	// Specifies the status of the AdvancedOptions
	AdvancedOptions map[string]*string `type:"map"`

	// The domain creation status. True if the creation of an Elasticsearch domain
	// is complete. False if domain creation is still in progress.
	Created *bool `type:"boolean"`

	// The domain deletion status. True if a delete request has been received for
	// the domain but resource cleanup is still in progress. False if the domain
	// has not been deleted. Once domain deletion is complete, the status of the
	// domain is no longer returned.
	Deleted *bool `type:"boolean"`

	// The unique identifier for the specified Elasticsearch domain.
	//
	// DomainId is a required field
	DomainId *string `min:"1" type:"string" required:"true"`

	// The name of an Elasticsearch domain. Domain names are unique across the domains
	// owned by an account within an AWS region. Domain names start with a letter
	// or number and can contain the following characters: a-z (lowercase), 0-9,
	// and - (hyphen).
	//
	// DomainName is a required field
	DomainName *string `min:"3" type:"string" required:"true"`

	// The EBSOptions for the specified domain. See Configuring EBS-based Storage
	// (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs)
	// for more information.
	EBSOptions *EBSOptions `type:"structure"`

	// The type and number of instances in the domain cluster.
	//
	// ElasticsearchClusterConfig is a required field
	ElasticsearchClusterConfig *ElasticsearchClusterConfig `type:"structure" required:"true"`

	ElasticsearchVersion *string `type:"string"`

	// The Elasticsearch domain endpoint that you use to submit index and search
	// requests.
	Endpoint *string `type:"string"`

	// The status of the Elasticsearch domain configuration. True if Amazon Elasticsearch
	// Service is processing configuration changes. False if the configuration is
	// active.
	Processing *bool `type:"boolean"`

	// Specifies the status of the SnapshotOptions
	SnapshotOptions *SnapshotOptions `type:"structure"`
}

// String returns the string representation
func (s ElasticsearchDomainStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchDomainStatus) GoString() string {
	return s.String()
}

// SetARN sets the ARN field's value.
func (s *ElasticsearchDomainStatus) SetARN(v string) *ElasticsearchDomainStatus {
	s.ARN = &v
	return s
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *ElasticsearchDomainStatus) SetAccessPolicies(v string) *ElasticsearchDomainStatus {
	s.AccessPolicies = &v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *ElasticsearchDomainStatus) SetAdvancedOptions(v map[string]*string) *ElasticsearchDomainStatus {
	s.AdvancedOptions = v
	return s
}

// SetCreated sets the Created field's value.
func (s *ElasticsearchDomainStatus) SetCreated(v bool) *ElasticsearchDomainStatus {
	s.Created = &v
	return s
}

// SetDeleted sets the Deleted field's value.
func (s *ElasticsearchDomainStatus) SetDeleted(v bool) *ElasticsearchDomainStatus {
	s.Deleted = &v
	return s
}

// SetDomainId sets the DomainId field's value.
func (s *ElasticsearchDomainStatus) SetDomainId(v string) *ElasticsearchDomainStatus {
	s.DomainId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *ElasticsearchDomainStatus) SetDomainName(v string) *ElasticsearchDomainStatus {
	s.DomainName = &v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *ElasticsearchDomainStatus) SetEBSOptions(v *EBSOptions) *ElasticsearchDomainStatus {
	s.EBSOptions = v
	return s
}

// SetElasticsearchClusterConfig sets the ElasticsearchClusterConfig field's value.
func (s *ElasticsearchDomainStatus) SetElasticsearchClusterConfig(v *ElasticsearchClusterConfig) *ElasticsearchDomainStatus {
	s.ElasticsearchClusterConfig = v
	return s
}

// SetElasticsearchVersion sets the ElasticsearchVersion field's value.
func (s *ElasticsearchDomainStatus) SetElasticsearchVersion(v string) *ElasticsearchDomainStatus {
	s.ElasticsearchVersion = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *ElasticsearchDomainStatus) SetEndpoint(v string) *ElasticsearchDomainStatus {
	s.Endpoint = &v
	return s
}

// SetProcessing sets the Processing field's value.
func (s *ElasticsearchDomainStatus) SetProcessing(v bool) *ElasticsearchDomainStatus {
	s.Processing = &v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *ElasticsearchDomainStatus) SetSnapshotOptions(v *SnapshotOptions) *ElasticsearchDomainStatus {
	s.SnapshotOptions = v
	return s
}

// Status of the Elasticsearch version options for the specified Elasticsearch
// domain.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/ElasticsearchVersionStatus
type ElasticsearchVersionStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the Elasticsearch version for the specified Elasticsearch domain.
	//
	// Options is a required field
	Options *string `type:"string" required:"true"`

	// Specifies the status of the Elasticsearch version options for the specified
	// Elasticsearch domain.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s ElasticsearchVersionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ElasticsearchVersionStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *ElasticsearchVersionStatus) SetOptions(v string) *ElasticsearchVersionStatus {
	s.Options = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ElasticsearchVersionStatus) SetStatus(v *OptionStatus) *ElasticsearchVersionStatus {
	s.Status = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/ListDomainNamesInput
type ListDomainNamesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ListDomainNamesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainNamesInput) GoString() string {
	return s.String()
}

// The result of a ListDomainNames operation. Contains the names of all Elasticsearch
// domains owned by this account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/ListDomainNamesResponse
type ListDomainNamesOutput struct {
	_ struct{} `type:"structure"`

	// List of Elasticsearch domain names.
	DomainNames []*DomainInfo `type:"list"`
}

// String returns the string representation
func (s ListDomainNamesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainNamesOutput) GoString() string {
	return s.String()
}

// SetDomainNames sets the DomainNames field's value.
func (s *ListDomainNamesOutput) SetDomainNames(v []*DomainInfo) *ListDomainNamesOutput {
	s.DomainNames = v
	return s
}

// Container for the parameters to the ListTags operation. Specify the ARN for
// the Elasticsearch domain to which the tags are attached that you want to
// view are attached.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/ListTagsRequest
type ListTagsInput struct {
	_ struct{} `type:"structure"`

	// Specify the ARN for the Elasticsearch domain to which the tags are attached
	// that you want to view.
	//
	// ARN is a required field
	ARN *string `location:"querystring" locationName:"arn" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsInput"}
	if s.ARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ARN"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *ListTagsInput) SetARN(v string) *ListTagsInput {
	s.ARN = &v
	return s
}

// The result of a ListTags operation. Contains tags for all requested Elasticsearch
// domains.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/ListTagsResponse
type ListTagsOutput struct {
	_ struct{} `type:"structure"`

	// List of Tag for the requested Elasticsearch domain.
	TagList []*Tag `type:"list"`
}

// String returns the string representation
func (s ListTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *ListTagsOutput) SetTagList(v []*Tag) *ListTagsOutput {
	s.TagList = v
	return s
}

// Provides the current status of the entity.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/OptionStatus
type OptionStatus struct {
	_ struct{} `type:"structure"`

	// Timestamp which tells the creation date for the entity.
	//
	// CreationDate is a required field
	CreationDate *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// Indicates whether the Elasticsearch domain is being deleted.
	PendingDeletion *bool `type:"boolean"`

	// Provides the OptionState for the Elasticsearch domain.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"OptionState"`

	// Timestamp which tells the last updated time for the entity.
	//
	// UpdateDate is a required field
	UpdateDate *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`

	// Specifies the latest version for the entity.
	UpdateVersion *int64 `type:"integer"`
}

// String returns the string representation
func (s OptionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionStatus) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *OptionStatus) SetCreationDate(v time.Time) *OptionStatus {
	s.CreationDate = &v
	return s
}

// SetPendingDeletion sets the PendingDeletion field's value.
func (s *OptionStatus) SetPendingDeletion(v bool) *OptionStatus {
	s.PendingDeletion = &v
	return s
}

// SetState sets the State field's value.
func (s *OptionStatus) SetState(v string) *OptionStatus {
	s.State = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *OptionStatus) SetUpdateDate(v time.Time) *OptionStatus {
	s.UpdateDate = &v
	return s
}

// SetUpdateVersion sets the UpdateVersion field's value.
func (s *OptionStatus) SetUpdateVersion(v int64) *OptionStatus {
	s.UpdateVersion = &v
	return s
}

// Container for the parameters to the RemoveTags operation. Specify the ARN
// for the Elasticsearch domain from which you want to remove the specified
// TagKey.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/RemoveTagsRequest
type RemoveTagsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the ARN for the Elasticsearch domain from which you want to delete
	// the specified tags.
	//
	// ARN is a required field
	ARN *string `type:"string" required:"true"`

	// Specifies the TagKey list which you want to remove from the Elasticsearch
	// domain.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RemoveTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemoveTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RemoveTagsInput"}
	if s.ARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ARN"))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetARN sets the ARN field's value.
func (s *RemoveTagsInput) SetARN(v string) *RemoveTagsInput {
	s.ARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *RemoveTagsInput) SetTagKeys(v []*string) *RemoveTagsInput {
	s.TagKeys = v
	return s
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/RemoveTagsOutput
type RemoveTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RemoveTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RemoveTagsOutput) GoString() string {
	return s.String()
}

// Specifies the time, in UTC format, when the service takes a daily automated
// snapshot of the specified Elasticsearch domain. Default value is 0 hours.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/SnapshotOptions
type SnapshotOptions struct {
	_ struct{} `type:"structure"`

	// Specifies the time, in UTC format, when the service takes a daily automated
	// snapshot of the specified Elasticsearch domain. Default value is 0 hours.
	AutomatedSnapshotStartHour *int64 `type:"integer"`
}

// String returns the string representation
func (s SnapshotOptions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnapshotOptions) GoString() string {
	return s.String()
}

// SetAutomatedSnapshotStartHour sets the AutomatedSnapshotStartHour field's value.
func (s *SnapshotOptions) SetAutomatedSnapshotStartHour(v int64) *SnapshotOptions {
	s.AutomatedSnapshotStartHour = &v
	return s
}

// Status of a daily automated snapshot.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/SnapshotOptionsStatus
type SnapshotOptionsStatus struct {
	_ struct{} `type:"structure"`

	// Specifies the daily snapshot options specified for the Elasticsearch domain.
	//
	// Options is a required field
	Options *SnapshotOptions `type:"structure" required:"true"`

	// Specifies the status of a daily automated snapshot.
	//
	// Status is a required field
	Status *OptionStatus `type:"structure" required:"true"`
}

// String returns the string representation
func (s SnapshotOptionsStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SnapshotOptionsStatus) GoString() string {
	return s.String()
}

// SetOptions sets the Options field's value.
func (s *SnapshotOptionsStatus) SetOptions(v *SnapshotOptions) *SnapshotOptionsStatus {
	s.Options = v
	return s
}

// SetStatus sets the Status field's value.
func (s *SnapshotOptionsStatus) SetStatus(v *OptionStatus) *SnapshotOptionsStatus {
	s.Status = v
	return s
}

// Specifies a key value pair for a resource tag.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// Specifies the TagKey, the name of the tag. Tag keys must be unique for the
	// Elasticsearch domain to which they are attached.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Specifies the TagValue, the value assigned to the corresponding tag key.
	// Tag values can be null and do not have to be unique in a tag set. For example,
	// you can have a key value pair in a tag set of project : Trinity and cost-center
	// : Trinity
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Container for the parameters to the UpdateElasticsearchDomain operation.
// Specifies the type and number of instances in the domain cluster.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/UpdateElasticsearchDomainConfigRequest
type UpdateElasticsearchDomainConfigInput struct {
	_ struct{} `type:"structure"`

	// IAM access policy as a JSON-formatted string.
	AccessPolicies *string `type:"string"`

	// Modifies the advanced option to allow references to indices in an HTTP request
	// body. Must be false when configuring access to individual sub-resources.
	// By default, the value is true. See Configuration Advanced Options (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-advanced-options)
	// for more information.
	AdvancedOptions map[string]*string `type:"map"`

	// The name of the Elasticsearch domain that you are updating.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"DomainName" min:"3" type:"string" required:"true"`

	// Specify the type and size of the EBS volume that you want to use.
	EBSOptions *EBSOptions `type:"structure"`

	// The type and number of instances to instantiate for the domain cluster.
	ElasticsearchClusterConfig *ElasticsearchClusterConfig `type:"structure"`

	// Option to set the time, in UTC format, for the daily automated snapshot.
	// Default value is 0 hours.
	SnapshotOptions *SnapshotOptions `type:"structure"`
}

// String returns the string representation
func (s UpdateElasticsearchDomainConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateElasticsearchDomainConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateElasticsearchDomainConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateElasticsearchDomainConfigInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccessPolicies sets the AccessPolicies field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetAccessPolicies(v string) *UpdateElasticsearchDomainConfigInput {
	s.AccessPolicies = &v
	return s
}

// SetAdvancedOptions sets the AdvancedOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetAdvancedOptions(v map[string]*string) *UpdateElasticsearchDomainConfigInput {
	s.AdvancedOptions = v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetDomainName(v string) *UpdateElasticsearchDomainConfigInput {
	s.DomainName = &v
	return s
}

// SetEBSOptions sets the EBSOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetEBSOptions(v *EBSOptions) *UpdateElasticsearchDomainConfigInput {
	s.EBSOptions = v
	return s
}

// SetElasticsearchClusterConfig sets the ElasticsearchClusterConfig field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetElasticsearchClusterConfig(v *ElasticsearchClusterConfig) *UpdateElasticsearchDomainConfigInput {
	s.ElasticsearchClusterConfig = v
	return s
}

// SetSnapshotOptions sets the SnapshotOptions field's value.
func (s *UpdateElasticsearchDomainConfigInput) SetSnapshotOptions(v *SnapshotOptions) *UpdateElasticsearchDomainConfigInput {
	s.SnapshotOptions = v
	return s
}

// The result of an UpdateElasticsearchDomain request. Contains the status of
// the Elasticsearch domain being updated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/es-2015-01-01/UpdateElasticsearchDomainConfigResponse
type UpdateElasticsearchDomainConfigOutput struct {
	_ struct{} `type:"structure"`

	// The status of the updated Elasticsearch domain.
	//
	// DomainConfig is a required field
	DomainConfig *ElasticsearchDomainConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateElasticsearchDomainConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateElasticsearchDomainConfigOutput) GoString() string {
	return s.String()
}

// SetDomainConfig sets the DomainConfig field's value.
func (s *UpdateElasticsearchDomainConfigOutput) SetDomainConfig(v *ElasticsearchDomainConfig) *UpdateElasticsearchDomainConfigOutput {
	s.DomainConfig = v
	return s
}

const (
	// ESPartitionInstanceTypeM3MediumElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM3MediumElasticsearch = "m3.medium.elasticsearch"

	// ESPartitionInstanceTypeM3LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM3LargeElasticsearch = "m3.large.elasticsearch"

	// ESPartitionInstanceTypeM3XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM3XlargeElasticsearch = "m3.xlarge.elasticsearch"

	// ESPartitionInstanceTypeM32xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM32xlargeElasticsearch = "m3.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeM4LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM4LargeElasticsearch = "m4.large.elasticsearch"

	// ESPartitionInstanceTypeM4XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM4XlargeElasticsearch = "m4.xlarge.elasticsearch"

	// ESPartitionInstanceTypeM42xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM42xlargeElasticsearch = "m4.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeM44xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM44xlargeElasticsearch = "m4.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeM410xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeM410xlargeElasticsearch = "m4.10xlarge.elasticsearch"

	// ESPartitionInstanceTypeT2MicroElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeT2MicroElasticsearch = "t2.micro.elasticsearch"

	// ESPartitionInstanceTypeT2SmallElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeT2SmallElasticsearch = "t2.small.elasticsearch"

	// ESPartitionInstanceTypeT2MediumElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeT2MediumElasticsearch = "t2.medium.elasticsearch"

	// ESPartitionInstanceTypeR3LargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR3LargeElasticsearch = "r3.large.elasticsearch"

	// ESPartitionInstanceTypeR3XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR3XlargeElasticsearch = "r3.xlarge.elasticsearch"

	// ESPartitionInstanceTypeR32xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR32xlargeElasticsearch = "r3.2xlarge.elasticsearch"

	// ESPartitionInstanceTypeR34xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR34xlargeElasticsearch = "r3.4xlarge.elasticsearch"

	// ESPartitionInstanceTypeR38xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeR38xlargeElasticsearch = "r3.8xlarge.elasticsearch"

	// ESPartitionInstanceTypeI2XlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeI2XlargeElasticsearch = "i2.xlarge.elasticsearch"

	// ESPartitionInstanceTypeI22xlargeElasticsearch is a ESPartitionInstanceType enum value
	ESPartitionInstanceTypeI22xlargeElasticsearch = "i2.2xlarge.elasticsearch"
)

// The state of a requested change. One of the following:
//
//    * Processing: The request change is still in-process.
//    * Active: The request change is processed and deployed to the Elasticsearch
//    domain.
const (
	// OptionStateRequiresIndexDocuments is a OptionState enum value
	OptionStateRequiresIndexDocuments = "RequiresIndexDocuments"

	// OptionStateProcessing is a OptionState enum value
	OptionStateProcessing = "Processing"

	// OptionStateActive is a OptionState enum value
	OptionStateActive = "Active"
)

// The type of EBS volume, standard, gp2, or io1. See Configuring EBS-based
// Storage (http://docs.aws.amazon.com/elasticsearch-service/latest/developerguide/es-createupdatedomains.html#es-createdomain-configure-ebs)for
// more information.
const (
	// VolumeTypeStandard is a VolumeType enum value
	VolumeTypeStandard = "standard"

	// VolumeTypeGp2 is a VolumeType enum value
	VolumeTypeGp2 = "gp2"

	// VolumeTypeIo1 is a VolumeType enum value
	VolumeTypeIo1 = "io1"
)
