/* automatically generated by rust-bindgen 0.59.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const __WORDSIZE: u32 = 64;
pub const __DARWIN_ONLY_64_BIT_INO_T: u32 = 0;
pub const __DARWIN_ONLY_UNIX_CONFORMANCE: u32 = 1;
pub const __DARWIN_ONLY_VERS_1050: u32 = 0;
pub const __DARWIN_UNIX03: u32 = 1;
pub const __DARWIN_64_BIT_INO_T: u32 = 1;
pub const __DARWIN_VERS_1050: u32 = 1;
pub const __DARWIN_NON_CANCELABLE: u32 = 0;
pub const __DARWIN_SUF_64_BIT_INO_T: &'static [u8; 9usize] = b"$INODE64\0";
pub const __DARWIN_SUF_1050: &'static [u8; 6usize] = b"$1050\0";
pub const __DARWIN_SUF_EXTSN: &'static [u8; 14usize] = b"$DARWIN_EXTSN\0";
pub const __DARWIN_C_ANSI: u32 = 4096;
pub const __DARWIN_C_FULL: u32 = 900000;
pub const __DARWIN_C_LEVEL: u32 = 900000;
pub const __STDC_WANT_LIB_EXT1__: u32 = 1;
pub const __DARWIN_NO_LONG_LONG: u32 = 0;
pub const _DARWIN_FEATURE_64_BIT_INODE: u32 = 1;
pub const _DARWIN_FEATURE_ONLY_UNIX_CONFORMANCE: u32 = 1;
pub const _DARWIN_FEATURE_UNIX_CONFORMANCE: u32 = 3;
pub const __PTHREAD_SIZE__: u32 = 8176;
pub const __PTHREAD_ATTR_SIZE__: u32 = 56;
pub const __PTHREAD_MUTEXATTR_SIZE__: u32 = 8;
pub const __PTHREAD_MUTEX_SIZE__: u32 = 56;
pub const __PTHREAD_CONDATTR_SIZE__: u32 = 8;
pub const __PTHREAD_COND_SIZE__: u32 = 40;
pub const __PTHREAD_ONCE_SIZE__: u32 = 8;
pub const __PTHREAD_RWLOCK_SIZE__: u32 = 192;
pub const __PTHREAD_RWLOCKATTR_SIZE__: u32 = 16;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const INT64_MAX: u64 = 9223372036854775807;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT64_MIN: i64 = -9223372036854775808;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const UINT64_MAX: i32 = -1;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST64_MIN: i64 = -9223372036854775808;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const INT_LEAST64_MAX: u64 = 9223372036854775807;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const UINT_LEAST64_MAX: i32 = -1;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i32 = -32768;
pub const INT_FAST32_MIN: i32 = -2147483648;
pub const INT_FAST64_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u32 = 32767;
pub const INT_FAST32_MAX: u32 = 2147483647;
pub const INT_FAST64_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: u32 = 65535;
pub const UINT_FAST32_MAX: u32 = 4294967295;
pub const UINT_FAST64_MAX: i32 = -1;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const UINTPTR_MAX: i32 = -1;
pub const SIZE_MAX: i32 = -1;
pub const RSIZE_MAX: i32 = -1;
pub const WINT_MIN: i32 = -2147483648;
pub const WINT_MAX: u32 = 2147483647;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const TSS2_RC_LAYER_SHIFT: u32 = 16;
pub const TSS2_BASE_RC_GENERAL_FAILURE: u32 = 1;
pub const TSS2_BASE_RC_NOT_IMPLEMENTED: u32 = 2;
pub const TSS2_BASE_RC_BAD_CONTEXT: u32 = 3;
pub const TSS2_BASE_RC_ABI_MISMATCH: u32 = 4;
pub const TSS2_BASE_RC_BAD_REFERENCE: u32 = 5;
pub const TSS2_BASE_RC_INSUFFICIENT_BUFFER: u32 = 6;
pub const TSS2_BASE_RC_BAD_SEQUENCE: u32 = 7;
pub const TSS2_BASE_RC_NO_CONNECTION: u32 = 8;
pub const TSS2_BASE_RC_TRY_AGAIN: u32 = 9;
pub const TSS2_BASE_RC_IO_ERROR: u32 = 10;
pub const TSS2_BASE_RC_BAD_VALUE: u32 = 11;
pub const TSS2_BASE_RC_NOT_PERMITTED: u32 = 12;
pub const TSS2_BASE_RC_INVALID_SESSIONS: u32 = 13;
pub const TSS2_BASE_RC_NO_DECRYPT_PARAM: u32 = 14;
pub const TSS2_BASE_RC_NO_ENCRYPT_PARAM: u32 = 15;
pub const TSS2_BASE_RC_BAD_SIZE: u32 = 16;
pub const TSS2_BASE_RC_MALFORMED_RESPONSE: u32 = 17;
pub const TSS2_BASE_RC_INSUFFICIENT_CONTEXT: u32 = 18;
pub const TSS2_BASE_RC_INSUFFICIENT_RESPONSE: u32 = 19;
pub const TSS2_BASE_RC_INCOMPATIBLE_TCTI: u32 = 20;
pub const TSS2_BASE_RC_NOT_SUPPORTED: u32 = 21;
pub const TSS2_BASE_RC_BAD_TCTI_STRUCTURE: u32 = 22;
pub const TSS2_BASE_RC_MEMORY: u32 = 23;
pub const TSS2_BASE_RC_BAD_TR: u32 = 24;
pub const TSS2_BASE_RC_MULTIPLE_DECRYPT_SESSIONS: u32 = 25;
pub const TSS2_BASE_RC_MULTIPLE_ENCRYPT_SESSIONS: u32 = 26;
pub const TSS2_BASE_RC_RSP_AUTH_FAILED: u32 = 27;
pub const TSS2_LAYER_IMPLEMENTATION_SPECIFIC_OFFSET: u32 = 63488;
pub const TSS2_LEVEL_IMPLEMENTATION_SPECIFIC_SHIFT: u32 = 11;
pub const TPM2_MAX_COMMAND_SIZE: u32 = 4096;
pub const TPM2_MAX_RESPONSE_SIZE: u32 = 4096;
pub const TPM2_NUM_PCR_BANKS: u32 = 16;
pub const TPM2_MAX_DIGEST_BUFFER: u32 = 1024;
pub const TPM2_MAX_NV_BUFFER_SIZE: u32 = 2048;
pub const TPM2_MAX_PCRS: u32 = 32;
pub const TPM2_MAX_ALG_LIST_SIZE: u32 = 128;
pub const TPM2_MAX_CAP_CC: u32 = 256;
pub const TPM2_MAX_CAP_BUFFER: u32 = 1024;
pub const TPM2_MAX_CONTEXT_SIZE: u32 = 5120;
pub const TPM2_SHA_DIGEST_SIZE: u32 = 20;
pub const TPM2_SHA1_DIGEST_SIZE: u32 = 20;
pub const TPM2_SHA256_DIGEST_SIZE: u32 = 32;
pub const TPM2_SHA384_DIGEST_SIZE: u32 = 48;
pub const TPM2_SHA512_DIGEST_SIZE: u32 = 64;
pub const TPM2_SM3_256_DIGEST_SIZE: u32 = 32;
pub const TPM2_MAX_SYM_BLOCK_SIZE: u32 = 16;
pub const TPM2_MAX_SYM_DATA: u32 = 256;
pub const TPM2_MAX_ECC_KEY_BYTES: u32 = 128;
pub const TPM2_MAX_SYM_KEY_BYTES: u32 = 32;
pub const TPM2_MAX_RSA_KEY_BYTES: u32 = 512;
pub const TPM2_LABEL_MAX_BUFFER: u32 = 32;
pub const TPM2_PCR_SELECT_MAX: u32 = 4;
pub const TPM2_PRIVATE_VENDOR_SPECIFIC_BYTES: u32 = 1280;
pub const TPMA_LOCALITY_EXTENDED_SHIFT: u32 = 5;
pub const TPMA_CC_COMMANDINDEX_SHIFT: u32 = 0;
pub const TPMA_CC_CHANDLES_SHIFT: u32 = 25;
pub const TPMA_CC_RES_SHIFT: u32 = 30;
pub const TPM2_NO: u32 = 0;
pub const TPM2_YES: u32 = 1;
pub const TPM2_NV_INDEX_INDEX_SHIFT: u32 = 0;
pub const TPM2_NV_INDEX_RH_NV_SHIFT: u32 = 24;
pub const TPMA_NV_TPM2_NT_SHIFT: u32 = 4;
pub const POLLIN: u32 = 1;
pub const POLLPRI: u32 = 2;
pub const POLLOUT: u32 = 4;
pub const POLLRDNORM: u32 = 64;
pub const POLLWRNORM: u32 = 4;
pub const POLLRDBAND: u32 = 128;
pub const POLLWRBAND: u32 = 256;
pub const POLLEXTEND: u32 = 512;
pub const POLLATTRIB: u32 = 1024;
pub const POLLNLINK: u32 = 2048;
pub const POLLWRITE: u32 = 4096;
pub const POLLERR: u32 = 8;
pub const POLLHUP: u32 = 16;
pub const POLLNVAL: u32 = 32;
pub const POLLSTANDARD: u32 = 511;
pub const TSS2_TCTI_TIMEOUT_BLOCK: i32 = -1;
pub const TSS2_TCTI_TIMEOUT_NONE: u32 = 0;
pub const TSS2_TCTI_INFO_SYMBOL: &'static [u8; 15usize] = b"Tss2_Tcti_Info\0";
pub const TSS2_SYS_MAX_SESSIONS: u32 = 3;
pub const ESYS_TR_NONE: u32 = 4095;
pub const ESYS_TR_PASSWORD: u32 = 255;
pub const ESYS_TR_PCR0: u32 = 0;
pub const ESYS_TR_PCR1: u32 = 1;
pub const ESYS_TR_PCR2: u32 = 2;
pub const ESYS_TR_PCR3: u32 = 3;
pub const ESYS_TR_PCR4: u32 = 4;
pub const ESYS_TR_PCR5: u32 = 5;
pub const ESYS_TR_PCR6: u32 = 6;
pub const ESYS_TR_PCR7: u32 = 7;
pub const ESYS_TR_PCR8: u32 = 8;
pub const ESYS_TR_PCR9: u32 = 9;
pub const ESYS_TR_PCR10: u32 = 10;
pub const ESYS_TR_PCR11: u32 = 11;
pub const ESYS_TR_PCR12: u32 = 12;
pub const ESYS_TR_PCR13: u32 = 13;
pub const ESYS_TR_PCR14: u32 = 14;
pub const ESYS_TR_PCR15: u32 = 15;
pub const ESYS_TR_PCR16: u32 = 16;
pub const ESYS_TR_PCR17: u32 = 17;
pub const ESYS_TR_PCR18: u32 = 18;
pub const ESYS_TR_PCR19: u32 = 19;
pub const ESYS_TR_PCR20: u32 = 20;
pub const ESYS_TR_PCR21: u32 = 21;
pub const ESYS_TR_PCR22: u32 = 22;
pub const ESYS_TR_PCR23: u32 = 23;
pub const ESYS_TR_PCR24: u32 = 24;
pub const ESYS_TR_PCR25: u32 = 25;
pub const ESYS_TR_PCR26: u32 = 26;
pub const ESYS_TR_PCR27: u32 = 27;
pub const ESYS_TR_PCR28: u32 = 28;
pub const ESYS_TR_PCR29: u32 = 29;
pub const ESYS_TR_PCR30: u32 = 30;
pub const ESYS_TR_PCR31: u32 = 31;
pub const ESYS_TR_RH_OWNER: u32 = 257;
pub const ESYS_TR_RH_NULL: u32 = 263;
pub const ESYS_TR_RH_LOCKOUT: u32 = 266;
pub const ESYS_TR_RH_ENDORSEMENT: u32 = 267;
pub const ESYS_TR_RH_PLATFORM: u32 = 268;
pub const ESYS_TR_RH_PLATFORM_NV: u32 = 269;
pub const ESYS_TR_RH_AUTH_FIRST: u32 = 272;
pub const ESYS_TR_MIN_OBJECT: u32 = 4096;
pub const __PRI_8_LENGTH_MODIFIER__: &'static [u8; 3usize] = b"hh\0";
pub const __PRI_64_LENGTH_MODIFIER__: &'static [u8; 3usize] = b"ll\0";
pub const __SCN_64_LENGTH_MODIFIER__: &'static [u8; 3usize] = b"ll\0";
pub const __PRI_MAX_LENGTH_MODIFIER__: &'static [u8; 2usize] = b"j\0";
pub const __SCN_MAX_LENGTH_MODIFIER__: &'static [u8; 2usize] = b"j\0";
pub const PRId8: &'static [u8; 4usize] = b"hhd\0";
pub const PRIi8: &'static [u8; 4usize] = b"hhi\0";
pub const PRIo8: &'static [u8; 4usize] = b"hho\0";
pub const PRIu8: &'static [u8; 4usize] = b"hhu\0";
pub const PRIx8: &'static [u8; 4usize] = b"hhx\0";
pub const PRIX8: &'static [u8; 4usize] = b"hhX\0";
pub const PRId16: &'static [u8; 3usize] = b"hd\0";
pub const PRIi16: &'static [u8; 3usize] = b"hi\0";
pub const PRIo16: &'static [u8; 3usize] = b"ho\0";
pub const PRIu16: &'static [u8; 3usize] = b"hu\0";
pub const PRIx16: &'static [u8; 3usize] = b"hx\0";
pub const PRIX16: &'static [u8; 3usize] = b"hX\0";
pub const PRId32: &'static [u8; 2usize] = b"d\0";
pub const PRIi32: &'static [u8; 2usize] = b"i\0";
pub const PRIo32: &'static [u8; 2usize] = b"o\0";
pub const PRIu32: &'static [u8; 2usize] = b"u\0";
pub const PRIx32: &'static [u8; 2usize] = b"x\0";
pub const PRIX32: &'static [u8; 2usize] = b"X\0";
pub const PRId64: &'static [u8; 4usize] = b"lld\0";
pub const PRIi64: &'static [u8; 4usize] = b"lli\0";
pub const PRIo64: &'static [u8; 4usize] = b"llo\0";
pub const PRIu64: &'static [u8; 4usize] = b"llu\0";
pub const PRIx64: &'static [u8; 4usize] = b"llx\0";
pub const PRIX64: &'static [u8; 4usize] = b"llX\0";
pub const PRIdLEAST8: &'static [u8; 4usize] = b"hhd\0";
pub const PRIiLEAST8: &'static [u8; 4usize] = b"hhi\0";
pub const PRIoLEAST8: &'static [u8; 4usize] = b"hho\0";
pub const PRIuLEAST8: &'static [u8; 4usize] = b"hhu\0";
pub const PRIxLEAST8: &'static [u8; 4usize] = b"hhx\0";
pub const PRIXLEAST8: &'static [u8; 4usize] = b"hhX\0";
pub const PRIdLEAST16: &'static [u8; 3usize] = b"hd\0";
pub const PRIiLEAST16: &'static [u8; 3usize] = b"hi\0";
pub const PRIoLEAST16: &'static [u8; 3usize] = b"ho\0";
pub const PRIuLEAST16: &'static [u8; 3usize] = b"hu\0";
pub const PRIxLEAST16: &'static [u8; 3usize] = b"hx\0";
pub const PRIXLEAST16: &'static [u8; 3usize] = b"hX\0";
pub const PRIdLEAST32: &'static [u8; 2usize] = b"d\0";
pub const PRIiLEAST32: &'static [u8; 2usize] = b"i\0";
pub const PRIoLEAST32: &'static [u8; 2usize] = b"o\0";
pub const PRIuLEAST32: &'static [u8; 2usize] = b"u\0";
pub const PRIxLEAST32: &'static [u8; 2usize] = b"x\0";
pub const PRIXLEAST32: &'static [u8; 2usize] = b"X\0";
pub const PRIdLEAST64: &'static [u8; 4usize] = b"lld\0";
pub const PRIiLEAST64: &'static [u8; 4usize] = b"lli\0";
pub const PRIoLEAST64: &'static [u8; 4usize] = b"llo\0";
pub const PRIuLEAST64: &'static [u8; 4usize] = b"llu\0";
pub const PRIxLEAST64: &'static [u8; 4usize] = b"llx\0";
pub const PRIXLEAST64: &'static [u8; 4usize] = b"llX\0";
pub const PRIdFAST8: &'static [u8; 4usize] = b"hhd\0";
pub const PRIiFAST8: &'static [u8; 4usize] = b"hhi\0";
pub const PRIoFAST8: &'static [u8; 4usize] = b"hho\0";
pub const PRIuFAST8: &'static [u8; 4usize] = b"hhu\0";
pub const PRIxFAST8: &'static [u8; 4usize] = b"hhx\0";
pub const PRIXFAST8: &'static [u8; 4usize] = b"hhX\0";
pub const PRIdFAST16: &'static [u8; 3usize] = b"hd\0";
pub const PRIiFAST16: &'static [u8; 3usize] = b"hi\0";
pub const PRIoFAST16: &'static [u8; 3usize] = b"ho\0";
pub const PRIuFAST16: &'static [u8; 3usize] = b"hu\0";
pub const PRIxFAST16: &'static [u8; 3usize] = b"hx\0";
pub const PRIXFAST16: &'static [u8; 3usize] = b"hX\0";
pub const PRIdFAST32: &'static [u8; 2usize] = b"d\0";
pub const PRIiFAST32: &'static [u8; 2usize] = b"i\0";
pub const PRIoFAST32: &'static [u8; 2usize] = b"o\0";
pub const PRIuFAST32: &'static [u8; 2usize] = b"u\0";
pub const PRIxFAST32: &'static [u8; 2usize] = b"x\0";
pub const PRIXFAST32: &'static [u8; 2usize] = b"X\0";
pub const PRIdFAST64: &'static [u8; 4usize] = b"lld\0";
pub const PRIiFAST64: &'static [u8; 4usize] = b"lli\0";
pub const PRIoFAST64: &'static [u8; 4usize] = b"llo\0";
pub const PRIuFAST64: &'static [u8; 4usize] = b"llu\0";
pub const PRIxFAST64: &'static [u8; 4usize] = b"llx\0";
pub const PRIXFAST64: &'static [u8; 4usize] = b"llX\0";
pub const PRIdPTR: &'static [u8; 3usize] = b"ld\0";
pub const PRIiPTR: &'static [u8; 3usize] = b"li\0";
pub const PRIoPTR: &'static [u8; 3usize] = b"lo\0";
pub const PRIuPTR: &'static [u8; 3usize] = b"lu\0";
pub const PRIxPTR: &'static [u8; 3usize] = b"lx\0";
pub const PRIXPTR: &'static [u8; 3usize] = b"lX\0";
pub const PRIdMAX: &'static [u8; 3usize] = b"jd\0";
pub const PRIiMAX: &'static [u8; 3usize] = b"ji\0";
pub const PRIoMAX: &'static [u8; 3usize] = b"jo\0";
pub const PRIuMAX: &'static [u8; 3usize] = b"ju\0";
pub const PRIxMAX: &'static [u8; 3usize] = b"jx\0";
pub const PRIXMAX: &'static [u8; 3usize] = b"jX\0";
pub const SCNd8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNi8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNo8: &'static [u8; 4usize] = b"hho\0";
pub const SCNu8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNx8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNd16: &'static [u8; 3usize] = b"hd\0";
pub const SCNi16: &'static [u8; 3usize] = b"hi\0";
pub const SCNo16: &'static [u8; 3usize] = b"ho\0";
pub const SCNu16: &'static [u8; 3usize] = b"hu\0";
pub const SCNx16: &'static [u8; 3usize] = b"hx\0";
pub const SCNd32: &'static [u8; 2usize] = b"d\0";
pub const SCNi32: &'static [u8; 2usize] = b"i\0";
pub const SCNo32: &'static [u8; 2usize] = b"o\0";
pub const SCNu32: &'static [u8; 2usize] = b"u\0";
pub const SCNx32: &'static [u8; 2usize] = b"x\0";
pub const SCNd64: &'static [u8; 4usize] = b"lld\0";
pub const SCNi64: &'static [u8; 4usize] = b"lli\0";
pub const SCNo64: &'static [u8; 4usize] = b"llo\0";
pub const SCNu64: &'static [u8; 4usize] = b"llu\0";
pub const SCNx64: &'static [u8; 4usize] = b"llx\0";
pub const SCNdLEAST8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNiLEAST8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNoLEAST8: &'static [u8; 4usize] = b"hho\0";
pub const SCNuLEAST8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNxLEAST8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNdLEAST16: &'static [u8; 3usize] = b"hd\0";
pub const SCNiLEAST16: &'static [u8; 3usize] = b"hi\0";
pub const SCNoLEAST16: &'static [u8; 3usize] = b"ho\0";
pub const SCNuLEAST16: &'static [u8; 3usize] = b"hu\0";
pub const SCNxLEAST16: &'static [u8; 3usize] = b"hx\0";
pub const SCNdLEAST32: &'static [u8; 2usize] = b"d\0";
pub const SCNiLEAST32: &'static [u8; 2usize] = b"i\0";
pub const SCNoLEAST32: &'static [u8; 2usize] = b"o\0";
pub const SCNuLEAST32: &'static [u8; 2usize] = b"u\0";
pub const SCNxLEAST32: &'static [u8; 2usize] = b"x\0";
pub const SCNdLEAST64: &'static [u8; 4usize] = b"lld\0";
pub const SCNiLEAST64: &'static [u8; 4usize] = b"lli\0";
pub const SCNoLEAST64: &'static [u8; 4usize] = b"llo\0";
pub const SCNuLEAST64: &'static [u8; 4usize] = b"llu\0";
pub const SCNxLEAST64: &'static [u8; 4usize] = b"llx\0";
pub const SCNdFAST8: &'static [u8; 4usize] = b"hhd\0";
pub const SCNiFAST8: &'static [u8; 4usize] = b"hhi\0";
pub const SCNoFAST8: &'static [u8; 4usize] = b"hho\0";
pub const SCNuFAST8: &'static [u8; 4usize] = b"hhu\0";
pub const SCNxFAST8: &'static [u8; 4usize] = b"hhx\0";
pub const SCNdFAST16: &'static [u8; 3usize] = b"hd\0";
pub const SCNiFAST16: &'static [u8; 3usize] = b"hi\0";
pub const SCNoFAST16: &'static [u8; 3usize] = b"ho\0";
pub const SCNuFAST16: &'static [u8; 3usize] = b"hu\0";
pub const SCNxFAST16: &'static [u8; 3usize] = b"hx\0";
pub const SCNdFAST32: &'static [u8; 2usize] = b"d\0";
pub const SCNiFAST32: &'static [u8; 2usize] = b"i\0";
pub const SCNoFAST32: &'static [u8; 2usize] = b"o\0";
pub const SCNuFAST32: &'static [u8; 2usize] = b"u\0";
pub const SCNxFAST32: &'static [u8; 2usize] = b"x\0";
pub const SCNdFAST64: &'static [u8; 4usize] = b"lld\0";
pub const SCNiFAST64: &'static [u8; 4usize] = b"lli\0";
pub const SCNoFAST64: &'static [u8; 4usize] = b"llo\0";
pub const SCNuFAST64: &'static [u8; 4usize] = b"llu\0";
pub const SCNxFAST64: &'static [u8; 4usize] = b"llx\0";
pub const SCNdPTR: &'static [u8; 3usize] = b"ld\0";
pub const SCNiPTR: &'static [u8; 3usize] = b"li\0";
pub const SCNoPTR: &'static [u8; 3usize] = b"lo\0";
pub const SCNuPTR: &'static [u8; 3usize] = b"lu\0";
pub const SCNxPTR: &'static [u8; 3usize] = b"lx\0";
pub const SCNdMAX: &'static [u8; 3usize] = b"jd\0";
pub const SCNiMAX: &'static [u8; 3usize] = b"ji\0";
pub const SCNoMAX: &'static [u8; 3usize] = b"jo\0";
pub const SCNuMAX: &'static [u8; 3usize] = b"ju\0";
pub const SCNxMAX: &'static [u8; 3usize] = b"jx\0";
pub const __API_TO_BE_DEPRECATED: u32 = 100000;
pub const __MAC_10_0: u32 = 1000;
pub const __MAC_10_1: u32 = 1010;
pub const __MAC_10_2: u32 = 1020;
pub const __MAC_10_3: u32 = 1030;
pub const __MAC_10_4: u32 = 1040;
pub const __MAC_10_5: u32 = 1050;
pub const __MAC_10_6: u32 = 1060;
pub const __MAC_10_7: u32 = 1070;
pub const __MAC_10_8: u32 = 1080;
pub const __MAC_10_9: u32 = 1090;
pub const __MAC_10_10: u32 = 101000;
pub const __MAC_10_10_2: u32 = 101002;
pub const __MAC_10_10_3: u32 = 101003;
pub const __MAC_10_11: u32 = 101100;
pub const __MAC_10_11_2: u32 = 101102;
pub const __MAC_10_11_3: u32 = 101103;
pub const __MAC_10_11_4: u32 = 101104;
pub const __MAC_10_12: u32 = 101200;
pub const __MAC_10_12_1: u32 = 101201;
pub const __MAC_10_12_2: u32 = 101202;
pub const __MAC_10_12_4: u32 = 101204;
pub const __MAC_10_13: u32 = 101300;
pub const __MAC_10_13_1: u32 = 101301;
pub const __MAC_10_13_2: u32 = 101302;
pub const __MAC_10_13_4: u32 = 101304;
pub const __MAC_10_14: u32 = 101400;
pub const __MAC_10_14_1: u32 = 101401;
pub const __MAC_10_14_4: u32 = 101404;
pub const __MAC_10_14_6: u32 = 101406;
pub const __MAC_10_15: u32 = 101500;
pub const __MAC_10_15_1: u32 = 101501;
pub const __MAC_10_15_4: u32 = 101504;
pub const __MAC_10_16: u32 = 101600;
pub const __MAC_11_0: u32 = 110000;
pub const __MAC_11_1: u32 = 110100;
pub const __MAC_11_3: u32 = 110300;
pub const __IPHONE_2_0: u32 = 20000;
pub const __IPHONE_2_1: u32 = 20100;
pub const __IPHONE_2_2: u32 = 20200;
pub const __IPHONE_3_0: u32 = 30000;
pub const __IPHONE_3_1: u32 = 30100;
pub const __IPHONE_3_2: u32 = 30200;
pub const __IPHONE_4_0: u32 = 40000;
pub const __IPHONE_4_1: u32 = 40100;
pub const __IPHONE_4_2: u32 = 40200;
pub const __IPHONE_4_3: u32 = 40300;
pub const __IPHONE_5_0: u32 = 50000;
pub const __IPHONE_5_1: u32 = 50100;
pub const __IPHONE_6_0: u32 = 60000;
pub const __IPHONE_6_1: u32 = 60100;
pub const __IPHONE_7_0: u32 = 70000;
pub const __IPHONE_7_1: u32 = 70100;
pub const __IPHONE_8_0: u32 = 80000;
pub const __IPHONE_8_1: u32 = 80100;
pub const __IPHONE_8_2: u32 = 80200;
pub const __IPHONE_8_3: u32 = 80300;
pub const __IPHONE_8_4: u32 = 80400;
pub const __IPHONE_9_0: u32 = 90000;
pub const __IPHONE_9_1: u32 = 90100;
pub const __IPHONE_9_2: u32 = 90200;
pub const __IPHONE_9_3: u32 = 90300;
pub const __IPHONE_10_0: u32 = 100000;
pub const __IPHONE_10_1: u32 = 100100;
pub const __IPHONE_10_2: u32 = 100200;
pub const __IPHONE_10_3: u32 = 100300;
pub const __IPHONE_11_0: u32 = 110000;
pub const __IPHONE_11_1: u32 = 110100;
pub const __IPHONE_11_2: u32 = 110200;
pub const __IPHONE_11_3: u32 = 110300;
pub const __IPHONE_11_4: u32 = 110400;
pub const __IPHONE_12_0: u32 = 120000;
pub const __IPHONE_12_1: u32 = 120100;
pub const __IPHONE_12_2: u32 = 120200;
pub const __IPHONE_12_3: u32 = 120300;
pub const __IPHONE_12_4: u32 = 120400;
pub const __IPHONE_13_0: u32 = 130000;
pub const __IPHONE_13_1: u32 = 130100;
pub const __IPHONE_13_2: u32 = 130200;
pub const __IPHONE_13_3: u32 = 130300;
pub const __IPHONE_13_4: u32 = 130400;
pub const __IPHONE_13_5: u32 = 130500;
pub const __IPHONE_13_6: u32 = 130600;
pub const __IPHONE_13_7: u32 = 130700;
pub const __IPHONE_14_0: u32 = 140000;
pub const __IPHONE_14_1: u32 = 140100;
pub const __IPHONE_14_2: u32 = 140200;
pub const __IPHONE_14_3: u32 = 140300;
pub const __IPHONE_14_5: u32 = 140500;
pub const __TVOS_9_0: u32 = 90000;
pub const __TVOS_9_1: u32 = 90100;
pub const __TVOS_9_2: u32 = 90200;
pub const __TVOS_10_0: u32 = 100000;
pub const __TVOS_10_0_1: u32 = 100001;
pub const __TVOS_10_1: u32 = 100100;
pub const __TVOS_10_2: u32 = 100200;
pub const __TVOS_11_0: u32 = 110000;
pub const __TVOS_11_1: u32 = 110100;
pub const __TVOS_11_2: u32 = 110200;
pub const __TVOS_11_3: u32 = 110300;
pub const __TVOS_11_4: u32 = 110400;
pub const __TVOS_12_0: u32 = 120000;
pub const __TVOS_12_1: u32 = 120100;
pub const __TVOS_12_2: u32 = 120200;
pub const __TVOS_12_3: u32 = 120300;
pub const __TVOS_12_4: u32 = 120400;
pub const __TVOS_13_0: u32 = 130000;
pub const __TVOS_13_2: u32 = 130200;
pub const __TVOS_13_3: u32 = 130300;
pub const __TVOS_13_4: u32 = 130400;
pub const __TVOS_14_0: u32 = 140000;
pub const __TVOS_14_1: u32 = 140100;
pub const __TVOS_14_2: u32 = 140200;
pub const __TVOS_14_3: u32 = 140300;
pub const __TVOS_14_5: u32 = 140500;
pub const __WATCHOS_1_0: u32 = 10000;
pub const __WATCHOS_2_0: u32 = 20000;
pub const __WATCHOS_2_1: u32 = 20100;
pub const __WATCHOS_2_2: u32 = 20200;
pub const __WATCHOS_3_0: u32 = 30000;
pub const __WATCHOS_3_1: u32 = 30100;
pub const __WATCHOS_3_1_1: u32 = 30101;
pub const __WATCHOS_3_2: u32 = 30200;
pub const __WATCHOS_4_0: u32 = 40000;
pub const __WATCHOS_4_1: u32 = 40100;
pub const __WATCHOS_4_2: u32 = 40200;
pub const __WATCHOS_4_3: u32 = 40300;
pub const __WATCHOS_5_0: u32 = 50000;
pub const __WATCHOS_5_1: u32 = 50100;
pub const __WATCHOS_5_2: u32 = 50200;
pub const __WATCHOS_5_3: u32 = 50300;
pub const __WATCHOS_6_0: u32 = 60000;
pub const __WATCHOS_6_1: u32 = 60100;
pub const __WATCHOS_6_2: u32 = 60200;
pub const __WATCHOS_7_0: u32 = 70000;
pub const __WATCHOS_7_1: u32 = 70100;
pub const __WATCHOS_7_2: u32 = 70200;
pub const __WATCHOS_7_3: u32 = 70300;
pub const __WATCHOS_7_4: u32 = 70400;
pub const MAC_OS_X_VERSION_10_0: u32 = 1000;
pub const MAC_OS_X_VERSION_10_1: u32 = 1010;
pub const MAC_OS_X_VERSION_10_2: u32 = 1020;
pub const MAC_OS_X_VERSION_10_3: u32 = 1030;
pub const MAC_OS_X_VERSION_10_4: u32 = 1040;
pub const MAC_OS_X_VERSION_10_5: u32 = 1050;
pub const MAC_OS_X_VERSION_10_6: u32 = 1060;
pub const MAC_OS_X_VERSION_10_7: u32 = 1070;
pub const MAC_OS_X_VERSION_10_8: u32 = 1080;
pub const MAC_OS_X_VERSION_10_9: u32 = 1090;
pub const MAC_OS_X_VERSION_10_10: u32 = 101000;
pub const MAC_OS_X_VERSION_10_10_2: u32 = 101002;
pub const MAC_OS_X_VERSION_10_10_3: u32 = 101003;
pub const MAC_OS_X_VERSION_10_11: u32 = 101100;
pub const MAC_OS_X_VERSION_10_11_2: u32 = 101102;
pub const MAC_OS_X_VERSION_10_11_3: u32 = 101103;
pub const MAC_OS_X_VERSION_10_11_4: u32 = 101104;
pub const MAC_OS_X_VERSION_10_12: u32 = 101200;
pub const MAC_OS_X_VERSION_10_12_1: u32 = 101201;
pub const MAC_OS_X_VERSION_10_12_2: u32 = 101202;
pub const MAC_OS_X_VERSION_10_12_4: u32 = 101204;
pub const MAC_OS_X_VERSION_10_13: u32 = 101300;
pub const MAC_OS_X_VERSION_10_13_1: u32 = 101301;
pub const MAC_OS_X_VERSION_10_13_2: u32 = 101302;
pub const MAC_OS_X_VERSION_10_13_4: u32 = 101304;
pub const MAC_OS_X_VERSION_10_14: u32 = 101400;
pub const MAC_OS_X_VERSION_10_14_1: u32 = 101401;
pub const MAC_OS_X_VERSION_10_14_4: u32 = 101404;
pub const MAC_OS_X_VERSION_10_14_6: u32 = 101406;
pub const MAC_OS_X_VERSION_10_15: u32 = 101500;
pub const MAC_OS_X_VERSION_10_15_1: u32 = 101501;
pub const MAC_OS_X_VERSION_10_16: u32 = 101600;
pub const MAC_OS_VERSION_11_0: u32 = 110000;
pub const __DRIVERKIT_19_0: u32 = 190000;
pub const __DRIVERKIT_20_0: u32 = 200000;
pub const __MAC_OS_X_VERSION_MAX_ALLOWED: u32 = 110300;
pub const __ENABLE_LEGACY_MAC_AVAILABILITY: u32 = 1;
pub const __DARWIN_WCHAR_MIN: i32 = -2147483648;
pub const _FORTIFY_SOURCE: u32 = 2;
pub const __DARWIN_NSIG: u32 = 32;
pub const NSIG: u32 = 32;
pub const _I386_SIGNAL_H_: u32 = 1;
pub const SIGHUP: u32 = 1;
pub const SIGINT: u32 = 2;
pub const SIGQUIT: u32 = 3;
pub const SIGILL: u32 = 4;
pub const SIGTRAP: u32 = 5;
pub const SIGABRT: u32 = 6;
pub const SIGIOT: u32 = 6;
pub const SIGEMT: u32 = 7;
pub const SIGFPE: u32 = 8;
pub const SIGKILL: u32 = 9;
pub const SIGBUS: u32 = 10;
pub const SIGSEGV: u32 = 11;
pub const SIGSYS: u32 = 12;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGTERM: u32 = 15;
pub const SIGURG: u32 = 16;
pub const SIGSTOP: u32 = 17;
pub const SIGTSTP: u32 = 18;
pub const SIGCONT: u32 = 19;
pub const SIGCHLD: u32 = 20;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGIO: u32 = 23;
pub const SIGXCPU: u32 = 24;
pub const SIGXFSZ: u32 = 25;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGWINCH: u32 = 28;
pub const SIGINFO: u32 = 29;
pub const SIGUSR1: u32 = 30;
pub const SIGUSR2: u32 = 31;
pub const FP_PREC_24B: u32 = 0;
pub const FP_PREC_53B: u32 = 2;
pub const FP_PREC_64B: u32 = 3;
pub const FP_RND_NEAR: u32 = 0;
pub const FP_RND_DOWN: u32 = 1;
pub const FP_RND_UP: u32 = 2;
pub const FP_CHOP: u32 = 3;
pub const FP_STATE_BYTES: u32 = 512;
pub const _X86_INSTRUCTION_STATE_MAX_INSN_BYTES: u32 = 2380;
pub const _X86_INSTRUCTION_STATE_CACHELINE_SIZE: u32 = 64;
pub const __LASTBRANCH_MAX: u32 = 32;
pub const SIGEV_NONE: u32 = 0;
pub const SIGEV_SIGNAL: u32 = 1;
pub const SIGEV_THREAD: u32 = 3;
pub const ILL_NOOP: u32 = 0;
pub const ILL_ILLOPC: u32 = 1;
pub const ILL_ILLTRP: u32 = 2;
pub const ILL_PRVOPC: u32 = 3;
pub const ILL_ILLOPN: u32 = 4;
pub const ILL_ILLADR: u32 = 5;
pub const ILL_PRVREG: u32 = 6;
pub const ILL_COPROC: u32 = 7;
pub const ILL_BADSTK: u32 = 8;
pub const FPE_NOOP: u32 = 0;
pub const FPE_FLTDIV: u32 = 1;
pub const FPE_FLTOVF: u32 = 2;
pub const FPE_FLTUND: u32 = 3;
pub const FPE_FLTRES: u32 = 4;
pub const FPE_FLTINV: u32 = 5;
pub const FPE_FLTSUB: u32 = 6;
pub const FPE_INTDIV: u32 = 7;
pub const FPE_INTOVF: u32 = 8;
pub const SEGV_NOOP: u32 = 0;
pub const SEGV_MAPERR: u32 = 1;
pub const SEGV_ACCERR: u32 = 2;
pub const BUS_NOOP: u32 = 0;
pub const BUS_ADRALN: u32 = 1;
pub const BUS_ADRERR: u32 = 2;
pub const BUS_OBJERR: u32 = 3;
pub const TRAP_BRKPT: u32 = 1;
pub const TRAP_TRACE: u32 = 2;
pub const CLD_NOOP: u32 = 0;
pub const CLD_EXITED: u32 = 1;
pub const CLD_KILLED: u32 = 2;
pub const CLD_DUMPED: u32 = 3;
pub const CLD_TRAPPED: u32 = 4;
pub const CLD_STOPPED: u32 = 5;
pub const CLD_CONTINUED: u32 = 6;
pub const POLL_IN: u32 = 1;
pub const POLL_OUT: u32 = 2;
pub const POLL_MSG: u32 = 3;
pub const POLL_ERR: u32 = 4;
pub const POLL_PRI: u32 = 5;
pub const POLL_HUP: u32 = 6;
pub const SA_ONSTACK: u32 = 1;
pub const SA_RESTART: u32 = 2;
pub const SA_RESETHAND: u32 = 4;
pub const SA_NOCLDSTOP: u32 = 8;
pub const SA_NODEFER: u32 = 16;
pub const SA_NOCLDWAIT: u32 = 32;
pub const SA_SIGINFO: u32 = 64;
pub const SA_USERTRAMP: u32 = 256;
pub const SA_64REGSET: u32 = 512;
pub const SA_USERSPACE_MASK: u32 = 127;
pub const SIG_BLOCK: u32 = 1;
pub const SIG_UNBLOCK: u32 = 2;
pub const SIG_SETMASK: u32 = 3;
pub const SI_USER: u32 = 65537;
pub const SI_QUEUE: u32 = 65538;
pub const SI_TIMER: u32 = 65539;
pub const SI_ASYNCIO: u32 = 65540;
pub const SI_MESGQ: u32 = 65541;
pub const SS_ONSTACK: u32 = 1;
pub const SS_DISABLE: u32 = 4;
pub const MINSIGSTKSZ: u32 = 32768;
pub const SIGSTKSZ: u32 = 131072;
pub const SV_ONSTACK: u32 = 1;
pub const SV_INTERRUPT: u32 = 2;
pub const SV_RESETHAND: u32 = 4;
pub const SV_NODEFER: u32 = 16;
pub const SV_NOCLDSTOP: u32 = 8;
pub const SV_SIGINFO: u32 = 64;
pub const PRIO_PROCESS: u32 = 0;
pub const PRIO_PGRP: u32 = 1;
pub const PRIO_USER: u32 = 2;
pub const PRIO_DARWIN_THREAD: u32 = 3;
pub const PRIO_DARWIN_PROCESS: u32 = 4;
pub const PRIO_MIN: i32 = -20;
pub const PRIO_MAX: u32 = 20;
pub const PRIO_DARWIN_BG: u32 = 4096;
pub const PRIO_DARWIN_NONUI: u32 = 4097;
pub const RUSAGE_SELF: u32 = 0;
pub const RUSAGE_CHILDREN: i32 = -1;
pub const RUSAGE_INFO_V0: u32 = 0;
pub const RUSAGE_INFO_V1: u32 = 1;
pub const RUSAGE_INFO_V2: u32 = 2;
pub const RUSAGE_INFO_V3: u32 = 3;
pub const RUSAGE_INFO_V4: u32 = 4;
pub const RUSAGE_INFO_V5: u32 = 5;
pub const RUSAGE_INFO_CURRENT: u32 = 5;
pub const RU_PROC_RUNS_RESLIDE: u32 = 1;
pub const RLIMIT_CPU: u32 = 0;
pub const RLIMIT_FSIZE: u32 = 1;
pub const RLIMIT_DATA: u32 = 2;
pub const RLIMIT_STACK: u32 = 3;
pub const RLIMIT_CORE: u32 = 4;
pub const RLIMIT_AS: u32 = 5;
pub const RLIMIT_RSS: u32 = 5;
pub const RLIMIT_MEMLOCK: u32 = 6;
pub const RLIMIT_NPROC: u32 = 7;
pub const RLIMIT_NOFILE: u32 = 8;
pub const RLIM_NLIMITS: u32 = 9;
pub const _RLIMIT_POSIX_FLAG: u32 = 4096;
pub const RLIMIT_WAKEUPS_MONITOR: u32 = 1;
pub const RLIMIT_CPU_USAGE_MONITOR: u32 = 2;
pub const RLIMIT_THREAD_CPULIMITS: u32 = 3;
pub const RLIMIT_FOOTPRINT_INTERVAL: u32 = 4;
pub const WAKEMON_ENABLE: u32 = 1;
pub const WAKEMON_DISABLE: u32 = 2;
pub const WAKEMON_GET_PARAMS: u32 = 4;
pub const WAKEMON_SET_DEFAULTS: u32 = 8;
pub const WAKEMON_MAKE_FATAL: u32 = 16;
pub const CPUMON_MAKE_FATAL: u32 = 4096;
pub const FOOTPRINT_INTERVAL_RESET: u32 = 1;
pub const IOPOL_TYPE_DISK: u32 = 0;
pub const IOPOL_TYPE_VFS_ATIME_UPDATES: u32 = 2;
pub const IOPOL_TYPE_VFS_MATERIALIZE_DATALESS_FILES: u32 = 3;
pub const IOPOL_TYPE_VFS_STATFS_NO_DATA_VOLUME: u32 = 4;
pub const IOPOL_TYPE_VFS_TRIGGER_RESOLVE: u32 = 5;
pub const IOPOL_TYPE_VFS_IGNORE_CONTENT_PROTECTION: u32 = 6;
pub const IOPOL_TYPE_VFS_IGNORE_PERMISSIONS: u32 = 7;
pub const IOPOL_TYPE_VFS_SKIP_MTIME_UPDATE: u32 = 8;
pub const IOPOL_SCOPE_PROCESS: u32 = 0;
pub const IOPOL_SCOPE_THREAD: u32 = 1;
pub const IOPOL_SCOPE_DARWIN_BG: u32 = 2;
pub const IOPOL_DEFAULT: u32 = 0;
pub const IOPOL_IMPORTANT: u32 = 1;
pub const IOPOL_PASSIVE: u32 = 2;
pub const IOPOL_THROTTLE: u32 = 3;
pub const IOPOL_UTILITY: u32 = 4;
pub const IOPOL_STANDARD: u32 = 5;
pub const IOPOL_APPLICATION: u32 = 5;
pub const IOPOL_NORMAL: u32 = 1;
pub const IOPOL_ATIME_UPDATES_DEFAULT: u32 = 0;
pub const IOPOL_ATIME_UPDATES_OFF: u32 = 1;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_DEFAULT: u32 = 0;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_OFF: u32 = 1;
pub const IOPOL_MATERIALIZE_DATALESS_FILES_ON: u32 = 2;
pub const IOPOL_VFS_STATFS_NO_DATA_VOLUME_DEFAULT: u32 = 0;
pub const IOPOL_VFS_STATFS_FORCE_NO_DATA_VOLUME: u32 = 1;
pub const IOPOL_VFS_TRIGGER_RESOLVE_DEFAULT: u32 = 0;
pub const IOPOL_VFS_TRIGGER_RESOLVE_OFF: u32 = 1;
pub const IOPOL_VFS_CONTENT_PROTECTION_DEFAULT: u32 = 0;
pub const IOPOL_VFS_CONTENT_PROTECTION_IGNORE: u32 = 1;
pub const IOPOL_VFS_IGNORE_PERMISSIONS_OFF: u32 = 0;
pub const IOPOL_VFS_IGNORE_PERMISSIONS_ON: u32 = 1;
pub const IOPOL_VFS_SKIP_MTIME_UPDATE_OFF: u32 = 0;
pub const IOPOL_VFS_SKIP_MTIME_UPDATE_ON: u32 = 1;
pub const WNOHANG: u32 = 1;
pub const WUNTRACED: u32 = 2;
pub const WCOREFLAG: u32 = 128;
pub const _WSTOPPED: u32 = 127;
pub const WEXITED: u32 = 4;
pub const WSTOPPED: u32 = 8;
pub const WCONTINUED: u32 = 16;
pub const WNOWAIT: u32 = 32;
pub const WAIT_ANY: i32 = -1;
pub const WAIT_MYPGRP: u32 = 0;
pub const _QUAD_HIGHWORD: u32 = 1;
pub const _QUAD_LOWWORD: u32 = 0;
pub const __DARWIN_LITTLE_ENDIAN: u32 = 1234;
pub const __DARWIN_BIG_ENDIAN: u32 = 4321;
pub const __DARWIN_PDP_ENDIAN: u32 = 3412;
pub const __DARWIN_BYTE_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const EXIT_FAILURE: u32 = 1;
pub const EXIT_SUCCESS: u32 = 0;
pub const RAND_MAX: u32 = 2147483647;
pub type int_least8_t = i8;
pub type int_least16_t = i16;
pub type int_least32_t = i32;
pub type int_least64_t = i64;
pub type uint_least8_t = u8;
pub type uint_least16_t = u16;
pub type uint_least32_t = u32;
pub type uint_least64_t = u64;
pub type int_fast8_t = i8;
pub type int_fast16_t = i16;
pub type int_fast32_t = i32;
pub type int_fast64_t = i64;
pub type uint_fast8_t = u8;
pub type uint_fast16_t = u16;
pub type uint_fast32_t = u32;
pub type uint_fast64_t = u64;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_longlong;
pub type __uint64_t = ::std::os::raw::c_ulonglong;
pub type __darwin_intptr_t = ::std::os::raw::c_long;
pub type __darwin_natural_t = ::std::os::raw::c_uint;
pub type __darwin_ct_rune_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __mbstate_t {
    pub __mbstate8: [::std::os::raw::c_char; 128usize],
    pub _mbstateL: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout___mbstate_t() {
    assert_eq!(
        ::std::mem::size_of::<__mbstate_t>(),
        128usize,
        concat!("Size of: ", stringify!(__mbstate_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__mbstate_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__mbstate_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>())).__mbstate8 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(__mbstate8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__mbstate_t>()))._mbstateL as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__mbstate_t),
            "::",
            stringify!(_mbstateL)
        )
    );
}
impl Default for __mbstate_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __darwin_mbstate_t = __mbstate_t;
pub type __darwin_ptrdiff_t = ::std::os::raw::c_long;
pub type __darwin_size_t = ::std::os::raw::c_ulong;
pub type __darwin_va_list = __builtin_va_list;
pub type __darwin_wchar_t = ::std::os::raw::c_int;
pub type __darwin_rune_t = __darwin_wchar_t;
pub type __darwin_wint_t = ::std::os::raw::c_int;
pub type __darwin_clock_t = ::std::os::raw::c_ulong;
pub type __darwin_socklen_t = __uint32_t;
pub type __darwin_ssize_t = ::std::os::raw::c_long;
pub type __darwin_time_t = ::std::os::raw::c_long;
pub type __darwin_blkcnt_t = __int64_t;
pub type __darwin_blksize_t = __int32_t;
pub type __darwin_dev_t = __int32_t;
pub type __darwin_fsblkcnt_t = ::std::os::raw::c_uint;
pub type __darwin_fsfilcnt_t = ::std::os::raw::c_uint;
pub type __darwin_gid_t = __uint32_t;
pub type __darwin_id_t = __uint32_t;
pub type __darwin_ino64_t = __uint64_t;
pub type __darwin_ino_t = __darwin_ino64_t;
pub type __darwin_mach_port_name_t = __darwin_natural_t;
pub type __darwin_mach_port_t = __darwin_mach_port_name_t;
pub type __darwin_mode_t = __uint16_t;
pub type __darwin_off_t = __int64_t;
pub type __darwin_pid_t = __int32_t;
pub type __darwin_sigset_t = __uint32_t;
pub type __darwin_suseconds_t = __int32_t;
pub type __darwin_uid_t = __uint32_t;
pub type __darwin_useconds_t = __uint32_t;
pub type __darwin_uuid_t = [::std::os::raw::c_uchar; 16usize];
pub type __darwin_uuid_string_t = [::std::os::raw::c_char; 37usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_pthread_handler_rec {
    pub __routine: ::std::option::Option<unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void)>,
    pub __arg: *mut ::std::os::raw::c_void,
    pub __next: *mut __darwin_pthread_handler_rec,
}
#[test]
fn bindgen_test_layout___darwin_pthread_handler_rec() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_pthread_handler_rec>(),
        24usize,
        concat!("Size of: ", stringify!(__darwin_pthread_handler_rec))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_pthread_handler_rec>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_pthread_handler_rec))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_pthread_handler_rec>())).__routine as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__routine)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_pthread_handler_rec>())).__arg as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__arg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_pthread_handler_rec>())).__next as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_pthread_handler_rec),
            "::",
            stringify!(__next)
        )
    );
}
impl Default for __darwin_pthread_handler_rec {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_attr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_attr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_attr_t>(),
        64usize,
        concat!("Size of: ", stringify!(_opaque_pthread_attr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_attr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_attr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_attr_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_attr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_attr_t>())).__opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_attr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
impl Default for _opaque_pthread_attr_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_cond_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 40usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(_opaque_pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_cond_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_cond_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_cond_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_cond_t>())).__opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_cond_t),
            "::",
            stringify!(__opaque)
        )
    );
}
impl Default for _opaque_pthread_cond_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _opaque_pthread_condattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_condattr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_condattr_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_condattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_condattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_condattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_condattr_t>())).__sig as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_condattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_condattr_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_condattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_mutex_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 56usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_mutex_t>(),
        64usize,
        concat!("Size of: ", stringify!(_opaque_pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_mutex_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutex_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_mutex_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutex_t),
            "::",
            stringify!(__opaque)
        )
    );
}
impl Default for _opaque_pthread_mutex_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _opaque_pthread_mutexattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_mutexattr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_mutexattr_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_mutexattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_mutexattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_mutexattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_mutexattr_t>())).__sig as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutexattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_mutexattr_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_mutexattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _opaque_pthread_once_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_once_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_once_t>(),
        16usize,
        concat!("Size of: ", stringify!(_opaque_pthread_once_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_once_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_once_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_once_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_once_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_once_t>())).__opaque as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_once_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_rwlock_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 192usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_rwlock_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_rwlock_t>(),
        200usize,
        concat!("Size of: ", stringify!(_opaque_pthread_rwlock_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_rwlock_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_rwlock_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlock_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_rwlock_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlock_t),
            "::",
            stringify!(__opaque)
        )
    );
}
impl Default for _opaque_pthread_rwlock_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct _opaque_pthread_rwlockattr_t {
    pub __sig: ::std::os::raw::c_long,
    pub __opaque: [::std::os::raw::c_char; 16usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_rwlockattr_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_rwlockattr_t>(),
        24usize,
        concat!("Size of: ", stringify!(_opaque_pthread_rwlockattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_rwlockattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_rwlockattr_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_rwlockattr_t>())).__sig as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlockattr_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_rwlockattr_t>())).__opaque as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_rwlockattr_t),
            "::",
            stringify!(__opaque)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _opaque_pthread_t {
    pub __sig: ::std::os::raw::c_long,
    pub __cleanup_stack: *mut __darwin_pthread_handler_rec,
    pub __opaque: [::std::os::raw::c_char; 8176usize],
}
#[test]
fn bindgen_test_layout__opaque_pthread_t() {
    assert_eq!(
        ::std::mem::size_of::<_opaque_pthread_t>(),
        8192usize,
        concat!("Size of: ", stringify!(_opaque_pthread_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_opaque_pthread_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_opaque_pthread_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_t>())).__sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_opaque_pthread_t>())).__cleanup_stack as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__cleanup_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_opaque_pthread_t>())).__opaque as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_opaque_pthread_t),
            "::",
            stringify!(__opaque)
        )
    );
}
impl Default for _opaque_pthread_t {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type __darwin_pthread_attr_t = _opaque_pthread_attr_t;
pub type __darwin_pthread_cond_t = _opaque_pthread_cond_t;
pub type __darwin_pthread_condattr_t = _opaque_pthread_condattr_t;
pub type __darwin_pthread_key_t = ::std::os::raw::c_ulong;
pub type __darwin_pthread_mutex_t = _opaque_pthread_mutex_t;
pub type __darwin_pthread_mutexattr_t = _opaque_pthread_mutexattr_t;
pub type __darwin_pthread_once_t = _opaque_pthread_once_t;
pub type __darwin_pthread_rwlock_t = _opaque_pthread_rwlock_t;
pub type __darwin_pthread_rwlockattr_t = _opaque_pthread_rwlockattr_t;
pub type __darwin_pthread_t = *mut _opaque_pthread_t;
pub type u_int8_t = ::std::os::raw::c_uchar;
pub type u_int16_t = ::std::os::raw::c_ushort;
pub type u_int32_t = ::std::os::raw::c_uint;
pub type u_int64_t = ::std::os::raw::c_ulonglong;
pub type register_t = i64;
pub type user_addr_t = u_int64_t;
pub type user_size_t = u_int64_t;
pub type user_ssize_t = i64;
pub type user_long_t = i64;
pub type user_ulong_t = u_int64_t;
pub type user_time_t = i64;
pub type user_off_t = i64;
pub type syscall_arg_t = u_int64_t;
pub type intmax_t = ::std::os::raw::c_long;
pub type uintmax_t = ::std::os::raw::c_ulong;
pub type size_t = ::std::os::raw::c_ulong;
pub type rsize_t = ::std::os::raw::c_ulong;
pub type wchar_t = ::std::os::raw::c_int;
pub type UINT8 = u8;
pub type BYTE = u8;
pub type INT8 = i8;
pub type BOOL = ::std::os::raw::c_int;
pub type UINT16 = u16;
pub type INT16 = i16;
pub type UINT32 = u32;
pub type INT32 = i32;
pub type UINT64 = u64;
pub type INT64 = i64;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TSS2_ABI_VERSION {
    pub tssCreator: u32,
    pub tssFamily: u32,
    pub tssLevel: u32,
    pub tssVersion: u32,
}
#[test]
fn bindgen_test_layout_TSS2_ABI_VERSION() {
    assert_eq!(
        ::std::mem::size_of::<TSS2_ABI_VERSION>(),
        16usize,
        concat!("Size of: ", stringify!(TSS2_ABI_VERSION))
    );
    assert_eq!(
        ::std::mem::align_of::<TSS2_ABI_VERSION>(),
        4usize,
        concat!("Alignment of ", stringify!(TSS2_ABI_VERSION))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TSS2_ABI_VERSION>())).tssCreator as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2_ABI_VERSION),
            "::",
            stringify!(tssCreator)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TSS2_ABI_VERSION>())).tssFamily as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2_ABI_VERSION),
            "::",
            stringify!(tssFamily)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TSS2_ABI_VERSION>())).tssLevel as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2_ABI_VERSION),
            "::",
            stringify!(tssLevel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TSS2_ABI_VERSION>())).tssVersion as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2_ABI_VERSION),
            "::",
            stringify!(tssVersion)
        )
    );
}
pub type TSS2_RC = u32;
pub type TPM2_ALG_ID = UINT16;
pub type TPM2_ECC_CURVE = UINT16;
pub type TPM2_CC = UINT32;
pub type TPM2_ALGORITHM_ID = UINT32;
pub type TPM2_MODIFIER_INDICATOR = UINT32;
pub type TPM2_AUTHORIZATION_SIZE = UINT32;
pub type TPM2_PARAMETER_SIZE = UINT32;
pub type TPM2_KEY_SIZE = UINT16;
pub type TPM2_KEY_BITS = UINT16;
pub type TPM2_SPEC = UINT32;
pub type TPM2_GENERATED = UINT32;
pub type TPM2_RC = UINT32;
pub type TPM2_CLOCK_ADJUST = INT8;
pub type TPM2_EO = UINT16;
pub type TPM2_ST = UINT16;
pub type TPM2_SU = UINT16;
pub type TPM2_SE = UINT8;
pub type TPM2_CAP = UINT32;
pub type TPM2_PT = UINT32;
pub type TPM2_PT_PCR = UINT32;
pub type TPM2_PS = UINT32;
pub type TPM2_HANDLE = UINT32;
pub type TPM2_HT = UINT8;
pub type TPM2_RH = TPM2_HANDLE;
pub type TPM2_HC = TPM2_HANDLE;
pub type TPMA_ALGORITHM = u32;
pub type TPMA_OBJECT = u32;
pub type TPMA_SESSION = UINT8;
pub type TPMA_LOCALITY = UINT8;
pub type TPMA_PERMANENT = u32;
pub type TPMA_STARTUP_CLEAR = u32;
pub type TPMA_MEMORY = u32;
pub type TPMA_CC = u32;
pub type TPMA_MODES = u32;
pub type TPMI_YES_NO = BYTE;
pub type TPMI_DH_OBJECT = TPM2_HANDLE;
pub type TPMI_DH_PERSISTENT = TPM2_HANDLE;
pub type TPMI_DH_ENTITY = TPM2_HANDLE;
pub type TPMI_DH_PCR = TPM2_HANDLE;
pub type TPMI_SH_AUTH_SESSION = TPM2_HANDLE;
pub type TPMI_SH_HMAC = TPM2_HANDLE;
pub type TPMI_SH_POLICY = TPM2_HANDLE;
pub type TPMI_DH_CONTEXT = TPM2_HANDLE;
pub type TPMI_RH_HIERARCHY = TPM2_HANDLE;
pub type TPMI_RH_ENABLES = TPM2_HANDLE;
pub type TPMI_RH_HIERARCHY_AUTH = TPM2_HANDLE;
pub type TPMI_RH_PLATFORM = TPM2_HANDLE;
pub type TPMI_RH_OWNER = TPM2_HANDLE;
pub type TPMI_RH_ENDORSEMENT = TPM2_HANDLE;
pub type TPMI_RH_PROVISION = TPM2_HANDLE;
pub type TPMI_RH_CLEAR = TPM2_HANDLE;
pub type TPMI_RH_NV_AUTH = TPM2_HANDLE;
pub type TPMI_RH_LOCKOUT = TPM2_HANDLE;
pub type TPMI_RH_NV_INDEX = TPM2_HANDLE;
pub type TPMI_ALG_HASH = TPM2_ALG_ID;
pub type TPMI_ALG_ASYM = TPM2_ALG_ID;
pub type TPMI_ALG_SYM = TPM2_ALG_ID;
pub type TPMI_ALG_SYM_OBJECT = TPM2_ALG_ID;
pub type TPMI_ALG_SYM_MODE = TPM2_ALG_ID;
pub type TPMI_ALG_KDF = TPM2_ALG_ID;
pub type TPMI_ALG_SIG_SCHEME = TPM2_ALG_ID;
pub type TPMI_ECC_KEY_EXCHANGE = TPM2_ALG_ID;
pub type TPMI_ST_COMMAND_TAG = TPM2_ST;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TPMS_EMPTY {
    pub empty: [BYTE; 1usize],
}
#[test]
fn bindgen_test_layout_TPMS_EMPTY() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_EMPTY>(),
        1usize,
        concat!("Size of: ", stringify!(TPMS_EMPTY))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_EMPTY>(),
        1usize,
        concat!("Alignment of ", stringify!(TPMS_EMPTY))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_EMPTY>())).empty as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_EMPTY),
            "::",
            stringify!(empty)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TPMS_ALGORITHM_DESCRIPTION {
    pub alg: TPM2_ALG_ID,
    pub attributes: TPMA_ALGORITHM,
}
#[test]
fn bindgen_test_layout_TPMS_ALGORITHM_DESCRIPTION() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_ALGORITHM_DESCRIPTION>(),
        8usize,
        concat!("Size of: ", stringify!(TPMS_ALGORITHM_DESCRIPTION))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_ALGORITHM_DESCRIPTION>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMS_ALGORITHM_DESCRIPTION))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ALGORITHM_DESCRIPTION>())).alg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ALGORITHM_DESCRIPTION),
            "::",
            stringify!(alg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPMS_ALGORITHM_DESCRIPTION>())).attributes as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ALGORITHM_DESCRIPTION),
            "::",
            stringify!(attributes)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union TPMU_HA {
    pub sha1: [BYTE; 20usize],
    pub sha256: [BYTE; 32usize],
    pub sha384: [BYTE; 48usize],
    pub sha512: [BYTE; 64usize],
    pub sm3_256: [BYTE; 32usize],
}
#[test]
fn bindgen_test_layout_TPMU_HA() {
    assert_eq!(
        ::std::mem::size_of::<TPMU_HA>(),
        64usize,
        concat!("Size of: ", stringify!(TPMU_HA))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMU_HA>(),
        1usize,
        concat!("Alignment of ", stringify!(TPMU_HA))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_HA>())).sha1 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_HA),
            "::",
            stringify!(sha1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_HA>())).sha256 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_HA),
            "::",
            stringify!(sha256)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_HA>())).sha384 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_HA),
            "::",
            stringify!(sha384)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_HA>())).sha512 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_HA),
            "::",
            stringify!(sha512)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_HA>())).sm3_256 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_HA),
            "::",
            stringify!(sm3_256)
        )
    );
}
impl Default for TPMU_HA {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMT_HA {
    pub hashAlg: TPMI_ALG_HASH,
    pub digest: TPMU_HA,
}
#[test]
fn bindgen_test_layout_TPMT_HA() {
    assert_eq!(
        ::std::mem::size_of::<TPMT_HA>(),
        66usize,
        concat!("Size of: ", stringify!(TPMT_HA))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMT_HA>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMT_HA))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_HA>())).hashAlg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_HA),
            "::",
            stringify!(hashAlg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_HA>())).digest as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_HA),
            "::",
            stringify!(digest)
        )
    );
}
impl Default for TPMT_HA {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_DIGEST {
    pub size: UINT16,
    pub buffer: [BYTE; 64usize],
}
#[test]
fn bindgen_test_layout_TPM2B_DIGEST() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_DIGEST>(),
        66usize,
        concat!("Size of: ", stringify!(TPM2B_DIGEST))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_DIGEST>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_DIGEST))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_DIGEST>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_DIGEST),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_DIGEST>())).buffer as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_DIGEST),
            "::",
            stringify!(buffer)
        )
    );
}
impl Default for TPM2B_DIGEST {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_DATA {
    pub size: UINT16,
    pub buffer: [BYTE; 64usize],
}
#[test]
fn bindgen_test_layout_TPM2B_DATA() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_DATA>(),
        66usize,
        concat!("Size of: ", stringify!(TPM2B_DATA))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_DATA>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_DATA))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_DATA>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_DATA),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_DATA>())).buffer as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_DATA),
            "::",
            stringify!(buffer)
        )
    );
}
impl Default for TPM2B_DATA {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TPM2B_NONCE = TPM2B_DIGEST;
pub type TPM2B_AUTH = TPM2B_DIGEST;
pub type TPM2B_OPERAND = TPM2B_DIGEST;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_EVENT {
    pub size: UINT16,
    pub buffer: [BYTE; 1024usize],
}
#[test]
fn bindgen_test_layout_TPM2B_EVENT() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_EVENT>(),
        1026usize,
        concat!("Size of: ", stringify!(TPM2B_EVENT))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_EVENT>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_EVENT))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_EVENT>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_EVENT),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_EVENT>())).buffer as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_EVENT),
            "::",
            stringify!(buffer)
        )
    );
}
impl Default for TPM2B_EVENT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_MAX_BUFFER {
    pub size: UINT16,
    pub buffer: [BYTE; 1024usize],
}
#[test]
fn bindgen_test_layout_TPM2B_MAX_BUFFER() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_MAX_BUFFER>(),
        1026usize,
        concat!("Size of: ", stringify!(TPM2B_MAX_BUFFER))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_MAX_BUFFER>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_MAX_BUFFER))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_MAX_BUFFER>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_MAX_BUFFER),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_MAX_BUFFER>())).buffer as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_MAX_BUFFER),
            "::",
            stringify!(buffer)
        )
    );
}
impl Default for TPM2B_MAX_BUFFER {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_MAX_NV_BUFFER {
    pub size: UINT16,
    pub buffer: [BYTE; 2048usize],
}
#[test]
fn bindgen_test_layout_TPM2B_MAX_NV_BUFFER() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_MAX_NV_BUFFER>(),
        2050usize,
        concat!("Size of: ", stringify!(TPM2B_MAX_NV_BUFFER))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_MAX_NV_BUFFER>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_MAX_NV_BUFFER))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_MAX_NV_BUFFER>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_MAX_NV_BUFFER),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_MAX_NV_BUFFER>())).buffer as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_MAX_NV_BUFFER),
            "::",
            stringify!(buffer)
        )
    );
}
impl Default for TPM2B_MAX_NV_BUFFER {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TPM2B_TIMEOUT = TPM2B_DIGEST;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TPM2B_IV {
    pub size: UINT16,
    pub buffer: [BYTE; 16usize],
}
#[test]
fn bindgen_test_layout_TPM2B_IV() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_IV>(),
        18usize,
        concat!("Size of: ", stringify!(TPM2B_IV))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_IV>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_IV))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_IV>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_IV),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_IV>())).buffer as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_IV),
            "::",
            stringify!(buffer)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union TPMU_NAME {
    pub digest: TPMT_HA,
    pub handle: TPM2_HANDLE,
}
#[test]
fn bindgen_test_layout_TPMU_NAME() {
    assert_eq!(
        ::std::mem::size_of::<TPMU_NAME>(),
        68usize,
        concat!("Size of: ", stringify!(TPMU_NAME))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMU_NAME>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMU_NAME))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_NAME>())).digest as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_NAME),
            "::",
            stringify!(digest)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_NAME>())).handle as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_NAME),
            "::",
            stringify!(handle)
        )
    );
}
impl Default for TPMU_NAME {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_NAME {
    pub size: UINT16,
    pub name: [BYTE; 68usize],
}
#[test]
fn bindgen_test_layout_TPM2B_NAME() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_NAME>(),
        70usize,
        concat!("Size of: ", stringify!(TPM2B_NAME))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_NAME>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_NAME))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_NAME>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_NAME),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_NAME>())).name as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_NAME),
            "::",
            stringify!(name)
        )
    );
}
impl Default for TPM2B_NAME {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TPMS_PCR_SELECT {
    pub sizeofSelect: UINT8,
    pub pcrSelect: [BYTE; 4usize],
}
#[test]
fn bindgen_test_layout_TPMS_PCR_SELECT() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_PCR_SELECT>(),
        5usize,
        concat!("Size of: ", stringify!(TPMS_PCR_SELECT))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_PCR_SELECT>(),
        1usize,
        concat!("Alignment of ", stringify!(TPMS_PCR_SELECT))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_PCR_SELECT>())).sizeofSelect as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_PCR_SELECT),
            "::",
            stringify!(sizeofSelect)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_PCR_SELECT>())).pcrSelect as *const _ as usize },
        1usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_PCR_SELECT),
            "::",
            stringify!(pcrSelect)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TPMS_PCR_SELECTION {
    pub hash: TPMI_ALG_HASH,
    pub sizeofSelect: UINT8,
    pub pcrSelect: [BYTE; 4usize],
}
#[test]
fn bindgen_test_layout_TPMS_PCR_SELECTION() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_PCR_SELECTION>(),
        8usize,
        concat!("Size of: ", stringify!(TPMS_PCR_SELECTION))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_PCR_SELECTION>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMS_PCR_SELECTION))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_PCR_SELECTION>())).hash as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_PCR_SELECTION),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_PCR_SELECTION>())).sizeofSelect as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_PCR_SELECTION),
            "::",
            stringify!(sizeofSelect)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_PCR_SELECTION>())).pcrSelect as *const _ as usize },
        3usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_PCR_SELECTION),
            "::",
            stringify!(pcrSelect)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMT_TK_CREATION {
    pub tag: TPM2_ST,
    pub hierarchy: TPMI_RH_HIERARCHY,
    pub digest: TPM2B_DIGEST,
}
#[test]
fn bindgen_test_layout_TPMT_TK_CREATION() {
    assert_eq!(
        ::std::mem::size_of::<TPMT_TK_CREATION>(),
        76usize,
        concat!("Size of: ", stringify!(TPMT_TK_CREATION))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMT_TK_CREATION>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMT_TK_CREATION))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_TK_CREATION>())).tag as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_TK_CREATION),
            "::",
            stringify!(tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_TK_CREATION>())).hierarchy as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_TK_CREATION),
            "::",
            stringify!(hierarchy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_TK_CREATION>())).digest as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_TK_CREATION),
            "::",
            stringify!(digest)
        )
    );
}
impl Default for TPMT_TK_CREATION {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMT_TK_VERIFIED {
    pub tag: TPM2_ST,
    pub hierarchy: TPMI_RH_HIERARCHY,
    pub digest: TPM2B_DIGEST,
}
#[test]
fn bindgen_test_layout_TPMT_TK_VERIFIED() {
    assert_eq!(
        ::std::mem::size_of::<TPMT_TK_VERIFIED>(),
        76usize,
        concat!("Size of: ", stringify!(TPMT_TK_VERIFIED))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMT_TK_VERIFIED>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMT_TK_VERIFIED))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_TK_VERIFIED>())).tag as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_TK_VERIFIED),
            "::",
            stringify!(tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_TK_VERIFIED>())).hierarchy as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_TK_VERIFIED),
            "::",
            stringify!(hierarchy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_TK_VERIFIED>())).digest as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_TK_VERIFIED),
            "::",
            stringify!(digest)
        )
    );
}
impl Default for TPMT_TK_VERIFIED {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMT_TK_AUTH {
    pub tag: TPM2_ST,
    pub hierarchy: TPMI_RH_HIERARCHY,
    pub digest: TPM2B_DIGEST,
}
#[test]
fn bindgen_test_layout_TPMT_TK_AUTH() {
    assert_eq!(
        ::std::mem::size_of::<TPMT_TK_AUTH>(),
        76usize,
        concat!("Size of: ", stringify!(TPMT_TK_AUTH))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMT_TK_AUTH>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMT_TK_AUTH))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_TK_AUTH>())).tag as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_TK_AUTH),
            "::",
            stringify!(tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_TK_AUTH>())).hierarchy as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_TK_AUTH),
            "::",
            stringify!(hierarchy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_TK_AUTH>())).digest as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_TK_AUTH),
            "::",
            stringify!(digest)
        )
    );
}
impl Default for TPMT_TK_AUTH {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMT_TK_HASHCHECK {
    pub tag: TPM2_ST,
    pub hierarchy: TPMI_RH_HIERARCHY,
    pub digest: TPM2B_DIGEST,
}
#[test]
fn bindgen_test_layout_TPMT_TK_HASHCHECK() {
    assert_eq!(
        ::std::mem::size_of::<TPMT_TK_HASHCHECK>(),
        76usize,
        concat!("Size of: ", stringify!(TPMT_TK_HASHCHECK))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMT_TK_HASHCHECK>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMT_TK_HASHCHECK))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_TK_HASHCHECK>())).tag as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_TK_HASHCHECK),
            "::",
            stringify!(tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_TK_HASHCHECK>())).hierarchy as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_TK_HASHCHECK),
            "::",
            stringify!(hierarchy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_TK_HASHCHECK>())).digest as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_TK_HASHCHECK),
            "::",
            stringify!(digest)
        )
    );
}
impl Default for TPMT_TK_HASHCHECK {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TPMS_ALG_PROPERTY {
    pub alg: TPM2_ALG_ID,
    pub algProperties: TPMA_ALGORITHM,
}
#[test]
fn bindgen_test_layout_TPMS_ALG_PROPERTY() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_ALG_PROPERTY>(),
        8usize,
        concat!("Size of: ", stringify!(TPMS_ALG_PROPERTY))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_ALG_PROPERTY>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMS_ALG_PROPERTY))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ALG_PROPERTY>())).alg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ALG_PROPERTY),
            "::",
            stringify!(alg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ALG_PROPERTY>())).algProperties as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ALG_PROPERTY),
            "::",
            stringify!(algProperties)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TPMS_TAGGED_PROPERTY {
    pub property: TPM2_PT,
    pub value: UINT32,
}
#[test]
fn bindgen_test_layout_TPMS_TAGGED_PROPERTY() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_TAGGED_PROPERTY>(),
        8usize,
        concat!("Size of: ", stringify!(TPMS_TAGGED_PROPERTY))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_TAGGED_PROPERTY>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMS_TAGGED_PROPERTY))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_TAGGED_PROPERTY>())).property as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_TAGGED_PROPERTY),
            "::",
            stringify!(property)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_TAGGED_PROPERTY>())).value as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_TAGGED_PROPERTY),
            "::",
            stringify!(value)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TPMS_TAGGED_PCR_SELECT {
    pub tag: TPM2_PT_PCR,
    pub sizeofSelect: UINT8,
    pub pcrSelect: [BYTE; 4usize],
}
#[test]
fn bindgen_test_layout_TPMS_TAGGED_PCR_SELECT() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_TAGGED_PCR_SELECT>(),
        12usize,
        concat!("Size of: ", stringify!(TPMS_TAGGED_PCR_SELECT))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_TAGGED_PCR_SELECT>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMS_TAGGED_PCR_SELECT))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_TAGGED_PCR_SELECT>())).tag as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_TAGGED_PCR_SELECT),
            "::",
            stringify!(tag)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPMS_TAGGED_PCR_SELECT>())).sizeofSelect as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_TAGGED_PCR_SELECT),
            "::",
            stringify!(sizeofSelect)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPMS_TAGGED_PCR_SELECT>())).pcrSelect as *const _ as usize
        },
        5usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_TAGGED_PCR_SELECT),
            "::",
            stringify!(pcrSelect)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMS_TAGGED_POLICY {
    pub handle: TPM2_HANDLE,
    pub policyHash: TPMT_HA,
}
#[test]
fn bindgen_test_layout_TPMS_TAGGED_POLICY() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_TAGGED_POLICY>(),
        72usize,
        concat!("Size of: ", stringify!(TPMS_TAGGED_POLICY))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_TAGGED_POLICY>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMS_TAGGED_POLICY))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_TAGGED_POLICY>())).handle as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_TAGGED_POLICY),
            "::",
            stringify!(handle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_TAGGED_POLICY>())).policyHash as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_TAGGED_POLICY),
            "::",
            stringify!(policyHash)
        )
    );
}
impl Default for TPMS_TAGGED_POLICY {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPML_CC {
    pub count: UINT32,
    pub commandCodes: [TPM2_CC; 256usize],
}
#[test]
fn bindgen_test_layout_TPML_CC() {
    assert_eq!(
        ::std::mem::size_of::<TPML_CC>(),
        1028usize,
        concat!("Size of: ", stringify!(TPML_CC))
    );
    assert_eq!(
        ::std::mem::align_of::<TPML_CC>(),
        4usize,
        concat!("Alignment of ", stringify!(TPML_CC))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPML_CC>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_CC),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPML_CC>())).commandCodes as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_CC),
            "::",
            stringify!(commandCodes)
        )
    );
}
impl Default for TPML_CC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPML_CCA {
    pub count: UINT32,
    pub commandAttributes: [TPMA_CC; 256usize],
}
#[test]
fn bindgen_test_layout_TPML_CCA() {
    assert_eq!(
        ::std::mem::size_of::<TPML_CCA>(),
        1028usize,
        concat!("Size of: ", stringify!(TPML_CCA))
    );
    assert_eq!(
        ::std::mem::align_of::<TPML_CCA>(),
        4usize,
        concat!("Alignment of ", stringify!(TPML_CCA))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPML_CCA>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_CCA),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPML_CCA>())).commandAttributes as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_CCA),
            "::",
            stringify!(commandAttributes)
        )
    );
}
impl Default for TPML_CCA {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPML_ALG {
    pub count: UINT32,
    pub algorithms: [TPM2_ALG_ID; 128usize],
}
#[test]
fn bindgen_test_layout_TPML_ALG() {
    assert_eq!(
        ::std::mem::size_of::<TPML_ALG>(),
        260usize,
        concat!("Size of: ", stringify!(TPML_ALG))
    );
    assert_eq!(
        ::std::mem::align_of::<TPML_ALG>(),
        4usize,
        concat!("Alignment of ", stringify!(TPML_ALG))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPML_ALG>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_ALG),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPML_ALG>())).algorithms as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_ALG),
            "::",
            stringify!(algorithms)
        )
    );
}
impl Default for TPML_ALG {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPML_HANDLE {
    pub count: UINT32,
    pub handle: [TPM2_HANDLE; 254usize],
}
#[test]
fn bindgen_test_layout_TPML_HANDLE() {
    assert_eq!(
        ::std::mem::size_of::<TPML_HANDLE>(),
        1020usize,
        concat!("Size of: ", stringify!(TPML_HANDLE))
    );
    assert_eq!(
        ::std::mem::align_of::<TPML_HANDLE>(),
        4usize,
        concat!("Alignment of ", stringify!(TPML_HANDLE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPML_HANDLE>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_HANDLE),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPML_HANDLE>())).handle as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_HANDLE),
            "::",
            stringify!(handle)
        )
    );
}
impl Default for TPML_HANDLE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPML_DIGEST {
    pub count: UINT32,
    pub digests: [TPM2B_DIGEST; 8usize],
}
#[test]
fn bindgen_test_layout_TPML_DIGEST() {
    assert_eq!(
        ::std::mem::size_of::<TPML_DIGEST>(),
        532usize,
        concat!("Size of: ", stringify!(TPML_DIGEST))
    );
    assert_eq!(
        ::std::mem::align_of::<TPML_DIGEST>(),
        4usize,
        concat!("Alignment of ", stringify!(TPML_DIGEST))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPML_DIGEST>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_DIGEST),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPML_DIGEST>())).digests as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_DIGEST),
            "::",
            stringify!(digests)
        )
    );
}
impl Default for TPML_DIGEST {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPML_DIGEST_VALUES {
    pub count: UINT32,
    pub digests: [TPMT_HA; 16usize],
}
#[test]
fn bindgen_test_layout_TPML_DIGEST_VALUES() {
    assert_eq!(
        ::std::mem::size_of::<TPML_DIGEST_VALUES>(),
        1060usize,
        concat!("Size of: ", stringify!(TPML_DIGEST_VALUES))
    );
    assert_eq!(
        ::std::mem::align_of::<TPML_DIGEST_VALUES>(),
        4usize,
        concat!("Alignment of ", stringify!(TPML_DIGEST_VALUES))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPML_DIGEST_VALUES>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_DIGEST_VALUES),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPML_DIGEST_VALUES>())).digests as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_DIGEST_VALUES),
            "::",
            stringify!(digests)
        )
    );
}
impl Default for TPML_DIGEST_VALUES {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TPML_PCR_SELECTION {
    pub count: UINT32,
    pub pcrSelections: [TPMS_PCR_SELECTION; 16usize],
}
#[test]
fn bindgen_test_layout_TPML_PCR_SELECTION() {
    assert_eq!(
        ::std::mem::size_of::<TPML_PCR_SELECTION>(),
        132usize,
        concat!("Size of: ", stringify!(TPML_PCR_SELECTION))
    );
    assert_eq!(
        ::std::mem::align_of::<TPML_PCR_SELECTION>(),
        4usize,
        concat!("Alignment of ", stringify!(TPML_PCR_SELECTION))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPML_PCR_SELECTION>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_PCR_SELECTION),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPML_PCR_SELECTION>())).pcrSelections as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_PCR_SELECTION),
            "::",
            stringify!(pcrSelections)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPML_ALG_PROPERTY {
    pub count: UINT32,
    pub algProperties: [TPMS_ALG_PROPERTY; 127usize],
}
#[test]
fn bindgen_test_layout_TPML_ALG_PROPERTY() {
    assert_eq!(
        ::std::mem::size_of::<TPML_ALG_PROPERTY>(),
        1020usize,
        concat!("Size of: ", stringify!(TPML_ALG_PROPERTY))
    );
    assert_eq!(
        ::std::mem::align_of::<TPML_ALG_PROPERTY>(),
        4usize,
        concat!("Alignment of ", stringify!(TPML_ALG_PROPERTY))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPML_ALG_PROPERTY>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_ALG_PROPERTY),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPML_ALG_PROPERTY>())).algProperties as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_ALG_PROPERTY),
            "::",
            stringify!(algProperties)
        )
    );
}
impl Default for TPML_ALG_PROPERTY {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPML_TAGGED_TPM_PROPERTY {
    pub count: UINT32,
    pub tpmProperty: [TPMS_TAGGED_PROPERTY; 127usize],
}
#[test]
fn bindgen_test_layout_TPML_TAGGED_TPM_PROPERTY() {
    assert_eq!(
        ::std::mem::size_of::<TPML_TAGGED_TPM_PROPERTY>(),
        1020usize,
        concat!("Size of: ", stringify!(TPML_TAGGED_TPM_PROPERTY))
    );
    assert_eq!(
        ::std::mem::align_of::<TPML_TAGGED_TPM_PROPERTY>(),
        4usize,
        concat!("Alignment of ", stringify!(TPML_TAGGED_TPM_PROPERTY))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPML_TAGGED_TPM_PROPERTY>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_TAGGED_TPM_PROPERTY),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPML_TAGGED_TPM_PROPERTY>())).tpmProperty as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_TAGGED_TPM_PROPERTY),
            "::",
            stringify!(tpmProperty)
        )
    );
}
impl Default for TPML_TAGGED_TPM_PROPERTY {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPML_TAGGED_PCR_PROPERTY {
    pub count: UINT32,
    pub pcrProperty: [TPMS_TAGGED_PCR_SELECT; 84usize],
}
#[test]
fn bindgen_test_layout_TPML_TAGGED_PCR_PROPERTY() {
    assert_eq!(
        ::std::mem::size_of::<TPML_TAGGED_PCR_PROPERTY>(),
        1012usize,
        concat!("Size of: ", stringify!(TPML_TAGGED_PCR_PROPERTY))
    );
    assert_eq!(
        ::std::mem::align_of::<TPML_TAGGED_PCR_PROPERTY>(),
        4usize,
        concat!("Alignment of ", stringify!(TPML_TAGGED_PCR_PROPERTY))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPML_TAGGED_PCR_PROPERTY>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_TAGGED_PCR_PROPERTY),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPML_TAGGED_PCR_PROPERTY>())).pcrProperty as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_TAGGED_PCR_PROPERTY),
            "::",
            stringify!(pcrProperty)
        )
    );
}
impl Default for TPML_TAGGED_PCR_PROPERTY {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPML_ECC_CURVE {
    pub count: UINT32,
    pub eccCurves: [TPM2_ECC_CURVE; 508usize],
}
#[test]
fn bindgen_test_layout_TPML_ECC_CURVE() {
    assert_eq!(
        ::std::mem::size_of::<TPML_ECC_CURVE>(),
        1020usize,
        concat!("Size of: ", stringify!(TPML_ECC_CURVE))
    );
    assert_eq!(
        ::std::mem::align_of::<TPML_ECC_CURVE>(),
        4usize,
        concat!("Alignment of ", stringify!(TPML_ECC_CURVE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPML_ECC_CURVE>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_ECC_CURVE),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPML_ECC_CURVE>())).eccCurves as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_ECC_CURVE),
            "::",
            stringify!(eccCurves)
        )
    );
}
impl Default for TPML_ECC_CURVE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPML_INTEL_PTT_PROPERTY {
    pub count: UINT32,
    pub property: [UINT32; 256usize],
}
#[test]
fn bindgen_test_layout_TPML_INTEL_PTT_PROPERTY() {
    assert_eq!(
        ::std::mem::size_of::<TPML_INTEL_PTT_PROPERTY>(),
        1028usize,
        concat!("Size of: ", stringify!(TPML_INTEL_PTT_PROPERTY))
    );
    assert_eq!(
        ::std::mem::align_of::<TPML_INTEL_PTT_PROPERTY>(),
        4usize,
        concat!("Alignment of ", stringify!(TPML_INTEL_PTT_PROPERTY))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPML_INTEL_PTT_PROPERTY>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_INTEL_PTT_PROPERTY),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPML_INTEL_PTT_PROPERTY>())).property as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_INTEL_PTT_PROPERTY),
            "::",
            stringify!(property)
        )
    );
}
impl Default for TPML_INTEL_PTT_PROPERTY {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union TPMU_CAPABILITIES {
    pub algorithms: TPML_ALG_PROPERTY,
    pub handles: TPML_HANDLE,
    pub command: TPML_CCA,
    pub ppCommands: TPML_CC,
    pub auditCommands: TPML_CC,
    pub assignedPCR: TPML_PCR_SELECTION,
    pub tpmProperties: TPML_TAGGED_TPM_PROPERTY,
    pub pcrProperties: TPML_TAGGED_PCR_PROPERTY,
    pub eccCurves: TPML_ECC_CURVE,
    pub intelPttProperty: TPML_INTEL_PTT_PROPERTY,
}
#[test]
fn bindgen_test_layout_TPMU_CAPABILITIES() {
    assert_eq!(
        ::std::mem::size_of::<TPMU_CAPABILITIES>(),
        1028usize,
        concat!("Size of: ", stringify!(TPMU_CAPABILITIES))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMU_CAPABILITIES>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMU_CAPABILITIES))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_CAPABILITIES>())).algorithms as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_CAPABILITIES),
            "::",
            stringify!(algorithms)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_CAPABILITIES>())).handles as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_CAPABILITIES),
            "::",
            stringify!(handles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_CAPABILITIES>())).command as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_CAPABILITIES),
            "::",
            stringify!(command)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_CAPABILITIES>())).ppCommands as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_CAPABILITIES),
            "::",
            stringify!(ppCommands)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_CAPABILITIES>())).auditCommands as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_CAPABILITIES),
            "::",
            stringify!(auditCommands)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_CAPABILITIES>())).assignedPCR as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_CAPABILITIES),
            "::",
            stringify!(assignedPCR)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_CAPABILITIES>())).tpmProperties as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_CAPABILITIES),
            "::",
            stringify!(tpmProperties)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_CAPABILITIES>())).pcrProperties as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_CAPABILITIES),
            "::",
            stringify!(pcrProperties)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_CAPABILITIES>())).eccCurves as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_CAPABILITIES),
            "::",
            stringify!(eccCurves)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPMU_CAPABILITIES>())).intelPttProperty as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_CAPABILITIES),
            "::",
            stringify!(intelPttProperty)
        )
    );
}
impl Default for TPMU_CAPABILITIES {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMS_CAPABILITY_DATA {
    pub capability: TPM2_CAP,
    pub data: TPMU_CAPABILITIES,
}
#[test]
fn bindgen_test_layout_TPMS_CAPABILITY_DATA() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_CAPABILITY_DATA>(),
        1032usize,
        concat!("Size of: ", stringify!(TPMS_CAPABILITY_DATA))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_CAPABILITY_DATA>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMS_CAPABILITY_DATA))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_CAPABILITY_DATA>())).capability as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CAPABILITY_DATA),
            "::",
            stringify!(capability)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_CAPABILITY_DATA>())).data as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CAPABILITY_DATA),
            "::",
            stringify!(data)
        )
    );
}
impl Default for TPMS_CAPABILITY_DATA {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TPMS_CLOCK_INFO {
    pub clock: UINT64,
    pub resetCount: UINT32,
    pub restartCount: UINT32,
    pub safe: TPMI_YES_NO,
}
#[test]
fn bindgen_test_layout_TPMS_CLOCK_INFO() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_CLOCK_INFO>(),
        24usize,
        concat!("Size of: ", stringify!(TPMS_CLOCK_INFO))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_CLOCK_INFO>(),
        8usize,
        concat!("Alignment of ", stringify!(TPMS_CLOCK_INFO))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_CLOCK_INFO>())).clock as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CLOCK_INFO),
            "::",
            stringify!(clock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_CLOCK_INFO>())).resetCount as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CLOCK_INFO),
            "::",
            stringify!(resetCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_CLOCK_INFO>())).restartCount as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CLOCK_INFO),
            "::",
            stringify!(restartCount)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_CLOCK_INFO>())).safe as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CLOCK_INFO),
            "::",
            stringify!(safe)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TPMS_TIME_INFO {
    pub time: UINT64,
    pub clockInfo: TPMS_CLOCK_INFO,
}
#[test]
fn bindgen_test_layout_TPMS_TIME_INFO() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_TIME_INFO>(),
        32usize,
        concat!("Size of: ", stringify!(TPMS_TIME_INFO))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_TIME_INFO>(),
        8usize,
        concat!("Alignment of ", stringify!(TPMS_TIME_INFO))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_TIME_INFO>())).time as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_TIME_INFO),
            "::",
            stringify!(time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_TIME_INFO>())).clockInfo as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_TIME_INFO),
            "::",
            stringify!(clockInfo)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TPMS_TIME_ATTEST_INFO {
    pub time: TPMS_TIME_INFO,
    pub firmwareVersion: UINT64,
}
#[test]
fn bindgen_test_layout_TPMS_TIME_ATTEST_INFO() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_TIME_ATTEST_INFO>(),
        40usize,
        concat!("Size of: ", stringify!(TPMS_TIME_ATTEST_INFO))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_TIME_ATTEST_INFO>(),
        8usize,
        concat!("Alignment of ", stringify!(TPMS_TIME_ATTEST_INFO))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_TIME_ATTEST_INFO>())).time as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_TIME_ATTEST_INFO),
            "::",
            stringify!(time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPMS_TIME_ATTEST_INFO>())).firmwareVersion as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_TIME_ATTEST_INFO),
            "::",
            stringify!(firmwareVersion)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMS_CERTIFY_INFO {
    pub name: TPM2B_NAME,
    pub qualifiedName: TPM2B_NAME,
}
#[test]
fn bindgen_test_layout_TPMS_CERTIFY_INFO() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_CERTIFY_INFO>(),
        140usize,
        concat!("Size of: ", stringify!(TPMS_CERTIFY_INFO))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_CERTIFY_INFO>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMS_CERTIFY_INFO))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_CERTIFY_INFO>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CERTIFY_INFO),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_CERTIFY_INFO>())).qualifiedName as *const _ as usize },
        70usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CERTIFY_INFO),
            "::",
            stringify!(qualifiedName)
        )
    );
}
impl Default for TPMS_CERTIFY_INFO {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMS_QUOTE_INFO {
    pub pcrSelect: TPML_PCR_SELECTION,
    pub pcrDigest: TPM2B_DIGEST,
}
#[test]
fn bindgen_test_layout_TPMS_QUOTE_INFO() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_QUOTE_INFO>(),
        200usize,
        concat!("Size of: ", stringify!(TPMS_QUOTE_INFO))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_QUOTE_INFO>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMS_QUOTE_INFO))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_QUOTE_INFO>())).pcrSelect as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_QUOTE_INFO),
            "::",
            stringify!(pcrSelect)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_QUOTE_INFO>())).pcrDigest as *const _ as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_QUOTE_INFO),
            "::",
            stringify!(pcrDigest)
        )
    );
}
impl Default for TPMS_QUOTE_INFO {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMS_COMMAND_AUDIT_INFO {
    pub auditCounter: UINT64,
    pub digestAlg: TPM2_ALG_ID,
    pub auditDigest: TPM2B_DIGEST,
    pub commandDigest: TPM2B_DIGEST,
}
#[test]
fn bindgen_test_layout_TPMS_COMMAND_AUDIT_INFO() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_COMMAND_AUDIT_INFO>(),
        144usize,
        concat!("Size of: ", stringify!(TPMS_COMMAND_AUDIT_INFO))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_COMMAND_AUDIT_INFO>(),
        8usize,
        concat!("Alignment of ", stringify!(TPMS_COMMAND_AUDIT_INFO))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPMS_COMMAND_AUDIT_INFO>())).auditCounter as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_COMMAND_AUDIT_INFO),
            "::",
            stringify!(auditCounter)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPMS_COMMAND_AUDIT_INFO>())).digestAlg as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_COMMAND_AUDIT_INFO),
            "::",
            stringify!(digestAlg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPMS_COMMAND_AUDIT_INFO>())).auditDigest as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_COMMAND_AUDIT_INFO),
            "::",
            stringify!(auditDigest)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPMS_COMMAND_AUDIT_INFO>())).commandDigest as *const _ as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_COMMAND_AUDIT_INFO),
            "::",
            stringify!(commandDigest)
        )
    );
}
impl Default for TPMS_COMMAND_AUDIT_INFO {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMS_SESSION_AUDIT_INFO {
    pub exclusiveSession: TPMI_YES_NO,
    pub sessionDigest: TPM2B_DIGEST,
}
#[test]
fn bindgen_test_layout_TPMS_SESSION_AUDIT_INFO() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_SESSION_AUDIT_INFO>(),
        68usize,
        concat!("Size of: ", stringify!(TPMS_SESSION_AUDIT_INFO))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_SESSION_AUDIT_INFO>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMS_SESSION_AUDIT_INFO))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPMS_SESSION_AUDIT_INFO>())).exclusiveSession as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_SESSION_AUDIT_INFO),
            "::",
            stringify!(exclusiveSession)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPMS_SESSION_AUDIT_INFO>())).sessionDigest as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_SESSION_AUDIT_INFO),
            "::",
            stringify!(sessionDigest)
        )
    );
}
impl Default for TPMS_SESSION_AUDIT_INFO {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMS_CREATION_INFO {
    pub objectName: TPM2B_NAME,
    pub creationHash: TPM2B_DIGEST,
}
#[test]
fn bindgen_test_layout_TPMS_CREATION_INFO() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_CREATION_INFO>(),
        136usize,
        concat!("Size of: ", stringify!(TPMS_CREATION_INFO))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_CREATION_INFO>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMS_CREATION_INFO))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_CREATION_INFO>())).objectName as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CREATION_INFO),
            "::",
            stringify!(objectName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_CREATION_INFO>())).creationHash as *const _ as usize },
        70usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CREATION_INFO),
            "::",
            stringify!(creationHash)
        )
    );
}
impl Default for TPMS_CREATION_INFO {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMS_NV_CERTIFY_INFO {
    pub indexName: TPM2B_NAME,
    pub offset: UINT16,
    pub nvContents: TPM2B_MAX_NV_BUFFER,
}
#[test]
fn bindgen_test_layout_TPMS_NV_CERTIFY_INFO() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_NV_CERTIFY_INFO>(),
        2122usize,
        concat!("Size of: ", stringify!(TPMS_NV_CERTIFY_INFO))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_NV_CERTIFY_INFO>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMS_NV_CERTIFY_INFO))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_NV_CERTIFY_INFO>())).indexName as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_NV_CERTIFY_INFO),
            "::",
            stringify!(indexName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_NV_CERTIFY_INFO>())).offset as *const _ as usize },
        70usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_NV_CERTIFY_INFO),
            "::",
            stringify!(offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_NV_CERTIFY_INFO>())).nvContents as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_NV_CERTIFY_INFO),
            "::",
            stringify!(nvContents)
        )
    );
}
impl Default for TPMS_NV_CERTIFY_INFO {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TPMI_ST_ATTEST = TPM2_ST;
#[repr(C)]
#[derive(Copy, Clone)]
pub union TPMU_ATTEST {
    pub certify: TPMS_CERTIFY_INFO,
    pub creation: TPMS_CREATION_INFO,
    pub quote: TPMS_QUOTE_INFO,
    pub commandAudit: TPMS_COMMAND_AUDIT_INFO,
    pub sessionAudit: TPMS_SESSION_AUDIT_INFO,
    pub time: TPMS_TIME_ATTEST_INFO,
    pub nv: TPMS_NV_CERTIFY_INFO,
}
#[test]
fn bindgen_test_layout_TPMU_ATTEST() {
    assert_eq!(
        ::std::mem::size_of::<TPMU_ATTEST>(),
        2128usize,
        concat!("Size of: ", stringify!(TPMU_ATTEST))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMU_ATTEST>(),
        8usize,
        concat!("Alignment of ", stringify!(TPMU_ATTEST))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ATTEST>())).certify as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ATTEST),
            "::",
            stringify!(certify)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ATTEST>())).creation as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ATTEST),
            "::",
            stringify!(creation)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ATTEST>())).quote as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ATTEST),
            "::",
            stringify!(quote)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ATTEST>())).commandAudit as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ATTEST),
            "::",
            stringify!(commandAudit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ATTEST>())).sessionAudit as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ATTEST),
            "::",
            stringify!(sessionAudit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ATTEST>())).time as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ATTEST),
            "::",
            stringify!(time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ATTEST>())).nv as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ATTEST),
            "::",
            stringify!(nv)
        )
    );
}
impl Default for TPMU_ATTEST {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMS_ATTEST {
    pub magic: TPM2_GENERATED,
    pub type_: TPMI_ST_ATTEST,
    pub qualifiedSigner: TPM2B_NAME,
    pub extraData: TPM2B_DATA,
    pub clockInfo: TPMS_CLOCK_INFO,
    pub firmwareVersion: UINT64,
    pub attested: TPMU_ATTEST,
}
#[test]
fn bindgen_test_layout_TPMS_ATTEST() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_ATTEST>(),
        2304usize,
        concat!("Size of: ", stringify!(TPMS_ATTEST))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_ATTEST>(),
        8usize,
        concat!("Alignment of ", stringify!(TPMS_ATTEST))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ATTEST>())).magic as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ATTEST),
            "::",
            stringify!(magic)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ATTEST>())).type_ as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ATTEST),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ATTEST>())).qualifiedSigner as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ATTEST),
            "::",
            stringify!(qualifiedSigner)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ATTEST>())).extraData as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ATTEST),
            "::",
            stringify!(extraData)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ATTEST>())).clockInfo as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ATTEST),
            "::",
            stringify!(clockInfo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ATTEST>())).firmwareVersion as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ATTEST),
            "::",
            stringify!(firmwareVersion)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ATTEST>())).attested as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ATTEST),
            "::",
            stringify!(attested)
        )
    );
}
impl Default for TPMS_ATTEST {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_ATTEST {
    pub size: UINT16,
    pub attestationData: [BYTE; 2304usize],
}
#[test]
fn bindgen_test_layout_TPM2B_ATTEST() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_ATTEST>(),
        2306usize,
        concat!("Size of: ", stringify!(TPM2B_ATTEST))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_ATTEST>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_ATTEST))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_ATTEST>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_ATTEST),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_ATTEST>())).attestationData as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_ATTEST),
            "::",
            stringify!(attestationData)
        )
    );
}
impl Default for TPM2B_ATTEST {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMS_AUTH_COMMAND {
    pub sessionHandle: TPMI_SH_AUTH_SESSION,
    pub nonce: TPM2B_NONCE,
    pub sessionAttributes: TPMA_SESSION,
    pub hmac: TPM2B_AUTH,
}
#[test]
fn bindgen_test_layout_TPMS_AUTH_COMMAND() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_AUTH_COMMAND>(),
        140usize,
        concat!("Size of: ", stringify!(TPMS_AUTH_COMMAND))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_AUTH_COMMAND>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMS_AUTH_COMMAND))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_AUTH_COMMAND>())).sessionHandle as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_AUTH_COMMAND),
            "::",
            stringify!(sessionHandle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_AUTH_COMMAND>())).nonce as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_AUTH_COMMAND),
            "::",
            stringify!(nonce)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPMS_AUTH_COMMAND>())).sessionAttributes as *const _ as usize
        },
        70usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_AUTH_COMMAND),
            "::",
            stringify!(sessionAttributes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_AUTH_COMMAND>())).hmac as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_AUTH_COMMAND),
            "::",
            stringify!(hmac)
        )
    );
}
impl Default for TPMS_AUTH_COMMAND {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMS_AUTH_RESPONSE {
    pub nonce: TPM2B_NONCE,
    pub sessionAttributes: TPMA_SESSION,
    pub hmac: TPM2B_AUTH,
}
#[test]
fn bindgen_test_layout_TPMS_AUTH_RESPONSE() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_AUTH_RESPONSE>(),
        134usize,
        concat!("Size of: ", stringify!(TPMS_AUTH_RESPONSE))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_AUTH_RESPONSE>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMS_AUTH_RESPONSE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_AUTH_RESPONSE>())).nonce as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_AUTH_RESPONSE),
            "::",
            stringify!(nonce)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPMS_AUTH_RESPONSE>())).sessionAttributes as *const _ as usize
        },
        66usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_AUTH_RESPONSE),
            "::",
            stringify!(sessionAttributes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_AUTH_RESPONSE>())).hmac as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_AUTH_RESPONSE),
            "::",
            stringify!(hmac)
        )
    );
}
impl Default for TPMS_AUTH_RESPONSE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TPMI_AES_KEY_BITS = TPM2_KEY_BITS;
pub type TPMI_SM4_KEY_BITS = TPM2_KEY_BITS;
pub type TPMI_TPM2_CAMELLIA_KEY_BITS = TPM2_KEY_BITS;
#[repr(C)]
#[derive(Copy, Clone)]
pub union TPMU_SYM_KEY_BITS {
    pub aes: TPMI_AES_KEY_BITS,
    pub sm4: TPMI_SM4_KEY_BITS,
    pub camellia: TPMI_TPM2_CAMELLIA_KEY_BITS,
    pub sym: TPM2_KEY_BITS,
    pub exclusiveOr: TPMI_ALG_HASH,
}
#[test]
fn bindgen_test_layout_TPMU_SYM_KEY_BITS() {
    assert_eq!(
        ::std::mem::size_of::<TPMU_SYM_KEY_BITS>(),
        2usize,
        concat!("Size of: ", stringify!(TPMU_SYM_KEY_BITS))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMU_SYM_KEY_BITS>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMU_SYM_KEY_BITS))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SYM_KEY_BITS>())).aes as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SYM_KEY_BITS),
            "::",
            stringify!(aes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SYM_KEY_BITS>())).sm4 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SYM_KEY_BITS),
            "::",
            stringify!(sm4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SYM_KEY_BITS>())).camellia as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SYM_KEY_BITS),
            "::",
            stringify!(camellia)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SYM_KEY_BITS>())).sym as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SYM_KEY_BITS),
            "::",
            stringify!(sym)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SYM_KEY_BITS>())).exclusiveOr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SYM_KEY_BITS),
            "::",
            stringify!(exclusiveOr)
        )
    );
}
impl Default for TPMU_SYM_KEY_BITS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union TPMU_SYM_MODE {
    pub aes: TPMI_ALG_SYM_MODE,
    pub sm4: TPMI_ALG_SYM_MODE,
    pub camellia: TPMI_ALG_SYM_MODE,
    pub sym: TPMI_ALG_SYM_MODE,
}
#[test]
fn bindgen_test_layout_TPMU_SYM_MODE() {
    assert_eq!(
        ::std::mem::size_of::<TPMU_SYM_MODE>(),
        2usize,
        concat!("Size of: ", stringify!(TPMU_SYM_MODE))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMU_SYM_MODE>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMU_SYM_MODE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SYM_MODE>())).aes as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SYM_MODE),
            "::",
            stringify!(aes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SYM_MODE>())).sm4 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SYM_MODE),
            "::",
            stringify!(sm4)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SYM_MODE>())).camellia as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SYM_MODE),
            "::",
            stringify!(camellia)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SYM_MODE>())).sym as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SYM_MODE),
            "::",
            stringify!(sym)
        )
    );
}
impl Default for TPMU_SYM_MODE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMT_SYM_DEF {
    pub algorithm: TPMI_ALG_SYM,
    pub keyBits: TPMU_SYM_KEY_BITS,
    pub mode: TPMU_SYM_MODE,
}
#[test]
fn bindgen_test_layout_TPMT_SYM_DEF() {
    assert_eq!(
        ::std::mem::size_of::<TPMT_SYM_DEF>(),
        6usize,
        concat!("Size of: ", stringify!(TPMT_SYM_DEF))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMT_SYM_DEF>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMT_SYM_DEF))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_SYM_DEF>())).algorithm as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_SYM_DEF),
            "::",
            stringify!(algorithm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_SYM_DEF>())).keyBits as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_SYM_DEF),
            "::",
            stringify!(keyBits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_SYM_DEF>())).mode as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_SYM_DEF),
            "::",
            stringify!(mode)
        )
    );
}
impl Default for TPMT_SYM_DEF {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMT_SYM_DEF_OBJECT {
    pub algorithm: TPMI_ALG_SYM_OBJECT,
    pub keyBits: TPMU_SYM_KEY_BITS,
    pub mode: TPMU_SYM_MODE,
}
#[test]
fn bindgen_test_layout_TPMT_SYM_DEF_OBJECT() {
    assert_eq!(
        ::std::mem::size_of::<TPMT_SYM_DEF_OBJECT>(),
        6usize,
        concat!("Size of: ", stringify!(TPMT_SYM_DEF_OBJECT))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMT_SYM_DEF_OBJECT>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMT_SYM_DEF_OBJECT))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_SYM_DEF_OBJECT>())).algorithm as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_SYM_DEF_OBJECT),
            "::",
            stringify!(algorithm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_SYM_DEF_OBJECT>())).keyBits as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_SYM_DEF_OBJECT),
            "::",
            stringify!(keyBits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_SYM_DEF_OBJECT>())).mode as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_SYM_DEF_OBJECT),
            "::",
            stringify!(mode)
        )
    );
}
impl Default for TPMT_SYM_DEF_OBJECT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TPM2B_SYM_KEY {
    pub size: UINT16,
    pub buffer: [BYTE; 32usize],
}
#[test]
fn bindgen_test_layout_TPM2B_SYM_KEY() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_SYM_KEY>(),
        34usize,
        concat!("Size of: ", stringify!(TPM2B_SYM_KEY))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_SYM_KEY>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_SYM_KEY))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_SYM_KEY>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_SYM_KEY),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_SYM_KEY>())).buffer as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_SYM_KEY),
            "::",
            stringify!(buffer)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMS_SYMCIPHER_PARMS {
    pub sym: TPMT_SYM_DEF_OBJECT,
}
#[test]
fn bindgen_test_layout_TPMS_SYMCIPHER_PARMS() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_SYMCIPHER_PARMS>(),
        6usize,
        concat!("Size of: ", stringify!(TPMS_SYMCIPHER_PARMS))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_SYMCIPHER_PARMS>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMS_SYMCIPHER_PARMS))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_SYMCIPHER_PARMS>())).sym as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_SYMCIPHER_PARMS),
            "::",
            stringify!(sym)
        )
    );
}
impl Default for TPMS_SYMCIPHER_PARMS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_SENSITIVE_DATA {
    pub size: UINT16,
    pub buffer: [BYTE; 256usize],
}
#[test]
fn bindgen_test_layout_TPM2B_SENSITIVE_DATA() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_SENSITIVE_DATA>(),
        258usize,
        concat!("Size of: ", stringify!(TPM2B_SENSITIVE_DATA))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_SENSITIVE_DATA>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_SENSITIVE_DATA))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_SENSITIVE_DATA>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_SENSITIVE_DATA),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_SENSITIVE_DATA>())).buffer as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_SENSITIVE_DATA),
            "::",
            stringify!(buffer)
        )
    );
}
impl Default for TPM2B_SENSITIVE_DATA {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMS_SENSITIVE_CREATE {
    pub userAuth: TPM2B_AUTH,
    pub data: TPM2B_SENSITIVE_DATA,
}
#[test]
fn bindgen_test_layout_TPMS_SENSITIVE_CREATE() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_SENSITIVE_CREATE>(),
        324usize,
        concat!("Size of: ", stringify!(TPMS_SENSITIVE_CREATE))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_SENSITIVE_CREATE>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMS_SENSITIVE_CREATE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_SENSITIVE_CREATE>())).userAuth as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_SENSITIVE_CREATE),
            "::",
            stringify!(userAuth)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_SENSITIVE_CREATE>())).data as *const _ as usize },
        66usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_SENSITIVE_CREATE),
            "::",
            stringify!(data)
        )
    );
}
impl Default for TPMS_SENSITIVE_CREATE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_SENSITIVE_CREATE {
    pub size: UINT16,
    pub sensitive: TPMS_SENSITIVE_CREATE,
}
#[test]
fn bindgen_test_layout_TPM2B_SENSITIVE_CREATE() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_SENSITIVE_CREATE>(),
        326usize,
        concat!("Size of: ", stringify!(TPM2B_SENSITIVE_CREATE))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_SENSITIVE_CREATE>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_SENSITIVE_CREATE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_SENSITIVE_CREATE>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_SENSITIVE_CREATE),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPM2B_SENSITIVE_CREATE>())).sensitive as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_SENSITIVE_CREATE),
            "::",
            stringify!(sensitive)
        )
    );
}
impl Default for TPM2B_SENSITIVE_CREATE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TPMS_SCHEME_HASH {
    pub hashAlg: TPMI_ALG_HASH,
}
#[test]
fn bindgen_test_layout_TPMS_SCHEME_HASH() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_SCHEME_HASH>(),
        2usize,
        concat!("Size of: ", stringify!(TPMS_SCHEME_HASH))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_SCHEME_HASH>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMS_SCHEME_HASH))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_SCHEME_HASH>())).hashAlg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_SCHEME_HASH),
            "::",
            stringify!(hashAlg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TPMS_SCHEME_ECDAA {
    pub hashAlg: TPMI_ALG_HASH,
    pub count: UINT16,
}
#[test]
fn bindgen_test_layout_TPMS_SCHEME_ECDAA() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_SCHEME_ECDAA>(),
        4usize,
        concat!("Size of: ", stringify!(TPMS_SCHEME_ECDAA))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_SCHEME_ECDAA>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMS_SCHEME_ECDAA))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_SCHEME_ECDAA>())).hashAlg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_SCHEME_ECDAA),
            "::",
            stringify!(hashAlg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_SCHEME_ECDAA>())).count as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_SCHEME_ECDAA),
            "::",
            stringify!(count)
        )
    );
}
pub type TPMI_ALG_KEYEDHASH_SCHEME = TPM2_ALG_ID;
pub type TPMS_SCHEME_HMAC = TPMS_SCHEME_HASH;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TPMS_SCHEME_XOR {
    pub hashAlg: TPMI_ALG_HASH,
    pub kdf: TPMI_ALG_KDF,
}
#[test]
fn bindgen_test_layout_TPMS_SCHEME_XOR() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_SCHEME_XOR>(),
        4usize,
        concat!("Size of: ", stringify!(TPMS_SCHEME_XOR))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_SCHEME_XOR>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMS_SCHEME_XOR))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_SCHEME_XOR>())).hashAlg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_SCHEME_XOR),
            "::",
            stringify!(hashAlg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_SCHEME_XOR>())).kdf as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_SCHEME_XOR),
            "::",
            stringify!(kdf)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union TPMU_SCHEME_KEYEDHASH {
    pub hmac: TPMS_SCHEME_HMAC,
    pub exclusiveOr: TPMS_SCHEME_XOR,
}
#[test]
fn bindgen_test_layout_TPMU_SCHEME_KEYEDHASH() {
    assert_eq!(
        ::std::mem::size_of::<TPMU_SCHEME_KEYEDHASH>(),
        4usize,
        concat!("Size of: ", stringify!(TPMU_SCHEME_KEYEDHASH))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMU_SCHEME_KEYEDHASH>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMU_SCHEME_KEYEDHASH))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SCHEME_KEYEDHASH>())).hmac as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SCHEME_KEYEDHASH),
            "::",
            stringify!(hmac)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPMU_SCHEME_KEYEDHASH>())).exclusiveOr as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SCHEME_KEYEDHASH),
            "::",
            stringify!(exclusiveOr)
        )
    );
}
impl Default for TPMU_SCHEME_KEYEDHASH {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMT_KEYEDHASH_SCHEME {
    pub scheme: TPMI_ALG_KEYEDHASH_SCHEME,
    pub details: TPMU_SCHEME_KEYEDHASH,
}
#[test]
fn bindgen_test_layout_TPMT_KEYEDHASH_SCHEME() {
    assert_eq!(
        ::std::mem::size_of::<TPMT_KEYEDHASH_SCHEME>(),
        6usize,
        concat!("Size of: ", stringify!(TPMT_KEYEDHASH_SCHEME))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMT_KEYEDHASH_SCHEME>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMT_KEYEDHASH_SCHEME))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_KEYEDHASH_SCHEME>())).scheme as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_KEYEDHASH_SCHEME),
            "::",
            stringify!(scheme)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_KEYEDHASH_SCHEME>())).details as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_KEYEDHASH_SCHEME),
            "::",
            stringify!(details)
        )
    );
}
impl Default for TPMT_KEYEDHASH_SCHEME {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TPMS_SIG_SCHEME_RSASSA = TPMS_SCHEME_HASH;
pub type TPMS_SIG_SCHEME_RSAPSS = TPMS_SCHEME_HASH;
pub type TPMS_SIG_SCHEME_ECDSA = TPMS_SCHEME_HASH;
pub type TPMS_SIG_SCHEME_SM2 = TPMS_SCHEME_HASH;
pub type TPMS_SIG_SCHEME_ECSCHNORR = TPMS_SCHEME_HASH;
pub type TPMS_SIG_SCHEME_ECDAA = TPMS_SCHEME_ECDAA;
#[repr(C)]
#[derive(Copy, Clone)]
pub union TPMU_SIG_SCHEME {
    pub rsassa: TPMS_SIG_SCHEME_RSASSA,
    pub rsapss: TPMS_SIG_SCHEME_RSAPSS,
    pub ecdsa: TPMS_SIG_SCHEME_ECDSA,
    pub ecdaa: TPMS_SIG_SCHEME_ECDAA,
    pub sm2: TPMS_SIG_SCHEME_SM2,
    pub ecschnorr: TPMS_SIG_SCHEME_ECSCHNORR,
    pub hmac: TPMS_SCHEME_HMAC,
    pub any: TPMS_SCHEME_HASH,
}
#[test]
fn bindgen_test_layout_TPMU_SIG_SCHEME() {
    assert_eq!(
        ::std::mem::size_of::<TPMU_SIG_SCHEME>(),
        4usize,
        concat!("Size of: ", stringify!(TPMU_SIG_SCHEME))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMU_SIG_SCHEME>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMU_SIG_SCHEME))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SIG_SCHEME>())).rsassa as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SIG_SCHEME),
            "::",
            stringify!(rsassa)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SIG_SCHEME>())).rsapss as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SIG_SCHEME),
            "::",
            stringify!(rsapss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SIG_SCHEME>())).ecdsa as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SIG_SCHEME),
            "::",
            stringify!(ecdsa)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SIG_SCHEME>())).ecdaa as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SIG_SCHEME),
            "::",
            stringify!(ecdaa)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SIG_SCHEME>())).sm2 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SIG_SCHEME),
            "::",
            stringify!(sm2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SIG_SCHEME>())).ecschnorr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SIG_SCHEME),
            "::",
            stringify!(ecschnorr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SIG_SCHEME>())).hmac as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SIG_SCHEME),
            "::",
            stringify!(hmac)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SIG_SCHEME>())).any as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SIG_SCHEME),
            "::",
            stringify!(any)
        )
    );
}
impl Default for TPMU_SIG_SCHEME {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMT_SIG_SCHEME {
    pub scheme: TPMI_ALG_SIG_SCHEME,
    pub details: TPMU_SIG_SCHEME,
}
#[test]
fn bindgen_test_layout_TPMT_SIG_SCHEME() {
    assert_eq!(
        ::std::mem::size_of::<TPMT_SIG_SCHEME>(),
        6usize,
        concat!("Size of: ", stringify!(TPMT_SIG_SCHEME))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMT_SIG_SCHEME>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMT_SIG_SCHEME))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_SIG_SCHEME>())).scheme as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_SIG_SCHEME),
            "::",
            stringify!(scheme)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_SIG_SCHEME>())).details as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_SIG_SCHEME),
            "::",
            stringify!(details)
        )
    );
}
impl Default for TPMT_SIG_SCHEME {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TPMS_ENC_SCHEME_OAEP = TPMS_SCHEME_HASH;
pub type TPMS_ENC_SCHEME_RSAES = TPMS_EMPTY;
pub type TPMS_KEY_SCHEME_ECDH = TPMS_SCHEME_HASH;
pub type TPMS_KEY_SCHEME_ECMQV = TPMS_SCHEME_HASH;
pub type TPMS_SCHEME_MGF1 = TPMS_SCHEME_HASH;
pub type TPMS_SCHEME_KDF1_SP800_56A = TPMS_SCHEME_HASH;
pub type TPMS_SCHEME_KDF2 = TPMS_SCHEME_HASH;
pub type TPMS_SCHEME_KDF1_SP800_108 = TPMS_SCHEME_HASH;
#[repr(C)]
#[derive(Copy, Clone)]
pub union TPMU_KDF_SCHEME {
    pub mgf1: TPMS_SCHEME_MGF1,
    pub kdf1_sp800_56a: TPMS_SCHEME_KDF1_SP800_56A,
    pub kdf2: TPMS_SCHEME_KDF2,
    pub kdf1_sp800_108: TPMS_SCHEME_KDF1_SP800_108,
}
#[test]
fn bindgen_test_layout_TPMU_KDF_SCHEME() {
    assert_eq!(
        ::std::mem::size_of::<TPMU_KDF_SCHEME>(),
        2usize,
        concat!("Size of: ", stringify!(TPMU_KDF_SCHEME))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMU_KDF_SCHEME>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMU_KDF_SCHEME))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_KDF_SCHEME>())).mgf1 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_KDF_SCHEME),
            "::",
            stringify!(mgf1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_KDF_SCHEME>())).kdf1_sp800_56a as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_KDF_SCHEME),
            "::",
            stringify!(kdf1_sp800_56a)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_KDF_SCHEME>())).kdf2 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_KDF_SCHEME),
            "::",
            stringify!(kdf2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_KDF_SCHEME>())).kdf1_sp800_108 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_KDF_SCHEME),
            "::",
            stringify!(kdf1_sp800_108)
        )
    );
}
impl Default for TPMU_KDF_SCHEME {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMT_KDF_SCHEME {
    pub scheme: TPMI_ALG_KDF,
    pub details: TPMU_KDF_SCHEME,
}
#[test]
fn bindgen_test_layout_TPMT_KDF_SCHEME() {
    assert_eq!(
        ::std::mem::size_of::<TPMT_KDF_SCHEME>(),
        4usize,
        concat!("Size of: ", stringify!(TPMT_KDF_SCHEME))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMT_KDF_SCHEME>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMT_KDF_SCHEME))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_KDF_SCHEME>())).scheme as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_KDF_SCHEME),
            "::",
            stringify!(scheme)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_KDF_SCHEME>())).details as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_KDF_SCHEME),
            "::",
            stringify!(details)
        )
    );
}
impl Default for TPMT_KDF_SCHEME {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TPMI_ALG_ASYM_SCHEME = TPM2_ALG_ID;
#[repr(C)]
#[derive(Copy, Clone)]
pub union TPMU_ASYM_SCHEME {
    pub ecdh: TPMS_KEY_SCHEME_ECDH,
    pub ecmqv: TPMS_KEY_SCHEME_ECMQV,
    pub rsassa: TPMS_SIG_SCHEME_RSASSA,
    pub rsapss: TPMS_SIG_SCHEME_RSAPSS,
    pub ecdsa: TPMS_SIG_SCHEME_ECDSA,
    pub ecdaa: TPMS_SIG_SCHEME_ECDAA,
    pub sm2: TPMS_SIG_SCHEME_SM2,
    pub ecschnorr: TPMS_SIG_SCHEME_ECSCHNORR,
    pub rsaes: TPMS_ENC_SCHEME_RSAES,
    pub oaep: TPMS_ENC_SCHEME_OAEP,
    pub anySig: TPMS_SCHEME_HASH,
}
#[test]
fn bindgen_test_layout_TPMU_ASYM_SCHEME() {
    assert_eq!(
        ::std::mem::size_of::<TPMU_ASYM_SCHEME>(),
        4usize,
        concat!("Size of: ", stringify!(TPMU_ASYM_SCHEME))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMU_ASYM_SCHEME>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMU_ASYM_SCHEME))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ASYM_SCHEME>())).ecdh as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ASYM_SCHEME),
            "::",
            stringify!(ecdh)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ASYM_SCHEME>())).ecmqv as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ASYM_SCHEME),
            "::",
            stringify!(ecmqv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ASYM_SCHEME>())).rsassa as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ASYM_SCHEME),
            "::",
            stringify!(rsassa)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ASYM_SCHEME>())).rsapss as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ASYM_SCHEME),
            "::",
            stringify!(rsapss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ASYM_SCHEME>())).ecdsa as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ASYM_SCHEME),
            "::",
            stringify!(ecdsa)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ASYM_SCHEME>())).ecdaa as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ASYM_SCHEME),
            "::",
            stringify!(ecdaa)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ASYM_SCHEME>())).sm2 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ASYM_SCHEME),
            "::",
            stringify!(sm2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ASYM_SCHEME>())).ecschnorr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ASYM_SCHEME),
            "::",
            stringify!(ecschnorr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ASYM_SCHEME>())).rsaes as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ASYM_SCHEME),
            "::",
            stringify!(rsaes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ASYM_SCHEME>())).oaep as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ASYM_SCHEME),
            "::",
            stringify!(oaep)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ASYM_SCHEME>())).anySig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ASYM_SCHEME),
            "::",
            stringify!(anySig)
        )
    );
}
impl Default for TPMU_ASYM_SCHEME {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMT_ASYM_SCHEME {
    pub scheme: TPMI_ALG_ASYM_SCHEME,
    pub details: TPMU_ASYM_SCHEME,
}
#[test]
fn bindgen_test_layout_TPMT_ASYM_SCHEME() {
    assert_eq!(
        ::std::mem::size_of::<TPMT_ASYM_SCHEME>(),
        6usize,
        concat!("Size of: ", stringify!(TPMT_ASYM_SCHEME))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMT_ASYM_SCHEME>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMT_ASYM_SCHEME))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_ASYM_SCHEME>())).scheme as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_ASYM_SCHEME),
            "::",
            stringify!(scheme)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_ASYM_SCHEME>())).details as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_ASYM_SCHEME),
            "::",
            stringify!(details)
        )
    );
}
impl Default for TPMT_ASYM_SCHEME {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TPMI_ALG_RSA_SCHEME = TPM2_ALG_ID;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMT_RSA_SCHEME {
    pub scheme: TPMI_ALG_RSA_SCHEME,
    pub details: TPMU_ASYM_SCHEME,
}
#[test]
fn bindgen_test_layout_TPMT_RSA_SCHEME() {
    assert_eq!(
        ::std::mem::size_of::<TPMT_RSA_SCHEME>(),
        6usize,
        concat!("Size of: ", stringify!(TPMT_RSA_SCHEME))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMT_RSA_SCHEME>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMT_RSA_SCHEME))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_RSA_SCHEME>())).scheme as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_RSA_SCHEME),
            "::",
            stringify!(scheme)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_RSA_SCHEME>())).details as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_RSA_SCHEME),
            "::",
            stringify!(details)
        )
    );
}
impl Default for TPMT_RSA_SCHEME {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TPMI_ALG_RSA_DECRYPT = TPM2_ALG_ID;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMT_RSA_DECRYPT {
    pub scheme: TPMI_ALG_RSA_DECRYPT,
    pub details: TPMU_ASYM_SCHEME,
}
#[test]
fn bindgen_test_layout_TPMT_RSA_DECRYPT() {
    assert_eq!(
        ::std::mem::size_of::<TPMT_RSA_DECRYPT>(),
        6usize,
        concat!("Size of: ", stringify!(TPMT_RSA_DECRYPT))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMT_RSA_DECRYPT>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMT_RSA_DECRYPT))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_RSA_DECRYPT>())).scheme as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_RSA_DECRYPT),
            "::",
            stringify!(scheme)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_RSA_DECRYPT>())).details as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_RSA_DECRYPT),
            "::",
            stringify!(details)
        )
    );
}
impl Default for TPMT_RSA_DECRYPT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_PUBLIC_KEY_RSA {
    pub size: UINT16,
    pub buffer: [BYTE; 512usize],
}
#[test]
fn bindgen_test_layout_TPM2B_PUBLIC_KEY_RSA() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_PUBLIC_KEY_RSA>(),
        514usize,
        concat!("Size of: ", stringify!(TPM2B_PUBLIC_KEY_RSA))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_PUBLIC_KEY_RSA>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_PUBLIC_KEY_RSA))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_PUBLIC_KEY_RSA>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_PUBLIC_KEY_RSA),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_PUBLIC_KEY_RSA>())).buffer as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_PUBLIC_KEY_RSA),
            "::",
            stringify!(buffer)
        )
    );
}
impl Default for TPM2B_PUBLIC_KEY_RSA {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TPMI_RSA_KEY_BITS = TPM2_KEY_BITS;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_PRIVATE_KEY_RSA {
    pub size: UINT16,
    pub buffer: [BYTE; 256usize],
}
#[test]
fn bindgen_test_layout_TPM2B_PRIVATE_KEY_RSA() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_PRIVATE_KEY_RSA>(),
        258usize,
        concat!("Size of: ", stringify!(TPM2B_PRIVATE_KEY_RSA))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_PRIVATE_KEY_RSA>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_PRIVATE_KEY_RSA))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_PRIVATE_KEY_RSA>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_PRIVATE_KEY_RSA),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_PRIVATE_KEY_RSA>())).buffer as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_PRIVATE_KEY_RSA),
            "::",
            stringify!(buffer)
        )
    );
}
impl Default for TPM2B_PRIVATE_KEY_RSA {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_ECC_PARAMETER {
    pub size: UINT16,
    pub buffer: [BYTE; 128usize],
}
#[test]
fn bindgen_test_layout_TPM2B_ECC_PARAMETER() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_ECC_PARAMETER>(),
        130usize,
        concat!("Size of: ", stringify!(TPM2B_ECC_PARAMETER))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_ECC_PARAMETER>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_ECC_PARAMETER))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_ECC_PARAMETER>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_ECC_PARAMETER),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_ECC_PARAMETER>())).buffer as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_ECC_PARAMETER),
            "::",
            stringify!(buffer)
        )
    );
}
impl Default for TPM2B_ECC_PARAMETER {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMS_ECC_POINT {
    pub x: TPM2B_ECC_PARAMETER,
    pub y: TPM2B_ECC_PARAMETER,
}
#[test]
fn bindgen_test_layout_TPMS_ECC_POINT() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_ECC_POINT>(),
        260usize,
        concat!("Size of: ", stringify!(TPMS_ECC_POINT))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_ECC_POINT>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMS_ECC_POINT))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ECC_POINT>())).x as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ECC_POINT),
            "::",
            stringify!(x)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ECC_POINT>())).y as *const _ as usize },
        130usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ECC_POINT),
            "::",
            stringify!(y)
        )
    );
}
impl Default for TPMS_ECC_POINT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_ECC_POINT {
    pub size: UINT16,
    pub point: TPMS_ECC_POINT,
}
#[test]
fn bindgen_test_layout_TPM2B_ECC_POINT() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_ECC_POINT>(),
        262usize,
        concat!("Size of: ", stringify!(TPM2B_ECC_POINT))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_ECC_POINT>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_ECC_POINT))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_ECC_POINT>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_ECC_POINT),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_ECC_POINT>())).point as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_ECC_POINT),
            "::",
            stringify!(point)
        )
    );
}
impl Default for TPM2B_ECC_POINT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TPMI_ALG_ECC_SCHEME = TPM2_ALG_ID;
pub type TPMI_ECC_CURVE = TPM2_ECC_CURVE;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMT_ECC_SCHEME {
    pub scheme: TPMI_ALG_ECC_SCHEME,
    pub details: TPMU_ASYM_SCHEME,
}
#[test]
fn bindgen_test_layout_TPMT_ECC_SCHEME() {
    assert_eq!(
        ::std::mem::size_of::<TPMT_ECC_SCHEME>(),
        6usize,
        concat!("Size of: ", stringify!(TPMT_ECC_SCHEME))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMT_ECC_SCHEME>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMT_ECC_SCHEME))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_ECC_SCHEME>())).scheme as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_ECC_SCHEME),
            "::",
            stringify!(scheme)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_ECC_SCHEME>())).details as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_ECC_SCHEME),
            "::",
            stringify!(details)
        )
    );
}
impl Default for TPMT_ECC_SCHEME {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMS_ALGORITHM_DETAIL_ECC {
    pub curveID: TPM2_ECC_CURVE,
    pub keySize: UINT16,
    pub kdf: TPMT_KDF_SCHEME,
    pub sign: TPMT_ECC_SCHEME,
    pub p: TPM2B_ECC_PARAMETER,
    pub a: TPM2B_ECC_PARAMETER,
    pub b: TPM2B_ECC_PARAMETER,
    pub gX: TPM2B_ECC_PARAMETER,
    pub gY: TPM2B_ECC_PARAMETER,
    pub n: TPM2B_ECC_PARAMETER,
    pub h: TPM2B_ECC_PARAMETER,
}
#[test]
fn bindgen_test_layout_TPMS_ALGORITHM_DETAIL_ECC() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_ALGORITHM_DETAIL_ECC>(),
        924usize,
        concat!("Size of: ", stringify!(TPMS_ALGORITHM_DETAIL_ECC))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_ALGORITHM_DETAIL_ECC>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMS_ALGORITHM_DETAIL_ECC))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPMS_ALGORITHM_DETAIL_ECC>())).curveID as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ALGORITHM_DETAIL_ECC),
            "::",
            stringify!(curveID)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPMS_ALGORITHM_DETAIL_ECC>())).keySize as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ALGORITHM_DETAIL_ECC),
            "::",
            stringify!(keySize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ALGORITHM_DETAIL_ECC>())).kdf as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ALGORITHM_DETAIL_ECC),
            "::",
            stringify!(kdf)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ALGORITHM_DETAIL_ECC>())).sign as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ALGORITHM_DETAIL_ECC),
            "::",
            stringify!(sign)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ALGORITHM_DETAIL_ECC>())).p as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ALGORITHM_DETAIL_ECC),
            "::",
            stringify!(p)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ALGORITHM_DETAIL_ECC>())).a as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ALGORITHM_DETAIL_ECC),
            "::",
            stringify!(a)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ALGORITHM_DETAIL_ECC>())).b as *const _ as usize },
        274usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ALGORITHM_DETAIL_ECC),
            "::",
            stringify!(b)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ALGORITHM_DETAIL_ECC>())).gX as *const _ as usize },
        404usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ALGORITHM_DETAIL_ECC),
            "::",
            stringify!(gX)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ALGORITHM_DETAIL_ECC>())).gY as *const _ as usize },
        534usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ALGORITHM_DETAIL_ECC),
            "::",
            stringify!(gY)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ALGORITHM_DETAIL_ECC>())).n as *const _ as usize },
        664usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ALGORITHM_DETAIL_ECC),
            "::",
            stringify!(n)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ALGORITHM_DETAIL_ECC>())).h as *const _ as usize },
        794usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ALGORITHM_DETAIL_ECC),
            "::",
            stringify!(h)
        )
    );
}
impl Default for TPMS_ALGORITHM_DETAIL_ECC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMS_SIGNATURE_RSA {
    pub hash: TPMI_ALG_HASH,
    pub sig: TPM2B_PUBLIC_KEY_RSA,
}
#[test]
fn bindgen_test_layout_TPMS_SIGNATURE_RSA() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_SIGNATURE_RSA>(),
        516usize,
        concat!("Size of: ", stringify!(TPMS_SIGNATURE_RSA))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_SIGNATURE_RSA>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMS_SIGNATURE_RSA))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_SIGNATURE_RSA>())).hash as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_SIGNATURE_RSA),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_SIGNATURE_RSA>())).sig as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_SIGNATURE_RSA),
            "::",
            stringify!(sig)
        )
    );
}
impl Default for TPMS_SIGNATURE_RSA {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TPMS_SIGNATURE_RSASSA = TPMS_SIGNATURE_RSA;
pub type TPMS_SIGNATURE_RSAPSS = TPMS_SIGNATURE_RSA;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMS_SIGNATURE_ECC {
    pub hash: TPMI_ALG_HASH,
    pub signatureR: TPM2B_ECC_PARAMETER,
    pub signatureS: TPM2B_ECC_PARAMETER,
}
#[test]
fn bindgen_test_layout_TPMS_SIGNATURE_ECC() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_SIGNATURE_ECC>(),
        262usize,
        concat!("Size of: ", stringify!(TPMS_SIGNATURE_ECC))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_SIGNATURE_ECC>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMS_SIGNATURE_ECC))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_SIGNATURE_ECC>())).hash as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_SIGNATURE_ECC),
            "::",
            stringify!(hash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_SIGNATURE_ECC>())).signatureR as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_SIGNATURE_ECC),
            "::",
            stringify!(signatureR)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_SIGNATURE_ECC>())).signatureS as *const _ as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_SIGNATURE_ECC),
            "::",
            stringify!(signatureS)
        )
    );
}
impl Default for TPMS_SIGNATURE_ECC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TPMS_SIGNATURE_ECDSA = TPMS_SIGNATURE_ECC;
pub type TPMS_SIGNATURE_ECDAA = TPMS_SIGNATURE_ECC;
pub type TPMS_SIGNATURE_SM2 = TPMS_SIGNATURE_ECC;
pub type TPMS_SIGNATURE_ECSCHNORR = TPMS_SIGNATURE_ECC;
#[repr(C)]
#[derive(Copy, Clone)]
pub union TPMU_SIGNATURE {
    pub rsassa: TPMS_SIGNATURE_RSASSA,
    pub rsapss: TPMS_SIGNATURE_RSAPSS,
    pub ecdsa: TPMS_SIGNATURE_ECDSA,
    pub ecdaa: TPMS_SIGNATURE_ECDAA,
    pub sm2: TPMS_SIGNATURE_SM2,
    pub ecschnorr: TPMS_SIGNATURE_ECSCHNORR,
    pub hmac: TPMT_HA,
    pub any: TPMS_SCHEME_HASH,
}
#[test]
fn bindgen_test_layout_TPMU_SIGNATURE() {
    assert_eq!(
        ::std::mem::size_of::<TPMU_SIGNATURE>(),
        516usize,
        concat!("Size of: ", stringify!(TPMU_SIGNATURE))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMU_SIGNATURE>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMU_SIGNATURE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SIGNATURE>())).rsassa as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SIGNATURE),
            "::",
            stringify!(rsassa)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SIGNATURE>())).rsapss as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SIGNATURE),
            "::",
            stringify!(rsapss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SIGNATURE>())).ecdsa as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SIGNATURE),
            "::",
            stringify!(ecdsa)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SIGNATURE>())).ecdaa as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SIGNATURE),
            "::",
            stringify!(ecdaa)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SIGNATURE>())).sm2 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SIGNATURE),
            "::",
            stringify!(sm2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SIGNATURE>())).ecschnorr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SIGNATURE),
            "::",
            stringify!(ecschnorr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SIGNATURE>())).hmac as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SIGNATURE),
            "::",
            stringify!(hmac)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SIGNATURE>())).any as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SIGNATURE),
            "::",
            stringify!(any)
        )
    );
}
impl Default for TPMU_SIGNATURE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMT_SIGNATURE {
    pub sigAlg: TPMI_ALG_SIG_SCHEME,
    pub signature: TPMU_SIGNATURE,
}
#[test]
fn bindgen_test_layout_TPMT_SIGNATURE() {
    assert_eq!(
        ::std::mem::size_of::<TPMT_SIGNATURE>(),
        518usize,
        concat!("Size of: ", stringify!(TPMT_SIGNATURE))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMT_SIGNATURE>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMT_SIGNATURE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_SIGNATURE>())).sigAlg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_SIGNATURE),
            "::",
            stringify!(sigAlg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_SIGNATURE>())).signature as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_SIGNATURE),
            "::",
            stringify!(signature)
        )
    );
}
impl Default for TPMT_SIGNATURE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union TPMU_ENCRYPTED_SECRET {
    pub ecc: [BYTE; 260usize],
    pub rsa: [BYTE; 512usize],
    pub symmetric: [BYTE; 66usize],
    pub keyedHash: [BYTE; 66usize],
}
#[test]
fn bindgen_test_layout_TPMU_ENCRYPTED_SECRET() {
    assert_eq!(
        ::std::mem::size_of::<TPMU_ENCRYPTED_SECRET>(),
        512usize,
        concat!("Size of: ", stringify!(TPMU_ENCRYPTED_SECRET))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMU_ENCRYPTED_SECRET>(),
        1usize,
        concat!("Alignment of ", stringify!(TPMU_ENCRYPTED_SECRET))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ENCRYPTED_SECRET>())).ecc as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ENCRYPTED_SECRET),
            "::",
            stringify!(ecc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ENCRYPTED_SECRET>())).rsa as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ENCRYPTED_SECRET),
            "::",
            stringify!(rsa)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ENCRYPTED_SECRET>())).symmetric as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ENCRYPTED_SECRET),
            "::",
            stringify!(symmetric)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_ENCRYPTED_SECRET>())).keyedHash as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_ENCRYPTED_SECRET),
            "::",
            stringify!(keyedHash)
        )
    );
}
impl Default for TPMU_ENCRYPTED_SECRET {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_ENCRYPTED_SECRET {
    pub size: UINT16,
    pub secret: [BYTE; 512usize],
}
#[test]
fn bindgen_test_layout_TPM2B_ENCRYPTED_SECRET() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_ENCRYPTED_SECRET>(),
        514usize,
        concat!("Size of: ", stringify!(TPM2B_ENCRYPTED_SECRET))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_ENCRYPTED_SECRET>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_ENCRYPTED_SECRET))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_ENCRYPTED_SECRET>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_ENCRYPTED_SECRET),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_ENCRYPTED_SECRET>())).secret as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_ENCRYPTED_SECRET),
            "::",
            stringify!(secret)
        )
    );
}
impl Default for TPM2B_ENCRYPTED_SECRET {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TPMI_ALG_PUBLIC = TPM2_ALG_ID;
#[repr(C)]
#[derive(Copy, Clone)]
pub union TPMU_PUBLIC_ID {
    pub keyedHash: TPM2B_DIGEST,
    pub sym: TPM2B_DIGEST,
    pub rsa: TPM2B_PUBLIC_KEY_RSA,
    pub ecc: TPMS_ECC_POINT,
}
#[test]
fn bindgen_test_layout_TPMU_PUBLIC_ID() {
    assert_eq!(
        ::std::mem::size_of::<TPMU_PUBLIC_ID>(),
        514usize,
        concat!("Size of: ", stringify!(TPMU_PUBLIC_ID))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMU_PUBLIC_ID>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMU_PUBLIC_ID))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_PUBLIC_ID>())).keyedHash as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_PUBLIC_ID),
            "::",
            stringify!(keyedHash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_PUBLIC_ID>())).sym as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_PUBLIC_ID),
            "::",
            stringify!(sym)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_PUBLIC_ID>())).rsa as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_PUBLIC_ID),
            "::",
            stringify!(rsa)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_PUBLIC_ID>())).ecc as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_PUBLIC_ID),
            "::",
            stringify!(ecc)
        )
    );
}
impl Default for TPMU_PUBLIC_ID {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMS_KEYEDHASH_PARMS {
    pub scheme: TPMT_KEYEDHASH_SCHEME,
}
#[test]
fn bindgen_test_layout_TPMS_KEYEDHASH_PARMS() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_KEYEDHASH_PARMS>(),
        6usize,
        concat!("Size of: ", stringify!(TPMS_KEYEDHASH_PARMS))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_KEYEDHASH_PARMS>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMS_KEYEDHASH_PARMS))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_KEYEDHASH_PARMS>())).scheme as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_KEYEDHASH_PARMS),
            "::",
            stringify!(scheme)
        )
    );
}
impl Default for TPMS_KEYEDHASH_PARMS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMS_ASYM_PARMS {
    pub symmetric: TPMT_SYM_DEF_OBJECT,
    pub scheme: TPMT_ASYM_SCHEME,
}
#[test]
fn bindgen_test_layout_TPMS_ASYM_PARMS() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_ASYM_PARMS>(),
        12usize,
        concat!("Size of: ", stringify!(TPMS_ASYM_PARMS))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_ASYM_PARMS>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMS_ASYM_PARMS))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ASYM_PARMS>())).symmetric as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ASYM_PARMS),
            "::",
            stringify!(symmetric)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ASYM_PARMS>())).scheme as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ASYM_PARMS),
            "::",
            stringify!(scheme)
        )
    );
}
impl Default for TPMS_ASYM_PARMS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMS_RSA_PARMS {
    pub symmetric: TPMT_SYM_DEF_OBJECT,
    pub scheme: TPMT_RSA_SCHEME,
    pub keyBits: TPMI_RSA_KEY_BITS,
    pub exponent: UINT32,
}
#[test]
fn bindgen_test_layout_TPMS_RSA_PARMS() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_RSA_PARMS>(),
        20usize,
        concat!("Size of: ", stringify!(TPMS_RSA_PARMS))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_RSA_PARMS>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMS_RSA_PARMS))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_RSA_PARMS>())).symmetric as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_RSA_PARMS),
            "::",
            stringify!(symmetric)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_RSA_PARMS>())).scheme as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_RSA_PARMS),
            "::",
            stringify!(scheme)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_RSA_PARMS>())).keyBits as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_RSA_PARMS),
            "::",
            stringify!(keyBits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_RSA_PARMS>())).exponent as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_RSA_PARMS),
            "::",
            stringify!(exponent)
        )
    );
}
impl Default for TPMS_RSA_PARMS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMS_ECC_PARMS {
    pub symmetric: TPMT_SYM_DEF_OBJECT,
    pub scheme: TPMT_ECC_SCHEME,
    pub curveID: TPMI_ECC_CURVE,
    pub kdf: TPMT_KDF_SCHEME,
}
#[test]
fn bindgen_test_layout_TPMS_ECC_PARMS() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_ECC_PARMS>(),
        18usize,
        concat!("Size of: ", stringify!(TPMS_ECC_PARMS))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_ECC_PARMS>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMS_ECC_PARMS))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ECC_PARMS>())).symmetric as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ECC_PARMS),
            "::",
            stringify!(symmetric)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ECC_PARMS>())).scheme as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ECC_PARMS),
            "::",
            stringify!(scheme)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ECC_PARMS>())).curveID as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ECC_PARMS),
            "::",
            stringify!(curveID)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ECC_PARMS>())).kdf as *const _ as usize },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ECC_PARMS),
            "::",
            stringify!(kdf)
        )
    );
}
impl Default for TPMS_ECC_PARMS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union TPMU_PUBLIC_PARMS {
    pub keyedHashDetail: TPMS_KEYEDHASH_PARMS,
    pub symDetail: TPMS_SYMCIPHER_PARMS,
    pub rsaDetail: TPMS_RSA_PARMS,
    pub eccDetail: TPMS_ECC_PARMS,
    pub asymDetail: TPMS_ASYM_PARMS,
}
#[test]
fn bindgen_test_layout_TPMU_PUBLIC_PARMS() {
    assert_eq!(
        ::std::mem::size_of::<TPMU_PUBLIC_PARMS>(),
        20usize,
        concat!("Size of: ", stringify!(TPMU_PUBLIC_PARMS))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMU_PUBLIC_PARMS>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMU_PUBLIC_PARMS))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPMU_PUBLIC_PARMS>())).keyedHashDetail as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_PUBLIC_PARMS),
            "::",
            stringify!(keyedHashDetail)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_PUBLIC_PARMS>())).symDetail as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_PUBLIC_PARMS),
            "::",
            stringify!(symDetail)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_PUBLIC_PARMS>())).rsaDetail as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_PUBLIC_PARMS),
            "::",
            stringify!(rsaDetail)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_PUBLIC_PARMS>())).eccDetail as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_PUBLIC_PARMS),
            "::",
            stringify!(eccDetail)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_PUBLIC_PARMS>())).asymDetail as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_PUBLIC_PARMS),
            "::",
            stringify!(asymDetail)
        )
    );
}
impl Default for TPMU_PUBLIC_PARMS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMT_PUBLIC_PARMS {
    pub type_: TPMI_ALG_PUBLIC,
    pub parameters: TPMU_PUBLIC_PARMS,
}
#[test]
fn bindgen_test_layout_TPMT_PUBLIC_PARMS() {
    assert_eq!(
        ::std::mem::size_of::<TPMT_PUBLIC_PARMS>(),
        24usize,
        concat!("Size of: ", stringify!(TPMT_PUBLIC_PARMS))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMT_PUBLIC_PARMS>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMT_PUBLIC_PARMS))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_PUBLIC_PARMS>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_PUBLIC_PARMS),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_PUBLIC_PARMS>())).parameters as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_PUBLIC_PARMS),
            "::",
            stringify!(parameters)
        )
    );
}
impl Default for TPMT_PUBLIC_PARMS {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMT_PUBLIC {
    pub type_: TPMI_ALG_PUBLIC,
    pub nameAlg: TPMI_ALG_HASH,
    pub objectAttributes: TPMA_OBJECT,
    pub authPolicy: TPM2B_DIGEST,
    pub parameters: TPMU_PUBLIC_PARMS,
    pub unique: TPMU_PUBLIC_ID,
}
#[test]
fn bindgen_test_layout_TPMT_PUBLIC() {
    assert_eq!(
        ::std::mem::size_of::<TPMT_PUBLIC>(),
        612usize,
        concat!("Size of: ", stringify!(TPMT_PUBLIC))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMT_PUBLIC>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMT_PUBLIC))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_PUBLIC>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_PUBLIC),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_PUBLIC>())).nameAlg as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_PUBLIC),
            "::",
            stringify!(nameAlg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_PUBLIC>())).objectAttributes as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_PUBLIC),
            "::",
            stringify!(objectAttributes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_PUBLIC>())).authPolicy as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_PUBLIC),
            "::",
            stringify!(authPolicy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_PUBLIC>())).parameters as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_PUBLIC),
            "::",
            stringify!(parameters)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_PUBLIC>())).unique as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_PUBLIC),
            "::",
            stringify!(unique)
        )
    );
}
impl Default for TPMT_PUBLIC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPM2B_PUBLIC {
    pub size: UINT16,
    pub publicArea: TPMT_PUBLIC,
}
#[test]
fn bindgen_test_layout_TPM2B_PUBLIC() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_PUBLIC>(),
        616usize,
        concat!("Size of: ", stringify!(TPM2B_PUBLIC))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_PUBLIC>(),
        4usize,
        concat!("Alignment of ", stringify!(TPM2B_PUBLIC))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_PUBLIC>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_PUBLIC),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_PUBLIC>())).publicArea as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_PUBLIC),
            "::",
            stringify!(publicArea)
        )
    );
}
impl Default for TPM2B_PUBLIC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_TEMPLATE {
    pub size: UINT16,
    pub buffer: [BYTE; 612usize],
}
#[test]
fn bindgen_test_layout_TPM2B_TEMPLATE() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_TEMPLATE>(),
        614usize,
        concat!("Size of: ", stringify!(TPM2B_TEMPLATE))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_TEMPLATE>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_TEMPLATE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_TEMPLATE>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_TEMPLATE),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_TEMPLATE>())).buffer as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_TEMPLATE),
            "::",
            stringify!(buffer)
        )
    );
}
impl Default for TPM2B_TEMPLATE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_PRIVATE_VENDOR_SPECIFIC {
    pub size: UINT16,
    pub buffer: [BYTE; 1280usize],
}
#[test]
fn bindgen_test_layout_TPM2B_PRIVATE_VENDOR_SPECIFIC() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_PRIVATE_VENDOR_SPECIFIC>(),
        1282usize,
        concat!("Size of: ", stringify!(TPM2B_PRIVATE_VENDOR_SPECIFIC))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_PRIVATE_VENDOR_SPECIFIC>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_PRIVATE_VENDOR_SPECIFIC))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPM2B_PRIVATE_VENDOR_SPECIFIC>())).size as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_PRIVATE_VENDOR_SPECIFIC),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPM2B_PRIVATE_VENDOR_SPECIFIC>())).buffer as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_PRIVATE_VENDOR_SPECIFIC),
            "::",
            stringify!(buffer)
        )
    );
}
impl Default for TPM2B_PRIVATE_VENDOR_SPECIFIC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union TPMU_SENSITIVE_COMPOSITE {
    pub rsa: TPM2B_PRIVATE_KEY_RSA,
    pub ecc: TPM2B_ECC_PARAMETER,
    pub bits: TPM2B_SENSITIVE_DATA,
    pub sym: TPM2B_SYM_KEY,
    pub any: TPM2B_PRIVATE_VENDOR_SPECIFIC,
}
#[test]
fn bindgen_test_layout_TPMU_SENSITIVE_COMPOSITE() {
    assert_eq!(
        ::std::mem::size_of::<TPMU_SENSITIVE_COMPOSITE>(),
        1282usize,
        concat!("Size of: ", stringify!(TPMU_SENSITIVE_COMPOSITE))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMU_SENSITIVE_COMPOSITE>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMU_SENSITIVE_COMPOSITE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SENSITIVE_COMPOSITE>())).rsa as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SENSITIVE_COMPOSITE),
            "::",
            stringify!(rsa)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SENSITIVE_COMPOSITE>())).ecc as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SENSITIVE_COMPOSITE),
            "::",
            stringify!(ecc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SENSITIVE_COMPOSITE>())).bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SENSITIVE_COMPOSITE),
            "::",
            stringify!(bits)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SENSITIVE_COMPOSITE>())).sym as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SENSITIVE_COMPOSITE),
            "::",
            stringify!(sym)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMU_SENSITIVE_COMPOSITE>())).any as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMU_SENSITIVE_COMPOSITE),
            "::",
            stringify!(any)
        )
    );
}
impl Default for TPMU_SENSITIVE_COMPOSITE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPMT_SENSITIVE {
    pub sensitiveType: TPMI_ALG_PUBLIC,
    pub authValue: TPM2B_AUTH,
    pub seedValue: TPM2B_DIGEST,
    pub sensitive: TPMU_SENSITIVE_COMPOSITE,
}
#[test]
fn bindgen_test_layout_TPMT_SENSITIVE() {
    assert_eq!(
        ::std::mem::size_of::<TPMT_SENSITIVE>(),
        1416usize,
        concat!("Size of: ", stringify!(TPMT_SENSITIVE))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMT_SENSITIVE>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMT_SENSITIVE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_SENSITIVE>())).sensitiveType as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_SENSITIVE),
            "::",
            stringify!(sensitiveType)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_SENSITIVE>())).authValue as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_SENSITIVE),
            "::",
            stringify!(authValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_SENSITIVE>())).seedValue as *const _ as usize },
        68usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_SENSITIVE),
            "::",
            stringify!(seedValue)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMT_SENSITIVE>())).sensitive as *const _ as usize },
        134usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMT_SENSITIVE),
            "::",
            stringify!(sensitive)
        )
    );
}
impl Default for TPMT_SENSITIVE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct TPM2B_SENSITIVE {
    pub size: UINT16,
    pub sensitiveArea: TPMT_SENSITIVE,
}
#[test]
fn bindgen_test_layout_TPM2B_SENSITIVE() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_SENSITIVE>(),
        1418usize,
        concat!("Size of: ", stringify!(TPM2B_SENSITIVE))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_SENSITIVE>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_SENSITIVE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_SENSITIVE>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_SENSITIVE),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_SENSITIVE>())).sensitiveArea as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_SENSITIVE),
            "::",
            stringify!(sensitiveArea)
        )
    );
}
impl Default for TPM2B_SENSITIVE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _PRIVATE {
    pub integrityOuter: TPM2B_DIGEST,
    pub integrityInner: TPM2B_DIGEST,
    pub sensitive: TPM2B_SENSITIVE,
}
#[test]
fn bindgen_test_layout__PRIVATE() {
    assert_eq!(
        ::std::mem::size_of::<_PRIVATE>(),
        1550usize,
        concat!("Size of: ", stringify!(_PRIVATE))
    );
    assert_eq!(
        ::std::mem::align_of::<_PRIVATE>(),
        2usize,
        concat!("Alignment of ", stringify!(_PRIVATE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_PRIVATE>())).integrityOuter as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_PRIVATE),
            "::",
            stringify!(integrityOuter)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_PRIVATE>())).integrityInner as *const _ as usize },
        66usize,
        concat!(
            "Offset of field: ",
            stringify!(_PRIVATE),
            "::",
            stringify!(integrityInner)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_PRIVATE>())).sensitive as *const _ as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(_PRIVATE),
            "::",
            stringify!(sensitive)
        )
    );
}
impl Default for _PRIVATE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_PRIVATE {
    pub size: UINT16,
    pub buffer: [BYTE; 1550usize],
}
#[test]
fn bindgen_test_layout_TPM2B_PRIVATE() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_PRIVATE>(),
        1552usize,
        concat!("Size of: ", stringify!(TPM2B_PRIVATE))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_PRIVATE>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_PRIVATE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_PRIVATE>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_PRIVATE),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_PRIVATE>())).buffer as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_PRIVATE),
            "::",
            stringify!(buffer)
        )
    );
}
impl Default for TPM2B_PRIVATE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMS_ID_OBJECT {
    pub integrityHMAC: TPM2B_DIGEST,
    pub encIdentity: TPM2B_DIGEST,
}
#[test]
fn bindgen_test_layout_TPMS_ID_OBJECT() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_ID_OBJECT>(),
        132usize,
        concat!("Size of: ", stringify!(TPMS_ID_OBJECT))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_ID_OBJECT>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMS_ID_OBJECT))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ID_OBJECT>())).integrityHMAC as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ID_OBJECT),
            "::",
            stringify!(integrityHMAC)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_ID_OBJECT>())).encIdentity as *const _ as usize },
        66usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_ID_OBJECT),
            "::",
            stringify!(encIdentity)
        )
    );
}
impl Default for TPMS_ID_OBJECT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_ID_OBJECT {
    pub size: UINT16,
    pub credential: [BYTE; 132usize],
}
#[test]
fn bindgen_test_layout_TPM2B_ID_OBJECT() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_ID_OBJECT>(),
        134usize,
        concat!("Size of: ", stringify!(TPM2B_ID_OBJECT))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_ID_OBJECT>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_ID_OBJECT))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_ID_OBJECT>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_ID_OBJECT),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_ID_OBJECT>())).credential as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_ID_OBJECT),
            "::",
            stringify!(credential)
        )
    );
}
impl Default for TPM2B_ID_OBJECT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TPM2_NV_INDEX = u32;
pub type TPM2_NT = UINT8;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TPMS_NV_PIN_COUNTER_PARAMETERS {
    pub pinCount: UINT32,
    pub pinLimit: UINT32,
}
#[test]
fn bindgen_test_layout_TPMS_NV_PIN_COUNTER_PARAMETERS() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_NV_PIN_COUNTER_PARAMETERS>(),
        8usize,
        concat!("Size of: ", stringify!(TPMS_NV_PIN_COUNTER_PARAMETERS))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_NV_PIN_COUNTER_PARAMETERS>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMS_NV_PIN_COUNTER_PARAMETERS))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPMS_NV_PIN_COUNTER_PARAMETERS>())).pinCount as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_NV_PIN_COUNTER_PARAMETERS),
            "::",
            stringify!(pinCount)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPMS_NV_PIN_COUNTER_PARAMETERS>())).pinLimit as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_NV_PIN_COUNTER_PARAMETERS),
            "::",
            stringify!(pinLimit)
        )
    );
}
pub type TPMA_NV = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMS_NV_PUBLIC {
    pub nvIndex: TPMI_RH_NV_INDEX,
    pub nameAlg: TPMI_ALG_HASH,
    pub attributes: TPMA_NV,
    pub authPolicy: TPM2B_DIGEST,
    pub dataSize: UINT16,
}
#[test]
fn bindgen_test_layout_TPMS_NV_PUBLIC() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_NV_PUBLIC>(),
        80usize,
        concat!("Size of: ", stringify!(TPMS_NV_PUBLIC))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_NV_PUBLIC>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMS_NV_PUBLIC))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_NV_PUBLIC>())).nvIndex as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_NV_PUBLIC),
            "::",
            stringify!(nvIndex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_NV_PUBLIC>())).nameAlg as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_NV_PUBLIC),
            "::",
            stringify!(nameAlg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_NV_PUBLIC>())).attributes as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_NV_PUBLIC),
            "::",
            stringify!(attributes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_NV_PUBLIC>())).authPolicy as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_NV_PUBLIC),
            "::",
            stringify!(authPolicy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_NV_PUBLIC>())).dataSize as *const _ as usize },
        78usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_NV_PUBLIC),
            "::",
            stringify!(dataSize)
        )
    );
}
impl Default for TPMS_NV_PUBLIC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_NV_PUBLIC {
    pub size: UINT16,
    pub nvPublic: TPMS_NV_PUBLIC,
}
#[test]
fn bindgen_test_layout_TPM2B_NV_PUBLIC() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_NV_PUBLIC>(),
        84usize,
        concat!("Size of: ", stringify!(TPM2B_NV_PUBLIC))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_NV_PUBLIC>(),
        4usize,
        concat!("Alignment of ", stringify!(TPM2B_NV_PUBLIC))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_NV_PUBLIC>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_NV_PUBLIC),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_NV_PUBLIC>())).nvPublic as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_NV_PUBLIC),
            "::",
            stringify!(nvPublic)
        )
    );
}
impl Default for TPM2B_NV_PUBLIC {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_CONTEXT_SENSITIVE {
    pub size: UINT16,
    pub buffer: [BYTE; 5120usize],
}
#[test]
fn bindgen_test_layout_TPM2B_CONTEXT_SENSITIVE() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_CONTEXT_SENSITIVE>(),
        5122usize,
        concat!("Size of: ", stringify!(TPM2B_CONTEXT_SENSITIVE))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_CONTEXT_SENSITIVE>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_CONTEXT_SENSITIVE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_CONTEXT_SENSITIVE>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_CONTEXT_SENSITIVE),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_CONTEXT_SENSITIVE>())).buffer as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_CONTEXT_SENSITIVE),
            "::",
            stringify!(buffer)
        )
    );
}
impl Default for TPM2B_CONTEXT_SENSITIVE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMS_CONTEXT_DATA {
    pub integrity: TPM2B_DIGEST,
    pub encrypted: TPM2B_CONTEXT_SENSITIVE,
}
#[test]
fn bindgen_test_layout_TPMS_CONTEXT_DATA() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_CONTEXT_DATA>(),
        5188usize,
        concat!("Size of: ", stringify!(TPMS_CONTEXT_DATA))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_CONTEXT_DATA>(),
        2usize,
        concat!("Alignment of ", stringify!(TPMS_CONTEXT_DATA))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_CONTEXT_DATA>())).integrity as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CONTEXT_DATA),
            "::",
            stringify!(integrity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_CONTEXT_DATA>())).encrypted as *const _ as usize },
        66usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CONTEXT_DATA),
            "::",
            stringify!(encrypted)
        )
    );
}
impl Default for TPMS_CONTEXT_DATA {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_CONTEXT_DATA {
    pub size: UINT16,
    pub buffer: [BYTE; 5188usize],
}
#[test]
fn bindgen_test_layout_TPM2B_CONTEXT_DATA() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_CONTEXT_DATA>(),
        5190usize,
        concat!("Size of: ", stringify!(TPM2B_CONTEXT_DATA))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_CONTEXT_DATA>(),
        2usize,
        concat!("Alignment of ", stringify!(TPM2B_CONTEXT_DATA))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_CONTEXT_DATA>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_CONTEXT_DATA),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_CONTEXT_DATA>())).buffer as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_CONTEXT_DATA),
            "::",
            stringify!(buffer)
        )
    );
}
impl Default for TPM2B_CONTEXT_DATA {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMS_CONTEXT {
    pub sequence: UINT64,
    pub savedHandle: TPMI_DH_CONTEXT,
    pub hierarchy: TPMI_RH_HIERARCHY,
    pub contextBlob: TPM2B_CONTEXT_DATA,
}
#[test]
fn bindgen_test_layout_TPMS_CONTEXT() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_CONTEXT>(),
        5208usize,
        concat!("Size of: ", stringify!(TPMS_CONTEXT))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_CONTEXT>(),
        8usize,
        concat!("Alignment of ", stringify!(TPMS_CONTEXT))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_CONTEXT>())).sequence as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CONTEXT),
            "::",
            stringify!(sequence)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_CONTEXT>())).savedHandle as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CONTEXT),
            "::",
            stringify!(savedHandle)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_CONTEXT>())).hierarchy as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CONTEXT),
            "::",
            stringify!(hierarchy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_CONTEXT>())).contextBlob as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CONTEXT),
            "::",
            stringify!(contextBlob)
        )
    );
}
impl Default for TPMS_CONTEXT {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPMS_CREATION_DATA {
    pub pcrSelect: TPML_PCR_SELECTION,
    pub pcrDigest: TPM2B_DIGEST,
    pub locality: TPMA_LOCALITY,
    pub parentNameAlg: TPM2_ALG_ID,
    pub parentName: TPM2B_NAME,
    pub parentQualifiedName: TPM2B_NAME,
    pub outsideInfo: TPM2B_DATA,
}
#[test]
fn bindgen_test_layout_TPMS_CREATION_DATA() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_CREATION_DATA>(),
        408usize,
        concat!("Size of: ", stringify!(TPMS_CREATION_DATA))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_CREATION_DATA>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMS_CREATION_DATA))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_CREATION_DATA>())).pcrSelect as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CREATION_DATA),
            "::",
            stringify!(pcrSelect)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_CREATION_DATA>())).pcrDigest as *const _ as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CREATION_DATA),
            "::",
            stringify!(pcrDigest)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_CREATION_DATA>())).locality as *const _ as usize },
        198usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CREATION_DATA),
            "::",
            stringify!(locality)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPMS_CREATION_DATA>())).parentNameAlg as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CREATION_DATA),
            "::",
            stringify!(parentNameAlg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_CREATION_DATA>())).parentName as *const _ as usize },
        202usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CREATION_DATA),
            "::",
            stringify!(parentName)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPMS_CREATION_DATA>())).parentQualifiedName as *const _ as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CREATION_DATA),
            "::",
            stringify!(parentQualifiedName)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_CREATION_DATA>())).outsideInfo as *const _ as usize },
        342usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_CREATION_DATA),
            "::",
            stringify!(outsideInfo)
        )
    );
}
impl Default for TPMS_CREATION_DATA {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPM2B_CREATION_DATA {
    pub size: UINT16,
    pub creationData: TPMS_CREATION_DATA,
}
#[test]
fn bindgen_test_layout_TPM2B_CREATION_DATA() {
    assert_eq!(
        ::std::mem::size_of::<TPM2B_CREATION_DATA>(),
        412usize,
        concat!("Size of: ", stringify!(TPM2B_CREATION_DATA))
    );
    assert_eq!(
        ::std::mem::align_of::<TPM2B_CREATION_DATA>(),
        4usize,
        concat!("Alignment of ", stringify!(TPM2B_CREATION_DATA))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPM2B_CREATION_DATA>())).size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_CREATION_DATA),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPM2B_CREATION_DATA>())).creationData as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPM2B_CREATION_DATA),
            "::",
            stringify!(creationData)
        )
    );
}
impl Default for TPM2B_CREATION_DATA {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TPM_AT = UINT32;
pub type TPM_EA = UINT32;
pub type TPMI_RH_AC = TPM2_HANDLE;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TPMS_AC_OUTPUT {
    pub tag: TPM_AT,
    pub data: UINT32,
}
#[test]
fn bindgen_test_layout_TPMS_AC_OUTPUT() {
    assert_eq!(
        ::std::mem::size_of::<TPMS_AC_OUTPUT>(),
        8usize,
        concat!("Size of: ", stringify!(TPMS_AC_OUTPUT))
    );
    assert_eq!(
        ::std::mem::align_of::<TPMS_AC_OUTPUT>(),
        4usize,
        concat!("Alignment of ", stringify!(TPMS_AC_OUTPUT))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_AC_OUTPUT>())).tag as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_AC_OUTPUT),
            "::",
            stringify!(tag)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPMS_AC_OUTPUT>())).data as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPMS_AC_OUTPUT),
            "::",
            stringify!(data)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TPML_AC_CAPABILITIES {
    pub count: UINT32,
    pub acCapabilities: [TPMS_AC_OUTPUT; 128usize],
}
#[test]
fn bindgen_test_layout_TPML_AC_CAPABILITIES() {
    assert_eq!(
        ::std::mem::size_of::<TPML_AC_CAPABILITIES>(),
        1028usize,
        concat!("Size of: ", stringify!(TPML_AC_CAPABILITIES))
    );
    assert_eq!(
        ::std::mem::align_of::<TPML_AC_CAPABILITIES>(),
        4usize,
        concat!("Alignment of ", stringify!(TPML_AC_CAPABILITIES))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TPML_AC_CAPABILITIES>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_AC_CAPABILITIES),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TPML_AC_CAPABILITIES>())).acCapabilities as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TPML_AC_CAPABILITIES),
            "::",
            stringify!(acCapabilities)
        )
    );
}
impl Default for TPML_AC_CAPABILITIES {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct pollfd {
    pub fd: ::std::os::raw::c_int,
    pub events: ::std::os::raw::c_short,
    pub revents: ::std::os::raw::c_short,
}
#[test]
fn bindgen_test_layout_pollfd() {
    assert_eq!(
        ::std::mem::size_of::<pollfd>(),
        8usize,
        concat!("Size of: ", stringify!(pollfd))
    );
    assert_eq!(
        ::std::mem::align_of::<pollfd>(),
        4usize,
        concat!("Alignment of ", stringify!(pollfd))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pollfd>())).fd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pollfd),
            "::",
            stringify!(fd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pollfd>())).events as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(pollfd),
            "::",
            stringify!(events)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pollfd>())).revents as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(pollfd),
            "::",
            stringify!(revents)
        )
    );
}
pub type nfds_t = ::std::os::raw::c_uint;
extern "C" {
    pub fn poll(
        arg1: *mut pollfd,
        arg2: nfds_t,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub type TSS2_TCTI_POLL_HANDLE = pollfd;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSS2_TCTI_OPAQUE_CONTEXT_BLOB {
    _unused: [u8; 0],
}
pub type TSS2_TCTI_CONTEXT = TSS2_TCTI_OPAQUE_CONTEXT_BLOB;
pub type TSS2_TCTI_TRANSMIT_FCN = ::std::option::Option<
    unsafe extern "C" fn(
        tctiContext: *mut TSS2_TCTI_CONTEXT,
        size: size_t,
        command: *const u8,
    ) -> TSS2_RC,
>;
pub type TSS2_TCTI_RECEIVE_FCN = ::std::option::Option<
    unsafe extern "C" fn(
        tctiContext: *mut TSS2_TCTI_CONTEXT,
        size: *mut size_t,
        response: *mut u8,
        timeout: i32,
    ) -> TSS2_RC,
>;
pub type TSS2_TCTI_FINALIZE_FCN =
    ::std::option::Option<unsafe extern "C" fn(tctiContext: *mut TSS2_TCTI_CONTEXT)>;
pub type TSS2_TCTI_CANCEL_FCN =
    ::std::option::Option<unsafe extern "C" fn(tctiContext: *mut TSS2_TCTI_CONTEXT) -> TSS2_RC>;
pub type TSS2_TCTI_GET_POLL_HANDLES_FCN = ::std::option::Option<
    unsafe extern "C" fn(
        tctiContext: *mut TSS2_TCTI_CONTEXT,
        handles: *mut TSS2_TCTI_POLL_HANDLE,
        num_handles: *mut size_t,
    ) -> TSS2_RC,
>;
pub type TSS2_TCTI_SET_LOCALITY_FCN = ::std::option::Option<
    unsafe extern "C" fn(tctiContext: *mut TSS2_TCTI_CONTEXT, locality: u8) -> TSS2_RC,
>;
pub type TSS2_TCTI_MAKE_STICKY_FCN = ::std::option::Option<
    unsafe extern "C" fn(
        tctiContext: *mut TSS2_TCTI_CONTEXT,
        handle: *mut TPM2_HANDLE,
        sticky: u8,
    ) -> TSS2_RC,
>;
pub type TSS2_TCTI_INIT_FUNC = ::std::option::Option<
    unsafe extern "C" fn(
        tctiContext: *mut TSS2_TCTI_CONTEXT,
        size: *mut size_t,
        config: *const ::std::os::raw::c_char,
    ) -> TSS2_RC,
>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TSS2_TCTI_CONTEXT_COMMON_V1 {
    pub magic: u64,
    pub version: u32,
    pub transmit: TSS2_TCTI_TRANSMIT_FCN,
    pub receive: TSS2_TCTI_RECEIVE_FCN,
    pub finalize: TSS2_TCTI_FINALIZE_FCN,
    pub cancel: TSS2_TCTI_CANCEL_FCN,
    pub getPollHandles: TSS2_TCTI_GET_POLL_HANDLES_FCN,
    pub setLocality: TSS2_TCTI_SET_LOCALITY_FCN,
}
#[test]
fn bindgen_test_layout_TSS2_TCTI_CONTEXT_COMMON_V1() {
    assert_eq!(
        ::std::mem::size_of::<TSS2_TCTI_CONTEXT_COMMON_V1>(),
        64usize,
        concat!("Size of: ", stringify!(TSS2_TCTI_CONTEXT_COMMON_V1))
    );
    assert_eq!(
        ::std::mem::align_of::<TSS2_TCTI_CONTEXT_COMMON_V1>(),
        8usize,
        concat!("Alignment of ", stringify!(TSS2_TCTI_CONTEXT_COMMON_V1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TSS2_TCTI_CONTEXT_COMMON_V1>())).magic as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2_TCTI_CONTEXT_COMMON_V1),
            "::",
            stringify!(magic)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TSS2_TCTI_CONTEXT_COMMON_V1>())).version as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2_TCTI_CONTEXT_COMMON_V1),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TSS2_TCTI_CONTEXT_COMMON_V1>())).transmit as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2_TCTI_CONTEXT_COMMON_V1),
            "::",
            stringify!(transmit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TSS2_TCTI_CONTEXT_COMMON_V1>())).receive as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2_TCTI_CONTEXT_COMMON_V1),
            "::",
            stringify!(receive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TSS2_TCTI_CONTEXT_COMMON_V1>())).finalize as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2_TCTI_CONTEXT_COMMON_V1),
            "::",
            stringify!(finalize)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TSS2_TCTI_CONTEXT_COMMON_V1>())).cancel as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2_TCTI_CONTEXT_COMMON_V1),
            "::",
            stringify!(cancel)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TSS2_TCTI_CONTEXT_COMMON_V1>())).getPollHandles as *const _
                as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2_TCTI_CONTEXT_COMMON_V1),
            "::",
            stringify!(getPollHandles)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TSS2_TCTI_CONTEXT_COMMON_V1>())).setLocality as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2_TCTI_CONTEXT_COMMON_V1),
            "::",
            stringify!(setLocality)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct TSS2_TCTI_CONTEXT_COMMON_V2 {
    pub v1: TSS2_TCTI_CONTEXT_COMMON_V1,
    pub makeSticky: TSS2_TCTI_MAKE_STICKY_FCN,
}
#[test]
fn bindgen_test_layout_TSS2_TCTI_CONTEXT_COMMON_V2() {
    assert_eq!(
        ::std::mem::size_of::<TSS2_TCTI_CONTEXT_COMMON_V2>(),
        72usize,
        concat!("Size of: ", stringify!(TSS2_TCTI_CONTEXT_COMMON_V2))
    );
    assert_eq!(
        ::std::mem::align_of::<TSS2_TCTI_CONTEXT_COMMON_V2>(),
        8usize,
        concat!("Alignment of ", stringify!(TSS2_TCTI_CONTEXT_COMMON_V2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TSS2_TCTI_CONTEXT_COMMON_V2>())).v1 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2_TCTI_CONTEXT_COMMON_V2),
            "::",
            stringify!(v1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<TSS2_TCTI_CONTEXT_COMMON_V2>())).makeSticky as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2_TCTI_CONTEXT_COMMON_V2),
            "::",
            stringify!(makeSticky)
        )
    );
}
pub type TSS2_TCTI_CONTEXT_COMMON_CURRENT = TSS2_TCTI_CONTEXT_COMMON_V2;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSS2_TCTI_INFO {
    pub version: u32,
    pub name: *const ::std::os::raw::c_char,
    pub description: *const ::std::os::raw::c_char,
    pub config_help: *const ::std::os::raw::c_char,
    pub init: TSS2_TCTI_INIT_FUNC,
}
#[test]
fn bindgen_test_layout_TSS2_TCTI_INFO() {
    assert_eq!(
        ::std::mem::size_of::<TSS2_TCTI_INFO>(),
        40usize,
        concat!("Size of: ", stringify!(TSS2_TCTI_INFO))
    );
    assert_eq!(
        ::std::mem::align_of::<TSS2_TCTI_INFO>(),
        8usize,
        concat!("Alignment of ", stringify!(TSS2_TCTI_INFO))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TSS2_TCTI_INFO>())).version as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2_TCTI_INFO),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TSS2_TCTI_INFO>())).name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2_TCTI_INFO),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TSS2_TCTI_INFO>())).description as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2_TCTI_INFO),
            "::",
            stringify!(description)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TSS2_TCTI_INFO>())).config_help as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2_TCTI_INFO),
            "::",
            stringify!(config_help)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TSS2_TCTI_INFO>())).init as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2_TCTI_INFO),
            "::",
            stringify!(init)
        )
    );
}
impl Default for TSS2_TCTI_INFO {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type TSS2_TCTI_INFO_FUNC =
    ::std::option::Option<unsafe extern "C" fn() -> *const TSS2_TCTI_INFO>;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _TSS2_SYS_OPAQUE_CONTEXT_BLOB {
    _unused: [u8; 0],
}
pub type TSS2_SYS_CONTEXT = _TSS2_SYS_OPAQUE_CONTEXT_BLOB;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSS2L_SYS_AUTH_COMMAND {
    pub count: u16,
    pub auths: [TPMS_AUTH_COMMAND; 3usize],
}
#[test]
fn bindgen_test_layout_TSS2L_SYS_AUTH_COMMAND() {
    assert_eq!(
        ::std::mem::size_of::<TSS2L_SYS_AUTH_COMMAND>(),
        424usize,
        concat!("Size of: ", stringify!(TSS2L_SYS_AUTH_COMMAND))
    );
    assert_eq!(
        ::std::mem::align_of::<TSS2L_SYS_AUTH_COMMAND>(),
        4usize,
        concat!("Alignment of ", stringify!(TSS2L_SYS_AUTH_COMMAND))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TSS2L_SYS_AUTH_COMMAND>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2L_SYS_AUTH_COMMAND),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TSS2L_SYS_AUTH_COMMAND>())).auths as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2L_SYS_AUTH_COMMAND),
            "::",
            stringify!(auths)
        )
    );
}
impl Default for TSS2L_SYS_AUTH_COMMAND {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TSS2L_SYS_AUTH_RESPONSE {
    pub count: u16,
    pub auths: [TPMS_AUTH_RESPONSE; 3usize],
}
#[test]
fn bindgen_test_layout_TSS2L_SYS_AUTH_RESPONSE() {
    assert_eq!(
        ::std::mem::size_of::<TSS2L_SYS_AUTH_RESPONSE>(),
        404usize,
        concat!("Size of: ", stringify!(TSS2L_SYS_AUTH_RESPONSE))
    );
    assert_eq!(
        ::std::mem::align_of::<TSS2L_SYS_AUTH_RESPONSE>(),
        2usize,
        concat!("Alignment of ", stringify!(TSS2L_SYS_AUTH_RESPONSE))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TSS2L_SYS_AUTH_RESPONSE>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2L_SYS_AUTH_RESPONSE),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<TSS2L_SYS_AUTH_RESPONSE>())).auths as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(TSS2L_SYS_AUTH_RESPONSE),
            "::",
            stringify!(auths)
        )
    );
}
impl Default for TSS2L_SYS_AUTH_RESPONSE {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn Tss2_Sys_GetContextSize(maxCommandResponseSize: size_t) -> size_t;
}
extern "C" {
    pub fn Tss2_Sys_Initialize(
        sysContext: *mut TSS2_SYS_CONTEXT,
        contextSize: size_t,
        tctiContext: *mut TSS2_TCTI_CONTEXT,
        abiVersion: *mut TSS2_ABI_VERSION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Finalize(sysContext: *mut TSS2_SYS_CONTEXT);
}
extern "C" {
    pub fn Tss2_Sys_GetTctiContext(
        sysContext: *mut TSS2_SYS_CONTEXT,
        tctiContext: *mut *mut TSS2_TCTI_CONTEXT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetDecryptParam(
        sysContext: *mut TSS2_SYS_CONTEXT,
        decryptParamSize: *mut size_t,
        decryptParamBuffer: *mut *const u8,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_SetDecryptParam(
        sysContext: *mut TSS2_SYS_CONTEXT,
        decryptParamSize: size_t,
        decryptParamBuffer: *const u8,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetCpBuffer(
        sysContext: *mut TSS2_SYS_CONTEXT,
        cpBufferUsedSize: *mut size_t,
        cpBuffer: *mut *const u8,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_SetCmdAuths(
        sysContext: *mut TSS2_SYS_CONTEXT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ExecuteAsync(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ExecuteFinish(sysContext: *mut TSS2_SYS_CONTEXT, timeout: i32) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Execute(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetCommandCode(
        sysContext: *mut TSS2_SYS_CONTEXT,
        commandCode: *mut UINT8,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetRspAuths(
        sysContext: *mut TSS2_SYS_CONTEXT,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetEncryptParam(
        sysContext: *mut TSS2_SYS_CONTEXT,
        encryptParamSize: *mut size_t,
        encryptParamBuffer: *mut *const u8,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_SetEncryptParam(
        sysContext: *mut TSS2_SYS_CONTEXT,
        encryptParamSize: size_t,
        encryptParamBuffer: *const u8,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetRpBuffer(
        sysContext: *mut TSS2_SYS_CONTEXT,
        rpBufferUsedSize: *mut size_t,
        rpBuffer: *mut *const u8,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Startup_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        startupType: TPM2_SU,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Startup_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Startup(sysContext: *mut TSS2_SYS_CONTEXT, startupType: TPM2_SU) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Shutdown_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        shutdownType: TPM2_SU,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Shutdown_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Shutdown(
        sysContext: *mut TSS2_SYS_CONTEXT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        shutdownType: TPM2_SU,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_SelfTest_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        fullTest: TPMI_YES_NO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_SelfTest_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_SelfTest(
        sysContext: *mut TSS2_SYS_CONTEXT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        fullTest: TPMI_YES_NO,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_IncrementalSelfTest_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        toTest: *const TPML_ALG,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_IncrementalSelfTest_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        toDoList: *mut TPML_ALG,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_IncrementalSelfTest(
        sysContext: *mut TSS2_SYS_CONTEXT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        toTest: *const TPML_ALG,
        toDoList: *mut TPML_ALG,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetTestResult_Prepare(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetTestResult_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        outData: *mut TPM2B_MAX_BUFFER,
        testResult: *mut TPM2_RC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetTestResult(
        sysContext: *mut TSS2_SYS_CONTEXT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        outData: *mut TPM2B_MAX_BUFFER,
        testResult: *mut TPM2_RC,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_StartAuthSession_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        tpmKey: TPMI_DH_OBJECT,
        bind: TPMI_DH_ENTITY,
        nonceCaller: *const TPM2B_NONCE,
        encryptedSalt: *const TPM2B_ENCRYPTED_SECRET,
        sessionType: TPM2_SE,
        symmetric: *const TPMT_SYM_DEF,
        authHash: TPMI_ALG_HASH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_StartAuthSession_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        sessionHandle: *mut TPMI_SH_AUTH_SESSION,
        nonceTPM: *mut TPM2B_NONCE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_StartAuthSession(
        sysContext: *mut TSS2_SYS_CONTEXT,
        tpmKey: TPMI_DH_OBJECT,
        bind: TPMI_DH_ENTITY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        nonceCaller: *const TPM2B_NONCE,
        encryptedSalt: *const TPM2B_ENCRYPTED_SECRET,
        sessionType: TPM2_SE,
        symmetric: *const TPMT_SYM_DEF,
        authHash: TPMI_ALG_HASH,
        sessionHandle: *mut TPMI_SH_AUTH_SESSION,
        nonceTPM: *mut TPM2B_NONCE,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyRestart_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        sessionHandle: TPMI_SH_POLICY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyRestart_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyRestart(
        sysContext: *mut TSS2_SYS_CONTEXT,
        sessionHandle: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Create_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        parentHandle: TPMI_DH_OBJECT,
        inSensitive: *const TPM2B_SENSITIVE_CREATE,
        inPublic: *const TPM2B_PUBLIC,
        outsideInfo: *const TPM2B_DATA,
        creationPCR: *const TPML_PCR_SELECTION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Create_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        outPrivate: *mut TPM2B_PRIVATE,
        outPublic: *mut TPM2B_PUBLIC,
        creationData: *mut TPM2B_CREATION_DATA,
        creationHash: *mut TPM2B_DIGEST,
        creationTicket: *mut TPMT_TK_CREATION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Create(
        sysContext: *mut TSS2_SYS_CONTEXT,
        parentHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        inSensitive: *const TPM2B_SENSITIVE_CREATE,
        inPublic: *const TPM2B_PUBLIC,
        outsideInfo: *const TPM2B_DATA,
        creationPCR: *const TPML_PCR_SELECTION,
        outPrivate: *mut TPM2B_PRIVATE,
        outPublic: *mut TPM2B_PUBLIC,
        creationData: *mut TPM2B_CREATION_DATA,
        creationHash: *mut TPM2B_DIGEST,
        creationTicket: *mut TPMT_TK_CREATION,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Load_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        parentHandle: TPMI_DH_OBJECT,
        inPrivate: *const TPM2B_PRIVATE,
        inPublic: *const TPM2B_PUBLIC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Load_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        objectHandle: *mut TPM2_HANDLE,
        name: *mut TPM2B_NAME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Load(
        sysContext: *mut TSS2_SYS_CONTEXT,
        parentHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        inPrivate: *const TPM2B_PRIVATE,
        inPublic: *const TPM2B_PUBLIC,
        objectHandle: *mut TPM2_HANDLE,
        name: *mut TPM2B_NAME,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_LoadExternal_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        inPrivate: *const TPM2B_SENSITIVE,
        inPublic: *const TPM2B_PUBLIC,
        hierarchy: TPMI_RH_HIERARCHY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_LoadExternal_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        objectHandle: *mut TPM2_HANDLE,
        name: *mut TPM2B_NAME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_LoadExternal(
        sysContext: *mut TSS2_SYS_CONTEXT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        inPrivate: *const TPM2B_SENSITIVE,
        inPublic: *const TPM2B_PUBLIC,
        hierarchy: TPMI_RH_HIERARCHY,
        objectHandle: *mut TPM2_HANDLE,
        name: *mut TPM2B_NAME,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ReadPublic_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        objectHandle: TPMI_DH_OBJECT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ReadPublic_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        outPublic: *mut TPM2B_PUBLIC,
        name: *mut TPM2B_NAME,
        qualifiedName: *mut TPM2B_NAME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ReadPublic(
        sysContext: *mut TSS2_SYS_CONTEXT,
        objectHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        outPublic: *mut TPM2B_PUBLIC,
        name: *mut TPM2B_NAME,
        qualifiedName: *mut TPM2B_NAME,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ActivateCredential_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        activateHandle: TPMI_DH_OBJECT,
        keyHandle: TPMI_DH_OBJECT,
        credentialBlob: *const TPM2B_ID_OBJECT,
        secret: *const TPM2B_ENCRYPTED_SECRET,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ActivateCredential_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        certInfo: *mut TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ActivateCredential(
        sysContext: *mut TSS2_SYS_CONTEXT,
        activateHandle: TPMI_DH_OBJECT,
        keyHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        credentialBlob: *const TPM2B_ID_OBJECT,
        secret: *const TPM2B_ENCRYPTED_SECRET,
        certInfo: *mut TPM2B_DIGEST,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_MakeCredential_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        handle: TPMI_DH_OBJECT,
        credential: *const TPM2B_DIGEST,
        objectName: *const TPM2B_NAME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_MakeCredential_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        credentialBlob: *mut TPM2B_ID_OBJECT,
        secret: *mut TPM2B_ENCRYPTED_SECRET,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_MakeCredential(
        sysContext: *mut TSS2_SYS_CONTEXT,
        handle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        credential: *const TPM2B_DIGEST,
        objectName: *const TPM2B_NAME,
        credentialBlob: *mut TPM2B_ID_OBJECT,
        secret: *mut TPM2B_ENCRYPTED_SECRET,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Unseal_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        itemHandle: TPMI_DH_OBJECT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Unseal_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        outData: *mut TPM2B_SENSITIVE_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Unseal(
        sysContext: *mut TSS2_SYS_CONTEXT,
        itemHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        outData: *mut TPM2B_SENSITIVE_DATA,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ObjectChangeAuth_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        objectHandle: TPMI_DH_OBJECT,
        parentHandle: TPMI_DH_OBJECT,
        newAuth: *const TPM2B_AUTH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ObjectChangeAuth_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        outPrivate: *mut TPM2B_PRIVATE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ObjectChangeAuth(
        sysContext: *mut TSS2_SYS_CONTEXT,
        objectHandle: TPMI_DH_OBJECT,
        parentHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        newAuth: *const TPM2B_AUTH,
        outPrivate: *mut TPM2B_PRIVATE,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Duplicate_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        objectHandle: TPMI_DH_OBJECT,
        newParentHandle: TPMI_DH_OBJECT,
        encryptionKeyIn: *const TPM2B_DATA,
        symmetricAlg: *const TPMT_SYM_DEF_OBJECT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Duplicate_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        encryptionKeyOut: *mut TPM2B_DATA,
        duplicate: *mut TPM2B_PRIVATE,
        outSymSeed: *mut TPM2B_ENCRYPTED_SECRET,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Duplicate(
        sysContext: *mut TSS2_SYS_CONTEXT,
        objectHandle: TPMI_DH_OBJECT,
        newParentHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        encryptionKeyIn: *const TPM2B_DATA,
        symmetricAlg: *const TPMT_SYM_DEF_OBJECT,
        encryptionKeyOut: *mut TPM2B_DATA,
        duplicate: *mut TPM2B_PRIVATE,
        outSymSeed: *mut TPM2B_ENCRYPTED_SECRET,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Rewrap_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        oldParent: TPMI_DH_OBJECT,
        newParent: TPMI_DH_OBJECT,
        inDuplicate: *const TPM2B_PRIVATE,
        name: *const TPM2B_NAME,
        inSymSeed: *const TPM2B_ENCRYPTED_SECRET,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Rewrap_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        outDuplicate: *mut TPM2B_PRIVATE,
        outSymSeed: *mut TPM2B_ENCRYPTED_SECRET,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Rewrap(
        sysContext: *mut TSS2_SYS_CONTEXT,
        oldParent: TPMI_DH_OBJECT,
        newParent: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        inDuplicate: *const TPM2B_PRIVATE,
        name: *const TPM2B_NAME,
        inSymSeed: *const TPM2B_ENCRYPTED_SECRET,
        outDuplicate: *mut TPM2B_PRIVATE,
        outSymSeed: *mut TPM2B_ENCRYPTED_SECRET,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Import_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        parentHandle: TPMI_DH_OBJECT,
        encryptionKey: *const TPM2B_DATA,
        objectPublic: *const TPM2B_PUBLIC,
        duplicate: *const TPM2B_PRIVATE,
        inSymSeed: *const TPM2B_ENCRYPTED_SECRET,
        symmetricAlg: *const TPMT_SYM_DEF_OBJECT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Import_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        outPrivate: *mut TPM2B_PRIVATE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Import(
        sysContext: *mut TSS2_SYS_CONTEXT,
        parentHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        encryptionKey: *const TPM2B_DATA,
        objectPublic: *const TPM2B_PUBLIC,
        duplicate: *const TPM2B_PRIVATE,
        inSymSeed: *const TPM2B_ENCRYPTED_SECRET,
        symmetricAlg: *const TPMT_SYM_DEF_OBJECT,
        outPrivate: *mut TPM2B_PRIVATE,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_RSA_Encrypt_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        keyHandle: TPMI_DH_OBJECT,
        message: *const TPM2B_PUBLIC_KEY_RSA,
        inScheme: *const TPMT_RSA_DECRYPT,
        label: *const TPM2B_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_RSA_Encrypt_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        outData: *mut TPM2B_PUBLIC_KEY_RSA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_RSA_Encrypt(
        sysContext: *mut TSS2_SYS_CONTEXT,
        keyHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        message: *const TPM2B_PUBLIC_KEY_RSA,
        inScheme: *const TPMT_RSA_DECRYPT,
        label: *const TPM2B_DATA,
        outData: *mut TPM2B_PUBLIC_KEY_RSA,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_RSA_Decrypt_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        keyHandle: TPMI_DH_OBJECT,
        cipherText: *const TPM2B_PUBLIC_KEY_RSA,
        inScheme: *const TPMT_RSA_DECRYPT,
        label: *const TPM2B_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_RSA_Decrypt_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        message: *mut TPM2B_PUBLIC_KEY_RSA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_RSA_Decrypt(
        sysContext: *mut TSS2_SYS_CONTEXT,
        keyHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        cipherText: *const TPM2B_PUBLIC_KEY_RSA,
        inScheme: *const TPMT_RSA_DECRYPT,
        label: *const TPM2B_DATA,
        message: *mut TPM2B_PUBLIC_KEY_RSA,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ECDH_KeyGen_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        keyHandle: TPMI_DH_OBJECT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ECDH_KeyGen_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        zPoint: *mut TPM2B_ECC_POINT,
        pubPoint: *mut TPM2B_ECC_POINT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ECDH_KeyGen(
        sysContext: *mut TSS2_SYS_CONTEXT,
        keyHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        zPoint: *mut TPM2B_ECC_POINT,
        pubPoint: *mut TPM2B_ECC_POINT,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ECDH_ZGen_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        keyHandle: TPMI_DH_OBJECT,
        inPoint: *const TPM2B_ECC_POINT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ECDH_ZGen_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        outPoint: *mut TPM2B_ECC_POINT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ECDH_ZGen(
        sysContext: *mut TSS2_SYS_CONTEXT,
        keyHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        inPoint: *const TPM2B_ECC_POINT,
        outPoint: *mut TPM2B_ECC_POINT,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ECC_Parameters_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        curveID: TPMI_ECC_CURVE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ECC_Parameters_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        parameters: *mut TPMS_ALGORITHM_DETAIL_ECC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ECC_Parameters(
        sysContext: *mut TSS2_SYS_CONTEXT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        curveID: TPMI_ECC_CURVE,
        parameters: *mut TPMS_ALGORITHM_DETAIL_ECC,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ZGen_2Phase_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        keyA: TPMI_DH_OBJECT,
        inQsB: *const TPM2B_ECC_POINT,
        inQeB: *const TPM2B_ECC_POINT,
        inScheme: TPMI_ECC_KEY_EXCHANGE,
        counter: UINT16,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ZGen_2Phase_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        outZ1: *mut TPM2B_ECC_POINT,
        outZ2: *mut TPM2B_ECC_POINT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ZGen_2Phase(
        sysContext: *mut TSS2_SYS_CONTEXT,
        keyA: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        inQsB: *const TPM2B_ECC_POINT,
        inQeB: *const TPM2B_ECC_POINT,
        inScheme: TPMI_ECC_KEY_EXCHANGE,
        counter: UINT16,
        outZ1: *mut TPM2B_ECC_POINT,
        outZ2: *mut TPM2B_ECC_POINT,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_EncryptDecrypt_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        keyHandle: TPMI_DH_OBJECT,
        decrypt: TPMI_YES_NO,
        mode: TPMI_ALG_SYM_MODE,
        ivIn: *const TPM2B_IV,
        inData: *const TPM2B_MAX_BUFFER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_EncryptDecrypt_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        outData: *mut TPM2B_MAX_BUFFER,
        ivOut: *mut TPM2B_IV,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_EncryptDecrypt(
        sysContext: *mut TSS2_SYS_CONTEXT,
        keyHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        decrypt: TPMI_YES_NO,
        mode: TPMI_ALG_SYM_MODE,
        ivIn: *const TPM2B_IV,
        inData: *const TPM2B_MAX_BUFFER,
        outData: *mut TPM2B_MAX_BUFFER,
        ivOut: *mut TPM2B_IV,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_EncryptDecrypt2_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        keyHandle: TPMI_DH_OBJECT,
        inData: *const TPM2B_MAX_BUFFER,
        decrypt: TPMI_YES_NO,
        mode: TPMI_ALG_SYM_MODE,
        ivIn: *const TPM2B_IV,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_EncryptDecrypt2_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        outData: *mut TPM2B_MAX_BUFFER,
        ivOut: *mut TPM2B_IV,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_EncryptDecrypt2(
        sysContext: *mut TSS2_SYS_CONTEXT,
        keyHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        inData: *const TPM2B_MAX_BUFFER,
        decrypt: TPMI_YES_NO,
        mode: TPMI_ALG_SYM_MODE,
        ivIn: *const TPM2B_IV,
        outData: *mut TPM2B_MAX_BUFFER,
        ivOut: *mut TPM2B_IV,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Hash_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        data: *const TPM2B_MAX_BUFFER,
        hashAlg: TPMI_ALG_HASH,
        hierarchy: TPMI_RH_HIERARCHY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Hash_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        outHash: *mut TPM2B_DIGEST,
        validation: *mut TPMT_TK_HASHCHECK,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Hash(
        sysContext: *mut TSS2_SYS_CONTEXT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        data: *const TPM2B_MAX_BUFFER,
        hashAlg: TPMI_ALG_HASH,
        hierarchy: TPMI_RH_HIERARCHY,
        outHash: *mut TPM2B_DIGEST,
        validation: *mut TPMT_TK_HASHCHECK,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_HMAC_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        handle: TPMI_DH_OBJECT,
        buffer: *const TPM2B_MAX_BUFFER,
        hashAlg: TPMI_ALG_HASH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_HMAC_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        outHMAC: *mut TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_HMAC(
        sysContext: *mut TSS2_SYS_CONTEXT,
        handle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        buffer: *const TPM2B_MAX_BUFFER,
        hashAlg: TPMI_ALG_HASH,
        outHMAC: *mut TPM2B_DIGEST,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetRandom_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        bytesRequested: UINT16,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetRandom_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        randomBytes: *mut TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetRandom(
        sysContext: *mut TSS2_SYS_CONTEXT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        bytesRequested: UINT16,
        randomBytes: *mut TPM2B_DIGEST,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_StirRandom_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        inData: *const TPM2B_SENSITIVE_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_StirRandom_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_StirRandom(
        sysContext: *mut TSS2_SYS_CONTEXT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        inData: *const TPM2B_SENSITIVE_DATA,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_HMAC_Start_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        handle: TPMI_DH_OBJECT,
        auth: *const TPM2B_AUTH,
        hashAlg: TPMI_ALG_HASH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_HMAC_Start_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        sequenceHandle: *mut TPMI_DH_OBJECT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_HMAC_Start(
        sysContext: *mut TSS2_SYS_CONTEXT,
        handle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        auth: *const TPM2B_AUTH,
        hashAlg: TPMI_ALG_HASH,
        sequenceHandle: *mut TPMI_DH_OBJECT,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_HashSequenceStart_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        auth: *const TPM2B_AUTH,
        hashAlg: TPMI_ALG_HASH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_HashSequenceStart_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        sequenceHandle: *mut TPMI_DH_OBJECT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_HashSequenceStart(
        sysContext: *mut TSS2_SYS_CONTEXT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        auth: *const TPM2B_AUTH,
        hashAlg: TPMI_ALG_HASH,
        sequenceHandle: *mut TPMI_DH_OBJECT,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_SequenceUpdate_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        sequenceHandle: TPMI_DH_OBJECT,
        buffer: *const TPM2B_MAX_BUFFER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_SequenceUpdate_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_SequenceUpdate(
        sysContext: *mut TSS2_SYS_CONTEXT,
        sequenceHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        buffer: *const TPM2B_MAX_BUFFER,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_SequenceComplete_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        sequenceHandle: TPMI_DH_OBJECT,
        buffer: *const TPM2B_MAX_BUFFER,
        hierarchy: TPMI_RH_HIERARCHY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_SequenceComplete_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        result: *mut TPM2B_DIGEST,
        validation: *mut TPMT_TK_HASHCHECK,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_SequenceComplete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        sequenceHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        buffer: *const TPM2B_MAX_BUFFER,
        hierarchy: TPMI_RH_HIERARCHY,
        result: *mut TPM2B_DIGEST,
        validation: *mut TPMT_TK_HASHCHECK,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_EventSequenceComplete_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        pcrHandle: TPMI_DH_PCR,
        sequenceHandle: TPMI_DH_OBJECT,
        buffer: *const TPM2B_MAX_BUFFER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_EventSequenceComplete_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        results: *mut TPML_DIGEST_VALUES,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_EventSequenceComplete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        pcrHandle: TPMI_DH_PCR,
        sequenceHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        buffer: *const TPM2B_MAX_BUFFER,
        results: *mut TPML_DIGEST_VALUES,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Certify_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        objectHandle: TPMI_DH_OBJECT,
        signHandle: TPMI_DH_OBJECT,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Certify_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        certifyInfo: *mut TPM2B_ATTEST,
        signature: *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Certify(
        sysContext: *mut TSS2_SYS_CONTEXT,
        objectHandle: TPMI_DH_OBJECT,
        signHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
        certifyInfo: *mut TPM2B_ATTEST,
        signature: *mut TPMT_SIGNATURE,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_CertifyCreation_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        signHandle: TPMI_DH_OBJECT,
        objectHandle: TPMI_DH_OBJECT,
        qualifyingData: *const TPM2B_DATA,
        creationHash: *const TPM2B_DIGEST,
        inScheme: *const TPMT_SIG_SCHEME,
        creationTicket: *const TPMT_TK_CREATION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_CertifyCreation_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        certifyInfo: *mut TPM2B_ATTEST,
        signature: *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_CertifyCreation(
        sysContext: *mut TSS2_SYS_CONTEXT,
        signHandle: TPMI_DH_OBJECT,
        objectHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        qualifyingData: *const TPM2B_DATA,
        creationHash: *const TPM2B_DIGEST,
        inScheme: *const TPMT_SIG_SCHEME,
        creationTicket: *const TPMT_TK_CREATION,
        certifyInfo: *mut TPM2B_ATTEST,
        signature: *mut TPMT_SIGNATURE,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Quote_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        signHandle: TPMI_DH_OBJECT,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
        PCRselect: *const TPML_PCR_SELECTION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Quote_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        quoted: *mut TPM2B_ATTEST,
        signature: *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Quote(
        sysContext: *mut TSS2_SYS_CONTEXT,
        signHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
        PCRselect: *const TPML_PCR_SELECTION,
        quoted: *mut TPM2B_ATTEST,
        signature: *mut TPMT_SIGNATURE,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetSessionAuditDigest_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        privacyAdminHandle: TPMI_RH_ENDORSEMENT,
        signHandle: TPMI_DH_OBJECT,
        sessionHandle: TPMI_SH_HMAC,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetSessionAuditDigest_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        auditInfo: *mut TPM2B_ATTEST,
        signature: *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetSessionAuditDigest(
        sysContext: *mut TSS2_SYS_CONTEXT,
        privacyAdminHandle: TPMI_RH_ENDORSEMENT,
        signHandle: TPMI_DH_OBJECT,
        sessionHandle: TPMI_SH_HMAC,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
        auditInfo: *mut TPM2B_ATTEST,
        signature: *mut TPMT_SIGNATURE,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetCommandAuditDigest_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        privacyHandle: TPMI_RH_ENDORSEMENT,
        signHandle: TPMI_DH_OBJECT,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetCommandAuditDigest_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        auditInfo: *mut TPM2B_ATTEST,
        signature: *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetCommandAuditDigest(
        sysContext: *mut TSS2_SYS_CONTEXT,
        privacyHandle: TPMI_RH_ENDORSEMENT,
        signHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
        auditInfo: *mut TPM2B_ATTEST,
        signature: *mut TPMT_SIGNATURE,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetTime_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        privacyAdminHandle: TPMI_RH_ENDORSEMENT,
        signHandle: TPMI_DH_OBJECT,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetTime_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        timeInfo: *mut TPM2B_ATTEST,
        signature: *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetTime(
        sysContext: *mut TSS2_SYS_CONTEXT,
        privacyAdminHandle: TPMI_RH_ENDORSEMENT,
        signHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
        timeInfo: *mut TPM2B_ATTEST,
        signature: *mut TPMT_SIGNATURE,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Commit_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        signHandle: TPMI_DH_OBJECT,
        P1: *const TPM2B_ECC_POINT,
        s2: *const TPM2B_SENSITIVE_DATA,
        y2: *const TPM2B_ECC_PARAMETER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Commit_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        K: *mut TPM2B_ECC_POINT,
        L: *mut TPM2B_ECC_POINT,
        E: *mut TPM2B_ECC_POINT,
        counter: *mut UINT16,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Commit(
        sysContext: *mut TSS2_SYS_CONTEXT,
        signHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        P1: *const TPM2B_ECC_POINT,
        s2: *const TPM2B_SENSITIVE_DATA,
        y2: *const TPM2B_ECC_PARAMETER,
        K: *mut TPM2B_ECC_POINT,
        L: *mut TPM2B_ECC_POINT,
        E: *mut TPM2B_ECC_POINT,
        counter: *mut UINT16,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_EC_Ephemeral_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        curveID: TPMI_ECC_CURVE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_EC_Ephemeral_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        Q: *mut TPM2B_ECC_POINT,
        counter: *mut UINT16,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_EC_Ephemeral(
        sysContext: *mut TSS2_SYS_CONTEXT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        curveID: TPMI_ECC_CURVE,
        Q: *mut TPM2B_ECC_POINT,
        counter: *mut UINT16,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_VerifySignature_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        keyHandle: TPMI_DH_OBJECT,
        digest: *const TPM2B_DIGEST,
        signature: *const TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_VerifySignature_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        validation: *mut TPMT_TK_VERIFIED,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_VerifySignature(
        sysContext: *mut TSS2_SYS_CONTEXT,
        keyHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        digest: *const TPM2B_DIGEST,
        signature: *const TPMT_SIGNATURE,
        validation: *mut TPMT_TK_VERIFIED,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Sign_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        keyHandle: TPMI_DH_OBJECT,
        digest: *const TPM2B_DIGEST,
        inScheme: *const TPMT_SIG_SCHEME,
        validation: *const TPMT_TK_HASHCHECK,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Sign_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        signature: *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Sign(
        sysContext: *mut TSS2_SYS_CONTEXT,
        keyHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        digest: *const TPM2B_DIGEST,
        inScheme: *const TPMT_SIG_SCHEME,
        validation: *const TPMT_TK_HASHCHECK,
        signature: *mut TPMT_SIGNATURE,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_SetCommandCodeAuditStatus_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        auth: TPMI_RH_PROVISION,
        auditAlg: TPMI_ALG_HASH,
        setList: *const TPML_CC,
        clearList: *const TPML_CC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_SetCommandCodeAuditStatus_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_SetCommandCodeAuditStatus(
        sysContext: *mut TSS2_SYS_CONTEXT,
        auth: TPMI_RH_PROVISION,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        auditAlg: TPMI_ALG_HASH,
        setList: *const TPML_CC,
        clearList: *const TPML_CC,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PCR_Extend_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        pcrHandle: TPMI_DH_PCR,
        digests: *const TPML_DIGEST_VALUES,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PCR_Extend_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PCR_Extend(
        sysContext: *mut TSS2_SYS_CONTEXT,
        pcrHandle: TPMI_DH_PCR,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        digests: *const TPML_DIGEST_VALUES,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PCR_Event_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        pcrHandle: TPMI_DH_PCR,
        eventData: *const TPM2B_EVENT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PCR_Event_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        digests: *mut TPML_DIGEST_VALUES,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PCR_Event(
        sysContext: *mut TSS2_SYS_CONTEXT,
        pcrHandle: TPMI_DH_PCR,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        eventData: *const TPM2B_EVENT,
        digests: *mut TPML_DIGEST_VALUES,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PCR_Read_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        pcrSelectionIn: *const TPML_PCR_SELECTION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PCR_Read_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        pcrUpdateCounter: *mut UINT32,
        pcrSelectionOut: *mut TPML_PCR_SELECTION,
        pcrValues: *mut TPML_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PCR_Read(
        sysContext: *mut TSS2_SYS_CONTEXT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        pcrSelectionIn: *const TPML_PCR_SELECTION,
        pcrUpdateCounter: *mut UINT32,
        pcrSelectionOut: *mut TPML_PCR_SELECTION,
        pcrValues: *mut TPML_DIGEST,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PCR_Allocate_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_PLATFORM,
        pcrAllocation: *const TPML_PCR_SELECTION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PCR_Allocate_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        allocationSuccess: *mut TPMI_YES_NO,
        maxPCR: *mut UINT32,
        sizeNeeded: *mut UINT32,
        sizeAvailable: *mut UINT32,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PCR_Allocate(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_PLATFORM,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        pcrAllocation: *const TPML_PCR_SELECTION,
        allocationSuccess: *mut TPMI_YES_NO,
        maxPCR: *mut UINT32,
        sizeNeeded: *mut UINT32,
        sizeAvailable: *mut UINT32,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PCR_SetAuthPolicy_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_PLATFORM,
        authPolicy: *const TPM2B_DIGEST,
        hashAlg: TPMI_ALG_HASH,
        pcrNum: TPMI_DH_PCR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PCR_SetAuthPolicy_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PCR_SetAuthPolicy(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_PLATFORM,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        authPolicy: *const TPM2B_DIGEST,
        hashAlg: TPMI_ALG_HASH,
        pcrNum: TPMI_DH_PCR,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PCR_SetAuthValue_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        pcrHandle: TPMI_DH_PCR,
        auth: *const TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PCR_SetAuthValue_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PCR_SetAuthValue(
        sysContext: *mut TSS2_SYS_CONTEXT,
        pcrHandle: TPMI_DH_PCR,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        auth: *const TPM2B_DIGEST,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PCR_Reset_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        pcrHandle: TPMI_DH_PCR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PCR_Reset_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PCR_Reset(
        sysContext: *mut TSS2_SYS_CONTEXT,
        pcrHandle: TPMI_DH_PCR,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicySigned_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authObject: TPMI_DH_OBJECT,
        policySession: TPMI_SH_POLICY,
        nonceTPM: *const TPM2B_NONCE,
        cpHashA: *const TPM2B_DIGEST,
        policyRef: *const TPM2B_NONCE,
        expiration: INT32,
        auth: *const TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicySigned_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        timeout: *mut TPM2B_TIMEOUT,
        policyTicket: *mut TPMT_TK_AUTH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicySigned(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authObject: TPMI_DH_OBJECT,
        policySession: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        nonceTPM: *const TPM2B_NONCE,
        cpHashA: *const TPM2B_DIGEST,
        policyRef: *const TPM2B_NONCE,
        expiration: INT32,
        auth: *const TPMT_SIGNATURE,
        timeout: *mut TPM2B_TIMEOUT,
        policyTicket: *mut TPMT_TK_AUTH,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicySecret_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_DH_ENTITY,
        policySession: TPMI_SH_POLICY,
        nonceTPM: *const TPM2B_NONCE,
        cpHashA: *const TPM2B_DIGEST,
        policyRef: *const TPM2B_NONCE,
        expiration: INT32,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicySecret_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        timeout: *mut TPM2B_TIMEOUT,
        policyTicket: *mut TPMT_TK_AUTH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicySecret(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_DH_ENTITY,
        policySession: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        nonceTPM: *const TPM2B_NONCE,
        cpHashA: *const TPM2B_DIGEST,
        policyRef: *const TPM2B_NONCE,
        expiration: INT32,
        timeout: *mut TPM2B_TIMEOUT,
        policyTicket: *mut TPMT_TK_AUTH,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyTicket_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        timeout: *const TPM2B_TIMEOUT,
        cpHashA: *const TPM2B_DIGEST,
        policyRef: *const TPM2B_NONCE,
        authName: *const TPM2B_NAME,
        ticket: *const TPMT_TK_AUTH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyTicket_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyTicket(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        timeout: *const TPM2B_TIMEOUT,
        cpHashA: *const TPM2B_DIGEST,
        policyRef: *const TPM2B_NONCE,
        authName: *const TPM2B_NAME,
        ticket: *const TPMT_TK_AUTH,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyOR_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        pHashList: *const TPML_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyOR_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyOR(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        pHashList: *const TPML_DIGEST,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyPCR_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        pcrDigest: *const TPM2B_DIGEST,
        pcrs: *const TPML_PCR_SELECTION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyPCR_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyPCR(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        pcrDigest: *const TPM2B_DIGEST,
        pcrs: *const TPML_PCR_SELECTION,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyLocality_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        locality: TPMA_LOCALITY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyLocality_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyLocality(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        locality: TPMA_LOCALITY,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyNV_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_NV_AUTH,
        nvIndex: TPMI_RH_NV_INDEX,
        policySession: TPMI_SH_POLICY,
        operandB: *const TPM2B_OPERAND,
        offset: UINT16,
        operation: TPM2_EO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyNV_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyNV(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_NV_AUTH,
        nvIndex: TPMI_RH_NV_INDEX,
        policySession: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        operandB: *const TPM2B_OPERAND,
        offset: UINT16,
        operation: TPM2_EO,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyCounterTimer_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        operandB: *const TPM2B_OPERAND,
        offset: UINT16,
        operation: TPM2_EO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyCounterTimer_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyCounterTimer(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        operandB: *const TPM2B_OPERAND,
        offset: UINT16,
        operation: TPM2_EO,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyCommandCode_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        code: TPM2_CC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyCommandCode_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyCommandCode(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        code: TPM2_CC,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyPhysicalPresence_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyPhysicalPresence_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyPhysicalPresence(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyCpHash_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        cpHashA: *const TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyCpHash_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyCpHash(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        cpHashA: *const TPM2B_DIGEST,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyNameHash_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        nameHash: *const TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyNameHash_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyNameHash(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        nameHash: *const TPM2B_DIGEST,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyDuplicationSelect_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        objectName: *const TPM2B_NAME,
        newParentName: *const TPM2B_NAME,
        includeObject: TPMI_YES_NO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyDuplicationSelect_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyDuplicationSelect(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        objectName: *const TPM2B_NAME,
        newParentName: *const TPM2B_NAME,
        includeObject: TPMI_YES_NO,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyAuthorize_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        approvedPolicy: *const TPM2B_DIGEST,
        policyRef: *const TPM2B_NONCE,
        keySign: *const TPM2B_NAME,
        checkTicket: *const TPMT_TK_VERIFIED,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyAuthorize_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyAuthorize(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        approvedPolicy: *const TPM2B_DIGEST,
        policyRef: *const TPM2B_NONCE,
        keySign: *const TPM2B_NAME,
        checkTicket: *const TPMT_TK_VERIFIED,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyAuthValue_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyAuthValue_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyAuthValue(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyPassword_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyPassword_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyPassword(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyGetDigest_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyGetDigest_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policyDigest: *mut TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyGetDigest(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        policyDigest: *mut TPM2B_DIGEST,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyNvWritten_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        writtenSet: TPMI_YES_NO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyNvWritten_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyNvWritten(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        writtenSet: TPMI_YES_NO,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_CreatePrimary_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        primaryHandle: TPMI_RH_HIERARCHY,
        inSensitive: *const TPM2B_SENSITIVE_CREATE,
        inPublic: *const TPM2B_PUBLIC,
        outsideInfo: *const TPM2B_DATA,
        creationPCR: *const TPML_PCR_SELECTION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_CreatePrimary_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        objectHandle: *mut TPM2_HANDLE,
        outPublic: *mut TPM2B_PUBLIC,
        creationData: *mut TPM2B_CREATION_DATA,
        creationHash: *mut TPM2B_DIGEST,
        creationTicket: *mut TPMT_TK_CREATION,
        name: *mut TPM2B_NAME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_CreatePrimary(
        sysContext: *mut TSS2_SYS_CONTEXT,
        primaryHandle: TPMI_RH_HIERARCHY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        inSensitive: *const TPM2B_SENSITIVE_CREATE,
        inPublic: *const TPM2B_PUBLIC,
        outsideInfo: *const TPM2B_DATA,
        creationPCR: *const TPML_PCR_SELECTION,
        objectHandle: *mut TPM2_HANDLE,
        outPublic: *mut TPM2B_PUBLIC,
        creationData: *mut TPM2B_CREATION_DATA,
        creationHash: *mut TPM2B_DIGEST,
        creationTicket: *mut TPMT_TK_CREATION,
        name: *mut TPM2B_NAME,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_HierarchyControl_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_HIERARCHY,
        enable: TPMI_RH_ENABLES,
        state: TPMI_YES_NO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_HierarchyControl_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_HierarchyControl(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_HIERARCHY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        enable: TPMI_RH_ENABLES,
        state: TPMI_YES_NO,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_SetPrimaryPolicy_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_HIERARCHY_AUTH,
        authPolicy: *const TPM2B_DIGEST,
        hashAlg: TPMI_ALG_HASH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_SetPrimaryPolicy_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_SetPrimaryPolicy(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_HIERARCHY_AUTH,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        authPolicy: *const TPM2B_DIGEST,
        hashAlg: TPMI_ALG_HASH,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ChangePPS_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_PLATFORM,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ChangePPS_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ChangePPS(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_PLATFORM,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ChangeEPS_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_PLATFORM,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ChangeEPS_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ChangeEPS(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_PLATFORM,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Clear_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_CLEAR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Clear_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Clear(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_CLEAR,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ClearControl_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        auth: TPMI_RH_CLEAR,
        disable: TPMI_YES_NO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ClearControl_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ClearControl(
        sysContext: *mut TSS2_SYS_CONTEXT,
        auth: TPMI_RH_CLEAR,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        disable: TPMI_YES_NO,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_HierarchyChangeAuth_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_HIERARCHY_AUTH,
        newAuth: *const TPM2B_AUTH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_HierarchyChangeAuth_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_HierarchyChangeAuth(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_HIERARCHY_AUTH,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        newAuth: *const TPM2B_AUTH,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_DictionaryAttackLockReset_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        lockHandle: TPMI_RH_LOCKOUT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_DictionaryAttackLockReset_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_DictionaryAttackLockReset(
        sysContext: *mut TSS2_SYS_CONTEXT,
        lockHandle: TPMI_RH_LOCKOUT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_DictionaryAttackParameters_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        lockHandle: TPMI_RH_LOCKOUT,
        newMaxTries: UINT32,
        newRecoveryTime: UINT32,
        lockoutRecovery: UINT32,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_DictionaryAttackParameters_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_DictionaryAttackParameters(
        sysContext: *mut TSS2_SYS_CONTEXT,
        lockHandle: TPMI_RH_LOCKOUT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        newMaxTries: UINT32,
        newRecoveryTime: UINT32,
        lockoutRecovery: UINT32,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PP_Commands_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        auth: TPMI_RH_PLATFORM,
        setList: *const TPML_CC,
        clearList: *const TPML_CC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PP_Commands_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PP_Commands(
        sysContext: *mut TSS2_SYS_CONTEXT,
        auth: TPMI_RH_PLATFORM,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        setList: *const TPML_CC,
        clearList: *const TPML_CC,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_SetAlgorithmSet_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_PLATFORM,
        algorithmSet: UINT32,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_SetAlgorithmSet_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_SetAlgorithmSet(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_PLATFORM,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        algorithmSet: UINT32,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_FieldUpgradeStart_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authorization: TPMI_RH_PLATFORM,
        keyHandle: TPMI_DH_OBJECT,
        fuDigest: *const TPM2B_DIGEST,
        manifestSignature: *const TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_FieldUpgradeStart_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_FieldUpgradeStart(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authorization: TPMI_RH_PLATFORM,
        keyHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        fuDigest: *const TPM2B_DIGEST,
        manifestSignature: *const TPMT_SIGNATURE,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_FieldUpgradeData_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        fuData: *const TPM2B_MAX_BUFFER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_FieldUpgradeData_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        nextDigest: *mut TPMT_HA,
        firstDigest: *mut TPMT_HA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_FieldUpgradeData(
        sysContext: *mut TSS2_SYS_CONTEXT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        fuData: *const TPM2B_MAX_BUFFER,
        nextDigest: *mut TPMT_HA,
        firstDigest: *mut TPMT_HA,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_FirmwareRead_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        sequenceNumber: UINT32,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_FirmwareRead_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        fuData: *mut TPM2B_MAX_BUFFER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_FirmwareRead(
        sysContext: *mut TSS2_SYS_CONTEXT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        sequenceNumber: UINT32,
        fuData: *mut TPM2B_MAX_BUFFER,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ContextSave_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        saveHandle: TPMI_DH_CONTEXT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ContextSave_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        context: *mut TPMS_CONTEXT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ContextSave(
        sysContext: *mut TSS2_SYS_CONTEXT,
        saveHandle: TPMI_DH_CONTEXT,
        context: *mut TPMS_CONTEXT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ContextLoad_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        context: *const TPMS_CONTEXT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ContextLoad_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        loadedHandle: *mut TPMI_DH_CONTEXT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ContextLoad(
        sysContext: *mut TSS2_SYS_CONTEXT,
        context: *const TPMS_CONTEXT,
        loadedHandle: *mut TPMI_DH_CONTEXT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_FlushContext_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        flushHandle: TPMI_DH_CONTEXT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_FlushContext_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_FlushContext(
        sysContext: *mut TSS2_SYS_CONTEXT,
        flushHandle: TPMI_DH_CONTEXT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_EvictControl_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        auth: TPMI_RH_PROVISION,
        objectHandle: TPMI_DH_OBJECT,
        persistentHandle: TPMI_DH_PERSISTENT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_EvictControl_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_EvictControl(
        sysContext: *mut TSS2_SYS_CONTEXT,
        auth: TPMI_RH_PROVISION,
        objectHandle: TPMI_DH_OBJECT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        persistentHandle: TPMI_DH_PERSISTENT,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ReadClock_Prepare(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ReadClock_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        currentTime: *mut TPMS_TIME_INFO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ReadClock(
        sysContext: *mut TSS2_SYS_CONTEXT,
        currentTime: *mut TPMS_TIME_INFO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ClockSet_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        auth: TPMI_RH_PROVISION,
        newTime: UINT64,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ClockSet_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ClockSet(
        sysContext: *mut TSS2_SYS_CONTEXT,
        auth: TPMI_RH_PROVISION,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        newTime: UINT64,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ClockRateAdjust_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        auth: TPMI_RH_PROVISION,
        rateAdjust: TPM2_CLOCK_ADJUST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ClockRateAdjust_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_ClockRateAdjust(
        sysContext: *mut TSS2_SYS_CONTEXT,
        auth: TPMI_RH_PROVISION,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        rateAdjust: TPM2_CLOCK_ADJUST,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetCapability_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        capability: TPM2_CAP,
        property: UINT32,
        propertyCount: UINT32,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetCapability_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        moreData: *mut TPMI_YES_NO,
        capabilityData: *mut TPMS_CAPABILITY_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_GetCapability(
        sysContext: *mut TSS2_SYS_CONTEXT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        capability: TPM2_CAP,
        property: UINT32,
        propertyCount: UINT32,
        moreData: *mut TPMI_YES_NO,
        capabilityData: *mut TPMS_CAPABILITY_DATA,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_TestParms_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        parameters: *const TPMT_PUBLIC_PARMS,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_TestParms_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_TestParms(
        sysContext: *mut TSS2_SYS_CONTEXT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        parameters: *const TPMT_PUBLIC_PARMS,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_DefineSpace_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_PROVISION,
        auth: *const TPM2B_AUTH,
        publicInfo: *const TPM2B_NV_PUBLIC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_DefineSpace_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_DefineSpace(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_PROVISION,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        auth: *const TPM2B_AUTH,
        publicInfo: *const TPM2B_NV_PUBLIC,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_UndefineSpace_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_PROVISION,
        nvIndex: TPMI_RH_NV_INDEX,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_UndefineSpace_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_UndefineSpace(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_PROVISION,
        nvIndex: TPMI_RH_NV_INDEX,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_UndefineSpaceSpecial_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        nvIndex: TPMI_RH_NV_INDEX,
        platform: TPMI_RH_PLATFORM,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_UndefineSpaceSpecial_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_UndefineSpaceSpecial(
        sysContext: *mut TSS2_SYS_CONTEXT,
        nvIndex: TPMI_RH_NV_INDEX,
        platform: TPMI_RH_PLATFORM,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_ReadPublic_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        nvIndex: TPMI_RH_NV_INDEX,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_ReadPublic_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        nvPublic: *mut TPM2B_NV_PUBLIC,
        nvName: *mut TPM2B_NAME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_ReadPublic(
        sysContext: *mut TSS2_SYS_CONTEXT,
        nvIndex: TPMI_RH_NV_INDEX,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        nvPublic: *mut TPM2B_NV_PUBLIC,
        nvName: *mut TPM2B_NAME,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_Write_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_NV_AUTH,
        nvIndex: TPMI_RH_NV_INDEX,
        data: *const TPM2B_MAX_NV_BUFFER,
        offset: UINT16,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_Write_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_Write(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_NV_AUTH,
        nvIndex: TPMI_RH_NV_INDEX,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        data: *const TPM2B_MAX_NV_BUFFER,
        offset: UINT16,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_Increment_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_NV_AUTH,
        nvIndex: TPMI_RH_NV_INDEX,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_Increment_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_Increment(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_NV_AUTH,
        nvIndex: TPMI_RH_NV_INDEX,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_Extend_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_NV_AUTH,
        nvIndex: TPMI_RH_NV_INDEX,
        data: *const TPM2B_MAX_NV_BUFFER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_Extend_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_Extend(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_NV_AUTH,
        nvIndex: TPMI_RH_NV_INDEX,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        data: *const TPM2B_MAX_NV_BUFFER,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_SetBits_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_NV_AUTH,
        nvIndex: TPMI_RH_NV_INDEX,
        bits: UINT64,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_SetBits_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_SetBits(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_NV_AUTH,
        nvIndex: TPMI_RH_NV_INDEX,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        bits: UINT64,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_WriteLock_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_NV_AUTH,
        nvIndex: TPMI_RH_NV_INDEX,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_WriteLock_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_WriteLock(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_NV_AUTH,
        nvIndex: TPMI_RH_NV_INDEX,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_GlobalWriteLock_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_PROVISION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_GlobalWriteLock_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_GlobalWriteLock(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_PROVISION,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_Read_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_NV_AUTH,
        nvIndex: TPMI_RH_NV_INDEX,
        size: UINT16,
        offset: UINT16,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_Read_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        data: *mut TPM2B_MAX_NV_BUFFER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_Read(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_NV_AUTH,
        nvIndex: TPMI_RH_NV_INDEX,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        size: UINT16,
        offset: UINT16,
        data: *mut TPM2B_MAX_NV_BUFFER,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_ReadLock_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_NV_AUTH,
        nvIndex: TPMI_RH_NV_INDEX,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_ReadLock_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_ReadLock(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_NV_AUTH,
        nvIndex: TPMI_RH_NV_INDEX,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_ChangeAuth_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        nvIndex: TPMI_RH_NV_INDEX,
        newAuth: *const TPM2B_AUTH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_ChangeAuth_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_ChangeAuth(
        sysContext: *mut TSS2_SYS_CONTEXT,
        nvIndex: TPMI_RH_NV_INDEX,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        newAuth: *const TPM2B_AUTH,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_Certify_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        signHandle: TPMI_DH_OBJECT,
        authHandle: TPMI_RH_NV_AUTH,
        nvIndex: TPMI_RH_NV_INDEX,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
        size: UINT16,
        offset: UINT16,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_Certify_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        certifyInfo: *mut TPM2B_ATTEST,
        signature: *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_NV_Certify(
        sysContext: *mut TSS2_SYS_CONTEXT,
        signHandle: TPMI_DH_OBJECT,
        authHandle: TPMI_RH_NV_AUTH,
        nvIndex: TPMI_RH_NV_INDEX,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
        size: UINT16,
        offset: UINT16,
        certifyInfo: *mut TPM2B_ATTEST,
        signature: *mut TPMT_SIGNATURE,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Vendor_TCG_Test_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        inputData: *const TPM2B_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Vendor_TCG_Test_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        outputData: *mut TPM2B_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Vendor_TCG_Test(
        sysContext: *mut TSS2_SYS_CONTEXT,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        inputData: *const TPM2B_DATA,
        outputData: *mut TPM2B_DATA,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_AC_GetCapability_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        ac: TPMI_RH_AC,
        capability: TPM_AT,
        count: UINT32,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_AC_GetCapability_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        moreData: *mut TPMI_YES_NO,
        capabilityData: *mut TPML_AC_CAPABILITIES,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_AC_GetCapability(
        sysContext: *mut TSS2_SYS_CONTEXT,
        ac: TPMI_RH_AC,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        capability: TPM_AT,
        count: UINT32,
        moreData: *mut TPMI_YES_NO,
        capabilityData: *mut TPML_AC_CAPABILITIES,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_AC_Send_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        sendObject: TPMI_DH_OBJECT,
        authHandle: TPMI_RH_NV_AUTH,
        ac: TPMI_RH_AC,
        acDataIn: *mut TPM2B_MAX_BUFFER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_AC_Send_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        acDataOut: *mut TPMS_AC_OUTPUT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_AC_Send(
        sysContext: *mut TSS2_SYS_CONTEXT,
        sendObject: TPMI_DH_OBJECT,
        authHandle: TPMI_RH_NV_AUTH,
        ac: TPMI_RH_AC,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        acDataIn: *mut TPM2B_MAX_BUFFER,
        acDataOut: *mut TPMS_AC_OUTPUT,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Policy_AC_SendSelect_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        objectName: *mut TPM2B_NAME,
        authHandleName: *mut TPM2B_NAME,
        acName: *mut TPM2B_NAME,
        includeObject: TPMI_YES_NO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Policy_AC_SendSelect_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_Policy_AC_SendSelect(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        objectName: *mut TPM2B_NAME,
        authHandleName: *mut TPM2B_NAME,
        acName: *mut TPM2B_NAME,
        includeObject: TPMI_YES_NO,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyTemplate_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        templateHash: *const TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyTemplate_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyTemplate(
        sysContext: *mut TSS2_SYS_CONTEXT,
        policySession: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        templateHash: *const TPM2B_DIGEST,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_CreateLoaded_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        parentHandle: TPMI_RH_HIERARCHY,
        inSensitive: *const TPM2B_SENSITIVE_CREATE,
        inPublic: *const TPM2B_TEMPLATE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_CreateLoaded_Complete(
        sysContext: *mut TSS2_SYS_CONTEXT,
        objectHandle: *mut TPM2_HANDLE,
        outPrivate: *mut TPM2B_PRIVATE,
        outPublic: *mut TPM2B_PUBLIC,
        name: *mut TPM2B_NAME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_CreateLoaded(
        sysContext: *mut TSS2_SYS_CONTEXT,
        parentHandle: TPMI_RH_HIERARCHY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        inSensitive: *const TPM2B_SENSITIVE_CREATE,
        inPublic: *const TPM2B_TEMPLATE,
        objectHandle: *mut TPM2_HANDLE,
        outPrivate: *mut TPM2B_PRIVATE,
        outPublic: *mut TPM2B_PUBLIC,
        name: *mut TPM2B_NAME,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyAuthorizeNV_Prepare(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_NV_AUTH,
        nvIndex: TPMI_RH_NV_INDEX,
        policySession: TPMI_SH_POLICY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyAuthorizeNV_Complete(sysContext: *mut TSS2_SYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_Sys_PolicyAuthorizeNV(
        sysContext: *mut TSS2_SYS_CONTEXT,
        authHandle: TPMI_RH_NV_AUTH,
        nvIndex: TPMI_RH_NV_INDEX,
        policySession: TPMI_SH_POLICY,
        cmdAuthsArray: *const TSS2L_SYS_AUTH_COMMAND,
        rspAuthsArray: *mut TSS2L_SYS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
pub type ESYS_TR = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ESYS_CONTEXT {
    _unused: [u8; 0],
}
extern "C" {
    pub fn Esys_Initialize(
        esys_context: *mut *mut ESYS_CONTEXT,
        tcti: *mut TSS2_TCTI_CONTEXT,
        abiVersion: *mut TSS2_ABI_VERSION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Finalize(context: *mut *mut ESYS_CONTEXT);
}
extern "C" {
    pub fn Esys_GetTcti(
        esys_context: *mut ESYS_CONTEXT,
        tcti: *mut *mut TSS2_TCTI_CONTEXT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_GetPollHandles(
        esys_context: *mut ESYS_CONTEXT,
        handles: *mut *mut TSS2_TCTI_POLL_HANDLE,
        count: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_SetTimeout(esys_context: *mut ESYS_CONTEXT, timeout: i32) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_TR_Serialize(
        esys_context: *mut ESYS_CONTEXT,
        object: ESYS_TR,
        buffer: *mut *mut u8,
        buffer_size: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_TR_Deserialize(
        esys_context: *mut ESYS_CONTEXT,
        buffer: *const u8,
        buffer_size: size_t,
        esys_handle: *mut ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_TR_FromTPMPublic_Async(
        esysContext: *mut ESYS_CONTEXT,
        tpm_handle: TPM2_HANDLE,
        optionalSession1: ESYS_TR,
        optionalSession2: ESYS_TR,
        optionalSession3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_TR_FromTPMPublic_Finish(
        esysContext: *mut ESYS_CONTEXT,
        object: *mut ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_TR_FromTPMPublic(
        esysContext: *mut ESYS_CONTEXT,
        tpm_handle: TPM2_HANDLE,
        optionalSession1: ESYS_TR,
        optionalSession2: ESYS_TR,
        optionalSession3: ESYS_TR,
        object: *mut ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_TR_Close(esys_context: *mut ESYS_CONTEXT, rsrc_handle: *mut ESYS_TR) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_TR_SetAuth(
        esysContext: *mut ESYS_CONTEXT,
        handle: ESYS_TR,
        authValue: *const TPM2B_AUTH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_TR_GetName(
        esysContext: *mut ESYS_CONTEXT,
        handle: ESYS_TR,
        name: *mut *mut TPM2B_NAME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_TRSess_GetAttributes(
        esysContext: *mut ESYS_CONTEXT,
        session: ESYS_TR,
        flags: *mut TPMA_SESSION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_TRSess_SetAttributes(
        esysContext: *mut ESYS_CONTEXT,
        session: ESYS_TR,
        flags: TPMA_SESSION,
        mask: TPMA_SESSION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_TRSess_GetNonceTPM(
        esysContext: *mut ESYS_CONTEXT,
        session: ESYS_TR,
        nonceTPM: *mut *mut TPM2B_NONCE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Startup(esysContext: *mut ESYS_CONTEXT, startupType: TPM2_SU) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Startup_Async(esysContext: *mut ESYS_CONTEXT, startupType: TPM2_SU) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Startup_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Shutdown(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        shutdownType: TPM2_SU,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Shutdown_Async(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        shutdownType: TPM2_SU,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Shutdown_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_SelfTest(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        fullTest: TPMI_YES_NO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_SelfTest_Async(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        fullTest: TPMI_YES_NO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_SelfTest_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_IncrementalSelfTest(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        toTest: *const TPML_ALG,
        toDoList: *mut *mut TPML_ALG,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_IncrementalSelfTest_Async(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        toTest: *const TPML_ALG,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_IncrementalSelfTest_Finish(
        esysContext: *mut ESYS_CONTEXT,
        toDoList: *mut *mut TPML_ALG,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_GetTestResult(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        outData: *mut *mut TPM2B_MAX_BUFFER,
        testResult: *mut TPM2_RC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_GetTestResult_Async(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_GetTestResult_Finish(
        esysContext: *mut ESYS_CONTEXT,
        outData: *mut *mut TPM2B_MAX_BUFFER,
        testResult: *mut TPM2_RC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_StartAuthSession(
        esysContext: *mut ESYS_CONTEXT,
        tpmKey: ESYS_TR,
        bind: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        nonceCaller: *const TPM2B_NONCE,
        sessionType: TPM2_SE,
        symmetric: *const TPMT_SYM_DEF,
        authHash: TPMI_ALG_HASH,
        sessionHandle: *mut ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_StartAuthSession_Async(
        esysContext: *mut ESYS_CONTEXT,
        tpmKey: ESYS_TR,
        bind: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        nonceCaller: *const TPM2B_NONCE,
        sessionType: TPM2_SE,
        symmetric: *const TPMT_SYM_DEF,
        authHash: TPMI_ALG_HASH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_StartAuthSession_Finish(
        esysContext: *mut ESYS_CONTEXT,
        sessionHandle: *mut ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyRestart(
        esysContext: *mut ESYS_CONTEXT,
        sessionHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyRestart_Async(
        esysContext: *mut ESYS_CONTEXT,
        sessionHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyRestart_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Create(
        esysContext: *mut ESYS_CONTEXT,
        parentHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inSensitive: *const TPM2B_SENSITIVE_CREATE,
        inPublic: *const TPM2B_PUBLIC,
        outsideInfo: *const TPM2B_DATA,
        creationPCR: *const TPML_PCR_SELECTION,
        outPrivate: *mut *mut TPM2B_PRIVATE,
        outPublic: *mut *mut TPM2B_PUBLIC,
        creationData: *mut *mut TPM2B_CREATION_DATA,
        creationHash: *mut *mut TPM2B_DIGEST,
        creationTicket: *mut *mut TPMT_TK_CREATION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Create_Async(
        esysContext: *mut ESYS_CONTEXT,
        parentHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inSensitive: *const TPM2B_SENSITIVE_CREATE,
        inPublic: *const TPM2B_PUBLIC,
        outsideInfo: *const TPM2B_DATA,
        creationPCR: *const TPML_PCR_SELECTION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Create_Finish(
        esysContext: *mut ESYS_CONTEXT,
        outPrivate: *mut *mut TPM2B_PRIVATE,
        outPublic: *mut *mut TPM2B_PUBLIC,
        creationData: *mut *mut TPM2B_CREATION_DATA,
        creationHash: *mut *mut TPM2B_DIGEST,
        creationTicket: *mut *mut TPMT_TK_CREATION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Load(
        esysContext: *mut ESYS_CONTEXT,
        parentHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inPrivate: *const TPM2B_PRIVATE,
        inPublic: *const TPM2B_PUBLIC,
        objectHandle: *mut ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Load_Async(
        esysContext: *mut ESYS_CONTEXT,
        parentHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inPrivate: *const TPM2B_PRIVATE,
        inPublic: *const TPM2B_PUBLIC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Load_Finish(esysContext: *mut ESYS_CONTEXT, objectHandle: *mut ESYS_TR) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_LoadExternal(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inPrivate: *const TPM2B_SENSITIVE,
        inPublic: *const TPM2B_PUBLIC,
        hierarchy: TPMI_RH_HIERARCHY,
        objectHandle: *mut ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_LoadExternal_Async(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inPrivate: *const TPM2B_SENSITIVE,
        inPublic: *const TPM2B_PUBLIC,
        hierarchy: TPMI_RH_HIERARCHY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_LoadExternal_Finish(
        esysContext: *mut ESYS_CONTEXT,
        objectHandle: *mut ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ReadPublic(
        esysContext: *mut ESYS_CONTEXT,
        objectHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        outPublic: *mut *mut TPM2B_PUBLIC,
        name: *mut *mut TPM2B_NAME,
        qualifiedName: *mut *mut TPM2B_NAME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ReadPublic_Async(
        esysContext: *mut ESYS_CONTEXT,
        objectHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ReadPublic_Finish(
        esysContext: *mut ESYS_CONTEXT,
        outPublic: *mut *mut TPM2B_PUBLIC,
        name: *mut *mut TPM2B_NAME,
        qualifiedName: *mut *mut TPM2B_NAME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ActivateCredential(
        esysContext: *mut ESYS_CONTEXT,
        activateHandle: ESYS_TR,
        keyHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        credentialBlob: *const TPM2B_ID_OBJECT,
        secret: *const TPM2B_ENCRYPTED_SECRET,
        certInfo: *mut *mut TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ActivateCredential_Async(
        esysContext: *mut ESYS_CONTEXT,
        activateHandle: ESYS_TR,
        keyHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        credentialBlob: *const TPM2B_ID_OBJECT,
        secret: *const TPM2B_ENCRYPTED_SECRET,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ActivateCredential_Finish(
        esysContext: *mut ESYS_CONTEXT,
        certInfo: *mut *mut TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_MakeCredential(
        esysContext: *mut ESYS_CONTEXT,
        handle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        credential: *const TPM2B_DIGEST,
        objectName: *const TPM2B_NAME,
        credentialBlob: *mut *mut TPM2B_ID_OBJECT,
        secret: *mut *mut TPM2B_ENCRYPTED_SECRET,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_MakeCredential_Async(
        esysContext: *mut ESYS_CONTEXT,
        handle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        credential: *const TPM2B_DIGEST,
        objectName: *const TPM2B_NAME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_MakeCredential_Finish(
        esysContext: *mut ESYS_CONTEXT,
        credentialBlob: *mut *mut TPM2B_ID_OBJECT,
        secret: *mut *mut TPM2B_ENCRYPTED_SECRET,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Unseal(
        esysContext: *mut ESYS_CONTEXT,
        itemHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        outData: *mut *mut TPM2B_SENSITIVE_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Unseal_Async(
        esysContext: *mut ESYS_CONTEXT,
        itemHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Unseal_Finish(
        esysContext: *mut ESYS_CONTEXT,
        outData: *mut *mut TPM2B_SENSITIVE_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ObjectChangeAuth(
        esysContext: *mut ESYS_CONTEXT,
        objectHandle: ESYS_TR,
        parentHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        newAuth: *const TPM2B_AUTH,
        outPrivate: *mut *mut TPM2B_PRIVATE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ObjectChangeAuth_Async(
        esysContext: *mut ESYS_CONTEXT,
        objectHandle: ESYS_TR,
        parentHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        newAuth: *const TPM2B_AUTH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ObjectChangeAuth_Finish(
        esysContext: *mut ESYS_CONTEXT,
        outPrivate: *mut *mut TPM2B_PRIVATE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_CreateLoaded(
        esysContext: *mut ESYS_CONTEXT,
        parentHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inSensitive: *const TPM2B_SENSITIVE_CREATE,
        inPublic: *const TPM2B_TEMPLATE,
        objectHandle: *mut ESYS_TR,
        outPrivate: *mut *mut TPM2B_PRIVATE,
        outPublic: *mut *mut TPM2B_PUBLIC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_CreateLoaded_Async(
        esysContext: *mut ESYS_CONTEXT,
        parentHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inSensitive: *const TPM2B_SENSITIVE_CREATE,
        inPublic: *const TPM2B_TEMPLATE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_CreateLoaded_Finish(
        esysContext: *mut ESYS_CONTEXT,
        objectHandle: *mut ESYS_TR,
        outPrivate: *mut *mut TPM2B_PRIVATE,
        outPublic: *mut *mut TPM2B_PUBLIC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Duplicate(
        esysContext: *mut ESYS_CONTEXT,
        objectHandle: ESYS_TR,
        newParentHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        encryptionKeyIn: *const TPM2B_DATA,
        symmetricAlg: *const TPMT_SYM_DEF_OBJECT,
        encryptionKeyOut: *mut *mut TPM2B_DATA,
        duplicate: *mut *mut TPM2B_PRIVATE,
        outSymSeed: *mut *mut TPM2B_ENCRYPTED_SECRET,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Duplicate_Async(
        esysContext: *mut ESYS_CONTEXT,
        objectHandle: ESYS_TR,
        newParentHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        encryptionKeyIn: *const TPM2B_DATA,
        symmetricAlg: *const TPMT_SYM_DEF_OBJECT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Duplicate_Finish(
        esysContext: *mut ESYS_CONTEXT,
        encryptionKeyOut: *mut *mut TPM2B_DATA,
        duplicate: *mut *mut TPM2B_PRIVATE,
        outSymSeed: *mut *mut TPM2B_ENCRYPTED_SECRET,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Rewrap(
        esysContext: *mut ESYS_CONTEXT,
        oldParent: ESYS_TR,
        newParent: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inDuplicate: *const TPM2B_PRIVATE,
        name: *const TPM2B_NAME,
        inSymSeed: *const TPM2B_ENCRYPTED_SECRET,
        outDuplicate: *mut *mut TPM2B_PRIVATE,
        outSymSeed: *mut *mut TPM2B_ENCRYPTED_SECRET,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Rewrap_Async(
        esysContext: *mut ESYS_CONTEXT,
        oldParent: ESYS_TR,
        newParent: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inDuplicate: *const TPM2B_PRIVATE,
        name: *const TPM2B_NAME,
        inSymSeed: *const TPM2B_ENCRYPTED_SECRET,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Rewrap_Finish(
        esysContext: *mut ESYS_CONTEXT,
        outDuplicate: *mut *mut TPM2B_PRIVATE,
        outSymSeed: *mut *mut TPM2B_ENCRYPTED_SECRET,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Import(
        esysContext: *mut ESYS_CONTEXT,
        parentHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        encryptionKey: *const TPM2B_DATA,
        objectPublic: *const TPM2B_PUBLIC,
        duplicate: *const TPM2B_PRIVATE,
        inSymSeed: *const TPM2B_ENCRYPTED_SECRET,
        symmetricAlg: *const TPMT_SYM_DEF_OBJECT,
        outPrivate: *mut *mut TPM2B_PRIVATE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Import_Async(
        esysContext: *mut ESYS_CONTEXT,
        parentHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        encryptionKey: *const TPM2B_DATA,
        objectPublic: *const TPM2B_PUBLIC,
        duplicate: *const TPM2B_PRIVATE,
        inSymSeed: *const TPM2B_ENCRYPTED_SECRET,
        symmetricAlg: *const TPMT_SYM_DEF_OBJECT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Import_Finish(
        esysContext: *mut ESYS_CONTEXT,
        outPrivate: *mut *mut TPM2B_PRIVATE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_RSA_Encrypt(
        esysContext: *mut ESYS_CONTEXT,
        keyHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        message: *const TPM2B_PUBLIC_KEY_RSA,
        inScheme: *const TPMT_RSA_DECRYPT,
        label: *const TPM2B_DATA,
        outData: *mut *mut TPM2B_PUBLIC_KEY_RSA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_RSA_Encrypt_Async(
        esysContext: *mut ESYS_CONTEXT,
        keyHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        message: *const TPM2B_PUBLIC_KEY_RSA,
        inScheme: *const TPMT_RSA_DECRYPT,
        label: *const TPM2B_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_RSA_Encrypt_Finish(
        esysContext: *mut ESYS_CONTEXT,
        outData: *mut *mut TPM2B_PUBLIC_KEY_RSA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_RSA_Decrypt(
        esysContext: *mut ESYS_CONTEXT,
        keyHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        cipherText: *const TPM2B_PUBLIC_KEY_RSA,
        inScheme: *const TPMT_RSA_DECRYPT,
        label: *const TPM2B_DATA,
        message: *mut *mut TPM2B_PUBLIC_KEY_RSA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_RSA_Decrypt_Async(
        esysContext: *mut ESYS_CONTEXT,
        keyHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        cipherText: *const TPM2B_PUBLIC_KEY_RSA,
        inScheme: *const TPMT_RSA_DECRYPT,
        label: *const TPM2B_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_RSA_Decrypt_Finish(
        esysContext: *mut ESYS_CONTEXT,
        message: *mut *mut TPM2B_PUBLIC_KEY_RSA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ECDH_KeyGen(
        esysContext: *mut ESYS_CONTEXT,
        keyHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        zPoint: *mut *mut TPM2B_ECC_POINT,
        pubPoint: *mut *mut TPM2B_ECC_POINT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ECDH_KeyGen_Async(
        esysContext: *mut ESYS_CONTEXT,
        keyHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ECDH_KeyGen_Finish(
        esysContext: *mut ESYS_CONTEXT,
        zPoint: *mut *mut TPM2B_ECC_POINT,
        pubPoint: *mut *mut TPM2B_ECC_POINT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ECDH_ZGen(
        esysContext: *mut ESYS_CONTEXT,
        keyHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inPoint: *const TPM2B_ECC_POINT,
        outPoint: *mut *mut TPM2B_ECC_POINT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ECDH_ZGen_Async(
        esysContext: *mut ESYS_CONTEXT,
        keyHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inPoint: *const TPM2B_ECC_POINT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ECDH_ZGen_Finish(
        esysContext: *mut ESYS_CONTEXT,
        outPoint: *mut *mut TPM2B_ECC_POINT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ECC_Parameters(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        curveID: TPMI_ECC_CURVE,
        parameters: *mut *mut TPMS_ALGORITHM_DETAIL_ECC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ECC_Parameters_Async(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        curveID: TPMI_ECC_CURVE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ECC_Parameters_Finish(
        esysContext: *mut ESYS_CONTEXT,
        parameters: *mut *mut TPMS_ALGORITHM_DETAIL_ECC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ZGen_2Phase(
        esysContext: *mut ESYS_CONTEXT,
        keyA: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inQsB: *const TPM2B_ECC_POINT,
        inQeB: *const TPM2B_ECC_POINT,
        inScheme: TPMI_ECC_KEY_EXCHANGE,
        counter: UINT16,
        outZ1: *mut *mut TPM2B_ECC_POINT,
        outZ2: *mut *mut TPM2B_ECC_POINT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ZGen_2Phase_Async(
        esysContext: *mut ESYS_CONTEXT,
        keyA: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inQsB: *const TPM2B_ECC_POINT,
        inQeB: *const TPM2B_ECC_POINT,
        inScheme: TPMI_ECC_KEY_EXCHANGE,
        counter: UINT16,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ZGen_2Phase_Finish(
        esysContext: *mut ESYS_CONTEXT,
        outZ1: *mut *mut TPM2B_ECC_POINT,
        outZ2: *mut *mut TPM2B_ECC_POINT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_EncryptDecrypt(
        esysContext: *mut ESYS_CONTEXT,
        keyHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        decrypt: TPMI_YES_NO,
        mode: TPMI_ALG_SYM_MODE,
        ivIn: *const TPM2B_IV,
        inData: *const TPM2B_MAX_BUFFER,
        outData: *mut *mut TPM2B_MAX_BUFFER,
        ivOut: *mut *mut TPM2B_IV,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_EncryptDecrypt_Async(
        esysContext: *mut ESYS_CONTEXT,
        keyHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        decrypt: TPMI_YES_NO,
        mode: TPMI_ALG_SYM_MODE,
        ivIn: *const TPM2B_IV,
        inData: *const TPM2B_MAX_BUFFER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_EncryptDecrypt_Finish(
        esysContext: *mut ESYS_CONTEXT,
        outData: *mut *mut TPM2B_MAX_BUFFER,
        ivOut: *mut *mut TPM2B_IV,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_EncryptDecrypt2(
        esysContext: *mut ESYS_CONTEXT,
        keyHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inData: *const TPM2B_MAX_BUFFER,
        decrypt: TPMI_YES_NO,
        mode: TPMI_ALG_SYM_MODE,
        ivIn: *const TPM2B_IV,
        outData: *mut *mut TPM2B_MAX_BUFFER,
        ivOut: *mut *mut TPM2B_IV,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_EncryptDecrypt2_Async(
        esysContext: *mut ESYS_CONTEXT,
        keyHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inData: *const TPM2B_MAX_BUFFER,
        decrypt: TPMI_YES_NO,
        mode: TPMI_ALG_SYM_MODE,
        ivIn: *const TPM2B_IV,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_EncryptDecrypt2_Finish(
        esysContext: *mut ESYS_CONTEXT,
        outData: *mut *mut TPM2B_MAX_BUFFER,
        ivOut: *mut *mut TPM2B_IV,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Hash(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        data: *const TPM2B_MAX_BUFFER,
        hashAlg: TPMI_ALG_HASH,
        hierarchy: TPMI_RH_HIERARCHY,
        outHash: *mut *mut TPM2B_DIGEST,
        validation: *mut *mut TPMT_TK_HASHCHECK,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Hash_Async(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        data: *const TPM2B_MAX_BUFFER,
        hashAlg: TPMI_ALG_HASH,
        hierarchy: TPMI_RH_HIERARCHY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Hash_Finish(
        esysContext: *mut ESYS_CONTEXT,
        outHash: *mut *mut TPM2B_DIGEST,
        validation: *mut *mut TPMT_TK_HASHCHECK,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_HMAC(
        esysContext: *mut ESYS_CONTEXT,
        handle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        buffer: *const TPM2B_MAX_BUFFER,
        hashAlg: TPMI_ALG_HASH,
        outHMAC: *mut *mut TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_HMAC_Async(
        esysContext: *mut ESYS_CONTEXT,
        handle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        buffer: *const TPM2B_MAX_BUFFER,
        hashAlg: TPMI_ALG_HASH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_HMAC_Finish(
        esysContext: *mut ESYS_CONTEXT,
        outHMAC: *mut *mut TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_GetRandom(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        bytesRequested: UINT16,
        randomBytes: *mut *mut TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_GetRandom_Async(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        bytesRequested: UINT16,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_GetRandom_Finish(
        esysContext: *mut ESYS_CONTEXT,
        randomBytes: *mut *mut TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_StirRandom(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inData: *const TPM2B_SENSITIVE_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_StirRandom_Async(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inData: *const TPM2B_SENSITIVE_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_StirRandom_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_HMAC_Start(
        esysContext: *mut ESYS_CONTEXT,
        handle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        auth: *const TPM2B_AUTH,
        hashAlg: TPMI_ALG_HASH,
        sequenceHandle: *mut ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_HMAC_Start_Async(
        esysContext: *mut ESYS_CONTEXT,
        handle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        auth: *const TPM2B_AUTH,
        hashAlg: TPMI_ALG_HASH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_HMAC_Start_Finish(
        esysContext: *mut ESYS_CONTEXT,
        sequenceHandle: *mut ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_HashSequenceStart(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        auth: *const TPM2B_AUTH,
        hashAlg: TPMI_ALG_HASH,
        sequenceHandle: *mut ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_HashSequenceStart_Async(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        auth: *const TPM2B_AUTH,
        hashAlg: TPMI_ALG_HASH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_HashSequenceStart_Finish(
        esysContext: *mut ESYS_CONTEXT,
        sequenceHandle: *mut ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_SequenceUpdate(
        esysContext: *mut ESYS_CONTEXT,
        sequenceHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        buffer: *const TPM2B_MAX_BUFFER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_SequenceUpdate_Async(
        esysContext: *mut ESYS_CONTEXT,
        sequenceHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        buffer: *const TPM2B_MAX_BUFFER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_SequenceUpdate_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_SequenceComplete(
        esysContext: *mut ESYS_CONTEXT,
        sequenceHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        buffer: *const TPM2B_MAX_BUFFER,
        hierarchy: TPMI_RH_HIERARCHY,
        result: *mut *mut TPM2B_DIGEST,
        validation: *mut *mut TPMT_TK_HASHCHECK,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_SequenceComplete_Async(
        esysContext: *mut ESYS_CONTEXT,
        sequenceHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        buffer: *const TPM2B_MAX_BUFFER,
        hierarchy: TPMI_RH_HIERARCHY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_SequenceComplete_Finish(
        esysContext: *mut ESYS_CONTEXT,
        result: *mut *mut TPM2B_DIGEST,
        validation: *mut *mut TPMT_TK_HASHCHECK,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_EventSequenceComplete(
        esysContext: *mut ESYS_CONTEXT,
        pcrHandle: ESYS_TR,
        sequenceHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        buffer: *const TPM2B_MAX_BUFFER,
        results: *mut *mut TPML_DIGEST_VALUES,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_EventSequenceComplete_Async(
        esysContext: *mut ESYS_CONTEXT,
        pcrHandle: ESYS_TR,
        sequenceHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        buffer: *const TPM2B_MAX_BUFFER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_EventSequenceComplete_Finish(
        esysContext: *mut ESYS_CONTEXT,
        results: *mut *mut TPML_DIGEST_VALUES,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Certify(
        esysContext: *mut ESYS_CONTEXT,
        objectHandle: ESYS_TR,
        signHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
        certifyInfo: *mut *mut TPM2B_ATTEST,
        signature: *mut *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Certify_Async(
        esysContext: *mut ESYS_CONTEXT,
        objectHandle: ESYS_TR,
        signHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Certify_Finish(
        esysContext: *mut ESYS_CONTEXT,
        certifyInfo: *mut *mut TPM2B_ATTEST,
        signature: *mut *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_CertifyCreation(
        esysContext: *mut ESYS_CONTEXT,
        signHandle: ESYS_TR,
        objectHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        qualifyingData: *const TPM2B_DATA,
        creationHash: *const TPM2B_DIGEST,
        inScheme: *const TPMT_SIG_SCHEME,
        creationTicket: *const TPMT_TK_CREATION,
        certifyInfo: *mut *mut TPM2B_ATTEST,
        signature: *mut *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_CertifyCreation_Async(
        esysContext: *mut ESYS_CONTEXT,
        signHandle: ESYS_TR,
        objectHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        qualifyingData: *const TPM2B_DATA,
        creationHash: *const TPM2B_DIGEST,
        inScheme: *const TPMT_SIG_SCHEME,
        creationTicket: *const TPMT_TK_CREATION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_CertifyCreation_Finish(
        esysContext: *mut ESYS_CONTEXT,
        certifyInfo: *mut *mut TPM2B_ATTEST,
        signature: *mut *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Quote(
        esysContext: *mut ESYS_CONTEXT,
        signHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
        PCRselect: *const TPML_PCR_SELECTION,
        quoted: *mut *mut TPM2B_ATTEST,
        signature: *mut *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Quote_Async(
        esysContext: *mut ESYS_CONTEXT,
        signHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
        PCRselect: *const TPML_PCR_SELECTION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Quote_Finish(
        esysContext: *mut ESYS_CONTEXT,
        quoted: *mut *mut TPM2B_ATTEST,
        signature: *mut *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_GetSessionAuditDigest(
        esysContext: *mut ESYS_CONTEXT,
        privacyAdminHandle: ESYS_TR,
        signHandle: ESYS_TR,
        sessionHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
        auditInfo: *mut *mut TPM2B_ATTEST,
        signature: *mut *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_GetSessionAuditDigest_Async(
        esysContext: *mut ESYS_CONTEXT,
        privacyAdminHandle: ESYS_TR,
        signHandle: ESYS_TR,
        sessionHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_GetSessionAuditDigest_Finish(
        esysContext: *mut ESYS_CONTEXT,
        auditInfo: *mut *mut TPM2B_ATTEST,
        signature: *mut *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_GetCommandAuditDigest(
        esysContext: *mut ESYS_CONTEXT,
        privacyHandle: ESYS_TR,
        signHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
        auditInfo: *mut *mut TPM2B_ATTEST,
        signature: *mut *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_GetCommandAuditDigest_Async(
        esysContext: *mut ESYS_CONTEXT,
        privacyHandle: ESYS_TR,
        signHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_GetCommandAuditDigest_Finish(
        esysContext: *mut ESYS_CONTEXT,
        auditInfo: *mut *mut TPM2B_ATTEST,
        signature: *mut *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_GetTime(
        esysContext: *mut ESYS_CONTEXT,
        privacyAdminHandle: ESYS_TR,
        signHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
        timeInfo: *mut *mut TPM2B_ATTEST,
        signature: *mut *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_GetTime_Async(
        esysContext: *mut ESYS_CONTEXT,
        privacyAdminHandle: ESYS_TR,
        signHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_GetTime_Finish(
        esysContext: *mut ESYS_CONTEXT,
        timeInfo: *mut *mut TPM2B_ATTEST,
        signature: *mut *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Commit(
        esysContext: *mut ESYS_CONTEXT,
        signHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        P1: *const TPM2B_ECC_POINT,
        s2: *const TPM2B_SENSITIVE_DATA,
        y2: *const TPM2B_ECC_PARAMETER,
        K: *mut *mut TPM2B_ECC_POINT,
        L: *mut *mut TPM2B_ECC_POINT,
        E: *mut *mut TPM2B_ECC_POINT,
        counter: *mut UINT16,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Commit_Async(
        esysContext: *mut ESYS_CONTEXT,
        signHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        P1: *const TPM2B_ECC_POINT,
        s2: *const TPM2B_SENSITIVE_DATA,
        y2: *const TPM2B_ECC_PARAMETER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Commit_Finish(
        esysContext: *mut ESYS_CONTEXT,
        K: *mut *mut TPM2B_ECC_POINT,
        L: *mut *mut TPM2B_ECC_POINT,
        E: *mut *mut TPM2B_ECC_POINT,
        counter: *mut UINT16,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_EC_Ephemeral(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        curveID: TPMI_ECC_CURVE,
        Q: *mut *mut TPM2B_ECC_POINT,
        counter: *mut UINT16,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_EC_Ephemeral_Async(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        curveID: TPMI_ECC_CURVE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_EC_Ephemeral_Finish(
        esysContext: *mut ESYS_CONTEXT,
        Q: *mut *mut TPM2B_ECC_POINT,
        counter: *mut UINT16,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_VerifySignature(
        esysContext: *mut ESYS_CONTEXT,
        keyHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        digest: *const TPM2B_DIGEST,
        signature: *const TPMT_SIGNATURE,
        validation: *mut *mut TPMT_TK_VERIFIED,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_VerifySignature_Async(
        esysContext: *mut ESYS_CONTEXT,
        keyHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        digest: *const TPM2B_DIGEST,
        signature: *const TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_VerifySignature_Finish(
        esysContext: *mut ESYS_CONTEXT,
        validation: *mut *mut TPMT_TK_VERIFIED,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Sign(
        esysContext: *mut ESYS_CONTEXT,
        keyHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        digest: *const TPM2B_DIGEST,
        inScheme: *const TPMT_SIG_SCHEME,
        validation: *const TPMT_TK_HASHCHECK,
        signature: *mut *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Sign_Async(
        esysContext: *mut ESYS_CONTEXT,
        keyHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        digest: *const TPM2B_DIGEST,
        inScheme: *const TPMT_SIG_SCHEME,
        validation: *const TPMT_TK_HASHCHECK,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Sign_Finish(
        esysContext: *mut ESYS_CONTEXT,
        signature: *mut *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_SetCommandCodeAuditStatus(
        esysContext: *mut ESYS_CONTEXT,
        auth: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        auditAlg: TPMI_ALG_HASH,
        setList: *const TPML_CC,
        clearList: *const TPML_CC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_SetCommandCodeAuditStatus_Async(
        esysContext: *mut ESYS_CONTEXT,
        auth: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        auditAlg: TPMI_ALG_HASH,
        setList: *const TPML_CC,
        clearList: *const TPML_CC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_SetCommandCodeAuditStatus_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PCR_Extend(
        esysContext: *mut ESYS_CONTEXT,
        pcrHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        digests: *const TPML_DIGEST_VALUES,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PCR_Extend_Async(
        esysContext: *mut ESYS_CONTEXT,
        pcrHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        digests: *const TPML_DIGEST_VALUES,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PCR_Extend_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PCR_Event(
        esysContext: *mut ESYS_CONTEXT,
        pcrHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        eventData: *const TPM2B_EVENT,
        digests: *mut *mut TPML_DIGEST_VALUES,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PCR_Event_Async(
        esysContext: *mut ESYS_CONTEXT,
        pcrHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        eventData: *const TPM2B_EVENT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PCR_Event_Finish(
        esysContext: *mut ESYS_CONTEXT,
        digests: *mut *mut TPML_DIGEST_VALUES,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PCR_Read(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        pcrSelectionIn: *const TPML_PCR_SELECTION,
        pcrUpdateCounter: *mut UINT32,
        pcrSelectionOut: *mut *mut TPML_PCR_SELECTION,
        pcrValues: *mut *mut TPML_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PCR_Read_Async(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        pcrSelectionIn: *const TPML_PCR_SELECTION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PCR_Read_Finish(
        esysContext: *mut ESYS_CONTEXT,
        pcrUpdateCounter: *mut UINT32,
        pcrSelectionOut: *mut *mut TPML_PCR_SELECTION,
        pcrValues: *mut *mut TPML_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PCR_Allocate(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        pcrAllocation: *const TPML_PCR_SELECTION,
        allocationSuccess: *mut TPMI_YES_NO,
        maxPCR: *mut UINT32,
        sizeNeeded: *mut UINT32,
        sizeAvailable: *mut UINT32,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PCR_Allocate_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        pcrAllocation: *const TPML_PCR_SELECTION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PCR_Allocate_Finish(
        esysContext: *mut ESYS_CONTEXT,
        allocationSuccess: *mut TPMI_YES_NO,
        maxPCR: *mut UINT32,
        sizeNeeded: *mut UINT32,
        sizeAvailable: *mut UINT32,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PCR_SetAuthPolicy(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        authPolicy: *const TPM2B_DIGEST,
        hashAlg: TPMI_ALG_HASH,
        pcrNum: TPMI_DH_PCR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PCR_SetAuthPolicy_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        authPolicy: *const TPM2B_DIGEST,
        hashAlg: TPMI_ALG_HASH,
        pcrNum: TPMI_DH_PCR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PCR_SetAuthPolicy_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PCR_SetAuthValue(
        esysContext: *mut ESYS_CONTEXT,
        pcrHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        auth: *const TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PCR_SetAuthValue_Async(
        esysContext: *mut ESYS_CONTEXT,
        pcrHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        auth: *const TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PCR_SetAuthValue_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PCR_Reset(
        esysContext: *mut ESYS_CONTEXT,
        pcrHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PCR_Reset_Async(
        esysContext: *mut ESYS_CONTEXT,
        pcrHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PCR_Reset_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicySigned(
        esysContext: *mut ESYS_CONTEXT,
        authObject: ESYS_TR,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        nonceTPM: *const TPM2B_NONCE,
        cpHashA: *const TPM2B_DIGEST,
        policyRef: *const TPM2B_NONCE,
        expiration: INT32,
        auth: *const TPMT_SIGNATURE,
        timeout: *mut *mut TPM2B_TIMEOUT,
        policyTicket: *mut *mut TPMT_TK_AUTH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicySigned_Async(
        esysContext: *mut ESYS_CONTEXT,
        authObject: ESYS_TR,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        nonceTPM: *const TPM2B_NONCE,
        cpHashA: *const TPM2B_DIGEST,
        policyRef: *const TPM2B_NONCE,
        expiration: INT32,
        auth: *const TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicySigned_Finish(
        esysContext: *mut ESYS_CONTEXT,
        timeout: *mut *mut TPM2B_TIMEOUT,
        policyTicket: *mut *mut TPMT_TK_AUTH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicySecret(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        nonceTPM: *const TPM2B_NONCE,
        cpHashA: *const TPM2B_DIGEST,
        policyRef: *const TPM2B_NONCE,
        expiration: INT32,
        timeout: *mut *mut TPM2B_TIMEOUT,
        policyTicket: *mut *mut TPMT_TK_AUTH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicySecret_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        nonceTPM: *const TPM2B_NONCE,
        cpHashA: *const TPM2B_DIGEST,
        policyRef: *const TPM2B_NONCE,
        expiration: INT32,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicySecret_Finish(
        esysContext: *mut ESYS_CONTEXT,
        timeout: *mut *mut TPM2B_TIMEOUT,
        policyTicket: *mut *mut TPMT_TK_AUTH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyTicket(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        timeout: *const TPM2B_TIMEOUT,
        cpHashA: *const TPM2B_DIGEST,
        policyRef: *const TPM2B_NONCE,
        authName: *const TPM2B_NAME,
        ticket: *const TPMT_TK_AUTH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyTicket_Async(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        timeout: *const TPM2B_TIMEOUT,
        cpHashA: *const TPM2B_DIGEST,
        policyRef: *const TPM2B_NONCE,
        authName: *const TPM2B_NAME,
        ticket: *const TPMT_TK_AUTH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyTicket_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyOR(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        pHashList: *const TPML_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyOR_Async(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        pHashList: *const TPML_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyOR_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyPCR(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        pcrDigest: *const TPM2B_DIGEST,
        pcrs: *const TPML_PCR_SELECTION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyPCR_Async(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        pcrDigest: *const TPM2B_DIGEST,
        pcrs: *const TPML_PCR_SELECTION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyPCR_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyLocality(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        locality: TPMA_LOCALITY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyLocality_Async(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        locality: TPMA_LOCALITY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyLocality_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyNV(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        operandB: *const TPM2B_OPERAND,
        offset: UINT16,
        operation: TPM2_EO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyNV_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        operandB: *const TPM2B_OPERAND,
        offset: UINT16,
        operation: TPM2_EO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyNV_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyCounterTimer(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        operandB: *const TPM2B_OPERAND,
        offset: UINT16,
        operation: TPM2_EO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyCounterTimer_Async(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        operandB: *const TPM2B_OPERAND,
        offset: UINT16,
        operation: TPM2_EO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyCounterTimer_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyCommandCode(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        code: TPM2_CC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyCommandCode_Async(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        code: TPM2_CC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyCommandCode_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyPhysicalPresence(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyPhysicalPresence_Async(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyPhysicalPresence_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyCpHash(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        cpHashA: *const TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyCpHash_Async(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        cpHashA: *const TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyCpHash_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyNameHash(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        nameHash: *const TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyNameHash_Async(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        nameHash: *const TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyNameHash_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyDuplicationSelect(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        objectName: *const TPM2B_NAME,
        newParentName: *const TPM2B_NAME,
        includeObject: TPMI_YES_NO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyDuplicationSelect_Async(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        objectName: *const TPM2B_NAME,
        newParentName: *const TPM2B_NAME,
        includeObject: TPMI_YES_NO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyDuplicationSelect_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyAuthorize(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        approvedPolicy: *const TPM2B_DIGEST,
        policyRef: *const TPM2B_NONCE,
        keySign: *const TPM2B_NAME,
        checkTicket: *const TPMT_TK_VERIFIED,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyAuthorize_Async(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        approvedPolicy: *const TPM2B_DIGEST,
        policyRef: *const TPM2B_NONCE,
        keySign: *const TPM2B_NAME,
        checkTicket: *const TPMT_TK_VERIFIED,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyAuthorize_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyAuthValue(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyAuthValue_Async(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyAuthValue_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyPassword(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyPassword_Async(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyPassword_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyGetDigest(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        policyDigest: *mut *mut TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyGetDigest_Async(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyGetDigest_Finish(
        esysContext: *mut ESYS_CONTEXT,
        policyDigest: *mut *mut TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyNvWritten(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        writtenSet: TPMI_YES_NO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyNvWritten_Async(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        writtenSet: TPMI_YES_NO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyNvWritten_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyTemplate(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        templateHash: *const TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyTemplate_Async(
        esysContext: *mut ESYS_CONTEXT,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        templateHash: *const TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyTemplate_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyAuthorizeNV(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyAuthorizeNV_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        policySession: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PolicyAuthorizeNV_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_CreatePrimary(
        esysContext: *mut ESYS_CONTEXT,
        primaryHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inSensitive: *const TPM2B_SENSITIVE_CREATE,
        inPublic: *const TPM2B_PUBLIC,
        outsideInfo: *const TPM2B_DATA,
        creationPCR: *const TPML_PCR_SELECTION,
        objectHandle: *mut ESYS_TR,
        outPublic: *mut *mut TPM2B_PUBLIC,
        creationData: *mut *mut TPM2B_CREATION_DATA,
        creationHash: *mut *mut TPM2B_DIGEST,
        creationTicket: *mut *mut TPMT_TK_CREATION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_CreatePrimary_Async(
        esysContext: *mut ESYS_CONTEXT,
        primaryHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inSensitive: *const TPM2B_SENSITIVE_CREATE,
        inPublic: *const TPM2B_PUBLIC,
        outsideInfo: *const TPM2B_DATA,
        creationPCR: *const TPML_PCR_SELECTION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_CreatePrimary_Finish(
        esysContext: *mut ESYS_CONTEXT,
        objectHandle: *mut ESYS_TR,
        outPublic: *mut *mut TPM2B_PUBLIC,
        creationData: *mut *mut TPM2B_CREATION_DATA,
        creationHash: *mut *mut TPM2B_DIGEST,
        creationTicket: *mut *mut TPMT_TK_CREATION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_HierarchyControl(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        enable: TPMI_RH_ENABLES,
        state: TPMI_YES_NO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_HierarchyControl_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        enable: TPMI_RH_ENABLES,
        state: TPMI_YES_NO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_HierarchyControl_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_SetPrimaryPolicy(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        authPolicy: *const TPM2B_DIGEST,
        hashAlg: TPMI_ALG_HASH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_SetPrimaryPolicy_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        authPolicy: *const TPM2B_DIGEST,
        hashAlg: TPMI_ALG_HASH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_SetPrimaryPolicy_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ChangePPS(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ChangePPS_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ChangePPS_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ChangeEPS(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ChangeEPS_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ChangeEPS_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Clear(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Clear_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Clear_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ClearControl(
        esysContext: *mut ESYS_CONTEXT,
        auth: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        disable: TPMI_YES_NO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ClearControl_Async(
        esysContext: *mut ESYS_CONTEXT,
        auth: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        disable: TPMI_YES_NO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ClearControl_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_HierarchyChangeAuth(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        newAuth: *const TPM2B_AUTH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_HierarchyChangeAuth_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        newAuth: *const TPM2B_AUTH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_HierarchyChangeAuth_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_DictionaryAttackLockReset(
        esysContext: *mut ESYS_CONTEXT,
        lockHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_DictionaryAttackLockReset_Async(
        esysContext: *mut ESYS_CONTEXT,
        lockHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_DictionaryAttackLockReset_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_DictionaryAttackParameters(
        esysContext: *mut ESYS_CONTEXT,
        lockHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        newMaxTries: UINT32,
        newRecoveryTime: UINT32,
        lockoutRecovery: UINT32,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_DictionaryAttackParameters_Async(
        esysContext: *mut ESYS_CONTEXT,
        lockHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        newMaxTries: UINT32,
        newRecoveryTime: UINT32,
        lockoutRecovery: UINT32,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_DictionaryAttackParameters_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PP_Commands(
        esysContext: *mut ESYS_CONTEXT,
        auth: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        setList: *const TPML_CC,
        clearList: *const TPML_CC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PP_Commands_Async(
        esysContext: *mut ESYS_CONTEXT,
        auth: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        setList: *const TPML_CC,
        clearList: *const TPML_CC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_PP_Commands_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_SetAlgorithmSet(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        algorithmSet: UINT32,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_SetAlgorithmSet_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        algorithmSet: UINT32,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_SetAlgorithmSet_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_FieldUpgradeStart(
        esysContext: *mut ESYS_CONTEXT,
        authorization: ESYS_TR,
        keyHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        fuDigest: *const TPM2B_DIGEST,
        manifestSignature: *const TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_FieldUpgradeStart_Async(
        esysContext: *mut ESYS_CONTEXT,
        authorization: ESYS_TR,
        keyHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        fuDigest: *const TPM2B_DIGEST,
        manifestSignature: *const TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_FieldUpgradeStart_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_FieldUpgradeData(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        fuData: *const TPM2B_MAX_BUFFER,
        nextDigest: *mut *mut TPMT_HA,
        firstDigest: *mut *mut TPMT_HA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_FieldUpgradeData_Async(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        fuData: *const TPM2B_MAX_BUFFER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_FieldUpgradeData_Finish(
        esysContext: *mut ESYS_CONTEXT,
        nextDigest: *mut *mut TPMT_HA,
        firstDigest: *mut *mut TPMT_HA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_FirmwareRead(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        sequenceNumber: UINT32,
        fuData: *mut *mut TPM2B_MAX_BUFFER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_FirmwareRead_Async(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        sequenceNumber: UINT32,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_FirmwareRead_Finish(
        esysContext: *mut ESYS_CONTEXT,
        fuData: *mut *mut TPM2B_MAX_BUFFER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ContextSave(
        esysContext: *mut ESYS_CONTEXT,
        saveHandle: ESYS_TR,
        context: *mut *mut TPMS_CONTEXT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ContextSave_Async(esysContext: *mut ESYS_CONTEXT, saveHandle: ESYS_TR) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ContextSave_Finish(
        esysContext: *mut ESYS_CONTEXT,
        context: *mut *mut TPMS_CONTEXT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ContextLoad(
        esysContext: *mut ESYS_CONTEXT,
        context: *const TPMS_CONTEXT,
        loadedHandle: *mut ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ContextLoad_Async(
        esysContext: *mut ESYS_CONTEXT,
        context: *const TPMS_CONTEXT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ContextLoad_Finish(
        esysContext: *mut ESYS_CONTEXT,
        loadedHandle: *mut ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_FlushContext(esysContext: *mut ESYS_CONTEXT, flushHandle: ESYS_TR) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_FlushContext_Async(esysContext: *mut ESYS_CONTEXT, flushHandle: ESYS_TR)
        -> TSS2_RC;
}
extern "C" {
    pub fn Esys_FlushContext_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_EvictControl(
        esysContext: *mut ESYS_CONTEXT,
        auth: ESYS_TR,
        objectHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        persistentHandle: TPMI_DH_PERSISTENT,
        newObjectHandle: *mut ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_EvictControl_Async(
        esysContext: *mut ESYS_CONTEXT,
        auth: ESYS_TR,
        objectHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        persistentHandle: TPMI_DH_PERSISTENT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_EvictControl_Finish(
        esysContext: *mut ESYS_CONTEXT,
        newObjectHandle: *mut ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ReadClock(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        currentTime: *mut *mut TPMS_TIME_INFO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ReadClock_Async(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ReadClock_Finish(
        esysContext: *mut ESYS_CONTEXT,
        currentTime: *mut *mut TPMS_TIME_INFO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ClockSet(
        esysContext: *mut ESYS_CONTEXT,
        auth: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        newTime: UINT64,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ClockSet_Async(
        esysContext: *mut ESYS_CONTEXT,
        auth: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        newTime: UINT64,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ClockSet_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ClockRateAdjust(
        esysContext: *mut ESYS_CONTEXT,
        auth: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        rateAdjust: TPM2_CLOCK_ADJUST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ClockRateAdjust_Async(
        esysContext: *mut ESYS_CONTEXT,
        auth: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        rateAdjust: TPM2_CLOCK_ADJUST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_ClockRateAdjust_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_GetCapability(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        capability: TPM2_CAP,
        property: UINT32,
        propertyCount: UINT32,
        moreData: *mut TPMI_YES_NO,
        capabilityData: *mut *mut TPMS_CAPABILITY_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_GetCapability_Async(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        capability: TPM2_CAP,
        property: UINT32,
        propertyCount: UINT32,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_GetCapability_Finish(
        esysContext: *mut ESYS_CONTEXT,
        moreData: *mut TPMI_YES_NO,
        capabilityData: *mut *mut TPMS_CAPABILITY_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_TestParms(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        parameters: *const TPMT_PUBLIC_PARMS,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_TestParms_Async(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        parameters: *const TPMT_PUBLIC_PARMS,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_TestParms_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_DefineSpace(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        auth: *const TPM2B_AUTH,
        publicInfo: *const TPM2B_NV_PUBLIC,
        nvHandle: *mut ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_DefineSpace_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        auth: *const TPM2B_AUTH,
        publicInfo: *const TPM2B_NV_PUBLIC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_DefineSpace_Finish(
        esysContext: *mut ESYS_CONTEXT,
        nvHandle: *mut ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_UndefineSpace(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_UndefineSpace_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_UndefineSpace_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_UndefineSpaceSpecial(
        esysContext: *mut ESYS_CONTEXT,
        nvIndex: ESYS_TR,
        platform: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_UndefineSpaceSpecial_Async(
        esysContext: *mut ESYS_CONTEXT,
        nvIndex: ESYS_TR,
        platform: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_UndefineSpaceSpecial_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_ReadPublic(
        esysContext: *mut ESYS_CONTEXT,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        nvPublic: *mut *mut TPM2B_NV_PUBLIC,
        nvName: *mut *mut TPM2B_NAME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_ReadPublic_Async(
        esysContext: *mut ESYS_CONTEXT,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_ReadPublic_Finish(
        esysContext: *mut ESYS_CONTEXT,
        nvPublic: *mut *mut TPM2B_NV_PUBLIC,
        nvName: *mut *mut TPM2B_NAME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_Write(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        data: *const TPM2B_MAX_NV_BUFFER,
        offset: UINT16,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_Write_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        data: *const TPM2B_MAX_NV_BUFFER,
        offset: UINT16,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_Write_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_Increment(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_Increment_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_Increment_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_Extend(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        data: *const TPM2B_MAX_NV_BUFFER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_Extend_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        data: *const TPM2B_MAX_NV_BUFFER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_Extend_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_SetBits(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        bits: UINT64,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_SetBits_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        bits: UINT64,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_SetBits_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_WriteLock(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_WriteLock_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_WriteLock_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_GlobalWriteLock(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_GlobalWriteLock_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_GlobalWriteLock_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_Read(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        size: UINT16,
        offset: UINT16,
        data: *mut *mut TPM2B_MAX_NV_BUFFER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_Read_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        size: UINT16,
        offset: UINT16,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_Read_Finish(
        esysContext: *mut ESYS_CONTEXT,
        data: *mut *mut TPM2B_MAX_NV_BUFFER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_ReadLock(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_ReadLock_Async(
        esysContext: *mut ESYS_CONTEXT,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_ReadLock_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_ChangeAuth(
        esysContext: *mut ESYS_CONTEXT,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        newAuth: *const TPM2B_AUTH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_ChangeAuth_Async(
        esysContext: *mut ESYS_CONTEXT,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        newAuth: *const TPM2B_AUTH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_ChangeAuth_Finish(esysContext: *mut ESYS_CONTEXT) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_Certify(
        esysContext: *mut ESYS_CONTEXT,
        signHandle: ESYS_TR,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
        size: UINT16,
        offset: UINT16,
        certifyInfo: *mut *mut TPM2B_ATTEST,
        signature: *mut *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_Certify_Async(
        esysContext: *mut ESYS_CONTEXT,
        signHandle: ESYS_TR,
        authHandle: ESYS_TR,
        nvIndex: ESYS_TR,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        qualifyingData: *const TPM2B_DATA,
        inScheme: *const TPMT_SIG_SCHEME,
        size: UINT16,
        offset: UINT16,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_NV_Certify_Finish(
        esysContext: *mut ESYS_CONTEXT,
        certifyInfo: *mut *mut TPM2B_ATTEST,
        signature: *mut *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Vendor_TCG_Test(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inputData: *const TPM2B_DATA,
        outputData: *mut *mut TPM2B_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Vendor_TCG_Test_Async(
        esysContext: *mut ESYS_CONTEXT,
        shandle1: ESYS_TR,
        shandle2: ESYS_TR,
        shandle3: ESYS_TR,
        inputData: *const TPM2B_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Vendor_TCG_Test_Finish(
        esysContext: *mut ESYS_CONTEXT,
        outputData: *mut *mut TPM2B_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Esys_Free(__ptr: *mut ::std::os::raw::c_void);
}
pub type __darwin_nl_item = ::std::os::raw::c_int;
pub type __darwin_wctrans_t = ::std::os::raw::c_int;
pub type __darwin_wctype_t = __uint32_t;
extern "C" {
    pub fn imaxabs(j: intmax_t) -> intmax_t;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct imaxdiv_t {
    pub quot: intmax_t,
    pub rem: intmax_t,
}
#[test]
fn bindgen_test_layout_imaxdiv_t() {
    assert_eq!(
        ::std::mem::size_of::<imaxdiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(imaxdiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<imaxdiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(imaxdiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaxdiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(imaxdiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<imaxdiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(imaxdiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub fn imaxdiv(__numer: intmax_t, __denom: intmax_t) -> imaxdiv_t;
}
extern "C" {
    pub fn strtoimax(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> intmax_t;
}
extern "C" {
    pub fn strtoumax(
        __nptr: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> uintmax_t;
}
extern "C" {
    pub fn wcstoimax(
        __nptr: *const wchar_t,
        __endptr: *mut *mut wchar_t,
        __base: ::std::os::raw::c_int,
    ) -> intmax_t;
}
extern "C" {
    pub fn wcstoumax(
        __nptr: *const wchar_t,
        __endptr: *mut *mut wchar_t,
        __base: ::std::os::raw::c_int,
    ) -> uintmax_t;
}
pub const idtype_t_P_ALL: idtype_t = 0;
pub const idtype_t_P_PID: idtype_t = 1;
pub const idtype_t_P_PGID: idtype_t = 2;
pub type idtype_t = ::std::os::raw::c_uint;
pub type pid_t = __darwin_pid_t;
pub type id_t = __darwin_id_t;
pub type sig_atomic_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_i386_thread_state {
    pub __eax: ::std::os::raw::c_uint,
    pub __ebx: ::std::os::raw::c_uint,
    pub __ecx: ::std::os::raw::c_uint,
    pub __edx: ::std::os::raw::c_uint,
    pub __edi: ::std::os::raw::c_uint,
    pub __esi: ::std::os::raw::c_uint,
    pub __ebp: ::std::os::raw::c_uint,
    pub __esp: ::std::os::raw::c_uint,
    pub __ss: ::std::os::raw::c_uint,
    pub __eflags: ::std::os::raw::c_uint,
    pub __eip: ::std::os::raw::c_uint,
    pub __cs: ::std::os::raw::c_uint,
    pub __ds: ::std::os::raw::c_uint,
    pub __es: ::std::os::raw::c_uint,
    pub __fs: ::std::os::raw::c_uint,
    pub __gs: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___darwin_i386_thread_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_thread_state>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_i386_thread_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_thread_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_thread_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__eax as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ebx as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ebx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ecx as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ecx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__edx as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__edx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__edi as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__edi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__esi as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__esi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ebp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ebp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__esp as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__esp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ss as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__eflags as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eflags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__eip as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__eip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__cs as *const _ as usize },
        44usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__cs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__ds as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__ds)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__es as *const _ as usize },
        52usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__fs as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__fs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_i386_thread_state>())).__gs as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_thread_state),
            "::",
            stringify!(__gs)
        )
    );
}
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_fp_control {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[test]
fn bindgen_test_layout___darwin_fp_control() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_fp_control>(),
        2usize,
        concat!("Size of: ", stringify!(__darwin_fp_control))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_fp_control>(),
        2usize,
        concat!("Alignment of ", stringify!(__darwin_fp_control))
    );
}
impl __darwin_fp_control {
    #[inline]
    pub fn __invalid(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___invalid(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __denorm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___denorm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __zdiv(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___zdiv(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __ovrfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___ovrfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __undfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___undfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __precis(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___precis(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __pc(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set___pc(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn __rc(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set___rc(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __invalid: ::std::os::raw::c_ushort,
        __denorm: ::std::os::raw::c_ushort,
        __zdiv: ::std::os::raw::c_ushort,
        __ovrfl: ::std::os::raw::c_ushort,
        __undfl: ::std::os::raw::c_ushort,
        __precis: ::std::os::raw::c_ushort,
        __pc: ::std::os::raw::c_ushort,
        __rc: ::std::os::raw::c_ushort,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __invalid: u16 = unsafe { ::std::mem::transmute(__invalid) };
            __invalid as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __denorm: u16 = unsafe { ::std::mem::transmute(__denorm) };
            __denorm as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __zdiv: u16 = unsafe { ::std::mem::transmute(__zdiv) };
            __zdiv as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let __ovrfl: u16 = unsafe { ::std::mem::transmute(__ovrfl) };
            __ovrfl as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let __undfl: u16 = unsafe { ::std::mem::transmute(__undfl) };
            __undfl as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let __precis: u16 = unsafe { ::std::mem::transmute(__precis) };
            __precis as u64
        });
        __bindgen_bitfield_unit.set(8usize, 2u8, {
            let __pc: u16 = unsafe { ::std::mem::transmute(__pc) };
            __pc as u64
        });
        __bindgen_bitfield_unit.set(10usize, 2u8, {
            let __rc: u16 = unsafe { ::std::mem::transmute(__rc) };
            __rc as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type __darwin_fp_control_t = __darwin_fp_control;
#[repr(C)]
#[repr(align(2))]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_fp_status {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[test]
fn bindgen_test_layout___darwin_fp_status() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_fp_status>(),
        2usize,
        concat!("Size of: ", stringify!(__darwin_fp_status))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_fp_status>(),
        2usize,
        concat!("Alignment of ", stringify!(__darwin_fp_status))
    );
}
impl __darwin_fp_status {
    #[inline]
    pub fn __invalid(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___invalid(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __denorm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___denorm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __zdiv(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___zdiv(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __ovrfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___ovrfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __undfl(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___undfl(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __precis(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___precis(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __stkflt(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___stkflt(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __errsumm(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___errsumm(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c0(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c0(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c1(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c1(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __c2(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c2(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __tos(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 3u8) as u16) }
    }
    #[inline]
    pub fn set___tos(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn __c3(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___c3(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __busy(&self) -> ::std::os::raw::c_ushort {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set___busy(&mut self, val: ::std::os::raw::c_ushort) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __invalid: ::std::os::raw::c_ushort,
        __denorm: ::std::os::raw::c_ushort,
        __zdiv: ::std::os::raw::c_ushort,
        __ovrfl: ::std::os::raw::c_ushort,
        __undfl: ::std::os::raw::c_ushort,
        __precis: ::std::os::raw::c_ushort,
        __stkflt: ::std::os::raw::c_ushort,
        __errsumm: ::std::os::raw::c_ushort,
        __c0: ::std::os::raw::c_ushort,
        __c1: ::std::os::raw::c_ushort,
        __c2: ::std::os::raw::c_ushort,
        __tos: ::std::os::raw::c_ushort,
        __c3: ::std::os::raw::c_ushort,
        __busy: ::std::os::raw::c_ushort,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __invalid: u16 = unsafe { ::std::mem::transmute(__invalid) };
            __invalid as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __denorm: u16 = unsafe { ::std::mem::transmute(__denorm) };
            __denorm as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __zdiv: u16 = unsafe { ::std::mem::transmute(__zdiv) };
            __zdiv as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let __ovrfl: u16 = unsafe { ::std::mem::transmute(__ovrfl) };
            __ovrfl as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let __undfl: u16 = unsafe { ::std::mem::transmute(__undfl) };
            __undfl as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let __precis: u16 = unsafe { ::std::mem::transmute(__precis) };
            __precis as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let __stkflt: u16 = unsafe { ::std::mem::transmute(__stkflt) };
            __stkflt as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let __errsumm: u16 = unsafe { ::std::mem::transmute(__errsumm) };
            __errsumm as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let __c0: u16 = unsafe { ::std::mem::transmute(__c0) };
            __c0 as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let __c1: u16 = unsafe { ::std::mem::transmute(__c1) };
            __c1 as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let __c2: u16 = unsafe { ::std::mem::transmute(__c2) };
            __c2 as u64
        });
        __bindgen_bitfield_unit.set(11usize, 3u8, {
            let __tos: u16 = unsafe { ::std::mem::transmute(__tos) };
            __tos as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let __c3: u16 = unsafe { ::std::mem::transmute(__c3) };
            __c3 as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let __busy: u16 = unsafe { ::std::mem::transmute(__busy) };
            __busy as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type __darwin_fp_status_t = __darwin_fp_status;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_mmst_reg {
    pub __mmst_reg: [::std::os::raw::c_char; 10usize],
    pub __mmst_rsrv: [::std::os::raw::c_char; 6usize],
}
#[test]
fn bindgen_test_layout___darwin_mmst_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mmst_reg>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_mmst_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mmst_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_mmst_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mmst_reg>())).__mmst_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mmst_reg),
            "::",
            stringify!(__mmst_reg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mmst_reg>())).__mmst_rsrv as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mmst_reg),
            "::",
            stringify!(__mmst_rsrv)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_xmm_reg {
    pub __xmm_reg: [::std::os::raw::c_char; 16usize],
}
#[test]
fn bindgen_test_layout___darwin_xmm_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_xmm_reg>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_xmm_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_xmm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_xmm_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_xmm_reg>())).__xmm_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_xmm_reg),
            "::",
            stringify!(__xmm_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_ymm_reg {
    pub __ymm_reg: [::std::os::raw::c_char; 32usize],
}
#[test]
fn bindgen_test_layout___darwin_ymm_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_ymm_reg>(),
        32usize,
        concat!("Size of: ", stringify!(__darwin_ymm_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_ymm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_ymm_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ymm_reg>())).__ymm_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ymm_reg),
            "::",
            stringify!(__ymm_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_zmm_reg {
    pub __zmm_reg: [::std::os::raw::c_char; 64usize],
}
#[test]
fn bindgen_test_layout___darwin_zmm_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_zmm_reg>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_zmm_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_zmm_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_zmm_reg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_zmm_reg>())).__zmm_reg as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_zmm_reg),
            "::",
            stringify!(__zmm_reg)
        )
    );
}
impl Default for __darwin_zmm_reg {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_opmask_reg {
    pub __opmask_reg: [::std::os::raw::c_char; 8usize],
}
#[test]
fn bindgen_test_layout___darwin_opmask_reg() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_opmask_reg>(),
        8usize,
        concat!("Size of: ", stringify!(__darwin_opmask_reg))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_opmask_reg>(),
        1usize,
        concat!("Alignment of ", stringify!(__darwin_opmask_reg))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_opmask_reg>())).__opmask_reg as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_opmask_reg),
            "::",
            stringify!(__opmask_reg)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_float_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_i386_float_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_float_state>(),
        524usize,
        concat!("Size of: ", stringify!(__darwin_i386_float_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_float_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_float_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_rsrv4 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_float_state>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_float_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
}
impl Default for __darwin_i386_float_state {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_avx_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_i386_avx_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_avx_state>(),
        716usize,
        concat!("Size of: ", stringify!(__darwin_i386_avx_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_avx_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_avx_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_mxcsrmask as *const _ as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_rsrv4 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_reserved1 as *const _ as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__avx_reserved1 as *const _ as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx_state>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx_state),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
}
impl Default for __darwin_i386_avx_state {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_i386_avx512_state {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 224usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_k0: __darwin_opmask_reg,
    pub __fpu_k1: __darwin_opmask_reg,
    pub __fpu_k2: __darwin_opmask_reg,
    pub __fpu_k3: __darwin_opmask_reg,
    pub __fpu_k4: __darwin_opmask_reg,
    pub __fpu_k5: __darwin_opmask_reg,
    pub __fpu_k6: __darwin_opmask_reg,
    pub __fpu_k7: __darwin_opmask_reg,
    pub __fpu_zmmh0: __darwin_ymm_reg,
    pub __fpu_zmmh1: __darwin_ymm_reg,
    pub __fpu_zmmh2: __darwin_ymm_reg,
    pub __fpu_zmmh3: __darwin_ymm_reg,
    pub __fpu_zmmh4: __darwin_ymm_reg,
    pub __fpu_zmmh5: __darwin_ymm_reg,
    pub __fpu_zmmh6: __darwin_ymm_reg,
    pub __fpu_zmmh7: __darwin_ymm_reg,
}
#[test]
fn bindgen_test_layout___darwin_i386_avx512_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_avx512_state>(),
        1036usize,
        concat!("Size of: ", stringify!(__darwin_i386_avx512_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_avx512_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_avx512_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_rsrv4 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__avx_reserved1 as *const _
                as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k0 as *const _ as usize
        },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k1 as *const _ as usize
        },
        724usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k2 as *const _ as usize
        },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k3 as *const _ as usize
        },
        740usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k4 as *const _ as usize
        },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k5 as *const _ as usize
        },
        756usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k6 as *const _ as usize
        },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_k7 as *const _ as usize
        },
        772usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_k7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh0 as *const _ as usize
        },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh1 as *const _ as usize
        },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh2 as *const _ as usize
        },
        844usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh3 as *const _ as usize
        },
        876usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh4 as *const _ as usize
        },
        908usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh5 as *const _ as usize
        },
        940usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh6 as *const _ as usize
        },
        972usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_avx512_state>())).__fpu_zmmh7 as *const _ as usize
        },
        1004usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_avx512_state),
            "::",
            stringify!(__fpu_zmmh7)
        )
    );
}
impl Default for __darwin_i386_avx512_state {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_i386_exception_state {
    pub __trapno: __uint16_t,
    pub __cpu: __uint16_t,
    pub __err: __uint32_t,
    pub __faultvaddr: __uint32_t,
}
#[test]
fn bindgen_test_layout___darwin_i386_exception_state() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_i386_exception_state>(),
        12usize,
        concat!("Size of: ", stringify!(__darwin_i386_exception_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_i386_exception_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_i386_exception_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__trapno as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__trapno)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__cpu as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__cpu)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__err as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__err)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_i386_exception_state>())).__faultvaddr as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_i386_exception_state),
            "::",
            stringify!(__faultvaddr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_x86_debug_state32 {
    pub __dr0: ::std::os::raw::c_uint,
    pub __dr1: ::std::os::raw::c_uint,
    pub __dr2: ::std::os::raw::c_uint,
    pub __dr3: ::std::os::raw::c_uint,
    pub __dr4: ::std::os::raw::c_uint,
    pub __dr5: ::std::os::raw::c_uint,
    pub __dr6: ::std::os::raw::c_uint,
    pub __dr7: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___darwin_x86_debug_state32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_debug_state32>(),
        32usize,
        concat!("Size of: ", stringify!(__darwin_x86_debug_state32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_debug_state32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_debug_state32))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr0 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr1 as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr2 as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr3 as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr4 as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr5 as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr6 as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state32>())).__dr7 as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state32),
            "::",
            stringify!(__dr7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __x86_instruction_state {
    pub __insn_stream_valid_bytes: ::std::os::raw::c_int,
    pub __insn_offset: ::std::os::raw::c_int,
    pub __out_of_synch: ::std::os::raw::c_int,
    pub __insn_bytes: [__uint8_t; 2380usize],
    pub __insn_cacheline: [__uint8_t; 64usize],
}
#[test]
fn bindgen_test_layout___x86_instruction_state() {
    assert_eq!(
        ::std::mem::size_of::<__x86_instruction_state>(),
        2456usize,
        concat!("Size of: ", stringify!(__x86_instruction_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__x86_instruction_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__x86_instruction_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__x86_instruction_state>())).__insn_stream_valid_bytes
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_instruction_state),
            "::",
            stringify!(__insn_stream_valid_bytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__x86_instruction_state>())).__insn_offset as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_instruction_state),
            "::",
            stringify!(__insn_offset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__x86_instruction_state>())).__out_of_synch as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_instruction_state),
            "::",
            stringify!(__out_of_synch)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__x86_instruction_state>())).__insn_bytes as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_instruction_state),
            "::",
            stringify!(__insn_bytes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__x86_instruction_state>())).__insn_cacheline as *const _
                as usize
        },
        2392usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_instruction_state),
            "::",
            stringify!(__insn_cacheline)
        )
    );
}
impl Default for __x86_instruction_state {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __last_branch_record {
    pub __from_ip: __uint64_t,
    pub __to_ip: __uint64_t,
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub __bindgen_padding_0: u32,
}
#[test]
fn bindgen_test_layout___last_branch_record() {
    assert_eq!(
        ::std::mem::size_of::<__last_branch_record>(),
        24usize,
        concat!("Size of: ", stringify!(__last_branch_record))
    );
    assert_eq!(
        ::std::mem::align_of::<__last_branch_record>(),
        8usize,
        concat!("Alignment of ", stringify!(__last_branch_record))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__last_branch_record>())).__from_ip as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__last_branch_record),
            "::",
            stringify!(__from_ip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__last_branch_record>())).__to_ip as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__last_branch_record),
            "::",
            stringify!(__to_ip)
        )
    );
}
impl __last_branch_record {
    #[inline]
    pub fn __mispredict(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___mispredict(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __tsx_abort(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___tsx_abort(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __in_tsx(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___in_tsx(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __cycle_count(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set___cycle_count(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn __reserved(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(19usize, 13u8) as u32) }
    }
    #[inline]
    pub fn set___reserved(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(19usize, 13u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __mispredict: __uint32_t,
        __tsx_abort: __uint32_t,
        __in_tsx: __uint32_t,
        __cycle_count: __uint32_t,
        __reserved: __uint32_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __mispredict: u32 = unsafe { ::std::mem::transmute(__mispredict) };
            __mispredict as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __tsx_abort: u32 = unsafe { ::std::mem::transmute(__tsx_abort) };
            __tsx_abort as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let __in_tsx: u32 = unsafe { ::std::mem::transmute(__in_tsx) };
            __in_tsx as u64
        });
        __bindgen_bitfield_unit.set(3usize, 16u8, {
            let __cycle_count: u32 = unsafe { ::std::mem::transmute(__cycle_count) };
            __cycle_count as u64
        });
        __bindgen_bitfield_unit.set(19usize, 13u8, {
            let __reserved: u32 = unsafe { ::std::mem::transmute(__reserved) };
            __reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __last_branch_state {
    pub __lbr_count: ::std::os::raw::c_int,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub __lbrs: [__last_branch_record; 32usize],
}
#[test]
fn bindgen_test_layout___last_branch_state() {
    assert_eq!(
        ::std::mem::size_of::<__last_branch_state>(),
        776usize,
        concat!("Size of: ", stringify!(__last_branch_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__last_branch_state>(),
        8usize,
        concat!("Alignment of ", stringify!(__last_branch_state))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__last_branch_state>())).__lbr_count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__last_branch_state),
            "::",
            stringify!(__lbr_count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__last_branch_state>())).__lbrs as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__last_branch_state),
            "::",
            stringify!(__lbrs)
        )
    );
}
impl __last_branch_state {
    #[inline]
    pub fn __lbr_supported_tsx(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___lbr_supported_tsx(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __lbr_supported_cycle_count(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set___lbr_supported_cycle_count(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn __reserved(&self) -> __uint32_t {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 30u8) as u32) }
    }
    #[inline]
    pub fn set___reserved(&mut self, val: __uint32_t) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 30u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        __lbr_supported_tsx: __uint32_t,
        __lbr_supported_cycle_count: __uint32_t,
        __reserved: __uint32_t,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let __lbr_supported_tsx: u32 = unsafe { ::std::mem::transmute(__lbr_supported_tsx) };
            __lbr_supported_tsx as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let __lbr_supported_cycle_count: u32 =
                unsafe { ::std::mem::transmute(__lbr_supported_cycle_count) };
            __lbr_supported_cycle_count as u64
        });
        __bindgen_bitfield_unit.set(2usize, 30u8, {
            let __reserved: u32 = unsafe { ::std::mem::transmute(__reserved) };
            __reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __x86_pagein_state {
    pub __pagein_error: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___x86_pagein_state() {
    assert_eq!(
        ::std::mem::size_of::<__x86_pagein_state>(),
        4usize,
        concat!("Size of: ", stringify!(__x86_pagein_state))
    );
    assert_eq!(
        ::std::mem::align_of::<__x86_pagein_state>(),
        4usize,
        concat!("Alignment of ", stringify!(__x86_pagein_state))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__x86_pagein_state>())).__pagein_error as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__x86_pagein_state),
            "::",
            stringify!(__pagein_error)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_x86_thread_state64 {
    pub __rax: __uint64_t,
    pub __rbx: __uint64_t,
    pub __rcx: __uint64_t,
    pub __rdx: __uint64_t,
    pub __rdi: __uint64_t,
    pub __rsi: __uint64_t,
    pub __rbp: __uint64_t,
    pub __rsp: __uint64_t,
    pub __r8: __uint64_t,
    pub __r9: __uint64_t,
    pub __r10: __uint64_t,
    pub __r11: __uint64_t,
    pub __r12: __uint64_t,
    pub __r13: __uint64_t,
    pub __r14: __uint64_t,
    pub __r15: __uint64_t,
    pub __rip: __uint64_t,
    pub __rflags: __uint64_t,
    pub __cs: __uint64_t,
    pub __fs: __uint64_t,
    pub __gs: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_thread_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_thread_state64>(),
        168usize,
        concat!("Size of: ", stringify!(__darwin_x86_thread_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_thread_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_thread_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rax as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rax)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rbx as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rbx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rcx as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rcx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rdx as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rdx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rdi as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rdi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rsi as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rsi)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rbp as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rbp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rsp as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rsp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r8 as *const _ as usize
        },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r9 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r10 as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r11 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r12 as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r13 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r14 as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__r15 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__r15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rip as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__rflags as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__rflags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__cs as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__fs as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__fs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_state64>())).__gs as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_state64),
            "::",
            stringify!(__gs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_x86_thread_full_state64 {
    pub __ss64: __darwin_x86_thread_state64,
    pub __ds: __uint64_t,
    pub __es: __uint64_t,
    pub __ss: __uint64_t,
    pub __gsbase: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_thread_full_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_thread_full_state64>(),
        200usize,
        concat!("Size of: ", stringify!(__darwin_x86_thread_full_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_thread_full_state64>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__darwin_x86_thread_full_state64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__ss64 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ss64)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__ds as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__es as *const _ as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__ss as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_thread_full_state64>())).__gsbase as *const _
                as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_thread_full_state64),
            "::",
            stringify!(__gsbase)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_float_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_x86_float_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_float_state64>(),
        524usize,
        concat!("Size of: ", stringify!(__darwin_x86_float_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_float_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_float_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm8 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm9 as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm10 as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm11 as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm12 as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm13 as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm14 as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_xmm15 as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_rsrv4 as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_float_state64>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_float_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
}
impl Default for __darwin_x86_float_state64 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_avx_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_ymmh8: __darwin_xmm_reg,
    pub __fpu_ymmh9: __darwin_xmm_reg,
    pub __fpu_ymmh10: __darwin_xmm_reg,
    pub __fpu_ymmh11: __darwin_xmm_reg,
    pub __fpu_ymmh12: __darwin_xmm_reg,
    pub __fpu_ymmh13: __darwin_xmm_reg,
    pub __fpu_ymmh14: __darwin_xmm_reg,
    pub __fpu_ymmh15: __darwin_xmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_x86_avx_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_avx_state64>(),
        844usize,
        concat!("Size of: ", stringify!(__darwin_x86_avx_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_avx_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_avx_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_reserved as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm8 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm9 as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm10 as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm11 as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm12 as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm13 as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm14 as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_xmm15 as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_rsrv4 as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__avx_reserved1 as *const _
                as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh8 as *const _ as usize
        },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh9 as *const _ as usize
        },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh10 as *const _ as usize
        },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh11 as *const _ as usize
        },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh12 as *const _ as usize
        },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh13 as *const _ as usize
        },
        796usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh14 as *const _ as usize
        },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx_state64>())).__fpu_ymmh15 as *const _ as usize
        },
        828usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx_state64),
            "::",
            stringify!(__fpu_ymmh15)
        )
    );
}
impl Default for __darwin_x86_avx_state64 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_x86_avx512_state64 {
    pub __fpu_reserved: [::std::os::raw::c_int; 2usize],
    pub __fpu_fcw: __darwin_fp_control,
    pub __fpu_fsw: __darwin_fp_status,
    pub __fpu_ftw: __uint8_t,
    pub __fpu_rsrv1: __uint8_t,
    pub __fpu_fop: __uint16_t,
    pub __fpu_ip: __uint32_t,
    pub __fpu_cs: __uint16_t,
    pub __fpu_rsrv2: __uint16_t,
    pub __fpu_dp: __uint32_t,
    pub __fpu_ds: __uint16_t,
    pub __fpu_rsrv3: __uint16_t,
    pub __fpu_mxcsr: __uint32_t,
    pub __fpu_mxcsrmask: __uint32_t,
    pub __fpu_stmm0: __darwin_mmst_reg,
    pub __fpu_stmm1: __darwin_mmst_reg,
    pub __fpu_stmm2: __darwin_mmst_reg,
    pub __fpu_stmm3: __darwin_mmst_reg,
    pub __fpu_stmm4: __darwin_mmst_reg,
    pub __fpu_stmm5: __darwin_mmst_reg,
    pub __fpu_stmm6: __darwin_mmst_reg,
    pub __fpu_stmm7: __darwin_mmst_reg,
    pub __fpu_xmm0: __darwin_xmm_reg,
    pub __fpu_xmm1: __darwin_xmm_reg,
    pub __fpu_xmm2: __darwin_xmm_reg,
    pub __fpu_xmm3: __darwin_xmm_reg,
    pub __fpu_xmm4: __darwin_xmm_reg,
    pub __fpu_xmm5: __darwin_xmm_reg,
    pub __fpu_xmm6: __darwin_xmm_reg,
    pub __fpu_xmm7: __darwin_xmm_reg,
    pub __fpu_xmm8: __darwin_xmm_reg,
    pub __fpu_xmm9: __darwin_xmm_reg,
    pub __fpu_xmm10: __darwin_xmm_reg,
    pub __fpu_xmm11: __darwin_xmm_reg,
    pub __fpu_xmm12: __darwin_xmm_reg,
    pub __fpu_xmm13: __darwin_xmm_reg,
    pub __fpu_xmm14: __darwin_xmm_reg,
    pub __fpu_xmm15: __darwin_xmm_reg,
    pub __fpu_rsrv4: [::std::os::raw::c_char; 96usize],
    pub __fpu_reserved1: ::std::os::raw::c_int,
    pub __avx_reserved1: [::std::os::raw::c_char; 64usize],
    pub __fpu_ymmh0: __darwin_xmm_reg,
    pub __fpu_ymmh1: __darwin_xmm_reg,
    pub __fpu_ymmh2: __darwin_xmm_reg,
    pub __fpu_ymmh3: __darwin_xmm_reg,
    pub __fpu_ymmh4: __darwin_xmm_reg,
    pub __fpu_ymmh5: __darwin_xmm_reg,
    pub __fpu_ymmh6: __darwin_xmm_reg,
    pub __fpu_ymmh7: __darwin_xmm_reg,
    pub __fpu_ymmh8: __darwin_xmm_reg,
    pub __fpu_ymmh9: __darwin_xmm_reg,
    pub __fpu_ymmh10: __darwin_xmm_reg,
    pub __fpu_ymmh11: __darwin_xmm_reg,
    pub __fpu_ymmh12: __darwin_xmm_reg,
    pub __fpu_ymmh13: __darwin_xmm_reg,
    pub __fpu_ymmh14: __darwin_xmm_reg,
    pub __fpu_ymmh15: __darwin_xmm_reg,
    pub __fpu_k0: __darwin_opmask_reg,
    pub __fpu_k1: __darwin_opmask_reg,
    pub __fpu_k2: __darwin_opmask_reg,
    pub __fpu_k3: __darwin_opmask_reg,
    pub __fpu_k4: __darwin_opmask_reg,
    pub __fpu_k5: __darwin_opmask_reg,
    pub __fpu_k6: __darwin_opmask_reg,
    pub __fpu_k7: __darwin_opmask_reg,
    pub __fpu_zmmh0: __darwin_ymm_reg,
    pub __fpu_zmmh1: __darwin_ymm_reg,
    pub __fpu_zmmh2: __darwin_ymm_reg,
    pub __fpu_zmmh3: __darwin_ymm_reg,
    pub __fpu_zmmh4: __darwin_ymm_reg,
    pub __fpu_zmmh5: __darwin_ymm_reg,
    pub __fpu_zmmh6: __darwin_ymm_reg,
    pub __fpu_zmmh7: __darwin_ymm_reg,
    pub __fpu_zmmh8: __darwin_ymm_reg,
    pub __fpu_zmmh9: __darwin_ymm_reg,
    pub __fpu_zmmh10: __darwin_ymm_reg,
    pub __fpu_zmmh11: __darwin_ymm_reg,
    pub __fpu_zmmh12: __darwin_ymm_reg,
    pub __fpu_zmmh13: __darwin_ymm_reg,
    pub __fpu_zmmh14: __darwin_ymm_reg,
    pub __fpu_zmmh15: __darwin_ymm_reg,
    pub __fpu_zmm16: __darwin_zmm_reg,
    pub __fpu_zmm17: __darwin_zmm_reg,
    pub __fpu_zmm18: __darwin_zmm_reg,
    pub __fpu_zmm19: __darwin_zmm_reg,
    pub __fpu_zmm20: __darwin_zmm_reg,
    pub __fpu_zmm21: __darwin_zmm_reg,
    pub __fpu_zmm22: __darwin_zmm_reg,
    pub __fpu_zmm23: __darwin_zmm_reg,
    pub __fpu_zmm24: __darwin_zmm_reg,
    pub __fpu_zmm25: __darwin_zmm_reg,
    pub __fpu_zmm26: __darwin_zmm_reg,
    pub __fpu_zmm27: __darwin_zmm_reg,
    pub __fpu_zmm28: __darwin_zmm_reg,
    pub __fpu_zmm29: __darwin_zmm_reg,
    pub __fpu_zmm30: __darwin_zmm_reg,
    pub __fpu_zmm31: __darwin_zmm_reg,
}
#[test]
fn bindgen_test_layout___darwin_x86_avx512_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_avx512_state64>(),
        2444usize,
        concat!("Size of: ", stringify!(__darwin_x86_avx512_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_avx512_state64>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_x86_avx512_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_reserved as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_reserved)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_fcw as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fcw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_fsw as *const _ as usize
        },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fsw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ftw as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ftw)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv1 as *const _ as usize
        },
        13usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_fop as *const _ as usize
        },
        14usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_fop)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ip as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_cs as *const _ as usize
        },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_cs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv2 as *const _ as usize
        },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_dp as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_dp)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ds as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ds)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv3 as *const _ as usize
        },
        30usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_mxcsr as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_mxcsr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_mxcsrmask as *const _
                as usize
        },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_mxcsrmask)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm0 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm1 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm2 as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm3 as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm4 as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm5 as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm6 as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_stmm7 as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_stmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm0 as *const _ as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm1 as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm2 as *const _ as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm3 as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm4 as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm5 as *const _ as usize
        },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm6 as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm7 as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm8 as *const _ as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm9 as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm10 as *const _ as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm11 as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm12 as *const _ as usize
        },
        360usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm13 as *const _ as usize
        },
        376usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm14 as *const _ as usize
        },
        392usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_xmm15 as *const _ as usize
        },
        408usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_xmm15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_rsrv4 as *const _ as usize
        },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_rsrv4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_reserved1 as *const _
                as usize
        },
        520usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__avx_reserved1 as *const _
                as usize
        },
        524usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__avx_reserved1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh0 as *const _ as usize
        },
        588usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh1 as *const _ as usize
        },
        604usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh2 as *const _ as usize
        },
        620usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh3 as *const _ as usize
        },
        636usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh4 as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh5 as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh6 as *const _ as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh7 as *const _ as usize
        },
        700usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh8 as *const _ as usize
        },
        716usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh9 as *const _ as usize
        },
        732usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh10 as *const _
                as usize
        },
        748usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh11 as *const _
                as usize
        },
        764usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh12 as *const _
                as usize
        },
        780usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh13 as *const _
                as usize
        },
        796usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh14 as *const _
                as usize
        },
        812usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_ymmh15 as *const _
                as usize
        },
        828usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_ymmh15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k0 as *const _ as usize
        },
        844usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k1 as *const _ as usize
        },
        852usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k2 as *const _ as usize
        },
        860usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k3 as *const _ as usize
        },
        868usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k4 as *const _ as usize
        },
        876usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k5 as *const _ as usize
        },
        884usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k6 as *const _ as usize
        },
        892usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_k7 as *const _ as usize
        },
        900usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_k7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh0 as *const _ as usize
        },
        908usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh1 as *const _ as usize
        },
        940usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh2 as *const _ as usize
        },
        972usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh3 as *const _ as usize
        },
        1004usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh4 as *const _ as usize
        },
        1036usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh5 as *const _ as usize
        },
        1068usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh6 as *const _ as usize
        },
        1100usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh7 as *const _ as usize
        },
        1132usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh8 as *const _ as usize
        },
        1164usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh8)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh9 as *const _ as usize
        },
        1196usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh9)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh10 as *const _
                as usize
        },
        1228usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh10)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh11 as *const _
                as usize
        },
        1260usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh11)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh12 as *const _
                as usize
        },
        1292usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh12)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh13 as *const _
                as usize
        },
        1324usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh13)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh14 as *const _
                as usize
        },
        1356usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh14)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmmh15 as *const _
                as usize
        },
        1388usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmmh15)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm16 as *const _ as usize
        },
        1420usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm16)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm17 as *const _ as usize
        },
        1484usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm17)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm18 as *const _ as usize
        },
        1548usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm18)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm19 as *const _ as usize
        },
        1612usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm19)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm20 as *const _ as usize
        },
        1676usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm20)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm21 as *const _ as usize
        },
        1740usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm21)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm22 as *const _ as usize
        },
        1804usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm22)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm23 as *const _ as usize
        },
        1868usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm23)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm24 as *const _ as usize
        },
        1932usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm24)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm25 as *const _ as usize
        },
        1996usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm25)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm26 as *const _ as usize
        },
        2060usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm26)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm27 as *const _ as usize
        },
        2124usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm27)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm28 as *const _ as usize
        },
        2188usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm28)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm29 as *const _ as usize
        },
        2252usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm29)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm30 as *const _ as usize
        },
        2316usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm30)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_avx512_state64>())).__fpu_zmm31 as *const _ as usize
        },
        2380usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_avx512_state64),
            "::",
            stringify!(__fpu_zmm31)
        )
    );
}
impl Default for __darwin_x86_avx512_state64 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_x86_exception_state64 {
    pub __trapno: __uint16_t,
    pub __cpu: __uint16_t,
    pub __err: __uint32_t,
    pub __faultvaddr: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_exception_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_exception_state64>(),
        16usize,
        concat!("Size of: ", stringify!(__darwin_x86_exception_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_exception_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_exception_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__trapno as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__trapno)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__cpu as *const _ as usize
        },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__cpu)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__err as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__err)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_exception_state64>())).__faultvaddr as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_exception_state64),
            "::",
            stringify!(__faultvaddr)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_x86_debug_state64 {
    pub __dr0: __uint64_t,
    pub __dr1: __uint64_t,
    pub __dr2: __uint64_t,
    pub __dr3: __uint64_t,
    pub __dr4: __uint64_t,
    pub __dr5: __uint64_t,
    pub __dr6: __uint64_t,
    pub __dr7: __uint64_t,
}
#[test]
fn bindgen_test_layout___darwin_x86_debug_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_debug_state64>(),
        64usize,
        concat!("Size of: ", stringify!(__darwin_x86_debug_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_debug_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_debug_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr0 as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr0)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr1 as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr2 as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr3 as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr4 as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr5 as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr6 as *const _ as usize
        },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_debug_state64>())).__dr7 as *const _ as usize
        },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_debug_state64),
            "::",
            stringify!(__dr7)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct __darwin_x86_cpmu_state64 {
    pub __ctrs: [__uint64_t; 16usize],
}
#[test]
fn bindgen_test_layout___darwin_x86_cpmu_state64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_x86_cpmu_state64>(),
        128usize,
        concat!("Size of: ", stringify!(__darwin_x86_cpmu_state64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_x86_cpmu_state64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_x86_cpmu_state64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_x86_cpmu_state64>())).__ctrs as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_x86_cpmu_state64),
            "::",
            stringify!(__ctrs)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_float_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext32>(),
        600usize,
        concat!("Size of: ", stringify!(__darwin_mcontext32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext32))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext32>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext32>())).__ss as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext32>())).__fs as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext32),
            "::",
            stringify!(__fs)
        )
    );
}
impl Default for __darwin_mcontext32 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_avx_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx32>(),
        792usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx32))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx32>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx32>())).__ss as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx32>())).__fs as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx32),
            "::",
            stringify!(__fs)
        )
    );
}
impl Default for __darwin_mcontext_avx32 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx512_32 {
    pub __es: __darwin_i386_exception_state,
    pub __ss: __darwin_i386_thread_state,
    pub __fs: __darwin_i386_avx512_state,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx512_32() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx512_32>(),
        1112usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx512_32))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx512_32>(),
        4usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx512_32))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_32>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_32),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_32>())).__ss as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_32),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_32>())).__fs as *const _ as usize
        },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_32),
            "::",
            stringify!(__fs)
        )
    );
}
impl Default for __darwin_mcontext_avx512_32 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_float_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext64>(),
        712usize,
        concat!("Size of: ", stringify!(__darwin_mcontext64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64>())).__ss as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64>())).__fs as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64),
            "::",
            stringify!(__fs)
        )
    );
}
impl Default for __darwin_mcontext64 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_float_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext64_full() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext64_full>(),
        744usize,
        concat!("Size of: ", stringify!(__darwin_mcontext64_full))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext64_full>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext64_full))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64_full>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64_full),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64_full>())).__ss as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64_full),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext64_full>())).__fs as *const _ as usize },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext64_full),
            "::",
            stringify!(__fs)
        )
    );
}
impl Default for __darwin_mcontext64_full {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_avx_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx64>(),
        1032usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx64))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx64>())).__es as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx64>())).__ss as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_mcontext_avx64>())).__fs as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64),
            "::",
            stringify!(__fs)
        )
    );
}
impl Default for __darwin_mcontext_avx64 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_avx_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx64_full() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx64_full>(),
        1064usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx64_full))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx64_full>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx64_full))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx64_full>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64_full),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx64_full>())).__ss as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64_full),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx64_full>())).__fs as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx64_full),
            "::",
            stringify!(__fs)
        )
    );
}
impl Default for __darwin_mcontext_avx64_full {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx512_64 {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_state64,
    pub __fs: __darwin_x86_avx512_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx512_64() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx512_64>(),
        2632usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx512_64))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx512_64>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_mcontext_avx512_64))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64>())).__ss as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64>())).__fs as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64),
            "::",
            stringify!(__fs)
        )
    );
}
impl Default for __darwin_mcontext_avx512_64 {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_mcontext_avx512_64_full {
    pub __es: __darwin_x86_exception_state64,
    pub __ss: __darwin_x86_thread_full_state64,
    pub __fs: __darwin_x86_avx512_state64,
}
#[test]
fn bindgen_test_layout___darwin_mcontext_avx512_64_full() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_mcontext_avx512_64_full>(),
        2664usize,
        concat!("Size of: ", stringify!(__darwin_mcontext_avx512_64_full))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_mcontext_avx512_64_full>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(__darwin_mcontext_avx512_64_full)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64_full>())).__es as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64_full),
            "::",
            stringify!(__es)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64_full>())).__ss as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64_full),
            "::",
            stringify!(__ss)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__darwin_mcontext_avx512_64_full>())).__fs as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_mcontext_avx512_64_full),
            "::",
            stringify!(__fs)
        )
    );
}
impl Default for __darwin_mcontext_avx512_64_full {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type mcontext_t = *mut __darwin_mcontext64;
pub type pthread_attr_t = __darwin_pthread_attr_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_sigaltstack {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_size: __darwin_size_t,
    pub ss_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___darwin_sigaltstack() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_sigaltstack>(),
        24usize,
        concat!("Size of: ", stringify!(__darwin_sigaltstack))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_sigaltstack>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_sigaltstack))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_sigaltstack>())).ss_sp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_sigaltstack>())).ss_size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_sigaltstack>())).ss_flags as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_sigaltstack),
            "::",
            stringify!(ss_flags)
        )
    );
}
impl Default for __darwin_sigaltstack {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type stack_t = __darwin_sigaltstack;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __darwin_ucontext {
    pub uc_onstack: ::std::os::raw::c_int,
    pub uc_sigmask: __darwin_sigset_t,
    pub uc_stack: __darwin_sigaltstack,
    pub uc_link: *mut __darwin_ucontext,
    pub uc_mcsize: __darwin_size_t,
    pub uc_mcontext: *mut __darwin_mcontext64,
}
#[test]
fn bindgen_test_layout___darwin_ucontext() {
    assert_eq!(
        ::std::mem::size_of::<__darwin_ucontext>(),
        56usize,
        concat!("Size of: ", stringify!(__darwin_ucontext))
    );
    assert_eq!(
        ::std::mem::align_of::<__darwin_ucontext>(),
        8usize,
        concat!("Alignment of ", stringify!(__darwin_ucontext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_onstack as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_onstack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_sigmask as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_sigmask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_stack as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_link as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_link)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_mcsize as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_mcsize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__darwin_ucontext>())).uc_mcontext as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__darwin_ucontext),
            "::",
            stringify!(uc_mcontext)
        )
    );
}
impl Default for __darwin_ucontext {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type ucontext_t = __darwin_ucontext;
pub type sigset_t = __darwin_sigset_t;
pub type uid_t = __darwin_uid_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigval {
    pub sival_int: ::std::os::raw::c_int,
    pub sival_ptr: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_sigval() {
    assert_eq!(
        ::std::mem::size_of::<sigval>(),
        8usize,
        concat!("Size of: ", stringify!(sigval))
    );
    assert_eq!(
        ::std::mem::align_of::<sigval>(),
        8usize,
        concat!("Alignment of ", stringify!(sigval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigval>())).sival_int as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_int)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigval>())).sival_ptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_ptr)
        )
    );
}
impl Default for sigval {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigevent {
    pub sigev_notify: ::std::os::raw::c_int,
    pub sigev_signo: ::std::os::raw::c_int,
    pub sigev_value: sigval,
    pub sigev_notify_function: ::std::option::Option<unsafe extern "C" fn(arg1: sigval)>,
    pub sigev_notify_attributes: *mut pthread_attr_t,
}
#[test]
fn bindgen_test_layout_sigevent() {
    assert_eq!(
        ::std::mem::size_of::<sigevent>(),
        32usize,
        concat!("Size of: ", stringify!(sigevent))
    );
    assert_eq!(
        ::std::mem::align_of::<sigevent>(),
        8usize,
        concat!("Alignment of ", stringify!(sigevent))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_notify as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_signo as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_signo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_value as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_notify_function as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify_function)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigevent>())).sigev_notify_attributes as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify_attributes)
        )
    );
}
impl Default for sigevent {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __siginfo {
    pub si_signo: ::std::os::raw::c_int,
    pub si_errno: ::std::os::raw::c_int,
    pub si_code: ::std::os::raw::c_int,
    pub si_pid: pid_t,
    pub si_uid: uid_t,
    pub si_status: ::std::os::raw::c_int,
    pub si_addr: *mut ::std::os::raw::c_void,
    pub si_value: sigval,
    pub si_band: ::std::os::raw::c_long,
    pub __pad: [::std::os::raw::c_ulong; 7usize],
}
#[test]
fn bindgen_test_layout___siginfo() {
    assert_eq!(
        ::std::mem::size_of::<__siginfo>(),
        104usize,
        concat!("Size of: ", stringify!(__siginfo))
    );
    assert_eq!(
        ::std::mem::align_of::<__siginfo>(),
        8usize,
        concat!("Alignment of ", stringify!(__siginfo))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_signo as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_signo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_errno as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_errno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_code as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_pid as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_pid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_uid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_status as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_addr as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_value as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).si_band as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(si_band)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__siginfo>())).__pad as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__siginfo),
            "::",
            stringify!(__pad)
        )
    );
}
impl Default for __siginfo {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type siginfo_t = __siginfo;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __sigaction_u {
    pub __sa_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub __sa_sigaction: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut __siginfo,
            arg3: *mut ::std::os::raw::c_void,
        ),
    >,
}
#[test]
fn bindgen_test_layout___sigaction_u() {
    assert_eq!(
        ::std::mem::size_of::<__sigaction_u>(),
        8usize,
        concat!("Size of: ", stringify!(__sigaction_u))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigaction_u>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigaction_u))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction_u>())).__sa_handler as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction_u),
            "::",
            stringify!(__sa_handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction_u>())).__sa_sigaction as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction_u),
            "::",
            stringify!(__sa_sigaction)
        )
    );
}
impl Default for __sigaction_u {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_tramp: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: ::std::os::raw::c_int,
            arg3: ::std::os::raw::c_int,
            arg4: *mut siginfo_t,
            arg5: *mut ::std::os::raw::c_void,
        ),
    >,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___sigaction() {
    assert_eq!(
        ::std::mem::size_of::<__sigaction>(),
        24usize,
        concat!("Size of: ", stringify!(__sigaction))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigaction>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigaction))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).__sigaction_u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(__sigaction_u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).sa_tramp as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(sa_tramp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).sa_mask as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(sa_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigaction>())).sa_flags as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigaction),
            "::",
            stringify!(sa_flags)
        )
    );
}
impl Default for __sigaction {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigaction {
    pub __sigaction_u: __sigaction_u,
    pub sa_mask: sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigaction() {
    assert_eq!(
        ::std::mem::size_of::<sigaction>(),
        16usize,
        concat!("Size of: ", stringify!(sigaction))
    );
    assert_eq!(
        ::std::mem::align_of::<sigaction>(),
        8usize,
        concat!("Alignment of ", stringify!(sigaction))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).__sigaction_u as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(__sigaction_u)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_flags)
        )
    );
}
impl Default for sigaction {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
pub type sig_t = ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct sigvec {
    pub sv_handler: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    pub sv_mask: ::std::os::raw::c_int,
    pub sv_flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigvec() {
    assert_eq!(
        ::std::mem::size_of::<sigvec>(),
        16usize,
        concat!("Size of: ", stringify!(sigvec))
    );
    assert_eq!(
        ::std::mem::align_of::<sigvec>(),
        8usize,
        concat!("Alignment of ", stringify!(sigvec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_handler as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigvec>())).sv_flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigvec),
            "::",
            stringify!(sv_flags)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigstack {
    pub ss_sp: *mut ::std::os::raw::c_char,
    pub ss_onstack: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigstack() {
    assert_eq!(
        ::std::mem::size_of::<sigstack>(),
        16usize,
        concat!("Size of: ", stringify!(sigstack))
    );
    assert_eq!(
        ::std::mem::align_of::<sigstack>(),
        8usize,
        concat!("Alignment of ", stringify!(sigstack))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigstack>())).ss_sp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigstack),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigstack>())).ss_onstack as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigstack),
            "::",
            stringify!(ss_onstack)
        )
    );
}
impl Default for sigstack {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn signal(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ) -> ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
        ),
    >;
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __darwin_time_t,
    pub tv_usec: __darwin_suseconds_t,
}
#[test]
fn bindgen_test_layout_timeval() {
    assert_eq!(
        ::std::mem::size_of::<timeval>(),
        16usize,
        concat!("Size of: ", stringify!(timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_usec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_usec)
        )
    );
}
pub type rlim_t = __uint64_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rusage {
    pub ru_utime: timeval,
    pub ru_stime: timeval,
    pub ru_maxrss: ::std::os::raw::c_long,
    pub ru_ixrss: ::std::os::raw::c_long,
    pub ru_idrss: ::std::os::raw::c_long,
    pub ru_isrss: ::std::os::raw::c_long,
    pub ru_minflt: ::std::os::raw::c_long,
    pub ru_majflt: ::std::os::raw::c_long,
    pub ru_nswap: ::std::os::raw::c_long,
    pub ru_inblock: ::std::os::raw::c_long,
    pub ru_oublock: ::std::os::raw::c_long,
    pub ru_msgsnd: ::std::os::raw::c_long,
    pub ru_msgrcv: ::std::os::raw::c_long,
    pub ru_nsignals: ::std::os::raw::c_long,
    pub ru_nvcsw: ::std::os::raw::c_long,
    pub ru_nivcsw: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_rusage() {
    assert_eq!(
        ::std::mem::size_of::<rusage>(),
        144usize,
        concat!("Size of: ", stringify!(rusage))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_utime as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_utime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_stime as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_stime)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_maxrss as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_maxrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_ixrss as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_ixrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_idrss as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_idrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_isrss as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_isrss)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_minflt as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_minflt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_majflt as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_majflt)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nswap as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nswap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_inblock as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_inblock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_oublock as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_oublock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_msgsnd as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_msgsnd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_msgrcv as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_msgrcv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nsignals as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nsignals)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nvcsw as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nvcsw)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage>())).ru_nivcsw as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage),
            "::",
            stringify!(ru_nivcsw)
        )
    );
}
pub type rusage_info_t = *mut ::std::os::raw::c_void;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rusage_info_v0 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v0() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v0>(),
        96usize,
        concat!("Size of: ", stringify!(rusage_info_v0))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v0>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v0))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v0>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v0>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v0),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rusage_info_v1 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v1() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v1>(),
        144usize,
        concat!("Size of: ", stringify!(rusage_info_v1))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v1>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v1>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v1),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rusage_info_v2 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v2() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v2>(),
        160usize,
        concat!("Size of: ", stringify!(rusage_info_v2))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v2>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v2))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_diskio_bytesread as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_diskio_bytesread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v2>())).ri_diskio_byteswritten as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v2),
            "::",
            stringify!(ri_diskio_byteswritten)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rusage_info_v3 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
    pub ri_cpu_time_qos_default: u64,
    pub ri_cpu_time_qos_maintenance: u64,
    pub ri_cpu_time_qos_background: u64,
    pub ri_cpu_time_qos_utility: u64,
    pub ri_cpu_time_qos_legacy: u64,
    pub ri_cpu_time_qos_user_initiated: u64,
    pub ri_cpu_time_qos_user_interactive: u64,
    pub ri_billed_system_time: u64,
    pub ri_serviced_system_time: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v3() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v3>(),
        232usize,
        concat!("Size of: ", stringify!(rusage_info_v3))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v3>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v3))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_diskio_bytesread as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_diskio_bytesread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_diskio_byteswritten as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_diskio_byteswritten)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_default as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_default)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_maintenance as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_maintenance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_background as *const _
                as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_background)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_utility as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_utility)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_legacy as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_legacy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_user_initiated as *const _
                as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_user_initiated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_cpu_time_qos_user_interactive as *const _
                as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_cpu_time_qos_user_interactive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_billed_system_time as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_billed_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v3>())).ri_serviced_system_time as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v3),
            "::",
            stringify!(ri_serviced_system_time)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rusage_info_v4 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
    pub ri_cpu_time_qos_default: u64,
    pub ri_cpu_time_qos_maintenance: u64,
    pub ri_cpu_time_qos_background: u64,
    pub ri_cpu_time_qos_utility: u64,
    pub ri_cpu_time_qos_legacy: u64,
    pub ri_cpu_time_qos_user_initiated: u64,
    pub ri_cpu_time_qos_user_interactive: u64,
    pub ri_billed_system_time: u64,
    pub ri_serviced_system_time: u64,
    pub ri_logical_writes: u64,
    pub ri_lifetime_max_phys_footprint: u64,
    pub ri_instructions: u64,
    pub ri_cycles: u64,
    pub ri_billed_energy: u64,
    pub ri_serviced_energy: u64,
    pub ri_interval_max_phys_footprint: u64,
    pub ri_runnable_time: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v4() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v4>(),
        296usize,
        concat!("Size of: ", stringify!(rusage_info_v4))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v4>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v4))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_diskio_bytesread as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_diskio_bytesread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_diskio_byteswritten as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_diskio_byteswritten)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_default as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_default)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_maintenance as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_maintenance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_background as *const _
                as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_background)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_utility as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_utility)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_legacy as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_legacy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_user_initiated as *const _
                as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_user_initiated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_cpu_time_qos_user_interactive as *const _
                as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cpu_time_qos_user_interactive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_billed_system_time as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_billed_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_serviced_system_time as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_serviced_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_logical_writes as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_logical_writes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_lifetime_max_phys_footprint as *const _
                as usize
        },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_lifetime_max_phys_footprint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_instructions as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_instructions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_cycles as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_cycles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_billed_energy as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_billed_energy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_serviced_energy as *const _ as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_serviced_energy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v4>())).ri_interval_max_phys_footprint as *const _
                as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_interval_max_phys_footprint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v4>())).ri_runnable_time as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v4),
            "::",
            stringify!(ri_runnable_time)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rusage_info_v5 {
    pub ri_uuid: [u8; 16usize],
    pub ri_user_time: u64,
    pub ri_system_time: u64,
    pub ri_pkg_idle_wkups: u64,
    pub ri_interrupt_wkups: u64,
    pub ri_pageins: u64,
    pub ri_wired_size: u64,
    pub ri_resident_size: u64,
    pub ri_phys_footprint: u64,
    pub ri_proc_start_abstime: u64,
    pub ri_proc_exit_abstime: u64,
    pub ri_child_user_time: u64,
    pub ri_child_system_time: u64,
    pub ri_child_pkg_idle_wkups: u64,
    pub ri_child_interrupt_wkups: u64,
    pub ri_child_pageins: u64,
    pub ri_child_elapsed_abstime: u64,
    pub ri_diskio_bytesread: u64,
    pub ri_diskio_byteswritten: u64,
    pub ri_cpu_time_qos_default: u64,
    pub ri_cpu_time_qos_maintenance: u64,
    pub ri_cpu_time_qos_background: u64,
    pub ri_cpu_time_qos_utility: u64,
    pub ri_cpu_time_qos_legacy: u64,
    pub ri_cpu_time_qos_user_initiated: u64,
    pub ri_cpu_time_qos_user_interactive: u64,
    pub ri_billed_system_time: u64,
    pub ri_serviced_system_time: u64,
    pub ri_logical_writes: u64,
    pub ri_lifetime_max_phys_footprint: u64,
    pub ri_instructions: u64,
    pub ri_cycles: u64,
    pub ri_billed_energy: u64,
    pub ri_serviced_energy: u64,
    pub ri_interval_max_phys_footprint: u64,
    pub ri_runnable_time: u64,
    pub ri_flags: u64,
}
#[test]
fn bindgen_test_layout_rusage_info_v5() {
    assert_eq!(
        ::std::mem::size_of::<rusage_info_v5>(),
        304usize,
        concat!("Size of: ", stringify!(rusage_info_v5))
    );
    assert_eq!(
        ::std::mem::align_of::<rusage_info_v5>(),
        8usize,
        concat!("Alignment of ", stringify!(rusage_info_v5))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_uuid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_uuid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_user_time as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_user_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_system_time as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_pkg_idle_wkups as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_interrupt_wkups as *const _ as usize
        },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_pageins as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_pageins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_wired_size as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_wired_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_resident_size as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_resident_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_phys_footprint as *const _ as usize
        },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_phys_footprint)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_proc_start_abstime as *const _ as usize
        },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_proc_start_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_proc_exit_abstime as *const _ as usize
        },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_proc_exit_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_child_user_time as *const _ as usize
        },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_child_user_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_child_system_time as *const _ as usize
        },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_child_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_child_pkg_idle_wkups as *const _ as usize
        },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_child_pkg_idle_wkups)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_child_interrupt_wkups as *const _ as usize
        },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_child_interrupt_wkups)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_child_pageins as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_child_pageins)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_child_elapsed_abstime as *const _ as usize
        },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_child_elapsed_abstime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_diskio_bytesread as *const _ as usize
        },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_diskio_bytesread)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_diskio_byteswritten as *const _ as usize
        },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_diskio_byteswritten)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_cpu_time_qos_default as *const _ as usize
        },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cpu_time_qos_default)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_cpu_time_qos_maintenance as *const _
                as usize
        },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cpu_time_qos_maintenance)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_cpu_time_qos_background as *const _
                as usize
        },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cpu_time_qos_background)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_cpu_time_qos_utility as *const _ as usize
        },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cpu_time_qos_utility)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_cpu_time_qos_legacy as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cpu_time_qos_legacy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_cpu_time_qos_user_initiated as *const _
                as usize
        },
        200usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cpu_time_qos_user_initiated)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_cpu_time_qos_user_interactive as *const _
                as usize
        },
        208usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cpu_time_qos_user_interactive)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_billed_system_time as *const _ as usize
        },
        216usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_billed_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_serviced_system_time as *const _ as usize
        },
        224usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_serviced_system_time)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_logical_writes as *const _ as usize
        },
        232usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_logical_writes)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_lifetime_max_phys_footprint as *const _
                as usize
        },
        240usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_lifetime_max_phys_footprint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_instructions as *const _ as usize },
        248usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_instructions)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_cycles as *const _ as usize },
        256usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_cycles)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_billed_energy as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_billed_energy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_serviced_energy as *const _ as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_serviced_energy)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<rusage_info_v5>())).ri_interval_max_phys_footprint as *const _
                as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_interval_max_phys_footprint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_runnable_time as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_runnable_time)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rusage_info_v5>())).ri_flags as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(rusage_info_v5),
            "::",
            stringify!(ri_flags)
        )
    );
}
pub type rusage_info_current = rusage_info_v5;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct rlimit {
    pub rlim_cur: rlim_t,
    pub rlim_max: rlim_t,
}
#[test]
fn bindgen_test_layout_rlimit() {
    assert_eq!(
        ::std::mem::size_of::<rlimit>(),
        16usize,
        concat!("Size of: ", stringify!(rlimit))
    );
    assert_eq!(
        ::std::mem::align_of::<rlimit>(),
        8usize,
        concat!("Alignment of ", stringify!(rlimit))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rlimit>())).rlim_cur as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(rlimit),
            "::",
            stringify!(rlim_cur)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<rlimit>())).rlim_max as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(rlimit),
            "::",
            stringify!(rlim_max)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct proc_rlimit_control_wakeupmon {
    pub wm_flags: u32,
    pub wm_rate: i32,
}
#[test]
fn bindgen_test_layout_proc_rlimit_control_wakeupmon() {
    assert_eq!(
        ::std::mem::size_of::<proc_rlimit_control_wakeupmon>(),
        8usize,
        concat!("Size of: ", stringify!(proc_rlimit_control_wakeupmon))
    );
    assert_eq!(
        ::std::mem::align_of::<proc_rlimit_control_wakeupmon>(),
        4usize,
        concat!("Alignment of ", stringify!(proc_rlimit_control_wakeupmon))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<proc_rlimit_control_wakeupmon>())).wm_flags as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(proc_rlimit_control_wakeupmon),
            "::",
            stringify!(wm_flags)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<proc_rlimit_control_wakeupmon>())).wm_rate as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(proc_rlimit_control_wakeupmon),
            "::",
            stringify!(wm_rate)
        )
    );
}
extern "C" {
    pub fn getpriority(arg1: ::std::os::raw::c_int, arg2: id_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getiopolicy_np(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getrlimit(arg1: ::std::os::raw::c_int, arg2: *mut rlimit) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getrusage(arg1: ::std::os::raw::c_int, arg2: *mut rusage) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setpriority(
        arg1: ::std::os::raw::c_int,
        arg2: id_t,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setiopolicy_np(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setrlimit(arg1: ::std::os::raw::c_int, arg2: *const rlimit) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union wait {
    pub w_status: ::std::os::raw::c_int,
    pub w_T: wait__bindgen_ty_1,
    pub w_S: wait__bindgen_ty_2,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct wait__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_wait__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<wait__bindgen_ty_1>(),
        4usize,
        concat!("Size of: ", stringify!(wait__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<wait__bindgen_ty_1>(),
        4usize,
        concat!("Alignment of ", stringify!(wait__bindgen_ty_1))
    );
}
impl wait__bindgen_ty_1 {
    #[inline]
    pub fn w_Termsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 7u8) as u32) }
    }
    #[inline]
    pub fn set_w_Termsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 7u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Coredump(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_w_Coredump(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Retcode(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Retcode(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Filler(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_w_Filler(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        w_Termsig: ::std::os::raw::c_uint,
        w_Coredump: ::std::os::raw::c_uint,
        w_Retcode: ::std::os::raw::c_uint,
        w_Filler: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 7u8, {
            let w_Termsig: u32 = unsafe { ::std::mem::transmute(w_Termsig) };
            w_Termsig as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let w_Coredump: u32 = unsafe { ::std::mem::transmute(w_Coredump) };
            w_Coredump as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let w_Retcode: u32 = unsafe { ::std::mem::transmute(w_Retcode) };
            w_Retcode as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let w_Filler: u32 = unsafe { ::std::mem::transmute(w_Filler) };
            w_Filler as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Default, Copy, Clone)]
pub struct wait__bindgen_ty_2 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[test]
fn bindgen_test_layout_wait__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<wait__bindgen_ty_2>(),
        4usize,
        concat!("Size of: ", stringify!(wait__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<wait__bindgen_ty_2>(),
        4usize,
        concat!("Alignment of ", stringify!(wait__bindgen_ty_2))
    );
}
impl wait__bindgen_ty_2 {
    #[inline]
    pub fn w_Stopval(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Stopval(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Stopsig(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_w_Stopsig(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn w_Filler(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 16u8) as u32) }
    }
    #[inline]
    pub fn set_w_Filler(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 16u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        w_Stopval: ::std::os::raw::c_uint,
        w_Stopsig: ::std::os::raw::c_uint,
        w_Filler: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 8u8, {
            let w_Stopval: u32 = unsafe { ::std::mem::transmute(w_Stopval) };
            w_Stopval as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let w_Stopsig: u32 = unsafe { ::std::mem::transmute(w_Stopsig) };
            w_Stopsig as u64
        });
        __bindgen_bitfield_unit.set(16usize, 16u8, {
            let w_Filler: u32 = unsafe { ::std::mem::transmute(w_Filler) };
            w_Filler as u64
        });
        __bindgen_bitfield_unit
    }
}
#[test]
fn bindgen_test_layout_wait() {
    assert_eq!(
        ::std::mem::size_of::<wait>(),
        4usize,
        concat!("Size of: ", stringify!(wait))
    );
    assert_eq!(
        ::std::mem::align_of::<wait>(),
        4usize,
        concat!("Alignment of ", stringify!(wait))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_status as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(wait),
            "::",
            stringify!(w_status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_T as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(wait), "::", stringify!(w_T))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<wait>())).w_S as *const _ as usize },
        0usize,
        concat!("Offset of field: ", stringify!(wait), "::", stringify!(w_S))
    );
}
impl Default for wait {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
extern "C" {
    pub fn wait(arg1: *mut ::std::os::raw::c_int) -> pid_t;
}
extern "C" {
    pub fn waitpid(
        arg1: pid_t,
        arg2: *mut ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
    ) -> pid_t;
}
extern "C" {
    pub fn waitid(
        arg1: idtype_t,
        arg2: id_t,
        arg3: *mut siginfo_t,
        arg4: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wait3(
        arg1: *mut ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: *mut rusage,
    ) -> pid_t;
}
extern "C" {
    pub fn wait4(
        arg1: pid_t,
        arg2: *mut ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: *mut rusage,
    ) -> pid_t;
}
extern "C" {
    pub fn alloca(arg1: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
pub type ct_rune_t = __darwin_ct_rune_t;
pub type rune_t = __darwin_rune_t;
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct div_t {
    pub quot: ::std::os::raw::c_int,
    pub rem: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_div_t() {
    assert_eq!(
        ::std::mem::size_of::<div_t>(),
        8usize,
        concat!("Size of: ", stringify!(div_t))
    );
    assert_eq!(
        ::std::mem::align_of::<div_t>(),
        4usize,
        concat!("Alignment of ", stringify!(div_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<div_t>())).rem as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(div_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct ldiv_t {
    pub quot: ::std::os::raw::c_long,
    pub rem: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_ldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<ldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(ldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
#[repr(C)]
#[derive(Debug, Default, Copy, Clone)]
pub struct lldiv_t {
    pub quot: ::std::os::raw::c_longlong,
    pub rem: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_lldiv_t() {
    assert_eq!(
        ::std::mem::size_of::<lldiv_t>(),
        16usize,
        concat!("Size of: ", stringify!(lldiv_t))
    );
    assert_eq!(
        ::std::mem::align_of::<lldiv_t>(),
        8usize,
        concat!("Alignment of ", stringify!(lldiv_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).quot as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(quot)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<lldiv_t>())).rem as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(lldiv_t),
            "::",
            stringify!(rem)
        )
    );
}
extern "C" {
    pub static mut __mb_cur_max: ::std::os::raw::c_int;
}
extern "C" {
    pub fn malloc(__size: ::std::os::raw::c_ulong) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn calloc(
        __count: ::std::os::raw::c_ulong,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn free(arg1: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn realloc(
        __ptr: *mut ::std::os::raw::c_void,
        __size: ::std::os::raw::c_ulong,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn valloc(arg1: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn aligned_alloc(__alignment: size_t, __size: size_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn posix_memalign(
        __memptr: *mut *mut ::std::os::raw::c_void,
        __alignment: size_t,
        __size: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn abort();
}
extern "C" {
    pub fn abs(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atexit(arg1: ::std::option::Option<unsafe extern "C" fn()>) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atof(arg1: *const ::std::os::raw::c_char) -> f64;
}
extern "C" {
    pub fn atoi(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn atol(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn atoll(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn bsearch(
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn div(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> div_t;
}
extern "C" {
    pub fn exit(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn getenv(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn labs(arg1: ::std::os::raw::c_long) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn ldiv(arg1: ::std::os::raw::c_long, arg2: ::std::os::raw::c_long) -> ldiv_t;
}
extern "C" {
    pub fn llabs(arg1: ::std::os::raw::c_longlong) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn lldiv(arg1: ::std::os::raw::c_longlong, arg2: ::std::os::raw::c_longlong) -> lldiv_t;
}
extern "C" {
    pub fn mblen(__s: *const ::std::os::raw::c_char, __n: size_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mbstowcs(
        arg1: *mut wchar_t,
        arg2: *const ::std::os::raw::c_char,
        arg3: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn mbtowc(
        arg1: *mut wchar_t,
        arg2: *const ::std::os::raw::c_char,
        arg3: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn qsort(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn rand() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn srand(arg1: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn strtod(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> f64;
}
extern "C" {
    pub fn strtof(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> f32;
}
extern "C" {
    pub fn strtol(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn strtold(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> u128;
}
extern "C" {
    pub fn strtoll(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtoul(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn strtoull(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub fn system(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn wcstombs(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const wchar_t,
        arg3: size_t,
    ) -> size_t;
}
extern "C" {
    pub fn wctomb(arg1: *mut ::std::os::raw::c_char, arg2: wchar_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn _Exit(arg1: ::std::os::raw::c_int);
}
extern "C" {
    pub fn a64l(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn drand48() -> f64;
}
extern "C" {
    pub fn ecvt(
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn erand48(arg1: *mut ::std::os::raw::c_ushort) -> f64;
}
extern "C" {
    pub fn fcvt(
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn gcvt(
        arg1: f64,
        arg2: ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getsubopt(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *const *mut ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn grantpt(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn initstate(
        arg1: ::std::os::raw::c_uint,
        arg2: *mut ::std::os::raw::c_char,
        arg3: size_t,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn jrand48(arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn l64a(arg1: ::std::os::raw::c_long) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn lcong48(arg1: *mut ::std::os::raw::c_ushort);
}
extern "C" {
    pub fn lrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn mktemp(arg1: *mut ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn mkstemp(arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mrand48() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn nrand48(arg1: *mut ::std::os::raw::c_ushort) -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn posix_openpt(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ptsname(arg1: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn ptsname_r(
        fildes: ::std::os::raw::c_int,
        buffer: *mut ::std::os::raw::c_char,
        buflen: size_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn putenv(arg1: *mut ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn random() -> ::std::os::raw::c_long;
}
extern "C" {
    pub fn rand_r(arg1: *mut ::std::os::raw::c_uint) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_realpath$DARWIN_EXTSN"]
    pub fn realpath(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn seed48(arg1: *mut ::std::os::raw::c_ushort) -> *mut ::std::os::raw::c_ushort;
}
extern "C" {
    pub fn setenv(
        __name: *const ::std::os::raw::c_char,
        __value: *const ::std::os::raw::c_char,
        __overwrite: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn setkey(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn setstate(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn srand48(arg1: ::std::os::raw::c_long);
}
extern "C" {
    pub fn srandom(arg1: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn unlockpt(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn unsetenv(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
pub type dev_t = __darwin_dev_t;
pub type mode_t = __darwin_mode_t;
extern "C" {
    pub fn arc4random() -> u32;
}
extern "C" {
    pub fn arc4random_addrandom(arg1: *mut ::std::os::raw::c_uchar, arg2: ::std::os::raw::c_int);
}
extern "C" {
    pub fn arc4random_buf(__buf: *mut ::std::os::raw::c_void, __nbytes: size_t);
}
extern "C" {
    pub fn arc4random_stir();
}
extern "C" {
    pub fn arc4random_uniform(__upper_bound: u32) -> u32;
}
extern "C" {
    pub fn atexit_b(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn bsearch_b(
        __key: *const ::std::os::raw::c_void,
        __base: *const ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn cgetcap(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn cgetclose() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetent(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetfirst(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetmatch(
        arg1: *const ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetnext(
        arg1: *mut *mut ::std::os::raw::c_char,
        arg2: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetnum(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut ::std::os::raw::c_long,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetset(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetstr(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn cgetustr(
        arg1: *mut ::std::os::raw::c_char,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[link_name = "\u{1}_daemon$1050"]
    pub fn daemon(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn devname(arg1: dev_t, arg2: mode_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn devname_r(
        arg1: dev_t,
        arg2: mode_t,
        buf: *mut ::std::os::raw::c_char,
        len: ::std::os::raw::c_int,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getbsize(
        arg1: *mut ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_long,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn getloadavg(arg1: *mut f64, arg2: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn getprogname() -> *const ::std::os::raw::c_char;
}
extern "C" {
    pub fn setprogname(arg1: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn heapsort(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn heapsort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mergesort(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn mergesort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn psort(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *const ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn psort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn psort_r(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        arg1: *mut ::std::os::raw::c_void,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
                arg3: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn qsort_b(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        __compar: *mut ::std::os::raw::c_void,
    );
}
extern "C" {
    pub fn qsort_r(
        __base: *mut ::std::os::raw::c_void,
        __nel: size_t,
        __width: size_t,
        arg1: *mut ::std::os::raw::c_void,
        __compar: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_void,
                arg3: *const ::std::os::raw::c_void,
            ) -> ::std::os::raw::c_int,
        >,
    );
}
extern "C" {
    pub fn radixsort(
        __base: *mut *const ::std::os::raw::c_uchar,
        __nel: ::std::os::raw::c_int,
        __table: *const ::std::os::raw::c_uchar,
        __endbyte: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn rpmatch(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sradixsort(
        __base: *mut *const ::std::os::raw::c_uchar,
        __nel: ::std::os::raw::c_int,
        __table: *const ::std::os::raw::c_uchar,
        __endbyte: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sranddev();
}
extern "C" {
    pub fn srandomdev();
}
extern "C" {
    pub fn reallocf(
        __ptr: *mut ::std::os::raw::c_void,
        __size: size_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn strtonum(
        __numstr: *const ::std::os::raw::c_char,
        __minval: ::std::os::raw::c_longlong,
        __maxval: ::std::os::raw::c_longlong,
        __errstrp: *mut *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtoq(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn strtouq(
        __str: *const ::std::os::raw::c_char,
        __endptr: *mut *mut ::std::os::raw::c_char,
        __base: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_ulonglong;
}
extern "C" {
    pub static mut suboptarg: *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn Tss2_TctiLdr_Finalize(context: *mut *mut TSS2_TCTI_CONTEXT);
}
extern "C" {
    pub fn Tss2_TctiLdr_Initialize_Ex(
        name: *const ::std::os::raw::c_char,
        conf: *const ::std::os::raw::c_char,
        context: *mut *mut TSS2_TCTI_CONTEXT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_TctiLdr_Initialize(
        nameConf: *const ::std::os::raw::c_char,
        context: *mut *mut TSS2_TCTI_CONTEXT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_TctiLdr_GetInfo(
        name: *const ::std::os::raw::c_char,
        info: *mut *mut TSS2_TCTI_INFO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_TctiLdr_FreeInfo(info: *mut *mut TSS2_TCTI_INFO);
}
extern "C" {
    pub fn Tss2_MU_BYTE_Marshal(
        src: BYTE,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_BYTE_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut BYTE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_INT8_Marshal(
        src: INT8,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_INT8_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut INT8,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_INT16_Marshal(
        src: INT16,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_INT16_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut INT16,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_INT32_Marshal(
        src: INT32,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_INT32_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut INT32,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_INT64_Marshal(
        src: INT64,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_INT64_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut INT64,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_UINT8_Marshal(
        src: UINT8,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_UINT8_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut UINT8,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_UINT16_Marshal(
        src: UINT16,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_UINT16_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut UINT16,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_UINT32_Marshal(
        src: UINT32,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_UINT32_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut UINT32,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_UINT64_Marshal(
        src: UINT64,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_UINT64_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut UINT64,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2_CC_Marshal(
        src: TPM2_CC,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2_CC_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2_CC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2_ST_Marshal(
        src: TPM2_ST,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2_ST_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2_ST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMA_ALGORITHM_Marshal(
        src: TPMA_ALGORITHM,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMA_ALGORITHM_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMA_ALGORITHM,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMA_CC_Marshal(
        src: TPMA_CC,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMA_CC_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMA_CC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMA_LOCALITY_Marshal(
        src: TPMA_LOCALITY,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMA_LOCALITY_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMA_LOCALITY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMA_NV_Marshal(
        src: TPMA_NV,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMA_NV_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMA_NV,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMA_OBJECT_Marshal(
        src: TPMA_OBJECT,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMA_OBJECT_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMA_OBJECT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMA_PERMANENT_Marshal(
        src: TPMA_PERMANENT,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMA_PERMANENT_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMA_PERMANENT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMA_SESSION_Marshal(
        src: TPMA_SESSION,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMA_SESSION_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMA_SESSION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMA_STARTUP_CLEAR_Marshal(
        src: TPMA_STARTUP_CLEAR,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMA_STARTUP_CLEAR_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMA_STARTUP_CLEAR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_DIGEST_Marshal(
        src: *const TPM2B_DIGEST,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_DIGEST_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_ATTEST_Marshal(
        src: *const TPM2B_ATTEST,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_ATTEST_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_ATTEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_NAME_Marshal(
        src: *const TPM2B_NAME,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_NAME_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_NAME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_MAX_NV_BUFFER_Marshal(
        src: *const TPM2B_MAX_NV_BUFFER,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_MAX_NV_BUFFER_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_MAX_NV_BUFFER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_SENSITIVE_DATA_Marshal(
        src: *const TPM2B_SENSITIVE_DATA,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_SENSITIVE_DATA_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_SENSITIVE_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_ECC_PARAMETER_Marshal(
        src: *const TPM2B_ECC_PARAMETER,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_ECC_PARAMETER_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_ECC_PARAMETER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_PUBLIC_KEY_RSA_Marshal(
        src: *const TPM2B_PUBLIC_KEY_RSA,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_PUBLIC_KEY_RSA_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_PUBLIC_KEY_RSA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_PRIVATE_KEY_RSA_Marshal(
        src: *const TPM2B_PRIVATE_KEY_RSA,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_PRIVATE_KEY_RSA_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_PRIVATE_KEY_RSA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_PRIVATE_Marshal(
        src: *const TPM2B_PRIVATE,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_PRIVATE_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_PRIVATE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_CONTEXT_SENSITIVE_Marshal(
        src: *const TPM2B_CONTEXT_SENSITIVE,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_CONTEXT_SENSITIVE_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_CONTEXT_SENSITIVE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_CONTEXT_DATA_Marshal(
        src: *const TPM2B_CONTEXT_DATA,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_CONTEXT_DATA_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_CONTEXT_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_DATA_Marshal(
        src: *const TPM2B_DATA,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_DATA_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_SYM_KEY_Marshal(
        src: *const TPM2B_SYM_KEY,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_SYM_KEY_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_SYM_KEY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_ECC_POINT_Marshal(
        src: *const TPM2B_ECC_POINT,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_ECC_POINT_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_ECC_POINT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_NV_PUBLIC_Marshal(
        src: *const TPM2B_NV_PUBLIC,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_NV_PUBLIC_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_NV_PUBLIC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_SENSITIVE_Marshal(
        src: *const TPM2B_SENSITIVE,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_SENSITIVE_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_SENSITIVE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_SENSITIVE_CREATE_Marshal(
        src: *const TPM2B_SENSITIVE_CREATE,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_SENSITIVE_CREATE_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_SENSITIVE_CREATE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_CREATION_DATA_Marshal(
        src: *const TPM2B_CREATION_DATA,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_CREATION_DATA_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_CREATION_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_PUBLIC_Marshal(
        src: *const TPM2B_PUBLIC,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_PUBLIC_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_PUBLIC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_ENCRYPTED_SECRET_Marshal(
        src: *const TPM2B_ENCRYPTED_SECRET,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_ENCRYPTED_SECRET_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_ENCRYPTED_SECRET,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_ID_OBJECT_Marshal(
        src: *const TPM2B_ID_OBJECT,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_ID_OBJECT_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_ID_OBJECT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_IV_Marshal(
        src: *const TPM2B_IV,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_IV_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_IV,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_AUTH_Marshal(
        src: *const TPM2B_AUTH,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_AUTH_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_AUTH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_EVENT_Marshal(
        src: *const TPM2B_EVENT,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_EVENT_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_EVENT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_MAX_BUFFER_Marshal(
        src: *const TPM2B_MAX_BUFFER,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_MAX_BUFFER_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_MAX_BUFFER,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_NONCE_Marshal(
        src: *const TPM2B_NONCE,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_NONCE_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_NONCE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_OPERAND_Marshal(
        src: *const TPM2B_OPERAND,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_OPERAND_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_OPERAND,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_TIMEOUT_Marshal(
        src: *const TPM2B_TIMEOUT,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_TIMEOUT_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_TIMEOUT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_TEMPLATE_Marshal(
        src: *const TPM2B_TEMPLATE,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2B_TEMPLATE_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPM2B_TEMPLATE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_CONTEXT_Marshal(
        src: *const TPMS_CONTEXT,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_CONTEXT_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_CONTEXT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_TIME_INFO_Marshal(
        src: *const TPMS_TIME_INFO,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_TIME_INFO_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_TIME_INFO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_ECC_POINT_Marshal(
        src: *const TPMS_ECC_POINT,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_ECC_POINT_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_ECC_POINT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_NV_PUBLIC_Marshal(
        src: *const TPMS_NV_PUBLIC,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_NV_PUBLIC_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_NV_PUBLIC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_ALG_PROPERTY_Marshal(
        src: *const TPMS_ALG_PROPERTY,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_ALG_PROPERTY_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_ALG_PROPERTY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_ALGORITHM_DESCRIPTION_Marshal(
        src: *const TPMS_ALGORITHM_DESCRIPTION,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_ALGORITHM_DESCRIPTION_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_ALGORITHM_DESCRIPTION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_TAGGED_PROPERTY_Marshal(
        src: *const TPMS_TAGGED_PROPERTY,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_TAGGED_PROPERTY_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_TAGGED_PROPERTY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_TAGGED_POLICY_Marshal(
        src: *const TPMS_TAGGED_POLICY,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_TAGGED_POLICY_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_TAGGED_POLICY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_CLOCK_INFO_Marshal(
        src: *const TPMS_CLOCK_INFO,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_CLOCK_INFO_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_CLOCK_INFO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_TIME_ATTEST_INFO_Marshal(
        src: *const TPMS_TIME_ATTEST_INFO,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_TIME_ATTEST_INFO_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_TIME_ATTEST_INFO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_CERTIFY_INFO_Marshal(
        src: *const TPMS_CERTIFY_INFO,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_CERTIFY_INFO_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_CERTIFY_INFO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_COMMAND_AUDIT_INFO_Marshal(
        src: *const TPMS_COMMAND_AUDIT_INFO,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_COMMAND_AUDIT_INFO_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_COMMAND_AUDIT_INFO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_SESSION_AUDIT_INFO_Marshal(
        src: *const TPMS_SESSION_AUDIT_INFO,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_SESSION_AUDIT_INFO_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_SESSION_AUDIT_INFO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_CREATION_INFO_Marshal(
        src: *const TPMS_CREATION_INFO,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_CREATION_INFO_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_CREATION_INFO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_NV_CERTIFY_INFO_Marshal(
        src: *const TPMS_NV_CERTIFY_INFO,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_NV_CERTIFY_INFO_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_NV_CERTIFY_INFO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_AUTH_COMMAND_Marshal(
        src: *const TPMS_AUTH_COMMAND,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_AUTH_COMMAND_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_AUTH_COMMAND,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_AUTH_RESPONSE_Marshal(
        src: *const TPMS_AUTH_RESPONSE,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_AUTH_RESPONSE_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_AUTH_RESPONSE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_SENSITIVE_CREATE_Marshal(
        src: *const TPMS_SENSITIVE_CREATE,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_SENSITIVE_CREATE_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_SENSITIVE_CREATE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_SCHEME_HASH_Marshal(
        src: *const TPMS_SCHEME_HASH,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_SCHEME_HASH_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_SCHEME_HASH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_SCHEME_ECDAA_Marshal(
        src: *const TPMS_SCHEME_ECDAA,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_SCHEME_ECDAA_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_SCHEME_ECDAA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_SCHEME_XOR_Marshal(
        src: *const TPMS_SCHEME_XOR,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_SCHEME_XOR_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_SCHEME_XOR,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_SIGNATURE_RSA_Marshal(
        src: *const TPMS_SIGNATURE_RSA,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_SIGNATURE_RSA_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_SIGNATURE_RSA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_SIGNATURE_ECC_Marshal(
        src: *const TPMS_SIGNATURE_ECC,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_SIGNATURE_ECC_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_SIGNATURE_ECC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_NV_PIN_COUNTER_PARAMETERS_Marshal(
        src: *const TPMS_NV_PIN_COUNTER_PARAMETERS,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_NV_PIN_COUNTER_PARAMETERS_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_NV_PIN_COUNTER_PARAMETERS,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_CONTEXT_DATA_Marshal(
        src: *const TPMS_CONTEXT_DATA,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_CONTEXT_DATA_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_CONTEXT_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_PCR_SELECT_Marshal(
        src: *const TPMS_PCR_SELECT,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_PCR_SELECT_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_PCR_SELECT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_PCR_SELECTION_Marshal(
        src: *const TPMS_PCR_SELECTION,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_PCR_SELECTION_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_PCR_SELECTION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_TAGGED_PCR_SELECT_Marshal(
        src: *const TPMS_TAGGED_PCR_SELECT,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_TAGGED_PCR_SELECT_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_TAGGED_PCR_SELECT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_QUOTE_INFO_Marshal(
        src: *const TPMS_QUOTE_INFO,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_QUOTE_INFO_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_QUOTE_INFO,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_CREATION_DATA_Marshal(
        src: *const TPMS_CREATION_DATA,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_CREATION_DATA_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_CREATION_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_ECC_PARMS_Marshal(
        src: *const TPMS_ECC_PARMS,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_ECC_PARMS_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_ECC_PARMS,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_ATTEST_Marshal(
        src: *const TPMS_ATTEST,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_ATTEST_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_ATTEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_ALGORITHM_DETAIL_ECC_Marshal(
        src: *const TPMS_ALGORITHM_DETAIL_ECC,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_ALGORITHM_DETAIL_ECC_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_ALGORITHM_DETAIL_ECC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_CAPABILITY_DATA_Marshal(
        src: *const TPMS_CAPABILITY_DATA,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_CAPABILITY_DATA_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_CAPABILITY_DATA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_KEYEDHASH_PARMS_Marshal(
        src: *const TPMS_KEYEDHASH_PARMS,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_KEYEDHASH_PARMS_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_KEYEDHASH_PARMS,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_RSA_PARMS_Marshal(
        src: *const TPMS_RSA_PARMS,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_RSA_PARMS_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_RSA_PARMS,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_SYMCIPHER_PARMS_Marshal(
        src: *const TPMS_SYMCIPHER_PARMS,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_SYMCIPHER_PARMS_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_SYMCIPHER_PARMS,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_AC_OUTPUT_Marshal(
        src: *const TPMS_AC_OUTPUT,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_AC_OUTPUT_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_AC_OUTPUT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_ID_OBJECT_Marshal(
        src: *const TPMS_ID_OBJECT,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_ID_OBJECT_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMS_ID_OBJECT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_CC_Marshal(
        src: *const TPML_CC,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_CC_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPML_CC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_CCA_Marshal(
        src: *const TPML_CCA,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_CCA_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPML_CCA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_ALG_Marshal(
        src: *const TPML_ALG,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_ALG_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPML_ALG,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_HANDLE_Marshal(
        src: *const TPML_HANDLE,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_HANDLE_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPML_HANDLE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_DIGEST_Marshal(
        src: *const TPML_DIGEST,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_DIGEST_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPML_DIGEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_DIGEST_VALUES_Marshal(
        src: *const TPML_DIGEST_VALUES,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_DIGEST_VALUES_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPML_DIGEST_VALUES,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_PCR_SELECTION_Marshal(
        src: *const TPML_PCR_SELECTION,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_PCR_SELECTION_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPML_PCR_SELECTION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_ALG_PROPERTY_Marshal(
        src: *const TPML_ALG_PROPERTY,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_ALG_PROPERTY_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPML_ALG_PROPERTY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_ECC_CURVE_Marshal(
        src: *const TPML_ECC_CURVE,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_ECC_CURVE_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPML_ECC_CURVE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_TAGGED_PCR_PROPERTY_Marshal(
        src: *const TPML_TAGGED_PCR_PROPERTY,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_TAGGED_PCR_PROPERTY_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPML_TAGGED_PCR_PROPERTY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_TAGGED_TPM_PROPERTY_Marshal(
        src: *const TPML_TAGGED_TPM_PROPERTY,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_TAGGED_TPM_PROPERTY_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPML_TAGGED_TPM_PROPERTY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_INTEL_PTT_PROPERTY_Marshal(
        src: *const TPML_INTEL_PTT_PROPERTY,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_INTEL_PTT_PROPERTY_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPML_INTEL_PTT_PROPERTY,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_AC_CAPABILITIES_Marshal(
        src: *const TPML_AC_CAPABILITIES,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPML_AC_CAPABILITIES_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPML_AC_CAPABILITIES,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_HA_Marshal(
        src: *const TPMU_HA,
        selector_value: u32,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_HA_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        selector_value: u32,
        dest: *mut TPMU_HA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_CAPABILITIES_Marshal(
        src: *const TPMU_CAPABILITIES,
        selector_value: u32,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_CAPABILITIES_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        selector_value: u32,
        dest: *mut TPMU_CAPABILITIES,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_ATTEST_Marshal(
        src: *const TPMU_ATTEST,
        selector_value: u32,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_ATTEST_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        selector_value: u32,
        dest: *mut TPMU_ATTEST,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_SYM_KEY_BITS_Marshal(
        src: *const TPMU_SYM_KEY_BITS,
        selector_value: u32,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_SYM_KEY_BITS_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        selector_value: u32,
        dest: *mut TPMU_SYM_KEY_BITS,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_SYM_MODE_Marshal(
        src: *const TPMU_SYM_MODE,
        selector_value: u32,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_SYM_MODE_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        selector_value: u32,
        dest: *mut TPMU_SYM_MODE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_SIG_SCHEME_Marshal(
        src: *const TPMU_SIG_SCHEME,
        selector_value: u32,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_SIG_SCHEME_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        selector_value: u32,
        dest: *mut TPMU_SIG_SCHEME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_KDF_SCHEME_Marshal(
        src: *const TPMU_KDF_SCHEME,
        selector_value: u32,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_KDF_SCHEME_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        selector_value: u32,
        dest: *mut TPMU_KDF_SCHEME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_ASYM_SCHEME_Marshal(
        src: *const TPMU_ASYM_SCHEME,
        selector_value: u32,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_ASYM_SCHEME_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        selector_value: u32,
        dest: *mut TPMU_ASYM_SCHEME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_SCHEME_KEYEDHASH_Marshal(
        src: *const TPMU_SCHEME_KEYEDHASH,
        selector_value: u32,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_SCHEME_KEYEDHASH_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        selector_value: u32,
        dest: *mut TPMU_SCHEME_KEYEDHASH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_SIGNATURE_Marshal(
        src: *const TPMU_SIGNATURE,
        selector_value: u32,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_SIGNATURE_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        selector_value: u32,
        dest: *mut TPMU_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_SENSITIVE_COMPOSITE_Marshal(
        src: *const TPMU_SENSITIVE_COMPOSITE,
        selector_value: u32,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_SENSITIVE_COMPOSITE_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        selector_value: u32,
        dest: *mut TPMU_SENSITIVE_COMPOSITE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_ENCRYPTED_SECRET_Marshal(
        src: *const TPMU_ENCRYPTED_SECRET,
        selector_value: u32,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_ENCRYPTED_SECRET_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        selector_value: u32,
        dest: *mut TPMU_ENCRYPTED_SECRET,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_PUBLIC_PARMS_Marshal(
        src: *const TPMU_PUBLIC_PARMS,
        selector_value: u32,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_PUBLIC_PARMS_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        selector_value: u32,
        dest: *mut TPMU_PUBLIC_PARMS,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_PUBLIC_ID_Marshal(
        src: *const TPMU_PUBLIC_ID,
        selector_value: u32,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_PUBLIC_ID_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        selector_value: u32,
        dest: *mut TPMU_PUBLIC_ID,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_NAME_Marshal(
        src: *const TPMU_NAME,
        selector_value: u32,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMU_NAME_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        selector_value: u32,
        dest: *mut TPMU_NAME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_HA_Marshal(
        src: *const TPMT_HA,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_HA_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMT_HA,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_SYM_DEF_Marshal(
        src: *const TPMT_SYM_DEF,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_SYM_DEF_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMT_SYM_DEF,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_SYM_DEF_OBJECT_Marshal(
        src: *const TPMT_SYM_DEF_OBJECT,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_SYM_DEF_OBJECT_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMT_SYM_DEF_OBJECT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_KEYEDHASH_SCHEME_Marshal(
        src: *const TPMT_KEYEDHASH_SCHEME,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_KEYEDHASH_SCHEME_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMT_KEYEDHASH_SCHEME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_SIG_SCHEME_Marshal(
        src: *const TPMT_SIG_SCHEME,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_SIG_SCHEME_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMT_SIG_SCHEME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_KDF_SCHEME_Marshal(
        src: *const TPMT_KDF_SCHEME,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_KDF_SCHEME_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMT_KDF_SCHEME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_ASYM_SCHEME_Marshal(
        src: *const TPMT_ASYM_SCHEME,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_ASYM_SCHEME_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMT_ASYM_SCHEME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_RSA_SCHEME_Marshal(
        src: *const TPMT_RSA_SCHEME,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_RSA_SCHEME_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMT_RSA_SCHEME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_RSA_DECRYPT_Marshal(
        src: *const TPMT_RSA_DECRYPT,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_RSA_DECRYPT_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMT_RSA_DECRYPT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_ECC_SCHEME_Marshal(
        src: *const TPMT_ECC_SCHEME,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_ECC_SCHEME_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMT_ECC_SCHEME,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_SIGNATURE_Marshal(
        src: *const TPMT_SIGNATURE,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_SIGNATURE_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMT_SIGNATURE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_SENSITIVE_Marshal(
        src: *const TPMT_SENSITIVE,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_SENSITIVE_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMT_SENSITIVE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_PUBLIC_Marshal(
        src: *const TPMT_PUBLIC,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_PUBLIC_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMT_PUBLIC,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_PUBLIC_PARMS_Marshal(
        src: *const TPMT_PUBLIC_PARMS,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_PUBLIC_PARMS_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMT_PUBLIC_PARMS,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_TK_CREATION_Marshal(
        src: *const TPMT_TK_CREATION,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_TK_CREATION_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMT_TK_CREATION,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_TK_VERIFIED_Marshal(
        src: *const TPMT_TK_VERIFIED,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_TK_VERIFIED_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMT_TK_VERIFIED,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_TK_AUTH_Marshal(
        src: *const TPMT_TK_AUTH,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_TK_AUTH_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMT_TK_AUTH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_TK_HASHCHECK_Marshal(
        src: *const TPMT_TK_HASHCHECK,
        buffer: *mut u8,
        buffer_size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMT_TK_HASHCHECK_Unmarshal(
        buffer: *const u8,
        buffer_size: size_t,
        offset: *mut size_t,
        dest: *mut TPMT_TK_HASHCHECK,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2_HANDLE_Marshal(
        in_: TPM2_HANDLE,
        buffer: *mut u8,
        size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2_HANDLE_Unmarshal(
        buffer: *const u8,
        size: size_t,
        offset: *mut size_t,
        out: *mut TPM2_HANDLE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMI_ALG_HASH_Marshal(
        in_: TPMI_ALG_HASH,
        buffer: *mut u8,
        size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMI_ALG_HASH_Unmarshal(
        buffer: *const u8,
        size: size_t,
        offset: *mut size_t,
        out: *mut TPMI_ALG_HASH,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2_SE_Marshal(
        in_: TPM2_SE,
        buffer: *mut u8,
        size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2_SE_Unmarshal(
        buffer: *const u8,
        size: size_t,
        offset: *mut size_t,
        out: *mut TPM2_SE,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2_NT_Marshal(
        in_: TPM2_NT,
        buffer: *mut u8,
        size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPM2_NT_Unmarshal(
        buffer: *const u8,
        size: size_t,
        offset: *mut size_t,
        out: *mut TPM2_NT,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_EMPTY_Marshal(
        in_: *const TPMS_EMPTY,
        buffer: *mut u8,
        size: size_t,
        offset: *mut size_t,
    ) -> TSS2_RC;
}
extern "C" {
    pub fn Tss2_MU_TPMS_EMPTY_Unmarshal(
        buffer: *const u8,
        size: size_t,
        offset: *mut size_t,
        out: *mut TPMS_EMPTY,
    ) -> TSS2_RC;
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: ::std::os::raw::c_uint,
    pub fp_offset: ::std::os::raw::c_uint,
    pub overflow_arg_area: *mut ::std::os::raw::c_void,
    pub reg_save_area: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout___va_list_tag() {
    assert_eq!(
        ::std::mem::size_of::<__va_list_tag>(),
        24usize,
        concat!("Size of: ", stringify!(__va_list_tag))
    );
    assert_eq!(
        ::std::mem::align_of::<__va_list_tag>(),
        8usize,
        concat!("Alignment of ", stringify!(__va_list_tag))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).gp_offset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(gp_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).fp_offset as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(fp_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).overflow_arg_area as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(overflow_arg_area)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).reg_save_area as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(reg_save_area)
        )
    );
}
impl Default for __va_list_tag {
    fn default() -> Self {
        let mut s = ::std::mem::MaybeUninit::<Self>::uninit();
        unsafe {
            ::std::ptr::write_bytes(s.as_mut_ptr(), 0, 1);
            s.assume_init()
        }
    }
}
