/*
 * Copyright (c) 2003, 2007-14 Matteo Frigo
 * Copyright (c) 2003, 2007-14 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Thu May 24 08:08:11 EDT 2018 */

#include "rdft/codelet-rdft.h"

#if defined(ARCH_PREFERS_FMA) || defined(ISA_EXTENSION_PREFERS_FMA)

/* Generated by: ../../../genfft/gen_hc2cdft_c.native -fma -simd -compact -variables 4 -pipeline-latency 8 -trivial-stores -variables 32 -no-generate-bytw -n 6 -dif -sign 1 -name hc2cbdftv_6 -include rdft/simd/hc2cbv.h */

/*
 * This function contains 29 FP additions, 24 FP multiplications,
 * (or, 17 additions, 12 multiplications, 12 fused multiply/add),
 * 38 stack variables, 2 constants, and 12 memory accesses
 */
#include "rdft/simd/hc2cbv.h"

static void hc2cbdftv_6(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DVK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DVK(KP866025403, +0.866025403784438646763723170752936183471402627);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * ((TWVL / VL) * 10)); m < me; m = m + VL, Rp = Rp + (VL * ms), Ip = Ip + (VL * ms), Rm = Rm - (VL * ms), Im = Im - (VL * ms), W = W + (TWVL * 10), MAKE_VOLATILE_STRIDE(24, rs)) {
	       V T4, Te, Tj, Tp, Tb, To, Th, Ti, Ta, Tg, T7, Tf, T2, T3, T8;
	       V T9, T5, T6, Tx, Tw, Tv, Ty, Tz, Tq, Ts, Tn, Tr, Tt, Tu, Tc;
	       V Tk, T1, Td, Tl, Tm;
	       T2 = LD(&(Rp[0]), ms, &(Rp[0]));
	       T3 = LD(&(Rm[WS(rs, 2)]), -ms, &(Rm[0]));
	       T4 = VFNMSCONJ(T3, T2);
	       Te = VFMACONJ(T3, T2);
	       T8 = LD(&(Rp[WS(rs, 1)]), ms, &(Rp[WS(rs, 1)]));
	       T9 = LD(&(Rm[WS(rs, 1)]), -ms, &(Rm[WS(rs, 1)]));
	       Ta = VFMSCONJ(T9, T8);
	       Tg = VFMACONJ(T9, T8);
	       T5 = LD(&(Rp[WS(rs, 2)]), ms, &(Rp[0]));
	       T6 = LD(&(Rm[0]), -ms, &(Rm[0]));
	       T7 = VFNMSCONJ(T6, T5);
	       Tf = VFMACONJ(T6, T5);
	       Tj = VMUL(LDK(KP866025403), VSUB(Tf, Tg));
	       Tp = VMUL(LDK(KP866025403), VSUB(T7, Ta));
	       Tb = VADD(T7, Ta);
	       To = VFNMS(LDK(KP500000000), Tb, T4);
	       Th = VADD(Tf, Tg);
	       Ti = VFNMS(LDK(KP500000000), Th, Te);
	       Tx = VADD(Te, Th);
	       Tv = LDW(&(W[0]));
	       Tw = VZMULI(Tv, VFMAI(Tp, To));
	       Ty = VADD(Tw, Tx);
	       ST(&(Rp[0]), Ty, ms, &(Rp[0]));
	       Tz = VCONJ(VSUB(Tx, Tw));
	       ST(&(Rm[0]), Tz, -ms, &(Rm[0]));
	       Tn = LDW(&(W[TWVL * 8]));
	       Tq = VZMULI(Tn, VFNMSI(Tp, To));
	       Tr = LDW(&(W[TWVL * 6]));
	       Ts = VZMUL(Tr, VFMAI(Tj, Ti));
	       Tt = VADD(Tq, Ts);
	       ST(&(Rp[WS(rs, 2)]), Tt, ms, &(Rp[0]));
	       Tu = VCONJ(VSUB(Ts, Tq));
	       ST(&(Rm[WS(rs, 2)]), Tu, -ms, &(Rm[0]));
	       T1 = LDW(&(W[TWVL * 4]));
	       Tc = VZMULI(T1, VADD(T4, Tb));
	       Td = LDW(&(W[TWVL * 2]));
	       Tk = VZMUL(Td, VFNMSI(Tj, Ti));
	       Tl = VADD(Tc, Tk);
	       ST(&(Rp[WS(rs, 1)]), Tl, ms, &(Rp[WS(rs, 1)]));
	       Tm = VCONJ(VSUB(Tk, Tc));
	       ST(&(Rm[WS(rs, 1)]), Tm, -ms, &(Rm[WS(rs, 1)]));
	  }
     }
     VLEAVE();
}

static const tw_instr twinstr[] = {
     VTW(1, 1),
     VTW(1, 2),
     VTW(1, 3),
     VTW(1, 4),
     VTW(1, 5),
     {TW_NEXT, VL, 0}
};

static const hc2c_desc desc = { 6, XSIMD_STRING("hc2cbdftv_6"), twinstr, &GENUS, {17, 12, 12, 0} };

void XSIMD(codelet_hc2cbdftv_6) (planner *p) {
     X(khc2c_register) (p, hc2cbdftv_6, &desc, HC2C_VIA_DFT);
}
#else

/* Generated by: ../../../genfft/gen_hc2cdft_c.native -simd -compact -variables 4 -pipeline-latency 8 -trivial-stores -variables 32 -no-generate-bytw -n 6 -dif -sign 1 -name hc2cbdftv_6 -include rdft/simd/hc2cbv.h */

/*
 * This function contains 29 FP additions, 14 FP multiplications,
 * (or, 27 additions, 12 multiplications, 2 fused multiply/add),
 * 41 stack variables, 2 constants, and 12 memory accesses
 */
#include "rdft/simd/hc2cbv.h"

static void hc2cbdftv_6(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DVK(KP500000000, +0.500000000000000000000000000000000000000000000);
     DVK(KP866025403, +0.866025403784438646763723170752936183471402627);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * ((TWVL / VL) * 10)); m < me; m = m + VL, Rp = Rp + (VL * ms), Ip = Ip + (VL * ms), Rm = Rm - (VL * ms), Im = Im - (VL * ms), W = W + (TWVL * 10), MAKE_VOLATILE_STRIDE(24, rs)) {
	       V T5, Th, Te, Ts, Tk, Tm, T2, T4, T3, T6, Tc, T8, Tb, T7, Ta;
	       V T9, Td, Ti, Tj, TA, Tf, Tn, Tv, Tt, Tz, T1, Tl, Tg, Tu, Tr;
	       V Tq, Ty, To, Tp, TC, TB, Tx, Tw;
	       T2 = LD(&(Rp[0]), ms, &(Rp[0]));
	       T3 = LD(&(Rm[WS(rs, 2)]), -ms, &(Rm[0]));
	       T4 = VCONJ(T3);
	       T5 = VSUB(T2, T4);
	       Th = VADD(T2, T4);
	       T6 = LD(&(Rp[WS(rs, 2)]), ms, &(Rp[0]));
	       Tc = LD(&(Rp[WS(rs, 1)]), ms, &(Rp[WS(rs, 1)]));
	       T7 = LD(&(Rm[0]), -ms, &(Rm[0]));
	       T8 = VCONJ(T7);
	       Ta = LD(&(Rm[WS(rs, 1)]), -ms, &(Rm[WS(rs, 1)]));
	       Tb = VCONJ(Ta);
	       T9 = VSUB(T6, T8);
	       Td = VSUB(Tb, Tc);
	       Te = VADD(T9, Td);
	       Ts = VBYI(VMUL(LDK(KP866025403), VSUB(T9, Td)));
	       Ti = VADD(T6, T8);
	       Tj = VADD(Tb, Tc);
	       Tk = VADD(Ti, Tj);
	       Tm = VBYI(VMUL(LDK(KP866025403), VSUB(Ti, Tj)));
	       TA = VADD(Th, Tk);
	       T1 = LDW(&(W[TWVL * 4]));
	       Tf = VZMULI(T1, VADD(T5, Te));
	       Tl = VFNMS(LDK(KP500000000), Tk, Th);
	       Tg = LDW(&(W[TWVL * 2]));
	       Tn = VZMUL(Tg, VSUB(Tl, Tm));
	       Tu = LDW(&(W[TWVL * 6]));
	       Tv = VZMUL(Tu, VADD(Tm, Tl));
	       Tr = VFNMS(LDK(KP500000000), Te, T5);
	       Tq = LDW(&(W[TWVL * 8]));
	       Tt = VZMULI(Tq, VSUB(Tr, Ts));
	       Ty = LDW(&(W[0]));
	       Tz = VZMULI(Ty, VADD(Ts, Tr));
	       To = VADD(Tf, Tn);
	       ST(&(Rp[WS(rs, 1)]), To, ms, &(Rp[WS(rs, 1)]));
	       Tp = VCONJ(VSUB(Tn, Tf));
	       ST(&(Rm[WS(rs, 1)]), Tp, -ms, &(Rm[WS(rs, 1)]));
	       TC = VCONJ(VSUB(TA, Tz));
	       ST(&(Rm[0]), TC, -ms, &(Rm[0]));
	       TB = VADD(Tz, TA);
	       ST(&(Rp[0]), TB, ms, &(Rp[0]));
	       Tx = VCONJ(VSUB(Tv, Tt));
	       ST(&(Rm[WS(rs, 2)]), Tx, -ms, &(Rm[0]));
	       Tw = VADD(Tt, Tv);
	       ST(&(Rp[WS(rs, 2)]), Tw, ms, &(Rp[0]));
	  }
     }
     VLEAVE();
}

static const tw_instr twinstr[] = {
     VTW(1, 1),
     VTW(1, 2),
     VTW(1, 3),
     VTW(1, 4),
     VTW(1, 5),
     {TW_NEXT, VL, 0}
};

static const hc2c_desc desc = { 6, XSIMD_STRING("hc2cbdftv_6"), twinstr, &GENUS, {27, 12, 2, 0} };

void XSIMD(codelet_hc2cbdftv_6) (planner *p) {
     X(khc2c_register) (p, hc2cbdftv_6, &desc, HC2C_VIA_DFT);
}
#endif
