#!/usr/bin/perl
# BEGIN_ICS_COPYRIGHT8 ****************************************
#
# Copyright (c) 2015-2020, Intel Corporation
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#     * Redistributions of source code must retain the above copyright notice,
#       this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of Intel Corporation nor the names of its contributors
#       may be used to endorse or promote products derived from this software
#       without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# END_ICS_COPYRIGHT8   ****************************************

# [ICS VERSION STRING: unknown]
use strict;
#use Term::ANSIColor;
#use Term::ANSIColor qw(:constants);
#use File::Basename;
#use Math::BigInt;

# ===========================================================================
# Host Tools

# capture host information for problem report
sub capture_report($)
{
	my($req_compname) = shift();

	my $result;
	my $inp;
	my $detail;

	if ( ! -e "$BIN_DIR/ethcapture" ) {
		printf("$req_compname not installed on this system\n");
		printf("Unable to Generate Supporting Information\n");
		HitKeyCont;
		return;
	}
	do {
		printf ("\n\nEnter Filename to Generate [q to quit] : ");
		$inp = <STDIN>;
		$inp=remove_whitespace($inp);
		chomp $inp;
		$_ = $inp;
			
		if (/^[Qq]$/) {
			return;
		}

		if ( length($inp) == 0 ) {
			next;
		}

		$inp = SanitizeFilename($inp);
		if ( length($inp) == 0) {
			printf("Invalid filename\n");
			$result = 1;
		} else {
			LogPrint "Capturing $INT_VERSION Report to $inp\n";
			$detail=GetNumericValue("Capture detail level (1-Normal 2-Fabric 3-Analysis):", 1, 1, 3);
			close_log;
			$result = system "$BIN_DIR/ethcapture -d $detail '$inp'";
			if ( $result != 0 ) {
				printf("\nError generating $inp\n");
			}
		}
	} while ($result != 0);
	open_log;
	HitKeyCont;
}

# invoke FastFabric TUI
my $FabricSetupScpFromDir=".";

sub run_fastfabric($)
{
	my($req_compname) = shift();

	if ( ! -e "$BIN_DIR/ethfastfabric" ) {
		printf("$req_compname not installed on this system\n");
		printf("Unable to perform FastFabric (Host Setup/Admin)\n");
		HitKeyCont;
		return;
	}
	system("$BIN_DIR/ethfastfabric --fromdir $FabricSetupScpFromDir");
	return;
}

