/*
 * See the dyninst/COPYRIGHT file for copyright information.
 * 
 * We provide the Paradyn Tools (below described as "Paradyn")
 * on an AS IS basis, and do not warrant its validity or performance.
 * We reserve the right to update, modify, or discontinue this
 * software at any time.  We shall have no obligation to supply such
 * updates or modifications or any other form of support to you.
 * 
 * By your use of Paradyn, you understand and agree that we (or any
 * other person or entity with proprietary rights in Paradyn) are
 * under no obligation to provide either maintenance services,
 * update services, notices of latent defects, or correction of
 * defects for Paradyn.
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

/************************************************************************
 *
 * $Id: RTshared-unix.c,v 1.1 2004/05/11 19:02:28 bernat Exp $
 * RTshared.c: shared memory implementation
 *
 ************************************************************************/

#include <sys/types.h>
#include <sys/shm.h>
#include <stdio.h>

/* Unfortunately, we still have platform problems... here it's unix vs NT */

void *RTsharedAttach(unsigned key, unsigned size, void *addr) {
    /* UNIX version */
    int shmid;
    void *mapAddr;
    shmid = shmget(key, size, 0666);
    if (shmid != -1) {
        /* Map the segment at the address given (0 if we don't care) */
        mapAddr = shmat(shmid, addr, 0);
        return mapAddr;
    }
    perror("RTsharedAttach: shmat");
    
    return (void *)-1;
    assert(0);
}

void *RTsharedDetach(unsigned key, unsigned size, void *addr) {
    return (void *)shmdt(addr);
}

