/*-
 *   BSD LICENSE
 *
 *   Copyright(c) 2010-2014 Intel Corporation. All rights reserved.
 *   All rights reserved.
 *
 *   Redistribution and use in source and binary forms, with or without
 *   modification, are permitted provided that the following conditions
 *   are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in
 *       the documentation and/or other materials provided with the
 *       distribution.
 *     * Neither the name of Intel Corporation nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 *   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 *   "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 *   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 *   A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 *   OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *   SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *   LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 *   DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 *   THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 *   OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
#ifndef _TEST_LPM_ROUTES_H_
#define _TEST_LPM_ROUTES_H_

struct rules_tbl_entry {
	uint8_t ip[16];
	uint8_t depth;
	uint8_t next_hop;
};

struct ips_tbl_entry {
	uint8_t ip[16];
	uint8_t next_hop;
};

static struct rules_tbl_entry large_route_table[] =
{
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 50, 146},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 54, 141},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 0}, 67, 23},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 97, 252},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 54, 6},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 9, 137},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 31, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 0}, 82, 9},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 120, 163},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 79, 197},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 54, 249},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 47, 88},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 52, 104},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 10, 36},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 54, 239},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 0}, 67, 201},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33, 94},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 51, 241},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 24, 239},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 0}, 66, 151},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 12, 137},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41, 231},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 44, 11},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 96, 20},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 15, 68},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 101, 64},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33, 152},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6, 217},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 2, 101},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 15, 58},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 27, 254},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 32, 148},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126, 126},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 123, 76},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 54, 240},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 54, 33},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 25, 47},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 109, 41},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 0}, 62, 72},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 46, 43},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 0}, 68, 26},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 42, 139},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 13, 219},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 0, 0}, 58, 105},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 47, 210},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 17, 151},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 42, 28},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 9, 64},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 121, 9},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 92, 250},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 0}, 66, 200},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 127, 132},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 0}, 71, 182},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 102, 7},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 100, 146},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 0}, 70, 98},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 86, 179},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 0}, 77, 245},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 0}, 64, 2},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 17, 5},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 0}, 66, 169},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33, 52},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 9, 177},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 27, 74},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 122, 212},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 122, 238},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 19, 18},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 0}, 75, 155},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 24, 97},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 32, 8},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 9, 123},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 92, 11},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 13, 211},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 20, 116},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11, 57},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 108, 178},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 102, 93},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 92, 3},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 121, 162},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 109, 125},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 34, 33},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 9, 254},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 0}, 74, 66},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 30, 4},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 0}, 86, 122},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 46, 59},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 117, 99},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 27, 41},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 8, 112},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 85, 255},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 44, 106},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 0}, 62, 170},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 16, 86},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 0}, 79, 155},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 35, 65},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 36, 39},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 90, 162},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 10, 69},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 0}, 64, 163},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 90, 116},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 53, 19},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 36, 48},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 49, 230},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 0}, 78, 155},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 96, 158},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 113, 252},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 110, 176},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 0}, 66, 211},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28, 15},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 0}, 68, 95},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 34, 169},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 44, 249},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 105, 61},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 23, 63},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 14, 43},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 81, 228},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 0}, 78, 165},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 0}, 64, 3},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 57, 211},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33, 210},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 99, 61},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 10, 120},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 47, 94},
	{{31, 181, 56, 141, 120, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41, 153},
	{{153, 73, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 18, 221},
	{{162, 107, 41, 189, 165, 155, 22, 139, 165, 72, 96, 0, 0, 0, 0, 0}, 87, 163},
	{{218, 17, 204, 165, 217, 251, 107, 45, 29, 15, 192, 167, 75, 0, 0, 0}, 106, 188},
	{{200, 124, 238, 213, 35, 228, 94, 141, 86, 187, 101, 60, 115, 52, 131, 16}, 124, 15},
	{{74, 237, 160, 56, 141, 217, 191, 16, 0, 0, 0, 0, 0, 0, 0, 0}, 63, 28},
	{{163, 47, 242, 103, 173, 217, 88, 154, 38, 200, 32, 0, 0, 0, 0, 0}, 84, 240},
	{{20, 227, 128, 28, 144, 147, 22, 13, 94, 129, 107, 88, 0, 0, 0, 0}, 93, 59},
	{{95, 144, 229, 107, 218, 125, 204, 233, 161, 42, 180, 64, 0, 0, 0, 0}, 90, 195},
	{{155, 220, 83, 208, 108, 16, 134, 156, 128, 0, 0, 0, 0, 0, 0, 0}, 66, 10},
	{{179, 138, 55, 80, 190, 153, 12, 237, 22, 120, 69, 0, 0, 0, 0, 0}, 88, 206},
	{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 2, 137},
	{{3, 119, 148, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 22, 225},
	{{13, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 10, 223},
	{{117, 28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 15, 29},
	{{164, 19, 195, 47, 136, 190, 156, 255, 30, 74, 143, 134, 162, 0, 0, 0}, 103, 166},
	{{40, 235, 94, 135, 135, 230, 71, 33, 64, 233, 0, 0, 0, 0, 0, 0}, 80, 178},
	{{222, 151, 166, 97, 129, 250, 140, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 55, 38},
	{{174, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 9, 141},
	{{6, 189, 100, 150, 250, 13, 46, 98, 228, 139, 50, 52, 52, 196, 128, 0}, 116, 230},
	{{75, 252, 89, 205, 37, 52, 106, 79, 188, 120, 54, 119, 160, 0, 0, 0}, 99, 124},
	{{38, 18, 146, 6, 63, 64, 231, 10, 152, 199, 5, 143, 147, 4, 252, 0}, 118, 54},
	{{111, 119, 169, 51, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 32, 162},
	{{105, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 13, 32},
	{{143, 57, 57, 101, 98, 182, 74, 227, 205, 143, 253, 237, 8, 0, 0, 0}, 102, 237},
	{{30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 7, 215},
	{{14, 232, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 22, 138},
	{{14, 53, 67, 216, 229, 155, 149, 139, 31, 253, 184, 126, 133, 108, 40, 0}, 118, 73},
	{{22, 58, 40, 143, 188, 132, 239, 14, 181, 252, 81, 192, 0, 0, 0, 0}, 90, 43},
	{{11, 222, 185, 243, 248, 150, 79, 230, 214, 213, 3, 23, 193, 196, 0, 0}, 112, 88},
	{{14, 226, 198, 117, 84, 93, 22, 96, 77, 241, 173, 68, 68, 204, 72, 0}, 119, 91},
	{{15, 103, 247, 219, 150, 142, 92, 50, 144, 0, 0, 0, 0, 0, 0, 0}, 69, 140},
	{{0, 213, 77, 244, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 37, 65},
	{{178, 174, 174, 239, 72, 181, 36, 217, 40, 169, 12, 104, 149, 157, 125, 128}, 122, 201},
	{{118, 53, 55, 17, 97, 227, 243, 176, 2, 0, 0, 0, 0, 0, 0, 0}, 72, 69},
	{{21, 253, 4, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 35, 170},
	{{5, 249, 186, 133, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 40, 192},
	{{47, 79, 35, 66, 11, 178, 161, 28, 87, 180, 45, 128, 0, 0, 0, 0}, 89, 21},
	{{242, 227, 20, 73, 150, 196, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 46, 35},
	{{121, 169, 102, 118, 157, 192, 154, 186, 126, 0, 0, 0, 0, 0, 0, 0}, 71, 235},
	{{9, 138, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 21, 240},
	{{45, 173, 14, 72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 30, 136},
	{{127, 47, 51, 201, 236, 45, 142, 80, 0, 0, 0, 0, 0, 0, 0, 0}, 60, 186},
	{{247, 233, 34, 38, 181, 207, 127, 20, 224, 118, 59, 148, 0, 0, 0, 0}, 95, 174},
	{{126, 187, 198, 104, 245, 223, 219, 18, 31, 124, 0, 0, 0, 0, 0, 0}, 79, 153},
	{{3, 163, 107, 228, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 35, 118},
	{{167, 109, 2, 95, 11, 62, 45, 128, 0, 0, 0, 0, 0, 0, 0, 0}, 60, 113},
	{{76, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6, 58},
	{{58, 190, 204, 151, 222, 147, 47, 78, 38, 203, 9, 17, 64, 0, 0, 0}, 101, 206},
	{{254, 220, 254, 220, 204, 79, 35, 127, 242, 63, 106, 232, 127, 180, 0, 0}, 111, 42},
	{{77, 156, 8, 209, 181, 37, 70, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 55, 230},
	{{65, 89, 137, 76, 208, 199, 166, 90, 128, 0, 0, 0, 0, 0, 0, 0}, 67, 6},
	{{47, 232, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 13, 254},
	{{172, 154, 12, 108, 77, 37, 106, 8, 234, 7, 248, 212, 112, 160, 0, 0}, 108, 214},
	{{254, 117, 239, 244, 154, 89, 166, 241, 12, 108, 127, 153, 206, 160, 0, 0}, 107, 43},
	{{113, 160, 206, 52, 143, 12, 9, 148, 224, 0, 0, 0, 0, 0, 0, 0}, 67, 178},
	{{178, 130, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 16, 179},
	{{229, 177, 28, 106, 59, 75, 182, 241, 36, 79, 224, 0, 0, 0, 0, 0}, 87, 236},
	{{156, 72, 93, 193, 50, 235, 75, 228, 88, 115, 89, 119, 128, 0, 0, 0}, 98, 184},
	{{28, 232, 28, 249, 83, 105, 211, 7, 136, 147, 231, 64, 0, 0, 0, 0}, 91, 95},
	{{217, 33, 23, 107, 74, 42, 135, 197, 144, 34, 40, 243, 13, 126, 36, 136}, 127, 152},
	{{64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 2, 113},
	{{85, 172, 121, 126, 213, 57, 225, 54, 197, 73, 85, 251, 9, 64, 0, 0}, 108, 137},
	{{104, 46, 25, 71, 86, 220, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 46, 224},
	{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6, 61},
	{{241, 113, 254, 106, 53, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41, 205},
	{{29, 36, 12, 244, 197, 127, 240, 8, 167, 134, 154, 248, 199, 123, 143, 240}, 124, 170},
	{{58, 29, 129, 94, 43, 139, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 53, 117},
	{{213, 124, 147, 196, 7, 82, 67, 70, 228, 0, 0, 0, 0, 0, 0, 0}, 70, 225},
	{{164, 168, 161, 140, 87, 85, 250, 41, 34, 0, 0, 0, 0, 0, 0, 0}, 72, 34},
	{{186, 142, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 17, 5},
	{{237, 249, 9, 70, 247, 97, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 50, 92},
	{{155, 92, 145, 218, 125, 226, 226, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 55, 230},
	{{35, 169, 62, 156, 86, 4, 125, 219, 119, 113, 191, 75, 198, 113, 0, 0}, 112, 61},
	{{207, 63, 96, 186, 26, 68, 115, 161, 163, 59, 190, 166, 18, 78, 232, 0}, 117, 221},
	{{86, 40, 200, 199, 247, 86, 159, 179, 191, 184, 117, 173, 211, 158, 0, 128}, 121, 105},
	{{104, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11, 181},
	{{205, 35, 123, 178, 36, 64, 62, 153, 195, 250, 0, 0, 0, 0, 0, 0}, 79, 110},
	{{117, 40, 57, 157, 138, 160, 223, 59, 155, 145, 64, 0, 0, 0, 0, 0}, 86, 103},
	{{74, 166, 140, 146, 74, 72, 229, 99, 167, 124, 107, 117, 217, 14, 246, 64}, 123, 218},
	{{12, 222, 244, 183, 83, 146, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 56, 146},
	{{11, 98, 146, 110, 95, 96, 80, 142, 224, 0, 0, 0, 0, 0, 0, 0}, 67, 90},
	{{235, 5, 187, 199, 30, 170, 82, 187, 228, 159, 22, 25, 204, 112, 0, 0}, 108, 197},
	{{35, 96, 146, 145, 155, 116, 252, 181, 29, 205, 230, 246, 30, 0, 0, 0}, 103, 158},
	{{174, 38, 56, 244, 227, 102, 252, 237, 128, 86, 0, 0, 0, 0, 0, 0}, 81, 118},
	{{65, 134, 37, 58, 90, 125, 60, 84, 0, 0, 0, 0, 0, 0, 0, 0}, 62, 95},
	{{253, 117, 135, 98, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33, 152},
	{{111, 115, 188, 184, 130, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 45, 239},
	{{202, 24, 89, 9, 149, 45, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 50, 48},
	{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 5, 228},
	{{244, 98, 52, 140, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 30, 247},
	{{151, 167, 43, 178, 116, 194, 173, 126, 236, 98, 40, 0, 0, 0, 0, 0}, 85, 12},
	{{60, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 10, 129},
	{{208, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4, 50},
	{{126, 11, 216, 242, 7, 45, 121, 208, 110, 135, 210, 75, 59, 182, 228, 42}, 128, 250},
	{{217, 26, 184, 146, 3, 18, 240, 15, 135, 8, 0, 0, 0, 0, 0, 0}, 77, 249},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 1, 230},
	{{145, 28, 29, 184, 2, 85, 234, 135, 98, 111, 136, 32, 0, 0, 0, 0}, 92, 228},
	{{108, 104, 255, 254, 34, 95, 72, 157, 0, 0, 0, 0, 0, 0, 0, 0}, 64, 181},
	{{153, 61, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 16, 206},
	{{22, 250, 130, 201, 132, 248, 189, 108, 0, 0, 0, 0, 0, 0, 0, 0}, 63, 122},
	{{158, 165, 234, 18, 44, 61, 82, 61, 235, 0, 0, 0, 0, 0, 0, 0}, 72, 81},
	{{236, 57, 124, 110, 124, 218, 82, 70, 142, 78, 18, 128, 0, 0, 0, 0}, 95, 175},
	{{94, 209, 200, 201, 149, 162, 248, 134, 239, 226, 1, 237, 16, 134, 56, 0}, 118, 170},
	{{187, 42, 31, 144, 236, 70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 47, 174},
	{{90, 214, 185, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 29, 104},
	{{194, 220, 211, 212, 211, 32, 196, 98, 71, 62, 153, 103, 80, 35, 128, 0}, 114, 113},
	{{24, 255, 158, 64, 180, 148, 10, 81, 243, 247, 0, 0, 0, 0, 0, 0}, 80, 89},
	{{231, 155, 100, 242, 112, 160, 160, 95, 98, 253, 219, 21, 239, 90, 0, 0}, 113, 151},
	{{225, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11, 108},
	{{136, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 7, 224},
	{{250, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 9, 95},
	{{72, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 14, 173},
	{{185, 51, 51, 167, 18, 44, 36, 59, 35, 135, 20, 104, 0, 0, 0, 0}, 93, 176},
	{{57, 146, 252, 60, 197, 68, 39, 162, 80, 198, 137, 50, 97, 92, 124, 0}, 119, 84},
	{{254, 46, 242, 105, 86, 94, 96, 14, 130, 176, 0, 0, 0, 0, 0, 0}, 78, 104},
	{{247, 202, 176, 76, 69, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 49, 236},
	{{50, 233, 203, 77, 42, 21, 115, 163, 166, 138, 192, 52, 178, 37, 112, 0}, 116, 153},
	{{62, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11, 190},
	{{53, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 13, 202},
	{{198, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 8, 54},
	{{189, 234, 106, 247, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 34, 156},
	{{110, 24, 228, 65, 216, 147, 9, 48, 60, 179, 172, 91, 115, 185, 227, 96}, 126, 245},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6, 218},
	{{74, 177, 89, 218, 248, 18, 176, 39, 118, 173, 201, 152, 0, 0, 0, 0}, 93, 72},
	{{31, 13, 153, 92, 27, 122, 150, 232, 88, 95, 202, 171, 208, 158, 0, 0}, 112, 183},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 2, 183},
	{{63, 37, 46, 158, 139, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 42, 241},
	{{53, 209, 59, 13, 202, 70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 47, 106},
	{{184, 44, 149, 221, 180, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 40, 180},
	{{222, 134, 37, 62, 223, 193, 39, 246, 15, 151, 200, 146, 0, 0, 0, 0}, 96, 142},
	{{199, 176, 189, 37, 233, 177, 252, 216, 94, 175, 253, 119, 96, 0, 0, 0}, 100, 6},
	{{44, 195, 201, 106, 209, 120, 122, 38, 43, 30, 142, 22, 196, 175, 100, 0}, 118, 33},
	{{33, 166, 10, 174, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 34, 224},
	{{54, 1, 189, 195, 133, 49, 36, 80, 138, 200, 0, 0, 0, 0, 0, 0}, 78, 14},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 10, 149},
	{{221, 131, 4, 247, 112, 89, 187, 119, 219, 80, 122, 156, 216, 160, 0, 0}, 108, 131},
	{{102, 20, 46, 129, 202, 247, 129, 1, 237, 71, 103, 58, 217, 44, 4, 0}, 121, 133},
	{{107, 156, 151, 44, 215, 98, 171, 126, 85, 32, 42, 128, 0, 0, 0, 0}, 89, 33},
	{{54, 25, 70, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28, 204},
	{{149, 211, 242, 14, 112, 219, 176, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 52, 43},
	{{95, 26, 143, 193, 8, 76, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 51, 168},
	{{63, 102, 244, 176, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28, 180},
	{{64, 85, 124, 226, 59, 239, 64, 130, 68, 122, 93, 74, 32, 37, 0, 0}, 112, 208},
	{{113, 90, 253, 149, 3, 218, 34, 215, 3, 143, 192, 64, 0, 0, 0, 0}, 90, 25},
	{{75, 231, 33, 5, 11, 94, 117, 104, 150, 60, 72, 161, 96, 38, 0, 0}, 111, 50},
	{{52, 13, 248, 1, 251, 14, 50, 29, 212, 123, 130, 177, 101, 96, 0, 0}, 109, 110},
	{{248, 221, 150, 132, 252, 82, 96, 2, 80, 232, 97, 239, 253, 64, 0, 0}, 109, 21},
	{{136, 77, 164, 161, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 36, 147},
	{{1, 33, 66, 254, 144, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43, 56},
	{{181, 25, 186, 225, 109, 190, 76, 158, 118, 122, 20, 64, 125, 55, 8, 0}, 117, 144},
	{{191, 187, 160, 140, 17, 6, 80, 120, 236, 212, 104, 144, 128, 0, 0, 0}, 100, 198},
	{{201, 61, 150, 254, 70, 77, 214, 211, 171, 163, 245, 64, 0, 0, 0, 0}, 90, 235},
	{{143, 226, 190, 50, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 38, 105},
	{{65, 168, 226, 36, 201, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 45, 138},
	{{136, 40, 65, 90, 47, 16, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 49, 122},
	{{94, 189, 224, 200, 170, 11, 79, 172, 0, 0, 0, 0, 0, 0, 0, 0}, 65, 193},
	{{236, 41, 169, 234, 14, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43, 231},
	{{1, 40, 140, 95, 81, 173, 250, 248, 0, 0, 0, 0, 0, 0, 0, 0}, 64, 250},
	{{83, 176, 146, 112, 89, 156, 57, 220, 125, 48, 44, 0, 0, 0, 0, 0}, 86, 24},
	{{76, 125, 228, 249, 243, 160, 106, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 55, 191},
	{{10, 203, 204, 49, 212, 115, 125, 4, 239, 122, 81, 34, 1, 198, 216, 0}, 117, 111},
	{{74, 214, 23, 44, 211, 40, 161, 61, 237, 190, 155, 59, 173, 42, 0, 0}, 111, 205},
	{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 1, 133},
	{{127, 0, 130, 61, 209, 5, 232, 35, 35, 42, 114, 52, 169, 234, 191, 0}, 122, 122},
	{{201, 107, 210, 13, 187, 62, 145, 28, 31, 189, 56, 0, 0, 0, 0, 0}, 87, 227},
	{{147, 171, 63, 145, 47, 160, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 46, 53},
	{{93, 232, 10, 97, 21, 243, 213, 135, 200, 0, 0, 0, 0, 0, 0, 0}, 72, 224},
	{{144, 121, 41, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 26, 199},
	{{116, 105, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 17, 79},
	{{142, 149, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 21, 19},
	{{97, 0, 228, 158, 50, 233, 251, 249, 0, 66, 197, 226, 0, 0, 0, 0}, 96, 211},
	{{114, 228, 199, 155, 175, 104, 26, 213, 66, 249, 120, 218, 164, 252, 212, 0}, 120, 6},
	{{224, 166, 76, 200, 121, 60, 110, 65, 60, 95, 137, 190, 92, 218, 218, 0}, 121, 143},
	{{139, 219, 92, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 31, 135},
	{{203, 237, 64, 189, 28, 13, 75, 197, 219, 243, 172, 3, 142, 32, 0, 0}, 109, 21},
	{{237, 186, 88, 254, 124, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 38, 220},
	{{182, 230, 93, 162, 129, 25, 56, 196, 112, 0, 0, 0, 0, 0, 0, 0}, 68, 151},
	{{245, 45, 69, 226, 90, 212, 254, 16, 0, 0, 0, 0, 0, 0, 0, 0}, 60, 111},
	{{107, 229, 240, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 20, 63},
	{{119, 208, 177, 235, 222, 252, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 57, 112},
	{{178, 151, 220, 162, 120, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41, 48},
	{{109, 26, 95, 170, 166, 151, 137, 83, 226, 82, 5, 114, 253, 210, 18, 12}, 126, 100},
	{{126, 27, 252, 19, 219, 129, 121, 48, 0, 0, 0, 0, 0, 0, 0, 0}, 60, 156},
	{{211, 195, 152, 145, 154, 93, 228, 215, 135, 101, 28, 82, 0, 0, 0, 0}, 95, 120},
	{{252, 107, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 16, 5},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4, 103},
	{{64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4, 84},
	{{225, 179, 43, 43, 222, 145, 205, 238, 164, 158, 147, 229, 56, 0, 0, 0}, 101, 24},
	{{208, 127, 151, 24, 64, 113, 47, 85, 209, 79, 144, 0, 0, 0, 0, 0}, 86, 81},
	{{178, 144, 203, 104, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 29, 96},
	{{56, 227, 139, 4, 86, 87, 180, 1, 215, 167, 237, 156, 111, 64, 47, 0}, 121, 6},
	{{80, 76, 204, 119, 172, 169, 254, 81, 104, 166, 219, 44, 173, 161, 212, 0}, 119, 40},
	{{129, 141, 139, 34, 241, 101, 223, 144, 0, 0, 0, 0, 0, 0, 0, 0}, 62, 143},
	{{85, 102, 137, 98, 65, 103, 54, 142, 144, 0, 0, 0, 0, 0, 0, 0}, 68, 69},
	{{56, 31, 159, 13, 201, 139, 161, 31, 89, 137, 4, 0, 0, 0, 0, 0}, 92, 48},
	{{229, 221, 54, 216, 223, 27, 196, 1, 0, 0, 0, 0, 0, 0, 0, 0}, 64, 115},
	{{5, 144, 176, 43, 180, 187, 20, 49, 59, 73, 108, 34, 83, 32, 192, 0}, 115, 130},
	{{24, 217, 205, 193, 74, 123, 160, 106, 103, 74, 200, 0, 0, 0, 0, 0}, 86, 57},
	{{247, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 8, 97},
	{{12, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 9, 146},
	{{160, 28, 201, 119, 148, 93, 251, 118, 28, 179, 123, 52, 71, 232, 48, 0}, 117, 194},
	{{152, 126, 17, 54, 101, 56, 130, 1, 205, 41, 207, 90, 151, 123, 128, 0}, 114, 129},
	{{77, 165, 29, 239, 95, 242, 34, 1, 11, 204, 135, 239, 128, 0, 0, 0}, 97, 159},
	{{183, 108, 146, 118, 74, 190, 7, 141, 9, 92, 2, 2, 8, 218, 120, 0}, 117, 242},
	{{37, 152, 29, 239, 242, 53, 56, 143, 219, 22, 14, 158, 49, 0, 0, 0}, 104, 162},
	{{198, 53, 241, 102, 240, 244, 97, 203, 62, 128, 213, 214, 220, 0, 0, 0}, 102, 140},
	{{144, 89, 48, 42, 249, 231, 189, 178, 232, 199, 30, 58, 63, 57, 0, 0}, 113, 77},
	{{68, 212, 177, 123, 44, 224, 19, 172, 89, 87, 192, 0, 0, 0, 0, 0}, 82, 121},
	{{252, 29, 179, 224, 4, 121, 205, 67, 152, 0, 0, 0, 0, 0, 0, 0}, 69, 102},
	{{28, 110, 164, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 23, 28},
	{{24, 88, 231, 1, 4, 71, 71, 241, 252, 14, 197, 0, 0, 0, 0, 0}, 89, 154},
	{{63, 131, 43, 76, 58, 140, 163, 74, 158, 80, 0, 0, 0, 0, 0, 0}, 76, 39},
	{{56, 28, 147, 149, 98, 93, 216, 216, 203, 156, 0, 0, 0, 0, 0, 0}, 78, 163},
	{{134, 169, 6, 103, 161, 244, 134, 117, 16, 0, 0, 0, 0, 0, 0, 0}, 68, 42},
	{{143, 247, 125, 190, 106, 50, 204, 98, 250, 151, 161, 96, 0, 0, 0, 0}, 92, 207},
	{{235, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 8, 25},
	{{46, 72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 18, 150},
	{{171, 35, 128, 117, 74, 29, 199, 67, 109, 176, 0, 0, 0, 0, 0, 0}, 76, 103},
	{{220, 233, 236, 112, 135, 136, 215, 43, 42, 0, 0, 0, 0, 0, 0, 0}, 71, 155},
	{{228, 11, 144, 117, 206, 192, 118, 25, 141, 78, 4, 105, 0, 0, 0, 0}, 96, 142},
	{{195, 67, 194, 229, 14, 53, 129, 7, 30, 208, 38, 100, 182, 59, 0, 0}, 112, 2},
	{{25, 76, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 19, 59},
	{{160, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4, 112},
	{{26, 203, 217, 152, 16, 187, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 48, 166},
	{{250, 213, 14, 235, 110, 171, 174, 23, 102, 128, 0, 0, 0, 0, 0, 0}, 73, 62},
	{{175, 230, 160, 13, 187, 17, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 50, 176},
	{{92, 155, 156, 93, 191, 73, 28, 82, 187, 129, 57, 5, 16, 0, 0, 0}, 100, 6},
	{{45, 203, 3, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 29, 26},
	{{120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 5, 6},
	{{216, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 5, 13},
	{{135, 215, 0, 71, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 37, 41},
	{{221, 149, 1, 40, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 36, 135},
	{{95, 143, 255, 194, 2, 157, 191, 113, 10, 229, 204, 56, 0, 0, 0, 0}, 93, 171},
	{{202, 212, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 19, 20},
	{{147, 203, 238, 120, 194, 23, 25, 58, 208, 177, 169, 0, 0, 0, 0, 0}, 89, 119},
	{{137, 170, 113, 252, 215, 194, 224, 146, 233, 87, 86, 192, 26, 46, 0, 0}, 112, 49},
	{{224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4, 141},
	{{250, 90, 241, 174, 163, 72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 47, 132},
	{{66, 190, 202, 144, 122, 86, 22, 103, 107, 164, 57, 54, 228, 128, 0, 0}, 105, 176},
	{{76, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 12, 186},
	{{120, 246, 1, 52, 187, 163, 78, 105, 224, 0, 0, 0, 0, 0, 0, 0}, 67, 93},
	{{137, 242, 136, 71, 98, 10, 53, 97, 160, 85, 132, 127, 185, 222, 0, 0}, 111, 242},
	{{255, 133, 181, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 24, 163},
	{{128, 177, 92, 155, 91, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 42, 184},
	{{45, 120, 186, 192, 240, 199, 178, 95, 32, 0, 0, 0, 0, 0, 0, 0}, 68, 188},
	{{151, 98, 103, 254, 90, 6, 10, 109, 14, 158, 69, 29, 140, 237, 40, 232}, 126, 193},
	{{148, 164, 81, 85, 76, 14, 84, 64, 89, 176, 0, 0, 0, 0, 0, 0}, 78, 63},
	{{145, 187, 165, 136, 88, 30, 107, 191, 205, 120, 119, 216, 158, 123, 64, 0}, 115, 160},
	{{78, 120, 28, 243, 216, 180, 87, 19, 253, 16, 110, 33, 228, 24, 232, 0}, 117, 251},
	{{74, 6, 166, 166, 183, 157, 96, 84, 151, 0, 0, 0, 0, 0, 0, 0}, 72, 228},
	{{89, 96, 4, 221, 214, 253, 58, 49, 9, 0, 0, 0, 0, 0, 0, 0}, 72, 168},
	{{97, 9, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 18, 194},
	{{213, 215, 45, 200, 170, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 47, 166},
	{{5, 14, 92, 0, 28, 245, 130, 202, 32, 40, 207, 77, 166, 170, 246, 64}, 122, 210},
	{{77, 45, 43, 71, 202, 0, 157, 146, 59, 91, 225, 0, 0, 0, 0, 0}, 89, 254},
	{{101, 174, 94, 168, 162, 171, 71, 12, 16, 224, 0, 0, 0, 0, 0, 0}, 75, 49},
	{{58, 17, 187, 194, 87, 73, 215, 103, 180, 12, 40, 66, 0, 0, 0, 0}, 96, 95},
	{{160, 91, 68, 81, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33, 193},
	{{94, 112, 249, 13, 167, 245, 101, 64, 0, 0, 0, 0, 0, 0, 0, 0}, 58, 155},
	{{236, 194, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 15, 133},
	{{168, 243, 103, 221, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 38, 10},
	{{86, 194, 218, 188, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33, 31},
	{{232, 3, 134, 67, 63, 196, 86, 14, 170, 243, 77, 134, 187, 140, 72, 18}, 127, 98},
	{{55, 253, 19, 201, 199, 71, 229, 218, 54, 64, 12, 162, 0, 0, 0, 0}, 96, 22},
	{{142, 34, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 20, 214},
	{{213, 16, 208, 50, 100, 33, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 50, 217},
	{{117, 237, 132, 185, 184, 246, 79, 42, 103, 98, 162, 243, 128, 0, 0, 0}, 98, 102},
	{{120, 25, 214, 222, 61, 157, 203, 102, 3, 146, 192, 0, 0, 0, 0, 0}, 83, 169},
	{{222, 46, 254, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 27, 152},
	{{254, 70, 158, 171, 11, 245, 223, 97, 70, 17, 27, 192, 186, 0, 0, 0}, 103, 214},
	{{192, 128, 228, 17, 68, 20, 44, 31, 52, 34, 212, 1, 224, 0, 0, 0}, 99, 178},
	{{237, 229, 203, 8, 121, 176, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 45, 164},
	{{6, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 7, 15},
	{{71, 197, 251, 122, 138, 232, 12, 241, 116, 240, 0, 0, 0, 0, 0, 0}, 76, 94},
	{{18, 241, 135, 210, 233, 54, 121, 185, 4, 0, 0, 0, 0, 0, 0, 0}, 70, 239},
	{{32, 50, 213, 63, 73, 217, 180, 21, 187, 128, 0, 0, 0, 0, 0, 0}, 73, 82},
	{{203, 166, 233, 73, 92, 182, 212, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 55, 54},
	{{56, 162, 126, 4, 18, 195, 192, 64, 164, 156, 119, 196, 64, 0, 0, 0}, 98, 47},
	{{120, 87, 81, 136, 180, 179, 68, 148, 243, 38, 80, 0, 0, 0, 0, 0}, 84, 214},
	{{64, 244, 193, 50, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 37, 215},
	{{91, 168, 253, 158, 131, 83, 159, 163, 113, 169, 112, 0, 0, 0, 0, 0}, 84, 153},
	{{159, 103, 102, 132, 111, 46, 18, 77, 36, 15, 137, 33, 177, 31, 243, 192}, 122, 245},
	{{123, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 8, 118},
	{{67, 81, 226, 190, 7, 79, 71, 250, 155, 245, 44, 81, 215, 213, 171, 224}, 123, 128},
	{{103, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 8, 7},
	{{246, 44, 168, 200, 198, 238, 52, 196, 125, 115, 0, 0, 0, 0, 0, 0}, 80, 152},
	{{205, 14, 186, 252, 239, 213, 59, 119, 105, 37, 140, 209, 4, 231, 0, 0}, 114, 248},
	{{70, 91, 254, 106, 94, 71, 170, 19, 158, 242, 192, 0, 0, 0, 0, 0}, 85, 143},
	{{250, 86, 233, 184, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 30, 159},
	{{122, 222, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 24, 11},
	{{27, 224, 235, 70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 31, 110},
	{{239, 100, 224, 3, 46, 127, 150, 251, 204, 120, 228, 64, 0, 0, 0, 0}, 97, 181},
	{{144, 115, 182, 206, 146, 13, 21, 111, 37, 70, 179, 129, 173, 82, 93, 128}, 121, 4},
	{{73, 190, 57, 243, 49, 51, 15, 209, 0, 0, 0, 0, 0, 0, 0, 0}, 67, 101},
	{{18, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11, 38},
	{{23, 37, 236, 177, 186, 7, 209, 135, 114, 44, 0, 0, 0, 0, 0, 0}, 78, 57},
	{{200, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 17, 142},
	{{181, 255, 153, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 24, 184},
	{{135, 168, 6, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 27, 91},
	{{200, 224, 33, 245, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41, 224},
	{{70, 111, 10, 62, 200, 224, 38, 204, 14, 164, 0, 0, 0, 0, 0, 0}, 78, 114},
	{{158, 133, 252, 18, 242, 12, 16, 60, 5, 52, 251, 179, 38, 235, 12, 0}, 118, 184},
	{{2, 23, 116, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28, 215},
	{{33, 25, 170, 74, 215, 134, 151, 181, 175, 232, 20, 155, 189, 242, 13, 0}, 120, 167},
	{{160, 186, 218, 183, 167, 84, 59, 152, 13, 137, 80, 128, 0, 0, 0, 0}, 89, 233},
	{{32, 141, 196, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 29, 101},
	{{207, 24, 202, 226, 191, 136, 78, 124, 160, 0, 0, 0, 0, 0, 0, 0}, 67, 139},
	{{210, 173, 172, 27, 197, 57, 114, 146, 169, 32, 0, 0, 0, 0, 0, 0}, 79, 32},
	{{95, 113, 12, 123, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 32, 57},
	{{129, 108, 186, 28, 19, 229, 96, 134, 199, 254, 199, 64, 0, 0, 0, 0}, 91, 151},
	{{103, 226, 38, 123, 35, 199, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 49, 0},
	{{41, 117, 43, 35, 208, 115, 73, 64, 0, 0, 0, 0, 0, 0, 0, 0}, 63, 227},
	{{42, 220, 61, 34, 199, 183, 42, 16, 223, 135, 0, 135, 213, 150, 100, 0}, 118, 124},
	{{165, 227, 96, 243, 112, 171, 117, 106, 50, 37, 82, 60, 80, 0, 0, 0}, 104, 228},
	{{158, 60, 111, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 27, 64},
	{{124, 108, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 25, 179},
	{{232, 68, 132, 159, 156, 103, 95, 190, 76, 0, 0, 0, 0, 0, 0, 0}, 70, 107},
	{{70, 77, 240, 209, 72, 63, 63, 45, 125, 79, 77, 41, 13, 0, 0, 0}, 104, 206},
	{{146, 254, 7, 5, 68, 240, 67, 237, 112, 0, 0, 0, 0, 0, 0, 0}, 68, 95},
	{{162, 223, 117, 27, 2, 156, 94, 170, 157, 114, 162, 50, 0, 0, 0, 0}, 96, 219},
	{{161, 62, 191, 68, 239, 73, 100, 37, 168, 254, 139, 202, 252, 65, 74, 0}, 119, 138},
	{{248, 122, 115, 81, 15, 158, 136, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 53, 84},
	{{8, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11, 161},
	{{142, 96, 105, 133, 251, 57, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 52, 25},
	{{138, 196, 139, 131, 233, 93, 65, 242, 86, 169, 7, 72, 82, 128, 0, 0}, 107, 113},
	{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 2, 46},
	{{175, 151, 75, 238, 26, 12, 100, 186, 0, 0, 0, 0, 0, 0, 0, 0}, 63, 72},
	{{82, 205, 211, 176, 170, 79, 57, 153, 161, 218, 32, 48, 0, 0, 0, 0}, 93, 230},
	{{227, 123, 232, 74, 236, 202, 211, 121, 200, 8, 59, 189, 81, 219, 144, 0}, 117, 142},
	{{205, 196, 89, 90, 103, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41, 134},
	{{63, 145, 23, 127, 102, 216, 49, 36, 168, 164, 59, 133, 18, 146, 0, 0}, 112, 100},
	{{213, 72, 154, 16, 230, 236, 218, 203, 223, 51, 31, 251, 103, 64, 0, 0}, 109, 45},
	{{126, 148, 232, 152, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 30, 219},
	{{160, 72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 16, 52},
	{{137, 38, 146, 20, 99, 188, 83, 123, 159, 159, 64, 0, 0, 0, 0, 0}, 83, 240},
	{{123, 228, 36, 44, 242, 29, 51, 228, 140, 60, 237, 0, 0, 0, 0, 0}, 90, 13},
	{{163, 169, 25, 89, 190, 114, 165, 158, 140, 210, 192, 0, 0, 0, 0, 0}, 84, 191},
	{{225, 38, 70, 89, 218, 236, 60, 5, 69, 163, 248, 50, 163, 64, 0, 0}, 106, 95},
	{{91, 94, 36, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28, 65},
	{{209, 238, 110, 0, 2, 152, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 45, 195},
	{{57, 17, 224, 164, 69, 95, 138, 172, 111, 55, 239, 167, 160, 0, 0, 0}, 103, 21},
	{{112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4, 114},
	{{102, 96, 223, 28, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 31, 92},
	{{137, 204, 150, 75, 193, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 42, 237},
	{{136, 56, 252, 240, 85, 48, 248, 231, 17, 49, 47, 238, 15, 233, 159, 184}, 125, 172},
	{{57, 31, 132, 123, 234, 255, 37, 82, 167, 204, 37, 158, 128, 0, 0, 0}, 98, 116},
	{{55, 198, 139, 219, 161, 156, 140, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 55, 54},
	{{44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 8, 203},
	{{53, 38, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 16, 74},
	{{227, 62, 107, 236, 118, 156, 60, 34, 31, 179, 76, 221, 0, 0, 0, 0}, 96, 220},
	{{105, 40, 240, 216, 91, 61, 19, 128, 224, 0, 0, 0, 0, 0, 0, 0}, 67, 219},
	{{96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 3, 179},
	{{118, 142, 251, 249, 128, 105, 113, 16, 0, 0, 0, 0, 0, 0, 0, 0}, 61, 194},
	{{101, 70, 196, 238, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 32, 187},
	{{245, 173, 165, 177, 200, 161, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 50, 79},
	{{0, 198, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 19, 87},
	{{92, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 8, 126},
	{{125, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11, 106},
	{{56, 59, 35, 82, 101, 72, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 50, 96},
	{{184, 72, 77, 251, 8, 166, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 47, 45},
	{{143, 74, 132, 205, 218, 247, 30, 160, 145, 199, 138, 12, 89, 220, 0, 0}, 110, 8},
	{{30, 178, 111, 225, 73, 79, 173, 52, 0, 0, 0, 0, 0, 0, 0, 0}, 62, 226},
	{{224, 48, 154, 231, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 36, 222},
	{{123, 144, 170, 143, 85, 169, 130, 245, 214, 0, 0, 0, 0, 0, 0, 0}, 71, 218},
	{{166, 224, 212, 100, 149, 55, 35, 210, 246, 108, 41, 245, 127, 174, 128, 0}, 116, 59},
	{{75, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 8, 80},
	{{197, 128, 190, 87, 47, 53, 92, 64, 0, 0, 0, 0, 0, 0, 0, 0}, 58, 177},
	{{249, 10, 76, 217, 225, 20, 124, 205, 44, 159, 190, 8, 0, 0, 0, 0}, 98, 44},
	{{180, 226, 0, 167, 137, 232, 174, 120, 113, 95, 22, 184, 0, 0, 0, 0}, 93, 206},
	{{123, 153, 102, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 27, 64},
	{{5, 144, 206, 158, 239, 189, 171, 120, 69, 46, 128, 237, 0, 0, 0, 0}, 96, 236},
	{{159, 235, 60, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 22, 101},
	{{42, 194, 150, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 26, 49},
	{{205, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11, 179},
	{{19, 65, 141, 20, 127, 77, 70, 205, 151, 115, 157, 23, 118, 128, 0, 0}, 109, 112},
	{{96, 11, 214, 40, 245, 251, 61, 64, 128, 241, 183, 183, 0, 0, 0, 0}, 96, 31},
	{{120, 4, 235, 112, 34, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41, 111},
	{{110, 127, 207, 76, 100, 148, 130, 206, 249, 2, 104, 0, 0, 0, 0, 0}, 86, 65},
	{{226, 190, 191, 249, 173, 96, 127, 200, 62, 20, 0, 0, 0, 0, 0, 0}, 78, 222},
	{{89, 88, 182, 14, 78, 122, 213, 192, 0, 0, 0, 0, 0, 0, 0, 0}, 58, 4},
	{{167, 94, 163, 227, 28, 111, 117, 103, 224, 0, 0, 0, 0, 0, 0, 0}, 67, 67},
	{{57, 220, 53, 116, 243, 184, 242, 134, 16, 70, 83, 61, 161, 128, 0, 0}, 109, 197},
	{{63, 235, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 22, 121},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 1, 167},
	{{15, 159, 42, 167, 76, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 38, 140},
	{{216, 252, 113, 40, 239, 46, 172, 48, 103, 250, 82, 179, 136, 64, 0, 0}, 106, 193},
	{{158, 147, 16, 44, 124, 56, 44, 48, 138, 64, 169, 0, 0, 0, 0, 0}, 90, 47},
	{{238, 238, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 21, 187},
	{{63, 159, 177, 162, 106, 212, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 56, 102},
	{{59, 40, 252, 185, 187, 216, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 46, 237},
	{{2, 218, 11, 68, 173, 196, 16, 223, 2, 18, 122, 215, 154, 0, 0, 0}, 103, 237},
	{{3, 9, 206, 73, 108, 196, 183, 119, 141, 162, 10, 180, 115, 32, 0, 0}, 107, 115},
	{{17, 227, 208, 146, 63, 201, 73, 239, 29, 79, 80, 0, 0, 0, 0, 0}, 84, 217},
	{{115, 180, 176, 241, 52, 209, 6, 64, 189, 76, 0, 0, 0, 0, 0, 0}, 79, 21},
	{{191, 88, 98, 245, 91, 46, 137, 254, 170, 80, 11, 55, 212, 28, 128, 0}, 113, 3},
	{{97, 141, 171, 175, 22, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 48, 62},
	{{32, 204, 102, 191, 164, 242, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 47, 80},
	{{29, 133, 210, 252, 124, 66, 160, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 51, 184},
	{{207, 179, 54, 144, 116, 67, 29, 64, 13, 199, 0, 0, 0, 0, 0, 0}, 80, 197},
	{{129, 216, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 13, 63},
	{{50, 152, 249, 143, 174, 234, 240, 48, 158, 255, 80, 105, 0, 0, 0, 0}, 99, 62},
	{{105, 208, 95, 218, 44, 11, 87, 134, 109, 18, 138, 66, 17, 69, 128, 0}, 114, 231},
	{{151, 79, 158, 220, 122, 101, 210, 164, 64, 0, 0, 0, 0, 0, 0, 0}, 67, 158},
	{{236, 97, 87, 155, 254, 137, 122, 208, 168, 201, 194, 118, 224, 0, 0, 0}, 101, 118},
	{{14, 229, 193, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 30, 237},
	{{46, 154, 50, 80, 92, 147, 158, 86, 1, 112, 0, 0, 0, 0, 0, 0}, 79, 15},
	{{88, 131, 21, 84, 62, 86, 7, 110, 142, 251, 242, 110, 194, 175, 247, 0}, 122, 84},
	{{229, 216, 111, 92, 173, 32, 63, 70, 36, 84, 6, 74, 136, 166, 38, 0}, 119, 205},
	{{121, 147, 216, 245, 37, 189, 146, 63, 145, 74, 128, 0, 0, 0, 0, 0}, 82, 220},
	{{44, 26, 254, 11, 181, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 40, 42},
	{{209, 114, 97, 249, 227, 159, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 51, 144},
	{{184, 244, 43, 117, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 37, 74},
	{{60, 81, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 19, 89},
	{{18, 40, 21, 113, 226, 91, 195, 88, 161, 19, 142, 0, 0, 0, 0, 0}, 88, 77},
	{{57, 0, 212, 158, 56, 51, 108, 198, 59, 5, 137, 196, 0, 0, 0, 0}, 94, 2},
	{{168, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 14, 75},
	{{64, 181, 254, 103, 1, 230, 117, 199, 128, 0, 0, 0, 0, 0, 0, 0}, 65, 18},
	{{212, 48, 214, 127, 78, 176, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 46, 246},
	{{155, 185, 236, 163, 204, 49, 129, 120, 183, 47, 10, 243, 65, 92, 192, 0}, 114, 10},
	{{94, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 14, 207},
	{{19, 210, 136, 113, 73, 79, 132, 196, 224, 0, 0, 0, 0, 0, 0, 0}, 68, 41},
	{{24, 203, 246, 242, 241, 223, 150, 237, 213, 202, 11, 128, 0, 0, 0, 0}, 89, 102},
	{{115, 59, 171, 221, 172, 181, 170, 67, 115, 205, 44, 107, 162, 67, 56, 0}, 118, 118},
	{{250, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 10, 146},
	{{203, 240, 28, 158, 182, 12, 86, 182, 142, 47, 143, 57, 239, 0, 0, 0}, 104, 122},
	{{196, 218, 109, 52, 2, 0, 64, 153, 34, 250, 240, 185, 117, 0, 0, 0}, 107, 6},
	{{137, 131, 191, 40, 72, 209, 74, 64, 0, 0, 0, 0, 0, 0, 0, 0}, 58, 18},
	{{236, 126, 167, 37, 185, 20, 34, 207, 76, 0, 0, 0, 0, 0, 0, 0}, 70, 83},
	{{129, 192, 245, 137, 251, 52, 75, 68, 81, 112, 146, 133, 64, 0, 0, 0}, 99, 90},
	{{7, 31, 148, 19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 32, 140},
	{{112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4, 242},
	{{167, 50, 202, 179, 74, 146, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 50, 31},
	{{44, 188, 186, 250, 229, 71, 28, 118, 35, 253, 245, 191, 199, 18, 0, 0}, 111, 9},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 1, 230},
	{{156, 163, 215, 175, 71, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 47, 50},
	{{67, 24, 151, 198, 242, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41, 34},
	{{134, 107, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 17, 11},
	{{35, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 8, 71},
	{{46, 196, 84, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 22, 146},
	{{82, 172, 8, 26, 154, 34, 125, 188, 5, 149, 159, 44, 78, 222, 236, 176}, 124, 249},
	{{78, 157, 79, 70, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 39, 143},
	{{231, 5, 210, 247, 198, 5, 157, 191, 206, 225, 149, 142, 207, 40, 0, 0}, 110, 17},
	{{38, 254, 235, 199, 191, 60, 43, 159, 190, 243, 203, 185, 184, 218, 132, 0}, 119, 60},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 1, 162},
	{{95, 240, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 12, 5},
	{{17, 128, 244, 178, 160, 78, 83, 92, 0, 0, 0, 0, 0, 0, 0, 0}, 62, 139},
	{{18, 102, 62, 251, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 39, 8},
	{{30, 75, 108, 40, 231, 166, 233, 220, 163, 176, 252, 210, 60, 30, 128, 0}, 114, 246},
	{{18, 3, 207, 64, 25, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 42, 171},
	{{52, 83, 235, 61, 164, 236, 83, 173, 143, 105, 14, 0, 0, 0, 0, 0}, 88, 206},
	{{166, 175, 186, 208, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28, 163},
	{{221, 154, 82, 98, 41, 126, 85, 52, 0, 0, 0, 0, 0, 0, 0, 0}, 62, 166},
	{{94, 84, 182, 120, 204, 232, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 51, 128},
	{{27, 174, 227, 228, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 31, 59},
	{{218, 12, 4, 156, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 32, 179},
	{{9, 5, 190, 195, 60, 216, 80, 150, 128, 117, 86, 128, 128, 112, 98, 208}, 124, 87},
	{{7, 226, 104, 112, 212, 9, 172, 124, 209, 121, 170, 229, 44, 178, 128, 0}, 114, 29},
	{{47, 71, 174, 76, 52, 83, 23, 18, 106, 48, 56, 32, 0, 0, 0, 0}, 91, 184},
	{{51, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 14, 45},
	{{28, 182, 167, 124, 28, 22, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 55, 144},
	{{34, 61, 14, 51, 253, 17, 19, 170, 49, 206, 188, 207, 247, 167, 192, 0}, 114, 119},
	{{2, 235, 18, 14, 195, 66, 237, 30, 0, 0, 0, 0, 0, 0, 0, 0}, 64, 113},
	{{51, 182, 142, 133, 127, 96, 159, 132, 99, 161, 64, 0, 0, 0, 0, 0}, 82, 50},
	{{170, 145, 230, 123, 215, 189, 73, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 56, 207},
	{{151, 166, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 21, 3},
	{{16, 141, 196, 129, 132, 207, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 58, 13},
	{{205, 25, 184, 191, 201, 206, 109, 224, 0, 0, 0, 0, 0, 0, 0, 0}, 59, 42},
	{{48, 114, 33, 103, 247, 255, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 50, 31},
	{{179, 156, 119, 146, 125, 21, 42, 146, 237, 213, 191, 132, 0, 0, 0, 0}, 94, 30},
	{{179, 129, 186, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 29, 94},
	{{17, 179, 217, 188, 128, 212, 4, 4, 152, 0, 0, 0, 0, 0, 0, 0}, 71, 190},
	{{132, 63, 74, 89, 209, 64, 63, 192, 0, 0, 0, 0, 0, 0, 0, 0}, 59, 238},
	{{16, 50, 248, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 30, 20},
	{{189, 96, 58, 53, 191, 235, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 51, 84},
	{{111, 98, 6, 65, 35, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 42, 108},
	{{118, 223, 83, 220, 110, 122, 23, 112, 185, 155, 73, 0, 0, 0, 0, 0}, 89, 136},
	{{173, 191, 150, 197, 204, 35, 169, 79, 31, 214, 251, 240, 0, 0, 0, 0}, 93, 196},
	{{26, 76, 129, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28, 67},
	{{231, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 12, 104},
	{{93, 172, 223, 252, 203, 0, 206, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 55, 15},
	{{53, 142, 203, 124, 104, 51, 241, 12, 161, 17, 101, 245, 120, 110, 192, 199}, 128, 237},
	{{9, 77, 120, 197, 193, 10, 237, 174, 233, 2, 165, 11, 229, 47, 144, 0}, 116, 224},
	{{99, 161, 189, 88, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 36, 179},
	{{18, 8, 76, 66, 2, 185, 206, 132, 224, 0, 0, 0, 0, 0, 0, 0}, 67, 84},
	{{169, 53, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 22, 65},
	{{136, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 5, 178},
	{{131, 162, 144, 124, 12, 98, 242, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 55, 154},
	{{75, 50, 129, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 27, 106},
	{{212, 183, 40, 225, 152, 136, 174, 91, 0, 0, 0, 0, 0, 0, 0, 0}, 67, 125},
	{{158, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 9, 118},
	{{7, 48, 132, 149, 169, 212, 198, 137, 202, 0, 0, 0, 0, 0, 0, 0}, 73, 52},
	{{173, 195, 129, 163, 141, 249, 40, 64, 0, 0, 0, 0, 0, 0, 0, 0}, 58, 173},
	{{109, 79, 75, 219, 205, 182, 22, 245, 223, 17, 146, 78, 109, 119, 128, 0}, 113, 8},
	{{174, 195, 24, 182, 215, 198, 214, 86, 34, 128, 0, 0, 0, 0, 0, 0}, 74, 211},
	{{22, 40, 51, 109, 70, 91, 152, 56, 0, 0, 0, 0, 0, 0, 0, 0}, 61, 253},
	{{169, 115, 246, 126, 65, 118, 219, 192, 0, 0, 0, 0, 0, 0, 0, 0}, 59, 47},
	{{154, 37, 70, 124, 107, 123, 232, 241, 164, 142, 71, 226, 182, 126, 0, 0}, 112, 73},
	{{6, 108, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 19, 192},
	{{216, 167, 158, 158, 222, 19, 96, 28, 40, 6, 70, 12, 147, 27, 85, 240}, 128, 55},
	{{72, 222, 52, 69, 69, 206, 163, 106, 235, 206, 80, 128, 0, 0, 0, 0}, 94, 147},
	{{150, 112, 106, 56, 15, 243, 154, 97, 134, 110, 160, 20, 183, 144, 234, 8}, 125, 86},
	{{58, 186, 106, 58, 124, 171, 53, 85, 33, 100, 64, 0, 0, 0, 0, 0}, 82, 16},
	{{7, 195, 22, 31, 62, 217, 209, 46, 90, 49, 189, 50, 168, 126, 0, 0}, 111, 167},
	{{92, 44, 159, 198, 185, 94, 231, 177, 64, 0, 0, 0, 0, 0, 0, 0}, 67, 148},
	{{169, 108, 190, 162, 23, 39, 140, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 54, 66},
	{{161, 5, 3, 11, 158, 157, 166, 212, 246, 22, 140, 101, 92, 0, 0, 0}, 104, 70},
	{{71, 191, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 16, 166},
	{{48, 136, 194, 145, 57, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 44, 109},
	{{144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 5, 226},
	{{223, 209, 10, 57, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 32, 8},
	{{154, 79, 170, 9, 43, 139, 249, 176, 186, 72, 216, 0, 0, 0, 0, 0}, 85, 218},
	{{1, 8, 123, 205, 167, 134, 128, 102, 10, 72, 0, 0, 0, 0, 0, 0}, 78, 54},
	{{31, 105, 48, 77, 103, 187, 99, 67, 96, 0, 0, 0, 0, 0, 0, 0}, 67, 48},
	{{14, 73, 54, 76, 232, 35, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 51, 244},
	{{14, 109, 251, 190, 36, 253, 99, 120, 94, 64, 0, 0, 0, 0, 0, 0}, 74, 50},
	{{122, 170, 9, 134, 124, 91, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 54, 173},
	{{246, 10, 85, 88, 82, 217, 95, 56, 216, 203, 160, 0, 0, 0, 0, 0}, 84, 245},
	{{77, 100, 114, 207, 150, 177, 69, 134, 74, 131, 147, 117, 177, 64, 210, 128}, 121, 54},
	{{171, 123, 22, 138, 132, 229, 250, 81, 186, 227, 146, 27, 170, 205, 128, 0}, 113, 86},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 2, 115},
	{{12, 35, 50, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 24, 144},
	{{255, 124, 179, 165, 169, 250, 66, 171, 223, 125, 247, 0, 0, 0, 0, 0}, 89, 171},
	{{244, 235, 211, 10, 251, 255, 206, 6, 198, 12, 50, 136, 0, 0, 0, 0}, 93, 231},
	{{221, 77, 237, 41, 50, 33, 103, 24, 25, 127, 208, 0, 0, 0, 0, 0}, 88, 34},
	{{216, 69, 47, 53, 117, 24, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 53, 225},
	{{180, 87, 25, 236, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 38, 174},
	{{110, 32, 24, 34, 116, 133, 245, 128, 123, 95, 125, 122, 100, 129, 128, 0}, 113, 37},
	{{27, 117, 179, 112, 133, 137, 110, 193, 246, 201, 219, 65, 56, 234, 106, 128}, 121, 39},
	{{186, 117, 252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 23, 59},
	{{243, 119, 54, 16, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 34, 96},
	{{160, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 3, 147},
	{{78, 48, 117, 200, 245, 118, 115, 240, 170, 125, 84, 103, 33, 168, 0, 0}, 110, 56},
	{{201, 253, 184, 254, 143, 81, 95, 42, 243, 147, 96, 145, 23, 26, 0, 0}, 111, 234},
	{{41, 215, 84, 136, 234, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 46, 199},
	{{91, 244, 137, 184, 231, 95, 135, 10, 184, 0, 0, 0, 0, 0, 0, 0}, 69, 191},
	{{113, 31, 181, 245, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 40, 235},
	{{181, 216, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 20, 45},
	{{87, 26, 119, 229, 97, 255, 9, 43, 32, 0, 0, 0, 0, 0, 0, 0}, 67, 164},
	{{205, 112, 67, 163, 196, 148, 5, 105, 8, 138, 144, 3, 171, 213, 159, 128}, 121, 130},
	{{136, 27, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 18, 166},
	{{2, 175, 111, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 24, 140},
	{{222, 131, 85, 218, 16, 229, 44, 230, 243, 76, 250, 139, 1, 203, 108, 0}, 118, 47},
	{{101, 180, 77, 142, 194, 73, 196, 246, 107, 100, 194, 72, 204, 124, 0, 0}, 111, 148},
	{{96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 3, 103},
	{{46, 62, 191, 130, 110, 128, 235, 62, 68, 39, 58, 152, 207, 204, 96, 0}, 116, 94},
	{{111, 11, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 19, 85},
	{{58, 43, 14, 93, 102, 210, 117, 208, 222, 171, 130, 41, 16, 16, 0, 0}, 109, 250},
	{{141, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 16, 153},
	{{170, 153, 160, 170, 144, 235, 122, 8, 106, 34, 24, 32, 102, 57, 12, 168}, 125, 182},
	{{34, 113, 163, 107, 61, 177, 39, 172, 242, 2, 130, 0, 0, 0, 0, 0}, 94, 23},
	{{222, 191, 239, 110, 162, 191, 195, 181, 80, 50, 85, 240, 88, 32, 0, 0}, 108, 38},
	{{179, 82, 253, 151, 212, 0, 72, 253, 175, 22, 34, 78, 53, 32, 0, 0}, 110, 121},
	{{10, 162, 20, 46, 164, 64, 88, 1, 202, 204, 124, 0, 0, 0, 0, 0}, 87, 146},
	{{210, 99, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 16, 138},
	{{183, 200, 1, 2, 51, 6, 66, 142, 20, 77, 48, 244, 0, 0, 0, 0}, 94, 149},
	{{29, 20, 224, 57, 204, 161, 131, 254, 53, 133, 163, 0, 0, 0, 0, 0}, 88, 232},
	{{75, 58, 170, 52, 146, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 45, 255},
	{{92, 21, 1, 113, 185, 88, 160, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 51, 148},
	{{103, 180, 222, 187, 129, 117, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 48, 117},
	{{32, 76, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 14, 237},
	{{7, 60, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 19, 113},
	{{167, 122, 205, 185, 21, 199, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 57, 162},
	{{21, 78, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 21, 225},
	{{92, 159, 167, 169, 136, 176, 95, 255, 87, 137, 112, 16, 0, 0, 0, 0}, 92, 210},
	{{84, 120, 160, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 22, 34},
	{{126, 5, 126, 176, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 29, 224},
	{{4, 58, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 16, 143},
	{{239, 154, 181, 182, 189, 211, 244, 53, 144, 0, 0, 0, 0, 0, 0, 0}, 68, 216},
	{{254, 188, 139, 167, 135, 47, 147, 239, 187, 106, 228, 156, 234, 234, 102, 0}, 120, 239},
	{{225, 168, 138, 92, 193, 255, 47, 233, 11, 154, 205, 86, 209, 88, 0, 0}, 111, 54},
	{{223, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 9, 35},
	{{235, 252, 115, 10, 151, 104, 193, 207, 38, 228, 229, 245, 42, 13, 108, 0}, 119, 230},
	{{1, 137, 53, 36, 210, 184, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 45, 234},
	{{149, 182, 72, 197, 92, 229, 9, 10, 220, 128, 72, 19, 4, 58, 192, 0}, 115, 70},
	{{105, 73, 57, 108, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 32, 246},
	{{189, 61, 230, 24, 235, 82, 58, 102, 97, 111, 121, 252, 156, 94, 191, 166}, 127, 217},
	{{193, 108, 231, 86, 140, 14, 192, 4, 135, 80, 129, 166, 158, 61, 230, 20}, 128, 201},
	{{110, 77, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 17, 49},
	{{3, 102, 36, 231, 15, 242, 143, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 57, 2},
	{{81, 189, 220, 168, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 38, 64},
	{{168, 75, 133, 180, 91, 165, 77, 232, 0, 0, 0, 0, 0, 0, 0, 0}, 62, 239},
	{{106, 179, 186, 109, 81, 234, 233, 167, 101, 160, 90, 102, 174, 234, 208, 0}, 116, 47},
	{{46, 105, 234, 21, 23, 247, 169, 33, 47, 5, 0, 0, 0, 0, 0, 0}, 80, 43},
	{{152, 144, 100, 142, 129, 23, 227, 50, 67, 81, 249, 116, 0, 0, 0, 0}, 94, 17},
	{{109, 74, 145, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 26, 5},
	{{100, 243, 22, 230, 38, 44, 128, 86, 132, 57, 0, 0, 0, 0, 0, 0}, 81, 240},
	{{153, 251, 115, 65, 104, 179, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 50, 197},
	{{43, 113, 60, 224, 36, 20, 42, 161, 24, 223, 192, 0, 0, 0, 0, 0}, 84, 192},
	{{61, 77, 121, 176, 138, 152, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 47, 160},
	{{119, 194, 146, 49, 59, 242, 25, 220, 122, 104, 80, 0, 0, 0, 0, 0}, 84, 199},
	{{254, 162, 155, 47, 187, 3, 1, 114, 142, 191, 152, 44, 144, 26, 202, 0}, 127, 217},
	{{176, 1, 114, 42, 191, 145, 43, 1, 141, 18, 64, 0, 0, 0, 0, 0}, 83, 75},
	{{170, 244, 67, 132, 145, 163, 76, 213, 85, 237, 248, 22, 207, 64, 0, 0}, 106, 222},
	{{102, 190, 58, 32, 75, 15, 89, 163, 64, 7, 168, 0, 0, 0, 0, 0}, 85, 39},
	{{124, 170, 35, 47, 152, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 45, 9},
	{{192, 221, 20, 228, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33, 217},
	{{208, 178, 136, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 25, 142},
	{{188, 68, 77, 30, 68, 153, 102, 180, 0, 0, 0, 0, 0, 0, 0, 0}, 62, 18},
	{{114, 178, 121, 188, 205, 233, 35, 77, 34, 197, 158, 174, 101, 0, 0, 0}, 104, 180},
	{{195, 98, 67, 12, 13, 43, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 56, 205},
	{{146, 190, 42, 222, 14, 54, 28, 128, 0, 0, 0, 0, 0, 0, 0, 0}, 57, 251},
	{{185, 202, 148, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 22, 178},
	{{138, 30, 129, 95, 224, 161, 120, 128, 0, 0, 0, 0, 0, 0, 0, 0}, 59, 198},
	{{69, 181, 5, 227, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 34, 84},
	{{90, 180, 0, 164, 227, 75, 174, 119, 128, 0, 0, 0, 0, 0, 0, 0}, 66, 128},
	{{20, 60, 58, 119, 245, 177, 162, 186, 13, 112, 211, 239, 128, 0, 0, 0}, 97, 75},
	{{158, 124, 157, 25, 230, 139, 51, 212, 76, 109, 236, 210, 48, 0, 0, 0}, 101, 192},
	{{125, 108, 242, 36, 94, 13, 36, 106, 90, 51, 83, 217, 131, 151, 0, 0}, 114, 60},
	{{222, 218, 162, 158, 15, 53, 191, 178, 0, 0, 0, 0, 0, 0, 0, 0}, 63, 169},
	{{104, 202, 127, 109, 73, 16, 17, 12, 0, 0, 0, 0, 0, 0, 0, 0}, 62, 10},
	{{172, 171, 246, 26, 176, 34, 22, 152, 246, 56, 173, 120, 105, 60, 92, 0}, 118, 64},
	{{190, 22, 171, 206, 109, 186, 179, 128, 253, 182, 108, 212, 220, 167, 171, 180}, 127, 182},
	{{119, 208, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 13, 29},
	{{160, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 3, 39},
	{{170, 144, 64, 2, 107, 166, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 51, 93},
	{{234, 9, 96, 20, 156, 157, 1, 34, 88, 0, 0, 0, 0, 0, 0, 0}, 75, 228},
	{{147, 237, 16, 120, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 34, 236},
	{{182, 189, 162, 158, 223, 90, 173, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 56, 190},
	{{116, 148, 142, 240, 10, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 49, 217},
	{{211, 73, 140, 69, 252, 27, 75, 46, 37, 6, 147, 32, 0, 0, 0, 0}, 93, 74},
	{{148, 61, 120, 49, 220, 65, 150, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 61, 180},
	{{172, 35, 202, 180, 129, 75, 240, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 55, 91},
	{{215, 109, 147, 157, 32, 28, 52, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 54, 230},
	{{151, 26, 182, 112, 205, 220, 160, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 52, 175},
	{{73, 91, 93, 61, 196, 3, 66, 26, 149, 96, 0, 0, 0, 0, 0, 0}, 75, 171},
	{{203, 163, 52, 247, 28, 119, 56, 223, 138, 70, 174, 97, 77, 59, 46, 0}, 120, 202},
	{{251, 50, 228, 178, 202, 195, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 49, 113},
	{{217, 159, 164, 199, 14, 237, 170, 184, 100, 231, 92, 222, 0, 0, 0, 0}, 96, 187},
	{{16, 161, 85, 193, 202, 21, 3, 155, 63, 116, 124, 203, 34, 13, 215, 0}, 120, 38},
	{{111, 52, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 26, 35},
	{{69, 12, 116, 151, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 38, 115},
	{{187, 60, 97, 40, 112, 101, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 51, 18},
	{{230, 194, 136, 255, 206, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 39, 34},
	{{179, 239, 170, 107, 3, 13, 212, 67, 177, 69, 8, 0, 0, 0, 0, 0}, 87, 75},
	{{11, 58, 130, 89, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33, 232},
	{{217, 178, 43, 203, 234, 20, 234, 186, 157, 88, 146, 192, 0, 0, 0, 0}, 91, 154},
	{{6, 180, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 19, 195},
	{{157, 154, 218, 158, 39, 224, 103, 230, 164, 0, 0, 0, 0, 0, 0, 0}, 70, 122},
	{{225, 10, 131, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 24, 97},
	{{16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 5, 220},
	{{166, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 7, 80},
	{{29, 190, 131, 215, 232, 246, 41, 226, 52, 192, 0, 0, 0, 0, 0, 0}, 77, 133},
	{{138, 74, 163, 93, 12, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 38, 93},
	{{229, 64, 97, 41, 28, 243, 249, 185, 97, 35, 49, 27, 175, 24, 0, 0}, 110, 176},
	{{6, 73, 94, 160, 186, 216, 84, 117, 233, 169, 146, 234, 0, 0, 0, 0}, 95, 68},
	{{163, 40, 242, 81, 224, 35, 72, 194, 176, 78, 224, 174, 12, 0, 0, 0}, 103, 247},
	{{2, 205, 40, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 29, 240},
	{{174, 225, 240, 160, 212, 8, 246, 67, 36, 0, 0, 0, 0, 0, 0, 0}, 74, 83},
	{{5, 117, 182, 141, 166, 249, 196, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 55, 132},
	{{46, 152, 169, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 24, 217},
	{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 3, 214},
	{{233, 202, 159, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 34, 193},
	{{172, 54, 159, 5, 14, 245, 106, 182, 2, 0, 0, 0, 0, 0, 0, 0}, 71, 61},
	{{241, 222, 251, 114, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 39, 65},
	{{31, 243, 190, 4, 207, 198, 249, 59, 167, 127, 93, 64, 0, 0, 0, 0}, 91, 108},
	{{201, 35, 222, 208, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28, 244},
	{{187, 105, 13, 114, 238, 197, 145, 23, 169, 116, 91, 28, 0, 0, 0, 0}, 95, 194},
	{{251, 251, 121, 168, 152, 178, 147, 188, 229, 123, 154, 242, 190, 165, 173, 48}, 124, 82},
	{{66, 187, 191, 164, 31, 196, 40, 186, 148, 115, 134, 57, 222, 254, 48, 0}, 116, 45},
	{{209, 17, 111, 41, 154, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 48, 224},
	{{40, 245, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 22, 17},
	{{72, 121, 151, 83, 170, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 44, 133},
	{{171, 172, 101, 238, 201, 148, 23, 81, 4, 11, 64, 0, 0, 0, 0, 0}, 85, 125},
	{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 3, 42},
	{{20, 46, 27, 93, 195, 184, 6, 162, 109, 225, 22, 152, 0, 0, 0, 0}, 96, 140},
	{{243, 122, 30, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28, 91},
	{{89, 250, 80, 72, 148, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 48, 92},
	{{187, 152, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 13, 125},
	{{172, 160, 143, 114, 128, 239, 174, 133, 176, 154, 159, 134, 10, 0, 0, 0}, 106, 249},
	{{254, 202, 113, 112, 173, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 40, 202},
	{{80, 152, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 13, 107},
	{{222, 216, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 13, 124},
	{{219, 138, 253, 12, 188, 197, 48, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 53, 57},
	{{124, 41, 173, 8, 202, 192, 61, 254, 174, 48, 239, 112, 0, 0, 0, 0}, 92, 181},
	{{195, 236, 245, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 24, 107},
	{{83, 82, 42, 244, 136, 191, 197, 81, 91, 154, 216, 85, 29, 150, 198, 22}, 128, 101},
	{{112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4, 102},
	{{44, 30, 219, 248, 214, 88, 225, 132, 0, 0, 0, 0, 0, 0, 0, 0}, 62, 136},
	{{41, 171, 206, 178, 195, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 45, 114},
	{{159, 15, 180, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 22, 215},
	{{42, 188, 37, 174, 86, 40, 4, 84, 174, 216, 0, 0, 0, 0, 0, 0}, 79, 249},
	{{185, 227, 85, 177, 219, 95, 250, 227, 69, 154, 118, 0, 0, 0, 0, 0}, 88, 29},
	{{22, 185, 238, 100, 25, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 44, 71},
	{{122, 149, 117, 77, 88, 250, 187, 203, 136, 22, 85, 42, 105, 234, 79, 8}, 127, 112},
	{{93, 152, 229, 140, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 31, 72},
	{{129, 37, 165, 167, 241, 24, 37, 40, 2, 128, 0, 0, 0, 0, 0, 0}, 73, 155},
	{{30, 202, 177, 3, 253, 202, 164, 248, 0, 0, 0, 0, 0, 0, 0, 0}, 61, 66},
	{{176, 25, 220, 120, 194, 228, 10, 45, 225, 142, 192, 96, 0, 0, 0, 0}, 91, 77},
	{{96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 3, 109},
	{{82, 56, 12, 204, 61, 45, 147, 240, 221, 0, 0, 0, 0, 0, 0, 0}, 72, 37},
	{{242, 38, 240, 41, 140, 75, 250, 37, 175, 115, 97, 224, 0, 0, 0, 0}, 91, 56},
	{{251, 192, 23, 90, 135, 56, 252, 56, 79, 219, 80, 167, 22, 0, 0, 0}, 103, 5},
	{{62, 128, 139, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 25, 15},
	{{214, 1, 84, 232, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 29, 183},
	{{207, 90, 237, 137, 171, 140, 227, 88, 250, 26, 197, 162, 163, 0, 0, 0}, 105, 171},
	{{196, 151, 235, 232, 114, 248, 1, 207, 193, 184, 186, 71, 157, 0, 0, 0}, 112, 202},
	{{152, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 5, 136},
	{{9, 174, 211, 200, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 37, 107},
	{{89, 150, 95, 28, 209, 13, 125, 159, 254, 244, 110, 0, 0, 0, 0, 0}, 87, 193},
	{{23, 28, 202, 10, 90, 158, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 52, 4},
	{{48, 25, 180, 9, 84, 236, 6, 144, 30, 198, 41, 56, 0, 0, 0, 0}, 96, 68},
	{{252, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 7, 40},
	{{20, 165, 57, 130, 164, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 39, 255},
	{{167, 56, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 18, 108},
	{{91, 204, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 14, 219},
	{{24, 46, 9, 4, 170, 150, 56, 130, 127, 120, 118, 104, 168, 48, 0, 0}, 108, 12},
	{{156, 60, 245, 247, 189, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 40, 84},
	{{148, 104, 187, 174, 129, 28, 127, 162, 92, 222, 52, 18, 0, 0, 0, 0}, 96, 33},
	{{38, 253, 182, 153, 233, 194, 159, 41, 94, 193, 254, 160, 0, 0, 0, 0}, 91, 199},
	{{156, 77, 105, 235, 145, 216, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 46, 52},
	{{100, 211, 238, 147, 65, 222, 99, 73, 252, 113, 46, 113, 52, 136, 0, 0}, 113, 184},
	{{13, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 18, 124},
	{{29, 240, 141, 230, 78, 237, 25, 135, 131, 6, 65, 77, 77, 248, 0, 0}, 109, 128},
	{{15, 192, 109, 31, 149, 221, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 49, 255},
	{{80, 185, 170, 71, 41, 58, 158, 106, 253, 7, 2, 184, 173, 0, 0, 0}, 105, 146},
	{{16, 229, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 24, 172},
	{{169, 2, 153, 9, 169, 203, 245, 154, 184, 0, 0, 0, 0, 0, 0, 0}, 70, 116},
	{{144, 135, 239, 164, 142, 187, 64, 109, 0, 0, 0, 0, 0, 0, 0, 0}, 66, 189},
	{{170, 78, 252, 227, 242, 199, 130, 251, 200, 0, 0, 0, 0, 0, 0, 0}, 70, 10},
	{{232, 18, 15, 126, 166, 126, 58, 25, 209, 62, 76, 79, 0, 0, 0, 0}, 98, 184},
	{{170, 82, 72, 53, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33, 98},
	{{152, 100, 37, 122, 242, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 42, 37},
	{{174, 231, 230, 33, 71, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 46, 174},
	{{74, 225, 252, 153, 202, 8, 162, 39, 64, 0, 0, 0, 0, 0, 0, 0}, 67, 251},
	{{167, 186, 101, 187, 122, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 42, 115},
	{{83, 7, 21, 122, 243, 67, 171, 146, 145, 160, 168, 103, 223, 64, 0, 0}, 107, 252},
	{{83, 132, 219, 86, 86, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 40, 176},
	{{22, 113, 72, 102, 73, 16, 236, 57, 197, 122, 31, 0, 0, 0, 0, 0}, 91, 155},
	{{250, 59, 64, 35, 72, 112, 159, 85, 200, 5, 193, 39, 152, 185, 148, 16}, 124, 36},
	{{220, 21, 48, 164, 224, 121, 17, 69, 10, 118, 106, 0, 0, 0, 0, 0}, 88, 202},
	{{160, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 5, 208},
	{{247, 64, 83, 125, 195, 225, 50, 76, 18, 104, 0, 0, 0, 0, 0, 0}, 77, 158},
	{{78, 91, 31, 202, 189, 25, 13, 133, 220, 0, 0, 0, 0, 0, 0, 0}, 72, 136},
	{{105, 197, 26, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28, 191},
	{{14, 31, 154, 242, 241, 231, 55, 151, 223, 56, 134, 255, 113, 206, 69, 0}, 120, 126},
	{{247, 193, 58, 176, 16, 71, 31, 120, 213, 104, 231, 83, 26, 118, 91, 135}, 128, 139},
	{{136, 32, 240, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 25, 216},
	{{100, 238, 112, 40, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 29, 93},
	{{80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4, 196},
	{{233, 224, 254, 57, 33, 205, 140, 217, 181, 72, 0, 0, 0, 0, 0, 0}, 81, 119},
	{{107, 75, 65, 158, 128, 142, 191, 188, 188, 240, 148, 243, 116, 0, 0, 0}, 104, 93},
	{{39, 70, 120, 114, 69, 237, 95, 48, 233, 176, 91, 154, 0, 0, 0, 0}, 96, 183},
	{{10, 61, 43, 101, 64, 102, 208, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 52, 207},
	{{151, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 9, 102},
	{{210, 241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 19, 36},
	{{52, 222, 249, 31, 108, 137, 199, 1, 242, 173, 184, 144, 0, 0, 0, 0}, 93, 41},
	{{123, 111, 88, 192, 69, 70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 47, 70},
	{{180, 82, 188, 125, 140, 8, 196, 74, 0, 0, 0, 0, 0, 0, 0, 0}, 63, 218},
	{{77, 158, 34, 101, 196, 102, 56, 220, 42, 143, 181, 187, 240, 64, 161, 0}, 120, 226},
	{{88, 220, 222, 38, 23, 108, 5, 148, 185, 110, 20, 14, 67, 61, 0, 0}, 114, 25},
	{{90, 65, 220, 165, 197, 133, 110, 92, 228, 19, 2, 17, 0, 0, 0, 0}, 98, 6},
	{{35, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11, 26},
	{{103, 123, 49, 209, 228, 229, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 52, 149},
	{{50, 244, 58, 191, 95, 156, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 46, 127},
	{{140, 169, 75, 77, 78, 86, 40, 16, 0, 0, 0, 0, 0, 0, 0, 0}, 62, 144},
	{{99, 176, 175, 83, 114, 50, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 56, 213},
	{{19, 208, 211, 76, 85, 176, 247, 64, 0, 0, 0, 0, 0, 0, 0, 0}, 58, 115},
	{{153, 28, 188, 113, 211, 116, 7, 178, 136, 205, 96, 0, 0, 0, 0, 0}, 83, 146},
	{{160, 180, 220, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 26, 58},
	{{234, 6, 112, 19, 61, 74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 47, 222},
	{{97, 110, 34, 117, 149, 148, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 50, 16},
	{{99, 173, 119, 73, 250, 30, 144, 30, 128, 0, 0, 0, 0, 0, 0, 0}, 65, 169},
	{{169, 134, 111, 89, 9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 40, 175},
	{{134, 80, 227, 43, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 32, 3},
	{{231, 243, 35, 80, 75, 207, 128, 137, 54, 170, 71, 238, 0, 0, 0, 0}, 96, 2},
	{{189, 190, 121, 135, 160, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 36, 193},
	{{143, 155, 216, 193, 239, 205, 204, 153, 143, 236, 69, 23, 200, 211, 0, 0}, 118, 151},
	{{32, 1, 115, 244, 33, 219, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 51, 182},
	{{220, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 10, 148},
	{{206, 87, 135, 235, 116, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 42, 53},
	{{152, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11, 87},
	{{58, 146, 188, 233, 230, 236, 192, 214, 168, 128, 0, 0, 0, 0, 0, 0}, 73, 235},
	{{84, 220, 82, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 23, 51},
	{{106, 145, 142, 42, 186, 186, 58, 1, 48, 98, 165, 131, 48, 156, 192, 0}, 116, 11},
	{{53, 219, 120, 242, 166, 214, 81, 130, 64, 0, 0, 0, 0, 0, 0, 0}, 68, 28},
	{{240, 120, 76, 163, 32, 197, 181, 251, 98, 220, 29, 226, 0, 0, 0, 0}, 96, 73},
	{{234, 197, 12, 160, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28, 216},
	{{191, 94, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 16, 99},
	{{200, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 18, 35},
	{{29, 129, 47, 83, 19, 75, 158, 1, 28, 24, 26, 147, 82, 119, 140, 100}, 127, 195},
	{{241, 174, 26, 53, 152, 112, 200, 134, 84, 187, 177, 176, 42, 64, 0, 0}, 108, 176},
	{{77, 171, 145, 48, 195, 84, 190, 36, 122, 199, 18, 0, 0, 0, 0, 0}, 87, 217},
	{{105, 104, 135, 53, 226, 118, 238, 169, 9, 253, 132, 162, 217, 123, 191, 96}, 126, 244},
	{{160, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 3, 125},
	{{41, 85, 143, 128, 91, 137, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 50, 219},
	{{116, 110, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 18, 165},
	{{75, 213, 44, 16, 43, 157, 34, 171, 98, 117, 109, 151, 5, 60, 224, 0}, 117, 6},
	{{229, 23, 116, 61, 80, 139, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 53, 47},
	{{83, 123, 74, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 23, 73},
	{{151, 243, 45, 217, 216, 158, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 47, 98},
	{{171, 184, 110, 211, 237, 114, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 52, 21},
	{{7, 246, 199, 119, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 32, 142},
	{{103, 47, 70, 17, 31, 232, 44, 75, 145, 155, 100, 216, 0, 0, 0, 0}, 93, 34},
	{{65, 170, 169, 100, 167, 147, 142, 251, 20, 64, 0, 0, 0, 0, 0, 0}, 74, 41},
	{{235, 6, 229, 248, 151, 137, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 55, 80},
	{{156, 39, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 22, 11},
	{{92, 188, 82, 192, 142, 249, 190, 128, 0, 0, 0, 0, 0, 0, 0, 0}, 58, 254},
	{{253, 218, 181, 46, 134, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 45, 95},
	{{189, 19, 31, 244, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 40, 8},
	{{30, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 14, 212},
	{{81, 226, 13, 173, 79, 123, 223, 124, 108, 80, 83, 238, 0, 0, 0, 0}, 95, 217},
	{{126, 211, 206, 82, 147, 215, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 57, 15},
	{{42, 229, 135, 197, 196, 243, 94, 181, 133, 34, 16, 0, 0, 0, 0, 0}, 84, 66},
	{{68, 210, 158, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28, 122},
	{{183, 63, 223, 94, 81, 41, 203, 20, 236, 212, 220, 199, 0, 0, 0, 0}, 97, 12},
	{{131, 146, 2, 125, 174, 43, 231, 20, 194, 0, 0, 0, 0, 0, 0, 0}, 71, 171},
	{{31, 180, 246, 158, 28, 192, 236, 39, 237, 55, 74, 195, 171, 192, 0, 0}, 106, 42},
	{{179, 10, 70, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28, 194},
	{{147, 51, 85, 185, 234, 209, 236, 87, 147, 17, 7, 68, 148, 32, 0, 0}, 107, 237},
	{{177, 178, 6, 40, 46, 166, 87, 198, 214, 234, 23, 224, 0, 0, 0, 0}, 93, 151},
	{{201, 53, 40, 20, 49, 4, 38, 139, 133, 217, 214, 134, 89, 200, 0, 0}, 109, 238},
	{{4, 26, 181, 37, 206, 129, 233, 32, 0, 0, 0, 0, 0, 0, 0, 0}, 59, 128},
	{{81, 58, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 26, 227},
	{{18, 238, 250, 161, 57, 246, 208, 118, 14, 76, 73, 25, 65, 22, 152, 120}, 127, 138},
	{{31, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 10, 60},
	{{115, 195, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 18, 148},
	{{116, 22, 75, 33, 16, 129, 35, 124, 10, 112, 31, 213, 181, 108, 177, 46}, 128, 129},
	{{117, 214, 20, 80, 83, 51, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 49, 202},
	{{120, 75, 124, 149, 120, 123, 242, 151, 181, 164, 128, 0, 0, 0, 0, 0}, 81, 88},
	{{87, 238, 168, 62, 88, 166, 52, 104, 219, 169, 93, 128, 0, 0, 0, 0}, 90, 3},
	{{237, 44, 224, 146, 52, 85, 245, 192, 65, 137, 37, 95, 156, 176, 0, 0}, 108, 243},
	{{214, 241, 51, 63, 73, 61, 193, 165, 23, 108, 0, 0, 0, 0, 0, 0}, 80, 95},
	{{87, 242, 21, 157, 45, 188, 36, 62, 66, 243, 64, 0, 0, 0, 0, 0}, 87, 255},
	{{0, 97, 220, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 26, 48},
	{{227, 206, 189, 31, 222, 8, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 50, 38},
	{{174, 27, 0, 16, 13, 150, 33, 122, 154, 59, 236, 35, 248, 178, 64, 0}, 115, 20},
	{{39, 20, 125, 69, 252, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43, 41},
	{{141, 232, 1, 12, 125, 229, 168, 14, 125, 116, 180, 0, 0, 0, 0, 0}, 92, 133},
	{{93, 238, 40, 228, 254, 203, 251, 6, 60, 82, 243, 242, 0, 0, 0, 0}, 95, 189},
	{{44, 115, 200, 17, 146, 223, 115, 253, 126, 206, 152, 90, 0, 0, 0, 0}, 95, 151},
	{{213, 58, 235, 255, 6, 163, 61, 10, 224, 0, 0, 0, 0, 0, 0, 0}, 68, 100},
	{{25, 86, 139, 116, 190, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 49, 118},
	{{113, 40, 65, 141, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 34, 164},
	{{149, 205, 200, 186, 19, 126, 215, 199, 94, 37, 100, 32, 128, 0, 0, 0}, 98, 71},
	{{39, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 9, 251},
	{{81, 87, 80, 173, 163, 166, 104, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 57, 51},
	{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 3, 185},
	{{140, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 10, 144},
	{{6, 42, 1, 178, 250, 53, 186, 178, 114, 121, 192, 0, 0, 0, 0, 0}, 84, 51},
	{{2, 17, 234, 51, 169, 5, 219, 149, 245, 237, 4, 0, 0, 0, 0, 0}, 87, 32},
	{{112, 187, 173, 17, 229, 171, 225, 170, 8, 0, 0, 0, 0, 0, 0, 0}, 70, 137},
	{{203, 71, 140, 237, 113, 96, 123, 16, 0, 0, 0, 0, 0, 0, 0, 0}, 60, 2},
	{{99, 138, 207, 2, 244, 25, 211, 98, 0, 0, 0, 0, 0, 0, 0, 0}, 63, 163},
	{{114, 42, 98, 246, 252, 48, 233, 118, 63, 226, 157, 226, 192, 0, 0, 0}, 100, 162},
	{{161, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 10, 192},
	{{233, 70, 240, 45, 240, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 36, 185},
	{{28, 123, 31, 176, 235, 229, 169, 192, 0, 0, 0, 0, 0, 0, 0, 0}, 59, 51},
	{{146, 197, 243, 235, 243, 56, 140, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 54, 93},
	{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 2, 159},
	{{141, 92, 13, 27, 87, 241, 171, 143, 220, 0, 0, 0, 0, 0, 0, 0}, 72, 189},
	{{164, 151, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 21, 248},
	{{35, 188, 248, 79, 39, 151, 232, 215, 248, 245, 185, 144, 78, 102, 173, 128}, 123, 38},
	{{193, 232, 166, 60, 62, 80, 230, 225, 165, 240, 0, 0, 0, 0, 0, 0}, 76, 167},
	{{109, 229, 118, 155, 43, 154, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 51, 28},
	{{160, 62, 63, 212, 218, 138, 154, 108, 163, 127, 197, 237, 183, 44, 140, 192}, 125, 37},
	{{196, 37, 51, 146, 26, 85, 53, 31, 216, 141, 52, 218, 153, 32, 0, 0}, 107, 234},
	{{228, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 9, 70},
	{{154, 248, 20, 242, 154, 244, 63, 17, 121, 52, 70, 84, 118, 208, 0, 0}, 108, 50},
	{{41, 100, 27, 84, 106, 112, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 51, 171},
	{{81, 99, 197, 139, 30, 150, 230, 216, 81, 190, 84, 165, 29, 64, 128, 0}, 113, 236},
	{{112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4, 3},
	{{164, 119, 253, 126, 160, 249, 183, 191, 119, 111, 224, 0, 0, 0, 0, 0}, 86, 64},
	{{138, 58, 198, 254, 0, 197, 60, 91, 132, 199, 181, 251, 78, 160, 0, 0}, 108, 213},
	{{209, 89, 168, 236, 146, 169, 100, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 54, 15},
	{{131, 210, 208, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 20, 145},
	{{165, 190, 157, 7, 131, 5, 147, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 57, 27},
	{{179, 226, 57, 204, 187, 70, 52, 81, 119, 162, 229, 42, 47, 185, 9, 162}, 127, 75},
	{{98, 235, 155, 51, 107, 167, 127, 137, 254, 246, 162, 171, 180, 13, 233, 0}, 123, 76},
	{{107, 79, 76, 90, 94, 151, 155, 31, 33, 115, 19, 204, 98, 115, 0, 0}, 113, 247},
	{{143, 46, 30, 175, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43, 121},
	{{155, 85, 217, 180, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 30, 214},
	{{58, 62, 156, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 26, 221},
	{{92, 155, 53, 3, 39, 108, 155, 200, 0, 0, 0, 0, 0, 0, 0, 0}, 63, 102},
	{{64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 2, 191},
	{{63, 134, 251, 59, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 39, 197},
	{{234, 149, 220, 106, 0, 144, 214, 128, 35, 102, 0, 0, 0, 0, 0, 0}, 79, 106},
};

static struct ips_tbl_entry large_ips_table[] =
{
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 194, 147, 115, 142, 16, 127, 8}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 229, 23, 195, 4, 249, 2}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 84, 128, 8, 36, 26}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 203, 219, 206}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 136, 152, 202, 50}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 5, 152, 190, 60, 210, 175, 81, 101}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 72, 237, 205, 48, 61}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 59}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 141, 41, 73, 9, 48, 30, 122, 18}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 43, 198, 176, 9, 240, 180}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 219, 60, 216, 227, 85, 97, 202, 243}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 185, 206, 43, 179, 129, 115, 166, 131, 102}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 88, 13, 78}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 216, 146, 183, 156, 118, 54, 250, 238, 4}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 2, 79}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 61, 9, 147, 80}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 217, 179, 60, 30, 230, 203}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 86, 177, 17, 57, 191, 148}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 183, 12, 211, 118, 249, 169, 219}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 119, 197, 52, 238, 81, 191, 112}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 100, 145, 120}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 230, 252}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 51, 116}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 69, 132, 25, 226}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 29, 50, 25, 251, 126, 167}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 105, 206, 38, 242, 19, 169}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 241, 65, 232, 169}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 98, 218, 119, 149, 192}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 182, 103}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 63, 60, 122, 11, 248, 145, 149, 224, 39}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 154, 104, 241, 221, 216, 89, 163, 74, 77}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 87, 149}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 217, 248, 111, 129, 119, 118}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 114, 29, 173, 243, 47, 62, 112}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 165, 58, 168, 164}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 8, 20, 67, 95, 80}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 230, 234, 164, 55, 21, 105, 115, 227}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 242, 114, 211, 159, 242}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 23, 36, 201, 102, 160, 208}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 5, 252, 137, 97, 245, 7, 115, 20, 51}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 249, 106, 198, 190, 23, 28, 20, 24, 214}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 12, 2, 115, 42}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 156, 225, 23}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 6, 253, 87, 178, 67, 237}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 238, 6, 238, 63}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 46, 212, 97, 16}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 141, 110, 89, 188, 166, 68}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 239, 190, 110, 60, 81, 148, 203, 221, 214}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 171, 145, 15, 135}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 146, 194}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 252, 81, 209, 1, 127, 134}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 244, 124, 19, 48, 19, 179, 32, 169, 72}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 216, 65, 92, 84}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 204, 126}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 45, 240, 229, 141, 221, 111}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 81, 244, 218, 21, 42, 248}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 190, 2, 138, 170, 49, 96}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 25, 212, 101, 84, 241}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 209}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 222, 35, 234, 212}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 31, 253, 169}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 39, 101}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 165, 183, 69, 28}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 19, 125, 169, 46, 44, 137, 1, 136, 111}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 122, 168, 211, 57, 14, 162, 55, 211}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 161, 107, 124}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 126, 35, 107, 201, 21, 140, 15, 246}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 70, 233, 179, 218, 33}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 199, 202, 185, 226, 209}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 245, 205, 239, 116, 228, 171, 199, 226, 214}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 11, 44, 36, 55, 249, 213, 120}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 28, 193, 217, 220, 104, 255}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 124, 197, 195}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 80, 124, 199}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 103, 30}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 181, 183, 49, 182, 210, 82, 135, 16}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 226}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 108}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 183, 182}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 249, 91, 47, 60}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 0, 51, 228, 125, 220, 71, 10}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 20, 10, 247, 72, 120, 44, 79, 150, 118}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 123, 72, 190, 210, 143, 29, 197, 249, 169}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 0, 239, 246, 133, 146, 235, 153, 223}, 146},
	{{66, 70, 154, 143, 197, 233, 0, 0, 207, 124, 153, 121, 5, 242, 157, 173}, 146},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 23, 185, 140, 139, 103, 142, 106}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 185, 15, 51, 2, 207, 128, 233}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 195}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 252, 177, 6}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 217, 157, 143, 150}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 164, 17, 162, 72, 176, 60, 79}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 165, 219, 227, 69, 234, 211}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 155, 93, 182, 88, 109}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 117}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 40, 180, 73, 180, 154, 67, 254, 51}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 231, 179, 32, 174, 173, 96, 36, 53}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 56, 168, 98, 111}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 239, 60, 33, 23, 217}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 99, 247}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 74, 90, 7, 5, 71, 46, 75}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 193, 240, 139, 99, 182, 157, 108}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 144, 159, 7}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 180}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 149, 168, 187, 209, 186, 15, 23, 185, 46}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 249}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 85, 105, 215, 122, 146}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 253, 123, 24, 192, 161}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 58, 253, 77, 222, 34}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 57}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 113}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 142}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 103}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 239, 32, 67, 206, 156, 187}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 188, 68, 182, 43, 122, 149, 93, 183}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 63, 23, 17, 133, 247, 150, 13}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 238, 84}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 34, 58, 184, 194, 11, 119, 165, 244}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 9, 195, 194, 222, 80, 28, 20}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 53, 32, 179, 2, 203, 84, 204, 56}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 196, 167, 118}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 34, 116, 134, 156, 29, 92, 178}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 224, 104, 226, 104, 168}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 167, 190, 234, 157, 115, 238, 4, 193}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 144, 199, 189}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 122, 250, 151, 194, 106}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 77, 157, 57, 89, 21, 168}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 78, 31, 174, 130, 146, 52, 56, 74}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 91, 125, 201, 35, 116, 188, 164, 252}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 63}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 245, 31}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 27, 55, 108}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 120, 215}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 153, 175, 0, 89}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 95, 210, 157}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 187, 43, 158, 70, 171, 33, 205}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 152, 70, 141, 31, 221, 103, 174}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 243, 33, 81, 214, 37, 116, 228}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 176}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 211, 126}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 138, 208, 196, 178, 255}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 216, 169, 43, 121, 215, 65, 200, 82}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 199}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 26, 17, 43, 72, 37, 99, 10, 168, 98}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 254, 199, 57, 240}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 30, 64, 213, 26, 221, 132, 12, 59}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 74, 13, 197, 157, 100, 175, 194, 224}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 176, 81, 26, 37}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 7, 218, 171, 158, 176, 85, 57}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 52, 206}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 252, 122}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 82, 206}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 230, 211, 109, 58, 219, 165}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 163}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 72, 155, 98}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 17, 222, 31, 151}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 220}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 236, 182}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 132, 252, 246, 173, 253}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 132, 199, 200, 117, 150, 141}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 189, 113, 154, 76, 249}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 143, 4, 77, 201, 223, 120}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 204, 55, 76}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 41, 155, 198, 49, 25, 201}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 26, 132, 211, 6, 57, 251, 37, 211}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 134}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 158, 233}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 164, 71, 141, 193, 223}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 202, 200}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 92, 110, 137, 158, 112, 255}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 163, 167, 14, 36, 59, 58}, 141},
	{{107, 79, 18, 235, 142, 84, 80, 0, 0, 0, 0, 0, 0, 110, 197, 154}, 141},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 180, 250, 184, 27, 86, 91}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 143, 254, 149}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 0}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 195, 197, 228}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 237, 101, 21, 175, 105}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 0}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 0}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 86, 164, 92, 85, 60}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 23}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 192, 220, 99, 80}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 202, 0, 167}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 43, 96, 151, 166, 39}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 25, 217, 213, 232, 190, 106, 17}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 239, 86, 149, 133}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 184}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 35, 65, 32, 131, 169, 32}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 0}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 36, 58, 147, 71, 141, 4}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 248, 65, 211, 179, 206, 85}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 95, 236, 202, 248}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 192, 175, 60, 105, 148}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 204, 201, 176}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 192, 45}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 72, 147}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 0}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 192, 45, 131, 232, 28}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 17, 77, 199, 129, 99}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 170, 233, 63, 187}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 141, 209, 134, 233, 198}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 114}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 175, 158, 25, 163, 230, 24, 233}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 21, 243, 104, 20, 64, 129, 69}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 172, 66, 53, 209}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 176, 210, 235, 5}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 0}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 34, 125, 189}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 254}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 20, 67}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 0}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 163, 119, 83}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 122, 205, 65, 128, 233, 10, 136}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 204, 52, 24, 71}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 135, 215, 40, 133, 253, 42, 29}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 32, 167, 28, 223}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 1, 232}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 15, 195, 45, 100, 206}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 0}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 214, 82, 203, 3}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 99}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 239, 213, 185, 226, 120, 186}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 198, 119, 227, 110}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 201, 141, 27, 99}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 244}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 0}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 0}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 154}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 173, 9, 76, 225, 199, 160}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 45, 204, 81, 211}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 77, 84, 167, 164, 243, 3, 12}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 0}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 174, 47}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 0}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 169}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 152, 104, 155, 52, 188}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 0}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 179, 99, 140}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 166, 61, 219, 47, 68, 69}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 206, 9, 124, 78, 117}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 84, 158}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 27, 243, 93, 225}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 0}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 189, 22, 24}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 172, 139, 224, 173}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 14, 208, 208, 144, 211, 98}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 0}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 42, 30, 148}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 21, 161, 36}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 144, 247, 65}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 173, 12, 131, 36, 16, 200}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 247, 61}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 137, 65, 227, 212, 117}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 191}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 247, 173, 74, 168}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 51, 44, 35, 114, 105, 175, 71}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 11, 96, 90, 42, 72, 205, 83}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 196, 8, 106, 99, 151}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 86, 245, 24, 209}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 182}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 135, 172, 217, 250, 57}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 141}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 43, 152, 244}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 91, 172, 104, 36}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 164}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 81}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 36, 217, 78, 46, 137, 197}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 0}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 32}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 82}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 225, 147}, 23},
	{{247, 132, 113, 1, 215, 247, 183, 239, 128, 0, 0, 0, 0, 0, 0, 0}, 23},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 85, 160}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 115}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 1, 244}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 198}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 98, 57, 127}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 15, 18, 26}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 241, 79}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 129}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 14, 129, 101}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 17, 64}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 186}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 207, 231}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 72, 118}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 202, 75}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 79, 202, 136}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 147, 188}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 26}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 212, 68}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 203}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 28, 89, 18}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 126}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 175, 244}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 186}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 242, 217, 242}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 246, 239}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 185, 134, 190}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 238, 227}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 50}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 41, 189, 65}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 141, 189, 141}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 201, 122, 55}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 31, 205, 118}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 122, 104}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 252}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 190, 9}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 169, 168, 251}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 113, 241, 133}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 247, 119}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 71, 100}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 224}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 178, 59, 195}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 128, 203, 86}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 8, 41, 235}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 16, 197}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 123}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 165, 2}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 27, 229}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 63, 158}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 244, 44}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 125, 33}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 222, 11}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 194, 191}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 40, 252, 201}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 61, 105, 128}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 10, 26}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 188, 225}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 177, 106}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 206, 53}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 2, 22, 95}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 218}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 188, 127, 40}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 111, 158}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 195, 150, 178}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 104, 1, 27}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 222}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 50}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 0}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 33, 112}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 68, 5}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 213, 44, 7}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 8}, 252},
	{{48, 19, 41, 12, 76, 101, 114, 160, 45, 103, 134, 146, 128, 0, 0, 18}, 252},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 160, 126, 159, 189, 251, 157, 4}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 46, 99, 76, 221, 248, 157, 78}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 219, 170, 221, 145}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 140, 180, 70, 51, 253, 59, 197, 2}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 155, 17, 148, 91, 79, 55, 184, 129}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 64, 244, 22, 187, 211, 6, 167, 107, 214}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 226, 222}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 62, 16, 53, 47, 161, 159, 193}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 55, 152, 181, 157}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 28, 224, 188, 69, 120, 84}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 147, 161, 198}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 181, 228, 170, 121, 204, 247}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 237, 69, 91, 180, 38, 104, 143}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 221, 145, 208, 217}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 169, 255, 172, 182, 203}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 145, 203, 184}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 28, 160, 146}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 88, 44, 236, 84, 63, 58, 9, 66}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 17, 0, 107, 195, 141}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 7, 93, 86, 46, 8, 175, 144}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 8, 236, 137, 219, 194, 71}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 141, 240, 125, 157, 221, 143, 146, 237}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 85, 38, 93, 11, 172, 63, 240, 86, 229}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 119}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 58, 173, 12}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 27, 233, 163}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 46, 132}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 126, 16, 235, 31}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 27}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 107, 43, 144, 93, 210, 164, 155, 191}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 106}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 108, 82}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 65, 68, 116, 217, 194, 202}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 185, 168, 18, 247}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 169}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 122}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 141, 220, 223, 91}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 58}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 84, 215, 108, 189, 67}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 170, 100, 146, 135, 9, 197, 62}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 246, 171, 35, 61, 245}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 227, 50, 78, 110, 178, 238, 241}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 76, 155, 124, 238, 79, 226}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 109, 167, 163, 53, 248}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 129, 53, 219, 24, 140, 114}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 72, 128, 25, 8, 218, 90, 72}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 45, 201, 53, 254, 150, 161}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 51}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 133}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 197, 238}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 49, 91, 218, 100, 17, 119, 31}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 31, 70, 200, 125}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 8, 54, 2, 3, 81, 94, 56, 45}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 171}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 51, 69, 170, 250, 8, 85, 181}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 116, 113, 183, 163, 26, 48, 103}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 54, 136, 156, 80, 8, 30, 142, 219}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 2, 227, 102}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 46, 9, 90, 100, 125, 108, 141}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 146, 25, 220, 214, 40, 194, 156, 126}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 100, 80, 104}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 89, 169, 143, 55, 86}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 211, 229}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 133, 151}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 142, 3, 5}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 157, 253, 71, 85, 89, 23, 21, 186}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 141, 222, 11, 124, 182, 165, 184}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 79, 44, 251, 19, 23, 185, 0}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 8, 42, 236}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 2, 237, 145, 124, 206, 41}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 229, 254, 54}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 17, 175, 208, 32, 57, 95, 161}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 208, 205, 157}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 201, 210, 111, 227, 103, 248, 54, 225, 96}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 140}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 79, 145, 224, 247, 201, 42, 134, 148}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 207, 29, 32, 157, 98, 75, 86}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 248}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 4, 111, 63, 133, 4}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 127, 116, 94, 247, 108, 197, 47, 167}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 8, 122, 204, 245, 84}, 6},
	{{5, 70, 208, 170, 19, 0, 116, 0, 0, 0, 0, 0, 149, 221, 33, 92}, 6},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 38, 26, 202, 126, 207}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 152, 23, 119, 35, 158, 137, 196, 202, 143}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 141, 132, 60, 168, 17, 121, 48}, 137},
	{{1, 0, 0, 0, 0, 0, 47, 72, 65, 68, 107, 192, 67, 125, 110, 16}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 85}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 188}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 222, 114, 253, 200}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 102, 211}, 137},
	{{1, 0, 0, 189, 178, 25, 10, 102, 117, 30, 95, 106, 167, 200, 28, 4}, 137},
	{{1, 0, 0, 0, 0, 0, 183, 128, 193, 70, 212, 12, 102, 86, 239, 44}, 137},
	{{1, 0, 0, 125, 109, 248, 123, 97, 195, 100, 47, 147, 207, 150, 84, 69}, 137},
	{{1, 0, 0, 0, 0, 0, 139, 248, 221, 32, 147, 173, 186, 229, 218, 199}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 171, 228, 69, 23, 9, 182, 178, 169}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 26, 97}, 137},
	{{1, 0, 0, 0, 65, 75, 138, 130, 29, 57, 180, 1, 52, 237, 57, 27}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 144, 100, 64, 90, 143, 215, 237, 193, 129}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192, 224, 36, 68, 219}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 209, 189, 61}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 128, 6, 154, 80, 92}, 137},
	{{1, 0, 30, 6, 115, 81, 20, 120, 187, 153, 141, 64, 210, 218, 120, 213}, 137},
	{{1, 0, 0, 0, 0, 211, 23, 76, 209, 36, 48, 25, 88, 126, 100, 203}, 137},
	{{1, 0, 0, 0, 0, 57, 132, 73, 91, 128, 211, 1, 108, 85, 3, 236}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 129, 218, 58, 64, 117, 40, 112, 54, 53}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 14, 184, 56, 117, 18, 239, 211, 235, 248}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 215, 88, 10, 30}, 137},
	{{1, 0, 0, 0, 89, 75, 149, 114, 6, 84, 63, 89, 176, 199, 1, 122}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 38}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 254, 173, 101, 204, 138, 223, 106, 17, 130}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 89, 94, 88}, 137},
	{{1, 0, 0, 216, 224, 79, 242, 94, 39, 83, 100, 26, 79, 61, 144, 236}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 93}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 121}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 253, 48, 242, 173, 112, 71, 254}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 132}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 166, 1, 134, 96, 222}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 214, 121, 122, 120, 70, 179}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 211}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 85, 0, 71, 27}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 212, 67, 195, 168, 248}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 10, 85, 132, 225, 224, 48, 196, 66, 224}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{1, 0, 0, 0, 0, 0, 165, 89, 177, 144, 198, 57, 149, 3, 56, 213}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 170, 99, 166, 123}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 141, 98, 238, 9, 251, 194, 206, 113, 158}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 47, 96, 181, 205, 139, 227, 211}, 137},
	{{1, 0, 0, 73, 32, 235, 233, 92, 184, 3, 153, 24, 250, 11, 109, 199}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 233, 64}, 137},
	{{1, 0, 0, 0, 0, 0, 207, 158, 60, 29, 206, 104, 20, 225, 83, 176}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 180}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 87, 17, 71, 177, 22}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 245, 245, 63, 250, 195, 139, 232}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{1, 0, 0, 0, 0, 38, 86, 59, 153, 53, 34, 16, 28, 21, 166, 22}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217, 143, 250, 23}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 238, 92, 202, 187}, 137},
	{{1, 0, 0, 0, 0, 0, 155, 119, 5, 230, 144, 128, 158, 139, 92, 91}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 228, 51, 79, 161, 100, 251, 193}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28, 114, 229}, 137},
	{{1, 0, 0, 0, 236, 163, 225, 226, 35, 135, 122, 179, 2, 209, 67, 22}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 140, 14, 246}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 59, 61, 22, 244}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 93, 23, 80, 25, 127, 251, 17}, 137},
	{{1, 0, 0, 0, 0, 0, 183, 32, 122, 115, 142, 101, 71, 239, 197, 26}, 137},
	{{1, 0, 0, 0, 112, 236, 94, 178, 254, 201, 120, 240, 93, 58, 37, 230}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 219, 173, 97, 3, 113, 227, 248, 23, 55}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 247, 164}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 171, 34, 106, 69, 113, 66}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 108, 155, 129, 254}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 199, 174, 52, 243}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 121, 107, 174, 63}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 178, 98}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 180, 84, 180, 49, 188}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 172, 185, 175}, 137},
	{{1, 0, 0, 0, 243, 49, 203, 199, 69, 222, 234, 170, 16, 224, 37, 244}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 201, 135, 156, 109}, 137},
	{{1, 0, 0, 0, 0, 107, 220, 206, 41, 70, 187, 178, 64, 79, 165, 74}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 200}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 85, 254, 68, 224, 11, 104, 189}, 137},
	{{1, 0, 0, 168, 8, 62, 41, 41, 240, 178, 229, 191, 176, 41, 216, 180}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 241, 253, 37, 46, 120, 224, 16, 201, 40}, 137},
	{{1, 0, 0, 0, 217, 48, 2, 246, 191, 226, 2, 7, 92, 202, 140, 97}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 179, 176, 24, 142, 178, 34, 227}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60, 13}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 244, 208, 190, 159, 253}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 255, 23, 255, 213, 17, 98, 30, 216}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 132, 173, 193, 251, 1, 247, 226, 5, 122}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 122}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 47, 138, 17, 100, 255, 113, 65, 244, 171}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 3, 231, 31, 102, 71, 143, 82}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135}, 137},
	{{12, 188, 26, 18, 0, 0, 0, 93, 161, 248, 97, 91, 37, 42, 217, 30}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 110, 145}, 9},
	{{12, 188, 26, 18, 0, 0, 63, 201, 143, 114, 238, 32, 35, 120, 248, 32}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 195, 57}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 54, 246, 15, 248, 250, 117, 149}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 151, 238}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 224, 218, 62, 128}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 116, 253, 85, 230, 75}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 119, 204, 207, 183}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 173, 19}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 51, 242, 8, 150, 198, 58, 26, 87, 111}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 50, 155, 108, 136, 144, 37, 189}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 87, 33, 71, 231, 3, 172, 210}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 203, 156}, 9},
	{{12, 188, 26, 18, 0, 0, 199, 31, 235, 22, 225, 103, 213, 204, 205, 221}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 221, 33, 255, 15, 196, 35, 16}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 251, 17}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 87, 5, 38, 162, 165, 64, 106, 75}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 117, 228, 19, 79}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 71, 69, 245, 231, 180, 182, 134, 131}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 90, 175, 31, 58, 38, 78, 110, 247, 249}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 230, 197, 182, 6}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 220, 216}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 40, 154, 3, 60, 162, 26}, 9},
	{{12, 188, 26, 18, 0, 136, 172, 244, 138, 85, 113, 233, 232, 37, 166, 216}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 207, 237, 92, 110, 61, 179, 200, 112, 252}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 253, 51, 122, 208, 149, 57}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 166, 84}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 4, 176}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 122, 85, 227, 147}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 239, 60, 217, 221, 120, 118, 47, 87}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 249, 62, 128, 243, 87, 201, 243, 70}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 241, 196, 119, 39, 85, 219, 54, 171}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 238, 6, 178, 142, 14, 82, 79}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 13, 188, 112, 82, 83, 172, 217, 180}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 29}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 130, 247}, 9},
	{{12, 188, 26, 18, 0, 0, 97, 234, 171, 195, 79, 18, 108, 13, 192, 234}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 112, 167, 68, 166, 243}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 235}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 170, 251, 211, 241, 153, 195, 39, 41}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 3, 90, 149, 113}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 209}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 132, 117, 27, 33, 79, 38, 113, 200, 96}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 84, 233, 80, 148, 92}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 177, 179, 127, 13, 157}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 46, 166, 247}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 168, 67, 206}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 186}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 219, 74, 218, 247, 117, 241, 158, 74}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 27, 220, 38, 200}, 9},
	{{12, 188, 26, 18, 0, 0, 45, 20, 19, 140, 74, 81, 2, 247, 16, 207}, 9},
	{{12, 188, 26, 18, 0, 0, 28, 202, 227, 156, 60, 230, 225, 21, 70, 236}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 176, 115, 138, 176, 207, 101, 247, 250}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 214, 253}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 241, 80, 73, 176}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 170, 119, 248, 161, 12, 114, 49, 44, 172}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 140, 107, 83, 230, 115, 156, 220}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 165, 152, 42, 175, 140, 162}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 140, 83, 84, 57}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 159, 61, 46, 112}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 32, 53, 67, 63, 181, 231}, 9},
	{{12, 188, 26, 18, 0, 46, 84, 44, 231, 151, 9, 8, 184, 2, 77, 55}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 148, 150, 51, 36, 219, 75, 212, 81, 125}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 184, 110, 82, 210, 227, 2}, 9},
	{{12, 188, 26, 18, 0, 0, 52, 209, 95, 150, 123, 249, 125, 28, 215, 126}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 81, 193, 83, 204, 35, 252}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 82}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 221, 248, 152}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 250, 123, 201, 37, 238}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 113, 150, 22, 94, 76, 9}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 199, 87}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 243, 161}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 42, 67, 161, 227, 142, 23, 218}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 150, 51}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 188, 67, 17, 199, 92, 24, 232}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 154, 35, 64, 251}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 11, 97, 167, 5, 134}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 78, 56}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 164, 17, 53}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 184, 216, 5, 159, 164}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 87}, 9},
	{{12, 188, 26, 18, 0, 0, 1, 20, 241, 26, 48, 129, 12, 232, 243, 126}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 51, 131, 13, 52, 111, 59, 105}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 222, 135, 118}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 124, 5, 132, 241}, 9},
	{{12, 188, 26, 18, 0, 206, 163, 116, 153, 252, 1, 168, 241, 64, 255, 60}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 147, 6, 197, 143}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 9},
	{{12, 188, 26, 18, 0, 0, 195, 232, 192, 182, 32, 169, 17, 149, 10, 62}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 179, 35, 234, 55, 233}, 9},
	{{12, 188, 26, 18, 0, 33, 236, 106, 253, 166, 10, 229, 21, 11, 76, 77}, 9},
	{{12, 188, 26, 18, 0, 0, 0, 0, 0, 0, 0, 88, 38, 206, 100, 108}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 33, 229}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 10, 125, 12, 76, 74}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 160}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 0}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 238, 95, 240, 9, 139}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 111}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 82}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 175, 126, 253, 232, 24}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 171, 234}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 84, 97}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 80, 83, 173, 11}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 166}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 16, 166}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 83, 20, 135}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 144, 42, 61}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 35, 26, 213}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 150, 175, 249}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 103, 113, 52, 222, 56}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 0}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 19, 68}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 27, 100, 253, 67, 91}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 210, 39, 96, 229}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 25, 65}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 0}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 84, 46}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 40}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 0}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 66, 251, 254, 189}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 0}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 172, 237}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 142, 216}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 244, 28}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 14}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 158, 253, 73}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 0}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 24, 201, 252, 179}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 161, 31, 77, 132}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 79, 60}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 252}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 0}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 252}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 63, 50}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 0}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 215, 206, 4}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 115}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 0}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 42}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 143}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 0}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 70, 110, 237}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 0}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 3, 136}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 51, 130, 116}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 114, 207}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 38}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 0}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 16, 125, 162}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 157, 83, 181, 171}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 0}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 154, 160, 39, 134, 138}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 129, 96}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 205}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 85, 200, 142, 196, 175}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 43, 194}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 132, 63}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 187, 126, 44, 86, 42}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 78, 225}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 210, 12, 64, 129, 108}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 238, 116, 68, 82, 239}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 167, 159}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 115}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 0}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 243, 67, 14, 23, 211}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 5}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 226, 245, 27}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 118, 190}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 231, 96}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 94, 81, 16}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 0}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 235, 43}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 30}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 43, 148, 70, 17}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 209, 187, 145}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 247, 68, 69}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 0}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 36, 22, 59, 234, 236}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 0}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 222, 108, 195}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 249, 183, 52}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 29}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 50, 198}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 70, 155}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 45, 7, 54, 237}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 68, 206, 54}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 118, 235, 86, 82, 8}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 107, 110, 247, 59}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 253, 175, 14, 116, 121}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 28}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 51, 193}, 9},
	{{1, 235, 101, 202, 26, 92, 23, 22, 179, 223, 128, 0, 0, 0, 0, 64}, 9},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{215, 19, 224, 102, 45, 133, 102, 249, 56, 20, 214, 219, 93, 125, 52, 0}, 163},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 190, 251, 174, 110, 15}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 113, 244, 191}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 223, 20, 210, 31}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 109, 68, 76, 246, 147}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 53, 240}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 180, 79, 203, 43}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 123, 145}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 143, 8, 213, 179}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 123, 59}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 135, 92, 201, 156, 65}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 246, 164, 69}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 159, 240, 85}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 173, 232, 162, 228, 254}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 163, 57}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 143, 17, 110, 47, 163}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 216, 243}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 45, 126, 104, 109, 55}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 22, 23}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 182}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 73, 41, 155, 208, 57}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 225, 53, 88, 117}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 4}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 157, 62, 233, 3}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 26}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 204, 187, 64}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 25, 194, 192, 108}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 225, 94, 61, 171, 221}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 183}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 76, 231}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 74, 177, 241, 27}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 237}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 226, 212, 18}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 108, 218}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 44, 213, 77}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 167, 218, 188, 75, 241}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 119, 70, 77, 168, 212}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 227, 152, 188, 7}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 216, 110}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 75, 233}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 97, 198, 118, 156, 155}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 124, 51, 144, 180, 189}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 233, 185, 247, 186, 98}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 23, 100}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 211, 90}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 229, 150, 170}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 34}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 192, 230, 104}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 158, 190, 169}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 243}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 38, 227, 66, 102}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 128, 170, 96}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 203, 105}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 110, 209, 243, 123}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 208}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 197, 75, 214}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 162, 21, 252}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 221, 235, 170}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 253, 204, 21, 233}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 102, 118, 218}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 10, 27, 106, 60}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 112, 250, 224, 169}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 253, 149}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 171}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 157}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 60, 151}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 204}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 237, 99}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 42, 240, 154}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 248, 10, 14, 47, 135}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 213, 115}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 205}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 197, 117, 30, 30}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 5, 238}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 22, 144, 186}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 104, 44, 246, 190, 235}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 18, 115, 87, 63, 240}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 0}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 53, 18, 115, 79}, 197},
	{{178, 183, 109, 64, 136, 84, 11, 53, 217, 102, 0, 0, 0, 0, 0, 93}, 197},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 24, 248, 47}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 163, 46, 109}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 88, 248, 245, 194, 198, 156, 1}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 4, 219, 136}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 234, 73}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 90, 46, 243, 239, 104, 46, 174}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 167, 90, 13, 106}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 228, 191, 24}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 178, 120, 230, 253, 195, 173, 127}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 77, 145, 138, 12}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 69, 242, 182, 193}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 217, 167, 201, 86, 197, 198}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 43, 250, 5, 49, 22, 15, 54}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 14, 78}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 214, 48, 227, 130}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 137, 174, 87}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 171, 87, 246}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 99}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 220, 198, 99, 108, 166, 85, 138, 192}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 213, 43, 241, 252}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 40}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 251, 21}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 116, 234, 81, 30, 20, 11, 111, 246}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 88, 55, 194}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 7, 134}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 140, 232, 134, 17, 127, 175, 103}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 112, 131, 233, 65, 121}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 55, 162}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 212, 84, 213, 114, 105, 95}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 1, 238, 169, 5}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 162, 230, 56, 155, 128, 52, 124, 196}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 214, 32, 120}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 50, 110}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 144, 139}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 25, 147, 39, 67, 71, 117, 20, 15, 194}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 156, 53, 128, 47}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 34, 71, 79, 166}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 112, 239, 57, 139, 240, 227}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 188, 113, 172, 56}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 39, 249, 145, 67, 95}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 82, 31, 76}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 134, 26, 122, 13, 187, 1, 209}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 90, 28, 191, 92, 88, 57, 15, 4}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 208, 153, 100, 77}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 59, 1, 219, 220, 221}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 123, 119, 153, 40, 187, 135}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 171}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 212}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 110, 54, 33, 124, 240, 168, 84}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 32, 242, 127, 199, 71, 34, 189, 41}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 254, 96, 31, 217, 163, 67, 1}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 21, 238, 228}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 10, 70, 13, 250}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 153, 26, 78, 210, 24, 108, 211, 165}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 137, 32, 128, 233, 57, 229, 237}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 5, 201, 187, 193, 240, 237, 115}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 128, 244, 245, 59, 201}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 135}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 74}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 112, 7, 236, 231, 7, 195, 80}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 237, 226}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 219, 187, 29}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 101, 2}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 249, 163, 87, 39, 75, 130, 92, 221}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 24, 161, 209, 215}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 137}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 129, 85}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 143, 178, 19, 73, 151, 95, 149, 191}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 8, 94}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 206, 221, 26, 186}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 87, 106, 187, 79, 50, 113, 185}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 228}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 147}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 149}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 90}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 21}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 150, 85, 238, 30, 16, 236, 128, 71}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 101, 83, 33, 241, 154, 215, 103}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 64, 106, 57}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 226, 225, 218, 69, 238, 109, 194}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 191, 255, 215, 29, 119, 244, 67}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 125, 127, 201, 34, 196, 41, 194}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 86, 85, 195}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 0, 0, 0, 75}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 212, 168, 223, 95, 209, 150}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 175, 55, 27, 235, 255, 208, 89}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 0, 0, 0, 6, 227, 129, 112}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 6, 23, 2, 89, 157, 118, 146, 15}, 249},
	{{212, 39, 158, 71, 253, 98, 248, 0, 0, 90, 74, 63, 194, 210, 94, 187}, 249},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 169, 181, 122}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 238, 211, 206, 190, 144, 21}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 57, 23, 41, 202, 141}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 79, 210, 49}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 133, 176, 79, 92, 247, 51, 93, 154, 32}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 148, 190, 220, 172, 121, 26, 18, 48}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 88, 66, 221}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 139, 88, 12, 248, 0, 234, 217, 235}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 154, 165, 152, 85, 90, 70, 90, 132}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 239, 101, 78, 173, 50, 240, 187, 187}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 13, 152, 244, 245, 144, 2, 58}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 236, 55, 0}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 44, 117, 194, 211, 177, 130, 55, 189}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 122, 129, 203}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 79, 96, 164, 207, 122, 88, 78, 150, 43}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 40, 183, 247, 255, 84, 41}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 212, 14, 15, 120, 147, 199, 104}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 102, 251, 188, 254, 185}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 28, 176, 254, 240, 251, 164}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 215, 26, 94, 185}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 35, 87}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 182, 58, 81, 54, 176}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 57, 117, 119}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 42, 126, 68}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 53, 82, 116, 3, 170}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 83, 203, 238, 201, 55, 168, 132, 225, 251}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 252, 138, 129, 93, 234, 247, 3, 248, 171}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 15, 5, 78, 39}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 212, 117, 32}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 64, 17, 166, 167}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 153, 83, 29, 161, 94, 12, 8, 18}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 148, 46}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 184, 40, 246, 99}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 218, 166, 147, 79, 246, 219, 153, 192, 212}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 71, 206, 209}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 187, 213, 150, 147, 241, 125, 68}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 247, 118, 241, 110, 84}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 226, 232}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 69, 40, 210, 243, 220, 78}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 29, 131, 209, 206, 94, 117}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 116, 44, 138, 102, 240}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 248, 244, 85, 117}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 217, 93, 58, 25, 14, 235, 161, 11}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 238, 89, 46, 31, 173}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 112, 9}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 222, 176, 227, 236, 241}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 95, 47, 62, 144}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 122, 38, 19, 138, 241}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 122, 166}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 121, 118, 226, 169, 26, 141, 62, 35, 54}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 186, 102, 135, 194, 198, 35}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 168, 66}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 18, 128, 139, 93, 195, 104, 120, 152, 112}, 88},
	{{92, 58, 159, 130, 105, 56, 202, 125, 96, 25, 143, 200, 105, 87, 149, 15}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 33, 112, 114, 219, 219, 85}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 176, 153}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 64, 207, 67, 41, 72}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 207, 99, 42, 112, 177, 104, 233, 171, 82}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 206, 49, 46, 244}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 120, 77, 245, 40, 41, 123, 107}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 170, 241, 93, 144, 160, 238}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 13, 223, 170, 153}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 189, 240}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 112, 115, 129, 203, 173, 17, 116, 215}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 101, 89, 205, 229, 212, 193}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 2, 191}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 93, 114}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 120, 8, 34, 170, 74, 205, 169, 11}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 158, 177, 209, 154, 229, 45, 222, 215}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 174, 242, 167, 137}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 120, 121}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 148, 247, 65}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 47, 100, 159, 254, 236, 253, 70, 103, 56}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 75, 123, 63, 243, 216, 167}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 146, 51, 212, 65, 109}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 118}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 227, 135, 210, 10, 200, 9}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 175, 108, 42, 233, 99, 26}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91}, 88},
	{{92, 58, 159, 130, 105, 56, 196, 7, 105, 44, 65, 96, 41, 197, 56, 30}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 146, 228, 128, 81, 7, 129, 4, 85}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 130, 228, 104, 152}, 88},
	{{92, 58, 159, 130, 105, 56, 0, 0, 0, 0, 0, 0, 0, 0, 80, 96}, 88},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 0, 214}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 17, 211, 249, 68, 140, 53, 97, 115, 111}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 0, 75}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 132, 246}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 220, 51, 254, 225, 199, 251, 158}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 211, 145, 24, 37, 139, 184}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 126, 198, 100}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 41, 229, 77, 253, 60, 204}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 13, 114, 134, 126}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 38, 123, 241, 147, 195, 152, 23}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 200, 61, 0, 96, 35, 219}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 107, 250, 123, 9, 240, 236, 47, 126, 239}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 205, 110, 185, 253, 4}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 193, 240, 91, 56, 37, 91}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 151, 194, 45}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 0, 43}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 12, 11, 219}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 67, 77, 93}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 249, 71, 182, 1, 231}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 198, 2, 225, 76, 237, 89, 244}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 253, 198}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 32, 218, 210, 43, 228, 171, 112, 159}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 217, 91, 189, 37}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 156, 5, 100, 232, 141, 218}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 70, 52}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 94, 117, 0, 241, 152}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 0, 193}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 236, 191, 125, 184, 32}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 0, 125}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 125, 142, 123}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 161, 116, 11, 205, 169}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 3, 152, 206, 54, 121, 63, 145, 7}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 0, 117}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 155, 116, 246, 207, 25, 48, 220, 53}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 210, 46, 85, 43}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 141, 160, 72, 246, 132}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 201, 134, 133, 162, 76, 11, 185, 26}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 38, 95, 120, 233, 178, 124, 146, 193, 172}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 77, 36, 104, 242}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 160, 230, 203, 149, 49, 187, 245}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 120, 189}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 39, 246}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 152, 106, 36, 219, 19, 228}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 208, 80, 142, 236}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 57, 45}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 19, 253, 185, 113, 11, 32, 156}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 225, 71}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 235, 151, 132, 162, 161, 252, 76}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 177, 110, 171, 135, 149}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 192, 115}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 211, 12, 81, 200, 212, 235, 101, 83, 221}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 144, 137, 203, 255, 40, 65}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 247, 222, 145, 26, 152, 78, 166, 189, 111}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 67, 37}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 116, 163, 12, 119, 78, 129, 204, 226, 193}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 151, 114, 253, 17, 29, 38}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 41, 209, 195, 244, 70, 56, 22, 113}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 5, 125, 198, 106, 137, 125, 40, 132}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 213, 72, 145, 159, 88, 42, 162, 65}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 0, 173}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 73, 124, 52, 54, 73}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 214, 225, 255, 231, 253}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 175, 144, 132, 64, 116, 181, 56, 142}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 255, 33, 35, 56}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 17, 45, 201, 89, 211, 72, 100, 183}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 103, 151, 216, 197, 4}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 6, 141, 50, 51, 202, 163, 210, 244}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 164, 63}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 152, 184, 101, 58}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 209, 178, 139, 125}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 21, 104, 233, 212, 106, 253, 187, 74}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 50, 184, 13, 9}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 15, 149}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 224, 48, 245, 249, 1, 125, 146, 167}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 0, 185}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 213, 9, 13, 170, 169, 26}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 250, 79, 132}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 180, 211, 157, 92, 186, 126, 86}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 2, 0, 31, 11, 185, 23, 223, 37}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 57, 126, 57, 212}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 115, 151, 11, 223, 254, 166}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 10, 151, 181, 177}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 129, 89, 174, 49, 235}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 130, 180, 20, 217}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 196, 49, 67, 9, 73, 222, 42}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 76, 214, 168}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 0, 0, 0, 0, 99, 105}, 104},
	{{118, 140, 65, 198, 212, 93, 144, 0, 0, 0, 35, 6, 57, 185, 234, 4}, 104},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 46, 103, 232, 6, 22, 12}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 27}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 193, 175, 170, 235, 210, 189, 247}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 151, 130, 211, 190, 104, 51, 128}, 36},
	{{86, 64, 0, 50, 237, 255, 240, 48, 176, 208, 192, 155, 27, 146, 247, 55}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 210, 134}, 36},
	{{86, 64, 0, 0, 193, 143, 112, 130, 185, 133, 145, 43, 251, 228, 162, 94}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 146, 192, 56, 77, 97, 210, 215, 202, 169}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 118, 64, 8, 22}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 81, 35}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 220, 12, 142, 255, 243, 221, 96, 57}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 221, 107, 108, 63, 39, 164, 122, 7}, 36},
	{{86, 64, 0, 0, 0, 132, 209, 112, 167, 176, 187, 37, 105, 96, 222, 30}, 36},
	{{86, 64, 0, 0, 34, 84, 158, 243, 232, 78, 217, 210, 8, 225, 71, 71}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 30, 209}, 36},
	{{86, 64, 0, 0, 0, 238, 85, 22, 118, 145, 239, 186, 140, 221, 189, 125}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 71, 111, 79, 240, 61, 72}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 190, 232, 3, 222, 218, 0, 41}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 133, 84, 63, 237, 22}, 36},
	{{86, 64, 0, 0, 0, 0, 18, 80, 41, 148, 78, 176, 162, 130, 66, 108}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90, 144, 136, 39, 227}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 21, 232, 16, 179, 205, 154}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 254}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 136, 245, 241, 142, 4, 31, 57, 170}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 250}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 194, 48, 232, 23, 160, 114, 55, 140}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 122}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 87, 138}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 50, 120, 252, 4, 140, 59, 170}, 36},
	{{86, 64, 0, 0, 173, 237, 124, 128, 32, 40, 153, 137, 215, 147, 1, 91}, 36},
	{{86, 64, 0, 195, 93, 210, 55, 63, 163, 123, 238, 46, 85, 109, 125, 206}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 236, 182}, 36},
	{{86, 64, 0, 0, 0, 0, 231, 116, 153, 74, 239, 241, 2, 39, 192, 97}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 84, 172, 106, 109}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 59, 125, 163, 216, 132, 241, 245, 95}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 206, 78, 177}, 36},
	{{86, 64, 0, 0, 224, 59, 179, 30, 217, 123, 153, 222, 126, 150, 139, 194}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 36},
	{{86, 64, 0, 0, 0, 5, 215, 54, 151, 52, 215, 198, 236, 1, 111, 230}, 36},
	{{86, 64, 0, 0, 213, 199, 96, 15, 253, 154, 240, 35, 203, 86, 65, 123}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 144, 180, 231, 192, 91, 161, 22, 206, 189}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 162, 30, 185, 131, 182, 102, 105, 21, 2}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 36},
	{{86, 64, 28, 161, 250, 206, 50, 52, 72, 97, 141, 71, 16, 109, 183, 168}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 210, 99}, 36},
	{{86, 64, 70, 199, 173, 6, 48, 156, 176, 164, 249, 232, 229, 76, 65, 113}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 195, 156}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 144, 42, 179, 64, 141, 54}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 215, 2}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 121, 151, 210, 55, 93, 239, 214, 18, 22}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 36},
	{{86, 64, 0, 0, 0, 63, 175, 137, 42, 4, 218, 83, 221, 213, 147, 115}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60, 111, 164}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 117, 66, 148, 115, 134}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 76, 192, 141, 117, 126, 69, 198, 135, 72}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 156, 199, 195, 48, 165, 109, 231, 13, 61}, 36},
	{{86, 64, 0, 16, 128, 127, 164, 248, 164, 201, 53, 64, 216, 140, 203, 13}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 188, 242, 180, 177, 226, 94}, 36},
	{{86, 64, 0, 201, 107, 91, 91, 11, 168, 51, 157, 254, 183, 160, 201, 59}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 42, 42, 33, 162, 159, 89}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 42, 1, 143}, 36},
	{{86, 64, 183, 47, 122, 128, 213, 138, 163, 167, 131, 127, 21, 119, 166, 139}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 86, 169, 119, 29, 33, 251}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 236, 115, 228, 181, 161, 61, 24, 82, 32}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 78, 193, 198, 3}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 18, 238, 17, 96, 63, 98, 205, 161, 48}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 226, 89, 68, 176, 66, 136, 190, 146, 239}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 203, 76, 171, 103}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 236, 132}, 36},
	{{86, 64, 0, 0, 0, 0, 11, 148, 35, 184, 176, 234, 227, 177, 132, 164}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 132, 242, 173}, 36},
	{{86, 64, 0, 0, 29, 240, 144, 20, 243, 27, 72, 183, 169, 32, 157, 88}, 36},
	{{86, 64, 0, 0, 225, 81, 10, 194, 212, 13, 21, 205, 47, 18, 243, 129}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 144, 100, 70, 61}, 36},
	{{86, 64, 0, 0, 181, 118, 214, 198, 173, 167, 4, 28, 95, 191, 67, 240}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 36},
	{{86, 64, 0, 212, 134, 168, 52, 41, 95, 242, 189, 26, 128, 78, 214, 52}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 36},
	{{86, 64, 0, 0, 93, 70, 120, 21, 83, 1, 78, 38, 24, 162, 67, 29}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 196, 145, 231, 44, 141, 187, 145, 90, 222}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 112, 82, 253, 233, 162, 238, 205, 7}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 105}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 209, 86}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 121, 172, 168, 230, 200, 98, 192, 109}, 36},
	{{86, 64, 0, 76, 66, 150, 107, 41, 6, 186, 221, 150, 29, 2, 242, 202}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 242, 141, 27}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 190, 5, 19, 50, 31}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 79, 23}, 36},
	{{86, 64, 73, 42, 126, 207, 187, 72, 14, 52, 238, 1, 29, 103, 131, 126}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 69, 157, 202, 12, 66, 16, 94, 229, 161}, 36},
	{{86, 64, 248, 105, 187, 184, 51, 201, 20, 71, 178, 122, 234, 76, 224, 130}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 161, 176, 10, 145, 129, 10, 233}, 36},
	{{86, 64, 0, 0, 0, 0, 0, 0, 0, 141, 156, 66, 249, 240, 166, 184}, 36},
	{{86, 64, 0, 0, 0, 0, 122, 187, 111, 66, 134, 182, 178, 45, 71, 3}, 36},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 47, 73, 60, 100, 211, 198}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 195, 168, 141, 165, 96, 67, 83, 67}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 230, 71, 77, 38, 245, 220}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 36, 195, 149, 235, 218}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 205, 157, 26, 83, 146, 191}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 79, 151, 245, 208}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 142, 29, 207, 76, 96, 228}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 148, 173, 251, 39, 32, 9, 201}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 170, 201}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 82, 206}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 0, 137}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 164, 100, 129, 63, 87, 10, 147}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 0, 219}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 32, 4, 17, 67, 61, 103}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 112, 214, 51, 114, 154, 63, 28, 125, 71}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 195, 10, 42, 220, 179}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 113, 247, 186, 172}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 114, 34}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 159, 218}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 244, 98, 142, 34}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 104, 87, 115, 250, 142, 244, 192}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 242, 124, 225, 166, 190}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 199, 173, 45, 120, 145, 208, 229}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 39, 153, 62, 54, 152, 165, 167}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 3, 38, 166}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 0, 114}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 165, 148}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 239, 13, 32}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 196, 167, 14, 93, 14, 58, 190}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 236, 140, 60, 117, 184}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 1, 194, 195, 227, 98}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 137, 224, 238, 246, 191}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 243, 154, 142}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 91, 20, 39, 88, 42, 154, 131}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 89, 107, 4, 151, 152}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 17, 195, 94, 107, 239}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 190, 103, 192, 111, 8, 144}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 113, 234, 156, 4}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 133, 182, 178, 197, 145, 49, 15, 158}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 131, 255, 236, 173, 108}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 32, 159, 24, 104, 119}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 176, 78}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 216, 150}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 193, 197, 11}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 234, 44, 230, 42, 223, 31}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 38, 81, 8, 127, 118, 208}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 42, 73, 234, 185, 247, 166, 117, 135}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 210, 232, 97}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 30, 42, 254, 120, 144, 174, 138, 108}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 105, 36, 174, 118, 228, 35, 52, 57}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 76, 104, 177, 145, 78, 79, 87}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 245, 206, 14}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 182, 161, 128, 231, 37}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 181, 147, 129, 6, 139, 94, 58, 39}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 81, 147, 65, 176, 155, 113}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 165, 195, 227, 132}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 86, 39, 123, 106}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 29, 146}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 139, 153, 255}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 0, 46}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 133, 70, 138, 221}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 132, 180, 202, 136, 57, 234}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 108, 13, 61, 41, 222, 70, 134, 13}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 177, 145, 112, 224, 100, 174}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 49, 56, 168, 139, 40, 208, 212}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 97, 234, 32}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 200, 138, 116, 230, 157, 36, 223, 252, 68}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 239, 153, 94, 146}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 175, 127, 166, 183}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 84, 96}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 211, 219, 96, 181}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 0, 91}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 125, 226, 235, 186, 79, 50, 71}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 156, 187, 181, 208, 139, 193}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 105, 204, 77, 160, 175, 73}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 4, 162, 242}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 175, 232, 49, 38, 179}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 21, 145, 108, 248, 123}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 112, 182, 171, 156}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 0, 40}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 102, 143, 51, 175, 192, 122, 173}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 10, 245, 197, 231, 186}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 32, 132, 93, 176, 102, 158, 72, 94}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 70, 8}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 2, 19, 43, 245, 58, 147, 175}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 141, 32, 112, 223, 9, 70, 36, 13}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 193, 187, 236}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 67, 194, 24, 73, 202, 148, 168}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 25, 211, 112, 112, 188, 42}, 239},
	{{79, 135, 242, 193, 197, 11, 200, 0, 0, 0, 0, 0, 0, 0, 106, 142}, 239},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 12, 32}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 145, 143, 97, 204, 109, 78, 25}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 46, 249, 217, 44, 24}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 94, 94, 192, 222, 94, 107}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 244, 246, 119, 176, 57, 164, 82}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 235, 140, 30, 201, 225}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 118, 109, 242}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 78, 206}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 16, 35, 232, 61, 76, 155, 69}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 0}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 176, 64, 128}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 165, 232, 34}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 29}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 160, 114}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 158, 35}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 69, 26, 129, 227, 172}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 89, 187, 195, 69, 28, 190}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 41}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 70, 166, 83, 142, 191}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 161, 183, 155, 92}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 85, 81, 128, 220, 88}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 151, 249, 46, 10, 137}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 54, 60, 51, 190, 72}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 187, 229, 225, 141, 192, 117, 192}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 198, 30, 156, 228, 50, 129, 22}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 37}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 174, 221, 2, 114, 55}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 144, 182, 183}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 191, 69, 157}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 38, 106, 34}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 0}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 241, 191, 98, 32, 143, 182}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 214, 239, 190, 179, 104}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 144, 185}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 0}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 0}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 68, 7, 72, 126}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 230, 187, 33, 75, 71, 167}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 0}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 183, 193, 162, 149, 50, 211}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 19, 216, 61, 17, 222}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 59, 32, 122}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 8, 74, 136, 52, 1}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 94, 12, 99, 123, 153, 174}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 0}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 232, 50, 97, 245, 150}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 34, 108, 10, 143, 177}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 170, 157, 30, 43, 94, 157, 169}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 111, 89, 96, 108, 188, 138, 100}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 4, 95, 165, 138, 39}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 0}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 0}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 0}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 224, 152, 32, 90}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 128}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 0}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 0}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 37}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 230, 53, 230, 229, 246, 40, 67}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 222}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 72, 161}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 105}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 0}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 196}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 174, 47, 226, 101}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 43, 100, 180, 22, 75}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 0}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 241, 145, 92, 226, 32}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 58, 203, 10}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 240, 207, 11, 167, 173}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 0}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 5, 119}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 24, 177, 217, 254, 8}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 39, 31}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 0}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 101, 211, 111, 210, 120, 149}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 0}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 245, 234}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 107, 158, 35, 51}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 248, 14, 141, 12, 79}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 0}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 163, 5}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 66, 41, 40, 175, 160, 226, 119}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 105, 122, 16, 4, 17, 149}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 143}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 0}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 190, 226, 14, 250, 154}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 175, 224, 127, 74, 148}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 90, 176}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 135, 42, 62, 137}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 58, 244, 81, 165, 231, 225}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 0}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 139, 2, 104}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 34, 163}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 34, 240, 92, 61, 150}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 0, 132}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 38, 184, 214}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 89, 123, 39, 116, 226, 194, 170}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 0, 0, 0, 0, 155, 190}, 201},
	{{163, 228, 239, 80, 41, 66, 176, 176, 0, 0, 239, 31, 226, 173, 86, 174}, 201},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 230}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135, 216, 129}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 145, 67, 23, 248, 188, 207}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 22, 106, 247}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 8, 41, 133, 113, 221, 204}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 56, 68, 146, 56, 16, 219, 107, 115}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 156, 104, 158, 70, 166, 73, 215, 84, 162}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 141, 155, 93, 140}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 230, 40, 40, 205, 204, 58, 241, 227, 177}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 25}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 132, 154, 116, 46, 176}, 94},
	{{31, 9, 231, 42, 0, 0, 53, 3, 127, 32, 234, 114, 182, 56, 9, 198}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 133, 39, 107, 33, 244, 86, 201, 26, 112}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 158, 2}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 80}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 56, 139, 250, 208, 28, 82, 252, 216, 28}, 94},
	{{31, 9, 231, 42, 0, 0, 100, 215, 171, 242, 68, 124, 87, 30, 54, 99}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 59, 154, 248, 191, 31, 169}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 178, 217}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 78, 154}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 11, 136, 106, 218, 215, 248, 242}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 45, 232, 77, 158, 151}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 191, 223, 83, 230, 51, 1, 107}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 121, 185, 154, 46, 31, 9, 237, 18}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 144, 105, 186, 233}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 156, 137, 12, 119, 41}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 244, 105, 2, 109, 88, 4, 31, 78, 219}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 229, 240, 151, 10, 67}, 94},
	{{31, 9, 231, 42, 0, 158, 55, 20, 87, 9, 144, 226, 63, 114, 88, 228}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 195, 204, 92}, 94},
	{{31, 9, 231, 42, 0, 0, 166, 140, 220, 64, 41, 136, 213, 47, 154, 167}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 157, 172, 70, 28, 181, 174}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 126, 170}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 226, 36}, 94},
	{{31, 9, 231, 42, 0, 0, 169, 234, 178, 13, 156, 249, 113, 45, 71, 176}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 107, 159, 52, 1}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 197, 218, 23, 60}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 138, 120}, 94},
	{{31, 9, 231, 42, 0, 0, 33, 49, 7, 90, 0, 226, 231, 248, 20, 200}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 87, 222}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 193, 220, 112, 81, 83, 214, 42, 230}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 56, 118, 183, 208, 119, 248, 213, 130}, 94},
	{{31, 9, 231, 42, 0, 0, 210, 61, 50, 40, 86, 159, 0, 31, 250, 156}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 119, 135, 78, 17, 11, 0, 48, 247, 69}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 94},
	{{31, 9, 231, 42, 0, 0, 189, 251, 27, 205, 253, 206, 47, 208, 242, 3}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 76, 243}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 18, 15, 149, 26, 78, 243, 67}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 113, 148, 184, 85, 145, 107, 68, 106}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 172, 117, 6, 208, 54, 72}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 191, 172, 159, 66}, 94},
	{{31, 9, 231, 42, 0, 94, 70, 17, 160, 1, 60, 93, 17, 194, 73, 182}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 121, 47, 94, 10, 24, 57, 111, 4}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 121, 115, 225, 210}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 34, 215, 168, 55, 202, 65, 121, 129}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 106, 138, 247, 152, 254}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 77, 8, 114}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 172, 164, 232, 105, 108, 151, 133, 67, 120}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 235, 150, 1}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 200, 63, 131, 198, 220, 30, 164}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 40, 164, 73, 119, 90, 205, 172}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 47, 199, 189, 91, 143, 81, 253, 229, 0}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 35, 112, 68, 107, 227, 161, 214, 181}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 219, 78, 217, 42, 99, 81, 13}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 152, 144}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 115, 219}, 94},
	{{31, 9, 231, 42, 0, 181, 180, 57, 252, 219, 155, 61, 229, 26, 160, 203}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 74, 194}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 54, 82, 208, 19, 237, 69}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 196, 227, 97, 63, 54, 49, 77, 66, 74}, 94},
	{{31, 9, 231, 42, 0, 0, 160, 246, 94, 99, 116, 53, 101, 186, 170, 183}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 181, 109, 250, 196, 114, 154, 244}, 94},
	{{31, 9, 231, 42, 0, 0, 131, 235, 211, 229, 9, 240, 242, 167, 148, 43}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 127, 231, 229, 253, 93, 8, 85, 110}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 61, 136, 213, 189}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 251, 112}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 224, 5}, 94},
	{{31, 9, 231, 42, 0, 0, 187, 115, 188, 59, 175, 121, 55, 91, 163, 140}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 145, 106, 54, 83, 89, 198, 75, 167, 193}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 132, 88, 43, 94, 86, 202, 53, 218}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 143, 188, 141, 63, 157, 41, 244, 182, 147}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 183, 34}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 156, 89, 97, 0}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 143, 236, 31}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 62, 159, 10, 112, 143}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 86, 133, 214, 112, 47, 52, 191, 1}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 214, 153, 246, 46, 146}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 114, 57}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 110, 52, 186, 32, 254, 73, 207, 2, 53}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 22}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 0, 0, 0, 0, 0, 160, 147, 37, 161}, 94},
	{{31, 9, 231, 42, 0, 0, 0, 230, 32, 236, 121, 136, 10, 127, 138, 137}, 94},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 94, 142, 154, 19, 204, 114, 205}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 115, 71, 107, 3, 18, 249, 158, 159, 89}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 127, 246}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 3, 169, 59, 202, 191, 63, 78, 66, 241}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 90, 26, 225, 87}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 213, 215, 122, 56, 253}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 15, 10, 113, 136, 183}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 193, 9, 234, 62, 155, 121, 49, 162}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 50, 50}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 35, 187, 19, 41, 248, 62}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 20, 62}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 192, 228}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 11, 51, 199, 180, 239, 91, 249, 198, 112}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 168, 237}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 32}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 40, 230, 151, 242, 54}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 92, 210, 54, 51}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 64, 212, 92, 98, 29, 244, 73}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 247, 57, 119, 195, 132, 244, 164}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 163, 187, 213, 27, 40, 46}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 76}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 109, 200, 99, 141, 41, 207}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 55, 202, 244, 151, 19, 238, 173}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 41, 211, 79, 29, 17, 69}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 177, 138, 112, 234, 115, 207}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 171, 239, 176, 179, 86, 183, 13, 205, 245}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 94, 88, 96, 181}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 113, 134, 216, 220}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 37, 196, 95, 97, 7, 36, 15}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 143, 117, 121, 252, 46, 83, 110}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 10, 71}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 151, 221}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 92, 64, 206, 226, 129}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 124, 129, 161, 6, 134, 84, 82, 127}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 79, 87, 151}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 204, 196, 242, 8, 245, 167, 227, 226, 122}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 225, 79}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 9, 245, 225, 142, 44, 43, 17}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 23, 21}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 146, 231, 1, 17, 239}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 240, 206, 9, 88, 3, 192, 40, 194}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 99, 224}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 32, 90}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 62, 219, 49, 131, 153, 48, 145}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 200, 202, 11, 87, 9, 154, 112, 228}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 26, 202, 63, 104, 136, 229}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 130, 50, 190, 223, 108, 1, 130, 59}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 33, 189, 226, 249, 89, 220, 236}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 160, 51, 127, 30, 112, 136, 209}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 49, 133}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 154, 159, 117}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 15, 255, 144, 187, 243, 208}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 42}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 213, 34, 109, 136, 195}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 227, 162, 137, 133, 9, 171, 196, 10, 34}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 14, 55, 198, 186, 146, 93}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 177, 180, 153, 126, 211, 180}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 82, 25, 152, 194, 86}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 148, 95, 52, 78, 230, 94, 76}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 129, 80, 240, 226, 116, 46, 91}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 219, 148, 114, 226}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 167, 53}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 157, 34, 235, 117}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 54, 159, 30, 53, 221, 128, 9, 61, 22}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 2, 73, 254, 19}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 3, 238, 135, 155, 40, 199, 229}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 225, 222, 140}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 225, 47, 109, 43, 33, 63}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 96, 221}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 53}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 98, 82, 211, 44, 165, 226, 4, 128, 176}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 49, 190, 32, 110, 99, 217, 159, 120}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 156, 144, 138, 233, 229}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 100}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 24, 154, 145, 24, 64, 140, 50, 212, 212}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 167, 114, 22, 92, 63, 172, 74}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 37, 110, 104}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 217, 193}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 91, 79, 183, 86, 37, 153, 33}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 239, 65}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 127, 67, 227, 92, 254}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 91}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 0, 0, 131}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 0, 169, 13, 129}, 241},
	{{108, 144, 205, 39, 215, 26, 96, 0, 0, 0, 0, 0, 222, 212, 144, 44}, 241},
	{{247, 217, 172, 0, 0, 0, 0, 17, 70, 130, 136, 120, 54, 96, 241, 39}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 182, 38, 208}, 239},
	{{247, 217, 172, 0, 244, 4, 22, 163, 92, 34, 165, 216, 210, 229, 132, 25}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 200, 164, 142, 253, 68, 223, 89, 208, 253}, 239},
	{{247, 217, 172, 0, 0, 0, 110, 126, 45, 56, 107, 58, 85, 166, 159, 18}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 85}, 239},
	{{247, 217, 172, 0, 0, 0, 101, 159, 79, 60, 162, 199, 249, 53, 72, 24}, 239},
	{{247, 217, 172, 0, 198, 178, 30, 32, 62, 201, 123, 186, 47, 24, 39, 12}, 239},
	{{247, 217, 172, 0, 119, 167, 172, 112, 35, 70, 129, 58, 143, 28, 91, 207}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 176, 19, 32}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 49, 153, 201}, 239},
	{{247, 217, 172, 0, 135, 69, 76, 85, 8, 18, 3, 20, 176, 102, 99, 113}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 254, 11}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 215, 127}, 239},
	{{247, 217, 172, 0, 0, 0, 234, 182, 170, 172, 120, 205, 51, 119, 4, 127}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 42, 90, 31, 51, 239, 13}, 239},
	{{247, 217, 172, 0, 0, 66, 84, 26, 169, 164, 39, 214, 218, 89, 119, 216}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 82}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 196, 170, 103, 139, 146, 200}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 71, 109}, 239},
	{{247, 217, 172, 0, 0, 0, 109, 40, 63, 113, 60, 199, 107, 9, 21, 70}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 172, 51, 114, 48, 58}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 191, 52, 54, 164, 225, 233, 115, 128, 1}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 224, 14, 80, 85, 12, 9, 109}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 246, 246, 221, 133, 24, 218}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 20}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 194, 117, 41, 243, 198}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 164, 24, 137, 186, 50, 239, 133}, 239},
	{{247, 217, 172, 0, 0, 0, 116, 224, 55, 9, 215, 81, 85, 42, 243, 169}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 142, 19, 223, 14}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 97, 95, 213, 122, 201}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 209, 78, 192, 167, 173}, 239},
	{{247, 217, 172, 0, 0, 67, 139, 166, 58, 172, 192, 221, 85, 204, 243, 133}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 193}, 239},
	{{247, 217, 172, 0, 0, 21, 117, 75, 179, 223, 54, 111, 81, 6, 90, 179}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 96, 203}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 222}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 192, 89, 178, 151, 18, 57, 11, 53}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 129, 135}, 239},
	{{247, 217, 172, 0, 0, 0, 14, 88, 70, 156, 73, 101, 199, 254, 182, 171}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 171, 191, 251, 19, 150, 23, 66, 104}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 148, 103, 212, 70, 66}, 239},
	{{247, 217, 172, 0, 0, 0, 210, 174, 74, 99, 31, 49, 7, 110, 246, 40}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 250, 194, 34, 30, 81, 162, 25}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 25, 82, 51, 79, 138}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56}, 239},
	{{247, 217, 172, 0, 0, 133, 69, 139, 192, 131, 178, 39, 126, 117, 127, 41}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 148}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 226, 137, 99, 7, 200}, 239},
	{{247, 217, 172, 0, 0, 173, 158, 253, 29, 122, 71, 165, 59, 28, 255, 55}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 254}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 148, 175, 65, 2, 241, 135, 143, 103}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 116, 181}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 196}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 167, 71, 145, 84, 102, 207, 82}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 116, 119, 63, 23}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 98, 244}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 243, 227}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 176, 70, 21, 111, 6, 60, 106, 115, 148}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 27, 193, 127, 80, 137}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 85}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 188, 18, 102, 42, 115, 124, 114, 66}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 207, 165, 188, 166, 211}, 239},
	{{247, 217, 172, 0, 0, 222, 144, 221, 86, 194, 99, 159, 11, 248, 62, 112}, 239},
	{{247, 217, 172, 0, 248, 180, 246, 12, 207, 207, 191, 117, 217, 254, 201, 225}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 86, 164, 83, 175, 109, 202}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 239},
	{{247, 217, 172, 0, 0, 0, 243, 120, 210, 177, 224, 191, 140, 128, 250, 72}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 67, 131, 121, 128, 43, 184, 90, 67, 187}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 144, 252}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 36, 218, 250, 38, 239, 192}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6}, 239},
	{{247, 217, 172, 0, 189, 42, 175, 105, 241, 105, 189, 151, 23, 222, 9, 101}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 132, 151, 109, 151, 137, 184}, 239},
	{{247, 217, 172, 0, 0, 147, 53, 69, 126, 162, 164, 106, 162, 96, 134, 141}, 239},
	{{247, 217, 172, 0, 0, 59, 115, 190, 214, 30, 174, 191, 213, 149, 204, 210}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 69, 105}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 205, 135, 152, 113, 229, 160}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 231, 58}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 168, 40, 9, 95, 241, 198, 125}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 83, 171, 199, 6, 5, 17, 201, 88, 246}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 72, 105, 244, 215, 31}, 239},
	{{247, 217, 172, 0, 0, 0, 10, 96, 17, 157, 251, 4, 93, 208, 210, 11}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 16, 77, 213, 157, 94, 203, 90, 45, 28}, 239},
	{{247, 217, 172, 0, 0, 223, 145, 197, 79, 194, 31, 143, 192, 36, 113, 9}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 87}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 44}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 239},
	{{247, 217, 172, 0, 0, 164, 65, 59, 55, 159, 14, 200, 26, 57, 233, 44}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 95, 1, 95, 215, 148}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 170, 158, 73, 197, 18, 207}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 6, 218, 132}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 103, 67, 166, 185, 69, 234, 113, 55}, 239},
	{{247, 217, 172, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 168, 45}, 239},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 28, 166, 210}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 66, 13, 88, 252}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 115, 49, 216, 188, 51, 182}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 255, 68, 32, 84}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 245, 224, 150, 162, 14, 55, 175}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 7, 59, 17, 183, 16, 166}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 220}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 210, 62, 110, 217, 206, 139}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 67, 105, 146, 134, 163}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 187, 86, 137, 255, 221}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 208, 162, 188, 125, 229, 96, 56}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 101, 221, 65, 250, 132}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 99}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 150, 164, 169, 153, 147, 203}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 135, 206, 163}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 174, 197}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 236}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 193, 205, 50, 210, 67, 181}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 179, 116}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 159, 150, 17, 91}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 84, 220, 160, 224, 99, 230}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 206}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 152}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 233, 140, 187, 72, 13, 235}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 158}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 40, 158, 222, 35, 95, 125, 122}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 26, 50, 165, 71, 77, 21, 62}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 201, 103, 25, 171}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 153, 117, 55, 56, 218, 84}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 157, 75}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 6, 2}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 99}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 119, 200, 143, 66, 227, 112}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 27, 229, 181, 220, 242, 77, 137}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 40, 6, 28, 10, 168}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 70, 127, 3, 208, 149}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 218, 95, 143, 45, 57, 75}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 158, 236, 173}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 99, 249, 180, 104}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 136, 210}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 199, 44, 185, 243, 140}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 4}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 77, 1, 29}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 133, 233, 118, 124, 7, 56, 207}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 81, 237, 255}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 157}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 151, 102}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 190, 189, 209}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 8, 246, 161}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 151, 109, 121, 69}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 1, 222, 223}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 63, 120, 127}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 225, 37, 126, 100, 26, 225}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 142, 149, 147}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 5, 205, 221}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 200, 112, 72, 178}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 155, 113, 171}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 50, 200, 243}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 243, 57, 63, 50}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 241, 104}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 16, 195, 227}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 37}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 222, 137, 7, 8, 119, 54, 96}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 189, 238, 52, 76, 168}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 237, 167, 101, 184, 201, 203}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 14, 22, 13, 238, 147, 210, 208}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 94, 199}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 240, 87, 222}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 222, 164, 143, 12}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 109, 224, 234, 129}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 180, 52}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 13, 225, 203, 183, 220, 128}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 97, 136, 50, 44, 34, 29}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 33, 93, 65, 213, 85}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 49, 70}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 226, 94, 81, 128}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 173, 237, 223, 65}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 86, 27, 193, 194}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 74, 242, 23, 210, 46, 218, 229}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 112, 33, 25, 6, 128, 192}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 8, 241, 94, 102, 42}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 1, 193, 7}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 162, 131, 51}, 151},
	{{24, 186, 73, 182, 240, 251, 125, 165, 0, 0, 0, 0, 0, 0, 128, 103}, 151},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 115, 81, 177, 8, 86, 50, 58}, 137},
	{{245, 112, 0, 0, 0, 16, 215, 156, 108, 221, 92, 108, 16, 199, 194, 113}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99, 130, 137}, 137},
	{{245, 112, 0, 0, 0, 67, 135, 40, 77, 201, 46, 205, 117, 26, 200, 124}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 209, 135, 4, 239, 76}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 60, 94, 96, 129, 177, 39}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 117, 198, 62, 14, 207}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 248}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 74, 28, 77, 145, 75, 104}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 195}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 112, 242, 146, 246, 93, 28, 141}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 243, 191}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 122}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 145, 139, 48, 251, 246, 177}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 52, 2, 164, 40}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 223, 158, 200, 54, 231, 51, 203, 191}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 166, 165, 223, 45, 151, 187, 92, 51}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 197, 5, 86, 228, 16, 172, 93, 70, 64}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 148, 223}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 106, 83, 194, 95, 194, 174, 113, 21}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 159, 179, 176, 227, 15, 121, 235, 202, 80}, 137},
	{{245, 112, 0, 0, 0, 0, 90, 227, 203, 141, 123, 177, 184, 236, 243, 32}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 203, 37, 129, 0, 60, 184, 170}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 245, 188, 230}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 166, 237, 182, 70}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{245, 112, 0, 0, 0, 0, 180, 123, 125, 115, 121, 7, 113, 29, 193, 126}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 99, 222, 133, 201, 45, 209}, 137},
	{{245, 112, 198, 218, 144, 2, 16, 201, 29, 99, 27, 234, 107, 61, 88, 188}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 148, 69, 49, 42, 105, 73, 123, 40, 134}, 137},
	{{245, 112, 0, 0, 0, 0, 1, 85, 155, 249, 241, 131, 86, 4, 65, 100}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 60}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 222, 116, 131, 62, 200, 123, 56}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 141, 234, 115, 57, 95, 201, 64, 196}, 137},
	{{245, 112, 0, 0, 51, 147, 14, 245, 22, 208, 53, 106, 136, 127, 153, 156}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 117, 208, 227}, 137},
	{{245, 112, 0, 0, 0, 0, 194, 85, 40, 222, 226, 90, 205, 52, 200, 205}, 137},
	{{245, 112, 0, 90, 6, 188, 52, 134, 178, 202, 246, 130, 62, 155, 120, 111}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{245, 112, 0, 0, 0, 102, 90, 157, 90, 103, 94, 8, 87, 57, 205, 69}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 208, 134, 217, 23, 61}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 42, 211, 234, 193, 195}, 137},
	{{245, 112, 0, 0, 0, 212, 157, 132, 80, 195, 37, 8, 36, 211, 178, 99}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 120, 4, 227, 62, 82, 78, 113, 243, 166}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 253, 91, 9, 88, 198, 185}, 137},
	{{245, 112, 0, 0, 0, 63, 157, 131, 36, 108, 198, 197, 149, 78, 52, 192}, 137},
	{{245, 112, 0, 0, 0, 83, 79, 96, 58, 125, 209, 205, 49, 26, 167, 38}, 137},
	{{245, 112, 0, 17, 57, 251, 226, 107, 229, 114, 44, 167, 152, 37, 229, 176}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 130, 40, 163}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{245, 112, 0, 253, 6, 224, 65, 7, 133, 120, 4, 50, 122, 165, 244, 88}, 137},
	{{245, 112, 0, 0, 188, 162, 49, 233, 43, 204, 81, 96, 189, 77, 82, 60}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 204, 226}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23}, 137},
	{{245, 112, 0, 0, 180, 139, 20, 120, 155, 76, 12, 197, 200, 191, 96, 41}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 114, 98, 129, 189, 216, 153, 246, 106, 22}, 137},
	{{245, 112, 0, 0, 0, 25, 138, 238, 179, 172, 201, 67, 209, 25, 175, 130}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 105, 62, 106, 63}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90, 180, 121}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 214, 10, 165, 0, 79, 82, 157, 65}, 137},
	{{245, 112, 0, 0, 0, 97, 148, 165, 48, 51, 229, 113, 104, 183, 104, 94}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 88, 165, 253, 45, 47}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 215}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 182, 54}, 137},
	{{245, 112, 0, 0, 16, 174, 66, 128, 92, 48, 168, 15, 14, 104, 129, 66}, 137},
	{{245, 112, 0, 248, 144, 17, 33, 175, 84, 227, 35, 250, 24, 90, 116, 219}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 204, 63, 234}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 125, 105}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 154, 169, 192, 180, 244, 166, 26, 185}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 255, 49, 155, 82}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 214}, 137},
	{{245, 112, 0, 0, 0, 173, 147, 153, 111, 29, 227, 112, 10, 25, 159, 228}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 149, 133, 81, 65, 145}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 214}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 183}, 137},
	{{245, 112, 0, 0, 0, 0, 246, 73, 205, 79, 236, 50, 244, 204, 190, 38}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 40, 255, 128, 169, 185, 10, 4, 159, 67}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 125, 72, 88, 193, 215, 36, 20, 145}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 226}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 211, 164, 178, 130, 1}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 214, 0}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 191, 11, 154, 186, 99, 244, 27, 66}, 137},
	{{245, 112, 154, 237, 29, 76, 120, 218, 37, 102, 157, 143, 35, 188, 156, 238}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 93}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 182, 31, 217, 100}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 251, 79, 114, 182}, 137},
	{{245, 112, 0, 0, 19, 56, 17, 105, 143, 32, 50, 112, 193, 57, 91, 167}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 209}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 16, 51, 172, 241, 189, 77, 186, 152, 90}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 179, 169, 162, 30, 241, 21, 84, 245, 209}, 137},
	{{245, 112, 0, 0, 0, 0, 0, 0, 0, 0, 244, 63, 11, 224, 243, 230}, 137},
	{{245, 112, 0, 10, 88, 209, 190, 151, 28, 97, 74, 160, 38, 83, 22, 170}, 137},
	{{245, 112, 0, 0, 117, 111, 75, 146, 119, 170, 72, 179, 172, 127, 197, 45}, 137},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 43, 220, 58, 78, 17, 175, 14}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 109, 75, 193, 85, 75, 233}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 234, 8, 113, 40, 35, 21, 156, 24, 9}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 87, 139}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 215, 60, 165}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 185}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 206, 23, 203, 34}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 149, 167, 233, 42, 58, 135, 167, 12, 191}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 56, 12, 186}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 125}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 231},
	{{44, 94, 138, 224, 168, 0, 216, 67, 147, 241, 166, 8, 191, 54, 175, 146}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 214, 197}, 231},
	{{44, 94, 138, 224, 168, 0, 39, 184, 253, 4, 23, 254, 253, 7, 211, 210}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 111, 110, 70, 51, 211, 178, 56, 119}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 124, 14, 209, 155, 20}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 218, 27, 43, 235, 225}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 219, 173, 157}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 151, 20}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 29, 184, 73, 198}, 231},
	{{44, 94, 138, 224, 168, 0, 114, 142, 102, 28, 130, 99, 236, 14, 87, 178}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 114, 241, 238, 149, 76, 234, 138}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 195}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 244, 225, 123, 98, 129, 170, 203}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 177, 241, 162, 210, 244, 67, 237, 41}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 133, 214, 116}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 81, 238, 146, 2}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 115, 239, 101}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 248, 31, 194, 6, 145}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 83}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 117, 232, 183, 18, 34}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 60, 75, 45, 169, 157, 28, 128, 199}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 190, 167, 190}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 184, 31, 184, 113}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 28, 34, 130, 152, 128, 2, 201, 130}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 64, 217, 205, 71, 57, 233, 195, 89, 188}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 150, 166, 50, 191, 149}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 234, 166, 68, 156}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 149, 236, 133, 92, 202, 154, 174, 123}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 7, 99, 70, 102}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 205, 246}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 242, 34, 21, 5, 130, 214}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 47, 245, 62, 106, 201}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 212, 194, 212}, 231},
	{{44, 94, 138, 224, 168, 0, 202, 153, 60, 89, 147, 157, 34, 132, 46, 119}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 125, 116, 77}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 179, 168, 180, 5, 220, 226, 34}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 231},
	{{44, 94, 138, 224, 168, 0, 164, 82, 93, 1, 60, 2, 155, 155, 172, 110}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 170, 195, 188, 93, 182, 193, 17}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 132, 86, 0, 98, 171, 69, 61}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 16, 124, 58, 163, 60, 24}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 90, 223, 148, 61, 139, 72, 252}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 82, 22, 176, 93, 40, 35, 216}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 253, 93, 85, 215, 200, 83, 174, 130, 19}, 231},
	{{44, 94, 138, 224, 168, 0, 163, 0, 90, 129, 136, 163, 236, 204, 253, 121}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 103}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 7, 144, 35, 222, 21, 84}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 25, 217, 228, 87, 64, 199}, 231},
	{{44, 94, 138, 224, 168, 0, 69, 94, 82, 167, 83, 238, 112, 17, 16, 139}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 242, 45, 175, 33, 5}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 198, 113, 223, 124, 159, 125, 225}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 78, 56, 97, 188, 204, 196, 107, 238, 249}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 217, 191, 211, 168, 229, 216, 212, 188}, 231},
	{{44, 94, 138, 224, 168, 0, 216, 38, 61, 59, 22, 52, 66, 100, 213, 2}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 164, 176, 37, 58, 232}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 94, 228, 244, 162}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 201, 42, 92}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 82, 104, 244, 141, 103, 195, 7, 139}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 151, 4, 164, 207, 253, 14, 148, 221, 54}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 176, 191, 124, 69, 131}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 234, 255, 229, 30, 238, 127, 125, 89, 209}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 48, 146, 88, 243, 115, 54}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 181, 115}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 235, 223, 233, 139, 182, 116, 141, 119}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 45, 31, 219, 9}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 241, 46, 17, 114, 58}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 211, 135, 131}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 116, 185, 228, 240}, 231},
	{{44, 94, 138, 224, 168, 0, 55, 175, 94, 110, 75, 11, 73, 235, 243, 233}, 231},
	{{44, 94, 138, 224, 168, 0, 80, 77, 188, 47, 232, 225, 159, 151, 129, 27}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 252}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 31, 86, 108, 72}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 0, 0, 0, 248, 194}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 220, 224, 151, 70, 25, 139, 2}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 56, 229, 249, 2, 125, 232, 169, 32}, 231},
	{{44, 94, 138, 224, 168, 0, 134, 206, 38, 83, 103, 122, 160, 116, 71, 110}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 106, 164, 175, 206, 103, 65, 78, 173, 180}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 186, 148, 234, 91, 221, 240, 35}, 231},
	{{44, 94, 138, 224, 168, 0, 0, 0, 0, 0, 0, 207, 200, 157, 122, 253}, 231},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 114, 52, 108, 236, 35, 129}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 165, 237, 2, 192, 37, 168, 82, 89, 43}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 29, 222, 182}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 90, 218, 196, 144}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 39, 56, 15, 23}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 142, 89, 161, 222, 56, 24, 89, 43, 206}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 199, 60, 45, 49, 225, 203, 115, 197, 6}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 164, 219, 16, 255, 27, 174, 102, 199}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 106, 170, 224, 54, 27}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 243, 203, 12, 252}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 171, 58, 144, 89, 137, 157, 120, 176}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 64, 184, 143}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 123, 14, 89, 12, 150, 223, 68, 225}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 225, 116, 8, 77, 102}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 39, 194, 216, 177}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 172, 116, 168}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 14, 163, 153, 231}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 186, 33, 250, 233, 87, 229, 220, 164}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 184}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 141, 109, 56}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 21, 232, 10, 190, 51, 175, 39, 136, 99}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11},
	{{184, 221, 109, 135, 225, 32, 2, 113, 162, 44, 73, 240, 229, 185, 14, 35}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 238, 116, 219, 145, 24, 252, 106, 241}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 254, 223, 55, 107, 59, 140, 174}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 180, 117, 114, 76, 193}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 68, 152, 110, 152, 197, 167}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 124, 15}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 140, 36, 178}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 6, 130, 208, 81}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 226, 123, 134}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 88, 55, 218, 1, 237, 185, 228, 35, 127}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 191, 29, 50, 251, 65, 154, 23, 97}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 245, 156}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 190, 86, 107, 107, 90, 105, 241}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 149, 94, 187, 68, 84, 39, 128}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 54, 1, 61}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 53, 233, 230, 191, 27, 215, 226, 203}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 120, 16, 174, 157, 44, 174, 240, 145}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 241, 89}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 124, 191, 20}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 104}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 152, 130, 86, 25}, 11},
	{{184, 221, 109, 135, 225, 32, 68, 14, 172, 203, 249, 250, 210, 234, 105, 37}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 37, 65, 205, 207, 105, 84}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 112, 59, 93, 178}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 160, 189}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 120, 26, 135, 178, 233, 150, 73}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 26}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 99, 229, 200, 4, 6, 63}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11},
	{{184, 221, 109, 135, 225, 32, 245, 95, 3, 45, 47, 16, 187, 45, 204, 120}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 128, 148, 233}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 90, 84, 101, 111, 177, 57, 64, 242}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 166}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 207, 214, 22, 65, 134, 36, 195}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 199, 186, 208, 104, 89, 157, 170, 180}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 215}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 255, 8, 216, 31}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 168, 225}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 116, 167}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 249, 250, 84, 147, 224, 248, 94, 13, 229}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 231, 209, 34, 172, 120, 62, 65}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 137, 190, 106, 211, 128, 13, 59}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 171, 86, 219, 14, 132, 250, 96}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 123, 88, 255, 31, 115, 255, 23, 42, 17}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 89, 52, 9, 14}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 70, 222, 207, 148, 183}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 178, 193, 163, 231, 249}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 38, 167, 133}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 192, 251, 92}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 180}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 116, 224, 55, 0, 18, 253, 44, 3}, 11},
	{{184, 221, 109, 135, 225, 32, 195, 167, 137, 244, 85, 140, 197, 183, 98, 49}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 184, 200, 206, 241, 17, 27, 40, 255, 164}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 40, 84}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 73, 68, 193, 184, 27, 225}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 39, 203}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 157, 173, 22, 251, 28, 48, 160, 168}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 198, 93, 123}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 116, 234, 139, 224, 223, 61}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 9, 93, 186, 51, 35, 146}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 100, 108, 77, 104, 247, 230, 179, 169}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 228, 60, 122, 179, 16, 248, 34}, 11},
	{{184, 221, 109, 135, 225, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 201}, 11},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 61, 198}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 243, 27, 46}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 67, 73}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 227, 183, 15}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 219, 212, 160}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 57, 6}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 253, 20, 61}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 8}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 144, 133, 233}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 240, 55}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 58, 21}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 230, 87}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 230, 134}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 1, 30}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 206, 81}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 205}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 165, 253}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 109, 213}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 187, 152, 119}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 167, 58}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 116, 67, 145}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 81, 73}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 230}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 148, 102, 46}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 14}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 240, 16}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 225, 221}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 247, 41}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 128}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 14, 188, 71}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 59, 19, 243}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 102, 122}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 220}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 91, 249}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 89, 94, 10}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 87, 122}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 144, 118, 209}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 59, 185, 77}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 106, 234, 16}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 253, 146}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 100, 63, 177}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 246}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 233, 101}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 178, 218, 12}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 100}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 43}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 241}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 15}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 92, 110, 188}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 72}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 44, 244, 101}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 111, 86, 144}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 177}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 112}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 144, 180, 230}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 219}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 26, 187, 117}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 55}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 2}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 144, 172, 146}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 208}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 205, 161, 1}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 173}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 185, 210}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 183, 234, 28}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 107, 173, 165}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 138}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 57, 103, 39}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 135, 16}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 141, 55}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 196}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 0, 0}, 20},
	{{51, 179, 136, 184, 30, 118, 24, 16, 26, 161, 206, 101, 0, 0, 123, 185}, 20},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 221, 12, 9, 238, 86, 227}, 68},
	{{48, 46, 0, 0, 0, 203, 57, 10, 203, 53, 37, 21, 38, 135, 219, 107}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 24, 7, 31, 193, 75, 35, 4, 12, 49}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 141, 50, 145}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 69, 51, 198, 162, 79, 24, 143, 117}, 68},
	{{48, 46, 0, 0, 0, 53, 137, 201, 30, 182, 226, 46, 244, 44, 2, 108}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 196}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 98, 64, 71, 9}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 252, 243}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 88, 9, 154, 103, 140, 199, 154, 56, 174}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131, 103, 211, 38}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 153, 41}, 68},
	{{48, 46, 0, 0, 0, 240, 104, 168, 105, 222, 152, 114, 158, 96, 47, 82}, 68},
	{{48, 46, 0, 0, 41, 232, 124, 80, 44, 138, 212, 88, 30, 163, 245, 97}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 246, 233, 44, 42, 47, 154}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 66, 109, 105, 160, 227, 73, 115, 79, 8}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 212, 11, 227}, 68},
	{{48, 46, 0, 0, 43, 236, 82, 249, 86, 73, 148, 99, 192, 105, 171, 248}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 2, 106, 65, 35, 109, 237, 123}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 104}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 58, 163, 150, 74, 38, 97}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 96, 207, 59}, 68},
	{{48, 46, 0, 125, 144, 36, 245, 52, 16, 215, 101, 50, 86, 90, 174, 234}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 224, 214, 128, 135, 29, 39}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 139, 181, 85, 79, 134}, 68},
	{{48, 46, 0, 0, 0, 0, 17, 131, 198, 1, 198, 143, 184, 219, 45, 226}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 33, 81, 96, 168, 130, 4, 97}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 151, 102, 138, 15, 185, 153, 57}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 27, 188, 236, 176, 179, 217}, 68},
	{{48, 46, 0, 0, 116, 146, 105, 243, 220, 65, 135, 172, 232, 254, 94, 235}, 68},
	{{48, 46, 0, 0, 0, 0, 117, 158, 201, 11, 220, 138, 47, 129, 22, 54}, 68},
	{{48, 46, 0, 0, 0, 125, 196, 95, 138, 163, 139, 43, 13, 209, 234, 162}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 213, 121}, 68},
	{{48, 46, 0, 0, 234, 190, 137, 169, 233, 69, 29, 47, 139, 174, 247, 193}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 170}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 25, 150}, 68},
	{{48, 46, 0, 32, 117, 212, 4, 135, 137, 12, 80, 235, 244, 218, 24, 220}, 68},
	{{48, 46, 0, 0, 0, 0, 4, 153, 35, 20, 103, 95, 103, 46, 104, 49}, 68},
	{{48, 46, 0, 80, 96, 66, 255, 49, 58, 22, 51, 190, 86, 133, 2, 91}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 198, 190, 26, 122, 181, 164, 160, 33}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 146, 237, 69, 174}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 33, 203, 239, 136, 196, 38, 33}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 36, 119, 210, 225, 0, 122, 22, 172}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 68},
	{{48, 46, 0, 0, 97, 131, 195, 188, 119, 111, 194, 41, 247, 206, 110, 90}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 116, 96, 234}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 65, 216}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 59, 124, 3, 100, 232, 92, 192, 104}, 68},
	{{48, 46, 0, 0, 0, 73, 106, 2, 23, 168, 61, 226, 209, 101, 74, 73}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 210, 3, 159}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 5, 160, 38, 229, 82, 7, 134}, 68},
	{{48, 46, 0, 0, 0, 224, 185, 122, 103, 45, 5, 135, 253, 75, 104, 61}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 76, 123}, 68},
	{{48, 46, 0, 171, 183, 104, 225, 119, 71, 116, 214, 125, 4, 212, 196, 60}, 68},
	{{48, 46, 0, 0, 0, 212, 238, 204, 61, 38, 180, 65, 75, 151, 103, 158}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 132, 211, 120, 217}, 68},
	{{48, 46, 0, 252, 83, 64, 230, 127, 132, 71, 90, 128, 137, 71, 105, 50}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 213, 5}, 68},
	{{48, 46, 0, 174, 99, 251, 57, 123, 140, 15, 168, 97, 207, 204, 95, 186}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 152, 51, 174}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 176, 146, 62, 129, 27, 138, 72}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 14, 173, 210, 18, 72, 153, 181}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 164, 64, 9}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 104, 156, 7}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 235, 36, 29, 153, 224}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 163, 150, 224, 69, 182, 77, 91}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 125, 10, 165}, 68},
	{{48, 46, 0, 0, 0, 0, 52, 190, 158, 222, 92, 224, 212, 221, 41, 156}, 68},
	{{48, 46, 0, 0, 188, 4, 192, 199, 181, 179, 219, 201, 230, 209, 51, 247}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 105, 137, 118, 198, 128, 145, 238, 222, 172}, 68},
	{{48, 46, 0, 0, 19, 36, 30, 15, 10, 98, 33, 152, 143, 174, 238, 92}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 219, 252}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 44, 44}, 68},
	{{48, 46, 0, 0, 252, 24, 226, 107, 187, 136, 124, 129, 17, 216, 179, 66}, 68},
	{{48, 46, 0, 0, 0, 0, 48, 72, 8, 128, 171, 223, 60, 14, 219, 95}, 68},
	{{48, 46, 0, 0, 0, 0, 250, 49, 153, 251, 205, 24, 157, 184, 40, 214}, 68},
	{{48, 46, 0, 0, 63, 169, 23, 150, 222, 127, 182, 9, 99, 153, 200, 50}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 215, 244, 77}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 222, 9, 168, 70, 60, 52, 150, 204}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 102}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53, 250}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 85, 122, 128, 132, 204, 55, 234}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 243, 6, 51}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 96, 226, 159, 36}, 68},
	{{48, 46, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 68},
	{{48, 46, 0, 0, 0, 176, 165, 143, 144, 232, 106, 21, 154, 198, 153, 178}, 68},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 227}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 219, 171}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 95}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 95}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 74, 110}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 41, 220, 158}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 223}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 102, 207, 239}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 7, 131}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 55}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 229, 148}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 54, 146, 63}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 230}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 161}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 75, 165}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 238}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 214, 43}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 158, 209, 43}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 167, 28, 79}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 80, 107}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 239}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 147, 85}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 187, 212, 109}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 12, 201, 235}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 48, 142}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 171}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 244, 243}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 186}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 190, 17}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 89, 166}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 114, 158, 131}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 200, 41, 101}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 216, 243}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 97, 140}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 49}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 145}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 81, 46, 153}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 147, 45}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 42}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 190}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 228, 27}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 114, 152}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 19, 210}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 225}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 102, 115}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 225, 244}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 81, 28}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 152}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 162, 204}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 126, 226, 84}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 95}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 106}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 47}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 8}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 19, 5}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 190, 127}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 175}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 254, 68, 222}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 172, 98}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 141, 184, 199}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 49, 87}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 122, 66, 88}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 77}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 98, 157}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 107, 119}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 153}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 168}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 129}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 223, 220}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 0}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 246, 252}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 241}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 179}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 0, 11}, 64},
	{{143, 235, 237, 220, 89, 119, 187, 143, 209, 94, 46, 58, 120, 0, 236, 132}, 64},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 167, 228, 61, 250, 115, 161}, 152},
	{{121, 190, 90, 177, 128, 0, 29, 173, 80, 159, 106, 45, 17, 141, 39, 249}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 2, 167, 6, 9, 103, 151}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 117, 115, 170, 11, 56, 178, 47, 58}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 178, 13, 52, 129, 193, 144, 103}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 31, 157, 120, 159, 237, 254}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 163, 66}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 138, 93, 100, 244, 64}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 67, 9, 103, 159}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 149, 51, 18, 115}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 12, 188, 2, 74, 47, 160, 135}, 152},
	{{121, 190, 90, 177, 128, 38, 141, 144, 76, 74, 98, 166, 131, 96, 230, 74}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 166, 222, 10}, 152},
	{{121, 190, 90, 177, 128, 163, 10, 156, 242, 15, 233, 185, 94, 143, 213, 106}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 229, 9}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 75, 152, 100, 34, 79, 155, 166, 243, 167}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 251, 36, 122}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 94, 205, 68, 50, 185, 232, 208}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 160, 93, 50}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 244, 52, 29, 49}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 174, 197, 11, 57, 93, 246, 235}, 152},
	{{121, 190, 90, 177, 128, 0, 197, 155, 80, 93, 84, 250, 225, 231, 114, 47}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 240, 43, 159, 76, 236, 28}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 16, 12, 129, 184, 33, 34, 215}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 233, 21, 14, 140, 107, 149, 62, 34}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 109, 0, 66, 220, 3, 42, 14}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 15, 102, 59, 96, 78, 69, 73, 137}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 189, 234}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 234, 188, 210, 210, 91, 110, 213, 25}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 211}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 55, 12, 217, 144, 63, 97, 201, 246, 77}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 61, 139, 101, 238, 155}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 40, 140, 195, 47, 110, 12, 203, 165, 158}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 94, 161, 216, 82, 152, 82}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 152, 183}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 157, 31}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 56, 156, 170, 227}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 179, 99, 163, 75, 88}, 152},
	{{121, 190, 90, 177, 128, 0, 185, 211, 101, 132, 208, 218, 143, 207, 176, 75}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 64, 12, 3, 142}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 113, 146, 155, 81, 84}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 152},
	{{121, 190, 90, 177, 128, 0, 9, 178, 224, 45, 78, 190, 170, 234, 137, 144}, 152},
	{{121, 190, 90, 177, 128, 121, 29, 170, 2, 181, 182, 180, 210, 111, 136, 113}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 152},
	{{121, 190, 90, 177, 128, 0, 219, 231, 176, 200, 63, 152, 48, 50, 186, 206}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 74, 154, 183, 159, 44}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 75, 92, 20, 60, 59, 97}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 93, 86, 248, 116}, 152},
	{{121, 190, 90, 177, 128, 0, 144, 254, 238, 149, 123, 210, 180, 181, 81, 153}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 245, 121, 239, 243, 89, 21}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 240, 241, 50, 137, 31, 173}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 126, 1, 129, 3, 142, 233}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66, 192}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 254, 167, 193, 246, 210}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 152},
	{{121, 190, 90, 177, 128, 0, 70, 249, 233, 236, 0, 8, 148, 107, 47, 92}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 189, 133}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 45, 42, 203, 190, 49, 49, 142, 198, 223}, 152},
	{{121, 190, 90, 177, 128, 9, 5, 34, 99, 38, 213, 40, 78, 182, 32, 67}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 140, 175, 107, 242, 177, 24, 168, 147}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 157, 251, 128, 245, 56, 112, 71, 197}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 28, 140, 38, 121, 239, 176, 176}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 160, 115, 217, 94, 205, 14, 91}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 43, 13, 86, 12, 143, 83, 6, 178, 240}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 179}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 112, 143, 19, 127, 176, 159}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 13, 231, 97, 150, 78}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 22, 234, 29}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 23, 222, 114, 179, 88, 146, 255, 73, 14}, 152},
	{{121, 190, 90, 177, 128, 0, 247, 106, 22, 194, 178, 25, 87, 152, 28, 230}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 24, 84, 75, 182, 84}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 106, 166, 38}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 58, 82, 199, 14, 111, 67, 0, 176, 174}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 134, 254, 213}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 96, 89, 129, 56, 241, 56, 249, 230, 29}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 100, 168, 25, 124, 147, 220, 249, 237}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 11, 92, 222}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 171, 180, 194, 156, 68, 124, 209}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 181, 86, 254, 179}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 163, 132, 185, 208, 149, 181, 250, 53, 173}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 216}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 80, 69, 20, 131, 12, 208, 203, 218}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 240, 106, 180, 157, 126, 62}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 246, 155, 99, 235, 242}, 152},
	{{121, 190, 90, 177, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 230}, 152},
	{{121, 190, 90, 177, 128, 232, 225, 126, 152, 199, 252, 102, 48, 92, 166, 253}, 152},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 124, 218, 47, 253}, 218},
	{{128, 0, 105, 170, 78, 198, 254, 172, 85, 253, 0, 12, 220, 175, 2, 190}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 126, 170}, 218},
	{{128, 0, 0, 0, 0, 171, 43, 71, 250, 17, 10, 217, 114, 131, 185, 65}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 224}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 117, 227, 128}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 250, 126, 177, 193, 152, 38, 198}, 218},
	{{128, 0, 0, 0, 0, 0, 189, 118, 93, 198, 146, 79, 9, 46, 39, 39}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 248, 170, 23, 229, 90}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 15, 40, 255, 148, 26, 217, 207}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 5, 225, 228, 118, 255, 215, 75, 158, 161}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 225, 72, 209}, 218},
	{{128, 0, 0, 0, 0, 35, 68, 160, 138, 56, 248, 43, 10, 176, 161, 75}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 202, 113, 136, 90, 181}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 50, 202, 107, 250, 31, 60, 250, 209}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 102, 19, 197, 23, 178, 116}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 218},
	{{128, 0, 0, 0, 0, 0, 78, 165, 77, 184, 212, 13, 200, 54, 164, 124}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 156, 174, 66, 41, 8, 104}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 22, 211, 175, 168, 19}, 218},
	{{128, 0, 92, 72, 42, 195, 226, 217, 197, 101, 102, 64, 48, 11, 201, 241}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 26, 80, 55, 106, 181, 167, 63, 228, 120}, 218},
	{{128, 0, 0, 0, 47, 9, 169, 243, 253, 46, 166, 87, 216, 20, 189, 112}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 152, 230, 123, 57, 246, 212}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 143, 197, 213, 29, 104, 170, 11}, 218},
	{{128, 0, 0, 0, 0, 104, 192, 232, 136, 206, 72, 92, 143, 185, 17, 200}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 143, 173, 138}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 218},
	{{128, 0, 155, 124, 255, 88, 44, 225, 82, 248, 33, 218, 179, 5, 124, 228}, 218},
	{{128, 0, 0, 244, 150, 69, 108, 70, 129, 203, 74, 128, 19, 27, 209, 206}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 126, 73, 201, 80, 101, 135}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 100, 112, 109, 197, 231, 132, 92}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 223, 217, 134, 172}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 86, 247, 30, 66}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 150, 94, 210, 225, 3, 201, 88, 62, 2}, 218},
	{{128, 0, 0, 95, 47, 162, 171, 96, 82, 3, 234, 153, 3, 4, 157, 164}, 218},
	{{128, 0, 0, 0, 0, 174, 68, 163, 250, 89, 181, 222, 16, 112, 2, 183}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 51, 122, 90, 157, 180, 107, 51}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 90, 109, 77, 95}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 11, 180, 103, 255, 156, 143, 5, 225}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 159, 244, 21, 67, 255, 126, 249}, 218},
	{{128, 0, 0, 211, 158, 243, 40, 116, 233, 224, 200, 12, 212, 36, 162, 53}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 206, 62, 169, 247, 218, 191, 28, 183}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 126, 67, 227, 36, 5, 216, 163}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 122, 168, 17, 111, 118, 225}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 70, 42, 93, 32, 0, 144}, 218},
	{{128, 0, 0, 0, 0, 0, 181, 17, 44, 80, 242, 56, 151, 92, 131, 176}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 89, 216, 149, 71, 172}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 44, 129}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 85, 60, 44, 195, 139, 40, 1, 151, 56}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 218},
	{{128, 0, 0, 83, 89, 105, 133, 32, 102, 5, 32, 163, 251, 207, 204, 123}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 46, 193, 219, 33, 227, 0, 5, 43, 65}, 218},
	{{128, 0, 7, 248, 56, 33, 123, 188, 122, 129, 236, 78, 128, 223, 91, 202}, 218},
	{{128, 0, 0, 0, 180, 243, 16, 76, 251, 16, 48, 196, 116, 121, 38, 48}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 146, 102, 159, 186, 162, 239, 77, 178}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 89, 126}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 218},
	{{128, 0, 0, 0, 0, 141, 154, 27, 19, 221, 58, 10, 95, 176, 138, 189}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 236, 75, 193, 255, 120}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 233, 131, 107, 60, 191, 159, 47, 111}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 194, 78, 239, 130, 204, 141, 62, 175, 56}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 137, 123, 24, 1, 132, 127, 148, 123, 92}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 5, 109, 128, 155, 114}, 218},
	{{128, 0, 0, 0, 223, 15, 169, 235, 103, 232, 208, 65, 92, 20, 221, 247}, 218},
	{{128, 0, 0, 0, 46, 244, 114, 146, 119, 244, 99, 127, 53, 40, 69, 177}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 203, 140, 234}, 218},
	{{128, 0, 0, 0, 0, 215, 239, 186, 54, 202, 152, 149, 87, 25, 239, 182}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 201, 123, 221, 85, 40, 55}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 195, 104, 126, 246, 163, 153, 159, 101}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 193, 6, 168, 45}, 218},
	{{128, 0, 0, 0, 0, 94, 5, 234, 133, 127, 51, 218, 2, 229, 208, 31}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217, 157, 68, 21, 87}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68}, 218},
	{{128, 0, 0, 107, 19, 226, 241, 122, 140, 50, 136, 100, 115, 179, 249, 119}, 218},
	{{128, 117, 120, 215, 217, 15, 117, 20, 145, 69, 219, 214, 223, 203, 204, 42}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 199, 201, 41, 19, 53, 124, 63, 160, 13}, 218},
	{{128, 0, 0, 0, 0, 0, 130, 171, 170, 38, 27, 156, 200, 141, 237, 69}, 218},
	{{128, 0, 0, 0, 0, 107, 220, 39, 144, 172, 19, 185, 193, 162, 75, 112}, 218},
	{{128, 0, 120, 171, 236, 163, 184, 180, 144, 77, 244, 247, 196, 170, 71, 13}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 23, 9, 11, 127, 51, 157, 169, 55}, 218},
	{{128, 0, 0, 0, 0, 113, 241, 18, 102, 175, 4, 188, 209, 250, 206, 78}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 27, 245, 129, 57, 225}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 8, 139, 32, 202, 188, 224, 14, 65, 199}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 22, 239, 246, 66, 10, 118, 183, 147}, 218},
	{{128, 0, 0, 0, 174, 23, 0, 95, 125, 139, 158, 187, 20, 184, 243, 27}, 218},
	{{128, 0, 0, 0, 121, 221, 16, 246, 5, 129, 173, 44, 146, 41, 146, 164}, 218},
	{{128, 0, 0, 0, 0, 0, 61, 51, 100, 95, 181, 66, 233, 161, 59, 239}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 193, 45, 252, 128, 228, 58}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 123, 101, 242, 175}, 218},
	{{128, 79, 39, 87, 254, 32, 62, 112, 197, 249, 194, 4, 224, 251, 2, 35}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 60}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 218},
	{{128, 0, 0, 0, 192, 117, 168, 33, 23, 139, 84, 29, 62, 239, 176, 21}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 190}, 218},
	{{128, 0, 0, 0, 255, 115, 252, 1, 54, 206, 61, 77, 249, 153, 3, 146}, 218},
	{{128, 0, 0, 0, 0, 0, 249, 175, 87, 143, 123, 172, 206, 223, 49, 66}, 218},
	{{128, 0, 252, 234, 64, 192, 199, 37, 90, 76, 33, 172, 217, 53, 235, 232}, 218},
	{{128, 0, 0, 0, 0, 49, 132, 153, 110, 165, 133, 121, 52, 197, 79, 183}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 60, 130, 86, 35, 96, 194, 128}, 218},
	{{128, 0, 0, 108, 80, 201, 104, 122, 249, 49, 32, 164, 233, 174, 255, 60}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 211}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 46, 90}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 183, 171, 148, 70, 15, 186, 226}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 24, 86, 18, 251, 199, 251, 17, 4, 20}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 252, 87, 57, 98, 122}, 218},
	{{128, 0, 87, 45, 136, 4, 221, 237, 240, 23, 125, 29, 116, 31, 12, 107}, 218},
	{{128, 0, 0, 0, 0, 212, 83, 17, 50, 160, 168, 17, 223, 67, 112, 177}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 212, 58, 184, 102, 136, 211, 247, 95}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 80, 36, 109, 22, 222}, 218},
	{{128, 0, 0, 176, 5, 48, 82, 71, 246, 165, 196, 137, 134, 177, 207, 89}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 131, 105, 193, 125}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 2, 114}, 218},
	{{128, 0, 0, 0, 90, 29, 119, 108, 143, 76, 198, 135, 181, 131, 116, 16}, 218},
	{{128, 0, 0, 120, 148, 94, 123, 45, 66, 58, 16, 10, 29, 130, 53, 26}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 219, 0, 69, 86, 176}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 137, 110, 54, 104, 161, 131, 101, 252, 29}, 218},
	{{128, 0, 0, 0, 65, 253, 235, 1, 128, 210, 180, 33, 112, 146, 242, 211}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 150, 91, 201, 226, 109, 31, 26}, 218},
	{{128, 0, 0, 0, 0, 0, 190, 118, 207, 240, 160, 187, 173, 4, 219, 229}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68, 93, 134, 225, 104}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 188, 27, 159, 104, 126, 215, 52, 128, 95}, 218},
	{{128, 0, 0, 0, 0, 0, 37, 19, 199, 217, 108, 148, 147, 35, 98, 62}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 194, 250, 5, 2}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 175, 185, 22, 231, 126}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 121, 42}, 218},
	{{128, 0, 0, 76, 135, 170, 16, 158, 78, 182, 15, 19, 175, 212, 50, 144}, 218},
	{{128, 0, 0, 0, 0, 157, 176, 47, 66, 66, 63, 53, 229, 188, 12, 111}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 234, 34, 252, 222, 98}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 148, 153, 254}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 99}, 218},
	{{128, 0, 0, 0, 117, 56, 77, 186, 202, 239, 241, 34, 71, 229, 82, 186}, 218},
	{{128, 0, 0, 0, 0, 26, 24, 126, 157, 201, 156, 242, 245, 4, 147, 58}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 189}, 218},
	{{128, 0, 0, 130, 100, 102, 244, 242, 33, 78, 56, 214, 66, 155, 22, 108}, 218},
	{{128, 0, 0, 0, 0, 0, 245, 173, 88, 107, 101, 157, 155, 24, 144, 160}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 129, 247, 51}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 108, 41, 77, 160}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 46}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 138, 227, 108, 172, 205, 26, 163}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 125, 70, 204, 231, 165, 184}, 218},
	{{128, 35, 120, 52, 159, 210, 136, 210, 182, 227, 151, 9, 210, 38, 92, 113}, 218},
	{{128, 0, 0, 0, 83, 233, 90, 135, 201, 34, 201, 121, 38, 61, 15, 132}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 233, 222, 97, 157, 27, 244, 26, 140, 140}, 218},
	{{128, 0, 0, 0, 0, 0, 116, 50, 198, 114, 25, 31, 219, 64, 104, 204}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 184, 0, 38, 133, 158, 155, 251, 73}, 218},
	{{128, 0, 197, 113, 199, 165, 3, 124, 138, 50, 193, 49, 94, 207, 120, 118}, 218},
	{{128, 0, 0, 0, 220, 99, 54, 107, 229, 116, 227, 197, 153, 174, 254, 57}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57, 156, 243, 52, 149}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 112, 129, 183, 1}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 184, 236}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 65, 13, 121, 10, 223, 140, 145, 56}, 218},
	{{128, 0, 0, 0, 0, 0, 154, 155, 156, 130, 69, 54, 13, 241, 252, 82}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 231, 216, 161, 253, 79, 233, 71}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 175, 107, 141, 64}, 218},
	{{128, 0, 0, 21, 166, 170, 104, 28, 200, 75, 235, 68, 224, 13, 192, 33}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 161, 176, 97, 181}, 218},
	{{128, 0, 0, 0, 0, 0, 5, 64, 185, 27, 175, 68, 78, 233, 169, 41}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 96, 12, 138, 237, 118, 9}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 193, 38, 228, 49, 94, 122, 196, 225, 111}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 250}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 122, 212, 38, 32, 245, 176, 197, 76}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 129, 203, 47}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 84, 172, 218, 254, 34, 112, 133, 189}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 54, 203, 208, 149, 161, 146}, 218},
	{{128, 0, 0, 0, 109, 103, 168, 147, 154, 126, 135, 187, 62, 136, 24, 251}, 218},
	{{128, 109, 162, 128, 148, 64, 177, 14, 66, 193, 250, 157, 33, 52, 127, 28}, 218},
	{{128, 155, 71, 143, 62, 97, 44, 100, 93, 69, 84, 224, 156, 155, 159, 166}, 218},
	{{128, 0, 247, 109, 199, 205, 158, 8, 220, 98, 46, 197, 64, 97, 219, 130}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 236, 195, 134, 165, 146, 218, 98, 94, 221}, 218},
	{{128, 0, 0, 0, 126, 121, 58, 155, 69, 4, 16, 180, 196, 38, 50, 244}, 218},
	{{128, 0, 0, 15, 41, 242, 125, 128, 161, 67, 84, 84, 62, 23, 99, 131}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 69, 112, 101, 229}, 218},
	{{128, 0, 0, 249, 166, 125, 48, 110, 205, 238, 193, 217, 39, 186, 229, 178}, 218},
	{{128, 0, 0, 146, 205, 172, 151, 215, 32, 224, 200, 2, 254, 157, 167, 82}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 45, 196, 222, 80}, 218},
	{{128, 0, 0, 0, 0, 181, 240, 8, 117, 242, 102, 180, 121, 223, 67, 86}, 218},
	{{128, 69, 202, 249, 2, 28, 230, 51, 126, 173, 170, 32, 116, 210, 112, 99}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 148, 108}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 240}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 154}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 228, 59, 187, 81, 207, 190, 105, 171}, 218},
	{{128, 0, 0, 0, 127, 71, 186, 33, 243, 104, 15, 71, 157, 234, 17, 198}, 218},
	{{128, 0, 0, 221, 254, 155, 191, 204, 131, 14, 109, 161, 2, 194, 149, 168}, 218},
	{{128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 218},
	{{111, 214, 0, 0, 121, 4, 28, 7, 123, 41, 115, 31, 91, 141, 163, 57}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 178, 150, 196, 105, 123}, 58},
	{{111, 214, 0, 0, 160, 27, 218, 189, 24, 30, 6, 92, 255, 26, 66, 64}, 58},
	{{111, 214, 0, 0, 0, 0, 205, 73, 2, 28, 70, 201, 109, 194, 223, 107}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 78, 94, 0, 161, 227, 128}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 180, 115, 5, 111, 219, 190}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 136, 255, 253}, 58},
	{{111, 214, 0, 84, 33, 209, 98, 179, 219, 211, 49, 55, 225, 2, 68, 47}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 218, 153, 27, 30}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 77, 168, 59}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 41, 104, 106, 215, 208, 43, 113}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 188}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 80, 196, 149, 165, 89, 107, 211}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 107, 53, 222}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 176, 207, 238, 230, 70, 65}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 114, 34, 119, 193, 137, 2, 137}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 27, 253, 169, 102, 29, 233}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 58},
	{{111, 214, 0, 0, 0, 114, 121, 178, 219, 117, 93, 138, 43, 171, 88, 74}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 23, 51, 204, 239, 1, 19, 145, 93}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 110, 231, 147, 216}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 187, 28, 99}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 58},
	{{111, 214, 0, 15, 212, 45, 219, 89, 47, 104, 209, 41, 91, 93, 227, 172}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 248, 184, 35, 198, 57}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 234, 160, 168, 16, 143, 5}, 58},
	{{111, 214, 0, 0, 0, 110, 186, 64, 3, 181, 38, 144, 57, 142, 28, 203}, 58},
	{{111, 214, 0, 128, 201, 47, 142, 164, 65, 229, 67, 128, 52, 140, 91, 42}, 58},
	{{111, 214, 0, 149, 1, 225, 152, 3, 211, 143, 210, 119, 121, 50, 15, 43}, 58},
	{{111, 214, 0, 0, 174, 165, 145, 43, 197, 13, 168, 4, 164, 133, 183, 110}, 58},
	{{111, 214, 0, 0, 0, 161, 163, 153, 148, 250, 64, 143, 11, 167, 149, 108}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 121, 238, 48, 158}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 136, 196, 27, 78, 94, 172}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 16, 154, 93, 245, 245, 185, 96, 97}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75, 235}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 175}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 94}, 58},
	{{111, 214, 0, 0, 0, 0, 237, 241, 172, 161, 134, 139, 153, 134, 50, 113}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 31, 113, 23, 52, 57, 104, 107}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 207, 221, 206, 245, 165, 214, 128}, 58},
	{{111, 214, 0, 38, 192, 11, 225, 46, 223, 68, 85, 193, 158, 8, 105, 185}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 120, 253, 221, 213, 216, 169, 204, 135}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 72}, 58},
	{{111, 214, 0, 0, 0, 236, 97, 132, 109, 176, 208, 243, 18, 113, 110, 88}, 58},
	{{111, 214, 0, 0, 0, 17, 158, 0, 99, 33, 27, 184, 150, 202, 11, 43}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 216, 196, 114, 220, 158, 75, 156}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 133, 122, 54, 138, 138, 52}, 58},
	{{111, 214, 0, 0, 141, 183, 37, 88, 162, 96, 31, 110, 180, 96, 41, 118}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 245, 20, 22}, 58},
	{{111, 214, 0, 0, 0, 113, 211, 51, 72, 188, 104, 26, 18, 116, 101, 211}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 178, 131, 101, 204}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 105}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 58},
	{{111, 214, 0, 221, 113, 77, 199, 250, 49, 51, 227, 237, 135, 197, 23, 173}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 100, 144, 232, 93}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206}, 58},
	{{111, 214, 0, 182, 151, 225, 12, 194, 139, 150, 138, 73, 145, 193, 226, 96}, 58},
	{{111, 214, 0, 0, 0, 0, 174, 72, 103, 0, 191, 214, 184, 6, 21, 88}, 58},
	{{111, 214, 0, 0, 0, 64, 84, 225, 209, 133, 109, 69, 250, 97, 229, 8}, 58},
	{{111, 214, 0, 64, 254, 142, 56, 17, 182, 220, 232, 197, 16, 103, 148, 75}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 9, 82, 100, 223, 168, 115}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 140, 13, 95, 23, 244, 4, 107, 50, 244}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 126, 131, 16, 43, 93, 17, 189, 79}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19}, 58},
	{{111, 214, 0, 0, 0, 0, 199, 142, 10, 47, 204, 66, 90, 50, 159, 132}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 162, 2, 34, 182}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 163, 133, 73, 223, 230, 18, 62}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24, 242, 82, 99}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 73, 131, 165, 171, 233, 148}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 94, 35, 2}, 58},
	{{111, 214, 0, 0, 0, 239, 41, 243, 129, 222, 121, 177, 222, 208, 190, 96}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 42, 198}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 190, 101, 180, 84, 146}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 236, 245, 195, 219, 72, 17, 236}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 197, 48, 194}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 93, 114, 131, 109, 8}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 11, 105, 201, 117, 134, 8, 51, 119}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 161, 169, 148, 46, 216, 22, 14, 25}, 58},
	{{111, 214, 0, 151, 19, 146, 225, 171, 26, 192, 198, 239, 221, 143, 55, 172}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 29, 2, 215, 49, 24, 65, 60, 133}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 133, 236, 45, 73, 214}, 58},
	{{111, 214, 0, 0, 0, 0, 173, 92, 11, 16, 28, 231, 41, 35, 68, 233}, 58},
	{{111, 214, 0, 16, 197, 51, 107, 111, 46, 102, 171, 254, 130, 181, 116, 224}, 58},
	{{111, 214, 0, 0, 144, 33, 9, 41, 37, 48, 230, 32, 210, 28, 106, 219}, 58},
	{{111, 214, 0, 156, 30, 176, 90, 110, 99, 70, 167, 102, 162, 213, 164, 171}, 58},
	{{111, 214, 0, 0, 15, 108, 115, 240, 223, 111, 213, 96, 90, 83, 183, 113}, 58},
	{{111, 214, 0, 99, 115, 10, 224, 140, 81, 50, 188, 128, 61, 24, 197, 73}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 61, 81, 189, 237, 180, 27, 6, 173, 167}, 58},
	{{111, 214, 0, 0, 34, 200, 139, 60, 210, 60, 235, 103, 240, 128, 5, 36}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 186, 138, 39, 183, 229, 113, 214, 153}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 166, 23, 234, 33, 232, 18}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 44, 182, 132}, 58},
	{{111, 214, 0, 0, 0, 97, 127, 13, 211, 39, 119, 90, 166, 32, 5, 252}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 242, 199, 184, 232}, 58},
	{{111, 214, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57, 97}, 58},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 178, 75, 221, 23, 87, 225}, 254},
	{{162, 23, 52, 64, 0, 150, 186, 146, 135, 28, 50, 114, 13, 119, 74, 91}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 125}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 174, 174, 145, 162, 41, 57, 242}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 89, 36, 233, 136, 189, 169, 56}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 149, 221, 125, 26, 16}, 254},
	{{162, 23, 52, 64, 0, 0, 70, 162, 48, 65, 135, 151, 64, 42, 127, 32}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 21}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 33, 207, 109, 84}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 180, 237, 247, 164, 125}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 221, 10, 82, 176, 104, 238, 137}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 44, 253, 138, 58, 204, 64}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 30, 58, 100, 218, 66, 81, 120}, 254},
	{{162, 23, 52, 64, 3, 5, 236, 208, 10, 156, 199, 169, 205, 56, 247, 115}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 103, 48, 216, 163, 25, 172, 152, 227}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 90, 15, 115, 41, 61, 63, 150, 77, 56}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 36, 119, 82, 90, 189, 138}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 73, 38, 184, 158, 145, 108}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 118, 69, 35, 139}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 76, 234, 240, 7, 167, 236, 28}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 40, 106, 31, 172, 147, 51, 49, 203}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 61}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 136, 196, 247, 23}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 198, 35, 189, 71, 4}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 87, 58, 136, 60, 215, 204, 76, 101, 238}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 53, 250, 124, 232, 45}, 254},
	{{162, 23, 52, 64, 0, 0, 39, 88, 218, 207, 225, 143, 251, 181, 33, 182}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 71, 176, 119, 71, 232}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 118, 43}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 243, 148, 76, 46, 28, 233, 88, 28, 151}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 44, 141, 14, 193}, 254},
	{{162, 23, 52, 64, 162, 117, 222, 113, 71, 246, 123, 153, 149, 92, 40, 19}, 254},
	{{162, 23, 52, 64, 0, 0, 199, 166, 204, 224, 186, 156, 58, 35, 220, 190}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52, 177}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 126, 57, 75, 89, 5, 23, 91}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, 108}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 161, 22, 142, 55, 179, 38, 100}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 128, 34, 226, 88, 132, 114}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 166, 66, 1}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 26, 217, 51, 23, 239, 231, 28, 161}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 195, 92, 11, 177}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 76, 184}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 16, 188, 90, 207, 179, 14}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 55, 157, 5, 16, 80, 91, 186, 139}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 130, 53, 194, 124, 66, 20, 222, 128, 213}, 254},
	{{162, 23, 52, 64, 0, 0, 219, 235, 90, 240, 174, 119, 169, 119, 77, 100}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 250, 160, 52, 158, 5, 182, 113, 89}, 254},
	{{162, 23, 52, 64, 0, 165, 54, 36, 174, 59, 157, 53, 12, 10, 55, 139}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 195, 114, 69}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 132, 124, 22}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 170, 8, 191, 12, 224, 221, 17, 145, 113}, 254},
	{{162, 23, 52, 64, 0, 0, 245, 175, 70, 120, 225, 142, 234, 113, 155, 196}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 142, 71, 233, 193}, 254},
	{{162, 23, 52, 64, 0, 0, 13, 252, 129, 239, 206, 246, 96, 81, 244, 250}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 163}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 157, 203, 193, 133, 5, 21, 238}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 34, 54, 111, 184, 195, 121, 240}, 254},
	{{162, 23, 52, 64, 0, 0, 52, 106, 3, 77, 90, 117, 193, 157, 144, 83}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 216, 76, 47, 177, 134, 182, 145, 74, 253}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 6, 93, 113, 119, 229, 177, 66, 17}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 248, 62, 10, 219, 144, 247}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 70, 140, 10, 10, 81, 96, 149, 137}, 254},
	{{162, 23, 52, 64, 0, 161, 103, 184, 176, 79, 74, 35, 116, 127, 241, 249}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 170, 76, 76, 103, 95, 230, 65, 115, 73}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 235, 74, 53, 144, 61, 179, 104, 9}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 120, 149, 113, 247, 236}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 45, 246, 51, 228, 57}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 208, 219, 8, 43, 134, 136, 48}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 121, 153, 108, 5, 63, 92, 25, 82, 139}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 155, 122, 8, 77, 200}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 87, 51, 126, 195, 231, 143, 211}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 72, 176, 59, 156, 6, 39, 226, 254, 164}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 98, 131, 176}, 254},
	{{162, 23, 52, 64, 167, 246, 183, 187, 82, 175, 187, 18, 253, 184, 254, 62}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 31, 212, 254, 26, 194, 223, 65, 219, 165}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 242, 66, 242, 63, 200}, 254},
	{{162, 23, 52, 64, 93, 246, 189, 72, 230, 19, 114, 168, 61, 27, 81, 13}, 254},
	{{162, 23, 52, 64, 44, 148, 49, 122, 151, 253, 31, 108, 233, 205, 84, 218}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 58, 140, 246, 154, 203, 195}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 253, 153, 253, 149, 46, 113, 146}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 33, 169, 136, 42, 234, 140, 237, 235}, 254},
	{{162, 23, 52, 64, 0, 0, 125, 128, 235, 235, 122, 10, 97, 142, 148, 219}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 3, 50, 95, 75, 43, 224}, 254},
	{{162, 23, 52, 64, 73, 81, 136, 7, 128, 150, 39, 103, 111, 162, 207, 25}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 55, 54, 165, 248, 102, 153, 52, 17}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 144, 154, 1, 18, 115}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 222, 154, 16, 11, 140, 242, 195}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 196, 220, 11, 157, 101, 101}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 111, 75, 36, 150}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 29, 0, 39, 124, 164, 113, 45}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 110, 202, 160, 210, 99, 245, 2, 134, 145}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20}, 254},
	{{162, 23, 52, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 226}, 254},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 233, 242}, 148},
	{{76, 103, 44, 79, 0, 0, 106, 178, 10, 117, 75, 248, 93, 202, 19, 151}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 36, 133, 31, 134, 25, 161, 232, 90, 80}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 33, 81, 225, 245}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 245, 40, 220, 50, 119, 42}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 218, 137, 0, 88}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 172, 27, 233, 42, 36, 253, 86, 58}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 214, 7, 71, 5, 230}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 45, 245, 192, 150, 30, 220, 164}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 210, 11, 136, 212, 67}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 154, 20, 134, 220}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 149, 66}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 95, 103, 207, 4, 161, 246, 78, 218}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 248}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 41, 207, 196, 60, 204, 203}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 177, 241}, 148},
	{{76, 103, 44, 79, 0, 0, 53, 211, 139, 32, 189, 242, 211, 197, 126, 126}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 255, 224, 228, 126, 217, 229, 13, 62, 103}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 79, 27}, 148},
	{{76, 103, 44, 79, 0, 0, 85, 112, 190, 25, 51, 19, 143, 155, 253, 144}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 169, 20}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 106, 33}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 27, 155, 204, 24, 95, 251, 120, 84, 54}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 228, 156, 48, 77, 4}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 230, 214, 69}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 99, 104, 240, 80}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 95, 188}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 41, 237, 182, 136, 205, 98}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 108, 108, 181, 226, 237, 23}, 148},
	{{76, 103, 44, 79, 0, 134, 143, 171, 252, 222, 15, 165, 216, 80, 214, 239}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 237, 190, 210, 22, 150, 211, 158}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 167, 127, 177, 141, 200}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 28, 8, 221, 226, 77, 217}, 148},
	{{76, 103, 44, 79, 0, 0, 196, 15, 168, 69, 88, 226, 231, 120, 112, 217}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 218, 145, 40}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 22, 123, 128}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 95, 70, 169, 153, 9, 175, 162, 45, 199}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 117, 126, 42}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 59}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 247, 245, 42, 185, 140, 34, 155, 239, 226}, 148},
	{{76, 103, 44, 79, 0, 242, 5, 86, 63, 6, 194, 111, 12, 25, 91, 96}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 187, 156}, 148},
	{{76, 103, 44, 79, 0, 0, 101, 5, 105, 99, 13, 196, 44, 63, 84, 132}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 175, 66, 185, 182, 253, 23, 18, 74, 84}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 138}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 22, 15, 223, 218, 134, 32, 224}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 243, 141, 62, 209}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 228, 107, 50, 115, 79, 243, 163, 53}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 148},
	{{76, 103, 44, 79, 0, 0, 132, 33, 195, 215, 112, 165, 170, 215, 156, 85}, 148},
	{{76, 103, 44, 79, 0, 0, 142, 16, 233, 208, 193, 39, 70, 207, 126, 80}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 188, 230, 187, 10, 120, 46, 207}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75, 144, 116}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 218}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 145, 230, 16, 184, 231, 210, 64}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 186}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 154}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 171, 26, 93, 188, 220, 150, 180}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 136, 168, 238, 88, 78, 90, 54}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 147, 91, 33, 2, 80, 184, 141, 181}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 148},
	{{76, 103, 44, 79, 0, 0, 234, 134, 105, 74, 83, 191, 234, 233, 45, 225}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 61, 191, 199, 54, 212}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 49, 230, 201, 79, 80, 141, 21}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 150, 44}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 148},
	{{76, 103, 44, 79, 0, 0, 197, 43, 89, 212, 214, 235, 201, 131, 86, 142}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 148},
	{{76, 103, 44, 79, 0, 0, 106, 206, 24, 227, 215, 138, 198, 247, 175, 95}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 229, 122, 88, 151, 198}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 145, 93, 69}, 148},
	{{76, 103, 44, 79, 0, 0, 45, 136, 59, 44, 163, 253, 176, 122, 89, 79}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 157, 51, 187}, 148},
	{{76, 103, 44, 79, 0, 90, 41, 142, 40, 3, 230, 126, 119, 185, 240, 62}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 213}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 132, 34, 50, 164, 162, 44, 67, 241}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 253, 222}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 79, 100, 76, 239, 225}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 52, 75, 187, 217}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 222, 172, 122, 190, 47, 158, 140, 13, 197}, 148},
	{{76, 103, 44, 79, 0, 0, 98, 77, 172, 126, 98, 89, 164, 24, 27, 60}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 29}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 197, 224, 61, 241, 179}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 148},
	{{76, 103, 44, 79, 0, 80, 159, 112, 49, 18, 246, 69, 72, 49, 78, 182}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 120, 216, 83, 143, 228, 57, 199, 63, 243}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 88, 123, 142, 229, 216, 215, 24}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 0, 0, 0, 0, 0, 210, 226, 107}, 148},
	{{76, 103, 44, 79, 0, 0, 0, 0, 87, 226, 46, 153, 199, 187, 188, 162}, 148},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 85, 219, 214, 12, 4, 65, 129, 162, 148, 208, 78, 39, 69, 94, 184}, 126},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{80, 54, 251, 28, 152, 23, 244, 192, 151, 83, 6, 144, 223, 213, 224, 128}, 76},
	{{39, 232, 237, 103, 191, 188, 36, 0, 236, 22, 156, 13, 228, 251, 121, 235}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 0, 88}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 88, 58}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 142, 12, 227, 71, 95, 170, 55, 245, 59}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 44, 239, 48, 39, 88}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 168, 189, 238, 20}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 68, 57}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 71, 161, 239, 15, 11, 127, 125, 217}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 167, 152, 113}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 0, 106}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 0, 16}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 19, 230, 28, 72, 11, 139, 74}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 114, 58, 55, 28, 204, 85, 184, 24}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 200, 213, 211}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 221, 205}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 15, 224, 166, 84, 85, 58, 44}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 36, 82, 118, 95, 213, 56}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 33, 130}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 9, 1}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 233, 166, 218}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 0, 90}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 160, 103}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 0, 131}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 244, 250, 239, 242}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 91, 219, 170, 180, 179, 139}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 126, 30}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 237, 203, 146, 229, 183, 112, 218, 195}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 228, 2}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 0, 190}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 131, 233, 234, 233, 36}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 162, 32, 10, 197, 44}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 98, 41, 115, 5, 154, 251, 206, 5}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 173, 190, 170, 132, 53}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 229, 224, 203, 120, 57, 1, 212, 196}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 110, 140, 231, 100}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 240, 133, 151, 252, 57, 194, 177}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 13, 78, 9}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 47, 39, 151, 34}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 173, 129, 196, 163, 142, 155, 141}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 40, 43, 213, 221, 173, 159, 140, 190}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 216, 206}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 51, 198, 1, 53, 233, 177, 167}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 220, 190, 48}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 144, 116, 6, 87, 13, 114, 50, 121}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 25, 181, 3, 68, 208, 3, 197}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 0, 126}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 13, 16, 61, 236, 78, 189}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 64, 87, 26, 78}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 83, 58, 36, 42, 168, 163, 150, 53}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 139, 50, 76, 87, 250, 96, 207}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 227, 27}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 25, 24}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 237, 179, 88, 69, 48, 98}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 92, 229, 95}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 42, 249}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 77, 181, 50}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 238, 96, 33, 153}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 129, 120, 38, 123}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 206, 177, 154, 221, 231, 230, 184, 174}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 76, 206, 238, 76, 231, 57, 70, 146}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 175, 17}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 39, 110, 0}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 214, 178, 185, 199}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 183, 47, 28, 66, 139, 48, 36, 165}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 98, 157, 36, 241, 194, 132, 67, 123, 114}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 218, 74, 34}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 122, 191, 142, 129, 133, 37, 146}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 105, 157, 49, 81, 251, 137, 206, 30}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 46, 44, 41, 222, 26, 194}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 0, 123}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 161, 125, 155, 240, 118, 147}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 57, 155, 6, 163, 219}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 13, 213, 249, 161}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 128, 188, 35, 224, 222, 210}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 7, 44, 115, 0, 64}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 191, 201, 28, 221}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 225, 245, 156, 184, 174, 170, 231, 66}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 112, 109, 205, 62, 172, 72, 122}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 94, 208, 61, 222, 183, 88}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 140, 224}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 205, 170, 59}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 185, 198, 62}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 82, 174}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 225, 113, 148, 162}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 47, 222, 79, 26, 65, 110, 178}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 226, 176, 22, 213, 49, 92, 90}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 247, 103, 147}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 116, 210, 56, 112, 100}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 151, 135, 223, 129, 41, 48}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 89, 190, 224, 33}, 240},
	{{39, 232, 237, 103, 191, 188, 36, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 240},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 206, 248}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 139, 155, 44}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 218, 11, 237}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 114, 5, 58, 58}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 198, 11, 255, 218, 14, 27}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 3, 173, 59, 80, 27, 226, 218}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 144, 157}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 174, 14, 193}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 199, 11, 243, 168, 252, 241, 134, 3}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 118, 239}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 117, 145, 175, 81}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 159, 171, 83, 146, 201, 102, 85, 94}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 40}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 203, 118, 177, 36, 187, 118}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 196, 177, 102, 199, 237}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 77, 196, 98, 32}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 34, 45}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 111, 202, 156, 25}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 72, 108, 163}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 247, 51, 20, 252}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 246, 204, 205, 108, 228, 165, 83}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 96, 113, 149, 32, 200, 162, 248, 66}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 241, 124, 114, 20, 95}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 200, 0, 21, 211, 114}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 15, 4, 241, 25}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 49, 77, 73}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 159, 74, 60, 149}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 166, 29, 162, 32, 235, 136, 216, 24, 179}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 68}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 4, 50, 78, 204, 23, 2, 59, 90}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 130}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 185, 229}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 142, 138, 218, 162}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 158, 199, 211, 240, 4, 125, 56, 107}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 91}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 91}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 6, 7}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 194, 222, 0, 195, 225}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 137, 21, 152, 17, 157, 162}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 117, 94}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 154, 32}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 172, 133, 97, 52, 141}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 19, 15, 255}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 62, 133, 86, 130}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 78, 104, 140, 88, 27, 143, 181, 160}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 151, 160, 150, 155, 253, 43}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 135, 43, 220, 108, 160, 211}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 225, 71}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 142, 253, 188, 27, 147, 93, 43, 132}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 41, 129, 87, 79, 183, 126, 45, 218, 116}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 125, 218, 190, 136, 198, 136, 180, 113}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 91, 201, 10, 126, 132, 184, 99}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 217, 126}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 242}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 74, 180, 22, 62, 239, 125, 28}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 29}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 86, 67, 188, 15, 6, 167, 26, 70, 36}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 35, 9, 193}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 247, 151, 38, 107}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 246, 212, 193, 189, 178, 138, 135}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 211, 212, 2, 149, 202, 219, 211}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 138, 208, 247, 38, 54}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 33, 121, 176, 243, 216, 147, 104}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 66, 145, 42, 176, 4, 64, 30, 14}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 215, 30, 91, 242, 255, 72}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 41}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 47, 84}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 77, 25, 215, 39, 117, 39, 194}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 250, 38}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 109, 146}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 9, 169, 121, 84, 65, 180}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 93, 38, 143, 150, 26, 123, 236}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 190, 104, 148, 34}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 196, 133, 139}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 220, 208, 235, 4, 58, 14, 243, 103}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 45, 221, 162, 105, 55, 230, 211}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 153, 203, 245, 163, 180, 96, 217, 55}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 214, 103, 169, 162, 216, 154, 202}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 153}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 233, 44, 10}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 175, 167}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 202, 161, 34, 139, 227, 201}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 0, 235}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 254, 27}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 0, 0, 175, 214}, 33},
	{{20, 231, 89, 210, 167, 173, 80, 0, 0, 0, 0, 0, 119, 233, 149, 201}, 33},
	{{125, 67, 198, 128, 0, 51, 236, 50, 245, 53, 235, 175, 239, 223, 210, 197}, 47},
	{{125, 67, 198, 128, 0, 123, 130, 151, 79, 15, 162, 141, 183, 139, 116, 109}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 236, 103}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 170}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 200, 182, 110, 217, 79, 65}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 203, 83}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 61, 139, 195, 163}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 245, 175, 109, 154, 84, 107}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 155, 179, 57, 123, 236, 13, 72}, 47},
	{{125, 67, 198, 128, 0, 176, 60, 244, 130, 230, 212, 183, 244, 127, 153, 122}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 191, 165, 129, 83, 121, 117, 200, 109}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 121, 164, 12, 224, 219, 157, 146}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 89, 98}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 143, 114, 198, 133, 234, 130, 63, 196, 239}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 30, 175, 166, 221, 139}, 47},
	{{125, 67, 198, 128, 0, 41, 219, 66, 241, 9, 37, 146, 173, 73, 28, 4}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 114, 193, 59, 113, 210, 165, 233, 22}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 143, 182, 47, 49, 74}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 229, 155, 185}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 172, 165, 228}, 47},
	{{125, 67, 198, 128, 112, 21, 4, 158, 195, 45, 163, 62, 20, 100, 186, 5}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 211, 2, 25, 253, 94, 74, 109, 170, 38}, 47},
	{{125, 67, 198, 128, 0, 0, 159, 153, 156, 168, 53, 238, 255, 146, 137, 29}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 4, 231, 171, 85, 109}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 98}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 153}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 231, 186, 10, 86, 24, 123, 200, 55}, 47},
	{{125, 67, 198, 128, 140, 239, 17, 231, 130, 166, 2, 163, 83, 208, 173, 160}, 47},
	{{125, 67, 198, 128, 0, 0, 95, 172, 121, 175, 29, 83, 8, 248, 194, 131}, 47},
	{{125, 67, 198, 128, 0, 8, 88, 167, 92, 52, 230, 243, 136, 43, 79, 205}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 194, 145, 242, 6, 236, 41, 251}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 255, 73, 219, 185, 234, 37, 245}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 184, 229, 34}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 12, 49}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 203, 248}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 97, 252, 211, 247, 47, 241, 153, 191}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 200, 77, 114, 204}, 47},
	{{125, 67, 198, 128, 0, 0, 79, 128, 27, 62, 112, 234, 178, 121, 249, 226}, 47},
	{{125, 67, 198, 128, 0, 116, 159, 77, 238, 160, 17, 236, 106, 118, 41, 77}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 49, 165, 62, 55, 25, 161, 106, 130, 130}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 147, 2, 180, 66, 19, 156, 155}, 47},
	{{125, 67, 198, 128, 0, 168, 200, 112, 70, 206, 145, 101, 253, 239, 57, 158}, 47},
	{{125, 67, 198, 128, 0, 0, 142, 93, 28, 245, 23, 128, 250, 95, 142, 45}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 111}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 110, 98, 113, 217, 155, 120, 230}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 206, 110, 72, 194, 185}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 194, 80, 227, 214, 74, 169, 232, 221}, 47},
	{{125, 67, 198, 128, 0, 108, 79, 7, 96, 93, 204, 175, 199, 136, 30, 224}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 27, 129, 119, 241, 67}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 118, 209, 111, 44, 98, 98, 251}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 99, 156, 235, 243, 70, 8, 55, 245, 59}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 243, 244}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 141, 24, 241, 193, 135, 206}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 24, 216, 15, 16, 151, 155, 153, 195}, 47},
	{{125, 67, 198, 128, 0, 0, 121, 207, 72, 33, 10, 2, 156, 189, 247, 247}, 47},
	{{125, 67, 198, 128, 0, 0, 69, 84, 217, 50, 169, 88, 186, 140, 13, 206}, 47},
	{{125, 67, 198, 128, 214, 24, 110, 56, 93, 254, 217, 223, 3, 24, 22, 58}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 3, 107, 158, 73, 244, 214, 97, 208}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 185, 232, 236, 19, 253, 146, 149, 148, 215}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 70}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 177, 185}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 54, 224, 19, 143, 58, 82, 95}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 172, 113, 231, 218, 49, 51, 254, 70, 240}, 47},
	{{125, 67, 198, 128, 127, 3, 105, 9, 142, 172, 73, 124, 196, 16, 4, 36}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 153, 134, 214, 8, 162, 253, 205, 17, 54}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 243, 232, 25, 139, 31, 211, 91}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 139, 44, 239}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 237, 224, 201, 62}, 47},
	{{125, 67, 198, 128, 193, 76, 184, 147, 146, 166, 231, 127, 33, 18, 32, 211}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 182, 122, 2, 44, 196, 226, 37, 232, 118}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206, 63, 150}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 123, 130, 2, 103, 121}, 47},
	{{125, 67, 198, 128, 0, 0, 210, 18, 175, 3, 214, 18, 102, 22, 187, 103}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 127, 56, 47, 115, 46, 24, 200, 148, 189}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 144, 108, 131, 120, 194, 251}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 12, 192, 114, 130, 135, 172}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 198, 31, 46, 234, 211, 255}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 50, 125, 118, 154, 54, 42}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 42, 170, 112, 26, 123}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 122, 39}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 60, 248, 73, 174, 194, 55, 132, 104}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 203, 14, 80, 114, 175, 109, 239, 187, 31}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 132, 28, 244}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 254, 237, 13, 159, 168, 227, 235, 31}, 47},
	{{125, 67, 198, 128, 50, 197, 56, 239, 139, 144, 243, 166, 221, 153, 107, 90}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 132, 51}, 47},
	{{125, 67, 198, 128, 0, 0, 19, 240, 125, 35, 174, 76, 57, 31, 74, 31}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 173, 0, 66, 107, 8, 40, 23}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 210, 92, 109, 199, 163, 32}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 144, 214}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 47},
	{{125, 67, 198, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 177, 97}, 47},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 123}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 98}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 126}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 97, 106}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 241}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 102}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 165}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 135}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 157}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 249}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 47}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 5}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 53}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 10}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 31, 80}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 238, 230}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 213}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 157}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 67}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 205}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 250}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 116}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 36}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 157, 231}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 105}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 255}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 88, 183}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 118}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 73, 128}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 130}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 64}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 175}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 23}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 158, 212}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 190}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 109, 33}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 214}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 174}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 203}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 183}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 23, 133}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 73}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 40}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 130, 172}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 206}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 191, 138}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 148}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 96}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 11}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 42}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 14}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 227}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 18}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 247}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 0}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 48, 134}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 0, 90}, 41},
	{{26, 239, 153, 5, 213, 121, 31, 114, 161, 46, 84, 15, 148, 160, 252, 96}, 41},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 83}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 195, 167, 229, 0, 231}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 74, 212, 71}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 0}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 0}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 104, 16, 246, 32}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 192, 32, 4, 165, 46, 103, 106}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 167, 203, 226, 115, 126, 48, 97}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 22, 37, 52, 89, 222, 47}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 54, 233, 50, 108, 241, 231}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 112, 188, 199, 116}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 107, 205, 98, 184, 17}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 220, 46, 140, 183, 17, 50}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 190, 44, 105, 240, 40}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 160}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 202, 197}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 0}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 184}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 196, 73, 35, 53, 85}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 249, 252, 248}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 215}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 14, 4, 241, 138, 246, 164, 136}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 0}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 0}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 0}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 141, 244, 242, 32}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 36, 75, 10, 207, 99, 77}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 182, 228, 205, 84, 14, 132}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 150, 28, 21, 41, 142}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 107, 134, 3}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 0}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 112}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 140, 18, 0, 127, 2, 189, 86, 112}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 0}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 237, 110, 206}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 211, 113, 207}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 59, 51, 19, 1, 21}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 248, 91}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 33}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 252, 57, 103, 39}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 0}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 0}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 177, 220, 145, 147, 100, 88, 249}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 52}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 53, 76, 7, 96, 57, 23}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 0}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 58, 190, 228}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 224}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 107, 182, 78, 93}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 52}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 245, 179, 236, 109, 103, 157}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 73, 47, 133, 50}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 59, 63, 58, 159, 94, 215}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 194, 140, 14, 69}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 76}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 188, 123, 140, 179, 172}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 195}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 113, 184, 207, 15, 222}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 0}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 116, 140, 238, 179, 194, 219}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 0}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 133, 173, 234, 10, 86}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 47, 233, 224, 141, 105}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 0}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 135, 245}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 34, 220, 113, 163, 1}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 64, 11, 120}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 50, 209}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 169, 68, 76, 239, 234, 104, 183}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 243, 187, 243, 56, 155}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 200, 184, 75, 31, 251, 150, 209, 86}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 58, 158, 160, 7, 130, 197}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 154, 242, 156, 107, 159, 26}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 8, 210, 33, 182}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 216, 144, 10}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 166, 99, 53, 72}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 112, 201}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 195}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 152, 146, 100, 3, 22, 59, 206}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 163}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 254, 172, 108, 78, 197, 84}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 123, 12, 20, 132, 33, 104, 252, 224}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 242, 120, 116, 224, 184}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 74, 15}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 81, 90, 150, 192, 166, 6, 85}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 252}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 197, 157}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 172, 245}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 111}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 228, 202, 24}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 101, 80, 152, 37, 44, 123, 170}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 105}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 65}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 70, 155, 46, 118, 133, 196}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 43}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 216, 62, 179}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 170, 217, 141}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 0}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 160, 213, 211, 57, 92}, 72},
	{{102, 212, 159, 118, 223, 115, 134, 172, 0, 0, 0, 0, 0, 0, 0, 86}, 72},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 251, 74, 117, 181, 138, 180, 43, 77}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 95, 166}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 171, 70, 221, 173}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 72, 25}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 8, 153, 79, 221, 45, 149}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 124, 25, 103, 228, 100, 66, 189, 72, 213}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 220, 182, 154, 28, 237, 182, 42, 77, 85}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 114, 184, 209}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 228, 0, 189, 153, 157, 229, 180}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 241}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 125, 16}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 127, 80, 141, 82, 7}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 243, 81, 80, 199, 141}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 9, 183, 69, 158, 66, 233, 111}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 118}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 220, 94, 35, 251, 104}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 22, 195, 83, 232, 255, 120, 106, 211}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 182, 20, 113, 254, 132, 201}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 201, 246, 223, 234, 143}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 240, 88, 162, 175, 138, 160, 145, 109}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 1, 26}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 119, 196, 139, 163, 216, 215, 184, 24}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 254, 51, 206, 91, 133, 56, 252, 71}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 30, 250, 231, 206}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 85, 241, 93, 255, 55}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 52, 190, 220, 98}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 180, 147}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 74, 242}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 106, 41, 108, 84, 168, 7, 24, 170}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 175, 141}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 119, 61, 102, 102, 186, 116, 102, 4, 122}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 68, 163, 19}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 119, 195, 248, 106}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 64, 230, 11, 34, 182}, 43},
	{{85, 181, 241, 127, 3, 44, 115, 251, 62, 149, 150, 149, 81, 206, 10, 12}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 119, 38, 167, 103, 41, 209, 82, 227}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 175, 174, 128, 236, 97, 19, 113}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 63, 238, 215}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 215, 5, 143, 3}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 153, 69, 56, 96, 68, 44, 7}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 146, 69, 162, 195, 69, 50, 101, 185}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 214}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 118, 155, 180, 201, 159, 100, 14, 122}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 182, 53, 141, 44, 116, 161, 96, 55}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 201}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 155, 130}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 25, 63}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 98, 219, 149, 225, 66, 107}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 179}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 154, 133, 70, 10, 11, 146, 85, 202}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 195, 222, 136, 247, 124, 47, 23, 90}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 22, 222, 244, 73, 49, 72, 223, 31, 236}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 113, 175, 252, 21}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 134, 18, 159}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 218, 223, 225, 244, 210, 150, 26, 104, 236}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 88, 240, 186}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 13, 152, 56, 207}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 84, 241, 8, 190, 169, 37}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 151, 47, 121, 48, 53, 3, 68, 229, 51}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 56, 154, 141, 52, 210}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 48, 146, 108}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 208, 47, 162, 64, 40, 176, 141, 78}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 160, 137, 96, 169, 89, 188, 183}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 193, 105, 80}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 183, 85, 0, 110}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 245, 52, 196, 98, 196, 255}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 173}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 32, 44, 14, 189, 250, 211}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 199, 187, 100, 173, 201, 48}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 71, 224, 240, 150, 53, 238, 36}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 62, 149, 79}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 100, 176, 36, 67, 165, 127, 220}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 117, 163, 89, 227, 180, 133, 86, 132, 15}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 140, 235, 246, 49, 20, 163}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 175}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 173, 11, 172, 98, 46}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 92, 73}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 147, 8, 35}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 234, 220, 42, 44}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 201, 112, 209, 1, 78, 149, 33, 84}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 71, 194, 204}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 214, 34, 111, 50, 20, 74, 33, 166}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 0, 0, 0, 0, 0, 0, 0, 0, 143}, 43},
	{{85, 181, 241, 127, 3, 44, 0, 250, 232, 174, 149, 130, 250, 135, 253, 182}, 43},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 22, 171, 129, 71, 184, 231, 14}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 81, 133, 6, 84, 146, 99, 6}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 162, 77, 88, 119}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 58, 61, 160, 206, 150}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 126, 192, 250}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 0}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 194, 84}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 211, 146, 29, 191, 138}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 213, 125, 204}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 198}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 0}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 91}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 183, 44, 51, 16, 110, 120}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 154, 230, 17, 184}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 0}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 24, 185}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 240, 139, 214, 60}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 206, 139, 243}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 0}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 226, 254}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 93, 96, 250, 240}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 0}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 42, 129}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 4, 180, 80, 2}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 153, 178, 222}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 126, 167, 185}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 43}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 100, 161, 60}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 134, 212, 224, 248, 130}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 242, 78, 181, 65, 111}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 134, 134, 0, 50}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 213, 179, 88, 226, 160}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 220, 94, 169}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 1, 205, 201, 78, 163}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 206, 27, 3, 115, 174, 248}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 0}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 0}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 156, 80, 100}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 85, 8, 44, 60, 49, 124}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 86, 236, 172, 54, 206}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 88, 64, 171, 132, 59, 214, 3}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 34, 199, 146, 126, 178, 137}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 240, 86}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 0}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 65, 22}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 244}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 161}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 118, 221, 2, 177}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 217}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 181, 6, 94, 18}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 129}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 170}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 1, 157, 35, 205, 154, 128}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 9, 74, 209, 21, 102, 26}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 248, 63, 2, 205, 176}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 180, 183, 123}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 35, 232, 250, 3, 191}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 0}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 68, 130, 251, 75, 149, 126, 222}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 18, 143, 52, 2}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 175, 167, 63, 80, 7}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 206, 235}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 0}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 177, 20, 126, 64, 152}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 0}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 170, 233, 190}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 0}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 33, 177, 248, 20, 226, 42, 64}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 181, 147}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 97, 14, 164, 52, 50, 86}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 89, 105, 39, 125}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 176, 247, 74, 7, 184, 2, 174}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 0}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 21, 114, 251, 68, 67}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 185, 201, 113, 236, 192, 7}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 87, 176, 112, 51}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 27, 92, 34, 132, 22, 71}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 64, 41, 70, 78}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 98, 4, 102, 136, 208}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 178}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 0}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 220, 162, 162, 250, 78, 107}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 245, 80, 48, 72, 232}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 100, 121, 222, 107, 191, 245}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 36, 117, 56, 35, 205}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 152, 218, 211, 162, 208, 81}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 182, 207}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 14, 84, 235, 54, 179, 117, 44}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 236, 190, 198, 182, 103, 246, 196}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 236, 82, 97}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 109, 35, 145, 125}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 155, 51, 243, 91}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 0}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 251, 190, 117, 138}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 0, 0, 0}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 103, 214, 146, 8, 142, 184, 104}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 202, 123, 53, 85}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 146, 2, 147, 62, 72, 17}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 15, 235, 39, 104, 235, 63}, 26},
	{{61, 199, 131, 226, 3, 230, 94, 119, 240, 0, 0, 0, 0, 25, 140, 18}, 26},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 196, 118, 233, 149}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 113, 136, 60, 156, 221}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 83, 229, 95, 229, 224, 137, 60}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 204, 27}, 139},
	{{0, 143, 160, 184, 162, 192, 167, 216, 55, 204, 199, 49, 207, 154, 113, 176}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 202, 148, 117, 218, 189, 147, 230, 111, 81}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 110, 19, 42, 88, 62, 181}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 117, 78, 191, 241, 11}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 72, 216, 225, 38, 13, 201, 214, 98, 89}, 139},
	{{0, 143, 160, 184, 162, 192, 5, 236, 22, 190, 99, 222, 168, 78, 215, 209}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 168, 79, 218, 86}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 245, 151, 56, 40, 219, 88, 228, 46, 24}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 147, 97}, 139},
	{{0, 143, 160, 184, 162, 192, 189, 117, 254, 89, 111, 110, 155, 213, 245, 139}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 105}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 242}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 200, 13, 115, 249, 128, 153, 69, 253, 92}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 95, 116, 65, 195, 160, 76, 61, 174}, 139},
	{{0, 143, 160, 184, 162, 192, 97, 227, 187, 148, 219, 178, 107, 66, 13, 212}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 112, 128}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 59, 43, 176, 121, 136, 116, 206, 169, 254}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 45, 209, 74, 21, 76, 186, 0, 191, 43}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 28, 223, 225, 200}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 172, 202, 23, 197, 37, 148}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 30, 145, 148, 208, 120, 151, 150, 254, 249}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 241}, 139},
	{{0, 143, 160, 184, 162, 192, 102, 44, 118, 226, 215, 231, 29, 232, 33, 176}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 148}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 172, 89, 7, 104, 169}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 158, 177, 35}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 210, 194, 175}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 221, 148, 78, 174, 156, 53}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 140, 216, 245, 114, 169, 125, 221, 93, 217}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 31, 255, 169, 123, 172, 62, 151, 57}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 38, 81, 9, 172, 90, 194, 119, 246, 188}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 246, 79, 157, 102, 187, 177, 139, 111}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 145, 123}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 38, 228, 110, 241, 98, 72}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 228}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 126, 12, 30, 28, 30, 5, 51, 16, 4}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 139, 4, 4, 124}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 204, 164, 65}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 122, 150, 131, 207}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 160, 230, 201, 110, 68, 141, 194, 28, 112}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 34, 116, 44, 59, 134, 146}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 199, 23, 48}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 100, 97, 69, 129, 10, 151, 255}, 139},
	{{0, 143, 160, 184, 162, 192, 59, 30, 142, 69, 244, 73, 185, 215, 192, 29}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 191, 207, 22, 153, 235}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 242, 91, 19}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 73, 225, 102, 242, 231}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 254, 21, 36, 243, 207, 85, 133}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 79}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 123, 230, 186, 148}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 229, 229, 191, 141, 14, 116, 52}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 158, 149, 65, 183, 240, 62, 137, 6, 70}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 82, 112, 24, 0, 209, 143, 28, 251, 226}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 38, 161, 96, 32, 66}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 224, 171}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 16, 162, 99, 151, 27, 38, 229, 150, 191}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 21, 5, 224, 101, 95, 204, 91, 53}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 215, 147, 145, 63, 75, 220, 98, 90}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 243}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 128, 0, 45, 209}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 88, 51, 160}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 225, 76, 166, 234, 52, 150, 15}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 183, 187, 153, 154, 11, 29, 158}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 168, 28}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 139},
	{{0, 143, 160, 184, 162, 192, 10, 114, 14, 211, 214, 27, 195, 250, 156, 134}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73}, 139},
	{{0, 143, 160, 184, 162, 192, 55, 124, 67, 78, 119, 67, 108, 4, 233, 4}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 161, 11, 3, 103}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 199, 35, 227}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 94}, 139},
	{{0, 143, 160, 184, 162, 192, 208, 92, 246, 169, 99, 254, 203, 53, 184, 252}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 55, 201, 19}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 145, 63, 151, 79, 12}, 139},
	{{0, 143, 160, 184, 162, 192, 23, 209, 206, 187, 170, 48, 187, 229, 169, 254}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 192, 133, 135, 36, 232, 156, 247, 224, 123}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 39, 165, 80, 82, 42}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 16, 74, 168, 58, 245, 247, 75}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 34}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 29, 124, 27, 249, 36}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 253, 55, 226, 211, 166, 124}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 13, 35, 68, 151, 54, 6, 60, 190}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 241, 71, 30, 21, 59, 122, 64, 204, 250}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 91, 71}, 139},
	{{0, 143, 160, 184, 162, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192}, 139},
	{{170, 24, 0, 0, 0, 0, 78, 106, 202, 236, 223, 135, 43, 67, 157, 56}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 170, 219, 114, 61}, 219},
	{{170, 24, 0, 0, 69, 117, 217, 95, 180, 100, 219, 166, 22, 23, 228, 204}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 243, 67, 130, 232, 66, 69, 122, 167}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 60, 40, 106, 136, 158, 68, 167}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 205, 165, 88, 239, 56, 241, 130, 122}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 153, 66, 202}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 201}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 190, 77, 119, 165}, 219},
	{{170, 24, 0, 0, 84, 29, 49, 206, 146, 171, 238, 74, 203, 250, 57, 213}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 100, 152, 51, 239}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 101, 137, 174}, 219},
	{{170, 24, 0, 0, 0, 0, 81, 6, 117, 184, 6, 199, 148, 52, 218, 85}, 219},
	{{170, 24, 0, 47, 210, 240, 198, 120, 253, 242, 163, 162, 237, 26, 231, 77}, 219},
	{{170, 24, 0, 0, 196, 162, 113, 51, 150, 156, 253, 29, 253, 175, 123, 190}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 89, 201, 252, 159, 35}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192, 46, 245, 75, 88}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 161, 124, 151, 199, 241, 246, 79, 120}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 117, 104, 159}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 124}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 219},
	{{170, 24, 0, 0, 108, 255, 142, 224, 114, 28, 201, 90, 138, 11, 128, 137}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 146}, 219},
	{{170, 24, 19, 76, 22, 171, 224, 78, 29, 172, 161, 88, 23, 96, 219, 29}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 69, 163, 166}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 240}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 136, 239, 37, 153, 254, 210}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 85}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 102, 118, 127, 186, 166, 102, 45, 96}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 219},
	{{170, 24, 145, 92, 27, 108, 235, 34, 236, 141, 82, 172, 13, 153, 219, 95}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90, 32, 245, 80, 108}, 219},
	{{170, 24, 48, 247, 31, 124, 139, 34, 199, 194, 50, 51, 116, 182, 23, 53}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 146, 102, 21, 225, 163, 129, 160}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 42, 81, 67, 200, 4, 75, 10}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 94, 163, 84, 68, 77, 30, 238, 45, 181}, 219},
	{{170, 24, 0, 19, 113, 41, 129, 107, 62, 181, 236, 88, 125, 250, 153, 88}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90, 174, 137, 233}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 63, 10, 103, 35, 151, 211, 28, 235}, 219},
	{{170, 24, 0, 153, 138, 9, 11, 176, 30, 99, 235, 68, 201, 84, 69, 196}, 219},
	{{170, 24, 0, 193, 184, 221, 88, 55, 251, 39, 32, 67, 23, 55, 125, 249}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 143, 151}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 157, 121}, 219},
	{{170, 24, 0, 130, 192, 212, 69, 204, 59, 137, 122, 6, 7, 130, 157, 186}, 219},
	{{170, 24, 0, 0, 0, 0, 135, 31, 90, 40, 51, 218, 163, 120, 152, 111}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 241, 102, 172, 12, 130}, 219},
	{{170, 24, 0, 0, 0, 0, 43, 93, 195, 22, 30, 58, 2, 207, 65, 27}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 3, 22, 134, 171, 135, 12, 194, 184, 53}, 219},
	{{170, 24, 0, 0, 0, 131, 181, 47, 67, 206, 89, 55, 135, 57, 139, 98}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 40, 188, 235, 186, 145, 178, 137}, 219},
	{{170, 24, 0, 0, 2, 127, 24, 121, 21, 38, 56, 163, 215, 97, 118, 245}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 31, 189, 85, 198, 136, 241, 26, 168, 209}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 9, 212, 248, 165, 207, 47, 174, 24, 20}, 219},
	{{170, 24, 0, 44, 176, 112, 132, 24, 140, 48, 185, 4, 179, 148, 196, 3}, 219},
	{{170, 24, 0, 0, 189, 154, 143, 174, 204, 99, 226, 76, 239, 129, 37, 158}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 148}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 170, 14, 211, 141, 115, 133, 125, 115, 112}, 219},
	{{170, 24, 0, 229, 19, 168, 8, 98, 36, 64, 25, 233, 22, 17, 54, 208}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 88, 128, 176, 159, 26, 194, 29, 21}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 220, 48, 28, 73, 72, 16, 2}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 12, 230, 99, 140, 30, 128}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 219},
	{{170, 24, 0, 0, 0, 0, 144, 227, 153, 15, 3, 198, 4, 51, 71, 198}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 213, 147, 4, 211, 69, 123}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 98, 213, 176, 6, 51, 170, 218}, 219},
	{{170, 24, 0, 5, 199, 15, 10, 191, 30, 207, 188, 221, 117, 110, 35, 244}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 116, 142, 251, 137, 174, 45}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 113, 217, 168}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 219},
	{{170, 24, 0, 0, 93, 133, 66, 80, 14, 65, 184, 79, 245, 44, 82, 248}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 136, 88, 14, 31, 230, 33, 154, 147, 86}, 219},
	{{170, 24, 0, 0, 0, 0, 103, 25, 143, 148, 195, 147, 114, 62, 153, 71}, 219},
	{{170, 24, 0, 0, 0, 0, 149, 31, 168, 18, 190, 123, 1, 242, 181, 148}, 219},
	{{170, 24, 0, 0, 0, 49, 223, 103, 219, 203, 97, 174, 133, 180, 171, 170}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 162, 56, 8, 185, 233, 144, 212, 159, 106}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 193, 141, 57, 218, 9, 214, 95}, 219},
	{{170, 24, 0, 0, 0, 0, 145, 104, 68, 251, 90, 94, 241, 23, 80, 81}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 38}, 219},
	{{170, 24, 0, 0, 73, 3, 159, 223, 120, 72, 38, 94, 241, 226, 223, 139}, 219},
	{{170, 24, 0, 175, 53, 185, 223, 1, 162, 219, 66, 92, 233, 72, 99, 75}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31}, 219},
	{{170, 24, 0, 0, 0, 198, 125, 178, 130, 71, 1, 39, 132, 217, 53, 95}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 208, 77, 222, 247, 37, 172}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 254, 137}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57, 141, 240, 155}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 197, 108, 212, 123, 150, 191, 107, 1, 196}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 39, 75}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 238}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 46, 4, 121, 154, 224, 156, 229, 80}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 74, 132, 108, 31}, 219},
	{{170, 24, 0, 0, 75, 40, 27, 44, 63, 185, 236, 39, 31, 141, 65, 201}, 219},
	{{170, 24, 0, 0, 0, 0, 0, 0, 0, 16, 246, 90, 37, 49, 38, 102}, 219},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 0, 235}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 188, 47, 221, 234}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 0, 0}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 43, 250, 176, 154, 76, 57, 165, 175}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 133, 92}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 165, 203, 129, 41, 46, 170, 135}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 216, 35, 34, 49, 4, 26, 204}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 170, 214}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 123, 216}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 132, 54, 142}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 254, 135, 12}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 0, 47}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 192, 61, 170, 247, 51, 133, 42, 176}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 215, 47, 35, 249, 53}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 236, 229, 233, 229, 145}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 201, 161, 165, 252}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 0, 59}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 142, 22, 173, 220, 155}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 0, 0}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 177, 162, 49, 84, 206, 113, 170, 106}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 225, 135, 143, 230, 29, 74, 109, 49}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 0, 13}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 13, 74, 151}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 107, 12, 84, 233, 188}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 3, 31, 249}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 109, 249}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 73, 177, 98, 237, 11, 206}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 37, 169, 206, 123}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 0, 236}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 16, 246, 246, 55}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 248, 208}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 80, 246, 245, 138, 164}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 189, 218, 16, 220, 254}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 20, 47, 101, 119, 19, 255, 136}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 40, 31}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 0, 130}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 188, 237, 31, 51, 131}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 0, 0}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 79, 244, 0, 179, 234}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 218, 169, 156, 146, 87, 132, 6}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 202, 148}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 143, 35, 130}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 2, 96, 152, 52, 78, 179, 227}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 0, 214}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 194, 25}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 246, 125, 95}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 126, 228, 66, 168, 1, 121, 192}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 181, 144, 24, 11, 192, 163}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 228, 75, 36, 9, 105, 34, 152, 103}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 0, 186}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 59, 149, 98}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 240, 155, 52, 183}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 184, 185, 223, 203}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 242, 12}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 33, 151, 48}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 71, 79}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 173, 167, 40, 98, 74, 83, 3, 146}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 22, 105, 199, 89, 169}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 112, 156, 80, 181}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 0, 15}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 0, 195}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 241, 164, 122, 129, 55, 225, 81, 64}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 255, 38, 108, 82, 225, 96, 247}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 5, 127, 147, 137, 159}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 1, 173, 56, 98, 254, 89, 63}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 0, 33}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 0, 0}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 194, 22}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 236, 25, 20, 136, 54}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 138, 28, 90}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 8, 122, 101}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 0, 116}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 53, 52, 86, 240, 58, 76, 178}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 18, 175, 23, 181, 5, 124}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 182, 65}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 77, 8, 92, 57}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 111, 169, 195}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 160, 8}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 23, 91}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 133, 193, 60}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 184, 128, 16, 62, 28, 107, 152}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 104, 13, 60, 192, 180, 194}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 195, 153, 8}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 0, 0}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 169, 73, 151}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 247, 2, 157, 73}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 206, 209, 184, 169, 246, 56, 146, 139}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 181, 126, 25, 17, 90, 96}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 36, 112, 153, 237, 232, 21, 193}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 0, 0, 169}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 31, 170, 148, 152}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 225, 64, 250, 150}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 135, 182, 15, 11, 66}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 197, 243, 230, 217, 130, 237, 168}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 26, 9, 116, 16}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 81, 104, 25, 131, 63}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 38, 221, 231, 223, 41, 218, 108}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 116, 193, 78, 154, 78}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 0, 195, 222, 73}, 105},
	{{61, 122, 24, 251, 124, 122, 202, 192, 0, 0, 0, 0, 124, 105, 204, 69}, 105},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 174, 136}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 83, 194, 136, 28, 163}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 80, 230}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 93, 64, 22, 71, 188, 207, 50, 22, 175}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 51, 173, 2, 124}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 89, 183, 132, 216, 181}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 28, 14, 141, 70, 135, 186, 48}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 29, 180, 24, 182, 48, 194, 73}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 43, 5, 59, 139, 207, 9, 203, 230, 213}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 222, 243, 144}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 170, 100, 10, 244}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 76}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 181, 2, 42}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 42}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 134, 179, 69}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 235, 126, 165, 122, 246, 0, 237, 127}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 5, 179, 18}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 58, 200, 228}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 120, 232, 205, 227, 65}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 128, 25, 223, 18, 134, 76, 174, 208}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 149, 87, 173, 40, 1, 76, 33}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 79, 200, 90}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 251, 216, 112, 246, 48, 175, 146, 33, 86}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 30, 7, 253, 0, 33, 118, 165, 241, 187}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 245, 139, 129, 172, 174, 231}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 176, 98, 249, 32, 208, 55, 81, 207}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 177, 242, 182}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 24, 165, 143, 171, 226, 153, 190, 191, 113}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 101, 56, 202, 7, 130, 226}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 184, 15, 9}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 4, 1, 227}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 170, 52, 76, 56, 196, 156}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 83, 228, 214}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 9, 82, 116, 15, 188, 58, 241}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 79, 175, 146}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 132, 110, 81, 110, 58, 118, 220, 22, 227}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 59, 251, 198, 216, 179, 204, 216, 225}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 166, 56, 120, 234, 165, 158, 214}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 68, 100, 58, 208, 191, 140, 151, 157}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 5, 22, 163, 102}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 222, 187, 250, 38, 199, 89, 148, 77}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 73, 242, 23, 61, 130, 217, 32, 251, 130}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 133, 130, 63, 234, 66, 112, 170}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 159, 221, 9, 157, 177, 4, 4, 80}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 177, 205, 194, 159, 239, 200, 0}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 232, 101, 247, 198, 38, 251, 24, 157}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 87}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 39, 67}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 235, 163, 144, 185, 21, 226}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 208}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 83, 98, 99, 53, 81, 31, 51}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 234, 182}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 250, 224, 124, 157, 138, 92, 45, 157}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 215, 58, 22, 196, 210, 37}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 150, 85, 165, 34, 5, 74, 74, 33, 62}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 205}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 240, 0}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 207, 51, 138, 19, 113, 162, 102, 78, 76}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 91, 6}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 209, 167, 229, 230, 141, 113, 64}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 39, 217, 110, 69, 192, 43, 149, 143, 29}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 233, 237, 132, 2}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 253, 179, 43, 98}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 186, 62, 35, 88, 108}, 210},
	{{33, 219, 226, 3, 180, 190, 177, 164, 29, 29, 53, 130, 112, 178, 84, 53}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 172, 46, 46, 253, 40, 2}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 114, 225, 227, 123, 102, 56, 4, 197}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 1, 227, 144, 25, 172, 87, 176, 165}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 225, 105, 73, 207, 209, 34, 204, 217, 24}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 16, 232, 169, 40, 176}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 98, 40, 228}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 114, 137, 41, 34, 169, 126, 74}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 189, 157, 62, 58, 144, 77, 91, 84}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 75, 229, 239, 120, 88, 124, 60, 223, 199}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 150, 84}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 185, 88, 220}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 26}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 127, 196, 94, 180, 2, 216, 175, 69}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 251, 156, 19, 148, 34, 102, 207, 242, 222}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 125}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 101, 158, 40, 40, 225, 36}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 79, 50, 148, 104, 34, 24, 82, 242}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 192, 84, 72, 238, 129, 70, 44, 84}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 100, 158, 11}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 211, 246, 97, 26, 77, 79, 51, 137, 217}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 0, 174, 221}, 210},
	{{33, 219, 226, 3, 180, 190, 0, 0, 0, 0, 0, 0, 0, 59, 236, 44}, 210},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 181, 58, 236, 212, 247, 202, 250}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 175, 230, 238, 108, 224, 88, 129}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 111, 182, 39, 193, 203, 25, 101, 108, 87}, 151},
	{{51, 251, 0, 0, 73, 209, 174, 209, 90, 72, 152, 163, 62, 130, 229, 158}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 33, 88, 221, 67, 21, 212, 18, 78}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 84, 36, 4, 245, 140, 9}, 151},
	{{51, 251, 0, 0, 0, 149, 16, 143, 255, 179, 139, 143, 97, 125, 125, 197}, 151},
	{{51, 251, 0, 0, 0, 0, 168, 203, 245, 93, 189, 81, 238, 251, 43, 229}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 151, 219, 21, 189, 137, 253}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 4, 175, 242, 251, 169, 157, 113, 135}, 151},
	{{51, 251, 0, 0, 43, 35, 206, 229, 184, 186, 78, 234, 170, 207, 159, 123}, 151},
	{{51, 251, 0, 36, 73, 138, 191, 40, 134, 231, 103, 193, 245, 36, 254, 127}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 89, 223}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 149}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 62, 46, 108}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 14, 163, 106, 111, 196, 79, 205}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 114, 54, 45}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 197, 160, 101, 246, 127, 184, 172, 49, 173}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 94, 50, 9, 1, 18, 231, 167, 244}, 151},
	{{51, 251, 0, 0, 0, 0, 129, 192, 223, 250, 216, 2, 75, 240, 184, 131}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 43, 131, 101}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 119, 156, 161, 101, 5, 186}, 151},
	{{51, 251, 0, 0, 100, 49, 2, 79, 150, 65, 230, 153, 44, 248, 173, 187}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{51, 251, 0, 0, 0, 106, 179, 155, 225, 74, 8, 11, 39, 117, 239, 198}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 191, 232, 134, 187, 172, 19, 36, 191}, 151},
	{{51, 251, 0, 0, 0, 0, 35, 55, 245, 182, 71, 105, 31, 108, 80, 204}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 69, 172, 145}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 162}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 231}, 151},
	{{51, 251, 0, 0, 0, 240, 144, 48, 54, 184, 119, 49, 97, 58, 182, 240}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90, 103, 151}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{51, 251, 0, 0, 45, 22, 108, 209, 96, 224, 134, 45, 183, 199, 209, 220}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 69, 228, 161, 249, 13, 104, 138}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 146, 230, 41, 216}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 141, 33, 105, 142, 75, 69}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 245, 23, 104, 118, 36, 103}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 144, 253, 173, 39, 116}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 126, 79, 178, 51, 23, 7, 237}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 51, 186, 132}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 27, 111, 130, 81, 7, 30, 171}, 151},
	{{51, 251, 0, 0, 60, 48, 24, 6, 247, 213, 169, 28, 6, 47, 117, 174}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 210, 217, 67, 58, 152, 216, 40}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 69, 150, 117}, 151},
	{{51, 251, 0, 225, 6, 187, 67, 221, 194, 192, 73, 81, 246, 54, 90, 214}, 151},
	{{51, 251, 0, 208, 229, 34, 5, 151, 211, 48, 0, 227, 71, 89, 232, 99}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 70, 151}, 151},
	{{51, 251, 0, 24, 123, 71, 125, 202, 182, 91, 212, 216, 186, 241, 129, 36}, 151},
	{{51, 251, 0, 0, 0, 57, 79, 227, 68, 175, 35, 151, 160, 70, 9, 78}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 140, 223}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 57, 241, 125, 142, 213, 49, 27}, 151},
	{{51, 251, 0, 0, 0, 220, 210, 75, 90, 16, 13, 67, 183, 210, 80, 75}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 4, 137, 99, 31, 215, 151, 253, 14}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 74, 117, 74, 202, 152, 141, 74, 252}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 143, 251, 94, 6}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 164, 176, 120, 137, 184, 97, 114, 28, 195}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 172, 79, 37, 3, 234, 161}, 151},
	{{51, 251, 0, 69, 76, 55, 17, 162, 38, 69, 145, 119, 71, 246, 180, 10}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 208}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 106, 26, 188, 107, 102, 223, 165}, 151},
	{{51, 251, 0, 0, 0, 51, 191, 162, 158, 10, 131, 195, 24, 250, 80, 78}, 151},
	{{51, 251, 0, 199, 155, 4, 227, 188, 24, 56, 197, 192, 83, 16, 233, 7}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 238, 89}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 151},
	{{51, 251, 0, 56, 131, 94, 98, 244, 214, 191, 71, 165, 88, 105, 76, 154}, 151},
	{{51, 251, 0, 238, 58, 126, 144, 241, 249, 224, 75, 51, 77, 23, 191, 224}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 196, 211}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 21, 78, 149, 31, 108, 34, 172, 246, 88}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 91, 217, 60, 13, 54, 253, 120, 155}, 151},
	{{51, 251, 0, 0, 0, 166, 214, 12, 217, 51, 92, 223, 212, 118, 197, 52}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 175, 137, 231, 246, 67, 201, 70, 240, 219}, 151},
	{{51, 251, 0, 228, 249, 46, 154, 132, 15, 112, 52, 124, 70, 160, 73, 56}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 234, 42, 181}, 151},
	{{51, 251, 0, 0, 186, 43, 31, 97, 65, 135, 140, 55, 244, 3, 36, 175}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 203, 226}, 151},
	{{51, 251, 0, 0, 0, 230, 71, 185, 153, 245, 26, 217, 212, 131, 21, 54}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 114, 1, 180, 220}, 151},
	{{51, 251, 0, 0, 0, 163, 238, 15, 42, 141, 22, 204, 37, 215, 107, 167}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 121, 151, 250, 224, 147, 33, 246, 64}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206, 163, 154, 146, 136}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 19, 15, 111, 187, 230, 26}, 151},
	{{51, 251, 0, 0, 0, 0, 110, 118, 80, 88, 213, 67, 203, 141, 160, 66}, 151},
	{{51, 251, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 245, 128, 162}, 151},
	{{51, 251, 0, 0, 0, 0, 57, 84, 156, 22, 168, 95, 175, 76, 5, 94}, 151},
	{{51, 251, 0, 0, 0, 0, 18, 81, 16, 153, 149, 248, 98, 165, 216, 238}, 151},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 81, 195}, 28},
	{{106, 185, 11, 122, 197, 192, 167, 28, 156, 216, 3, 51, 236, 86, 51, 197}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 155, 27, 38, 97}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 109, 172, 124, 12, 237, 26, 119, 176}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 105}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 219, 173, 47, 94, 59, 83, 203, 183}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 24, 166}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 154, 89, 172, 92, 203, 22, 58, 205, 104}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 194}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 207, 69, 4, 80, 63, 189, 4, 247, 190}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 75, 165, 29, 161, 207, 66, 105, 250}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 106, 59}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 122, 91, 188, 233}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 31, 124, 246, 132, 123}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 70}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 183, 162, 156, 167, 86, 186}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 225, 237, 107, 228, 25, 124, 44}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 249, 220, 241, 17, 49, 92}, 28},
	{{106, 185, 11, 122, 197, 192, 175, 81, 172, 162, 212, 6, 48, 84, 51, 6}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 17, 46, 61}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 215, 132, 220, 255, 160}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 107, 1, 226, 181, 188, 85, 46, 191}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 69, 47, 59, 116, 212, 186, 27}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 89, 208, 74, 232, 16, 173}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 148, 203, 64, 61, 184, 35}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 65, 155, 204, 65, 147, 119}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 125, 27, 59, 208, 44}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 195, 159, 117}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 53, 56, 235}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 252, 167, 0, 28, 154, 72, 251, 131}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 22, 158, 196, 34}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 65, 105, 183, 224, 190}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 67, 187, 55}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 202, 186, 233, 0, 196}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 103, 165, 149}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 129}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 230, 68, 212, 187, 230, 251, 43, 12, 166}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 40, 34, 10, 246, 192, 188, 121, 50}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 17, 42, 9, 162, 15, 44}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 106, 82}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 41, 170, 253, 66, 22, 114, 209, 200, 85}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 22, 101}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 239, 245, 202, 183}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 108, 198, 50, 194, 97}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 28, 181, 162, 193, 15, 190}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 215, 133, 8, 239, 144}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 124, 85}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 143, 172, 246, 201, 22}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 162, 27, 2, 233, 224, 21}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 8, 37, 250, 117, 189}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 251, 246, 210, 163, 27}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 35, 22, 136, 236, 15}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 174, 184, 95, 50, 32, 123}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 156, 39, 167}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 223, 172, 127}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 165, 81, 31}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 101, 118, 149, 209, 51, 217, 155}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 34, 0, 206, 233, 243, 182}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 18, 66, 67, 35, 233}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 95, 204, 251}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 135, 245, 198, 103, 75}, 28},
	{{106, 185, 11, 122, 197, 192, 234, 90, 127, 52, 72, 19, 146, 59, 154, 123}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 207, 141}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 17, 168, 251, 71, 41, 77}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 78, 223, 199, 119, 242, 30}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 245}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 12, 100, 12, 121, 201, 185, 148, 244}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 52, 162, 216, 64, 9, 139, 161, 94, 106}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 244, 146, 185, 139, 106, 36, 234, 32}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 113, 9, 55, 225, 123, 25, 201, 44}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 46, 74, 186, 11, 52, 204, 8, 245, 67}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 134, 151, 46, 42, 92, 24, 240}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 152, 55, 89, 131, 136, 213, 40, 194, 245}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 247, 53, 80, 160, 214, 171, 119, 57, 172}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 100, 224}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 69, 217, 146, 97, 50}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 18, 158, 240, 184, 234, 123, 129, 44, 20}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 116, 254, 86}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 133, 84, 222, 222, 222, 194, 74, 214, 219}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 162, 207, 148, 210, 41, 107, 146}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 143, 237, 224, 240, 167, 193, 11}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 0, 165, 70, 227, 2}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 242, 44, 156, 199, 152, 17, 52, 191, 161}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 62, 220, 160, 177, 174, 23, 194, 2}, 28},
	{{106, 185, 11, 122, 197, 192, 0, 0, 0, 0, 0, 191, 93, 6, 33, 102}, 28},
	{{192, 0, 0, 0, 0, 0, 0, 0, 173, 95, 55, 208, 191, 193, 22, 64}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 72, 224, 223, 129, 154, 6, 91, 129}, 64},
	{{192, 0, 0, 0, 0, 226, 234, 7, 22, 243, 59, 163, 108, 48, 138, 102}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 100, 92, 165, 126, 254, 185, 255, 125}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 64},
	{{192, 0, 27, 237, 220, 209, 158, 175, 34, 185, 21, 92, 65, 79, 109, 234}, 64},
	{{192, 0, 0, 212, 125, 6, 72, 153, 110, 196, 23, 188, 144, 240, 97, 239}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 213}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 232, 146, 185, 133, 186, 102, 30}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 133, 212, 118, 99, 59, 255}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 75, 152, 236}, 64},
	{{192, 0, 0, 0, 0, 234, 209, 47, 173, 213, 186, 93, 245, 231, 176, 39}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 214}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60, 45, 98}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 227, 10, 138, 194, 211}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 61, 198, 8}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 28, 226}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 38, 161, 52}, 64},
	{{192, 0, 0, 0, 0, 0, 119, 48, 91, 158, 122, 8, 84, 191, 129, 157}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 137}, 64},
	{{192, 0, 0, 0, 0, 0, 5, 68, 72, 129, 26, 229, 96, 88, 90, 146}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 194}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 115}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 78, 173, 0, 133, 74, 130}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 98, 19, 32, 130, 147, 161}, 64},
	{{192, 0, 0, 0, 0, 0, 172, 35, 185, 117, 197, 99, 83, 49, 52, 73}, 64},
	{{192, 0, 0, 0, 0, 122, 219, 208, 46, 90, 205, 189, 187, 108, 203, 97}, 64},
	{{192, 0, 0, 0, 0, 28, 115, 163, 108, 218, 249, 100, 235, 47, 237, 128}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 150, 227, 94, 65, 107, 128, 28, 163}, 64},
	{{192, 0, 0, 0, 90, 92, 41, 185, 35, 167, 202, 115, 186, 87, 25, 68}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 238, 250, 60, 109}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 232, 153, 165}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 225, 135, 103, 97, 219}, 64},
	{{192, 0, 0, 0, 0, 77, 122, 106, 230, 232, 148, 232, 3, 151, 211, 212}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 195, 91, 25, 176}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 254, 23, 142, 199, 35, 155}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90, 205, 84, 118, 191}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6}, 64},
	{{192, 0, 0, 0, 0, 0, 62, 212, 121, 129, 130, 221, 232, 200, 126, 59}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 160, 143}, 64},
	{{192, 0, 0, 130, 152, 242, 239, 69, 235, 144, 130, 91, 190, 175, 223, 131}, 64},
	{{192, 0, 0, 0, 117, 46, 201, 92, 74, 125, 199, 234, 124, 151, 21, 250}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 82, 53, 254, 101, 69, 36, 103}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 189, 123, 234, 12, 164, 27, 245, 156}, 64},
	{{192, 0, 0, 0, 0, 0, 39, 233, 69, 201, 245, 83, 197, 246, 115, 0}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 44, 108, 192, 77, 56, 253, 141, 233, 166}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 3, 5}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 69, 42, 78, 237, 47, 104, 51, 6, 2}, 64},
	{{192, 0, 0, 0, 0, 151, 205, 17, 10, 126, 1, 223, 132, 190, 167, 50}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 146, 197, 110, 242}, 64},
	{{192, 0, 185, 124, 143, 83, 86, 6, 226, 92, 168, 219, 58, 106, 81, 249}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 130, 243, 229, 230, 143, 117}, 64},
	{{192, 0, 0, 0, 229, 15, 184, 10, 28, 78, 26, 43, 159, 241, 155, 222}, 64},
	{{192, 0, 0, 0, 0, 0, 228, 40, 55, 187, 242, 225, 84, 58, 128, 5}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 87}, 64},
	{{192, 0, 0, 29, 108, 103, 4, 8, 195, 158, 193, 128, 237, 226, 221, 247}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 193, 24, 53}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75, 108, 142, 76, 24}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 190}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 64},
	{{192, 0, 0, 245, 165, 150, 40, 176, 182, 152, 65, 117, 27, 222, 158, 190}, 64},
	{{192, 0, 0, 253, 227, 254, 8, 189, 147, 39, 23, 251, 81, 154, 79, 187}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 179, 249, 176, 202}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 209, 217, 76, 213, 47, 34, 201, 19, 128}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 64},
	{{192, 0, 0, 0, 0, 0, 201, 114, 236, 177, 84, 135, 175, 144, 45, 193}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 250, 144, 212, 234}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 129}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 251, 114}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131, 207}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 133, 156, 86, 131, 176, 47, 65}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 134, 177, 115, 231}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 117, 67, 246, 199, 143, 143}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 7, 22}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 209, 53, 8, 9, 235}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 82, 130}, 64},
	{{192, 0, 0, 0, 0, 0, 105, 53, 49, 110, 210, 173, 193, 41, 39, 91}, 64},
	{{192, 0, 0, 0, 0, 46, 60, 103, 192, 192, 100, 38, 176, 25, 253, 190}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 103, 204, 124, 32}, 64},
	{{192, 0, 68, 152, 151, 122, 27, 22, 96, 10, 177, 180, 58, 104, 131, 145}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 195, 126, 92, 58, 181, 69}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 175, 18, 205, 178, 158, 25}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 171, 134, 94, 64, 127, 226, 130, 48, 99}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 183, 141, 229}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 147, 129, 238}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 158, 242, 158}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224, 38, 132, 33, 88, 13}, 64},
	{{192, 0, 135, 221, 237, 114, 233, 43, 185, 25, 116, 194, 51, 109, 100, 203}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 59, 131, 176}, 64},
	{{192, 0, 0, 0, 0, 238, 24, 80, 213, 146, 156, 210, 200, 21, 234, 66}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 210}, 64},
	{{192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192}, 64},
	{{192, 0, 0, 0, 0, 214, 158, 245, 178, 238, 254, 138, 136, 19, 222, 244}, 64},
	{{192, 0, 0, 0, 0, 0, 136, 101, 186, 45, 90, 126, 199, 96, 34, 176}, 64},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{239, 195, 77, 239, 131, 156, 2, 246, 191, 178, 204, 160, 21, 213, 30, 128}, 9},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 38, 153, 139}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 75, 222, 209, 241}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 1}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 57, 132, 96}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 202, 54, 59}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 59}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 237, 194, 59}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 149, 133}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 223, 111, 113, 211}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 7, 28, 186}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 242}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 242, 205}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 77, 245, 170}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 184, 44, 130}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 77}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 187, 104, 141}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 26, 163, 65}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 62}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 2, 46, 227, 145}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 44, 226}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 52}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 226}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 2, 89, 80}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 104, 117, 106}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 9}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 206, 82, 155}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 138, 89, 53}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 115, 57, 70, 23}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 58, 48, 132}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 76}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 133, 46}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 251}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 158, 118, 148}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 128, 16, 244}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 101, 196, 188}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 241, 8, 231}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 51, 175}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 12}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 111, 96, 38, 99}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 200, 215, 76, 180}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 172}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 144, 242, 199}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 81, 28}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 35, 144}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 154, 100, 239, 243}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 134, 97, 234}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 139, 215, 220, 21}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 112}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 38, 53}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 57, 37, 66}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 219, 124}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 28, 19}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 194, 239, 88}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 140}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 139, 14, 191, 6}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 153, 81, 173}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 62, 63}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 1}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 235, 174}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 167, 200, 244}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 105}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 235, 186, 174}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 232, 159, 169, 132}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 183, 142}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 26, 187}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 223, 109}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 108}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 34, 200, 200}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 228, 91, 241}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 0}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 101, 202}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 0, 172}, 250},
	{{141, 207, 181, 99, 55, 245, 151, 228, 65, 50, 85, 16, 0, 0, 152, 188}, 250},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 85, 14, 173, 131}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 232}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 183, 125}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 165, 237, 174, 98, 128, 250, 202}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 196, 79}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 199, 170, 183, 207, 171, 49, 228}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 177, 141, 217, 189, 125, 102, 24}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 22, 34, 90, 105}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 166, 74}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 114, 205, 82, 33, 47, 176}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 40, 233, 153, 199, 217, 20, 21}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 70}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 0}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 0}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 158, 90, 207, 255, 195, 155}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 90, 6, 40}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 122, 38, 67, 24, 205, 156, 209}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 64}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 0}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 59, 92}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 137, 207}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 0}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 161}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 131, 115}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 101}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 30, 48, 72, 106, 53}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 199, 191}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 193, 11}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 199}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 167, 96}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 242, 150, 123, 159}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 72, 48, 250, 46, 239}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 127, 159, 105}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 0}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 228, 229}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 24, 11, 57, 139, 231, 238}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 150, 53, 28}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 163, 249, 195, 147}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 144, 91}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 136, 192, 55}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 38}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 120, 188, 14, 116}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 0}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 205, 248, 35, 34}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 79, 204, 170, 197, 126, 213}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 71, 120, 254, 40, 233, 156, 81}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 36, 153, 94, 17, 3, 243, 102}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 17, 99}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 127, 187, 254, 103}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 103, 199, 147, 37, 207, 26, 132}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 0}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 0}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 97}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 0}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 119, 148, 137, 96, 141, 44, 32}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 69, 159}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 27, 154, 136, 117, 12, 66}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 245, 26, 201, 104, 157, 171, 113}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 131, 96, 165, 197, 35, 221}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 162, 216, 16, 122, 36, 80, 55}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 102, 98, 118, 19, 198, 185, 99}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 0}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 140, 63, 161, 129}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 0}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 151, 219}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 212, 217, 223, 177, 76}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 34, 69, 229, 14, 203, 34}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 93, 74, 127, 171, 61, 97}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 13}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 239, 207, 160, 101, 139}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 78, 73, 206, 160}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 222}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 120, 157, 240, 182, 164}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 118, 41, 111, 75, 252}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 251, 76, 78, 167, 6}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 8}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 98}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 84, 196, 54, 224, 99}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 0}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 236, 248, 168, 165}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 203, 237, 113, 103, 190}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 115}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 0}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 211}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 135, 60, 112, 31, 150, 196}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 60, 108, 216, 224, 137, 103}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 249, 55}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 186}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 20, 32, 132, 25, 244, 71, 236}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 74, 147, 59, 172, 119, 137, 19}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 49, 240, 41}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 4, 222, 215, 135, 80}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 7, 248, 250, 162, 118}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 60, 216, 248, 91, 175, 23}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 136, 95, 1}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 70, 251, 36, 191, 225, 255}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 41, 51, 109, 200, 162}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 40, 173}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 0}, 200},
	{{110, 159, 230, 251, 224, 210, 58, 49, 0, 0, 0, 0, 0, 0, 0, 0}, 200},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{134, 26, 104, 32, 129, 41, 201, 50, 164, 69, 178, 156, 156, 133, 8, 218}, 132},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 101, 148, 230, 236, 56}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 179}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 181, 116}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 231, 62, 51, 193, 114, 83}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 0}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 0}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 233, 2, 129, 72, 155, 112}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 229, 217, 101}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 0}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 49, 219, 184}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 0}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 93, 253, 192, 67}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 27, 222, 229, 134, 7}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 71, 117, 167, 9, 92, 149}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 19}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 72, 239, 55}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 0}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 0}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 0}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 160, 192, 62, 147, 73, 137}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 137, 247, 4}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 145, 6, 173}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 129, 245, 242, 99, 82, 97}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 147, 97, 105, 34, 144, 20}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 223, 211, 250, 145, 98}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 169, 29, 241}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 64, 38, 10}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 100, 39, 17, 149, 24, 117}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 55, 71, 39}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 217, 170, 209}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 172, 92}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 45, 224, 228}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 231, 235, 71, 169, 196}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 198, 114, 135, 200, 214}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 58}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 46, 139, 166, 166}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 126, 9, 121, 207, 221}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 0}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 227, 219, 164, 224, 128}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 155, 20, 4, 235}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 250, 178, 56, 1}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 182, 139}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 45, 23, 97, 25}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 61, 146, 231}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 27, 219, 107, 14}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 39, 85}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 0}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 227, 247, 11, 86}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 247, 155, 249}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 89, 46, 90}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 18, 102, 85, 32}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 178, 69, 197}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 137, 130}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 221, 32, 183}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 145, 52, 116, 16, 63, 28}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 0}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 201, 70, 77}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 49, 116, 37, 195}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 65}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 210}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 0}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 0}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 217, 38}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 127, 157, 242, 26, 126, 0}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 0}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 0}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 213, 253, 113}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 10, 73}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 171, 47, 48, 223}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 199, 24, 237}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 96, 223, 183, 2, 109}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 255, 14, 184, 18, 43}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 252}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 231, 149, 156, 193}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 0}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 66, 123, 191, 225}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 96, 113, 22}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 19}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 143, 158, 122, 195, 63, 254}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 235, 49, 159, 220, 67}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 159}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 97}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 63, 18}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 244}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 141, 231}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 253}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 0}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 183, 254, 228}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 236, 225}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 253}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 254, 253}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 146, 155}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 128, 219, 178, 196, 47, 91}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 197, 183, 81, 176, 116}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 0, 0, 0}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 204, 238, 106, 29, 133, 97}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 104, 85, 243}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 6, 167, 89, 228, 22}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 123, 124, 40}, 182},
	{{253, 207, 116, 105, 210, 166, 186, 99, 182, 0, 0, 0, 0, 152, 164, 31}, 182},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 45}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 66, 254}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 245, 44}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 148}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 229, 42}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 26}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 149, 248}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 253}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 221, 24}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 89, 168}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 223}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 90, 156}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 245}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 177, 199}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 241, 35}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 78}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 170, 99}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 19}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 76}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 63, 79, 159}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 136, 141}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 223}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 210, 166}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 180}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 191, 16}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 71, 78}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 63, 238}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 255}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 50, 107}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 103, 145}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 102, 167}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 17, 1}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 210, 129}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 103}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 114}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 182}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 16}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 1, 69, 52}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 49, 17, 162}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 134, 183}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 80}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 91, 243}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 76}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 212, 24}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 157, 197}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 219, 147}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 203}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 4, 171}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 249}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 8}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 142, 228}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 30, 223}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 115}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 47}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 234}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 228, 41}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 107}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 43, 185}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 54}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 244, 67}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 92}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 74}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 248, 184, 167}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 236}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 0}, 7},
	{{211, 73, 38, 80, 183, 168, 52, 138, 25, 214, 112, 8, 252, 0, 0, 20}, 7},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 171, 189, 205}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 71}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 167}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 222}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 248}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 7}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 213}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 156, 223}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 98, 210, 245}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 151}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 137}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 220}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 10, 56, 28}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 166, 130, 190}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 215, 153}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 16, 56}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 244, 123, 146}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 120}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 232, 163, 122}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 128}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 201, 245}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 77, 25}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 197}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 153, 34, 135}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 209}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 14, 117, 211}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 130}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 149}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 127, 207, 141}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 163}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 196, 126}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 76}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 240, 226, 161}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 160}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 84, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 185, 74}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 249}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 187, 124}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 30, 139}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 100, 57, 57}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 47, 180}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 23}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 244, 87, 238}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 49, 174}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 88}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 46}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 37, 98}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 227}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 179, 103}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 13}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 191, 240, 101}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 41, 127}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 49, 81, 41}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 138, 67}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 135}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 211}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 27}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 110}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 37}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 88, 116, 127}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 203}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 245, 137}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 175}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 229, 102, 241}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 193}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 164}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 163, 64}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 145}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 229, 42}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 59, 60}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 44}, 146},
	{{200, 244, 108, 238, 164, 141, 215, 39, 233, 249, 120, 80, 112, 0, 0, 0}, 146},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 12}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 3}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 132, 23, 1, 200, 245, 24}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 27, 244, 175}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 198, 172, 197, 161, 211, 94}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 217, 158, 19, 9, 70}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 81}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 231, 191, 193, 63, 145}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 118, 87, 188, 189, 165, 210, 48}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 52, 192, 208, 103, 85}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 195, 115}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 140, 119, 217, 189, 72, 56, 224}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 198, 193, 135, 251, 80, 99, 180}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 171, 50, 254, 187}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 0}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 239, 137, 123}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 130, 166, 252, 11, 162, 123, 128}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 19, 42, 148, 57, 244}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 41}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 124}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 103, 1, 79, 255}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 41, 117}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 156, 163, 161, 20, 57, 38}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 47, 126, 105, 75, 177, 22}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 192, 76, 127}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 190, 201, 147, 219, 56}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 96, 81, 60}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 143, 255, 8, 193, 16}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 75, 29, 153, 223, 18, 14}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 163, 193, 89, 101, 58}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 237}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 202, 155, 245, 152, 106, 197}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 149, 45, 4, 230, 129}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 153}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 87, 14, 249, 50, 79}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 140, 215}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 236}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 211, 126, 202, 238, 196, 192}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 212, 209, 23, 202, 142, 253}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 0}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 27, 28, 92, 34, 217, 98}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 6, 250, 66}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 208, 85, 128, 146}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 31, 209}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 53, 250, 56, 245, 195, 218}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 190, 180}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 20, 203, 58, 135, 33, 163}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 17}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 23, 159, 183, 132, 174, 119}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 195, 66, 42, 142}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 81}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 228, 58, 203, 109}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 12}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 65, 31, 164}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 0}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 152, 161}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 127, 109, 3, 77, 217}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 156, 51, 126, 251}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 0}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 175, 150, 118, 192, 83, 212}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 137, 252}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 40, 202, 123, 138, 4, 203}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 103, 179, 50, 253}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 4, 90, 91, 103, 173}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 171, 57, 80}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 19, 199, 155, 179}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 152, 87, 77, 189, 141}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 125, 169, 195, 150, 46, 223}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 171, 34}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 169, 124, 21, 184, 9}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 0}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 0}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 182, 57, 139, 28, 198, 35}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 169, 54, 249}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 74, 108, 12}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 85, 62, 124, 27}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 156, 41, 168, 63, 12, 211, 72}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 10, 164, 119, 133, 231, 119}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 0}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 109}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 36, 237}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 103, 140}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 35, 34, 200, 196, 78}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 0}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 132, 19, 129, 187, 150}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 97, 187, 161, 82}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 115}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 15, 254, 121, 206, 229, 228}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 173, 120, 181, 95}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 81, 124, 204, 211, 89}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 10, 25, 64, 203, 27}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 146, 159, 103, 194, 46, 165}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 0}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 152, 13, 153, 234}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 221, 88, 94, 199, 78}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 179, 13, 176, 66, 249}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 0}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 0, 0, 0, 0}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 0, 234, 20, 76, 169}, 98},
	{{107, 44, 250, 202, 64, 37, 107, 105, 140, 0, 0, 203, 244, 141, 128, 186}, 98},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 218, 177, 243, 233}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 196, 76, 199}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 80}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 18, 180, 30}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 72, 188}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 96, 97, 137}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 121, 232}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 115, 182, 167, 176}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 111, 176, 180, 177, 176}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 146, 241, 47}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 152}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 187}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 41, 149, 128, 118}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 216, 46, 133}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 84}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 23, 224}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 90, 228, 218, 42}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 226, 42, 141}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 128, 182}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 26}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 91}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 180, 85, 71, 126}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 119}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 108, 219, 19}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 91, 191, 104}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 88}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 18}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 72, 121}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 13}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 113, 45, 77, 147}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 140, 192}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 117}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 213, 67, 229, 80}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 121, 32, 142, 185, 132}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 4, 139, 183, 76}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 108}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 65, 28, 119}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 102, 71, 232, 2}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 231, 232, 66, 131}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 241}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 105, 232, 98}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 78}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 37, 16, 106, 245}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 34}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 125, 203, 236, 122, 51}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 65, 158}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 25}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 120}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 67, 221, 154, 64, 166}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 124, 152, 56}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 178, 153}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 184}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 2, 172, 130, 3}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 17, 144, 61}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 249, 105}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 6}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 205, 242, 219}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 97, 12}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 167, 117, 62, 219}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 55}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 181}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 85, 94, 74, 164, 229}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 64, 192}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 139, 60, 123}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 43, 234, 94, 87}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 120, 212, 170, 106}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 254, 25, 88, 7}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 71, 244, 183, 208}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 255, 138, 118}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 2, 152, 164}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 0, 0, 0, 0, 0}, 179},
	{{93, 86, 56, 27, 159, 195, 126, 39, 240, 201, 48, 18, 135, 93, 192, 90}, 179},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 30, 219}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 213}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 128, 170, 68, 136, 138}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 64}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 0}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 189, 124, 118, 181, 207, 236}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 0}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 0}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 137}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 131, 77, 136, 55, 31, 185}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 21, 47, 207, 120}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 149, 109, 55}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 221, 239, 148}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 179}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 0}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 175, 50, 33}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 79, 37, 12, 114}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 182}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 118, 178, 10, 42}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 38}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 222, 228, 128, 155}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 120, 205}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 0}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 160, 145, 242, 91}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 76, 190, 69, 83}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 74, 107, 217, 232}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 192, 93, 5}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 23, 157, 68, 221}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 151, 147, 133, 115}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 217, 1, 49}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 28, 164, 3}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 151, 233, 255, 35}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 228, 56, 20, 154, 191, 151}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 91, 211, 55, 155, 109}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 200, 36, 112, 122, 13, 27}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 156, 162, 179}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 105, 33, 222}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 126}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 62, 255, 32}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 58, 140, 122, 206, 235}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 122, 242, 132, 152, 252}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 214, 75, 195, 166, 165}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 252, 61, 216, 137}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 131, 45}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 0}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 0}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 0}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 67, 209}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 202, 102, 231, 57, 213}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 253, 167, 114}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 37, 62, 109}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 106, 252, 31, 20, 249, 111}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 153, 179}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 134, 40, 184, 137, 69}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 0}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 155, 101, 130, 191}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 176, 193, 235, 228, 63}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 202, 222}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 66, 227, 250, 65, 48}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 14, 112, 1, 53}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 55, 217}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 238, 18, 92, 189}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 40, 56}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 184, 117}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 0}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 208, 139, 19, 26, 211}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 180}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 0}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 111, 209, 202, 73, 141, 11}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 0}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 64, 177}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 176, 220, 15, 233, 164}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 0}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 156, 239, 49}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 169, 144, 148, 197, 157}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 111, 226, 12, 172, 179}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 253, 187, 26}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 203}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 0}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 132, 9, 90, 55, 57, 158}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 0}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 0}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 152, 114, 146, 207}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 0}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 0}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 175, 197, 208}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 68, 118, 190}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 200}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 0}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 157, 183, 186, 61, 173}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 206}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 0, 0, 0}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 0, 49, 113, 113}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 105, 30, 143, 249}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 0, 60, 196, 60, 150}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 114, 48, 97, 170, 32}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 115, 171, 233, 236, 13}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 164, 78, 4, 135, 194}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 0, 73, 197, 105, 238, 79}, 245},
	{{32, 202, 214, 242, 39, 141, 61, 146, 138, 96, 232, 44, 72, 59, 21, 71}, 245},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 0}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 230, 128, 78, 28}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 75, 23, 233, 252}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 0}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 240, 94, 117, 114, 129, 101, 232}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 46}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 0}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 58, 168, 171, 153, 116, 245}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 72, 26, 253, 161, 98, 104, 129}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 0}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 21}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 243, 36, 92, 191}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 230, 160, 86, 31, 252, 229, 144}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 169, 214, 57, 1}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 9, 75, 179, 199, 175, 175}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 57, 3, 174, 225, 131, 55, 185}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 26, 122}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 81, 235, 81, 119, 124}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 131, 61}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 0}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 240, 217, 63, 107, 50, 223, 157}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 0}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 0}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 49, 93, 109, 82, 90, 94}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 246}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 178, 246, 73, 110, 246, 164, 96}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 187, 89, 20, 52, 0, 60, 195}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 21, 126, 16, 70}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 22, 200, 93, 126}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 85, 123, 66}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 128}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 15, 63, 182, 172, 248, 10, 220}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 83, 66, 8, 25}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 0}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 204, 148, 170, 221, 150, 168, 109}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 16, 51}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 213, 251, 142}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 0}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 239, 162, 2, 7, 70}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 0}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 227, 34, 139, 51, 207, 251, 157}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 195, 94, 105, 57, 129, 57}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 137, 245, 164, 208, 68, 229, 165}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 104}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 0}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 36, 215}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 69}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 236}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 34, 187, 150}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 0}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 0}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 88, 102}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 65}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 0}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 163, 119, 186, 38, 70}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 80, 80, 208}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 46, 28, 76, 30, 22, 219, 204}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 66}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 44}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 129}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 126, 206, 68}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 156, 74, 240, 198, 195, 99}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 0}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 25, 176, 62, 164, 242}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 0}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 5, 224, 119, 148}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 4, 103, 117, 46, 150}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 2, 38, 148}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 23, 234, 167, 34, 24}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 20, 181, 4, 227, 85, 81}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 239, 108, 139, 121, 6, 8}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 12, 140}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 0}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 185, 204, 220, 64, 192}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 96, 4}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 172, 102}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 48}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 143, 72, 210, 248, 137, 218}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 239, 72, 231, 27, 23}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 106, 40, 236}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 107, 41, 82, 16, 224, 147, 224}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 151, 51, 79}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 135, 92, 176, 155, 92, 217}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 32, 167, 210}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 67, 227, 53, 53}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 46, 193, 255, 58, 70, 203}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 45, 126, 151, 155}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 41, 97, 98, 205, 167, 159}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 168, 174, 96}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 31}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 162, 204, 19, 64, 31}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 143, 153}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 37, 10}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 133, 164, 139, 168, 209, 242, 133}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 255, 212}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 124, 202, 153, 46, 238, 28}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 125, 25, 248, 35, 14, 12, 19}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 146}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 0, 0, 0}, 2},
	{{167, 77, 249, 28, 210, 196, 227, 241, 0, 0, 0, 0, 0, 145, 139, 142}, 2},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 102, 154, 91, 92, 245, 185}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 101, 113, 221, 12, 47, 98, 196}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 132, 184}, 5},
	{{241, 59, 128, 153, 49, 46, 107, 116, 98, 211, 15, 31, 12, 255, 123, 82}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 124, 170, 199, 165, 120, 162, 200, 92, 209}, 5},
	{{241, 59, 128, 0, 229, 39, 28, 234, 118, 177, 240, 92, 40, 98, 22, 96}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 214, 165, 127, 38}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 165, 248, 52}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 193}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 177, 21}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 222, 77, 48, 30, 21, 138, 54}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60, 207, 126}, 5},
	{{241, 59, 128, 0, 244, 58, 3, 88, 232, 48, 180, 230, 83, 39, 9, 172}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 204, 105, 53, 229}, 5},
	{{241, 59, 128, 88, 185, 84, 82, 11, 235, 100, 25, 11, 207, 130, 99, 65}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 97, 203, 54, 143, 104, 34, 52, 113}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 98, 99}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 92}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 105, 62, 71, 203, 202, 124}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 88, 149, 49, 242}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 68, 224, 18, 229, 246, 132, 145, 25}, 5},
	{{241, 59, 128, 0, 0, 0, 210, 48, 139, 69, 81, 158, 97, 26, 144, 182}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 176, 87, 116}, 5},
	{{241, 59, 128, 0, 0, 235, 161, 47, 55, 14, 136, 89, 113, 45, 87, 122}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 121, 209}, 5},
	{{241, 59, 128, 0, 58, 96, 162, 15, 202, 186, 78, 89, 13, 172, 184, 126}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 44, 19, 129, 54}, 5},
	{{241, 59, 128, 0, 0, 0, 127, 23, 147, 107, 49, 234, 69, 114, 57, 106}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 179, 234, 36, 152, 21}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 10, 247, 60, 3, 156, 134}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 154}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 188, 152, 216, 236, 56, 83, 128, 96, 217}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 115, 155, 119, 14, 171, 89}, 5},
	{{241, 59, 128, 0, 232, 66, 8, 100, 63, 171, 221, 72, 180, 32, 241, 218}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 248, 226, 220, 116}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 255, 252, 84, 175, 94}, 5},
	{{241, 59, 128, 0, 0, 224, 200, 241, 161, 85, 193, 117, 66, 160, 46, 250}, 5},
	{{241, 59, 128, 0, 0, 0, 235, 78, 74, 130, 250, 94, 206, 187, 83, 118}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 203, 223, 238, 191}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192}, 5},
	{{241, 59, 128, 0, 234, 216, 50, 86, 198, 93, 73, 85, 51, 27, 190, 110}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 69, 113, 222, 181, 205, 214, 8, 70}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 103, 220, 60, 222, 214, 107, 193}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 245}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 138, 38}, 5},
	{{241, 59, 128, 0, 0, 111, 14, 168, 45, 149, 81, 194, 38, 45, 109, 50}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 61, 243, 149, 151, 192, 155, 162, 27}, 5},
	{{241, 59, 128, 0, 49, 191, 243, 239, 213, 90, 182, 213, 247, 142, 168, 196}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 30, 61, 171, 117, 74, 223}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 238, 227, 181, 103}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 249, 228, 8}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 235}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 5},
	{{241, 59, 128, 132, 68, 32, 145, 153, 158, 248, 187, 224, 69, 202, 115, 16}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 142, 13, 46, 10, 62, 71, 211, 137}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 126, 82, 200}, 5},
	{{241, 59, 128, 46, 215, 189, 40, 210, 212, 158, 238, 120, 78, 14, 113, 226}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 172, 210, 26}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 145, 230, 227, 210, 172, 32, 229}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 226, 236, 121, 211, 17, 27, 254, 128, 18}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 85}, 5},
	{{241, 59, 128, 0, 36, 177, 76, 11, 190, 192, 124, 199, 174, 192, 193, 18}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 194, 47, 9, 71}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 35, 242, 52, 20, 241, 255}, 5},
	{{241, 59, 128, 0, 0, 93, 12, 140, 151, 194, 234, 121, 249, 43, 58, 196}, 5},
	{{241, 59, 128, 151, 100, 28, 70, 101, 153, 47, 77, 56, 171, 93, 210, 67}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 88, 21, 178, 100, 158}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 10, 30, 212, 203, 209, 235, 91, 108, 113}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 150, 18, 43, 18, 124}, 5},
	{{241, 59, 128, 0, 0, 187, 184, 6, 179, 134, 110, 85, 81, 143, 9, 7}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 230, 92, 34, 49, 43}, 5},
	{{241, 59, 128, 9, 61, 250, 30, 168, 50, 202, 104, 200, 80, 136, 250, 151}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 171, 22}, 5},
	{{241, 59, 128, 0, 236, 34, 108, 76, 88, 128, 77, 43, 213, 119, 117, 205}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 194, 70, 220, 126, 200, 49, 18, 211, 123}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, 134, 65, 186}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 132, 111, 99, 54, 250, 63, 195}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 122, 249, 144, 34}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 13, 201, 24, 131, 213}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 95, 0, 105, 109, 180, 168}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 194, 210, 141, 30, 115}, 5},
	{{241, 59, 128, 0, 191, 245, 29, 57, 116, 227, 16, 72, 5, 191, 114, 208}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206, 96}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 75, 0, 2, 116, 63, 206, 169, 90}, 5},
	{{241, 59, 128, 23, 101, 236, 69, 151, 15, 150, 3, 108, 95, 78, 178, 0}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 0, 0, 0, 102, 204, 69, 119, 166}, 5},
	{{241, 59, 128, 0, 0, 91, 46, 131, 154, 141, 47, 21, 190, 122, 2, 32}, 5},
	{{241, 59, 128, 0, 0, 0, 194, 16, 176, 48, 91, 19, 224, 144, 65, 107}, 5},
	{{241, 59, 128, 0, 0, 0, 0, 0, 33, 14, 175, 113, 32, 146, 234, 95}, 5},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 175, 203, 118, 70, 58, 74, 158}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 148, 193, 55, 97, 67, 59, 38}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 41}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 217, 105, 163, 235, 27, 90, 80}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 144, 42, 239, 222, 250, 178}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 203, 48, 154}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 48}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 247, 91, 213, 141}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 138, 236, 47}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 150}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 76, 174}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 57, 82, 235, 116, 107, 173}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 203, 18, 7, 192, 222, 255, 69}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 236}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 4, 3, 250, 131}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 177, 157, 40, 189}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 232, 119, 164}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 127, 40, 179, 171}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 255, 115, 239, 78, 50, 122, 106}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 90}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 193, 61, 169, 187}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 246, 123, 120, 19, 61, 192, 11}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 160, 181, 50, 32, 125, 62, 38}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 10, 146, 59, 153, 6}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 116, 172, 48, 192, 197}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 245, 153, 118, 192, 162, 192}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 90, 17, 108, 243, 58}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 124, 103, 39, 23, 59, 27, 111}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 242, 24, 222, 136, 142}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 93, 241, 158, 137, 92}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 157, 157, 84, 77, 15, 174}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 228, 214, 112}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 255, 227, 112, 219}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 31, 169, 167, 88, 252, 34}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 251, 82, 12, 57, 117, 173, 217}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 186, 15}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 99, 128, 182}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 163, 185, 95}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 153, 195, 2}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 106, 123}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 36, 199, 19}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 214, 135, 172, 75, 134}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 253, 250, 125, 205, 249}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 173, 189}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 223, 0, 216, 73}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 114, 20, 223, 64}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 89, 250, 40}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 168, 15}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 205, 103, 142, 150, 154, 9}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 65, 255, 231, 149, 212, 142}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 255, 42, 133, 184, 196}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 108, 81}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 4, 222, 70, 58}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 206, 46, 250}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 28, 85, 216}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 15, 73, 13}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 229, 43, 200}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 171, 128, 65}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 252, 196, 14, 63, 58, 104, 100}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 230}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 27, 134, 62, 209}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 223, 218, 38, 34, 119}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 191, 70, 40, 1}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 171}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 120, 76, 208}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 13}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 225, 50, 9}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 36, 217, 118, 181, 244}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 234, 211}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 105, 161}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 186, 190, 57, 114, 14, 19}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 212}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 252, 43, 58, 24}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 1, 28}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 54, 101}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 21, 147, 52, 249}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 197, 171, 147, 28, 18, 52, 103}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 219, 238, 197}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 104, 173, 153, 51, 96}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 245, 136, 72}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 171}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 161, 46, 224, 74, 65, 146, 69}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 124, 102, 208, 43, 94}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 195, 6, 52, 44}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 202, 213, 107, 65, 67}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 194, 7, 175, 240, 233}, 169},
	{{143, 68, 146, 210, 173, 155, 251, 173, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{167, 180, 226, 144, 0, 49, 48, 196, 28, 75, 141, 198, 177, 193, 29, 186}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97, 78, 85}, 52},
	{{167, 180, 226, 144, 0, 192, 108, 166, 128, 59, 213, 246, 224, 88, 251, 17}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 20, 72, 159, 87}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 52},
	{{167, 180, 226, 144, 0, 0, 229, 106, 82, 99, 14, 54, 146, 55, 53, 201}, 52},
	{{167, 180, 226, 144, 0, 148, 83, 190, 33, 206, 92, 167, 48, 17, 172, 120}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 191, 134, 15, 134, 3, 33, 38, 199}, 52},
	{{167, 180, 226, 144, 0, 0, 1, 231, 212, 205, 157, 176, 56, 156, 237, 212}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 218, 60, 152, 16, 167, 79}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 179, 60}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 166, 42, 11, 14}, 52},
	{{167, 180, 226, 144, 0, 0, 23, 106, 46, 168, 104, 185, 151, 116, 211, 170}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 200, 245, 243, 236, 42, 181, 77, 22}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 31, 219, 70}, 52},
	{{167, 180, 226, 144, 0, 0, 96, 108, 25, 250, 93, 200, 142, 221, 87, 132}, 52},
	{{167, 180, 226, 144, 0, 232, 161, 71, 170, 6, 247, 15, 83, 109, 98, 253}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13, 9}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 253, 4, 30, 150}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 158}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 53, 174, 72, 216, 82, 62}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 147, 197, 105, 242, 23, 73, 100, 124}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 233, 122, 236, 3, 74, 115}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 125}, 52},
	{{167, 180, 226, 144, 0, 0, 164, 112, 63, 143, 208, 187, 146, 185, 42, 75}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 80, 118, 213, 81, 247, 128, 37}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 71, 193, 227, 85, 145, 86, 120}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 134}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 143, 146, 113, 1, 22, 247, 170, 85, 70}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 52}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 54, 87}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 179, 232, 114, 0}, 52},
	{{167, 180, 226, 144, 0, 233, 120, 108, 85, 67, 116, 86, 108, 179, 130, 142}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 46, 203, 153, 193, 178, 56, 5}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 91, 227, 238, 219, 93, 151, 171, 191}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 179, 158, 17, 81, 57, 149, 197}, 52},
	{{167, 180, 226, 144, 0, 154, 231, 55, 55, 58, 142, 79, 75, 176, 2, 117}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 235}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 216, 218, 130, 229}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 181, 95, 33, 91, 203}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 95, 111, 59, 232, 206, 161, 170}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 210, 182, 122, 44, 195, 35, 1, 173, 16}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 74, 239, 224, 180, 229, 235, 150, 176}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 123, 69, 126}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 171, 246, 176, 204, 189, 45}, 52},
	{{167, 180, 226, 144, 0, 0, 188, 184, 218, 245, 227, 82, 118, 95, 11, 102}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 119}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 38, 209, 233, 97, 116, 37, 236, 95}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 202, 189, 80, 26, 79, 24, 166, 106}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 51, 221, 242, 213, 64, 107, 46, 38, 248}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 170, 119}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 101, 212, 131}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 116}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 166, 46, 236, 245, 7, 108}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 125, 71, 161, 68, 177, 168, 41, 254, 88}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 165}, 52},
	{{167, 180, 226, 144, 0, 0, 255, 151, 243, 147, 25, 169, 33, 73, 73, 235}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 246, 99}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 118, 220, 162, 12}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 137, 132}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 66, 145, 96, 146, 252, 8, 86, 164}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 229, 91, 118, 212}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 25, 218, 22, 1, 75, 130}, 52},
	{{167, 180, 226, 144, 0, 9, 62, 245, 200, 178, 44, 122, 199, 13, 143, 201}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 13}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 5, 10, 219, 159, 203, 88, 9, 181, 212}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 34, 56, 217, 157, 30}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 211, 0, 80, 35, 106, 101, 225, 109}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 95, 138, 226, 180, 250, 38, 161, 118}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 189, 213, 1, 56}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 232, 167, 226}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 140, 28, 157}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 47, 48, 221, 105, 234, 226}, 52},
	{{167, 180, 226, 144, 0, 0, 227, 52, 161, 43, 80, 12, 202, 110, 225, 200}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 214, 64, 215}, 52},
	{{167, 180, 226, 144, 0, 173, 55, 48, 211, 254, 249, 212, 91, 129, 107, 253}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 163, 82}, 52},
	{{167, 180, 226, 144, 0, 0, 33, 228, 181, 174, 24, 148, 2, 243, 53, 182}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 35, 115, 38, 103, 254, 134}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 228, 142, 84}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 49, 229, 246, 114, 229, 37}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 106, 199, 154}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 196, 116, 186}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 125, 73, 75}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 27, 74, 170, 85, 184, 100, 130, 122}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 252}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 254, 180, 167, 2, 68}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 167, 74, 38, 240}, 52},
	{{167, 180, 226, 144, 0, 172, 76, 195, 165, 206, 160, 68, 8, 196, 244, 64}, 52},
	{{167, 180, 226, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 237, 55, 216}, 52},
	{{241, 0, 0, 211, 24, 250, 230, 57, 204, 33, 116, 248, 12, 187, 115, 249}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 220, 240, 127, 248, 216, 57, 71}, 149},
	{{241, 0, 154, 218, 55, 105, 197, 102, 251, 123, 2, 237, 221, 249, 167, 209}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 249, 213, 149, 209, 32}, 149},
	{{241, 0, 0, 0, 111, 112, 8, 101, 45, 184, 144, 41, 46, 155, 151, 31}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 165, 33, 237, 211, 184, 126, 178}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 30, 22, 128, 109, 62, 237, 242, 181}, 149},
	{{241, 0, 0, 19, 205, 184, 7, 134, 148, 67, 238, 209, 18, 188, 127, 126}, 149},
	{{241, 0, 0, 217, 118, 38, 186, 176, 39, 160, 215, 35, 197, 17, 52, 240}, 149},
	{{241, 0, 239, 245, 109, 214, 88, 154, 158, 204, 86, 190, 230, 214, 198, 99}, 149},
	{{241, 0, 0, 86, 224, 176, 184, 62, 75, 166, 205, 66, 213, 219, 39, 208}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 83, 175, 90, 245, 118, 111, 60}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 26, 237, 255, 30, 201, 0, 174, 50, 9}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 44, 117, 125, 49}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 55}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 134, 242, 133}, 149},
	{{241, 0, 0, 0, 64, 175, 146, 146, 136, 219, 201, 144, 184, 20, 127, 114}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 149},
	{{241, 0, 56, 116, 80, 243, 165, 9, 73, 138, 96, 111, 117, 183, 173, 117}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 70, 166, 15, 197, 225}, 149},
	{{241, 0, 0, 196, 36, 122, 250, 83, 105, 160, 67, 226, 243, 190, 55, 197}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 92, 119, 12, 62, 83, 244, 140}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 174, 205, 51}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 146, 232, 86, 236, 192}, 149},
	{{241, 0, 0, 160, 130, 75, 170, 198, 157, 117, 36, 137, 216, 77, 135, 194}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 11, 138, 124, 14, 91, 97, 192, 238}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 37, 101, 119, 227, 83, 202, 171, 116}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 190, 210, 245, 201, 52}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 47, 239, 86, 150}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 129, 253, 201, 89}, 149},
	{{241, 0, 75, 132, 108, 205, 78, 136, 75, 137, 229, 109, 116, 101, 250, 22}, 149},
	{{241, 0, 241, 199, 176, 75, 48, 196, 81, 36, 241, 44, 74, 203, 103, 76}, 149},
	{{241, 0, 0, 0, 0, 122, 99, 150, 19, 20, 135, 212, 141, 245, 144, 17}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 216, 199}, 149},
	{{241, 0, 0, 160, 184, 188, 250, 70, 4, 154, 118, 47, 163, 139, 205, 180}, 149},
	{{241, 0, 0, 0, 0, 86, 170, 217, 226, 20, 33, 251, 6, 235, 177, 49}, 149},
	{{241, 0, 217, 39, 99, 47, 126, 129, 135, 60, 251, 24, 250, 14, 49, 246}, 149},
	{{241, 0, 0, 0, 0, 0, 123, 13, 119, 161, 76, 252, 209, 28, 14, 171}, 149},
	{{241, 0, 0, 0, 20, 195, 101, 106, 250, 21, 28, 81, 96, 45, 83, 163}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 72, 184, 221, 240, 43, 116, 99, 244, 160}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 136, 17, 11}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 215, 108}, 149},
	{{241, 0, 0, 174, 160, 122, 237, 108, 186, 103, 230, 100, 182, 166, 134, 204}, 149},
	{{241, 0, 0, 0, 0, 74, 206, 23, 55, 135, 55, 108, 154, 132, 227, 22}, 149},
	{{241, 0, 0, 0, 0, 0, 57, 57, 131, 253, 66, 191, 109, 212, 72, 166}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48}, 149},
	{{241, 0, 83, 41, 174, 102, 101, 181, 42, 226, 179, 208, 163, 18, 159, 1}, 149},
	{{241, 0, 0, 0, 124, 91, 169, 93, 147, 33, 255, 136, 176, 25, 244, 204}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 15, 210, 143, 154, 32, 47, 212}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 177, 85, 9, 101, 231}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 146, 46, 154, 58, 240}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 38, 36, 205}, 149},
	{{241, 0, 0, 0, 0, 188, 27, 207, 213, 5, 114, 57, 212, 213, 72, 59}, 149},
	{{241, 0, 0, 0, 0, 110, 105, 188, 152, 166, 111, 38, 190, 10, 251, 174}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 149},
	{{241, 0, 0, 192, 92, 248, 163, 93, 168, 228, 76, 168, 216, 233, 50, 42}, 149},
	{{241, 0, 0, 0, 0, 0, 183, 17, 235, 94, 224, 167, 124, 111, 242, 231}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 173, 21, 135, 173, 120}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 137, 188, 199, 199, 162, 41, 207, 191}, 149},
	{{241, 0, 0, 101, 74, 226, 212, 197, 129, 208, 90, 205, 240, 56, 216, 34}, 149},
	{{241, 0, 0, 0, 0, 109, 137, 35, 181, 131, 92, 142, 115, 144, 165, 210}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 44, 201, 128, 155, 166, 168, 124}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 124, 40, 205}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 94, 70}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 171, 155, 166, 158}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 218, 141, 54, 196, 51, 253}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 157, 212, 248, 182, 209, 141, 200, 232}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 231, 30, 53, 131, 214}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 189, 73, 40}, 149},
	{{241, 0, 0, 0, 248, 187, 148, 166, 6, 241, 73, 92, 127, 110, 202, 119}, 149},
	{{241, 0, 0, 0, 0, 154, 33, 0, 171, 177, 30, 239, 186, 105, 169, 216}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 149},
	{{241, 0, 0, 16, 59, 165, 221, 56, 69, 31, 105, 91, 210, 112, 242, 207}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 82, 2, 206, 123}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 121, 238, 236, 175, 194, 148, 73, 66}, 149},
	{{241, 0, 0, 0, 0, 0, 166, 146, 56, 110, 176, 158, 195, 32, 170, 36}, 149},
	{{241, 0, 0, 78, 0, 73, 232, 191, 167, 249, 225, 136, 197, 173, 150, 149}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 82, 244, 230, 3, 170}, 149},
	{{241, 0, 0, 0, 0, 144, 65, 23, 102, 117, 92, 107, 76, 130, 77, 45}, 149},
	{{241, 0, 0, 0, 198, 80, 89, 84, 248, 192, 8, 99, 132, 86, 229, 178}, 149},
	{{241, 0, 0, 0, 238, 230, 146, 213, 0, 107, 196, 125, 50, 10, 94, 115}, 149},
	{{241, 0, 0, 0, 0, 200, 159, 230, 84, 169, 200, 50, 152, 47, 167, 63}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 133, 48, 120, 128}, 149},
	{{241, 0, 0, 0, 230, 200, 178, 21, 244, 30, 122, 246, 216, 218, 9, 242}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 243}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 135, 44, 82, 76, 42, 175, 94, 209, 74}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 80, 241, 114, 127, 31, 81, 45, 134, 254}, 149},
	{{241, 0, 0, 182, 36, 81, 171, 218, 184, 73, 82, 154, 85, 72, 36, 182}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 213, 47, 142, 69, 175, 141, 39}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 12, 229, 11, 223}, 149},
	{{241, 0, 0, 0, 0, 0, 0, 0, 83, 64, 103, 132, 128, 200, 195, 137}, 149},
	{{241, 0, 0, 56, 179, 42, 14, 46, 26, 202, 111, 5, 160, 117, 221, 251}, 149},
	{{238, 9, 168, 96, 0, 137, 68, 34, 36, 32, 203, 246, 76, 207, 51, 215}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 231, 164, 238}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 33, 184, 201, 188, 82, 73}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 176, 39}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 156, 241, 100, 32, 185, 231, 98}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 57, 242, 106, 16, 140, 34}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 223, 33, 59, 195, 156, 22}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 28, 250, 254, 19, 191, 193, 186, 17}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 60, 131, 70, 20, 63, 129, 200, 99}, 74},
	{{238, 9, 168, 96, 3, 185, 95, 111, 189, 156, 67, 25, 101, 84, 191, 197}, 74},
	{{238, 9, 168, 96, 0, 0, 162, 175, 251, 247, 26, 57, 235, 103, 247, 113}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 172, 59, 119, 203, 127, 103, 18, 3, 82}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 66, 121, 74, 4, 27, 75, 244, 107}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 123, 89, 239, 6, 19, 21, 15, 71, 31}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 202, 35}, 74},
	{{238, 9, 168, 96, 0, 0, 96, 59, 124, 71, 133, 199, 98, 217, 231, 181}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 160, 27, 172, 103, 113, 206, 184}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 125, 46, 213, 118, 205, 161, 200}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 240, 254, 197, 61, 209, 32, 10, 87, 118}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 42, 6, 48, 79, 25, 179, 223, 49, 254}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 189, 29, 113, 79, 119, 138, 33}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 187, 90, 62, 203, 40, 115, 35, 161, 112}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40, 255, 103}, 74},
	{{238, 9, 168, 96, 17, 223, 176, 161, 237, 187, 24, 151, 16, 9, 218, 194}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 244, 204, 87}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 56, 195, 81, 174}, 74},
	{{238, 9, 168, 96, 32, 57, 67, 191, 163, 163, 149, 202, 24, 179, 248, 11}, 74},
	{{238, 9, 168, 96, 0, 0, 209, 247, 53, 64, 5, 57, 51, 100, 224, 12}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 38, 123, 170}, 74},
	{{238, 9, 168, 96, 0, 0, 182, 146, 59, 124, 203, 30, 195, 106, 13, 66}, 74},
	{{238, 9, 168, 96, 0, 0, 205, 88, 253, 210, 70, 234, 162, 191, 220, 149}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 33, 222, 169, 165, 150, 223, 93, 71}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 23, 46}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 116, 255, 40}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 73, 77, 54, 28, 30, 231, 152, 151, 111}, 74},
	{{238, 9, 168, 96, 0, 0, 179, 95, 119, 146, 221, 183, 46, 23, 27, 251}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 198, 251, 82, 164, 36, 113, 73, 91, 197}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 74},
	{{238, 9, 168, 96, 82, 176, 71, 44, 209, 57, 151, 231, 201, 156, 227, 175}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 24, 149, 8, 63, 227}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 127, 138, 40, 130}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 165, 83, 81}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 21, 90, 78, 251, 92, 118, 29, 121}, 74},
	{{238, 9, 168, 96, 0, 0, 51, 215, 117, 208, 109, 13, 169, 35, 183, 176}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 202, 148, 112, 210, 80, 252}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 88}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 250, 142, 72}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 218, 98, 244, 231, 119, 236, 248}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 124, 0, 10, 254, 244, 33, 55, 74}, 74},
	{{238, 9, 168, 96, 1, 149, 194, 222, 195, 212, 28, 177, 80, 213, 6, 248}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131, 113, 243}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 116, 34, 15, 24, 134, 91, 182}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 63, 23, 75, 79, 76, 84, 159}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 129, 51, 234}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 222, 232, 4, 48}, 74},
	{{238, 9, 168, 96, 0, 84, 59, 154, 247, 56, 122, 65, 213, 4, 28, 129}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 139, 231, 34, 104, 252, 63, 129}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 137, 81, 89, 251, 176}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 93, 202, 45, 131, 95, 37, 49, 47, 50}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 131, 141}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 67, 6, 251, 251, 178, 106, 203}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 205}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120}, 74},
	{{238, 9, 168, 96, 0, 0, 174, 156, 87, 68, 210, 248, 184, 15, 234, 134}, 74},
	{{238, 9, 168, 96, 10, 123, 255, 81, 197, 194, 58, 94, 135, 112, 135, 231}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 74},
	{{238, 9, 168, 96, 0, 71, 6, 143, 170, 114, 153, 14, 248, 5, 162, 125}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 57, 239, 177, 217, 138}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 12, 176, 243, 58, 130, 110}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223}, 74},
	{{238, 9, 168, 96, 0, 24, 177, 170, 160, 38, 231, 63, 227, 20, 70, 146}, 74},
	{{238, 9, 168, 96, 0, 0, 51, 173, 23, 225, 10, 137, 42, 42, 215, 81}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 74},
	{{238, 9, 168, 96, 0, 1, 17, 201, 117, 195, 3, 251, 217, 139, 226, 237}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 196, 88, 246, 231, 151, 200}, 74},
	{{238, 9, 168, 96, 0, 212, 11, 234, 19, 31, 54, 98, 52, 73, 0, 191}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 249}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 240, 13, 247, 34}, 74},
	{{238, 9, 168, 96, 0, 0, 24, 27, 35, 57, 189, 126, 168, 146, 82, 39}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 152, 126, 132}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 74}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 34, 116, 26}, 74},
	{{238, 9, 168, 96, 0, 7, 186, 159, 130, 190, 87, 195, 47, 251, 213, 222}, 74},
	{{238, 9, 168, 96, 0, 0, 199, 8, 180, 160, 145, 205, 132, 49, 146, 119}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 219, 46, 21, 199}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 135, 67, 224, 148, 253, 31, 164, 143}, 74},
	{{238, 9, 168, 96, 0, 50, 33, 235, 125, 57, 107, 1, 77, 89, 217, 241}, 74},
	{{238, 9, 168, 96, 167, 42, 21, 100, 88, 14, 112, 161, 73, 47, 38, 131}, 74},
	{{238, 9, 168, 96, 0, 17, 71, 170, 211, 13, 148, 92, 78, 67, 219, 148}, 74},
	{{238, 9, 168, 96, 0, 0, 0, 0, 0, 213, 168, 180, 94, 252, 61, 63}, 74},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{203, 148, 16, 96, 125, 18, 86, 1, 91, 244, 251, 20, 31, 14, 75, 128}, 212},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{111, 227, 137, 94, 65, 21, 77, 137, 119, 130, 159, 19, 159, 45, 18, 192}, 238},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 196, 65, 144, 228, 20, 170}, 18},
	{{59, 144, 0, 0, 102, 163, 220, 197, 18, 236, 117, 18, 114, 130, 231, 134}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 164}, 18},
	{{59, 144, 0, 0, 0, 74, 197, 147, 1, 37, 107, 67, 126, 181, 25, 162}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 69}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 197, 54, 104, 92, 212, 135, 232, 197}, 18},
	{{59, 144, 0, 0, 161, 186, 79, 187, 107, 163, 126, 245, 165, 207, 124, 243}, 18},
	{{59, 144, 0, 0, 0, 0, 174, 190, 49, 37, 133, 95, 239, 194, 130, 59}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 114}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 176, 221}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 17}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 18},
	{{59, 144, 0, 0, 0, 144, 228, 96, 27, 87, 18, 135, 74, 245, 129, 201}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 139, 242, 181, 221, 22}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 179}, 18},
	{{59, 144, 0, 0, 0, 203, 184, 188, 65, 253, 149, 76, 168, 158, 130, 189}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 196, 88, 54, 107, 102, 179, 253, 73}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 212, 11, 158, 126}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 77, 217, 58, 118, 25, 108}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 222, 235, 227, 61, 189}, 18},
	{{59, 144, 0, 0, 131, 200, 105, 51, 133, 81, 210, 80, 40, 214, 201, 36}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 232, 223, 122, 226}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 156, 235}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 195, 52, 122, 175, 3}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 9, 246, 82}, 18},
	{{59, 144, 0, 0, 0, 0, 58, 12, 11, 97, 6, 197, 124, 126, 147, 160}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 19, 103, 64, 164, 72, 175, 126}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 120, 80, 195, 201, 54, 162, 94, 99, 104}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 18},
	{{59, 144, 0, 0, 0, 0, 74, 194, 66, 175, 48, 60, 84, 217, 72, 199}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 18},
	{{59, 144, 0, 0, 253, 97, 146, 231, 156, 14, 165, 22, 48, 123, 67, 183}, 18},
	{{59, 144, 0, 156, 162, 205, 178, 73, 222, 99, 55, 153, 85, 248, 251, 234}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 182, 4, 134, 54, 100, 125, 16, 164}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 89}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 172, 123, 166, 177, 39}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 110, 100, 244, 62, 50, 254}, 18},
	{{59, 144, 0, 0, 0, 42, 142, 64, 136, 98, 157, 112, 84, 19, 44, 145}, 18},
	{{59, 144, 0, 0, 0, 0, 142, 173, 27, 117, 50, 243, 5, 253, 210, 31}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 152, 223, 205, 140, 36, 169}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 152, 163, 44, 254, 51}, 18},
	{{59, 144, 0, 0, 0, 0, 66, 35, 12, 51, 81, 105, 96, 209, 97, 82}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 114, 82, 124, 250}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 184, 76, 179}, 18},
	{{59, 144, 0, 0, 0, 42, 39, 144, 255, 219, 58, 57, 178, 153, 107, 130}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 77, 42, 115, 159, 186, 230, 236, 160, 16}, 18},
	{{59, 144, 0, 0, 0, 0, 34, 63, 60, 67, 29, 191, 245, 216, 221, 117}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 42, 216, 15, 221, 182, 57, 198, 218, 82}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 229, 136, 204, 222, 144}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 173}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 164, 118, 201, 243}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 88, 172}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 45, 98, 185, 215, 100, 248, 27, 183, 34}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 235, 249, 239}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 77, 47, 213}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 144, 7, 120, 138, 174, 195, 110, 147}, 18},
	{{59, 144, 0, 0, 0, 0, 163, 126, 189, 197, 23, 145, 63, 10, 231, 64}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 18},
	{{59, 144, 0, 0, 0, 97, 180, 201, 78, 69, 29, 33, 50, 115, 89, 60}, 18},
	{{59, 144, 0, 0, 56, 106, 216, 28, 238, 112, 95, 27, 82, 93, 106, 201}, 18},
	{{59, 144, 0, 0, 105, 192, 36, 205, 179, 32, 113, 165, 225, 182, 96, 105}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 115, 239, 116}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68, 109}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 102, 230, 193, 189, 177, 193, 201, 160}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 130}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 202, 7, 128, 30, 76, 76, 204}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 22, 231, 8}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 37, 37, 43, 162, 148, 169, 56, 236, 4}, 18},
	{{59, 144, 0, 0, 124, 184, 96, 128, 146, 11, 242, 238, 74, 232, 254, 120}, 18},
	{{59, 144, 0, 0, 0, 0, 120, 244, 6, 159, 122, 3, 26, 71, 8, 171}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 84, 132, 243, 226, 233, 135, 71, 137}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 71, 216, 179, 126, 122, 82}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 118, 71, 104, 69}, 18},
	{{59, 144, 0, 0, 0, 0, 170, 139, 119, 192, 162, 63, 93, 226, 194, 136}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 229, 19, 66, 188, 138, 246, 89}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 124, 78}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 168, 186, 126, 141, 31, 97, 9, 69}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 176}, 18},
	{{59, 144, 0, 0, 0, 205, 134, 86, 243, 151, 22, 233, 176, 95, 176, 9}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 237, 100, 203}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 127, 125, 251, 23, 240, 44, 215}, 18},
	{{59, 144, 0, 0, 237, 25, 2, 7, 117, 186, 132, 204, 99, 155, 163, 123}, 18},
	{{59, 144, 0, 171, 177, 209, 41, 228, 161, 248, 134, 194, 224, 104, 60, 121}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 181, 53, 55}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 118, 72, 14, 129, 253, 89}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 185, 17, 226, 41, 199, 11}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 148, 154, 244, 84, 251}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 86, 13, 127, 203, 24, 81, 14, 64}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 151, 111, 176}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 121, 165, 212}, 18},
	{{59, 144, 0, 0, 0, 64, 124, 233, 167, 115, 8, 155, 27, 98, 70, 212}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 0, 0, 138, 78, 211, 243, 179, 143}, 18},
	{{59, 144, 0, 0, 0, 0, 0, 0, 180, 38, 9, 160, 88, 24, 90, 105}, 18},
	{{59, 144, 0, 0, 89, 239, 22, 122, 128, 131, 203, 215, 205, 178, 190, 105}, 18},
	{{59, 144, 0, 0, 0, 0, 255, 154, 120, 107, 225, 230, 146, 71, 179, 120}, 18},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 49, 238, 164}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 158, 178, 114, 47, 101, 203}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 36, 136}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 32}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 226}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 19, 80, 100, 37, 206, 218}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 191, 219, 32, 69, 54}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 79}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 0}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 0}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 34}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 0}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 197, 66, 230, 244, 99, 30}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 113, 212, 172, 170}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 151, 253, 111, 185}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 135, 233}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 77, 108, 72, 183, 29}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 38}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 0}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 28, 94, 230, 108, 122}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 35, 75, 202}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 0}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 3, 120, 226, 206, 181, 158}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 228, 157, 228, 53}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 23, 62, 23}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 175, 203}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 135, 21, 204, 95, 86}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 247}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 0}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 0}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 40, 55, 175, 162, 162}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 90}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 57}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 68, 23, 153, 173}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 198, 8, 194, 14}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 86, 181, 70}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 240, 50}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 166, 128, 29}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 211, 227, 108, 102, 158}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 186, 207, 56, 186, 22}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 158, 23, 127, 94, 248}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 175, 128}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 237}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 0}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 124, 218}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 207, 65}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 140, 132, 49, 182}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 14, 75, 140}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 67, 154, 177, 194}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 189, 46, 22, 119, 125, 80}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 252, 96, 44, 184, 244}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 234, 154, 189, 87, 126}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 147, 191}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 118, 237}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 156, 67}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 250, 123, 202, 94, 144}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 63, 126, 138, 134}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 0}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 94, 180, 58, 63, 191, 191}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 150, 70, 136, 80, 234, 153}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 30}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 51, 158, 13, 19, 250}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 136, 169, 184, 18}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 0}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 0}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 202, 11, 61, 51, 176, 77}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 16}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 129}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 204, 73, 151, 87, 101}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 126, 72, 241, 137, 1, 23}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 242, 200}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 226, 152, 91}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 45, 195}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 51, 197, 181, 44}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 113, 169, 97, 222, 90}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 207}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 217, 92}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 83, 112, 141, 194, 77}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 0}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 131, 58, 228, 14, 227}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 137, 69, 18}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 72, 172, 251}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 167, 129, 140, 212}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 29, 215}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 0}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 219, 199, 179, 157, 138, 171}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 253}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 180, 233, 27, 204}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 49, 99, 123, 47}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 166, 10, 251, 33}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 213, 202, 148, 218}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 0}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 58, 80, 60, 93, 17, 225}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 14}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 107, 25, 220, 31}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 0}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 0}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 0, 0, 0, 16}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 76, 82, 73, 146}, 155},
	{{110, 192, 255, 120, 84, 215, 3, 130, 38, 224, 0, 0, 102, 176, 41, 140}, 155},
	{{152, 79, 219, 0, 0, 208, 83, 188, 96, 181, 55, 63, 95, 37, 49, 233}, 97},
	{{152, 79, 219, 0, 86, 133, 47, 231, 225, 51, 130, 214, 70, 160, 195, 202}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 40, 191, 167, 36, 243, 171}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 155, 224, 166, 215, 41, 214, 52}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 213, 86, 132}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 153, 107, 179, 13, 120, 78, 56, 92, 47}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 139, 251}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 175, 210, 245, 224, 232, 57, 199}, 97},
	{{152, 79, 219, 0, 0, 0, 123, 43, 177, 185, 229, 84, 103, 223, 112, 42}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 156, 31, 172, 205}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 17, 213, 187, 52, 203, 143, 213}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 110, 47, 143, 49, 226, 66, 91}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 226, 233, 213, 43, 215, 250, 75, 61}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 231, 243, 146, 180, 101, 233}, 97},
	{{152, 79, 219, 0, 0, 229, 178, 229, 181, 199, 190, 253, 136, 109, 79, 151}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 150, 111, 16, 24, 13, 92, 139, 68, 109}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 98, 79, 53, 58, 220}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 248, 199, 151, 139, 39, 227, 132}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 247, 42, 17, 121, 184, 207, 32, 117, 183}, 97},
	{{152, 79, 219, 0, 0, 45, 106, 223, 114, 156, 41, 141, 12, 236, 219, 183}, 97},
	{{152, 79, 219, 0, 0, 0, 105, 202, 246, 78, 149, 84, 142, 63, 6, 166}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 93, 3, 162, 160, 217, 158, 230, 106}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 168}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 236, 157, 121, 203, 213, 154}, 97},
	{{152, 79, 219, 0, 0, 0, 54, 96, 119, 26, 156, 212, 75, 18, 36, 75}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 241}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 71, 74, 177, 241, 14, 6, 178}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 102, 58, 144, 40, 251, 24}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 222, 76, 109, 6, 22, 181, 21, 24}, 97},
	{{152, 79, 219, 0, 218, 104, 245, 140, 27, 108, 53, 53, 139, 148, 79, 214}, 97},
	{{152, 79, 219, 0, 0, 254, 17, 21, 8, 215, 126, 179, 116, 49, 228, 136}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 239}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 27, 176, 122, 58, 197, 192, 199, 3}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 148, 182}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 121, 205, 227, 102}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 120, 41, 70}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 147, 158, 212, 199, 112, 111, 209}, 97},
	{{152, 79, 219, 0, 0, 164, 93, 50, 214, 182, 102, 180, 28, 167, 139, 112}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 110, 61, 219, 48, 246, 20}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 23, 4, 175, 180, 91, 38}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 204, 244}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 126, 18, 10, 134, 88, 116, 150, 184, 146}, 97},
	{{152, 79, 219, 0, 0, 0, 97, 189, 183, 69, 19, 190, 210, 24, 75, 192}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 232, 117, 24, 37, 85}, 97},
	{{152, 79, 219, 0, 244, 117, 244, 14, 83, 58, 15, 127, 6, 178, 147, 2}, 97},
	{{152, 79, 219, 0, 0, 0, 28, 121, 233, 131, 255, 110, 97, 72, 45, 66}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 237, 44, 106, 1, 68, 177, 83, 80, 16}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 27, 62, 86, 119, 73, 55, 115, 19}, 97},
	{{152, 79, 219, 0, 0, 59, 31, 240, 208, 246, 143, 20, 63, 240, 191, 190}, 97},
	{{152, 79, 219, 0, 224, 2, 187, 230, 149, 36, 185, 157, 30, 189, 31, 176}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 119, 136, 216}, 97},
	{{152, 79, 219, 0, 219, 51, 170, 161, 28, 190, 54, 198, 165, 139, 101, 19}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 97},
	{{152, 79, 219, 0, 180, 180, 155, 35, 125, 88, 180, 254, 68, 63, 221, 190}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 116}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 248, 150, 241, 52, 59, 133}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 213, 178, 196, 15}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 126, 28, 103, 178, 192, 76, 236, 30}, 97},
	{{152, 79, 219, 0, 0, 216, 234, 178, 206, 203, 150, 117, 148, 93, 86, 178}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 67, 83, 41, 147, 206, 141}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 173, 208, 76, 96, 225, 112, 153}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 93, 224, 156}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 196}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 111, 145, 132, 211, 255}, 97},
	{{152, 79, 219, 0, 0, 0, 152, 9, 7, 178, 58, 146, 54, 206, 101, 42}, 97},
	{{152, 79, 219, 0, 190, 157, 182, 184, 87, 111, 47, 0, 202, 100, 54, 244}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 194}, 97},
	{{152, 79, 219, 0, 0, 59, 183, 74, 71, 180, 237, 232, 179, 22, 155, 224}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 172, 136, 79, 174, 250, 96}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 139, 28, 145, 209, 185, 251, 217, 150, 161}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 213, 180}, 97},
	{{152, 79, 219, 0, 112, 104, 242, 58, 152, 139, 95, 12, 35, 87, 153, 94}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 242, 200, 76, 211}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 116, 189, 111, 135, 155, 31, 245, 193, 86}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 119, 221, 251, 64, 158, 168}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 92}, 97},
	{{152, 79, 219, 0, 0, 0, 123, 64, 166, 219, 36, 239, 154, 232, 78, 113}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 251, 223, 197, 200, 188, 186, 4, 134}, 97},
	{{152, 79, 219, 0, 0, 111, 185, 13, 17, 28, 200, 200, 120, 30, 216, 142}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191}, 97},
	{{152, 79, 219, 0, 40, 135, 69, 131, 153, 48, 222, 85, 44, 104, 25, 69}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 91, 217, 249, 206, 248, 77, 92, 177, 214}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 249, 23, 117}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 234, 168, 209, 95, 70, 0, 105}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 246, 83}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 198, 192, 51, 96, 86}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 81}, 97},
	{{152, 79, 219, 0, 0, 0, 0, 0, 0, 0, 226, 117, 12, 72, 19, 153}, 97},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 82, 222, 227, 178, 82, 20, 190}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 132, 54}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 71, 183, 86, 188, 45, 224}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 130, 219, 75}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 133, 107, 60, 54, 74}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 209, 13, 217, 39, 46, 162, 240, 90}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 145, 148}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 184, 112, 74, 109, 12, 88, 233, 152, 231}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 187, 17}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 82, 243, 29, 238, 38}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 193, 201, 227, 141, 240, 203}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 49, 235, 126, 20, 206, 72, 206}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 108}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 69, 25, 162, 252, 189}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 14, 198, 144, 247, 0, 13, 170}, 8},
	{{118, 186, 157, 248, 0, 86, 183, 41, 26, 30, 170, 13, 229, 143, 62, 111}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 151}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 173, 158}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 53, 176, 167, 3, 225, 72}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 182, 141}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 58, 142, 69, 247, 83}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 198, 22, 162, 96, 226, 87, 225}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 28, 150, 57, 41, 75, 243, 240}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 218, 229, 203, 118, 0, 242}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 157}, 8},
	{{118, 186, 157, 248, 0, 0, 183, 61, 232, 87, 182, 200, 86, 68, 129, 255}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 171, 85}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 89, 233, 134, 20}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 249, 223}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 174, 165, 121, 171, 7, 231, 184, 218}, 8},
	{{118, 186, 157, 248, 0, 74, 8, 103, 189, 148, 251, 235, 43, 214, 171, 173}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 97, 73, 248, 80, 204, 181, 205, 108, 65}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 225, 142, 205, 130, 24}, 8},
	{{118, 186, 157, 248, 0, 0, 248, 62, 5, 232, 52, 54, 148, 42, 1, 0}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 133, 89, 213, 146, 59, 245, 191, 167, 219}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 57, 99, 240, 31, 54}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 177, 57, 11, 205, 103, 60, 132, 205, 238}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 233, 16, 78, 90, 80, 98, 167, 125}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 54, 101, 153, 101, 253, 152, 227, 225}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 86, 24, 139, 59, 128, 178, 198, 50}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 179}, 8},
	{{118, 186, 157, 248, 0, 1, 253, 215, 134, 136, 94, 150, 18, 114, 220, 68}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 221, 165, 137, 125, 214}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 133, 248}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 90, 95, 105, 180, 21}, 8},
	{{118, 186, 157, 248, 0, 120, 186, 217, 126, 182, 105, 146, 252, 251, 117, 248}, 8},
	{{118, 186, 157, 248, 0, 108, 135, 227, 235, 111, 249, 54, 185, 121, 82, 18}, 8},
	{{118, 186, 157, 248, 0, 58, 126, 121, 35, 205, 1, 12, 20, 151, 200, 23}, 8},
	{{118, 186, 157, 248, 0, 0, 111, 144, 231, 93, 123, 226, 184, 188, 3, 26}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 86, 118, 253}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 88, 93, 211}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 152}, 8},
	{{118, 186, 157, 248, 0, 127, 179, 200, 153, 197, 60, 217, 29, 125, 144, 158}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 85, 142, 235, 83, 12, 39, 124}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 74, 240, 147, 93, 253, 203}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 71, 213, 60, 85, 34}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 126, 139}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 23, 198, 96, 25, 69, 52, 235, 45}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 92, 15, 76, 147}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 8},
	{{118, 186, 157, 248, 0, 141, 225, 194, 98, 89, 54, 189, 32, 42, 220, 251}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 108, 119}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 193, 162, 77, 113, 94, 7, 202}, 8},
	{{118, 186, 157, 248, 0, 9, 6, 194, 139, 159, 83, 48, 225, 220, 49, 232}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 170, 99, 103, 235, 228}, 8},
	{{118, 186, 157, 248, 0, 177, 19, 61, 123, 97, 108, 220, 96, 24, 1, 206}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 86, 138, 65, 177, 222, 224}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 220, 112, 2, 23, 176, 92, 35, 9}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 242, 21, 37, 199, 139, 177, 201}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 213, 86, 169}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 42, 234, 158, 15, 132}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 2, 83, 108, 239, 38, 246, 172, 198, 72}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 8},
	{{118, 186, 157, 248, 0, 0, 140, 128, 190, 176, 93, 248, 4, 166, 99, 85}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 65, 12, 111, 8}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 243, 117, 232}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 230, 10, 125, 131, 3, 237, 74, 132, 85}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 227}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 207, 211, 145, 254}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 69, 206, 240, 243}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 103, 137, 194}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 133, 80, 49, 173}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 215, 171, 79, 45, 235, 234}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 166, 58, 127, 223, 35, 126, 20}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 30, 178, 247, 177}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 245}, 8},
	{{118, 186, 157, 248, 0, 110, 242, 102, 22, 164, 136, 88, 40, 131, 81, 120}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 8, 107, 113, 201, 0}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 204, 164, 113}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 162, 23, 211, 0, 224, 81, 31, 36}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 91, 241, 251, 187, 197, 155, 240, 39, 216}, 8},
	{{118, 186, 157, 248, 0, 232, 144, 136, 230, 239, 197, 58, 54, 62, 170, 139}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 59, 254, 78, 244, 90, 51}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 182}, 8},
	{{118, 186, 157, 248, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 238, 184}, 8},
	{{118, 186, 157, 248, 0, 0, 47, 39, 73, 171, 99, 158, 116, 174, 233, 233}, 8},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 26, 94, 221}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 128, 162, 207, 209, 113, 22, 97, 95, 0}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 96, 34, 133, 119, 20, 35, 161}, 123},
	{{70, 128, 0, 0, 0, 222, 14, 236, 201, 171, 208, 181, 97, 175, 147, 234}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 60, 32, 203, 41, 89, 102, 48}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 251, 194, 255, 235, 255, 183, 159, 192}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 226, 124, 255, 1, 160, 202, 136}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 238, 123, 80}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 43, 21, 234, 41, 140, 199}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 17}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206, 253, 100, 10, 194}, 123},
	{{70, 128, 0, 0, 0, 209, 74, 140, 214, 70, 119, 70, 138, 66, 0, 164}, 123},
	{{70, 128, 0, 178, 152, 16, 64, 130, 211, 206, 93, 196, 151, 70, 75, 56}, 123},
	{{70, 128, 0, 0, 175, 23, 150, 33, 144, 94, 108, 52, 90, 205, 139, 144}, 123},
	{{70, 128, 28, 201, 85, 103, 58, 50, 130, 241, 128, 112, 219, 123, 219, 205}, 123},
	{{70, 128, 0, 0, 0, 42, 51, 192, 21, 194, 125, 236, 112, 146, 108, 44}, 123},
	{{70, 128, 0, 0, 204, 195, 120, 74, 125, 226, 245, 91, 238, 67, 6, 23}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40, 161, 244, 128, 119}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 63, 173, 195, 105, 155, 5, 6, 85}, 123},
	{{70, 128, 0, 0, 0, 11, 215, 17, 237, 121, 149, 17, 109, 22, 15, 60}, 123},
	{{70, 128, 0, 0, 0, 0, 144, 14, 21, 207, 68, 77, 139, 44, 247, 211}, 123},
	{{70, 128, 0, 0, 0, 0, 131, 197, 249, 242, 61, 196, 192, 127, 105, 97}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 123},
	{{70, 128, 0, 14, 236, 113, 29, 183, 76, 157, 5, 67, 98, 161, 12, 100}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 67, 246, 86, 92, 232, 36, 171, 89, 202}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 196, 181, 248}, 123},
	{{70, 128, 0, 0, 0, 0, 101, 6, 222, 17, 220, 184, 146, 81, 74, 130}, 123},
	{{70, 128, 0, 0, 0, 245, 145, 44, 249, 85, 168, 4, 252, 205, 170, 169}, 123},
	{{70, 128, 0, 0, 0, 173, 87, 80, 131, 66, 169, 68, 159, 153, 227, 239}, 123},
	{{70, 128, 0, 12, 15, 111, 1, 105, 149, 185, 169, 65, 82, 33, 76, 73}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 54, 252, 237, 4, 158, 69, 12}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 152, 70, 178, 152, 49, 145, 87}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 12, 0, 237, 193, 212, 242, 119, 248}, 123},
	{{70, 128, 0, 0, 242, 182, 30, 155, 128, 39, 242, 223, 206, 53, 136, 6}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 151, 45, 183}, 123},
	{{70, 128, 0, 0, 0, 0, 142, 153, 48, 181, 104, 136, 111, 239, 119, 238}, 123},
	{{70, 128, 0, 0, 0, 0, 186, 26, 108, 94, 147, 160, 117, 65, 49, 100}, 123},
	{{70, 128, 0, 0, 0, 50, 49, 69, 61, 64, 161, 113, 76, 205, 96, 23}, 123},
	{{70, 128, 0, 0, 0, 255, 239, 168, 254, 98, 61, 182, 70, 17, 124, 167}, 123},
	{{70, 128, 69, 97, 171, 66, 181, 10, 59, 36, 38, 66, 5, 53, 41, 63}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 163, 84}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 227, 126, 72, 27, 34}, 123},
	{{70, 128, 0, 0, 70, 141, 78, 39, 172, 185, 155, 166, 122, 165, 53, 114}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 170, 142, 158, 156, 147, 61}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 221, 94, 135, 25, 20, 233, 195, 151}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 160, 223, 230, 27}, 123},
	{{70, 128, 0, 0, 0, 0, 55, 193, 189, 23, 58, 255, 241, 109, 252, 61}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 90, 92, 27, 220, 148, 141, 196, 3, 55}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 28, 160}, 123},
	{{70, 128, 0, 22, 146, 90, 209, 10, 135, 163, 54, 139, 240, 198, 237, 246}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 235, 186, 188, 34, 49, 23}, 123},
	{{70, 128, 0, 0, 0, 108, 151, 147, 165, 89, 75, 173, 156, 148, 192, 35}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 251, 240, 158, 182, 117, 120, 119, 104, 156}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 223, 79, 11, 226, 105, 202}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 214, 244, 214, 85, 0, 234, 5}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 212, 68, 118, 10, 191, 28}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 109, 9, 52, 229, 215, 233, 233, 100}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 149, 16, 24, 66, 17, 95}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 211, 168, 163}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 123},
	{{70, 128, 0, 0, 0, 6, 156, 198, 206, 163, 44, 70, 181, 184, 3, 171}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 181, 136, 235}, 123},
	{{70, 128, 0, 34, 216, 175, 173, 235, 244, 42, 62, 74, 169, 139, 186, 1}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 111, 12, 154, 157, 175, 10, 172, 102}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 146, 128, 1, 218, 39}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 210, 154, 119, 82, 55, 177, 229}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 155, 147, 234, 245, 131, 81}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 49}, 123},
	{{70, 128, 0, 0, 0, 0, 85, 213, 226, 71, 155, 89, 81, 193, 229, 95}, 123},
	{{70, 128, 36, 114, 112, 189, 159, 85, 68, 194, 101, 204, 63, 64, 155, 89}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 82, 84, 21, 13, 223, 105, 159, 100}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 24, 156, 147, 248, 31, 185, 137}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 189, 1}, 123},
	{{70, 128, 0, 0, 0, 100, 226, 245, 223, 167, 116, 170, 235, 177, 9, 73}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 123},
	{{70, 128, 0, 0, 0, 0, 188, 35, 32, 191, 127, 27, 111, 180, 7, 139}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 240, 181, 203}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 93, 142}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 160, 124, 212}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 109, 23, 212, 235, 147, 79}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 159, 229, 183, 58, 65, 66, 205, 230}, 123},
	{{70, 128, 0, 0, 0, 124, 182, 25, 130, 134, 220, 27, 218, 232, 28, 152}, 123},
	{{70, 128, 0, 0, 45, 250, 51, 228, 121, 236, 184, 124, 0, 182, 241, 111}, 123},
	{{70, 128, 0, 0, 36, 205, 9, 71, 193, 70, 188, 226, 207, 19, 211, 88}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 166, 186, 121}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 196, 51}, 123},
	{{70, 128, 0, 0, 0, 0, 160, 98, 250, 126, 170, 3, 155, 50, 247, 243}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 4, 92, 173, 130, 142, 243}, 123},
	{{70, 128, 0, 0, 49, 149, 220, 51, 237, 113, 146, 189, 9, 210, 166, 9}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 241, 100, 3, 64}, 123},
	{{70, 128, 130, 179, 96, 32, 179, 5, 115, 61, 51, 14, 219, 144, 28, 13}, 123},
	{{70, 128, 0, 252, 196, 253, 7, 151, 106, 96, 120, 217, 79, 59, 28, 18}, 123},
	{{70, 128, 0, 0, 0, 91, 170, 244, 233, 43, 241, 184, 33, 68, 116, 138}, 123},
	{{70, 128, 0, 199, 149, 58, 32, 6, 86, 21, 229, 200, 149, 167, 132, 138}, 123},
	{{70, 128, 0, 0, 0, 0, 0, 0, 131, 42, 58, 141, 215, 53, 107, 117}, 123},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 41}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 164, 50, 229}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 63}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 122, 165, 8, 212}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 74, 64, 71}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 67, 82, 135}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 50, 140}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 4}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 77}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 72, 25}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 184, 166}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 8, 37, 183, 186}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 50, 153, 47}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 53, 189, 195, 152}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 56}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 62, 15, 131}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 134, 220}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 67, 169, 96, 209}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 156, 27}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 168}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 250, 79}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 5}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 19, 212}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 95}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 39}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 42, 107, 111, 206}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 106, 186, 69, 122}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 199, 224}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 159}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 129, 138, 64, 167}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 82}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 80}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 107, 155, 161}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 206}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 122, 105, 164, 219}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 12, 173, 157, 9}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 165, 27}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 243, 156, 116}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 143, 113}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 192}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 181, 51}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 99, 217, 78}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 13, 28}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 70}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 184, 30, 132}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 219, 114, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 121, 215, 156, 185}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 171, 27, 169}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 126, 95, 126}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 66}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 219, 89}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 117, 131}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 211, 243, 66}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 191}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 146}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 241, 95}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 17}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 90}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 177}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 144}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 127, 87}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 2, 47, 62}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 37, 43, 89}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 50, 226, 102}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 117}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 36, 238}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 112}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 48, 109}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 36}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 126}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 105}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 143, 247}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 53}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 71, 19, 75}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 212, 98, 2}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 89, 240}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 0, 0}, 11},
	{{253, 119, 114, 227, 18, 243, 81, 61, 238, 107, 190, 144, 0, 0, 224, 116}, 11},
	{{166, 112, 0, 190, 25, 219, 187, 102, 1, 20, 198, 20, 249, 174, 23, 231}, 211},
	{{166, 112, 0, 0, 0, 26, 149, 172, 231, 217, 23, 103, 106, 23, 201, 71}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, 108}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 232, 67, 225}, 211},
	{{166, 112, 0, 0, 223, 83, 171, 151, 74, 177, 6, 37, 219, 69, 233, 89}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 99, 172, 97, 16, 56, 254}, 211},
	{{166, 112, 251, 98, 181, 225, 36, 127, 73, 56, 209, 248, 89, 88, 56, 232}, 211},
	{{166, 112, 0, 0, 155, 125, 94, 147, 14, 171, 60, 115, 189, 236, 170, 37}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 17, 186, 4, 170, 165, 5, 195, 236, 113}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 229, 99}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 4, 155, 138, 214, 36, 100, 218, 159, 62}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 255, 246, 113, 11, 169, 196, 183, 16, 82}, 211},
	{{166, 112, 0, 0, 0, 0, 182, 201, 231, 123, 201, 59, 194, 111, 196, 36}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 5, 16, 86, 246, 155, 190, 226}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 199, 202, 107, 206, 79}, 211},
	{{166, 112, 0, 0, 0, 0, 109, 72, 212, 197, 239, 205, 226, 255, 171, 206}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 156}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 158, 110}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 120, 94, 219, 65, 229, 115, 224}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 204, 153}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 245, 35, 77, 39, 53, 110, 241}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 87}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 157, 42, 85, 80, 45}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 183, 191}, 211},
	{{166, 112, 117, 222, 211, 118, 157, 76, 25, 57, 131, 235, 241, 64, 153, 93}, 211},
	{{166, 112, 0, 188, 14, 166, 43, 100, 147, 185, 88, 216, 19, 60, 255, 27}, 211},
	{{166, 112, 0, 0, 0, 52, 205, 96, 67, 187, 91, 251, 14, 146, 49, 184}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 74, 252, 104, 145, 82, 15, 10, 165, 63}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 142, 15, 77, 99, 83, 5}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 160, 100, 49, 65}, 211},
	{{166, 112, 0, 0, 0, 0, 248, 95, 47, 30, 133, 176, 232, 103, 100, 249}, 211},
	{{166, 112, 0, 0, 0, 0, 145, 26, 126, 199, 212, 212, 49, 56, 201, 59}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 114, 53, 203, 79, 128, 251}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 232, 160, 102, 226, 6, 22, 90, 130, 104}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 161, 158, 42, 226, 127}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 241}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 86, 114, 110, 8}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 80, 217, 190, 2, 224, 155, 173}, 211},
	{{166, 112, 0, 0, 124, 110, 152, 102, 80, 47, 177, 54, 19, 45, 181, 82}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 83, 42, 67, 135, 11}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 178, 195, 123, 142, 106}, 211},
	{{166, 112, 0, 223, 83, 153, 34, 10, 138, 243, 3, 107, 166, 34, 106, 38}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 39, 31, 238, 172}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 192, 216, 79, 227, 79, 224, 10, 147, 116}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 54, 186, 153, 48, 62}, 211},
	{{166, 112, 0, 0, 0, 0, 181, 36, 208, 169, 208, 11, 199, 154, 7, 147}, 211},
	{{166, 112, 0, 0, 0, 49, 69, 200, 203, 57, 181, 36, 155, 151, 68, 171}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 254, 26, 98, 191}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 102, 223, 107, 250}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 104}, 211},
	{{166, 112, 0, 0, 0, 197, 59, 20, 247, 70, 201, 193, 9, 222, 155, 60}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 117, 105, 193, 168, 19, 113, 34}, 211},
	{{166, 112, 0, 0, 0, 0, 119, 159, 4, 228, 81, 3, 223, 111, 112, 246}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 219, 35, 91, 126, 119}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 186, 116, 231, 255, 30, 168, 110}, 211},
	{{166, 112, 0, 0, 169, 192, 89, 202, 9, 172, 152, 16, 126, 232, 18, 34}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 46, 110, 7, 212}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{166, 112, 0, 0, 0, 0, 205, 115, 54, 127, 211, 59, 237, 187, 31, 225}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 185, 74, 104}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 245, 233, 153, 86, 162}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 62, 131, 195, 140, 119, 146, 18}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 60, 111, 201, 219, 120, 110}, 211},
	{{166, 112, 221, 51, 5, 181, 16, 89, 16, 110, 223, 189, 124, 1, 243, 100}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 117, 5, 201, 249, 194}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 148, 182}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 140, 181, 40}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 24, 60, 124, 120, 193, 232}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 25, 179, 90, 55, 109, 247}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 27, 135, 100, 201, 227, 165}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 59}, 211},
	{{166, 112, 0, 0, 0, 81, 20, 100, 163, 154, 205, 96, 183, 228, 246, 115}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 254, 48}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 238, 151}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 121}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 108}, 211},
	{{166, 112, 0, 105, 52, 149, 99, 246, 131, 46, 223, 109, 76, 168, 4, 183}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 87, 66, 170, 228, 32, 6}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 38, 184, 208, 234, 85, 120, 58, 135, 125}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 10, 2, 99, 110, 190, 166, 24, 98}, 211},
	{{166, 112, 0, 243, 253, 123, 2, 4, 142, 28, 20, 49, 30, 142, 82, 49}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 232, 23, 240, 154, 214, 81, 95}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 32, 99, 88, 237, 67, 185, 47, 101, 190}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 98, 223, 108, 45}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 220, 245, 132}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 224, 8, 178, 218, 122, 214, 108, 90, 57}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 145, 138, 248, 146, 185, 208, 150}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 216}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 9, 125, 148}, 211},
	{{166, 112, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{43, 95, 224, 0, 186, 235, 217, 42, 160, 69, 219, 155, 93, 209, 163, 175}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 231, 124, 215, 178, 244, 97}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 116},
	{{43, 95, 224, 0, 0, 0, 174, 4, 109, 203, 209, 132, 128, 129, 172, 162}, 116},
	{{43, 95, 224, 0, 0, 0, 183, 81, 118, 30, 40, 141, 221, 103, 148, 223}, 116},
	{{43, 95, 224, 0, 0, 0, 65, 82, 102, 236, 221, 45, 157, 74, 148, 104}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 241}, 116},
	{{43, 95, 224, 0, 94, 176, 48, 101, 185, 96, 57, 109, 67, 30, 3, 76}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 147, 45}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 207, 246, 194, 245}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 83, 59, 100, 112, 255, 109, 206}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 100, 84, 170, 39, 92}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 175}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 199, 235}, 116},
	{{43, 95, 224, 0, 84, 205, 85, 41, 51, 212, 43, 213, 113, 226, 156, 170}, 116},
	{{43, 95, 224, 0, 50, 140, 108, 38, 24, 206, 159, 126, 16, 121, 66, 85}, 116},
	{{43, 95, 224, 204, 234, 128, 248, 83, 242, 203, 231, 216, 142, 123, 32, 228}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 33, 201, 230, 1, 109, 28, 162}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 101, 83, 106, 159, 147}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 138, 158, 113, 3, 149}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 222}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 63, 161, 155, 221, 77, 11}, 116},
	{{43, 95, 224, 0, 0, 0, 154, 228, 149, 116, 76, 232, 73, 204, 232, 158}, 116},
	{{43, 95, 224, 0, 0, 70, 2, 220, 17, 179, 137, 122, 249, 72, 82, 166}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 144, 155, 89, 239}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 251, 249, 1}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 47, 155, 166, 227, 147, 135, 221, 15}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57, 246, 146}, 116},
	{{43, 95, 224, 0, 79, 152, 19, 161, 202, 162, 13, 178, 80, 149, 55, 51}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 237, 16, 89, 161, 237, 144}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 64, 240, 242, 112, 20, 136}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 61}, 116},
	{{43, 95, 224, 0, 0, 149, 122, 157, 98, 57, 64, 142, 217, 191, 115, 55}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 199, 44, 75}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 230, 136, 254}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 219, 102, 216, 185, 153, 43}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 3, 109, 213, 239, 177, 233}, 116},
	{{43, 95, 224, 0, 0, 0, 110, 89, 253, 39, 21, 200, 213, 16, 243, 24}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 230, 153, 36, 130, 18, 184, 102}, 116},
	{{43, 95, 224, 0, 0, 229, 248, 74, 52, 115, 176, 82, 211, 236, 198, 37}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 180, 133, 215, 73}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 91, 242, 21, 145, 39, 30, 57, 254, 144}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 116},
	{{43, 95, 224, 0, 0, 0, 232, 146, 101, 6, 228, 154, 113, 253, 51, 183}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 116},
	{{43, 95, 224, 0, 0, 129, 78, 49, 74, 26, 31, 232, 199, 110, 149, 99}, 116},
	{{43, 95, 224, 0, 59, 107, 143, 254, 40, 214, 163, 9, 177, 103, 167, 212}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 31, 251, 63, 153, 143}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 61, 143, 189}, 116},
	{{43, 95, 224, 0, 49, 231, 173, 119, 192, 239, 236, 70, 67, 91, 254, 246}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 222, 135, 30, 37, 59}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 170, 190, 150, 191}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 115, 157, 138}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 246, 83, 94, 22, 110}, 116},
	{{43, 95, 224, 0, 17, 54, 112, 187, 164, 198, 165, 216, 236, 139, 214, 169}, 116},
	{{43, 95, 224, 203, 30, 87, 207, 20, 113, 36, 250, 57, 228, 147, 213, 171}, 116},
	{{43, 95, 224, 0, 2, 229, 57, 221, 122, 230, 142, 165, 182, 169, 227, 2}, 116},
	{{43, 95, 224, 0, 93, 17, 21, 187, 3, 130, 28, 44, 36, 116, 180, 175}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 253, 34, 163, 12}, 116},
	{{43, 95, 224, 0, 0, 0, 19, 203, 111, 81, 7, 112, 130, 158, 233, 67}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 220, 195}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 69, 136}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 137, 138}, 116},
	{{43, 95, 224, 0, 0, 128, 217, 201, 99, 177, 1, 63, 47, 22, 170, 229}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 155, 210, 153, 12, 240, 46, 46, 21, 34}, 116},
	{{43, 95, 224, 85, 50, 51, 150, 54, 171, 165, 12, 255, 210, 170, 25, 140}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 35, 109, 165, 153, 213, 193, 154, 38}, 116},
	{{43, 95, 224, 187, 47, 16, 66, 232, 172, 167, 35, 145, 233, 238, 1, 164}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 140, 84, 236, 224, 232, 84}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 199, 89, 241, 94, 144, 154, 31, 122, 140}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 44, 42, 195, 137}, 116},
	{{43, 95, 224, 0, 0, 251, 251, 143, 174, 206, 155, 169, 145, 91, 28, 80}, 116},
	{{43, 95, 224, 0, 0, 106, 167, 73, 175, 43, 36, 125, 40, 160, 118, 82}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 183, 151, 66, 62, 223}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 124, 183, 17}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 146, 27, 233, 156, 235, 7, 187}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 88}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 82}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 59, 20, 244}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 157, 130, 49, 174, 241, 205, 14, 208}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 47, 201, 156, 0, 224, 96, 135}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 199, 90, 227, 153, 37}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 27, 108}, 116},
	{{43, 95, 224, 157, 163, 245, 141, 37, 97, 76, 126, 223, 17, 79, 26, 241}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 227, 108}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91, 50, 76}, 116},
	{{43, 95, 224, 0, 0, 0, 104, 94, 124, 244, 79, 159, 199, 70, 228, 252}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 194, 106, 209}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 96, 76, 31, 217}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 29, 180, 114, 135, 116, 78, 40, 195}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 0, 236, 102, 157, 38, 124, 73, 149, 127}, 116},
	{{43, 95, 224, 0, 0, 0, 0, 40, 116, 43, 160, 242, 215, 17, 85, 234}, 116},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 34, 41, 247}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4}, 57},
	{{94, 128, 0, 0, 0, 0, 144, 229, 92, 66, 45, 124, 193, 59, 19, 75}, 57},
	{{94, 128, 0, 116, 105, 185, 240, 49, 241, 238, 249, 15, 218, 37, 218, 189}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72, 181, 155, 80, 6}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 36, 8, 191}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 6, 93, 162, 70, 41, 131, 102, 168}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 102, 242}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 73, 232, 220, 10, 218, 142, 74, 159, 114}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 121, 59, 242, 191, 126, 92, 71}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 168, 117, 244, 14}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 223, 67, 125, 31, 134, 42, 228, 140}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135, 130, 253, 165, 232}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 57},
	{{94, 128, 0, 0, 0, 174, 37, 227, 218, 13, 254, 33, 181, 176, 36, 178}, 57},
	{{94, 128, 0, 0, 36, 238, 17, 199, 230, 160, 125, 77, 214, 102, 56, 209}, 57},
	{{94, 128, 0, 0, 0, 23, 177, 92, 130, 8, 109, 192, 155, 7, 152, 8}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 136, 108, 198}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 190, 115, 66, 25, 241, 132, 185, 15, 87}, 57},
	{{94, 128, 0, 0, 28, 29, 57, 235, 136, 233, 107, 163, 167, 89, 108, 155}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 96}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 184}, 57},
	{{94, 128, 0, 0, 0, 0, 230, 198, 51, 88, 102, 229, 33, 84, 128, 66}, 57},
	{{94, 128, 0, 0, 238, 254, 36, 230, 62, 52, 144, 136, 158, 77, 13, 190}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 9, 92, 118, 55, 147, 54, 203, 73, 62}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 57},
	{{94, 128, 0, 0, 0, 0, 15, 149, 166, 149, 197, 131, 78, 68, 171, 165}, 57},
	{{94, 128, 0, 211, 89, 38, 56, 21, 128, 26, 18, 60, 213, 113, 241, 83}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 131, 197, 66, 87, 46, 197}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 23, 114, 199, 186}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 89, 184, 134, 100, 248, 12, 78, 109, 121}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 250, 59, 140, 48, 54, 198}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 233, 245, 255, 218}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 226}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 182, 65, 233, 145, 209, 210, 134, 56}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 57},
	{{94, 128, 0, 0, 0, 63, 121, 164, 192, 187, 171, 58, 190, 212, 67, 222}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 197, 238, 0, 55, 53, 81, 184, 185}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 191, 210, 137, 60}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 162, 144, 178, 21, 226, 63, 152, 195}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 204, 231, 207}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 172, 30, 236, 153, 90}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 196, 167, 206, 176, 26, 237}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28, 159, 5}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 201, 63}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 241, 176, 149, 40, 156, 10}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 14, 89, 166, 139, 219, 65, 188, 133}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 200, 255, 206, 3}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 123, 87}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 92, 155}, 57},
	{{94, 128, 103, 246, 140, 201, 218, 30, 2, 61, 214, 51, 248, 10, 165, 62}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 121}, 57},
	{{94, 128, 0, 0, 0, 0, 55, 101, 9, 93, 45, 124, 62, 221, 21, 172}, 57},
	{{94, 128, 0, 0, 182, 25, 190, 224, 76, 36, 212, 40, 174, 188, 193, 12}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 138, 26, 57, 32, 187, 204, 53, 63, 226}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 9, 74, 134, 16}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 34, 95, 191, 61, 251, 236, 67}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 71, 136}, 57},
	{{94, 128, 0, 91, 69, 22, 228, 37, 185, 35, 1, 186, 212, 90, 29, 21}, 57},
	{{94, 128, 0, 0, 147, 122, 61, 151, 9, 177, 217, 101, 182, 211, 159, 184}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 255, 155, 176, 230, 74, 166, 161, 187, 61}, 57},
	{{94, 128, 0, 0, 0, 0, 7, 141, 74, 190, 207, 55, 219, 225, 93, 88}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10, 236, 166}, 57},
	{{94, 128, 0, 0, 0, 0, 88, 192, 48, 55, 194, 72, 155, 7, 177, 231}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 70}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 195}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 47, 33, 188, 187, 40, 117, 182, 70}, 57},
	{{94, 128, 0, 0, 0, 0, 212, 77, 28, 226, 165, 115, 199, 120, 237, 109}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 126, 255, 94, 17, 25, 242}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 141, 148, 85, 89, 229}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90, 158, 16}, 57},
	{{94, 128, 0, 251, 144, 212, 27, 183, 1, 138, 233, 230, 10, 105, 85, 91}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 220}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 143}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 162, 96, 248, 101, 19, 154, 32}, 57},
	{{94, 128, 0, 0, 77, 115, 3, 224, 55, 202, 223, 16, 189, 61, 182, 160}, 57},
	{{94, 128, 0, 0, 107, 8, 182, 54, 0, 16, 26, 224, 238, 151, 177, 181}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 204}, 57},
	{{94, 128, 0, 0, 0, 175, 232, 29, 206, 234, 27, 50, 142, 170, 194, 173}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 165, 38, 86, 79, 134}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 228, 39, 216, 70, 26, 127, 237}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 142, 23, 184, 80, 32, 14, 117, 254}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 81}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 135, 29, 249, 212, 43, 47, 166, 236, 156}, 57},
	{{94, 128, 0, 57, 216, 160, 34, 162, 188, 121, 140, 127, 172, 224, 67, 226}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 178}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 104, 13, 144, 123, 168, 13, 132, 17}, 57},
	{{94, 128, 0, 0, 0, 87, 40, 253, 246, 210, 81, 45, 131, 18, 232, 175}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 211, 183, 119}, 57},
	{{94, 128, 0, 0, 177, 165, 178, 131, 178, 207, 45, 130, 177, 219, 119, 245}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 95, 220, 250}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 64, 59, 152, 39, 10, 8}, 57},
	{{94, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 188, 171}, 57},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 69}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 196}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 205}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 233, 133}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 101}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 149, 231}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 253}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 33}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 180}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 182}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 66, 89}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 66, 52}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 217}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 88}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 245}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 212}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 107}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 92}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 10}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 232}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 62, 102}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 255}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 67}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 145}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 122, 29}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 214}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 120, 242}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 110}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 152}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 187}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 107}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 214, 171}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 97}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 168}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 60, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 141}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 208, 121}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 46}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 32}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 75, 208}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 60}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 65, 45}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 94, 93}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 214}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 104}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 119}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 217}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 97, 200}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 47}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 139, 159}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 100, 17}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 24}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 181, 225}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 205}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 142}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 21}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 31, 139}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 0}, 178},
	{{182, 251, 195, 132, 66, 7, 208, 146, 223, 231, 211, 181, 25, 176, 0, 218}, 178},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 106, 198}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 45, 255}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 106, 161}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 63, 86}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 230}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 127, 178}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 60, 208}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 171}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 147}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 199}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 188, 61}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 216, 110}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 8}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 159, 49}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 247, 12}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 84, 138}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 194}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 191}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 62}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 107}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 9}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 16}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 59, 47}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 7, 72, 119}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 3, 163}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 237, 30}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 212, 51}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 110}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 171, 146, 68}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 88, 212, 127}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 51, 174}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 245, 0, 194}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 30, 233}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 19, 189}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 254, 20, 236}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 54, 154, 48}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 145}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 131, 158}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 214}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 170, 204}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 141}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 29}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 84}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 224, 186}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 180}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 124}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 152, 72}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 218}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 21, 19}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 193}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 154}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 184, 143}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 86, 158}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 10, 56}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 245, 82}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 16}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 71, 203}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 159}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 64}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 59, 91}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 141}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 0, 0}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 42, 152}, 93},
	{{152, 166, 111, 233, 194, 17, 230, 41, 221, 253, 69, 123, 108, 0, 55, 107}, 93},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 109, 89, 5}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 92, 125}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 138, 158, 217, 32}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 140, 54}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 189, 210, 124}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 215, 151}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 207, 96}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 112, 192, 177, 29}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 93, 224, 203}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 133, 130, 173, 189}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 142, 216, 122}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 186, 85, 140}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 254, 229, 240, 107}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 238, 65, 120}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 181, 83, 229}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 185, 30}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 51, 56}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 236}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 118}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 44, 243, 143, 242}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 138, 144, 78, 13}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 190, 197, 47}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 182, 13}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 39, 165}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 110, 197, 82, 248}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 241, 31}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 30, 62, 119, 130}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 60}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 21}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 12, 59, 78}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 240, 204, 115}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 64, 4, 215}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 227, 39}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 65, 226}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 149}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 69}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 156, 119, 238, 106}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 180, 196, 122}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 231}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 123}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 206, 247, 238}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 15}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 110, 69}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 201, 42, 76}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 156}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 175}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 252}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 19, 26, 213, 176}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 119, 155, 56}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 145, 119, 54}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 139, 11, 224}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 89, 37, 148, 164}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 184, 123}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 115, 150, 248}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 188}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 182}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 221, 80}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 253, 253}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 137, 45, 189}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 228}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 48, 254, 46, 208}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 109, 138, 226}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 102, 187, 182}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 61, 37}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 50}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 183, 59, 254}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 50, 252}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 196, 80}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 93, 74}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 57, 56}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 135, 18, 111}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 89, 203, 238, 57}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 236, 119}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 240, 65, 10}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 244}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 133}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 161, 225}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 100, 107, 2}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 82}, 3},
	{{106, 141, 235, 190, 82, 241, 152, 186, 195, 81, 86, 144, 0, 0, 0, 0}, 3},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{32, 81, 210, 153, 151, 29, 11, 62, 127, 177, 194, 254, 103, 83, 58, 128}, 162},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 160, 142}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 251, 194}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 196, 188}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 237}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 241}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 173}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 84, 90}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 86, 139}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 83}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 5}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 225}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 248}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 150}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 181}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 47}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 129}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 158}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 231}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 190}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 244, 144}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 17, 74}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 59, 34}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 68}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 159, 252}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 20}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 225}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 164}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 54}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 126}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 104}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 228}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 189}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 250, 160}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 252}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 60}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 145}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 76}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 80, 181}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 158}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 162}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 27}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 100, 88}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 20}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 189}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 217}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 107}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 135}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 160}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 36}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 23}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 145, 174}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 208}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 176}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 235}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 0, 0}, 125},
	{{79, 112, 224, 26, 174, 39, 98, 181, 115, 57, 209, 189, 136, 48, 196, 189}, 125},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 107}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 21, 186, 154, 209, 54, 75, 167}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 25, 119, 116, 142, 51, 124}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 251, 92, 240, 64, 49}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 16, 187, 186, 210, 226, 152, 166}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 191, 149, 31, 206, 165, 131}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 116, 13, 84, 159}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 90, 54, 134, 34, 212}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 142}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 214, 74, 132, 47, 215}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 68, 47, 242, 131, 43, 255, 233, 146, 173}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 235, 218, 3, 134, 81, 212, 9}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 88, 178, 219, 53, 136}, 33},
	{{106, 197, 83, 151, 64, 0, 71, 64, 93, 203, 238, 143, 159, 184, 224, 111}, 33},
	{{106, 197, 83, 151, 64, 4, 109, 151, 90, 97, 9, 229, 93, 118, 129, 234}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 64, 249}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 177, 177}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90, 33}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 216, 222}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 112, 82}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 255, 172, 226, 161, 126, 96, 141, 237}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 176, 108}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 66, 53, 229, 112, 227, 94}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 152, 195, 0, 249, 199, 176, 245, 189, 106}, 33},
	{{106, 197, 83, 151, 64, 92, 87, 239, 8, 246, 122, 115, 65, 197, 206, 185}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 117, 24, 236, 80, 209, 253}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 13, 23, 191, 229, 40, 232, 53}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 46, 109}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 145, 11, 172, 98, 20}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 28, 97, 17, 95, 194, 139}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 71, 41, 168, 222, 9, 252}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 57, 108, 111, 227, 194}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 3, 36, 173}, 33},
	{{106, 197, 83, 151, 64, 0, 254, 11, 83, 111, 156, 247, 112, 180, 55, 84}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 70, 64, 131, 127, 80, 132, 174, 179}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 21, 83, 177, 218, 145, 16, 39, 220, 125}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 204, 131, 120, 43, 212}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 30, 196, 227, 86, 134, 99}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 102, 92, 10, 93, 122, 55}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33},
	{{106, 197, 83, 151, 64, 0, 161, 63, 63, 96, 110, 95, 101, 145, 197, 168}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 35, 223, 198, 141, 63, 233}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 105, 220}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 213, 72, 60, 60, 239, 98, 187}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 29, 146, 48, 214, 139, 51, 52}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 19, 17, 56, 164, 140, 221, 237, 22}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 75, 170, 164, 42, 87, 70, 2, 211}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 179, 221}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 8}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 108, 92, 126, 8}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 77, 213, 171, 183, 182, 39}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 129, 68, 44, 252, 35, 249, 214}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 146, 49}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 124, 195, 208, 59}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 108, 204, 162, 86, 244, 246, 112, 238, 77}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 136, 193, 111, 117, 254, 118, 32, 22, 169}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 52, 171, 248, 90, 151, 81, 1, 23}, 33},
	{{106, 197, 83, 151, 64, 248, 132, 46, 141, 72, 230, 115, 40, 29, 138, 77}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 34}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 125, 106, 76}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 150, 24}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 89}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 167, 218, 95, 38, 110}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 222}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 48, 0, 253, 115, 226}, 33},
	{{106, 197, 83, 151, 64, 0, 184, 197, 109, 46, 16, 16, 219, 251, 99, 201}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 73, 30, 194}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 109, 242, 83, 53}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 144, 188, 71}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 168, 239, 55, 240, 4}, 33},
	{{106, 197, 83, 151, 64, 0, 165, 199, 252, 39, 68, 147, 223, 11, 212, 44}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 93}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 47, 90, 47, 119, 104}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 231, 33, 67, 218, 121, 137, 182, 50, 98}, 33},
	{{106, 197, 83, 151, 64, 35, 51, 94, 210, 97, 114, 175, 18, 182, 67, 140}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 170}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 106}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 38, 80, 64, 204, 128, 207, 160, 156, 34}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 178, 63, 227, 9}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 153, 75, 214, 201, 19, 70}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 50, 131, 128, 14, 63}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 198, 179, 70, 185, 52, 18, 136, 134}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 181, 104, 88, 125, 35, 20, 226, 227, 235}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 144, 184, 89}, 33},
	{{106, 197, 83, 151, 64, 0, 139, 15, 164, 17, 2, 98, 159, 28, 142, 40}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 125, 26}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 249, 54, 157, 211}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 38, 169, 189}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 221, 14, 78, 171, 178, 158, 100, 144, 222}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 41, 120, 138, 157, 111, 221, 89, 35}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 164, 34, 122, 16, 246, 145, 205, 90}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 33},
	{{106, 197, 83, 151, 64, 0, 0, 120, 227, 26, 93, 106, 225, 135, 173, 170}, 33},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 70, 81}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 59, 159, 207, 251, 185, 138}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 145, 119, 183, 43, 147, 138}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 254},
	{{190, 0, 156, 206, 135, 248, 76, 115, 174, 113, 88, 192, 228, 71, 241, 30}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 174, 179, 131}, 254},
	{{190, 0, 0, 0, 215, 19, 155, 224, 24, 90, 65, 43, 60, 39, 209, 219}, 254},
	{{190, 0, 0, 0, 151, 62, 171, 23, 100, 15, 142, 137, 86, 225, 148, 54}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 93, 47, 53}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 189, 224, 61}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 116}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 76}, 254},
	{{190, 0, 0, 0, 0, 166, 36, 64, 42, 15, 139, 4, 216, 166, 145, 172}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 30, 6, 75, 202, 39, 2, 18}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 49, 9}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 228, 171}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 97, 177, 242, 71, 77, 226, 37}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 235, 78, 164, 46}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 158}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 209, 246}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 249}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 194, 106, 245, 88, 121, 104, 217, 228, 252}, 254},
	{{190, 0, 0, 0, 0, 0, 210, 78, 255, 35, 249, 103, 28, 213, 247, 248}, 254},
	{{190, 0, 168, 33, 105, 204, 90, 24, 73, 132, 192, 18, 235, 185, 220, 145}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57, 239, 88, 89, 85}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167, 154, 23}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 196, 123, 222, 83, 143, 86, 20, 62}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 186, 114, 250, 116, 85}, 254},
	{{190, 0, 0, 0, 0, 190, 249, 113, 38, 178, 87, 241, 228, 23, 10, 230}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40, 225}, 254},
	{{190, 0, 0, 0, 102, 127, 227, 43, 8, 235, 11, 31, 223, 121, 136, 250}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 243, 175, 181, 224, 134, 31, 50, 45}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 118, 50, 40}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135, 242, 93, 254, 45}, 254},
	{{190, 0, 123, 26, 222, 100, 255, 236, 4, 137, 112, 8, 220, 11, 201, 198}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 206, 66, 199, 247}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 93, 98, 217, 168}, 254},
	{{190, 0, 0, 0, 197, 189, 150, 240, 228, 213, 63, 140, 91, 69, 2, 53}, 254},
	{{190, 0, 0, 19, 132, 172, 254, 98, 157, 80, 105, 32, 31, 78, 86, 217}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 156, 56}, 254},
	{{190, 0, 0, 0, 0, 159, 112, 222, 184, 142, 204, 183, 63, 67, 181, 38}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 215}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 149, 74, 229, 189}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 50}, 254},
	{{190, 0, 0, 0, 0, 0, 43, 208, 91, 15, 28, 240, 7, 162, 60, 246}, 254},
	{{190, 0, 0, 52, 203, 175, 117, 174, 23, 254, 140, 116, 174, 152, 149, 140}, 254},
	{{190, 0, 0, 0, 0, 0, 71, 91, 251, 61, 171, 66, 210, 179, 229, 17}, 254},
	{{190, 0, 75, 3, 104, 53, 225, 50, 179, 1, 235, 128, 67, 141, 67, 64}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 252, 193, 166, 0}, 254},
	{{190, 0, 0, 77, 38, 61, 184, 147, 227, 151, 87, 78, 129, 231, 111, 217}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 92, 54, 110, 4, 36, 103, 60, 116}, 254},
	{{190, 0, 0, 0, 111, 23, 138, 79, 245, 111, 107, 1, 205, 230, 14, 15}, 254},
	{{190, 0, 0, 0, 0, 88, 24, 228, 189, 70, 197, 61, 31, 112, 116, 77}, 254},
	{{190, 0, 0, 0, 0, 139, 250, 82, 77, 37, 107, 118, 92, 83, 156, 47}, 254},
	{{190, 0, 0, 0, 171, 131, 157, 15, 150, 26, 39, 161, 7, 195, 155, 128}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 110, 131, 107, 176, 146, 98, 194, 106, 9}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 180, 177, 244, 187}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71, 2, 14}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 150, 151, 253, 150, 8}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 111, 127}, 254},
	{{190, 0, 99, 175, 181, 38, 172, 177, 232, 94, 62, 82, 153, 198, 187, 70}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 12, 129, 160, 114, 179, 199, 161, 43}, 254},
	{{190, 0, 0, 0, 0, 0, 113, 252, 43, 151, 114, 30, 182, 40, 251, 78}, 254},
	{{190, 0, 95, 104, 204, 77, 75, 220, 37, 15, 111, 2, 125, 164, 46, 59}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 228, 64, 47, 28, 104, 121}, 254},
	{{190, 0, 0, 107, 38, 208, 193, 153, 235, 202, 179, 245, 227, 184, 15, 29}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 232, 161, 50, 4, 166, 1, 241}, 254},
	{{190, 0, 0, 0, 0, 0, 41, 19, 39, 167, 251, 212, 41, 202, 165, 190}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 16, 240, 66, 20, 113, 225, 128, 26}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 247, 90, 121, 121, 150, 58}, 254},
	{{190, 0, 121, 233, 2, 4, 76, 73, 111, 37, 55, 208, 32, 147, 62, 255}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 71, 120, 158, 211}, 254},
	{{190, 0, 0, 0, 0, 94, 50, 22, 198, 203, 188, 219, 143, 248, 130, 194}, 254},
	{{190, 0, 0, 0, 0, 192, 146, 68, 176, 226, 142, 78, 7, 12, 173, 38}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 100, 52, 138}, 254},
	{{190, 0, 0, 130, 60, 177, 131, 118, 19, 211, 137, 211, 249, 68, 37, 48}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 116, 154}, 254},
	{{190, 0, 0, 0, 0, 118, 221, 6, 51, 161, 198, 186, 146, 89, 139, 183}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 212, 66, 23}, 254},
	{{190, 0, 242, 65, 164, 46, 222, 178, 72, 113, 245, 162, 59, 67, 66, 206}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67, 106}, 254},
	{{190, 0, 0, 0, 0, 0, 27, 95, 223, 142, 202, 64, 138, 178, 58, 159}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 228, 87, 210, 89, 83, 123}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 177, 109, 15, 209, 200, 74, 64, 48}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 36, 94, 227, 84, 24, 182}, 254},
	{{190, 0, 0, 0, 0, 27, 209, 147, 25, 64, 96, 66, 19, 93, 93, 37}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 170, 165}, 254},
	{{190, 0, 0, 0, 0, 208, 225, 46, 19, 56, 17, 247, 100, 188, 136, 141}, 254},
	{{190, 0, 0, 0, 89, 33, 197, 129, 220, 148, 59, 10, 86, 0, 201, 48}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 160, 207, 254, 164, 240}, 254},
	{{190, 0, 157, 16, 172, 6, 128, 181, 184, 159, 133, 96, 220, 99, 151, 238}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 164}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 85}, 254},
	{{190, 0, 0, 0, 0, 0, 0, 0, 0, 19, 202, 54, 180, 15, 195, 139}, 254},
	{{190, 0, 0, 127, 115, 114, 184, 218, 224, 133, 177, 103, 75, 219, 190, 176}, 254},
	{{190, 0, 100, 96, 18, 167, 33, 84, 49, 82, 95, 161, 0, 75, 230, 81}, 254},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 9}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 0}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 58}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 153, 106, 14, 110, 26, 28}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 103, 107, 11, 130}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 174, 79, 81, 32, 0}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 131}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 174, 241, 183, 28, 59}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 31, 50, 96, 212}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 199, 45, 190, 190, 45}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 154, 191, 144, 113, 246}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 207, 9, 123, 115}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 186, 7, 107, 203, 170}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 189, 182}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 131, 42, 98, 142, 199, 78}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 174, 44}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 171, 161, 133, 42}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 22, 37}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 36}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 96, 65}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 177, 110}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 1, 223, 41}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 159, 238}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 204, 194, 175, 83}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 44, 102, 107, 163, 59, 230}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 116, 167, 86, 248, 102}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 183, 130, 198}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 216, 92, 145}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 114, 180, 153}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 182, 41, 104, 194, 172}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 201, 76, 139, 187}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 168, 35, 126, 94, 63}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 164, 144, 216, 215, 99}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 153, 118, 240, 37, 135, 175}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 0}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 136}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 86, 122, 195, 58}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 184, 25, 13, 172}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 237}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 214, 53, 115}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 194, 99, 173, 35}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 100, 15, 185, 187, 115, 229}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 200}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 107, 92, 239}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 0}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 217, 68, 221}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 15, 86, 84, 57, 235}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 129, 240, 209, 106}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 11, 155, 100, 7, 199}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 173, 125, 208, 213, 38, 59}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 185}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 242, 242, 154, 98, 119, 242}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 120, 230, 144, 56, 190, 252}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 19, 195, 193}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 48, 159, 5, 145}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 227}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 0}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 17, 72, 85}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 0}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 95, 236, 159}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 115, 174, 160, 17}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 213, 191, 207, 40}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 0}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 0}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 0}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 88, 85, 157}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 0}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 100, 3, 15, 72, 109}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 0}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 0}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 180, 59, 120, 50, 167}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 240, 140, 54}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 74, 140, 92, 240}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 39, 90}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 0}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 105, 29, 249}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 68, 56}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 187}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 43, 136, 134, 198}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 232, 211, 176}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 70, 28}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 213, 73}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 72, 179, 81, 154, 23}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 240, 123, 217, 144, 45, 50}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 21, 196, 158}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 69}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 104, 188, 213, 2, 220}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 85, 122, 34, 92}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 0}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 107, 74, 111, 203}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 91, 193}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 38, 228, 198}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 221, 44, 149}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 75, 219, 164, 5, 114, 106}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 241, 238, 149, 78, 252, 13}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 0, 0}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 66, 183}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 0, 0, 37, 29}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 0, 0, 130, 181, 250, 85}, 66},
	{{156, 73, 249, 148, 55, 192, 20, 42, 142, 128, 213, 118, 193, 22, 29, 146}, 66},
	{{64, 107, 36, 120, 0, 0, 0, 80, 199, 85, 29, 58, 18, 156, 159, 120}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 181, 31}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 106, 124, 84, 212, 76, 16}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 163, 199, 111, 170, 12, 67, 107, 170}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 30, 140, 153, 145}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 155, 57}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 226, 253, 161, 202}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 219, 192, 94, 25, 142}, 4},
	{{64, 107, 36, 120, 0, 186, 66, 162, 234, 119, 244, 192, 19, 213, 43, 219}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 161, 15, 156}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 20, 101, 63, 56, 114, 18, 232, 104, 53}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 193, 125, 218, 131, 108}, 4},
	{{64, 107, 36, 120, 0, 22, 220, 119, 47, 48, 54, 177, 253, 195, 74, 198}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 178, 186}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 103, 241, 254, 111}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 101}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 185, 176, 17, 167, 191, 13, 114, 206}, 4},
	{{64, 107, 36, 120, 0, 0, 194, 146, 145, 139, 171, 40, 212, 60, 127, 206}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 225, 251, 111, 121, 62, 175, 234, 59, 114}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 212, 150, 173, 245, 117, 24, 103}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 18, 31, 215, 36, 137, 250, 242, 172, 26}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4},
	{{64, 107, 36, 120, 78, 249, 212, 44, 225, 112, 79, 108, 141, 119, 219, 173}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 69, 2, 162, 197, 91, 16}, 4},
	{{64, 107, 36, 120, 192, 179, 60, 25, 204, 228, 113, 175, 244, 195, 131, 247}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 155, 190}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 145, 238, 237}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 70, 28, 240}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 188, 126, 214, 55, 67, 75, 211, 64}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 133}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 55, 209, 106, 211, 60, 0}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 129}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 65, 215, 175, 41}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 57, 128, 244, 138, 173, 197, 87}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 67, 184, 242, 198}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 49, 80, 168, 30, 35, 64, 167, 99, 30}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 248, 144, 124, 170}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 176, 144, 91, 110, 62, 158}, 4},
	{{64, 107, 36, 120, 0, 232, 84, 34, 9, 1, 33, 126, 210, 226, 127, 199}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 73, 226, 188, 93, 98, 96, 130, 42}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 142}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 86, 128, 164, 87, 175, 118}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 122, 0, 46, 251, 109, 176, 186}, 4},
	{{64, 107, 36, 120, 220, 133, 95, 233, 49, 236, 44, 42, 189, 226, 170, 54}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 248, 65, 68, 235, 144, 181, 123, 204, 126}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 172, 112, 138, 93, 189, 166}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 135, 96, 10}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 44, 17, 109, 136}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 78, 100, 5, 188, 79, 68, 244}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 130, 92, 91, 17, 102, 239, 86}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 197, 63, 71, 219, 225, 103, 188, 96}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 219, 189, 121, 126, 249, 233}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 52, 28, 95, 228, 200, 175, 195}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 96, 24, 200, 233}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 225, 89, 67, 57, 179, 172}, 4},
	{{64, 107, 36, 120, 0, 155, 249, 60, 119, 34, 47, 73, 60, 150, 155, 138}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 248, 205, 41, 49, 45, 79, 66, 253, 125}, 4},
	{{64, 107, 36, 120, 0, 0, 122, 14, 167, 162, 195, 230, 62, 173, 16, 144}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 17, 70, 117, 86}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 68}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 228, 248}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 153, 221, 194, 12, 206, 50, 179, 0}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 134, 41}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 211, 43, 38, 60, 151, 18}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 104, 3, 85, 19, 89, 98}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 244, 252, 253, 207, 19, 157, 29, 213}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 96, 138, 63, 50, 36, 215}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 154, 108, 22, 38, 227, 219, 188}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 81}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 192, 95}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 109, 129, 173, 206, 99, 148, 94, 24, 134}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 11, 115, 155, 9}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 111, 72, 188, 157, 14, 128, 174, 199}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 156}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 203, 24, 202, 143, 208, 223, 140, 175}, 4},
	{{64, 107, 36, 120, 0, 29, 170, 14, 137, 24, 169, 52, 8, 168, 93, 133}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 162}, 4},
	{{64, 107, 36, 120, 0, 0, 166, 191, 205, 127, 80, 251, 5, 218, 161, 57}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 121, 163, 65, 195, 103, 110, 136}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 28, 233, 95, 12, 12, 208}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 117, 217}, 4},
	{{64, 107, 36, 120, 0, 0, 14, 3, 76, 115, 223, 171, 26, 230, 235, 114}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 158, 60, 166, 234, 138, 135, 243, 96}, 4},
	{{64, 107, 36, 120, 0, 0, 0, 0, 0, 198, 203, 196, 224, 187, 195, 201}, 4},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 242}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 0}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 41, 85, 183}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 91, 176, 200}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 9}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 201, 103, 247, 151, 97}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 240, 240, 197}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 0}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 151, 182, 82, 110}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 149, 27, 219}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 48}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 0}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 171}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 92, 56}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 220}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 159, 145}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 0}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 47, 233, 228}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 157, 11, 214, 194}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 106, 232, 195, 138, 39}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 66}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 253, 140, 166, 169}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 89, 121, 58, 39}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 62, 211, 105, 123}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 0}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 187, 34, 42, 93}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 78}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 51, 38, 231, 254}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 38, 124, 97, 112}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 25, 189, 196}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 207, 198, 50, 113}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 168}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 0}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 149, 103, 193}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 11}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 114}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 151, 209, 35, 171, 230}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 88}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 227, 2, 236, 200, 9}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 199, 214, 235, 12, 94}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 68, 203, 14}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 231}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 0}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 198, 140, 35, 251, 135}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 164}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 119, 6}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 51}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 33, 166, 64, 120}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 59, 111, 239}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 238, 144}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 171, 205, 175, 6}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 205, 33, 96}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 0}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 213}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 37, 48}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 8, 93, 41, 127}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 87}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 0}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 0}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 43, 248, 35, 88}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 138, 99}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 177, 170, 115, 48}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 64, 167, 157, 108}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 38}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 31, 165}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 0}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 163, 233, 17}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 125, 80}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 200}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 0}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 105}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 0}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 20}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 252, 104, 78, 99, 251}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 108, 54, 242, 143, 200}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 79, 254, 85, 100, 24}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 59, 126, 226}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 25}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 106, 28, 236, 82}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 142, 38, 208}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 103, 168, 76, 110}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 85}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 16, 28}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 59}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 44, 146, 60}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 136}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 228, 133, 54, 92}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 66, 72, 45}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 21, 195}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 81}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 138}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 30, 243, 56}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 0}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 23, 95, 85, 25}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 86}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 0}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 0}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 0, 47}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 87, 166, 220, 223, 214}, 122},
	{{115, 148, 71, 250, 158, 174, 168, 249, 106, 110, 196, 0, 0, 0, 68, 87}, 122},
	{{18, 139, 152, 44, 38, 88, 0, 0, 109, 223, 185, 181, 20, 181, 113, 56}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 229, 145, 185, 176, 120, 236, 233, 122, 66}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 104, 144, 112}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 198, 98}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 171, 76, 46, 135, 204}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 216}, 59},
	{{18, 139, 152, 44, 38, 88, 239, 46, 123, 130, 59, 7, 179, 231, 75, 20}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 159, 144, 87, 252}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 123, 10, 54, 233}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 84, 248, 39, 183, 56, 42}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 253, 206, 161, 214, 40, 16, 193, 66, 250}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 118}, 59},
	{{18, 139, 152, 44, 38, 88, 244, 16, 24, 91, 32, 49, 176, 40, 206, 189}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 140, 236, 87}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 148, 152, 195, 190, 208}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 173, 97, 135, 123}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 87, 50, 13, 210, 82}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 141, 34, 7, 232, 6, 141, 207, 61, 235}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 17, 172, 50, 218, 44, 251, 61, 244, 219}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 127, 149}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 100, 255, 25, 91, 251}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 221, 78, 203}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 218, 181, 158, 26, 226, 42, 83}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 62, 254, 16, 226, 233, 153, 86, 139}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 220, 220, 139, 35, 74, 100, 51, 226}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 114, 13, 109, 35, 207, 145, 128, 73, 121}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 152, 222, 129, 73, 82, 69, 247, 177}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 202, 210}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 64, 153, 179}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 240, 175, 66, 210, 172, 155, 205}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 174}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 193, 205, 19, 180, 52, 188, 85, 237}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 15, 144, 194, 5, 48}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 147, 153}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 131, 152, 246, 225, 154, 3, 96}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 152, 114, 169, 155, 154, 232, 239, 210}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 171, 201, 160, 20, 98, 53, 116, 63, 115}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 64, 212}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 228, 98, 246, 49, 86}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 14, 91, 135, 229, 202}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 179, 74, 44, 119}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 42, 222, 181, 14, 208, 227, 34}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 169, 142, 30}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 234, 71, 243}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 51, 50, 98, 203, 199, 132, 48, 158}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 150}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 27, 6, 198, 8}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 235, 50, 218, 116, 91, 159, 226, 11, 102}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 29, 178, 83, 114}, 59},
	{{18, 139, 152, 44, 38, 88, 243, 75, 34, 46, 36, 222, 131, 38, 155, 43}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 122, 43, 197, 114}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 17, 50, 32, 223, 133, 128}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 176, 40, 92, 254, 130, 121, 41, 27, 175}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 218, 41, 130}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 128, 6, 100, 80, 161, 202, 186}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 211, 175}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 129, 174}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 192, 154, 197, 248, 94, 189, 149}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 182, 254, 133, 227, 145}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 41, 62}, 59},
	{{18, 139, 152, 44, 38, 88, 155, 113, 131, 99, 221, 41, 5, 28, 146, 122}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 51, 87, 214, 21, 91, 171, 221, 197}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 247, 49, 145, 211}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 93, 121, 55, 195, 6}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 57, 227, 211, 160, 149, 214, 72}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 21, 201, 201, 195, 223}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 153, 214, 254, 142, 146}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 172, 235, 221, 236, 85, 125, 178}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 212}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 75, 223, 34, 252, 176, 200, 182}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 201, 216, 255, 149, 245, 139, 126, 131, 121}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 175, 173, 219, 217, 149, 236, 204, 106, 168}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 169, 231, 72, 147}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 37, 228}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 50, 57, 48, 234, 196}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 29, 9, 18, 140, 235, 197, 181, 215}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 223, 112, 37, 36, 29}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 73, 231, 90, 239}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 242, 248, 102, 42}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 78, 189, 29, 244}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 103, 245, 207}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 129, 129, 63, 141, 208, 74, 108, 170, 116}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 188}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 163, 222}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 59},
	{{18, 139, 152, 44, 38, 88, 0, 193, 253, 132, 146, 6, 34, 17, 223, 124}, 59},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 224}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 77}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 127}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 20}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 70}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 125}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 29}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 129}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 23}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 87}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 170}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 35}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 130}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 170}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 171}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 127}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 104}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 219}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 88}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 185}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 218}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 216}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 91}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 173}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 0}, 99},
	{{55, 229, 117, 106, 146, 95, 74, 220, 122, 0, 84, 202, 183, 138, 120, 21}, 99},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 227, 53, 76}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 224, 18, 6, 198, 204, 113, 105, 211, 193}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 87, 0}, 41},
	{{153, 211, 3, 96, 0, 66, 148, 128, 170, 38, 29, 59, 25, 184, 219, 149}, 41},
	{{153, 211, 3, 96, 0, 0, 83, 103, 73, 50, 114, 64, 135, 238, 238, 208}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 94}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 104, 18}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 78, 130, 63}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 129, 3, 196, 74, 75, 25}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 224}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 252, 133, 109, 49, 224, 90}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 109, 173, 164, 194, 87, 13, 157, 154}, 41},
	{{153, 211, 3, 96, 0, 164, 105, 167, 25, 182, 177, 180, 105, 202, 82, 111}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 2, 6, 72, 4, 117, 125, 16, 154}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 116, 216, 56}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 40, 114, 80, 216}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 30, 35, 183, 188, 85, 56, 207, 137}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 22, 80, 129}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 140, 251, 71, 5, 195, 5, 74, 201, 110}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 174, 149, 193, 88, 97, 212, 235}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 140, 162, 83, 214, 196, 27}, 41},
	{{153, 211, 3, 96, 0, 78, 71, 28, 173, 142, 108, 240, 214, 123, 41, 179}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 173, 1, 184}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41},
	{{153, 211, 3, 96, 0, 0, 73, 82, 129, 239, 20, 83, 215, 152, 104, 206}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 48, 137, 28, 47, 199, 124, 152, 135}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 44, 48, 135, 41, 167, 33, 63}, 41},
	{{153, 211, 3, 96, 0, 0, 136, 133, 86, 60, 246, 193, 176, 167, 31, 17}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 91, 240, 160, 169, 101, 144}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 105, 218, 215, 165}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 103, 131, 86, 64}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 2, 71}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 206, 79, 172, 31, 60, 47, 52, 170}, 41},
	{{153, 211, 3, 96, 0, 0, 42, 198, 22, 0, 65, 225, 233, 113, 13, 229}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 193, 72, 158, 183, 69}, 41},
	{{153, 211, 3, 96, 0, 141, 15, 126, 230, 143, 191, 208, 153, 116, 44, 71}, 41},
	{{153, 211, 3, 96, 0, 0, 52, 59, 82, 73, 50, 179, 229, 229, 128, 52}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 219}, 41},
	{{153, 211, 3, 96, 0, 0, 67, 8, 110, 58, 44, 85, 167, 138, 65, 179}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 150, 202, 224, 184, 228, 70}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 54, 174, 219, 46, 104, 200, 201, 211}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 95, 187, 31, 155, 198, 244, 69, 239}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41},
	{{153, 211, 3, 96, 0, 0, 218, 200, 32, 46, 56, 67, 113, 85, 148, 182}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41},
	{{153, 211, 3, 96, 0, 40, 98, 144, 97, 199, 234, 227, 187, 101, 199, 75}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187, 213, 76}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 128, 113, 24, 64, 234, 122, 198}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 183, 238, 230, 63}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66, 185}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 52, 126, 115, 69}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 216, 217, 148, 249, 89, 107, 5}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 201, 223, 239, 19, 152, 17, 198, 33, 127}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 241, 90, 30, 91, 50, 33, 238, 85}, 41},
	{{153, 211, 3, 96, 0, 5, 194, 150, 57, 157, 194, 236, 210, 237, 183, 124}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41},
	{{153, 211, 3, 96, 0, 0, 211, 140, 137, 132, 207, 214, 14, 93, 139, 177}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63, 13, 118}, 41},
	{{153, 211, 3, 96, 91, 111, 160, 35, 205, 9, 227, 61, 94, 207, 133, 180}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 94, 81, 168, 26, 155, 174, 118, 117, 4}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 204, 78, 134, 233, 129, 135, 228}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 157, 92, 40, 52, 167, 226}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 53, 238, 36, 207, 176, 175, 157, 71, 132}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 2, 131, 215, 130, 121, 115}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 169, 252, 154, 233, 68, 69, 144, 232, 9}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 217, 154, 17, 29}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 42, 233}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 193, 13, 38, 25, 181, 215, 103, 249, 246}, 41},
	{{153, 211, 3, 96, 0, 136, 156, 110, 179, 190, 4, 223, 101, 162, 59, 22}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41},
	{{153, 211, 3, 96, 0, 183, 233, 0, 137, 254, 173, 170, 129, 71, 89, 69}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 167, 101, 185, 158, 152, 248}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 74, 46, 45, 4}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 161, 243, 160, 94, 55, 202, 216, 221}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 116, 212, 42}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 108, 209, 217, 245, 84, 30}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 200, 181, 201, 231, 241, 245, 27, 85}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 168, 32, 165}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 208, 70, 99}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 70, 133, 168}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 246}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 138, 103, 95, 114, 126, 82, 90, 226, 23}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 79, 210, 59, 16, 149, 88, 138}, 41},
	{{153, 211, 3, 96, 0, 219, 174, 158, 236, 188, 42, 64, 82, 42, 184, 203}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 176, 207}, 41},
	{{153, 211, 3, 96, 217, 114, 129, 24, 1, 137, 225, 22, 60, 255, 166, 55}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 178}, 41},
	{{153, 211, 3, 96, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 41},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 34, 197, 99, 80, 140}, 137},
	{{1, 0, 231, 101, 27, 71, 216, 95, 98, 77, 161, 110, 63, 147, 21, 117}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 52}, 137},
	{{1, 0, 0, 52, 166, 34, 96, 218, 194, 201, 233, 91, 205, 205, 151, 54}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 243, 49, 142, 149}, 137},
	{{1, 0, 0, 31, 90, 12, 247, 229, 182, 135, 220, 221, 253, 106, 44, 150}, 137},
	{{1, 0, 0, 0, 131, 96, 95, 120, 214, 138, 206, 159, 165, 168, 10, 44}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 232, 185, 221, 218, 112, 97, 17}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 83, 47, 123, 255, 214}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 29, 204, 17, 102, 122, 20, 68}, 137},
	{{1, 0, 0, 0, 0, 173, 33, 89, 216, 174, 202, 21, 112, 49, 191, 159}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 150, 107, 176}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 184, 173, 136, 155, 233, 93}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{1, 0, 0, 11, 79, 202, 17, 203, 178, 243, 181, 142, 58, 1, 248, 217}, 137},
	{{1, 0, 193, 175, 94, 138, 4, 117, 31, 249, 36, 46, 89, 94, 90, 206}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{1, 0, 0, 0, 82, 94, 240, 22, 20, 95, 151, 103, 97, 166, 225, 26}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 228, 27}, 137},
	{{1, 0, 170, 151, 7, 242, 10, 2, 148, 37, 133, 79, 247, 34, 32, 219}, 137},
	{{1, 0, 0, 0, 0, 0, 92, 188, 135, 200, 32, 29, 185, 188, 166, 153}, 137},
	{{1, 0, 245, 9, 192, 242, 178, 177, 130, 37, 81, 19, 115, 148, 164, 39}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159, 42, 7, 88, 30, 242}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 48, 178, 83}, 137},
	{{1, 0, 0, 171, 71, 163, 67, 120, 185, 161, 149, 77, 215, 67, 103, 199}, 137},
	{{1, 0, 249, 172, 190, 219, 4, 28, 50, 159, 130, 70, 38, 140, 144, 115}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 167, 208, 145, 187, 29, 36, 76, 85}, 137},
	{{1, 0, 0, 0, 0, 0, 153, 123, 232, 18, 241, 224, 30, 19, 50, 247}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{1, 0, 0, 0, 35, 81, 64, 78, 191, 26, 164, 26, 142, 146, 154, 163}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90, 45, 148, 135}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 47, 108, 118, 247, 74, 238, 176, 86, 11}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 180, 117, 96, 102, 190}, 137},
	{{1, 0, 0, 0, 148, 239, 244, 75, 247, 125, 135, 71, 162, 255, 143, 109}, 137},
	{{1, 0, 143, 112, 158, 172, 16, 200, 63, 84, 175, 107, 169, 30, 53, 131}, 137},
	{{1, 0, 33, 12, 242, 6, 4, 96, 42, 160, 186, 134, 118, 60, 248, 255}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 189}, 137},
	{{1, 0, 221, 45, 216, 87, 79, 238, 68, 134, 209, 153, 98, 120, 28, 241}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 223, 115, 184, 178, 72, 192, 149, 244}, 137},
	{{1, 0, 0, 0, 127, 101, 222, 38, 58, 81, 230, 97, 248, 112, 4, 57}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 22, 172, 161, 142, 77, 176, 253}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 71, 5, 83, 169, 204, 53, 80, 24}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 44, 164, 61}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 99, 143, 32, 224, 153}, 137},
	{{1, 0, 167, 32, 148, 106, 219, 2, 231, 169, 28, 163, 171, 27, 100, 36}, 137},
	{{1, 0, 0, 0, 0, 126, 5, 224, 243, 240, 16, 56, 242, 160, 101, 119}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 141}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 211, 150, 241, 34, 109, 119}, 137},
	{{1, 0, 0, 48, 193, 33, 194, 97, 159, 95, 90, 195, 34, 185, 176, 228}, 137},
	{{1, 0, 0, 0, 0, 0, 168, 192, 42, 214, 215, 184, 186, 94, 240, 155}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 44, 68, 203, 147, 162}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 255, 143, 216, 206, 47, 229, 69, 15}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40, 23, 173}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 216}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 108}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 249, 36, 144, 127, 93, 195, 211, 174, 80}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 143, 227}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{1, 0, 0, 0, 0, 6, 163, 216, 51, 172, 213, 83, 132, 111, 184, 179}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 239, 81, 228, 75, 142, 162, 210}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 105}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 102, 86, 19, 3, 211, 0, 102}, 137},
	{{1, 0, 0, 0, 0, 204, 252, 166, 10, 6, 230, 116, 6, 254, 206, 132}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 253, 62, 93}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 85, 122, 136, 32, 94, 56, 154}, 137},
	{{1, 0, 0, 0, 0, 0, 189, 61, 245, 172, 64, 48, 75, 193, 77, 234}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 111, 23, 109, 152, 252, 76, 177}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 203, 212, 208, 135, 236, 123, 48, 190, 97}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 229, 222}, 137},
	{{1, 0, 97, 195, 96, 138, 182, 69, 246, 118, 33, 106, 105, 150, 251, 40}, 137},
	{{1, 0, 0, 0, 0, 159, 47, 159, 166, 204, 50, 209, 76, 60, 3, 187}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 216, 208, 52, 108, 85, 206, 230, 172}, 137},
	{{1, 0, 0, 0, 0, 156, 133, 124, 149, 42, 80, 150, 181, 232, 179, 184}, 137},
	{{1, 0, 0, 0, 27, 156, 201, 250, 202, 75, 129, 251, 29, 19, 150, 79}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 234}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 199}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 25, 66, 53, 109, 125, 19, 109}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 213, 246, 226}, 137},
	{{1, 0, 0, 0, 0, 18, 59, 213, 76, 27, 138, 122, 188, 117, 253, 230}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 93, 153, 104}, 137},
	{{1, 0, 0, 0, 106, 200, 114, 24, 154, 36, 106, 89, 141, 33, 34, 212}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 61, 174, 108, 191, 155, 170, 214, 206}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 113}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119}, 137},
	{{1, 0, 0, 0, 212, 129, 26, 199, 132, 221, 102, 145, 161, 231, 249, 35}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 179, 236, 67, 134, 9, 97, 127}, 137},
	{{1, 0, 0, 146, 186, 182, 103, 82, 4, 49, 13, 142, 156, 41, 241, 61}, 137},
	{{1, 0, 0, 0, 5, 149, 75, 223, 69, 41, 21, 133, 2, 33, 103, 52}, 137},
	{{1, 0, 180, 69, 7, 172, 160, 185, 14, 52, 189, 84, 114, 183, 117, 93}, 137},
	{{1, 0, 59, 168, 228, 29, 119, 119, 124, 100, 47, 185, 176, 24, 121, 231}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 89, 49, 243}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 189, 24}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6, 77, 27, 164}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 142, 199, 49, 51, 42, 223, 191, 64, 98}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 106, 231, 199}, 137},
	{{1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 211, 118}, 137},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 86, 140, 70, 133}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 148, 100, 234, 25}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 84, 150, 35, 224}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 125}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 177, 13}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 103, 153}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 41}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 250}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 76, 175}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 146, 71}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 206, 29}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 44}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 202, 212, 205, 21}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 31, 232}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 197}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 203, 191}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 144}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 15, 202}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 109}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 46, 89, 17, 76, 207}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 229}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 238, 46, 183}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 23, 154, 46, 139}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 193, 214}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 15}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 89, 80}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 72, 67}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 192, 1, 245, 4}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 62, 78, 22, 53}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 251, 7, 44}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 197, 226, 163, 143}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 239, 11}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 167, 157, 1, 175}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 76, 214}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 176, 245, 25, 206, 167}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 97}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 154, 151, 234}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 26, 155, 15, 191}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 40, 58, 234}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 64}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 251, 176}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 149, 134, 14, 90}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 123, 130, 151, 234}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 84}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 165, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 73}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 198, 166, 138}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 36, 24, 127, 188}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 179, 195, 178, 197}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 44, 33, 197, 164}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 69}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 97, 65, 100}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 190}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 100}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 237, 79, 157, 95}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 226, 250, 191, 121}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 38, 145}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 179, 76, 34, 176}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 165, 46, 35, 252, 113}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 97, 214}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 20, 20, 233, 255}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 169, 93, 192, 154}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 7, 28, 36, 75, 216}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 36, 223}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 59}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 14}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 72, 158, 31}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 227, 205}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 64, 79, 98, 139, 183}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 104, 42, 35}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 182, 16}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 111, 102}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 237}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 237, 180, 151}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 83, 57, 155, 192}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 0}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 75, 116}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 116}, 255},
	{{49, 192, 102, 142, 216, 3, 114, 64, 165, 128, 168, 0, 0, 0, 0, 51}, 255},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 88}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 197, 163}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 253, 202, 147, 27, 57, 174, 204}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 139, 168}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 66, 110, 185, 205, 126, 237}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 122, 64, 220, 168, 46, 44, 122, 78}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 107, 211}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 20, 12, 60, 198, 188, 101, 184, 239}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 167, 202, 120, 53, 4}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 199, 223, 75, 157, 218, 45, 177, 1, 161}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 114, 114}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 74, 110, 50, 255}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 5, 42, 44, 53}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 162, 150, 187, 197, 78, 175, 61, 113}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 81, 184, 175, 186, 40, 188}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 115, 61, 38, 172, 218, 199, 89}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 138, 92, 165, 156, 138, 45, 62, 126, 9}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 199, 126, 64}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 35, 28, 197, 73, 84}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 42}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 164, 40, 70, 218, 104, 247}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 202}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 150, 72, 99, 101, 241}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 181, 162, 195, 171}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 201, 118, 191, 77, 248, 84, 123, 173}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 110, 242, 180, 74, 104, 191, 30, 80}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 46, 84, 9, 49}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 129, 87, 146, 183, 155}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 123}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 104, 158, 63, 51, 141, 32, 55, 193}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 123, 185, 102, 38, 63, 213, 50, 158, 215}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 160, 209, 227}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 66, 246, 147}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 226, 137, 34, 9}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 28, 29, 247, 238, 122, 72}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 162, 138, 104, 149, 104, 242}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 144, 198}, 106},
	{{201, 143, 240, 240, 209, 224, 145, 28, 179, 129, 243, 162, 72, 135, 27, 46}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 117, 42, 3, 30, 47, 46}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 167, 104, 213, 156, 125, 211, 202, 110}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 62, 44, 176, 100}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 104, 106, 237, 75, 156}, 106},
	{{201, 143, 240, 240, 209, 224, 142, 219, 198, 23, 162, 113, 63, 161, 113, 223}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 77, 198, 22, 222, 149, 162, 182}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 216, 248, 82, 133, 175, 40, 50}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 3, 129, 11, 250, 79, 134, 88, 213, 217}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 81, 111, 140, 249}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 26, 245, 64}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 151, 138, 62}, 106},
	{{201, 143, 240, 240, 209, 224, 58, 0, 239, 137, 148, 197, 71, 50, 97, 167}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 198, 176, 42}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 83, 165, 90, 101, 11}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 192, 239, 228, 204, 40}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 72}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 229, 34, 23, 40, 60, 234, 159, 177, 107}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 119, 191, 70}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 223, 102}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 88, 10, 251}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 64, 113, 237}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 131, 184, 2, 54, 18, 234, 173, 193, 179}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 207, 118, 27, 101}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 23, 202, 178, 218, 186, 138, 77}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 83, 164, 217, 67, 228, 109}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 101, 198}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 221, 110, 80, 215}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 86, 18, 5, 104}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 112, 223}, 106},
	{{201, 143, 240, 240, 209, 224, 15, 36, 202, 255, 6, 145, 220, 151, 1, 58}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 224, 81, 102}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 200, 250}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 8, 244, 33, 122, 176, 11, 112, 218, 172}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 9, 8, 165, 174, 99, 130, 5, 132, 151}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 184, 88, 241, 155, 236, 1, 182, 154, 231}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 255, 116, 251, 170, 98, 228}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 136, 196, 59, 75, 95}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 97, 224, 106, 7, 254, 108, 112}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 22, 212, 194, 47, 198, 119}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 113, 66, 182}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 237}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 124, 89, 250, 187, 36, 70, 86, 18, 29}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 112, 151}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 169, 73, 152}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 184, 157, 64, 29, 151, 32, 111, 62}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 126, 34, 21, 83}, 106},
	{{201, 143, 240, 240, 209, 224, 103, 227, 128, 136, 20, 184, 151, 78, 149, 193}, 106},
	{{201, 143, 240, 240, 209, 224, 0, 0, 0, 0, 0, 0, 135, 10, 145, 172}, 106},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 18}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 19, 100}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 191, 129}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 82, 114, 120}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 8, 209, 11, 234, 143, 109, 63}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 133}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 222, 240, 144, 224, 56}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 72, 156, 99, 151}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 93, 109}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 113, 77, 186, 38, 32, 72, 166}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 173, 12, 111, 189, 129, 214, 26}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 168, 17, 117, 226}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 0}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 6, 60, 23}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 139, 53}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 38}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 84}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 13, 107}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 186}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 63, 208, 89, 149, 170, 146}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 229, 131, 253, 11}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 0}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 137, 180, 12, 178, 52}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 133, 101, 178, 70, 24}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 0}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 34, 102}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 216, 143, 53}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 0}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 76, 230, 123, 214, 232, 100, 15}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 79, 10, 197, 128, 243, 172}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 194, 95, 15, 83, 161, 200, 117}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 175, 208, 85}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 8, 136, 178, 135, 23, 13}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 73, 175}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 140, 232, 49, 181, 14}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 95, 220, 60, 171, 190, 236}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 231, 92, 207, 152, 245, 147}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 174, 100, 248}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 0}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 127, 119, 48, 18}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 92, 86, 102}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 238}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 58, 80, 7, 117, 241, 177}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 177, 9, 228}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 204, 51, 78, 196, 5, 173, 117}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 219, 19, 37}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 193, 50, 125}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 14, 208, 224, 52, 100}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 254, 218, 18, 218, 175}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 17, 115, 60, 210, 184, 39, 163}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 108}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 155}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 133, 132, 250, 235}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 0}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 118, 242, 67, 159}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 228, 248, 213, 142, 147, 233, 153}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 67, 222, 8, 119, 133, 42}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 135, 44, 118, 228}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 71, 3, 184, 86}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 0}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 20, 109, 73, 210}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 22, 46, 131, 116}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 131, 25, 152, 33, 156, 224, 135}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 89, 30, 98, 179, 140, 200}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 0}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 0}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 129, 63, 162, 218, 82, 254}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 104, 54}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 98}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 94, 226, 72, 214, 71}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 54, 77}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 98}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 186, 7, 154, 138, 166, 79, 219}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 179}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 153, 219, 52, 146, 4, 172}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 28, 128, 190}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 68, 12, 9, 21, 198}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 25, 129}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 144, 179, 132, 47, 16, 55}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 74, 146, 115, 6, 129, 36}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 29}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 244, 171, 162, 207, 168, 248}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 46, 100, 50, 25, 7}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 207, 208, 19, 166, 109, 37}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 7, 85, 195, 212, 198, 121}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 10, 250, 99, 102, 160, 200, 113}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 176, 43}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 40, 235, 28, 144, 85, 162, 69}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 46, 246, 163, 84, 98, 22}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 115, 59, 195, 120, 48, 209, 96, 55}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 152, 202, 139}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 108, 207, 27, 192, 82, 224}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 89, 87, 90, 44}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 0}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 131, 134, 141}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 92, 169, 205, 113, 62}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 136, 205, 158, 254, 39, 46}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 0, 0, 0, 84}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 74, 127, 56, 91}, 170},
	{{158, 19, 164, 196, 87, 162, 33, 120, 0, 0, 0, 0, 21, 119, 7, 160}, 170},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 229, 150, 46, 238, 164}, 86},
	{{5, 114, 0, 0, 0, 0, 91, 210, 74, 139, 141, 144, 93, 27, 178, 25}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 86},
	{{5, 114, 0, 15, 143, 130, 47, 147, 19, 175, 132, 149, 188, 237, 100, 135}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 212, 43, 75, 50, 53, 225, 189}, 86},
	{{5, 114, 0, 0, 208, 105, 242, 201, 168, 41, 92, 79, 192, 86, 255, 110}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 204, 1, 186}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28, 18, 130, 243}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 162, 70, 123, 23, 193, 14}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 184, 49, 141, 12, 77, 194, 140, 108, 235}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 181, 170, 46, 194}, 86},
	{{5, 114, 0, 51, 237, 36, 43, 96, 213, 102, 201, 138, 92, 30, 248, 175}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 219, 112}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 19, 218, 25}, 86},
	{{5, 114, 0, 248, 182, 60, 232, 69, 250, 123, 35, 113, 129, 138, 92, 156}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 249, 59, 21, 192}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 124, 170, 205, 163, 146, 28, 232}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 251, 235, 0, 12, 189, 133, 227, 167}, 86},
	{{5, 114, 0, 0, 101, 121, 108, 191, 29, 86, 167, 40, 13, 162, 142, 101}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 102, 149, 164, 118}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 202, 242, 92, 66, 168, 60, 133, 121, 170}, 86},
	{{5, 114, 0, 0, 0, 0, 236, 173, 172, 160, 186, 22, 195, 99, 104, 182}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 52, 124, 168, 109, 137, 40, 160, 19, 254}, 86},
	{{5, 114, 0, 0, 0, 0, 235, 174, 91, 215, 210, 198, 54, 236, 229, 68}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 104}, 86},
	{{5, 114, 0, 0, 199, 28, 253, 223, 25, 167, 202, 82, 32, 8, 214, 154}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 14, 173, 128, 230, 219, 70}, 86},
	{{5, 114, 0, 0, 122, 41, 92, 114, 186, 150, 239, 222, 14, 143, 163, 212}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 238, 246, 123, 189, 170, 163}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 246, 37, 186, 47, 23}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 129, 7, 57, 103, 118, 3, 247}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 154}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 149, 142, 234, 226, 96, 40, 45, 13}, 86},
	{{5, 114, 0, 176, 185, 238, 95, 209, 88, 18, 172, 220, 236, 160, 240, 126}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 86},
	{{5, 114, 0, 0, 0, 0, 130, 40, 78, 243, 158, 120, 94, 106, 29, 217}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90, 191}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 240, 2, 147}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 170}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 13, 72, 60, 241, 198, 148, 17}, 86},
	{{5, 114, 0, 0, 0, 0, 130, 222, 22, 142, 108, 25, 148, 30, 37, 119}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 132, 149, 67}, 86},
	{{5, 114, 0, 0, 0, 0, 12, 160, 236, 44, 242, 19, 237, 188, 175, 91}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 235, 138}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91, 79}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 207, 153, 171, 184, 249, 24, 31, 250}, 86},
	{{5, 114, 0, 0, 0, 0, 192, 163, 38, 79, 251, 121, 156, 111, 13, 89}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 184, 203}, 86},
	{{5, 114, 0, 0, 0, 0, 237, 193, 0, 35, 197, 251, 51, 180, 221, 196}, 86},
	{{5, 114, 0, 154, 41, 11, 111, 178, 233, 46, 230, 74, 129, 168, 43, 22}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 196, 81, 51, 149, 24, 16, 154, 101, 103}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 89, 138, 218, 4, 37, 139, 93}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 138, 238, 128, 227}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 93, 203}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 173, 38, 87, 137, 227, 160, 216}, 86},
	{{5, 114, 0, 201, 110, 175, 244, 73, 126, 79, 32, 54, 179, 159, 164, 54}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 97}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90, 167, 92, 66, 89}, 86},
	{{5, 114, 0, 0, 0, 0, 252, 39, 38, 51, 226, 190, 73, 18, 90, 155}, 86},
	{{5, 114, 0, 0, 0, 0, 244, 65, 143, 18, 164, 243, 100, 159, 95, 51}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 159, 18, 0, 24, 201, 40, 130, 148, 188}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 135, 235, 171, 125, 113, 84, 15}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 86},
	{{5, 114, 0, 0, 0, 0, 254, 113, 8, 79, 174, 202, 154, 146, 60, 211}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 105, 126, 133, 232, 142, 130, 96, 26, 5}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 180, 199, 90, 22, 6}, 86},
	{{5, 114, 0, 65, 226, 6, 126, 75, 221, 69, 97, 184, 130, 53, 89, 243}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 101, 35}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 116, 219, 144, 87}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 86},
	{{5, 114, 0, 0, 0, 110, 96, 81, 115, 214, 161, 170, 80, 217, 141, 164}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 77, 80, 22, 211, 91, 68}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 78, 251, 145, 232, 82}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 11, 175, 49, 219, 151, 187, 148, 40}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 179, 65}, 86},
	{{5, 114, 0, 0, 137, 21, 242, 194, 79, 88, 2, 216, 116, 221, 24, 25}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 179, 78}, 86},
	{{5, 114, 0, 0, 0, 74, 70, 16, 54, 227, 239, 205, 3, 243, 195, 104}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 26}, 86},
	{{5, 114, 0, 0, 0, 0, 161, 229, 99, 44, 49, 100, 70, 20, 128, 233}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 168, 66, 116, 43, 75, 146}, 86},
	{{5, 114, 0, 0, 0, 24, 62, 230, 126, 75, 244, 41, 247, 126, 69, 102}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 103, 145, 47, 233, 81, 158, 28, 162, 106}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 252, 245, 123, 84, 85, 63, 172, 102}, 86},
	{{5, 114, 0, 0, 0, 252, 229, 208, 127, 195, 86, 75, 237, 17, 81, 143}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 234, 106, 158, 119, 241, 235}, 86},
	{{5, 114, 0, 223, 180, 0, 79, 122, 89, 107, 133, 241, 244, 155, 39, 151}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 152, 25, 175, 179}, 86},
	{{5, 114, 0, 0, 0, 76, 63, 239, 7, 222, 125, 241, 0, 54, 24, 210}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 153, 169, 237, 22, 193, 164, 142, 3}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 214, 230, 85}, 86},
	{{5, 114, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53, 229, 161, 7}, 86},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 200, 50, 202, 109}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 145, 232, 99}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 107, 32, 146, 171, 100}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 146, 224}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 21, 103, 76, 11, 34}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 158, 161, 241, 188}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 0}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 43, 80, 134}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 108, 142}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 0}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 34, 73, 87, 73}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 0}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 0}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 9, 154}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 0}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 109, 55}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 59, 237, 85, 71, 15}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 85, 246, 120}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 119, 174, 146, 199, 190}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 139, 92, 64, 84}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 0}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 0}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 107, 155, 49, 163, 121}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 0}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 14, 52, 12, 6}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 110, 159}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 0}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 106, 34}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 219, 225, 55, 77}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 210}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 158}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 125, 102, 185, 123}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 3, 3}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 104, 84, 196, 251, 254}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 83, 91}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 189}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 0}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 149, 242, 74, 149, 203}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 222, 242}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 82, 152, 166, 220}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 212, 175}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 229}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 64, 22, 185, 226, 187}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 0}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 167, 210, 149}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 120}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 159, 81}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 175, 70, 56}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 229}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 106, 46, 255, 148}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 211, 46, 82}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 91}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 0}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 20, 153}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 183}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 0}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 110}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 0}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 165, 151, 5}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 169, 46, 131}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 144, 253}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 153, 195, 1}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 0}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 41, 22}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 207}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 83, 48, 46}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 88, 116, 211, 222}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 158, 246, 30}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 232, 15, 138}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 0}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 214, 235, 4}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 186, 179}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 24, 207, 98}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 88, 3}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 123, 251, 10, 48, 242}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 0}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 228, 128, 224}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 176, 63, 176, 62, 145}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 0}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 84, 11, 148, 159, 231}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 52, 196}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 0}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 111}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 109, 6}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 185, 202, 224}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 84, 31, 251, 15, 199, 74}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 247, 161}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 169, 66, 129, 104, 148}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 43, 81, 165, 247}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 206, 191, 102, 98}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 73, 234}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 0}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 147, 114}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 81, 15, 76, 247}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 96, 245, 238}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 32}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 248, 244}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 6, 135}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 0, 0, 0, 222}, 155},
	{{34, 170, 246, 62, 198, 85, 193, 227, 252, 68, 0, 0, 164, 220, 108, 89}, 155},
	{{21, 52, 9, 86, 224, 221, 10, 137, 203, 67, 29, 49, 200, 107, 252, 103}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 59, 79, 244, 121, 76, 78}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 124, 38, 117, 27, 107}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 150, 38, 239, 219, 39, 255}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 198, 66}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 141}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 210, 116, 109, 197, 114, 160}, 65},
	{{21, 52, 9, 86, 224, 192, 137, 98, 86, 11, 251, 146, 167, 106, 144, 99}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 66, 42, 28, 241, 190, 52, 81, 37}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 228}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 80, 27, 8}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 231, 45, 79}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 165, 7}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 220, 40, 26, 142}, 65},
	{{21, 52, 9, 86, 224, 151, 135, 108, 57, 36, 156, 28, 94, 170, 18, 116}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 212, 8, 65, 108, 230, 14}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 95, 15, 115, 182, 150}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 141, 202, 224, 91, 134}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 98, 160, 139, 148, 26}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 47, 15, 135, 110}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 198, 127, 72, 6, 165, 70, 20}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 229}, 65},
	{{21, 52, 9, 86, 224, 107, 161, 143, 51, 10, 163, 42, 152, 51, 215, 105}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 145, 199, 233, 14, 239, 168, 154}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 249, 205, 245, 181, 239, 115, 116, 181, 67}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 57, 192, 152, 129, 19, 149, 154, 124, 198}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 163}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 242}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 251, 66, 218, 254, 42, 17}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 156, 219, 216, 151, 4, 109, 136, 185, 238}, 65},
	{{21, 52, 9, 86, 224, 0, 11, 228, 247, 3, 58, 140, 6, 101, 143, 47}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 199, 186}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 215, 113, 156, 134, 231, 132}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 32, 106, 3}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 140, 123, 17, 188, 29, 192, 255, 17, 48}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 238, 187, 98, 53, 193}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 241, 107, 166, 21, 119, 3}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 233, 197, 184, 124, 67, 19, 136, 28}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 192, 41, 113, 45, 195}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 166, 106}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 93, 228, 130, 118, 237}, 65},
	{{21, 52, 9, 86, 224, 0, 223, 3, 133, 184, 136, 223, 122, 173, 148, 128}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 55, 221, 202, 119, 114, 157, 140, 76, 22}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 109, 51, 233, 248, 72, 206, 203}, 65},
	{{21, 52, 9, 86, 224, 0, 223, 133, 85, 41, 228, 104, 111, 39, 197, 136}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 172, 251, 2}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 163, 151, 124}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 62, 148, 218, 211}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 174, 64, 238, 91, 59, 97}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 91, 209, 125}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 74, 213, 150, 100}, 65},
	{{21, 52, 9, 86, 224, 0, 114, 153, 23, 230, 243, 60, 179, 113, 243, 142}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 217, 14, 245, 120, 179, 222}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 175, 164, 222, 245, 81, 176}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 104, 124, 75, 18, 82, 155, 185}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 1, 9, 93}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 5, 78, 72, 8}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 238, 84, 253, 60, 76}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 184, 73, 144, 191, 129, 101}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 140, 2, 193, 205, 61}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 67, 54, 22, 121}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 29, 183, 135, 131, 211, 194, 198, 28, 152}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 180, 193, 138, 189, 152}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 213, 220, 255}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 188, 169, 0, 109, 181, 54, 32, 65, 231}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 254}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 91, 52, 212, 26, 164, 11}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 229, 58, 74, 116, 9, 202, 2, 41}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 251, 237, 74, 233, 116, 112}, 65},
	{{21, 52, 9, 86, 224, 4, 251, 103, 32, 6, 12, 60, 184, 118, 3, 197}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 143, 174, 247}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 119, 7, 209, 160, 233, 159, 157, 4}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 65},
	{{21, 52, 9, 86, 224, 217, 32, 42, 6, 249, 92, 183, 14, 37, 101, 148}, 65},
	{{21, 52, 9, 86, 224, 0, 150, 188, 18, 49, 216, 0, 21, 254, 161, 184}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 15, 239, 111, 220, 213, 63, 169}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 162}, 65},
	{{21, 52, 9, 86, 224, 0, 67, 130, 242, 236, 0, 64, 63, 189, 180, 156}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 70, 216, 181, 117, 169, 189, 8, 40}, 65},
	{{21, 52, 9, 86, 224, 38, 149, 190, 38, 226, 253, 111, 229, 56, 81, 80}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 180, 174, 30, 23, 80, 88, 173, 155, 67}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 34, 168, 161, 60}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 240}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 131, 119, 72, 97, 109, 124}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 64, 239, 114, 164, 192, 114, 255}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 14, 2, 159, 209, 219, 4, 104}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 172, 64, 23, 229, 206, 134, 249, 26}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 0, 189, 92, 133}, 65},
	{{21, 52, 9, 86, 224, 0, 211, 92, 68, 14, 78, 223, 121, 122, 219, 197}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 0, 0, 0, 113, 15, 168, 202}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 186, 221, 84, 67, 172, 118, 13, 127, 1}, 65},
	{{21, 52, 9, 86, 224, 0, 0, 0, 0, 129, 167, 239, 82, 141, 177, 94}, 65},
	{{203, 81, 49, 171, 224, 0, 0, 16, 135, 71, 130, 161, 145, 197, 16, 151}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 76, 226, 251, 146, 98}, 39},
	{{203, 81, 49, 171, 224, 203, 219, 116, 30, 214, 186, 66, 128, 229, 33, 176}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 173}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 160, 128, 131}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 28}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 35, 34, 92}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 164, 235, 0, 174}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 196, 99, 178, 149, 104}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 156, 255, 60, 189, 86, 64, 200, 190, 213}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 226, 185, 175, 252, 96, 122, 152}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 254, 64, 26, 9, 41, 172, 17, 188}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 176, 167, 105, 73}, 39},
	{{203, 81, 49, 171, 224, 0, 51, 248, 140, 139, 197, 27, 96, 234, 166, 132}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 144, 151, 97}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 162}, 39},
	{{203, 81, 49, 171, 224, 118, 185, 227, 3, 85, 48, 157, 4, 136, 102, 64}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 22, 16, 42, 157}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 53, 136, 2, 193, 217, 106}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 170, 207}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 113, 27, 52, 246, 45}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 103, 119, 13, 41, 239, 169, 79}, 39},
	{{203, 81, 49, 171, 224, 0, 198, 0, 135, 37, 234, 116, 148, 250, 242, 218}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 125, 183, 24, 43, 24, 62, 201}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 229}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 183, 45}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 39},
	{{203, 81, 49, 171, 224, 81, 224, 120, 136, 34, 11, 194, 27, 108, 129, 109}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 79}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 10, 97, 136, 114, 39, 99, 215}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 241, 35, 163, 211, 204, 214}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 69, 30, 109, 112, 50}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 167}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 67, 57, 221, 139, 18, 41, 21, 103}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 187}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 14, 88, 229, 58}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 134}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 150, 149, 239}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 69, 167, 18}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 30, 159, 40, 109, 122, 25}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 82, 131, 134, 219, 66}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 211, 167, 51, 250, 59, 32, 229}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 103}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 145, 100, 93}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 15, 169}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 140, 204, 83, 211, 213, 168}, 39},
	{{203, 81, 49, 171, 224, 193, 76, 143, 127, 45, 37, 35, 165, 173, 43, 87}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 93, 85, 128, 42, 69, 45}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 174, 120, 168}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 51, 151, 93, 9, 8, 243, 79}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 138}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 99, 50, 157}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 202}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 12, 250, 132, 229, 51, 67}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 119, 222, 0, 29, 132}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 138, 249, 120, 53, 176, 73, 148, 109, 82}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 231}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 19, 219, 12, 94, 48}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 57, 148, 238, 227, 16, 173}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 44, 165, 190, 244, 89}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 137, 141, 226, 114, 255, 198, 26}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 133}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 95, 29, 18, 97, 151, 187}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 11, 230, 182, 175, 130}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 202, 178}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 81, 163, 151}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57, 69}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 58, 18, 41, 193, 49, 129, 72, 34, 27}, 39},
	{{203, 81, 49, 171, 224, 33, 36, 62, 193, 26, 92, 153, 222, 212, 61, 148}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 87}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 39},
	{{203, 81, 49, 171, 224, 122, 28, 161, 3, 139, 87, 78, 31, 86, 96, 159}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 120, 193, 74, 24, 151}, 39},
	{{203, 81, 49, 171, 224, 0, 93, 41, 101, 238, 24, 116, 164, 110, 98, 19}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 63}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 21, 186, 188, 206, 20}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 196}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 93}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 222, 86, 44, 105, 220, 240}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 113, 104}, 39},
	{{203, 81, 49, 171, 224, 39, 235, 140, 157, 202, 10, 36, 101, 127, 121, 179}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 149, 48, 203, 255, 232}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 191, 182, 110}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 71, 12, 170}, 39},
	{{203, 81, 49, 171, 224, 0, 236, 175, 158, 245, 210, 3, 11, 65, 188, 156}, 39},
	{{203, 81, 49, 171, 224, 0, 51, 242, 133, 207, 145, 101, 14, 59, 13, 111}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 147}, 39},
	{{203, 81, 49, 171, 224, 66, 179, 4, 176, 85, 112, 95, 71, 153, 91, 203}, 39},
	{{203, 81, 49, 171, 224, 0, 59, 59, 206, 203, 215, 173, 213, 84, 182, 229}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 222, 162, 140, 52, 48, 205}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 3, 42, 156, 86}, 39},
	{{203, 81, 49, 171, 224, 0, 0, 0, 0, 0, 0, 0, 0, 69, 21, 212}, 39},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 168, 1, 200}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 209, 142}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 119, 244, 164}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 68, 194, 221, 142}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 178, 207, 126}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 235, 7, 138, 10}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 128, 31, 25}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 117, 243, 196}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 99, 140, 52}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 193, 147, 67}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 124, 184, 37}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 224, 89}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 164}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 164, 214, 143}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 42, 212}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 125, 230, 18}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 69}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 157, 118, 127}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 89, 239}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 108, 16, 174, 32}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 18}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 236, 60, 134}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 146}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 216, 112}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 160, 10}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 247, 102, 82}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 115}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 55, 114}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 153, 103, 0, 216}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 13}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 103}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 128, 101}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 50, 5, 60}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 30, 7, 92, 138}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 159, 68, 207}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 61}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 183, 177}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 127}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 11, 7}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 37}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 98}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 7}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 220, 65}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 145}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 227, 255, 229, 58}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 237, 67, 173}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 164}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 245, 248, 185}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 72, 253, 173, 252}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 147, 78, 170, 69}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 201}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 91, 178, 204, 237}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 204}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 18, 45, 64, 226}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 219, 27}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 235, 10}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 26}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 123}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 11, 178, 29}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 125, 8}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 135}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 163, 128}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 75, 241, 201}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 102, 204}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 149, 116, 83}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 68}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 118}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 22}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 142, 154, 227}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 4, 223, 107, 192}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 53}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 212}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 107}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 183}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 165, 234, 12, 132}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 0, 0}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 253, 141}, 162},
	{{211, 218, 87, 244, 93, 181, 118, 41, 156, 143, 254, 0, 0, 0, 70, 129}, 162},
	{{77, 64, 0, 0, 0, 0, 0, 165, 234, 71, 48, 174, 146, 240, 112, 2}, 69},
	{{77, 64, 0, 0, 0, 232, 191, 31, 22, 206, 179, 104, 86, 254, 81, 120}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 166, 4, 108, 65, 136, 186, 144, 5}, 69},
	{{77, 64, 0, 0, 0, 0, 90, 203, 103, 108, 76, 100, 76, 109, 181, 219}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66, 57, 22, 37}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 47, 199, 101, 157, 191, 174, 194, 108, 113}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 225, 42}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 111, 69, 108, 0, 242, 226, 45}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55}, 69},
	{{77, 64, 0, 0, 0, 36, 107, 213, 229, 54, 252, 240, 8, 131, 21, 45}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 75, 71, 4, 199}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 226, 192, 106, 252}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 96, 124, 130, 104, 249, 249}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65, 37, 160, 127}, 69},
	{{77, 64, 0, 0, 0, 80, 0, 249, 49, 193, 233, 104, 139, 11, 17, 198}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 84, 234, 132, 103, 8}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 189, 245, 9, 242, 216}, 69},
	{{77, 64, 0, 17, 204, 206, 73, 13, 225, 94, 182, 79, 100, 61, 21, 125}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 142, 208}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 27, 140, 124, 219, 104}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 143, 12, 158, 89, 233, 234}, 69},
	{{77, 64, 0, 0, 0, 134, 174, 168, 25, 79, 181, 206, 122, 251, 247, 176}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 69},
	{{77, 64, 167, 21, 150, 44, 57, 207, 154, 30, 22, 175, 182, 226, 78, 117}, 69},
	{{77, 64, 0, 0, 0, 151, 112, 98, 23, 11, 132, 123, 75, 237, 239, 69}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 131, 53, 96, 244, 57, 34, 191, 149}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 101, 17, 136, 216, 67}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 71, 83, 105, 87, 25, 250, 199}, 69},
	{{77, 64, 0, 225, 185, 124, 222, 127, 231, 17, 67, 145, 165, 31, 158, 104}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 130, 241, 13, 22, 45, 25, 205, 160, 56}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 50, 174, 208, 219, 24, 157, 49, 45, 145}, 69},
	{{77, 64, 0, 0, 0, 0, 128, 187, 132, 156, 4, 211, 49, 77, 64, 71}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 69},
	{{77, 64, 48, 109, 53, 241, 191, 175, 179, 41, 221, 173, 120, 225, 70, 87}, 69},
	{{77, 64, 0, 0, 164, 13, 161, 60, 227, 152, 93, 20, 89, 49, 209, 33}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 43, 118, 139, 81, 29, 27, 56, 11}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 48, 68, 176, 233, 248, 161, 102}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 176, 212, 8, 228}, 69},
	{{77, 64, 0, 0, 131, 110, 171, 117, 216, 251, 12, 208, 58, 80, 199, 163}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 152, 53, 203, 150}, 69},
	{{77, 64, 0, 0, 0, 43, 51, 8, 187, 220, 129, 116, 3, 159, 66, 42}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 201, 103, 240, 228, 26, 183, 96, 158}, 69},
	{{77, 64, 0, 0, 0, 0, 84, 217, 57, 110, 150, 2, 167, 171, 60, 71}, 69},
	{{77, 64, 147, 217, 187, 7, 18, 211, 32, 123, 51, 71, 139, 85, 184, 186}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 141, 41, 148, 245, 190, 48}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 37, 104, 223}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 98, 26, 47, 15, 157, 160, 73, 112, 167}, 69},
	{{77, 64, 0, 141, 117, 47, 115, 44, 92, 128, 246, 61, 253, 71, 174, 179}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 122, 156, 120, 227, 210, 216, 18}, 69},
	{{77, 64, 0, 0, 0, 0, 254, 205, 119, 150, 5, 27, 114, 251, 124, 108}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 228, 74, 189, 28, 236, 184, 189, 137}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 122, 251, 97, 202, 8}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 69},
	{{77, 64, 0, 188, 145, 70, 192, 141, 199, 107, 141, 69, 235, 234, 72, 197}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 199, 38, 34, 197}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224, 82, 39}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 194, 94}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 137, 221, 134, 231}, 69},
	{{77, 64, 0, 253, 128, 227, 30, 209, 134, 74, 215, 110, 106, 165, 178, 13}, 69},
	{{77, 64, 0, 0, 128, 52, 185, 200, 219, 211, 120, 164, 177, 225, 62, 164}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 121, 246, 98, 123, 115}, 69},
	{{77, 64, 228, 240, 14, 49, 201, 141, 185, 79, 45, 113, 230, 224, 137, 233}, 69},
	{{77, 64, 0, 0, 0, 0, 134, 199, 92, 35, 148, 132, 16, 112, 114, 126}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 215, 78, 79, 153, 51, 92}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 215}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 122, 199}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57, 156, 4, 112}, 69},
	{{77, 64, 129, 7, 132, 191, 61, 212, 150, 209, 17, 206, 241, 214, 101, 142}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 254, 248}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 227, 52, 139, 22, 25, 61, 199, 250, 166}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 141, 183, 72, 175, 2, 194, 86, 144}, 69},
	{{77, 64, 0, 20, 217, 125, 53, 61, 7, 77, 72, 75, 35, 98, 248, 129}, 69},
	{{77, 64, 230, 123, 155, 33, 164, 118, 129, 109, 131, 202, 96, 97, 18, 125}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 110, 2, 222}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 166, 123, 224, 227, 201, 170, 163}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 181, 248, 246, 94}, 69},
	{{77, 64, 225, 228, 243, 104, 236, 3, 227, 203, 214, 196, 174, 109, 171, 207}, 69},
	{{77, 64, 0, 0, 0, 0, 98, 202, 184, 6, 67, 22, 213, 153, 41, 135}, 69},
	{{77, 64, 0, 29, 134, 90, 105, 135, 254, 135, 249, 30, 161, 97, 48, 199}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 161}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 109, 63, 227}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 165}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 138, 231}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 110, 29, 99, 62, 41, 113, 227, 150}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 144, 45, 4, 215, 222, 11, 227, 83}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 239}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 85, 118, 9, 208, 129, 184, 131, 87, 105}, 69},
	{{77, 64, 0, 0, 201, 143, 1, 202, 83, 201, 157, 151, 175, 167, 249, 167}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 205, 219, 54, 13, 197}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 145, 165, 192, 167, 29, 226}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 228, 160, 209, 232}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 0, 105, 224, 64, 255, 179, 163, 51}, 69},
	{{77, 64, 0, 0, 0, 0, 0, 0, 21, 173, 146, 181, 6, 137, 136, 219}, 69},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 129, 132, 122}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 58}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 116, 32, 55}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 173, 25, 60}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 70, 57, 44, 0, 215}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 213, 65, 217}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 153, 246, 54}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 0}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 72}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 100}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 152, 45, 129, 87, 1, 92, 26}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 88}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 64, 120, 66}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 147}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 112, 53, 157, 142}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 225, 226, 129}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 152, 162, 70, 116, 173, 247}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 49, 196}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 171}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 87, 82}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 205}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 94, 202, 12, 84, 221, 216}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 161, 225, 227}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 0}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 81, 242}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 223, 49, 33, 254, 154, 116, 183}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 32}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 79, 153, 245, 226, 63, 75, 230}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 0}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 187}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 230, 73, 197, 88, 233}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 0}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 249, 107, 81, 235, 214}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 0}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 110, 193, 243, 108, 135, 44, 189}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 120, 199, 220}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 0}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 140, 11, 28, 113, 26, 139, 242}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 122, 62, 160, 44, 149}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 218, 65, 171, 233, 170, 139, 119}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 162, 248, 85}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 19}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 90, 195, 10, 135, 16, 90, 16}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 208, 60, 208, 109}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 156, 237}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 0}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 37}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 219, 193, 122}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 227, 120, 237, 141, 242, 153, 94}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 117, 217, 31, 184, 28, 126, 45}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 137, 67, 20, 155}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 114, 166}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 53, 186, 115, 95, 243, 53, 185}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 157, 242}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 7, 157, 29, 104, 135}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 61, 141, 164}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 236, 6, 95, 108}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 0}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 230, 21, 11, 204, 19, 10, 105}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 0}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 155, 249}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 0}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 134}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 42}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 0}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 254, 135}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 11, 26, 17}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 43, 221, 9}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 202, 206, 170, 110, 12, 15}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 115, 70}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 141, 67, 145, 193, 88}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 227, 106, 30}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 0}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 12, 179, 221, 194, 20, 180, 218}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 69, 47, 245}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 31, 203}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 75, 253, 30, 22}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 44, 182, 141, 82}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 190, 69, 194, 161, 82, 71, 21}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 83, 83}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 0}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 76}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 137, 105, 252, 182, 94, 161}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 165, 128, 251, 153, 119, 113}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 152, 98, 174}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 138, 252, 222, 48, 250, 28, 189}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 181, 88, 60, 204, 84, 163, 252}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 231, 123, 145, 203}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 58, 11, 97, 142}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 28, 154, 2, 168}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 74, 139, 116, 255, 197, 243}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 19, 142, 42}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 33, 45}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 162, 86, 31, 108, 19, 210}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 0}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 123, 153, 179, 57}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 177, 101, 77, 253, 131}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 145, 58, 17, 110, 141}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 0, 0, 0, 0, 0, 0, 163}, 163},
	{{158, 219, 219, 39, 4, 219, 100, 63, 0, 138, 80, 52, 159, 111, 218, 219}, 163},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 222, 117, 141}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 75, 237}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 13, 228}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 26, 28, 207}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 82, 181, 109}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 213, 172}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 197}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 75}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 242}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 157}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 104, 39, 118, 49}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 37, 149, 202, 226}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 164}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 6, 203, 6, 147}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 96, 189}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 226, 194, 209}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 50}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 1, 84}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 41, 23, 127}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 90, 114}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 7, 164}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 107, 19, 175}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 192, 49, 116}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 141}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 212}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 87, 34, 108}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 206, 188, 103, 60}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 220, 146, 73}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 205, 77, 244, 11}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 16, 89}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 124, 211, 85, 251}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 223, 62}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 48, 238, 160}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 181, 155}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 200}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 252, 80, 253}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 99, 97, 175}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 253, 40, 24, 48}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 101, 80, 18, 95}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 201, 47}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 204, 138, 152}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 32}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 192, 119}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 43, 96, 110}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 31, 216}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 248}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 72, 66, 150}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 140}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 155, 10, 132, 212}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 165, 108, 197}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 16, 59, 2}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 154, 41, 151, 106}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 116, 128, 73, 95}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 79, 29, 186, 128}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 72, 253}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 175, 177, 103}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 120}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 224, 124, 209, 185}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 28, 121, 48, 25}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 80, 92}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 221, 234, 124}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 145}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 108, 51, 162}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 123, 103}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 167}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 2}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 222}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 54, 124, 113, 164}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 141, 192, 92}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 228, 112, 183}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 0}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 0, 0, 63}, 116},
	{{61, 50, 232, 1, 185, 252, 243, 54, 189, 240, 170, 192, 0, 178, 221, 240}, 116},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 90, 89, 18, 131, 8, 219, 115}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 82}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 154, 11, 2, 179, 70}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 123, 246, 85, 115, 13, 18, 153, 136, 75}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 62, 67, 40, 94, 23, 225, 182, 127, 33}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 105, 103, 180, 97}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 208, 252, 220, 233, 20}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 235, 82, 146}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 229, 51, 134, 213, 2, 206, 111, 73}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 25, 43, 97, 22, 10, 239}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 250, 142, 158, 5, 6}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 142}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 160, 15, 42, 163}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 126, 225, 128, 47, 67, 46, 36}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 125, 46, 91, 107}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 212, 216, 127}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 215, 10, 17, 146, 252}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 230, 231, 78, 52, 64}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 106}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 215, 210, 25, 48, 184, 227}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 147, 147, 20, 136, 11, 193, 119, 188, 163}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 93, 173}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 181, 113}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 81, 205, 136, 92, 101, 175}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 22, 123, 95, 249, 16, 191}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 131, 97, 170}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 47, 8}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 253, 186, 217, 183}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 92, 51, 39, 100, 80, 39, 199, 47, 35}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 34, 164, 125, 84, 121, 80}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 217}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 179, 182, 210, 73, 155, 255, 101}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 226, 50, 91, 77}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 125, 14, 143, 94, 113, 119, 207}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 134}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 202, 55}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 171, 153, 136, 69, 196}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 167, 39, 190}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 42, 41, 208, 228, 228, 84, 90}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 43, 35}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 183}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 170, 223, 121, 200, 130, 69, 100, 244, 190}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 210, 155, 77, 4}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 186, 161, 192, 226, 6, 103}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 231}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 163, 3, 209, 205, 82}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 221, 178, 7}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 139, 17, 253, 135}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 56, 26, 153}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 139, 217, 161, 189}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 78}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 165, 2, 157, 16, 53, 7, 1, 179}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 105, 35, 8, 173, 247, 241, 224, 196}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 195, 133}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 252, 155, 2, 128, 150}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 94, 3, 67, 208, 33, 79, 81, 154}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 114, 33, 26, 238}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 70, 77, 134, 66, 112}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 187, 204}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 212, 127, 85}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 219, 142}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 38, 214, 145, 168, 230, 23}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 249, 168, 141, 10, 41, 129, 212}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 126, 56, 161, 190, 82, 129, 231, 252}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 108}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 2, 86, 116}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 82, 41, 76, 245, 207, 160, 56, 157}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 108, 157, 207}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 117, 132, 193, 245, 109, 119, 55}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 209, 118, 138, 210, 94, 11}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 208, 64, 87, 39, 82, 120, 219}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 1, 193, 228, 184, 13, 10, 255, 134}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 123, 87, 148, 171}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 145, 138, 42, 255, 20, 189, 24, 142}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 92, 91, 149, 66, 89}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 80, 221, 155, 158, 200, 230}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 90, 138, 178, 108, 94, 62}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 90, 183, 183, 20}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 123}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 46, 247, 226, 251}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 76, 191, 138}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 21, 253, 109, 255, 174, 25, 113}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 232, 203}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 165, 77, 185}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 68, 109, 14, 93, 181, 119, 50, 244}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 238, 118, 220, 211, 33, 234}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 186, 141, 115, 196}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 135, 1, 104, 6, 57, 132, 2}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 159, 43, 36, 57, 69}, 19},
	{{241, 143, 33, 19, 247, 55, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 19},
	{{61, 28, 61, 252, 32, 0, 0, 193, 42, 192, 42, 57, 183, 244, 90, 150}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 244}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 236, 50, 37, 97, 144, 173, 183}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 252, 116, 40}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 89, 47}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 73, 32}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 176, 139, 139, 76, 8}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 178, 190, 35, 141}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 228, 70}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 124, 122, 144, 3, 20, 240, 233, 209, 85}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 191, 201, 229, 138, 111, 127, 241}, 48},
	{{61, 28, 61, 252, 32, 62, 202, 154, 145, 219, 67, 196, 241, 25, 158, 224}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 217, 158, 219, 228, 44, 187}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 252, 9, 218, 156, 70}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 131, 37, 29, 231, 189, 28, 108, 44}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 209, 137, 203, 85, 70, 42}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 29, 94, 113, 235, 158, 186, 4, 116}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 181, 70, 40, 46, 7, 162, 30, 172}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 25, 38, 229, 9, 71, 129}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 144, 130, 165, 11, 190, 50, 142, 163, 120}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 238, 43, 218, 168, 89, 182}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 248, 86, 154, 227}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 111, 238, 245, 59, 108}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 183, 84, 209, 151}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 45, 235, 180, 93, 245}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 147, 27, 202, 220, 243, 167, 215, 196}, 48},
	{{61, 28, 61, 252, 32, 0, 53, 24, 102, 217, 140, 162, 180, 249, 14, 47}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 107, 212}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 238, 85, 146, 140, 136, 199}, 48},
	{{61, 28, 61, 252, 32, 0, 67, 89, 144, 121, 52, 168, 108, 79, 236, 9}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 166, 156, 123, 65, 133, 7, 237, 126, 74}, 48},
	{{61, 28, 61, 252, 32, 0, 151, 13, 81, 42, 90, 60, 131, 40, 15, 155}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 17, 241, 182, 95, 229, 25}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 200, 180, 58, 116, 165, 247}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48, 220}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 21, 160, 139, 57, 136, 137, 129, 53}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 96, 253, 16}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 172, 33, 162, 66, 219, 33}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 132, 14, 133, 14, 164, 181, 245, 162}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 66, 120, 239, 153}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 221, 232, 164, 145}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 249}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 238, 230, 236, 223, 101, 174, 222, 135, 113}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 84, 27, 105, 34, 27}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 66, 30, 137, 116, 21, 22, 205, 149, 206}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 108, 79, 165, 26, 88, 140, 25, 100, 203}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 22, 27, 140, 85, 152, 221, 215}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 39, 64, 17, 57, 41, 85}, 48},
	{{61, 28, 61, 252, 32, 91, 177, 166, 253, 15, 36, 15, 202, 134, 101, 107}, 48},
	{{61, 28, 61, 252, 32, 0, 227, 131, 82, 154, 130, 166, 236, 162, 113, 196}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119, 131}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 152, 180}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 123, 74, 8, 224, 87, 188, 196}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 19, 188, 112, 217, 53, 36}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25, 102}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 162, 117}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 25, 197, 238, 63, 88}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 34, 25, 127}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 218, 83}, 48},
	{{61, 28, 61, 252, 32, 0, 126, 96, 102, 119, 34, 96, 79, 63, 205, 202}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 194}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 34}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 148, 103, 254}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 246, 181}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 107, 6}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 95, 59, 147}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 253, 84, 180, 176, 80, 104, 94, 0}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 158, 90, 241, 56, 5, 155, 123, 64}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 60, 126, 130, 43, 108, 240, 167}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 235, 24}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 197, 94, 211}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 237, 20, 86, 4}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 165, 250, 218, 17, 248, 71, 120}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 154, 110, 216, 235}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 70}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 108, 144}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 9, 95, 209}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 107, 148, 21, 123, 17, 95, 11, 139}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 83, 16, 37, 103}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 182, 20, 115, 200, 151, 214}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 226, 229, 175, 36, 101}, 48},
	{{61, 28, 61, 252, 32, 70, 192, 176, 128, 196, 116, 226, 37, 235, 14, 67}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 170, 203, 221, 215, 137, 190, 110, 49, 179}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 247, 48, 252, 235, 73, 246, 40}, 48},
	{{61, 28, 61, 252, 32, 0, 117, 227, 153, 131, 94, 36, 108, 26, 155, 83}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 47, 2, 101, 191, 84}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 255, 36, 143, 237, 213, 79, 255, 130}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 54, 134, 198, 104, 83, 211, 214}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 42, 27, 106, 48, 208, 57, 120, 244}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 91, 6, 93}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 48}, 48},
	{{61, 28, 61, 252, 32, 0, 61, 172, 29, 245, 112, 175, 75, 99, 89, 198}, 48},
	{{61, 28, 61, 252, 32, 0, 0, 0, 0, 110, 11, 108, 207, 102, 2, 220}, 48},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 41, 69, 20, 63, 206}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 91, 105, 72, 62, 179, 94, 180}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 178, 40, 137, 244}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 51, 187, 58, 8, 156, 36, 115}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 123, 234, 89, 70, 33, 71}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 169, 108}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 185, 95, 145, 110, 225}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 243, 244}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 150, 204, 18, 198, 8, 50, 251, 203, 23}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 151, 152, 62, 253, 20, 77, 85}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 71, 160, 177, 162, 189, 8}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 224, 34, 103, 255}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 207, 255, 19, 87, 105, 164, 88}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 50, 51}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 110, 85, 118, 205, 6}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 215, 98, 60, 202, 63, 144, 72}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 161, 105, 223, 61, 253}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 60, 115, 179, 65, 140, 68, 21, 230, 200}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 41, 40, 9, 133}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 200, 111, 223, 90, 49, 162}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 80, 61, 94, 139, 248}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 189, 243, 15, 184, 141, 88, 67}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 197, 6}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 53}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 169, 219, 238}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 231, 94, 110, 213, 196, 125, 138}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 190, 110, 94, 218, 17, 67, 82}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 178, 64, 101}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 159, 66, 75}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 26}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 64, 177, 81, 12}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 49, 152, 54, 18, 77}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 247, 151, 12, 14}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 91, 226, 96, 240, 101, 231, 202}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 223, 226, 190, 139, 41, 190, 10, 216}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 251}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 195, 212, 68, 246, 22, 38}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 59, 244, 151, 184, 143, 115, 129, 169, 233}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 142, 191, 14, 232}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 161, 45, 225, 25}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 151}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 134, 187, 4, 116, 195, 208}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 71, 92, 76, 191, 12, 88}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 39, 37}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 38, 145, 22}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 44, 148, 56, 122, 189, 2, 43}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 138, 191, 47, 148, 206, 214, 37, 102, 187}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 25}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 202, 201, 171, 193, 251, 184, 85, 101, 151}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 137, 131, 251, 52, 90, 179}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 42, 48, 177, 184}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 158, 17, 55, 118}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 110, 72}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 203, 1, 31, 240}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 76, 39, 219, 186, 187, 174, 95, 62}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 62, 184}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 134, 223, 90, 232, 234, 68}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 126, 22, 16, 182, 216}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 34, 96, 243, 98, 0}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 136}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 246, 130}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 33, 134, 207, 191, 218, 91}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 153, 118, 57}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 148, 138, 148, 80, 121, 194}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 112, 164, 121, 113, 95}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 251, 177, 186, 14}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 208, 171, 113, 249, 99, 203}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 196, 237, 49, 183, 85, 132, 166, 240, 123}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 126, 175}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 213, 132, 150, 4, 83}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 71, 196, 16, 127, 10, 31}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 163, 101, 127, 179, 92, 146}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 51, 91, 163, 19, 31}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 135, 216}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 57, 186, 231, 86, 77, 109}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 87, 110, 181, 3, 138, 210}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 115, 172, 192, 27, 203, 235, 184}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 163}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 203, 198, 137, 182, 116, 157, 204}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 7, 94, 88, 143, 145, 159, 215}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 87, 174, 118, 41, 167, 4, 117, 93, 155}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 246, 53, 1, 125, 250}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 0, 97, 189}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 0, 0, 0, 0, 0, 35, 36, 243}, 230},
	{{102, 112, 194, 108, 90, 253, 128, 0, 150, 135, 159, 90, 101, 136, 29, 93}, 230},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 0}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 185}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 152}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 77}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 234, 174, 218}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 155, 219, 70}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 150, 174, 172, 242}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 214, 204, 57, 16, 161}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 15, 42, 9, 2, 92}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 30}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 0}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 86}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 205, 44, 109, 195}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 62}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 126, 227, 143, 43, 112, 101}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 33, 102, 136}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 174, 61, 103, 251}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 210, 33, 93, 88, 136}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 0}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 35, 96, 79, 11}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 0}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 202}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 77}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 155, 180, 239, 196}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 171, 47, 17}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 234, 168, 182}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 67, 207, 131, 58, 123}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 193}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 124}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 92, 176, 76, 122}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 0}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 45, 171}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 203}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 251}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 15, 212, 201, 76, 58}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 17, 53}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 3, 187, 210, 8, 153}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 172, 70, 139, 92}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 229, 44, 90}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 178}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 99}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 173, 142, 64}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 205, 103, 251, 212, 240, 149}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 58, 221, 17, 157, 218, 91}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 208, 185}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 0}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 192, 213, 197}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 116, 110, 126, 48}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 148, 155, 38, 125, 238}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 235, 75, 53}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 9, 144, 36}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 76, 110}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 134, 177, 156, 160}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 210, 201, 203, 23, 89}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 144, 189, 47, 116, 168}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 9, 162, 40, 93}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 12, 161, 189}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 58, 46, 195, 163, 70}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 183, 191}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 13, 161, 68, 172, 61}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 200, 138, 13, 79, 0}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 0}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 192, 17}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 229, 44, 86, 224, 99}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 0}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 182}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 0}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 103, 75, 249, 63}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 160, 139, 148, 244, 89, 26}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 0}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 138, 52, 47, 74}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 214, 224, 51}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 0}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 241}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 104, 144, 59, 36, 248}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 245, 120}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 91, 99, 145, 49, 167}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 187, 186, 147}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 220, 112, 86, 121}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 0}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 196}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 153, 245, 57}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 0}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 251, 130, 215}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 170, 77}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 7, 160, 80, 185}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 141, 226, 45, 60}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 225, 216, 12, 93, 34}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 0}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 17, 146}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 253, 29, 1}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 72, 196}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 0, 1}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 99, 133}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 244, 191, 56, 6}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 49, 145, 82}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 17, 4, 173, 71, 163}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 0, 200, 16}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 0, 0, 137, 78, 176}, 155},
	{{74, 88, 58, 66, 172, 41, 144, 204, 195, 240, 0, 35, 133, 29, 2, 180}, 155},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 6, 174, 34}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 255}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 122}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 67, 34}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 175, 23}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 99}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 56, 155, 100}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 89, 38, 93}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 41, 202}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 63, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 89, 115}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 158}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 165}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 65, 223}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 188, 128}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 163, 36, 136}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 244}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 73}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 3, 200, 171}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 46, 41}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 1, 87, 65}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 183}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 87, 182, 98}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 22, 244, 32}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 245, 242, 58}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 132, 224, 191}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 209}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 71}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 149, 39}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 185, 154}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 63}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 146}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 21}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 128, 197, 77}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 213, 11}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 212, 157}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 114, 109, 21}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 122}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 84, 218}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 189}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 218, 5}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 91, 123}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 55, 143, 3}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 35}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 159}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 9, 117, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 68, 251, 213}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 154}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 82}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 212}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 212}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 59, 179}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 195, 183, 139}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 104}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 142, 168, 231}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 76}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 106}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 63}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 7, 18}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 68, 64, 250}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 215}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 217}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 65, 115, 83}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 171, 195, 110}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 147, 181, 238}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 239}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{44, 148, 187, 58, 190, 59, 190, 187, 124, 138, 222, 131, 0, 0, 0, 0}, 158},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 247}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 227}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 228}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 2}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 79}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 122}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 247}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 97}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 216}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 168}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 134}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 99}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 219}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 107}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 106}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 98}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 195}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 171}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 87}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 213}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 143}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 242}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 137}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 85}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 32}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 130}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 29}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 31}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 64}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 50}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 226}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 93}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 74}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 128}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 241}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 54}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 6}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 6}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 0}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 86}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 111}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 88}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 81}, 252},
	{{67, 7, 216, 139, 93, 224, 20, 135, 186, 86, 209, 111, 60, 80, 0, 85}, 252},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 242}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 137, 67}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 61, 219}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 120}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 235}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 156}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 97}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 70, 151}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 235}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 99}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 143}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 199}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 3}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 161, 57}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 175}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 213}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 49, 202}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 105, 30}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 43}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 173}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 111}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 245, 111}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 23}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 220}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 209}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 17}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 150}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 77}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 212}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 41}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 11}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 130}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 69, 4}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 5}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 215}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 106, 75}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 1, 25}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 246}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 10}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 254, 52}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 31}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 199}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 66}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 36}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 20, 179}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{209, 26, 12, 174, 5, 101, 164, 181, 237, 63, 192, 57, 54, 120, 0, 0}, 176},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 223}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 244, 103, 188, 138, 148, 90}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 26, 255, 79, 17, 99, 112}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 89, 244, 64}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 6, 68, 117, 11, 135}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 229, 122, 225, 180, 233, 30, 40}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 85}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 56, 15}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 83, 155, 189, 63, 255, 135}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 99, 34, 204, 133, 91}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 84, 32, 144, 220}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 220, 11, 110, 126}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 104, 73, 228}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 148, 112}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 50, 24, 231}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 223}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 20, 185, 164, 5, 129, 82}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 104}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 122, 81, 54, 227}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 56}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 162, 4, 36, 103, 147, 83}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 211}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 242, 204, 78, 87, 160, 252, 174}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 181, 57}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 211, 43, 85, 10}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 64, 25, 222, 56, 2, 162}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 9, 105, 84, 31, 80}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 1, 169, 176, 22, 232, 155, 182}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 68}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 165}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 103, 187, 66, 32, 60, 194, 224}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 249}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 210, 30, 107, 229, 30, 108}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 253, 188, 139, 217}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 248}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 203, 159, 40}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 93}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 218, 110}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 210}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 36, 112, 202, 216, 32, 82, 59}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 218, 241, 142, 166, 164}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 213, 176, 20, 119, 232}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 237, 168, 58, 142}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 87, 185, 123}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 220, 98, 236, 28, 145, 223}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 64, 224, 9, 101, 36, 25, 6}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 253, 146, 90, 9, 153, 17, 247}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 104}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 4, 38, 18, 151}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 179}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 94, 142, 154, 82, 23}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 236, 227, 195, 121, 160, 5}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 3, 31, 201, 202}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 82, 66, 32, 184, 21, 83, 201}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 248, 145}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 121, 249, 184, 84, 187, 212}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 175, 246, 239, 151, 120, 184, 164}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 222, 65, 87}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 222, 180, 49, 7}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 117, 157}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 83, 200, 192}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 60, 187, 150, 251, 227, 233, 73}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 246}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 15}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 45}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 99, 96, 249, 55, 231}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 210, 73}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 71, 164, 50}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 161, 39, 205, 200, 255}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 190, 70, 79, 193}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 254}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 120, 63, 124, 218, 97}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 126, 97}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 234}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 164, 51, 185, 58, 140}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 161}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 101, 118}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 96, 15, 69, 183, 9, 51}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 0, 0, 72}, 211},
	{{4, 66, 232, 52, 239, 56, 48, 58, 192, 0, 0, 0, 0, 79, 28, 205}, 211},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 168, 212, 63, 217, 114}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 184, 11, 45, 175, 102, 162, 129}, 15},
	{{158, 165, 2, 144, 0, 0, 164, 190, 2, 69, 8, 229, 42, 246, 94, 193}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 135, 226, 50, 109, 49}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 105, 112, 0, 57, 22, 74, 106}, 15},
	{{158, 165, 2, 144, 0, 99, 52, 105, 55, 99, 196, 103, 118, 251, 125, 10}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 112, 81, 62, 136, 229, 117}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 33, 51}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 196, 176, 6, 157, 228}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 242, 187, 19, 183, 48}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 140, 165, 250, 100, 209, 58, 31}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 231}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 139, 44, 229, 214, 149}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 214, 196, 118, 127, 243, 146}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 86}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 29, 122}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 33, 3, 250, 127, 202, 80, 136}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 97, 206, 143, 179, 122, 145, 209}, 15},
	{{158, 165, 2, 144, 0, 114, 203, 135, 37, 219, 86, 157, 53, 198, 142, 145}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 60, 122, 162, 173, 238, 168, 69, 54, 134}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 62}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 208, 155, 72, 156}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 81, 57}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 226, 65}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 206, 45, 131, 27, 109}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 23, 203, 230, 21, 178, 110, 233}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 156, 88, 59, 172, 4}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 126, 215}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 202, 139, 167}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 239}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 236, 172, 59, 220, 74}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 103, 189, 61, 222, 216, 53}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 54, 48, 108, 144, 28, 109, 36, 22}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14}, 15},
	{{158, 165, 2, 144, 0, 0, 34, 237, 164, 160, 9, 49, 3, 181, 134, 70}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 211, 204, 65, 142, 59, 99}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 44, 246, 168, 202, 142, 23, 118}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 43, 38, 227, 60, 214, 98, 234, 158}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 120, 92, 177, 216, 77, 9, 10, 181, 118}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 129, 78, 46, 65, 249, 17}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 65, 190, 63, 107, 33}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 71}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 15},
	{{158, 165, 2, 144, 0, 195, 80, 190, 224, 69, 53, 186, 111, 65, 233, 242}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 194, 206, 222, 241, 51, 180, 199}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 58, 187, 173, 203, 158, 5, 91, 189}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 135, 121, 135, 33}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 180, 184, 89, 232, 184, 147, 125, 172}, 15},
	{{158, 165, 2, 144, 0, 0, 240, 221, 200, 172, 252, 77, 29, 174, 241, 132}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 245, 77, 217, 59, 112}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 34, 42, 208, 8, 169}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 46, 56, 109}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 86, 134, 20, 49, 43, 96}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 165}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 231, 218, 108, 72, 117, 38, 139, 181, 127}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 213, 131, 46}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 20, 47, 77, 124, 176, 168, 52, 89}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 126, 247, 81, 21, 153}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 251, 14, 38, 22, 77, 152}, 15},
	{{158, 165, 2, 144, 0, 0, 121, 121, 113, 73, 14, 116, 14, 143, 182, 72}, 15},
	{{158, 165, 2, 144, 0, 140, 161, 29, 203, 84, 31, 9, 130, 186, 184, 154}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 190, 200, 16, 238, 68, 158, 139, 106, 73}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 12, 203, 141, 0, 194, 11, 250}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 188, 221, 255, 214}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 133, 229, 55, 89, 86, 211, 107, 128, 180}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 159, 2, 171, 193, 86, 223, 23, 82}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 189, 154, 113, 26, 7, 3}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 183}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 85, 233, 6, 231}, 15},
	{{158, 165, 2, 144, 4, 71, 57, 2, 118, 14, 18, 88, 74, 68, 10, 222}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 65}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 167, 182, 198, 1, 55}, 15},
	{{158, 165, 2, 144, 0, 0, 232, 17, 7, 172, 232, 22, 76, 63, 30, 64}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 191, 211, 187, 149, 173, 0}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 78, 195, 36, 128, 241, 79}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 80, 149, 90, 83, 129, 236, 89, 226, 219}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 25}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 74, 170, 156, 116, 62}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90, 55}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 151, 166, 89, 128, 194, 47, 241, 120}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 78, 162, 16, 85, 143, 22}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 138, 13, 197}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 55, 109, 104}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 216, 120, 10, 251, 35}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 251, 181, 72, 247, 5, 130}, 15},
	{{158, 165, 2, 144, 161, 121, 51, 99, 220, 53, 183, 198, 229, 31, 225, 50}, 15},
	{{158, 165, 2, 144, 0, 80, 180, 182, 193, 160, 244, 3, 194, 117, 58, 27}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 116, 141, 153}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 249, 73, 8, 159, 113, 176, 231, 166, 8}, 15},
	{{158, 165, 2, 144, 0, 0, 182, 102, 92, 6, 116, 200, 236, 14, 52, 252}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 204, 168, 196}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 175, 55, 39, 9, 186, 65, 150, 225}, 15},
	{{158, 165, 2, 144, 0, 0, 108, 29, 229, 171, 34, 45, 196, 117, 200, 216}, 15},
	{{158, 165, 2, 144, 0, 0, 0, 0, 0, 0, 0, 0, 103, 68, 96, 74}, 15},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 86, 249, 27, 85, 25}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 34, 206, 24, 232}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 184, 245, 40, 21}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 201, 203, 41}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 82}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 63, 92, 141, 57, 194}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 185, 242, 250}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 156}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 0}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 210, 42, 75, 214, 119}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 198, 100, 16, 171, 246}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 47, 160, 116}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 163, 240, 207}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 0}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 214, 97, 130, 240, 92, 99, 241}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 245, 228, 113, 31, 189}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 46, 215, 119, 5, 8, 111, 98}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 15, 203, 117, 235, 169, 133, 180}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 242, 120, 185, 161, 125, 203, 198}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 0}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 96, 100, 163, 57, 71, 61}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 189, 6, 48, 141, 244, 216}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 74, 181}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 74, 254, 10}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 197, 26, 92, 182}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 249, 66, 128, 216, 166}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 0}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 251, 225, 84, 65, 78}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 126, 186, 118, 6}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 241, 247, 192}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 212, 188}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 115, 20, 73, 246, 195}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 129, 246, 149, 16}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 138, 179, 123, 19}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 229, 190, 71, 205, 181}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 97, 27, 115, 247}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 66, 250, 161}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 62, 80, 64, 110, 178, 122, 245}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 214, 8, 183, 147, 139}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 143, 34}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 0}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 189, 155, 46, 129, 235, 76}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 56, 35, 102, 98}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 161}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 127, 104, 138}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 140, 71, 185, 50, 152, 18}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 244, 245, 176}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 95, 201}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 54, 224, 59, 162, 128, 95}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 16, 162, 57, 156}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 184, 195, 105, 110}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 128, 255, 116, 111, 6, 2}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 199, 250, 73, 166}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 191, 91, 221, 140, 88, 186, 27}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 202, 252, 186, 141, 145, 151}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 25, 92, 79, 57, 196, 80, 76}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 0}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 248, 83, 133}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 0}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 185}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 174, 254, 154, 188}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 223, 139, 183, 105}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 244, 26, 219}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 0}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 185, 223, 61, 173, 149, 62}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 232, 208, 221, 101}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 0}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 122, 169}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 165, 42, 86, 12, 124}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 164, 67, 168}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 224, 213, 71, 177, 163, 253}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 0}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 99}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 166, 1, 159, 182, 170, 237, 233}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 182, 193, 215}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 10, 183, 64, 181, 235}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 0}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 0}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 51, 144, 61}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 104, 190}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 122, 105, 38, 217, 197}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 35, 207, 67, 255, 145}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 33, 10}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 133, 78, 7}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 0}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 120, 189}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 0}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 211, 159, 101, 17}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 0}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 212}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 81, 166, 7, 13, 13}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 193, 100, 174, 245}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 123, 184, 100}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 8, 25, 224, 150}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 0}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 0, 0, 0, 25}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 32, 59, 154, 255, 85}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 155, 172, 4, 68, 130, 242}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 0, 0, 189, 251, 184, 203}, 95},
	{{85, 204, 245, 198, 68, 44, 39, 71, 32, 0, 34, 89, 31, 164, 146, 168}, 95},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 106, 210, 86}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 98, 203, 127, 167, 0, 240, 177, 254}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 187, 168, 10, 92}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 144, 238, 207, 4, 214, 170, 155, 136}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 79, 217, 93}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 127, 156, 136}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 10, 107, 5, 131, 2, 181, 226, 173}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 193, 14, 190, 180, 132}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 212, 188, 89}, 169},
	{{181, 134, 25, 87, 128, 0, 195, 66, 207, 96, 74, 235, 91, 224, 173, 247}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 91, 157, 211, 239, 160, 159, 128, 67, 51}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 191, 79, 183, 8, 124}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 59, 34, 91, 94, 83, 22}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 31, 204, 106, 49, 203, 103, 26, 78, 193}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 144, 30, 124, 86, 106, 220, 74}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 86, 255, 112, 118, 137, 105, 70, 174, 6}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 254, 100, 61, 128, 161, 88, 56}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 53, 180, 11}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 27, 190, 117, 179, 99}, 169},
	{{181, 134, 25, 87, 128, 0, 50, 123, 29, 100, 62, 252, 240, 115, 95, 12}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 162, 181, 255}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 254, 74, 198, 11, 98, 186}, 169},
	{{181, 134, 25, 87, 128, 0, 252, 75, 102, 252, 41, 159, 42, 155, 176, 217}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 224, 157, 86, 12, 139}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 150, 34}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 243, 9, 207, 210, 221, 155}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 215, 138, 68, 66, 242, 169, 129, 247, 45}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 218, 121, 24, 126, 56, 92, 144, 163, 93}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 58, 205, 245, 92, 37, 48, 170}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 224, 18, 32, 96, 240, 78, 155, 138, 153}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 173}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 163, 31, 208, 211, 5, 225, 49, 184}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 198, 13, 21}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 162, 201, 62}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 67, 199, 79, 91, 116}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 67, 246, 24, 243, 134}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 177, 164}, 169},
	{{181, 134, 25, 87, 128, 0, 84, 12, 129, 244, 2, 166, 215, 170, 142, 243}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 174}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 25, 76, 253, 13, 156, 160}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 35, 158, 21, 193, 243, 231, 182, 121}, 169},
	{{181, 134, 25, 87, 128, 0, 162, 183, 125, 226, 165, 130, 153, 150, 58, 100}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 130}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 184, 145, 94, 53, 46}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 191, 147, 78, 196, 158, 195, 116, 59}, 169},
	{{181, 134, 25, 87, 128, 113, 174, 85, 73, 238, 65, 161, 177, 176, 196, 16}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 228, 0}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 159, 195, 194, 188, 241, 165, 198, 91}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 58, 175, 229, 96, 169, 113, 195, 247}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 101, 200, 130, 95, 234, 74}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 42, 129, 199, 120, 169, 168, 110, 222}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 37, 133, 20, 205, 11, 30}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 169, 223, 117, 79, 240, 45, 112, 134, 162}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 55, 200, 220}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 184, 204, 124, 6, 46, 135}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 121}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 249, 84, 89, 105, 134}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 229, 19, 99, 20}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 95, 80, 174, 247, 206}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 241, 161}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 164, 73, 128, 73}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 99, 154, 126, 98, 67, 17, 126, 54, 129}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 211, 229, 195, 222, 250, 4, 107, 158, 216}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 247, 255, 31}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 51, 225, 243, 242, 7, 245, 145}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 171, 177, 182, 153, 34, 221, 58, 207, 244}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 41, 29, 103, 252, 183}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 9, 26, 184}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 151, 75, 87, 57, 248, 178, 187, 100, 34}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 175, 191, 37, 68, 189, 31, 60, 209, 85}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 186, 167, 55, 50, 217, 222, 129, 254, 91}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 9, 148, 171, 104}, 169},
	{{181, 134, 25, 87, 128, 0, 129, 67, 202, 16, 246, 6, 135, 238, 111, 2}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 32, 181, 165, 81, 129, 198, 151, 22}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 32, 123, 4}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 205}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 228, 230, 146, 113, 90, 33, 132, 210}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 112, 13, 147, 117, 103, 45, 35}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 14, 188, 9}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 227}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 149}, 169},
	{{181, 134, 25, 87, 128, 239, 182, 61, 163, 201, 111, 222, 15, 235, 220, 135}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 80, 107, 167, 143, 237, 142, 17}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 242, 206, 239, 10, 114}, 169},
	{{181, 134, 25, 87, 128, 0, 237, 173, 173, 92, 221, 88, 126, 111, 249, 151}, 169},
	{{181, 134, 25, 87, 128, 225, 62, 29, 218, 67, 218, 224, 27, 125, 80, 185}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 2, 180, 180, 85}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 124, 225, 188, 15, 0, 177}, 169},
	{{181, 134, 25, 87, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 169},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 64, 248, 15, 253, 84, 137}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 48, 109, 137, 120, 229, 57, 26, 240}, 249},
	{{26, 230, 61, 36, 79, 192, 195, 231, 51, 66, 238, 62, 84, 179, 46, 221}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 177, 196, 252, 101, 225, 245}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 174, 153, 216, 65}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 85, 146, 227}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 114, 210}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 85, 51, 53, 195}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 201, 251}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 164, 29, 89, 252}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 69, 118, 219, 128}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 197, 68, 134, 61, 137, 231, 157, 106}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 51, 51, 57, 13, 152, 103, 220, 199, 212}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 87, 201, 200, 196, 110, 207, 60}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 116, 64, 43, 94}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 1, 56, 18, 165, 91}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 173, 140, 11, 251}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 69, 241, 100, 159}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 233, 122, 113, 91, 250, 3, 217, 143}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 6, 112, 38, 225, 97, 248, 170}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 100, 248, 214, 119, 188, 70, 167, 253}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 77, 126}, 249},
	{{26, 230, 61, 36, 79, 192, 116, 211, 184, 157, 233, 44, 194, 183, 131, 196}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 56, 79, 109, 1, 8, 128}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 69, 54, 155, 132}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 25, 16, 93, 4, 50, 34, 102, 169, 208}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 192, 92, 58, 168, 253, 23, 108}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 171, 159, 214}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 184, 197, 123}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 135, 110, 38, 201, 178, 11}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 46, 250, 56, 65}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 179, 25, 204, 107, 33, 229, 0, 195, 144}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 224, 135}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 33, 107, 243, 129, 213, 11, 55}, 249},
	{{26, 230, 61, 36, 79, 192, 206, 141, 232, 252, 252, 159, 176, 188, 111, 162}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 117, 102, 221, 197, 102, 13, 18}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 197, 40, 10, 100, 221, 66, 41, 103}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 3, 0, 101, 77, 242, 113, 82, 238, 215}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 195, 75, 64, 204, 162, 253, 116, 251, 90}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 67, 115, 51, 71}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 44, 196, 187, 249, 245, 139, 91}, 249},
	{{26, 230, 61, 36, 79, 192, 70, 95, 166, 157, 99, 56, 205, 115, 178, 164}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 163, 156, 251, 102, 224, 198, 9}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 7, 145, 222, 112, 23, 204, 160, 207, 149}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 125, 88}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 238, 181, 177}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 234, 114, 72, 74}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 181, 38, 136, 121, 227}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 105, 49, 153, 151, 174}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 206, 164, 95, 101, 126, 195}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 187, 206, 200, 147, 140, 159}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 132, 2, 235, 57, 122, 9}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 255, 123, 56, 9, 238}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 253, 252, 148, 52}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 24, 152, 184, 33, 129, 84, 109}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 135, 206, 149, 85, 184, 191, 133, 44, 72}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 245, 29, 241, 209, 207, 118, 131, 201, 70}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 128, 115, 32, 149, 184, 213, 145, 131, 215}, 249},
	{{26, 230, 61, 36, 79, 192, 32, 226, 254, 2, 72, 119, 234, 164, 232, 7}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 83, 8, 238, 170, 9, 184}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 141, 77, 128}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 238, 88, 186, 104, 251, 62, 191, 225}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 104, 214, 171, 56}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 40, 85, 1, 161, 145, 3}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 155, 78, 9, 98, 222, 111}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 249}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 102, 174, 141, 110}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 14, 52, 117, 95, 146}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 196, 144}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 211, 46, 129, 34, 106, 169, 157, 159, 113}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 71, 172, 121, 18, 50, 192, 72, 64, 42}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 48, 75, 114, 236}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 193}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 152, 110, 182, 25, 21, 24}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 34, 87, 103, 186, 193}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 128, 32, 100}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 236, 72, 4, 196, 86}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 50, 181, 123, 174, 47, 201, 43}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 132, 24}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 120, 224, 59, 219, 4, 56, 112, 158}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 234, 234, 43, 199}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 166, 99, 164, 146, 71, 124, 105}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 219, 68, 123, 47}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 115, 246, 131, 162, 118, 138}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 162, 88, 135, 60}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 186, 180, 230, 58, 194, 46, 38, 28, 251}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 243, 106, 231, 54, 77, 50, 40}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 75, 130, 12, 186, 242}, 249},
	{{26, 230, 61, 36, 79, 192, 0, 0, 0, 0, 0, 0, 0, 0, 85, 51}, 249},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 136, 88}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 18}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 62, 158}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 195}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 110}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 203}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 154, 123}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 41, 136}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 253}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 5}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 57}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 193}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 68}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 240}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 1}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 42}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 39, 53}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 240}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 208, 12}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 161}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 234, 42}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 239, 218}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 225, 244}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 57, 42}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 47, 59}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 225, 142}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 37, 253}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 239}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 38}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 225}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 216, 88}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 173, 132}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 188}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 91, 236}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 45, 174}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 121, 228}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 115, 18}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 49, 24}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 187, 86}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 252}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 138, 243}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 68, 42}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 157, 147}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 235}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 155, 139}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 252, 25}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 100, 233}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 134, 115}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 33}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 124}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 233, 206}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 251, 146}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 103}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 208, 229}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 148, 88}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 30, 16}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 26}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 199, 168}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 139, 165}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 0, 0}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 43, 170}, 61},
	{{5, 170, 198, 139, 65, 186, 188, 45, 42, 253, 165, 89, 206, 0, 59, 203}, 61},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 77, 31, 186, 99, 78, 84, 130}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 106, 221, 15, 176, 161, 73, 15}, 63},
	{{211, 245, 62, 0, 74, 129, 113, 228, 87, 44, 251, 62, 19, 17, 28, 68}, 63},
	{{211, 245, 62, 0, 0, 0, 60, 95, 180, 109, 150, 224, 124, 246, 185, 34}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 144, 84, 198, 138, 239, 151, 165}, 63},
	{{211, 245, 62, 59, 77, 227, 198, 205, 105, 37, 178, 147, 86, 157, 144, 134}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 234, 76, 217, 131, 247, 142, 23}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 94, 170}, 63},
	{{211, 245, 62, 0, 0, 0, 56, 193, 232, 120, 157, 45, 124, 235, 37, 196}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 245, 229}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 39}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 73, 204, 44, 209, 57, 165, 187, 203}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 123, 175, 40, 70, 246, 186, 190, 27}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47, 78, 86, 89}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 208, 80, 70, 142, 103, 203, 3}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 60}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90, 63}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 51, 195}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 217, 127, 44, 238, 234, 252, 80, 83, 44}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 243, 171, 123, 227, 123, 162, 213, 137}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 70, 120, 170, 29}, 63},
	{{211, 245, 62, 104, 162, 47, 62, 132, 152, 62, 12, 248, 253, 78, 66, 37}, 63},
	{{211, 245, 62, 0, 0, 0, 208, 13, 97, 108, 142, 179, 219, 55, 167, 65}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 166}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 62, 172, 60}, 63},
	{{211, 245, 62, 0, 0, 34, 39, 177, 213, 119, 205, 110, 191, 144, 187, 81}, 63},
	{{211, 245, 62, 0, 177, 97, 226, 17, 9, 114, 201, 1, 31, 68, 80, 36}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 155, 19, 65, 219, 255, 5, 23, 59, 140}, 63},
	{{211, 245, 62, 0, 0, 88, 250, 94, 26, 46, 108, 17, 133, 237, 202, 166}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 3, 135, 51, 59, 48}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 251, 22, 115, 100, 12, 112, 9}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 63},
	{{211, 245, 62, 0, 0, 187, 244, 224, 24, 237, 141, 123, 232, 196, 146, 71}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 198, 87, 61, 232, 246, 71, 111, 70, 243}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 244, 60}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 162}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 63},
	{{211, 245, 62, 0, 0, 204, 208, 170, 16, 197, 45, 183, 57, 252, 210, 163}, 63},
	{{211, 245, 62, 0, 0, 0, 222, 9, 97, 128, 221, 248, 44, 90, 159, 94}, 63},
	{{211, 245, 62, 0, 0, 59, 26, 115, 130, 190, 152, 186, 1, 137, 177, 75}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 162, 194, 189, 209, 136}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 45, 250, 93, 13}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 90, 79, 230, 55, 244}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 131, 209, 111, 14, 243, 92, 73, 118, 73}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91, 78}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 102, 182, 150, 54}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 241}, 63},
	{{211, 245, 62, 0, 0, 0, 227, 169, 206, 84, 38, 230, 44, 243, 200, 210}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 135, 228, 110, 206, 212}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 78, 66, 246, 33}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 115, 198, 165, 190, 55}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 249, 99, 101, 239, 73, 183}, 63},
	{{211, 245, 62, 0, 0, 0, 163, 161, 152, 158, 37, 55, 206, 171, 207, 116}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 244, 93, 224, 3, 113, 132, 160}, 63},
	{{211, 245, 62, 0, 0, 0, 20, 115, 144, 17, 110, 37, 173, 229, 178, 211}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 184, 88, 125, 150, 45, 194, 86}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 149, 93, 67, 235, 234, 38, 199, 100, 188}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 214, 178, 221, 17, 64, 61, 64, 86, 56}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 237, 121, 151, 88}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 183, 207, 61}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 10}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 89, 203, 138, 191, 177, 42, 102, 28}, 63},
	{{211, 245, 62, 0, 0, 0, 119, 21, 45, 175, 179, 182, 143, 117, 72, 19}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 213, 127, 57, 122, 137, 44}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 92, 157, 67, 23}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 203, 7, 178, 35, 60, 3, 88, 171}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 80, 237, 32, 25, 18, 40, 142}, 63},
	{{211, 245, 62, 0, 0, 0, 69, 9, 162, 140, 10, 52, 65, 94, 73, 37}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 227, 184, 225, 210, 146}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 165, 133, 251, 87, 90, 89, 1}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 133, 10, 107, 27, 88, 22, 237, 211, 252}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 31, 64, 114, 197, 187, 84, 137, 51}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 169, 201, 95, 13, 209, 69, 178}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 144, 68, 161}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 21, 220, 205, 39, 2, 246, 85}, 63},
	{{211, 245, 62, 0, 56, 115, 112, 25, 111, 90, 185, 108, 170, 119, 46, 238}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 251}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 77, 168, 89}, 63},
	{{211, 245, 62, 0, 0, 241, 196, 174, 234, 161, 250, 101, 47, 46, 176, 238}, 63},
	{{211, 245, 62, 0, 0, 235, 139, 208, 229, 208, 221, 176, 251, 10, 113, 246}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 133, 194, 0, 123, 255, 135}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 63},
	{{211, 245, 62, 0, 0, 242, 82, 46, 119, 15, 18, 130, 181, 0, 56, 11}, 63},
	{{211, 245, 62, 0, 239, 223, 194, 136, 70, 141, 154, 23, 174, 191, 21, 20}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 135, 156, 239, 162, 153, 58}, 63},
	{{211, 245, 62, 0, 226, 229, 210, 218, 96, 169, 11, 81, 95, 219, 112, 171}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 63},
	{{211, 245, 62, 0, 164, 17, 135, 211, 34, 216, 147, 67, 35, 188, 179, 54}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 69, 178, 37, 106, 234, 135}, 63},
	{{211, 245, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 143}, 63},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 232, 175, 185}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 206, 93, 15, 167, 243, 44, 99, 214}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 188, 6, 139, 178, 86, 48, 234, 246, 223}, 43},
	{{117, 68, 0, 0, 0, 0, 205, 103, 61, 235, 239, 44, 142, 252, 179, 160}, 43},
	{{117, 68, 0, 225, 104, 90, 11, 47, 115, 110, 63, 14, 75, 111, 169, 54}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 180, 176, 14, 166, 49, 7, 66, 233, 132}, 43},
	{{117, 68, 0, 132, 219, 230, 175, 153, 250, 192, 221, 74, 131, 211, 127, 252}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 119, 3, 235, 77, 14, 104, 3, 224, 16}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 72}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 255, 8, 0}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 61, 79, 28, 33, 77, 192, 209, 11}, 43},
	{{117, 68, 0, 0, 0, 200, 160, 94, 147, 19, 183, 11, 142, 204, 194, 25}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 183}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 26, 148}, 43},
	{{117, 68, 0, 102, 105, 90, 57, 142, 170, 98, 123, 70, 221, 145, 84, 251}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 59, 81, 32, 229}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 40}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 20, 241}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 134, 199, 246}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 1, 45}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 112, 134, 215, 206, 7, 247, 2, 219}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 188, 27, 20, 158, 249, 188}, 43},
	{{117, 68, 0, 0, 0, 232, 247, 4, 125, 45, 163, 183, 95, 199, 42, 79}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 191, 1, 250, 15}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 178}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 161, 147, 100, 193}, 43},
	{{117, 68, 0, 241, 40, 247, 152, 174, 24, 165, 208, 106, 223, 205, 75, 28}, 43},
	{{117, 68, 0, 0, 0, 0, 64, 128, 215, 218, 27, 205, 41, 150, 236, 93}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 216}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 8, 162, 161, 157, 184, 160, 30}, 43},
	{{117, 68, 0, 0, 0, 77, 200, 58, 105, 210, 138, 181, 245, 124, 6, 104}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 172, 183, 227, 191, 8, 253, 214}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 188}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 225, 20, 24}, 43},
	{{117, 68, 0, 0, 0, 0, 138, 137, 85, 236, 189, 219, 197, 59, 119, 10}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 176, 199, 237, 70}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 197, 39}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 56, 80, 16, 59, 241, 146, 147, 78, 98}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 184, 13, 49, 164, 244, 59}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 85, 172, 128, 105}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 145, 169, 83, 193, 69, 166, 202, 238}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 69, 114, 113, 168, 249, 114}, 43},
	{{117, 68, 0, 0, 80, 189, 252, 25, 46, 254, 242, 170, 167, 128, 164, 63}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 111, 80, 152, 205, 214, 180, 98}, 43},
	{{117, 68, 0, 239, 48, 15, 182, 228, 13, 113, 105, 200, 20, 204, 116, 236}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 21, 137, 66, 143, 249, 161}, 43},
	{{117, 68, 0, 0, 128, 110, 17, 234, 177, 124, 62, 65, 35, 78, 248, 175}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 197, 246, 213}, 43},
	{{117, 68, 0, 19, 47, 184, 153, 201, 104, 183, 166, 237, 166, 88, 55, 178}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 175}, 43},
	{{117, 68, 0, 0, 46, 2, 199, 41, 37, 58, 57, 123, 101, 15, 202, 47}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217, 185, 99, 180, 6}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 140, 167, 95}, 43},
	{{117, 68, 0, 0, 0, 8, 12, 226, 1, 147, 44, 48, 86, 224, 84, 25}, 43},
	{{117, 68, 0, 0, 232, 230, 10, 249, 86, 115, 134, 73, 255, 21, 130, 242}, 43},
	{{117, 68, 0, 0, 0, 0, 72, 255, 219, 168, 181, 56, 24, 241, 226, 200}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 121, 28, 226, 122, 41, 254, 206, 170}, 43},
	{{117, 68, 0, 227, 128, 195, 54, 161, 147, 2, 56, 51, 49, 231, 188, 185}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 2, 177, 223, 192, 152, 170}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 182, 242, 11, 246}, 43},
	{{117, 68, 0, 0, 16, 1, 57, 67, 78, 9, 245, 164, 17, 191, 183, 127}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 126, 192, 12}, 43},
	{{117, 68, 0, 173, 182, 255, 179, 31, 4, 153, 47, 115, 191, 138, 142, 154}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 79, 249, 176, 9}, 43},
	{{117, 68, 0, 0, 0, 0, 104, 121, 236, 35, 51, 38, 83, 249, 11, 32}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 151}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 229, 117, 247, 249, 151, 16, 169, 37, 206}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 45, 35, 194, 99, 55, 3, 122}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 15, 0, 254, 107, 12, 82, 148, 210, 90}, 43},
	{{117, 68, 0, 0, 0, 31, 159, 96, 76, 42, 237, 195, 153, 37, 170, 27}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 47, 12, 232, 77, 77, 94, 38, 212}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 15, 47, 137, 87, 227, 238, 133, 132}, 43},
	{{117, 68, 0, 23, 180, 78, 30, 102, 175, 202, 41, 199, 10, 219, 104, 84}, 43},
	{{117, 68, 0, 0, 0, 68, 26, 211, 147, 122, 13, 2, 178, 125, 140, 186}, 43},
	{{117, 68, 0, 0, 140, 114, 43, 73, 167, 173, 123, 94, 102, 227, 120, 113}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 152, 136, 68, 149, 177}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 26, 24, 164}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 251, 117, 237, 92, 45, 216}, 43},
	{{117, 68, 0, 0, 0, 0, 26, 244, 77, 254, 58, 191, 42, 91, 19, 143}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56, 100}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 142, 38, 16}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 34, 52, 68, 112, 123, 110, 200, 46, 235}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 11, 69, 197, 104, 106, 240, 124, 198}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 172, 202, 189, 72, 5, 52, 7, 180}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 102, 81, 177, 219, 47, 81, 142, 31}, 43},
	{{117, 68, 0, 0, 152, 89, 166, 116, 108, 170, 138, 63, 113, 187, 101, 17}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43},
	{{117, 68, 0, 0, 191, 180, 5, 106, 239, 113, 141, 116, 7, 149, 141, 76}, 43},
	{{117, 68, 0, 0, 13, 99, 253, 47, 35, 65, 35, 70, 73, 167, 191, 160}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 7, 103, 77, 245, 166, 171}, 43},
	{{117, 68, 224, 60, 43, 48, 62, 142, 215, 141, 74, 49, 178, 15, 103, 32}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 168, 78}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 180, 97, 248, 64, 27}, 43},
	{{117, 68, 0, 0, 0, 171, 148, 35, 199, 227, 158, 52, 188, 83, 120, 60}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 43},
	{{117, 68, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 251, 52, 54, 190}, 43},
	{{117, 68, 0, 0, 119, 57, 243, 201, 253, 31, 122, 222, 231, 165, 40, 120}, 43},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 61, 137}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 213}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 204}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 210, 102, 164}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 118, 71, 210}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 16, 159, 24, 214, 61}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 117}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 74, 183}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 4, 60, 111, 253, 148}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 95, 6, 45}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 100, 128}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 91, 33, 11, 77}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 94, 33}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 141}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 247, 139, 7}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 161, 212, 248, 249}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 137, 4, 179}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 57, 57, 91}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 140, 210, 169}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 70, 205}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 96, 176, 154}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 48}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 98}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 76}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 5, 31, 13, 219, 58}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 141, 199}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 73}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 55, 190, 143, 164, 111}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 57, 95, 142, 70}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 214, 119, 191, 134}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 217, 139}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 16}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 229, 50}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 14}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 136, 216, 188}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 48}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 106, 233, 32, 49, 6}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 53, 178, 187, 106}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 107, 227, 121}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 196, 215, 25, 26, 27}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 123, 123, 92, 139}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 172, 230, 73}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 78, 11}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 67, 114, 167, 94}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 11, 182}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 38}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 129, 1, 119}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 40, 99, 218, 87, 5}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 71}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 87}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 76, 188, 183, 214, 169}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 112, 190, 29, 179, 9}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 34}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 81}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 185, 194, 211, 55}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 198, 11, 68}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 61, 223, 52, 175, 91}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 181, 2}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 235, 173}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 74, 222, 156, 73, 168}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 97, 39, 183}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 40, 33, 232, 236}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 143}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 117, 34, 13, 122, 10}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 28, 229, 63, 185}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 3, 116, 127, 199, 2}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 51, 57, 175, 244}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 193}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 213, 194, 125, 233, 106}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 153, 165, 64}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 90, 156, 240, 63}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 222, 108, 98, 140, 105}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 38}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 75, 246, 77}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 248, 130, 110}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 244, 197, 243, 185}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 125, 107, 34, 33, 111}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 191, 10}, 228},
	{{103, 17, 123, 102, 70, 206, 90, 92, 124, 198, 0, 0, 0, 0, 0, 0}, 228},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 128, 38, 148, 75, 180}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 75, 47, 221, 28, 123}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 0}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 38, 244, 55, 55}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 66, 44, 195}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 80}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 0}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 132}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 127, 4}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 193, 16, 245}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 173, 200, 59, 179, 234}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 107, 19, 188, 4, 16}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 65, 185, 9}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 138}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 227, 122, 166}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 45, 101, 197}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 83}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 25, 130, 69, 89}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 73}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 148, 206, 119}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 234, 106, 241, 74}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 9}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 249}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 217, 88, 202, 89}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 27}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 132, 38, 30, 115}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 175, 207}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 37, 88, 120, 225}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 2, 90, 108, 237}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 133, 139, 166, 55}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 0}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 99, 184, 204, 59, 234}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 46, 254, 215}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 228, 41, 177, 187, 227}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 124, 18, 201, 209}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 134, 96, 47, 201}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 108, 150}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 201, 91, 158}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 107, 214, 149, 143, 137}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 169, 173, 253, 133, 222}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 50}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 45, 179, 45}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 13, 244, 134, 247}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 229, 125}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 136}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 253, 187, 244, 242, 105, 251}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 217, 189, 48, 219}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 44, 97, 217, 25}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 45}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 4, 92, 150, 219}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 43, 151}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 233, 188}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 20}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 13, 37, 119}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 75}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 222, 69, 244, 98, 190}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 134, 206}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 245, 210, 160, 188, 86}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 90, 242, 218, 146}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 33, 194}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 0}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 148, 236, 39, 126}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 114, 235, 179}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 0}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 15, 157}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 9}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 173, 219}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 0}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 160, 21, 191}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 52, 85, 97, 94}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 188}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 80, 127, 161}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 107, 181, 116, 124, 250}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 238, 7, 43, 17, 236}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 200, 55, 249, 184, 91}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 240}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 0}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 83, 151, 113, 209, 27, 27}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 76}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 23, 105, 253}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 0}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 105}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 195}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 38, 181, 114, 6}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 13, 27, 82}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 98, 91, 78, 132, 136}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 86, 125, 127, 65}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 0}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 119}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 72}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 130}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 0}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 251, 36, 132}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 75, 187}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 147}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 94, 230}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 0, 0, 0}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 94, 83, 171}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 0, 0, 193, 164, 179}, 165},
	{{192, 237, 88, 244, 53, 30, 61, 160, 143, 64, 0, 27, 210, 240, 26, 104}, 165},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 219, 238, 9}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 205, 28, 142}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 161, 200, 144, 48, 255, 234}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 0}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 161, 86, 168, 204, 56, 197}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 167, 159}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 143, 129, 19, 64}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 13, 27, 105, 103, 161}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 19}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 101, 254, 214, 22, 99}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 4, 235, 71, 250, 243, 127}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 201, 5, 138, 38, 253, 73, 2}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 213, 191}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 213}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 31, 225, 242}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 180}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 80, 53, 45, 237}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 164, 42}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 0}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 51}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 208, 241, 193, 136, 20, 207, 71}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 75, 134, 35, 38, 236, 196}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 0}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 28, 83, 178, 114, 194, 255}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 138, 231, 155, 226}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 159, 160}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 137, 80, 153, 81, 246, 75}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 117, 112, 8, 72, 227}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 243, 220, 78, 154, 108, 228, 21}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 97, 107, 232}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 155, 31, 105, 205}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 76, 142, 15, 34, 75}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 0}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 51, 106, 135, 70, 227}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 123}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 0}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 90, 210, 172}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 140, 250, 12, 184, 64, 33, 243}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 0}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 231, 149, 44, 183, 225, 105, 115}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 157, 201, 86, 78, 47}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 4, 7, 27, 237}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 221, 38, 21, 206, 225, 10}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 193}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 131, 55, 197, 106, 67, 151, 176}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 57, 24, 145, 223, 122, 71}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 102, 83, 79, 162}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 77, 119}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 243, 115, 60, 98}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 187, 253, 237, 196, 198, 159, 239}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 143, 231}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 168, 38, 47}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 4, 50, 128, 78}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 126}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 2, 127, 153, 165, 80, 104}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 180, 61, 26, 126, 149, 200, 168}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 145}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 161, 148, 62, 72, 212, 201}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 55}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 159, 135, 86}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 95}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 51, 43, 60, 140}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 0}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 0}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 0}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 105, 5, 244, 3, 99, 142, 103}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 127, 185}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 156, 69, 225, 148}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 44, 26}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 85}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 102, 24, 73, 53, 98, 175}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 0}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 0}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 59, 247, 252, 149, 106, 41}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 46, 76, 79, 11, 45, 68, 244}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 35, 204}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 0}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 34, 216, 27, 73, 198}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 71}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 255, 120, 178}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 239, 62}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 121}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 3, 56, 144, 129, 149, 150, 132}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 0}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 182}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 248}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 35, 245, 124}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 144, 198, 150, 102, 108}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 186}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 245, 83, 189}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 199, 175, 8, 21, 170, 65, 86}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 211, 71, 217, 53}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 230, 39, 42, 52}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 160, 158, 147, 61, 30, 50}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 78, 25, 81, 105}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 112, 8, 131, 3, 120, 81, 56}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 233, 218, 25, 128, 17, 147, 9}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 0, 193}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 0, 0, 0, 0, 148, 37}, 3},
	{{199, 82, 217, 183, 2, 179, 195, 6, 0, 0, 198, 249, 43, 215, 93, 62}, 3},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 92, 246}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 161, 142}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 157, 70, 136, 185, 247, 179}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 186, 36}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 192, 164, 237}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 171, 97}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 68, 138, 38}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 56, 137, 34, 111, 199}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 189, 185, 44, 248, 143, 178}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 233, 200, 71, 222, 255, 210}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 186, 232, 140, 11, 149, 48, 184}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 124, 41, 224, 226, 64, 201, 84, 141}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 168, 211, 87, 131, 231}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 31, 142, 140, 157, 16}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 0, 215}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 160, 201, 67, 117, 153, 32, 235, 229}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 123, 54}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 240, 54, 195, 139, 196, 224}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 199, 59, 88, 89, 63}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 6, 122}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 240, 182, 31, 199}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 149, 111, 192, 167, 122}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 140, 126}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 141, 144}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 24, 171, 40, 151, 108}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 0, 233}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 135, 202, 59, 77, 11, 104, 253}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 55, 169, 45}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 146, 64, 199, 191, 110}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 0, 38}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 41, 39}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 201, 130, 232}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 0, 215}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 252, 158, 209, 20}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 113, 157, 240, 196, 7, 186}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 7, 95, 57, 63, 108}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 235, 111, 77}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 64, 80, 34, 78}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 200, 99, 220, 106, 153, 19}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 87, 147, 119, 69, 97, 142}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 63, 170}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 125, 1, 37, 62, 210}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 107, 27}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 212, 167, 174, 66, 68}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 242, 145, 170, 20}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 152, 185, 9, 213}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 43, 142, 148}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 245, 251, 227}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 15, 50, 161, 163, 154, 190, 14, 20}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 160, 203}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 206, 221, 49, 190, 214, 176}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 169, 45, 181, 89, 104}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 3, 222, 113, 65, 175, 88}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 91, 71, 148, 78, 79, 221}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 224, 94}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 113, 236}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 164, 173, 184, 85, 253}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 90, 207, 25, 165, 131, 167, 114}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 125, 192, 87, 118, 199, 158}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 243, 221, 146, 200}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 151, 99, 5}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 61, 244}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 0, 232}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 0, 221}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 56, 242, 243, 143, 42}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 133, 237, 10, 129, 197, 15, 255}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 181, 7, 57, 198, 52, 78, 193}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 214, 209, 42}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 113, 157, 244}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 174, 251}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 208, 35, 248, 22, 85, 231}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 220, 243, 212}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 106, 217}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 0, 200}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 175, 77, 157, 187}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 203, 126, 15, 118}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 249, 229, 183}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 155, 18}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 0, 215}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 187, 35}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 171, 15, 219, 142, 141, 241, 29, 48}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 254, 98, 223, 93, 255, 37, 94}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 186, 153}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 252, 182, 120, 41, 89}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 0, 0, 0, 0, 0, 249, 78}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 42, 52, 29, 151, 23, 229, 130}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 0, 181, 166, 204, 225, 132, 152, 144}, 211},
	{{157, 230, 79, 162, 57, 125, 152, 0, 102, 52, 226, 134, 18, 72, 146, 220}, 211},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 146, 24, 88, 122, 38, 199}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 94, 7, 160, 207, 83, 124, 106}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 213, 16, 159, 210, 31, 199, 225}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 111, 182, 67}, 210},
	{{27, 67, 64, 235, 128, 0, 214, 207, 238, 102, 201, 27, 143, 189, 204, 127}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 55}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 246}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 89}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 12, 58, 98, 29, 79, 104, 206, 219}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 172, 61, 119}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 112, 146, 58, 31, 15, 78, 220}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 229, 195, 125, 157, 156, 60, 166, 142, 78}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 48, 127, 17, 129, 167, 144, 227}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 252, 193, 61, 183}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 90, 67}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 220, 125, 22, 107, 45, 218}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 98, 101, 20, 46, 114, 248, 227, 21, 52}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 246}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 89, 113, 106}, 210},
	{{27, 67, 64, 235, 128, 162, 19, 230, 214, 39, 123, 241, 31, 58, 152, 237}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 87}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 215, 202, 60, 76, 60, 134, 4, 82, 69}, 210},
	{{27, 67, 64, 235, 128, 232, 106, 69, 252, 88, 12, 113, 11, 152, 245, 176}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 145, 28, 173, 104, 204, 182, 102, 45}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 73, 132, 20, 186, 152}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 163, 197, 22, 107}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 30, 211, 229, 162, 161, 35}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 45, 255, 19, 134, 30, 174, 202}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 168, 198, 162, 195, 195, 86, 35, 40, 212}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 6, 224, 115, 205, 163, 168, 224, 205, 21}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 232, 205, 50}, 210},
	{{27, 67, 64, 235, 128, 0, 13, 210, 14, 55, 44, 30, 249, 253, 224, 226}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 99, 87, 170}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 102, 157, 127, 19}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 2, 186, 3, 8}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 190, 48, 189, 207, 250, 115}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 130, 15, 183, 151, 247, 173, 93, 216}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 208, 45, 237, 156, 188, 178, 227}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 184, 91}, 210},
	{{27, 67, 64, 235, 128, 152, 175, 191, 13, 218, 10, 77, 84, 25, 121, 183}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 171}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 31, 218, 60, 193, 243}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 109, 22, 98, 187, 81, 138, 175}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 221, 74, 226, 44, 115}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 120, 210}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 172, 115, 206, 204}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 241, 114, 170, 47, 215, 172, 148}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 56}, 210},
	{{27, 67, 64, 235, 128, 151, 187, 252, 226, 16, 12, 224, 143, 44, 214, 247}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 249, 186, 86, 69, 8, 84, 70, 128, 31}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 17, 30, 119, 95, 140, 69}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 131, 235, 22, 198, 137, 227, 21, 227}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 254, 209, 76, 198, 159, 228}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 121, 76, 157, 68, 152, 230, 111, 67, 26}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 48}, 210},
	{{27, 67, 64, 235, 128, 107, 239, 128, 161, 171, 241, 11, 249, 133, 92, 240}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 70, 55, 78, 29, 90, 235}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 16, 94, 77, 189, 216, 66, 194, 117, 10}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 157, 61, 101, 112, 108}, 210},
	{{27, 67, 64, 235, 128, 95, 63, 98, 40, 103, 225, 57, 196, 228, 233, 5}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 38, 150, 60, 96}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 36, 134, 23, 53, 56, 4, 11}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 163, 235}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 47}, 210},
	{{27, 67, 64, 235, 128, 0, 136, 75, 239, 28, 65, 0, 216, 87, 87, 172}, 210},
	{{27, 67, 64, 235, 128, 0, 23, 135, 45, 141, 44, 241, 45, 34, 69, 176}, 210},
	{{27, 67, 64, 235, 128, 0, 194, 160, 77, 35, 109, 115, 2, 15, 173, 73}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 26, 104, 223, 15, 210, 236, 84, 25, 173}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 213, 107, 116, 125, 39}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 232, 29, 42, 208}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 234}, 210},
	{{27, 67, 64, 235, 128, 93, 200, 251, 108, 203, 10, 216, 147, 44, 156, 162}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 109, 70, 118, 62, 211}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 252, 14, 182, 189, 226}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 176, 18, 171, 230, 197, 227}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 63, 73, 40, 184, 245, 124}, 210},
	{{27, 67, 64, 235, 128, 57, 53, 209, 107, 152, 244, 255, 246, 55, 184, 19}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 63, 195, 238, 251, 17, 203}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 129, 55, 70, 82, 74, 193}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 58, 78}, 210},
	{{27, 67, 64, 235, 128, 0, 221, 186, 182, 155, 44, 218, 145, 237, 54, 232}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 11, 161, 156, 110}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 236, 232}, 210},
	{{27, 67, 64, 235, 128, 0, 238, 117, 56, 221, 97, 46, 249, 232, 245, 58}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 237, 40}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 0, 0, 223, 86, 128}, 210},
	{{27, 67, 64, 235, 128, 0, 0, 0, 0, 0, 0, 46, 121, 41, 119, 88}, 210},
	{{27, 67, 64, 235, 128, 0, 133, 215, 91, 225, 168, 61, 126, 191, 28, 75}, 210},
	{{27, 67, 64, 235, 128, 0, 214, 222, 47, 216, 80, 17, 7, 22, 70, 101}, 210},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 143, 177}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 14, 94}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 27, 94}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 44}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 52, 118}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 222}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 250}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 152}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 70, 2, 30}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 46, 153}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 21, 103}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 174}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 105}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 22, 155, 243}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 19, 4, 201}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 61, 188, 6}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 65, 54}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 182, 72}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 228, 127, 3}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 161, 222, 212}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 84, 57}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 38, 231}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 115, 201, 232}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 220, 133}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 40, 164, 150}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 241, 47, 89}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 189, 233}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 69, 214}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 87, 128, 155}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 207, 73}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 96, 49, 127}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 72, 38, 169}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 175, 251, 116}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 252}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 161}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 138, 248, 159}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 46}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 7, 133, 89}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 157, 2, 21}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 182, 126, 158}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 160, 246}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 56}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 120, 77}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 139}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 140, 112}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 239, 101}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 241, 212}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 190, 214}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 246, 237}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 233, 149}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 130}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 43}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 114, 134, 54}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 215, 49}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 228, 16}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 190, 94, 37}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 210, 74}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 146}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 82, 118}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 203}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 118, 180, 141}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 30, 168, 95}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 204, 96}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 27, 181, 75}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 151}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 231, 13, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 214, 166, 125}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 199, 110}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 90}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 128, 49, 36}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 29}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 0}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 55, 94}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 0, 0, 150}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 228, 42, 118}, 61},
	{{72, 158, 163, 106, 193, 137, 190, 7, 250, 165, 249, 73, 64, 197, 143, 31}, 61},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 195, 249}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 65, 22, 205, 193, 161, 153, 59, 231}, 120},
	{{34, 192, 0, 177, 163, 136, 90, 227, 4, 157, 179, 64, 78, 37, 155, 227}, 120},
	{{34, 192, 0, 0, 0, 44, 159, 76, 55, 222, 163, 156, 13, 166, 214, 180}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 187, 37, 240, 113, 90, 79, 67, 130}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 106, 243, 179, 135}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 17, 165, 20, 12, 136}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 255}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224, 50, 85, 70, 154}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18, 166}, 120},
	{{34, 192, 0, 44, 101, 200, 243, 95, 97, 48, 123, 56, 202, 151, 118, 81}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 98}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 101, 203, 247, 126, 126, 235, 185, 35, 138}, 120},
	{{34, 192, 0, 0, 22, 190, 147, 88, 85, 123, 167, 136, 31, 227, 249, 200}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 14, 225, 108, 188, 171, 214, 173, 21, 146}, 120},
	{{34, 192, 0, 0, 0, 128, 92, 242, 83, 93, 12, 6, 175, 34, 141, 126}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223, 143}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 240, 154, 185, 129, 116, 149, 198, 243, 33}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 54, 52, 199, 67, 254, 45, 10}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 87, 216}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 217}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 230, 213, 6, 124, 180}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 141, 178, 81, 35, 239, 248}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 129, 176, 104, 89}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 239, 41, 113, 195, 104}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 179, 241}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 20, 33, 165, 68, 204, 121, 44, 216, 191}, 120},
	{{34, 192, 0, 0, 0, 0, 91, 93, 4, 228, 242, 253, 63, 2, 1, 205}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 154, 146, 124, 113, 160}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 148, 246, 202, 96, 221, 88, 145, 132, 253}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 243, 59, 125}, 120},
	{{34, 192, 0, 0, 0, 73, 54, 230, 182, 9, 165, 56, 101, 193, 231, 240}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 236, 203, 106, 90, 8}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 230}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 74, 232, 142, 96, 187, 202, 67}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 85, 34, 147, 200}, 120},
	{{34, 192, 0, 0, 0, 0, 171, 38, 199, 160, 52, 96, 207, 220, 58, 21}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 185, 17, 149, 73, 134}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 141, 16, 109, 116, 14}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 143}, 120},
	{{34, 192, 38, 227, 131, 115, 239, 51, 86, 148, 23, 96, 60, 229, 177, 184}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 127, 177, 189, 98, 24}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 126, 194, 8, 26}, 120},
	{{34, 192, 99, 200, 87, 153, 114, 61, 177, 195, 91, 32, 204, 146, 188, 72}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 82, 208, 84, 68, 129}, 120},
	{{34, 192, 0, 0, 0, 0, 29, 223, 248, 192, 36, 186, 136, 207, 65, 41}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 199, 152, 180, 191, 21, 30, 133, 89}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 251}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 155, 9, 12, 113, 11, 242, 60, 156, 114}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 179, 86}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 44, 151, 176, 241}, 120},
	{{34, 192, 0, 0, 218, 218, 188, 186, 247, 120, 162, 67, 47, 205, 221, 127}, 120},
	{{34, 192, 0, 0, 0, 135, 199, 54, 182, 41, 107, 101, 143, 34, 250, 75}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 178, 50, 81, 254}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 137, 84, 37, 99, 223}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 91, 126, 245, 62}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 242, 130, 16, 128, 73, 247, 5, 129, 230}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 235, 20, 174, 23, 84, 113}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 107, 140, 156, 140, 185, 212, 225, 224, 39}, 120},
	{{34, 192, 0, 251, 147, 181, 13, 100, 45, 175, 181, 27, 164, 229, 81, 7}, 120},
	{{34, 192, 69, 17, 9, 58, 58, 115, 63, 219, 244, 143, 168, 50, 158, 235}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 31, 36, 193, 240, 12, 108, 21, 83, 117}, 120},
	{{34, 192, 0, 0, 0, 104, 251, 189, 69, 39, 219, 252, 14, 245, 73, 31}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 134, 220}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 129, 196, 57, 22, 6, 241, 176}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 223}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66, 122, 74, 146}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 120},
	{{34, 192, 0, 0, 70, 216, 90, 38, 34, 45, 239, 98, 149, 165, 39, 188}, 120},
	{{34, 192, 242, 201, 249, 250, 137, 139, 119, 233, 189, 207, 27, 177, 72, 42}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 178, 226, 205, 207}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 234, 30, 153, 185, 230, 217, 26}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 234, 239, 134, 242, 190, 24, 154, 32}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 53, 6}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 21, 98, 95, 46, 48, 81, 203, 106}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 88, 200, 120, 239, 72, 51, 132, 223}, 120},
	{{34, 192, 0, 0, 0, 0, 222, 221, 17, 43, 13, 81, 171, 79, 78, 181}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 130, 247, 77, 1, 211, 64}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 210, 137, 119}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 144, 226}, 120},
	{{34, 192, 9, 100, 77, 9, 81, 30, 0, 17, 205, 28, 233, 123, 62, 135}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 176, 196, 60, 7, 85, 233, 15, 84, 109}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 12, 205, 213, 171, 37, 123}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 140}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 243, 192, 44, 58, 144, 109, 165, 197}, 120},
	{{34, 192, 0, 0, 0, 0, 94, 158, 237, 240, 27, 93, 95, 137, 137, 114}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 97, 172, 98, 140, 47, 158, 74}, 120},
	{{34, 192, 0, 0, 0, 167, 214, 144, 127, 164, 81, 9, 152, 218, 148, 117}, 120},
	{{34, 192, 0, 0, 0, 0, 24, 236, 42, 5, 216, 74, 145, 57, 73, 233}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 35, 71}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 175, 164, 230, 236, 233}, 120},
	{{34, 192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 115, 21}, 120},
	{{34, 192, 0, 0, 0, 0, 179, 123, 176, 177, 33, 152, 218, 230, 47, 185}, 120},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 19, 103, 90, 147, 229, 247}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 89, 181, 18, 131, 77, 7, 151}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 224}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 83, 131, 177, 245, 75, 244, 149, 212, 2}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 245, 150, 119, 81, 50}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 216, 128, 164, 213, 38, 15, 210, 114, 41}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 104, 232, 131, 140, 131}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 139, 237, 119, 165, 80, 66, 212, 243, 249}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 221, 40, 255, 86, 235, 238, 2}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 0, 199, 188, 226, 216}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 35, 225, 233, 65, 110, 17}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 16, 221, 3, 168, 118, 103, 4, 145}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 0, 0, 0, 239, 255}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 241, 158, 116, 128, 253, 228, 229, 15}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 0, 0, 0, 18, 119}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 159}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 0, 16, 199, 18, 186}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 177, 75, 70, 224, 193, 160, 170}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 177, 216, 65, 199, 50, 189}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 0, 0, 0, 76, 242}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 83, 115, 67, 166, 22}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 76, 1, 5, 169, 58, 242, 23}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 152, 201, 109, 167, 197, 164, 8, 221}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 0, 22, 74, 18, 42}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 13, 87, 186, 161, 42}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 33, 12, 79, 43, 229, 19, 240}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 0, 0, 0, 174, 183}, 94},
	{{215, 141, 95, 192, 189, 62, 80, 152, 106, 120, 212, 212, 250, 153, 112, 125}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 81, 209, 232, 143, 13, 85, 224, 170}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 76, 13, 211, 31, 156, 197, 225, 2}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 213, 120, 118, 213, 47, 253}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 164, 216, 245, 56, 195, 216}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 0, 0, 0, 117, 47}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 105, 86, 157, 108, 59, 188}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 0, 0, 0, 193, 140}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 118, 60, 194, 222, 252}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 0, 181, 139, 206, 116}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 0, 0, 0, 0, 34, 145, 250}, 94},
	{{215, 141, 95, 192, 189, 62, 0, 0, 0, 143, 47, 178, 239, 131, 174, 134}, 94},
	{{215, 141, 95, 192, 