<!--
This file was generated by a tool. We generally don't accept PRs to change the API definition by
editing this file. It's only provided to make the API definition of .NET Standard easier to read
on GitHub. The authoritative definition of the .NET Standard API set is /src/netstandard/ref. 
-->

# .NET Standard 2.0

[Overview](netstandard2.0.md) | [Previous](netstandard1.6_ref.md) | [Next](netstandard2.1_ref.md)

```C#
namespace Microsoft.Win32.SafeHandles {
    public abstract class CriticalHandleMinusOneIsInvalid : CriticalHandle {
        protected CriticalHandleMinusOneIsInvalid();
        public override bool IsInvalid { get; }
    }
    public abstract class CriticalHandleZeroOrMinusOneIsInvalid : CriticalHandle {
        protected CriticalHandleZeroOrMinusOneIsInvalid();
        public override bool IsInvalid { get; }
    }
    public sealed class SafeFileHandle : SafeHandleZeroOrMinusOneIsInvalid {
        public SafeFileHandle(IntPtr preexistingHandle, bool ownsHandle);
        protected override bool ReleaseHandle();
    }
    public abstract class SafeHandleMinusOneIsInvalid : SafeHandle {
        protected SafeHandleMinusOneIsInvalid(bool ownsHandle);
        public override bool IsInvalid { get; }
    }
    public abstract class SafeHandleZeroOrMinusOneIsInvalid : SafeHandle {
        protected SafeHandleZeroOrMinusOneIsInvalid(bool ownsHandle);
        public override bool IsInvalid { get; }
    }
    public sealed class SafeMemoryMappedFileHandle : SafeHandleZeroOrMinusOneIsInvalid {
        protected override bool ReleaseHandle();
    }
    public sealed class SafeMemoryMappedViewHandle : SafeBuffer {
        protected override bool ReleaseHandle();
    }
    public sealed class SafePipeHandle : SafeHandleZeroOrMinusOneIsInvalid {
        public SafePipeHandle(IntPtr preexistingHandle, bool ownsHandle);
        protected override bool ReleaseHandle();
    }
    public sealed class SafeProcessHandle : SafeHandleZeroOrMinusOneIsInvalid {
        public SafeProcessHandle(IntPtr existingHandle, bool ownsHandle);
        protected override bool ReleaseHandle();
    }
    public sealed class SafeWaitHandle : SafeHandleZeroOrMinusOneIsInvalid {
        public SafeWaitHandle(IntPtr existingHandle, bool ownsHandle);
        protected override bool ReleaseHandle();
    }
    public sealed class SafeX509ChainHandle : SafeHandleZeroOrMinusOneIsInvalid {
        protected override bool ReleaseHandle();
    }
}
namespace System {
    public class AccessViolationException : SystemException {
        public AccessViolationException();
        protected AccessViolationException(SerializationInfo info, StreamingContext context);
        public AccessViolationException(string message);
        public AccessViolationException(string message, Exception innerException);
    }
    public delegate void Action();
    public delegate void Action<in T>(T obj);
    public delegate void Action<in T1, in T2>(T1 arg1, T2 arg2);
    public delegate void Action<in T1, in T2, in T3>(T1 arg1, T2 arg2, T3 arg3);
    public delegate void Action<in T1, in T2, in T3, in T4>(T1 arg1, T2 arg2, T3 arg3, T4 arg4);
    public delegate void Action<in T1, in T2, in T3, in T4, in T5>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5);
    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6);
    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6, in T7>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7);
    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8);
    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9);
    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10);
    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11);
    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, in T12>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12);
    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, in T12, in T13>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13);
    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, in T12, in T13, in T14>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13, T14 arg14);
    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, in T12, in T13, in T14, in T15>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13, T14 arg14, T15 arg15);
    public delegate void Action<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, in T12, in T13, in T14, in T15, in T16>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13, T14 arg14, T15 arg15, T16 arg16);
    public static class Activator {
        public static object CreateInstance(Type type);
        public static object CreateInstance(Type type, bool nonPublic);
        public static object CreateInstance(Type type, params object[] args);
        public static object CreateInstance(Type type, object[] args, object[] activationAttributes);
        public static object CreateInstance(Type type, BindingFlags bindingAttr, Binder binder, object[] args, CultureInfo culture);
        public static object CreateInstance(Type type, BindingFlags bindingAttr, Binder binder, object[] args, CultureInfo culture, object[] activationAttributes);
        public static T CreateInstance<T>();
    }
    public class AggregateException : Exception {
        public AggregateException();
        public AggregateException(IEnumerable<Exception> innerExceptions);
        public AggregateException(params Exception[] innerExceptions);
        protected AggregateException(SerializationInfo info, StreamingContext context);
        public AggregateException(string message);
        public AggregateException(string message, IEnumerable<Exception> innerExceptions);
        public AggregateException(string message, Exception innerException);
        public AggregateException(string message, params Exception[] innerExceptions);
        public ReadOnlyCollection<Exception> InnerExceptions { get; }
        public AggregateException Flatten();
        public override Exception GetBaseException();
        public override void GetObjectData(SerializationInfo info, StreamingContext context);
        public void Handle(Func<Exception, bool> predicate);
        public override string ToString();
    }
    public static class AppContext {
        public static string BaseDirectory { get; }
        public static string TargetFrameworkName { get; }
        public static object GetData(string name);
        public static void SetSwitch(string switchName, bool isEnabled);
        public static bool TryGetSwitch(string switchName, out bool isEnabled);
    }
    public sealed class AppDomain : MarshalByRefObject {
        public string BaseDirectory { get; }
        public static AppDomain CurrentDomain { get; }
        public string DynamicDirectory { get; }
        public string FriendlyName { get; }
        public int Id { get; }
        public bool IsFullyTrusted { get; }
        public bool IsHomogenous { get; }
        public static bool MonitoringIsEnabled { get; set; }
        public long MonitoringSurvivedMemorySize { get; }
        public static long MonitoringSurvivedProcessMemorySize { get; }
        public long MonitoringTotalAllocatedMemorySize { get; }
        public TimeSpan MonitoringTotalProcessorTime { get; }
        public string RelativeSearchPath { get; }
        public bool ShadowCopyFiles { get; }
        public event AssemblyLoadEventHandler AssemblyLoad;
        public event ResolveEventHandler AssemblyResolve;
        public event EventHandler DomainUnload;
        public event EventHandler<FirstChanceExceptionEventArgs> FirstChanceException;
        public event EventHandler ProcessExit;
        public event ResolveEventHandler ReflectionOnlyAssemblyResolve;
        public event ResolveEventHandler ResourceResolve;
        public event ResolveEventHandler TypeResolve;
        public event UnhandledExceptionEventHandler UnhandledException;
        public void AppendPrivatePath(string path);
        public string ApplyPolicy(string assemblyName);
        public void ClearPrivatePath();
        public void ClearShadowCopyPath();
        public static AppDomain CreateDomain(string friendlyName);
        public int ExecuteAssembly(string assemblyFile);
        public int ExecuteAssembly(string assemblyFile, string[] args);
        public int ExecuteAssembly(string assemblyFile, string[] args, byte[] hashValue, AssemblyHashAlgorithm hashAlgorithm);
        public int ExecuteAssemblyByName(AssemblyName assemblyName, params string[] args);
        public int ExecuteAssemblyByName(string assemblyName);
        public int ExecuteAssemblyByName(string assemblyName, params string[] args);
        public Assembly[] GetAssemblies();
        public static int GetCurrentThreadId();
        public object GetData(string name);
        public new Type GetType();
        public override object InitializeLifetimeService();
        public Nullable<bool> IsCompatibilitySwitchSet(string value);
        public bool IsDefaultAppDomain();
        public bool IsFinalizingForUnload();
        public Assembly Load(byte[] rawAssembly);
        public Assembly Load(byte[] rawAssembly, byte[] rawSymbolStore);
        public Assembly Load(AssemblyName assemblyRef);
        public Assembly Load(string assemblyString);
        public Assembly[] ReflectionOnlyGetAssemblies();
        public void SetCachePath(string path);
        public void SetData(string name, object data);
        public void SetDynamicBase(string path);
        public void SetPrincipalPolicy(PrincipalPolicy policy);
        public void SetShadowCopyFiles();
        public void SetShadowCopyPath(string path);
        public void SetThreadPrincipal(IPrincipal principal);
        public override string ToString();
        public static void Unload(AppDomain domain);
    }
    public class AppDomainUnloadedException : SystemException {
        public AppDomainUnloadedException();
        protected AppDomainUnloadedException(SerializationInfo info, StreamingContext context);
        public AppDomainUnloadedException(string message);
        public AppDomainUnloadedException(string message, Exception innerException);
    }
    public class ApplicationException : Exception {
        public ApplicationException();
        protected ApplicationException(SerializationInfo info, StreamingContext context);
        public ApplicationException(string message);
        public ApplicationException(string message, Exception innerException);
    }
    public sealed class ApplicationId {
        public ApplicationId(byte[] publicKeyToken, string name, Version version, string processorArchitecture, string culture);
        public string Culture { get; }
        public string Name { get; }
        public string ProcessorArchitecture { get; }
        public byte[] PublicKeyToken { get; }
        public Version Version { get; }
        public ApplicationId Copy();
        public override bool Equals(object o);
        public override int GetHashCode();
        public override string ToString();
    }
    public class ArgumentException : SystemException, ISerializable {
        public ArgumentException();
        protected ArgumentException(SerializationInfo info, StreamingContext context);
        public ArgumentException(string message);
        public ArgumentException(string message, Exception innerException);
        public ArgumentException(string message, string paramName);
        public ArgumentException(string message, string paramName, Exception innerException);
        public override string Message { get; }
        public virtual string ParamName { get; }
        public override void GetObjectData(SerializationInfo info, StreamingContext context);
    }
    public class ArgumentNullException : ArgumentException {
        public ArgumentNullException();
        protected ArgumentNullException(SerializationInfo info, StreamingContext context);
        public ArgumentNullException(string paramName);
        public ArgumentNullException(string message, Exception innerException);
        public ArgumentNullException(string paramName, string message);
    }
    public class ArgumentOutOfRangeException : ArgumentException, ISerializable {
        public ArgumentOutOfRangeException();
        protected ArgumentOutOfRangeException(SerializationInfo info, StreamingContext context);
        public ArgumentOutOfRangeException(string paramName);
        public ArgumentOutOfRangeException(string message, Exception innerException);
        public ArgumentOutOfRangeException(string paramName, object actualValue, string message);
        public ArgumentOutOfRangeException(string paramName, string message);
        public virtual object ActualValue { get; }
        public override string Message { get; }
        public override void GetObjectData(SerializationInfo info, StreamingContext context);
    }
    public class ArithmeticException : SystemException {
        public ArithmeticException();
        protected ArithmeticException(SerializationInfo info, StreamingContext context);
        public ArithmeticException(string message);
        public ArithmeticException(string message, Exception innerException);
    }
    public abstract class Array : ICloneable, ICollection, IEnumerable, IList, IStructuralComparable, IStructuralEquatable {
        public bool IsFixedSize { get; }
        public bool IsReadOnly { get; }
        public bool IsSynchronized { get; }
        public int Length { get; }
        public long LongLength { get; }
        public int Rank { get; }
        public object SyncRoot { get; }
        int System.Collections.ICollection.Count { get; }
        object System.Collections.IList.this[int index] { get; set; }
        public static ReadOnlyCollection<T> AsReadOnly<T>(T[] array);
        public static int BinarySearch(Array array, int index, int length, object value);
        public static int BinarySearch(Array array, int index, int length, object value, IComparer comparer);
        public static int BinarySearch(Array array, object value);
        public static int BinarySearch(Array array, object value, IComparer comparer);
        public static int BinarySearch<T>(T[] array, int index, int length, T value);
        public static int BinarySearch<T>(T[] array, int index, int length, T value, IComparer<T> comparer);
        public static int BinarySearch<T>(T[] array, T value);
        public static int BinarySearch<T>(T[] array, T value, IComparer<T> comparer);
        public static void Clear(Array array, int index, int length);
        public object Clone();
        public static void ConstrainedCopy(Array sourceArray, int sourceIndex, Array destinationArray, int destinationIndex, int length);
        public static TOutput[] ConvertAll<TInput, TOutput>(TInput[] array, Converter<TInput, TOutput> converter);
        public static void Copy(Array sourceArray, Array destinationArray, int length);
        public static void Copy(Array sourceArray, Array destinationArray, long length);
        public static void Copy(Array sourceArray, int sourceIndex, Array destinationArray, int destinationIndex, int length);
        public static void Copy(Array sourceArray, long sourceIndex, Array destinationArray, long destinationIndex, long length);
        public void CopyTo(Array array, int index);
        public void CopyTo(Array array, long index);
        public static Array CreateInstance(Type elementType, int length);
        public static Array CreateInstance(Type elementType, int length1, int length2);
        public static Array CreateInstance(Type elementType, int length1, int length2, int length3);
        public static Array CreateInstance(Type elementType, params int[] lengths);
        public static Array CreateInstance(Type elementType, int[] lengths, int[] lowerBounds);
        public static Array CreateInstance(Type elementType, params long[] lengths);
        public static T[] Empty<T>();
        public static bool Exists<T>(T[] array, Predicate<T> match);
        public static T Find<T>(T[] array, Predicate<T> match);
        public static T[] FindAll<T>(T[] array, Predicate<T> match);
        public static int FindIndex<T>(T[] array, int startIndex, int count, Predicate<T> match);
        public static int FindIndex<T>(T[] array, int startIndex, Predicate<T> match);
        public static int FindIndex<T>(T[] array, Predicate<T> match);
        public static T FindLast<T>(T[] array, Predicate<T> match);
        public static int FindLastIndex<T>(T[] array, int startIndex, int count, Predicate<T> match);
        public static int FindLastIndex<T>(T[] array, int startIndex, Predicate<T> match);
        public static int FindLastIndex<T>(T[] array, Predicate<T> match);
        public static void ForEach<T>(T[] array, Action<T> action);
        public IEnumerator GetEnumerator();
        public int GetLength(int dimension);
        public long GetLongLength(int dimension);
        public int GetLowerBound(int dimension);
        public int GetUpperBound(int dimension);
        public object GetValue(int index);
        public object GetValue(int index1, int index2);
        public object GetValue(int index1, int index2, int index3);
        public object GetValue(params int[] indices);
        public object GetValue(long index);
        public object GetValue(long index1, long index2);
        public object GetValue(long index1, long index2, long index3);
        public object GetValue(params long[] indices);
        public static int IndexOf(Array array, object value);
        public static int IndexOf(Array array, object value, int startIndex);
        public static int IndexOf(Array array, object value, int startIndex, int count);
        public static int IndexOf<T>(T[] array, T value);
        public static int IndexOf<T>(T[] array, T value, int startIndex);
        public static int IndexOf<T>(T[] array, T value, int startIndex, int count);
        public void Initialize();
        public static int LastIndexOf(Array array, object value);
        public static int LastIndexOf(Array array, object value, int startIndex);
        public static int LastIndexOf(Array array, object value, int startIndex, int count);
        public static int LastIndexOf<T>(T[] array, T value);
        public static int LastIndexOf<T>(T[] array, T value, int startIndex);
        public static int LastIndexOf<T>(T[] array, T value, int startIndex, int count);
        public static void Resize<T>(ref T[] array, int newSize);
        public static void Reverse(Array array);
        public static void Reverse(Array array, int index, int length);
        public void SetValue(object value, int index);
        public void SetValue(object value, int index1, int index2);
        public void SetValue(object value, int index1, int index2, int index3);
        public void SetValue(object value, params int[] indices);
        public void SetValue(object value, long index);
        public void SetValue(object value, long index1, long index2);
        public void SetValue(object value, long index1, long index2, long index3);
        public void SetValue(object value, params long[] indices);
        public static void Sort(Array array);
        public static void Sort(Array keys, Array items);
        public static void Sort(Array keys, Array items, IComparer comparer);
        public static void Sort(Array keys, Array items, int index, int length);
        public static void Sort(Array keys, Array items, int index, int length, IComparer comparer);
        public static void Sort(Array array, IComparer comparer);
        public static void Sort(Array array, int index, int length);
        public static void Sort(Array array, int index, int length, IComparer comparer);
        public static void Sort<T>(T[] array);
        public static void Sort<T>(T[] array, IComparer<T> comparer);
        public static void Sort<T>(T[] array, Comparison<T> comparison);
        public static void Sort<T>(T[] array, int index, int length);
        public static void Sort<T>(T[] array, int index, int length, IComparer<T> comparer);
        public static void Sort<TKey, TValue>(TKey[] keys, TValue[] items);
        public static void Sort<TKey, TValue>(TKey[] keys, TValue[] items, IComparer<TKey> comparer);
        public static void Sort<TKey, TValue>(TKey[] keys, TValue[] items, int index, int length);
        public static void Sort<TKey, TValue>(TKey[] keys, TValue[] items, int index, int length, IComparer<TKey> comparer);
        int System.Collections.IList.Add(object value);
        void System.Collections.IList.Clear();
        bool System.Collections.IList.Contains(object value);
        int System.Collections.IList.IndexOf(object value);
        void System.Collections.IList.Insert(int index, object value);
        void System.Collections.IList.Remove(object value);
        void System.Collections.IList.RemoveAt(int index);
        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
        public static bool TrueForAll<T>(T[] array, Predicate<T> match);
    }
    public struct ArraySegment<T> : ICollection<T>, IEnumerable, IEnumerable<T>, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T> {
        public ArraySegment(T[] array);
        public ArraySegment(T[] array, int offset, int count);
        public T[] Array { get; }
        public int Count { get; }
        public int Offset { get; }
        bool System.Collections.Generic.ICollection<T>.IsReadOnly { get; }
        T System.Collections.Generic.IList<T>.this[int index] { get; set; }
        T System.Collections.Generic.IReadOnlyList<T>.this[int index] { get; }
        public bool Equals(ArraySegment<T> obj);
        public override bool Equals(object obj);
        public override int GetHashCode();
        public static bool operator ==(ArraySegment<T> a, ArraySegment<T> b);
        public static bool operator !=(ArraySegment<T> a, ArraySegment<T> b);
        void System.Collections.Generic.ICollection<T>.Add(T item);
        void System.Collections.Generic.ICollection<T>.Clear();
        bool System.Collections.Generic.ICollection<T>.Contains(T item);
        void System.Collections.Generic.ICollection<T>.CopyTo(T[] array, int arrayIndex);
        bool System.Collections.Generic.ICollection<T>.Remove(T item);
        IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
        int System.Collections.Generic.IList<T>.IndexOf(T item);
        void System.Collections.Generic.IList<T>.Insert(int index, T item);
        void System.Collections.Generic.IList<T>.RemoveAt(int index);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
    }
    public class ArrayTypeMismatchException : SystemException {
        public ArrayTypeMismatchException();
        protected ArrayTypeMismatchException(SerializationInfo info, StreamingContext context);
        public ArrayTypeMismatchException(string message);
        public ArrayTypeMismatchException(string message, Exception innerException);
    }
    public class AssemblyLoadEventArgs : EventArgs {
        public AssemblyLoadEventArgs(Assembly loadedAssembly);
        public Assembly LoadedAssembly { get; }
    }
    public delegate void AssemblyLoadEventHandler(object sender, AssemblyLoadEventArgs args);
    public delegate void AsyncCallback(IAsyncResult ar);
    public abstract class Attribute {
        protected Attribute();
        public virtual object TypeId { get; }
        public override bool Equals(object obj);
        public static Attribute GetCustomAttribute(Assembly element, Type attributeType);
        public static Attribute GetCustomAttribute(Assembly element, Type attributeType, bool inherit);
        public static Attribute GetCustomAttribute(MemberInfo element, Type attributeType);
        public static Attribute GetCustomAttribute(MemberInfo element, Type attributeType, bool inherit);
        public static Attribute GetCustomAttribute(Module element, Type attributeType);
        public static Attribute GetCustomAttribute(Module element, Type attributeType, bool inherit);
        public static Attribute GetCustomAttribute(ParameterInfo element, Type attributeType);
        public static Attribute GetCustomAttribute(ParameterInfo element, Type attributeType, bool inherit);
        public static Attribute[] GetCustomAttributes(Assembly element);
        public static Attribute[] GetCustomAttributes(Assembly element, bool inherit);
        public static Attribute[] GetCustomAttributes(Assembly element, Type attributeType);
        public static Attribute[] GetCustomAttributes(Assembly element, Type attributeType, bool inherit);
        public static Attribute[] GetCustomAttributes(MemberInfo element);
        public static Attribute[] GetCustomAttributes(MemberInfo element, bool inherit);
        public static Attribute[] GetCustomAttributes(MemberInfo element, Type type);
        public static Attribute[] GetCustomAttributes(MemberInfo element, Type type, bool inherit);
        public static Attribute[] GetCustomAttributes(Module element);
        public static Attribute[] GetCustomAttributes(Module element, bool inherit);
        public static Attribute[] GetCustomAttributes(Module element, Type attributeType);
        public static Attribute[] GetCustomAttributes(Module element, Type attributeType, bool inherit);
        public static Attribute[] GetCustomAttributes(ParameterInfo element);
        public static Attribute[] GetCustomAttributes(ParameterInfo element, bool inherit);
        public static Attribute[] GetCustomAttributes(ParameterInfo element, Type attributeType);
        public static Attribute[] GetCustomAttributes(ParameterInfo element, Type attributeType, bool inherit);
        public override int GetHashCode();
        public virtual bool IsDefaultAttribute();
        public static bool IsDefined(Assembly element, Type attributeType);
        public static bool IsDefined(Assembly element, Type attributeType, bool inherit);
        public static bool IsDefined(MemberInfo element, Type attributeType);
        public static bool IsDefined(MemberInfo element, Type attributeType, bool inherit);
        public static bool IsDefined(Module element, Type attributeType);
        public static bool IsDefined(Module element, Type attributeType, bool inherit);
        public static bool IsDefined(ParameterInfo element, Type attributeType);
        public static bool IsDefined(ParameterInfo element, Type attributeType, bool inherit);
        public virtual bool Match(object obj);
    }
    public enum AttributeTargets {
        All = 32767,
        Assembly = 1,
        Class = 4,
        Constructor = 32,
        Delegate = 4096,
        Enum = 16,
        Event = 512,
        Field = 256,
        GenericParameter = 16384,
        Interface = 1024,
        Method = 64,
        Module = 2,
        Parameter = 2048,
        Property = 128,
        ReturnValue = 8192,
        Struct = 8,
    }
    public sealed class AttributeUsageAttribute : Attribute {
        public AttributeUsageAttribute(AttributeTargets validOn);
        public bool AllowMultiple { get; set; }
        public bool Inherited { get; set; }
        public AttributeTargets ValidOn { get; }
    }
    public class BadImageFormatException : SystemException {
        public BadImageFormatException();
        protected BadImageFormatException(SerializationInfo info, StreamingContext context);
        public BadImageFormatException(string message);
        public BadImageFormatException(string message, Exception inner);
        public BadImageFormatException(string message, string fileName);
        public BadImageFormatException(string message, string fileName, Exception inner);
        public string FileName { get; }
        public string FusionLog { get; }
        public override string Message { get; }
        public override void GetObjectData(SerializationInfo info, StreamingContext context);
        public override string ToString();
    }
    public enum Base64FormattingOptions {
        InsertLineBreaks = 1,
        None = 0,
    }
    public static class BitConverter {
        public static readonly bool IsLittleEndian;
        public static long DoubleToInt64Bits(double value);
        public static byte[] GetBytes(bool value);
        public static byte[] GetBytes(char value);
        public static byte[] GetBytes(double value);
        public static byte[] GetBytes(short value);
        public static byte[] GetBytes(int value);
        public static byte[] GetBytes(long value);
        public static byte[] GetBytes(float value);
        public static byte[] GetBytes(ushort value);
        public static byte[] GetBytes(uint value);
        public static byte[] GetBytes(ulong value);
        public static double Int64BitsToDouble(long value);
        public static bool ToBoolean(byte[] value, int startIndex);
        public static char ToChar(byte[] value, int startIndex);
        public static double ToDouble(byte[] value, int startIndex);
        public static short ToInt16(byte[] value, int startIndex);
        public static int ToInt32(byte[] value, int startIndex);
        public static long ToInt64(byte[] value, int startIndex);
        public static float ToSingle(byte[] value, int startIndex);
        public static string ToString(byte[] value);
        public static string ToString(byte[] value, int startIndex);
        public static string ToString(byte[] value, int startIndex, int length);
        public static ushort ToUInt16(byte[] value, int startIndex);
        public static uint ToUInt32(byte[] value, int startIndex);
        public static ulong ToUInt64(byte[] value, int startIndex);
    }
    public struct Boolean : IComparable, IComparable<bool>, IConvertible, IEquatable<bool> {
        public static readonly string FalseString;
        public static readonly string TrueString;
        public int CompareTo(Boolean value);
        public int CompareTo(object obj);
        public Boolean Equals(Boolean obj);
        public override Boolean Equals(object obj);
        public override int GetHashCode();
        public TypeCode GetTypeCode();
        public static Boolean Parse(string value);
        Boolean System.IConvertible.ToBoolean(IFormatProvider provider);
        byte System.IConvertible.ToByte(IFormatProvider provider);
        char System.IConvertible.ToChar(IFormatProvider provider);
        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
        decimal System.IConvertible.ToDecimal(IFormatProvider provider);
        double System.IConvertible.ToDouble(IFormatProvider provider);
        short System.IConvertible.ToInt16(IFormatProvider provider);
        int System.IConvertible.ToInt32(IFormatProvider provider);
        long System.IConvertible.ToInt64(IFormatProvider provider);
        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
        float System.IConvertible.ToSingle(IFormatProvider provider);
        object System.IConvertible.ToType(Type type, IFormatProvider provider);
        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
        uint System.IConvertible.ToUInt32(IFormatProvider provider);
        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
        public override string ToString();
        public string ToString(IFormatProvider provider);
        public static Boolean TryParse(string value, out Boolean result);
    }
    public static class Buffer {
        public static void BlockCopy(Array src, int srcOffset, Array dst, int dstOffset, int count);
        public static int ByteLength(Array array);
        public static byte GetByte(Array array, int index);
        public unsafe static void MemoryCopy(void* source, void* destination, long destinationSizeInBytes, long sourceBytesToCopy);
        public unsafe static void MemoryCopy(void* source, void* destination, ulong destinationSizeInBytes, ulong sourceBytesToCopy);
        public static void SetByte(Array array, int index, byte value);
    }
    public struct Byte : IComparable, IComparable<byte>, IConvertible, IEquatable<byte>, IFormattable {
        public const byte MaxValue = (byte)255;
        public const byte MinValue = (byte)0;
        public int CompareTo(Byte value);
        public int CompareTo(object value);
        public bool Equals(Byte obj);
        public override bool Equals(object obj);
        public override int GetHashCode();
        public TypeCode GetTypeCode();
        public static Byte Parse(string s);
        public static Byte Parse(string s, NumberStyles style);
        public static Byte Parse(string s, NumberStyles style, IFormatProvider provider);
        public static Byte Parse(string s, IFormatProvider provider);
        bool System.IConvertible.ToBoolean(IFormatProvider provider);
        Byte System.IConvertible.ToByte(IFormatProvider provider);
        char System.IConvertible.ToChar(IFormatProvider provider);
        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
        decimal System.IConvertible.ToDecimal(IFormatProvider provider);
        double System.IConvertible.ToDouble(IFormatProvider provider);
        short System.IConvertible.ToInt16(IFormatProvider provider);
        int System.IConvertible.ToInt32(IFormatProvider provider);
        long System.IConvertible.ToInt64(IFormatProvider provider);
        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
        float System.IConvertible.ToSingle(IFormatProvider provider);
        object System.IConvertible.ToType(Type type, IFormatProvider provider);
        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
        uint System.IConvertible.ToUInt32(IFormatProvider provider);
        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
        public override string ToString();
        public string ToString(IFormatProvider provider);
        public string ToString(string format);
        public string ToString(string format, IFormatProvider provider);
        public static bool TryParse(string s, out Byte result);
        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out Byte result);
    }
    public class CannotUnloadAppDomainException : SystemException {
        public CannotUnloadAppDomainException();
        protected CannotUnloadAppDomainException(SerializationInfo info, StreamingContext context);
        public CannotUnloadAppDomainException(string message);
        public CannotUnloadAppDomainException(string message, Exception innerException);
    }
    public struct Char : IComparable, IComparable<char>, IConvertible, IEquatable<char> {
        public const char MaxValue = '\uFFFF';
        public const char MinValue = '\0';
        public int CompareTo(Char value);
        public int CompareTo(object value);
        public static string ConvertFromUtf32(int utf32);
        public static int ConvertToUtf32(Char highSurrogate, Char lowSurrogate);
        public static int ConvertToUtf32(string s, int index);
        public bool Equals(Char obj);
        public override bool Equals(object obj);
        public override int GetHashCode();
        public static double GetNumericValue(Char c);
        public static double GetNumericValue(string s, int index);
        public TypeCode GetTypeCode();
        public static UnicodeCategory GetUnicodeCategory(Char c);
        public static UnicodeCategory GetUnicodeCategory(string s, int index);
        public static bool IsControl(Char c);
        public static bool IsControl(string s, int index);
        public static bool IsDigit(Char c);
        public static bool IsDigit(string s, int index);
        public static bool IsHighSurrogate(Char c);
        public static bool IsHighSurrogate(string s, int index);
        public static bool IsLetter(Char c);
        public static bool IsLetter(string s, int index);
        public static bool IsLetterOrDigit(Char c);
        public static bool IsLetterOrDigit(string s, int index);
        public static bool IsLower(Char c);
        public static bool IsLower(string s, int index);
        public static bool IsLowSurrogate(Char c);
        public static bool IsLowSurrogate(string s, int index);
        public static bool IsNumber(Char c);
        public static bool IsNumber(string s, int index);
        public static bool IsPunctuation(Char c);
        public static bool IsPunctuation(string s, int index);
        public static bool IsSeparator(Char c);
        public static bool IsSeparator(string s, int index);
        public static bool IsSurrogate(Char c);
        public static bool IsSurrogate(string s, int index);
        public static bool IsSurrogatePair(Char highSurrogate, Char lowSurrogate);
        public static bool IsSurrogatePair(string s, int index);
        public static bool IsSymbol(Char c);
        public static bool IsSymbol(string s, int index);
        public static bool IsUpper(Char c);
        public static bool IsUpper(string s, int index);
        public static bool IsWhiteSpace(Char c);
        public static bool IsWhiteSpace(string s, int index);
        public static Char Parse(string s);
        bool System.IConvertible.ToBoolean(IFormatProvider provider);
        byte System.IConvertible.ToByte(IFormatProvider provider);
        Char System.IConvertible.ToChar(IFormatProvider provider);
        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
        decimal System.IConvertible.ToDecimal(IFormatProvider provider);
        double System.IConvertible.ToDouble(IFormatProvider provider);
        short System.IConvertible.ToInt16(IFormatProvider provider);
        int System.IConvertible.ToInt32(IFormatProvider provider);
        long System.IConvertible.ToInt64(IFormatProvider provider);
        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
        float System.IConvertible.ToSingle(IFormatProvider provider);
        object System.IConvertible.ToType(Type type, IFormatProvider provider);
        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
        uint System.IConvertible.ToUInt32(IFormatProvider provider);
        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
        public static Char ToLower(Char c);
        public static Char ToLower(Char c, CultureInfo culture);
        public static Char ToLowerInvariant(Char c);
        public override string ToString();
        public static string ToString(Char c);
        public string ToString(IFormatProvider provider);
        public static Char ToUpper(Char c);
        public static Char ToUpper(Char c, CultureInfo culture);
        public static Char ToUpperInvariant(Char c);
        public static bool TryParse(string s, out Char result);
    }
    public sealed class CharEnumerator : ICloneable, IDisposable, IEnumerator, IEnumerator<char> {
        public char Current { get; }
        object System.Collections.IEnumerator.Current { get; }
        public object Clone();
        public void Dispose();
        public bool MoveNext();
        public void Reset();
    }
    public sealed class CLSCompliantAttribute : Attribute {
        public CLSCompliantAttribute(bool isCompliant);
        public bool IsCompliant { get; }
    }
    public delegate int Comparison<in T>(T x, T y);
    public static class Console {
        public static ConsoleColor BackgroundColor { get; set; }
        public static int BufferHeight { get; set; }
        public static int BufferWidth { get; set; }
        public static bool CapsLock { get; }
        public static int CursorLeft { get; set; }
        public static int CursorSize { get; set; }
        public static int CursorTop { get; set; }
        public static bool CursorVisible { get; set; }
        public static TextWriter Error { get; }
        public static ConsoleColor ForegroundColor { get; set; }
        public static TextReader In { get; }
        public static Encoding InputEncoding { get; set; }
        public static bool IsErrorRedirected { get; }
        public static bool IsInputRedirected { get; }
        public static bool IsOutputRedirected { get; }
        public static bool KeyAvailable { get; }
        public static int LargestWindowHeight { get; }
        public static int LargestWindowWidth { get; }
        public static bool NumberLock { get; }
        public static TextWriter Out { get; }
        public static Encoding OutputEncoding { get; set; }
        public static string Title { get; set; }
        public static bool TreatControlCAsInput { get; set; }
        public static int WindowHeight { get; set; }
        public static int WindowLeft { get; set; }
        public static int WindowTop { get; set; }
        public static int WindowWidth { get; set; }
        public static event ConsoleCancelEventHandler CancelKeyPress;
        public static void Beep();
        public static void Beep(int frequency, int duration);
        public static void Clear();
        public static void MoveBufferArea(int sourceLeft, int sourceTop, int sourceWidth, int sourceHeight, int targetLeft, int targetTop);
        public static void MoveBufferArea(int sourceLeft, int sourceTop, int sourceWidth, int sourceHeight, int targetLeft, int targetTop, char sourceChar, ConsoleColor sourceForeColor, ConsoleColor sourceBackColor);
        public static Stream OpenStandardError();
        public static Stream OpenStandardError(int bufferSize);
        public static Stream OpenStandardInput();
        public static Stream OpenStandardInput(int bufferSize);
        public static Stream OpenStandardOutput();
        public static Stream OpenStandardOutput(int bufferSize);
        public static int Read();
        public static ConsoleKeyInfo ReadKey();
        public static ConsoleKeyInfo ReadKey(bool intercept);
        public static string ReadLine();
        public static void ResetColor();
        public static void SetBufferSize(int width, int height);
        public static void SetCursorPosition(int left, int top);
        public static void SetError(TextWriter newError);
        public static void SetIn(TextReader newIn);
        public static void SetOut(TextWriter newOut);
        public static void SetWindowPosition(int left, int top);
        public static void SetWindowSize(int width, int height);
        public static void Write(bool value);
        public static void Write(char value);
        public static void Write(char[] buffer);
        public static void Write(char[] buffer, int index, int count);
        public static void Write(decimal value);
        public static void Write(double value);
        public static void Write(int value);
        public static void Write(long value);
        public static void Write(object value);
        public static void Write(float value);
        public static void Write(string value);
        public static void Write(string format, object arg0);
        public static void Write(string format, object arg0, object arg1);
        public static void Write(string format, object arg0, object arg1, object arg2);
        public static void Write(string format, params object[] arg);
        public static void Write(uint value);
        public static void Write(ulong value);
        public static void WriteLine();
        public static void WriteLine(bool value);
        public static void WriteLine(char value);
        public static void WriteLine(char[] buffer);
        public static void WriteLine(char[] buffer, int index, int count);
        public static void WriteLine(decimal value);
        public static void WriteLine(double value);
        public static void WriteLine(int value);
        public static void WriteLine(long value);
        public static void WriteLine(object value);
        public static void WriteLine(float value);
        public static void WriteLine(string value);
        public static void WriteLine(string format, object arg0);
        public static void WriteLine(string format, object arg0, object arg1);
        public static void WriteLine(string format, object arg0, object arg1, object arg2);
        public static void WriteLine(string format, params object[] arg);
        public static void WriteLine(uint value);
        public static void WriteLine(ulong value);
    }
    public sealed class ConsoleCancelEventArgs : EventArgs {
        public bool Cancel { get; set; }
        public ConsoleSpecialKey SpecialKey { get; }
    }
    public delegate void ConsoleCancelEventHandler(object sender, ConsoleCancelEventArgs e);
    public enum ConsoleColor {
        Black = 0,
        Blue = 9,
        Cyan = 11,
        DarkBlue = 1,
        DarkCyan = 3,
        DarkGray = 8,
        DarkGreen = 2,
        DarkMagenta = 5,
        DarkRed = 4,
        DarkYellow = 6,
        Gray = 7,
        Green = 10,
        Magenta = 13,
        Red = 12,
        White = 15,
        Yellow = 14,
    }
    public enum ConsoleKey {
        A = 65,
        Add = 107,
        Applications = 93,
        Attention = 246,
        B = 66,
        Backspace = 8,
        BrowserBack = 166,
        BrowserFavorites = 171,
        BrowserForward = 167,
        BrowserHome = 172,
        BrowserRefresh = 168,
        BrowserSearch = 170,
        BrowserStop = 169,
        C = 67,
        Clear = 12,
        CrSel = 247,
        D = 68,
        D0 = 48,
        D1 = 49,
        D2 = 50,
        D3 = 51,
        D4 = 52,
        D5 = 53,
        D6 = 54,
        D7 = 55,
        D8 = 56,
        D9 = 57,
        Decimal = 110,
        Delete = 46,
        Divide = 111,
        DownArrow = 40,
        E = 69,
        End = 35,
        Enter = 13,
        EraseEndOfFile = 249,
        Escape = 27,
        Execute = 43,
        ExSel = 248,
        F = 70,
        F1 = 112,
        F10 = 121,
        F11 = 122,
        F12 = 123,
        F13 = 124,
        F14 = 125,
        F15 = 126,
        F16 = 127,
        F17 = 128,
        F18 = 129,
        F19 = 130,
        F2 = 113,
        F20 = 131,
        F21 = 132,
        F22 = 133,
        F23 = 134,
        F24 = 135,
        F3 = 114,
        F4 = 115,
        F5 = 116,
        F6 = 117,
        F7 = 118,
        F8 = 119,
        F9 = 120,
        G = 71,
        H = 72,
        Help = 47,
        Home = 36,
        I = 73,
        Insert = 45,
        J = 74,
        K = 75,
        L = 76,
        LaunchApp1 = 182,
        LaunchApp2 = 183,
        LaunchMail = 180,
        LaunchMediaSelect = 181,
        LeftArrow = 37,
        LeftWindows = 91,
        M = 77,
        MediaNext = 176,
        MediaPlay = 179,
        MediaPrevious = 177,
        MediaStop = 178,
        Multiply = 106,
        N = 78,
        NoName = 252,
        NumPad0 = 96,
        NumPad1 = 97,
        NumPad2 = 98,
        NumPad3 = 99,
        NumPad4 = 100,
        NumPad5 = 101,
        NumPad6 = 102,
        NumPad7 = 103,
        NumPad8 = 104,
        NumPad9 = 105,
        O = 79,
        Oem1 = 186,
        Oem102 = 226,
        Oem2 = 191,
        Oem3 = 192,
        Oem4 = 219,
        Oem5 = 220,
        Oem6 = 221,
        Oem7 = 222,
        Oem8 = 223,
        OemClear = 254,
        OemComma = 188,
        OemMinus = 189,
        OemPeriod = 190,
        OemPlus = 187,
        P = 80,
        Pa1 = 253,
        Packet = 231,
        PageDown = 34,
        PageUp = 33,
        Pause = 19,
        Play = 250,
        Print = 42,
        PrintScreen = 44,
        Process = 229,
        Q = 81,
        R = 82,
        RightArrow = 39,
        RightWindows = 92,
        S = 83,
        Select = 41,
        Separator = 108,
        Sleep = 95,
        Spacebar = 32,
        Subtract = 109,
        T = 84,
        Tab = 9,
        U = 85,
        UpArrow = 38,
        V = 86,
        VolumeDown = 174,
        VolumeMute = 173,
        VolumeUp = 175,
        W = 87,
        X = 88,
        Y = 89,
        Z = 90,
        Zoom = 251,
    }
    public struct ConsoleKeyInfo {
        public ConsoleKeyInfo(char keyChar, ConsoleKey key, bool shift, bool alt, bool control);
        public ConsoleKey Key { get; }
        public char KeyChar { get; }
        public ConsoleModifiers Modifiers { get; }
        public bool Equals(ConsoleKeyInfo obj);
        public override bool Equals(object value);
        public override int GetHashCode();
        public static bool operator ==(ConsoleKeyInfo a, ConsoleKeyInfo b);
        public static bool operator !=(ConsoleKeyInfo a, ConsoleKeyInfo b);
    }
    public enum ConsoleModifiers {
        Alt = 1,
        Control = 4,
        Shift = 2,
    }
    public enum ConsoleSpecialKey {
        ControlBreak = 1,
        ControlC = 0,
    }
    public abstract class ContextBoundObject : MarshalByRefObject {
        protected ContextBoundObject();
    }
    public class ContextMarshalException : SystemException {
        public ContextMarshalException();
        protected ContextMarshalException(SerializationInfo info, StreamingContext context);
        public ContextMarshalException(string message);
        public ContextMarshalException(string message, Exception inner);
    }
    public class ContextStaticAttribute : Attribute {
        public ContextStaticAttribute();
    }
    public static class Convert {
        public static readonly object DBNull;
        public static object ChangeType(object value, Type conversionType);
        public static object ChangeType(object value, Type conversionType, IFormatProvider provider);
        public static object ChangeType(object value, TypeCode typeCode);
        public static object ChangeType(object value, TypeCode typeCode, IFormatProvider provider);
        public static byte[] FromBase64CharArray(char[] inArray, int offset, int length);
        public static byte[] FromBase64String(string s);
        public static TypeCode GetTypeCode(object value);
        public static bool IsDBNull(object value);
        public static int ToBase64CharArray(byte[] inArray, int offsetIn, int length, char[] outArray, int offsetOut);
        public static int ToBase64CharArray(byte[] inArray, int offsetIn, int length, char[] outArray, int offsetOut, Base64FormattingOptions options);
        public static string ToBase64String(byte[] inArray);
        public static string ToBase64String(byte[] inArray, Base64FormattingOptions options);
        public static string ToBase64String(byte[] inArray, int offset, int length);
        public static string ToBase64String(byte[] inArray, int offset, int length, Base64FormattingOptions options);
        public static bool ToBoolean(bool value);
        public static bool ToBoolean(byte value);
        public static bool ToBoolean(char value);
        public static bool ToBoolean(DateTime value);
        public static bool ToBoolean(decimal value);
        public static bool ToBoolean(double value);
        public static bool ToBoolean(short value);
        public static bool ToBoolean(int value);
        public static bool ToBoolean(long value);
        public static bool ToBoolean(object value);
        public static bool ToBoolean(object value, IFormatProvider provider);
        public static bool ToBoolean(sbyte value);
        public static bool ToBoolean(float value);
        public static bool ToBoolean(string value);
        public static bool ToBoolean(string value, IFormatProvider provider);
        public static bool ToBoolean(ushort value);
        public static bool ToBoolean(uint value);
        public static bool ToBoolean(ulong value);
        public static byte ToByte(bool value);
        public static byte ToByte(byte value);
        public static byte ToByte(char value);
        public static byte ToByte(DateTime value);
        public static byte ToByte(decimal value);
        public static byte ToByte(double value);
        public static byte ToByte(short value);
        public static byte ToByte(int value);
        public static byte ToByte(long value);
        public static byte ToByte(object value);
        public static byte ToByte(object value, IFormatProvider provider);
        public static byte ToByte(sbyte value);
        public static byte ToByte(float value);
        public static byte ToByte(string value);
        public static byte ToByte(string value, IFormatProvider provider);
        public static byte ToByte(string value, int fromBase);
        public static byte ToByte(ushort value);
        public static byte ToByte(uint value);
        public static byte ToByte(ulong value);
        public static char ToChar(bool value);
        public static char ToChar(byte value);
        public static char ToChar(char value);
        public static char ToChar(DateTime value);
        public static char ToChar(decimal value);
        public static char ToChar(double value);
        public static char ToChar(short value);
        public static char ToChar(int value);
        public static char ToChar(long value);
        public static char ToChar(object value);
        public static char ToChar(object value, IFormatProvider provider);
        public static char ToChar(sbyte value);
        public static char ToChar(float value);
        public static char ToChar(string value);
        public static char ToChar(string value, IFormatProvider provider);
        public static char ToChar(ushort value);
        public static char ToChar(uint value);
        public static char ToChar(ulong value);
        public static DateTime ToDateTime(bool value);
        public static DateTime ToDateTime(byte value);
        public static DateTime ToDateTime(char value);
        public static DateTime ToDateTime(DateTime value);
        public static DateTime ToDateTime(decimal value);
        public static DateTime ToDateTime(double value);
        public static DateTime ToDateTime(short value);
        public static DateTime ToDateTime(int value);
        public static DateTime ToDateTime(long value);
        public static DateTime ToDateTime(object value);
        public static DateTime ToDateTime(object value, IFormatProvider provider);
        public static DateTime ToDateTime(sbyte value);
        public static DateTime ToDateTime(float value);
        public static DateTime ToDateTime(string value);
        public static DateTime ToDateTime(string value, IFormatProvider provider);
        public static DateTime ToDateTime(ushort value);
        public static DateTime ToDateTime(uint value);
        public static DateTime ToDateTime(ulong value);
        public static decimal ToDecimal(bool value);
        public static decimal ToDecimal(byte value);
        public static decimal ToDecimal(char value);
        public static decimal ToDecimal(DateTime value);
        public static decimal ToDecimal(decimal value);
        public static decimal ToDecimal(double value);
        public static decimal ToDecimal(short value);
        public static decimal ToDecimal(int value);
        public static decimal ToDecimal(long value);
        public static decimal ToDecimal(object value);
        public static decimal ToDecimal(object value, IFormatProvider provider);
        public static decimal ToDecimal(sbyte value);
        public static decimal ToDecimal(float value);
        public static decimal ToDecimal(string value);
        public static decimal ToDecimal(string value, IFormatProvider provider);
        public static decimal ToDecimal(ushort value);
        public static decimal ToDecimal(uint value);
        public static decimal ToDecimal(ulong value);
        public static double ToDouble(bool value);
        public static double ToDouble(byte value);
        public static double ToDouble(char value);
        public static double ToDouble(DateTime value);
        public static double ToDouble(decimal value);
        public static double ToDouble(double value);
        public static double ToDouble(short value);
        public static double ToDouble(int value);
        public static double ToDouble(long value);
        public static double ToDouble(object value);
        public static double ToDouble(object value, IFormatProvider provider);
        public static double ToDouble(sbyte value);
        public static double ToDouble(float value);
        public static double ToDouble(string value);
        public static double ToDouble(string value, IFormatProvider provider);
        public static double ToDouble(ushort value);
        public static double ToDouble(uint value);
        public static double ToDouble(ulong value);
        public static short ToInt16(bool value);
        public static short ToInt16(byte value);
        public static short ToInt16(char value);
        public static short ToInt16(DateTime value);
        public static short ToInt16(decimal value);
        public static short ToInt16(double value);
        public static short ToInt16(short value);
        public static short ToInt16(int value);
        public static short ToInt16(long value);
        public static short ToInt16(object value);
        public static short ToInt16(object value, IFormatProvider provider);
        public static short ToInt16(sbyte value);
        public static short ToInt16(float value);
        public static short ToInt16(string value);
        public static short ToInt16(string value, IFormatProvider provider);
        public static short ToInt16(string value, int fromBase);
        public static short ToInt16(ushort value);
        public static short ToInt16(uint value);
        public static short ToInt16(ulong value);
        public static int ToInt32(bool value);
        public static int ToInt32(byte value);
        public static int ToInt32(char value);
        public static int ToInt32(DateTime value);
        public static int ToInt32(decimal value);
        public static int ToInt32(double value);
        public static int ToInt32(short value);
        public static int ToInt32(int value);
        public static int ToInt32(long value);
        public static int ToInt32(object value);
        public static int ToInt32(object value, IFormatProvider provider);
        public static int ToInt32(sbyte value);
        public static int ToInt32(float value);
        public static int ToInt32(string value);
        public static int ToInt32(string value, IFormatProvider provider);
        public static int ToInt32(string value, int fromBase);
        public static int ToInt32(ushort value);
        public static int ToInt32(uint value);
        public static int ToInt32(ulong value);
        public static long ToInt64(bool value);
        public static long ToInt64(byte value);
        public static long ToInt64(char value);
        public static long ToInt64(DateTime value);
        public static long ToInt64(decimal value);
        public static long ToInt64(double value);
        public static long ToInt64(short value);
        public static long ToInt64(int value);
        public static long ToInt64(long value);
        public static long ToInt64(object value);
        public static long ToInt64(object value, IFormatProvider provider);
        public static long ToInt64(sbyte value);
        public static long ToInt64(float value);
        public static long ToInt64(string value);
        public static long ToInt64(string value, IFormatProvider provider);
        public static long ToInt64(string value, int fromBase);
        public static long ToInt64(ushort value);
        public static long ToInt64(uint value);
        public static long ToInt64(ulong value);
        public static sbyte ToSByte(bool value);
        public static sbyte ToSByte(byte value);
        public static sbyte ToSByte(char value);
        public static sbyte ToSByte(DateTime value);
        public static sbyte ToSByte(decimal value);
        public static sbyte ToSByte(double value);
        public static sbyte ToSByte(short value);
        public static sbyte ToSByte(int value);
        public static sbyte ToSByte(long value);
        public static sbyte ToSByte(object value);
        public static sbyte ToSByte(object value, IFormatProvider provider);
        public static sbyte ToSByte(sbyte value);
        public static sbyte ToSByte(float value);
        public static sbyte ToSByte(string value);
        public static sbyte ToSByte(string value, IFormatProvider provider);
        public static sbyte ToSByte(string value, int fromBase);
        public static sbyte ToSByte(ushort value);
        public static sbyte ToSByte(uint value);
        public static sbyte ToSByte(ulong value);
        public static float ToSingle(bool value);
        public static float ToSingle(byte value);
        public static float ToSingle(char value);
        public static float ToSingle(DateTime value);
        public static float ToSingle(decimal value);
        public static float ToSingle(double value);
        public static float ToSingle(short value);
        public static float ToSingle(int value);
        public static float ToSingle(long value);
        public static float ToSingle(object value);
        public static float ToSingle(object value, IFormatProvider provider);
        public static float ToSingle(sbyte value);
        public static float ToSingle(float value);
        public static float ToSingle(string value);
        public static float ToSingle(string value, IFormatProvider provider);
        public static float ToSingle(ushort value);
        public static float ToSingle(uint value);
        public static float ToSingle(ulong value);
        public static string ToString(bool value);
        public static string ToString(bool value, IFormatProvider provider);
        public static string ToString(byte value);
        public static string ToString(byte value, IFormatProvider provider);
        public static string ToString(byte value, int toBase);
        public static string ToString(char value);
        public static string ToString(char value, IFormatProvider provider);
        public static string ToString(DateTime value);
        public static string ToString(DateTime value, IFormatProvider provider);
        public static string ToString(decimal value);
        public static string ToString(decimal value, IFormatProvider provider);
        public static string ToString(double value);
        public static string ToString(double value, IFormatProvider provider);
        public static string ToString(short value);
        public static string ToString(short value, IFormatProvider provider);
        public static string ToString(short value, int toBase);
        public static string ToString(int value);
        public static string ToString(int value, IFormatProvider provider);
        public static string ToString(int value, int toBase);
        public static string ToString(long value);
        public static string ToString(long value, IFormatProvider provider);
        public static string ToString(long value, int toBase);
        public static string ToString(object value);
        public static string ToString(object value, IFormatProvider provider);
        public static string ToString(sbyte value);
        public static string ToString(sbyte value, IFormatProvider provider);
        public static string ToString(float value);
        public static string ToString(float value, IFormatProvider provider);
        public static string ToString(string value);
        public static string ToString(string value, IFormatProvider provider);
        public static string ToString(ushort value);
        public static string ToString(ushort value, IFormatProvider provider);
        public static string ToString(uint value);
        public static string ToString(uint value, IFormatProvider provider);
        public static string ToString(ulong value);
        public static string ToString(ulong value, IFormatProvider provider);
        public static ushort ToUInt16(bool value);
        public static ushort ToUInt16(byte value);
        public static ushort ToUInt16(char value);
        public static ushort ToUInt16(DateTime value);
        public static ushort ToUInt16(decimal value);
        public static ushort ToUInt16(double value);
        public static ushort ToUInt16(short value);
        public static ushort ToUInt16(int value);
        public static ushort ToUInt16(long value);
        public static ushort ToUInt16(object value);
        public static ushort ToUInt16(object value, IFormatProvider provider);
        public static ushort ToUInt16(sbyte value);
        public static ushort ToUInt16(float value);
        public static ushort ToUInt16(string value);
        public static ushort ToUInt16(string value, IFormatProvider provider);
        public static ushort ToUInt16(string value, int fromBase);
        public static ushort ToUInt16(ushort value);
        public static ushort ToUInt16(uint value);
        public static ushort ToUInt16(ulong value);
        public static uint ToUInt32(bool value);
        public static uint ToUInt32(byte value);
        public static uint ToUInt32(char value);
        public static uint ToUInt32(DateTime value);
        public static uint ToUInt32(decimal value);
        public static uint ToUInt32(double value);
        public static uint ToUInt32(short value);
        public static uint ToUInt32(int value);
        public static uint ToUInt32(long value);
        public static uint ToUInt32(object value);
        public static uint ToUInt32(object value, IFormatProvider provider);
        public static uint ToUInt32(sbyte value);
        public static uint ToUInt32(float value);
        public static uint ToUInt32(string value);
        public static uint ToUInt32(string value, IFormatProvider provider);
        public static uint ToUInt32(string value, int fromBase);
        public static uint ToUInt32(ushort value);
        public static uint ToUInt32(uint value);
        public static uint ToUInt32(ulong value);
        public static ulong ToUInt64(bool value);
        public static ulong ToUInt64(byte value);
        public static ulong ToUInt64(char value);
        public static ulong ToUInt64(DateTime value);
        public static ulong ToUInt64(decimal value);
        public static ulong ToUInt64(double value);
        public static ulong ToUInt64(short value);
        public static ulong ToUInt64(int value);
        public static ulong ToUInt64(long value);
        public static ulong ToUInt64(object value);
        public static ulong ToUInt64(object value, IFormatProvider provider);
        public static ulong ToUInt64(sbyte value);
        public static ulong ToUInt64(float value);
        public static ulong ToUInt64(string value);
        public static ulong ToUInt64(string value, IFormatProvider provider);
        public static ulong ToUInt64(string value, int fromBase);
        public static ulong ToUInt64(ushort value);
        public static ulong ToUInt64(uint value);
        public static ulong ToUInt64(ulong value);
    }
    public delegate TOutput Converter<in TInput, out TOutput>(TInput input);
    public sealed class DataMisalignedException : SystemException {
        public DataMisalignedException();
        public DataMisalignedException(string message);
        public DataMisalignedException(string message, Exception innerException);
    }
    public struct DateTime : IComparable, IComparable<DateTime>, IConvertible, IEquatable<DateTime>, IFormattable, ISerializable {
        public static readonly DateTime MaxValue;
        public static readonly DateTime MinValue;
        public DateTime(int year, int month, int day);
        public DateTime(int year, int month, int day, Calendar calendar);
        public DateTime(int year, int month, int day, int hour, int minute, int second);
        public DateTime(int year, int month, int day, int hour, int minute, int second, DateTimeKind kind);
        public DateTime(int year, int month, int day, int hour, int minute, int second, Calendar calendar);
        public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond);
        public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, DateTimeKind kind);
        public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, Calendar calendar);
        public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, Calendar calendar, DateTimeKind kind);
        public DateTime(long ticks);
        public DateTime(long ticks, DateTimeKind kind);
        public DateTime Date { get; }
        public int Day { get; }
        public DayOfWeek DayOfWeek { get; }
        public int DayOfYear { get; }
        public int Hour { get; }
        public DateTimeKind Kind { get; }
        public int Millisecond { get; }
        public int Minute { get; }
        public int Month { get; }
        public static DateTime Now { get; }
        public int Second { get; }
        public long Ticks { get; }
        public TimeSpan TimeOfDay { get; }
        public static DateTime Today { get; }
        public static DateTime UtcNow { get; }
        public int Year { get; }
        public DateTime Add(TimeSpan value);
        public DateTime AddDays(double value);
        public DateTime AddHours(double value);
        public DateTime AddMilliseconds(double value);
        public DateTime AddMinutes(double value);
        public DateTime AddMonths(int months);
        public DateTime AddSeconds(double value);
        public DateTime AddTicks(long value);
        public DateTime AddYears(int value);
        public static int Compare(DateTime t1, DateTime t2);
        public int CompareTo(DateTime value);
        public int CompareTo(object value);
        public static int DaysInMonth(int year, int month);
        public bool Equals(DateTime value);
        public static bool Equals(DateTime t1, DateTime t2);
        public override bool Equals(object value);
        public static DateTime FromBinary(long dateData);
        public static DateTime FromFileTime(long fileTime);
        public static DateTime FromFileTimeUtc(long fileTime);
        public static DateTime FromOADate(double d);
        public string[] GetDateTimeFormats();
        public string[] GetDateTimeFormats(char format);
        public string[] GetDateTimeFormats(char format, IFormatProvider provider);
        public string[] GetDateTimeFormats(IFormatProvider provider);
        public override int GetHashCode();
        public TypeCode GetTypeCode();
        public bool IsDaylightSavingTime();
        public static bool IsLeapYear(int year);
        public static DateTime operator +(DateTime d, TimeSpan t);
        public static bool operator ==(DateTime d1, DateTime d2);
        public static bool operator >(DateTime t1, DateTime t2);
        public static bool operator >=(DateTime t1, DateTime t2);
        public static bool operator !=(DateTime d1, DateTime d2);
        public static bool operator <(DateTime t1, DateTime t2);
        public static bool operator <=(DateTime t1, DateTime t2);
        public static TimeSpan operator -(DateTime d1, DateTime d2);
        public static DateTime operator -(DateTime d, TimeSpan t);
        public static DateTime Parse(string s);
        public static DateTime Parse(string s, IFormatProvider provider);
        public static DateTime Parse(string s, IFormatProvider provider, DateTimeStyles styles);
        public static DateTime ParseExact(string s, string format, IFormatProvider provider);
        public static DateTime ParseExact(string s, string format, IFormatProvider provider, DateTimeStyles style);
        public static DateTime ParseExact(string s, string[] formats, IFormatProvider provider, DateTimeStyles style);
        public static DateTime SpecifyKind(DateTime value, DateTimeKind kind);
        public TimeSpan Subtract(DateTime value);
        public DateTime Subtract(TimeSpan value);
        bool System.IConvertible.ToBoolean(IFormatProvider provider);
        byte System.IConvertible.ToByte(IFormatProvider provider);
        char System.IConvertible.ToChar(IFormatProvider provider);
        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
        decimal System.IConvertible.ToDecimal(IFormatProvider provider);
        double System.IConvertible.ToDouble(IFormatProvider provider);
        short System.IConvertible.ToInt16(IFormatProvider provider);
        int System.IConvertible.ToInt32(IFormatProvider provider);
        long System.IConvertible.ToInt64(IFormatProvider provider);
        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
        float System.IConvertible.ToSingle(IFormatProvider provider);
        object System.IConvertible.ToType(Type type, IFormatProvider provider);
        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
        uint System.IConvertible.ToUInt32(IFormatProvider provider);
        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo info, StreamingContext context);
        public long ToBinary();
        public long ToFileTime();
        public long ToFileTimeUtc();
        public DateTime ToLocalTime();
        public string ToLongDateString();
        public string ToLongTimeString();
        public double ToOADate();
        public string ToShortDateString();
        public string ToShortTimeString();
        public override string ToString();
        public string ToString(IFormatProvider provider);
        public string ToString(string format);
        public string ToString(string format, IFormatProvider provider);
        public DateTime ToUniversalTime();
        public static bool TryParse(string s, out DateTime result);
        public static bool TryParse(string s, IFormatProvider provider, DateTimeStyles styles, out DateTime result);
        public static bool TryParseExact(string s, string format, IFormatProvider provider, DateTimeStyles style, out DateTime result);
        public static bool TryParseExact(string s, string[] formats, IFormatProvider provider, DateTimeStyles style, out DateTime result);
    }
    public enum DateTimeKind {
        Local = 2,
        Unspecified = 0,
        Utc = 1,
    }
    public struct DateTimeOffset : IComparable, IComparable<DateTimeOffset>, IDeserializationCallback, IEquatable<DateTimeOffset>, IFormattable, ISerializable {
        public static readonly DateTimeOffset MaxValue;
        public static readonly DateTimeOffset MinValue;
        public DateTimeOffset(DateTime dateTime);
        public DateTimeOffset(DateTime dateTime, TimeSpan offset);
        public DateTimeOffset(int year, int month, int day, int hour, int minute, int second, int millisecond, Calendar calendar, TimeSpan offset);
        public DateTimeOffset(int year, int month, int day, int hour, int minute, int second, int millisecond, TimeSpan offset);
        public DateTimeOffset(int year, int month, int day, int hour, int minute, int second, TimeSpan offset);
        public DateTimeOffset(long ticks, TimeSpan offset);
        public DateTime Date { get; }
        public DateTime DateTime { get; }
        public int Day { get; }
        public DayOfWeek DayOfWeek { get; }
        public int DayOfYear { get; }
        public int Hour { get; }
        public DateTime LocalDateTime { get; }
        public int Millisecond { get; }
        public int Minute { get; }
        public int Month { get; }
        public static DateTimeOffset Now { get; }
        public TimeSpan Offset { get; }
        public int Second { get; }
        public long Ticks { get; }
        public TimeSpan TimeOfDay { get; }
        public DateTime UtcDateTime { get; }
        public static DateTimeOffset UtcNow { get; }
        public long UtcTicks { get; }
        public int Year { get; }
        public DateTimeOffset Add(TimeSpan timeSpan);
        public DateTimeOffset AddDays(double days);
        public DateTimeOffset AddHours(double hours);
        public DateTimeOffset AddMilliseconds(double milliseconds);
        public DateTimeOffset AddMinutes(double minutes);
        public DateTimeOffset AddMonths(int months);
        public DateTimeOffset AddSeconds(double seconds);
        public DateTimeOffset AddTicks(long ticks);
        public DateTimeOffset AddYears(int years);
        public static int Compare(DateTimeOffset first, DateTimeOffset second);
        public int CompareTo(DateTimeOffset other);
        public bool Equals(DateTimeOffset other);
        public static bool Equals(DateTimeOffset first, DateTimeOffset second);
        public override bool Equals(object obj);
        public bool EqualsExact(DateTimeOffset other);
        public static DateTimeOffset FromFileTime(long fileTime);
        public static DateTimeOffset FromUnixTimeMilliseconds(long milliseconds);
        public static DateTimeOffset FromUnixTimeSeconds(long seconds);
        public override int GetHashCode();
        public static DateTimeOffset operator +(DateTimeOffset dateTimeOffset, TimeSpan timeSpan);
        public static bool operator ==(DateTimeOffset left, DateTimeOffset right);
        public static bool operator >(DateTimeOffset left, DateTimeOffset right);
        public static bool operator >=(DateTimeOffset left, DateTimeOffset right);
        public static implicit operator DateTimeOffset (DateTime dateTime);
        public static bool operator !=(DateTimeOffset left, DateTimeOffset right);
        public static bool operator <(DateTimeOffset left, DateTimeOffset right);
        public static bool operator <=(DateTimeOffset left, DateTimeOffset right);
        public static TimeSpan operator -(DateTimeOffset left, DateTimeOffset right);
        public static DateTimeOffset operator -(DateTimeOffset dateTimeOffset, TimeSpan timeSpan);
        public static DateTimeOffset Parse(string input);
        public static DateTimeOffset Parse(string input, IFormatProvider formatProvider);
        public static DateTimeOffset Parse(string input, IFormatProvider formatProvider, DateTimeStyles styles);
        public static DateTimeOffset ParseExact(string input, string format, IFormatProvider formatProvider);
        public static DateTimeOffset ParseExact(string input, string format, IFormatProvider formatProvider, DateTimeStyles styles);
        public static DateTimeOffset ParseExact(string input, string[] formats, IFormatProvider formatProvider, DateTimeStyles styles);
        public TimeSpan Subtract(DateTimeOffset value);
        public DateTimeOffset Subtract(TimeSpan value);
        int System.IComparable.CompareTo(object obj);
        void System.Runtime.Serialization.IDeserializationCallback.OnDeserialization(object sender);
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo info, StreamingContext context);
        public long ToFileTime();
        public DateTimeOffset ToLocalTime();
        public DateTimeOffset ToOffset(TimeSpan offset);
        public override string ToString();
        public string ToString(IFormatProvider formatProvider);
        public string ToString(string format);
        public string ToString(string format, IFormatProvider formatProvider);
        public DateTimeOffset ToUniversalTime();
        public long ToUnixTimeMilliseconds();
        public long ToUnixTimeSeconds();
        public static bool TryParse(string input, out DateTimeOffset result);
        public static bool TryParse(string input, IFormatProvider formatProvider, DateTimeStyles styles, out DateTimeOffset result);
        public static bool TryParseExact(string input, string format, IFormatProvider formatProvider, DateTimeStyles styles, out DateTimeOffset result);
        public static bool TryParseExact(string input, string[] formats, IFormatProvider formatProvider, DateTimeStyles styles, out DateTimeOffset result);
    }
    public enum DayOfWeek {
        Friday = 5,
        Monday = 1,
        Saturday = 6,
        Sunday = 0,
        Thursday = 4,
        Tuesday = 2,
        Wednesday = 3,
    }
    public sealed class DBNull : IConvertible, ISerializable {
        public static readonly DBNull Value;
        public void GetObjectData(SerializationInfo info, StreamingContext context);
        public TypeCode GetTypeCode();
        bool System.IConvertible.ToBoolean(IFormatProvider provider);
        byte System.IConvertible.ToByte(IFormatProvider provider);
        char System.IConvertible.ToChar(IFormatProvider provider);
        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
        decimal System.IConvertible.ToDecimal(IFormatProvider provider);
        double System.IConvertible.ToDouble(IFormatProvider provider);
        short System.IConvertible.ToInt16(IFormatProvider provider);
        int System.IConvertible.ToInt32(IFormatProvider provider);
        long System.IConvertible.ToInt64(IFormatProvider provider);
        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
        float System.IConvertible.ToSingle(IFormatProvider provider);
        object System.IConvertible.ToType(Type type, IFormatProvider provider);
        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
        uint System.IConvertible.ToUInt32(IFormatProvider provider);
        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
        public override string ToString();
        public string ToString(IFormatProvider provider);
    }
    public struct Decimal : IComparable, IComparable<decimal>, IConvertible, IDeserializationCallback, IEquatable<decimal>, IFormattable {
        public static readonly decimal MaxValue;
        public static readonly decimal MinusOne;
        public static readonly decimal MinValue;
        public static readonly decimal One;
        public static readonly decimal Zero;
        public Decimal(double value);
        public Decimal(int value);
        public Decimal(int lo, int mid, int hi, bool isNegative, byte scale);
        public Decimal(int[] bits);
        public Decimal(long value);
        public Decimal(float value);
        public Decimal(uint value);
        public Decimal(ulong value);
        public static Decimal Add(Decimal d1, Decimal d2);
        public static Decimal Ceiling(Decimal d);
        public static int Compare(Decimal d1, Decimal d2);
        public int CompareTo(Decimal value);
        public int CompareTo(object value);
        public static Decimal Divide(Decimal d1, Decimal d2);
        public bool Equals(Decimal value);
        public static bool Equals(Decimal d1, Decimal d2);
        public override bool Equals(object value);
        public static Decimal Floor(Decimal d);
        public static Decimal FromOACurrency(long cy);
        public static int[] GetBits(Decimal d);
        public override int GetHashCode();
        public TypeCode GetTypeCode();
        public static Decimal Multiply(Decimal d1, Decimal d2);
        public static Decimal Negate(Decimal d);
        public static Decimal operator +(Decimal d1, Decimal d2);
        public static Decimal operator --(Decimal d);
        public static Decimal operator /(Decimal d1, Decimal d2);
        public static bool operator ==(Decimal d1, Decimal d2);
        public static explicit operator byte (Decimal value);
        public static explicit operator char (Decimal value);
        public static explicit operator double (Decimal value);
        public static explicit operator short (Decimal value);
        public static explicit operator int (Decimal value);
        public static explicit operator long (Decimal value);
        public static explicit operator sbyte (Decimal value);
        public static explicit operator float (Decimal value);
        public static explicit operator ushort (Decimal value);
        public static explicit operator uint (Decimal value);
        public static explicit operator ulong (Decimal value);
        public static explicit operator Decimal (double value);
        public static explicit operator Decimal (float value);
        public static bool operator >(Decimal d1, Decimal d2);
        public static bool operator >=(Decimal d1, Decimal d2);
        public static implicit operator Decimal (byte value);
        public static implicit operator Decimal (char value);
        public static implicit operator Decimal (short value);
        public static implicit operator Decimal (int value);
        public static implicit operator Decimal (long value);
        public static implicit operator Decimal (sbyte value);
        public static implicit operator Decimal (ushort value);
        public static implicit operator Decimal (uint value);
        public static implicit operator Decimal (ulong value);
        public static Decimal operator ++(Decimal d);
        public static bool operator !=(Decimal d1, Decimal d2);
        public static bool operator <(Decimal d1, Decimal d2);
        public static bool operator <=(Decimal d1, Decimal d2);
        public static Decimal operator %(Decimal d1, Decimal d2);
        public static Decimal operator *(Decimal d1, Decimal d2);
        public static Decimal operator -(Decimal d1, Decimal d2);
        public static Decimal operator -(Decimal d);
        public static Decimal operator +(Decimal d);
        public static Decimal Parse(string s);
        public static Decimal Parse(string s, NumberStyles style);
        public static Decimal Parse(string s, NumberStyles style, IFormatProvider provider);
        public static Decimal Parse(string s, IFormatProvider provider);
        public static Decimal Remainder(Decimal d1, Decimal d2);
        public static Decimal Round(Decimal d);
        public static Decimal Round(Decimal d, int decimals);
        public static Decimal Round(Decimal d, int decimals, MidpointRounding mode);
        public static Decimal Round(Decimal d, MidpointRounding mode);
        public static Decimal Subtract(Decimal d1, Decimal d2);
        bool System.IConvertible.ToBoolean(IFormatProvider provider);
        byte System.IConvertible.ToByte(IFormatProvider provider);
        char System.IConvertible.ToChar(IFormatProvider provider);
        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
        Decimal System.IConvertible.ToDecimal(IFormatProvider provider);
        double System.IConvertible.ToDouble(IFormatProvider provider);
        short System.IConvertible.ToInt16(IFormatProvider provider);
        int System.IConvertible.ToInt32(IFormatProvider provider);
        long System.IConvertible.ToInt64(IFormatProvider provider);
        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
        float System.IConvertible.ToSingle(IFormatProvider provider);
        object System.IConvertible.ToType(Type type, IFormatProvider provider);
        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
        uint System.IConvertible.ToUInt32(IFormatProvider provider);
        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
        void System.Runtime.Serialization.IDeserializationCallback.OnDeserialization(object sender);
        public static byte ToByte(Decimal value);
        public static double ToDouble(Decimal d);
        public static short ToInt16(Decimal value);
        public static int ToInt32(Decimal d);
        public static long ToInt64(Decimal d);
        public static long ToOACurrency(Decimal value);
        public static sbyte ToSByte(Decimal value);
        public static float ToSingle(Decimal d);
        public override string ToString();
        public string ToString(IFormatProvider provider);
        public string ToString(string format);
        public string ToString(string format, IFormatProvider provider);
        public static ushort ToUInt16(Decimal value);
        public static uint ToUInt32(Decimal d);
        public static ulong ToUInt64(Decimal d);
        public static Decimal Truncate(Decimal d);
        public static bool TryParse(string s, out Decimal result);
        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out Decimal result);
    }
    public abstract class Delegate : ICloneable, ISerializable {
        protected Delegate(object target, string method);
        protected Delegate(Type target, string method);
        public MethodInfo Method { get; }
        public object Target { get; }
        public virtual object Clone();
        public static Delegate Combine(Delegate a, Delegate b);
        public static Delegate Combine(params Delegate[] delegates);
        protected virtual Delegate CombineImpl(Delegate d);
        public static Delegate CreateDelegate(Type type, object firstArgument, MethodInfo method);
        public static Delegate CreateDelegate(Type type, object firstArgument, MethodInfo method, bool throwOnBindFailure);
        public static Delegate CreateDelegate(Type type, object target, string method);
        public static Delegate CreateDelegate(Type type, object target, string method, bool ignoreCase);
        public static Delegate CreateDelegate(Type type, object target, string method, bool ignoreCase, bool throwOnBindFailure);
        public static Delegate CreateDelegate(Type type, MethodInfo method);
        public static Delegate CreateDelegate(Type type, MethodInfo method, bool throwOnBindFailure);
        public static Delegate CreateDelegate(Type type, Type target, string method);
        public static Delegate CreateDelegate(Type type, Type target, string method, bool ignoreCase);
        public static Delegate CreateDelegate(Type type, Type target, string method, bool ignoreCase, bool throwOnBindFailure);
        public object DynamicInvoke(params object[] args);
        protected virtual object DynamicInvokeImpl(object[] args);
        public override bool Equals(object obj);
        public override int GetHashCode();
        public virtual Delegate[] GetInvocationList();
        protected virtual MethodInfo GetMethodImpl();
        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
        public static bool operator ==(Delegate d1, Delegate d2);
        public static bool operator !=(Delegate d1, Delegate d2);
        public static Delegate Remove(Delegate source, Delegate value);
        public static Delegate RemoveAll(Delegate source, Delegate value);
        protected virtual Delegate RemoveImpl(Delegate d);
    }
    public class DivideByZeroException : ArithmeticException {
        public DivideByZeroException();
        protected DivideByZeroException(SerializationInfo info, StreamingContext context);
        public DivideByZeroException(string message);
        public DivideByZeroException(string message, Exception innerException);
    }
    public class DllNotFoundException : TypeLoadException {
        public DllNotFoundException();
        protected DllNotFoundException(SerializationInfo info, StreamingContext context);
        public DllNotFoundException(string message);
        public DllNotFoundException(string message, Exception inner);
    }
    public struct Double : IComparable, IComparable<double>, IConvertible, IEquatable<double>, IFormattable {
        public const double Epsilon = 4.94065645841247E-324;
        public const double MaxValue = 1.7976931348623157E+308;
        public const double MinValue = -1.7976931348623157E+308;
        public const double NaN = 0.0 / 0.0;
        public const double NegativeInfinity = -1.0 / 0.0;
        public const double PositiveInfinity = 1.0 / 0.0;
        public int CompareTo(Double value);
        public int CompareTo(object value);
        public bool Equals(Double obj);
        public override bool Equals(object obj);
        public override int GetHashCode();
        public TypeCode GetTypeCode();
        public static bool IsInfinity(Double d);
        public static bool IsNaN(Double d);
        public static bool IsNegativeInfinity(Double d);
        public static bool IsPositiveInfinity(Double d);
        public static bool operator ==(Double left, Double right);
        public static bool operator >(Double left, Double right);
        public static bool operator >=(Double left, Double right);
        public static bool operator !=(Double left, Double right);
        public static bool operator <(Double left, Double right);
        public static bool operator <=(Double left, Double right);
        public static Double Parse(string s);
        public static Double Parse(string s, NumberStyles style);
        public static Double Parse(string s, NumberStyles style, IFormatProvider provider);
        public static Double Parse(string s, IFormatProvider provider);
        bool System.IConvertible.ToBoolean(IFormatProvider provider);
        byte System.IConvertible.ToByte(IFormatProvider provider);
        char System.IConvertible.ToChar(IFormatProvider provider);
        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
        decimal System.IConvertible.ToDecimal(IFormatProvider provider);
        Double System.IConvertible.ToDouble(IFormatProvider provider);
        short System.IConvertible.ToInt16(IFormatProvider provider);
        int System.IConvertible.ToInt32(IFormatProvider provider);
        long System.IConvertible.ToInt64(IFormatProvider provider);
        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
        float System.IConvertible.ToSingle(IFormatProvider provider);
        object System.IConvertible.ToType(Type type, IFormatProvider provider);
        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
        uint System.IConvertible.ToUInt32(IFormatProvider provider);
        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
        public override string ToString();
        public string ToString(IFormatProvider provider);
        public string ToString(string format);
        public string ToString(string format, IFormatProvider provider);
        public static bool TryParse(string s, out Double result);
        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out Double result);
    }
    public class DuplicateWaitObjectException : ArgumentException {
        public DuplicateWaitObjectException();
        protected DuplicateWaitObjectException(SerializationInfo info, StreamingContext context);
        public DuplicateWaitObjectException(string parameterName);
        public DuplicateWaitObjectException(string message, Exception innerException);
        public DuplicateWaitObjectException(string parameterName, string message);
    }
    public class EntryPointNotFoundException : TypeLoadException {
        public EntryPointNotFoundException();
        protected EntryPointNotFoundException(SerializationInfo info, StreamingContext context);
        public EntryPointNotFoundException(string message);
        public EntryPointNotFoundException(string message, Exception inner);
    }
    public abstract class Enum : ValueType, IComparable, IConvertible, IFormattable {
        protected Enum();
        public int CompareTo(object target);
        public override bool Equals(object obj);
        public static string Format(Type enumType, object value, string format);
        public override int GetHashCode();
        public static string GetName(Type enumType, object value);
        public static string[] GetNames(Type enumType);
        public TypeCode GetTypeCode();
        public static Type GetUnderlyingType(Type enumType);
        public static Array GetValues(Type enumType);
        public bool HasFlag(Enum flag);
        public static bool IsDefined(Type enumType, object value);
        public static object Parse(Type enumType, string value);
        public static object Parse(Type enumType, string value, bool ignoreCase);
        bool System.IConvertible.ToBoolean(IFormatProvider provider);
        byte System.IConvertible.ToByte(IFormatProvider provider);
        char System.IConvertible.ToChar(IFormatProvider provider);
        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
        decimal System.IConvertible.ToDecimal(IFormatProvider provider);
        double System.IConvertible.ToDouble(IFormatProvider provider);
        short System.IConvertible.ToInt16(IFormatProvider provider);
        int System.IConvertible.ToInt32(IFormatProvider provider);
        long System.IConvertible.ToInt64(IFormatProvider provider);
        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
        float System.IConvertible.ToSingle(IFormatProvider provider);
        object System.IConvertible.ToType(Type type, IFormatProvider provider);
        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
        uint System.IConvertible.ToUInt32(IFormatProvider provider);
        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
        public static object ToObject(Type enumType, byte value);
        public static object ToObject(Type enumType, short value);
        public static object ToObject(Type enumType, int value);
        public static object ToObject(Type enumType, long value);
        public static object ToObject(Type enumType, object value);
        public static object ToObject(Type enumType, sbyte value);
        public static object ToObject(Type enumType, ushort value);
        public static object ToObject(Type enumType, uint value);
        public static object ToObject(Type enumType, ulong value);
        public override string ToString();
        public string ToString(IFormatProvider provider);
        public string ToString(string format);
        public string ToString(string format, IFormatProvider provider);
        public static bool TryParse<TEnum>(string value, bool ignoreCase, out TEnum result) where TEnum : struct;
        public static bool TryParse<TEnum>(string value, out TEnum result) where TEnum : struct;
    }
    public static class Environment {
        public static string CommandLine { get; }
        public static string CurrentDirectory { get; set; }
        public static int CurrentManagedThreadId { get; }
        public static int ExitCode { get; set; }
        public static bool HasShutdownStarted { get; }
        public static bool Is64BitOperatingSystem { get; }
        public static bool Is64BitProcess { get; }
        public static string MachineName { get; }
        public static string NewLine { get; }
        public static OperatingSystem OSVersion { get; }
        public static int ProcessorCount { get; }
        public static string StackTrace { get; }
        public static string SystemDirectory { get; }
        public static int SystemPageSize { get; }
        public static int TickCount { get; }
        public static string UserDomainName { get; }
        public static bool UserInteractive { get; }
        public static string UserName { get; }
        public static Version Version { get; }
        public static long WorkingSet { get; }
        public static void Exit(int exitCode);
        public static string ExpandEnvironmentVariables(string name);
        public static void FailFast(string message);
        public static void FailFast(string message, Exception exception);
        public static string[] GetCommandLineArgs();
        public static string GetEnvironmentVariable(string variable);
        public static string GetEnvironmentVariable(string variable, EnvironmentVariableTarget target);
        public static IDictionary GetEnvironmentVariables();
        public static IDictionary GetEnvironmentVariables(EnvironmentVariableTarget target);
        public static string GetFolderPath(Environment.SpecialFolder folder);
        public static string GetFolderPath(Environment.SpecialFolder folder, Environment.SpecialFolderOption option);
        public static string[] GetLogicalDrives();
        public static void SetEnvironmentVariable(string variable, string value);
        public static void SetEnvironmentVariable(string variable, string value, EnvironmentVariableTarget target);
        public enum SpecialFolder {
            AdminTools = 48,
            ApplicationData = 26,
            CDBurning = 59,
            CommonAdminTools = 47,
            CommonApplicationData = 35,
            CommonDesktopDirectory = 25,
            CommonDocuments = 46,
            CommonMusic = 53,
            CommonOemLinks = 58,
            CommonPictures = 54,
            CommonProgramFiles = 43,
            CommonProgramFilesX86 = 44,
            CommonPrograms = 23,
            CommonStartMenu = 22,
            CommonStartup = 24,
            CommonTemplates = 45,
            CommonVideos = 55,
            Cookies = 33,
            Desktop = 0,
            DesktopDirectory = 16,
            Favorites = 6,
            Fonts = 20,
            History = 34,
            InternetCache = 32,
            LocalApplicationData = 28,
            LocalizedResources = 57,
            MyComputer = 17,
            MyDocuments = 5,
            MyMusic = 13,
            MyPictures = 39,
            MyVideos = 14,
            NetworkShortcuts = 19,
            Personal = 5,
            PrinterShortcuts = 27,
            ProgramFiles = 38,
            ProgramFilesX86 = 42,
            Programs = 2,
            Recent = 8,
            Resources = 56,
            SendTo = 9,
            StartMenu = 11,
            Startup = 7,
            System = 37,
            SystemX86 = 41,
            Templates = 21,
            UserProfile = 40,
            Windows = 36,
        }
        public enum SpecialFolderOption {
            Create = 32768,
            DoNotVerify = 16384,
            None = 0,
        }
    }
    public enum EnvironmentVariableTarget {
        Machine = 2,
        Process = 0,
        User = 1,
    }
    public class EventArgs {
        public static readonly EventArgs Empty;
        public EventArgs();
    }
    public delegate void EventHandler(object sender, EventArgs e);
    public delegate void EventHandler<TEventArgs>(object sender, TEventArgs e);
    public class Exception : ISerializable {
        public Exception();
        protected Exception(SerializationInfo info, StreamingContext context);
        public Exception(string message);
        public Exception(string message, Exception innerException);
        public virtual IDictionary Data { get; }
        public virtual string HelpLink { get; set; }
        public int HResult { get; protected set; }
        public Exception InnerException { get; }
        public virtual string Message { get; }
        public virtual string Source { get; set; }
        public virtual string StackTrace { get; }
        public MethodBase TargetSite { get; }
        protected event EventHandler<SafeSerializationEventArgs> SerializeObjectState;
        public virtual Exception GetBaseException();
        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
        public new Type GetType();
        public override string ToString();
    }
    public sealed class ExecutionEngineException : SystemException {
        public ExecutionEngineException();
        public ExecutionEngineException(string message);
        public ExecutionEngineException(string message, Exception innerException);
    }
    public class FieldAccessException : MemberAccessException {
        public FieldAccessException();
        protected FieldAccessException(SerializationInfo info, StreamingContext context);
        public FieldAccessException(string message);
        public FieldAccessException(string message, Exception inner);
    }
    public class FileStyleUriParser : UriParser {
        public FileStyleUriParser();
    }
    public class FlagsAttribute : Attribute {
        public FlagsAttribute();
    }
    public class FormatException : SystemException {
        public FormatException();
        protected FormatException(SerializationInfo info, StreamingContext context);
        public FormatException(string message);
        public FormatException(string message, Exception innerException);
    }
    public abstract class FormattableString : IFormattable {
        protected FormattableString();
        public abstract int ArgumentCount { get; }
        public abstract string Format { get; }
        public abstract object GetArgument(int index);
        public abstract object[] GetArguments();
        public static string Invariant(FormattableString formattable);
        string System.IFormattable.ToString(string ignored, IFormatProvider formatProvider);
        public override string ToString();
        public abstract string ToString(IFormatProvider formatProvider);
    }
    public class FtpStyleUriParser : UriParser {
        public FtpStyleUriParser();
    }
    public delegate TResult Func<out TResult>();
    public delegate TResult Func<in T, out TResult>(T arg);
    public delegate TResult Func<in T1, in T2, out TResult>(T1 arg1, T2 arg2);
    public delegate TResult Func<in T1, in T2, in T3, out TResult>(T1 arg1, T2 arg2, T3 arg3);
    public delegate TResult Func<in T1, in T2, in T3, in T4, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4);
    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5);
    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6);
    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, in T7, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7);
    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8);
    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9);
    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10);
    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11);
    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, in T12, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12);
    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, in T12, in T13, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13);
    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, in T12, in T13, in T14, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13, T14 arg14);
    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, in T12, in T13, in T14, in T15, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13, T14 arg14, T15 arg15);
    public delegate TResult Func<in T1, in T2, in T3, in T4, in T5, in T6, in T7, in T8, in T9, in T10, in T11, in T12, in T13, in T14, in T15, in T16, out TResult>(T1 arg1, T2 arg2, T3 arg3, T4 arg4, T5 arg5, T6 arg6, T7 arg7, T8 arg8, T9 arg9, T10 arg10, T11 arg11, T12 arg12, T13 arg13, T14 arg14, T15 arg15, T16 arg16);
    public static class GC {
        public static int MaxGeneration { get; }
        public static void AddMemoryPressure(long bytesAllocated);
        public static void CancelFullGCNotification();
        public static void Collect();
        public static void Collect(int generation);
        public static void Collect(int generation, GCCollectionMode mode);
        public static void Collect(int generation, GCCollectionMode mode, bool blocking);
        public static void Collect(int generation, GCCollectionMode mode, bool blocking, bool compacting);
        public static int CollectionCount(int generation);
        public static void EndNoGCRegion();
        public static int GetGeneration(object obj);
        public static int GetGeneration(WeakReference wo);
        public static long GetTotalMemory(bool forceFullCollection);
        public static void KeepAlive(object obj);
        public static void RegisterForFullGCNotification(int maxGenerationThreshold, int largeObjectHeapThreshold);
        public static void RemoveMemoryPressure(long bytesAllocated);
        public static void ReRegisterForFinalize(object obj);
        public static void SuppressFinalize(object obj);
        public static bool TryStartNoGCRegion(long totalSize);
        public static bool TryStartNoGCRegion(long totalSize, bool disallowFullBlockingGC);
        public static bool TryStartNoGCRegion(long totalSize, long lohSize);
        public static bool TryStartNoGCRegion(long totalSize, long lohSize, bool disallowFullBlockingGC);
        public static GCNotificationStatus WaitForFullGCApproach();
        public static GCNotificationStatus WaitForFullGCApproach(int millisecondsTimeout);
        public static GCNotificationStatus WaitForFullGCComplete();
        public static GCNotificationStatus WaitForFullGCComplete(int millisecondsTimeout);
        public static void WaitForPendingFinalizers();
    }
    public enum GCCollectionMode {
        Default = 0,
        Forced = 1,
        Optimized = 2,
    }
    public enum GCNotificationStatus {
        Canceled = 2,
        Failed = 1,
        NotApplicable = 4,
        Succeeded = 0,
        Timeout = 3,
    }
    public class GenericUriParser : UriParser {
        public GenericUriParser(GenericUriParserOptions options);
    }
    public enum GenericUriParserOptions {
        AllowEmptyAuthority = 2,
        Default = 0,
        DontCompressPath = 128,
        DontConvertPathBackslashes = 64,
        DontUnescapePathDotsAndSlashes = 256,
        GenericAuthority = 1,
        Idn = 512,
        IriParsing = 1024,
        NoFragment = 32,
        NoPort = 8,
        NoQuery = 16,
        NoUserInfo = 4,
    }
    public class GopherStyleUriParser : UriParser {
        public GopherStyleUriParser();
    }
    public struct Guid : IComparable, IComparable<Guid>, IEquatable<Guid>, IFormattable {
        public static readonly Guid Empty;
        public Guid(byte[] b);
        public Guid(int a, short b, short c, byte d, byte e, byte f, byte g, byte h, byte i, byte j, byte k);
        public Guid(int a, short b, short c, byte[] d);
        public Guid(string g);
        public Guid(uint a, ushort b, ushort c, byte d, byte e, byte f, byte g, byte h, byte i, byte j, byte k);
        public int CompareTo(Guid value);
        public int CompareTo(object value);
        public bool Equals(Guid g);
        public override bool Equals(object o);
        public override int GetHashCode();
        public static Guid NewGuid();
        public static bool operator ==(Guid a, Guid b);
        public static bool operator !=(Guid a, Guid b);
        public static Guid Parse(string input);
        public static Guid ParseExact(string input, string format);
        public byte[] ToByteArray();
        public override string ToString();
        public string ToString(string format);
        public string ToString(string format, IFormatProvider provider);
        public static bool TryParse(string input, out Guid result);
        public static bool TryParseExact(string input, string format, out Guid result);
    }
    public class HttpStyleUriParser : UriParser {
        public HttpStyleUriParser();
    }
    public interface IAsyncResult {
        object AsyncState { get; }
        WaitHandle AsyncWaitHandle { get; }
        bool CompletedSynchronously { get; }
        bool IsCompleted { get; }
    }
    public interface ICloneable {
        object Clone();
    }
    public interface IComparable {
        int CompareTo(object obj);
    }
    public interface IComparable<in T> {
        int CompareTo(T other);
    }
    public interface IConvertible {
        TypeCode GetTypeCode();
        bool ToBoolean(IFormatProvider provider);
        byte ToByte(IFormatProvider provider);
        char ToChar(IFormatProvider provider);
        DateTime ToDateTime(IFormatProvider provider);
        decimal ToDecimal(IFormatProvider provider);
        double ToDouble(IFormatProvider provider);
        short ToInt16(IFormatProvider provider);
        int ToInt32(IFormatProvider provider);
        long ToInt64(IFormatProvider provider);
        sbyte ToSByte(IFormatProvider provider);
        float ToSingle(IFormatProvider provider);
        string ToString(IFormatProvider provider);
        object ToType(Type conversionType, IFormatProvider provider);
        ushort ToUInt16(IFormatProvider provider);
        uint ToUInt32(IFormatProvider provider);
        ulong ToUInt64(IFormatProvider provider);
    }
    public interface ICustomFormatter {
        string Format(string format, object arg, IFormatProvider formatProvider);
    }
    public interface IDisposable {
        void Dispose();
    }
    public interface IEquatable<T> {
        bool Equals(T other);
    }
    public interface IFormatProvider {
        object GetFormat(Type formatType);
    }
    public interface IFormattable {
        string ToString(string format, IFormatProvider formatProvider);
    }
    public sealed class IndexOutOfRangeException : SystemException {
        public IndexOutOfRangeException();
        public IndexOutOfRangeException(string message);
        public IndexOutOfRangeException(string message, Exception innerException);
    }
    public sealed class InsufficientExecutionStackException : SystemException {
        public InsufficientExecutionStackException();
        public InsufficientExecutionStackException(string message);
        public InsufficientExecutionStackException(string message, Exception innerException);
    }
    public sealed class InsufficientMemoryException : OutOfMemoryException {
        public InsufficientMemoryException();
        public InsufficientMemoryException(string message);
        public InsufficientMemoryException(string message, Exception innerException);
    }
    public struct Int16 : IComparable, IComparable<short>, IConvertible, IEquatable<short>, IFormattable {
        public const short MaxValue = (short)32767;
        public const short MinValue = (short)-32768;
        public int CompareTo(Int16 value);
        public int CompareTo(object value);
        public bool Equals(Int16 obj);
        public override bool Equals(object obj);
        public override int GetHashCode();
        public TypeCode GetTypeCode();
        public static Int16 Parse(string s);
        public static Int16 Parse(string s, NumberStyles style);
        public static Int16 Parse(string s, NumberStyles style, IFormatProvider provider);
        public static Int16 Parse(string s, IFormatProvider provider);
        bool System.IConvertible.ToBoolean(IFormatProvider provider);
        byte System.IConvertible.ToByte(IFormatProvider provider);
        char System.IConvertible.ToChar(IFormatProvider provider);
        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
        decimal System.IConvertible.ToDecimal(IFormatProvider provider);
        double System.IConvertible.ToDouble(IFormatProvider provider);
        Int16 System.IConvertible.ToInt16(IFormatProvider provider);
        int System.IConvertible.ToInt32(IFormatProvider provider);
        long System.IConvertible.ToInt64(IFormatProvider provider);
        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
        float System.IConvertible.ToSingle(IFormatProvider provider);
        object System.IConvertible.ToType(Type type, IFormatProvider provider);
        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
        uint System.IConvertible.ToUInt32(IFormatProvider provider);
        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
        public override string ToString();
        public string ToString(IFormatProvider provider);
        public string ToString(string format);
        public string ToString(string format, IFormatProvider provider);
        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out Int16 result);
        public static bool TryParse(string s, out Int16 result);
    }
    public struct Int32 : IComparable, IComparable<int>, IConvertible, IEquatable<int>, IFormattable {
        public const int MaxValue = 2147483647;
        public const int MinValue = -2147483648;
        public Int32 CompareTo(Int32 value);
        public Int32 CompareTo(object value);
        public bool Equals(Int32 obj);
        public override bool Equals(object obj);
        public override Int32 GetHashCode();
        public TypeCode GetTypeCode();
        public static Int32 Parse(string s);
        public static Int32 Parse(string s, NumberStyles style);
        public static Int32 Parse(string s, NumberStyles style, IFormatProvider provider);
        public static Int32 Parse(string s, IFormatProvider provider);
        bool System.IConvertible.ToBoolean(IFormatProvider provider);
        byte System.IConvertible.ToByte(IFormatProvider provider);
        char System.IConvertible.ToChar(IFormatProvider provider);
        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
        decimal System.IConvertible.ToDecimal(IFormatProvider provider);
        double System.IConvertible.ToDouble(IFormatProvider provider);
        short System.IConvertible.ToInt16(IFormatProvider provider);
        Int32 System.IConvertible.ToInt32(IFormatProvider provider);
        long System.IConvertible.ToInt64(IFormatProvider provider);
        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
        float System.IConvertible.ToSingle(IFormatProvider provider);
        object System.IConvertible.ToType(Type type, IFormatProvider provider);
        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
        uint System.IConvertible.ToUInt32(IFormatProvider provider);
        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
        public override string ToString();
        public string ToString(IFormatProvider provider);
        public string ToString(string format);
        public string ToString(string format, IFormatProvider provider);
        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out Int32 result);
        public static bool TryParse(string s, out Int32 result);
    }
    public struct Int64 : IComparable, IComparable<long>, IConvertible, IEquatable<long>, IFormattable {
        public const long MaxValue = (long)9223372036854775807;
        public const long MinValue = (long)-9223372036854775808;
        public int CompareTo(Int64 value);
        public int CompareTo(object value);
        public bool Equals(Int64 obj);
        public override bool Equals(object obj);
        public override int GetHashCode();
        public TypeCode GetTypeCode();
        public static Int64 Parse(string s);
        public static Int64 Parse(string s, NumberStyles style);
        public static Int64 Parse(string s, NumberStyles style, IFormatProvider provider);
        public static Int64 Parse(string s, IFormatProvider provider);
        bool System.IConvertible.ToBoolean(IFormatProvider provider);
        byte System.IConvertible.ToByte(IFormatProvider provider);
        char System.IConvertible.ToChar(IFormatProvider provider);
        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
        decimal System.IConvertible.ToDecimal(IFormatProvider provider);
        double System.IConvertible.ToDouble(IFormatProvider provider);
        short System.IConvertible.ToInt16(IFormatProvider provider);
        int System.IConvertible.ToInt32(IFormatProvider provider);
        Int64 System.IConvertible.ToInt64(IFormatProvider provider);
        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
        float System.IConvertible.ToSingle(IFormatProvider provider);
        object System.IConvertible.ToType(Type type, IFormatProvider provider);
        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
        uint System.IConvertible.ToUInt32(IFormatProvider provider);
        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
        public override string ToString();
        public string ToString(IFormatProvider provider);
        public string ToString(string format);
        public string ToString(string format, IFormatProvider provider);
        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out Int64 result);
        public static bool TryParse(string s, out Int64 result);
    }
    public struct IntPtr : ISerializable {
        public static readonly IntPtr Zero;
        public IntPtr(int value);
        public IntPtr(long value);
        public unsafe IntPtr(void* value);
        public static int Size { get; }
        public static IntPtr Add(IntPtr pointer, int offset);
        public override bool Equals(object obj);
        public override int GetHashCode();
        public static IntPtr operator +(IntPtr pointer, int offset);
        public static bool operator ==(IntPtr value1, IntPtr value2);
        public static explicit operator IntPtr (int value);
        public static explicit operator IntPtr (long value);
        public static explicit operator int (IntPtr value);
        public static explicit operator long (IntPtr value);
        public unsafe static explicit operator void* (IntPtr value);
        public unsafe static explicit operator IntPtr (void* value);
        public static bool operator !=(IntPtr value1, IntPtr value2);
        public static IntPtr operator -(IntPtr pointer, int offset);
        public static IntPtr Subtract(IntPtr pointer, int offset);
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo info, StreamingContext context);
        public int ToInt32();
        public long ToInt64();
        public unsafe void* ToPointer();
        public override string ToString();
        public string ToString(string format);
    }
    public class InvalidCastException : SystemException {
        public InvalidCastException();
        protected InvalidCastException(SerializationInfo info, StreamingContext context);
        public InvalidCastException(string message);
        public InvalidCastException(string message, Exception innerException);
        public InvalidCastException(string message, int errorCode);
    }
    public class InvalidOperationException : SystemException {
        public InvalidOperationException();
        protected InvalidOperationException(SerializationInfo info, StreamingContext context);
        public InvalidOperationException(string message);
        public InvalidOperationException(string message, Exception innerException);
    }
    public sealed class InvalidProgramException : SystemException {
        public InvalidProgramException();
        public InvalidProgramException(string message);
        public InvalidProgramException(string message, Exception inner);
    }
    public class InvalidTimeZoneException : Exception {
        public InvalidTimeZoneException();
        protected InvalidTimeZoneException(SerializationInfo info, StreamingContext context);
        public InvalidTimeZoneException(string message);
        public InvalidTimeZoneException(string message, Exception innerException);
    }
    public interface IObservable<out T> {
        IDisposable Subscribe(IObserver<T> observer);
    }
    public interface IObserver<in T> {
        void OnCompleted();
        void OnError(Exception error);
        void OnNext(T value);
    }
    public interface IProgress<in T> {
        void Report(T value);
    }
    public interface IServiceProvider {
        object GetService(Type serviceType);
    }
    public class Lazy<T> {
        public Lazy();
        public Lazy(bool isThreadSafe);
        public Lazy(Func<T> valueFactory);
        public Lazy(Func<T> valueFactory, bool isThreadSafe);
        public Lazy(Func<T> valueFactory, LazyThreadSafetyMode mode);
        public Lazy(LazyThreadSafetyMode mode);
        public bool IsValueCreated { get; }
        public T Value { get; }
        public override string ToString();
    }
    public class Lazy<T, TMetadata> : Lazy<T> {
        public Lazy(Func<T> valueFactory, TMetadata metadata);
        public Lazy(Func<T> valueFactory, TMetadata metadata, bool isThreadSafe);
        public Lazy(Func<T> valueFactory, TMetadata metadata, LazyThreadSafetyMode mode);
        public Lazy(TMetadata metadata);
        public Lazy(TMetadata metadata, bool isThreadSafe);
        public Lazy(TMetadata metadata, LazyThreadSafetyMode mode);
        public TMetadata Metadata { get; }
    }
    public class LdapStyleUriParser : UriParser {
        public LdapStyleUriParser();
    }
    public enum LoaderOptimization {
        DisallowBindings = 4,
        DomainMask = 3,
        MultiDomain = 2,
        MultiDomainHost = 3,
        NotSpecified = 0,
        SingleDomain = 1,
    }
    public sealed class LoaderOptimizationAttribute : Attribute {
        public LoaderOptimizationAttribute(byte value);
        public LoaderOptimizationAttribute(LoaderOptimization value);
        public LoaderOptimization Value { get; }
    }
    public sealed class LocalDataStoreSlot {
    }
    public abstract class MarshalByRefObject {
        protected MarshalByRefObject();
        public object GetLifetimeService();
        public virtual object InitializeLifetimeService();
        protected MarshalByRefObject MemberwiseClone(bool cloneIdentity);
    }
    public static class Math {
        public const double E = 2.7182818284590451;
        public const double PI = 3.1415926535897931;
        public static decimal Abs(decimal value);
        public static double Abs(double value);
        public static short Abs(short value);
        public static int Abs(int value);
        public static long Abs(long value);
        public static sbyte Abs(sbyte value);
        public static float Abs(float value);
        public static double Acos(double d);
        public static double Asin(double d);
        public static double Atan(double d);
        public static double Atan2(double y, double x);
        public static long BigMul(int a, int b);
        public static decimal Ceiling(decimal d);
        public static double Ceiling(double a);
        public static double Cos(double d);
        public static double Cosh(double value);
        public static int DivRem(int a, int b, out int result);
        public static long DivRem(long a, long b, out long result);
        public static double Exp(double d);
        public static decimal Floor(decimal d);
        public static double Floor(double d);
        public static double IEEERemainder(double x, double y);
        public static double Log(double d);
        public static double Log(double a, double newBase);
        public static double Log10(double d);
        public static byte Max(byte val1, byte val2);
        public static decimal Max(decimal val1, decimal val2);
        public static double Max(double val1, double val2);
        public static short Max(short val1, short val2);
        public static int Max(int val1, int val2);
        public static long Max(long val1, long val2);
        public static sbyte Max(sbyte val1, sbyte val2);
        public static float Max(float val1, float val2);
        public static ushort Max(ushort val1, ushort val2);
        public static uint Max(uint val1, uint val2);
        public static ulong Max(ulong val1, ulong val2);
        public static byte Min(byte val1, byte val2);
        public static decimal Min(decimal val1, decimal val2);
        public static double Min(double val1, double val2);
        public static short Min(short val1, short val2);
        public static int Min(int val1, int val2);
        public static long Min(long val1, long val2);
        public static sbyte Min(sbyte val1, sbyte val2);
        public static float Min(float val1, float val2);
        public static ushort Min(ushort val1, ushort val2);
        public static uint Min(uint val1, uint val2);
        public static ulong Min(ulong val1, ulong val2);
        public static double Pow(double x, double y);
        public static decimal Round(decimal d);
        public static decimal Round(decimal d, int decimals);
        public static decimal Round(decimal d, int decimals, MidpointRounding mode);
        public static decimal Round(decimal d, MidpointRounding mode);
        public static double Round(double a);
        public static double Round(double value, int digits);
        public static double Round(double value, int digits, MidpointRounding mode);
        public static double Round(double value, MidpointRounding mode);
        public static int Sign(decimal value);
        public static int Sign(double value);
        public static int Sign(short value);
        public static int Sign(int value);
        public static int Sign(long value);
        public static int Sign(sbyte value);
        public static int Sign(float value);
        public static double Sin(double a);
        public static double Sinh(double value);
        public static double Sqrt(double d);
        public static double Tan(double a);
        public static double Tanh(double value);
        public static decimal Truncate(decimal d);
        public static double Truncate(double d);
    }
    public class MemberAccessException : SystemException {
        public MemberAccessException();
        protected MemberAccessException(SerializationInfo info, StreamingContext context);
        public MemberAccessException(string message);
        public MemberAccessException(string message, Exception inner);
    }
    public class MethodAccessException : MemberAccessException {
        public MethodAccessException();
        protected MethodAccessException(SerializationInfo info, StreamingContext context);
        public MethodAccessException(string message);
        public MethodAccessException(string message, Exception inner);
    }
    public enum MidpointRounding {
        AwayFromZero = 1,
        ToEven = 0,
    }
    public class MissingFieldException : MissingMemberException, ISerializable {
        public MissingFieldException();
        protected MissingFieldException(SerializationInfo info, StreamingContext context);
        public MissingFieldException(string message);
        public MissingFieldException(string message, Exception inner);
        public MissingFieldException(string className, string fieldName);
        public override string Message { get; }
    }
    public class MissingMemberException : MemberAccessException, ISerializable {
        protected byte[] Signature;
        protected string ClassName;
        protected string MemberName;
        public MissingMemberException();
        protected MissingMemberException(SerializationInfo info, StreamingContext context);
        public MissingMemberException(string message);
        public MissingMemberException(string message, Exception inner);
        public MissingMemberException(string className, string memberName);
        public override string Message { get; }
        public override void GetObjectData(SerializationInfo info, StreamingContext context);
    }
    public class MissingMethodException : MissingMemberException, ISerializable {
        public MissingMethodException();
        protected MissingMethodException(SerializationInfo info, StreamingContext context);
        public MissingMethodException(string message);
        public MissingMethodException(string message, Exception inner);
        public MissingMethodException(string className, string methodName);
        public override string Message { get; }
    }
    public struct ModuleHandle {
        public static readonly ModuleHandle EmptyHandle;
        public int MDStreamVersion { get; }
        public bool Equals(ModuleHandle handle);
        public override bool Equals(object obj);
        public override int GetHashCode();
        public RuntimeFieldHandle GetRuntimeFieldHandleFromMetadataToken(int fieldToken);
        public RuntimeMethodHandle GetRuntimeMethodHandleFromMetadataToken(int methodToken);
        public RuntimeTypeHandle GetRuntimeTypeHandleFromMetadataToken(int typeToken);
        public static bool operator ==(ModuleHandle left, ModuleHandle right);
        public static bool operator !=(ModuleHandle left, ModuleHandle right);
        public RuntimeFieldHandle ResolveFieldHandle(int fieldToken);
        public RuntimeFieldHandle ResolveFieldHandle(int fieldToken, RuntimeTypeHandle[] typeInstantiationContext, RuntimeTypeHandle[] methodInstantiationContext);
        public RuntimeMethodHandle ResolveMethodHandle(int methodToken);
        public RuntimeMethodHandle ResolveMethodHandle(int methodToken, RuntimeTypeHandle[] typeInstantiationContext, RuntimeTypeHandle[] methodInstantiationContext);
        public RuntimeTypeHandle ResolveTypeHandle(int typeToken);
        public RuntimeTypeHandle ResolveTypeHandle(int typeToken, RuntimeTypeHandle[] typeInstantiationContext, RuntimeTypeHandle[] methodInstantiationContext);
    }
    public sealed class MTAThreadAttribute : Attribute {
        public MTAThreadAttribute();
    }
    public abstract class MulticastDelegate : Delegate {
        protected MulticastDelegate(object target, string method);
        protected MulticastDelegate(Type target, string method);
        protected sealed override Delegate CombineImpl(Delegate follow);
        public sealed override bool Equals(object obj);
        public sealed override int GetHashCode();
        public sealed override Delegate[] GetInvocationList();
        protected override MethodInfo GetMethodImpl();
        public override void GetObjectData(SerializationInfo info, StreamingContext context);
        public static bool operator ==(MulticastDelegate d1, MulticastDelegate d2);
        public static bool operator !=(MulticastDelegate d1, MulticastDelegate d2);
        protected sealed override Delegate RemoveImpl(Delegate value);
    }
    public sealed class MulticastNotSupportedException : SystemException {
        public MulticastNotSupportedException();
        public MulticastNotSupportedException(string message);
        public MulticastNotSupportedException(string message, Exception inner);
    }
    public class NetPipeStyleUriParser : UriParser {
        public NetPipeStyleUriParser();
    }
    public class NetTcpStyleUriParser : UriParser {
        public NetTcpStyleUriParser();
    }
    public class NewsStyleUriParser : UriParser {
        public NewsStyleUriParser();
    }
    public sealed class NonSerializedAttribute : Attribute {
        public NonSerializedAttribute();
    }
    public class NotFiniteNumberException : ArithmeticException {
        public NotFiniteNumberException();
        public NotFiniteNumberException(double offendingNumber);
        protected NotFiniteNumberException(SerializationInfo info, StreamingContext context);
        public NotFiniteNumberException(string message);
        public NotFiniteNumberException(string message, double offendingNumber);
        public NotFiniteNumberException(string message, double offendingNumber, Exception innerException);
        public NotFiniteNumberException(string message, Exception innerException);
        public double OffendingNumber { get; }
        public override void GetObjectData(SerializationInfo info, StreamingContext context);
    }
    public class NotImplementedException : SystemException {
        public NotImplementedException();
        protected NotImplementedException(SerializationInfo info, StreamingContext context);
        public NotImplementedException(string message);
        public NotImplementedException(string message, Exception inner);
    }
    public class NotSupportedException : SystemException {
        public NotSupportedException();
        protected NotSupportedException(SerializationInfo info, StreamingContext context);
        public NotSupportedException(string message);
        public NotSupportedException(string message, Exception innerException);
    }
    public static class Nullable {
        public static int Compare<T>(Nullable<T> n1, Nullable<T> n2) where T : struct;
        public static bool Equals<T>(Nullable<T> n1, Nullable<T> n2) where T : struct;
        public static Type GetUnderlyingType(Type nullableType);
    }
    public struct Nullable<T> where T : struct {
        public Nullable(T value);
        public bool HasValue { get; }
        public T Value { get; }
        public override bool Equals(object other);
        public override int GetHashCode();
        public T GetValueOrDefault();
        public T GetValueOrDefault(T defaultValue);
        public static explicit operator T (Nullable<T> value);
        public static implicit operator Nullable<T> (T value);
        public override string ToString();
    }
    public class NullReferenceException : SystemException {
        public NullReferenceException();
        protected NullReferenceException(SerializationInfo info, StreamingContext context);
        public NullReferenceException(string message);
        public NullReferenceException(string message, Exception innerException);
    }
    public class Object {
        public Object();
        public virtual bool Equals(Object obj);
        public static bool Equals(Object objA, Object objB);
        ~Object();
        public virtual int GetHashCode();
        public Type GetType();
        protected Object MemberwiseClone();
        public static bool ReferenceEquals(Object objA, Object objB);
        public virtual string ToString();
    }
    public class ObjectDisposedException : InvalidOperationException {
        protected ObjectDisposedException(SerializationInfo info, StreamingContext context);
        public ObjectDisposedException(string objectName);
        public ObjectDisposedException(string message, Exception innerException);
        public ObjectDisposedException(string objectName, string message);
        public override string Message { get; }
        public string ObjectName { get; }
        public override void GetObjectData(SerializationInfo info, StreamingContext context);
    }
    public sealed class ObsoleteAttribute : Attribute {
        public ObsoleteAttribute();
        public ObsoleteAttribute(string message);
        public ObsoleteAttribute(string message, bool error);
        public bool IsError { get; }
        public string Message { get; }
    }
    public sealed class OperatingSystem : ICloneable, ISerializable {
        public OperatingSystem(PlatformID platform, Version version);
        public PlatformID Platform { get; }
        public string ServicePack { get; }
        public Version Version { get; }
        public string VersionString { get; }
        public object Clone();
        public void GetObjectData(SerializationInfo info, StreamingContext context);
        public override string ToString();
    }
    public class OperationCanceledException : SystemException {
        public OperationCanceledException();
        protected OperationCanceledException(SerializationInfo info, StreamingContext context);
        public OperationCanceledException(string message);
        public OperationCanceledException(string message, Exception innerException);
        public OperationCanceledException(string message, Exception innerException, CancellationToken token);
        public OperationCanceledException(string message, CancellationToken token);
        public OperationCanceledException(CancellationToken token);
        public CancellationToken CancellationToken { get; }
    }
    public class OutOfMemoryException : SystemException {
        public OutOfMemoryException();
        protected OutOfMemoryException(SerializationInfo info, StreamingContext context);
        public OutOfMemoryException(string message);
        public OutOfMemoryException(string message, Exception innerException);
    }
    public class OverflowException : ArithmeticException {
        public OverflowException();
        protected OverflowException(SerializationInfo info, StreamingContext context);
        public OverflowException(string message);
        public OverflowException(string message, Exception innerException);
    }
    public sealed class ParamArrayAttribute : Attribute {
        public ParamArrayAttribute();
    }
    public enum PlatformID {
        MacOSX = 6,
        Unix = 4,
        Win32NT = 2,
        Win32S = 0,
        Win32Windows = 1,
        WinCE = 3,
        Xbox = 5,
    }
    public class PlatformNotSupportedException : NotSupportedException {
        public PlatformNotSupportedException();
        protected PlatformNotSupportedException(SerializationInfo info, StreamingContext context);
        public PlatformNotSupportedException(string message);
        public PlatformNotSupportedException(string message, Exception inner);
    }
    public delegate bool Predicate<in T>(T obj);
    public class Progress<T> : IProgress<T> {
        public Progress();
        public Progress(Action<T> handler);
        public event EventHandler<T> ProgressChanged;
        protected virtual void OnReport(T value);
        void System.IProgress<T>.Report(T value);
    }
    public class Random {
        public Random();
        public Random(int Seed);
        public virtual int Next();
        public virtual int Next(int maxValue);
        public virtual int Next(int minValue, int maxValue);
        public virtual void NextBytes(byte[] buffer);
        public virtual double NextDouble();
        protected virtual double Sample();
    }
    public class RankException : SystemException {
        public RankException();
        protected RankException(SerializationInfo info, StreamingContext context);
        public RankException(string message);
        public RankException(string message, Exception innerException);
    }
    public class ResolveEventArgs : EventArgs {
        public ResolveEventArgs(string name);
        public ResolveEventArgs(string name, Assembly requestingAssembly);
        public string Name { get; }
        public Assembly RequestingAssembly { get; }
    }
    public delegate Assembly ResolveEventHandler(object sender, ResolveEventArgs args);
    public struct RuntimeArgumentHandle {
    }
    public struct RuntimeFieldHandle : ISerializable {
        public IntPtr Value { get; }
        public override bool Equals(object obj);
        public bool Equals(RuntimeFieldHandle handle);
        public override int GetHashCode();
        public void GetObjectData(SerializationInfo info, StreamingContext context);
        public static bool operator ==(RuntimeFieldHandle left, RuntimeFieldHandle right);
        public static bool operator !=(RuntimeFieldHandle left, RuntimeFieldHandle right);
    }
    public struct RuntimeMethodHandle : ISerializable {
        public IntPtr Value { get; }
        public override bool Equals(object obj);
        public bool Equals(RuntimeMethodHandle handle);
        public IntPtr GetFunctionPointer();
        public override int GetHashCode();
        public void GetObjectData(SerializationInfo info, StreamingContext context);
        public static bool operator ==(RuntimeMethodHandle left, RuntimeMethodHandle right);
        public static bool operator !=(RuntimeMethodHandle left, RuntimeMethodHandle right);
    }
    public struct RuntimeTypeHandle : ISerializable {
        public IntPtr Value { get; }
        public override bool Equals(object obj);
        public bool Equals(RuntimeTypeHandle handle);
        public override int GetHashCode();
        public ModuleHandle GetModuleHandle();
        public void GetObjectData(SerializationInfo info, StreamingContext context);
        public static bool operator ==(object left, RuntimeTypeHandle right);
        public static bool operator ==(RuntimeTypeHandle left, object right);
        public static bool operator !=(object left, RuntimeTypeHandle right);
        public static bool operator !=(RuntimeTypeHandle left, object right);
    }
    public struct SByte : IComparable, IComparable<sbyte>, IConvertible, IEquatable<sbyte>, IFormattable {
        public const sbyte MaxValue = (sbyte)127;
        public const sbyte MinValue = (sbyte)-128;
        public int CompareTo(object obj);
        public int CompareTo(SByte value);
        public override bool Equals(object obj);
        public bool Equals(SByte obj);
        public override int GetHashCode();
        public TypeCode GetTypeCode();
        public static SByte Parse(string s);
        public static SByte Parse(string s, NumberStyles style);
        public static SByte Parse(string s, NumberStyles style, IFormatProvider provider);
        public static SByte Parse(string s, IFormatProvider provider);
        bool System.IConvertible.ToBoolean(IFormatProvider provider);
        byte System.IConvertible.ToByte(IFormatProvider provider);
        char System.IConvertible.ToChar(IFormatProvider provider);
        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
        decimal System.IConvertible.ToDecimal(IFormatProvider provider);
        double System.IConvertible.ToDouble(IFormatProvider provider);
        short System.IConvertible.ToInt16(IFormatProvider provider);
        int System.IConvertible.ToInt32(IFormatProvider provider);
        long System.IConvertible.ToInt64(IFormatProvider provider);
        SByte System.IConvertible.ToSByte(IFormatProvider provider);
        float System.IConvertible.ToSingle(IFormatProvider provider);
        object System.IConvertible.ToType(Type type, IFormatProvider provider);
        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
        uint System.IConvertible.ToUInt32(IFormatProvider provider);
        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
        public override string ToString();
        public string ToString(IFormatProvider provider);
        public string ToString(string format);
        public string ToString(string format, IFormatProvider provider);
        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out SByte result);
        public static bool TryParse(string s, out SByte result);
    }
    public sealed class SerializableAttribute : Attribute {
        public SerializableAttribute();
    }
    public struct Single : IComparable, IComparable<float>, IConvertible, IEquatable<float>, IFormattable {
        public const float Epsilon = 1.401298E-45f;
        public const float MaxValue = 3.40282347E+38f;
        public const float MinValue = -3.40282347E+38f;
        public const float NaN = 0.0f / 0.0f;
        public const float NegativeInfinity = -1.0f / 0.0f;
        public const float PositiveInfinity = 1.0f / 0.0f;
        public int CompareTo(object value);
        public int CompareTo(Single value);
        public override bool Equals(object obj);
        public bool Equals(Single obj);
        public override int GetHashCode();
        public TypeCode GetTypeCode();
        public static bool IsInfinity(Single f);
        public static bool IsNaN(Single f);
        public static bool IsNegativeInfinity(Single f);
        public static bool IsPositiveInfinity(Single f);
        public static bool operator ==(Single left, Single right);
        public static bool operator >(Single left, Single right);
        public static bool operator >=(Single left, Single right);
        public static bool operator !=(Single left, Single right);
        public static bool operator <(Single left, Single right);
        public static bool operator <=(Single left, Single right);
        public static Single Parse(string s);
        public static Single Parse(string s, NumberStyles style);
        public static Single Parse(string s, NumberStyles style, IFormatProvider provider);
        public static Single Parse(string s, IFormatProvider provider);
        bool System.IConvertible.ToBoolean(IFormatProvider provider);
        byte System.IConvertible.ToByte(IFormatProvider provider);
        char System.IConvertible.ToChar(IFormatProvider provider);
        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
        decimal System.IConvertible.ToDecimal(IFormatProvider provider);
        double System.IConvertible.ToDouble(IFormatProvider provider);
        short System.IConvertible.ToInt16(IFormatProvider provider);
        int System.IConvertible.ToInt32(IFormatProvider provider);
        long System.IConvertible.ToInt64(IFormatProvider provider);
        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
        Single System.IConvertible.ToSingle(IFormatProvider provider);
        object System.IConvertible.ToType(Type type, IFormatProvider provider);
        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
        uint System.IConvertible.ToUInt32(IFormatProvider provider);
        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
        public override string ToString();
        public string ToString(IFormatProvider provider);
        public string ToString(string format);
        public string ToString(string format, IFormatProvider provider);
        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out Single result);
        public static bool TryParse(string s, out Single result);
    }
    public sealed class StackOverflowException : SystemException {
        public StackOverflowException();
        public StackOverflowException(string message);
        public StackOverflowException(string message, Exception innerException);
    }
    public sealed class STAThreadAttribute : Attribute {
        public STAThreadAttribute();
    }
    public sealed class String : ICloneable, IComparable, IComparable<string>, IConvertible, IEnumerable, IEnumerable<char>, IEquatable<string> {
        public static readonly string Empty;
        public unsafe String(char* value);
        public unsafe String(char* value, int startIndex, int length);
        public String(char c, int count);
        public String(char[] value);
        public String(char[] value, int startIndex, int length);
        public unsafe String(sbyte* value);
        public unsafe String(sbyte* value, int startIndex, int length);
        public unsafe String(sbyte* value, int startIndex, int length, Encoding enc);
        public int Length { get; }
        public char this[int index] { get; }
        public object Clone();
        public static int Compare(String strA, int indexA, String strB, int indexB, int length);
        public static int Compare(String strA, int indexA, String strB, int indexB, int length, bool ignoreCase);
        public static int Compare(String strA, int indexA, String strB, int indexB, int length, bool ignoreCase, CultureInfo culture);
        public static int Compare(String strA, int indexA, String strB, int indexB, int length, CultureInfo culture, CompareOptions options);
        public static int Compare(String strA, int indexA, String strB, int indexB, int length, StringComparison comparisonType);
        public static int Compare(String strA, String strB);
        public static int Compare(String strA, String strB, bool ignoreCase);
        public static int Compare(String strA, String strB, bool ignoreCase, CultureInfo culture);
        public static int Compare(String strA, String strB, CultureInfo culture, CompareOptions options);
        public static int Compare(String strA, String strB, StringComparison comparisonType);
        public static int CompareOrdinal(String strA, int indexA, String strB, int indexB, int length);
        public static int CompareOrdinal(String strA, String strB);
        public int CompareTo(object value);
        public int CompareTo(String strB);
        public static String Concat(IEnumerable<string> values);
        public static String Concat(object arg0);
        public static String Concat(object arg0, object arg1);
        public static String Concat(object arg0, object arg1, object arg2);
        public static String Concat(params object[] args);
        public static String Concat(String str0, String str1);
        public static String Concat(String str0, String str1, String str2);
        public static String Concat(String str0, String str1, String str2, String str3);
        public static String Concat(params string[] values);
        public static String Concat<T>(IEnumerable<T> values);
        public bool Contains(String value);
        public static String Copy(String str);
        public void CopyTo(int sourceIndex, char[] destination, int destinationIndex, int count);
        public bool EndsWith(String value);
        public bool EndsWith(String value, bool ignoreCase, CultureInfo culture);
        public bool EndsWith(String value, StringComparison comparisonType);
        public override bool Equals(object obj);
        public bool Equals(String value);
        public static bool Equals(String a, String b);
        public static bool Equals(String a, String b, StringComparison comparisonType);
        public bool Equals(String value, StringComparison comparisonType);
        public static String Format(IFormatProvider provider, String format, object arg0);
        public static String Format(IFormatProvider provider, String format, object arg0, object arg1);
        public static String Format(IFormatProvider provider, String format, object arg0, object arg1, object arg2);
        public static String Format(IFormatProvider provider, String format, params object[] args);
        public static String Format(String format, object arg0);
        public static String Format(String format, object arg0, object arg1);
        public static String Format(String format, object arg0, object arg1, object arg2);
        public static String Format(String format, params object[] args);
        public CharEnumerator GetEnumerator();
        public override int GetHashCode();
        public TypeCode GetTypeCode();
        public int IndexOf(char value);
        public int IndexOf(char value, int startIndex);
        public int IndexOf(char value, int startIndex, int count);
        public int IndexOf(String value);
        public int IndexOf(String value, int startIndex);
        public int IndexOf(String value, int startIndex, int count);
        public int IndexOf(String value, int startIndex, int count, StringComparison comparisonType);
        public int IndexOf(String value, int startIndex, StringComparison comparisonType);
        public int IndexOf(String value, StringComparison comparisonType);
        public int IndexOfAny(char[] anyOf);
        public int IndexOfAny(char[] anyOf, int startIndex);
        public int IndexOfAny(char[] anyOf, int startIndex, int count);
        public String Insert(int startIndex, String value);
        public static String Intern(String str);
        public static String IsInterned(String str);
        public bool IsNormalized();
        public bool IsNormalized(NormalizationForm normalizationForm);
        public static bool IsNullOrEmpty(String value);
        public static bool IsNullOrWhiteSpace(String value);
        public static String Join(String separator, IEnumerable<string> values);
        public static String Join(String separator, params object[] values);
        public static String Join(String separator, params string[] value);
        public static String Join(String separator, string[] value, int startIndex, int count);
        public static String Join<T>(String separator, IEnumerable<T> values);
        public int LastIndexOf(char value);
        public int LastIndexOf(char value, int startIndex);
        public int LastIndexOf(char value, int startIndex, int count);
        public int LastIndexOf(String value);
        public int LastIndexOf(String value, int startIndex);
        public int LastIndexOf(String value, int startIndex, int count);
        public int LastIndexOf(String value, int startIndex, int count, StringComparison comparisonType);
        public int LastIndexOf(String value, int startIndex, StringComparison comparisonType);
        public int LastIndexOf(String value, StringComparison comparisonType);
        public int LastIndexOfAny(char[] anyOf);
        public int LastIndexOfAny(char[] anyOf, int startIndex);
        public int LastIndexOfAny(char[] anyOf, int startIndex, int count);
        public String Normalize();
        public String Normalize(NormalizationForm normalizationForm);
        public static bool operator ==(String a, String b);
        public static bool operator !=(String a, String b);
        public String PadLeft(int totalWidth);
        public String PadLeft(int totalWidth, char paddingChar);
        public String PadRight(int totalWidth);
        public String PadRight(int totalWidth, char paddingChar);
        public String Remove(int startIndex);
        public String Remove(int startIndex, int count);
        public String Replace(char oldChar, char newChar);
        public String Replace(String oldValue, String newValue);
        public string[] Split(params char[] separator);
        public string[] Split(char[] separator, int count);
        public string[] Split(char[] separator, int count, StringSplitOptions options);
        public string[] Split(char[] separator, StringSplitOptions options);
        public string[] Split(string[] separator, int count, StringSplitOptions options);
        public string[] Split(string[] separator, StringSplitOptions options);
        public bool StartsWith(String value);
        public bool StartsWith(String value, bool ignoreCase, CultureInfo culture);
        public bool StartsWith(String value, StringComparison comparisonType);
        public String Substring(int startIndex);
        public String Substring(int startIndex, int length);
        IEnumerator<char> System.Collections.Generic.IEnumerable<System.Char>.GetEnumerator();
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        bool System.IConvertible.ToBoolean(IFormatProvider provider);
        byte System.IConvertible.ToByte(IFormatProvider provider);
        char System.IConvertible.ToChar(IFormatProvider provider);
        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
        decimal System.IConvertible.ToDecimal(IFormatProvider provider);
        double System.IConvertible.ToDouble(IFormatProvider provider);
        short System.IConvertible.ToInt16(IFormatProvider provider);
        int System.IConvertible.ToInt32(IFormatProvider provider);
        long System.IConvertible.ToInt64(IFormatProvider provider);
        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
        float System.IConvertible.ToSingle(IFormatProvider provider);
        object System.IConvertible.ToType(Type type, IFormatProvider provider);
        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
        uint System.IConvertible.ToUInt32(IFormatProvider provider);
        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
        public char[] ToCharArray();
        public char[] ToCharArray(int startIndex, int length);
        public String ToLower();
        public String ToLower(CultureInfo culture);
        public String ToLowerInvariant();
        public override String ToString();
        public String ToString(IFormatProvider provider);
        public String ToUpper();
        public String ToUpper(CultureInfo culture);
        public String ToUpperInvariant();
        public String Trim();
        public String Trim(params char[] trimChars);
        public String TrimEnd(params char[] trimChars);
        public String TrimStart(params char[] trimChars);
    }
    public abstract class StringComparer : IComparer, IComparer<string>, IEqualityComparer, IEqualityComparer<string> {
        protected StringComparer();
        public static StringComparer CurrentCulture { get; }
        public static StringComparer CurrentCultureIgnoreCase { get; }
        public static StringComparer InvariantCulture { get; }
        public static StringComparer InvariantCultureIgnoreCase { get; }
        public static StringComparer Ordinal { get; }
        public static StringComparer OrdinalIgnoreCase { get; }
        public int Compare(object x, object y);
        public abstract int Compare(string x, string y);
        public static StringComparer Create(CultureInfo culture, bool ignoreCase);
        public new bool Equals(object x, object y);
        public abstract bool Equals(string x, string y);
        public int GetHashCode(object obj);
        public abstract int GetHashCode(string obj);
    }
    public enum StringComparison {
        CurrentCulture = 0,
        CurrentCultureIgnoreCase = 1,
        InvariantCulture = 2,
        InvariantCultureIgnoreCase = 3,
        Ordinal = 4,
        OrdinalIgnoreCase = 5,
    }
    public static class StringNormalizationExtensions {
        public static bool IsNormalized(this string value);
        public static bool IsNormalized(this string value, NormalizationForm normalizationForm);
        public static string Normalize(this string value);
        public static string Normalize(this string value, NormalizationForm normalizationForm);
    }
    public enum StringSplitOptions {
        None = 0,
        RemoveEmptyEntries = 1,
    }
    public class SystemException : Exception {
        public SystemException();
        protected SystemException(SerializationInfo info, StreamingContext context);
        public SystemException(string message);
        public SystemException(string message, Exception innerException);
    }
    public class ThreadStaticAttribute : Attribute {
        public ThreadStaticAttribute();
    }
    public class TimeoutException : SystemException {
        public TimeoutException();
        protected TimeoutException(SerializationInfo info, StreamingContext context);
        public TimeoutException(string message);
        public TimeoutException(string message, Exception innerException);
    }
    public struct TimeSpan : IComparable, IComparable<TimeSpan>, IEquatable<TimeSpan>, IFormattable {
        public const long TicksPerDay = (long)864000000000;
        public const long TicksPerHour = (long)36000000000;
        public const long TicksPerMillisecond = (long)10000;
        public const long TicksPerMinute = (long)600000000;
        public const long TicksPerSecond = (long)10000000;
        public static readonly TimeSpan MaxValue;
        public static readonly TimeSpan MinValue;
        public static readonly TimeSpan Zero;
        public TimeSpan(int hours, int minutes, int seconds);
        public TimeSpan(int days, int hours, int minutes, int seconds);
        public TimeSpan(int days, int hours, int minutes, int seconds, int milliseconds);
        public TimeSpan(long ticks);
        public int Days { get; }
        public int Hours { get; }
        public int Milliseconds { get; }
        public int Minutes { get; }
        public int Seconds { get; }
        public long Ticks { get; }
        public double TotalDays { get; }
        public double TotalHours { get; }
        public double TotalMilliseconds { get; }
        public double TotalMinutes { get; }
        public double TotalSeconds { get; }
        public TimeSpan Add(TimeSpan ts);
        public static int Compare(TimeSpan t1, TimeSpan t2);
        public int CompareTo(object value);
        public int CompareTo(TimeSpan value);
        public TimeSpan Duration();
        public override bool Equals(object value);
        public bool Equals(TimeSpan obj);
        public static bool Equals(TimeSpan t1, TimeSpan t2);
        public static TimeSpan FromDays(double value);
        public static TimeSpan FromHours(double value);
        public static TimeSpan FromMilliseconds(double value);
        public static TimeSpan FromMinutes(double value);
        public static TimeSpan FromSeconds(double value);
        public static TimeSpan FromTicks(long value);
        public override int GetHashCode();
        public TimeSpan Negate();
        public static TimeSpan operator +(TimeSpan t1, TimeSpan t2);
        public static bool operator ==(TimeSpan t1, TimeSpan t2);
        public static bool operator >(TimeSpan t1, TimeSpan t2);
        public static bool operator >=(TimeSpan t1, TimeSpan t2);
        public static bool operator !=(TimeSpan t1, TimeSpan t2);
        public static bool operator <(TimeSpan t1, TimeSpan t2);
        public static bool operator <=(TimeSpan t1, TimeSpan t2);
        public static TimeSpan operator -(TimeSpan t1, TimeSpan t2);
        public static TimeSpan operator -(TimeSpan t);
        public static TimeSpan operator +(TimeSpan t);
        public static TimeSpan Parse(string s);
        public static TimeSpan Parse(string input, IFormatProvider formatProvider);
        public static TimeSpan ParseExact(string input, string format, IFormatProvider formatProvider);
        public static TimeSpan ParseExact(string input, string format, IFormatProvider formatProvider, TimeSpanStyles styles);
        public static TimeSpan ParseExact(string input, string[] formats, IFormatProvider formatProvider);
        public static TimeSpan ParseExact(string input, string[] formats, IFormatProvider formatProvider, TimeSpanStyles styles);
        public TimeSpan Subtract(TimeSpan ts);
        public override string ToString();
        public string ToString(string format);
        public string ToString(string format, IFormatProvider formatProvider);
        public static bool TryParse(string input, IFormatProvider formatProvider, out TimeSpan result);
        public static bool TryParse(string s, out TimeSpan result);
        public static bool TryParseExact(string input, string format, IFormatProvider formatProvider, TimeSpanStyles styles, out TimeSpan result);
        public static bool TryParseExact(string input, string format, IFormatProvider formatProvider, out TimeSpan result);
        public static bool TryParseExact(string input, string[] formats, IFormatProvider formatProvider, TimeSpanStyles styles, out TimeSpan result);
        public static bool TryParseExact(string input, string[] formats, IFormatProvider formatProvider, out TimeSpan result);
    }
    public abstract class TimeZone {
        protected TimeZone();
        public static TimeZone CurrentTimeZone { get; }
        public abstract string DaylightName { get; }
        public abstract string StandardName { get; }
        public abstract DaylightTime GetDaylightChanges(int year);
        public abstract TimeSpan GetUtcOffset(DateTime time);
        public virtual bool IsDaylightSavingTime(DateTime time);
        public static bool IsDaylightSavingTime(DateTime time, DaylightTime daylightTimes);
        public virtual DateTime ToLocalTime(DateTime time);
        public virtual DateTime ToUniversalTime(DateTime time);
    }
    public sealed class TimeZoneInfo : IDeserializationCallback, IEquatable<TimeZoneInfo>, ISerializable {
        public TimeSpan BaseUtcOffset { get; }
        public string DaylightName { get; }
        public string DisplayName { get; }
        public string Id { get; }
        public static TimeZoneInfo Local { get; }
        public string StandardName { get; }
        public bool SupportsDaylightSavingTime { get; }
        public static TimeZoneInfo Utc { get; }
        public static void ClearCachedData();
        public static DateTime ConvertTime(DateTime dateTime, TimeZoneInfo destinationTimeZone);
        public static DateTime ConvertTime(DateTime dateTime, TimeZoneInfo sourceTimeZone, TimeZoneInfo destinationTimeZone);
        public static DateTimeOffset ConvertTime(DateTimeOffset dateTimeOffset, TimeZoneInfo destinationTimeZone);
        public static DateTime ConvertTimeBySystemTimeZoneId(DateTime dateTime, string destinationTimeZoneId);
        public static DateTime ConvertTimeBySystemTimeZoneId(DateTime dateTime, string sourceTimeZoneId, string destinationTimeZoneId);
        public static DateTimeOffset ConvertTimeBySystemTimeZoneId(DateTimeOffset dateTimeOffset, string destinationTimeZoneId);
        public static DateTime ConvertTimeFromUtc(DateTime dateTime, TimeZoneInfo destinationTimeZone);
        public static DateTime ConvertTimeToUtc(DateTime dateTime);
        public static DateTime ConvertTimeToUtc(DateTime dateTime, TimeZoneInfo sourceTimeZone);
        public static TimeZoneInfo CreateCustomTimeZone(string id, TimeSpan baseUtcOffset, string displayName, string standardDisplayName);
        public static TimeZoneInfo CreateCustomTimeZone(string id, TimeSpan baseUtcOffset, string displayName, string standardDisplayName, string daylightDisplayName, TimeZoneInfo.AdjustmentRule[] adjustmentRules);
        public static TimeZoneInfo CreateCustomTimeZone(string id, TimeSpan baseUtcOffset, string displayName, string standardDisplayName, string daylightDisplayName, TimeZoneInfo.AdjustmentRule[] adjustmentRules, bool disableDaylightSavingTime);
        public override bool Equals(object obj);
        public bool Equals(TimeZoneInfo other);
        public static TimeZoneInfo FindSystemTimeZoneById(string id);
        public static TimeZoneInfo FromSerializedString(string source);
        public TimeZoneInfo.AdjustmentRule[] GetAdjustmentRules();
        public TimeSpan[] GetAmbiguousTimeOffsets(DateTime dateTime);
        public TimeSpan[] GetAmbiguousTimeOffsets(DateTimeOffset dateTimeOffset);
        public override int GetHashCode();
        public static ReadOnlyCollection<TimeZoneInfo> GetSystemTimeZones();
        public TimeSpan GetUtcOffset(DateTime dateTime);
        public TimeSpan GetUtcOffset(DateTimeOffset dateTimeOffset);
        public bool HasSameRules(TimeZoneInfo other);
        public bool IsAmbiguousTime(DateTime dateTime);
        public bool IsAmbiguousTime(DateTimeOffset dateTimeOffset);
        public bool IsDaylightSavingTime(DateTime dateTime);
        public bool IsDaylightSavingTime(DateTimeOffset dateTimeOffset);
        public bool IsInvalidTime(DateTime dateTime);
        void System.Runtime.Serialization.IDeserializationCallback.OnDeserialization(object sender);
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo info, StreamingContext context);
        public string ToSerializedString();
        public override string ToString();
        public sealed class AdjustmentRule : IDeserializationCallback, IEquatable<TimeZoneInfo.AdjustmentRule>, ISerializable {
            public DateTime DateEnd { get; }
            public DateTime DateStart { get; }
            public TimeSpan DaylightDelta { get; }
            public TimeZoneInfo.TransitionTime DaylightTransitionEnd { get; }
            public TimeZoneInfo.TransitionTime DaylightTransitionStart { get; }
            public static TimeZoneInfo.AdjustmentRule CreateAdjustmentRule(DateTime dateStart, DateTime dateEnd, TimeSpan daylightDelta, TimeZoneInfo.TransitionTime daylightTransitionStart, TimeZoneInfo.TransitionTime daylightTransitionEnd);
            public bool Equals(TimeZoneInfo.AdjustmentRule other);
            public override int GetHashCode();
            void System.Runtime.Serialization.IDeserializationCallback.OnDeserialization(object sender);
            void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo info, StreamingContext context);
        }
        public struct TransitionTime : IDeserializationCallback, IEquatable<TimeZoneInfo.TransitionTime>, ISerializable {
            public int Day { get; }
            public DayOfWeek DayOfWeek { get; }
            public bool IsFixedDateRule { get; }
            public int Month { get; }
            public DateTime TimeOfDay { get; }
            public int Week { get; }
            public static TimeZoneInfo.TransitionTime CreateFixedDateRule(DateTime timeOfDay, int month, int day);
            public static TimeZoneInfo.TransitionTime CreateFloatingDateRule(DateTime timeOfDay, int month, int week, DayOfWeek dayOfWeek);
            public override bool Equals(object obj);
            public bool Equals(TimeZoneInfo.TransitionTime other);
            public override int GetHashCode();
            public static bool operator ==(TimeZoneInfo.TransitionTime t1, TimeZoneInfo.TransitionTime t2);
            public static bool operator !=(TimeZoneInfo.TransitionTime t1, TimeZoneInfo.TransitionTime t2);
            void System.Runtime.Serialization.IDeserializationCallback.OnDeserialization(object sender);
            void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo info, StreamingContext context);
        }
    }
    public class TimeZoneNotFoundException : Exception {
        public TimeZoneNotFoundException();
        protected TimeZoneNotFoundException(SerializationInfo info, StreamingContext context);
        public TimeZoneNotFoundException(string message);
        public TimeZoneNotFoundException(string message, Exception innerException);
    }
    public static class Tuple {
        public static Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8>> Create<T1, T2, T3, T4, T5, T6, T7, T8>(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5, T6 item6, T7 item7, T8 item8);
        public static Tuple<T1, T2, T3, T4, T5, T6, T7> Create<T1, T2, T3, T4, T5, T6, T7>(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5, T6 item6, T7 item7);
        public static Tuple<T1, T2, T3, T4, T5, T6> Create<T1, T2, T3, T4, T5, T6>(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5, T6 item6);
        public static Tuple<T1, T2, T3, T4, T5> Create<T1, T2, T3, T4, T5>(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5);
        public static Tuple<T1, T2, T3, T4> Create<T1, T2, T3, T4>(T1 item1, T2 item2, T3 item3, T4 item4);
        public static Tuple<T1, T2, T3> Create<T1, T2, T3>(T1 item1, T2 item2, T3 item3);
        public static Tuple<T1, T2> Create<T1, T2>(T1 item1, T2 item2);
        public static Tuple<T1> Create<T1>(T1 item1);
    }
    public class Tuple<T1> : IComparable, IStructuralComparable, IStructuralEquatable {
        public Tuple(T1 item1);
        public T1 Item1 { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
        int System.IComparable.CompareTo(object obj);
        public override string ToString();
    }
    public class Tuple<T1, T2> : IComparable, IStructuralComparable, IStructuralEquatable {
        public Tuple(T1 item1, T2 item2);
        public T1 Item1 { get; }
        public T2 Item2 { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
        int System.IComparable.CompareTo(object obj);
        public override string ToString();
    }
    public class Tuple<T1, T2, T3> : IComparable, IStructuralComparable, IStructuralEquatable {
        public Tuple(T1 item1, T2 item2, T3 item3);
        public T1 Item1 { get; }
        public T2 Item2 { get; }
        public T3 Item3 { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
        int System.IComparable.CompareTo(object obj);
        public override string ToString();
    }
    public class Tuple<T1, T2, T3, T4> : IComparable, IStructuralComparable, IStructuralEquatable {
        public Tuple(T1 item1, T2 item2, T3 item3, T4 item4);
        public T1 Item1 { get; }
        public T2 Item2 { get; }
        public T3 Item3 { get; }
        public T4 Item4 { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
        int System.IComparable.CompareTo(object obj);
        public override string ToString();
    }
    public class Tuple<T1, T2, T3, T4, T5> : IComparable, IStructuralComparable, IStructuralEquatable {
        public Tuple(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5);
        public T1 Item1 { get; }
        public T2 Item2 { get; }
        public T3 Item3 { get; }
        public T4 Item4 { get; }
        public T5 Item5 { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
        int System.IComparable.CompareTo(object obj);
        public override string ToString();
    }
    public class Tuple<T1, T2, T3, T4, T5, T6> : IComparable, IStructuralComparable, IStructuralEquatable {
        public Tuple(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5, T6 item6);
        public T1 Item1 { get; }
        public T2 Item2 { get; }
        public T3 Item3 { get; }
        public T4 Item4 { get; }
        public T5 Item5 { get; }
        public T6 Item6 { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
        int System.IComparable.CompareTo(object obj);
        public override string ToString();
    }
    public class Tuple<T1, T2, T3, T4, T5, T6, T7> : IComparable, IStructuralComparable, IStructuralEquatable {
        public Tuple(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5, T6 item6, T7 item7);
        public T1 Item1 { get; }
        public T2 Item2 { get; }
        public T3 Item3 { get; }
        public T4 Item4 { get; }
        public T5 Item5 { get; }
        public T6 Item6 { get; }
        public T7 Item7 { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
        int System.IComparable.CompareTo(object obj);
        public override string ToString();
    }
    public class Tuple<T1, T2, T3, T4, T5, T6, T7, TRest> : IComparable, IStructuralComparable, IStructuralEquatable {
        public Tuple(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5, T6 item6, T7 item7, TRest rest);
        public T1 Item1 { get; }
        public T2 Item2 { get; }
        public T3 Item3 { get; }
        public T4 Item4 { get; }
        public T5 Item5 { get; }
        public T6 Item6 { get; }
        public T7 Item7 { get; }
        public TRest Rest { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
        int System.IComparable.CompareTo(object obj);
        public override string ToString();
    }
    public static class TupleExtensions {
        public static void Deconstruct<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14, Tuple<T15, T16, T17, T18, T19, T20, T21>>> value, out T1 item1, out T2 item2, out T3 item3, out T4 item4, out T5 item5, out T6 item6, out T7 item7, out T8 item8, out T9 item9, out T10 item10, out T11 item11, out T12 item12, out T13 item13, out T14 item14, out T15 item15, out T16 item16, out T17 item17, out T18 item18, out T19 item19, out T20 item20, out T21 item21);
        public static void Deconstruct<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14, Tuple<T15, T16, T17, T18, T19, T20>>> value, out T1 item1, out T2 item2, out T3 item3, out T4 item4, out T5 item5, out T6 item6, out T7 item7, out T8 item8, out T9 item9, out T10 item10, out T11 item11, out T12 item12, out T13 item13, out T14 item14, out T15 item15, out T16 item16, out T17 item17, out T18 item18, out T19 item19, out T20 item20);
        public static void Deconstruct<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14, Tuple<T15, T16, T17, T18, T19>>> value, out T1 item1, out T2 item2, out T3 item3, out T4 item4, out T5 item5, out T6 item6, out T7 item7, out T8 item8, out T9 item9, out T10 item10, out T11 item11, out T12 item12, out T13 item13, out T14 item14, out T15 item15, out T16 item16, out T17 item17, out T18 item18, out T19 item19);
        public static void Deconstruct<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14, Tuple<T15, T16, T17, T18>>> value, out T1 item1, out T2 item2, out T3 item3, out T4 item4, out T5 item5, out T6 item6, out T7 item7, out T8 item8, out T9 item9, out T10 item10, out T11 item11, out T12 item12, out T13 item13, out T14 item14, out T15 item15, out T16 item16, out T17 item17, out T18 item18);
        public static void Deconstruct<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14, Tuple<T15, T16, T17>>> value, out T1 item1, out T2 item2, out T3 item3, out T4 item4, out T5 item5, out T6 item6, out T7 item7, out T8 item8, out T9 item9, out T10 item10, out T11 item11, out T12 item12, out T13 item13, out T14 item14, out T15 item15, out T16 item16, out T17 item17);
        public static void Deconstruct<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14, Tuple<T15, T16>>> value, out T1 item1, out T2 item2, out T3 item3, out T4 item4, out T5 item5, out T6 item6, out T7 item7, out T8 item8, out T9 item9, out T10 item10, out T11 item11, out T12 item12, out T13 item13, out T14 item14, out T15 item15, out T16 item16);
        public static void Deconstruct<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14, Tuple<T15>>> value, out T1 item1, out T2 item2, out T3 item3, out T4 item4, out T5 item5, out T6 item6, out T7 item7, out T8 item8, out T9 item9, out T10 item10, out T11 item11, out T12 item12, out T13 item13, out T14 item14, out T15 item15);
        public static void Deconstruct<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14>> value, out T1 item1, out T2 item2, out T3 item3, out T4 item4, out T5 item5, out T6 item6, out T7 item7, out T8 item8, out T9 item9, out T10 item10, out T11 item11, out T12 item12, out T13 item13, out T14 item14);
        public static void Deconstruct<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13>> value, out T1 item1, out T2 item2, out T3 item3, out T4 item4, out T5 item5, out T6 item6, out T7 item7, out T8 item8, out T9 item9, out T10 item10, out T11 item11, out T12 item12, out T13 item13);
        public static void Deconstruct<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12>> value, out T1 item1, out T2 item2, out T3 item3, out T4 item4, out T5 item5, out T6 item6, out T7 item7, out T8 item8, out T9 item9, out T10 item10, out T11 item11, out T12 item12);
        public static void Deconstruct<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11>> value, out T1 item1, out T2 item2, out T3 item3, out T4 item4, out T5 item5, out T6 item6, out T7 item7, out T8 item8, out T9 item9, out T10 item10, out T11 item11);
        public static void Deconstruct<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10>> value, out T1 item1, out T2 item2, out T3 item3, out T4 item4, out T5 item5, out T6 item6, out T7 item7, out T8 item8, out T9 item9, out T10 item10);
        public static void Deconstruct<T1, T2, T3, T4, T5, T6, T7, T8, T9>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9>> value, out T1 item1, out T2 item2, out T3 item3, out T4 item4, out T5 item5, out T6 item6, out T7 item7, out T8 item8, out T9 item9);
        public static void Deconstruct<T1, T2, T3, T4, T5, T6, T7, T8>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8>> value, out T1 item1, out T2 item2, out T3 item3, out T4 item4, out T5 item5, out T6 item6, out T7 item7, out T8 item8);
        public static void Deconstruct<T1, T2, T3, T4, T5, T6, T7>(this Tuple<T1, T2, T3, T4, T5, T6, T7> value, out T1 item1, out T2 item2, out T3 item3, out T4 item4, out T5 item5, out T6 item6, out T7 item7);
        public static void Deconstruct<T1, T2, T3, T4, T5, T6>(this Tuple<T1, T2, T3, T4, T5, T6> value, out T1 item1, out T2 item2, out T3 item3, out T4 item4, out T5 item5, out T6 item6);
        public static void Deconstruct<T1, T2, T3, T4, T5>(this Tuple<T1, T2, T3, T4, T5> value, out T1 item1, out T2 item2, out T3 item3, out T4 item4, out T5 item5);
        public static void Deconstruct<T1, T2, T3, T4>(this Tuple<T1, T2, T3, T4> value, out T1 item1, out T2 item2, out T3 item3, out T4 item4);
        public static void Deconstruct<T1, T2, T3>(this Tuple<T1, T2, T3> value, out T1 item1, out T2 item2, out T3 item3);
        public static void Deconstruct<T1, T2>(this Tuple<T1, T2> value, out T1 item1, out T2 item2);
        public static void Deconstruct<T1>(this Tuple<T1> value, out T1 item1);
        public static Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14, Tuple<T15, T16, T17, T18, T19, T20, T21>>> ToTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21>(this ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11, T12, T13, T14, ValueTuple<T15, T16, T17, T18, T19, T20, T21>>> value);
        public static Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14, Tuple<T15, T16, T17, T18, T19, T20>>> ToTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20>(this ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11, T12, T13, T14, ValueTuple<T15, T16, T17, T18, T19, T20>>> value);
        public static Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14, Tuple<T15, T16, T17, T18, T19>>> ToTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19>(this ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11, T12, T13, T14, ValueTuple<T15, T16, T17, T18, T19>>> value);
        public static Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14, Tuple<T15, T16, T17, T18>>> ToTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18>(this ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11, T12, T13, T14, ValueTuple<T15, T16, T17, T18>>> value);
        public static Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14, Tuple<T15, T16, T17>>> ToTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17>(this ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11, T12, T13, T14, ValueTuple<T15, T16, T17>>> value);
        public static Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14, Tuple<T15, T16>>> ToTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>(this ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11, T12, T13, T14, ValueTuple<T15, T16>>> value);
        public static Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14, Tuple<T15>>> ToTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>(this ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11, T12, T13, T14, ValueTuple<T15>>> value);
        public static Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14>> ToTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>(this ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11, T12, T13, T14>> value);
        public static Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13>> ToTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>(this ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11, T12, T13>> value);
        public static Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12>> ToTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>(this ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11, T12>> value);
        public static Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11>> ToTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>(this ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11>> value);
        public static Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10>> ToTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>(this ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10>> value);
        public static Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9>> ToTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9>(this ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9>> value);
        public static Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8>> ToTuple<T1, T2, T3, T4, T5, T6, T7, T8>(this ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8>> value);
        public static Tuple<T1, T2, T3, T4, T5, T6, T7> ToTuple<T1, T2, T3, T4, T5, T6, T7>(this ValueTuple<T1, T2, T3, T4, T5, T6, T7> value);
        public static Tuple<T1, T2, T3, T4, T5, T6> ToTuple<T1, T2, T3, T4, T5, T6>(this ValueTuple<T1, T2, T3, T4, T5, T6> value);
        public static Tuple<T1, T2, T3, T4, T5> ToTuple<T1, T2, T3, T4, T5>(this ValueTuple<T1, T2, T3, T4, T5> value);
        public static Tuple<T1, T2, T3, T4> ToTuple<T1, T2, T3, T4>(this ValueTuple<T1, T2, T3, T4> value);
        public static Tuple<T1, T2, T3> ToTuple<T1, T2, T3>(this ValueTuple<T1, T2, T3> value);
        public static Tuple<T1, T2> ToTuple<T1, T2>(this ValueTuple<T1, T2> value);
        public static Tuple<T1> ToTuple<T1>(this ValueTuple<T1> value);
        public static ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11, T12, T13, T14, ValueTuple<T15, T16, T17, T18, T19, T20, T21>>> ToValueTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14, Tuple<T15, T16, T17, T18, T19, T20, T21>>> value);
        public static ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11, T12, T13, T14, ValueTuple<T15, T16, T17, T18, T19, T20>>> ToValueTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14, Tuple<T15, T16, T17, T18, T19, T20>>> value);
        public static ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11, T12, T13, T14, ValueTuple<T15, T16, T17, T18, T19>>> ToValueTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14, Tuple<T15, T16, T17, T18, T19>>> value);
        public static ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11, T12, T13, T14, ValueTuple<T15, T16, T17, T18>>> ToValueTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14, Tuple<T15, T16, T17, T18>>> value);
        public static ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11, T12, T13, T14, ValueTuple<T15, T16, T17>>> ToValueTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14, Tuple<T15, T16, T17>>> value);
        public static ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11, T12, T13, T14, ValueTuple<T15, T16>>> ToValueTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14, Tuple<T15, T16>>> value);
        public static ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11, T12, T13, T14, ValueTuple<T15>>> ToValueTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14, Tuple<T15>>> value);
        public static ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11, T12, T13, T14>> ToValueTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13, T14>> value);
        public static ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11, T12, T13>> ToValueTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12, T13>> value);
        public static ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11, T12>> ToValueTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11, T12>> value);
        public static ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10, T11>> ToValueTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10, T11>> value);
        public static ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9, T10>> ToValueTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9, T10>> value);
        public static ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8, T9>> ToValueTuple<T1, T2, T3, T4, T5, T6, T7, T8, T9>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8, T9>> value);
        public static ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8>> ToValueTuple<T1, T2, T3, T4, T5, T6, T7, T8>(this Tuple<T1, T2, T3, T4, T5, T6, T7, Tuple<T8>> value);
        public static ValueTuple<T1, T2, T3, T4, T5, T6, T7> ToValueTuple<T1, T2, T3, T4, T5, T6, T7>(this Tuple<T1, T2, T3, T4, T5, T6, T7> value);
        public static ValueTuple<T1, T2, T3, T4, T5, T6> ToValueTuple<T1, T2, T3, T4, T5, T6>(this Tuple<T1, T2, T3, T4, T5, T6> value);
        public static ValueTuple<T1, T2, T3, T4, T5> ToValueTuple<T1, T2, T3, T4, T5>(this Tuple<T1, T2, T3, T4, T5> value);
        public static ValueTuple<T1, T2, T3, T4> ToValueTuple<T1, T2, T3, T4>(this Tuple<T1, T2, T3, T4> value);
        public static ValueTuple<T1, T2, T3> ToValueTuple<T1, T2, T3>(this Tuple<T1, T2, T3> value);
        public static ValueTuple<T1, T2> ToValueTuple<T1, T2>(this Tuple<T1, T2> value);
        public static ValueTuple<T1> ToValueTuple<T1>(this Tuple<T1> value);
    }
    public abstract class Type : MemberInfo, IReflect {
        public static readonly char Delimiter;
        public static readonly object Missing;
        public static readonly MemberFilter FilterAttribute;
        public static readonly MemberFilter FilterName;
        public static readonly MemberFilter FilterNameIgnoreCase;
        public static readonly Type[] EmptyTypes;
        protected Type();
        public abstract Assembly Assembly { get; }
        public abstract string AssemblyQualifiedName { get; }
        public TypeAttributes Attributes { get; }
        public abstract Type BaseType { get; }
        public virtual bool ContainsGenericParameters { get; }
        public virtual MethodBase DeclaringMethod { get; }
        public override Type DeclaringType { get; }
        public static Binder DefaultBinder { get; }
        public abstract string FullName { get; }
        public virtual GenericParameterAttributes GenericParameterAttributes { get; }
        public virtual int GenericParameterPosition { get; }
        public virtual Type[] GenericTypeArguments { get; }
        public abstract Guid GUID { get; }
        public bool HasElementType { get; }
        public bool IsAbstract { get; }
        public bool IsAnsiClass { get; }
        public bool IsArray { get; }
        public bool IsAutoClass { get; }
        public bool IsAutoLayout { get; }
        public bool IsByRef { get; }
        public bool IsClass { get; }
        public bool IsCOMObject { get; }
        public virtual bool IsConstructedGenericType { get; }
        public bool IsContextful { get; }
        public virtual bool IsEnum { get; }
        public bool IsExplicitLayout { get; }
        public virtual bool IsGenericParameter { get; }
        public virtual bool IsGenericType { get; }
        public virtual bool IsGenericTypeDefinition { get; }
        public bool IsImport { get; }
        public bool IsInterface { get; }
        public bool IsLayoutSequential { get; }
        public bool IsMarshalByRef { get; }
        public bool IsNested { get; }
        public bool IsNestedAssembly { get; }
        public bool IsNestedFamANDAssem { get; }
        public bool IsNestedFamily { get; }
        public bool IsNestedFamORAssem { get; }
        public bool IsNestedPrivate { get; }
        public bool IsNestedPublic { get; }
        public bool IsNotPublic { get; }
        public bool IsPointer { get; }
        public bool IsPrimitive { get; }
        public bool IsPublic { get; }
        public bool IsSealed { get; }
        public virtual bool IsSecurityCritical { get; }
        public virtual bool IsSecuritySafeCritical { get; }
        public virtual bool IsSecurityTransparent { get; }
        public virtual bool IsSerializable { get; }
        public bool IsSpecialName { get; }
        public bool IsUnicodeClass { get; }
        public bool IsValueType { get; }
        public bool IsVisible { get; }
        public override MemberTypes MemberType { get; }
        public abstract new Module Module { get; }
        public abstract string Namespace { get; }
        public override Type ReflectedType { get; }
        public virtual StructLayoutAttribute StructLayoutAttribute { get; }
        public virtual RuntimeTypeHandle TypeHandle { get; }
        public ConstructorInfo TypeInitializer { get; }
        public abstract Type UnderlyingSystemType { get; }
        public override bool Equals(object o);
        public virtual bool Equals(Type o);
        public virtual Type[] FindInterfaces(TypeFilter filter, object filterCriteria);
        public virtual MemberInfo[] FindMembers(MemberTypes memberType, BindingFlags bindingAttr, MemberFilter filter, object filterCriteria);
        public virtual int GetArrayRank();
        protected abstract TypeAttributes GetAttributeFlagsImpl();
        public ConstructorInfo GetConstructor(BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
        public ConstructorInfo GetConstructor(BindingFlags bindingAttr, Binder binder, Type[] types, ParameterModifier[] modifiers);
        public ConstructorInfo GetConstructor(Type[] types);
        protected abstract ConstructorInfo GetConstructorImpl(BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
        public ConstructorInfo[] GetConstructors();
        public abstract ConstructorInfo[] GetConstructors(BindingFlags bindingAttr);
        public virtual MemberInfo[] GetDefaultMembers();
        public abstract Type GetElementType();
        public virtual string GetEnumName(object value);
        public virtual string[] GetEnumNames();
        public virtual Type GetEnumUnderlyingType();
        public virtual Array GetEnumValues();
        public EventInfo GetEvent(string name);
        public abstract EventInfo GetEvent(string name, BindingFlags bindingAttr);
        public virtual EventInfo[] GetEvents();
        public abstract EventInfo[] GetEvents(BindingFlags bindingAttr);
        public FieldInfo GetField(string name);
        public abstract FieldInfo GetField(string name, BindingFlags bindingAttr);
        public FieldInfo[] GetFields();
        public abstract FieldInfo[] GetFields(BindingFlags bindingAttr);
        public virtual Type[] GetGenericArguments();
        public virtual Type[] GetGenericParameterConstraints();
        public virtual Type GetGenericTypeDefinition();
        public override int GetHashCode();
        public Type GetInterface(string name);
        public abstract Type GetInterface(string name, bool ignoreCase);
        public virtual InterfaceMapping GetInterfaceMap(Type interfaceType);
        public abstract Type[] GetInterfaces();
        public MemberInfo[] GetMember(string name);
        public virtual MemberInfo[] GetMember(string name, BindingFlags bindingAttr);
        public virtual MemberInfo[] GetMember(string name, MemberTypes type, BindingFlags bindingAttr);
        public MemberInfo[] GetMembers();
        public abstract MemberInfo[] GetMembers(BindingFlags bindingAttr);
        public MethodInfo GetMethod(string name);
        public MethodInfo GetMethod(string name, BindingFlags bindingAttr);
        public MethodInfo GetMethod(string name, BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
        public MethodInfo GetMethod(string name, BindingFlags bindingAttr, Binder binder, Type[] types, ParameterModifier[] modifiers);
        public MethodInfo GetMethod(string name, Type[] types);
        public MethodInfo GetMethod(string name, Type[] types, ParameterModifier[] modifiers);
        protected abstract MethodInfo GetMethodImpl(string name, BindingFlags bindingAttr, Binder binder, CallingConventions callConvention, Type[] types, ParameterModifier[] modifiers);
        public MethodInfo[] GetMethods();
        public abstract MethodInfo[] GetMethods(BindingFlags bindingAttr);
        public Type GetNestedType(string name);
        public abstract Type GetNestedType(string name, BindingFlags bindingAttr);
        public Type[] GetNestedTypes();
        public abstract Type[] GetNestedTypes(BindingFlags bindingAttr);
        public PropertyInfo[] GetProperties();
        public abstract PropertyInfo[] GetProperties(BindingFlags bindingAttr);
        public PropertyInfo GetProperty(string name);
        public PropertyInfo GetProperty(string name, BindingFlags bindingAttr);
        public PropertyInfo GetProperty(string name, BindingFlags bindingAttr, Binder binder, Type returnType, Type[] types, ParameterModifier[] modifiers);
        public PropertyInfo GetProperty(string name, Type returnType);
        public PropertyInfo GetProperty(string name, Type returnType, Type[] types);
        public PropertyInfo GetProperty(string name, Type returnType, Type[] types, ParameterModifier[] modifiers);
        public PropertyInfo GetProperty(string name, Type[] types);
        protected abstract PropertyInfo GetPropertyImpl(string name, BindingFlags bindingAttr, Binder binder, Type returnType, Type[] types, ParameterModifier[] modifiers);
        public new Type GetType();
        public static Type GetType(string typeName);
        public static Type GetType(string typeName, bool throwOnError);
        public static Type GetType(string typeName, bool throwOnError, bool ignoreCase);
        public static Type GetType(string typeName, Func<AssemblyName, Assembly> assemblyResolver, Func<Assembly, string, bool, Type> typeResolver);
        public static Type GetType(string typeName, Func<AssemblyName, Assembly> assemblyResolver, Func<Assembly, string, bool, Type> typeResolver, bool throwOnError);
        public static Type GetType(string typeName, Func<AssemblyName, Assembly> assemblyResolver, Func<Assembly, string, bool, Type> typeResolver, bool throwOnError, bool ignoreCase);
        public static Type[] GetTypeArray(object[] args);
        public static TypeCode GetTypeCode(Type type);
        protected virtual TypeCode GetTypeCodeImpl();
        public static Type GetTypeFromCLSID(Guid clsid);
        public static Type GetTypeFromCLSID(Guid clsid, bool throwOnError);
        public static Type GetTypeFromCLSID(Guid clsid, string server);
        public static Type GetTypeFromCLSID(Guid clsid, string server, bool throwOnError);
        public static Type GetTypeFromHandle(RuntimeTypeHandle handle);
        public static Type GetTypeFromProgID(string progID);
        public static Type GetTypeFromProgID(string progID, bool throwOnError);
        public static Type GetTypeFromProgID(string progID, string server);
        public static Type GetTypeFromProgID(string progID, string server, bool throwOnError);
        public static RuntimeTypeHandle GetTypeHandle(object o);
        protected abstract bool HasElementTypeImpl();
        public object InvokeMember(string name, BindingFlags invokeAttr, Binder binder, object target, object[] args);
        public object InvokeMember(string name, BindingFlags invokeAttr, Binder binder, object target, object[] args, CultureInfo culture);
        public abstract object InvokeMember(string name, BindingFlags invokeAttr, Binder binder, object target, object[] args, ParameterModifier[] modifiers, CultureInfo culture, string[] namedParameters);
        protected abstract bool IsArrayImpl();
        public virtual bool IsAssignableFrom(Type c);
        protected abstract bool IsByRefImpl();
        protected abstract bool IsCOMObjectImpl();
        protected virtual bool IsContextfulImpl();
        public virtual bool IsEnumDefined(object value);
        public virtual bool IsEquivalentTo(Type other);
        public virtual bool IsInstanceOfType(object o);
        protected virtual bool IsMarshalByRefImpl();
        protected abstract bool IsPointerImpl();
        protected abstract bool IsPrimitiveImpl();
        public virtual bool IsSubclassOf(Type c);
        protected virtual bool IsValueTypeImpl();
        public virtual Type MakeArrayType();
        public virtual Type MakeArrayType(int rank);
        public virtual Type MakeByRefType();
        public virtual Type MakeGenericType(params Type[] typeArguments);
        public virtual Type MakePointerType();
        public static bool operator ==(Type left, Type right);
        public static bool operator !=(Type left, Type right);
        public static Type ReflectionOnlyGetType(string typeName, bool throwIfNotFound, bool ignoreCase);
        public override string ToString();
    }
    public class TypeAccessException : TypeLoadException {
        public TypeAccessException();
        protected TypeAccessException(SerializationInfo info, StreamingContext context);
        public TypeAccessException(string message);
        public TypeAccessException(string message, Exception inner);
    }
    public enum TypeCode {
        Boolean = 3,
        Byte = 6,
        Char = 4,
        DateTime = 16,
        DBNull = 2,
        Decimal = 15,
        Double = 14,
        Empty = 0,
        Int16 = 7,
        Int32 = 9,
        Int64 = 11,
        Object = 1,
        SByte = 5,
        Single = 13,
        String = 18,
        UInt16 = 8,
        UInt32 = 10,
        UInt64 = 12,
    }
    public struct TypedReference {
        public override bool Equals(object o);
        public override int GetHashCode();
        public static Type GetTargetType(TypedReference value);
        public static TypedReference MakeTypedReference(object target, FieldInfo[] flds);
        public static void SetTypedReference(TypedReference target, object value);
        public static RuntimeTypeHandle TargetTypeToken(TypedReference value);
        public static object ToObject(TypedReference value);
    }
    public sealed class TypeInitializationException : SystemException {
        public TypeInitializationException(string fullTypeName, Exception innerException);
        public string TypeName { get; }
        public override void GetObjectData(SerializationInfo info, StreamingContext context);
    }
    public class TypeLoadException : SystemException, ISerializable {
        public TypeLoadException();
        protected TypeLoadException(SerializationInfo info, StreamingContext context);
        public TypeLoadException(string message);
        public TypeLoadException(string message, Exception inner);
        public override string Message { get; }
        public string TypeName { get; }
        public override void GetObjectData(SerializationInfo info, StreamingContext context);
    }
    public class TypeUnloadedException : SystemException {
        public TypeUnloadedException();
        protected TypeUnloadedException(SerializationInfo info, StreamingContext context);
        public TypeUnloadedException(string message);
        public TypeUnloadedException(string message, Exception innerException);
    }
    public struct UInt16 : IComparable, IComparable<ushort>, IConvertible, IEquatable<ushort>, IFormattable {
        public const ushort MaxValue = (ushort)65535;
        public const ushort MinValue = (ushort)0;
        public int CompareTo(object value);
        public int CompareTo(UInt16 value);
        public override bool Equals(object obj);
        public bool Equals(UInt16 obj);
        public override int GetHashCode();
        public TypeCode GetTypeCode();
        public static UInt16 Parse(string s);
        public static UInt16 Parse(string s, NumberStyles style);
        public static UInt16 Parse(string s, NumberStyles style, IFormatProvider provider);
        public static UInt16 Parse(string s, IFormatProvider provider);
        bool System.IConvertible.ToBoolean(IFormatProvider provider);
        byte System.IConvertible.ToByte(IFormatProvider provider);
        char System.IConvertible.ToChar(IFormatProvider provider);
        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
        decimal System.IConvertible.ToDecimal(IFormatProvider provider);
        double System.IConvertible.ToDouble(IFormatProvider provider);
        short System.IConvertible.ToInt16(IFormatProvider provider);
        int System.IConvertible.ToInt32(IFormatProvider provider);
        long System.IConvertible.ToInt64(IFormatProvider provider);
        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
        float System.IConvertible.ToSingle(IFormatProvider provider);
        object System.IConvertible.ToType(Type type, IFormatProvider provider);
        UInt16 System.IConvertible.ToUInt16(IFormatProvider provider);
        uint System.IConvertible.ToUInt32(IFormatProvider provider);
        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
        public override string ToString();
        public string ToString(IFormatProvider provider);
        public string ToString(string format);
        public string ToString(string format, IFormatProvider provider);
        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out UInt16 result);
        public static bool TryParse(string s, out UInt16 result);
    }
    public struct UInt32 : IComparable, IComparable<uint>, IConvertible, IEquatable<uint>, IFormattable {
        public const uint MaxValue = (uint)4294967295;
        public const uint MinValue = (uint)0;
        public int CompareTo(object value);
        public int CompareTo(UInt32 value);
        public override bool Equals(object obj);
        public bool Equals(UInt32 obj);
        public override int GetHashCode();
        public TypeCode GetTypeCode();
        public static UInt32 Parse(string s);
        public static UInt32 Parse(string s, NumberStyles style);
        public static UInt32 Parse(string s, NumberStyles style, IFormatProvider provider);
        public static UInt32 Parse(string s, IFormatProvider provider);
        bool System.IConvertible.ToBoolean(IFormatProvider provider);
        byte System.IConvertible.ToByte(IFormatProvider provider);
        char System.IConvertible.ToChar(IFormatProvider provider);
        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
        decimal System.IConvertible.ToDecimal(IFormatProvider provider);
        double System.IConvertible.ToDouble(IFormatProvider provider);
        short System.IConvertible.ToInt16(IFormatProvider provider);
        int System.IConvertible.ToInt32(IFormatProvider provider);
        long System.IConvertible.ToInt64(IFormatProvider provider);
        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
        float System.IConvertible.ToSingle(IFormatProvider provider);
        object System.IConvertible.ToType(Type type, IFormatProvider provider);
        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
        UInt32 System.IConvertible.ToUInt32(IFormatProvider provider);
        ulong System.IConvertible.ToUInt64(IFormatProvider provider);
        public override string ToString();
        public string ToString(IFormatProvider provider);
        public string ToString(string format);
        public string ToString(string format, IFormatProvider provider);
        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out UInt32 result);
        public static bool TryParse(string s, out UInt32 result);
    }
    public struct UInt64 : IComparable, IComparable<ulong>, IConvertible, IEquatable<ulong>, IFormattable {
        public const ulong MaxValue = (ulong)18446744073709551615;
        public const ulong MinValue = (ulong)0;
        public int CompareTo(object value);
        public int CompareTo(UInt64 value);
        public override bool Equals(object obj);
        public bool Equals(UInt64 obj);
        public override int GetHashCode();
        public TypeCode GetTypeCode();
        public static UInt64 Parse(string s);
        public static UInt64 Parse(string s, NumberStyles style);
        public static UInt64 Parse(string s, NumberStyles style, IFormatProvider provider);
        public static UInt64 Parse(string s, IFormatProvider provider);
        bool System.IConvertible.ToBoolean(IFormatProvider provider);
        byte System.IConvertible.ToByte(IFormatProvider provider);
        char System.IConvertible.ToChar(IFormatProvider provider);
        DateTime System.IConvertible.ToDateTime(IFormatProvider provider);
        decimal System.IConvertible.ToDecimal(IFormatProvider provider);
        double System.IConvertible.ToDouble(IFormatProvider provider);
        short System.IConvertible.ToInt16(IFormatProvider provider);
        int System.IConvertible.ToInt32(IFormatProvider provider);
        long System.IConvertible.ToInt64(IFormatProvider provider);
        sbyte System.IConvertible.ToSByte(IFormatProvider provider);
        float System.IConvertible.ToSingle(IFormatProvider provider);
        object System.IConvertible.ToType(Type type, IFormatProvider provider);
        ushort System.IConvertible.ToUInt16(IFormatProvider provider);
        uint System.IConvertible.ToUInt32(IFormatProvider provider);
        UInt64 System.IConvertible.ToUInt64(IFormatProvider provider);
        public override string ToString();
        public string ToString(IFormatProvider provider);
        public string ToString(string format);
        public string ToString(string format, IFormatProvider provider);
        public static bool TryParse(string s, NumberStyles style, IFormatProvider provider, out UInt64 result);
        public static bool TryParse(string s, out UInt64 result);
    }
    public struct UIntPtr : ISerializable {
        public static readonly UIntPtr Zero;
        public UIntPtr(uint value);
        public UIntPtr(ulong value);
        public unsafe UIntPtr(void* value);
        public static int Size { get; }
        public static UIntPtr Add(UIntPtr pointer, int offset);
        public override bool Equals(object obj);
        public override int GetHashCode();
        public static UIntPtr operator +(UIntPtr pointer, int offset);
        public static bool operator ==(UIntPtr value1, UIntPtr value2);
        public static explicit operator UIntPtr (uint value);
        public static explicit operator UIntPtr (ulong value);
        public static explicit operator uint (UIntPtr value);
        public static explicit operator ulong (UIntPtr value);
        public unsafe static explicit operator void* (UIntPtr value);
        public unsafe static explicit operator UIntPtr (void* value);
        public static bool operator !=(UIntPtr value1, UIntPtr value2);
        public static UIntPtr operator -(UIntPtr pointer, int offset);
        public static UIntPtr Subtract(UIntPtr pointer, int offset);
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo info, StreamingContext context);
        public unsafe void* ToPointer();
        public override string ToString();
        public uint ToUInt32();
        public ulong ToUInt64();
    }
    public class UnauthorizedAccessException : SystemException {
        public UnauthorizedAccessException();
        protected UnauthorizedAccessException(SerializationInfo info, StreamingContext context);
        public UnauthorizedAccessException(string message);
        public UnauthorizedAccessException(string message, Exception inner);
    }
    public class UnhandledExceptionEventArgs : EventArgs {
        public UnhandledExceptionEventArgs(object exception, bool isTerminating);
        public object ExceptionObject { get; }
        public bool IsTerminating { get; }
    }
    public delegate void UnhandledExceptionEventHandler(object sender, UnhandledExceptionEventArgs e);
    public class Uri : ISerializable {
        public static readonly string SchemeDelimiter;
        public static readonly string UriSchemeFile;
        public static readonly string UriSchemeFtp;
        public static readonly string UriSchemeGopher;
        public static readonly string UriSchemeHttp;
        public static readonly string UriSchemeHttps;
        public static readonly string UriSchemeMailto;
        public static readonly string UriSchemeNetPipe;
        public static readonly string UriSchemeNetTcp;
        public static readonly string UriSchemeNews;
        public static readonly string UriSchemeNntp;
        protected Uri(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public Uri(string uriString);
        public Uri(string uriString, bool dontEscape);
        public Uri(string uriString, UriKind uriKind);
        public Uri(Uri baseUri, string relativeUri);
        public Uri(Uri baseUri, string relativeUri, bool dontEscape);
        public Uri(Uri baseUri, Uri relativeUri);
        public string AbsolutePath { get; }
        public string AbsoluteUri { get; }
        public string Authority { get; }
        public string DnsSafeHost { get; }
        public string Fragment { get; }
        public string Host { get; }
        public UriHostNameType HostNameType { get; }
        public string IdnHost { get; }
        public bool IsAbsoluteUri { get; }
        public bool IsDefaultPort { get; }
        public bool IsFile { get; }
        public bool IsLoopback { get; }
        public bool IsUnc { get; }
        public string LocalPath { get; }
        public string OriginalString { get; }
        public string PathAndQuery { get; }
        public int Port { get; }
        public string Query { get; }
        public string Scheme { get; }
        public string[] Segments { get; }
        public bool UserEscaped { get; }
        public string UserInfo { get; }
        protected virtual void Canonicalize();
        public static UriHostNameType CheckHostName(string name);
        public static bool CheckSchemeName(string schemeName);
        protected virtual void CheckSecurity();
        public static int Compare(Uri uri1, Uri uri2, UriComponents partsToCompare, UriFormat compareFormat, StringComparison comparisonType);
        public override bool Equals(object comparand);
        protected virtual void Escape();
        public static string EscapeDataString(string stringToEscape);
        protected static string EscapeString(string str);
        public static string EscapeUriString(string stringToEscape);
        public static int FromHex(char digit);
        public string GetComponents(UriComponents components, UriFormat format);
        public override int GetHashCode();
        public string GetLeftPart(UriPartial part);
        protected void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public static string HexEscape(char character);
        public static char HexUnescape(string pattern, ref int index);
        protected virtual bool IsBadFileSystemCharacter(char character);
        public bool IsBaseOf(Uri uri);
        protected static bool IsExcludedCharacter(char character);
        public static bool IsHexDigit(char character);
        public static bool IsHexEncoding(string pattern, int index);
        protected virtual bool IsReservedCharacter(char character);
        public bool IsWellFormedOriginalString();
        public static bool IsWellFormedUriString(string uriString, UriKind uriKind);
        public string MakeRelative(Uri toUri);
        public Uri MakeRelativeUri(Uri uri);
        public static bool operator ==(Uri uri1, Uri uri2);
        public static bool operator !=(Uri uri1, Uri uri2);
        protected virtual void Parse();
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public override string ToString();
        public static bool TryCreate(string uriString, UriKind uriKind, out Uri result);
        public static bool TryCreate(Uri baseUri, string relativeUri, out Uri result);
        public static bool TryCreate(Uri baseUri, Uri relativeUri, out Uri result);
        protected virtual string Unescape(string path);
        public static string UnescapeDataString(string stringToUnescape);
    }
    public class UriBuilder {
        public UriBuilder();
        public UriBuilder(string uri);
        public UriBuilder(string schemeName, string hostName);
        public UriBuilder(string scheme, string host, int portNumber);
        public UriBuilder(string scheme, string host, int port, string pathValue);
        public UriBuilder(string scheme, string host, int port, string path, string extraValue);
        public UriBuilder(Uri uri);
        public string Fragment { get; set; }
        public string Host { get; set; }
        public string Password { get; set; }
        public string Path { get; set; }
        public int Port { get; set; }
        public string Query { get; set; }
        public string Scheme { get; set; }
        public Uri Uri { get; }
        public string UserName { get; set; }
        public override bool Equals(object rparam);
        public override int GetHashCode();
        public override string ToString();
    }
    public enum UriComponents {
        AbsoluteUri = 127,
        Fragment = 64,
        Host = 4,
        HostAndPort = 132,
        HttpRequestUrl = 61,
        KeepDelimiter = 1073741824,
        NormalizedHost = 256,
        Path = 16,
        PathAndQuery = 48,
        Port = 8,
        Query = 32,
        Scheme = 1,
        SchemeAndServer = 13,
        SerializationInfoString = -2147483648,
        StrongAuthority = 134,
        StrongPort = 128,
        UserInfo = 2,
    }
    public enum UriFormat {
        SafeUnescaped = 3,
        Unescaped = 2,
        UriEscaped = 1,
    }
    public class UriFormatException : FormatException, ISerializable {
        public UriFormatException();
        protected UriFormatException(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public UriFormatException(string textString);
        public UriFormatException(string textString, Exception e);
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
    }
    public enum UriHostNameType {
        Basic = 1,
        Dns = 2,
        IPv4 = 3,
        IPv6 = 4,
        Unknown = 0,
    }
    public enum UriKind {
        Absolute = 1,
        Relative = 2,
        RelativeOrAbsolute = 0,
    }
    public abstract class UriParser {
        protected UriParser();
        protected virtual string GetComponents(Uri uri, UriComponents components, UriFormat format);
        protected virtual void InitializeAndValidate(Uri uri, out UriFormatException parsingError);
        protected virtual bool IsBaseOf(Uri baseUri, Uri relativeUri);
        public static bool IsKnownScheme(string schemeName);
        protected virtual bool IsWellFormedOriginalString(Uri uri);
        protected virtual UriParser OnNewUri();
        protected virtual void OnRegister(string schemeName, int defaultPort);
        public static void Register(UriParser uriParser, string schemeName, int defaultPort);
        protected virtual string Resolve(Uri baseUri, Uri relativeUri, out UriFormatException parsingError);
    }
    public enum UriPartial {
        Authority = 1,
        Path = 2,
        Query = 3,
        Scheme = 0,
    }
    public class UriTypeConverter : TypeConverter {
        public UriTypeConverter();
        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
        public override bool IsValid(ITypeDescriptorContext context, object value);
    }
    public struct ValueTuple : IComparable, IComparable<ValueTuple>, IEquatable<ValueTuple>, IStructuralComparable, IStructuralEquatable {
        public int CompareTo(ValueTuple other);
        public static ValueTuple Create();
        public static ValueTuple<T1, T2, T3, T4, T5, T6, T7, ValueTuple<T8>> Create<T1, T2, T3, T4, T5, T6, T7, T8>(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5, T6 item6, T7 item7, T8 item8);
        public static ValueTuple<T1, T2, T3, T4, T5, T6, T7> Create<T1, T2, T3, T4, T5, T6, T7>(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5, T6 item6, T7 item7);
        public static ValueTuple<T1, T2, T3, T4, T5, T6> Create<T1, T2, T3, T4, T5, T6>(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5, T6 item6);
        public static ValueTuple<T1, T2, T3, T4, T5> Create<T1, T2, T3, T4, T5>(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5);
        public static ValueTuple<T1, T2, T3, T4> Create<T1, T2, T3, T4>(T1 item1, T2 item2, T3 item3, T4 item4);
        public static ValueTuple<T1, T2, T3> Create<T1, T2, T3>(T1 item1, T2 item2, T3 item3);
        public static ValueTuple<T1, T2> Create<T1, T2>(T1 item1, T2 item2);
        public static ValueTuple<T1> Create<T1>(T1 item1);
        public override bool Equals(object obj);
        public bool Equals(ValueTuple other);
        public override int GetHashCode();
        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
        int System.IComparable.CompareTo(object other);
        public override string ToString();
    }
    public struct ValueTuple<T1> : IComparable, IComparable<ValueTuple<T1>>, IEquatable<ValueTuple<T1>>, IStructuralComparable, IStructuralEquatable {
        public T1 Item1;
        public ValueTuple(T1 item1);
        public int CompareTo(ValueTuple<T1> other);
        public override bool Equals(object obj);
        public bool Equals(ValueTuple<T1> other);
        public override int GetHashCode();
        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
        int System.IComparable.CompareTo(object other);
        public override string ToString();
    }
    public struct ValueTuple<T1, T2> : IComparable, IComparable<ValueTuple<T1, T2>>, IEquatable<ValueTuple<T1, T2>>, IStructuralComparable, IStructuralEquatable {
        public T1 Item1;
        public T2 Item2;
        public ValueTuple(T1 item1, T2 item2);
        public int CompareTo(ValueTuple<T1, T2> other);
        public override bool Equals(object obj);
        public bool Equals(ValueTuple<T1, T2> other);
        public override int GetHashCode();
        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
        int System.IComparable.CompareTo(object other);
        public override string ToString();
    }
    public struct ValueTuple<T1, T2, T3> : IComparable, IComparable<ValueTuple<T1, T2, T3>>, IEquatable<ValueTuple<T1, T2, T3>>, IStructuralComparable, IStructuralEquatable {
        public T1 Item1;
        public T2 Item2;
        public T3 Item3;
        public ValueTuple(T1 item1, T2 item2, T3 item3);
        public int CompareTo(ValueTuple<T1, T2, T3> other);
        public override bool Equals(object obj);
        public bool Equals(ValueTuple<T1, T2, T3> other);
        public override int GetHashCode();
        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
        int System.IComparable.CompareTo(object other);
        public override string ToString();
    }
    public struct ValueTuple<T1, T2, T3, T4> : IComparable, IComparable<ValueTuple<T1, T2, T3, T4>>, IEquatable<ValueTuple<T1, T2, T3, T4>>, IStructuralComparable, IStructuralEquatable {
        public T1 Item1;
        public T2 Item2;
        public T3 Item3;
        public T4 Item4;
        public ValueTuple(T1 item1, T2 item2, T3 item3, T4 item4);
        public int CompareTo(ValueTuple<T1, T2, T3, T4> other);
        public override bool Equals(object obj);
        public bool Equals(ValueTuple<T1, T2, T3, T4> other);
        public override int GetHashCode();
        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
        int System.IComparable.CompareTo(object other);
        public override string ToString();
    }
    public struct ValueTuple<T1, T2, T3, T4, T5> : IComparable, IComparable<ValueTuple<T1, T2, T3, T4, T5>>, IEquatable<ValueTuple<T1, T2, T3, T4, T5>>, IStructuralComparable, IStructuralEquatable {
        public T1 Item1;
        public T2 Item2;
        public T3 Item3;
        public T4 Item4;
        public T5 Item5;
        public ValueTuple(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5);
        public int CompareTo(ValueTuple<T1, T2, T3, T4, T5> other);
        public override bool Equals(object obj);
        public bool Equals(ValueTuple<T1, T2, T3, T4, T5> other);
        public override int GetHashCode();
        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
        int System.IComparable.CompareTo(object other);
        public override string ToString();
    }
    public struct ValueTuple<T1, T2, T3, T4, T5, T6> : IComparable, IComparable<ValueTuple<T1, T2, T3, T4, T5, T6>>, IEquatable<ValueTuple<T1, T2, T3, T4, T5, T6>>, IStructuralComparable, IStructuralEquatable {
        public T1 Item1;
        public T2 Item2;
        public T3 Item3;
        public T4 Item4;
        public T5 Item5;
        public T6 Item6;
        public ValueTuple(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5, T6 item6);
        public int CompareTo(ValueTuple<T1, T2, T3, T4, T5, T6> other);
        public override bool Equals(object obj);
        public bool Equals(ValueTuple<T1, T2, T3, T4, T5, T6> other);
        public override int GetHashCode();
        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
        int System.IComparable.CompareTo(object other);
        public override string ToString();
    }
    public struct ValueTuple<T1, T2, T3, T4, T5, T6, T7> : IComparable, IComparable<ValueTuple<T1, T2, T3, T4, T5, T6, T7>>, IEquatable<ValueTuple<T1, T2, T3, T4, T5, T6, T7>>, IStructuralComparable, IStructuralEquatable {
        public T1 Item1;
        public T2 Item2;
        public T3 Item3;
        public T4 Item4;
        public T5 Item5;
        public T6 Item6;
        public T7 Item7;
        public ValueTuple(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5, T6 item6, T7 item7);
        public int CompareTo(ValueTuple<T1, T2, T3, T4, T5, T6, T7> other);
        public override bool Equals(object obj);
        public bool Equals(ValueTuple<T1, T2, T3, T4, T5, T6, T7> other);
        public override int GetHashCode();
        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
        int System.IComparable.CompareTo(object other);
        public override string ToString();
    }
    public struct ValueTuple<T1, T2, T3, T4, T5, T6, T7, TRest> : IComparable, IComparable<ValueTuple<T1, T2, T3, T4, T5, T6, T7, TRest>>, IEquatable<ValueTuple<T1, T2, T3, T4, T5, T6, T7, TRest>>, IStructuralComparable, IStructuralEquatable where TRest : struct {
        public T1 Item1;
        public T2 Item2;
        public T3 Item3;
        public T4 Item4;
        public T5 Item5;
        public T6 Item6;
        public T7 Item7;
        public TRest Rest;
        public ValueTuple(T1 item1, T2 item2, T3 item3, T4 item4, T5 item5, T6 item6, T7 item7, TRest rest);
        public int CompareTo(ValueTuple<T1, T2, T3, T4, T5, T6, T7, TRest> other);
        public override bool Equals(object obj);
        public bool Equals(ValueTuple<T1, T2, T3, T4, T5, T6, T7, TRest> other);
        public override int GetHashCode();
        int System.Collections.IStructuralComparable.CompareTo(object other, IComparer comparer);
        bool System.Collections.IStructuralEquatable.Equals(object other, IEqualityComparer comparer);
        int System.Collections.IStructuralEquatable.GetHashCode(IEqualityComparer comparer);
        int System.IComparable.CompareTo(object other);
        public override string ToString();
    }
    public abstract class ValueType {
        protected ValueType();
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override string ToString();
    }
    public sealed class Version : ICloneable, IComparable, IComparable<Version>, IEquatable<Version> {
        public Version();
        public Version(int major, int minor);
        public Version(int major, int minor, int build);
        public Version(int major, int minor, int build, int revision);
        public Version(string version);
        public int Build { get; }
        public int Major { get; }
        public short MajorRevision { get; }
        public int Minor { get; }
        public short MinorRevision { get; }
        public int Revision { get; }
        public object Clone();
        public int CompareTo(object version);
        public int CompareTo(Version value);
        public override bool Equals(object obj);
        public bool Equals(Version obj);
        public override int GetHashCode();
        public static bool operator ==(Version v1, Version v2);
        public static bool operator >(Version v1, Version v2);
        public static bool operator >=(Version v1, Version v2);
        public static bool operator !=(Version v1, Version v2);
        public static bool operator <(Version v1, Version v2);
        public static bool operator <=(Version v1, Version v2);
        public static Version Parse(string input);
        public override string ToString();
        public string ToString(int fieldCount);
        public static bool TryParse(string input, out Version result);
    }
    public struct Void {
    }
    public class WeakReference : ISerializable {
        public WeakReference(object target);
        public WeakReference(object target, bool trackResurrection);
        protected WeakReference(SerializationInfo info, StreamingContext context);
        public virtual bool IsAlive { get; }
        public virtual object Target { get; set; }
        public virtual bool TrackResurrection { get; }
        ~WeakReference();
        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
    }
    public sealed class WeakReference<T> : ISerializable where T : class {
        public WeakReference(T target);
        public WeakReference(T target, bool trackResurrection);
        public void GetObjectData(SerializationInfo info, StreamingContext context);
        public void SetTarget(T target);
        public bool TryGetTarget(out T target);
    }
}
namespace System.CodeDom.Compiler {
    public sealed class GeneratedCodeAttribute : Attribute {
        public GeneratedCodeAttribute(string tool, string version);
        public string Tool { get; }
        public string Version { get; }
    }
    public class IndentedTextWriter : TextWriter {
        public const string DefaultTabString = "    ";
        public IndentedTextWriter(TextWriter writer);
        public IndentedTextWriter(TextWriter writer, string tabString);
        public override Encoding Encoding { get; }
        public int Indent { get; set; }
        public TextWriter InnerWriter { get; }
        public override string NewLine { get; set; }
        public override void Close();
        public override void Flush();
        protected virtual void OutputTabs();
        public override void Write(bool value);
        public override void Write(char value);
        public override void Write(char[] buffer);
        public override void Write(char[] buffer, int index, int count);
        public override void Write(double value);
        public override void Write(int value);
        public override void Write(long value);
        public override void Write(object value);
        public override void Write(float value);
        public override void Write(string s);
        public override void Write(string format, object arg0);
        public override void Write(string format, object arg0, object arg1);
        public override void Write(string format, params object[] arg);
        public override void WriteLine();
        public override void WriteLine(bool value);
        public override void WriteLine(char value);
        public override void WriteLine(char[] buffer);
        public override void WriteLine(char[] buffer, int index, int count);
        public override void WriteLine(double value);
        public override void WriteLine(int value);
        public override void WriteLine(long value);
        public override void WriteLine(object value);
        public override void WriteLine(float value);
        public override void WriteLine(string s);
        public override void WriteLine(string format, object arg0);
        public override void WriteLine(string format, object arg0, object arg1);
        public override void WriteLine(string format, params object[] arg);
        public override void WriteLine(uint value);
        public void WriteLineNoTabs(string s);
    }
}
namespace System.Collections {
    public class ArrayList : ICloneable, ICollection, IEnumerable, IList {
        public ArrayList();
        public ArrayList(ICollection c);
        public ArrayList(int capacity);
        public virtual int Capacity { get; set; }
        public virtual int Count { get; }
        public virtual bool IsFixedSize { get; }
        public virtual bool IsReadOnly { get; }
        public virtual bool IsSynchronized { get; }
        public virtual object SyncRoot { get; }
        public virtual object this[int index] { get; set; }
        public static ArrayList Adapter(IList list);
        public virtual int Add(object value);
        public virtual void AddRange(ICollection c);
        public virtual int BinarySearch(int index, int count, object value, IComparer comparer);
        public virtual int BinarySearch(object value);
        public virtual int BinarySearch(object value, IComparer comparer);
        public virtual void Clear();
        public virtual object Clone();
        public virtual bool Contains(object item);
        public virtual void CopyTo(Array array);
        public virtual void CopyTo(Array array, int arrayIndex);
        public virtual void CopyTo(int index, Array array, int arrayIndex, int count);
        public static ArrayList FixedSize(ArrayList list);
        public static IList FixedSize(IList list);
        public virtual IEnumerator GetEnumerator();
        public virtual IEnumerator GetEnumerator(int index, int count);
        public virtual ArrayList GetRange(int index, int count);
        public virtual int IndexOf(object value);
        public virtual int IndexOf(object value, int startIndex);
        public virtual int IndexOf(object value, int startIndex, int count);
        public virtual void Insert(int index, object value);
        public virtual void InsertRange(int index, ICollection c);
        public virtual int LastIndexOf(object value);
        public virtual int LastIndexOf(object value, int startIndex);
        public virtual int LastIndexOf(object value, int startIndex, int count);
        public static ArrayList ReadOnly(ArrayList list);
        public static IList ReadOnly(IList list);
        public virtual void Remove(object obj);
        public virtual void RemoveAt(int index);
        public virtual void RemoveRange(int index, int count);
        public static ArrayList Repeat(object value, int count);
        public virtual void Reverse();
        public virtual void Reverse(int index, int count);
        public virtual void SetRange(int index, ICollection c);
        public virtual void Sort();
        public virtual void Sort(IComparer comparer);
        public virtual void Sort(int index, int count, IComparer comparer);
        public static ArrayList Synchronized(ArrayList list);
        public static IList Synchronized(IList list);
        public virtual object[] ToArray();
        public virtual Array ToArray(Type type);
        public virtual void TrimToSize();
    }
    public sealed class BitArray : ICloneable, ICollection, IEnumerable {
        public BitArray(bool[] values);
        public BitArray(byte[] bytes);
        public BitArray(BitArray bits);
        public BitArray(int length);
        public BitArray(int length, bool defaultValue);
        public BitArray(int[] values);
        public int Count { get; }
        public bool IsReadOnly { get; }
        public bool IsSynchronized { get; }
        public int Length { get; set; }
        public object SyncRoot { get; }
        public bool this[int index] { get; set; }
        public BitArray And(BitArray value);
        public object Clone();
        public void CopyTo(Array array, int index);
        public bool Get(int index);
        public IEnumerator GetEnumerator();
        public BitArray Not();
        public BitArray Or(BitArray value);
        public void Set(int index, bool value);
        public void SetAll(bool value);
        public BitArray Xor(BitArray value);
    }
    public class CaseInsensitiveComparer : IComparer {
        public CaseInsensitiveComparer();
        public CaseInsensitiveComparer(CultureInfo culture);
        public static CaseInsensitiveComparer Default { get; }
        public static CaseInsensitiveComparer DefaultInvariant { get; }
        public int Compare(object a, object b);
    }
    public class CaseInsensitiveHashCodeProvider : IHashCodeProvider {
        public CaseInsensitiveHashCodeProvider();
        public CaseInsensitiveHashCodeProvider(CultureInfo culture);
        public static CaseInsensitiveHashCodeProvider Default { get; }
        public static CaseInsensitiveHashCodeProvider DefaultInvariant { get; }
        public int GetHashCode(object obj);
    }
    public abstract class CollectionBase : ICollection, IEnumerable, IList {
        protected CollectionBase();
        protected CollectionBase(int capacity);
        public int Capacity { get; set; }
        public int Count { get; }
        protected ArrayList InnerList { get; }
        protected IList List { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        bool System.Collections.IList.IsFixedSize { get; }
        bool System.Collections.IList.IsReadOnly { get; }
        object System.Collections.IList.this[int index] { get; set; }
        public void Clear();
        public IEnumerator GetEnumerator();
        protected virtual void OnClear();
        protected virtual void OnClearComplete();
        protected virtual void OnInsert(int index, object value);
        protected virtual void OnInsertComplete(int index, object value);
        protected virtual void OnRemove(int index, object value);
        protected virtual void OnRemoveComplete(int index, object value);
        protected virtual void OnSet(int index, object oldValue, object newValue);
        protected virtual void OnSetComplete(int index, object oldValue, object newValue);
        protected virtual void OnValidate(object value);
        public void RemoveAt(int index);
        void System.Collections.ICollection.CopyTo(Array array, int index);
        int System.Collections.IList.Add(object value);
        bool System.Collections.IList.Contains(object value);
        int System.Collections.IList.IndexOf(object value);
        void System.Collections.IList.Insert(int index, object value);
        void System.Collections.IList.Remove(object value);
    }
    public sealed class Comparer : IComparer, ISerializable {
        public static readonly Comparer Default;
        public static readonly Comparer DefaultInvariant;
        public Comparer(CultureInfo culture);
        public int Compare(object a, object b);
        public void GetObjectData(SerializationInfo info, StreamingContext context);
    }
    public abstract class DictionaryBase : ICollection, IDictionary, IEnumerable {
        protected DictionaryBase();
        public int Count { get; }
        protected IDictionary Dictionary { get; }
        protected Hashtable InnerHashtable { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        bool System.Collections.IDictionary.IsFixedSize { get; }
        bool System.Collections.IDictionary.IsReadOnly { get; }
        object System.Collections.IDictionary.this[object key] { get; set; }
        ICollection System.Collections.IDictionary.Keys { get; }
        ICollection System.Collections.IDictionary.Values { get; }
        public void Clear();
        public void CopyTo(Array array, int index);
        public IDictionaryEnumerator GetEnumerator();
        protected virtual void OnClear();
        protected virtual void OnClearComplete();
        protected virtual object OnGet(object key, object currentValue);
        protected virtual void OnInsert(object key, object value);
        protected virtual void OnInsertComplete(object key, object value);
        protected virtual void OnRemove(object key, object value);
        protected virtual void OnRemoveComplete(object key, object value);
        protected virtual void OnSet(object key, object oldValue, object newValue);
        protected virtual void OnSetComplete(object key, object oldValue, object newValue);
        protected virtual void OnValidate(object key, object value);
        void System.Collections.IDictionary.Add(object key, object value);
        bool System.Collections.IDictionary.Contains(object key);
        void System.Collections.IDictionary.Remove(object key);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
    }
    public struct DictionaryEntry {
        public DictionaryEntry(object key, object value);
        public object Key { get; set; }
        public object Value { get; set; }
    }
    public class Hashtable : ICloneable, ICollection, IDeserializationCallback, IDictionary, IEnumerable, ISerializable {
        public Hashtable();
        public Hashtable(IDictionary d);
        public Hashtable(IDictionary d, IEqualityComparer equalityComparer);
        public Hashtable(IDictionary d, IHashCodeProvider hcp, IComparer comparer);
        public Hashtable(IDictionary d, float loadFactor);
        public Hashtable(IDictionary d, float loadFactor, IEqualityComparer equalityComparer);
        public Hashtable(IDictionary d, float loadFactor, IHashCodeProvider hcp, IComparer comparer);
        public Hashtable(IEqualityComparer equalityComparer);
        public Hashtable(IHashCodeProvider hcp, IComparer comparer);
        public Hashtable(int capacity);
        public Hashtable(int capacity, IEqualityComparer equalityComparer);
        public Hashtable(int capacity, IHashCodeProvider hcp, IComparer comparer);
        public Hashtable(int capacity, float loadFactor);
        public Hashtable(int capacity, float loadFactor, IEqualityComparer equalityComparer);
        public Hashtable(int capacity, float loadFactor, IHashCodeProvider hcp, IComparer comparer);
        protected Hashtable(SerializationInfo info, StreamingContext context);
        protected IComparer comparer { get; set; }
        public virtual int Count { get; }
        protected IEqualityComparer EqualityComparer { get; }
        protected IHashCodeProvider hcp { get; set; }
        public virtual bool IsFixedSize { get; }
        public virtual bool IsReadOnly { get; }
        public virtual bool IsSynchronized { get; }
        public virtual ICollection Keys { get; }
        public virtual object SyncRoot { get; }
        public virtual object this[object key] { get; set; }
        public virtual ICollection Values { get; }
        public virtual void Add(object key, object value);
        public virtual void Clear();
        public virtual object Clone();
        public virtual bool Contains(object key);
        public virtual bool ContainsKey(object key);
        public virtual bool ContainsValue(object value);
        public virtual void CopyTo(Array array, int arrayIndex);
        public virtual IDictionaryEnumerator GetEnumerator();
        protected virtual int GetHash(object key);
        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
        protected virtual bool KeyEquals(object item, object key);
        public virtual void OnDeserialization(object sender);
        public virtual void Remove(object key);
        public static Hashtable Synchronized(Hashtable table);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
    }
    public interface ICollection : IEnumerable {
        int Count { get; }
        bool IsSynchronized { get; }
        object SyncRoot { get; }
        void CopyTo(Array array, int index);
    }
    public interface IComparer {
        int Compare(object x, object y);
    }
    public interface IDictionary : ICollection, IEnumerable {
        bool IsFixedSize { get; }
        bool IsReadOnly { get; }
        ICollection Keys { get; }
        object this[object key] { get; set; }
        ICollection Values { get; }
        void Add(object key, object value);
        void Clear();
        bool Contains(object key);
        new IDictionaryEnumerator GetEnumerator();
        void Remove(object key);
    }
    public interface IDictionaryEnumerator : IEnumerator {
        DictionaryEntry Entry { get; }
        object Key { get; }
        object Value { get; }
    }
    public interface IEnumerable {
        IEnumerator GetEnumerator();
    }
    public interface IEnumerator {
        object Current { get; }
        bool MoveNext();
        void Reset();
    }
    public interface IEqualityComparer {
        bool Equals(object x, object y);
        int GetHashCode(object obj);
    }
    public interface IHashCodeProvider {
        int GetHashCode(object obj);
    }
    public interface IList : ICollection, IEnumerable {
        bool IsFixedSize { get; }
        bool IsReadOnly { get; }
        object this[int index] { get; set; }
        int Add(object value);
        void Clear();
        bool Contains(object value);
        int IndexOf(object value);
        void Insert(int index, object value);
        void Remove(object value);
        void RemoveAt(int index);
    }
    public interface IStructuralComparable {
        int CompareTo(object other, IComparer comparer);
    }
    public interface IStructuralEquatable {
        bool Equals(object other, IEqualityComparer comparer);
        int GetHashCode(IEqualityComparer comparer);
    }
    public class Queue : ICloneable, ICollection, IEnumerable {
        public Queue();
        public Queue(ICollection col);
        public Queue(int capacity);
        public Queue(int capacity, float growFactor);
        public virtual int Count { get; }
        public virtual bool IsSynchronized { get; }
        public virtual object SyncRoot { get; }
        public virtual void Clear();
        public virtual object Clone();
        public virtual bool Contains(object obj);
        public virtual void CopyTo(Array array, int index);
        public virtual object Dequeue();
        public virtual void Enqueue(object obj);
        public virtual IEnumerator GetEnumerator();
        public virtual object Peek();
        public static Queue Synchronized(Queue queue);
        public virtual object[] ToArray();
        public virtual void TrimToSize();
    }
    public abstract class ReadOnlyCollectionBase : ICollection, IEnumerable {
        protected ReadOnlyCollectionBase();
        public virtual int Count { get; }
        protected ArrayList InnerList { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        public virtual IEnumerator GetEnumerator();
        void System.Collections.ICollection.CopyTo(Array array, int index);
    }
    public class SortedList : ICloneable, ICollection, IDictionary, IEnumerable {
        public SortedList();
        public SortedList(IComparer comparer);
        public SortedList(IComparer comparer, int capacity);
        public SortedList(IDictionary d);
        public SortedList(IDictionary d, IComparer comparer);
        public SortedList(int initialCapacity);
        public virtual int Capacity { get; set; }
        public virtual int Count { get; }
        public virtual bool IsFixedSize { get; }
        public virtual bool IsReadOnly { get; }
        public virtual bool IsSynchronized { get; }
        public virtual ICollection Keys { get; }
        public virtual object SyncRoot { get; }
        public virtual object this[object key] { get; set; }
        public virtual ICollection Values { get; }
        public virtual void Add(object key, object value);
        public virtual void Clear();
        public virtual object Clone();
        public virtual bool Contains(object key);
        public virtual bool ContainsKey(object key);
        public virtual bool ContainsValue(object value);
        public virtual void CopyTo(Array array, int arrayIndex);
        public virtual object GetByIndex(int index);
        public virtual IDictionaryEnumerator GetEnumerator();
        public virtual object GetKey(int index);
        public virtual IList GetKeyList();
        public virtual IList GetValueList();
        public virtual int IndexOfKey(object key);
        public virtual int IndexOfValue(object value);
        public virtual void Remove(object key);
        public virtual void RemoveAt(int index);
        public virtual void SetByIndex(int index, object value);
        public static SortedList Synchronized(SortedList list);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        public virtual void TrimToSize();
    }
    public class Stack : ICloneable, ICollection, IEnumerable {
        public Stack();
        public Stack(ICollection col);
        public Stack(int initialCapacity);
        public virtual int Count { get; }
        public virtual bool IsSynchronized { get; }
        public virtual object SyncRoot { get; }
        public virtual void Clear();
        public virtual object Clone();
        public virtual bool Contains(object obj);
        public virtual void CopyTo(Array array, int index);
        public virtual IEnumerator GetEnumerator();
        public virtual object Peek();
        public virtual object Pop();
        public virtual void Push(object obj);
        public static Stack Synchronized(Stack stack);
        public virtual object[] ToArray();
    }
    public static class StructuralComparisons {
        public static IComparer StructuralComparer { get; }
        public static IEqualityComparer StructuralEqualityComparer { get; }
    }
}
namespace System.Collections.Concurrent {
    public class BlockingCollection<T> : ICollection, IDisposable, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T> {
        public BlockingCollection();
        public BlockingCollection(IProducerConsumerCollection<T> collection);
        public BlockingCollection(IProducerConsumerCollection<T> collection, int boundedCapacity);
        public BlockingCollection(int boundedCapacity);
        public int BoundedCapacity { get; }
        public int Count { get; }
        public bool IsAddingCompleted { get; }
        public bool IsCompleted { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        public void Add(T item);
        public void Add(T item, CancellationToken cancellationToken);
        public static int AddToAny(BlockingCollection<T>[] collections, T item);
        public static int AddToAny(BlockingCollection<T>[] collections, T item, CancellationToken cancellationToken);
        public void CompleteAdding();
        public void CopyTo(T[] array, int index);
        public void Dispose();
        protected virtual void Dispose(bool disposing);
        public IEnumerable<T> GetConsumingEnumerable();
        public IEnumerable<T> GetConsumingEnumerable(CancellationToken cancellationToken);
        IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
        void System.Collections.ICollection.CopyTo(Array array, int index);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        public T Take();
        public T Take(CancellationToken cancellationToken);
        public static int TakeFromAny(BlockingCollection<T>[] collections, out T item);
        public static int TakeFromAny(BlockingCollection<T>[] collections, out T item, CancellationToken cancellationToken);
        public T[] ToArray();
        public bool TryAdd(T item);
        public bool TryAdd(T item, int millisecondsTimeout);
        public bool TryAdd(T item, int millisecondsTimeout, CancellationToken cancellationToken);
        public bool TryAdd(T item, TimeSpan timeout);
        public static int TryAddToAny(BlockingCollection<T>[] collections, T item);
        public static int TryAddToAny(BlockingCollection<T>[] collections, T item, int millisecondsTimeout);
        public static int TryAddToAny(BlockingCollection<T>[] collections, T item, int millisecondsTimeout, CancellationToken cancellationToken);
        public static int TryAddToAny(BlockingCollection<T>[] collections, T item, TimeSpan timeout);
        public bool TryTake(out T item);
        public bool TryTake(out T item, int millisecondsTimeout);
        public bool TryTake(out T item, int millisecondsTimeout, CancellationToken cancellationToken);
        public bool TryTake(out T item, TimeSpan timeout);
        public static int TryTakeFromAny(BlockingCollection<T>[] collections, out T item);
        public static int TryTakeFromAny(BlockingCollection<T>[] collections, out T item, int millisecondsTimeout);
        public static int TryTakeFromAny(BlockingCollection<T>[] collections, out T item, int millisecondsTimeout, CancellationToken cancellationToken);
        public static int TryTakeFromAny(BlockingCollection<T>[] collections, out T item, TimeSpan timeout);
    }
    public class ConcurrentBag<T> : ICollection, IEnumerable, IEnumerable<T>, IProducerConsumerCollection<T>, IReadOnlyCollection<T> {
        public ConcurrentBag();
        public ConcurrentBag(IEnumerable<T> collection);
        public int Count { get; }
        public bool IsEmpty { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        public void Add(T item);
        public void CopyTo(T[] array, int index);
        public IEnumerator<T> GetEnumerator();
        bool System.Collections.Concurrent.IProducerConsumerCollection<T>.TryAdd(T item);
        void System.Collections.ICollection.CopyTo(Array array, int index);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        public T[] ToArray();
        public bool TryPeek(out T result);
        public bool TryTake(out T result);
    }
    public class ConcurrentDictionary<TKey, TValue> : ICollection, ICollection<KeyValuePair<TKey, TValue>>, IDictionary, IDictionary<TKey, TValue>, IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>>, IReadOnlyCollection<KeyValuePair<TKey, TValue>>, IReadOnlyDictionary<TKey, TValue> {
        public ConcurrentDictionary();
        public ConcurrentDictionary(IEnumerable<KeyValuePair<TKey, TValue>> collection);
        public ConcurrentDictionary(IEnumerable<KeyValuePair<TKey, TValue>> collection, IEqualityComparer<TKey> comparer);
        public ConcurrentDictionary(IEqualityComparer<TKey> comparer);
        public ConcurrentDictionary(int concurrencyLevel, IEnumerable<KeyValuePair<TKey, TValue>> collection, IEqualityComparer<TKey> comparer);
        public ConcurrentDictionary(int concurrencyLevel, int capacity);
        public ConcurrentDictionary(int concurrencyLevel, int capacity, IEqualityComparer<TKey> comparer);
        public int Count { get; }
        public bool IsEmpty { get; }
        public ICollection<TKey> Keys { get; }
        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.IsReadOnly { get; }
        IEnumerable<TKey> System.Collections.Generic.IReadOnlyDictionary<TKey,TValue>.Keys { get; }
        IEnumerable<TValue> System.Collections.Generic.IReadOnlyDictionary<TKey,TValue>.Values { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        bool System.Collections.IDictionary.IsFixedSize { get; }
        bool System.Collections.IDictionary.IsReadOnly { get; }
        object System.Collections.IDictionary.this[object key] { get; set; }
        ICollection System.Collections.IDictionary.Keys { get; }
        ICollection System.Collections.IDictionary.Values { get; }
        public TValue this[TKey key] { get; set; }
        public ICollection<TValue> Values { get; }
        public TValue AddOrUpdate(TKey key, Func<TKey, TValue> addValueFactory, Func<TKey, TValue, TValue> updateValueFactory);
        public TValue AddOrUpdate(TKey key, TValue addValue, Func<TKey, TValue, TValue> updateValueFactory);
        public void Clear();
        public bool ContainsKey(TKey key);
        public IEnumerator<KeyValuePair<TKey, TValue>> GetEnumerator();
        public TValue GetOrAdd(TKey key, Func<TKey, TValue> valueFactory);
        public TValue GetOrAdd(TKey key, TValue value);
        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Add(KeyValuePair<TKey, TValue> keyValuePair);
        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Contains(KeyValuePair<TKey, TValue> keyValuePair);
        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.CopyTo(KeyValuePair<TKey, TValue>[] array, int index);
        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Remove(KeyValuePair<TKey, TValue> keyValuePair);
        void System.Collections.Generic.IDictionary<TKey,TValue>.Add(TKey key, TValue value);
        bool System.Collections.Generic.IDictionary<TKey,TValue>.Remove(TKey key);
        void System.Collections.ICollection.CopyTo(Array array, int index);
        void System.Collections.IDictionary.Add(object key, object value);
        bool System.Collections.IDictionary.Contains(object key);
        IDictionaryEnumerator System.Collections.IDictionary.GetEnumerator();
        void System.Collections.IDictionary.Remove(object key);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        public KeyValuePair<TKey, TValue>[] ToArray();
        public bool TryAdd(TKey key, TValue value);
        public bool TryGetValue(TKey key, out TValue value);
        public bool TryRemove(TKey key, out TValue value);
        public bool TryUpdate(TKey key, TValue newValue, TValue comparisonValue);
    }
    public class ConcurrentQueue<T> : ICollection, IEnumerable, IEnumerable<T>, IProducerConsumerCollection<T>, IReadOnlyCollection<T> {
        public ConcurrentQueue();
        public ConcurrentQueue(IEnumerable<T> collection);
        public int Count { get; }
        public bool IsEmpty { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        public void CopyTo(T[] array, int index);
        public void Enqueue(T item);
        public IEnumerator<T> GetEnumerator();
        bool System.Collections.Concurrent.IProducerConsumerCollection<T>.TryAdd(T item);
        bool System.Collections.Concurrent.IProducerConsumerCollection<T>.TryTake(out T item);
        void System.Collections.ICollection.CopyTo(Array array, int index);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        public T[] ToArray();
        public bool TryDequeue(out T result);
        public bool TryPeek(out T result);
    }
    public class ConcurrentStack<T> : ICollection, IEnumerable, IEnumerable<T>, IProducerConsumerCollection<T>, IReadOnlyCollection<T> {
        public ConcurrentStack();
        public ConcurrentStack(IEnumerable<T> collection);
        public int Count { get; }
        public bool IsEmpty { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        public void Clear();
        public void CopyTo(T[] array, int index);
        public IEnumerator<T> GetEnumerator();
        public void Push(T item);
        public void PushRange(T[] items);
        public void PushRange(T[] items, int startIndex, int count);
        bool System.Collections.Concurrent.IProducerConsumerCollection<T>.TryAdd(T item);
        bool System.Collections.Concurrent.IProducerConsumerCollection<T>.TryTake(out T item);
        void System.Collections.ICollection.CopyTo(Array array, int index);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        public T[] ToArray();
        public bool TryPeek(out T result);
        public bool TryPop(out T result);
        public int TryPopRange(T[] items);
        public int TryPopRange(T[] items, int startIndex, int count);
    }
    public enum EnumerablePartitionerOptions {
        NoBuffering = 1,
        None = 0,
    }
    public interface IProducerConsumerCollection<T> : ICollection, IEnumerable, IEnumerable<T> {
        void CopyTo(T[] array, int index);
        T[] ToArray();
        bool TryAdd(T item);
        bool TryTake(out T item);
    }
    public abstract class OrderablePartitioner<TSource> : Partitioner<TSource> {
        protected OrderablePartitioner(bool keysOrderedInEachPartition, bool keysOrderedAcrossPartitions, bool keysNormalized);
        public bool KeysNormalized { get; }
        public bool KeysOrderedAcrossPartitions { get; }
        public bool KeysOrderedInEachPartition { get; }
        public override IEnumerable<TSource> GetDynamicPartitions();
        public virtual IEnumerable<KeyValuePair<long, TSource>> GetOrderableDynamicPartitions();
        public abstract IList<IEnumerator<KeyValuePair<long, TSource>>> GetOrderablePartitions(int partitionCount);
        public override IList<IEnumerator<TSource>> GetPartitions(int partitionCount);
    }
    public static class Partitioner {
        public static OrderablePartitioner<Tuple<int, int>> Create(int fromInclusive, int toExclusive);
        public static OrderablePartitioner<Tuple<int, int>> Create(int fromInclusive, int toExclusive, int rangeSize);
        public static OrderablePartitioner<Tuple<long, long>> Create(long fromInclusive, long toExclusive);
        public static OrderablePartitioner<Tuple<long, long>> Create(long fromInclusive, long toExclusive, long rangeSize);
        public static OrderablePartitioner<TSource> Create<TSource>(IEnumerable<TSource> source);
        public static OrderablePartitioner<TSource> Create<TSource>(IEnumerable<TSource> source, EnumerablePartitionerOptions partitionerOptions);
        public static OrderablePartitioner<TSource> Create<TSource>(IList<TSource> list, bool loadBalance);
        public static OrderablePartitioner<TSource> Create<TSource>(TSource[] array, bool loadBalance);
    }
    public abstract class Partitioner<TSource> {
        protected Partitioner();
        public virtual bool SupportsDynamicPartitions { get; }
        public virtual IEnumerable<TSource> GetDynamicPartitions();
        public abstract IList<IEnumerator<TSource>> GetPartitions(int partitionCount);
    }
}
namespace System.Collections.Generic {
    public abstract class Comparer<T> : IComparer, IComparer<T> {
        protected Comparer();
        public static Comparer<T> Default { get; }
        public abstract int Compare(T x, T y);
        public static Comparer<T> Create(Comparison<T> comparison);
        int System.Collections.IComparer.Compare(object x, object y);
    }
    public class Dictionary<TKey, TValue> : ICollection, ICollection<KeyValuePair<TKey, TValue>>, IDeserializationCallback, IDictionary, IDictionary<TKey, TValue>, IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>>, IReadOnlyCollection<KeyValuePair<TKey, TValue>>, IReadOnlyDictionary<TKey, TValue>, ISerializable {
        public Dictionary();
        public Dictionary(IDictionary<TKey, TValue> dictionary);
        public Dictionary(IDictionary<TKey, TValue> dictionary, IEqualityComparer<TKey> comparer);
        public Dictionary(IEqualityComparer<TKey> comparer);
        public Dictionary(int capacity);
        public Dictionary(int capacity, IEqualityComparer<TKey> comparer);
        protected Dictionary(SerializationInfo info, StreamingContext context);
        public IEqualityComparer<TKey> Comparer { get; }
        public int Count { get; }
        public Dictionary<TKey, TValue>.KeyCollection Keys { get; }
        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.IsReadOnly { get; }
        ICollection<TKey> System.Collections.Generic.IDictionary<TKey,TValue>.Keys { get; }
        ICollection<TValue> System.Collections.Generic.IDictionary<TKey,TValue>.Values { get; }
        IEnumerable<TKey> System.Collections.Generic.IReadOnlyDictionary<TKey,TValue>.Keys { get; }
        IEnumerable<TValue> System.Collections.Generic.IReadOnlyDictionary<TKey,TValue>.Values { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        bool System.Collections.IDictionary.IsFixedSize { get; }
        bool System.Collections.IDictionary.IsReadOnly { get; }
        object System.Collections.IDictionary.this[object key] { get; set; }
        ICollection System.Collections.IDictionary.Keys { get; }
        ICollection System.Collections.IDictionary.Values { get; }
        public TValue this[TKey key] { get; set; }
        public Dictionary<TKey, TValue>.ValueCollection Values { get; }
        public void Add(TKey key, TValue value);
        public void Clear();
        public bool ContainsKey(TKey key);
        public bool ContainsValue(TValue value);
        public Dictionary<TKey, TValue>.Enumerator GetEnumerator();
        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
        public virtual void OnDeserialization(object sender);
        public bool Remove(TKey key);
        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Add(KeyValuePair<TKey, TValue> keyValuePair);
        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Contains(KeyValuePair<TKey, TValue> keyValuePair);
        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.CopyTo(KeyValuePair<TKey, TValue>[] array, int index);
        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Remove(KeyValuePair<TKey, TValue> keyValuePair);
        IEnumerator<KeyValuePair<TKey, TValue>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<TKey,TValue>>.GetEnumerator();
        void System.Collections.ICollection.CopyTo(Array array, int index);
        void System.Collections.IDictionary.Add(object key, object value);
        bool System.Collections.IDictionary.Contains(object key);
        IDictionaryEnumerator System.Collections.IDictionary.GetEnumerator();
        void System.Collections.IDictionary.Remove(object key);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        public bool TryGetValue(TKey key, out TValue value);
        public struct Enumerator : IDictionaryEnumerator, IDisposable, IEnumerator, IEnumerator<KeyValuePair<TKey, TValue>> {
            public KeyValuePair<TKey, TValue> Current { get; }
            DictionaryEntry System.Collections.IDictionaryEnumerator.Entry { get; }
            object System.Collections.IDictionaryEnumerator.Key { get; }
            object System.Collections.IDictionaryEnumerator.Value { get; }
            object System.Collections.IEnumerator.Current { get; }
            public void Dispose();
            public bool MoveNext();
            void System.Collections.IEnumerator.Reset();
        }
        public sealed class KeyCollection : ICollection, ICollection<TKey>, IEnumerable, IEnumerable<TKey>, IReadOnlyCollection<TKey> {
            public KeyCollection(Dictionary<TKey, TValue> dictionary);
            public int Count { get; }
            bool System.Collections.Generic.ICollection<TKey>.IsReadOnly { get; }
            bool System.Collections.ICollection.IsSynchronized { get; }
            object System.Collections.ICollection.SyncRoot { get; }
            public void CopyTo(TKey[] array, int index);
            public Dictionary<TKey, TValue>.KeyCollection.Enumerator GetEnumerator();
            void System.Collections.Generic.ICollection<TKey>.Add(TKey item);
            void System.Collections.Generic.ICollection<TKey>.Clear();
            bool System.Collections.Generic.ICollection<TKey>.Contains(TKey item);
            bool System.Collections.Generic.ICollection<TKey>.Remove(TKey item);
            IEnumerator<TKey> System.Collections.Generic.IEnumerable<TKey>.GetEnumerator();
            void System.Collections.ICollection.CopyTo(Array array, int index);
            IEnumerator System.Collections.IEnumerable.GetEnumerator();
            public struct Enumerator : IDisposable, IEnumerator, IEnumerator<TKey> {
                public TKey Current { get; }
                object System.Collections.IEnumerator.Current { get; }
                public void Dispose();
                public bool MoveNext();
                void System.Collections.IEnumerator.Reset();
            }
        }
        public sealed class ValueCollection : ICollection, ICollection<TValue>, IEnumerable, IEnumerable<TValue>, IReadOnlyCollection<TValue> {
            public ValueCollection(Dictionary<TKey, TValue> dictionary);
            public int Count { get; }
            bool System.Collections.Generic.ICollection<TValue>.IsReadOnly { get; }
            bool System.Collections.ICollection.IsSynchronized { get; }
            object System.Collections.ICollection.SyncRoot { get; }
            public void CopyTo(TValue[] array, int index);
            public Dictionary<TKey, TValue>.ValueCollection.Enumerator GetEnumerator();
            void System.Collections.Generic.ICollection<TValue>.Add(TValue item);
            void System.Collections.Generic.ICollection<TValue>.Clear();
            bool System.Collections.Generic.ICollection<TValue>.Contains(TValue item);
            bool System.Collections.Generic.ICollection<TValue>.Remove(TValue item);
            IEnumerator<TValue> System.Collections.Generic.IEnumerable<TValue>.GetEnumerator();
            void System.Collections.ICollection.CopyTo(Array array, int index);
            IEnumerator System.Collections.IEnumerable.GetEnumerator();
            public struct Enumerator : IDisposable, IEnumerator, IEnumerator<TValue> {
                public TValue Current { get; }
                object System.Collections.IEnumerator.Current { get; }
                public void Dispose();
                public bool MoveNext();
                void System.Collections.IEnumerator.Reset();
            }
        }
    }
    public abstract class EqualityComparer<T> : IEqualityComparer, IEqualityComparer<T> {
        protected EqualityComparer();
        public static EqualityComparer<T> Default { get; }
        public abstract bool Equals(T x, T y);
        public abstract int GetHashCode(T obj);
        bool System.Collections.IEqualityComparer.Equals(object x, object y);
        int System.Collections.IEqualityComparer.GetHashCode(object obj);
    }
    public class HashSet<T> : ICollection<T>, IDeserializationCallback, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>, ISerializable, ISet<T> {
        public HashSet();
        public HashSet(IEnumerable<T> collection);
        public HashSet(IEnumerable<T> collection, IEqualityComparer<T> comparer);
        public HashSet(IEqualityComparer<T> comparer);
        protected HashSet(SerializationInfo info, StreamingContext context);
        public IEqualityComparer<T> Comparer { get; }
        public int Count { get; }
        bool System.Collections.Generic.ICollection<T>.IsReadOnly { get; }
        public bool Add(T item);
        public void Clear();
        public bool Contains(T item);
        public void CopyTo(T[] array);
        public void CopyTo(T[] array, int arrayIndex);
        public void CopyTo(T[] array, int arrayIndex, int count);
        public static IEqualityComparer<HashSet<T>> CreateSetComparer();
        public void ExceptWith(IEnumerable<T> other);
        public HashSet<T>.Enumerator GetEnumerator();
        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
        public void IntersectWith(IEnumerable<T> other);
        public bool IsProperSubsetOf(IEnumerable<T> other);
        public bool IsProperSupersetOf(IEnumerable<T> other);
        public bool IsSubsetOf(IEnumerable<T> other);
        public bool IsSupersetOf(IEnumerable<T> other);
        public virtual void OnDeserialization(object sender);
        public bool Overlaps(IEnumerable<T> other);
        public bool Remove(T item);
        public int RemoveWhere(Predicate<T> match);
        public bool SetEquals(IEnumerable<T> other);
        public void SymmetricExceptWith(IEnumerable<T> other);
        void System.Collections.Generic.ICollection<T>.Add(T item);
        IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        public void TrimExcess();
        public void UnionWith(IEnumerable<T> other);
        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<T> {
            public T Current { get; }
            object System.Collections.IEnumerator.Current { get; }
            public void Dispose();
            public bool MoveNext();
            void System.Collections.IEnumerator.Reset();
        }
    }
    public interface ICollection<T> : IEnumerable, IEnumerable<T> {
        int Count { get; }
        bool IsReadOnly { get; }
        void Add(T item);
        void Clear();
        bool Contains(T item);
        void CopyTo(T[] array, int arrayIndex);
        bool Remove(T item);
    }
    public interface IComparer<in T> {
        int Compare(T x, T y);
    }
    public interface IDictionary<TKey, TValue> : ICollection<KeyValuePair<TKey, TValue>>, IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>> {
        ICollection<TKey> Keys { get; }
        TValue this[TKey key] { get; set; }
        ICollection<TValue> Values { get; }
        void Add(TKey key, TValue value);
        bool ContainsKey(TKey key);
        bool Remove(TKey key);
        bool TryGetValue(TKey key, out TValue value);
    }
    public interface IEnumerable<out T> : IEnumerable {
        new IEnumerator<T> GetEnumerator();
    }
    public interface IEnumerator<out T> : IDisposable, IEnumerator {
        new T Current { get; }
    }
    public interface IEqualityComparer<in T> {
        bool Equals(T x, T y);
        int GetHashCode(T obj);
    }
    public interface IList<T> : ICollection<T>, IEnumerable, IEnumerable<T> {
        T this[int index] { get; set; }
        int IndexOf(T item);
        void Insert(int index, T item);
        void RemoveAt(int index);
    }
    public interface IReadOnlyCollection<out T> : IEnumerable, IEnumerable<T> {
        int Count { get; }
    }
    public interface IReadOnlyDictionary<TKey, TValue> : IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>>, IReadOnlyCollection<KeyValuePair<TKey, TValue>> {
        IEnumerable<TKey> Keys { get; }
        TValue this[TKey key] { get; }
        IEnumerable<TValue> Values { get; }
        bool ContainsKey(TKey key);
        bool TryGetValue(TKey key, out TValue value);
    }
    public interface IReadOnlyList<out T> : IEnumerable, IEnumerable<T>, IReadOnlyCollection<T> {
        T this[int index] { get; }
    }
    public interface ISet<T> : ICollection<T>, IEnumerable, IEnumerable<T> {
        new bool Add(T item);
        void ExceptWith(IEnumerable<T> other);
        void IntersectWith(IEnumerable<T> other);
        bool IsProperSubsetOf(IEnumerable<T> other);
        bool IsProperSupersetOf(IEnumerable<T> other);
        bool IsSubsetOf(IEnumerable<T> other);
        bool IsSupersetOf(IEnumerable<T> other);
        bool Overlaps(IEnumerable<T> other);
        bool SetEquals(IEnumerable<T> other);
        void SymmetricExceptWith(IEnumerable<T> other);
        void UnionWith(IEnumerable<T> other);
    }
    public class KeyNotFoundException : SystemException, ISerializable {
        public KeyNotFoundException();
        protected KeyNotFoundException(SerializationInfo info, StreamingContext context);
        public KeyNotFoundException(string message);
        public KeyNotFoundException(string message, Exception innerException);
    }
    public struct KeyValuePair<TKey, TValue> {
        public KeyValuePair(TKey key, TValue value);
        public TKey Key { get; }
        public TValue Value { get; }
        public override string ToString();
    }
    public class LinkedList<T> : ICollection, ICollection<T>, IDeserializationCallback, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>, ISerializable {
        public LinkedList();
        public LinkedList(IEnumerable<T> collection);
        protected LinkedList(SerializationInfo info, StreamingContext context);
        public int Count { get; }
        public LinkedListNode<T> First { get; }
        public LinkedListNode<T> Last { get; }
        bool System.Collections.Generic.ICollection<T>.IsReadOnly { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        public void AddAfter(LinkedListNode<T> node, LinkedListNode<T> newNode);
        public LinkedListNode<T> AddAfter(LinkedListNode<T> node, T value);
        public void AddBefore(LinkedListNode<T> node, LinkedListNode<T> newNode);
        public LinkedListNode<T> AddBefore(LinkedListNode<T> node, T value);
        public void AddFirst(LinkedListNode<T> node);
        public LinkedListNode<T> AddFirst(T value);
        public void AddLast(LinkedListNode<T> node);
        public LinkedListNode<T> AddLast(T value);
        public void Clear();
        public bool Contains(T value);
        public void CopyTo(T[] array, int index);
        public LinkedListNode<T> Find(T value);
        public LinkedListNode<T> FindLast(T value);
        public LinkedList<T>.Enumerator GetEnumerator();
        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
        public virtual void OnDeserialization(object sender);
        public void Remove(LinkedListNode<T> node);
        public bool Remove(T value);
        public void RemoveFirst();
        public void RemoveLast();
        void System.Collections.Generic.ICollection<T>.Add(T value);
        IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
        void System.Collections.ICollection.CopyTo(Array array, int index);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        public struct Enumerator : IDeserializationCallback, IDisposable, IEnumerator, IEnumerator<T>, ISerializable {
            public T Current { get; }
            object System.Collections.IEnumerator.Current { get; }
            public void Dispose();
            public bool MoveNext();
            void System.Collections.IEnumerator.Reset();
            void System.Runtime.Serialization.IDeserializationCallback.OnDeserialization(object sender);
            void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo info, StreamingContext context);
        }
    }
    public sealed class LinkedListNode<T> {
        public LinkedListNode(T value);
        public LinkedList<T> List { get; }
        public LinkedListNode<T> Next { get; }
        public LinkedListNode<T> Previous { get; }
        public T Value { get; set; }
    }
    public class List<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T> {
        public List();
        public List(IEnumerable<T> collection);
        public List(int capacity);
        public int Capacity { get; set; }
        public int Count { get; }
        bool System.Collections.Generic.ICollection<T>.IsReadOnly { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        bool System.Collections.IList.IsFixedSize { get; }
        bool System.Collections.IList.IsReadOnly { get; }
        object System.Collections.IList.this[int index] { get; set; }
        public T this[int index] { get; set; }
        public void Add(T item);
        public void AddRange(IEnumerable<T> collection);
        public ReadOnlyCollection<T> AsReadOnly();
        public int BinarySearch(int index, int count, T item, IComparer<T> comparer);
        public int BinarySearch(T item);
        public int BinarySearch(T item, IComparer<T> comparer);
        public void Clear();
        public bool Contains(T item);
        public List<TOutput> ConvertAll<TOutput>(Converter<T, TOutput> converter);
        public void CopyTo(int index, T[] array, int arrayIndex, int count);
        public void CopyTo(T[] array);
        public void CopyTo(T[] array, int arrayIndex);
        public bool Exists(Predicate<T> match);
        public T Find(Predicate<T> match);
        public List<T> FindAll(Predicate<T> match);
        public int FindIndex(int startIndex, int count, Predicate<T> match);
        public int FindIndex(int startIndex, Predicate<T> match);
        public int FindIndex(Predicate<T> match);
        public T FindLast(Predicate<T> match);
        public int FindLastIndex(int startIndex, int count, Predicate<T> match);
        public int FindLastIndex(int startIndex, Predicate<T> match);
        public int FindLastIndex(Predicate<T> match);
        public void ForEach(Action<T> action);
        public List<T>.Enumerator GetEnumerator();
        public List<T> GetRange(int index, int count);
        public int IndexOf(T item);
        public int IndexOf(T item, int index);
        public int IndexOf(T item, int index, int count);
        public void Insert(int index, T item);
        public void InsertRange(int index, IEnumerable<T> collection);
        public int LastIndexOf(T item);
        public int LastIndexOf(T item, int index);
        public int LastIndexOf(T item, int index, int count);
        public bool Remove(T item);
        public int RemoveAll(Predicate<T> match);
        public void RemoveAt(int index);
        public void RemoveRange(int index, int count);
        public void Reverse();
        public void Reverse(int index, int count);
        public void Sort();
        public void Sort(IComparer<T> comparer);
        public void Sort(Comparison<T> comparison);
        public void Sort(int index, int count, IComparer<T> comparer);
        IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
        void System.Collections.ICollection.CopyTo(Array array, int arrayIndex);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        int System.Collections.IList.Add(object item);
        bool System.Collections.IList.Contains(object item);
        int System.Collections.IList.IndexOf(object item);
        void System.Collections.IList.Insert(int index, object item);
        void System.Collections.IList.Remove(object item);
        public T[] ToArray();
        public void TrimExcess();
        public bool TrueForAll(Predicate<T> match);
        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<T> {
            public T Current { get; }
            object System.Collections.IEnumerator.Current { get; }
            public void Dispose();
            public bool MoveNext();
            void System.Collections.IEnumerator.Reset();
        }
    }
    public class Queue<T> : ICollection, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T> {
        public Queue();
        public Queue(IEnumerable<T> collection);
        public Queue(int capacity);
        public int Count { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        public void Clear();
        public bool Contains(T item);
        public void CopyTo(T[] array, int arrayIndex);
        public T Dequeue();
        public void Enqueue(T item);
        public Queue<T>.Enumerator GetEnumerator();
        public T Peek();
        IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
        void System.Collections.ICollection.CopyTo(Array array, int index);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        public T[] ToArray();
        public void TrimExcess();
        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<T> {
            public T Current { get; }
            object System.Collections.IEnumerator.Current { get; }
            public void Dispose();
            public bool MoveNext();
            void System.Collections.IEnumerator.Reset();
        }
    }
    public class SortedDictionary<TKey, TValue> : ICollection, ICollection<KeyValuePair<TKey, TValue>>, IDictionary, IDictionary<TKey, TValue>, IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>>, IReadOnlyCollection<KeyValuePair<TKey, TValue>>, IReadOnlyDictionary<TKey, TValue> {
        public SortedDictionary();
        public SortedDictionary(IComparer<TKey> comparer);
        public SortedDictionary(IDictionary<TKey, TValue> dictionary);
        public SortedDictionary(IDictionary<TKey, TValue> dictionary, IComparer<TKey> comparer);
        public IComparer<TKey> Comparer { get; }
        public int Count { get; }
        public SortedDictionary<TKey, TValue>.KeyCollection Keys { get; }
        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.IsReadOnly { get; }
        ICollection<TKey> System.Collections.Generic.IDictionary<TKey,TValue>.Keys { get; }
        ICollection<TValue> System.Collections.Generic.IDictionary<TKey,TValue>.Values { get; }
        IEnumerable<TKey> System.Collections.Generic.IReadOnlyDictionary<TKey,TValue>.Keys { get; }
        IEnumerable<TValue> System.Collections.Generic.IReadOnlyDictionary<TKey,TValue>.Values { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        bool System.Collections.IDictionary.IsFixedSize { get; }
        bool System.Collections.IDictionary.IsReadOnly { get; }
        object System.Collections.IDictionary.this[object key] { get; set; }
        ICollection System.Collections.IDictionary.Keys { get; }
        ICollection System.Collections.IDictionary.Values { get; }
        public TValue this[TKey key] { get; set; }
        public SortedDictionary<TKey, TValue>.ValueCollection Values { get; }
        public void Add(TKey key, TValue value);
        public void Clear();
        public bool ContainsKey(TKey key);
        public bool ContainsValue(TValue value);
        public void CopyTo(KeyValuePair<TKey, TValue>[] array, int index);
        public SortedDictionary<TKey, TValue>.Enumerator GetEnumerator();
        public bool Remove(TKey key);
        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Add(KeyValuePair<TKey, TValue> keyValuePair);
        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Contains(KeyValuePair<TKey, TValue> keyValuePair);
        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Remove(KeyValuePair<TKey, TValue> keyValuePair);
        IEnumerator<KeyValuePair<TKey, TValue>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<TKey,TValue>>.GetEnumerator();
        void System.Collections.ICollection.CopyTo(Array array, int index);
        void System.Collections.IDictionary.Add(object key, object value);
        bool System.Collections.IDictionary.Contains(object key);
        IDictionaryEnumerator System.Collections.IDictionary.GetEnumerator();
        void System.Collections.IDictionary.Remove(object key);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        public bool TryGetValue(TKey key, out TValue value);
        public struct Enumerator : IDictionaryEnumerator, IDisposable, IEnumerator, IEnumerator<KeyValuePair<TKey, TValue>> {
            public KeyValuePair<TKey, TValue> Current { get; }
            DictionaryEntry System.Collections.IDictionaryEnumerator.Entry { get; }
            object System.Collections.IDictionaryEnumerator.Key { get; }
            object System.Collections.IDictionaryEnumerator.Value { get; }
            object System.Collections.IEnumerator.Current { get; }
            public void Dispose();
            public bool MoveNext();
            void System.Collections.IEnumerator.Reset();
        }
        public sealed class KeyCollection : ICollection, ICollection<TKey>, IEnumerable, IEnumerable<TKey>, IReadOnlyCollection<TKey> {
            public KeyCollection(SortedDictionary<TKey, TValue> dictionary);
            public int Count { get; }
            bool System.Collections.Generic.ICollection<TKey>.IsReadOnly { get; }
            bool System.Collections.ICollection.IsSynchronized { get; }
            object System.Collections.ICollection.SyncRoot { get; }
            public void CopyTo(TKey[] array, int index);
            public SortedDictionary<TKey, TValue>.KeyCollection.Enumerator GetEnumerator();
            void System.Collections.Generic.ICollection<TKey>.Add(TKey item);
            void System.Collections.Generic.ICollection<TKey>.Clear();
            bool System.Collections.Generic.ICollection<TKey>.Contains(TKey item);
            bool System.Collections.Generic.ICollection<TKey>.Remove(TKey item);
            IEnumerator<TKey> System.Collections.Generic.IEnumerable<TKey>.GetEnumerator();
            void System.Collections.ICollection.CopyTo(Array array, int index);
            IEnumerator System.Collections.IEnumerable.GetEnumerator();
            public struct Enumerator : IDisposable, IEnumerator, IEnumerator<TKey> {
                public TKey Current { get; }
                object System.Collections.IEnumerator.Current { get; }
                public void Dispose();
                public bool MoveNext();
                void System.Collections.IEnumerator.Reset();
            }
        }
        public sealed class ValueCollection : ICollection, ICollection<TValue>, IEnumerable, IEnumerable<TValue>, IReadOnlyCollection<TValue> {
            public ValueCollection(SortedDictionary<TKey, TValue> dictionary);
            public int Count { get; }
            bool System.Collections.Generic.ICollection<TValue>.IsReadOnly { get; }
            bool System.Collections.ICollection.IsSynchronized { get; }
            object System.Collections.ICollection.SyncRoot { get; }
            public void CopyTo(TValue[] array, int index);
            public SortedDictionary<TKey, TValue>.ValueCollection.Enumerator GetEnumerator();
            void System.Collections.Generic.ICollection<TValue>.Add(TValue item);
            void System.Collections.Generic.ICollection<TValue>.Clear();
            bool System.Collections.Generic.ICollection<TValue>.Contains(TValue item);
            bool System.Collections.Generic.ICollection<TValue>.Remove(TValue item);
            IEnumerator<TValue> System.Collections.Generic.IEnumerable<TValue>.GetEnumerator();
            void System.Collections.ICollection.CopyTo(Array array, int index);
            IEnumerator System.Collections.IEnumerable.GetEnumerator();
            public struct Enumerator : IDisposable, IEnumerator, IEnumerator<TValue> {
                public TValue Current { get; }
                object System.Collections.IEnumerator.Current { get; }
                public void Dispose();
                public bool MoveNext();
                void System.Collections.IEnumerator.Reset();
            }
        }
    }
    public class SortedList<TKey, TValue> : ICollection, ICollection<KeyValuePair<TKey, TValue>>, IDictionary, IDictionary<TKey, TValue>, IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>>, IReadOnlyCollection<KeyValuePair<TKey, TValue>>, IReadOnlyDictionary<TKey, TValue> {
        public SortedList();
        public SortedList(IComparer<TKey> comparer);
        public SortedList(IDictionary<TKey, TValue> dictionary);
        public SortedList(IDictionary<TKey, TValue> dictionary, IComparer<TKey> comparer);
        public SortedList(int capacity);
        public SortedList(int capacity, IComparer<TKey> comparer);
        public int Capacity { get; set; }
        public IComparer<TKey> Comparer { get; }
        public int Count { get; }
        public IList<TKey> Keys { get; }
        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.IsReadOnly { get; }
        ICollection<TKey> System.Collections.Generic.IDictionary<TKey,TValue>.Keys { get; }
        ICollection<TValue> System.Collections.Generic.IDictionary<TKey,TValue>.Values { get; }
        IEnumerable<TKey> System.Collections.Generic.IReadOnlyDictionary<TKey,TValue>.Keys { get; }
        IEnumerable<TValue> System.Collections.Generic.IReadOnlyDictionary<TKey,TValue>.Values { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        bool System.Collections.IDictionary.IsFixedSize { get; }
        bool System.Collections.IDictionary.IsReadOnly { get; }
        object System.Collections.IDictionary.this[object key] { get; set; }
        ICollection System.Collections.IDictionary.Keys { get; }
        ICollection System.Collections.IDictionary.Values { get; }
        public TValue this[TKey key] { get; set; }
        public IList<TValue> Values { get; }
        public void Add(TKey key, TValue value);
        public void Clear();
        public bool ContainsKey(TKey key);
        public bool ContainsValue(TValue value);
        public IEnumerator<KeyValuePair<TKey, TValue>> GetEnumerator();
        public int IndexOfKey(TKey key);
        public int IndexOfValue(TValue value);
        public bool Remove(TKey key);
        public void RemoveAt(int index);
        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Add(KeyValuePair<TKey, TValue> keyValuePair);
        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Contains(KeyValuePair<TKey, TValue> keyValuePair);
        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.CopyTo(KeyValuePair<TKey, TValue>[] array, int arrayIndex);
        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Remove(KeyValuePair<TKey, TValue> keyValuePair);
        IEnumerator<KeyValuePair<TKey, TValue>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<TKey,TValue>>.GetEnumerator();
        void System.Collections.ICollection.CopyTo(Array array, int arrayIndex);
        void System.Collections.IDictionary.Add(object key, object value);
        bool System.Collections.IDictionary.Contains(object key);
        IDictionaryEnumerator System.Collections.IDictionary.GetEnumerator();
        void System.Collections.IDictionary.Remove(object key);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        public void TrimExcess();
        public bool TryGetValue(TKey key, out TValue value);
    }
    public class SortedSet<T> : ICollection, ICollection<T>, IDeserializationCallback, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T>, ISerializable, ISet<T> {
        public SortedSet();
        public SortedSet(IComparer<T> comparer);
        public SortedSet(IEnumerable<T> collection);
        public SortedSet(IEnumerable<T> collection, IComparer<T> comparer);
        protected SortedSet(SerializationInfo info, StreamingContext context);
        public IComparer<T> Comparer { get; }
        public int Count { get; }
        public T Max { get; }
        public T Min { get; }
        bool System.Collections.Generic.ICollection<T>.IsReadOnly { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        public bool Add(T item);
        public virtual void Clear();
        public virtual bool Contains(T item);
        public void CopyTo(T[] array);
        public void CopyTo(T[] array, int index);
        public void CopyTo(T[] array, int index, int count);
        public static IEqualityComparer<SortedSet<T>> CreateSetComparer();
        public static IEqualityComparer<SortedSet<T>> CreateSetComparer(IEqualityComparer<T> memberEqualityComparer);
        public void ExceptWith(IEnumerable<T> other);
        public SortedSet<T>.Enumerator GetEnumerator();
        protected virtual void GetObjectData(SerializationInfo info, StreamingContext context);
        public virtual SortedSet<T> GetViewBetween(T lowerValue, T upperValue);
        public virtual void IntersectWith(IEnumerable<T> other);
        public bool IsProperSubsetOf(IEnumerable<T> other);
        public bool IsProperSupersetOf(IEnumerable<T> other);
        public bool IsSubsetOf(IEnumerable<T> other);
        public bool IsSupersetOf(IEnumerable<T> other);
        protected virtual void OnDeserialization(object sender);
        public bool Overlaps(IEnumerable<T> other);
        public bool Remove(T item);
        public int RemoveWhere(Predicate<T> match);
        public IEnumerable<T> Reverse();
        public bool SetEquals(IEnumerable<T> other);
        public void SymmetricExceptWith(IEnumerable<T> other);
        void System.Collections.Generic.ICollection<T>.Add(T item);
        IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
        void System.Collections.ICollection.CopyTo(Array array, int index);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        void System.Runtime.Serialization.IDeserializationCallback.OnDeserialization(object sender);
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo info, StreamingContext context);
        public void UnionWith(IEnumerable<T> other);
        public struct Enumerator : IDeserializationCallback, IDisposable, IEnumerator, IEnumerator<T>, ISerializable {
            public T Current { get; }
            object System.Collections.IEnumerator.Current { get; }
            public void Dispose();
            public bool MoveNext();
            void System.Collections.IEnumerator.Reset();
            void System.Runtime.Serialization.IDeserializationCallback.OnDeserialization(object sender);
            void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo info, StreamingContext context);
        }
    }
    public class Stack<T> : ICollection, IEnumerable, IEnumerable<T>, IReadOnlyCollection<T> {
        public Stack();
        public Stack(IEnumerable<T> collection);
        public Stack(int capacity);
        public int Count { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        public void Clear();
        public bool Contains(T item);
        public void CopyTo(T[] array, int arrayIndex);
        public Stack<T>.Enumerator GetEnumerator();
        public T Peek();
        public T Pop();
        public void Push(T item);
        IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
        void System.Collections.ICollection.CopyTo(Array array, int arrayIndex);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        public T[] ToArray();
        public void TrimExcess();
        public struct Enumerator : IDisposable, IEnumerator, IEnumerator<T> {
            public T Current { get; }
            object System.Collections.IEnumerator.Current { get; }
            public void Dispose();
            public bool MoveNext();
            void System.Collections.IEnumerator.Reset();
        }
    }
}
namespace System.Collections.ObjectModel {
    public class Collection<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T> {
        public Collection();
        public Collection(IList<T> list);
        public int Count { get; }
        protected IList<T> Items { get; }
        bool System.Collections.Generic.ICollection<T>.IsReadOnly { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        bool System.Collections.IList.IsFixedSize { get; }
        bool System.Collections.IList.IsReadOnly { get; }
        object System.Collections.IList.this[int index] { get; set; }
        public T this[int index] { get; set; }
        public void Add(T item);
        public void Clear();
        protected virtual void ClearItems();
        public bool Contains(T item);
        public void CopyTo(T[] array, int index);
        public IEnumerator<T> GetEnumerator();
        public int IndexOf(T item);
        public void Insert(int index, T item);
        protected virtual void InsertItem(int index, T item);
        public bool Remove(T item);
        public void RemoveAt(int index);
        protected virtual void RemoveItem(int index);
        protected virtual void SetItem(int index, T item);
        void System.Collections.ICollection.CopyTo(Array array, int index);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        int System.Collections.IList.Add(object value);
        bool System.Collections.IList.Contains(object value);
        int System.Collections.IList.IndexOf(object value);
        void System.Collections.IList.Insert(int index, object value);
        void System.Collections.IList.Remove(object value);
    }
    public abstract class KeyedCollection<TKey, TItem> : Collection<TItem> {
        protected KeyedCollection();
        protected KeyedCollection(IEqualityComparer<TKey> comparer);
        protected KeyedCollection(IEqualityComparer<TKey> comparer, int dictionaryCreationThreshold);
        public IEqualityComparer<TKey> Comparer { get; }
        protected IDictionary<TKey, TItem> Dictionary { get; }
        public TItem this[TKey key] { get; }
        protected void ChangeItemKey(TItem item, TKey newKey);
        protected override void ClearItems();
        public bool Contains(TKey key);
        protected abstract TKey GetKeyForItem(TItem item);
        protected override void InsertItem(int index, TItem item);
        public bool Remove(TKey key);
        protected override void RemoveItem(int index);
        protected override void SetItem(int index, TItem item);
    }
    public class ObservableCollection<T> : Collection<T>, INotifyCollectionChanged, INotifyPropertyChanged {
        public ObservableCollection();
        public ObservableCollection(IEnumerable<T> collection);
        public ObservableCollection(List<T> list);
        public virtual event NotifyCollectionChangedEventHandler CollectionChanged;
        protected virtual event PropertyChangedEventHandler PropertyChanged;
        event PropertyChangedEventHandler System.ComponentModel.INotifyPropertyChanged.PropertyChanged;
        protected IDisposable BlockReentrancy();
        protected void CheckReentrancy();
        protected override void ClearItems();
        protected override void InsertItem(int index, T item);
        public void Move(int oldIndex, int newIndex);
        protected virtual void MoveItem(int oldIndex, int newIndex);
        protected virtual void OnCollectionChanged(NotifyCollectionChangedEventArgs e);
        protected virtual void OnPropertyChanged(PropertyChangedEventArgs e);
        protected override void RemoveItem(int index);
        protected override void SetItem(int index, T item);
    }
    public class ReadOnlyCollection<T> : ICollection, ICollection<T>, IEnumerable, IEnumerable<T>, IList, IList<T>, IReadOnlyCollection<T>, IReadOnlyList<T> {
        public ReadOnlyCollection(IList<T> list);
        public int Count { get; }
        protected IList<T> Items { get; }
        bool System.Collections.Generic.ICollection<T>.IsReadOnly { get; }
        T System.Collections.Generic.IList<T>.this[int index] { get; set; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        bool System.Collections.IList.IsFixedSize { get; }
        bool System.Collections.IList.IsReadOnly { get; }
        object System.Collections.IList.this[int index] { get; set; }
        public T this[int index] { get; }
        public bool Contains(T value);
        public void CopyTo(T[] array, int index);
        public IEnumerator<T> GetEnumerator();
        public int IndexOf(T value);
        void System.Collections.Generic.ICollection<T>.Add(T value);
        void System.Collections.Generic.ICollection<T>.Clear();
        bool System.Collections.Generic.ICollection<T>.Remove(T value);
        void System.Collections.Generic.IList<T>.Insert(int index, T value);
        void System.Collections.Generic.IList<T>.RemoveAt(int index);
        void System.Collections.ICollection.CopyTo(Array array, int index);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        int System.Collections.IList.Add(object value);
        void System.Collections.IList.Clear();
        bool System.Collections.IList.Contains(object value);
        int System.Collections.IList.IndexOf(object value);
        void System.Collections.IList.Insert(int index, object value);
        void System.Collections.IList.Remove(object value);
        void System.Collections.IList.RemoveAt(int index);
    }
    public class ReadOnlyDictionary<TKey, TValue> : ICollection, ICollection<KeyValuePair<TKey, TValue>>, IDictionary, IDictionary<TKey, TValue>, IEnumerable, IEnumerable<KeyValuePair<TKey, TValue>>, IReadOnlyCollection<KeyValuePair<TKey, TValue>>, IReadOnlyDictionary<TKey, TValue> {
        public ReadOnlyDictionary(IDictionary<TKey, TValue> dictionary);
        public int Count { get; }
        protected IDictionary<TKey, TValue> Dictionary { get; }
        public ReadOnlyDictionary<TKey, TValue>.KeyCollection Keys { get; }
        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.IsReadOnly { get; }
        TValue System.Collections.Generic.IDictionary<TKey,TValue>.this[TKey key] { get; set; }
        ICollection<TKey> System.Collections.Generic.IDictionary<TKey,TValue>.Keys { get; }
        ICollection<TValue> System.Collections.Generic.IDictionary<TKey,TValue>.Values { get; }
        IEnumerable<TKey> System.Collections.Generic.IReadOnlyDictionary<TKey,TValue>.Keys { get; }
        IEnumerable<TValue> System.Collections.Generic.IReadOnlyDictionary<TKey,TValue>.Values { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        bool System.Collections.IDictionary.IsFixedSize { get; }
        bool System.Collections.IDictionary.IsReadOnly { get; }
        object System.Collections.IDictionary.this[object key] { get; set; }
        ICollection System.Collections.IDictionary.Keys { get; }
        ICollection System.Collections.IDictionary.Values { get; }
        public TValue this[TKey key] { get; }
        public ReadOnlyDictionary<TKey, TValue>.ValueCollection Values { get; }
        public bool ContainsKey(TKey key);
        public IEnumerator<KeyValuePair<TKey, TValue>> GetEnumerator();
        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Add(KeyValuePair<TKey, TValue> item);
        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Clear();
        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Contains(KeyValuePair<TKey, TValue> item);
        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.CopyTo(KeyValuePair<TKey, TValue>[] array, int arrayIndex);
        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<TKey,TValue>>.Remove(KeyValuePair<TKey, TValue> item);
        void System.Collections.Generic.IDictionary<TKey,TValue>.Add(TKey key, TValue value);
        bool System.Collections.Generic.IDictionary<TKey,TValue>.Remove(TKey key);
        void System.Collections.ICollection.CopyTo(Array array, int index);
        void System.Collections.IDictionary.Add(object key, object value);
        void System.Collections.IDictionary.Clear();
        bool System.Collections.IDictionary.Contains(object key);
        IDictionaryEnumerator System.Collections.IDictionary.GetEnumerator();
        void System.Collections.IDictionary.Remove(object key);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        public bool TryGetValue(TKey key, out TValue value);
        public sealed class KeyCollection : ICollection, ICollection<TKey>, IEnumerable, IEnumerable<TKey>, IReadOnlyCollection<TKey> {
            public int Count { get; }
            bool System.Collections.Generic.ICollection<TKey>.IsReadOnly { get; }
            bool System.Collections.ICollection.IsSynchronized { get; }
            object System.Collections.ICollection.SyncRoot { get; }
            public void CopyTo(TKey[] array, int arrayIndex);
            public IEnumerator<TKey> GetEnumerator();
            void System.Collections.Generic.ICollection<TKey>.Add(TKey item);
            void System.Collections.Generic.ICollection<TKey>.Clear();
            bool System.Collections.Generic.ICollection<TKey>.Contains(TKey item);
            bool System.Collections.Generic.ICollection<TKey>.Remove(TKey item);
            void System.Collections.ICollection.CopyTo(Array array, int index);
            IEnumerator System.Collections.IEnumerable.GetEnumerator();
        }
        public sealed class ValueCollection : ICollection, ICollection<TValue>, IEnumerable, IEnumerable<TValue>, IReadOnlyCollection<TValue> {
            public int Count { get; }
            bool System.Collections.Generic.ICollection<TValue>.IsReadOnly { get; }
            bool System.Collections.ICollection.IsSynchronized { get; }
            object System.Collections.ICollection.SyncRoot { get; }
            public void CopyTo(TValue[] array, int arrayIndex);
            public IEnumerator<TValue> GetEnumerator();
            void System.Collections.Generic.ICollection<TValue>.Add(TValue item);
            void System.Collections.Generic.ICollection<TValue>.Clear();
            bool System.Collections.Generic.ICollection<TValue>.Contains(TValue item);
            bool System.Collections.Generic.ICollection<TValue>.Remove(TValue item);
            void System.Collections.ICollection.CopyTo(Array array, int index);
            IEnumerator System.Collections.IEnumerable.GetEnumerator();
        }
    }
    public class ReadOnlyObservableCollection<T> : ReadOnlyCollection<T>, INotifyCollectionChanged, INotifyPropertyChanged {
        public ReadOnlyObservableCollection(ObservableCollection<T> list);
        protected virtual event NotifyCollectionChangedEventHandler CollectionChanged;
        protected virtual event PropertyChangedEventHandler PropertyChanged;
        event NotifyCollectionChangedEventHandler System.Collections.Specialized.INotifyCollectionChanged.CollectionChanged;
        event PropertyChangedEventHandler System.ComponentModel.INotifyPropertyChanged.PropertyChanged;
        protected virtual void OnCollectionChanged(NotifyCollectionChangedEventArgs args);
        protected virtual void OnPropertyChanged(PropertyChangedEventArgs args);
    }
}
namespace System.Collections.Specialized {
    public struct BitVector32 {
        public BitVector32(BitVector32 value);
        public BitVector32(int data);
        public int Data { get; }
        public int this[BitVector32.Section section] { get; set; }
        public bool this[int bit] { get; set; }
        public static int CreateMask();
        public static int CreateMask(int previous);
        public static BitVector32.Section CreateSection(short maxValue);
        public static BitVector32.Section CreateSection(short maxValue, BitVector32.Section previous);
        public override bool Equals(object o);
        public override int GetHashCode();
        public override string ToString();
        public static string ToString(BitVector32 value);
        public struct Section {
            public short Mask { get; }
            public short Offset { get; }
            public bool Equals(BitVector32.Section obj);
            public override bool Equals(object o);
            public override int GetHashCode();
            public static bool operator ==(BitVector32.Section a, BitVector32.Section b);
            public static bool operator !=(BitVector32.Section a, BitVector32.Section b);
            public override string ToString();
            public static string ToString(BitVector32.Section value);
        }
    }
    public class CollectionsUtil {
        public CollectionsUtil();
        public static Hashtable CreateCaseInsensitiveHashtable();
        public static Hashtable CreateCaseInsensitiveHashtable(IDictionary d);
        public static Hashtable CreateCaseInsensitiveHashtable(int capacity);
        public static SortedList CreateCaseInsensitiveSortedList();
    }
    public class HybridDictionary : ICollection, IDictionary, IEnumerable {
        public HybridDictionary();
        public HybridDictionary(bool caseInsensitive);
        public HybridDictionary(int initialSize);
        public HybridDictionary(int initialSize, bool caseInsensitive);
        public int Count { get; }
        public bool IsFixedSize { get; }
        public bool IsReadOnly { get; }
        public bool IsSynchronized { get; }
        public ICollection Keys { get; }
        public object SyncRoot { get; }
        public object this[object key] { get; set; }
        public ICollection Values { get; }
        public void Add(object key, object value);
        public void Clear();
        public bool Contains(object key);
        public void CopyTo(Array array, int index);
        public IDictionaryEnumerator GetEnumerator();
        public void Remove(object key);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
    }
    public interface INotifyCollectionChanged {
        event NotifyCollectionChangedEventHandler CollectionChanged;
    }
    public interface IOrderedDictionary : ICollection, IDictionary, IEnumerable {
        object this[int index] { get; set; }
        new IDictionaryEnumerator GetEnumerator();
        void Insert(int index, object key, object value);
        void RemoveAt(int index);
    }
    public class ListDictionary : ICollection, IDictionary, IEnumerable {
        public ListDictionary();
        public ListDictionary(IComparer comparer);
        public int Count { get; }
        public bool IsFixedSize { get; }
        public bool IsReadOnly { get; }
        public bool IsSynchronized { get; }
        public ICollection Keys { get; }
        public object SyncRoot { get; }
        public object this[object key] { get; set; }
        public ICollection Values { get; }
        public void Add(object key, object value);
        public void Clear();
        public bool Contains(object key);
        public void CopyTo(Array array, int index);
        public IDictionaryEnumerator GetEnumerator();
        public void Remove(object key);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
    }
    public abstract class NameObjectCollectionBase : ICollection, IDeserializationCallback, IEnumerable, ISerializable {
        protected NameObjectCollectionBase();
        protected NameObjectCollectionBase(IEqualityComparer equalityComparer);
        protected NameObjectCollectionBase(IHashCodeProvider hashProvider, IComparer comparer);
        protected NameObjectCollectionBase(int capacity);
        protected NameObjectCollectionBase(int capacity, IEqualityComparer equalityComparer);
        protected NameObjectCollectionBase(int capacity, IHashCodeProvider hashProvider, IComparer comparer);
        protected NameObjectCollectionBase(SerializationInfo info, StreamingContext context);
        public virtual int Count { get; }
        protected bool IsReadOnly { get; set; }
        public virtual NameObjectCollectionBase.KeysCollection Keys { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        protected void BaseAdd(string name, object value);
        protected void BaseClear();
        protected object BaseGet(int index);
        protected object BaseGet(string name);
        protected string[] BaseGetAllKeys();
        protected object[] BaseGetAllValues();
        protected object[] BaseGetAllValues(Type type);
        protected string BaseGetKey(int index);
        protected bool BaseHasKeys();
        protected void BaseRemove(string name);
        protected void BaseRemoveAt(int index);
        protected void BaseSet(int index, object value);
        protected void BaseSet(string name, object value);
        public virtual IEnumerator GetEnumerator();
        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
        public virtual void OnDeserialization(object sender);
        void System.Collections.ICollection.CopyTo(Array array, int index);
        public class KeysCollection : ICollection, IEnumerable {
            public int Count { get; }
            bool System.Collections.ICollection.IsSynchronized { get; }
            object System.Collections.ICollection.SyncRoot { get; }
            public string this[int index] { get; }
            public virtual string Get(int index);
            public IEnumerator GetEnumerator();
            void System.Collections.ICollection.CopyTo(Array array, int index);
        }
    }
    public class NameValueCollection : NameObjectCollectionBase {
        public NameValueCollection();
        public NameValueCollection(IEqualityComparer equalityComparer);
        public NameValueCollection(IHashCodeProvider hashProvider, IComparer comparer);
        public NameValueCollection(NameValueCollection col);
        public NameValueCollection(int capacity);
        public NameValueCollection(int capacity, IEqualityComparer equalityComparer);
        public NameValueCollection(int capacity, IHashCodeProvider hashProvider, IComparer comparer);
        public NameValueCollection(int capacity, NameValueCollection col);
        protected NameValueCollection(SerializationInfo info, StreamingContext context);
        public virtual string[] AllKeys { get; }
        public string this[int index] { get; }
        public string this[string name] { get; set; }
        public void Add(NameValueCollection c);
        public virtual void Add(string name, string value);
        public virtual void Clear();
        public void CopyTo(Array dest, int index);
        public virtual string Get(int index);
        public virtual string Get(string name);
        public virtual string GetKey(int index);
        public virtual string[] GetValues(int index);
        public virtual string[] GetValues(string name);
        public bool HasKeys();
        protected void InvalidateCachedArrays();
        public virtual void Remove(string name);
        public virtual void Set(string name, string value);
    }
    public enum NotifyCollectionChangedAction {
        Add = 0,
        Move = 3,
        Remove = 1,
        Replace = 2,
        Reset = 4,
    }
    public class NotifyCollectionChangedEventArgs : EventArgs {
        public NotifyCollectionChangedEventArgs(NotifyCollectionChangedAction action);
        public NotifyCollectionChangedEventArgs(NotifyCollectionChangedAction action, IList changedItems);
        public NotifyCollectionChangedEventArgs(NotifyCollectionChangedAction action, IList newItems, IList oldItems);
        public NotifyCollectionChangedEventArgs(NotifyCollectionChangedAction action, IList newItems, IList oldItems, int startingIndex);
        public NotifyCollectionChangedEventArgs(NotifyCollectionChangedAction action, IList changedItems, int startingIndex);
        public NotifyCollectionChangedEventArgs(NotifyCollectionChangedAction action, IList changedItems, int index, int oldIndex);
        public NotifyCollectionChangedEventArgs(NotifyCollectionChangedAction action, object changedItem);
        public NotifyCollectionChangedEventArgs(NotifyCollectionChangedAction action, object changedItem, int index);
        public NotifyCollectionChangedEventArgs(NotifyCollectionChangedAction action, object changedItem, int index, int oldIndex);
        public NotifyCollectionChangedEventArgs(NotifyCollectionChangedAction action, object newItem, object oldItem);
        public NotifyCollectionChangedEventArgs(NotifyCollectionChangedAction action, object newItem, object oldItem, int index);
        public NotifyCollectionChangedAction Action { get; }
        public IList NewItems { get; }
        public int NewStartingIndex { get; }
        public IList OldItems { get; }
        public int OldStartingIndex { get; }
    }
    public delegate void NotifyCollectionChangedEventHandler(object sender, NotifyCollectionChangedEventArgs e);
    public class OrderedDictionary : ICollection, IDeserializationCallback, IDictionary, IEnumerable, IOrderedDictionary, ISerializable {
        public OrderedDictionary();
        public OrderedDictionary(IEqualityComparer comparer);
        public OrderedDictionary(int capacity);
        public OrderedDictionary(int capacity, IEqualityComparer comparer);
        protected OrderedDictionary(SerializationInfo info, StreamingContext context);
        public int Count { get; }
        public bool IsReadOnly { get; }
        public ICollection Keys { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        bool System.Collections.IDictionary.IsFixedSize { get; }
        public object this[int index] { get; set; }
        public object this[object key] { get; set; }
        public ICollection Values { get; }
        public void Add(object key, object value);
        public OrderedDictionary AsReadOnly();
        public void Clear();
        public bool Contains(object key);
        public void CopyTo(Array array, int index);
        public virtual IDictionaryEnumerator GetEnumerator();
        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
        public void Insert(int index, object key, object value);
        protected virtual void OnDeserialization(object sender);
        public void Remove(object key);
        public void RemoveAt(int index);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        void System.Runtime.Serialization.IDeserializationCallback.OnDeserialization(object sender);
    }
    public class StringCollection : ICollection, IEnumerable, IList {
        public StringCollection();
        public int Count { get; }
        public bool IsReadOnly { get; }
        public bool IsSynchronized { get; }
        public object SyncRoot { get; }
        bool System.Collections.IList.IsFixedSize { get; }
        bool System.Collections.IList.IsReadOnly { get; }
        object System.Collections.IList.this[int index] { get; set; }
        public string this[int index] { get; set; }
        public int Add(string value);
        public void AddRange(string[] value);
        public void Clear();
        public bool Contains(string value);
        public void CopyTo(string[] array, int index);
        public StringEnumerator GetEnumerator();
        public int IndexOf(string value);
        public void Insert(int index, string value);
        public void Remove(string value);
        public void RemoveAt(int index);
        void System.Collections.ICollection.CopyTo(Array array, int index);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        int System.Collections.IList.Add(object value);
        bool System.Collections.IList.Contains(object value);
        int System.Collections.IList.IndexOf(object value);
        void System.Collections.IList.Insert(int index, object value);
        void System.Collections.IList.Remove(object value);
    }
    public class StringDictionary : IEnumerable {
        public StringDictionary();
        public virtual int Count { get; }
        public virtual bool IsSynchronized { get; }
        public virtual ICollection Keys { get; }
        public virtual object SyncRoot { get; }
        public virtual string this[string key] { get; set; }
        public virtual ICollection Values { get; }
        public virtual void Add(string key, string value);
        public virtual void Clear();
        public virtual bool ContainsKey(string key);
        public virtual bool ContainsValue(string value);
        public virtual void CopyTo(Array array, int index);
        public virtual IEnumerator GetEnumerator();
        public virtual void Remove(string key);
    }
    public class StringEnumerator {
        public string Current { get; }
        public bool MoveNext();
        public void Reset();
    }
}
namespace System.ComponentModel {
    public class AddingNewEventArgs : EventArgs {
        public AddingNewEventArgs();
        public AddingNewEventArgs(object newObject);
        public object NewObject { get; set; }
    }
    public delegate void AddingNewEventHandler(object sender, AddingNewEventArgs e);
    public sealed class AmbientValueAttribute : Attribute {
        public AmbientValueAttribute(bool value);
        public AmbientValueAttribute(byte value);
        public AmbientValueAttribute(char value);
        public AmbientValueAttribute(double value);
        public AmbientValueAttribute(short value);
        public AmbientValueAttribute(int value);
        public AmbientValueAttribute(long value);
        public AmbientValueAttribute(object value);
        public AmbientValueAttribute(float value);
        public AmbientValueAttribute(string value);
        public AmbientValueAttribute(Type type, string value);
        public object Value { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
    }
    public class ArrayConverter : CollectionConverter {
        public ArrayConverter();
        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
        public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value, Attribute[] attributes);
        public override bool GetPropertiesSupported(ITypeDescriptorContext context);
    }
    public class AsyncCompletedEventArgs : EventArgs {
        public AsyncCompletedEventArgs(Exception error, bool cancelled, object userState);
        public bool Cancelled { get; }
        public Exception Error { get; }
        public object UserState { get; }
        protected void RaiseExceptionIfNecessary();
    }
    public delegate void AsyncCompletedEventHandler(object sender, AsyncCompletedEventArgs e);
    public sealed class AsyncOperation {
        public SynchronizationContext SynchronizationContext { get; }
        public object UserSuppliedState { get; }
        public void OperationCompleted();
        public void Post(SendOrPostCallback d, object arg);
        public void PostOperationCompleted(SendOrPostCallback d, object arg);
    }
    public static class AsyncOperationManager {
        public static SynchronizationContext SynchronizationContext { get; set; }
        public static AsyncOperation CreateOperation(object userSuppliedState);
    }
    public class AttributeCollection : ICollection, IEnumerable {
        public static readonly AttributeCollection Empty;
        protected AttributeCollection();
        public AttributeCollection(params Attribute[] attributes);
        protected virtual Attribute[] Attributes { get; }
        public int Count { get; }
        int System.Collections.ICollection.Count { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        public virtual Attribute this[int index] { get; }
        public virtual Attribute this[Type attributeType] { get; }
        public bool Contains(Attribute attribute);
        public bool Contains(Attribute[] attributes);
        public void CopyTo(Array array, int index);
        public static AttributeCollection FromExisting(AttributeCollection existing, params Attribute[] newAttributes);
        protected Attribute GetDefaultAttribute(Type attributeType);
        public IEnumerator GetEnumerator();
        public bool Matches(Attribute attribute);
        public bool Matches(Attribute[] attributes);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
    }
    public class AttributeProviderAttribute : Attribute {
        public AttributeProviderAttribute(string typeName);
        public AttributeProviderAttribute(string typeName, string propertyName);
        public AttributeProviderAttribute(Type type);
        public string PropertyName { get; }
        public string TypeName { get; }
    }
    public class BackgroundWorker : Component {
        public BackgroundWorker();
        public bool CancellationPending { get; }
        public bool IsBusy { get; }
        public bool WorkerReportsProgress { get; set; }
        public bool WorkerSupportsCancellation { get; set; }
        public event DoWorkEventHandler DoWork;
        public event ProgressChangedEventHandler ProgressChanged;
        public event RunWorkerCompletedEventHandler RunWorkerCompleted;
        public void CancelAsync();
        protected virtual void OnDoWork(DoWorkEventArgs e);
        protected virtual void OnProgressChanged(ProgressChangedEventArgs e);
        protected virtual void OnRunWorkerCompleted(RunWorkerCompletedEventArgs e);
        public void ReportProgress(int percentProgress);
        public void ReportProgress(int percentProgress, object userState);
        public void RunWorkerAsync();
        public void RunWorkerAsync(object argument);
    }
    public abstract class BaseNumberConverter : TypeConverter {
        protected BaseNumberConverter();
        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
        public override bool CanConvertTo(ITypeDescriptorContext context, Type t);
        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
    }
    public sealed class BindableAttribute : Attribute {
        public static readonly BindableAttribute Default;
        public static readonly BindableAttribute No;
        public static readonly BindableAttribute Yes;
        public BindableAttribute(bool bindable);
        public BindableAttribute(bool bindable, BindingDirection direction);
        public BindableAttribute(BindableSupport flags);
        public BindableAttribute(BindableSupport flags, BindingDirection direction);
        public bool Bindable { get; }
        public BindingDirection Direction { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public enum BindableSupport {
        Default = 2,
        No = 0,
        Yes = 1,
    }
    public enum BindingDirection {
        OneWay = 0,
        TwoWay = 1,
    }
    public class BindingList<T> : Collection<T>, IBindingList, ICancelAddNew, ICollection, IEnumerable, IList, IRaiseItemChangedEvents {
        public BindingList();
        public BindingList(IList<T> list);
        public bool AllowEdit { get; set; }
        public bool AllowNew { get; set; }
        public bool AllowRemove { get; set; }
        protected virtual bool IsSortedCore { get; }
        public bool RaiseListChangedEvents { get; set; }
        protected virtual ListSortDirection SortDirectionCore { get; }
        protected virtual PropertyDescriptor SortPropertyCore { get; }
        protected virtual bool SupportsChangeNotificationCore { get; }
        protected virtual bool SupportsSearchingCore { get; }
        protected virtual bool SupportsSortingCore { get; }
        bool System.ComponentModel.IBindingList.AllowEdit { get; }
        bool System.ComponentModel.IBindingList.AllowNew { get; }
        bool System.ComponentModel.IBindingList.AllowRemove { get; }
        bool System.ComponentModel.IBindingList.IsSorted { get; }
        ListSortDirection System.ComponentModel.IBindingList.SortDirection { get; }
        PropertyDescriptor System.ComponentModel.IBindingList.SortProperty { get; }
        bool System.ComponentModel.IBindingList.SupportsChangeNotification { get; }
        bool System.ComponentModel.IBindingList.SupportsSearching { get; }
        bool System.ComponentModel.IBindingList.SupportsSorting { get; }
        bool System.ComponentModel.IRaiseItemChangedEvents.RaisesItemChangedEvents { get; }
        public event AddingNewEventHandler AddingNew;
        public event ListChangedEventHandler ListChanged;
        public T AddNew();
        protected virtual object AddNewCore();
        protected virtual void ApplySortCore(PropertyDescriptor prop, ListSortDirection direction);
        public virtual void CancelNew(int itemIndex);
        protected override void ClearItems();
        public virtual void EndNew(int itemIndex);
        protected virtual int FindCore(PropertyDescriptor prop, object key);
        protected override void InsertItem(int index, T item);
        protected virtual void OnAddingNew(AddingNewEventArgs e);
        protected virtual void OnListChanged(ListChangedEventArgs e);
        protected override void RemoveItem(int index);
        protected virtual void RemoveSortCore();
        public void ResetBindings();
        public void ResetItem(int position);
        protected override void SetItem(int index, T item);
        void System.ComponentModel.IBindingList.AddIndex(PropertyDescriptor prop);
        object System.ComponentModel.IBindingList.AddNew();
        void System.ComponentModel.IBindingList.ApplySort(PropertyDescriptor prop, ListSortDirection direction);
        int System.ComponentModel.IBindingList.Find(PropertyDescriptor prop, object key);
        void System.ComponentModel.IBindingList.RemoveIndex(PropertyDescriptor prop);
        void System.ComponentModel.IBindingList.RemoveSort();
    }
    public class BooleanConverter : TypeConverter {
        public BooleanConverter();
        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context);
        public override bool GetStandardValuesSupported(ITypeDescriptorContext context);
    }
    public sealed class BrowsableAttribute : Attribute {
        public static readonly BrowsableAttribute Default;
        public static readonly BrowsableAttribute No;
        public static readonly BrowsableAttribute Yes;
        public BrowsableAttribute(bool browsable);
        public bool Browsable { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public class ByteConverter : BaseNumberConverter {
        public ByteConverter();
    }
    public class CancelEventArgs : EventArgs {
        public CancelEventArgs();
        public CancelEventArgs(bool cancel);
        public bool Cancel { get; set; }
    }
    public delegate void CancelEventHandler(object sender, CancelEventArgs e);
    public class CategoryAttribute : Attribute {
        public CategoryAttribute();
        public CategoryAttribute(string category);
        public static CategoryAttribute Action { get; }
        public static CategoryAttribute Appearance { get; }
        public static CategoryAttribute Asynchronous { get; }
        public static CategoryAttribute Behavior { get; }
        public string Category { get; }
        public static CategoryAttribute Data { get; }
        public static CategoryAttribute Default { get; }
        public static CategoryAttribute Design { get; }
        public static CategoryAttribute DragDrop { get; }
        public static CategoryAttribute Focus { get; }
        public static CategoryAttribute Format { get; }
        public static CategoryAttribute Key { get; }
        public static CategoryAttribute Layout { get; }
        public static CategoryAttribute Mouse { get; }
        public static CategoryAttribute WindowStyle { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        protected virtual string GetLocalizedString(string value);
        public override bool IsDefaultAttribute();
    }
    public class CharConverter : TypeConverter {
        public CharConverter();
        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
    }
    public enum CollectionChangeAction {
        Add = 1,
        Refresh = 3,
        Remove = 2,
    }
    public class CollectionChangeEventArgs : EventArgs {
        public CollectionChangeEventArgs(CollectionChangeAction action, object element);
        public virtual CollectionChangeAction Action { get; }
        public virtual object Element { get; }
    }
    public delegate void CollectionChangeEventHandler(object sender, CollectionChangeEventArgs e);
    public class CollectionConverter : TypeConverter {
        public CollectionConverter();
        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
        public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value, Attribute[] attributes);
        public override bool GetPropertiesSupported(ITypeDescriptorContext context);
    }
    public sealed class ComplexBindingPropertiesAttribute : Attribute {
        public static readonly ComplexBindingPropertiesAttribute Default;
        public ComplexBindingPropertiesAttribute();
        public ComplexBindingPropertiesAttribute(string dataSource);
        public ComplexBindingPropertiesAttribute(string dataSource, string dataMember);
        public string DataMember { get; }
        public string DataSource { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
    }
    public class Component : MarshalByRefObject, IComponent, IDisposable {
        public Component();
        protected virtual bool CanRaiseEvents { get; }
        public IContainer Container { get; }
        protected bool DesignMode { get; }
        protected EventHandlerList Events { get; }
        public virtual ISite Site { get; set; }
        public event EventHandler Disposed;
        public void Dispose();
        protected virtual void Dispose(bool disposing);
        ~Component();
        protected virtual object GetService(Type service);
        public override string ToString();
    }
    public class ComponentCollection : ReadOnlyCollectionBase {
        public ComponentCollection(IComponent[] components);
        public virtual IComponent this[int index] { get; }
        public virtual IComponent this[string name] { get; }
        public void CopyTo(IComponent[] array, int index);
    }
    public class ComponentConverter : ReferenceConverter {
        public ComponentConverter(Type type);
        public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value, Attribute[] attributes);
        public override bool GetPropertiesSupported(ITypeDescriptorContext context);
    }
    public abstract class ComponentEditor {
        protected ComponentEditor();
        public abstract bool EditComponent(ITypeDescriptorContext context, object component);
        public bool EditComponent(object component);
    }
    public class ComponentResourceManager : ResourceManager {
        public ComponentResourceManager();
        public ComponentResourceManager(Type t);
        public void ApplyResources(object value, string objectName);
        public virtual void ApplyResources(object value, string objectName, CultureInfo culture);
    }
    public class Container : IContainer, IDisposable {
        public Container();
        public virtual ComponentCollection Components { get; }
        public virtual void Add(IComponent component);
        public virtual void Add(IComponent component, string name);
        protected virtual ISite CreateSite(IComponent component, string name);
        public void Dispose();
        protected virtual void Dispose(bool disposing);
        ~Container();
        protected virtual object GetService(Type service);
        public virtual void Remove(IComponent component);
        protected void RemoveWithoutUnsiting(IComponent component);
        protected virtual void ValidateName(IComponent component, string name);
    }
    public abstract class ContainerFilterService {
        protected ContainerFilterService();
        public virtual ComponentCollection FilterComponents(ComponentCollection components);
    }
    public class CultureInfoConverter : TypeConverter {
        public CultureInfoConverter();
        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
        protected virtual string GetCultureName(CultureInfo culture);
        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context);
        public override bool GetStandardValuesSupported(ITypeDescriptorContext context);
    }
    public abstract class CustomTypeDescriptor : ICustomTypeDescriptor {
        protected CustomTypeDescriptor();
        protected CustomTypeDescriptor(ICustomTypeDescriptor parent);
        public virtual AttributeCollection GetAttributes();
        public virtual string GetClassName();
        public virtual string GetComponentName();
        public virtual TypeConverter GetConverter();
        public virtual EventDescriptor GetDefaultEvent();
        public virtual PropertyDescriptor GetDefaultProperty();
        public virtual object GetEditor(Type editorBaseType);
        public virtual EventDescriptorCollection GetEvents();
        public virtual EventDescriptorCollection GetEvents(Attribute[] attributes);
        public virtual PropertyDescriptorCollection GetProperties();
        public virtual PropertyDescriptorCollection GetProperties(Attribute[] attributes);
        public virtual object GetPropertyOwner(PropertyDescriptor pd);
    }
    public class DataErrorsChangedEventArgs : EventArgs {
        public DataErrorsChangedEventArgs(string propertyName);
        public virtual string PropertyName { get; }
    }
    public sealed class DataObjectAttribute : Attribute {
        public static readonly DataObjectAttribute DataObject;
        public static readonly DataObjectAttribute Default;
        public static readonly DataObjectAttribute NonDataObject;
        public DataObjectAttribute();
        public DataObjectAttribute(bool isDataObject);
        public bool IsDataObject { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public sealed class DataObjectFieldAttribute : Attribute {
        public DataObjectFieldAttribute(bool primaryKey);
        public DataObjectFieldAttribute(bool primaryKey, bool isIdentity);
        public DataObjectFieldAttribute(bool primaryKey, bool isIdentity, bool isNullable);
        public DataObjectFieldAttribute(bool primaryKey, bool isIdentity, bool isNullable, int length);
        public bool IsIdentity { get; }
        public bool IsNullable { get; }
        public int Length { get; }
        public bool PrimaryKey { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
    }
    public sealed class DataObjectMethodAttribute : Attribute {
        public DataObjectMethodAttribute(DataObjectMethodType methodType);
        public DataObjectMethodAttribute(DataObjectMethodType methodType, bool isDefault);
        public bool IsDefault { get; }
        public DataObjectMethodType MethodType { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override bool Match(object obj);
    }
    public enum DataObjectMethodType {
        Delete = 4,
        Fill = 0,
        Insert = 3,
        Select = 1,
        Update = 2,
    }
    public class DateTimeConverter : TypeConverter {
        public DateTimeConverter();
        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
    }
    public class DateTimeOffsetConverter : TypeConverter {
        public DateTimeOffsetConverter();
        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
    }
    public class DecimalConverter : BaseNumberConverter {
        public DecimalConverter();
        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
    }
    public sealed class DefaultBindingPropertyAttribute : Attribute {
        public static readonly DefaultBindingPropertyAttribute Default;
        public DefaultBindingPropertyAttribute();
        public DefaultBindingPropertyAttribute(string name);
        public string Name { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
    }
    public sealed class DefaultEventAttribute : Attribute {
        public static readonly DefaultEventAttribute Default;
        public DefaultEventAttribute(string name);
        public string Name { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
    }
    public sealed class DefaultPropertyAttribute : Attribute {
        public static readonly DefaultPropertyAttribute Default;
        public DefaultPropertyAttribute(string name);
        public string Name { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
    }
    public class DefaultValueAttribute : Attribute {
        public DefaultValueAttribute(bool value);
        public DefaultValueAttribute(byte value);
        public DefaultValueAttribute(char value);
        public DefaultValueAttribute(double value);
        public DefaultValueAttribute(short value);
        public DefaultValueAttribute(int value);
        public DefaultValueAttribute(long value);
        public DefaultValueAttribute(object value);
        public DefaultValueAttribute(float value);
        public DefaultValueAttribute(string value);
        public DefaultValueAttribute(Type type, string value);
        public virtual object Value { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        protected void SetValue(object value);
    }
    public class DescriptionAttribute : Attribute {
        public static readonly DescriptionAttribute Default;
        public DescriptionAttribute();
        public DescriptionAttribute(string description);
        public virtual string Description { get; }
        protected string DescriptionValue { get; set; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public sealed class DesignerAttribute : Attribute {
        public DesignerAttribute(string designerTypeName);
        public DesignerAttribute(string designerTypeName, string designerBaseTypeName);
        public DesignerAttribute(string designerTypeName, Type designerBaseType);
        public DesignerAttribute(Type designerType);
        public DesignerAttribute(Type designerType, Type designerBaseType);
        public string DesignerBaseTypeName { get; }
        public string DesignerTypeName { get; }
        public override object TypeId { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
    }
    public sealed class DesignerCategoryAttribute : Attribute {
        public static readonly DesignerCategoryAttribute Component;
        public static readonly DesignerCategoryAttribute Default;
        public static readonly DesignerCategoryAttribute Form;
        public static readonly DesignerCategoryAttribute Generic;
        public DesignerCategoryAttribute();
        public DesignerCategoryAttribute(string category);
        public string Category { get; }
        public override object TypeId { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public enum DesignerSerializationVisibility {
        Content = 2,
        Hidden = 0,
        Visible = 1,
    }
    public sealed class DesignerSerializationVisibilityAttribute : Attribute {
        public static readonly DesignerSerializationVisibilityAttribute Content;
        public static readonly DesignerSerializationVisibilityAttribute Default;
        public static readonly DesignerSerializationVisibilityAttribute Hidden;
        public static readonly DesignerSerializationVisibilityAttribute Visible;
        public DesignerSerializationVisibilityAttribute(DesignerSerializationVisibility visibility);
        public DesignerSerializationVisibility Visibility { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public sealed class DesignOnlyAttribute : Attribute {
        public static readonly DesignOnlyAttribute Default;
        public static readonly DesignOnlyAttribute No;
        public static readonly DesignOnlyAttribute Yes;
        public DesignOnlyAttribute(bool isDesignOnly);
        public bool IsDesignOnly { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public sealed class DesignTimeVisibleAttribute : Attribute {
        public static readonly DesignTimeVisibleAttribute Default;
        public static readonly DesignTimeVisibleAttribute No;
        public static readonly DesignTimeVisibleAttribute Yes;
        public DesignTimeVisibleAttribute();
        public DesignTimeVisibleAttribute(bool visible);
        public bool Visible { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public class DisplayNameAttribute : Attribute {
        public static readonly DisplayNameAttribute Default;
        public DisplayNameAttribute();
        public DisplayNameAttribute(string displayName);
        public virtual string DisplayName { get; }
        protected string DisplayNameValue { get; set; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public class DoubleConverter : BaseNumberConverter {
        public DoubleConverter();
    }
    public class DoWorkEventArgs : CancelEventArgs {
        public DoWorkEventArgs(object argument);
        public object Argument { get; }
        public object Result { get; set; }
    }
    public delegate void DoWorkEventHandler(object sender, DoWorkEventArgs e);
    public sealed class EditorAttribute : Attribute {
        public EditorAttribute();
        public EditorAttribute(string typeName, string baseTypeName);
        public EditorAttribute(string typeName, Type baseType);
        public EditorAttribute(Type type, Type baseType);
        public string EditorBaseTypeName { get; }
        public string EditorTypeName { get; }
        public override object TypeId { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
    }
    public sealed class EditorBrowsableAttribute : Attribute {
        public EditorBrowsableAttribute();
        public EditorBrowsableAttribute(EditorBrowsableState state);
        public EditorBrowsableState State { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
    }
    public enum EditorBrowsableState {
        Advanced = 2,
        Always = 0,
        Never = 1,
    }
    public class EnumConverter : TypeConverter {
        public EnumConverter(Type type);
        protected virtual IComparer Comparer { get; }
        protected Type EnumType { get; }
        protected TypeConverter.StandardValuesCollection Values { get; set; }
        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context);
        public override bool GetStandardValuesSupported(ITypeDescriptorContext context);
        public override bool IsValid(ITypeDescriptorContext context, object value);
    }
    public abstract class EventDescriptor : MemberDescriptor {
        protected EventDescriptor(MemberDescriptor descr);
        protected EventDescriptor(MemberDescriptor descr, Attribute[] attrs);
        protected EventDescriptor(string name, Attribute[] attrs);
        public abstract Type ComponentType { get; }
        public abstract Type EventType { get; }
        public abstract bool IsMulticast { get; }
        public abstract void AddEventHandler(object component, Delegate value);
        public abstract void RemoveEventHandler(object component, Delegate value);
    }
    public class EventDescriptorCollection : ICollection, IEnumerable, IList {
        public static readonly EventDescriptorCollection Empty;
        public EventDescriptorCollection(EventDescriptor[] events);
        public EventDescriptorCollection(EventDescriptor[] events, bool readOnly);
        public int Count { get; }
        int System.Collections.ICollection.Count { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        bool System.Collections.IList.IsFixedSize { get; }
        bool System.Collections.IList.IsReadOnly { get; }
        object System.Collections.IList.this[int index] { get; set; }
        public virtual EventDescriptor this[int index] { get; }
        public virtual EventDescriptor this[string name] { get; }
        public int Add(EventDescriptor value);
        public void Clear();
        public bool Contains(EventDescriptor value);
        public virtual EventDescriptor Find(string name, bool ignoreCase);
        public IEnumerator GetEnumerator();
        public int IndexOf(EventDescriptor value);
        public void Insert(int index, EventDescriptor value);
        protected void InternalSort(IComparer sorter);
        protected void InternalSort(string[] names);
        public void Remove(EventDescriptor value);
        public void RemoveAt(int index);
        public virtual EventDescriptorCollection Sort();
        public virtual EventDescriptorCollection Sort(IComparer comparer);
        public virtual EventDescriptorCollection Sort(string[] names);
        public virtual EventDescriptorCollection Sort(string[] names, IComparer comparer);
        void System.Collections.ICollection.CopyTo(Array array, int index);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        int System.Collections.IList.Add(object value);
        void System.Collections.IList.Clear();
        bool System.Collections.IList.Contains(object value);
        int System.Collections.IList.IndexOf(object value);
        void System.Collections.IList.Insert(int index, object value);
        void System.Collections.IList.Remove(object value);
        void System.Collections.IList.RemoveAt(int index);
    }
    public sealed class EventHandlerList : IDisposable {
        public EventHandlerList();
        public Delegate this[object key] { get; set; }
        public void AddHandler(object key, Delegate value);
        public void AddHandlers(EventHandlerList listToAddFrom);
        public void Dispose();
        public void RemoveHandler(object key, Delegate value);
    }
    public class ExpandableObjectConverter : TypeConverter {
        public ExpandableObjectConverter();
        public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value, Attribute[] attributes);
        public override bool GetPropertiesSupported(ITypeDescriptorContext context);
    }
    public sealed class ExtenderProvidedPropertyAttribute : Attribute {
        public ExtenderProvidedPropertyAttribute();
        public PropertyDescriptor ExtenderProperty { get; }
        public IExtenderProvider Provider { get; }
        public Type ReceiverType { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public class GuidConverter : TypeConverter {
        public GuidConverter();
        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
    }
    public class HandledEventArgs : EventArgs {
        public HandledEventArgs();
        public HandledEventArgs(bool defaultHandledValue);
        public bool Handled { get; set; }
    }
    public delegate void HandledEventHandler(object sender, HandledEventArgs e);
    public interface IBindingList : ICollection, IEnumerable, IList {
        bool AllowEdit { get; }
        bool AllowNew { get; }
        bool AllowRemove { get; }
        bool IsSorted { get; }
        ListSortDirection SortDirection { get; }
        PropertyDescriptor SortProperty { get; }
        bool SupportsChangeNotification { get; }
        bool SupportsSearching { get; }
        bool SupportsSorting { get; }
        event ListChangedEventHandler ListChanged;
        void AddIndex(PropertyDescriptor property);
        object AddNew();
        void ApplySort(PropertyDescriptor property, ListSortDirection direction);
        int Find(PropertyDescriptor property, object key);
        void RemoveIndex(PropertyDescriptor property);
        void RemoveSort();
    }
    public interface IBindingListView : IBindingList, ICollection, IEnumerable, IList {
        string Filter { get; set; }
        ListSortDescriptionCollection SortDescriptions { get; }
        bool SupportsAdvancedSorting { get; }
        bool SupportsFiltering { get; }
        void ApplySort(ListSortDescriptionCollection sorts);
        void RemoveFilter();
    }
    public interface ICancelAddNew {
        void CancelNew(int itemIndex);
        void EndNew(int itemIndex);
    }
    public interface IChangeTracking {
        bool IsChanged { get; }
        void AcceptChanges();
    }
    public interface IComNativeDescriptorHandler {
        AttributeCollection GetAttributes(object component);
        string GetClassName(object component);
        TypeConverter GetConverter(object component);
        EventDescriptor GetDefaultEvent(object component);
        PropertyDescriptor GetDefaultProperty(object component);
        object GetEditor(object component, Type baseEditorType);
        EventDescriptorCollection GetEvents(object component);
        EventDescriptorCollection GetEvents(object component, Attribute[] attributes);
        string GetName(object component);
        PropertyDescriptorCollection GetProperties(object component, Attribute[] attributes);
        object GetPropertyValue(object component, int dispid, ref bool success);
        object GetPropertyValue(object component, string propertyName, ref bool success);
    }
    public interface IComponent : IDisposable {
        ISite Site { get; set; }
        event EventHandler Disposed;
    }
    public interface IContainer : IDisposable {
        ComponentCollection Components { get; }
        void Add(IComponent component);
        void Add(IComponent component, string name);
        void Remove(IComponent component);
    }
    public interface ICustomTypeDescriptor {
        AttributeCollection GetAttributes();
        string GetClassName();
        string GetComponentName();
        TypeConverter GetConverter();
        EventDescriptor GetDefaultEvent();
        PropertyDescriptor GetDefaultProperty();
        object GetEditor(Type editorBaseType);
        EventDescriptorCollection GetEvents();
        EventDescriptorCollection GetEvents(Attribute[] attributes);
        PropertyDescriptorCollection GetProperties();
        PropertyDescriptorCollection GetProperties(Attribute[] attributes);
        object GetPropertyOwner(PropertyDescriptor pd);
    }
    public interface IDataErrorInfo {
        string Error { get; }
        string this[string columnName] { get; }
    }
    public interface IEditableObject {
        void BeginEdit();
        void CancelEdit();
        void EndEdit();
    }
    public interface IExtenderProvider {
        bool CanExtend(object extendee);
    }
    public interface IIntellisenseBuilder {
        string Name { get; }
        bool Show(string language, string value, ref string newValue);
    }
    public interface IListSource {
        bool ContainsListCollection { get; }
        IList GetList();
    }
    public sealed class ImmutableObjectAttribute : Attribute {
        public static readonly ImmutableObjectAttribute Default;
        public static readonly ImmutableObjectAttribute No;
        public static readonly ImmutableObjectAttribute Yes;
        public ImmutableObjectAttribute(bool immutable);
        public bool Immutable { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public interface INestedContainer : IContainer, IDisposable {
        IComponent Owner { get; }
    }
    public interface INestedSite : IServiceProvider, ISite {
        string FullName { get; }
    }
    public sealed class InheritanceAttribute : Attribute {
        public static readonly InheritanceAttribute Default;
        public static readonly InheritanceAttribute Inherited;
        public static readonly InheritanceAttribute InheritedReadOnly;
        public static readonly InheritanceAttribute NotInherited;
        public InheritanceAttribute();
        public InheritanceAttribute(InheritanceLevel inheritanceLevel);
        public InheritanceLevel InheritanceLevel { get; }
        public override bool Equals(object value);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
        public override string ToString();
    }
    public enum InheritanceLevel {
        Inherited = 1,
        InheritedReadOnly = 2,
        NotInherited = 3,
    }
    public sealed class InitializationEventAttribute : Attribute {
        public InitializationEventAttribute(string eventName);
        public string EventName { get; }
    }
    public interface INotifyDataErrorInfo {
        bool HasErrors { get; }
        event EventHandler<DataErrorsChangedEventArgs> ErrorsChanged;
        IEnumerable GetErrors(string propertyName);
    }
    public interface INotifyPropertyChanged {
        event PropertyChangedEventHandler PropertyChanged;
    }
    public interface INotifyPropertyChanging {
        event PropertyChangingEventHandler PropertyChanging;
    }
    public class InstallerTypeAttribute : Attribute {
        public InstallerTypeAttribute(string typeName);
        public InstallerTypeAttribute(Type installerType);
        public virtual Type InstallerType { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
    }
    public abstract class InstanceCreationEditor {
        protected InstanceCreationEditor();
        public virtual string Text { get; }
        public abstract object CreateInstance(ITypeDescriptorContext context, Type instanceType);
    }
    public class Int16Converter : BaseNumberConverter {
        public Int16Converter();
    }
    public class Int32Converter : BaseNumberConverter {
        public Int32Converter();
    }
    public class Int64Converter : BaseNumberConverter {
        public Int64Converter();
    }
    public class InvalidAsynchronousStateException : ArgumentException {
        public InvalidAsynchronousStateException();
        protected InvalidAsynchronousStateException(SerializationInfo info, StreamingContext context);
        public InvalidAsynchronousStateException(string message);
        public InvalidAsynchronousStateException(string message, Exception innerException);
    }
    public class InvalidEnumArgumentException : ArgumentException {
        public InvalidEnumArgumentException();
        protected InvalidEnumArgumentException(SerializationInfo info, StreamingContext context);
        public InvalidEnumArgumentException(string message);
        public InvalidEnumArgumentException(string message, Exception innerException);
        public InvalidEnumArgumentException(string argumentName, int invalidValue, Type enumClass);
    }
    public interface IRaiseItemChangedEvents {
        bool RaisesItemChangedEvents { get; }
    }
    public interface IRevertibleChangeTracking : IChangeTracking {
        void RejectChanges();
    }
    public interface ISite : IServiceProvider {
        IComponent Component { get; }
        IContainer Container { get; }
        bool DesignMode { get; }
        string Name { get; set; }
    }
    public interface ISupportInitialize {
        void BeginInit();
        void EndInit();
    }
    public interface ISupportInitializeNotification : ISupportInitialize {
        bool IsInitialized { get; }
        event EventHandler Initialized;
    }
    public interface ISynchronizeInvoke {
        bool InvokeRequired { get; }
        IAsyncResult BeginInvoke(Delegate method, object[] args);
        object EndInvoke(IAsyncResult result);
        object Invoke(Delegate method, object[] args);
    }
    public interface ITypeDescriptorContext : IServiceProvider {
        IContainer Container { get; }
        object Instance { get; }
        PropertyDescriptor PropertyDescriptor { get; }
        void OnComponentChanged();
        bool OnComponentChanging();
    }
    public interface ITypedList {
        PropertyDescriptorCollection GetItemProperties(PropertyDescriptor[] listAccessors);
        string GetListName(PropertyDescriptor[] listAccessors);
    }
    public abstract class License : IDisposable {
        protected License();
        public abstract string LicenseKey { get; }
        public abstract void Dispose();
    }
    public class LicenseContext : IServiceProvider {
        public LicenseContext();
        public virtual LicenseUsageMode UsageMode { get; }
        public virtual string GetSavedLicenseKey(Type type, Assembly resourceAssembly);
        public virtual object GetService(Type type);
        public virtual void SetSavedLicenseKey(Type type, string key);
    }
    public class LicenseException : SystemException {
        protected LicenseException(SerializationInfo info, StreamingContext context);
        public LicenseException(Type type);
        public LicenseException(Type type, object instance);
        public LicenseException(Type type, object instance, string message);
        public LicenseException(Type type, object instance, string message, Exception innerException);
        public Type LicensedType { get; }
        public override void GetObjectData(SerializationInfo info, StreamingContext context);
    }
    public sealed class LicenseManager {
        public static LicenseContext CurrentContext { get; set; }
        public static LicenseUsageMode UsageMode { get; }
        public static object CreateWithContext(Type type, LicenseContext creationContext);
        public static object CreateWithContext(Type type, LicenseContext creationContext, object[] args);
        public static bool IsLicensed(Type type);
        public static bool IsValid(Type type);
        public static bool IsValid(Type type, object instance, out License license);
        public static void LockContext(object contextUser);
        public static void UnlockContext(object contextUser);
        public static void Validate(Type type);
        public static License Validate(Type type, object instance);
    }
    public abstract class LicenseProvider {
        protected LicenseProvider();
        public abstract License GetLicense(LicenseContext context, Type type, object instance, bool allowExceptions);
    }
    public sealed class LicenseProviderAttribute : Attribute {
        public static readonly LicenseProviderAttribute Default;
        public LicenseProviderAttribute();
        public LicenseProviderAttribute(string typeName);
        public LicenseProviderAttribute(Type type);
        public Type LicenseProvider { get; }
        public override object TypeId { get; }
        public override bool Equals(object value);
        public override int GetHashCode();
    }
    public enum LicenseUsageMode {
        Designtime = 1,
        Runtime = 0,
    }
    public class LicFileLicenseProvider : LicenseProvider {
        public LicFileLicenseProvider();
        protected virtual string GetKey(Type type);
        public override License GetLicense(LicenseContext context, Type type, object instance, bool allowExceptions);
        protected virtual bool IsKeyValid(string key, Type type);
    }
    public sealed class ListBindableAttribute : Attribute {
        public static readonly ListBindableAttribute Default;
        public static readonly ListBindableAttribute No;
        public static readonly ListBindableAttribute Yes;
        public ListBindableAttribute(bool listBindable);
        public ListBindableAttribute(BindableSupport flags);
        public bool ListBindable { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public class ListChangedEventArgs : EventArgs {
        public ListChangedEventArgs(ListChangedType listChangedType, PropertyDescriptor propDesc);
        public ListChangedEventArgs(ListChangedType listChangedType, int newIndex);
        public ListChangedEventArgs(ListChangedType listChangedType, int newIndex, PropertyDescriptor propDesc);
        public ListChangedEventArgs(ListChangedType listChangedType, int newIndex, int oldIndex);
        public ListChangedType ListChangedType { get; }
        public int NewIndex { get; }
        public int OldIndex { get; }
        public PropertyDescriptor PropertyDescriptor { get; }
    }
    public delegate void ListChangedEventHandler(object sender, ListChangedEventArgs e);
    public enum ListChangedType {
        ItemAdded = 1,
        ItemChanged = 4,
        ItemDeleted = 2,
        ItemMoved = 3,
        PropertyDescriptorAdded = 5,
        PropertyDescriptorChanged = 7,
        PropertyDescriptorDeleted = 6,
        Reset = 0,
    }
    public class ListSortDescription {
        public ListSortDescription(PropertyDescriptor property, ListSortDirection direction);
        public PropertyDescriptor PropertyDescriptor { get; set; }
        public ListSortDirection SortDirection { get; set; }
    }
    public class ListSortDescriptionCollection : ICollection, IEnumerable, IList {
        public ListSortDescriptionCollection();
        public ListSortDescriptionCollection(ListSortDescription[] sorts);
        public int Count { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        bool System.Collections.IList.IsFixedSize { get; }
        bool System.Collections.IList.IsReadOnly { get; }
        object System.Collections.IList.this[int index] { get; set; }
        public ListSortDescription this[int index] { get; set; }
        public bool Contains(object value);
        public void CopyTo(Array array, int index);
        public int IndexOf(object value);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        int System.Collections.IList.Add(object value);
        void System.Collections.IList.Clear();
        void System.Collections.IList.Insert(int index, object value);
        void System.Collections.IList.Remove(object value);
        void System.Collections.IList.RemoveAt(int index);
    }
    public enum ListSortDirection {
        Ascending = 0,
        Descending = 1,
    }
    public sealed class LocalizableAttribute : Attribute {
        public static readonly LocalizableAttribute Default;
        public static readonly LocalizableAttribute No;
        public static readonly LocalizableAttribute Yes;
        public LocalizableAttribute(bool isLocalizable);
        public bool IsLocalizable { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public sealed class LookupBindingPropertiesAttribute : Attribute {
        public static readonly LookupBindingPropertiesAttribute Default;
        public LookupBindingPropertiesAttribute();
        public LookupBindingPropertiesAttribute(string dataSource, string displayMember, string valueMember, string lookupMember);
        public string DataSource { get; }
        public string DisplayMember { get; }
        public string LookupMember { get; }
        public string ValueMember { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
    }
    public class MarshalByValueComponent : IComponent, IDisposable, IServiceProvider {
        public MarshalByValueComponent();
        public virtual IContainer Container { get; }
        public virtual bool DesignMode { get; }
        protected EventHandlerList Events { get; }
        public virtual ISite Site { get; set; }
        public event EventHandler Disposed;
        public void Dispose();
        protected virtual void Dispose(bool disposing);
        ~MarshalByValueComponent();
        public virtual object GetService(Type service);
        public override string ToString();
    }
    public class MaskedTextProvider : ICloneable {
        public MaskedTextProvider(string mask);
        public MaskedTextProvider(string mask, bool restrictToAscii);
        public MaskedTextProvider(string mask, char passwordChar, bool allowPromptAsInput);
        public MaskedTextProvider(string mask, CultureInfo culture);
        public MaskedTextProvider(string mask, CultureInfo culture, bool restrictToAscii);
        public MaskedTextProvider(string mask, CultureInfo culture, bool allowPromptAsInput, char promptChar, char passwordChar, bool restrictToAscii);
        public MaskedTextProvider(string mask, CultureInfo culture, char passwordChar, bool allowPromptAsInput);
        public bool AllowPromptAsInput { get; }
        public bool AsciiOnly { get; }
        public int AssignedEditPositionCount { get; }
        public int AvailableEditPositionCount { get; }
        public CultureInfo Culture { get; }
        public static char DefaultPasswordChar { get; }
        public int EditPositionCount { get; }
        public IEnumerator EditPositions { get; }
        public bool IncludeLiterals { get; set; }
        public bool IncludePrompt { get; set; }
        public static int InvalidIndex { get; }
        public bool IsPassword { get; set; }
        public int LastAssignedPosition { get; }
        public int Length { get; }
        public string Mask { get; }
        public bool MaskCompleted { get; }
        public bool MaskFull { get; }
        public char PasswordChar { get; set; }
        public char PromptChar { get; set; }
        public bool ResetOnPrompt { get; set; }
        public bool ResetOnSpace { get; set; }
        public bool SkipLiterals { get; set; }
        public char this[int index] { get; }
        public bool Add(char input);
        public bool Add(char input, out int testPosition, out MaskedTextResultHint resultHint);
        public bool Add(string input);
        public bool Add(string input, out int testPosition, out MaskedTextResultHint resultHint);
        public void Clear();
        public void Clear(out MaskedTextResultHint resultHint);
        public object Clone();
        public int FindAssignedEditPositionFrom(int position, bool direction);
        public int FindAssignedEditPositionInRange(int startPosition, int endPosition, bool direction);
        public int FindEditPositionFrom(int position, bool direction);
        public int FindEditPositionInRange(int startPosition, int endPosition, bool direction);
        public int FindNonEditPositionFrom(int position, bool direction);
        public int FindNonEditPositionInRange(int startPosition, int endPosition, bool direction);
        public int FindUnassignedEditPositionFrom(int position, bool direction);
        public int FindUnassignedEditPositionInRange(int startPosition, int endPosition, bool direction);
        public static bool GetOperationResultFromHint(MaskedTextResultHint hint);
        public bool InsertAt(char input, int position);
        public bool InsertAt(char input, int position, out int testPosition, out MaskedTextResultHint resultHint);
        public bool InsertAt(string input, int position);
        public bool InsertAt(string input, int position, out int testPosition, out MaskedTextResultHint resultHint);
        public bool IsAvailablePosition(int position);
        public bool IsEditPosition(int position);
        public static bool IsValidInputChar(char c);
        public static bool IsValidMaskChar(char c);
        public static bool IsValidPasswordChar(char c);
        public bool Remove();
        public bool Remove(out int testPosition, out MaskedTextResultHint resultHint);
        public bool RemoveAt(int position);
        public bool RemoveAt(int startPosition, int endPosition);
        public bool RemoveAt(int startPosition, int endPosition, out int testPosition, out MaskedTextResultHint resultHint);
        public bool Replace(char input, int position);
        public bool Replace(char input, int position, out int testPosition, out MaskedTextResultHint resultHint);
        public bool Replace(char input, int startPosition, int endPosition, out int testPosition, out MaskedTextResultHint resultHint);
        public bool Replace(string input, int position);
        public bool Replace(string input, int position, out int testPosition, out MaskedTextResultHint resultHint);
        public bool Replace(string input, int startPosition, int endPosition, out int testPosition, out MaskedTextResultHint resultHint);
        public bool Set(string input);
        public bool Set(string input, out int testPosition, out MaskedTextResultHint resultHint);
        public string ToDisplayString();
        public override string ToString();
        public string ToString(bool ignorePasswordChar);
        public string ToString(bool includePrompt, bool includeLiterals);
        public string ToString(bool ignorePasswordChar, bool includePrompt, bool includeLiterals, int startPosition, int length);
        public string ToString(bool includePrompt, bool includeLiterals, int startPosition, int length);
        public string ToString(bool ignorePasswordChar, int startPosition, int length);
        public string ToString(int startPosition, int length);
        public bool VerifyChar(char input, int position, out MaskedTextResultHint hint);
        public bool VerifyEscapeChar(char input, int position);
        public bool VerifyString(string input);
        public bool VerifyString(string input, out int testPosition, out MaskedTextResultHint resultHint);
    }
    public enum MaskedTextResultHint {
        AlphanumericCharacterExpected = -2,
        AsciiCharacterExpected = -1,
        CharacterEscaped = 1,
        DigitExpected = -3,
        InvalidInput = -51,
        LetterExpected = -4,
        NoEffect = 2,
        NonEditPosition = -54,
        PositionOutOfRange = -55,
        PromptCharNotAllowed = -52,
        SideEffect = 3,
        SignedDigitExpected = -5,
        Success = 4,
        UnavailableEditPosition = -53,
        Unknown = 0,
    }
    public abstract class MemberDescriptor {
        protected MemberDescriptor(MemberDescriptor descr);
        protected MemberDescriptor(MemberDescriptor oldMemberDescriptor, Attribute[] newAttributes);
        protected MemberDescriptor(string name);
        protected MemberDescriptor(string name, Attribute[] attributes);
        protected virtual Attribute[] AttributeArray { get; set; }
        public virtual AttributeCollection Attributes { get; }
        public virtual string Category { get; }
        public virtual string Description { get; }
        public virtual bool DesignTimeOnly { get; }
        public virtual string DisplayName { get; }
        public virtual bool IsBrowsable { get; }
        public virtual string Name { get; }
        protected virtual int NameHashCode { get; }
        protected virtual AttributeCollection CreateAttributeCollection();
        public override bool Equals(object obj);
        protected virtual void FillAttributes(IList attributeList);
        protected static MethodInfo FindMethod(Type componentClass, string name, Type[] args, Type returnType);
        protected static MethodInfo FindMethod(Type componentClass, string name, Type[] args, Type returnType, bool publicOnly);
        public override int GetHashCode();
        protected virtual object GetInvocationTarget(Type type, object instance);
        protected static object GetInvokee(Type componentClass, object component);
        protected static ISite GetSite(object component);
    }
    public sealed class MergablePropertyAttribute : Attribute {
        public static readonly MergablePropertyAttribute Default;
        public static readonly MergablePropertyAttribute No;
        public static readonly MergablePropertyAttribute Yes;
        public MergablePropertyAttribute(bool allowMerge);
        public bool AllowMerge { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public class MultilineStringConverter : TypeConverter {
        public MultilineStringConverter();
        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
        public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value, Attribute[] attributes);
        public override bool GetPropertiesSupported(ITypeDescriptorContext context);
    }
    public class NestedContainer : Container, IContainer, IDisposable, INestedContainer {
        public NestedContainer(IComponent owner);
        public IComponent Owner { get; }
        protected virtual string OwnerName { get; }
        protected override ISite CreateSite(IComponent component, string name);
        protected override void Dispose(bool disposing);
        protected override object GetService(Type service);
    }
    public sealed class NotifyParentPropertyAttribute : Attribute {
        public static readonly NotifyParentPropertyAttribute Default;
        public static readonly NotifyParentPropertyAttribute No;
        public static readonly NotifyParentPropertyAttribute Yes;
        public NotifyParentPropertyAttribute(bool notifyParent);
        public bool NotifyParent { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public class NullableConverter : TypeConverter {
        public NullableConverter(Type type);
        public Type NullableType { get; }
        public Type UnderlyingType { get; }
        public TypeConverter UnderlyingTypeConverter { get; }
        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
        public override object CreateInstance(ITypeDescriptorContext context, IDictionary propertyValues);
        public override bool GetCreateInstanceSupported(ITypeDescriptorContext context);
        public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value, Attribute[] attributes);
        public override bool GetPropertiesSupported(ITypeDescriptorContext context);
        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context);
        public override bool GetStandardValuesSupported(ITypeDescriptorContext context);
        public override bool IsValid(ITypeDescriptorContext context, object value);
    }
    public sealed class ParenthesizePropertyNameAttribute : Attribute {
        public static readonly ParenthesizePropertyNameAttribute Default;
        public ParenthesizePropertyNameAttribute();
        public ParenthesizePropertyNameAttribute(bool needParenthesis);
        public bool NeedParenthesis { get; }
        public override bool Equals(object o);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public sealed class PasswordPropertyTextAttribute : Attribute {
        public static readonly PasswordPropertyTextAttribute Default;
        public static readonly PasswordPropertyTextAttribute No;
        public static readonly PasswordPropertyTextAttribute Yes;
        public PasswordPropertyTextAttribute();
        public PasswordPropertyTextAttribute(bool password);
        public bool Password { get; }
        public override bool Equals(object o);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public class ProgressChangedEventArgs : EventArgs {
        public ProgressChangedEventArgs(int progressPercentage, object userState);
        public int ProgressPercentage { get; }
        public object UserState { get; }
    }
    public delegate void ProgressChangedEventHandler(object sender, ProgressChangedEventArgs e);
    public class PropertyChangedEventArgs : EventArgs {
        public PropertyChangedEventArgs(string propertyName);
        public virtual string PropertyName { get; }
    }
    public delegate void PropertyChangedEventHandler(object sender, PropertyChangedEventArgs e);
    public class PropertyChangingEventArgs : EventArgs {
        public PropertyChangingEventArgs(string propertyName);
        public virtual string PropertyName { get; }
    }
    public delegate void PropertyChangingEventHandler(object sender, PropertyChangingEventArgs e);
    public abstract class PropertyDescriptor : MemberDescriptor {
        protected PropertyDescriptor(MemberDescriptor descr);
        protected PropertyDescriptor(MemberDescriptor descr, Attribute[] attrs);
        protected PropertyDescriptor(string name, Attribute[] attrs);
        public abstract Type ComponentType { get; }
        public virtual TypeConverter Converter { get; }
        public virtual bool IsLocalizable { get; }
        public abstract bool IsReadOnly { get; }
        public abstract Type PropertyType { get; }
        public DesignerSerializationVisibility SerializationVisibility { get; }
        public virtual bool SupportsChangeEvents { get; }
        public virtual void AddValueChanged(object component, EventHandler handler);
        public abstract bool CanResetValue(object component);
        protected object CreateInstance(Type type);
        public override bool Equals(object obj);
        protected override void FillAttributes(IList attributeList);
        public PropertyDescriptorCollection GetChildProperties();
        public PropertyDescriptorCollection GetChildProperties(Attribute[] filter);
        public PropertyDescriptorCollection GetChildProperties(object instance);
        public virtual PropertyDescriptorCollection GetChildProperties(object instance, Attribute[] filter);
        public virtual object GetEditor(Type editorBaseType);
        public override int GetHashCode();
        protected override object GetInvocationTarget(Type type, object instance);
        protected Type GetTypeFromName(string typeName);
        public abstract object GetValue(object component);
        protected internal EventHandler GetValueChangedHandler(object component);
        protected virtual void OnValueChanged(object component, EventArgs e);
        public virtual void RemoveValueChanged(object component, EventHandler handler);
        public abstract void ResetValue(object component);
        public abstract void SetValue(object component, object value);
        public abstract bool ShouldSerializeValue(object component);
    }
    public class PropertyDescriptorCollection : ICollection, IDictionary, IEnumerable, IList {
        public static readonly PropertyDescriptorCollection Empty;
        public PropertyDescriptorCollection(PropertyDescriptor[] properties);
        public PropertyDescriptorCollection(PropertyDescriptor[] properties, bool readOnly);
        public int Count { get; }
        int System.Collections.ICollection.Count { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        bool System.Collections.IDictionary.IsFixedSize { get; }
        bool System.Collections.IDictionary.IsReadOnly { get; }
        object System.Collections.IDictionary.this[object key] { get; set; }
        ICollection System.Collections.IDictionary.Keys { get; }
        ICollection System.Collections.IDictionary.Values { get; }
        bool System.Collections.IList.IsFixedSize { get; }
        bool System.Collections.IList.IsReadOnly { get; }
        object System.Collections.IList.this[int index] { get; set; }
        public virtual PropertyDescriptor this[int index] { get; }
        public virtual PropertyDescriptor this[string name] { get; }
        public int Add(PropertyDescriptor value);
        public void Clear();
        public bool Contains(PropertyDescriptor value);
        public void CopyTo(Array array, int index);
        public virtual PropertyDescriptor Find(string name, bool ignoreCase);
        public virtual IEnumerator GetEnumerator();
        public int IndexOf(PropertyDescriptor value);
        public void Insert(int index, PropertyDescriptor value);
        protected void InternalSort(IComparer sorter);
        protected void InternalSort(string[] names);
        public void Remove(PropertyDescriptor value);
        public void RemoveAt(int index);
        public virtual PropertyDescriptorCollection Sort();
        public virtual PropertyDescriptorCollection Sort(IComparer comparer);
        public virtual PropertyDescriptorCollection Sort(string[] names);
        public virtual PropertyDescriptorCollection Sort(string[] names, IComparer comparer);
        void System.Collections.IDictionary.Add(object key, object value);
        void System.Collections.IDictionary.Clear();
        bool System.Collections.IDictionary.Contains(object key);
        IDictionaryEnumerator System.Collections.IDictionary.GetEnumerator();
        void System.Collections.IDictionary.Remove(object key);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        int System.Collections.IList.Add(object value);
        void System.Collections.IList.Clear();
        bool System.Collections.IList.Contains(object value);
        int System.Collections.IList.IndexOf(object value);
        void System.Collections.IList.Insert(int index, object value);
        void System.Collections.IList.Remove(object value);
        void System.Collections.IList.RemoveAt(int index);
    }
    public class PropertyTabAttribute : Attribute {
        public PropertyTabAttribute();
        public PropertyTabAttribute(string tabClassName);
        public PropertyTabAttribute(string tabClassName, PropertyTabScope tabScope);
        public PropertyTabAttribute(Type tabClass);
        public PropertyTabAttribute(Type tabClass, PropertyTabScope tabScope);
        public Type[] TabClasses { get; }
        protected string[] TabClassNames { get; }
        public PropertyTabScope[] TabScopes { get; }
        public bool Equals(PropertyTabAttribute other);
        public override bool Equals(object other);
        public override int GetHashCode();
        protected void InitializeArrays(string[] tabClassNames, PropertyTabScope[] tabScopes);
        protected void InitializeArrays(Type[] tabClasses, PropertyTabScope[] tabScopes);
    }
    public enum PropertyTabScope {
        Component = 3,
        Document = 2,
        Global = 1,
        Static = 0,
    }
    public sealed class ProvidePropertyAttribute : Attribute {
        public ProvidePropertyAttribute(string propertyName, string receiverTypeName);
        public ProvidePropertyAttribute(string propertyName, Type receiverType);
        public string PropertyName { get; }
        public string ReceiverTypeName { get; }
        public override object TypeId { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
    }
    public sealed class ReadOnlyAttribute : Attribute {
        public static readonly ReadOnlyAttribute Default;
        public static readonly ReadOnlyAttribute No;
        public static readonly ReadOnlyAttribute Yes;
        public ReadOnlyAttribute(bool isReadOnly);
        public bool IsReadOnly { get; }
        public override bool Equals(object value);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public class RecommendedAsConfigurableAttribute : Attribute {
        public static readonly RecommendedAsConfigurableAttribute Default;
        public static readonly RecommendedAsConfigurableAttribute No;
        public static readonly RecommendedAsConfigurableAttribute Yes;
        public RecommendedAsConfigurableAttribute(bool recommendedAsConfigurable);
        public bool RecommendedAsConfigurable { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public class ReferenceConverter : TypeConverter {
        public ReferenceConverter(Type type);
        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context);
        public override bool GetStandardValuesSupported(ITypeDescriptorContext context);
        protected virtual bool IsValueAllowed(ITypeDescriptorContext context, object value);
    }
    public class RefreshEventArgs : EventArgs {
        public RefreshEventArgs(object componentChanged);
        public RefreshEventArgs(Type typeChanged);
        public object ComponentChanged { get; }
        public Type TypeChanged { get; }
    }
    public delegate void RefreshEventHandler(RefreshEventArgs e);
    public enum RefreshProperties {
        All = 1,
        None = 0,
        Repaint = 2,
    }
    public sealed class RefreshPropertiesAttribute : Attribute {
        public static readonly RefreshPropertiesAttribute All;
        public static readonly RefreshPropertiesAttribute Default;
        public static readonly RefreshPropertiesAttribute Repaint;
        public RefreshPropertiesAttribute(RefreshProperties refresh);
        public RefreshProperties RefreshProperties { get; }
        public override bool Equals(object value);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public class RunInstallerAttribute : Attribute {
        public static readonly RunInstallerAttribute Default;
        public static readonly RunInstallerAttribute No;
        public static readonly RunInstallerAttribute Yes;
        public RunInstallerAttribute(bool runInstaller);
        public bool RunInstaller { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public class RunWorkerCompletedEventArgs : AsyncCompletedEventArgs {
        public RunWorkerCompletedEventArgs(object result, Exception error, bool cancelled);
        public object Result { get; }
        public new object UserState { get; }
    }
    public delegate void RunWorkerCompletedEventHandler(object sender, RunWorkerCompletedEventArgs e);
    public class SByteConverter : BaseNumberConverter {
        public SByteConverter();
    }
    public sealed class SettingsBindableAttribute : Attribute {
        public static readonly SettingsBindableAttribute No;
        public static readonly SettingsBindableAttribute Yes;
        public SettingsBindableAttribute(bool bindable);
        public bool Bindable { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
    }
    public class SingleConverter : BaseNumberConverter {
        public SingleConverter();
    }
    public class StringConverter : TypeConverter {
        public StringConverter();
        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
    }
    public static class SyntaxCheck {
        public static bool CheckMachineName(string value);
        public static bool CheckPath(string value);
        public static bool CheckRootedPath(string value);
    }
    public class TimeSpanConverter : TypeConverter {
        public TimeSpanConverter();
        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
    }
    public class ToolboxItemAttribute : Attribute {
        public static readonly ToolboxItemAttribute Default;
        public static readonly ToolboxItemAttribute None;
        public ToolboxItemAttribute(bool defaultType);
        public ToolboxItemAttribute(string toolboxItemTypeName);
        public ToolboxItemAttribute(Type toolboxItemType);
        public Type ToolboxItemType { get; }
        public string ToolboxItemTypeName { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public sealed class ToolboxItemFilterAttribute : Attribute {
        public ToolboxItemFilterAttribute(string filterString);
        public ToolboxItemFilterAttribute(string filterString, ToolboxItemFilterType filterType);
        public string FilterString { get; }
        public ToolboxItemFilterType FilterType { get; }
        public override object TypeId { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override bool Match(object obj);
        public override string ToString();
    }
    public enum ToolboxItemFilterType {
        Allow = 0,
        Custom = 1,
        Prevent = 2,
        Require = 3,
    }
    public class TypeConverter {
        public TypeConverter();
        public virtual bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
        public bool CanConvertFrom(Type sourceType);
        public virtual bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
        public bool CanConvertTo(Type destinationType);
        public virtual object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
        public object ConvertFrom(object value);
        public object ConvertFromInvariantString(ITypeDescriptorContext context, string text);
        public object ConvertFromInvariantString(string text);
        public object ConvertFromString(ITypeDescriptorContext context, CultureInfo culture, string text);
        public object ConvertFromString(ITypeDescriptorContext context, string text);
        public object ConvertFromString(string text);
        public virtual object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
        public object ConvertTo(object value, Type destinationType);
        public string ConvertToInvariantString(ITypeDescriptorContext context, object value);
        public string ConvertToInvariantString(object value);
        public string ConvertToString(ITypeDescriptorContext context, CultureInfo culture, object value);
        public string ConvertToString(ITypeDescriptorContext context, object value);
        public string ConvertToString(object value);
        public object CreateInstance(IDictionary propertyValues);
        public virtual object CreateInstance(ITypeDescriptorContext context, IDictionary propertyValues);
        protected Exception GetConvertFromException(object value);
        protected Exception GetConvertToException(object value, Type destinationType);
        public bool GetCreateInstanceSupported();
        public virtual bool GetCreateInstanceSupported(ITypeDescriptorContext context);
        public PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value);
        public virtual PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value, Attribute[] attributes);
        public PropertyDescriptorCollection GetProperties(object value);
        public bool GetPropertiesSupported();
        public virtual bool GetPropertiesSupported(ITypeDescriptorContext context);
        public ICollection GetStandardValues();
        public virtual TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
        public bool GetStandardValuesExclusive();
        public virtual bool GetStandardValuesExclusive(ITypeDescriptorContext context);
        public bool GetStandardValuesSupported();
        public virtual bool GetStandardValuesSupported(ITypeDescriptorContext context);
        public virtual bool IsValid(ITypeDescriptorContext context, object value);
        public bool IsValid(object value);
        protected PropertyDescriptorCollection SortProperties(PropertyDescriptorCollection props, string[] names);
        protected abstract class SimplePropertyDescriptor : PropertyDescriptor {
            protected SimplePropertyDescriptor(Type componentType, string name, Type propertyType);
            protected SimplePropertyDescriptor(Type componentType, string name, Type propertyType, Attribute[] attributes);
            public override Type ComponentType { get; }
            public override bool IsReadOnly { get; }
            public override Type PropertyType { get; }
            public override bool CanResetValue(object component);
            public override void ResetValue(object component);
            public override bool ShouldSerializeValue(object component);
        }
        public class StandardValuesCollection : ICollection, IEnumerable {
            public StandardValuesCollection(ICollection values);
            public int Count { get; }
            int System.Collections.ICollection.Count { get; }
            bool System.Collections.ICollection.IsSynchronized { get; }
            object System.Collections.ICollection.SyncRoot { get; }
            public object this[int index] { get; }
            public void CopyTo(Array array, int index);
            public IEnumerator GetEnumerator();
            void System.Collections.ICollection.CopyTo(Array array, int index);
            IEnumerator System.Collections.IEnumerable.GetEnumerator();
        }
    }
    public sealed class TypeConverterAttribute : Attribute {
        public static readonly TypeConverterAttribute Default;
        public TypeConverterAttribute();
        public TypeConverterAttribute(string typeName);
        public TypeConverterAttribute(Type type);
        public string ConverterTypeName { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
    }
    public abstract class TypeDescriptionProvider {
        protected TypeDescriptionProvider();
        protected TypeDescriptionProvider(TypeDescriptionProvider parent);
        public virtual object CreateInstance(IServiceProvider provider, Type objectType, Type[] argTypes, object[] args);
        public virtual IDictionary GetCache(object instance);
        public virtual ICustomTypeDescriptor GetExtendedTypeDescriptor(object instance);
        protected internal virtual IExtenderProvider[] GetExtenderProviders(object instance);
        public virtual string GetFullComponentName(object component);
        public Type GetReflectionType(object instance);
        public Type GetReflectionType(Type objectType);
        public virtual Type GetReflectionType(Type objectType, object instance);
        public virtual Type GetRuntimeType(Type reflectionType);
        public ICustomTypeDescriptor GetTypeDescriptor(object instance);
        public ICustomTypeDescriptor GetTypeDescriptor(Type objectType);
        public virtual ICustomTypeDescriptor GetTypeDescriptor(Type objectType, object instance);
        public virtual bool IsSupportedType(Type type);
    }
    public sealed class TypeDescriptionProviderAttribute : Attribute {
        public TypeDescriptionProviderAttribute(string typeName);
        public TypeDescriptionProviderAttribute(Type type);
        public string TypeName { get; }
    }
    public sealed class TypeDescriptor {
        public static IComNativeDescriptorHandler ComNativeDescriptorHandler { get; set; }
        public static Type ComObjectType { get; }
        public static Type InterfaceType { get; }
        public static event RefreshEventHandler Refreshed;
        public static TypeDescriptionProvider AddAttributes(object instance, params Attribute[] attributes);
        public static TypeDescriptionProvider AddAttributes(Type type, params Attribute[] attributes);
        public static void AddEditorTable(Type editorBaseType, Hashtable table);
        public static void AddProvider(TypeDescriptionProvider provider, object instance);
        public static void AddProvider(TypeDescriptionProvider provider, Type type);
        public static void AddProviderTransparent(TypeDescriptionProvider provider, object instance);
        public static void AddProviderTransparent(TypeDescriptionProvider provider, Type type);
        public static void CreateAssociation(object primary, object secondary);
        public static IDesigner CreateDesigner(IComponent component, Type designerBaseType);
        public static EventDescriptor CreateEvent(Type componentType, EventDescriptor oldEventDescriptor, params Attribute[] attributes);
        public static EventDescriptor CreateEvent(Type componentType, string name, Type type, params Attribute[] attributes);
        public static object CreateInstance(IServiceProvider provider, Type objectType, Type[] argTypes, object[] args);
        public static PropertyDescriptor CreateProperty(Type componentType, PropertyDescriptor oldPropertyDescriptor, params Attribute[] attributes);
        public static PropertyDescriptor CreateProperty(Type componentType, string name, Type type, params Attribute[] attributes);
        public static object GetAssociation(Type type, object primary);
        public static AttributeCollection GetAttributes(object component);
        public static AttributeCollection GetAttributes(object component, bool noCustomTypeDesc);
        public static AttributeCollection GetAttributes(Type componentType);
        public static string GetClassName(object component);
        public static string GetClassName(object component, bool noCustomTypeDesc);
        public static string GetClassName(Type componentType);
        public static string GetComponentName(object component);
        public static string GetComponentName(object component, bool noCustomTypeDesc);
        public static TypeConverter GetConverter(object component);
        public static TypeConverter GetConverter(object component, bool noCustomTypeDesc);
        public static TypeConverter GetConverter(Type type);
        public static EventDescriptor GetDefaultEvent(object component);
        public static EventDescriptor GetDefaultEvent(object component, bool noCustomTypeDesc);
        public static EventDescriptor GetDefaultEvent(Type componentType);
        public static PropertyDescriptor GetDefaultProperty(object component);
        public static PropertyDescriptor GetDefaultProperty(object component, bool noCustomTypeDesc);
        public static PropertyDescriptor GetDefaultProperty(Type componentType);
        public static object GetEditor(object component, Type editorBaseType);
        public static object GetEditor(object component, Type editorBaseType, bool noCustomTypeDesc);
        public static object GetEditor(Type type, Type editorBaseType);
        public static EventDescriptorCollection GetEvents(object component);
        public static EventDescriptorCollection GetEvents(object component, Attribute[] attributes);
        public static EventDescriptorCollection GetEvents(object component, Attribute[] attributes, bool noCustomTypeDesc);
        public static EventDescriptorCollection GetEvents(object component, bool noCustomTypeDesc);
        public static EventDescriptorCollection GetEvents(Type componentType);
        public static EventDescriptorCollection GetEvents(Type componentType, Attribute[] attributes);
        public static string GetFullComponentName(object component);
        public static PropertyDescriptorCollection GetProperties(object component);
        public static PropertyDescriptorCollection GetProperties(object component, Attribute[] attributes);
        public static PropertyDescriptorCollection GetProperties(object component, Attribute[] attributes, bool noCustomTypeDesc);
        public static PropertyDescriptorCollection GetProperties(object component, bool noCustomTypeDesc);
        public static PropertyDescriptorCollection GetProperties(Type componentType);
        public static PropertyDescriptorCollection GetProperties(Type componentType, Attribute[] attributes);
        public static TypeDescriptionProvider GetProvider(object instance);
        public static TypeDescriptionProvider GetProvider(Type type);
        public static Type GetReflectionType(object instance);
        public static Type GetReflectionType(Type type);
        public static void Refresh(object component);
        public static void Refresh(Assembly assembly);
        public static void Refresh(Module module);
        public static void Refresh(Type type);
        public static void RemoveAssociation(object primary, object secondary);
        public static void RemoveAssociations(object primary);
        public static void RemoveProvider(TypeDescriptionProvider provider, object instance);
        public static void RemoveProvider(TypeDescriptionProvider provider, Type type);
        public static void RemoveProviderTransparent(TypeDescriptionProvider provider, object instance);
        public static void RemoveProviderTransparent(TypeDescriptionProvider provider, Type type);
        public static void SortDescriptorArray(IList infos);
    }
    public abstract class TypeListConverter : TypeConverter {
        protected TypeListConverter(Type[] types);
        public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType);
        public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType);
        public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value);
        public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType);
        public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context);
        public override bool GetStandardValuesExclusive(ITypeDescriptorContext context);
        public override bool GetStandardValuesSupported(ITypeDescriptorContext context);
    }
    public class UInt16Converter : BaseNumberConverter {
        public UInt16Converter();
    }
    public class UInt32Converter : BaseNumberConverter {
        public UInt32Converter();
    }
    public class UInt64Converter : BaseNumberConverter {
        public UInt64Converter();
    }
    public class WarningException : SystemException {
        public WarningException();
        protected WarningException(SerializationInfo info, StreamingContext context);
        public WarningException(string message);
        public WarningException(string message, Exception innerException);
        public WarningException(string message, string helpUrl);
        public WarningException(string message, string helpUrl, string helpTopic);
        public string HelpTopic { get; }
        public string HelpUrl { get; }
        public override void GetObjectData(SerializationInfo info, StreamingContext context);
    }
    public class Win32Exception : ExternalException, ISerializable {
        public Win32Exception();
        public Win32Exception(int error);
        public Win32Exception(int error, string message);
        protected Win32Exception(SerializationInfo info, StreamingContext context);
        public Win32Exception(string message);
        public Win32Exception(string message, Exception innerException);
        public int NativeErrorCode { get; }
        public override void GetObjectData(SerializationInfo info, StreamingContext context);
    }
}
namespace System.ComponentModel.Design {
    public class ActiveDesignerEventArgs : EventArgs {
        public ActiveDesignerEventArgs(IDesignerHost oldDesigner, IDesignerHost newDesigner);
        public IDesignerHost NewDesigner { get; }
        public IDesignerHost OldDesigner { get; }
    }
    public delegate void ActiveDesignerEventHandler(object sender, ActiveDesignerEventArgs e);
    public class CheckoutException : ExternalException {
        public static readonly CheckoutException Canceled;
        public CheckoutException();
        protected CheckoutException(SerializationInfo info, StreamingContext context);
        public CheckoutException(string message);
        public CheckoutException(string message, Exception innerException);
        public CheckoutException(string message, int errorCode);
    }
    public class CommandID {
        public CommandID(Guid menuGroup, int commandID);
        public virtual Guid Guid { get; }
        public virtual int ID { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override string ToString();
    }
    public sealed class ComponentChangedEventArgs : EventArgs {
        public ComponentChangedEventArgs(object component, MemberDescriptor member, object oldValue, object newValue);
        public object Component { get; }
        public MemberDescriptor Member { get; }
        public object NewValue { get; }
        public object OldValue { get; }
    }
    public delegate void ComponentChangedEventHandler(object sender, ComponentChangedEventArgs e);
    public sealed class ComponentChangingEventArgs : EventArgs {
        public ComponentChangingEventArgs(object component, MemberDescriptor member);
        public object Component { get; }
        public MemberDescriptor Member { get; }
    }
    public delegate void ComponentChangingEventHandler(object sender, ComponentChangingEventArgs e);
    public class ComponentEventArgs : EventArgs {
        public ComponentEventArgs(IComponent component);
        public virtual IComponent Component { get; }
    }
    public delegate void ComponentEventHandler(object sender, ComponentEventArgs e);
    public class ComponentRenameEventArgs : EventArgs {
        public ComponentRenameEventArgs(object component, string oldName, string newName);
        public object Component { get; }
        public virtual string NewName { get; }
        public virtual string OldName { get; }
    }
    public delegate void ComponentRenameEventHandler(object sender, ComponentRenameEventArgs e);
    public class DesignerCollection : ICollection, IEnumerable {
        public DesignerCollection(IList designers);
        public DesignerCollection(IDesignerHost[] designers);
        public int Count { get; }
        int System.Collections.ICollection.Count { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        public virtual IDesignerHost this[int index] { get; }
        public IEnumerator GetEnumerator();
        void System.Collections.ICollection.CopyTo(Array array, int index);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
    }
    public class DesignerEventArgs : EventArgs {
        public DesignerEventArgs(IDesignerHost host);
        public IDesignerHost Designer { get; }
    }
    public delegate void DesignerEventHandler(object sender, DesignerEventArgs e);
    public abstract class DesignerOptionService : IDesignerOptionService {
        protected DesignerOptionService();
        public DesignerOptionService.DesignerOptionCollection Options { get; }
        protected DesignerOptionService.DesignerOptionCollection CreateOptionCollection(DesignerOptionService.DesignerOptionCollection parent, string name, object value);
        protected virtual void PopulateOptionCollection(DesignerOptionService.DesignerOptionCollection options);
        protected virtual bool ShowDialog(DesignerOptionService.DesignerOptionCollection options, object optionObject);
        object System.ComponentModel.Design.IDesignerOptionService.GetOptionValue(string pageName, string valueName);
        void System.ComponentModel.Design.IDesignerOptionService.SetOptionValue(string pageName, string valueName, object value);
        public sealed class DesignerOptionCollection : ICollection, IEnumerable, IList {
            public int Count { get; }
            public string Name { get; }
            public DesignerOptionService.DesignerOptionCollection Parent { get; }
            public PropertyDescriptorCollection Properties { get; }
            bool System.Collections.ICollection.IsSynchronized { get; }
            object System.Collections.ICollection.SyncRoot { get; }
            bool System.Collections.IList.IsFixedSize { get; }
            bool System.Collections.IList.IsReadOnly { get; }
            object System.Collections.IList.this[int index] { get; set; }
            public DesignerOptionService.DesignerOptionCollection this[int index] { get; }
            public DesignerOptionService.DesignerOptionCollection this[string name] { get; }
            public void CopyTo(Array array, int index);
            public IEnumerator GetEnumerator();
            public int IndexOf(DesignerOptionService.DesignerOptionCollection value);
            public bool ShowDialog();
            int System.Collections.IList.Add(object value);
            void System.Collections.IList.Clear();
            bool System.Collections.IList.Contains(object value);
            int System.Collections.IList.IndexOf(object value);
            void System.Collections.IList.Insert(int index, object value);
            void System.Collections.IList.Remove(object value);
            void System.Collections.IList.RemoveAt(int index);
        }
    }
    public abstract class DesignerTransaction : IDisposable {
        protected DesignerTransaction();
        protected DesignerTransaction(string description);
        public bool Canceled { get; }
        public bool Committed { get; }
        public string Description { get; }
        public void Cancel();
        public void Commit();
        protected virtual void Dispose(bool disposing);
        ~DesignerTransaction();
        protected abstract void OnCancel();
        protected abstract void OnCommit();
        void System.IDisposable.Dispose();
    }
    public class DesignerTransactionCloseEventArgs : EventArgs {
        public DesignerTransactionCloseEventArgs(bool commit);
        public DesignerTransactionCloseEventArgs(bool commit, bool lastTransaction);
        public bool LastTransaction { get; }
        public bool TransactionCommitted { get; }
    }
    public delegate void DesignerTransactionCloseEventHandler(object sender, DesignerTransactionCloseEventArgs e);
    public class DesignerVerb : MenuCommand {
        public DesignerVerb(string text, EventHandler handler);
        public DesignerVerb(string text, EventHandler handler, CommandID startCommandID);
        public string Description { get; set; }
        public string Text { get; }
        public override string ToString();
    }
    public class DesignerVerbCollection : CollectionBase {
        public DesignerVerbCollection();
        public DesignerVerbCollection(DesignerVerb[] value);
        public DesignerVerb this[int index] { get; set; }
        public int Add(DesignerVerb value);
        public void AddRange(DesignerVerbCollection value);
        public void AddRange(DesignerVerb[] value);
        public bool Contains(DesignerVerb value);
        public void CopyTo(DesignerVerb[] array, int index);
        public int IndexOf(DesignerVerb value);
        public void Insert(int index, DesignerVerb value);
        protected override void OnClear();
        protected override void OnInsert(int index, object value);
        protected override void OnRemove(int index, object value);
        protected override void OnSet(int index, object oldValue, object newValue);
        protected override void OnValidate(object value);
        public void Remove(DesignerVerb value);
    }
    public class DesigntimeLicenseContext : LicenseContext {
        public DesigntimeLicenseContext();
        public override LicenseUsageMode UsageMode { get; }
        public override string GetSavedLicenseKey(Type type, Assembly resourceAssembly);
        public override void SetSavedLicenseKey(Type type, string key);
    }
    public class DesigntimeLicenseContextSerializer {
        public static void Serialize(Stream o, string cryptoKey, DesigntimeLicenseContext context);
    }
    public enum HelpContextType {
        Ambient = 0,
        Selection = 2,
        ToolWindowSelection = 3,
        Window = 1,
    }
    public sealed class HelpKeywordAttribute : Attribute {
        public static readonly HelpKeywordAttribute Default;
        public HelpKeywordAttribute();
        public HelpKeywordAttribute(string keyword);
        public HelpKeywordAttribute(Type t);
        public string HelpKeyword { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public override bool IsDefaultAttribute();
    }
    public enum HelpKeywordType {
        F1Keyword = 0,
        FilterKeyword = 2,
        GeneralKeyword = 1,
    }
    public interface IComponentChangeService {
        event ComponentEventHandler ComponentAdded;
        event ComponentEventHandler ComponentAdding;
        event ComponentChangedEventHandler ComponentChanged;
        event ComponentChangingEventHandler ComponentChanging;
        event ComponentEventHandler ComponentRemoved;
        event ComponentEventHandler ComponentRemoving;
        event ComponentRenameEventHandler ComponentRename;
        void OnComponentChanged(object component, MemberDescriptor member, object oldValue, object newValue);
        void OnComponentChanging(object component, MemberDescriptor member);
    }
    public interface IComponentDiscoveryService {
        ICollection GetComponentTypes(IDesignerHost designerHost, Type baseType);
    }
    public interface IComponentInitializer {
        void InitializeExistingComponent(IDictionary defaultValues);
        void InitializeNewComponent(IDictionary defaultValues);
    }
    public interface IDesigner : IDisposable {
        IComponent Component { get; }
        DesignerVerbCollection Verbs { get; }
        void DoDefaultAction();
        void Initialize(IComponent component);
    }
    public interface IDesignerEventService {
        IDesignerHost ActiveDesigner { get; }
        DesignerCollection Designers { get; }
        event ActiveDesignerEventHandler ActiveDesignerChanged;
        event DesignerEventHandler DesignerCreated;
        event DesignerEventHandler DesignerDisposed;
        event EventHandler SelectionChanged;
    }
    public interface IDesignerFilter {
        void PostFilterAttributes(IDictionary attributes);
        void PostFilterEvents(IDictionary events);
        void PostFilterProperties(IDictionary properties);
        void PreFilterAttributes(IDictionary attributes);
        void PreFilterEvents(IDictionary events);
        void PreFilterProperties(IDictionary properties);
    }
    public interface IDesignerHost : IServiceContainer, IServiceProvider {
        IContainer Container { get; }
        bool InTransaction { get; }
        bool Loading { get; }
        IComponent RootComponent { get; }
        string RootComponentClassName { get; }
        string TransactionDescription { get; }
        event EventHandler Activated;
        event EventHandler Deactivated;
        event EventHandler LoadComplete;
        event DesignerTransactionCloseEventHandler TransactionClosed;
        event DesignerTransactionCloseEventHandler TransactionClosing;
        event EventHandler TransactionOpened;
        event EventHandler TransactionOpening;
        void Activate();
        IComponent CreateComponent(Type componentClass);
        IComponent CreateComponent(Type componentClass, string name);
        DesignerTransaction CreateTransaction();
        DesignerTransaction CreateTransaction(string description);
        void DestroyComponent(IComponent component);
        IDesigner GetDesigner(IComponent component);
        Type GetType(string typeName);
    }
    public interface IDesignerHostTransactionState {
        bool IsClosingTransaction { get; }
    }
    public interface IDesignerOptionService {
        object GetOptionValue(string pageName, string valueName);
        void SetOptionValue(string pageName, string valueName, object value);
    }
    public interface IDictionaryService {
        object GetKey(object value);
        object GetValue(object key);
        void SetValue(object key, object value);
    }
    public interface IEventBindingService {
        string CreateUniqueMethodName(IComponent component, EventDescriptor e);
        ICollection GetCompatibleMethods(EventDescriptor e);
        EventDescriptor GetEvent(PropertyDescriptor property);
        PropertyDescriptorCollection GetEventProperties(EventDescriptorCollection events);
        PropertyDescriptor GetEventProperty(EventDescriptor e);
        bool ShowCode();
        bool ShowCode(IComponent component, EventDescriptor e);
        bool ShowCode(int lineNumber);
    }
    public interface IExtenderListService {
        IExtenderProvider[] GetExtenderProviders();
    }
    public interface IExtenderProviderService {
        void AddExtenderProvider(IExtenderProvider provider);
        void RemoveExtenderProvider(IExtenderProvider provider);
    }
    public interface IHelpService {
        void AddContextAttribute(string name, string value, HelpKeywordType keywordType);
        void ClearContextAttributes();
        IHelpService CreateLocalContext(HelpContextType contextType);
        void RemoveContextAttribute(string name, string value);
        void RemoveLocalContext(IHelpService localContext);
        void ShowHelpFromKeyword(string helpKeyword);
        void ShowHelpFromUrl(string helpUrl);
    }
    public interface IInheritanceService {
        void AddInheritedComponents(IComponent component, IContainer container);
        InheritanceAttribute GetInheritanceAttribute(IComponent component);
    }
    public interface IMenuCommandService {
        DesignerVerbCollection Verbs { get; }
        void AddCommand(MenuCommand command);
        void AddVerb(DesignerVerb verb);
        MenuCommand FindCommand(CommandID commandID);
        bool GlobalInvoke(CommandID commandID);
        void RemoveCommand(MenuCommand command);
        void RemoveVerb(DesignerVerb verb);
        void ShowContextMenu(CommandID menuID, int x, int y);
    }
    public interface IReferenceService {
        IComponent GetComponent(object reference);
        string GetName(object reference);
        object GetReference(string name);
        object[] GetReferences();
        object[] GetReferences(Type baseType);
    }
    public interface IResourceService {
        IResourceReader GetResourceReader(CultureInfo info);
        IResourceWriter GetResourceWriter(CultureInfo info);
    }
    public interface IRootDesigner : IDesigner, IDisposable {
        ViewTechnology[] SupportedTechnologies { get; }
        object GetView(ViewTechnology technology);
    }
    public interface ISelectionService {
        object PrimarySelection { get; }
        int SelectionCount { get; }
        event EventHandler SelectionChanged;
        event EventHandler SelectionChanging;
        bool GetComponentSelected(object component);
        ICollection GetSelectedComponents();
        void SetSelectedComponents(ICollection components);
        void SetSelectedComponents(ICollection components, SelectionTypes selectionType);
    }
    public interface IServiceContainer : IServiceProvider {
        void AddService(Type serviceType, ServiceCreatorCallback callback);
        void AddService(Type serviceType, ServiceCreatorCallback callback, bool promote);
        void AddService(Type serviceType, object serviceInstance);
        void AddService(Type serviceType, object serviceInstance, bool promote);
        void RemoveService(Type serviceType);
        void RemoveService(Type serviceType, bool promote);
    }
    public interface ITreeDesigner : IDesigner, IDisposable {
        ICollection Children { get; }
        IDesigner Parent { get; }
    }
    public interface ITypeDescriptorFilterService {
        bool FilterAttributes(IComponent component, IDictionary attributes);
        bool FilterEvents(IComponent component, IDictionary events);
        bool FilterProperties(IComponent component, IDictionary properties);
    }
    public interface ITypeDiscoveryService {
        ICollection GetTypes(Type baseType, bool excludeGlobalTypes);
    }
    public interface ITypeResolutionService {
        Assembly GetAssembly(AssemblyName name);
        Assembly GetAssembly(AssemblyName name, bool throwOnError);
        string GetPathOfAssembly(AssemblyName name);
        Type GetType(string name);
        Type GetType(string name, bool throwOnError);
        Type GetType(string name, bool throwOnError, bool ignoreCase);
        void ReferenceAssembly(AssemblyName name);
    }
    public class MenuCommand {
        public MenuCommand(EventHandler handler, CommandID command);
        public virtual bool Checked { get; set; }
        public virtual CommandID CommandID { get; }
        public virtual bool Enabled { get; set; }
        public virtual int OleStatus { get; }
        public virtual IDictionary Properties { get; }
        public virtual bool Supported { get; set; }
        public virtual bool Visible { get; set; }
        public event EventHandler CommandChanged;
        public virtual void Invoke();
        public virtual void Invoke(object arg);
        protected virtual void OnCommandChanged(EventArgs e);
        public override string ToString();
    }
    public enum SelectionTypes {
        Add = 64,
        Auto = 1,
        Click = 16,
        MouseDown = 4,
        MouseUp = 8,
        Normal = 1,
        Primary = 16,
        Remove = 128,
        Replace = 2,
        Toggle = 32,
        Valid = 31,
    }
    public class ServiceContainer : IDisposable, IServiceContainer, IServiceProvider {
        public ServiceContainer();
        public ServiceContainer(IServiceProvider parentProvider);
        protected virtual Type[] DefaultServices { get; }
        public void AddService(Type serviceType, ServiceCreatorCallback callback);
        public virtual void AddService(Type serviceType, ServiceCreatorCallback callback, bool promote);
        public void AddService(Type serviceType, object serviceInstance);
        public virtual void AddService(Type serviceType, object serviceInstance, bool promote);
        public void Dispose();
        protected virtual void Dispose(bool disposing);
        public virtual object GetService(Type serviceType);
        public void RemoveService(Type serviceType);
        public virtual void RemoveService(Type serviceType, bool promote);
    }
    public delegate object ServiceCreatorCallback(IServiceContainer container, Type serviceType);
    public class StandardCommands {
        public static readonly CommandID AlignBottom;
        public static readonly CommandID AlignHorizontalCenters;
        public static readonly CommandID AlignLeft;
        public static readonly CommandID AlignRight;
        public static readonly CommandID AlignToGrid;
        public static readonly CommandID AlignTop;
        public static readonly CommandID AlignVerticalCenters;
        public static readonly CommandID ArrangeBottom;
        public static readonly CommandID ArrangeIcons;
        public static readonly CommandID ArrangeRight;
        public static readonly CommandID BringForward;
        public static readonly CommandID BringToFront;
        public static readonly CommandID CenterHorizontally;
        public static readonly CommandID CenterVertically;
        public static readonly CommandID Copy;
        public static readonly CommandID Cut;
        public static readonly CommandID Delete;
        public static readonly CommandID DocumentOutline;
        public static readonly CommandID F1Help;
        public static readonly CommandID Group;
        public static readonly CommandID HorizSpaceConcatenate;
        public static readonly CommandID HorizSpaceDecrease;
        public static readonly CommandID HorizSpaceIncrease;
        public static readonly CommandID HorizSpaceMakeEqual;
        public static readonly CommandID LineupIcons;
        public static readonly CommandID LockControls;
        public static readonly CommandID MultiLevelRedo;
        public static readonly CommandID MultiLevelUndo;
        public static readonly CommandID Paste;
        public static readonly CommandID Properties;
        public static readonly CommandID PropertiesWindow;
        public static readonly CommandID Redo;
        public static readonly CommandID Replace;
        public static readonly CommandID SelectAll;
        public static readonly CommandID SendBackward;
        public static readonly CommandID SendToBack;
        public static readonly CommandID ShowGrid;
        public static readonly CommandID ShowLargeIcons;
        public static readonly CommandID SizeToControl;
        public static readonly CommandID SizeToControlHeight;
        public static readonly CommandID SizeToControlWidth;
        public static readonly CommandID SizeToFit;
        public static readonly CommandID SizeToGrid;
        public static readonly CommandID SnapToGrid;
        public static readonly CommandID TabOrder;
        public static readonly CommandID Undo;
        public static readonly CommandID Ungroup;
        public static readonly CommandID VerbFirst;
        public static readonly CommandID VerbLast;
        public static readonly CommandID VertSpaceConcatenate;
        public static readonly CommandID VertSpaceDecrease;
        public static readonly CommandID VertSpaceIncrease;
        public static readonly CommandID VertSpaceMakeEqual;
        public static readonly CommandID ViewCode;
        public static readonly CommandID ViewGrid;
        public StandardCommands();
    }
    public class StandardToolWindows {
        public static readonly Guid ObjectBrowser;
        public static readonly Guid OutputWindow;
        public static readonly Guid ProjectExplorer;
        public static readonly Guid PropertyBrowser;
        public static readonly Guid RelatedLinks;
        public static readonly Guid ServerExplorer;
        public static readonly Guid TaskList;
        public static readonly Guid Toolbox;
        public StandardToolWindows();
    }
    public abstract class TypeDescriptionProviderService {
        protected TypeDescriptionProviderService();
        public abstract TypeDescriptionProvider GetProvider(object instance);
        public abstract TypeDescriptionProvider GetProvider(Type type);
    }
    public enum ViewTechnology {
        Default = 2,
        Passthrough = 0,
        WindowsForms = 1,
    }
}
namespace System.ComponentModel.Design.Serialization {
    public abstract class ComponentSerializationService {
        protected ComponentSerializationService();
        public abstract SerializationStore CreateStore();
        public abstract ICollection Deserialize(SerializationStore store);
        public abstract ICollection Deserialize(SerializationStore store, IContainer container);
        public void DeserializeTo(SerializationStore store, IContainer container);
        public void DeserializeTo(SerializationStore store, IContainer container, bool validateRecycledTypes);
        public abstract void DeserializeTo(SerializationStore store, IContainer container, bool validateRecycledTypes, bool applyDefaults);
        public abstract SerializationStore LoadStore(Stream stream);
        public abstract void Serialize(SerializationStore store, object value);
        public abstract void SerializeAbsolute(SerializationStore store, object value);
        public abstract void SerializeMember(SerializationStore store, object owningObject, MemberDescriptor member);
        public abstract void SerializeMemberAbsolute(SerializationStore store, object owningObject, MemberDescriptor member);
    }
    public sealed class ContextStack {
        public ContextStack();
        public object Current { get; }
        public object this[int level] { get; }
        public object this[Type type] { get; }
        public void Append(object context);
        public object Pop();
        public void Push(object context);
    }
    public sealed class DefaultSerializationProviderAttribute : Attribute {
        public DefaultSerializationProviderAttribute(string providerTypeName);
        public DefaultSerializationProviderAttribute(Type providerType);
        public string ProviderTypeName { get; }
    }
    public abstract class DesignerLoader {
        protected DesignerLoader();
        public virtual bool Loading { get; }
        public abstract void BeginLoad(IDesignerLoaderHost host);
        public abstract void Dispose();
        public virtual void Flush();
    }
    public sealed class DesignerSerializerAttribute : Attribute {
        public DesignerSerializerAttribute(string serializerTypeName, string baseSerializerTypeName);
        public DesignerSerializerAttribute(string serializerTypeName, Type baseSerializerType);
        public DesignerSerializerAttribute(Type serializerType, Type baseSerializerType);
        public string SerializerBaseTypeName { get; }
        public string SerializerTypeName { get; }
        public override object TypeId { get; }
    }
    public interface IDesignerLoaderHost : IDesignerHost, IServiceContainer, IServiceProvider {
        void EndLoad(string baseClassName, bool successful, ICollection errorCollection);
        void Reload();
    }
    public interface IDesignerLoaderHost2 : IDesignerHost, IDesignerLoaderHost, IServiceContainer, IServiceProvider {
        bool CanReloadWithErrors { get; set; }
        bool IgnoreErrorsDuringReload { get; set; }
    }
    public interface IDesignerLoaderService {
        void AddLoadDependency();
        void DependentLoadComplete(bool successful, ICollection errorCollection);
        bool Reload();
    }
    public interface IDesignerSerializationManager : IServiceProvider {
        ContextStack Context { get; }
        PropertyDescriptorCollection Properties { get; }
        event ResolveNameEventHandler ResolveName;
        event EventHandler SerializationComplete;
        void AddSerializationProvider(IDesignerSerializationProvider provider);
        object CreateInstance(Type type, ICollection arguments, string name, bool addToContainer);
        object GetInstance(string name);
        string GetName(object value);
        object GetSerializer(Type objectType, Type serializerType);
        Type GetType(string typeName);
        void RemoveSerializationProvider(IDesignerSerializationProvider provider);
        void ReportError(object errorInformation);
        void SetName(object instance, string name);
    }
    public interface IDesignerSerializationProvider {
        object GetSerializer(IDesignerSerializationManager manager, object currentSerializer, Type objectType, Type serializerType);
    }
    public interface IDesignerSerializationService {
        ICollection Deserialize(object serializationData);
        object Serialize(ICollection objects);
    }
    public interface INameCreationService {
        string CreateName(IContainer container, Type dataType);
        bool IsValidName(string name);
        void ValidateName(string name);
    }
    public sealed class InstanceDescriptor {
        public InstanceDescriptor(MemberInfo member, ICollection arguments);
        public InstanceDescriptor(MemberInfo member, ICollection arguments, bool isComplete);
        public ICollection Arguments { get; }
        public bool IsComplete { get; }
        public MemberInfo MemberInfo { get; }
        public object Invoke();
    }
    public struct MemberRelationship {
        public static readonly MemberRelationship Empty;
        public MemberRelationship(object owner, MemberDescriptor member);
        public bool IsEmpty { get; }
        public MemberDescriptor Member { get; }
        public object Owner { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
        public static bool operator ==(MemberRelationship left, MemberRelationship right);
        public static bool operator !=(MemberRelationship left, MemberRelationship right);
    }
    public abstract class MemberRelationshipService {
        protected MemberRelationshipService();
        public MemberRelationship this[MemberRelationship source] { get; set; }
        public MemberRelationship this[object sourceOwner, MemberDescriptor sourceMember] { get; set; }
        protected virtual MemberRelationship GetRelationship(MemberRelationship source);
        protected virtual void SetRelationship(MemberRelationship source, MemberRelationship relationship);
        public abstract bool SupportsRelationship(MemberRelationship source, MemberRelationship relationship);
    }
    public class ResolveNameEventArgs : EventArgs {
        public ResolveNameEventArgs(string name);
        public string Name { get; }
        public object Value { get; set; }
    }
    public delegate void ResolveNameEventHandler(object sender, ResolveNameEventArgs e);
    public sealed class RootDesignerSerializerAttribute : Attribute {
        public RootDesignerSerializerAttribute(string serializerTypeName, string baseSerializerTypeName, bool reloadable);
        public RootDesignerSerializerAttribute(string serializerTypeName, Type baseSerializerType, bool reloadable);
        public RootDesignerSerializerAttribute(Type serializerType, Type baseSerializerType, bool reloadable);
        public bool Reloadable { get; }
        public string SerializerBaseTypeName { get; }
        public string SerializerTypeName { get; }
        public override object TypeId { get; }
    }
    public abstract class SerializationStore : IDisposable {
        protected SerializationStore();
        public abstract ICollection Errors { get; }
        public abstract void Close();
        protected virtual void Dispose(bool disposing);
        public abstract void Save(Stream stream);
        void System.IDisposable.Dispose();
    }
}
namespace System.Configuration.Assemblies {
    public enum AssemblyHashAlgorithm {
        MD5 = 32771,
        None = 0,
        SHA1 = 32772,
        SHA256 = 32780,
        SHA384 = 32781,
        SHA512 = 32782,
    }
    public enum AssemblyVersionCompatibility {
        SameDomain = 3,
        SameMachine = 1,
        SameProcess = 2,
    }
}
namespace System.Data {
    public enum AcceptRejectRule {
        Cascade = 1,
        None = 0,
    }
    public enum CommandBehavior {
        CloseConnection = 32,
        Default = 0,
        KeyInfo = 4,
        SchemaOnly = 2,
        SequentialAccess = 16,
        SingleResult = 1,
        SingleRow = 8,
    }
    public enum CommandType {
        StoredProcedure = 4,
        TableDirect = 512,
        Text = 1,
    }
    public enum ConflictOption {
        CompareAllSearchableValues = 1,
        CompareRowVersion = 2,
        OverwriteChanges = 3,
    }
    public enum ConnectionState {
        Broken = 16,
        Closed = 0,
        Connecting = 2,
        Executing = 4,
        Fetching = 8,
        Open = 1,
    }
    public abstract class Constraint {
        protected Constraint();
        public virtual string ConstraintName { get; set; }
        public PropertyCollection ExtendedProperties { get; }
        public abstract DataTable Table { get; }
        protected virtual DataSet _DataSet { get; }
        protected void CheckStateForProperty();
        protected internal void SetDataSet(DataSet dataSet);
        public override string ToString();
    }
    public sealed class ConstraintCollection : InternalDataCollectionBase {
        protected override ArrayList List { get; }
        public Constraint this[int index] { get; }
        public Constraint this[string name] { get; }
        public event CollectionChangeEventHandler CollectionChanged;
        public void Add(Constraint constraint);
        public Constraint Add(string name, DataColumn column, bool primaryKey);
        public Constraint Add(string name, DataColumn primaryKeyColumn, DataColumn foreignKeyColumn);
        public Constraint Add(string name, DataColumn[] columns, bool primaryKey);
        public Constraint Add(string name, DataColumn[] primaryKeyColumns, DataColumn[] foreignKeyColumns);
        public void AddRange(Constraint[] constraints);
        public bool CanRemove(Constraint constraint);
        public void Clear();
        public bool Contains(string name);
        public void CopyTo(Constraint[] array, int index);
        public int IndexOf(Constraint constraint);
        public int IndexOf(string constraintName);
        public void Remove(Constraint constraint);
        public void Remove(string name);
        public void RemoveAt(int index);
    }
    public class ConstraintException : DataException {
        public ConstraintException();
        protected ConstraintException(SerializationInfo info, StreamingContext context);
        public ConstraintException(string s);
        public ConstraintException(string message, Exception innerException);
    }
    public class DataColumn : MarshalByValueComponent {
        public DataColumn();
        public DataColumn(string columnName);
        public DataColumn(string columnName, Type dataType);
        public DataColumn(string columnName, Type dataType, string expr);
        public DataColumn(string columnName, Type dataType, string expr, MappingType type);
        public bool AllowDBNull { get; set; }
        public bool AutoIncrement { get; set; }
        public long AutoIncrementSeed { get; set; }
        public long AutoIncrementStep { get; set; }
        public string Caption { get; set; }
        public virtual MappingType ColumnMapping { get; set; }
        public string ColumnName { get; set; }
        public Type DataType { get; set; }
        public DataSetDateTime DateTimeMode { get; set; }
        public object DefaultValue { get; set; }
        public string Expression { get; set; }
        public PropertyCollection ExtendedProperties { get; }
        public int MaxLength { get; set; }
        public string Namespace { get; set; }
        public int Ordinal { get; }
        public string Prefix { get; set; }
        public bool ReadOnly { get; set; }
        public DataTable Table { get; }
        public bool Unique { get; set; }
        protected internal void CheckNotAllowNull();
        protected void CheckUnique();
        protected virtual void OnPropertyChanging(PropertyChangedEventArgs pcevent);
        protected internal void RaisePropertyChanging(string name);
        public void SetOrdinal(int ordinal);
        public override string ToString();
    }
    public class DataColumnChangeEventArgs : EventArgs {
        public DataColumnChangeEventArgs(DataRow row, DataColumn column, object value);
        public DataColumn Column { get; }
        public object ProposedValue { get; set; }
        public DataRow Row { get; }
    }
    public delegate void DataColumnChangeEventHandler(object sender, DataColumnChangeEventArgs e);
    public sealed class DataColumnCollection : InternalDataCollectionBase {
        protected override ArrayList List { get; }
        public DataColumn this[int index] { get; }
        public DataColumn this[string name] { get; }
        public event CollectionChangeEventHandler CollectionChanged;
        public DataColumn Add();
        public void Add(DataColumn column);
        public DataColumn Add(string columnName);
        public DataColumn Add(string columnName, Type type);
        public DataColumn Add(string columnName, Type type, string expression);
        public void AddRange(DataColumn[] columns);
        public bool CanRemove(DataColumn column);
        public void Clear();
        public bool Contains(string name);
        public void CopyTo(DataColumn[] array, int index);
        public int IndexOf(DataColumn column);
        public int IndexOf(string columnName);
        public void Remove(DataColumn column);
        public void Remove(string name);
        public void RemoveAt(int index);
    }
    public class DataException : SystemException {
        public DataException();
        protected DataException(SerializationInfo info, StreamingContext context);
        public DataException(string s);
        public DataException(string s, Exception innerException);
    }
    public class DataRelation {
        public DataRelation(string relationName, DataColumn parentColumn, DataColumn childColumn);
        public DataRelation(string relationName, DataColumn parentColumn, DataColumn childColumn, bool createConstraints);
        public DataRelation(string relationName, DataColumn[] parentColumns, DataColumn[] childColumns);
        public DataRelation(string relationName, DataColumn[] parentColumns, DataColumn[] childColumns, bool createConstraints);
        public DataRelation(string relationName, string parentTableName, string parentTableNamespace, string childTableName, string childTableNamespace, string[] parentColumnNames, string[] childColumnNames, bool nested);
        public DataRelation(string relationName, string parentTableName, string childTableName, string[] parentColumnNames, string[] childColumnNames, bool nested);
        public virtual DataColumn[] ChildColumns { get; }
        public virtual ForeignKeyConstraint ChildKeyConstraint { get; }
        public virtual DataTable ChildTable { get; }
        public virtual DataSet DataSet { get; }
        public PropertyCollection ExtendedProperties { get; }
        public virtual bool Nested { get; set; }
        public virtual DataColumn[] ParentColumns { get; }
        public virtual UniqueConstraint ParentKeyConstraint { get; }
        public virtual DataTable ParentTable { get; }
        public virtual string RelationName { get; set; }
        protected void CheckStateForProperty();
        protected internal void OnPropertyChanging(PropertyChangedEventArgs pcevent);
        protected internal void RaisePropertyChanging(string name);
        public override string ToString();
    }
    public abstract class DataRelationCollection : InternalDataCollectionBase {
        protected DataRelationCollection();
        public abstract DataRelation this[int index] { get; }
        public abstract DataRelation this[string name] { get; }
        public event CollectionChangeEventHandler CollectionChanged;
        public virtual DataRelation Add(DataColumn parentColumn, DataColumn childColumn);
        public virtual DataRelation Add(DataColumn[] parentColumns, DataColumn[] childColumns);
        public void Add(DataRelation relation);
        public virtual DataRelation Add(string name, DataColumn parentColumn, DataColumn childColumn);
        public virtual DataRelation Add(string name, DataColumn parentColumn, DataColumn childColumn, bool createConstraints);
        public virtual DataRelation Add(string name, DataColumn[] parentColumns, DataColumn[] childColumns);
        public virtual DataRelation Add(string name, DataColumn[] parentColumns, DataColumn[] childColumns, bool createConstraints);
        protected virtual void AddCore(DataRelation relation);
        public virtual void AddRange(DataRelation[] relations);
        public virtual bool CanRemove(DataRelation relation);
        public virtual void Clear();
        public virtual bool Contains(string name);
        public void CopyTo(DataRelation[] array, int index);
        protected abstract DataSet GetDataSet();
        public virtual int IndexOf(DataRelation relation);
        public virtual int IndexOf(string relationName);
        protected virtual void OnCollectionChanged(CollectionChangeEventArgs ccevent);
        protected virtual void OnCollectionChanging(CollectionChangeEventArgs ccevent);
        public void Remove(DataRelation relation);
        public void Remove(string name);
        public void RemoveAt(int index);
        protected virtual void RemoveCore(DataRelation relation);
    }
    public class DataRow {
        protected internal DataRow(DataRowBuilder builder);
        public bool HasErrors { get; }
        public object[] ItemArray { get; set; }
        public string RowError { get; set; }
        public DataRowState RowState { get; }
        public DataTable Table { get; }
        public object this[DataColumn column, DataRowVersion version] { get; }
        public object this[DataColumn column] { get; set; }
        public object this[int columnIndex, DataRowVersion version] { get; }
        public object this[int columnIndex] { get; set; }
        public object this[string columnName, DataRowVersion version] { get; }
        public object this[string columnName] { get; set; }
        public void AcceptChanges();
        public void BeginEdit();
        public void CancelEdit();
        public void ClearErrors();
        public void Delete();
        public void EndEdit();
        public DataRow[] GetChildRows(DataRelation relation);
        public DataRow[] GetChildRows(DataRelation relation, DataRowVersion version);
        public DataRow[] GetChildRows(string relationName);
        public DataRow[] GetChildRows(string relationName, DataRowVersion version);
        public string GetColumnError(DataColumn column);
        public string GetColumnError(int columnIndex);
        public string GetColumnError(string columnName);
        public DataColumn[] GetColumnsInError();
        public DataRow GetParentRow(DataRelation relation);
        public DataRow GetParentRow(DataRelation relation, DataRowVersion version);
        public DataRow GetParentRow(string relationName);
        public DataRow GetParentRow(string relationName, DataRowVersion version);
        public DataRow[] GetParentRows(DataRelation relation);
        public DataRow[] GetParentRows(DataRelation relation, DataRowVersion version);
        public DataRow[] GetParentRows(string relationName);
        public DataRow[] GetParentRows(string relationName, DataRowVersion version);
        public bool HasVersion(DataRowVersion version);
        public bool IsNull(DataColumn column);
        public bool IsNull(DataColumn column, DataRowVersion version);
        public bool IsNull(int columnIndex);
        public bool IsNull(string columnName);
        public void RejectChanges();
        public void SetAdded();
        public void SetColumnError(DataColumn column, string error);
        public void SetColumnError(int columnIndex, string error);
        public void SetColumnError(string columnName, string error);
        public void SetModified();
        protected void SetNull(DataColumn column);
        public void SetParentRow(DataRow parentRow);
        public void SetParentRow(DataRow parentRow, DataRelation relation);
    }
    public enum DataRowAction {
        Add = 16,
        Change = 2,
        ChangeCurrentAndOriginal = 64,
        ChangeOriginal = 32,
        Commit = 8,
        Delete = 1,
        Nothing = 0,
        Rollback = 4,
    }
    public sealed class DataRowBuilder {
    }
    public class DataRowChangeEventArgs : EventArgs {
        public DataRowChangeEventArgs(DataRow row, DataRowAction action);
        public DataRowAction Action { get; }
        public DataRow Row { get; }
    }
    public delegate void DataRowChangeEventHandler(object sender, DataRowChangeEventArgs e);
    public sealed class DataRowCollection : InternalDataCollectionBase {
        public override int Count { get; }
        public DataRow this[int index] { get; }
        public void Add(DataRow row);
        public DataRow Add(params object[] values);
        public void Clear();
        public bool Contains(object key);
        public bool Contains(object[] keys);
        public override void CopyTo(Array ar, int index);
        public void CopyTo(DataRow[] array, int index);
        public DataRow Find(object key);
        public DataRow Find(object[] keys);
        public override IEnumerator GetEnumerator();
        public int IndexOf(DataRow row);
        public void InsertAt(DataRow row, int pos);
        public void Remove(DataRow row);
        public void RemoveAt(int index);
    }
    public enum DataRowState {
        Added = 4,
        Deleted = 8,
        Detached = 1,
        Modified = 16,
        Unchanged = 2,
    }
    public enum DataRowVersion {
        Current = 512,
        Default = 1536,
        Original = 256,
        Proposed = 1024,
    }
    public class DataRowView : ICustomTypeDescriptor, IDataErrorInfo, IEditableObject, INotifyPropertyChanged {
        public DataView DataView { get; }
        public bool IsEdit { get; }
        public bool IsNew { get; }
        public DataRow Row { get; }
        public DataRowVersion RowVersion { get; }
        string System.ComponentModel.IDataErrorInfo.Error { get; }
        string System.ComponentModel.IDataErrorInfo.this[string colName] { get; }
        public object this[int ndx] { get; set; }
        public object this[string property] { get; set; }
        public event PropertyChangedEventHandler PropertyChanged;
        public void BeginEdit();
        public void CancelEdit();
        public DataView CreateChildView(DataRelation relation);
        public DataView CreateChildView(DataRelation relation, bool followParent);
        public DataView CreateChildView(string relationName);
        public DataView CreateChildView(string relationName, bool followParent);
        public void Delete();
        public void EndEdit();
        public override bool Equals(object other);
        public override int GetHashCode();
        AttributeCollection System.ComponentModel.ICustomTypeDescriptor.GetAttributes();
        string System.ComponentModel.ICustomTypeDescriptor.GetClassName();
        string System.ComponentModel.ICustomTypeDescriptor.GetComponentName();
        TypeConverter System.ComponentModel.ICustomTypeDescriptor.GetConverter();
        EventDescriptor System.ComponentModel.ICustomTypeDescriptor.GetDefaultEvent();
        PropertyDescriptor System.ComponentModel.ICustomTypeDescriptor.GetDefaultProperty();
        object System.ComponentModel.ICustomTypeDescriptor.GetEditor(Type editorBaseType);
        EventDescriptorCollection System.ComponentModel.ICustomTypeDescriptor.GetEvents();
        EventDescriptorCollection System.ComponentModel.ICustomTypeDescriptor.GetEvents(Attribute[] attributes);
        PropertyDescriptorCollection System.ComponentModel.ICustomTypeDescriptor.GetProperties();
        PropertyDescriptorCollection System.ComponentModel.ICustomTypeDescriptor.GetProperties(Attribute[] attributes);
        object System.ComponentModel.ICustomTypeDescriptor.GetPropertyOwner(PropertyDescriptor pd);
    }
    public class DataSet : MarshalByValueComponent, IListSource, ISerializable, ISupportInitialize, ISupportInitializeNotification, IXmlSerializable {
        public DataSet();
        protected DataSet(SerializationInfo info, StreamingContext context);
        protected DataSet(SerializationInfo info, StreamingContext context, bool ConstructSchema);
        public DataSet(string dataSetName);
        public bool CaseSensitive { get; set; }
        public string DataSetName { get; set; }
        public DataViewManager DefaultViewManager { get; }
        public bool EnforceConstraints { get; set; }
        public PropertyCollection ExtendedProperties { get; }
        public bool HasErrors { get; }
        public bool IsInitialized { get; }
        public CultureInfo Locale { get; set; }
        public string Namespace { get; set; }
        public string Prefix { get; set; }
        public DataRelationCollection Relations { get; }
        public SerializationFormat RemotingFormat { get; set; }
        public virtual SchemaSerializationMode SchemaSerializationMode { get; set; }
        public override ISite Site { get; set; }
        bool System.ComponentModel.IListSource.ContainsListCollection { get; }
        public DataTableCollection Tables { get; }
        public event EventHandler Initialized;
        public event MergeFailedEventHandler MergeFailed;
        public void AcceptChanges();
        public void BeginInit();
        public void Clear();
        public virtual DataSet Clone();
        public DataSet Copy();
        public DataTableReader CreateDataReader();
        public DataTableReader CreateDataReader(params DataTable[] dataTables);
        protected SchemaSerializationMode DetermineSchemaSerializationMode(SerializationInfo info, StreamingContext context);
        protected SchemaSerializationMode DetermineSchemaSerializationMode(XmlReader reader);
        public void EndInit();
        public DataSet GetChanges();
        public DataSet GetChanges(DataRowState rowStates);
        public static XmlSchemaComplexType GetDataSetSchema(XmlSchemaSet schemaSet);
        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
        protected virtual XmlSchema GetSchemaSerializable();
        protected void GetSerializationData(SerializationInfo info, StreamingContext context);
        public string GetXml();
        public string GetXmlSchema();
        public bool HasChanges();
        public bool HasChanges(DataRowState rowStates);
        public void InferXmlSchema(Stream stream, string[] nsArray);
        public void InferXmlSchema(TextReader reader, string[] nsArray);
        public void InferXmlSchema(string fileName, string[] nsArray);
        public void InferXmlSchema(XmlReader reader, string[] nsArray);
        protected virtual void InitializeDerivedDataSet();
        protected bool IsBinarySerialized(SerializationInfo info, StreamingContext context);
        public void Load(IDataReader reader, LoadOption loadOption, params DataTable[] tables);
        public virtual void Load(IDataReader reader, LoadOption loadOption, FillErrorEventHandler errorHandler, params DataTable[] tables);
        public void Load(IDataReader reader, LoadOption loadOption, params string[] tables);
        public void Merge(DataRow[] rows);
        public void Merge(DataRow[] rows, bool preserveChanges, MissingSchemaAction missingSchemaAction);
        public void Merge(DataSet dataSet);
        public void Merge(DataSet dataSet, bool preserveChanges);
        public void Merge(DataSet dataSet, bool preserveChanges, MissingSchemaAction missingSchemaAction);
        public void Merge(DataTable table);
        public void Merge(DataTable table, bool preserveChanges, MissingSchemaAction missingSchemaAction);
        protected virtual void OnPropertyChanging(PropertyChangedEventArgs pcevent);
        protected virtual void OnRemoveRelation(DataRelation relation);
        protected internal virtual void OnRemoveTable(DataTable table);
        protected internal void RaisePropertyChanging(string name);
        public XmlReadMode ReadXml(Stream stream);
        public XmlReadMode ReadXml(Stream stream, XmlReadMode mode);
        public XmlReadMode ReadXml(TextReader reader);
        public XmlReadMode ReadXml(TextReader reader, XmlReadMode mode);
        public XmlReadMode ReadXml(string fileName);
        public XmlReadMode ReadXml(string fileName, XmlReadMode mode);
        public XmlReadMode ReadXml(XmlReader reader);
        public XmlReadMode ReadXml(XmlReader reader, XmlReadMode mode);
        public void ReadXmlSchema(Stream stream);
        public void ReadXmlSchema(TextReader reader);
        public void ReadXmlSchema(string fileName);
        public void ReadXmlSchema(XmlReader reader);
        protected virtual void ReadXmlSerializable(XmlReader reader);
        public virtual void RejectChanges();
        public virtual void Reset();
        protected virtual bool ShouldSerializeRelations();
        protected virtual bool ShouldSerializeTables();
        IList System.ComponentModel.IListSource.GetList();
        XmlSchema System.Xml.Serialization.IXmlSerializable.GetSchema();
        void System.Xml.Serialization.IXmlSerializable.ReadXml(XmlReader reader);
        void System.Xml.Serialization.IXmlSerializable.WriteXml(XmlWriter writer);
        public void WriteXml(Stream stream);
        public void WriteXml(Stream stream, XmlWriteMode mode);
        public void WriteXml(TextWriter writer);
        public void WriteXml(TextWriter writer, XmlWriteMode mode);
        public void WriteXml(string fileName);
        public void WriteXml(string fileName, XmlWriteMode mode);
        public void WriteXml(XmlWriter writer);
        public void WriteXml(XmlWriter writer, XmlWriteMode mode);
        public void WriteXmlSchema(Stream stream);
        public void WriteXmlSchema(Stream stream, Converter<Type, string> multipleTargetConverter);
        public void WriteXmlSchema(TextWriter writer);
        public void WriteXmlSchema(TextWriter writer, Converter<Type, string> multipleTargetConverter);
        public void WriteXmlSchema(string fileName);
        public void WriteXmlSchema(string fileName, Converter<Type, string> multipleTargetConverter);
        public void WriteXmlSchema(XmlWriter writer);
        public void WriteXmlSchema(XmlWriter writer, Converter<Type, string> multipleTargetConverter);
    }
    public enum DataSetDateTime {
        Local = 1,
        Unspecified = 2,
        UnspecifiedLocal = 3,
        Utc = 4,
    }
    public class DataSysDescriptionAttribute : DescriptionAttribute {
        public DataSysDescriptionAttribute(string description);
        public override string Description { get; }
    }
    public class DataTable : MarshalByValueComponent, IListSource, ISerializable, ISupportInitialize, ISupportInitializeNotification, IXmlSerializable {
        protected internal bool fInitInProgress;
        public DataTable();
        protected DataTable(SerializationInfo info, StreamingContext context);
        public DataTable(string tableName);
        public DataTable(string tableName, string tableNamespace);
        public bool CaseSensitive { get; set; }
        public DataRelationCollection ChildRelations { get; }
        public DataColumnCollection Columns { get; }
        public ConstraintCollection Constraints { get; }
        public DataSet DataSet { get; }
        public DataView DefaultView { get; }
        public string DisplayExpression { get; set; }
        public PropertyCollection ExtendedProperties { get; }
        public bool HasErrors { get; }
        public bool IsInitialized { get; }
        public CultureInfo Locale { get; set; }
        public int MinimumCapacity { get; set; }
        public string Namespace { get; set; }
        public DataRelationCollection ParentRelations { get; }
        public string Prefix { get; set; }
        public DataColumn[] PrimaryKey { get; set; }
        public SerializationFormat RemotingFormat { get; set; }
        public DataRowCollection Rows { get; }
        public override ISite Site { get; set; }
        bool System.ComponentModel.IListSource.ContainsListCollection { get; }
        public string TableName { get; set; }
        public event DataColumnChangeEventHandler ColumnChanged;
        public event DataColumnChangeEventHandler ColumnChanging;
        public event EventHandler Initialized;
        public event DataRowChangeEventHandler RowChanged;
        public event DataRowChangeEventHandler RowChanging;
        public event DataRowChangeEventHandler RowDeleted;
        public event DataRowChangeEventHandler RowDeleting;
        public event DataTableClearEventHandler TableCleared;
        public event DataTableClearEventHandler TableClearing;
        public event DataTableNewRowEventHandler TableNewRow;
        public void AcceptChanges();
        public virtual void BeginInit();
        public void BeginLoadData();
        public void Clear();
        public virtual DataTable Clone();
        public object Compute(string expression, string filter);
        public DataTable Copy();
        public DataTableReader CreateDataReader();
        protected virtual DataTable CreateInstance();
        public virtual void EndInit();
        public void EndLoadData();
        public DataTable GetChanges();
        public DataTable GetChanges(DataRowState rowStates);
        public static XmlSchemaComplexType GetDataTableSchema(XmlSchemaSet schemaSet);
        public DataRow[] GetErrors();
        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
        protected virtual Type GetRowType();
        protected virtual XmlSchema GetSchema();
        public void ImportRow(DataRow row);
        public void Load(IDataReader reader);
        public void Load(IDataReader reader, LoadOption loadOption);
        public virtual void Load(IDataReader reader, LoadOption loadOption, FillErrorEventHandler errorHandler);
        public DataRow LoadDataRow(object[] values, bool fAcceptChanges);
        public DataRow LoadDataRow(object[] values, LoadOption loadOption);
        public void Merge(DataTable table);
        public void Merge(DataTable table, bool preserveChanges);
        public void Merge(DataTable table, bool preserveChanges, MissingSchemaAction missingSchemaAction);
        public DataRow NewRow();
        protected internal DataRow[] NewRowArray(int size);
        protected virtual DataRow NewRowFromBuilder(DataRowBuilder builder);
        protected internal virtual void OnColumnChanged(DataColumnChangeEventArgs e);
        protected internal virtual void OnColumnChanging(DataColumnChangeEventArgs e);
        protected virtual void OnPropertyChanging(PropertyChangedEventArgs pcevent);
        protected virtual void OnRemoveColumn(DataColumn column);
        protected virtual void OnRowChanged(DataRowChangeEventArgs e);
        protected virtual void OnRowChanging(DataRowChangeEventArgs e);
        protected virtual void OnRowDeleted(DataRowChangeEventArgs e);
        protected virtual void OnRowDeleting(DataRowChangeEventArgs e);
        protected virtual void OnTableCleared(DataTableClearEventArgs e);
        protected virtual void OnTableClearing(DataTableClearEventArgs e);
        protected virtual void OnTableNewRow(DataTableNewRowEventArgs e);
        public XmlReadMode ReadXml(Stream stream);
        public XmlReadMode ReadXml(TextReader reader);
        public XmlReadMode ReadXml(string fileName);
        public XmlReadMode ReadXml(XmlReader reader);
        public void ReadXmlSchema(Stream stream);
        public void ReadXmlSchema(TextReader reader);
        public void ReadXmlSchema(string fileName);
        public void ReadXmlSchema(XmlReader reader);
        protected virtual void ReadXmlSerializable(XmlReader reader);
        public void RejectChanges();
        public virtual void Reset();
        public DataRow[] Select();
        public DataRow[] Select(string filterExpression);
        public DataRow[] Select(string filterExpression, string sort);
        public DataRow[] Select(string filterExpression, string sort, DataViewRowState recordStates);
        IList System.ComponentModel.IListSource.GetList();
        XmlSchema System.Xml.Serialization.IXmlSerializable.GetSchema();
        void System.Xml.Serialization.IXmlSerializable.ReadXml(XmlReader reader);
        void System.Xml.Serialization.IXmlSerializable.WriteXml(XmlWriter writer);
        public override string ToString();
        public void WriteXml(Stream stream);
        public void WriteXml(Stream stream, bool writeHierarchy);
        public void WriteXml(Stream stream, XmlWriteMode mode);
        public void WriteXml(Stream stream, XmlWriteMode mode, bool writeHierarchy);
        public void WriteXml(TextWriter writer);
        public void WriteXml(TextWriter writer, bool writeHierarchy);
        public void WriteXml(TextWriter writer, XmlWriteMode mode);
        public void WriteXml(TextWriter writer, XmlWriteMode mode, bool writeHierarchy);
        public void WriteXml(string fileName);
        public void WriteXml(string fileName, bool writeHierarchy);
        public void WriteXml(string fileName, XmlWriteMode mode);
        public void WriteXml(string fileName, XmlWriteMode mode, bool writeHierarchy);
        public void WriteXml(XmlWriter writer);
        public void WriteXml(XmlWriter writer, bool writeHierarchy);
        public void WriteXml(XmlWriter writer, XmlWriteMode mode);
        public void WriteXml(XmlWriter writer, XmlWriteMode mode, bool writeHierarchy);
        public void WriteXmlSchema(Stream stream);
        public void WriteXmlSchema(Stream stream, bool writeHierarchy);
        public void WriteXmlSchema(TextWriter writer);
        public void WriteXmlSchema(TextWriter writer, bool writeHierarchy);
        public void WriteXmlSchema(string fileName);
        public void WriteXmlSchema(string fileName, bool writeHierarchy);
        public void WriteXmlSchema(XmlWriter writer);
        public void WriteXmlSchema(XmlWriter writer, bool writeHierarchy);
    }
    public sealed class DataTableClearEventArgs : EventArgs {
        public DataTableClearEventArgs(DataTable dataTable);
        public DataTable Table { get; }
        public string TableName { get; }
        public string TableNamespace { get; }
    }
    public delegate void DataTableClearEventHandler(object sender, DataTableClearEventArgs e);
    public sealed class DataTableCollection : InternalDataCollectionBase {
        protected override ArrayList List { get; }
        public DataTable this[int index] { get; }
        public DataTable this[string name, string tableNamespace] { get; }
        public DataTable this[string name] { get; }
        public event CollectionChangeEventHandler CollectionChanged;
        public event CollectionChangeEventHandler CollectionChanging;
        public DataTable Add();
        public void Add(DataTable table);
        public DataTable Add(string name);
        public DataTable Add(string name, string tableNamespace);
        public void AddRange(DataTable[] tables);
        public bool CanRemove(DataTable table);
        public void Clear();
        public bool Contains(string name);
        public bool Contains(string name, string tableNamespace);
        public void CopyTo(DataTable[] array, int index);
        public int IndexOf(DataTable table);
        public int IndexOf(string tableName);
        public int IndexOf(string tableName, string tableNamespace);
        public void Remove(DataTable table);
        public void Remove(string name);
        public void Remove(string name, string tableNamespace);
        public void RemoveAt(int index);
    }
    public sealed class DataTableNewRowEventArgs : EventArgs {
        public DataTableNewRowEventArgs(DataRow dataRow);
        public DataRow Row { get; }
    }
    public delegate void DataTableNewRowEventHandler(object sender, DataTableNewRowEventArgs e);
    public sealed class DataTableReader : DbDataReader {
        public DataTableReader(DataTable dataTable);
        public DataTableReader(DataTable[] dataTables);
        public override int Depth { get; }
        public override int FieldCount { get; }
        public override bool HasRows { get; }
        public override bool IsClosed { get; }
        public override int RecordsAffected { get; }
        public override object this[int ordinal] { get; }
        public override object this[string name] { get; }
        public override void Close();
        public override bool GetBoolean(int ordinal);
        public override byte GetByte(int ordinal);
        public override long GetBytes(int ordinal, long dataIndex, byte[] buffer, int bufferIndex, int length);
        public override char GetChar(int ordinal);
        public override long GetChars(int ordinal, long dataIndex, char[] buffer, int bufferIndex, int length);
        public override string GetDataTypeName(int ordinal);
        public override DateTime GetDateTime(int ordinal);
        public override decimal GetDecimal(int ordinal);
        public override double GetDouble(int ordinal);
        public override IEnumerator GetEnumerator();
        public override Type GetFieldType(int ordinal);
        public override float GetFloat(int ordinal);
        public override Guid GetGuid(int ordinal);
        public override short GetInt16(int ordinal);
        public override int GetInt32(int ordinal);
        public override long GetInt64(int ordinal);
        public override string GetName(int ordinal);
        public override int GetOrdinal(string name);
        public override Type GetProviderSpecificFieldType(int ordinal);
        public override object GetProviderSpecificValue(int ordinal);
        public override int GetProviderSpecificValues(object[] values);
        public override DataTable GetSchemaTable();
        public override string GetString(int ordinal);
        public override object GetValue(int ordinal);
        public override int GetValues(object[] values);
        public override bool IsDBNull(int ordinal);
        public override bool NextResult();
        public override bool Read();
    }
    public class DataView : MarshalByValueComponent, IBindingList, IBindingListView, ICollection, IEnumerable, IList, ISupportInitialize, ISupportInitializeNotification, ITypedList {
        public DataView();
        public DataView(DataTable table);
        public DataView(DataTable table, string RowFilter, string Sort, DataViewRowState RowState);
        public bool AllowDelete { get; set; }
        public bool AllowEdit { get; set; }
        public bool AllowNew { get; set; }
        public bool ApplyDefaultSort { get; set; }
        public int Count { get; }
        public DataViewManager DataViewManager { get; }
        public bool IsInitialized { get; }
        protected bool IsOpen { get; }
        public virtual string RowFilter { get; set; }
        public DataViewRowState RowStateFilter { get; set; }
        public string Sort { get; set; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        bool System.Collections.IList.IsFixedSize { get; }
        bool System.Collections.IList.IsReadOnly { get; }
        object System.Collections.IList.this[int recordIndex] { get; set; }
        bool System.ComponentModel.IBindingList.AllowEdit { get; }
        bool System.ComponentModel.IBindingList.AllowNew { get; }
        bool System.ComponentModel.IBindingList.AllowRemove { get; }
        bool System.ComponentModel.IBindingList.IsSorted { get; }
        ListSortDirection System.ComponentModel.IBindingList.SortDirection { get; }
        PropertyDescriptor System.ComponentModel.IBindingList.SortProperty { get; }
        bool System.ComponentModel.IBindingList.SupportsChangeNotification { get; }
        bool System.ComponentModel.IBindingList.SupportsSearching { get; }
        bool System.ComponentModel.IBindingList.SupportsSorting { get; }
        string System.ComponentModel.IBindingListView.Filter { get; set; }
        ListSortDescriptionCollection System.ComponentModel.IBindingListView.SortDescriptions { get; }
        bool System.ComponentModel.IBindingListView.SupportsAdvancedSorting { get; }
        bool System.ComponentModel.IBindingListView.SupportsFiltering { get; }
        public DataTable Table { get; set; }
        public DataRowView this[int recordIndex] { get; }
        public event EventHandler Initialized;
        public event ListChangedEventHandler ListChanged;
        public virtual DataRowView AddNew();
        public void BeginInit();
        protected void Close();
        protected virtual void ColumnCollectionChanged(object sender, CollectionChangeEventArgs e);
        public void CopyTo(Array array, int index);
        public void Delete(int index);
        protected override void Dispose(bool disposing);
        public void EndInit();
        public virtual bool Equals(DataView view);
        public int Find(object key);
        public int Find(object[] key);
        public DataRowView[] FindRows(object key);
        public DataRowView[] FindRows(object[] key);
        public IEnumerator GetEnumerator();
        protected virtual void IndexListChanged(object sender, ListChangedEventArgs e);
        protected virtual void OnListChanged(ListChangedEventArgs e);
        protected void Open();
        protected void Reset();
        int System.Collections.IList.Add(object value);
        void System.Collections.IList.Clear();
        bool System.Collections.IList.Contains(object value);
        int System.Collections.IList.IndexOf(object value);
        void System.Collections.IList.Insert(int index, object value);
        void System.Collections.IList.Remove(object value);
        void System.Collections.IList.RemoveAt(int index);
        void System.ComponentModel.IBindingList.AddIndex(PropertyDescriptor property);
        object System.ComponentModel.IBindingList.AddNew();
        void System.ComponentModel.IBindingList.ApplySort(PropertyDescriptor property, ListSortDirection direction);
        int System.ComponentModel.IBindingList.Find(PropertyDescriptor property, object key);
        void System.ComponentModel.IBindingList.RemoveIndex(PropertyDescriptor property);
        void System.ComponentModel.IBindingList.RemoveSort();
        void System.ComponentModel.IBindingListView.ApplySort(ListSortDescriptionCollection sorts);
        void System.ComponentModel.IBindingListView.RemoveFilter();
        PropertyDescriptorCollection System.ComponentModel.ITypedList.GetItemProperties(PropertyDescriptor[] listAccessors);
        string System.ComponentModel.ITypedList.GetListName(PropertyDescriptor[] listAccessors);
        public DataTable ToTable();
        public DataTable ToTable(bool distinct, params string[] columnNames);
        public DataTable ToTable(string tableName);
        public DataTable ToTable(string tableName, bool distinct, params string[] columnNames);
        protected void UpdateIndex();
        protected virtual void UpdateIndex(bool force);
    }
    public class DataViewManager : MarshalByValueComponent, IBindingList, ICollection, IEnumerable, IList, ITypedList {
        public DataViewManager();
        public DataViewManager(DataSet dataSet);
        public DataSet DataSet { get; set; }
        public string DataViewSettingCollectionString { get; set; }
        public DataViewSettingCollection DataViewSettings { get; }
        int System.Collections.ICollection.Count { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        bool System.Collections.IList.IsFixedSize { get; }
        bool System.Collections.IList.IsReadOnly { get; }
        object System.Collections.IList.this[int index] { get; set; }
        bool System.ComponentModel.IBindingList.AllowEdit { get; }
        bool System.ComponentModel.IBindingList.AllowNew { get; }
        bool System.ComponentModel.IBindingList.AllowRemove { get; }
        bool System.ComponentModel.IBindingList.IsSorted { get; }
        ListSortDirection System.ComponentModel.IBindingList.SortDirection { get; }
        PropertyDescriptor System.ComponentModel.IBindingList.SortProperty { get; }
        bool System.ComponentModel.IBindingList.SupportsChangeNotification { get; }
        bool System.ComponentModel.IBindingList.SupportsSearching { get; }
        bool System.ComponentModel.IBindingList.SupportsSorting { get; }
        public event ListChangedEventHandler ListChanged;
        public DataView CreateDataView(DataTable table);
        protected virtual void OnListChanged(ListChangedEventArgs e);
        protected virtual void RelationCollectionChanged(object sender, CollectionChangeEventArgs e);
        void System.Collections.ICollection.CopyTo(Array array, int index);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        int System.Collections.IList.Add(object value);
        void System.Collections.IList.Clear();
        bool System.Collections.IList.Contains(object value);
        int System.Collections.IList.IndexOf(object value);
        void System.Collections.IList.Insert(int index, object value);
        void System.Collections.IList.Remove(object value);
        void System.Collections.IList.RemoveAt(int index);
        void System.ComponentModel.IBindingList.AddIndex(PropertyDescriptor property);
        object System.ComponentModel.IBindingList.AddNew();
        void System.ComponentModel.IBindingList.ApplySort(PropertyDescriptor property, ListSortDirection direction);
        int System.ComponentModel.IBindingList.Find(PropertyDescriptor property, object key);
        void System.ComponentModel.IBindingList.RemoveIndex(PropertyDescriptor property);
        void System.ComponentModel.IBindingList.RemoveSort();
        PropertyDescriptorCollection System.ComponentModel.ITypedList.GetItemProperties(PropertyDescriptor[] listAccessors);
        string System.ComponentModel.ITypedList.GetListName(PropertyDescriptor[] listAccessors);
        protected virtual void TableCollectionChanged(object sender, CollectionChangeEventArgs e);
    }
    public enum DataViewRowState {
        Added = 4,
        CurrentRows = 22,
        Deleted = 8,
        ModifiedCurrent = 16,
        ModifiedOriginal = 32,
        None = 0,
        OriginalRows = 42,
        Unchanged = 2,
    }
    public class DataViewSetting {
        public bool ApplyDefaultSort { get; set; }
        public DataViewManager DataViewManager { get; }
        public string RowFilter { get; set; }
        public DataViewRowState RowStateFilter { get; set; }
        public string Sort { get; set; }
        public DataTable Table { get; }
    }
    public class DataViewSettingCollection : ICollection, IEnumerable {
        public virtual int Count { get; }
        public bool IsReadOnly { get; }
        public bool IsSynchronized { get; }
        public object SyncRoot { get; }
        public virtual DataViewSetting this[DataTable table] { get; set; }
        public virtual DataViewSetting this[int index] { get; set; }
        public virtual DataViewSetting this[string tableName] { get; }
        public void CopyTo(Array ar, int index);
        public void CopyTo(DataViewSetting[] ar, int index);
        public IEnumerator GetEnumerator();
    }
    public sealed class DBConcurrencyException : SystemException {
        public DBConcurrencyException();
        public DBConcurrencyException(string message);
        public DBConcurrencyException(string message, Exception inner);
        public DBConcurrencyException(string message, Exception inner, DataRow[] dataRows);
        public DataRow Row { get; set; }
        public int RowCount { get; }
        public void CopyToRows(DataRow[] array);
        public void CopyToRows(DataRow[] array, int arrayIndex);
        public override void GetObjectData(SerializationInfo si, StreamingContext context);
    }
    public enum DbType {
        AnsiString = 0,
        AnsiStringFixedLength = 22,
        Binary = 1,
        Boolean = 3,
        Byte = 2,
        Currency = 4,
        Date = 5,
        DateTime = 6,
        DateTime2 = 26,
        DateTimeOffset = 27,
        Decimal = 7,
        Double = 8,
        Guid = 9,
        Int16 = 10,
        Int32 = 11,
        Int64 = 12,
        Object = 13,
        SByte = 14,
        Single = 15,
        String = 16,
        StringFixedLength = 23,
        Time = 17,
        UInt16 = 18,
        UInt32 = 19,
        UInt64 = 20,
        VarNumeric = 21,
        Xml = 25,
    }
    public class DeletedRowInaccessibleException : DataException {
        public DeletedRowInaccessibleException();
        protected DeletedRowInaccessibleException(SerializationInfo info, StreamingContext context);
        public DeletedRowInaccessibleException(string s);
        public DeletedRowInaccessibleException(string message, Exception innerException);
    }
    public class DuplicateNameException : DataException {
        public DuplicateNameException();
        protected DuplicateNameException(SerializationInfo info, StreamingContext context);
        public DuplicateNameException(string s);
        public DuplicateNameException(string message, Exception innerException);
    }
    public class EvaluateException : InvalidExpressionException {
        public EvaluateException();
        protected EvaluateException(SerializationInfo info, StreamingContext context);
        public EvaluateException(string s);
        public EvaluateException(string message, Exception innerException);
    }
    public class FillErrorEventArgs : EventArgs {
        public FillErrorEventArgs(DataTable dataTable, object[] values);
        public bool Continue { get; set; }
        public DataTable DataTable { get; }
        public Exception Errors { get; set; }
        public object[] Values { get; }
    }
    public delegate void FillErrorEventHandler(object sender, FillErrorEventArgs e);
    public class ForeignKeyConstraint : Constraint {
        public ForeignKeyConstraint(DataColumn parentColumn, DataColumn childColumn);
        public ForeignKeyConstraint(DataColumn[] parentColumns, DataColumn[] childColumns);
        public ForeignKeyConstraint(string constraintName, DataColumn parentColumn, DataColumn childColumn);
        public ForeignKeyConstraint(string constraintName, DataColumn[] parentColumns, DataColumn[] childColumns);
        public ForeignKeyConstraint(string constraintName, string parentTableName, string parentTableNamespace, string[] parentColumnNames, string[] childColumnNames, AcceptRejectRule acceptRejectRule, Rule deleteRule, Rule updateRule);
        public ForeignKeyConstraint(string constraintName, string parentTableName, string[] parentColumnNames, string[] childColumnNames, AcceptRejectRule acceptRejectRule, Rule deleteRule, Rule updateRule);
        public virtual AcceptRejectRule AcceptRejectRule { get; set; }
        public virtual DataColumn[] Columns { get; }
        public virtual Rule DeleteRule { get; set; }
        public virtual DataColumn[] RelatedColumns { get; }
        public virtual DataTable RelatedTable { get; }
        public override DataTable Table { get; }
        public virtual Rule UpdateRule { get; set; }
        public override bool Equals(object key);
        public override int GetHashCode();
    }
    public interface IColumnMapping {
        string DataSetColumn { get; set; }
        string SourceColumn { get; set; }
    }
    public interface IColumnMappingCollection : ICollection, IEnumerable, IList {
        object this[string index] { get; set; }
        IColumnMapping Add(string sourceColumnName, string dataSetColumnName);
        bool Contains(string sourceColumnName);
        IColumnMapping GetByDataSetColumn(string dataSetColumnName);
        int IndexOf(string sourceColumnName);
        void RemoveAt(string sourceColumnName);
    }
    public interface IDataAdapter {
        MissingMappingAction MissingMappingAction { get; set; }
        MissingSchemaAction MissingSchemaAction { get; set; }
        ITableMappingCollection TableMappings { get; }
        int Fill(DataSet dataSet);
        DataTable[] FillSchema(DataSet dataSet, SchemaType schemaType);
        IDataParameter[] GetFillParameters();
        int Update(DataSet dataSet);
    }
    public interface IDataParameter {
        DbType DbType { get; set; }
        ParameterDirection Direction { get; set; }
        bool IsNullable { get; }
        string ParameterName { get; set; }
        string SourceColumn { get; set; }
        DataRowVersion SourceVersion { get; set; }
        object Value { get; set; }
    }
    public interface IDataParameterCollection : ICollection, IEnumerable, IList {
        object this[string parameterName] { get; set; }
        bool Contains(string parameterName);
        int IndexOf(string parameterName);
        void RemoveAt(string parameterName);
    }
    public interface IDataReader : IDataRecord, IDisposable {
        int Depth { get; }
        bool IsClosed { get; }
        int RecordsAffected { get; }
        void Close();
        DataTable GetSchemaTable();
        bool NextResult();
        bool Read();
    }
    public interface IDataRecord {
        int FieldCount { get; }
        object this[int i] { get; }
        object this[string name] { get; }
        bool GetBoolean(int i);
        byte GetByte(int i);
        long GetBytes(int i, long fieldOffset, byte[] buffer, int bufferoffset, int length);
        char GetChar(int i);
        long GetChars(int i, long fieldoffset, char[] buffer, int bufferoffset, int length);
        IDataReader GetData(int i);
        string GetDataTypeName(int i);
        DateTime GetDateTime(int i);
        decimal GetDecimal(int i);
        double GetDouble(int i);
        Type GetFieldType(int i);
        float GetFloat(int i);
        Guid GetGuid(int i);
        short GetInt16(int i);
        int GetInt32(int i);
        long GetInt64(int i);
        string GetName(int i);
        int GetOrdinal(string name);
        string GetString(int i);
        object GetValue(int i);
        int GetValues(object[] values);
        bool IsDBNull(int i);
    }
    public interface IDbCommand : IDisposable {
        string CommandText { get; set; }
        int CommandTimeout { get; set; }
        CommandType CommandType { get; set; }
        IDbConnection Connection { get; set; }
        IDataParameterCollection Parameters { get; }
        IDbTransaction Transaction { get; set; }
        UpdateRowSource UpdatedRowSource { get; set; }
        void Cancel();
        IDbDataParameter CreateParameter();
        int ExecuteNonQuery();
        IDataReader ExecuteReader();
        IDataReader ExecuteReader(CommandBehavior behavior);
        object ExecuteScalar();
        void Prepare();
    }
    public interface IDbConnection : IDisposable {
        string ConnectionString { get; set; }
        int ConnectionTimeout { get; }
        string Database { get; }
        ConnectionState State { get; }
        IDbTransaction BeginTransaction();
        IDbTransaction BeginTransaction(IsolationLevel il);
        void ChangeDatabase(string databaseName);
        void Close();
        IDbCommand CreateCommand();
        void Open();
    }
    public interface IDbDataAdapter : IDataAdapter {
        IDbCommand DeleteCommand { get; set; }
        IDbCommand InsertCommand { get; set; }
        IDbCommand SelectCommand { get; set; }
        IDbCommand UpdateCommand { get; set; }
    }
    public interface IDbDataParameter : IDataParameter {
        byte Precision { get; set; }
        byte Scale { get; set; }
        int Size { get; set; }
    }
    public interface IDbTransaction : IDisposable {
        IDbConnection Connection { get; }
        IsolationLevel IsolationLevel { get; }
        void Commit();
        void Rollback();
    }
    public class InRowChangingEventException : DataException {
        public InRowChangingEventException();
        protected InRowChangingEventException(SerializationInfo info, StreamingContext context);
        public InRowChangingEventException(string s);
        public InRowChangingEventException(string message, Exception innerException);
    }
    public class InternalDataCollectionBase : ICollection, IEnumerable {
        public InternalDataCollectionBase();
        public virtual int Count { get; }
        public bool IsReadOnly { get; }
        public bool IsSynchronized { get; }
        protected virtual ArrayList List { get; }
        public object SyncRoot { get; }
        public virtual void CopyTo(Array ar, int index);
        public virtual IEnumerator GetEnumerator();
    }
    public class InvalidConstraintException : DataException {
        public InvalidConstraintException();
        protected InvalidConstraintException(SerializationInfo info, StreamingContext context);
        public InvalidConstraintException(string s);
        public InvalidConstraintException(string message, Exception innerException);
    }
    public class InvalidExpressionException : DataException {
        public InvalidExpressionException();
        protected InvalidExpressionException(SerializationInfo info, StreamingContext context);
        public InvalidExpressionException(string s);
        public InvalidExpressionException(string message, Exception innerException);
    }
    public enum IsolationLevel {
        Chaos = 16,
        ReadCommitted = 4096,
        ReadUncommitted = 256,
        RepeatableRead = 65536,
        Serializable = 1048576,
        Snapshot = 16777216,
        Unspecified = -1,
    }
    public interface ITableMapping {
        IColumnMappingCollection ColumnMappings { get; }
        string DataSetTable { get; set; }
        string SourceTable { get; set; }
    }
    public interface ITableMappingCollection : ICollection, IEnumerable, IList {
        object this[string index] { get; set; }
        ITableMapping Add(string sourceTableName, string dataSetTableName);
        bool Contains(string sourceTableName);
        ITableMapping GetByDataSetTable(string dataSetTableName);
        int IndexOf(string sourceTableName);
        void RemoveAt(string sourceTableName);
    }
    public enum KeyRestrictionBehavior {
        AllowOnly = 0,
        PreventUsage = 1,
    }
    public enum LoadOption {
        OverwriteChanges = 1,
        PreserveChanges = 2,
        Upsert = 3,
    }
    public enum MappingType {
        Attribute = 2,
        Element = 1,
        Hidden = 4,
        SimpleContent = 3,
    }
    public class MergeFailedEventArgs : EventArgs {
        public MergeFailedEventArgs(DataTable table, string conflict);
        public string Conflict { get; }
        public DataTable Table { get; }
    }
    public delegate void MergeFailedEventHandler(object sender, MergeFailedEventArgs e);
    public enum MissingMappingAction {
        Error = 3,
        Ignore = 2,
        Passthrough = 1,
    }
    public class MissingPrimaryKeyException : DataException {
        public MissingPrimaryKeyException();
        protected MissingPrimaryKeyException(SerializationInfo info, StreamingContext context);
        public MissingPrimaryKeyException(string s);
        public MissingPrimaryKeyException(string message, Exception innerException);
    }
    public enum MissingSchemaAction {
        Add = 1,
        AddWithKey = 4,
        Error = 3,
        Ignore = 2,
    }
    public class NoNullAllowedException : DataException {
        public NoNullAllowedException();
        protected NoNullAllowedException(SerializationInfo info, StreamingContext context);
        public NoNullAllowedException(string s);
        public NoNullAllowedException(string message, Exception innerException);
    }
    public enum ParameterDirection {
        Input = 1,
        InputOutput = 3,
        Output = 2,
        ReturnValue = 6,
    }
    public class PropertyCollection : Hashtable {
        public PropertyCollection();
        protected PropertyCollection(SerializationInfo info, StreamingContext context);
        public override object Clone();
    }
    public class ReadOnlyException : DataException {
        public ReadOnlyException();
        protected ReadOnlyException(SerializationInfo info, StreamingContext context);
        public ReadOnlyException(string s);
        public ReadOnlyException(string message, Exception innerException);
    }
    public class RowNotInTableException : DataException {
        public RowNotInTableException();
        protected RowNotInTableException(SerializationInfo info, StreamingContext context);
        public RowNotInTableException(string s);
        public RowNotInTableException(string message, Exception innerException);
    }
    public enum Rule {
        Cascade = 1,
        None = 0,
        SetDefault = 3,
        SetNull = 2,
    }
    public enum SchemaSerializationMode {
        ExcludeSchema = 2,
        IncludeSchema = 1,
    }
    public enum SchemaType {
        Mapped = 2,
        Source = 1,
    }
    public enum SerializationFormat {
        Binary = 1,
        Xml = 0,
    }
    public enum SqlDbType {
        BigInt = 0,
        Binary = 1,
        Bit = 2,
        Char = 3,
        Date = 31,
        DateTime = 4,
        DateTime2 = 33,
        DateTimeOffset = 34,
        Decimal = 5,
        Float = 6,
        Image = 7,
        Int = 8,
        Money = 9,
        NChar = 10,
        NText = 11,
        NVarChar = 12,
        Real = 13,
        SmallDateTime = 15,
        SmallInt = 16,
        SmallMoney = 17,
        Structured = 30,
        Text = 18,
        Time = 32,
        Timestamp = 19,
        TinyInt = 20,
        Udt = 29,
        UniqueIdentifier = 14,
        VarBinary = 21,
        VarChar = 22,
        Variant = 23,
        Xml = 25,
    }
    public sealed class StateChangeEventArgs : EventArgs {
        public StateChangeEventArgs(ConnectionState originalState, ConnectionState currentState);
        public ConnectionState CurrentState { get; }
        public ConnectionState OriginalState { get; }
    }
    public delegate void StateChangeEventHandler(object sender, StateChangeEventArgs e);
    public sealed class StatementCompletedEventArgs : EventArgs {
        public StatementCompletedEventArgs(int recordCount);
        public int RecordCount { get; }
    }
    public delegate void StatementCompletedEventHandler(object sender, StatementCompletedEventArgs e);
    public enum StatementType {
        Batch = 4,
        Delete = 3,
        Insert = 1,
        Select = 0,
        Update = 2,
    }
    public class StrongTypingException : DataException {
        public StrongTypingException();
        protected StrongTypingException(SerializationInfo info, StreamingContext context);
        public StrongTypingException(string message);
        public StrongTypingException(string s, Exception innerException);
    }
    public class SyntaxErrorException : InvalidExpressionException {
        public SyntaxErrorException();
        protected SyntaxErrorException(SerializationInfo info, StreamingContext context);
        public SyntaxErrorException(string s);
        public SyntaxErrorException(string message, Exception innerException);
    }
    public class UniqueConstraint : Constraint {
        public UniqueConstraint(DataColumn column);
        public UniqueConstraint(DataColumn column, bool isPrimaryKey);
        public UniqueConstraint(DataColumn[] columns);
        public UniqueConstraint(DataColumn[] columns, bool isPrimaryKey);
        public UniqueConstraint(string name, DataColumn column);
        public UniqueConstraint(string name, DataColumn column, bool isPrimaryKey);
        public UniqueConstraint(string name, DataColumn[] columns);
        public UniqueConstraint(string name, DataColumn[] columns, bool isPrimaryKey);
        public UniqueConstraint(string name, string[] columnNames, bool isPrimaryKey);
        public virtual DataColumn[] Columns { get; }
        public bool IsPrimaryKey { get; }
        public override DataTable Table { get; }
        public override bool Equals(object key2);
        public override int GetHashCode();
    }
    public enum UpdateRowSource {
        Both = 3,
        FirstReturnedRecord = 2,
        None = 0,
        OutputParameters = 1,
    }
    public enum UpdateStatus {
        Continue = 0,
        ErrorsOccurred = 1,
        SkipAllRemainingRows = 3,
        SkipCurrentRow = 2,
    }
    public class VersionNotFoundException : DataException {
        public VersionNotFoundException();
        protected VersionNotFoundException(SerializationInfo info, StreamingContext context);
        public VersionNotFoundException(string s);
        public VersionNotFoundException(string message, Exception innerException);
    }
    public enum XmlReadMode {
        Auto = 0,
        DiffGram = 4,
        Fragment = 5,
        IgnoreSchema = 2,
        InferSchema = 3,
        InferTypedSchema = 6,
        ReadSchema = 1,
    }
    public enum XmlWriteMode {
        DiffGram = 2,
        IgnoreSchema = 1,
        WriteSchema = 0,
    }
}
namespace System.Data.Common {
    public enum CatalogLocation {
        End = 2,
        Start = 1,
    }
    public class DataAdapter : Component, IDataAdapter {
        protected DataAdapter();
        protected DataAdapter(DataAdapter from);
        public bool AcceptChangesDuringFill { get; set; }
        public bool AcceptChangesDuringUpdate { get; set; }
        public bool ContinueUpdateOnError { get; set; }
        public LoadOption FillLoadOption { get; set; }
        public MissingMappingAction MissingMappingAction { get; set; }
        public MissingSchemaAction MissingSchemaAction { get; set; }
        public virtual bool ReturnProviderSpecificTypes { get; set; }
        ITableMappingCollection System.Data.IDataAdapter.TableMappings { get; }
        public DataTableMappingCollection TableMappings { get; }
        public event FillErrorEventHandler FillError;
        protected virtual DataAdapter CloneInternals();
        protected virtual DataTableMappingCollection CreateTableMappings();
        protected override void Dispose(bool disposing);
        public virtual int Fill(DataSet dataSet);
        protected virtual int Fill(DataSet dataSet, string srcTable, IDataReader dataReader, int startRecord, int maxRecords);
        protected virtual int Fill(DataTable dataTable, IDataReader dataReader);
        protected virtual int Fill(DataTable[] dataTables, IDataReader dataReader, int startRecord, int maxRecords);
        public virtual DataTable[] FillSchema(DataSet dataSet, SchemaType schemaType);
        protected virtual DataTable[] FillSchema(DataSet dataSet, SchemaType schemaType, string srcTable, IDataReader dataReader);
        protected virtual DataTable FillSchema(DataTable dataTable, SchemaType schemaType, IDataReader dataReader);
        public virtual IDataParameter[] GetFillParameters();
        protected bool HasTableMappings();
        protected virtual void OnFillError(FillErrorEventArgs value);
        public void ResetFillLoadOption();
        public virtual bool ShouldSerializeAcceptChangesDuringFill();
        public virtual bool ShouldSerializeFillLoadOption();
        protected virtual bool ShouldSerializeTableMappings();
        public virtual int Update(DataSet dataSet);
    }
    public sealed class DataColumnMapping : MarshalByRefObject, ICloneable, IColumnMapping {
        public DataColumnMapping();
        public DataColumnMapping(string sourceColumn, string dataSetColumn);
        public string DataSetColumn { get; set; }
        public string SourceColumn { get; set; }
        public DataColumn GetDataColumnBySchemaAction(DataTable dataTable, Type dataType, MissingSchemaAction schemaAction);
        public static DataColumn GetDataColumnBySchemaAction(string sourceColumn, string dataSetColumn, DataTable dataTable, Type dataType, MissingSchemaAction schemaAction);
        object System.ICloneable.Clone();
        public override string ToString();
    }
    public sealed class DataColumnMappingCollection : MarshalByRefObject, ICollection, IColumnMappingCollection, IEnumerable, IList {
        public DataColumnMappingCollection();
        public int Count { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        bool System.Collections.IList.IsFixedSize { get; }
        bool System.Collections.IList.IsReadOnly { get; }
        object System.Collections.IList.this[int index] { get; set; }
        object System.Data.IColumnMappingCollection.this[string index] { get; set; }
        public DataColumnMapping this[int index] { get; set; }
        public DataColumnMapping this[string sourceColumn] { get; set; }
        public int Add(object value);
        public DataColumnMapping Add(string sourceColumn, string dataSetColumn);
        public void AddRange(Array values);
        public void AddRange(DataColumnMapping[] values);
        public void Clear();
        public bool Contains(object value);
        public bool Contains(string value);
        public void CopyTo(Array array, int index);
        public void CopyTo(DataColumnMapping[] array, int index);
        public DataColumnMapping GetByDataSetColumn(string value);
        public static DataColumnMapping GetColumnMappingBySchemaAction(DataColumnMappingCollection columnMappings, string sourceColumn, MissingMappingAction mappingAction);
        public static DataColumn GetDataColumn(DataColumnMappingCollection columnMappings, string sourceColumn, Type dataType, DataTable dataTable, MissingMappingAction mappingAction, MissingSchemaAction schemaAction);
        public IEnumerator GetEnumerator();
        public int IndexOf(object value);
        public int IndexOf(string sourceColumn);
        public int IndexOfDataSetColumn(string dataSetColumn);
        public void Insert(int index, DataColumnMapping value);
        public void Insert(int index, object value);
        public void Remove(DataColumnMapping value);
        public void Remove(object value);
        public void RemoveAt(int index);
        public void RemoveAt(string sourceColumn);
        IColumnMapping System.Data.IColumnMappingCollection.Add(string sourceColumnName, string dataSetColumnName);
        IColumnMapping System.Data.IColumnMappingCollection.GetByDataSetColumn(string dataSetColumnName);
    }
    public sealed class DataTableMapping : MarshalByRefObject, ICloneable, ITableMapping {
        public DataTableMapping();
        public DataTableMapping(string sourceTable, string dataSetTable);
        public DataTableMapping(string sourceTable, string dataSetTable, DataColumnMapping[] columnMappings);
        public DataColumnMappingCollection ColumnMappings { get; }
        public string DataSetTable { get; set; }
        public string SourceTable { get; set; }
        IColumnMappingCollection System.Data.ITableMapping.ColumnMappings { get; }
        public DataColumnMapping GetColumnMappingBySchemaAction(string sourceColumn, MissingMappingAction mappingAction);
        public DataColumn GetDataColumn(string sourceColumn, Type dataType, DataTable dataTable, MissingMappingAction mappingAction, MissingSchemaAction schemaAction);
        public DataTable GetDataTableBySchemaAction(DataSet dataSet, MissingSchemaAction schemaAction);
        object System.ICloneable.Clone();
        public override string ToString();
    }
    public sealed class DataTableMappingCollection : MarshalByRefObject, ICollection, IEnumerable, IList, ITableMappingCollection {
        public DataTableMappingCollection();
        public int Count { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        bool System.Collections.IList.IsFixedSize { get; }
        bool System.Collections.IList.IsReadOnly { get; }
        object System.Collections.IList.this[int index] { get; set; }
        object System.Data.ITableMappingCollection.this[string index] { get; set; }
        public DataTableMapping this[int index] { get; set; }
        public DataTableMapping this[string sourceTable] { get; set; }
        public int Add(object value);
        public DataTableMapping Add(string sourceTable, string dataSetTable);
        public void AddRange(Array values);
        public void AddRange(DataTableMapping[] values);
        public void Clear();
        public bool Contains(object value);
        public bool Contains(string value);
        public void CopyTo(Array array, int index);
        public void CopyTo(DataTableMapping[] array, int index);
        public DataTableMapping GetByDataSetTable(string dataSetTable);
        public IEnumerator GetEnumerator();
        public static DataTableMapping GetTableMappingBySchemaAction(DataTableMappingCollection tableMappings, string sourceTable, string dataSetTable, MissingMappingAction mappingAction);
        public int IndexOf(object value);
        public int IndexOf(string sourceTable);
        public int IndexOfDataSetTable(string dataSetTable);
        public void Insert(int index, DataTableMapping value);
        public void Insert(int index, object value);
        public void Remove(DataTableMapping value);
        public void Remove(object value);
        public void RemoveAt(int index);
        public void RemoveAt(string sourceTable);
        ITableMapping System.Data.ITableMappingCollection.Add(string sourceTableName, string dataSetTableName);
        ITableMapping System.Data.ITableMappingCollection.GetByDataSetTable(string dataSetTableName);
    }
    public abstract class DbColumn {
        protected DbColumn();
        public Nullable<bool> AllowDBNull { get; protected set; }
        public string BaseCatalogName { get; protected set; }
        public string BaseColumnName { get; protected set; }
        public string BaseSchemaName { get; protected set; }
        public string BaseServerName { get; protected set; }
        public string BaseTableName { get; protected set; }
        public string ColumnName { get; protected set; }
        public Nullable<int> ColumnOrdinal { get; protected set; }
        public Nullable<int> ColumnSize { get; protected set; }
        public Type DataType { get; protected set; }
        public string DataTypeName { get; protected set; }
        public Nullable<bool> IsAliased { get; protected set; }
        public Nullable<bool> IsAutoIncrement { get; protected set; }
        public Nullable<bool> IsExpression { get; protected set; }
        public Nullable<bool> IsHidden { get; protected set; }
        public Nullable<bool> IsIdentity { get; protected set; }
        public Nullable<bool> IsKey { get; protected set; }
        public Nullable<bool> IsLong { get; protected set; }
        public Nullable<bool> IsReadOnly { get; protected set; }
        public Nullable<bool> IsUnique { get; protected set; }
        public Nullable<int> NumericPrecision { get; protected set; }
        public Nullable<int> NumericScale { get; protected set; }
        public virtual object this[string property] { get; }
        public string UdtAssemblyQualifiedName { get; protected set; }
    }
    public abstract class DbCommand : Component, IDbCommand, IDisposable {
        protected DbCommand();
        public abstract string CommandText { get; set; }
        public abstract int CommandTimeout { get; set; }
        public abstract CommandType CommandType { get; set; }
        public DbConnection Connection { get; set; }
        protected abstract DbConnection DbConnection { get; set; }
        protected abstract DbParameterCollection DbParameterCollection { get; }
        protected abstract DbTransaction DbTransaction { get; set; }
        public abstract bool DesignTimeVisible { get; set; }
        public DbParameterCollection Parameters { get; }
        IDbConnection System.Data.IDbCommand.Connection { get; set; }
        IDataParameterCollection System.Data.IDbCommand.Parameters { get; }
        IDbTransaction System.Data.IDbCommand.Transaction { get; set; }
        public DbTransaction Transaction { get; set; }
        public abstract UpdateRowSource UpdatedRowSource { get; set; }
        public abstract void Cancel();
        protected abstract DbParameter CreateDbParameter();
        public DbParameter CreateParameter();
        protected abstract DbDataReader ExecuteDbDataReader(CommandBehavior behavior);
        protected virtual Task<DbDataReader> ExecuteDbDataReaderAsync(CommandBehavior behavior, CancellationToken cancellationToken);
        public abstract int ExecuteNonQuery();
        public Task<int> ExecuteNonQueryAsync();
        public virtual Task<int> ExecuteNonQueryAsync(CancellationToken cancellationToken);
        public DbDataReader ExecuteReader();
        public DbDataReader ExecuteReader(CommandBehavior behavior);
        public Task<DbDataReader> ExecuteReaderAsync();
        public Task<DbDataReader> ExecuteReaderAsync(CommandBehavior behavior);
        public Task<DbDataReader> ExecuteReaderAsync(CommandBehavior behavior, CancellationToken cancellationToken);
        public Task<DbDataReader> ExecuteReaderAsync(CancellationToken cancellationToken);
        public abstract object ExecuteScalar();
        public Task<object> ExecuteScalarAsync();
        public virtual Task<object> ExecuteScalarAsync(CancellationToken cancellationToken);
        public abstract void Prepare();
        IDbDataParameter System.Data.IDbCommand.CreateParameter();
        IDataReader System.Data.IDbCommand.ExecuteReader();
        IDataReader System.Data.IDbCommand.ExecuteReader(CommandBehavior behavior);
    }
    public abstract class DbCommandBuilder : Component {
        protected DbCommandBuilder();
        public virtual CatalogLocation CatalogLocation { get; set; }
        public virtual string CatalogSeparator { get; set; }
        public virtual ConflictOption ConflictOption { get; set; }
        public DbDataAdapter DataAdapter { get; set; }
        public virtual string QuotePrefix { get; set; }
        public virtual string QuoteSuffix { get; set; }
        public virtual string SchemaSeparator { get; set; }
        public bool SetAllValues { get; set; }
        protected abstract void ApplyParameterInfo(DbParameter parameter, DataRow row, StatementType statementType, bool whereClause);
        protected override void Dispose(bool disposing);
        public DbCommand GetDeleteCommand();
        public DbCommand GetDeleteCommand(bool useColumnsForParameterNames);
        public DbCommand GetInsertCommand();
        public DbCommand GetInsertCommand(bool useColumnsForParameterNames);
        protected abstract string GetParameterName(int parameterOrdinal);
        protected abstract string GetParameterName(string parameterName);
        protected abstract string GetParameterPlaceholder(int parameterOrdinal);
        protected virtual DataTable GetSchemaTable(DbCommand sourceCommand);
        public DbCommand GetUpdateCommand();
        public DbCommand GetUpdateCommand(bool useColumnsForParameterNames);
        protected virtual DbCommand InitializeCommand(DbCommand command);
        public virtual string QuoteIdentifier(string unquotedIdentifier);
        public virtual void RefreshSchema();
        protected void RowUpdatingHandler(RowUpdatingEventArgs rowUpdatingEvent);
        protected abstract void SetRowUpdatingHandler(DbDataAdapter adapter);
        public virtual string UnquoteIdentifier(string quotedIdentifier);
    }
    public abstract class DbConnection : Component, IDbConnection, IDisposable {
        protected DbConnection();
        public abstract string ConnectionString { get; set; }
        public virtual int ConnectionTimeout { get; }
        public abstract string Database { get; }
        public abstract string DataSource { get; }
        protected virtual DbProviderFactory DbProviderFactory { get; }
        public abstract string ServerVersion { get; }
        public abstract ConnectionState State { get; }
        public virtual event StateChangeEventHandler StateChange;
        protected abstract DbTransaction BeginDbTransaction(IsolationLevel isolationLevel);
        public DbTransaction BeginTransaction();
        public DbTransaction BeginTransaction(IsolationLevel isolationLevel);
        public abstract void ChangeDatabase(string databaseName);
        public abstract void Close();
        public DbCommand CreateCommand();
        protected abstract DbCommand CreateDbCommand();
        public virtual void EnlistTransaction(Transaction transaction);
        public virtual DataTable GetSchema();
        public virtual DataTable GetSchema(string collectionName);
        public virtual DataTable GetSchema(string collectionName, string[] restrictionValues);
        protected virtual void OnStateChange(StateChangeEventArgs stateChange);
        public abstract void Open();
        public Task OpenAsync();
        public virtual Task OpenAsync(CancellationToken cancellationToken);
        IDbTransaction System.Data.IDbConnection.BeginTransaction();
        IDbTransaction System.Data.IDbConnection.BeginTransaction(IsolationLevel isolationLevel);
        IDbCommand System.Data.IDbConnection.CreateCommand();
    }
    public class DbConnectionStringBuilder : ICollection, ICustomTypeDescriptor, IDictionary, IEnumerable {
        public DbConnectionStringBuilder();
        public DbConnectionStringBuilder(bool useOdbcRules);
        public bool BrowsableConnectionString { get; set; }
        public string ConnectionString { get; set; }
        public virtual int Count { get; }
        public virtual bool IsFixedSize { get; }
        public bool IsReadOnly { get; }
        public virtual ICollection Keys { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        object System.Collections.IDictionary.this[object keyword] { get; set; }
        public virtual object this[string keyword] { get; set; }
        public virtual ICollection Values { get; }
        public void Add(string keyword, object value);
        public static void AppendKeyValuePair(StringBuilder builder, string keyword, string value);
        public static void AppendKeyValuePair(StringBuilder builder, string keyword, string value, bool useOdbcRules);
        public virtual void Clear();
        protected internal void ClearPropertyDescriptors();
        public virtual bool ContainsKey(string keyword);
        public virtual bool EquivalentTo(DbConnectionStringBuilder connectionStringBuilder);
        protected virtual void GetProperties(Hashtable propertyDescriptors);
        public virtual bool Remove(string keyword);
        public virtual bool ShouldSerialize(string keyword);
        void System.Collections.ICollection.CopyTo(Array array, int index);
        void System.Collections.IDictionary.Add(object keyword, object value);
        bool System.Collections.IDictionary.Contains(object keyword);
        IDictionaryEnumerator System.Collections.IDictionary.GetEnumerator();
        void System.Collections.IDictionary.Remove(object keyword);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        AttributeCollection System.ComponentModel.ICustomTypeDescriptor.GetAttributes();
        string System.ComponentModel.ICustomTypeDescriptor.GetClassName();
        string System.ComponentModel.ICustomTypeDescriptor.GetComponentName();
        TypeConverter System.ComponentModel.ICustomTypeDescriptor.GetConverter();
        EventDescriptor System.ComponentModel.ICustomTypeDescriptor.GetDefaultEvent();
        PropertyDescriptor System.ComponentModel.ICustomTypeDescriptor.GetDefaultProperty();
        object System.ComponentModel.ICustomTypeDescriptor.GetEditor(Type editorBaseType);
        EventDescriptorCollection System.ComponentModel.ICustomTypeDescriptor.GetEvents();
        EventDescriptorCollection System.ComponentModel.ICustomTypeDescriptor.GetEvents(Attribute[] attributes);
        PropertyDescriptorCollection System.ComponentModel.ICustomTypeDescriptor.GetProperties();
        PropertyDescriptorCollection System.ComponentModel.ICustomTypeDescriptor.GetProperties(Attribute[] attributes);
        object System.ComponentModel.ICustomTypeDescriptor.GetPropertyOwner(PropertyDescriptor pd);
        public override string ToString();
        public virtual bool TryGetValue(string keyword, out object value);
    }
    public abstract class DbDataAdapter : DataAdapter, ICloneable, IDataAdapter, IDbDataAdapter {
        public const string DefaultSourceTableName = "Table";
        protected DbDataAdapter();
        protected DbDataAdapter(DbDataAdapter adapter);
        public DbCommand DeleteCommand { get; set; }
        protected internal CommandBehavior FillCommandBehavior { get; set; }
        public DbCommand InsertCommand { get; set; }
        public DbCommand SelectCommand { get; set; }
        IDbCommand System.Data.IDbDataAdapter.DeleteCommand { get; set; }
        IDbCommand System.Data.IDbDataAdapter.InsertCommand { get; set; }
        IDbCommand System.Data.IDbDataAdapter.SelectCommand { get; set; }
        IDbCommand System.Data.IDbDataAdapter.UpdateCommand { get; set; }
        public virtual int UpdateBatchSize { get; set; }
        public DbCommand UpdateCommand { get; set; }
        protected virtual int AddToBatch(IDbCommand command);
        protected virtual void ClearBatch();
        protected virtual RowUpdatedEventArgs CreateRowUpdatedEvent(DataRow dataRow, IDbCommand command, StatementType statementType, DataTableMapping tableMapping);
        protected virtual RowUpdatingEventArgs CreateRowUpdatingEvent(DataRow dataRow, IDbCommand command, StatementType statementType, DataTableMapping tableMapping);
        protected override void Dispose(bool disposing);
        protected virtual int ExecuteBatch();
        public override int Fill(DataSet dataSet);
        public int Fill(DataSet dataSet, int startRecord, int maxRecords, string srcTable);
        protected virtual int Fill(DataSet dataSet, int startRecord, int maxRecords, string srcTable, IDbCommand command, CommandBehavior behavior);
        public int Fill(DataSet dataSet, string srcTable);
        public int Fill(DataTable dataTable);
        protected virtual int Fill(DataTable dataTable, IDbCommand command, CommandBehavior behavior);
        protected virtual int Fill(DataTable[] dataTables, int startRecord, int maxRecords, IDbCommand command, CommandBehavior behavior);
        public int Fill(int startRecord, int maxRecords, params DataTable[] dataTables);
        public override DataTable[] FillSchema(DataSet dataSet, SchemaType schemaType);
        protected virtual DataTable[] FillSchema(DataSet dataSet, SchemaType schemaType, IDbCommand command, string srcTable, CommandBehavior behavior);
        public DataTable[] FillSchema(DataSet dataSet, SchemaType schemaType, string srcTable);
        public DataTable FillSchema(DataTable dataTable, SchemaType schemaType);
        protected virtual DataTable FillSchema(DataTable dataTable, SchemaType schemaType, IDbCommand command, CommandBehavior behavior);
        protected virtual IDataParameter GetBatchedParameter(int commandIdentifier, int parameterIndex);
        protected virtual bool GetBatchedRecordsAffected(int commandIdentifier, out int recordsAffected, out Exception error);
        public override IDataParameter[] GetFillParameters();
        protected virtual void InitializeBatching();
        protected virtual void OnRowUpdated(RowUpdatedEventArgs value);
        protected virtual void OnRowUpdating(RowUpdatingEventArgs value);
        object System.ICloneable.Clone();
        protected virtual void TerminateBatching();
        public int Update(DataRow[] dataRows);
        protected virtual int Update(DataRow[] dataRows, DataTableMapping tableMapping);
        public override int Update(DataSet dataSet);
        public int Update(DataSet dataSet, string srcTable);
        public int Update(DataTable dataTable);
    }
    public abstract class DbDataReader : MarshalByRefObject, IDataReader, IDataRecord, IDisposable, IEnumerable {
        protected DbDataReader();
        public abstract int Depth { get; }
        public abstract int FieldCount { get; }
        public abstract bool HasRows { get; }
        public abstract bool IsClosed { get; }
        public abstract int RecordsAffected { get; }
        public abstract object this[int ordinal] { get; }
        public abstract object this[string name] { get; }
        public virtual int VisibleFieldCount { get; }
        public virtual void Close();
        public void Dispose();
        protected virtual void Dispose(bool disposing);
        public abstract bool GetBoolean(int ordinal);
        public abstract byte GetByte(int ordinal);
        public abstract long GetBytes(int ordinal, long dataOffset, byte[] buffer, int bufferOffset, int length);
        public abstract char GetChar(int ordinal);
        public abstract long GetChars(int ordinal, long dataOffset, char[] buffer, int bufferOffset, int length);
        public DbDataReader GetData(int ordinal);
        public abstract string GetDataTypeName(int ordinal);
        public abstract DateTime GetDateTime(int ordinal);
        protected virtual DbDataReader GetDbDataReader(int ordinal);
        public abstract decimal GetDecimal(int ordinal);
        public abstract double GetDouble(int ordinal);
        public abstract IEnumerator GetEnumerator();
        public abstract Type GetFieldType(int ordinal);
        public virtual T GetFieldValue<T>(int ordinal);
        public Task<T> GetFieldValueAsync<T>(int ordinal);
        public virtual Task<T> GetFieldValueAsync<T>(int ordinal, CancellationToken cancellationToken);
        public abstract float GetFloat(int ordinal);
        public abstract Guid GetGuid(int ordinal);
        public abstract short GetInt16(int ordinal);
        public abstract int GetInt32(int ordinal);
        public abstract long GetInt64(int ordinal);
        public abstract string GetName(int ordinal);
        public abstract int GetOrdinal(string name);
        public virtual Type GetProviderSpecificFieldType(int ordinal);
        public virtual object GetProviderSpecificValue(int ordinal);
        public virtual int GetProviderSpecificValues(object[] values);
        public virtual DataTable GetSchemaTable();
        public virtual Stream GetStream(int ordinal);
        public abstract string GetString(int ordinal);
        public virtual TextReader GetTextReader(int ordinal);
        public abstract object GetValue(int ordinal);
        public abstract int GetValues(object[] values);
        public abstract bool IsDBNull(int ordinal);
        public Task<bool> IsDBNullAsync(int ordinal);
        public virtual Task<bool> IsDBNullAsync(int ordinal, CancellationToken cancellationToken);
        public abstract bool NextResult();
        public Task<bool> NextResultAsync();
        public virtual Task<bool> NextResultAsync(CancellationToken cancellationToken);
        public abstract bool Read();
        public Task<bool> ReadAsync();
        public virtual Task<bool> ReadAsync(CancellationToken cancellationToken);
        IDataReader System.Data.IDataRecord.GetData(int ordinal);
    }
    public static class DbDataReaderExtensions {
        public static bool CanGetColumnSchema(this DbDataReader reader);
        public static ReadOnlyCollection<DbColumn> GetColumnSchema(this DbDataReader reader);
    }
    public abstract class DbDataRecord : ICustomTypeDescriptor, IDataRecord {
        protected DbDataRecord();
        public abstract int FieldCount { get; }
        public abstract object this[int i] { get; }
        public abstract object this[string name] { get; }
        public abstract bool GetBoolean(int i);
        public abstract byte GetByte(int i);
        public abstract long GetBytes(int i, long dataIndex, byte[] buffer, int bufferIndex, int length);
        public abstract char GetChar(int i);
        public abstract long GetChars(int i, long dataIndex, char[] buffer, int bufferIndex, int length);
        public IDataReader GetData(int i);
        public abstract string GetDataTypeName(int i);
        public abstract DateTime GetDateTime(int i);
        protected virtual DbDataReader GetDbDataReader(int i);
        public abstract decimal GetDecimal(int i);
        public abstract double GetDouble(int i);
        public abstract Type GetFieldType(int i);
        public abstract float GetFloat(int i);
        public abstract Guid GetGuid(int i);
        public abstract short GetInt16(int i);
        public abstract int GetInt32(int i);
        public abstract long GetInt64(int i);
        public abstract string GetName(int i);
        public abstract int GetOrdinal(string name);
        public abstract string GetString(int i);
        public abstract object GetValue(int i);
        public abstract int GetValues(object[] values);
        public abstract bool IsDBNull(int i);
        AttributeCollection System.ComponentModel.ICustomTypeDescriptor.GetAttributes();
        string System.ComponentModel.ICustomTypeDescriptor.GetClassName();
        string System.ComponentModel.ICustomTypeDescriptor.GetComponentName();
        TypeConverter System.ComponentModel.ICustomTypeDescriptor.GetConverter();
        EventDescriptor System.ComponentModel.ICustomTypeDescriptor.GetDefaultEvent();
        PropertyDescriptor System.ComponentModel.ICustomTypeDescriptor.GetDefaultProperty();
        object System.ComponentModel.ICustomTypeDescriptor.GetEditor(Type editorBaseType);
        EventDescriptorCollection System.ComponentModel.ICustomTypeDescriptor.GetEvents();
        EventDescriptorCollection System.ComponentModel.ICustomTypeDescriptor.GetEvents(Attribute[] attributes);
        PropertyDescriptorCollection System.ComponentModel.ICustomTypeDescriptor.GetProperties();
        PropertyDescriptorCollection System.ComponentModel.ICustomTypeDescriptor.GetProperties(Attribute[] attributes);
        object System.ComponentModel.ICustomTypeDescriptor.GetPropertyOwner(PropertyDescriptor pd);
    }
    public abstract class DbDataSourceEnumerator {
        protected DbDataSourceEnumerator();
        public abstract DataTable GetDataSources();
    }
    public class DbEnumerator : IEnumerator {
        public DbEnumerator(DbDataReader reader);
        public DbEnumerator(DbDataReader reader, bool closeReader);
        public DbEnumerator(IDataReader reader);
        public DbEnumerator(IDataReader reader, bool closeReader);
        public object Current { get; }
        public bool MoveNext();
        public void Reset();
    }
    public abstract class DbException : ExternalException {
        protected DbException();
        protected DbException(SerializationInfo info, StreamingContext context);
        protected DbException(string message);
        protected DbException(string message, Exception innerException);
        protected DbException(string message, int errorCode);
    }
    public static class DbMetaDataCollectionNames {
        public static readonly string DataSourceInformation;
        public static readonly string DataTypes;
        public static readonly string MetaDataCollections;
        public static readonly string ReservedWords;
        public static readonly string Restrictions;
    }
    public static class DbMetaDataColumnNames {
        public static readonly string CollectionName;
        public static readonly string ColumnSize;
        public static readonly string CompositeIdentifierSeparatorPattern;
        public static readonly string CreateFormat;
        public static readonly string CreateParameters;
        public static readonly string DataSourceProductName;
        public static readonly string DataSourceProductVersion;
        public static readonly string DataSourceProductVersionNormalized;
        public static readonly string DataType;
        public static readonly string GroupByBehavior;
        public static readonly string IdentifierCase;
        public static readonly string IdentifierPattern;
        public static readonly string IsAutoIncrementable;
        public static readonly string IsBestMatch;
        public static readonly string IsCaseSensitive;
        public static readonly string IsConcurrencyType;
        public static readonly string IsFixedLength;
        public static readonly string IsFixedPrecisionScale;
        public static readonly string IsLiteralSupported;
        public static readonly string IsLong;
        public static readonly string IsNullable;
        public static readonly string IsSearchable;
        public static readonly string IsSearchableWithLike;
        public static readonly string IsUnsigned;
        public static readonly string LiteralPrefix;
        public static readonly string LiteralSuffix;
        public static readonly string MaximumScale;
        public static readonly string MinimumScale;
        public static readonly string NumberOfIdentifierParts;
        public static readonly string NumberOfRestrictions;
        public static readonly string OrderByColumnsInSelect;
        public static readonly string ParameterMarkerFormat;
        public static readonly string ParameterMarkerPattern;
        public static readonly string ParameterNameMaxLength;
        public static readonly string ParameterNamePattern;
        public static readonly string ProviderDbType;
        public static readonly string QuotedIdentifierCase;
        public static readonly string QuotedIdentifierPattern;
        public static readonly string ReservedWord;
        public static readonly string StatementSeparatorPattern;
        public static readonly string StringLiteralPattern;
        public static readonly string SupportedJoinOperators;
        public static readonly string TypeName;
    }
    public abstract class DbParameter : MarshalByRefObject, IDataParameter, IDbDataParameter {
        protected DbParameter();
        public abstract DbType DbType { get; set; }
        public abstract ParameterDirection Direction { get; set; }
        public abstract bool IsNullable { get; set; }
        public abstract string ParameterName { get; set; }
        public virtual byte Precision { get; set; }
        public virtual byte Scale { get; set; }
        public abstract int Size { get; set; }
        public abstract string SourceColumn { get; set; }
        public abstract bool SourceColumnNullMapping { get; set; }
        public virtual DataRowVersion SourceVersion { get; set; }
        byte System.Data.IDbDataParameter.Precision { get; set; }
        byte System.Data.IDbDataParameter.Scale { get; set; }
        public abstract object Value { get; set; }
        public abstract void ResetDbType();
    }
    public abstract class DbParameterCollection : MarshalByRefObject, ICollection, IDataParameterCollection, IEnumerable, IList {
        protected DbParameterCollection();
        public abstract int Count { get; }
        public virtual bool IsFixedSize { get; }
        public virtual bool IsReadOnly { get; }
        public virtual bool IsSynchronized { get; }
        public abstract object SyncRoot { get; }
        object System.Collections.IList.this[int index] { get; set; }
        object System.Data.IDataParameterCollection.this[string parameterName] { get; set; }
        public DbParameter this[int index] { get; set; }
        public DbParameter this[string parameterName] { get; set; }
        public abstract int Add(object value);
        public abstract void AddRange(Array values);
        public abstract void Clear();
        public abstract bool Contains(object value);
        public abstract bool Contains(string value);
        public abstract void CopyTo(Array array, int index);
        public abstract IEnumerator GetEnumerator();
        protected abstract DbParameter GetParameter(int index);
        protected abstract DbParameter GetParameter(string parameterName);
        public abstract int IndexOf(object value);
        public abstract int IndexOf(string parameterName);
        public abstract void Insert(int index, object value);
        public abstract void Remove(object value);
        public abstract void RemoveAt(int index);
        public abstract void RemoveAt(string parameterName);
        protected abstract void SetParameter(int index, DbParameter value);
        protected abstract void SetParameter(string parameterName, DbParameter value);
    }
    public abstract class DbProviderFactory {
        protected DbProviderFactory();
        public virtual bool CanCreateDataSourceEnumerator { get; }
        public virtual DbCommand CreateCommand();
        public virtual DbCommandBuilder CreateCommandBuilder();
        public virtual DbConnection CreateConnection();
        public virtual DbConnectionStringBuilder CreateConnectionStringBuilder();
        public virtual DbDataAdapter CreateDataAdapter();
        public virtual DbDataSourceEnumerator CreateDataSourceEnumerator();
        public virtual DbParameter CreateParameter();
    }
    public sealed class DbProviderSpecificTypePropertyAttribute : Attribute {
        public DbProviderSpecificTypePropertyAttribute(bool isProviderSpecificTypeProperty);
        public bool IsProviderSpecificTypeProperty { get; }
    }
    public abstract class DbTransaction : MarshalByRefObject, IDbTransaction, IDisposable {
        protected DbTransaction();
        public DbConnection Connection { get; }
        protected abstract DbConnection DbConnection { get; }
        public abstract IsolationLevel IsolationLevel { get; }
        IDbConnection System.Data.IDbTransaction.Connection { get; }
        public abstract void Commit();
        public void Dispose();
        protected virtual void Dispose(bool disposing);
        public abstract void Rollback();
    }
    public enum GroupByBehavior {
        ExactMatch = 4,
        MustContainAll = 3,
        NotSupported = 1,
        Unknown = 0,
        Unrelated = 2,
    }
    public interface IDbColumnSchemaGenerator {
        ReadOnlyCollection<DbColumn> GetColumnSchema();
    }
    public enum IdentifierCase {
        Insensitive = 1,
        Sensitive = 2,
        Unknown = 0,
    }
    public class RowUpdatedEventArgs : EventArgs {
        public RowUpdatedEventArgs(DataRow dataRow, IDbCommand command, StatementType statementType, DataTableMapping tableMapping);
        public IDbCommand Command { get; }
        public Exception Errors { get; set; }
        public int RecordsAffected { get; }
        public DataRow Row { get; }
        public int RowCount { get; }
        public StatementType StatementType { get; }
        public UpdateStatus Status { get; set; }
        public DataTableMapping TableMapping { get; }
        public void CopyToRows(DataRow[] array);
        public void CopyToRows(DataRow[] array, int arrayIndex);
    }
    public class RowUpdatingEventArgs : EventArgs {
        public RowUpdatingEventArgs(DataRow dataRow, IDbCommand command, StatementType statementType, DataTableMapping tableMapping);
        protected virtual IDbCommand BaseCommand { get; set; }
        public IDbCommand Command { get; set; }
        public Exception Errors { get; set; }
        public DataRow Row { get; }
        public StatementType StatementType { get; }
        public UpdateStatus Status { get; set; }
        public DataTableMapping TableMapping { get; }
    }
    public static class SchemaTableColumn {
        public static readonly string AllowDBNull;
        public static readonly string BaseColumnName;
        public static readonly string BaseSchemaName;
        public static readonly string BaseTableName;
        public static readonly string ColumnName;
        public static readonly string ColumnOrdinal;
        public static readonly string ColumnSize;
        public static readonly string DataType;
        public static readonly string IsAliased;
        public static readonly string IsExpression;
        public static readonly string IsKey;
        public static readonly string IsLong;
        public static readonly string IsUnique;
        public static readonly string NonVersionedProviderType;
        public static readonly string NumericPrecision;
        public static readonly string NumericScale;
        public static readonly string ProviderType;
    }
    public static class SchemaTableOptionalColumn {
        public static readonly string AutoIncrementSeed;
        public static readonly string AutoIncrementStep;
        public static readonly string BaseCatalogName;
        public static readonly string BaseColumnNamespace;
        public static readonly string BaseServerName;
        public static readonly string BaseTableNamespace;
        public static readonly string ColumnMapping;
        public static readonly string DefaultValue;
        public static readonly string Expression;
        public static readonly string IsAutoIncrement;
        public static readonly string IsHidden;
        public static readonly string IsReadOnly;
        public static readonly string IsRowVersion;
        public static readonly string ProviderSpecificDataType;
    }
    public enum SupportedJoinOperators {
        FullOuter = 8,
        Inner = 1,
        LeftOuter = 2,
        None = 0,
        RightOuter = 4,
    }
}
namespace System.Data.SqlTypes {
    public interface INullable {
        bool IsNull { get; }
    }
    public sealed class SqlAlreadyFilledException : SqlTypeException {
        public SqlAlreadyFilledException();
        public SqlAlreadyFilledException(string message);
        public SqlAlreadyFilledException(string message, Exception e);
    }
    public struct SqlBinary : IComparable, INullable, IXmlSerializable {
        public static readonly SqlBinary Null;
        public SqlBinary(byte[] value);
        public bool IsNull { get; }
        public int Length { get; }
        public byte this[int index] { get; }
        public byte[] Value { get; }
        public static SqlBinary Add(SqlBinary x, SqlBinary y);
        public int CompareTo(SqlBinary value);
        public int CompareTo(object value);
        public static SqlBinary Concat(SqlBinary x, SqlBinary y);
        public static SqlBoolean Equals(SqlBinary x, SqlBinary y);
        public override bool Equals(object value);
        public override int GetHashCode();
        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
        public static SqlBoolean GreaterThan(SqlBinary x, SqlBinary y);
        public static SqlBoolean GreaterThanOrEqual(SqlBinary x, SqlBinary y);
        public static SqlBoolean LessThan(SqlBinary x, SqlBinary y);
        public static SqlBoolean LessThanOrEqual(SqlBinary x, SqlBinary y);
        public static SqlBoolean NotEquals(SqlBinary x, SqlBinary y);
        public static SqlBinary operator +(SqlBinary x, SqlBinary y);
        public static SqlBoolean operator ==(SqlBinary x, SqlBinary y);
        public static explicit operator byte[] (SqlBinary x);
        public static explicit operator SqlBinary (SqlGuid x);
        public static SqlBoolean operator >(SqlBinary x, SqlBinary y);
        public static SqlBoolean operator >=(SqlBinary x, SqlBinary y);
        public static implicit operator SqlBinary (byte[] x);
        public static SqlBoolean operator !=(SqlBinary x, SqlBinary y);
        public static SqlBoolean operator <(SqlBinary x, SqlBinary y);
        public static SqlBoolean operator <=(SqlBinary x, SqlBinary y);
        XmlSchema System.Xml.Serialization.IXmlSerializable.GetSchema();
        void System.Xml.Serialization.IXmlSerializable.ReadXml(XmlReader reader);
        void System.Xml.Serialization.IXmlSerializable.WriteXml(XmlWriter writer);
        public SqlGuid ToSqlGuid();
        public override string ToString();
    }
    public struct SqlBoolean : IComparable, INullable, IXmlSerializable {
        public static readonly SqlBoolean False;
        public static readonly SqlBoolean Null;
        public static readonly SqlBoolean One;
        public static readonly SqlBoolean True;
        public static readonly SqlBoolean Zero;
        public SqlBoolean(bool value);
        public SqlBoolean(int value);
        public byte ByteValue { get; }
        public bool IsFalse { get; }
        public bool IsNull { get; }
        public bool IsTrue { get; }
        public bool Value { get; }
        public static SqlBoolean And(SqlBoolean x, SqlBoolean y);
        public int CompareTo(SqlBoolean value);
        public int CompareTo(object value);
        public static SqlBoolean Equals(SqlBoolean x, SqlBoolean y);
        public override bool Equals(object value);
        public override int GetHashCode();
        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
        public static SqlBoolean GreaterThan(SqlBoolean x, SqlBoolean y);
        public static SqlBoolean GreaterThanOrEquals(SqlBoolean x, SqlBoolean y);
        public static SqlBoolean LessThan(SqlBoolean x, SqlBoolean y);
        public static SqlBoolean LessThanOrEquals(SqlBoolean x, SqlBoolean y);
        public static SqlBoolean NotEquals(SqlBoolean x, SqlBoolean y);
        public static SqlBoolean OnesComplement(SqlBoolean x);
        public static SqlBoolean operator &(SqlBoolean x, SqlBoolean y);
        public static SqlBoolean operator |(SqlBoolean x, SqlBoolean y);
        public static SqlBoolean operator ==(SqlBoolean x, SqlBoolean y);
        public static SqlBoolean operator ^(SqlBoolean x, SqlBoolean y);
        public static explicit operator bool (SqlBoolean x);
        public static explicit operator SqlBoolean (SqlByte x);
        public static explicit operator SqlBoolean (SqlDecimal x);
        public static explicit operator SqlBoolean (SqlDouble x);
        public static explicit operator SqlBoolean (SqlInt16 x);
        public static explicit operator SqlBoolean (SqlInt32 x);
        public static explicit operator SqlBoolean (SqlInt64 x);
        public static explicit operator SqlBoolean (SqlMoney x);
        public static explicit operator SqlBoolean (SqlSingle x);
        public static explicit operator SqlBoolean (SqlString x);
        public static bool operator false(SqlBoolean x);
        public static SqlBoolean operator >(SqlBoolean x, SqlBoolean y);
        public static SqlBoolean operator >=(SqlBoolean x, SqlBoolean y);
        public static implicit operator SqlBoolean (bool x);
        public static SqlBoolean operator !=(SqlBoolean x, SqlBoolean y);
        public static SqlBoolean operator <(SqlBoolean x, SqlBoolean y);
        public static SqlBoolean operator <=(SqlBoolean x, SqlBoolean y);
        public static SqlBoolean operator !(SqlBoolean x);
        public static SqlBoolean operator ~(SqlBoolean x);
        public static bool operator true(SqlBoolean x);
        public static SqlBoolean Or(SqlBoolean x, SqlBoolean y);
        public static SqlBoolean Parse(string s);
        XmlSchema System.Xml.Serialization.IXmlSerializable.GetSchema();
        void System.Xml.Serialization.IXmlSerializable.ReadXml(XmlReader reader);
        void System.Xml.Serialization.IXmlSerializable.WriteXml(XmlWriter writer);
        public SqlByte ToSqlByte();
        public SqlDecimal ToSqlDecimal();
        public SqlDouble ToSqlDouble();
        public SqlInt16 ToSqlInt16();
        public SqlInt32 ToSqlInt32();
        public SqlInt64 ToSqlInt64();
        public SqlMoney ToSqlMoney();
        public SqlSingle ToSqlSingle();
        public SqlString ToSqlString();
        public override string ToString();
        public static SqlBoolean Xor(SqlBoolean x, SqlBoolean y);
    }
    public struct SqlByte : IComparable, INullable, IXmlSerializable {
        public static readonly SqlByte MaxValue;
        public static readonly SqlByte MinValue;
        public static readonly SqlByte Null;
        public static readonly SqlByte Zero;
        public SqlByte(byte value);
        public bool IsNull { get; }
        public byte Value { get; }
        public static SqlByte Add(SqlByte x, SqlByte y);
        public static SqlByte BitwiseAnd(SqlByte x, SqlByte y);
        public static SqlByte BitwiseOr(SqlByte x, SqlByte y);
        public int CompareTo(SqlByte value);
        public int CompareTo(object value);
        public static SqlByte Divide(SqlByte x, SqlByte y);
        public static SqlBoolean Equals(SqlByte x, SqlByte y);
        public override bool Equals(object value);
        public override int GetHashCode();
        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
        public static SqlBoolean GreaterThan(SqlByte x, SqlByte y);
        public static SqlBoolean GreaterThanOrEqual(SqlByte x, SqlByte y);
        public static SqlBoolean LessThan(SqlByte x, SqlByte y);
        public static SqlBoolean LessThanOrEqual(SqlByte x, SqlByte y);
        public static SqlByte Mod(SqlByte x, SqlByte y);
        public static SqlByte Modulus(SqlByte x, SqlByte y);
        public static SqlByte Multiply(SqlByte x, SqlByte y);
        public static SqlBoolean NotEquals(SqlByte x, SqlByte y);
        public static SqlByte OnesComplement(SqlByte x);
        public static SqlByte operator +(SqlByte x, SqlByte y);
        public static SqlByte operator &(SqlByte x, SqlByte y);
        public static SqlByte operator |(SqlByte x, SqlByte y);
        public static SqlByte operator /(SqlByte x, SqlByte y);
        public static SqlBoolean operator ==(SqlByte x, SqlByte y);
        public static SqlByte operator ^(SqlByte x, SqlByte y);
        public static explicit operator SqlByte (SqlBoolean x);
        public static explicit operator byte (SqlByte x);
        public static explicit operator SqlByte (SqlDecimal x);
        public static explicit operator SqlByte (SqlDouble x);
        public static explicit operator SqlByte (SqlInt16 x);
        public static explicit operator SqlByte (SqlInt32 x);
        public static explicit operator SqlByte (SqlInt64 x);
        public static explicit operator SqlByte (SqlMoney x);
        public static explicit operator SqlByte (SqlSingle x);
        public static explicit operator SqlByte (SqlString x);
        public static SqlBoolean operator >(SqlByte x, SqlByte y);
        public static SqlBoolean operator >=(SqlByte x, SqlByte y);
        public static implicit operator SqlByte (byte x);
        public static SqlBoolean operator !=(SqlByte x, SqlByte y);
        public static SqlBoolean operator <(SqlByte x, SqlByte y);
        public static SqlBoolean operator <=(SqlByte x, SqlByte y);
        public static SqlByte operator %(SqlByte x, SqlByte y);
        public static SqlByte operator *(SqlByte x, SqlByte y);
        public static SqlByte operator ~(SqlByte x);
        public static SqlByte operator -(SqlByte x, SqlByte y);
        public static SqlByte Parse(string s);
        public static SqlByte Subtract(SqlByte x, SqlByte y);
        XmlSchema System.Xml.Serialization.IXmlSerializable.GetSchema();
        void System.Xml.Serialization.IXmlSerializable.ReadXml(XmlReader reader);
        void System.Xml.Serialization.IXmlSerializable.WriteXml(XmlWriter writer);
        public SqlBoolean ToSqlBoolean();
        public SqlDecimal ToSqlDecimal();
        public SqlDouble ToSqlDouble();
        public SqlInt16 ToSqlInt16();
        public SqlInt32 ToSqlInt32();
        public SqlInt64 ToSqlInt64();
        public SqlMoney ToSqlMoney();
        public SqlSingle ToSqlSingle();
        public SqlString ToSqlString();
        public override string ToString();
        public static SqlByte Xor(SqlByte x, SqlByte y);
    }
    public sealed class SqlBytes : INullable, ISerializable, IXmlSerializable {
        public SqlBytes();
        public SqlBytes(byte[] buffer);
        public SqlBytes(SqlBinary value);
        public SqlBytes(Stream s);
        public byte[] Buffer { get; }
        public bool IsNull { get; }
        public long Length { get; }
        public long MaxLength { get; }
        public static SqlBytes Null { get; }
        public StorageState Storage { get; }
        public Stream Stream { get; set; }
        public byte this[long offset] { get; set; }
        public byte[] Value { get; }
        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
        public static explicit operator SqlBytes (SqlBinary value);
        public static explicit operator SqlBinary (SqlBytes value);
        public long Read(long offset, byte[] buffer, int offsetInBuffer, int count);
        public void SetLength(long value);
        public void SetNull();
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo info, StreamingContext context);
        XmlSchema System.Xml.Serialization.IXmlSerializable.GetSchema();
        void System.Xml.Serialization.IXmlSerializable.ReadXml(XmlReader r);
        void System.Xml.Serialization.IXmlSerializable.WriteXml(XmlWriter writer);
        public SqlBinary ToSqlBinary();
        public void Write(long offset, byte[] buffer, int offsetInBuffer, int count);
    }
    public sealed class SqlChars : INullable, ISerializable, IXmlSerializable {
        public SqlChars();
        public SqlChars(char[] buffer);
        public SqlChars(SqlString value);
        public char[] Buffer { get; }
        public bool IsNull { get; }
        public long Length { get; }
        public long MaxLength { get; }
        public static SqlChars Null { get; }
        public StorageState Storage { get; }
        public char this[long offset] { get; set; }
        public char[] Value { get; }
        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
        public static explicit operator SqlString (SqlChars value);
        public static explicit operator SqlChars (SqlString value);
        public long Read(long offset, char[] buffer, int offsetInBuffer, int count);
        public void SetLength(long value);
        public void SetNull();
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo info, StreamingContext context);
        XmlSchema System.Xml.Serialization.IXmlSerializable.GetSchema();
        void System.Xml.Serialization.IXmlSerializable.ReadXml(XmlReader r);
        void System.Xml.Serialization.IXmlSerializable.WriteXml(XmlWriter writer);
        public SqlString ToSqlString();
        public void Write(long offset, char[] buffer, int offsetInBuffer, int count);
    }
    public enum SqlCompareOptions {
        BinarySort = 32768,
        BinarySort2 = 16384,
        IgnoreCase = 1,
        IgnoreKanaType = 8,
        IgnoreNonSpace = 2,
        IgnoreWidth = 16,
        None = 0,
    }
    public struct SqlDateTime : IComparable, INullable, IXmlSerializable {
        public static readonly SqlDateTime MaxValue;
        public static readonly SqlDateTime MinValue;
        public static readonly SqlDateTime Null;
        public static readonly int SQLTicksPerHour;
        public static readonly int SQLTicksPerMinute;
        public static readonly int SQLTicksPerSecond;
        public SqlDateTime(DateTime value);
        public SqlDateTime(int dayTicks, int timeTicks);
        public SqlDateTime(int year, int month, int day);
        public SqlDateTime(int year, int month, int day, int hour, int minute, int second);
        public SqlDateTime(int year, int month, int day, int hour, int minute, int second, double millisecond);
        public SqlDateTime(int year, int month, int day, int hour, int minute, int second, int bilisecond);
        public int DayTicks { get; }
        public bool IsNull { get; }
        public int TimeTicks { get; }
        public DateTime Value { get; }
        public static SqlDateTime Add(SqlDateTime x, TimeSpan t);
        public int CompareTo(SqlDateTime value);
        public int CompareTo(object value);
        public static SqlBoolean Equals(SqlDateTime x, SqlDateTime y);
        public override bool Equals(object value);
        public override int GetHashCode();
        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
        public static SqlBoolean GreaterThan(SqlDateTime x, SqlDateTime y);
        public static SqlBoolean GreaterThanOrEqual(SqlDateTime x, SqlDateTime y);
        public static SqlBoolean LessThan(SqlDateTime x, SqlDateTime y);
        public static SqlBoolean LessThanOrEqual(SqlDateTime x, SqlDateTime y);
        public static SqlBoolean NotEquals(SqlDateTime x, SqlDateTime y);
        public static SqlDateTime operator +(SqlDateTime x, TimeSpan t);
        public static SqlBoolean operator ==(SqlDateTime x, SqlDateTime y);
        public static explicit operator DateTime (SqlDateTime x);
        public static explicit operator SqlDateTime (SqlString x);
        public static SqlBoolean operator >(SqlDateTime x, SqlDateTime y);
        public static SqlBoolean operator >=(SqlDateTime x, SqlDateTime y);
        public static implicit operator SqlDateTime (DateTime value);
        public static SqlBoolean operator !=(SqlDateTime x, SqlDateTime y);
        public static SqlBoolean operator <(SqlDateTime x, SqlDateTime y);
        public static SqlBoolean operator <=(SqlDateTime x, SqlDateTime y);
        public static SqlDateTime operator -(SqlDateTime x, TimeSpan t);
        public static SqlDateTime Parse(string s);
        public static SqlDateTime Subtract(SqlDateTime x, TimeSpan t);
        XmlSchema System.Xml.Serialization.IXmlSerializable.GetSchema();
        void System.Xml.Serialization.IXmlSerializable.ReadXml(XmlReader reader);
        void System.Xml.Serialization.IXmlSerializable.WriteXml(XmlWriter writer);
        public SqlString ToSqlString();
        public override string ToString();
    }
    public struct SqlDecimal : IComparable, INullable, IXmlSerializable {
        public static readonly byte MaxPrecision;
        public static readonly byte MaxScale;
        public static readonly SqlDecimal MaxValue;
        public static readonly SqlDecimal MinValue;
        public static readonly SqlDecimal Null;
        public SqlDecimal(byte bPrecision, byte bScale, bool fPositive, int data1, int data2, int data3, int data4);
        public SqlDecimal(byte bPrecision, byte bScale, bool fPositive, int[] bits);
        public SqlDecimal(decimal value);
        public SqlDecimal(double dVal);
        public SqlDecimal(int value);
        public SqlDecimal(long value);
        public byte[] BinData { get; }
        public int[] Data { get; }
        public bool IsNull { get; }
        public bool IsPositive { get; }
        public byte Precision { get; }
        public byte Scale { get; }
        public decimal Value { get; }
        public static SqlDecimal Abs(SqlDecimal n);
        public static SqlDecimal Add(SqlDecimal x, SqlDecimal y);
        public static SqlDecimal AdjustScale(SqlDecimal n, int digits, bool fRound);
        public static SqlDecimal Ceiling(SqlDecimal n);
        public int CompareTo(SqlDecimal value);
        public int CompareTo(object value);
        public static SqlDecimal ConvertToPrecScale(SqlDecimal n, int precision, int scale);
        public static SqlDecimal Divide(SqlDecimal x, SqlDecimal y);
        public static SqlBoolean Equals(SqlDecimal x, SqlDecimal y);
        public override bool Equals(object value);
        public static SqlDecimal Floor(SqlDecimal n);
        public override int GetHashCode();
        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
        public static SqlBoolean GreaterThan(SqlDecimal x, SqlDecimal y);
        public static SqlBoolean GreaterThanOrEqual(SqlDecimal x, SqlDecimal y);
        public static SqlBoolean LessThan(SqlDecimal x, SqlDecimal y);
        public static SqlBoolean LessThanOrEqual(SqlDecimal x, SqlDecimal y);
        public static SqlDecimal Multiply(SqlDecimal x, SqlDecimal y);
        public static SqlBoolean NotEquals(SqlDecimal x, SqlDecimal y);
        public static SqlDecimal operator +(SqlDecimal x, SqlDecimal y);
        public static SqlDecimal operator /(SqlDecimal x, SqlDecimal y);
        public static SqlBoolean operator ==(SqlDecimal x, SqlDecimal y);
        public static explicit operator SqlDecimal (SqlBoolean x);
        public static explicit operator decimal (SqlDecimal x);
        public static explicit operator SqlDecimal (SqlDouble x);
        public static explicit operator SqlDecimal (SqlSingle x);
        public static explicit operator SqlDecimal (SqlString x);
        public static explicit operator SqlDecimal (double x);
        public static SqlBoolean operator >(SqlDecimal x, SqlDecimal y);
        public static SqlBoolean operator >=(SqlDecimal x, SqlDecimal y);
        public static implicit operator SqlDecimal (SqlByte x);
        public static implicit operator SqlDecimal (SqlInt16 x);
        public static implicit operator SqlDecimal (SqlInt32 x);
        public static implicit operator SqlDecimal (SqlInt64 x);
        public static implicit operator SqlDecimal (SqlMoney x);
        public static implicit operator SqlDecimal (decimal x);
        public static implicit operator SqlDecimal (long x);
        public static SqlBoolean operator !=(SqlDecimal x, SqlDecimal y);
        public static SqlBoolean operator <(SqlDecimal x, SqlDecimal y);
        public static SqlBoolean operator <=(SqlDecimal x, SqlDecimal y);
        public static SqlDecimal operator *(SqlDecimal x, SqlDecimal y);
        public static SqlDecimal operator -(SqlDecimal x, SqlDecimal y);
        public static SqlDecimal operator -(SqlDecimal x);
        public static SqlDecimal Parse(string s);
        public static SqlDecimal Power(SqlDecimal n, double exp);
        public static SqlDecimal Round(SqlDecimal n, int position);
        public static SqlInt32 Sign(SqlDecimal n);
        public static SqlDecimal Subtract(SqlDecimal x, SqlDecimal y);
        XmlSchema System.Xml.Serialization.IXmlSerializable.GetSchema();
        void System.Xml.Serialization.IXmlSerializable.ReadXml(XmlReader reader);
        void System.Xml.Serialization.IXmlSerializable.WriteXml(XmlWriter writer);
        public double ToDouble();
        public SqlBoolean ToSqlBoolean();
        public SqlByte ToSqlByte();
        public SqlDouble ToSqlDouble();
        public SqlInt16 ToSqlInt16();
        public SqlInt32 ToSqlInt32();
        public SqlInt64 ToSqlInt64();
        public SqlMoney ToSqlMoney();
        public SqlSingle ToSqlSingle();
        public SqlString ToSqlString();
        public override string ToString();
        public static SqlDecimal Truncate(SqlDecimal n, int position);
    }
    public struct SqlDouble : IComparable, INullable, IXmlSerializable {
        public static readonly SqlDouble MaxValue;
        public static readonly SqlDouble MinValue;
        public static readonly SqlDouble Null;
        public static readonly SqlDouble Zero;
        public SqlDouble(double value);
        public bool IsNull { get; }
        public double Value { get; }
        public static SqlDouble Add(SqlDouble x, SqlDouble y);
        public int CompareTo(SqlDouble value);
        public int CompareTo(object value);
        public static SqlDouble Divide(SqlDouble x, SqlDouble y);
        public static SqlBoolean Equals(SqlDouble x, SqlDouble y);
        public override bool Equals(object value);
        public override int GetHashCode();
        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
        public static SqlBoolean GreaterThan(SqlDouble x, SqlDouble y);
        public static SqlBoolean GreaterThanOrEqual(SqlDouble x, SqlDouble y);
        public static SqlBoolean LessThan(SqlDouble x, SqlDouble y);
        public static SqlBoolean LessThanOrEqual(SqlDouble x, SqlDouble y);
        public static SqlDouble Multiply(SqlDouble x, SqlDouble y);
        public static SqlBoolean NotEquals(SqlDouble x, SqlDouble y);
        public static SqlDouble operator +(SqlDouble x, SqlDouble y);
        public static SqlDouble operator /(SqlDouble x, SqlDouble y);
        public static SqlBoolean operator ==(SqlDouble x, SqlDouble y);
        public static explicit operator SqlDouble (SqlBoolean x);
        public static explicit operator double (SqlDouble x);
        public static explicit operator SqlDouble (SqlString x);
        public static SqlBoolean operator >(SqlDouble x, SqlDouble y);
        public static SqlBoolean operator >=(SqlDouble x, SqlDouble y);
        public static implicit operator SqlDouble (SqlByte x);
        public static implicit operator SqlDouble (SqlDecimal x);
        public static implicit operator SqlDouble (SqlInt16 x);
        public static implicit operator SqlDouble (SqlInt32 x);
        public static implicit operator SqlDouble (SqlInt64 x);
        public static implicit operator SqlDouble (SqlMoney x);
        public static implicit operator SqlDouble (SqlSingle x);
        public static implicit operator SqlDouble (double x);
        public static SqlBoolean operator !=(SqlDouble x, SqlDouble y);
        public static SqlBoolean operator <(SqlDouble x, SqlDouble y);
        public static SqlBoolean operator <=(SqlDouble x, SqlDouble y);
        public static SqlDouble operator *(SqlDouble x, SqlDouble y);
        public static SqlDouble operator -(SqlDouble x, SqlDouble y);
        public static SqlDouble operator -(SqlDouble x);
        public static SqlDouble Parse(string s);
        public static SqlDouble Subtract(SqlDouble x, SqlDouble y);
        XmlSchema System.Xml.Serialization.IXmlSerializable.GetSchema();
        void System.Xml.Serialization.IXmlSerializable.ReadXml(XmlReader reader);
        void System.Xml.Serialization.IXmlSerializable.WriteXml(XmlWriter writer);
        public SqlBoolean ToSqlBoolean();
        public SqlByte ToSqlByte();
        public SqlDecimal ToSqlDecimal();
        public SqlInt16 ToSqlInt16();
        public SqlInt32 ToSqlInt32();
        public SqlInt64 ToSqlInt64();
        public SqlMoney ToSqlMoney();
        public SqlSingle ToSqlSingle();
        public SqlString ToSqlString();
        public override string ToString();
    }
    public struct SqlGuid : IComparable, INullable, IXmlSerializable {
        public static readonly SqlGuid Null;
        public SqlGuid(byte[] value);
        public SqlGuid(Guid g);
        public SqlGuid(int a, short b, short c, byte d, byte e, byte f, byte g, byte h, byte i, byte j, byte k);
        public SqlGuid(string s);
        public bool IsNull { get; }
        public Guid Value { get; }
        public int CompareTo(SqlGuid value);
        public int CompareTo(object value);
        public static SqlBoolean Equals(SqlGuid x, SqlGuid y);
        public override bool Equals(object value);
        public override int GetHashCode();
        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
        public static SqlBoolean GreaterThan(SqlGuid x, SqlGuid y);
        public static SqlBoolean GreaterThanOrEqual(SqlGuid x, SqlGuid y);
        public static SqlBoolean LessThan(SqlGuid x, SqlGuid y);
        public static SqlBoolean LessThanOrEqual(SqlGuid x, SqlGuid y);
        public static SqlBoolean NotEquals(SqlGuid x, SqlGuid y);
        public static SqlBoolean operator ==(SqlGuid x, SqlGuid y);
        public static explicit operator SqlGuid (SqlBinary x);
        public static explicit operator Guid (SqlGuid x);
        public static explicit operator SqlGuid (SqlString x);
        public static SqlBoolean operator >(SqlGuid x, SqlGuid y);
        public static SqlBoolean operator >=(SqlGuid x, SqlGuid y);
        public static implicit operator SqlGuid (Guid x);
        public static SqlBoolean operator !=(SqlGuid x, SqlGuid y);
        public static SqlBoolean operator <(SqlGuid x, SqlGuid y);
        public static SqlBoolean operator <=(SqlGuid x, SqlGuid y);
        public static SqlGuid Parse(string s);
        XmlSchema System.Xml.Serialization.IXmlSerializable.GetSchema();
        void System.Xml.Serialization.IXmlSerializable.ReadXml(XmlReader reader);
        void System.Xml.Serialization.IXmlSerializable.WriteXml(XmlWriter writer);
        public byte[] ToByteArray();
        public SqlBinary ToSqlBinary();
        public SqlString ToSqlString();
        public override string ToString();
    }
    public struct SqlInt16 : IComparable, INullable, IXmlSerializable {
        public static readonly SqlInt16 MaxValue;
        public static readonly SqlInt16 MinValue;
        public static readonly SqlInt16 Null;
        public static readonly SqlInt16 Zero;
        public SqlInt16(short value);
        public bool IsNull { get; }
        public short Value { get; }
        public static SqlInt16 Add(SqlInt16 x, SqlInt16 y);
        public static SqlInt16 BitwiseAnd(SqlInt16 x, SqlInt16 y);
        public static SqlInt16 BitwiseOr(SqlInt16 x, SqlInt16 y);
        public int CompareTo(SqlInt16 value);
        public int CompareTo(object value);
        public static SqlInt16 Divide(SqlInt16 x, SqlInt16 y);
        public static SqlBoolean Equals(SqlInt16 x, SqlInt16 y);
        public override bool Equals(object value);
        public override int GetHashCode();
        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
        public static SqlBoolean GreaterThan(SqlInt16 x, SqlInt16 y);
        public static SqlBoolean GreaterThanOrEqual(SqlInt16 x, SqlInt16 y);
        public static SqlBoolean LessThan(SqlInt16 x, SqlInt16 y);
        public static SqlBoolean LessThanOrEqual(SqlInt16 x, SqlInt16 y);
        public static SqlInt16 Mod(SqlInt16 x, SqlInt16 y);
        public static SqlInt16 Modulus(SqlInt16 x, SqlInt16 y);
        public static SqlInt16 Multiply(SqlInt16 x, SqlInt16 y);
        public static SqlBoolean NotEquals(SqlInt16 x, SqlInt16 y);
        public static SqlInt16 OnesComplement(SqlInt16 x);
        public static SqlInt16 operator +(SqlInt16 x, SqlInt16 y);
        public static SqlInt16 operator &(SqlInt16 x, SqlInt16 y);
        public static SqlInt16 operator |(SqlInt16 x, SqlInt16 y);
        public static SqlInt16 operator /(SqlInt16 x, SqlInt16 y);
        public static SqlBoolean operator ==(SqlInt16 x, SqlInt16 y);
        public static SqlInt16 operator ^(SqlInt16 x, SqlInt16 y);
        public static explicit operator SqlInt16 (SqlBoolean x);
        public static explicit operator SqlInt16 (SqlDecimal x);
        public static explicit operator SqlInt16 (SqlDouble x);
        public static explicit operator short (SqlInt16 x);
        public static explicit operator SqlInt16 (SqlInt32 x);
        public static explicit operator SqlInt16 (SqlInt64 x);
        public static explicit operator SqlInt16 (SqlMoney x);
        public static explicit operator SqlInt16 (SqlSingle x);
        public static explicit operator SqlInt16 (SqlString x);
        public static SqlBoolean operator >(SqlInt16 x, SqlInt16 y);
        public static SqlBoolean operator >=(SqlInt16 x, SqlInt16 y);
        public static implicit operator SqlInt16 (SqlByte x);
        public static implicit operator SqlInt16 (short x);
        public static SqlBoolean operator !=(SqlInt16 x, SqlInt16 y);
        public static SqlBoolean operator <(SqlInt16 x, SqlInt16 y);
        public static SqlBoolean operator <=(SqlInt16 x, SqlInt16 y);
        public static SqlInt16 operator %(SqlInt16 x, SqlInt16 y);
        public static SqlInt16 operator *(SqlInt16 x, SqlInt16 y);
        public static SqlInt16 operator ~(SqlInt16 x);
        public static SqlInt16 operator -(SqlInt16 x, SqlInt16 y);
        public static SqlInt16 operator -(SqlInt16 x);
        public static SqlInt16 Parse(string s);
        public static SqlInt16 Subtract(SqlInt16 x, SqlInt16 y);
        XmlSchema System.Xml.Serialization.IXmlSerializable.GetSchema();
        void System.Xml.Serialization.IXmlSerializable.ReadXml(XmlReader reader);
        void System.Xml.Serialization.IXmlSerializable.WriteXml(XmlWriter writer);
        public SqlBoolean ToSqlBoolean();
        public SqlByte ToSqlByte();
        public SqlDecimal ToSqlDecimal();
        public SqlDouble ToSqlDouble();
        public SqlInt32 ToSqlInt32();
        public SqlInt64 ToSqlInt64();
        public SqlMoney ToSqlMoney();
        public SqlSingle ToSqlSingle();
        public SqlString ToSqlString();
        public override string ToString();
        public static SqlInt16 Xor(SqlInt16 x, SqlInt16 y);
    }
    public struct SqlInt32 : IComparable, INullable, IXmlSerializable {
        public static readonly SqlInt32 MaxValue;
        public static readonly SqlInt32 MinValue;
        public static readonly SqlInt32 Null;
        public static readonly SqlInt32 Zero;
        public SqlInt32(int value);
        public bool IsNull { get; }
        public int Value { get; }
        public static SqlInt32 Add(SqlInt32 x, SqlInt32 y);
        public static SqlInt32 BitwiseAnd(SqlInt32 x, SqlInt32 y);
        public static SqlInt32 BitwiseOr(SqlInt32 x, SqlInt32 y);
        public int CompareTo(SqlInt32 value);
        public int CompareTo(object value);
        public static SqlInt32 Divide(SqlInt32 x, SqlInt32 y);
        public static SqlBoolean Equals(SqlInt32 x, SqlInt32 y);
        public override bool Equals(object value);
        public override int GetHashCode();
        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
        public static SqlBoolean GreaterThan(SqlInt32 x, SqlInt32 y);
        public static SqlBoolean GreaterThanOrEqual(SqlInt32 x, SqlInt32 y);
        public static SqlBoolean LessThan(SqlInt32 x, SqlInt32 y);
        public static SqlBoolean LessThanOrEqual(SqlInt32 x, SqlInt32 y);
        public static SqlInt32 Mod(SqlInt32 x, SqlInt32 y);
        public static SqlInt32 Modulus(SqlInt32 x, SqlInt32 y);
        public static SqlInt32 Multiply(SqlInt32 x, SqlInt32 y);
        public static SqlBoolean NotEquals(SqlInt32 x, SqlInt32 y);
        public static SqlInt32 OnesComplement(SqlInt32 x);
        public static SqlInt32 operator +(SqlInt32 x, SqlInt32 y);
        public static SqlInt32 operator &(SqlInt32 x, SqlInt32 y);
        public static SqlInt32 operator |(SqlInt32 x, SqlInt32 y);
        public static SqlInt32 operator /(SqlInt32 x, SqlInt32 y);
        public static SqlBoolean operator ==(SqlInt32 x, SqlInt32 y);
        public static SqlInt32 operator ^(SqlInt32 x, SqlInt32 y);
        public static explicit operator SqlInt32 (SqlBoolean x);
        public static explicit operator SqlInt32 (SqlDecimal x);
        public static explicit operator SqlInt32 (SqlDouble x);
        public static explicit operator int (SqlInt32 x);
        public static explicit operator SqlInt32 (SqlInt64 x);
        public static explicit operator SqlInt32 (SqlMoney x);
        public static explicit operator SqlInt32 (SqlSingle x);
        public static explicit operator SqlInt32 (SqlString x);
        public static SqlBoolean operator >(SqlInt32 x, SqlInt32 y);
        public static SqlBoolean operator >=(SqlInt32 x, SqlInt32 y);
        public static implicit operator SqlInt32 (SqlByte x);
        public static implicit operator SqlInt32 (SqlInt16 x);
        public static implicit operator SqlInt32 (int x);
        public static SqlBoolean operator !=(SqlInt32 x, SqlInt32 y);
        public static SqlBoolean operator <(SqlInt32 x, SqlInt32 y);
        public static SqlBoolean operator <=(SqlInt32 x, SqlInt32 y);
        public static SqlInt32 operator %(SqlInt32 x, SqlInt32 y);
        public static SqlInt32 operator *(SqlInt32 x, SqlInt32 y);
        public static SqlInt32 operator ~(SqlInt32 x);
        public static SqlInt32 operator -(SqlInt32 x, SqlInt32 y);
        public static SqlInt32 operator -(SqlInt32 x);
        public static SqlInt32 Parse(string s);
        public static SqlInt32 Subtract(SqlInt32 x, SqlInt32 y);
        XmlSchema System.Xml.Serialization.IXmlSerializable.GetSchema();
        void System.Xml.Serialization.IXmlSerializable.ReadXml(XmlReader reader);
        void System.Xml.Serialization.IXmlSerializable.WriteXml(XmlWriter writer);
        public SqlBoolean ToSqlBoolean();
        public SqlByte ToSqlByte();
        public SqlDecimal ToSqlDecimal();
        public SqlDouble ToSqlDouble();
        public SqlInt16 ToSqlInt16();
        public SqlInt64 ToSqlInt64();
        public SqlMoney ToSqlMoney();
        public SqlSingle ToSqlSingle();
        public SqlString ToSqlString();
        public override string ToString();
        public static SqlInt32 Xor(SqlInt32 x, SqlInt32 y);
    }
    public struct SqlInt64 : IComparable, INullable, IXmlSerializable {
        public static readonly SqlInt64 MaxValue;
        public static readonly SqlInt64 MinValue;
        public static readonly SqlInt64 Null;
        public static readonly SqlInt64 Zero;
        public SqlInt64(long value);
        public bool IsNull { get; }
        public long Value { get; }
        public static SqlInt64 Add(SqlInt64 x, SqlInt64 y);
        public static SqlInt64 BitwiseAnd(SqlInt64 x, SqlInt64 y);
        public static SqlInt64 BitwiseOr(SqlInt64 x, SqlInt64 y);
        public int CompareTo(SqlInt64 value);
        public int CompareTo(object value);
        public static SqlInt64 Divide(SqlInt64 x, SqlInt64 y);
        public static SqlBoolean Equals(SqlInt64 x, SqlInt64 y);
        public override bool Equals(object value);
        public override int GetHashCode();
        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
        public static SqlBoolean GreaterThan(SqlInt64 x, SqlInt64 y);
        public static SqlBoolean GreaterThanOrEqual(SqlInt64 x, SqlInt64 y);
        public static SqlBoolean LessThan(SqlInt64 x, SqlInt64 y);
        public static SqlBoolean LessThanOrEqual(SqlInt64 x, SqlInt64 y);
        public static SqlInt64 Mod(SqlInt64 x, SqlInt64 y);
        public static SqlInt64 Modulus(SqlInt64 x, SqlInt64 y);
        public static SqlInt64 Multiply(SqlInt64 x, SqlInt64 y);
        public static SqlBoolean NotEquals(SqlInt64 x, SqlInt64 y);
        public static SqlInt64 OnesComplement(SqlInt64 x);
        public static SqlInt64 operator +(SqlInt64 x, SqlInt64 y);
        public static SqlInt64 operator &(SqlInt64 x, SqlInt64 y);
        public static SqlInt64 operator |(SqlInt64 x, SqlInt64 y);
        public static SqlInt64 operator /(SqlInt64 x, SqlInt64 y);
        public static SqlBoolean operator ==(SqlInt64 x, SqlInt64 y);
        public static SqlInt64 operator ^(SqlInt64 x, SqlInt64 y);
        public static explicit operator SqlInt64 (SqlBoolean x);
        public static explicit operator SqlInt64 (SqlDecimal x);
        public static explicit operator SqlInt64 (SqlDouble x);
        public static explicit operator long (SqlInt64 x);
        public static explicit operator SqlInt64 (SqlMoney x);
        public static explicit operator SqlInt64 (SqlSingle x);
        public static explicit operator SqlInt64 (SqlString x);
        public static SqlBoolean operator >(SqlInt64 x, SqlInt64 y);
        public static SqlBoolean operator >=(SqlInt64 x, SqlInt64 y);
        public static implicit operator SqlInt64 (SqlByte x);
        public static implicit operator SqlInt64 (SqlInt16 x);
        public static implicit operator SqlInt64 (SqlInt32 x);
        public static implicit operator SqlInt64 (long x);
        public static SqlBoolean operator !=(SqlInt64 x, SqlInt64 y);
        public static SqlBoolean operator <(SqlInt64 x, SqlInt64 y);
        public static SqlBoolean operator <=(SqlInt64 x, SqlInt64 y);
        public static SqlInt64 operator %(SqlInt64 x, SqlInt64 y);
        public static SqlInt64 operator *(SqlInt64 x, SqlInt64 y);
        public static SqlInt64 operator ~(SqlInt64 x);
        public static SqlInt64 operator -(SqlInt64 x, SqlInt64 y);
        public static SqlInt64 operator -(SqlInt64 x);
        public static SqlInt64 Parse(string s);
        public static SqlInt64 Subtract(SqlInt64 x, SqlInt64 y);
        XmlSchema System.Xml.Serialization.IXmlSerializable.GetSchema();
        void System.Xml.Serialization.IXmlSerializable.ReadXml(XmlReader reader);
        void System.Xml.Serialization.IXmlSerializable.WriteXml(XmlWriter writer);
        public SqlBoolean ToSqlBoolean();
        public SqlByte ToSqlByte();
        public SqlDecimal ToSqlDecimal();
        public SqlDouble ToSqlDouble();
        public SqlInt16 ToSqlInt16();
        public SqlInt32 ToSqlInt32();
        public SqlMoney ToSqlMoney();
        public SqlSingle ToSqlSingle();
        public SqlString ToSqlString();
        public override string ToString();
        public static SqlInt64 Xor(SqlInt64 x, SqlInt64 y);
    }
    public struct SqlMoney : IComparable, INullable, IXmlSerializable {
        public static readonly SqlMoney MaxValue;
        public static readonly SqlMoney MinValue;
        public static readonly SqlMoney Null;
        public static readonly SqlMoney Zero;
        public SqlMoney(decimal value);
        public SqlMoney(double value);
        public SqlMoney(int value);
        public SqlMoney(long value);
        public bool IsNull { get; }
        public decimal Value { get; }
        public static SqlMoney Add(SqlMoney x, SqlMoney y);
        public int CompareTo(SqlMoney value);
        public int CompareTo(object value);
        public static SqlMoney Divide(SqlMoney x, SqlMoney y);
        public static SqlBoolean Equals(SqlMoney x, SqlMoney y);
        public override bool Equals(object value);
        public override int GetHashCode();
        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
        public static SqlBoolean GreaterThan(SqlMoney x, SqlMoney y);
        public static SqlBoolean GreaterThanOrEqual(SqlMoney x, SqlMoney y);
        public static SqlBoolean LessThan(SqlMoney x, SqlMoney y);
        public static SqlBoolean LessThanOrEqual(SqlMoney x, SqlMoney y);
        public static SqlMoney Multiply(SqlMoney x, SqlMoney y);
        public static SqlBoolean NotEquals(SqlMoney x, SqlMoney y);
        public static SqlMoney operator +(SqlMoney x, SqlMoney y);
        public static SqlMoney operator /(SqlMoney x, SqlMoney y);
        public static SqlBoolean operator ==(SqlMoney x, SqlMoney y);
        public static explicit operator SqlMoney (SqlBoolean x);
        public static explicit operator SqlMoney (SqlDecimal x);
        public static explicit operator SqlMoney (SqlDouble x);
        public static explicit operator decimal (SqlMoney x);
        public static explicit operator SqlMoney (SqlSingle x);
        public static explicit operator SqlMoney (SqlString x);
        public static explicit operator SqlMoney (double x);
        public static SqlBoolean operator >(SqlMoney x, SqlMoney y);
        public static SqlBoolean operator >=(SqlMoney x, SqlMoney y);
        public static implicit operator SqlMoney (SqlByte x);
        public static implicit operator SqlMoney (SqlInt16 x);
        public static implicit operator SqlMoney (SqlInt32 x);
        public static implicit operator SqlMoney (SqlInt64 x);
        public static implicit operator SqlMoney (decimal x);
        public static implicit operator SqlMoney (long x);
        public static SqlBoolean operator !=(SqlMoney x, SqlMoney y);
        public static SqlBoolean operator <(SqlMoney x, SqlMoney y);
        public static SqlBoolean operator <=(SqlMoney x, SqlMoney y);
        public static SqlMoney operator *(SqlMoney x, SqlMoney y);
        public static SqlMoney operator -(SqlMoney x, SqlMoney y);
        public static SqlMoney operator -(SqlMoney x);
        public static SqlMoney Parse(string s);
        public static SqlMoney Subtract(SqlMoney x, SqlMoney y);
        XmlSchema System.Xml.Serialization.IXmlSerializable.GetSchema();
        void System.Xml.Serialization.IXmlSerializable.ReadXml(XmlReader reader);
        void System.Xml.Serialization.IXmlSerializable.WriteXml(XmlWriter writer);
        public decimal ToDecimal();
        public double ToDouble();
        public int ToInt32();
        public long ToInt64();
        public SqlBoolean ToSqlBoolean();
        public SqlByte ToSqlByte();
        public SqlDecimal ToSqlDecimal();
        public SqlDouble ToSqlDouble();
        public SqlInt16 ToSqlInt16();
        public SqlInt32 ToSqlInt32();
        public SqlInt64 ToSqlInt64();
        public SqlSingle ToSqlSingle();
        public SqlString ToSqlString();
        public override string ToString();
    }
    public sealed class SqlNotFilledException : SqlTypeException {
        public SqlNotFilledException();
        public SqlNotFilledException(string message);
        public SqlNotFilledException(string message, Exception e);
    }
    public sealed class SqlNullValueException : SqlTypeException {
        public SqlNullValueException();
        public SqlNullValueException(string message);
        public SqlNullValueException(string message, Exception e);
    }
    public struct SqlSingle : IComparable, INullable, IXmlSerializable {
        public static readonly SqlSingle MaxValue;
        public static readonly SqlSingle MinValue;
        public static readonly SqlSingle Null;
        public static readonly SqlSingle Zero;
        public SqlSingle(double value);
        public SqlSingle(float value);
        public bool IsNull { get; }
        public float Value { get; }
        public static SqlSingle Add(SqlSingle x, SqlSingle y);
        public int CompareTo(SqlSingle value);
        public int CompareTo(object value);
        public static SqlSingle Divide(SqlSingle x, SqlSingle y);
        public static SqlBoolean Equals(SqlSingle x, SqlSingle y);
        public override bool Equals(object value);
        public override int GetHashCode();
        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
        public static SqlBoolean GreaterThan(SqlSingle x, SqlSingle y);
        public static SqlBoolean GreaterThanOrEqual(SqlSingle x, SqlSingle y);
        public static SqlBoolean LessThan(SqlSingle x, SqlSingle y);
        public static SqlBoolean LessThanOrEqual(SqlSingle x, SqlSingle y);
        public static SqlSingle Multiply(SqlSingle x, SqlSingle y);
        public static SqlBoolean NotEquals(SqlSingle x, SqlSingle y);
        public static SqlSingle operator +(SqlSingle x, SqlSingle y);
        public static SqlSingle operator /(SqlSingle x, SqlSingle y);
        public static SqlBoolean operator ==(SqlSingle x, SqlSingle y);
        public static explicit operator SqlSingle (SqlBoolean x);
        public static explicit operator SqlSingle (SqlDouble x);
        public static explicit operator float (SqlSingle x);
        public static explicit operator SqlSingle (SqlString x);
        public static SqlBoolean operator >(SqlSingle x, SqlSingle y);
        public static SqlBoolean operator >=(SqlSingle x, SqlSingle y);
        public static implicit operator SqlSingle (SqlByte x);
        public static implicit operator SqlSingle (SqlDecimal x);
        public static implicit operator SqlSingle (SqlInt16 x);
        public static implicit operator SqlSingle (SqlInt32 x);
        public static implicit operator SqlSingle (SqlInt64 x);
        public static implicit operator SqlSingle (SqlMoney x);
        public static implicit operator SqlSingle (float x);
        public static SqlBoolean operator !=(SqlSingle x, SqlSingle y);
        public static SqlBoolean operator <(SqlSingle x, SqlSingle y);
        public static SqlBoolean operator <=(SqlSingle x, SqlSingle y);
        public static SqlSingle operator *(SqlSingle x, SqlSingle y);
        public static SqlSingle operator -(SqlSingle x, SqlSingle y);
        public static SqlSingle operator -(SqlSingle x);
        public static SqlSingle Parse(string s);
        public static SqlSingle Subtract(SqlSingle x, SqlSingle y);
        XmlSchema System.Xml.Serialization.IXmlSerializable.GetSchema();
        void System.Xml.Serialization.IXmlSerializable.ReadXml(XmlReader reader);
        void System.Xml.Serialization.IXmlSerializable.WriteXml(XmlWriter writer);
        public SqlBoolean ToSqlBoolean();
        public SqlByte ToSqlByte();
        public SqlDecimal ToSqlDecimal();
        public SqlDouble ToSqlDouble();
        public SqlInt16 ToSqlInt16();
        public SqlInt32 ToSqlInt32();
        public SqlInt64 ToSqlInt64();
        public SqlMoney ToSqlMoney();
        public SqlString ToSqlString();
        public override string ToString();
    }
    public struct SqlString : IComparable, INullable, IXmlSerializable {
        public static readonly SqlString Null;
        public static readonly int BinarySort;
        public static readonly int BinarySort2;
        public static readonly int IgnoreCase;
        public static readonly int IgnoreKanaType;
        public static readonly int IgnoreNonSpace;
        public static readonly int IgnoreWidth;
        public SqlString(int lcid, SqlCompareOptions compareOptions, byte[] data);
        public SqlString(int lcid, SqlCompareOptions compareOptions, byte[] data, bool fUnicode);
        public SqlString(int lcid, SqlCompareOptions compareOptions, byte[] data, int index, int count);
        public SqlString(int lcid, SqlCompareOptions compareOptions, byte[] data, int index, int count, bool fUnicode);
        public SqlString(string data);
        public SqlString(string data, int lcid);
        public SqlString(string data, int lcid, SqlCompareOptions compareOptions);
        public CompareInfo CompareInfo { get; }
        public CultureInfo CultureInfo { get; }
        public bool IsNull { get; }
        public int LCID { get; }
        public SqlCompareOptions SqlCompareOptions { get; }
        public string Value { get; }
        public static SqlString Add(SqlString x, SqlString y);
        public SqlString Clone();
        public static CompareOptions CompareOptionsFromSqlCompareOptions(SqlCompareOptions compareOptions);
        public int CompareTo(SqlString value);
        public int CompareTo(object value);
        public static SqlString Concat(SqlString x, SqlString y);
        public static SqlBoolean Equals(SqlString x, SqlString y);
        public override bool Equals(object value);
        public override int GetHashCode();
        public byte[] GetNonUnicodeBytes();
        public byte[] GetUnicodeBytes();
        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
        public static SqlBoolean GreaterThan(SqlString x, SqlString y);
        public static SqlBoolean GreaterThanOrEqual(SqlString x, SqlString y);
        public static SqlBoolean LessThan(SqlString x, SqlString y);
        public static SqlBoolean LessThanOrEqual(SqlString x, SqlString y);
        public static SqlBoolean NotEquals(SqlString x, SqlString y);
        public static SqlString operator +(SqlString x, SqlString y);
        public static SqlBoolean operator ==(SqlString x, SqlString y);
        public static explicit operator SqlString (SqlBoolean x);
        public static explicit operator SqlString (SqlByte x);
        public static explicit operator SqlString (SqlDateTime x);
        public static explicit operator SqlString (SqlDecimal x);
        public static explicit operator SqlString (SqlDouble x);
        public static explicit operator SqlString (SqlGuid x);
        public static explicit operator SqlString (SqlInt16 x);
        public static explicit operator SqlString (SqlInt32 x);
        public static explicit operator SqlString (SqlInt64 x);
        public static explicit operator SqlString (SqlMoney x);
        public static explicit operator SqlString (SqlSingle x);
        public static explicit operator string (SqlString x);
        public static SqlBoolean operator >(SqlString x, SqlString y);
        public static SqlBoolean operator >=(SqlString x, SqlString y);
        public static implicit operator SqlString (string x);
        public static SqlBoolean operator !=(SqlString x, SqlString y);
        public static SqlBoolean operator <(SqlString x, SqlString y);
        public static SqlBoolean operator <=(SqlString x, SqlString y);
        XmlSchema System.Xml.Serialization.IXmlSerializable.GetSchema();
        void System.Xml.Serialization.IXmlSerializable.ReadXml(XmlReader reader);
        void System.Xml.Serialization.IXmlSerializable.WriteXml(XmlWriter writer);
        public SqlBoolean ToSqlBoolean();
        public SqlByte ToSqlByte();
        public SqlDateTime ToSqlDateTime();
        public SqlDecimal ToSqlDecimal();
        public SqlDouble ToSqlDouble();
        public SqlGuid ToSqlGuid();
        public SqlInt16 ToSqlInt16();
        public SqlInt32 ToSqlInt32();
        public SqlInt64 ToSqlInt64();
        public SqlMoney ToSqlMoney();
        public SqlSingle ToSqlSingle();
        public override string ToString();
    }
    public sealed class SqlTruncateException : SqlTypeException {
        public SqlTruncateException();
        public SqlTruncateException(string message);
        public SqlTruncateException(string message, Exception e);
    }
    public class SqlTypeException : SystemException {
        public SqlTypeException();
        protected SqlTypeException(SerializationInfo si, StreamingContext sc);
        public SqlTypeException(string message);
        public SqlTypeException(string message, Exception e);
    }
    public sealed class SqlXml : INullable, IXmlSerializable {
        public SqlXml();
        public SqlXml(Stream value);
        public SqlXml(XmlReader value);
        public bool IsNull { get; }
        public static SqlXml Null { get; }
        public string Value { get; }
        public XmlReader CreateReader();
        public static XmlQualifiedName GetXsdType(XmlSchemaSet schemaSet);
        XmlSchema System.Xml.Serialization.IXmlSerializable.GetSchema();
        void System.Xml.Serialization.IXmlSerializable.ReadXml(XmlReader r);
        void System.Xml.Serialization.IXmlSerializable.WriteXml(XmlWriter writer);
    }
    public enum StorageState {
        Buffer = 0,
        Stream = 1,
        UnmanagedBuffer = 2,
    }
}
namespace System.Diagnostics {
    public class BooleanSwitch : Switch {
        public BooleanSwitch(string displayName, string description);
        public BooleanSwitch(string displayName, string description, string defaultSwitchValue);
        public bool Enabled { get; set; }
        protected override void OnValueChanged();
    }
    public sealed class ConditionalAttribute : Attribute {
        public ConditionalAttribute(string conditionString);
        public string ConditionString { get; }
    }
    public class CorrelationManager {
        public Guid ActivityId { get; set; }
        public Stack LogicalOperationStack { get; }
        public void StartLogicalOperation();
        public void StartLogicalOperation(object operationId);
        public void StopLogicalOperation();
    }
    public class DataReceivedEventArgs : EventArgs {
        public string Data { get; }
    }
    public delegate void DataReceivedEventHandler(object sender, DataReceivedEventArgs e);
    public static class Debug {
        public static bool AutoFlush { get; set; }
        public static int IndentLevel { get; set; }
        public static int IndentSize { get; set; }
        public static void Assert(bool condition);
        public static void Assert(bool condition, string message);
        public static void Assert(bool condition, string message, string detailMessage);
        public static void Assert(bool condition, string message, string detailMessageFormat, params object[] args);
        public static void Close();
        public static void Fail(string message);
        public static void Fail(string message, string detailMessage);
        public static void Flush();
        public static void Indent();
        public static void Print(string message);
        public static void Print(string format, params object[] args);
        public static void Unindent();
        public static void Write(object value);
        public static void Write(object value, string category);
        public static void Write(string message);
        public static void Write(string message, string category);
        public static void WriteIf(bool condition, object value);
        public static void WriteIf(bool condition, object value, string category);
        public static void WriteIf(bool condition, string message);
        public static void WriteIf(bool condition, string message, string category);
        public static void WriteLine(object value);
        public static void WriteLine(object value, string category);
        public static void WriteLine(string message);
        public static void WriteLine(string format, params object[] args);
        public static void WriteLine(string message, string category);
        public static void WriteLineIf(bool condition, object value);
        public static void WriteLineIf(bool condition, object value, string category);
        public static void WriteLineIf(bool condition, string message);
        public static void WriteLineIf(bool condition, string message, string category);
    }
    public sealed class DebuggableAttribute : Attribute {
        public DebuggableAttribute(DebuggableAttribute.DebuggingModes modes);
        public DebuggableAttribute(bool isJITTrackingEnabled, bool isJITOptimizerDisabled);
        public DebuggableAttribute.DebuggingModes DebuggingFlags { get; }
        public bool IsJITOptimizerDisabled { get; }
        public bool IsJITTrackingEnabled { get; }
        public enum DebuggingModes {
            Default = 1,
            DisableOptimizations = 256,
            EnableEditAndContinue = 4,
            IgnoreSymbolStoreSequencePoints = 2,
            None = 0,
        }
    }
    public static class Debugger {
        public static readonly string DefaultCategory;
        public static bool IsAttached { get; }
        public static void Break();
        public static bool IsLogging();
        public static bool Launch();
        public static void Log(int level, string category, string message);
        public static void NotifyOfCrossThreadDependency();
    }
    public sealed class DebuggerBrowsableAttribute : Attribute {
        public DebuggerBrowsableAttribute(DebuggerBrowsableState state);
        public DebuggerBrowsableState State { get; }
    }
    public enum DebuggerBrowsableState {
        Collapsed = 2,
        Never = 0,
        RootHidden = 3,
    }
    public sealed class DebuggerDisplayAttribute : Attribute {
        public DebuggerDisplayAttribute(string value);
        public string Name { get; set; }
        public Type Target { get; set; }
        public string TargetTypeName { get; set; }
        public string Type { get; set; }
        public string Value { get; }
    }
    public sealed class DebuggerHiddenAttribute : Attribute {
        public DebuggerHiddenAttribute();
    }
    public sealed class DebuggerNonUserCodeAttribute : Attribute {
        public DebuggerNonUserCodeAttribute();
    }
    public sealed class DebuggerStepperBoundaryAttribute : Attribute {
        public DebuggerStepperBoundaryAttribute();
    }
    public sealed class DebuggerStepThroughAttribute : Attribute {
        public DebuggerStepThroughAttribute();
    }
    public sealed class DebuggerTypeProxyAttribute : Attribute {
        public DebuggerTypeProxyAttribute(string typeName);
        public DebuggerTypeProxyAttribute(Type type);
        public string ProxyTypeName { get; }
        public Type Target { get; set; }
        public string TargetTypeName { get; set; }
    }
    public sealed class DebuggerVisualizerAttribute : Attribute {
        public DebuggerVisualizerAttribute(string visualizerTypeName);
        public DebuggerVisualizerAttribute(string visualizerTypeName, string visualizerObjectSourceTypeName);
        public DebuggerVisualizerAttribute(string visualizerTypeName, Type visualizerObjectSource);
        public DebuggerVisualizerAttribute(Type visualizer);
        public DebuggerVisualizerAttribute(Type visualizer, string visualizerObjectSourceTypeName);
        public DebuggerVisualizerAttribute(Type visualizer, Type visualizerObjectSource);
        public string Description { get; set; }
        public Type Target { get; set; }
        public string TargetTypeName { get; set; }
        public string VisualizerObjectSourceTypeName { get; }
        public string VisualizerTypeName { get; }
    }
    public class DefaultTraceListener : TraceListener {
        public DefaultTraceListener();
        public bool AssertUiEnabled { get; set; }
        public string LogFileName { get; set; }
        public override void Fail(string message);
        public override void Fail(string message, string detailMessage);
        public override void Write(string message);
        public override void WriteLine(string message);
    }
    public class DelimitedListTraceListener : TextWriterTraceListener {
        public DelimitedListTraceListener(Stream stream);
        public DelimitedListTraceListener(Stream stream, string name);
        public DelimitedListTraceListener(TextWriter writer);
        public DelimitedListTraceListener(TextWriter writer, string name);
        public DelimitedListTraceListener(string fileName);
        public DelimitedListTraceListener(string fileName, string name);
        public string Delimiter { get; set; }
        protected override string[] GetSupportedAttributes();
        public override void TraceData(TraceEventCache eventCache, string source, TraceEventType eventType, int id, object data);
        public override void TraceData(TraceEventCache eventCache, string source, TraceEventType eventType, int id, params object[] data);
        public override void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id, string message);
        public override void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id, string format, params object[] args);
    }
    public class EventTypeFilter : TraceFilter {
        public EventTypeFilter(SourceLevels level);
        public SourceLevels EventType { get; set; }
        public override bool ShouldTrace(TraceEventCache cache, string source, TraceEventType eventType, int id, string formatOrMessage, object[] args, object data1, object[] data);
    }
    public sealed class FileVersionInfo {
        public string Comments { get; }
        public string CompanyName { get; }
        public int FileBuildPart { get; }
        public string FileDescription { get; }
        public int FileMajorPart { get; }
        public int FileMinorPart { get; }
        public string FileName { get; }
        public int FilePrivatePart { get; }
        public string FileVersion { get; }
        public string InternalName { get; }
        public bool IsDebug { get; }
        public bool IsPatched { get; }
        public bool IsPreRelease { get; }
        public bool IsPrivateBuild { get; }
        public bool IsSpecialBuild { get; }
        public string Language { get; }
        public string LegalCopyright { get; }
        public string LegalTrademarks { get; }
        public string OriginalFilename { get; }
        public string PrivateBuild { get; }
        public int ProductBuildPart { get; }
        public int ProductMajorPart { get; }
        public int ProductMinorPart { get; }
        public string ProductName { get; }
        public int ProductPrivatePart { get; }
        public string ProductVersion { get; }
        public string SpecialBuild { get; }
        public static FileVersionInfo GetVersionInfo(string fileName);
        public override string ToString();
    }
    public class MonitoringDescriptionAttribute : DescriptionAttribute {
        public MonitoringDescriptionAttribute(string description);
        public override string Description { get; }
    }
    public class Process : Component {
        public Process();
        public int BasePriority { get; }
        public bool EnableRaisingEvents { get; set; }
        public int ExitCode { get; }
        public DateTime ExitTime { get; }
        public IntPtr Handle { get; }
        public int HandleCount { get; }
        public bool HasExited { get; }
        public int Id { get; }
        public string MachineName { get; }
        public ProcessModule MainModule { get; }
        public IntPtr MainWindowHandle { get; }
        public string MainWindowTitle { get; }
        public IntPtr MaxWorkingSet { get; set; }
        public IntPtr MinWorkingSet { get; set; }
        public ProcessModuleCollection Modules { get; }
        public int NonpagedSystemMemorySize { get; }
        public long NonpagedSystemMemorySize64 { get; }
        public int PagedMemorySize { get; }
        public long PagedMemorySize64 { get; }
        public int PagedSystemMemorySize { get; }
        public long PagedSystemMemorySize64 { get; }
        public int PeakPagedMemorySize { get; }
        public long PeakPagedMemorySize64 { get; }
        public int PeakVirtualMemorySize { get; }
        public long PeakVirtualMemorySize64 { get; }
        public int PeakWorkingSet { get; }
        public long PeakWorkingSet64 { get; }
        public bool PriorityBoostEnabled { get; set; }
        public ProcessPriorityClass PriorityClass { get; set; }
        public int PrivateMemorySize { get; }
        public long PrivateMemorySize64 { get; }
        public TimeSpan PrivilegedProcessorTime { get; }
        public string ProcessName { get; }
        public IntPtr ProcessorAffinity { get; set; }
        public bool Responding { get; }
        public SafeProcessHandle SafeHandle { get; }
        public int SessionId { get; }
        public StreamReader StandardError { get; }
        public StreamWriter StandardInput { get; }
        public StreamReader StandardOutput { get; }
        public ProcessStartInfo StartInfo { get; set; }
        public DateTime StartTime { get; }
        public ISynchronizeInvoke SynchronizingObject { get; set; }
        public ProcessThreadCollection Threads { get; }
        public TimeSpan TotalProcessorTime { get; }
        public TimeSpan UserProcessorTime { get; }
        public int VirtualMemorySize { get; }
        public long VirtualMemorySize64 { get; }
        public int WorkingSet { get; }
        public long WorkingSet64 { get; }
        public event DataReceivedEventHandler ErrorDataReceived;
        public event EventHandler Exited;
        public event DataReceivedEventHandler OutputDataReceived;
        public void BeginErrorReadLine();
        public void BeginOutputReadLine();
        public void CancelErrorRead();
        public void CancelOutputRead();
        public void Close();
        public bool CloseMainWindow();
        protected override void Dispose(bool disposing);
        public static void EnterDebugMode();
        public static Process GetCurrentProcess();
        public static Process GetProcessById(int processId);
        public static Process GetProcessById(int processId, string machineName);
        public static Process[] GetProcesses();
        public static Process[] GetProcesses(string machineName);
        public static Process[] GetProcessesByName(string processName);
        public static Process[] GetProcessesByName(string processName, string machineName);
        public void Kill();
        public static void LeaveDebugMode();
        protected void OnExited();
        public void Refresh();
        public bool Start();
        public static Process Start(ProcessStartInfo startInfo);
        public static Process Start(string fileName);
        public static Process Start(string fileName, string arguments);
        public static Process Start(string fileName, string userName, SecureString password, string domain);
        public static Process Start(string fileName, string arguments, string userName, SecureString password, string domain);
        public override string ToString();
        public void WaitForExit();
        public bool WaitForExit(int milliseconds);
        public bool WaitForInputIdle();
        public bool WaitForInputIdle(int milliseconds);
    }
    public class ProcessModule : Component {
        public IntPtr BaseAddress { get; }
        public IntPtr EntryPointAddress { get; }
        public string FileName { get; }
        public FileVersionInfo FileVersionInfo { get; }
        public int ModuleMemorySize { get; }
        public string ModuleName { get; }
        public override string ToString();
    }
    public class ProcessModuleCollection : ReadOnlyCollectionBase {
        protected ProcessModuleCollection();
        public ProcessModuleCollection(ProcessModule[] processModules);
        public ProcessModule this[int index] { get; }
        public bool Contains(ProcessModule module);
        public void CopyTo(ProcessModule[] array, int index);
        public int IndexOf(ProcessModule module);
    }
    public enum ProcessPriorityClass {
        AboveNormal = 32768,
        BelowNormal = 16384,
        High = 128,
        Idle = 64,
        Normal = 32,
        RealTime = 256,
    }
    public sealed class ProcessStartInfo {
        public ProcessStartInfo();
        public ProcessStartInfo(string fileName);
        public ProcessStartInfo(string fileName, string arguments);
        public string Arguments { get; set; }
        public bool CreateNoWindow { get; set; }
        public string Domain { get; set; }
        public IDictionary<string, string> Environment { get; }
        public StringDictionary EnvironmentVariables { get; }
        public bool ErrorDialog { get; set; }
        public IntPtr ErrorDialogParentHandle { get; set; }
        public string FileName { get; set; }
        public bool LoadUserProfile { get; set; }
        public SecureString Password { get; set; }
        public string PasswordInClearText { get; set; }
        public bool RedirectStandardError { get; set; }
        public bool RedirectStandardInput { get; set; }
        public bool RedirectStandardOutput { get; set; }
        public Encoding StandardErrorEncoding { get; set; }
        public Encoding StandardOutputEncoding { get; set; }
        public string UserName { get; set; }
        public bool UseShellExecute { get; set; }
        public string Verb { get; set; }
        public string[] Verbs { get; }
        public ProcessWindowStyle WindowStyle { get; set; }
        public string WorkingDirectory { get; set; }
    }
    public class ProcessThread : Component {
        public int BasePriority { get; }
        public int CurrentPriority { get; }
        public int Id { get; }
        public int IdealProcessor { set; }
        public bool PriorityBoostEnabled { get; set; }
        public ThreadPriorityLevel PriorityLevel { get; set; }
        public TimeSpan PrivilegedProcessorTime { get; }
        public IntPtr ProcessorAffinity { set; }
        public IntPtr StartAddress { get; }
        public DateTime StartTime { get; }
        public ThreadState ThreadState { get; }
        public TimeSpan TotalProcessorTime { get; }
        public TimeSpan UserProcessorTime { get; }
        public ThreadWaitReason WaitReason { get; }
        public void ResetIdealProcessor();
    }
    public class ProcessThreadCollection : ReadOnlyCollectionBase {
        protected ProcessThreadCollection();
        public ProcessThreadCollection(ProcessThread[] processThreads);
        public ProcessThread this[int index] { get; }
        public int Add(ProcessThread thread);
        public bool Contains(ProcessThread thread);
        public void CopyTo(ProcessThread[] array, int index);
        public int IndexOf(ProcessThread thread);
        public void Insert(int index, ProcessThread thread);
        public void Remove(ProcessThread thread);
    }
    public enum ProcessWindowStyle {
        Hidden = 1,
        Maximized = 3,
        Minimized = 2,
        Normal = 0,
    }
    public class SourceFilter : TraceFilter {
        public SourceFilter(string source);
        public string Source { get; set; }
        public override bool ShouldTrace(TraceEventCache cache, string source, TraceEventType eventType, int id, string formatOrMessage, object[] args, object data1, object[] data);
    }
    public enum SourceLevels {
        ActivityTracing = 65280,
        All = -1,
        Critical = 1,
        Error = 3,
        Information = 15,
        Off = 0,
        Verbose = 31,
        Warning = 7,
    }
    public class SourceSwitch : Switch {
        public SourceSwitch(string name);
        public SourceSwitch(string displayName, string defaultSwitchValue);
        public SourceLevels Level { get; set; }
        protected override void OnValueChanged();
        public bool ShouldTrace(TraceEventType eventType);
    }
    public class StackFrame {
        public const int OFFSET_UNKNOWN = -1;
        public StackFrame();
        public StackFrame(bool fNeedFileInfo);
        public StackFrame(int skipFrames);
        public StackFrame(int skipFrames, bool fNeedFileInfo);
        public StackFrame(string fileName, int lineNumber);
        public StackFrame(string fileName, int lineNumber, int colNumber);
        public virtual int GetFileColumnNumber();
        public virtual int GetFileLineNumber();
        public virtual string GetFileName();
        public virtual int GetILOffset();
        public virtual MethodBase GetMethod();
        public virtual int GetNativeOffset();
        public override string ToString();
    }
    public static class StackFrameExtensions {
        public static IntPtr GetNativeImageBase(this StackFrame stackFrame);
        public static IntPtr GetNativeIP(this StackFrame stackFrame);
        public static bool HasILOffset(this StackFrame stackFrame);
        public static bool HasMethod(this StackFrame stackFrame);
        public static bool HasNativeImage(this StackFrame stackFrame);
        public static bool HasSource(this StackFrame stackFrame);
    }
    public class StackTrace {
        public const int METHODS_TO_SKIP = 0;
        public StackTrace();
        public StackTrace(bool fNeedFileInfo);
        public StackTrace(StackFrame frame);
        public StackTrace(Exception e);
        public StackTrace(Exception e, bool fNeedFileInfo);
        public StackTrace(Exception e, int skipFrames);
        public StackTrace(Exception e, int skipFrames, bool fNeedFileInfo);
        public StackTrace(int skipFrames);
        public StackTrace(int skipFrames, bool fNeedFileInfo);
        public virtual int FrameCount { get; }
        public virtual StackFrame GetFrame(int index);
        public virtual StackFrame[] GetFrames();
        public override string ToString();
    }
    public class Stopwatch {
        public static readonly bool IsHighResolution;
        public static readonly long Frequency;
        public Stopwatch();
        public TimeSpan Elapsed { get; }
        public long ElapsedMilliseconds { get; }
        public long ElapsedTicks { get; }
        public bool IsRunning { get; }
        public static long GetTimestamp();
        public void Reset();
        public void Restart();
        public void Start();
        public static Stopwatch StartNew();
        public void Stop();
    }
    public abstract class Switch {
        protected Switch(string displayName, string description);
        protected Switch(string displayName, string description, string defaultSwitchValue);
        public StringDictionary Attributes { get; }
        public string Description { get; }
        public string DisplayName { get; }
        protected int SwitchSetting { get; set; }
        protected string Value { get; set; }
        protected virtual string[] GetSupportedAttributes();
        protected virtual void OnSwitchSettingChanged();
        protected virtual void OnValueChanged();
    }
    public sealed class SwitchAttribute : Attribute {
        public SwitchAttribute(string switchName, Type switchType);
        public string SwitchDescription { get; set; }
        public string SwitchName { get; set; }
        public Type SwitchType { get; set; }
        public static SwitchAttribute[] GetAll(Assembly assembly);
    }
    public sealed class SwitchLevelAttribute : Attribute {
        public SwitchLevelAttribute(Type switchLevelType);
        public Type SwitchLevelType { get; set; }
    }
    public class TextWriterTraceListener : TraceListener {
        public TextWriterTraceListener();
        public TextWriterTraceListener(Stream stream);
        public TextWriterTraceListener(Stream stream, string name);
        public TextWriterTraceListener(TextWriter writer);
        public TextWriterTraceListener(TextWriter writer, string name);
        public TextWriterTraceListener(string fileName);
        public TextWriterTraceListener(string fileName, string name);
        public TextWriter Writer { get; set; }
        public override void Close();
        protected override void Dispose(bool disposing);
        public override void Flush();
        public override void Write(string message);
        public override void WriteLine(string message);
    }
    public enum ThreadPriorityLevel {
        AboveNormal = 1,
        BelowNormal = -1,
        Highest = 2,
        Idle = -15,
        Lowest = -2,
        Normal = 0,
        TimeCritical = 15,
    }
    public enum ThreadState {
        Initialized = 0,
        Ready = 1,
        Running = 2,
        Standby = 3,
        Terminated = 4,
        Transition = 6,
        Unknown = 7,
        Wait = 5,
    }
    public enum ThreadWaitReason {
        EventPairHigh = 7,
        EventPairLow = 8,
        ExecutionDelay = 4,
        Executive = 0,
        FreePage = 1,
        LpcReceive = 9,
        LpcReply = 10,
        PageIn = 2,
        PageOut = 12,
        Suspended = 5,
        SystemAllocation = 3,
        Unknown = 13,
        UserRequest = 6,
        VirtualMemory = 11,
    }
    public sealed class Trace {
        public static bool AutoFlush { get; set; }
        public static CorrelationManager CorrelationManager { get; }
        public static int IndentLevel { get; set; }
        public static int IndentSize { get; set; }
        public static TraceListenerCollection Listeners { get; }
        public static bool UseGlobalLock { get; set; }
        public static void Assert(bool condition);
        public static void Assert(bool condition, string message);
        public static void Assert(bool condition, string message, string detailMessage);
        public static void Close();
        public static void Fail(string message);
        public static void Fail(string message, string detailMessage);
        public static void Flush();
        public static void Indent();
        public static void Refresh();
        public static void TraceError(string message);
        public static void TraceError(string format, params object[] args);
        public static void TraceInformation(string message);
        public static void TraceInformation(string format, params object[] args);
        public static void TraceWarning(string message);
        public static void TraceWarning(string format, params object[] args);
        public static void Unindent();
        public static void Write(object value);
        public static void Write(object value, string category);
        public static void Write(string message);
        public static void Write(string message, string category);
        public static void WriteIf(bool condition, object value);
        public static void WriteIf(bool condition, object value, string category);
        public static void WriteIf(bool condition, string message);
        public static void WriteIf(bool condition, string message, string category);
        public static void WriteLine(object value);
        public static void WriteLine(object value, string category);
        public static void WriteLine(string message);
        public static void WriteLine(string message, string category);
        public static void WriteLineIf(bool condition, object value);
        public static void WriteLineIf(bool condition, object value, string category);
        public static void WriteLineIf(bool condition, string message);
        public static void WriteLineIf(bool condition, string message, string category);
    }
    public class TraceEventCache {
        public TraceEventCache();
        public string Callstack { get; }
        public DateTime DateTime { get; }
        public Stack LogicalOperationStack { get; }
        public int ProcessId { get; }
        public string ThreadId { get; }
        public long Timestamp { get; }
    }
    public enum TraceEventType {
        Critical = 1,
        Error = 2,
        Information = 8,
        Resume = 2048,
        Start = 256,
        Stop = 512,
        Suspend = 1024,
        Transfer = 4096,
        Verbose = 16,
        Warning = 4,
    }
    public abstract class TraceFilter {
        protected TraceFilter();
        public abstract bool ShouldTrace(TraceEventCache cache, string source, TraceEventType eventType, int id, string formatOrMessage, object[] args, object data1, object[] data);
    }
    public enum TraceLevel {
        Error = 1,
        Info = 3,
        Off = 0,
        Verbose = 4,
        Warning = 2,
    }
    public abstract class TraceListener : MarshalByRefObject, IDisposable {
        protected TraceListener();
        protected TraceListener(string name);
        public StringDictionary Attributes { get; }
        public TraceFilter Filter { get; set; }
        public int IndentLevel { get; set; }
        public int IndentSize { get; set; }
        public virtual bool IsThreadSafe { get; }
        public virtual string Name { get; set; }
        protected bool NeedIndent { get; set; }
        public TraceOptions TraceOutputOptions { get; set; }
        public virtual void Close();
        public void Dispose();
        protected virtual void Dispose(bool disposing);
        public virtual void Fail(string message);
        public virtual void Fail(string message, string detailMessage);
        public virtual void Flush();
        protected virtual string[] GetSupportedAttributes();
        public virtual void TraceData(TraceEventCache eventCache, string source, TraceEventType eventType, int id, object data);
        public virtual void TraceData(TraceEventCache eventCache, string source, TraceEventType eventType, int id, params object[] data);
        public virtual void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id);
        public virtual void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id, string message);
        public virtual void TraceEvent(TraceEventCache eventCache, string source, TraceEventType eventType, int id, string format, params object[] args);
        public virtual void TraceTransfer(TraceEventCache eventCache, string source, int id, string message, Guid relatedActivityId);
        public virtual void Write(object o);
        public virtual void Write(object o, string category);
        public abstract void Write(string message);
        public virtual void Write(string message, string category);
        protected virtual void WriteIndent();
        public virtual void WriteLine(object o);
        public virtual void WriteLine(object o, string category);
        public abstract void WriteLine(string message);
        public virtual void WriteLine(string message, string category);
    }
    public class TraceListenerCollection : ICollection, IEnumerable, IList {
        public int Count { get; }
        bool System.Collections.ICollection.IsSynchronized { get; }
        object System.Collections.ICollection.SyncRoot { get; }
        bool System.Collections.IList.IsFixedSize { get; }
        bool System.Collections.IList.IsReadOnly { get; }
        object System.Collections.IList.this[int index] { get; set; }
        public TraceListener this[int i] { get; set; }
        public TraceListener this[string name] { get; }
        public int Add(TraceListener listener);
        public void AddRange(TraceListenerCollection value);
        public void AddRange(TraceListener[] value);
        public void Clear();
        public bool Contains(TraceListener listener);
        public void CopyTo(TraceListener[] listeners, int index);
        public IEnumerator GetEnumerator();
        public int IndexOf(TraceListener listener);
        public void Insert(int index, TraceListener listener);
        public void Remove(TraceListener listener);
        public void Remove(string name);
        public void RemoveAt(int index);
        void System.Collections.ICollection.CopyTo(Array array, int index);
        int System.Collections.IList.Add(object value);
        bool System.Collections.IList.Contains(object value);
        int System.Collections.IList.IndexOf(object value);
        void System.Collections.IList.Insert(int index, object value);
        void System.Collections.IList.Remove(object value);
    }
    public enum TraceOptions {
        Callstack = 32,
        DateTime = 2,
        LogicalOperationStack = 1,
        None = 0,
        ProcessId = 8,
        ThreadId = 16,
        Timestamp = 4,
    }
    public class TraceSource {
        public TraceSource(string name);
        public TraceSource(string name, SourceLevels defaultLevel);
        public StringDictionary Attributes { get; }
        public TraceListenerCollection Listeners { get; }
        public string Name { get; }
        public SourceSwitch Switch { get; set; }
        public void Close();
        public void Flush();
        protected virtual string[] GetSupportedAttributes();
        public void TraceData(TraceEventType eventType, int id, object data);
        public void TraceData(TraceEventType eventType, int id, params object[] data);
        public void TraceEvent(TraceEventType eventType, int id);
        public void TraceEvent(TraceEventType eventType, int id, string message);
        public void TraceEvent(TraceEventType eventType, int id, string format, params object[] args);
        public void TraceInformation(string message);
        public void TraceInformation(string format, params object[] args);
        public void TraceTransfer(int id, string message, Guid relatedActivityId);
    }
    public class TraceSwitch : Switch {
        public TraceSwitch(string displayName, string description);
        public TraceSwitch(string displayName, string description, string defaultSwitchValue);
        public TraceLevel Level { get; set; }
        public bool TraceError { get; }
        public bool TraceInfo { get; }
        public bool TraceVerbose { get; }
        public bool TraceWarning { get; }
        protected override void OnSwitchSettingChanged();
        protected override void OnValueChanged();
    }
}
namespace System.Diagnostics.CodeAnalysis {
    public sealed class ExcludeFromCodeCoverageAttribute : Attribute {
        public ExcludeFromCodeCoverageAttribute();
    }
    public sealed class SuppressMessageAttribute : Attribute {
        public SuppressMessageAttribute(string category, string checkId);
        public string Category { get; }
        public string CheckId { get; }
        public string Justification { get; set; }
        public string MessageId { get; set; }
        public string Scope { get; set; }
        public string Target { get; set; }
    }
}
namespace System.Diagnostics.Contracts {
    public static class Contract {
        public static event EventHandler<ContractFailedEventArgs> ContractFailed;
        public static void Assert(bool condition);
        public static void Assert(bool condition, string userMessage);
        public static void Assume(bool condition);
        public static void Assume(bool condition, string userMessage);
        public static void EndContractBlock();
        public static void Ensures(bool condition);
        public static void Ensures(bool condition, string userMessage);
        public static void EnsuresOnThrow<TException>(bool condition) where TException : Exception;
        public static void EnsuresOnThrow<TException>(bool condition, string userMessage) where TException : Exception;
        public static bool Exists(int fromInclusive, int toExclusive, Predicate<int> predicate);
        public static bool Exists<T>(IEnumerable<T> collection, Predicate<T> predicate);
        public static bool ForAll(int fromInclusive, int toExclusive, Predicate<int> predicate);
        public static bool ForAll<T>(IEnumerable<T> collection, Predicate<T> predicate);
        public static void Invariant(bool condition);
        public static void Invariant(bool condition, string userMessage);
        public static T OldValue<T>(T value);
        public static void Requires(bool condition);
        public static void Requires(bool condition, string userMessage);
        public static void Requires<TException>(bool condition) where TException : Exception;
        public static void Requires<TException>(bool condition, string userMessage) where TException : Exception;
        public static T Result<T>();
        public static T ValueAtReturn<T>(out T value);
    }
    public sealed class ContractAbbreviatorAttribute : Attribute {
        public ContractAbbreviatorAttribute();
    }
    public sealed class ContractArgumentValidatorAttribute : Attribute {
        public ContractArgumentValidatorAttribute();
    }
    public sealed class ContractClassAttribute : Attribute {
        public ContractClassAttribute(Type typeContainingContracts);
        public Type TypeContainingContracts { get; }
    }
    public sealed class ContractClassForAttribute : Attribute {
        public ContractClassForAttribute(Type typeContractsAreFor);
        public Type TypeContractsAreFor { get; }
    }
    public sealed class ContractFailedEventArgs : EventArgs {
        public ContractFailedEventArgs(ContractFailureKind failureKind, string message, string condition, Exception originalException);
        public string Condition { get; }
        public ContractFailureKind FailureKind { get; }
        public bool Handled { get; }
        public string Message { get; }
        public Exception OriginalException { get; }
        public bool Unwind { get; }
        public void SetHandled();
        public void SetUnwind();
    }
    public enum ContractFailureKind {
        Assert = 4,
        Assume = 5,
        Invariant = 3,
        Postcondition = 1,
        PostconditionOnException = 2,
        Precondition = 0,
    }
    public sealed class ContractInvariantMethodAttribute : Attribute {
        public ContractInvariantMethodAttribute();
    }
    public sealed class ContractOptionAttribute : Attribute {
        public ContractOptionAttribute(string category, string setting, bool enabled);
        public ContractOptionAttribute(string category, string setting, string value);
        public string Category { get; }
        public bool Enabled { get; }
        public string Setting { get; }
        public string Value { get; }
    }
    public sealed class ContractPublicPropertyNameAttribute : Attribute {
        public ContractPublicPropertyNameAttribute(string name);
        public string Name { get; }
    }
    public sealed class ContractReferenceAssemblyAttribute : Attribute {
        public ContractReferenceAssemblyAttribute();
    }
    public sealed class ContractRuntimeIgnoredAttribute : Attribute {
        public ContractRuntimeIgnoredAttribute();
    }
    public sealed class ContractVerificationAttribute : Attribute {
        public ContractVerificationAttribute(bool value);
        public bool Value { get; }
    }
    public sealed class PureAttribute : Attribute {
        public PureAttribute();
    }
}
namespace System.Diagnostics.SymbolStore {
    public interface ISymbolBinder {
        ISymbolReader GetReader(int importer, string filename, string searchPath);
    }
    public interface ISymbolBinder1 {
        ISymbolReader GetReader(IntPtr importer, string filename, string searchPath);
    }
    public interface ISymbolDocument {
        Guid CheckSumAlgorithmId { get; }
        Guid DocumentType { get; }
        bool HasEmbeddedSource { get; }
        Guid Language { get; }
        Guid LanguageVendor { get; }
        int SourceLength { get; }
        string URL { get; }
        int FindClosestLine(int line);
        byte[] GetCheckSum();
        byte[] GetSourceRange(int startLine, int startColumn, int endLine, int endColumn);
    }
    public interface ISymbolDocumentWriter {
        void SetCheckSum(Guid algorithmId, byte[] checkSum);
        void SetSource(byte[] source);
    }
    public interface ISymbolMethod {
        ISymbolScope RootScope { get; }
        int SequencePointCount { get; }
        SymbolToken Token { get; }
        ISymbolNamespace GetNamespace();
        int GetOffset(ISymbolDocument document, int line, int column);
        ISymbolVariable[] GetParameters();
        int[] GetRanges(ISymbolDocument document, int line, int column);
        ISymbolScope GetScope(int offset);
        void GetSequencePoints(int[] offsets, ISymbolDocument[] documents, int[] lines, int[] columns, int[] endLines, int[] endColumns);
        bool GetSourceStartEnd(ISymbolDocument[] docs, int[] lines, int[] columns);
    }
    public interface ISymbolNamespace {
        string Name { get; }
        ISymbolNamespace[] GetNamespaces();
        ISymbolVariable[] GetVariables();
    }
    public interface ISymbolReader {
        SymbolToken UserEntryPoint { get; }
        ISymbolDocument GetDocument(string url, Guid language, Guid languageVendor, Guid documentType);
        ISymbolDocument[] GetDocuments();
        ISymbolVariable[] GetGlobalVariables();
        ISymbolMethod GetMethod(SymbolToken method);
        ISymbolMethod GetMethod(SymbolToken method, int version);
        ISymbolMethod GetMethodFromDocumentPosition(ISymbolDocument document, int line, int column);
        ISymbolNamespace[] GetNamespaces();
        byte[] GetSymAttribute(SymbolToken parent, string name);
        ISymbolVariable[] GetVariables(SymbolToken parent);
    }
    public interface ISymbolScope {
        int EndOffset { get; }
        ISymbolMethod Method { get; }
        ISymbolScope Parent { get; }
        int StartOffset { get; }
        ISymbolScope[] GetChildren();
        ISymbolVariable[] GetLocals();
        ISymbolNamespace[] GetNamespaces();
    }
    public interface ISymbolVariable {
        int AddressField1 { get; }
        int AddressField2 { get; }
        int AddressField3 { get; }
        SymAddressKind AddressKind { get; }
        object Attributes { get; }
        int EndOffset { get; }
        string Name { get; }
        int StartOffset { get; }
        byte[] GetSignature();
    }
    public interface ISymbolWriter {
        void Close();
        void CloseMethod();
        void CloseNamespace();
        void CloseScope(int endOffset);
        ISymbolDocumentWriter DefineDocument(string url, Guid language, Guid languageVendor, Guid documentType);
        void DefineField(SymbolToken parent, string name, FieldAttributes attributes, byte[] signature, SymAddressKind addrKind, int addr1, int addr2, int addr3);
        void DefineGlobalVariable(string name, FieldAttributes attributes, byte[] signature, SymAddressKind addrKind, int addr1, int addr2, int addr3);
        void DefineLocalVariable(string name, FieldAttributes attributes, byte[] signature, SymAddressKind addrKind, int addr1, int addr2, int addr3, int startOffset, int endOffset);
        void DefineParameter(string name, ParameterAttributes attributes, int sequence, SymAddressKind addrKind, int addr1, int addr2, int addr3);
        void DefineSequencePoints(ISymbolDocumentWriter document, int[] offsets, int[] lines, int[] columns, int[] endLines, int[] endColumns);
        void Initialize(IntPtr emitter, string filename, bool fFullBuild);
        void OpenMethod(SymbolToken method);
        void OpenNamespace(string name);
        int OpenScope(int startOffset);
        void SetMethodSourceRange(ISymbolDocumentWriter startDoc, int startLine, int startColumn, ISymbolDocumentWriter endDoc, int endLine, int endColumn);
        void SetScopeRange(int scopeID, int startOffset, int endOffset);
        void SetSymAttribute(SymbolToken parent, string name, byte[] data);
        void SetUnderlyingWriter(IntPtr underlyingWriter);
        void SetUserEntryPoint(SymbolToken entryMethod);
        void UsingNamespace(string fullName);
    }
    public enum SymAddressKind {
        BitField = 9,
        ILOffset = 1,
        NativeOffset = 5,
        NativeRegister = 3,
        NativeRegisterRegister = 6,
        NativeRegisterRelative = 4,
        NativeRegisterStack = 7,
        NativeRVA = 2,
        NativeSectionOffset = 10,
        NativeStackRegister = 8,
    }
    public struct SymbolToken {
        public SymbolToken(int val);
        public bool Equals(SymbolToken obj);
        public override bool Equals(object obj);
        public override int GetHashCode();
        public int GetToken();
        public static bool operator ==(SymbolToken a, SymbolToken b);
        public static bool operator !=(SymbolToken a, SymbolToken b);
    }
    public class SymDocumentType {
        public static readonly Guid Text;
        public SymDocumentType();
    }
    public class SymLanguageType {
        public static readonly Guid Basic;
        public static readonly Guid C;
        public static readonly Guid Cobol;
        public static readonly Guid CPlusPlus;
        public static readonly Guid CSharp;
        public static readonly Guid ILAssembly;
        public static readonly Guid Java;
        public static readonly Guid JScript;
        public static readonly Guid MCPlusPlus;
        public static readonly Guid Pascal;
        public static readonly Guid SMC;
        public SymLanguageType();
    }
    public class SymLanguageVendor {
        public static readonly Guid Microsoft;
        public SymLanguageVendor();
    }
}
namespace System.Diagnostics.Tracing {
    public enum EventActivityOptions {
        Detachable = 8,
        Disable = 2,
        None = 0,
        Recursive = 4,
    }
    public sealed class EventAttribute : Attribute {
        public EventAttribute(int eventId);
        public EventActivityOptions ActivityOptions { get; set; }
        public EventChannel Channel { get; set; }
        public int EventId { get; }
        public EventKeywords Keywords { get; set; }
        public EventLevel Level { get; set; }
        public string Message { get; set; }
        public EventOpcode Opcode { get; set; }
        public EventTags Tags { get; set; }
        public EventTask Task { get; set; }
        public byte Version { get; set; }
    }
    public enum EventChannel : byte {
        Admin = (byte)16,
        Analytic = (byte)18,
        Debug = (byte)19,
        None = (byte)0,
        Operational = (byte)17,
    }
    public enum EventCommand {
        Disable = -3,
        Enable = -2,
        SendManifest = -1,
        Update = 0,
    }
    public class EventCommandEventArgs : EventArgs {
        public IDictionary<string, string> Arguments { get; }
        public EventCommand Command { get; }
        public bool DisableEvent(int eventId);
        public bool EnableEvent(int eventId);
    }
    public class EventCounter {
        public EventCounter(string name, EventSource eventSource);
        public void WriteMetric(float value);
    }
    public class EventDataAttribute : Attribute {
        public EventDataAttribute();
        public string Name { get; set; }
    }
    public class EventFieldAttribute : Attribute {
        public EventFieldAttribute();
        public EventFieldFormat Format { get; set; }
        public EventFieldTags Tags { get; set; }
    }
    public enum EventFieldFormat {
        Boolean = 3,
        Default = 0,
        Hexadecimal = 4,
        HResult = 15,
        Json = 12,
        String = 2,
        Xml = 11,
    }
    public enum EventFieldTags {
        None = 0,
    }
    public class EventIgnoreAttribute : Attribute {
        public EventIgnoreAttribute();
    }
    public enum EventKeywords : long {
        All = (long)-1,
        AuditFailure = (long)4503599627370496,
        AuditSuccess = (long)9007199254740992,
        CorrelationHint = (long)4503599627370496,
        EventLogClassic = (long)36028797018963968,
        MicrosoftTelemetry = (long)562949953421312,
        None = (long)0,
        Sqm = (long)2251799813685248,
        WdiContext = (long)562949953421312,
        WdiDiagnostic = (long)1125899906842624,
    }
    public enum EventLevel {
        Critical = 1,
        Error = 2,
        Informational = 4,
        LogAlways = 0,
        Verbose = 5,
        Warning = 3,
    }
    public abstract class EventListener : IDisposable {
        protected EventListener();
        public void DisableEvents(EventSource eventSource);
        public virtual void Dispose();
        public void EnableEvents(EventSource eventSource, EventLevel level);
        public void EnableEvents(EventSource eventSource, EventLevel level, EventKeywords matchAnyKeyword);
        public void EnableEvents(EventSource eventSource, EventLevel level, EventKeywords matchAnyKeyword, IDictionary<string, string> arguments);
        protected static int EventSourceIndex(EventSource eventSource);
        protected internal virtual void OnEventSourceCreated(EventSource eventSource);
        protected internal abstract void OnEventWritten(EventWrittenEventArgs eventData);
    }
    public enum EventManifestOptions {
        AllCultures = 2,
        AllowEventSourceOverride = 8,
        None = 0,
        OnlyIfNeededForRegistration = 4,
        Strict = 1,
    }
    public enum EventOpcode {
        DataCollectionStart = 3,
        DataCollectionStop = 4,
        Extension = 5,
        Info = 0,
        Receive = 240,
        Reply = 6,
        Resume = 7,
        Send = 9,
        Start = 1,
        Stop = 2,
        Suspend = 8,
    }
    public class EventSource : IDisposable {
        protected EventSource();
        protected EventSource(bool throwOnEventWriteErrors);
        protected EventSource(EventSourceSettings settings);
        protected EventSource(EventSourceSettings settings, params string[] traits);
        public EventSource(string eventSourceName);
        public EventSource(string eventSourceName, EventSourceSettings config);
        public EventSource(string eventSourceName, EventSourceSettings config, params string[] traits);
        public Exception ConstructionException { get; }
        public static Guid CurrentThreadActivityId { get; }
        public Guid Guid { get; }
        public string Name { get; }
        public EventSourceSettings Settings { get; }
        public event EventHandler<EventCommandEventArgs> EventCommandExecuted;
        public void Dispose();
        protected virtual void Dispose(bool disposing);
        ~EventSource();
        public static string GenerateManifest(Type eventSourceType, string assemblyPathToIncludeInManifest);
        public static string GenerateManifest(Type eventSourceType, string assemblyPathToIncludeInManifest, EventManifestOptions flags);
        public static Guid GetGuid(Type eventSourceType);
        public static string GetName(Type eventSourceType);
        public static IEnumerable<EventSource> GetSources();
        public string GetTrait(string key);
        public bool IsEnabled();
        public bool IsEnabled(EventLevel level, EventKeywords keywords);
        public bool IsEnabled(EventLevel level, EventKeywords keywords, EventChannel channel);
        protected virtual void OnEventCommand(EventCommandEventArgs command);
        public static void SendCommand(EventSource eventSource, EventCommand command, IDictionary<string, string> commandArguments);
        public static void SetCurrentThreadActivityId(Guid activityId);
        public static void SetCurrentThreadActivityId(Guid activityId, out Guid oldActivityThatWillContinue);
        public override string ToString();
        public void Write(string eventName);
        public void Write(string eventName, EventSourceOptions options);
        public void Write<T>(string eventName, ref EventSourceOptions options, ref Guid activityId, ref Guid relatedActivityId, ref T data);
        public void Write<T>(string eventName, ref EventSourceOptions options, ref T data);
        public void Write<T>(string eventName, T data);
        protected void WriteEvent(int eventId);
        protected void WriteEvent(int eventId, byte[] arg1);
        protected void WriteEvent(int eventId, int arg1);
        protected void WriteEvent(int eventId, int arg1, int arg2);
        protected void WriteEvent(int eventId, int arg1, int arg2, int arg3);
        protected void WriteEvent(int eventId, int arg1, string arg2);
        protected void WriteEvent(int eventId, long arg1);
        protected void WriteEvent(int eventId, long arg1, byte[] arg2);
        protected void WriteEvent(int eventId, long arg1, long arg2);
        protected void WriteEvent(int eventId, long arg1, long arg2, long arg3);
        protected void WriteEvent(int eventId, long arg1, string arg2);
        protected void WriteEvent(int eventId, params object[] args);
        protected void WriteEvent(int eventId, string arg1);
        protected void WriteEvent(int eventId, string arg1, int arg2);
        protected void WriteEvent(int eventId, string arg1, int arg2, int arg3);
        protected void WriteEvent(int eventId, string arg1, long arg2);
        protected void WriteEvent(int eventId, string arg1, string arg2);
        protected void WriteEvent(int eventId, string arg1, string arg2, string arg3);
        protected unsafe void WriteEventCore(int eventId, int eventDataCount, EventSource.EventData* data);
        protected void WriteEventWithRelatedActivityId(int eventId, Guid relatedActivityId, params object[] args);
        protected unsafe void WriteEventWithRelatedActivityIdCore(int eventId, Guid* relatedActivityId, int eventDataCount, EventSource.EventData* data);
        protected internal struct EventData {
            public IntPtr DataPointer { get; set; }
            public int Size { get; set; }
        }
    }
    public sealed class EventSourceAttribute : Attribute {
        public EventSourceAttribute();
        public string Guid { get; set; }
        public string LocalizationResources { get; set; }
        public string Name { get; set; }
    }
    public class EventSourceException : Exception {
        public EventSourceException();
        protected EventSourceException(SerializationInfo info, StreamingContext context);
        public EventSourceException(string message);
        public EventSourceException(string message, Exception innerException);
    }
    public struct EventSourceOptions {
        public EventActivityOptions ActivityOptions { get; set; }
        public EventKeywords Keywords { get; set; }
        public EventLevel Level { get; set; }
        public EventOpcode Opcode { get; set; }
        public EventTags Tags { get; set; }
    }
    public enum EventSourceSettings {
        Default = 0,
        EtwManifestEventFormat = 4,
        EtwSelfDescribingEventFormat = 8,
        ThrowOnEventWriteErrors = 1,
    }
    public enum EventTags {
        None = 0,
    }
    public enum EventTask {
        None = 0,
    }
    public class EventWrittenEventArgs : EventArgs {
        public Guid ActivityId { get; }
        public EventChannel Channel { get; }
        public int EventId { get; }
        public string EventName { get; }
        public EventSource EventSource { get; }
        public EventKeywords Keywords { get; }
        public EventLevel Level { get; }
        public string Message { get; }
        public EventOpcode Opcode { get; }
        public ReadOnlyCollection<object> Payload { get; }
        public ReadOnlyCollection<string> PayloadNames { get; }
        public Guid RelatedActivityId { get; }
        public EventTags Tags { get; }
        public EventTask Task { get; }
        public byte Version { get; }
    }
    public sealed class NonEventAttribute : Attribute {
        public NonEventAttribute();
    }
}
namespace System.Drawing {
    public struct Color {
        public static readonly Color Empty;
        public byte A { get; }
        public static Color AliceBlue { get; }
        public static Color AntiqueWhite { get; }
        public static Color Aqua { get; }
        public static Color Aquamarine { get; }
        public static Color Azure { get; }
        public byte B { get; }
        public static Color Beige { get; }
        public static Color Bisque { get; }
        public static Color Black { get; }
        public static Color BlanchedAlmond { get; }
        public static Color Blue { get; }
        public static Color BlueViolet { get; }
        public static Color Brown { get; }
        public static Color BurlyWood { get; }
        public static Color CadetBlue { get; }
        public static Color Chartreuse { get; }
        public static Color Chocolate { get; }
        public static Color Coral { get; }
        public static Color CornflowerBlue { get; }
        public static Color Cornsilk { get; }
        public static Color Crimson { get; }
        public static Color Cyan { get; }
        public static Color DarkBlue { get; }
        public static Color DarkCyan { get; }
        public static Color DarkGoldenrod { get; }
        public static Color DarkGray { get; }
        public static Color DarkGreen { get; }
        public static Color DarkKhaki { get; }
        public static Color DarkMagenta { get; }
        public static Color DarkOliveGreen { get; }
        public static Color DarkOrange { get; }
        public static Color DarkOrchid { get; }
        public static Color DarkRed { get; }
        public static Color DarkSalmon { get; }
        public static Color DarkSeaGreen { get; }
        public static Color DarkSlateBlue { get; }
        public static Color DarkSlateGray { get; }
        public static Color DarkTurquoise { get; }
        public static Color DarkViolet { get; }
        public static Color DeepPink { get; }
        public static Color DeepSkyBlue { get; }
        public static Color DimGray { get; }
        public static Color DodgerBlue { get; }
        public static Color Firebrick { get; }
        public static Color FloralWhite { get; }
        public static Color ForestGreen { get; }
        public static Color Fuchsia { get; }
        public byte G { get; }
        public static Color Gainsboro { get; }
        public static Color GhostWhite { get; }
        public static Color Gold { get; }
        public static Color Goldenrod { get; }
        public static Color Gray { get; }
        public static Color Green { get; }
        public static Color GreenYellow { get; }
        public static Color Honeydew { get; }
        public static Color HotPink { get; }
        public static Color IndianRed { get; }
        public static Color Indigo { get; }
        public bool IsEmpty { get; }
        public bool IsNamedColor { get; }
        public static Color Ivory { get; }
        public static Color Khaki { get; }
        public static Color Lavender { get; }
        public static Color LavenderBlush { get; }
        public static Color LawnGreen { get; }
        public static Color LemonChiffon { get; }
        public static Color LightBlue { get; }
        public static Color LightCoral { get; }
        public static Color LightCyan { get; }
        public static Color LightGoldenrodYellow { get; }
        public static Color LightGray { get; }
        public static Color LightGreen { get; }
        public static Color LightPink { get; }
        public static Color LightSalmon { get; }
        public static Color LightSeaGreen { get; }
        public static Color LightSkyBlue { get; }
        public static Color LightSlateGray { get; }
        public static Color LightSteelBlue { get; }
        public static Color LightYellow { get; }
        public static Color Lime { get; }
        public static Color LimeGreen { get; }
        public static Color Linen { get; }
        public static Color Magenta { get; }
        public static Color Maroon { get; }
        public static Color MediumAquamarine { get; }
        public static Color MediumBlue { get; }
        public static Color MediumOrchid { get; }
        public static Color MediumPurple { get; }
        public static Color MediumSeaGreen { get; }
        public static Color MediumSlateBlue { get; }
        public static Color MediumSpringGreen { get; }
        public static Color MediumTurquoise { get; }
        public static Color MediumVioletRed { get; }
        public static Color MidnightBlue { get; }
        public static Color MintCream { get; }
        public static Color MistyRose { get; }
        public static Color Moccasin { get; }
        public string Name { get; }
        public static Color NavajoWhite { get; }
        public static Color Navy { get; }
        public static Color OldLace { get; }
        public static Color Olive { get; }
        public static Color OliveDrab { get; }
        public static Color Orange { get; }
        public static Color OrangeRed { get; }
        public static Color Orchid { get; }
        public static Color PaleGoldenrod { get; }
        public static Color PaleGreen { get; }
        public static Color PaleTurquoise { get; }
        public static Color PaleVioletRed { get; }
        public static Color PapayaWhip { get; }
        public static Color PeachPuff { get; }
        public static Color Peru { get; }
        public static Color Pink { get; }
        public static Color Plum { get; }
        public static Color PowderBlue { get; }
        public static Color Purple { get; }
        public byte R { get; }
        public static Color Red { get; }
        public static Color RosyBrown { get; }
        public static Color RoyalBlue { get; }
        public static Color SaddleBrown { get; }
        public static Color Salmon { get; }
        public static Color SandyBrown { get; }
        public static Color SeaGreen { get; }
        public static Color SeaShell { get; }
        public static Color Sienna { get; }
        public static Color Silver { get; }
        public static Color SkyBlue { get; }
        public static Color SlateBlue { get; }
        public static Color SlateGray { get; }
        public static Color Snow { get; }
        public static Color SpringGreen { get; }
        public static Color SteelBlue { get; }
        public static Color Tan { get; }
        public static Color Teal { get; }
        public static Color Thistle { get; }
        public static Color Tomato { get; }
        public static Color Transparent { get; }
        public static Color Turquoise { get; }
        public static Color Violet { get; }
        public static Color Wheat { get; }
        public static Color White { get; }
        public static Color WhiteSmoke { get; }
        public static Color Yellow { get; }
        public static Color YellowGreen { get; }
        public override bool Equals(object obj);
        public static Color FromArgb(int argb);
        public static Color FromArgb(int alpha, Color baseColor);
        public static Color FromArgb(int red, int green, int blue);
        public static Color FromArgb(int alpha, int red, int green, int blue);
        public static Color FromName(string name);
        public float GetBrightness();
        public override int GetHashCode();
        public float GetHue();
        public float GetSaturation();
        public static bool operator ==(Color left, Color right);
        public static bool operator !=(Color left, Color right);
        public int ToArgb();
        public override string ToString();
    }
    public struct Point {
        public static readonly Point Empty;
        public Point(Size sz);
        public Point(int dw);
        public Point(int x, int y);
        public bool IsEmpty { get; }
        public int X { get; set; }
        public int Y { get; set; }
        public static Point Add(Point pt, Size sz);
        public static Point Ceiling(PointF value);
        public override bool Equals(object obj);
        public override int GetHashCode();
        public void Offset(Point p);
        public void Offset(int dx, int dy);
        public static Point operator +(Point pt, Size sz);
        public static bool operator ==(Point left, Point right);
        public static explicit operator Size (Point p);
        public static implicit operator PointF (Point p);
        public static bool operator !=(Point left, Point right);
        public static Point operator -(Point pt, Size sz);
        public static Point Round(PointF value);
        public static Point Subtract(Point pt, Size sz);
        public override string ToString();
        public static Point Truncate(PointF value);
    }
    public struct PointF {
        public static readonly PointF Empty;
        public PointF(float x, float y);
        public bool IsEmpty { get; }
        public float X { get; set; }
        public float Y { get; set; }
        public static PointF Add(PointF pt, Size sz);
        public static PointF Add(PointF pt, SizeF sz);
        public override bool Equals(object obj);
        public override int GetHashCode();
        public static PointF operator +(PointF pt, Size sz);
        public static PointF operator +(PointF pt, SizeF sz);
        public static bool operator ==(PointF left, PointF right);
        public static bool operator !=(PointF left, PointF right);
        public static PointF operator -(PointF pt, Size sz);
        public static PointF operator -(PointF pt, SizeF sz);
        public static PointF Subtract(PointF pt, Size sz);
        public static PointF Subtract(PointF pt, SizeF sz);
        public override string ToString();
    }
    public struct Rectangle {
        public static readonly Rectangle Empty;
        public Rectangle(Point location, Size size);
        public Rectangle(int x, int y, int width, int height);
        public int Bottom { get; }
        public int Height { get; set; }
        public bool IsEmpty { get; }
        public int Left { get; }
        public Point Location { get; set; }
        public int Right { get; }
        public Size Size { get; set; }
        public int Top { get; }
        public int Width { get; set; }
        public int X { get; set; }
        public int Y { get; set; }
        public static Rectangle Ceiling(RectangleF value);
        public bool Contains(Point pt);
        public bool Contains(Rectangle rect);
        public bool Contains(int x, int y);
        public override bool Equals(object obj);
        public static Rectangle FromLTRB(int left, int top, int right, int bottom);
        public override int GetHashCode();
        public static Rectangle Inflate(Rectangle rect, int x, int y);
        public void Inflate(Size size);
        public void Inflate(int width, int height);
        public void Intersect(Rectangle rect);
        public static Rectangle Intersect(Rectangle a, Rectangle b);
        public bool IntersectsWith(Rectangle rect);
        public void Offset(Point pos);
        public void Offset(int x, int y);
        public static bool operator ==(Rectangle left, Rectangle right);
        public static bool operator !=(Rectangle left, Rectangle right);
        public static Rectangle Round(RectangleF value);
        public override string ToString();
        public static Rectangle Truncate(RectangleF value);
        public static Rectangle Union(Rectangle a, Rectangle b);
    }
    public struct RectangleF {
        public static readonly RectangleF Empty;
        public RectangleF(PointF location, SizeF size);
        public RectangleF(float x, float y, float width, float height);
        public float Bottom { get; }
        public float Height { get; set; }
        public bool IsEmpty { get; }
        public float Left { get; }
        public PointF Location { get; set; }
        public float Right { get; }
        public SizeF Size { get; set; }
        public float Top { get; }
        public float Width { get; set; }
        public float X { get; set; }
        public float Y { get; set; }
        public bool Contains(PointF pt);
        public bool Contains(RectangleF rect);
        public bool Contains(float x, float y);
        public override bool Equals(object obj);
        public static RectangleF FromLTRB(float left, float top, float right, float bottom);
        public override int GetHashCode();
        public static RectangleF Inflate(RectangleF rect, float x, float y);
        public void Inflate(SizeF size);
        public void Inflate(float x, float y);
        public void Intersect(RectangleF rect);
        public static RectangleF Intersect(RectangleF a, RectangleF b);
        public bool IntersectsWith(RectangleF rect);
        public void Offset(PointF pos);
        public void Offset(float x, float y);
        public static bool operator ==(RectangleF left, RectangleF right);
        public static implicit operator RectangleF (Rectangle r);
        public static bool operator !=(RectangleF left, RectangleF right);
        public override string ToString();
        public static RectangleF Union(RectangleF a, RectangleF b);
    }
    public struct Size {
        public static readonly Size Empty;
        public Size(Point pt);
        public Size(int width, int height);
        public int Height { get; set; }
        public bool IsEmpty { get; }
        public int Width { get; set; }
        public static Size Add(Size sz1, Size sz2);
        public static Size Ceiling(SizeF value);
        public override bool Equals(object obj);
        public override int GetHashCode();
        public static Size operator +(Size sz1, Size sz2);
        public static bool operator ==(Size sz1, Size sz2);
        public static explicit operator Point (Size size);
        public static implicit operator SizeF (Size p);
        public static bool operator !=(Size sz1, Size sz2);
        public static Size operator -(Size sz1, Size sz2);
        public static Size Round(SizeF value);
        public static Size Subtract(Size sz1, Size sz2);
        public override string ToString();
        public static Size Truncate(SizeF value);
    }
    public struct SizeF {
        public static readonly SizeF Empty;
        public SizeF(PointF pt);
        public SizeF(SizeF size);
        public SizeF(float width, float height);
        public float Height { get; set; }
        public bool IsEmpty { get; }
        public float Width { get; set; }
        public static SizeF Add(SizeF sz1, SizeF sz2);
        public override bool Equals(object obj);
        public override int GetHashCode();
        public static SizeF operator +(SizeF sz1, SizeF sz2);
        public static bool operator ==(SizeF sz1, SizeF sz2);
        public static explicit operator PointF (SizeF size);
        public static bool operator !=(SizeF sz1, SizeF sz2);
        public static SizeF operator -(SizeF sz1, SizeF sz2);
        public static SizeF Subtract(SizeF sz1, SizeF sz2);
        public PointF ToPointF();
        public Size ToSize();
        public override string ToString();
    }
}
namespace System.Dynamic {
    public abstract class BinaryOperationBinder : DynamicMetaObjectBinder {
        protected BinaryOperationBinder(ExpressionType operation);
        public ExpressionType Operation { get; }
        public sealed override Type ReturnType { get; }
        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
        public DynamicMetaObject FallbackBinaryOperation(DynamicMetaObject target, DynamicMetaObject arg);
        public abstract DynamicMetaObject FallbackBinaryOperation(DynamicMetaObject target, DynamicMetaObject arg, DynamicMetaObject errorSuggestion);
    }
    public abstract class BindingRestrictions {
        public static readonly BindingRestrictions Empty;
        public static BindingRestrictions Combine(IList<DynamicMetaObject> contributingObjects);
        public static BindingRestrictions GetExpressionRestriction(Expression expression);
        public static BindingRestrictions GetInstanceRestriction(Expression expression, object instance);
        public static BindingRestrictions GetTypeRestriction(Expression expression, Type type);
        public BindingRestrictions Merge(BindingRestrictions restrictions);
        public Expression ToExpression();
    }
    public sealed class CallInfo {
        public CallInfo(int argCount, IEnumerable<string> argNames);
        public CallInfo(int argCount, params string[] argNames);
        public int ArgumentCount { get; }
        public ReadOnlyCollection<string> ArgumentNames { get; }
        public override bool Equals(object obj);
        public override int GetHashCode();
    }
    public abstract class ConvertBinder : DynamicMetaObjectBinder {
        protected ConvertBinder(Type type, bool @explicit);
        public bool Explicit { get; }
        public sealed override Type ReturnType { get; }
        public Type Type { get; }
        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
        public DynamicMetaObject FallbackConvert(DynamicMetaObject target);
        public abstract DynamicMetaObject FallbackConvert(DynamicMetaObject target, DynamicMetaObject errorSuggestion);
    }
    public abstract class CreateInstanceBinder : DynamicMetaObjectBinder {
        protected CreateInstanceBinder(CallInfo callInfo);
        public CallInfo CallInfo { get; }
        public sealed override Type ReturnType { get; }
        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
        public DynamicMetaObject FallbackCreateInstance(DynamicMetaObject target, DynamicMetaObject[] args);
        public abstract DynamicMetaObject FallbackCreateInstance(DynamicMetaObject target, DynamicMetaObject[] args, DynamicMetaObject errorSuggestion);
    }
    public abstract class DeleteIndexBinder : DynamicMetaObjectBinder {
        protected DeleteIndexBinder(CallInfo callInfo);
        public CallInfo CallInfo { get; }
        public sealed override Type ReturnType { get; }
        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
        public DynamicMetaObject FallbackDeleteIndex(DynamicMetaObject target, DynamicMetaObject[] indexes);
        public abstract DynamicMetaObject FallbackDeleteIndex(DynamicMetaObject target, DynamicMetaObject[] indexes, DynamicMetaObject errorSuggestion);
    }
    public abstract class DeleteMemberBinder : DynamicMetaObjectBinder {
        protected DeleteMemberBinder(string name, bool ignoreCase);
        public bool IgnoreCase { get; }
        public string Name { get; }
        public sealed override Type ReturnType { get; }
        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
        public DynamicMetaObject FallbackDeleteMember(DynamicMetaObject target);
        public abstract DynamicMetaObject FallbackDeleteMember(DynamicMetaObject target, DynamicMetaObject errorSuggestion);
    }
    public class DynamicMetaObject {
        public static readonly DynamicMetaObject[] EmptyMetaObjects;
        public DynamicMetaObject(Expression expression, BindingRestrictions restrictions);
        public DynamicMetaObject(Expression expression, BindingRestrictions restrictions, object value);
        public Expression Expression { get; }
        public bool HasValue { get; }
        public Type LimitType { get; }
        public BindingRestrictions Restrictions { get; }
        public Type RuntimeType { get; }
        public object Value { get; }
        public virtual DynamicMetaObject BindBinaryOperation(BinaryOperationBinder binder, DynamicMetaObject arg);
        public virtual DynamicMetaObject BindConvert(ConvertBinder binder);
        public virtual DynamicMetaObject BindCreateInstance(CreateInstanceBinder binder, DynamicMetaObject[] args);
        public virtual DynamicMetaObject BindDeleteIndex(DeleteIndexBinder binder, DynamicMetaObject[] indexes);
        public virtual DynamicMetaObject BindDeleteMember(DeleteMemberBinder binder);
        public virtual DynamicMetaObject BindGetIndex(GetIndexBinder binder, DynamicMetaObject[] indexes);
        public virtual DynamicMetaObject BindGetMember(GetMemberBinder binder);
        public virtual DynamicMetaObject BindInvoke(InvokeBinder binder, DynamicMetaObject[] args);
        public virtual DynamicMetaObject BindInvokeMember(InvokeMemberBinder binder, DynamicMetaObject[] args);
        public virtual DynamicMetaObject BindSetIndex(SetIndexBinder binder, DynamicMetaObject[] indexes, DynamicMetaObject value);
        public virtual DynamicMetaObject BindSetMember(SetMemberBinder binder, DynamicMetaObject value);
        public virtual DynamicMetaObject BindUnaryOperation(UnaryOperationBinder binder);
        public static DynamicMetaObject Create(object value, Expression expression);
        public virtual IEnumerable<string> GetDynamicMemberNames();
    }
    public abstract class DynamicMetaObjectBinder : CallSiteBinder {
        protected DynamicMetaObjectBinder();
        public virtual Type ReturnType { get; }
        public abstract DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
        public sealed override Expression Bind(object[] args, ReadOnlyCollection<ParameterExpression> parameters, LabelTarget returnLabel);
        public DynamicMetaObject Defer(DynamicMetaObject target, params DynamicMetaObject[] args);
        public DynamicMetaObject Defer(params DynamicMetaObject[] args);
        public Expression GetUpdateExpression(Type type);
    }
    public class DynamicObject : IDynamicMetaObjectProvider {
        protected DynamicObject();
        public virtual IEnumerable<string> GetDynamicMemberNames();
        public virtual DynamicMetaObject GetMetaObject(Expression parameter);
        public virtual bool TryBinaryOperation(BinaryOperationBinder binder, object arg, out object result);
        public virtual bool TryConvert(ConvertBinder binder, out object result);
        public virtual bool TryCreateInstance(CreateInstanceBinder binder, object[] args, out object result);
        public virtual bool TryDeleteIndex(DeleteIndexBinder binder, object[] indexes);
        public virtual bool TryDeleteMember(DeleteMemberBinder binder);
        public virtual bool TryGetIndex(GetIndexBinder binder, object[] indexes, out object result);
        public virtual bool TryGetMember(GetMemberBinder binder, out object result);
        public virtual bool TryInvoke(InvokeBinder binder, object[] args, out object result);
        public virtual bool TryInvokeMember(InvokeMemberBinder binder, object[] args, out object result);
        public virtual bool TrySetIndex(SetIndexBinder binder, object[] indexes, object value);
        public virtual bool TrySetMember(SetMemberBinder binder, object value);
        public virtual bool TryUnaryOperation(UnaryOperationBinder binder, out object result);
    }
    public sealed class ExpandoObject : ICollection<KeyValuePair<string, object>>, IDictionary<string, object>, IDynamicMetaObjectProvider, IEnumerable, IEnumerable<KeyValuePair<string, object>>, INotifyPropertyChanged {
        public ExpandoObject();
        int System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Count { get; }
        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.IsReadOnly { get; }
        object System.Collections.Generic.IDictionary<System.String,System.Object>.this[string key] { get; set; }
        ICollection<string> System.Collections.Generic.IDictionary<System.String,System.Object>.Keys { get; }
        ICollection<object> System.Collections.Generic.IDictionary<System.String,System.Object>.Values { get; }
        event PropertyChangedEventHandler System.ComponentModel.INotifyPropertyChanged.PropertyChanged;
        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Add(KeyValuePair<string, object> item);
        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Clear();
        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Contains(KeyValuePair<string, object> item);
        void System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.CopyTo(KeyValuePair<string, object>[] array, int arrayIndex);
        bool System.Collections.Generic.ICollection<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.Remove(KeyValuePair<string, object> item);
        void System.Collections.Generic.IDictionary<System.String,System.Object>.Add(string key, object value);
        bool System.Collections.Generic.IDictionary<System.String,System.Object>.ContainsKey(string key);
        bool System.Collections.Generic.IDictionary<System.String,System.Object>.Remove(string key);
        bool System.Collections.Generic.IDictionary<System.String,System.Object>.TryGetValue(string key, out object value);
        IEnumerator<KeyValuePair<string, object>> System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<System.String,System.Object>>.GetEnumerator();
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        DynamicMetaObject System.Dynamic.IDynamicMetaObjectProvider.GetMetaObject(Expression parameter);
    }
    public abstract class GetIndexBinder : DynamicMetaObjectBinder {
        protected GetIndexBinder(CallInfo callInfo);
        public CallInfo CallInfo { get; }
        public sealed override Type ReturnType { get; }
        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
        public DynamicMetaObject FallbackGetIndex(DynamicMetaObject target, DynamicMetaObject[] indexes);
        public abstract DynamicMetaObject FallbackGetIndex(DynamicMetaObject target, DynamicMetaObject[] indexes, DynamicMetaObject errorSuggestion);
    }
    public abstract class GetMemberBinder : DynamicMetaObjectBinder {
        protected GetMemberBinder(string name, bool ignoreCase);
        public bool IgnoreCase { get; }
        public string Name { get; }
        public sealed override Type ReturnType { get; }
        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
        public DynamicMetaObject FallbackGetMember(DynamicMetaObject target);
        public abstract DynamicMetaObject FallbackGetMember(DynamicMetaObject target, DynamicMetaObject errorSuggestion);
    }
    public interface IDynamicMetaObjectProvider {
        DynamicMetaObject GetMetaObject(Expression parameter);
    }
    public interface IInvokeOnGetBinder {
        bool InvokeOnGet { get; }
    }
    public abstract class InvokeBinder : DynamicMetaObjectBinder {
        protected InvokeBinder(CallInfo callInfo);
        public CallInfo CallInfo { get; }
        public sealed override Type ReturnType { get; }
        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
        public DynamicMetaObject FallbackInvoke(DynamicMetaObject target, DynamicMetaObject[] args);
        public abstract DynamicMetaObject FallbackInvoke(DynamicMetaObject target, DynamicMetaObject[] args, DynamicMetaObject errorSuggestion);
    }
    public abstract class InvokeMemberBinder : DynamicMetaObjectBinder {
        protected InvokeMemberBinder(string name, bool ignoreCase, CallInfo callInfo);
        public CallInfo CallInfo { get; }
        public bool IgnoreCase { get; }
        public string Name { get; }
        public sealed override Type ReturnType { get; }
        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
        public abstract DynamicMetaObject FallbackInvoke(DynamicMetaObject target, DynamicMetaObject[] args, DynamicMetaObject errorSuggestion);
        public DynamicMetaObject FallbackInvokeMember(DynamicMetaObject target, DynamicMetaObject[] args);
        public abstract DynamicMetaObject FallbackInvokeMember(DynamicMetaObject target, DynamicMetaObject[] args, DynamicMetaObject errorSuggestion);
    }
    public abstract class SetIndexBinder : DynamicMetaObjectBinder {
        protected SetIndexBinder(CallInfo callInfo);
        public CallInfo CallInfo { get; }
        public sealed override Type ReturnType { get; }
        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
        public DynamicMetaObject FallbackSetIndex(DynamicMetaObject target, DynamicMetaObject[] indexes, DynamicMetaObject value);
        public abstract DynamicMetaObject FallbackSetIndex(DynamicMetaObject target, DynamicMetaObject[] indexes, DynamicMetaObject value, DynamicMetaObject errorSuggestion);
    }
    public abstract class SetMemberBinder : DynamicMetaObjectBinder {
        protected SetMemberBinder(string name, bool ignoreCase);
        public bool IgnoreCase { get; }
        public string Name { get; }
        public sealed override Type ReturnType { get; }
        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
        public DynamicMetaObject FallbackSetMember(DynamicMetaObject target, DynamicMetaObject value);
        public abstract DynamicMetaObject FallbackSetMember(DynamicMetaObject target, DynamicMetaObject value, DynamicMetaObject errorSuggestion);
    }
    public abstract class UnaryOperationBinder : DynamicMetaObjectBinder {
        protected UnaryOperationBinder(ExpressionType operation);
        public ExpressionType Operation { get; }
        public sealed override Type ReturnType { get; }
        public sealed override DynamicMetaObject Bind(DynamicMetaObject target, DynamicMetaObject[] args);
        public DynamicMetaObject FallbackUnaryOperation(DynamicMetaObject target);
        public abstract DynamicMetaObject FallbackUnaryOperation(DynamicMetaObject target, DynamicMetaObject errorSuggestion);
    }
}
namespace System.Globalization {
    public abstract class Calendar : ICloneable {
        public const int CurrentEra = 0;
        protected Calendar();
        public virtual CalendarAlgorithmType AlgorithmType { get; }
        protected virtual int DaysInYearBeforeMinSupportedYear { get; }
        public abstract int[] Eras { get; }
        public bool IsReadOnly { get; }
        public virtual DateTime MaxSupportedDateTime { get; }
        public virtual DateTime MinSupportedDateTime { get; }
        public virtual int TwoDigitYearMax { get; set; }
        public virtual DateTime AddDays(DateTime time, int days);
        public virtual DateTime AddHours(DateTime time, int hours);
        public virtual DateTime AddMilliseconds(DateTime time, double milliseconds);
        public virtual DateTime AddMinutes(DateTime time, int minutes);
        public abstract DateTime AddMonths(DateTime time, int months);
        public virtual DateTime AddSeconds(DateTime time, int seconds);
        public virtual DateTime AddWeeks(DateTime time, int weeks);
        public abstract DateTime AddYears(DateTime time, int years);
        public virtual object Clone();
        public abstract int GetDayOfMonth(DateTime time);
        public abstract DayOfWeek GetDayOfWeek(DateTime time);
        public abstract int GetDayOfYear(DateTime time);
        public virtual int GetDaysInMonth(int year, int month);
        public abstract int GetDaysInMonth(int year, int month, int era);
        public virtual int GetDaysInYear(int year);
        public abstract int GetDaysInYear(int year, int era);
        public abstract int GetEra(DateTime time);
        public virtual int GetHour(DateTime time);
        public virtual int GetLeapMonth(int year);
        public virtual int GetLeapMonth(int year, int era);
        public virtual double GetMilliseconds(DateTime time);
        public virtual int GetMinute(DateTime time);
        public abstract int GetMonth(DateTime time);
        public virtual int GetMonthsInYear(int year);
        public abstract int GetMonthsInYear(int year, int era);
        public virtual int GetSecond(DateTime time);
        public virtual int GetWeekOfYear(DateTime time, CalendarWeekRule rule, DayOfWeek firstDayOfWeek);
        public abstract int GetYear(DateTime time);
        public virtual bool IsLeapDay(int year, int month, int day);
        public abstract bool IsLeapDay(int year, int month, int day, int era);
        public virtual bool IsLeapMonth(int year, int month);
        public abstract bool IsLeapMonth(int year, int month, int era);
        public virtual bool IsLeapYear(int year);
        public abstract bool IsLeapYear(int year, int era);
        public static Calendar ReadOnly(Calendar calendar);
        public virtual DateTime ToDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond);
        public abstract DateTime ToDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int era);
        public virtual int ToFourDigitYear(int year);
    }
    public enum CalendarAlgorithmType {
        LunarCalendar = 2,
        LunisolarCalendar = 3,
        SolarCalendar = 1,
        Unknown = 0,
    }
    public enum CalendarWeekRule {
        FirstDay = 0,
        FirstFourDayWeek = 2,
        FirstFullWeek = 1,
    }
    public static class CharUnicodeInfo {
        public static int GetDecimalDigitValue(char ch);
        public static int GetDecimalDigitValue(string s, int index);
        public static int GetDigitValue(char ch);
        public static int GetDigitValue(string s, int index);
        public static double GetNumericValue(char ch);
        public static double GetNumericValue(string s, int index);
        public static UnicodeCategory GetUnicodeCategory(char ch);
        public static UnicodeCategory GetUnicodeCategory(string s, int index);
    }
    public class ChineseLunisolarCalendar : EastAsianLunisolarCalendar {
        public const int ChineseEra = 1;
        public ChineseLunisolarCalendar();
        protected override int DaysInYearBeforeMinSupportedYear { get; }
        public override int[] Eras { get; }
        public override DateTime MaxSupportedDateTime { get; }
        public override DateTime MinSupportedDateTime { get; }
        public override int GetEra(DateTime time);
    }
    public class CompareInfo : IDeserializationCallback {
        public int LCID { get; }
        public virtual string Name { get; }
        public SortVersion Version { get; }
        public virtual int Compare(string string1, int offset1, int length1, string string2, int offset2, int length2);
        public virtual int Compare(string string1, int offset1, int length1, string string2, int offset2, int length2, CompareOptions options);
        public virtual int Compare(string string1, int offset1, string string2, int offset2);
        public virtual int Compare(string string1, int offset1, string string2, int offset2, CompareOptions options);
        public virtual int Compare(string string1, string string2);
        public virtual int Compare(string string1, string string2, CompareOptions options);
        public override bool Equals(object value);
        public static CompareInfo GetCompareInfo(int culture);
        public static CompareInfo GetCompareInfo(int culture, Assembly assembly);
        public static CompareInfo GetCompareInfo(string name);
        public static CompareInfo GetCompareInfo(string name, Assembly assembly);
        public override int GetHashCode();
        public virtual int GetHashCode(string source, CompareOptions options);
        public virtual SortKey GetSortKey(string source);
        public virtual SortKey GetSortKey(string source, CompareOptions options);
        public virtual int IndexOf(string source, char value);
        public virtual int IndexOf(string source, char value, CompareOptions options);
        public virtual int IndexOf(string source, char value, int startIndex);
        public virtual int IndexOf(string source, char value, int startIndex, CompareOptions options);
        public virtual int IndexOf(string source, char value, int startIndex, int count);
        public virtual int IndexOf(string source, char value, int startIndex, int count, CompareOptions options);
        public virtual int IndexOf(string source, string value);
        public virtual int IndexOf(string source, string value, CompareOptions options);
        public virtual int IndexOf(string source, string value, int startIndex);
        public virtual int IndexOf(string source, string value, int startIndex, CompareOptions options);
        public virtual int IndexOf(string source, string value, int startIndex, int count);
        public virtual int IndexOf(string source, string value, int startIndex, int count, CompareOptions options);
        public virtual bool IsPrefix(string source, string prefix);
        public virtual bool IsPrefix(string source, string prefix, CompareOptions options);
        public static bool IsSortable(char ch);
        public static bool IsSortable(string text);
        public virtual bool IsSuffix(string source, string suffix);
        public virtual bool IsSuffix(string source, string suffix, CompareOptions options);
        public virtual int LastIndexOf(string source, char value);
        public virtual int LastIndexOf(string source, char value, CompareOptions options);
        public virtual int LastIndexOf(string source, char value, int startIndex);
        public virtual int LastIndexOf(string source, char value, int startIndex, CompareOptions options);
        public virtual int LastIndexOf(string source, char value, int startIndex, int count);
        public virtual int LastIndexOf(string source, char value, int startIndex, int count, CompareOptions options);
        public virtual int LastIndexOf(string source, string value);
        public virtual int LastIndexOf(string source, string value, CompareOptions options);
        public virtual int LastIndexOf(string source, string value, int startIndex);
        public virtual int LastIndexOf(string source, string value, int startIndex, CompareOptions options);
        public virtual int LastIndexOf(string source, string value, int startIndex, int count);
        public virtual int LastIndexOf(string source, string value, int startIndex, int count, CompareOptions options);
        void System.Runtime.Serialization.IDeserializationCallback.OnDeserialization(object sender);
        public override string ToString();
    }
    public enum CompareOptions {
        IgnoreCase = 1,
        IgnoreKanaType = 8,
        IgnoreNonSpace = 2,
        IgnoreSymbols = 4,
        IgnoreWidth = 16,
        None = 0,
        Ordinal = 1073741824,
        OrdinalIgnoreCase = 268435456,
        StringSort = 536870912,
    }
    public class CultureInfo : ICloneable, IFormatProvider {
        public CultureInfo(int culture);
        public CultureInfo(int culture, bool useUserOverride);
        public CultureInfo(string name);
        public CultureInfo(string name, bool useUserOverride);
        public virtual Calendar Calendar { get; }
        public virtual CompareInfo CompareInfo { get; }
        public CultureTypes CultureTypes { get; }
        public static CultureInfo CurrentCulture { get; set; }
        public static CultureInfo CurrentUICulture { get; set; }
        public virtual DateTimeFormatInfo DateTimeFormat { get; set; }
        public static CultureInfo DefaultThreadCurrentCulture { get; set; }
        public static CultureInfo DefaultThreadCurrentUICulture { get; set; }
        public virtual string DisplayName { get; }
        public virtual string EnglishName { get; }
        public string IetfLanguageTag { get; }
        public static CultureInfo InstalledUICulture { get; }
        public static CultureInfo InvariantCulture { get; }
        public virtual bool IsNeutralCulture { get; }
        public bool IsReadOnly { get; }
        public virtual int KeyboardLayoutId { get; }
        public virtual int LCID { get; }
        public virtual string Name { get; }
        public virtual string NativeName { get; }
        public virtual NumberFormatInfo NumberFormat { get; set; }
        public virtual Calendar[] OptionalCalendars { get; }
        public virtual CultureInfo Parent { get; }
        public virtual TextInfo TextInfo { get; }
        public virtual string ThreeLetterISOLanguageName { get; }
        public virtual string ThreeLetterWindowsLanguageName { get; }
        public virtual string TwoLetterISOLanguageName { get; }
        public bool UseUserOverride { get; }
        public void ClearCachedData();
        public virtual object Clone();
        public static CultureInfo CreateSpecificCulture(string name);
        public override bool Equals(object value);
        public CultureInfo GetConsoleFallbackUICulture();
        public static CultureInfo GetCultureInfo(int culture);
        public static CultureInfo GetCultureInfo(string name);
        public static CultureInfo GetCultureInfo(string name, string altName);
        public static CultureInfo GetCultureInfoByIetfLanguageTag(string name);
        public static CultureInfo[] GetCultures(CultureTypes types);
        public virtual object GetFormat(Type formatType);
        public override int GetHashCode();
        public static CultureInfo ReadOnly(CultureInfo ci);
        public override string ToString();
    }
    public class CultureNotFoundException : ArgumentException, ISerializable {
        public CultureNotFoundException();
        protected CultureNotFoundException(SerializationInfo info, StreamingContext context);
        public CultureNotFoundException(string message);
        public CultureNotFoundException(string message, Exception innerException);
        public CultureNotFoundException(string message, int invalidCultureId, Exception innerException);
        public CultureNotFoundException(string paramName, int invalidCultureId, string message);
        public CultureNotFoundException(string paramName, string message);
        public CultureNotFoundException(string message, string invalidCultureName, Exception innerException);
        public CultureNotFoundException(string paramName, string invalidCultureName, string message);
        public virtual Nullable<int> InvalidCultureId { get; }
        public virtual string InvalidCultureName { get; }
        public override string Message { get; }
        public override void GetObjectData(SerializationInfo info, StreamingContext context);
    }
    public enum CultureTypes {
        AllCultures = 7,
        FrameworkCultures = 64,
        InstalledWin32Cultures = 4,
        NeutralCultures = 1,
        ReplacementCultures = 16,
        SpecificCultures = 2,
        UserCustomCulture = 8,
        WindowsOnlyCultures = 32,
    }
    public sealed class DateTimeFormatInfo : ICloneable, IFormatProvider {
        public DateTimeFormatInfo();
        public string[] AbbreviatedDayNames { get; set; }
        public string[] AbbreviatedMonthGenitiveNames { get; set; }
        public string[] AbbreviatedMonthNames { get; set; }
        public string AMDesignator { get; set; }
        public Calendar Calendar { get; set; }
        public CalendarWeekRule CalendarWeekRule { get; set; }
        public static DateTimeFormatInfo CurrentInfo { get; }
        public string DateSeparator { get; set; }
        public string[] DayNames { get; set; }
        public DayOfWeek FirstDayOfWeek { get; set; }
        public string FullDateTimePattern { get; set; }
        public static DateTimeFormatInfo InvariantInfo { get; }
        public bool IsReadOnly { get; }
        public string LongDatePattern { get; set; }
        public string LongTimePattern { get; set; }
        public string MonthDayPattern { get; set; }
        public string[] MonthGenitiveNames { get; set; }
        public string[] MonthNames { get; set; }
        public string NativeCalendarName { get; }
        public string PMDesignator { get; set; }
        public string RFC1123Pattern { get; }
        public string ShortDatePattern { get; set; }
        public string[] ShortestDayNames { get; set; }
        public string ShortTimePattern { get; set; }
        public string SortableDateTimePattern { get; }
        public string TimeSeparator { get; set; }
        public string UniversalSortableDateTimePattern { get; }
        public string YearMonthPattern { get; set; }
        public object Clone();
        public string GetAbbreviatedDayName(DayOfWeek dayofweek);
        public string GetAbbreviatedEraName(int era);
        public string GetAbbreviatedMonthName(int month);
        public string[] GetAllDateTimePatterns();
        public string[] GetAllDateTimePatterns(char format);
        public string GetDayName(DayOfWeek dayofweek);
        public int GetEra(string eraName);
        public string GetEraName(int era);
        public object GetFormat(Type formatType);
        public static DateTimeFormatInfo GetInstance(IFormatProvider provider);
        public string GetMonthName(int month);
        public string GetShortestDayName(DayOfWeek dayOfWeek);
        public static DateTimeFormatInfo ReadOnly(DateTimeFormatInfo dtfi);
        public void SetAllDateTimePatterns(string[] patterns, char format);
    }
    public enum DateTimeStyles {
        AdjustToUniversal = 16,
        AllowInnerWhite = 4,
        AllowLeadingWhite = 1,
        AllowTrailingWhite = 2,
        AllowWhiteSpaces = 7,
        AssumeLocal = 32,
        AssumeUniversal = 64,
        NoCurrentDateDefault = 8,
        None = 0,
        RoundtripKind = 128,
    }
    public class DaylightTime {
        public DaylightTime(DateTime start, DateTime end, TimeSpan delta);
        public TimeSpan Delta { get; }
        public DateTime End { get; }
        public DateTime Start { get; }
    }
    public enum DigitShapes {
        Context = 0,
        NativeNational = 2,
        None = 1,
    }
    public abstract class EastAsianLunisolarCalendar : Calendar {
        public override CalendarAlgorithmType AlgorithmType { get; }
        public override int TwoDigitYearMax { get; set; }
        public override DateTime AddMonths(DateTime time, int months);
        public override DateTime AddYears(DateTime time, int years);
        public int GetCelestialStem(int sexagenaryYear);
        public override int GetDayOfMonth(DateTime time);
        public override DayOfWeek GetDayOfWeek(DateTime time);
        public override int GetDayOfYear(DateTime time);
        public override int GetDaysInMonth(int year, int month, int era);
        public override int GetDaysInYear(int year, int era);
        public override int GetLeapMonth(int year, int era);
        public override int GetMonth(DateTime time);
        public override int GetMonthsInYear(int year, int era);
        public virtual int GetSexagenaryYear(DateTime time);
        public int GetTerrestrialBranch(int sexagenaryYear);
        public override int GetYear(DateTime time);
        public override bool IsLeapDay(int year, int month, int day, int era);
        public override bool IsLeapMonth(int year, int month, int era);
        public override bool IsLeapYear(int year, int era);
        public override DateTime ToDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int era);
        public override int ToFourDigitYear(int year);
    }
    public static class GlobalizationExtensions {
        public static StringComparer GetStringComparer(this CompareInfo compareInfo, CompareOptions options);
    }
    public class GregorianCalendar : Calendar {
        public const int ADEra = 1;
        public GregorianCalendar();
        public GregorianCalendar(GregorianCalendarTypes type);
        public override CalendarAlgorithmType AlgorithmType { get; }
        public virtual GregorianCalendarTypes CalendarType { get; set; }
        public override int[] Eras { get; }
        public override DateTime MaxSupportedDateTime { get; }
        public override DateTime MinSupportedDateTime { get; }
        public override int TwoDigitYearMax { get; set; }
        public override DateTime AddMonths(DateTime time, int months);
        public override DateTime AddYears(DateTime time, int years);
        public override int GetDayOfMonth(DateTime time);
        public override DayOfWeek GetDayOfWeek(DateTime time);
        public override int GetDayOfYear(DateTime time);
        public override int GetDaysInMonth(int year, int month, int era);
        public override int GetDaysInYear(int year, int era);
        public override int GetEra(DateTime time);
        public override int GetLeapMonth(int year, int era);
        public override int GetMonth(DateTime time);
        public override int GetMonthsInYear(int year, int era);
        public override int GetYear(DateTime time);
        public override bool IsLeapDay(int year, int month, int day, int era);
        public override bool IsLeapMonth(int year, int month, int era);
        public override bool IsLeapYear(int year, int era);
        public override DateTime ToDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int era);
        public override int ToFourDigitYear(int year);
    }
    public enum GregorianCalendarTypes {
        Arabic = 10,
        Localized = 1,
        MiddleEastFrench = 9,
        TransliteratedEnglish = 11,
        TransliteratedFrench = 12,
        USEnglish = 2,
    }
    public class HebrewCalendar : Calendar {
        public static readonly int HebrewEra;
        public HebrewCalendar();
        public override CalendarAlgorithmType AlgorithmType { get; }
        public override int[] Eras { get; }
        public override DateTime MaxSupportedDateTime { get; }
        public override DateTime MinSupportedDateTime { get; }
        public override int TwoDigitYearMax { get; set; }
        public override DateTime AddMonths(DateTime time, int months);
        public override DateTime AddYears(DateTime time, int years);
        public override int GetDayOfMonth(DateTime time);
        public override DayOfWeek GetDayOfWeek(DateTime time);
        public override int GetDayOfYear(DateTime time);
        public override int GetDaysInMonth(int year, int month, int era);
        public override int GetDaysInYear(int year, int era);
        public override int GetEra(DateTime time);
        public override int GetLeapMonth(int year, int era);
        public override int GetMonth(DateTime time);
        public override int GetMonthsInYear(int year, int era);
        public override int GetYear(DateTime time);
        public override bool IsLeapDay(int year, int month, int day, int era);
        public override bool IsLeapMonth(int year, int month, int era);
        public override bool IsLeapYear(int year, int era);
        public override DateTime ToDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int era);
        public override int ToFourDigitYear(int year);
    }
    public class HijriCalendar : Calendar {
        public static readonly int HijriEra;
        public HijriCalendar();
        public override CalendarAlgorithmType AlgorithmType { get; }
        protected override int DaysInYearBeforeMinSupportedYear { get; }
        public override int[] Eras { get; }
        public int HijriAdjustment { get; set; }
        public override DateTime MaxSupportedDateTime { get; }
        public override DateTime MinSupportedDateTime { get; }
        public override int TwoDigitYearMax { get; set; }
        public override DateTime AddMonths(DateTime time, int months);
        public override DateTime AddYears(DateTime time, int years);
        public override int GetDayOfMonth(DateTime time);
        public override DayOfWeek GetDayOfWeek(DateTime time);
        public override int GetDayOfYear(DateTime time);
        public override int GetDaysInMonth(int year, int month, int era);
        public override int GetDaysInYear(int year, int era);
        public override int GetEra(DateTime time);
        public override int GetLeapMonth(int year, int era);
        public override int GetMonth(DateTime time);
        public override int GetMonthsInYear(int year, int era);
        public override int GetYear(DateTime time);
        public override bool IsLeapDay(int year, int month, int day, int era);
        public override bool IsLeapMonth(int year, int month, int era);
        public override bool IsLeapYear(int year, int era);
        public override DateTime ToDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int era);
        public override int ToFourDigitYear(int year);
    }
    public sealed class IdnMapping {
        public IdnMapping();
        public bool AllowUnassigned { get; set; }
        public bool UseStd3AsciiRules { get; set; }
        public override bool Equals(object obj);
        public string GetAscii(string unicode);
        public string GetAscii(string unicode, int index);
        public string GetAscii(string unicode, int index, int count);
        public override int GetHashCode();
        public string GetUnicode(string ascii);
        public string GetUnicode(string ascii, int index);
        public string GetUnicode(string ascii, int index, int count);
    }
    public class JapaneseCalendar : Calendar {
        public JapaneseCalendar();
        public override CalendarAlgorithmType AlgorithmType { get; }
        public override int[] Eras { get; }
        public override DateTime MaxSupportedDateTime { get; }
        public override DateTime MinSupportedDateTime { get; }
        public override int TwoDigitYearMax { get; set; }
        public override DateTime AddMonths(DateTime time, int months);
        public override DateTime AddYears(DateTime time, int years);
        public override int GetDayOfMonth(DateTime time);
        public override DayOfWeek GetDayOfWeek(DateTime time);
        public override int GetDayOfYear(DateTime time);
        public override int GetDaysInMonth(int year, int month, int era);
        public override int GetDaysInYear(int year, int era);
        public override int GetEra(DateTime time);
        public override int GetLeapMonth(int year, int era);
        public override int GetMonth(DateTime time);
        public override int GetMonthsInYear(int year, int era);
        public override int GetWeekOfYear(DateTime time, CalendarWeekRule rule, DayOfWeek firstDayOfWeek);
        public override int GetYear(DateTime time);
        public override bool IsLeapDay(int year, int month, int day, int era);
        public override bool IsLeapMonth(int year, int month, int era);
        public override bool IsLeapYear(int year, int era);
        public override DateTime ToDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int era);
        public override int ToFourDigitYear(int year);
    }
    public class JapaneseLunisolarCalendar : EastAsianLunisolarCalendar {
        public const int JapaneseEra = 1;
        public JapaneseLunisolarCalendar();
        protected override int DaysInYearBeforeMinSupportedYear { get; }
        public override int[] Eras { get; }
        public override DateTime MaxSupportedDateTime { get; }
        public override DateTime MinSupportedDateTime { get; }
        public override int GetEra(DateTime time);
    }
    public class JulianCalendar : Calendar {
        public static readonly int JulianEra;
        public JulianCalendar();
        public override CalendarAlgorithmType AlgorithmType { get; }
        public override int[] Eras { get; }
        public override DateTime MaxSupportedDateTime { get; }
        public override DateTime MinSupportedDateTime { get; }
        public override int TwoDigitYearMax { get; set; }
        public override DateTime AddMonths(DateTime time, int months);
        public override DateTime AddYears(DateTime time, int years);
        public override int GetDayOfMonth(DateTime time);
        public override DayOfWeek GetDayOfWeek(DateTime time);
        public override int GetDayOfYear(DateTime time);
        public override int GetDaysInMonth(int year, int month, int era);
        public override int GetDaysInYear(int year, int era);
        public override int GetEra(DateTime time);
        public override int GetLeapMonth(int year, int era);
        public override int GetMonth(DateTime time);
        public override int GetMonthsInYear(int year, int era);
        public override int GetYear(DateTime time);
        public override bool IsLeapDay(int year, int month, int day, int era);
        public override bool IsLeapMonth(int year, int month, int era);
        public override bool IsLeapYear(int year, int era);
        public override DateTime ToDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int era);
        public override int ToFourDigitYear(int year);
    }
    public class KoreanCalendar : Calendar {
        public const int KoreanEra = 1;
        public KoreanCalendar();
        public override CalendarAlgorithmType AlgorithmType { get; }
        public override int[] Eras { get; }
        public override DateTime MaxSupportedDateTime { get; }
        public override DateTime MinSupportedDateTime { get; }
        public override int TwoDigitYearMax { get; set; }
        public override DateTime AddMonths(DateTime time, int months);
        public override DateTime AddYears(DateTime time, int years);
        public override int GetDayOfMonth(DateTime time);
        public override DayOfWeek GetDayOfWeek(DateTime time);
        public override int GetDayOfYear(DateTime time);
        public override int GetDaysInMonth(int year, int month, int era);
        public override int GetDaysInYear(int year, int era);
        public override int GetEra(DateTime time);
        public override int GetLeapMonth(int year, int era);
        public override int GetMonth(DateTime time);
        public override int GetMonthsInYear(int year, int era);
        public override int GetWeekOfYear(DateTime time, CalendarWeekRule rule, DayOfWeek firstDayOfWeek);
        public override int GetYear(DateTime time);
        public override bool IsLeapDay(int year, int month, int day, int era);
        public override bool IsLeapMonth(int year, int month, int era);
        public override bool IsLeapYear(int year, int era);
        public override DateTime ToDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int era);
        public override int ToFourDigitYear(int year);
    }
    public class KoreanLunisolarCalendar : EastAsianLunisolarCalendar {
        public const int GregorianEra = 1;
        public KoreanLunisolarCalendar();
        protected override int DaysInYearBeforeMinSupportedYear { get; }
        public override int[] Eras { get; }
        public override DateTime MaxSupportedDateTime { get; }
        public override DateTime MinSupportedDateTime { get; }
        public override int GetEra(DateTime time);
    }
    public sealed class NumberFormatInfo : ICloneable, IFormatProvider {
        public NumberFormatInfo();
        public int CurrencyDecimalDigits { get; set; }
        public string CurrencyDecimalSeparator { get; set; }
        public string CurrencyGroupSeparator { get; set; }
        public int[] CurrencyGroupSizes { get; set; }
        public int CurrencyNegativePattern { get; set; }
        public int CurrencyPositivePattern { get; set; }
        public string CurrencySymbol { get; set; }
        public static NumberFormatInfo CurrentInfo { get; }
        public DigitShapes DigitSubstitution { get; set; }
        public static NumberFormatInfo InvariantInfo { get; }
        public bool IsReadOnly { get; }
        public string NaNSymbol { get; set; }
        public string[] NativeDigits { get; set; }
        public string NegativeInfinitySymbol { get; set; }
        public string NegativeSign { get; set; }
        public int NumberDecimalDigits { get; set; }
        public string NumberDecimalSeparator { get; set; }
        public string NumberGroupSeparator { get; set; }
        public int[] NumberGroupSizes { get; set; }
        public int NumberNegativePattern { get; set; }
        public int PercentDecimalDigits { get; set; }
        public string PercentDecimalSeparator { get; set; }
        public string PercentGroupSeparator { get; set; }
        public int[] PercentGroupSizes { get; set; }
        public int PercentNegativePattern { get; set; }
        public int PercentPositivePattern { get; set; }
        public string PercentSymbol { get; set; }
        public string PerMilleSymbol { get; set; }
        public string PositiveInfinitySymbol { get; set; }
        public string PositiveSign { get; set; }
        public object Clone();
        public object GetFormat(Type formatType);
        public static NumberFormatInfo GetInstance(IFormatProvider formatProvider);
        public static NumberFormatInfo ReadOnly(NumberFormatInfo nfi);
    }
    public enum NumberStyles {
        AllowCurrencySymbol = 256,
        AllowDecimalPoint = 32,
        AllowExponent = 128,
        AllowHexSpecifier = 512,
        AllowLeadingSign = 4,
        AllowLeadingWhite = 1,
        AllowParentheses = 16,
        AllowThousands = 64,
        AllowTrailingSign = 8,
        AllowTrailingWhite = 2,
        Any = 511,
        Currency = 383,
        Float = 167,
        HexNumber = 515,
        Integer = 7,
        None = 0,
        Number = 111,
    }
    public class PersianCalendar : Calendar {
        public static readonly int PersianEra;
        public PersianCalendar();
        public override CalendarAlgorithmType AlgorithmType { get; }
        public override int[] Eras { get; }
        public override DateTime MaxSupportedDateTime { get; }
        public override DateTime MinSupportedDateTime { get; }
        public override int TwoDigitYearMax { get; set; }
        public override DateTime AddMonths(DateTime time, int months);
        public override DateTime AddYears(DateTime time, int years);
        public override int GetDayOfMonth(DateTime time);
        public override DayOfWeek GetDayOfWeek(DateTime time);
        public override int GetDayOfYear(DateTime time);
        public override int GetDaysInMonth(int year, int month, int era);
        public override int GetDaysInYear(int year, int era);
        public override int GetEra(DateTime time);
        public override int GetLeapMonth(int year, int era);
        public override int GetMonth(DateTime time);
        public override int GetMonthsInYear(int year, int era);
        public override int GetYear(DateTime time);
        public override bool IsLeapDay(int year, int month, int day, int era);
        public override bool IsLeapMonth(int year, int month, int era);
        public override bool IsLeapYear(int year, int era);
        public override DateTime ToDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int era);
        public override int ToFourDigitYear(int year);
    }
    public class RegionInfo {
        public RegionInfo(int culture);
        public RegionInfo(string name);
        public virtual string CurrencyEnglishName { get; }
        public virtual string CurrencyNativeName { get; }
        public virtual string CurrencySymbol { get; }
        public static RegionInfo CurrentRegion { get; }
        public virtual string DisplayName { get; }
        public virtual string EnglishName { get; }
        public virtual int GeoId { get; }
        public virtual bool IsMetric { get; }
        public virtual string ISOCurrencySymbol { get; }
        public virtual string Name { get; }
        public virtual string NativeName { get; }
        public virtual string ThreeLetterISORegionName { get; }
        public virtual string ThreeLetterWindowsRegionName { get; }
        public virtual string TwoLetterISORegionName { get; }
        public override bool Equals(object value);
        public override int GetHashCode();
        public override string ToString();
    }
    public class SortKey {
        public virtual byte[] KeyData { get; }
        public virtual string OriginalString { get; }
        public static int Compare(SortKey sortkey1, SortKey sortkey2);
        public override bool Equals(object value);
        public override int GetHashCode();
        public override string ToString();
    }
    public sealed class SortVersion : IEquatable<SortVersion> {
        public SortVersion(int fullVersion, Guid sortId);
        public int FullVersion { get; }
        public Guid SortId { get; }
        public bool Equals(SortVersion other);
        public override bool Equals(object obj);
        public override int GetHashCode();
        public static bool operator ==(SortVersion left, SortVersion right);
        public static bool operator !=(SortVersion left, SortVersion right);
    }
    public class StringInfo {
        public StringInfo();
        public StringInfo(string value);
        public int LengthInTextElements { get; }
        public string String { get; set; }
        public override bool Equals(object value);
        public override int GetHashCode();
        public static string GetNextTextElement(string str);
        public static string GetNextTextElement(string str, int index);
        public static TextElementEnumerator GetTextElementEnumerator(string str);
        public static TextElementEnumerator GetTextElementEnumerator(string str, int index);
        public static int[] ParseCombiningCharacters(string str);
        public string SubstringByTextElements(int startingTextElement);
        public string SubstringByTextElements(int startingTextElement, int lengthInTextElements);
    }
    public class TaiwanCalendar : Calendar {
        public TaiwanCalendar();
        public override CalendarAlgorithmType AlgorithmType { get; }
        public override int[] Eras { get; }
        public override DateTime MaxSupportedDateTime { get; }
        public override DateTime MinSupportedDateTime { get; }
        public override int TwoDigitYearMax { get; set; }
        public override DateTime AddMonths(DateTime time, int months);
        public override DateTime AddYears(DateTime time, int years);
        public override int GetDayOfMonth(DateTime time);
        public override DayOfWeek GetDayOfWeek(DateTime time);
        public override int GetDayOfYear(DateTime time);
        public override int GetDaysInMonth(int year, int month, int era);
        public override int GetDaysInYear(int year, int era);
        public override int GetEra(DateTime time);
        public override int GetLeapMonth(int year, int era);
        public override int GetMonth(DateTime time);
        public override int GetMonthsInYear(int year, int era);
        public override int GetWeekOfYear(DateTime time, CalendarWeekRule rule, DayOfWeek firstDayOfWeek);
        public override int GetYear(DateTime time);
        public override bool IsLeapDay(int year, int month, int day, int era);
        public override bool IsLeapMonth(int year, int month, int era);
        public override bool IsLeapYear(int year, int era);
        public override DateTime ToDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int era);
        public override int ToFourDigitYear(int year);
    }
    public class TaiwanLunisolarCalendar : EastAsianLunisolarCalendar {
        public TaiwanLunisolarCalendar();
        protected override int DaysInYearBeforeMinSupportedYear { get; }
        public override int[] Eras { get; }
        public override DateTime MaxSupportedDateTime { get; }
        public override DateTime MinSupportedDateTime { get; }
        public override int GetEra(DateTime time);
    }
    public class TextElementEnumerator : IEnumerator {
        public object Current { get; }
        public int ElementIndex { get; }
        public string GetTextElement();
        public bool MoveNext();
        public void Reset();
    }
    public class TextInfo : ICloneable, IDeserializationCallback {
        public virtual int ANSICodePage { get; }
        public string CultureName { get; }
        public virtual int EBCDICCodePage { get; }
        public bool IsReadOnly { get; }
        public bool IsRightToLeft { get; }
        public int LCID { get; }
        public virtual string ListSeparator { get; set; }
        public virtual int MacCodePage { get; }
        public virtual int OEMCodePage { get; }
        public virtual object Clone();
        public override bool Equals(object obj);
        public override int GetHashCode();
        public static TextInfo ReadOnly(TextInfo textInfo);
        void System.Runtime.Serialization.IDeserializationCallback.OnDeserialization(object sender);
        public virtual char ToLower(char c);
        public virtual string ToLower(string str);
        public override string ToString();
        public string ToTitleCase(string str);
        public virtual char ToUpper(char c);
        public virtual string ToUpper(string str);
    }
    public class ThaiBuddhistCalendar : Calendar {
        public const int ThaiBuddhistEra = 1;
        public ThaiBuddhistCalendar();
        public override CalendarAlgorithmType AlgorithmType { get; }
        public override int[] Eras { get; }
        public override DateTime MaxSupportedDateTime { get; }
        public override DateTime MinSupportedDateTime { get; }
        public override int TwoDigitYearMax { get; set; }
        public override DateTime AddMonths(DateTime time, int months);
        public override DateTime AddYears(DateTime time, int years);
        public override int GetDayOfMonth(DateTime time);
        public override DayOfWeek GetDayOfWeek(DateTime time);
        public override int GetDayOfYear(DateTime time);
        public override int GetDaysInMonth(int year, int month, int era);
        public override int GetDaysInYear(int year, int era);
        public override int GetEra(DateTime time);
        public override int GetLeapMonth(int year, int era);
        public override int GetMonth(DateTime time);
        public override int GetMonthsInYear(int year, int era);
        public override int GetWeekOfYear(DateTime time, CalendarWeekRule rule, DayOfWeek firstDayOfWeek);
        public override int GetYear(DateTime time);
        public override bool IsLeapDay(int year, int month, int day, int era);
        public override bool IsLeapMonth(int year, int month, int era);
        public override bool IsLeapYear(int year, int era);
        public override DateTime ToDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int era);
        public override int ToFourDigitYear(int year);
    }
    public enum TimeSpanStyles {
        AssumeNegative = 1,
        None = 0,
    }
    public class UmAlQuraCalendar : Calendar {
        public const int UmAlQuraEra = 1;
        public UmAlQuraCalendar();
        public override CalendarAlgorithmType AlgorithmType { get; }
        protected override int DaysInYearBeforeMinSupportedYear { get; }
        public override int[] Eras { get; }
        public override DateTime MaxSupportedDateTime { get; }
        public override DateTime MinSupportedDateTime { get; }
        public override int TwoDigitYearMax { get; set; }
        public override DateTime AddMonths(DateTime time, int months);
        public override DateTime AddYears(DateTime time, int years);
        public override int GetDayOfMonth(DateTime time);
        public override DayOfWeek GetDayOfWeek(DateTime time);
        public override int GetDayOfYear(DateTime time);
        public override int GetDaysInMonth(int year, int month, int era);
        public override int GetDaysInYear(int year, int era);
        public override int GetEra(DateTime time);
        public override int GetLeapMonth(int year, int era);
        public override int GetMonth(DateTime time);
        public override int GetMonthsInYear(int year, int era);
        public override int GetYear(DateTime time);
        public override bool IsLeapDay(int year, int month, int day, int era);
        public override bool IsLeapMonth(int year, int month, int era);
        public override bool IsLeapYear(int year, int era);
        public override DateTime ToDateTime(int year, int month, int day, int hour, int minute, int second, int millisecond, int era);
        public override int ToFourDigitYear(int year);
    }
    public enum UnicodeCategory {
        ClosePunctuation = 21,
        ConnectorPunctuation = 18,
        Control = 14,
        CurrencySymbol = 26,
        DashPunctuation = 19,
        DecimalDigitNumber = 8,
        EnclosingMark = 7,
        FinalQuotePunctuation = 23,
        Format = 15,
        InitialQuotePunctuation = 22,
        LetterNumber = 9,
        LineSeparator = 12,
        LowercaseLetter = 1,
        MathSymbol = 25,
        ModifierLetter = 3,
        ModifierSymbol = 27,
        NonSpacingMark = 5,
        OpenPunctuation = 20,
        OtherLetter = 4,
        OtherNotAssigned = 29,
        OtherNumber = 10,
        OtherPunctuation = 24,
        OtherSymbol = 28,
        ParagraphSeparator = 13,
        PrivateUse = 17,
        SpaceSeparator = 11,
        SpacingCombiningMark = 6,
        Surrogate = 16,
        TitlecaseLetter = 2,
        UppercaseLetter = 0,
    }
}
namespace System.IO {
    public class BinaryReader : IDisposable {
        public BinaryReader(Stream input);
        public BinaryReader(Stream input, Encoding encoding);
        public BinaryReader(Stream input, Encoding encoding, bool leaveOpen);
        public virtual Stream BaseStream { get; }
        public virtual void Close();
        public void Dispose();
        protected virtual void Dispose(bool disposing);
        protected virtual void FillBuffer(int numBytes);
        public virtual int PeekChar();
        public virtual int Read();
        public virtual int Read(byte[] buffer, int index, int count);
        public virtual int Read(char[] buffer, int index, int count);
        protected internal int Read7BitEncodedInt();
        public virtual bool ReadBoolean();
        public virtual byte ReadByte();
        public virtual byte[] ReadBytes(int count);
        public virtual char ReadChar();
        public virtual char[] ReadChars(int count);
        public virtual decimal ReadDecimal();
        public virtual double ReadDouble();
        public virtual short ReadInt16();
        public virtual int ReadInt32();
        public virtual long ReadInt64();
        public virtual sbyte ReadSByte();
        public virtual float ReadSingle();
        public virtual string ReadString();
        public virtual ushort ReadUInt16();
        public virtual uint ReadUInt32();
        public virtual ulong ReadUInt64();
    }
    public class BinaryWriter : IDisposable {
        public static readonly BinaryWriter Null;
        protected Stream OutStream;
        protected BinaryWriter();
        public BinaryWriter(Stream output);
        public BinaryWriter(Stream output, Encoding encoding);
        public BinaryWriter(Stream output, Encoding encoding, bool leaveOpen);
        public virtual Stream BaseStream { get; }
        public virtual void Close();
        public void Dispose();
        protected virtual void Dispose(bool disposing);
        public virtual void Flush();
        public virtual long Seek(int offset, SeekOrigin origin);
        public virtual void Write(bool value);
        public virtual void Write(byte value);
        public virtual void Write(byte[] buffer);
        public virtual void Write(byte[] buffer, int index, int count);
        public virtual void Write(char ch);
        public virtual void Write(char[] chars);
        public virtual void Write(char[] chars, int index, int count);
        public virtual void Write(decimal value);
        public virtual void Write(double value);
        public virtual void Write(short value);
        public virtual void Write(int value);
        public virtual void Write(long value);
        public virtual void Write(sbyte value);
        public virtual void Write(float value);
        public virtual void Write(string value);
        public virtual void Write(ushort value);
        public virtual void Write(uint value);
        public virtual void Write(ulong value);
        protected void Write7BitEncodedInt(int value);
    }
    public sealed class BufferedStream : Stream {
        public BufferedStream(Stream stream);
        public BufferedStream(Stream stream, int bufferSize);
        public override bool CanRead { get; }
        public override bool CanSeek { get; }
        public override bool CanWrite { get; }
        public override long Length { get; }
        public override long Position { get; set; }
        public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
        protected override void Dispose(bool disposing);
        public override int EndRead(IAsyncResult asyncResult);
        public override void EndWrite(IAsyncResult asyncResult);
        public override void Flush();
        public override Task FlushAsync(CancellationToken cancellationToken);
        public override int Read(byte[] array, int offset, int count);
        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
        public override int ReadByte();
        public override long Seek(long offset, SeekOrigin origin);
        public override void SetLength(long value);
        public override void Write(byte[] array, int offset, int count);
        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
        public override void WriteByte(byte value);
    }
    public static class Directory {
        public static DirectoryInfo CreateDirectory(string path);
        public static void Delete(string path);
        public static void Delete(string path, bool recursive);
        public static IEnumerable<string> EnumerateDirectories(string path);
        public static IEnumerable<string> EnumerateDirectories(string path, string searchPattern);
        public static IEnumerable<string> EnumerateDirectories(string path, string searchPattern, SearchOption searchOption);
        public static IEnumerable<string> EnumerateFiles(string path);
        public static IEnumerable<string> EnumerateFiles(string path, string searchPattern);
        public static IEnumerable<string> EnumerateFiles(string path, string searchPattern, SearchOption searchOption);
        public static IEnumerable<string> EnumerateFileSystemEntries(string path);
        public static IEnumerable<string> EnumerateFileSystemEntries(string path, string searchPattern);
        public static IEnumerable<string> EnumerateFileSystemEntries(string path, string searchPattern, SearchOption searchOption);
        public static bool Exists(string path);
        public static DateTime GetCreationTime(string path);
        public static DateTime GetCreationTimeUtc(string path);
        public static string GetCurrentDirectory();
        public static string[] GetDirectories(string path);
        public static string[] GetDirectories(string path, string searchPattern);
        public static string[] GetDirectories(string path, string searchPattern, SearchOption searchOption);
        public static string GetDirectoryRoot(string path);
        public static string[] GetFiles(string path);
        public static string[] GetFiles(string path, string searchPattern);
        public static string[] GetFiles(string path, string searchPattern, SearchOption searchOption);
        public static string[] GetFileSystemEntries(string path);
        public static string[] GetFileSystemEntries(string path, string searchPattern);
        public static string[] GetFileSystemEntries(string path, string searchPattern, SearchOption searchOption);
        public static DateTime GetLastAccessTime(string path);
        public static DateTime GetLastAccessTimeUtc(string path);
        public static DateTime GetLastWriteTime(string path);
        public static DateTime GetLastWriteTimeUtc(string path);
        public static string[] GetLogicalDrives();
        public static DirectoryInfo GetParent(string path);
        public static void Move(string sourceDirName, string destDirName);
        public static void SetCreationTime(string path, DateTime creationTime);
        public static void SetCreationTimeUtc(string path, DateTime creationTimeUtc);
        public static void SetCurrentDirectory(string path);
        public static void SetLastAccessTime(string path, DateTime lastAccessTime);
        public static void SetLastAccessTimeUtc(string path, DateTime lastAccessTimeUtc);
        public static void SetLastWriteTime(string path, DateTime lastWriteTime);
        public static void SetLastWriteTimeUtc(string path, DateTime lastWriteTimeUtc);
    }
    public sealed class DirectoryInfo : FileSystemInfo {
        public DirectoryInfo(string path);
        public override bool Exists { get; }
        public override string Name { get; }
        public DirectoryInfo Parent { get; }
        public DirectoryInfo Root { get; }
        public void Create();
        public DirectoryInfo CreateSubdirectory(string path);
        public override void Delete();
        public void Delete(bool recursive);
        public IEnumerable<DirectoryInfo> EnumerateDirectories();
        public IEnumerable<DirectoryInfo> EnumerateDirectories(string searchPattern);
        public IEnumerable<DirectoryInfo> EnumerateDirectories(string searchPattern, SearchOption searchOption);
        public IEnumerable<FileInfo> EnumerateFiles();
        public IEnumerable<FileInfo> EnumerateFiles(string searchPattern);
        public IEnumerable<FileInfo> EnumerateFiles(string searchPattern, SearchOption searchOption);
        public IEnumerable<FileSystemInfo> EnumerateFileSystemInfos();
        public IEnumerable<FileSystemInfo> EnumerateFileSystemInfos(string searchPattern);
        public IEnumerable<FileSystemInfo> EnumerateFileSystemInfos(string searchPattern, SearchOption searchOption);
        public DirectoryInfo[] GetDirectories();
        public DirectoryInfo[] GetDirectories(string searchPattern);
        public DirectoryInfo[] GetDirectories(string searchPattern, SearchOption searchOption);
        public FileInfo[] GetFiles();
        public FileInfo[] GetFiles(string searchPattern);
        public FileInfo[] GetFiles(string searchPattern, SearchOption searchOption);
        public FileSystemInfo[] GetFileSystemInfos();
        public FileSystemInfo[] GetFileSystemInfos(string searchPattern);
        public FileSystemInfo[] GetFileSystemInfos(string searchPattern, SearchOption searchOption);
        public void MoveTo(string destDirName);
        public override string ToString();
    }
    public class DirectoryNotFoundException : IOException {
        public DirectoryNotFoundException();
        protected DirectoryNotFoundException(SerializationInfo info, StreamingContext context);
        public DirectoryNotFoundException(string message);
        public DirectoryNotFoundException(string message, Exception innerException);
    }
    public sealed class DriveInfo : ISerializable {
        public DriveInfo(string driveName);
        public long AvailableFreeSpace { get; }
        public string DriveFormat { get; }
        public DriveType DriveType { get; }
        public bool IsReady { get; }
        public string Name { get; }
        public DirectoryInfo RootDirectory { get; }
        public long TotalFreeSpace { get; }
        public long TotalSize { get; }
        public string VolumeLabel { get; set; }
        public static DriveInfo[] GetDrives();
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo info, StreamingContext context);
        public override string ToString();
    }
    public class DriveNotFoundException : IOException {
        public DriveNotFoundException();
        protected DriveNotFoundException(SerializationInfo info, StreamingContext context);
        public DriveNotFoundException(string message);
        public DriveNotFoundException(string message, Exception innerException);
    }
    public enum DriveType {
        CDRom = 5,
        Fixed = 3,
        Network = 4,
        NoRootDirectory = 1,
        Ram = 6,
        Removable = 2,
        Unknown = 0,
    }
    public class EndOfStreamException : IOException {
        public EndOfStreamException();
        protected EndOfStreamException(SerializationInfo info, StreamingContext context);
        public EndOfStreamException(string message);
        public EndOfStreamException(string message, Exception innerException);
    }
    public class ErrorEventArgs : EventArgs {
        public ErrorEventArgs(Exception exception);
        public virtual Exception GetException();
    }
    public delegate void ErrorEventHandler(object sender, ErrorEventArgs e);
    public static class File {
        public static void AppendAllLines(string path, IEnumerable<string> contents);
        public static void AppendAllLines(string path, IEnumerable<string> contents, Encoding encoding);
        public static void AppendAllText(string path, string contents);
        public static void AppendAllText(string path, string contents, Encoding encoding);
        public static StreamWriter AppendText(string path);
        public static void Copy(string sourceFileName, string destFileName);
        public static void Copy(string sourceFileName, string destFileName, bool overwrite);
        public static FileStream Create(string path);
        public static FileStream Create(string path, int bufferSize);
        public static FileStream Create(string path, int bufferSize, FileOptions options);
        public static StreamWriter CreateText(string path);
        public static void Decrypt(string path);
        public static void Delete(string path);
        public static void Encrypt(string path);
        public static bool Exists(string path);
        public static FileAttributes GetAttributes(string path);
        public static DateTime GetCreationTime(string path);
        public static DateTime GetCreationTimeUtc(string path);
        public static DateTime GetLastAccessTime(string path);
        public static DateTime GetLastAccessTimeUtc(string path);
        public static DateTime GetLastWriteTime(string path);
        public static DateTime GetLastWriteTimeUtc(string path);
        public static void Move(string sourceFileName, string destFileName);
        public static FileStream Open(string path, FileMode mode);
        public static FileStream Open(string path, FileMode mode, FileAccess access);
        public static FileStream Open(string path, FileMode mode, FileAccess access, FileShare share);
        public static FileStream OpenRead(string path);
        public static StreamReader OpenText(string path);
        public static FileStream OpenWrite(string path);
        public static byte[] ReadAllBytes(string path);
        public static string[] ReadAllLines(string path);
        public static string[] ReadAllLines(string path, Encoding encoding);
        public static string ReadAllText(string path);
        public static string ReadAllText(string path, Encoding encoding);
        public static IEnumerable<string> ReadLines(string path);
        public static IEnumerable<string> ReadLines(string path, Encoding encoding);
        public static void Replace(string sourceFileName, string destinationFileName, string destinationBackupFileName);
        public static void Replace(string sourceFileName, string destinationFileName, string destinationBackupFileName, bool ignoreMetadataErrors);
        public static void SetAttributes(string path, FileAttributes fileAttributes);
        public static void SetCreationTime(string path, DateTime creationTime);
        public static void SetCreationTimeUtc(string path, DateTime creationTimeUtc);
        public static void SetLastAccessTime(string path, DateTime lastAccessTime);
        public static void SetLastAccessTimeUtc(string path, DateTime lastAccessTimeUtc);
        public static void SetLastWriteTime(string path, DateTime lastWriteTime);
        public static void SetLastWriteTimeUtc(string path, DateTime lastWriteTimeUtc);
        public static void WriteAllBytes(string path, byte[] bytes);
        public static void WriteAllLines(string path, IEnumerable<string> contents);
        public static void WriteAllLines(string path, IEnumerable<string> contents, Encoding encoding);
        public static void WriteAllLines(string path, string[] contents);
        public static void WriteAllLines(string path, string[] contents, Encoding encoding);
        public static void WriteAllText(string path, string contents);
        public static void WriteAllText(string path, string contents, Encoding encoding);
    }
    public enum FileAccess {
        Read = 1,
        ReadWrite = 3,
        Write = 2,
    }
    public enum FileAttributes {
        Archive = 32,
        Compressed = 2048,
        Device = 64,
        Directory = 16,
        Encrypted = 16384,
        Hidden = 2,
        IntegrityStream = 32768,
        Normal = 128,
        NoScrubData = 131072,
        NotContentIndexed = 8192,
        Offline = 4096,
        ReadOnly = 1,
        ReparsePoint = 1024,
        SparseFile = 512,
        System = 4,
        Temporary = 256,
    }
    public sealed class FileInfo : FileSystemInfo {
        public FileInfo(string fileName);
        public DirectoryInfo Directory { get; }
        public string DirectoryName { get; }
        public override bool Exists { get; }
        public bool IsReadOnly { get; set; }
        public long Length { get; }
        public override string Name { get; }
        public StreamWriter AppendText();
        public FileInfo CopyTo(string destFileName);
        public FileInfo CopyTo(string destFileName, bool overwrite);
        public FileStream Create();
        public StreamWriter CreateText();
        public void Decrypt();
        public override void Delete();
        public void Encrypt();
        public void MoveTo(string destFileName);
        public FileStream Open(FileMode mode);
        public FileStream Open(FileMode mode, FileAccess access);
        public FileStream Open(FileMode mode, FileAccess access, FileShare share);
        public FileStream OpenRead();
        public StreamReader OpenText();
        public FileStream OpenWrite();
        public FileInfo Replace(string destinationFileName, string destinationBackupFileName);
        public FileInfo Replace(string destinationFileName, string destinationBackupFileName, bool ignoreMetadataErrors);
        public override string ToString();
    }
    public class FileLoadException : IOException {
        public FileLoadException();
        protected FileLoadException(SerializationInfo info, StreamingContext context);
        public FileLoadException(string message);
        public FileLoadException(string message, Exception inner);
        public FileLoadException(string message, string fileName);
        public FileLoadException(string message, string fileName, Exception inner);
        public string FileName { get; }
        public string FusionLog { get; }
        public override string Message { get; }
        public override void GetObjectData(SerializationInfo info, StreamingContext context);
        public override string ToString();
    }
    public enum FileMode {
        Append = 6,
        Create = 2,
        CreateNew = 1,
        Open = 3,
        OpenOrCreate = 4,
        Truncate = 5,
    }
    public class FileNotFoundException : IOException {
        public FileNotFoundException();
        protected FileNotFoundException(SerializationInfo info, StreamingContext context);
        public FileNotFoundException(string message);
        public FileNotFoundException(string message, Exception innerException);
        public FileNotFoundException(string message, string fileName);
        public FileNotFoundException(string message, string fileName, Exception innerException);
        public string FileName { get; }
        public string FusionLog { get; }
        public override string Message { get; }
        public override void GetObjectData(SerializationInfo info, StreamingContext context);
        public override string ToString();
    }
    public enum FileOptions {
        Asynchronous = 1073741824,
        DeleteOnClose = 67108864,
        Encrypted = 16384,
        None = 0,
        RandomAccess = 268435456,
        SequentialScan = 134217728,
        WriteThrough = -2147483648,
    }
    public enum FileShare {
        Delete = 4,
        Inheritable = 16,
        None = 0,
        Read = 1,
        ReadWrite = 3,
        Write = 2,
    }
    public class FileStream : Stream {
        public FileStream(SafeFileHandle handle, FileAccess access);
        public FileStream(SafeFileHandle handle, FileAccess access, int bufferSize);
        public FileStream(SafeFileHandle handle, FileAccess access, int bufferSize, bool isAsync);
        public FileStream(IntPtr handle, FileAccess access);
        public FileStream(IntPtr handle, FileAccess access, bool ownsHandle);
        public FileStream(IntPtr handle, FileAccess access, bool ownsHandle, int bufferSize);
        public FileStream(IntPtr handle, FileAccess access, bool ownsHandle, int bufferSize, bool isAsync);
        public FileStream(string path, FileMode mode);
        public FileStream(string path, FileMode mode, FileAccess access);
        public FileStream(string path, FileMode mode, FileAccess access, FileShare share);
        public FileStream(string path, FileMode mode, FileAccess access, FileShare share, int bufferSize);
        public FileStream(string path, FileMode mode, FileAccess access, FileShare share, int bufferSize, bool useAsync);
        public FileStream(string path, FileMode mode, FileAccess access, FileShare share, int bufferSize, FileOptions options);
        public override bool CanRead { get; }
        public override bool CanSeek { get; }
        public override bool CanWrite { get; }
        public virtual IntPtr Handle { get; }
        public virtual bool IsAsync { get; }
        public override long Length { get; }
        public string Name { get; }
        public override long Position { get; set; }
        public virtual SafeFileHandle SafeFileHandle { get; }
        public override IAsyncResult BeginRead(byte[] array, int offset, int numBytes, AsyncCallback userCallback, object stateObject);
        public override IAsyncResult BeginWrite(byte[] array, int offset, int numBytes, AsyncCallback userCallback, object stateObject);
        protected override void Dispose(bool disposing);
        public override int EndRead(IAsyncResult asyncResult);
        public override void EndWrite(IAsyncResult asyncResult);
        ~FileStream();
        public override void Flush();
        public virtual void Flush(bool flushToDisk);
        public override Task FlushAsync(CancellationToken cancellationToken);
        public virtual void Lock(long position, long length);
        public override int Read(byte[] array, int offset, int count);
        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
        public override int ReadByte();
        public override long Seek(long offset, SeekOrigin origin);
        public override void SetLength(long value);
        public virtual void Unlock(long position, long length);
        public override void Write(byte[] array, int offset, int count);
        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
        public override void WriteByte(byte value);
    }
    public class FileSystemEventArgs : EventArgs {
        public FileSystemEventArgs(WatcherChangeTypes changeType, string directory, string name);
        public WatcherChangeTypes ChangeType { get; }
        public string FullPath { get; }
        public string Name { get; }
    }
    public delegate void FileSystemEventHandler(object sender, FileSystemEventArgs e);
    public abstract class FileSystemInfo : MarshalByRefObject, ISerializable {
        protected string FullPath;
        protected string OriginalPath;
        protected FileSystemInfo();
        protected FileSystemInfo(SerializationInfo info, StreamingContext context);
        public FileAttributes Attributes { get; set; }
        public DateTime CreationTime { get; set; }
        public DateTime CreationTimeUtc { get; set; }
        public abstract bool Exists { get; }
        public string Extension { get; }
        public virtual string FullName { get; }
        public DateTime LastAccessTime { get; set; }
        public DateTime LastAccessTimeUtc { get; set; }
        public DateTime LastWriteTime { get; set; }
        public DateTime LastWriteTimeUtc { get; set; }
        public abstract string Name { get; }
        public abstract void Delete();
        public virtual void GetObjectData(SerializationInfo info, StreamingContext context);
        public void Refresh();
    }
    public class FileSystemWatcher : Component, ISupportInitialize {
        public FileSystemWatcher();
        public FileSystemWatcher(string path);
        public FileSystemWatcher(string path, string filter);
        public bool EnableRaisingEvents { get; set; }
        public string Filter { get; set; }
        public bool IncludeSubdirectories { get; set; }
        public int InternalBufferSize { get; set; }
        public NotifyFilters NotifyFilter { get; set; }
        public string Path { get; set; }
        public override ISite Site { get; set; }
        public ISynchronizeInvoke SynchronizingObject { get; set; }
        public event FileSystemEventHandler Changed;
        public event FileSystemEventHandler Created;
        public event FileSystemEventHandler Deleted;
        public event ErrorEventHandler Error;
        public event RenamedEventHandler Renamed;
        public void BeginInit();
        protected override void Dispose(bool disposing);
        public void EndInit();
        protected void OnChanged(FileSystemEventArgs e);
        protected void OnCreated(FileSystemEventArgs e);
        protected void OnDeleted(FileSystemEventArgs e);
        protected void OnError(ErrorEventArgs e);
        protected void OnRenamed(RenamedEventArgs e);
        public WaitForChangedResult WaitForChanged(WatcherChangeTypes changeType);
        public WaitForChangedResult WaitForChanged(WatcherChangeTypes changeType, int timeout);
    }
    public enum HandleInheritability {
        Inheritable = 1,
        None = 0,
    }
    public class InternalBufferOverflowException : SystemException {
        public InternalBufferOverflowException();
        protected InternalBufferOverflowException(SerializationInfo info, StreamingContext context);
        public InternalBufferOverflowException(string message);
        public InternalBufferOverflowException(string message, Exception inner);
    }
    public sealed class InvalidDataException : SystemException {
        public InvalidDataException();
        public InvalidDataException(string message);
        public InvalidDataException(string message, Exception innerException);
    }
    public class IOException : SystemException {
        public IOException();
        protected IOException(SerializationInfo info, StreamingContext context);
        public IOException(string message);
        public IOException(string message, Exception innerException);
        public IOException(string message, int hresult);
    }
    public class MemoryStream : Stream {
        public MemoryStream();
        public MemoryStream(byte[] buffer);
        public MemoryStream(byte[] buffer, bool writable);
        public MemoryStream(byte[] buffer, int index, int count);
        public MemoryStream(byte[] buffer, int index, int count, bool writable);
        public MemoryStream(byte[] buffer, int index, int count, bool writable, bool publiclyVisible);
        public MemoryStream(int capacity);
        public override bool CanRead { get; }
        public override bool CanSeek { get; }
        public override bool CanWrite { get; }
        public virtual int Capacity { get; set; }
        public override long Length { get; }
        public override long Position { get; set; }
        public override Task CopyToAsync(Stream destination, int bufferSize, CancellationToken cancellationToken);
        protected override void Dispose(bool disposing);
        public override void Flush();
        public override Task FlushAsync(CancellationToken cancellationToken);
        public virtual byte[] GetBuffer();
        public override int Read(byte[] buffer, int offset, int count);
        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
        public override int ReadByte();
        public override long Seek(long offset, SeekOrigin loc);
        public override void SetLength(long value);
        public virtual byte[] ToArray();
        public virtual bool TryGetBuffer(out ArraySegment<byte> buffer);
        public override void Write(byte[] buffer, int offset, int count);
        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
        public override void WriteByte(byte value);
        public virtual void WriteTo(Stream stream);
    }
    public enum NotifyFilters {
        Attributes = 4,
        CreationTime = 64,
        DirectoryName = 2,
        FileName = 1,
        LastAccess = 32,
        LastWrite = 16,
        Security = 256,
        Size = 8,
    }
    public static class Path {
        public static readonly char AltDirectorySeparatorChar;
        public static readonly char DirectorySeparatorChar;
        public static readonly char PathSeparator;
        public static readonly char VolumeSeparatorChar;
        public static readonly char[] InvalidPathChars;
        public static string ChangeExtension(string path, string extension);
        public static string Combine(string path1, string path2);
        public static string Combine(string path1, string path2, string path3);
        public static string Combine(string path1, string path2, string path3, string path4);
        public static string Combine(params string[] paths);
        public static string GetDirectoryName(string path);
        public static string GetExtension(string path);
        public static string GetFileName(string path);
        public static string GetFileNameWithoutExtension(string path);
        public static string GetFullPath(string path);
        public static char[] GetInvalidFileNameChars();
        public static char[] GetInvalidPathChars();
        public static string GetPathRoot(string path);
        public static string GetRandomFileName();
        public static string GetTempFileName();
        public static string GetTempPath();
        public static bool HasExtension(string path);
        public static bool IsPathRooted(string path);
    }
    public class PathTooLongException : IOException {
        public PathTooLongException();
        protected PathTooLongException(SerializationInfo info, StreamingContext context);
        public PathTooLongException(string message);
        public PathTooLongException(string message, Exception innerException);
    }
    public class RenamedEventArgs : FileSystemEventArgs {
        public RenamedEventArgs(WatcherChangeTypes changeType, string directory, string name, string oldName);
        public string OldFullPath { get; }
        public string OldName { get; }
    }
    public delegate void RenamedEventHandler(object sender, RenamedEventArgs e);
    public enum SearchOption {
        AllDirectories = 1,
        TopDirectoryOnly = 0,
    }
    public enum SeekOrigin {
        Begin = 0,
        Current = 1,
        End = 2,
    }
    public abstract class Stream : MarshalByRefObject, IDisposable {
        public static readonly Stream Null;
        protected Stream();
        public abstract bool CanRead { get; }
        public abstract bool CanSeek { get; }
        public virtual bool CanTimeout { get; }
        public abstract bool CanWrite { get; }
        public abstract long Length { get; }
        public abstract long Position { get; set; }
        public virtual int ReadTimeout { get; set; }
        public virtual int WriteTimeout { get; set; }
        public virtual IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
        public virtual IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
        public virtual void Close();
        public void CopyTo(Stream destination);
        public void CopyTo(Stream destination, int bufferSize);
        public Task CopyToAsync(Stream destination);
        public Task CopyToAsync(Stream destination, int bufferSize);
        public virtual Task CopyToAsync(Stream destination, int bufferSize, CancellationToken cancellationToken);
        protected virtual WaitHandle CreateWaitHandle();
        public void Dispose();
        protected virtual void Dispose(bool disposing);
        public virtual int EndRead(IAsyncResult asyncResult);
        public virtual void EndWrite(IAsyncResult asyncResult);
        public abstract void Flush();
        public Task FlushAsync();
        public virtual Task FlushAsync(CancellationToken cancellationToken);
        protected virtual void ObjectInvariant();
        public abstract int Read(byte[] buffer, int offset, int count);
        public Task<int> ReadAsync(byte[] buffer, int offset, int count);
        public virtual Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
        public virtual int ReadByte();
        public abstract long Seek(long offset, SeekOrigin origin);
        public abstract void SetLength(long value);
        public static Stream Synchronized(Stream stream);
        public abstract void Write(byte[] buffer, int offset, int count);
        public Task WriteAsync(byte[] buffer, int offset, int count);
        public virtual Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
        public virtual void WriteByte(byte value);
    }
    public class StreamReader : TextReader {
        public static readonly new StreamReader Null;
        public StreamReader(Stream stream);
        public StreamReader(Stream stream, bool detectEncodingFromByteOrderMarks);
        public StreamReader(Stream stream, Encoding encoding);
        public StreamReader(Stream stream, Encoding encoding, bool detectEncodingFromByteOrderMarks);
        public StreamReader(Stream stream, Encoding encoding, bool detectEncodingFromByteOrderMarks, int bufferSize);
        public StreamReader(Stream stream, Encoding encoding, bool detectEncodingFromByteOrderMarks, int bufferSize, bool leaveOpen);
        public StreamReader(string path);
        public StreamReader(string path, bool detectEncodingFromByteOrderMarks);
        public StreamReader(string path, Encoding encoding);
        public StreamReader(string path, Encoding encoding, bool detectEncodingFromByteOrderMarks);
        public StreamReader(string path, Encoding encoding, bool detectEncodingFromByteOrderMarks, int bufferSize);
        public virtual Stream BaseStream { get; }
        public virtual Encoding CurrentEncoding { get; }
        public bool EndOfStream { get; }
        public override void Close();
        public void DiscardBufferedData();
        protected override void Dispose(bool disposing);
        public override int Peek();
        public override int Read();
        public override int Read(char[] buffer, int index, int count);
        public override Task<int> ReadAsync(char[] buffer, int index, int count);
        public override int ReadBlock(char[] buffer, int index, int count);
        public override Task<int> ReadBlockAsync(char[] buffer, int index, int count);
        public override string ReadLine();
        public override Task<string> ReadLineAsync();
        public override string ReadToEnd();
        public override Task<string> ReadToEndAsync();
    }
    public class StreamWriter : TextWriter {
        public static readonly new StreamWriter Null;
        public StreamWriter(Stream stream);
        public StreamWriter(Stream stream, Encoding encoding);
        public StreamWriter(Stream stream, Encoding encoding, int bufferSize);
        public StreamWriter(Stream stream, Encoding encoding, int bufferSize, bool leaveOpen);
        public StreamWriter(string path);
        public StreamWriter(string path, bool append);
        public StreamWriter(string path, bool append, Encoding encoding);
        public StreamWriter(string path, bool append, Encoding encoding, int bufferSize);
        public virtual bool AutoFlush { get; set; }
        public virtual Stream BaseStream { get; }
        public override Encoding Encoding { get; }
        public override void Close();
        protected override void Dispose(bool disposing);
        public override void Flush();
        public override Task FlushAsync();
        public override void Write(char value);
        public override void Write(char[] buffer);
        public override void Write(char[] buffer, int index, int count);
        public override void Write(string value);
        public override Task WriteAsync(char value);
        public override Task WriteAsync(char[] buffer, int index, int count);
        public override Task WriteAsync(string value);
        public override Task WriteLineAsync();
        public override Task WriteLineAsync(char value);
        public override Task WriteLineAsync(char[] buffer, int index, int count);
        public override Task WriteLineAsync(string value);
    }
    public class StringReader : TextReader {
        public StringReader(string s);
        public override void Close();
        protected override void Dispose(bool disposing);
        public override int Peek();
        public override int Read();
        public override int Read(char[] buffer, int index, int count);
        public override Task<int> ReadAsync(char[] buffer, int index, int count);
        public override Task<int> ReadBlockAsync(char[] buffer, int index, int count);
        public override string ReadLine();
        public override Task<string> ReadLineAsync();
        public override string ReadToEnd();
        public override Task<string> ReadToEndAsync();
    }
    public class StringWriter : TextWriter {
        public StringWriter();
        public StringWriter(IFormatProvider formatProvider);
        public StringWriter(StringBuilder sb);
        public StringWriter(StringBuilder sb, IFormatProvider formatProvider);
        public override Encoding Encoding { get; }
        public override void Close();
        protected override void Dispose(bool disposing);
        public override Task FlushAsync();
        public virtual StringBuilder GetStringBuilder();
        public override string ToString();
        public override void Write(char value);
        public override void Write(char[] buffer, int index, int count);
        public override void Write(string value);
        public override Task WriteAsync(char value);
        public override Task WriteAsync(char[] buffer, int index, int count);
        public override Task WriteAsync(string value);
        public override Task WriteLineAsync(char value);
        public override Task WriteLineAsync(char[] buffer, int index, int count);
        public override Task WriteLineAsync(string value);
    }
    public abstract class TextReader : MarshalByRefObject, IDisposable {
        public static readonly TextReader Null;
        protected TextReader();
        public virtual void Close();
        public void Dispose();
        protected virtual void Dispose(bool disposing);
        public virtual int Peek();
        public virtual int Read();
        public virtual int Read(char[] buffer, int index, int count);
        public virtual Task<int> ReadAsync(char[] buffer, int index, int count);
        public virtual int ReadBlock(char[] buffer, int index, int count);
        public virtual Task<int> ReadBlockAsync(char[] buffer, int index, int count);
        public virtual string ReadLine();
        public virtual Task<string> ReadLineAsync();
        public virtual string ReadToEnd();
        public virtual Task<string> ReadToEndAsync();
        public static TextReader Synchronized(TextReader reader);
    }
    public abstract class TextWriter : MarshalByRefObject, IDisposable {
        protected char[] CoreNewLine;
        public static readonly TextWriter Null;
        protected TextWriter();
        protected TextWriter(IFormatProvider formatProvider);
        public abstract Encoding Encoding { get; }
        public virtual IFormatProvider FormatProvider { get; }
        public virtual string NewLine { get; set; }
        public virtual void Close();
        public void Dispose();
        protected virtual void Dispose(bool disposing);
        public virtual void Flush();
        public virtual Task FlushAsync();
        public static TextWriter Synchronized(TextWriter writer);
        public virtual void Write(bool value);
        public virtual void Write(char value);
        public virtual void Write(char[] buffer);
        public virtual void Write(char[] buffer, int index, int count);
        public virtual void Write(decimal value);
        public virtual void Write(double value);
        public virtual void Write(int value);
        public virtual void Write(long value);
        public virtual void Write(object value);
        public virtual void Write(float value);
        public virtual void Write(string value);
        public virtual void Write(string format, object arg0);
        public virtual void Write(string format, object arg0, object arg1);
        public virtual void Write(string format, object arg0, object arg1, object arg2);
        public virtual void Write(string format, params object[] arg);
        public virtual void Write(uint value);
        public virtual void Write(ulong value);
        public virtual Task WriteAsync(char value);
        public Task WriteAsync(char[] buffer);
        public virtual Task WriteAsync(char[] buffer, int index, int count);
        public virtual Task WriteAsync(string value);
        public virtual void WriteLine();
        public virtual void WriteLine(bool value);
        public virtual void WriteLine(char value);
        public virtual void WriteLine(char[] buffer);
        public virtual void WriteLine(char[] buffer, int index, int count);
        public virtual void WriteLine(decimal value);
        public virtual void WriteLine(double value);
        public virtual void WriteLine(int value);
        public virtual void WriteLine(long value);
        public virtual void WriteLine(object value);
        public virtual void WriteLine(float value);
        public virtual void WriteLine(string value);
        public virtual void WriteLine(string format, object arg0);
        public virtual void WriteLine(string format, object arg0, object arg1);
        public virtual void WriteLine(string format, object arg0, object arg1, object arg2);
        public virtual void WriteLine(string format, params object[] arg);
        public virtual void WriteLine(uint value);
        public virtual void WriteLine(ulong value);
        public virtual Task WriteLineAsync();
        public virtual Task WriteLineAsync(char value);
        public Task WriteLineAsync(char[] buffer);
        public virtual Task WriteLineAsync(char[] buffer, int index, int count);
        public virtual Task WriteLineAsync(string value);
    }
    public class UnmanagedMemoryAccessor : IDisposable {
        protected UnmanagedMemoryAccessor();
        public UnmanagedMemoryAccessor(SafeBuffer buffer, long offset, long capacity);
        public UnmanagedMemoryAccessor(SafeBuffer buffer, long offset, long capacity, FileAccess access);
        public bool CanRead { get; }
        public bool CanWrite { get; }
        public long Capacity { get; }
        protected bool IsOpen { get; }
        public void Dispose();
        protected virtual void Dispose(bool disposing);
        protected void Initialize(SafeBuffer buffer, long offset, long capacity, FileAccess access);
        public void Read<T>(long position, out T structure) where T : struct;
        public int ReadArray<T>(long position, T[] array, int offset, int count) where T : struct;
        public bool ReadBoolean(long position);
        public byte ReadByte(long position);
        public char ReadChar(long position);
        public decimal ReadDecimal(long position);
        public double ReadDouble(long position);
        public short ReadInt16(long position);
        public int ReadInt32(long position);
        public long ReadInt64(long position);
        public sbyte ReadSByte(long position);
        public float ReadSingle(long position);
        public ushort ReadUInt16(long position);
        public uint ReadUInt32(long position);
        public ulong ReadUInt64(long position);
        public void Write(long position, bool value);
        public void Write(long position, byte value);
        public void Write(long position, char value);
        public void Write(long position, decimal value);
        public void Write(long position, double value);
        public void Write(long position, short value);
        public void Write(long position, int value);
        public void Write(long position, long value);
        public void Write(long position, sbyte value);
        public void Write(long position, float value);
        public void Write(long position, ushort value);
        public void Write(long position, uint value);
        public void Write(long position, ulong value);
        public void Write<T>(long position, ref T structure) where T : struct;
        public void WriteArray<T>(long position, T[] array, int offset, int count) where T : struct;
    }
    public class UnmanagedMemoryStream : Stream {
        protected UnmanagedMemoryStream();
        public unsafe UnmanagedMemoryStream(byte* pointer, long length);
        public unsafe UnmanagedMemoryStream(byte* pointer, long length, long capacity, FileAccess access);
        public UnmanagedMemoryStream(SafeBuffer buffer, long offset, long length);
        public UnmanagedMemoryStream(SafeBuffer buffer, long offset, long length, FileAccess access);
        public override bool CanRead { get; }
        public override bool CanSeek { get; }
        public override bool CanWrite { get; }
        public long Capacity { get; }
        public override long Length { get; }
        public override long Position { get; set; }
        public unsafe byte* PositionPointer { get; set; }
        protected override void Dispose(bool disposing);
        public override void Flush();
        public override Task FlushAsync(CancellationToken cancellationToken);
        protected unsafe void Initialize(byte* pointer, long length, long capacity, FileAccess access);
        protected void Initialize(SafeBuffer buffer, long offset, long length, FileAccess access);
        public override int Read(byte[] buffer, int offset, int count);
        public override Task<int> ReadAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
        public override int ReadByte();
        public override long Seek(long offset, SeekOrigin loc);
        public override void SetLength(long value);
        public override void Write(byte[] buffer, int offset, int count);
        public override Task WriteAsync(byte[] buffer, int offset, int count, CancellationToken cancellationToken);
        public override void WriteByte(byte value);
    }
    public struct WaitForChangedResult {
        public WatcherChangeTypes ChangeType { get; set; }
        public string Name { get; set; }
        public string OldName { get; set; }
        public bool TimedOut { get; set; }
    }
    public enum WatcherChangeTypes {
        All = 15,
        Changed = 4,
        Created = 1,
        Deleted = 2,
        Renamed = 8,
    }
}
namespace System.IO.Compression {
    public enum CompressionLevel {
        Fastest = 1,
        NoCompression = 2,
        Optimal = 0,
    }
    public enum CompressionMode {
        Compress = 1,
        Decompress = 0,
    }
    public class DeflateStream : Stream {
        public DeflateStream(Stream stream, CompressionLevel compressionLevel);
        public DeflateStream(Stream stream, CompressionLevel compressionLevel, bool leaveOpen);
        public DeflateStream(Stream stream, CompressionMode mode);
        public DeflateStream(Stream stream, CompressionMode mode, bool leaveOpen);
        public Stream BaseStream { get; }
        public override bool CanRead { get; }
        public override bool CanSeek { get; }
        public override bool CanWrite { get; }
        public override long Length { get; }
        public override long Position { get; set; }
        public override IAsyncResult BeginRead(byte[] array, int offset, int count, AsyncCallback asyncCallback, object asyncState);
        public override IAsyncResult BeginWrite(byte[] array, int offset, int count, AsyncCallback asyncCallback, object asyncState);
        protected override void Dispose(bool disposing);
        public override int EndRead(IAsyncResult asyncResult);
        public override void EndWrite(IAsyncResult asyncResult);
        public override void Flush();
        public override int Read(byte[] array, int offset, int count);
        public override long Seek(long offset, SeekOrigin origin);
        public override void SetLength(long value);
        public override void Write(byte[] array, int offset, int count);
    }
    public class GZipStream : Stream {
        public GZipStream(Stream stream, CompressionLevel compressionLevel);
        public GZipStream(Stream stream, CompressionLevel compressionLevel, bool leaveOpen);
        public GZipStream(Stream stream, CompressionMode mode);
        public GZipStream(Stream stream, CompressionMode mode, bool leaveOpen);
        public Stream BaseStream { get; }
        public override bool CanRead { get; }
        public override bool CanSeek { get; }
        public override bool CanWrite { get; }
        public override long Length { get; }
        public override long Position { get; set; }
        public override IAsyncResult BeginRead(byte[] array, int offset, int count, AsyncCallback asyncCallback, object asyncState);
        public override IAsyncResult BeginWrite(byte[] array, int offset, int count, AsyncCallback asyncCallback, object asyncState);
        protected override void Dispose(bool disposing);
        public override int EndRead(IAsyncResult asyncResult);
        public override void EndWrite(IAsyncResult asyncResult);
        public override void Flush();
        public override int Read(byte[] array, int offset, int count);
        public override long Seek(long offset, SeekOrigin origin);
        public override void SetLength(long value);
        public override void Write(byte[] array, int offset, int count);
    }
    public class ZipArchive : IDisposable {
        public ZipArchive(Stream stream);
        public ZipArchive(Stream stream, ZipArchiveMode mode);
        public ZipArchive(Stream stream, ZipArchiveMode mode, bool leaveOpen);
        public ZipArchive(Stream stream, ZipArchiveMode mode, bool leaveOpen, Encoding entryNameEncoding);
        public ReadOnlyCollection<ZipArchiveEntry> Entries { get; }
        public ZipArchiveMode Mode { get; }
        public ZipArchiveEntry CreateEntry(string entryName);
        public ZipArchiveEntry CreateEntry(string entryName, CompressionLevel compressionLevel);
        public void Dispose();
        protected virtual void Dispose(bool disposing);
        public ZipArchiveEntry GetEntry(string entryName);
    }
    public class ZipArchiveEntry {
        public ZipArchive Archive { get; }
        public long CompressedLength { get; }
        public string FullName { get; }
        public DateTimeOffset LastWriteTime { get; set; }
        public long Length { get; }
        public string Name { get; }
        public void Delete();
        public Stream Open();
        public override string ToString();
    }
    public enum ZipArchiveMode {
        Create = 1,
        Read = 0,
        Update = 2,
    }
    public static class ZipFile {
        public static void CreateFromDirectory(string sourceDirectoryName, string destinationArchiveFileName);
        public static void CreateFromDirectory(string sourceDirectoryName, string destinationArchiveFileName, CompressionLevel compressionLevel, bool includeBaseDirectory);
        public static void CreateFromDirectory(string sourceDirectoryName, string destinationArchiveFileName, CompressionLevel compressionLevel, bool includeBaseDirectory, Encoding entryNameEncoding);
        public static void ExtractToDirectory(string sourceArchiveFileName, string destinationDirectoryName);
        public static void ExtractToDirectory(string sourceArchiveFileName, string destinationDirectoryName, Encoding entryNameEncoding);
        public static ZipArchive Open(string archiveFileName, ZipArchiveMode mode);
        public static ZipArchive Open(string archiveFileName, ZipArchiveMode mode, Encoding entryNameEncoding);
        public static ZipArchive OpenRead(string archiveFileName);
    }
    public static class ZipFileExtensions {
        public static ZipArchiveEntry CreateEntryFromFile(this ZipArchive destination, string sourceFileName, string entryName);
        public static ZipArchiveEntry CreateEntryFromFile(this ZipArchive destination, string sourceFileName, string entryName, CompressionLevel compressionLevel);
        public static void ExtractToDirectory(this ZipArchive source, string destinationDirectoryName);
        public static void ExtractToFile(this ZipArchiveEntry source, string destinationFileName);
        public static void ExtractToFile(this ZipArchiveEntry source, string destinationFileName, bool overwrite);
    }
}
namespace System.IO.IsolatedStorage {
    public interface INormalizeForIsolatedStorage {
        object Normalize();
    }
    public abstract class IsolatedStorage : MarshalByRefObject {
        public object ApplicationIdentity { get; }
        public object AssemblyIdentity { get; }
        public virtual long AvailableFreeSpace { get; }
        public virtual ulong CurrentSize { get; }
        public object DomainIdentity { get; }
        public virtual ulong MaximumSize { get; }
        public virtual long Quota { get; }
        public IsolatedStorageScope Scope { get; }
        protected virtual char SeparatorExternal { get; }
        protected virtual char SeparatorInternal { get; }
        public virtual long UsedSize { get; }
        public virtual bool IncreaseQuotaTo(long newQuotaSize);
        protected void InitStore(IsolatedStorageScope scope, Type appEvidenceType);
        protected void InitStore(IsolatedStorageScope scope, Type domainEvidenceType, Type assemblyEvidenceType);
        public abstract void Remove();
    }
    public class IsolatedStorageException : Exception {
        public IsolatedStorageException();
        protected IsolatedStorageException(SerializationInfo info, StreamingContext context);
        public IsolatedStorageException(string message);
        public IsolatedStorageException(string message, Exception inner);
    }
    public sealed class IsolatedStorageFile : IsolatedStorage, IDisposable {
        public override long AvailableFreeSpace { get; }
        public override ulong CurrentSize { get; }
        public static bool IsEnabled { get; }
        public override ulong MaximumSize { get; }
        public override long Quota { get; }
        public override long UsedSize { get; }
        public void Close();
        public void CopyFile(string sourceFileName, string destinationFileName);
        public void CopyFile(string sourceFileName, string destinationFileName, bool overwrite);
        public void CreateDirectory(string dir);
        public IsolatedStorageFileStream CreateFile(string path);
        public void DeleteDirectory(string dir);
        public void DeleteFile(string file);
        public bool DirectoryExists(string path);
        public void Dispose();
        public bool FileExists(string path);
        public DateTimeOffset GetCreationTime(string path);
        public string[] GetDirectoryNames();
        public string[] GetDirectoryNames(string searchPattern);
        public static IEnumerator GetEnumerator(IsolatedStorageScope scope);
        public string[] GetFileNames();
        public string[] GetFileNames(string searchPattern);
        public DateTimeOffset GetLastAccessTime(string path);
        public DateTimeOffset GetLastWriteTime(string path);
        public static IsolatedStorageFile GetMachineStoreForApplication();
        public static IsolatedStorageFile GetMachineStoreForAssembly();
        public static IsolatedStorageFile GetMachineStoreForDomain();
        public static IsolatedStorageFile GetStore(IsolatedStorageScope scope, object applicationIdentity);
        public static IsolatedStorageFile GetStore(IsolatedStorageScope scope, object domainIdentity, object assemblyIdentity);
        public static IsolatedStorageFile GetStore(IsolatedStorageScope scope, Type applicationEvidenceType);
        public static IsolatedStorageFile GetStore(IsolatedStorageScope scope, Type domainEvidenceType, Type assemblyEvidenceType);
        public static IsolatedStorageFile GetUserStoreForApplication();
        public static IsolatedStorageFile GetUserStoreForAssembly();
        public static IsolatedStorageFile GetUserStoreForDomain();
        public static IsolatedStorageFile GetUserStoreForSite();
        public override bool IncreaseQuotaTo(long newQuotaSize);
        public void MoveDirectory(string sourceDirectoryName, string destinationDirectoryName);
        public void MoveFile(string sourceFileName, string destinationFileName);
        public IsolatedStorageFileStream OpenFile(string path, FileMode mode);
        public IsolatedStorageFileStream OpenFile(string path, FileMode mode, FileAccess access);
        public IsolatedStorageFileStream OpenFile(string path, FileMode mode, FileAccess access, FileShare share);
        public override void Remove();
        public static void Remove(IsolatedStorageScope scope);
    }
    public class IsolatedStorageFileStream : FileStream {
        public IsolatedStorageFileStream(string path, FileMode mode);
        public IsolatedStorageFileStream(string path, FileMode mode, FileAccess access);
        public IsolatedStorageFileStream(string path, FileMode mode, FileAccess access, FileShare share);
        public IsolatedStorageFileStream(string path, FileMode mode, FileAccess access, FileShare share, int bufferSize);
        public IsolatedStorageFileStream(string path, FileMode mode, FileAccess access, FileShare share, int bufferSize, IsolatedStorageFile isf);
        public IsolatedStorageFileStream(string path, FileMode mode, FileAccess access, FileShare share, IsolatedStorageFile isf);
        public IsolatedStorageFileStream(string path, FileMode mode, FileAccess access, IsolatedStorageFile isf);
        public IsolatedStorageFileStream(string path, FileMode mode, IsolatedStorageFile isf);
        public override bool CanRead { get; }
        public override bool CanSeek { get; }
        public override bool CanWrite { get; }
        public override IntPtr Handle { get; }
        public override bool IsAsync { get; }
        public override long Length { get; }
        public override long Position { get; set; }
        public override SafeFileHandle SafeFileHandle { get; }
        public override IAsyncResult BeginRead(byte[] buffer, int offset, int numBytes, AsyncCallback userCallback, object stateObject);
        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int numBytes, AsyncCallback userCallback, object stateObject);
        protected override void Dispose(bool disposing);
        public override int EndRead(IAsyncResult asyncResult);
        public override void EndWrite(IAsyncResult asyncResult);
        public override void Flush();
        public override void Flush(bool flushToDisk);
        public override void Lock(long position, long length);
        public override int Read(byte[] buffer, int offset, int count);
        public override int ReadByte();
        public override long Seek(long offset, SeekOrigin origin);
        public override void SetLength(long value);
        public override void Unlock(long position, long length);
        public override void Write(byte[] buffer, int offset, int count);
        public override void WriteByte(byte value);
    }
    public enum IsolatedStorageScope {
        Application = 32,
        Assembly = 4,
        Domain = 2,
        Machine = 16,
        None = 0,
        Roaming = 8,
        User = 1,
    }
}
namespace System.IO.MemoryMappedFiles {
    public class MemoryMappedFile : IDisposable {
        public SafeMemoryMappedFileHandle SafeMemoryMappedFileHandle { get; }
        public static MemoryMappedFile CreateFromFile(FileStream fileStream, string mapName, long capacity, MemoryMappedFileAccess access, HandleInheritability inheritability, bool leaveOpen);
        public static MemoryMappedFile CreateFromFile(string path);
        public static MemoryMappedFile CreateFromFile(string path, FileMode mode);
        public static MemoryMappedFile CreateFromFile(string path, FileMode mode, string mapName);
        public static MemoryMappedFile CreateFromFile(string path, FileMode mode, string mapName, long capacity);
        public static MemoryMappedFile CreateFromFile(string path, FileMode mode, string mapName, long capacity, MemoryMappedFileAccess access);
        public static MemoryMappedFile CreateNew(string mapName, long capacity);
        public static MemoryMappedFile CreateNew(string mapName, long capacity, MemoryMappedFileAccess access);
        public static MemoryMappedFile CreateNew(string mapName, long capacity, MemoryMappedFileAccess access, MemoryMappedFileOptions options, HandleInheritability inheritability);
        public static MemoryMappedFile CreateOrOpen(string mapName, long capacity);
        public static MemoryMappedFile CreateOrOpen(string mapName, long capacity, MemoryMappedFileAccess access);
        public static MemoryMappedFile CreateOrOpen(string mapName, long capacity, MemoryMappedFileAccess access, MemoryMappedFileOptions options, HandleInheritability inheritability);
        public MemoryMappedViewAccessor CreateViewAccessor();
        public MemoryMappedViewAccessor CreateViewAccessor(long offset, long size);
        public MemoryMappedViewAccessor CreateViewAccessor(long offset, long size, MemoryMappedFileAccess access);
        public MemoryMappedViewStream CreateViewStream();
        public MemoryMappedViewStream CreateViewStream(long offset, long size);
        public MemoryMappedViewStream CreateViewStream(long offset, long size, MemoryMappedFileAccess access);
        public void Dispose();
        protected virtual void Dispose(bool disposing);
        public static MemoryMappedFile OpenExisting(string mapName);
        public static MemoryMappedFile OpenExisting(string mapName, MemoryMappedFileRights desiredAccessRights);
        public static MemoryMappedFile OpenExisting(string mapName, MemoryMappedFileRights desiredAccessRights, HandleInheritability inheritability);
    }
    public enum MemoryMappedFileAccess {
        CopyOnWrite = 3,
        Read = 1,
        ReadExecute = 4,
        ReadWrite = 0,
        ReadWriteExecute = 5,
        Write = 2,
    }
    public enum MemoryMappedFileOptions {
        DelayAllocatePages = 67108864,
        None = 0,
    }
    public enum MemoryMappedFileRights {
        AccessSystemSecurity = 16777216,
        ChangePermissions = 262144,
        CopyOnWrite = 1,
        Delete = 65536,
        Execute = 8,
        FullControl = 983055,
        Read = 4,
        ReadExecute = 12,
        ReadPermissions = 131072,
        ReadWrite = 6,
        ReadWriteExecute = 14,
        TakeOwnership = 524288,
        Write = 2,
    }
    public sealed class MemoryMappedViewAccessor : UnmanagedMemoryAccessor {
        public long PointerOffset { get; }
        public SafeMemoryMappedViewHandle SafeMemoryMappedViewHandle { get; }
        protected override void Dispose(bool disposing);
        public void Flush();
    }
    public sealed class MemoryMappedViewStream : UnmanagedMemoryStream {
        public long PointerOffset { get; }
        public SafeMemoryMappedViewHandle SafeMemoryMappedViewHandle { get; }
        protected override void Dispose(bool disposing);
        public override void Flush();
        public override void SetLength(long value);
    }
}
namespace System.IO.Pipes {
    public sealed class AnonymousPipeClientStream : PipeStream {
        public AnonymousPipeClientStream(PipeDirection direction, SafePipeHandle safePipeHandle);
        public AnonymousPipeClientStream(PipeDirection direction, string pipeHandleAsString);
        public AnonymousPipeClientStream(string pipeHandleAsString);
        public override PipeTransmissionMode ReadMode { set; }
        public override PipeTransmissionMode TransmissionMode { get; }
    }
    public sealed class AnonymousPipeServerStream : PipeStream {
        public AnonymousPipeServerStream();
        public AnonymousPipeServerStream(PipeDirection direction);
        public AnonymousPipeServerStream(PipeDirection direction, SafePipeHandle serverSafePipeHandle, SafePipeHandle clientSafePipeHandle);
        public AnonymousPipeServerStream(PipeDirection direction, HandleInheritability inheritability);
        public AnonymousPipeServerStream(PipeDirection direction, HandleInheritability inheritability, int bufferSize);
        public SafePipeHandle ClientSafePipeHandle { get; }
        public override PipeTransmissionMode ReadMode { set; }
        public override PipeTransmissionMode TransmissionMode { get; }
        protected override void Dispose(bool disposing);
        public void DisposeLocalCopyOfClientHandle();
        public string GetClientHandleAsString();
    }
    public sealed class NamedPipeClientStream : PipeStream {
        public NamedPipeClientStream(PipeDirection direction, bool isAsync, bool isConnected, SafePipeHandle safePipeHandle);
        public NamedPipeClientStream(string pipeName);
        public NamedPipeClientStream(string serverName, string pipeName);
        public NamedPipeClientStream(string serverName, string pipeName, PipeDirection direction);
        public NamedPipeClientStream(string serverName, string pipeName, PipeDirection direction, PipeOptions options);
        public NamedPipeClientStream(string serverName, string pipeName, PipeDirection direction, PipeOptions options, TokenImpersonationLevel impersonationLevel);
        public NamedPipeClientStream(string serverName, string pipeName, PipeDirection direction, PipeOptions options, TokenImpersonationLevel impersonationLevel, HandleInheritability inheritability);
        public int NumberOfServerInstances { get; }
        protected internal override void CheckPipePropertyOperations();
        public void Connect();
        public void Connect(int timeout);
        public Task ConnectAsync();
        public Task ConnectAsync(int timeout);
        public Task ConnectAsync(int timeout, CancellationToken cancellationToken);
        public Task ConnectAsync(CancellationToken cancellationToken);
    }
    public sealed class NamedPipeServerStream : PipeStream {
        public const int MaxAllowedServerInstances = -1;
        public NamedPipeServerStream(PipeDirection direction, bool isAsync, bool isConnected, SafePipeHandle safePipeHandle);
        public NamedPipeServerStream(string pipeName);
        public NamedPipeServerStream(string pipeName, PipeDirection direction);
        public NamedPipeServerStream(string pipeName, PipeDirection direction, int maxNumberOfServerInstances);
        public NamedPipeServerStream(string pipeName, PipeDirection direction, int maxNumberOfServerInstances, PipeTransmissionMode transmissionMode);
        public NamedPipeServerStream(string pipeName, PipeDirection direction, int maxNumberOfServerInstances, PipeTransmissionMode transmissionMode, PipeOptions options);
        public NamedPipeServerStream(string pipeName, PipeDirection direction, int maxNumberOfServerInstances, PipeTransmissionMode transmissionMode, PipeOptions options, int inBufferSize, int outBufferSize);
        public IAsyncResult BeginWaitForConnection(AsyncCallback callback, object state);
        public void Disconnect();
        public void EndWaitForConnection(IAsyncResult asyncResult);
        public string GetImpersonationUserName();
        public void RunAsClient(PipeStreamImpersonationWorker impersonationWorker);
        public void WaitForConnection();
        public Task WaitForConnectionAsync();
        public Task WaitForConnectionAsync(CancellationToken cancellationToken);
    }
    public enum PipeDirection {
        In = 1,
        InOut = 3,
        Out = 2,
    }
    public enum PipeOptions {
        Asynchronous = 1073741824,
        None = 0,
        WriteThrough = -2147483648,
    }
    public abstract class PipeStream : Stream {
        protected PipeStream(PipeDirection direction, int bufferSize);
        protected PipeStream(PipeDirection direction, PipeTransmissionMode transmissionMode, int outBufferSize);
        public override bool CanRead { get; }
        public override bool CanSeek { get; }
        public override bool CanWrite { get; }
        public virtual int InBufferSize { get; }
        public bool IsAsync { get; }
        public bool IsConnected { get; protected set; }
        protected bool IsHandleExposed { get; }
        public bool IsMessageComplete { get; }
        public override long Length { get; }
        public virtual int OutBufferSize { get; }
        public override long Position { get; set; }
        public virtual PipeTransmissionMode ReadMode { get; set; }
        public SafePipeHandle SafePipeHandle { get; }
        public virtual PipeTransmissionMode TransmissionMode { get; }
        public override IAsyncResult BeginRead(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
        public override IAsyncResult BeginWrite(byte[] buffer, int offset, int count, AsyncCallback callback, object state);
        protected internal virtual void CheckPipePropertyOperations();
        protected internal void CheckReadOperations();
        protected internal void CheckWriteOperations();
        protected override void Dispose(bool disposing);
        public override int EndRead(IAsyncResult asyncResult);
        public override void EndWrite(IAsyncResult asyncResult);
        public override void Flush();
        protected void InitializeHandle(SafePipeHandle handle, bool isExposed, bool isAsync);
        public override int Read(byte[] buffer, int offset, int count);
        public override int ReadByte();
        public override long Seek(long offset, SeekOrigin origin);
        public override void SetLength(long value);
        public void WaitForPipeDrain();
        public override void Write(byte[] buffer, int offset, int count);
        public override void WriteByte(byte value);
    }
    public delegate void PipeStreamImpersonationWorker();
    public enum PipeTransmissionMode {
        Byte = 0,
        Message = 1,
    }
}
namespace System.Linq {
    public static class Enumerable {
        public static TResult Aggregate<TSource, TAccumulate, TResult>(this IEnumerable<TSource> source, TAccumulate seed, Func<TAccumulate, TSource, TAccumulate> func, Func<TAccumulate, TResult> resultSelector);
        public static TAccumulate Aggregate<TSource, TAccumulate>(this IEnumerable<TSource> source, TAccumulate seed, Func<TAccumulate, TSource, TAccumulate> func);
        public static TSource Aggregate<TSource>(this IEnumerable<TSource> source, Func<TSource, TSource, TSource> func);
        public static bool All<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
        public static bool Any<TSource>(this IEnumerable<TSource> source);
        public static bool Any<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
        public static IEnumerable<TSource> Append<TSource>(this IEnumerable<TSource> source, TSource element);
        public static IEnumerable<TSource> AsEnumerable<TSource>(this IEnumerable<TSource> source);
        public static decimal Average(this IEnumerable<decimal> source);
        public static double Average(this IEnumerable<double> source);
        public static double Average(this IEnumerable<int> source);
        public static double Average(this IEnumerable<long> source);
        public static Nullable<decimal> Average(this IEnumerable<Nullable<decimal>> source);
        public static Nullable<double> Average(this IEnumerable<Nullable<double>> source);
        public static Nullable<double> Average(this IEnumerable<Nullable<int>> source);
        public static Nullable<double> Average(this IEnumerable<Nullable<long>> source);
        public static Nullable<float> Average(this IEnumerable<Nullable<float>> source);
        public static float Average(this IEnumerable<float> source);
        public static decimal Average<TSource>(this IEnumerable<TSource> source, Func<TSource, decimal> selector);
        public static double Average<TSource>(this IEnumerable<TSource> source, Func<TSource, double> selector);
        public static double Average<TSource>(this IEnumerable<TSource> source, Func<TSource, int> selector);
        public static double Average<TSource>(this IEnumerable<TSource> source, Func<TSource, long> selector);
        public static Nullable<decimal> Average<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<decimal>> selector);
        public static Nullable<double> Average<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<double>> selector);
        public static Nullable<double> Average<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<int>> selector);
        public static Nullable<double> Average<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<long>> selector);
        public static Nullable<float> Average<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<float>> selector);
        public static float Average<TSource>(this IEnumerable<TSource> source, Func<TSource, float> selector);
        public static IEnumerable<TResult> Cast<TResult>(this IEnumerable source);
        public static IEnumerable<TSource> Concat<TSource>(this IEnumerable<TSource> first, IEnumerable<TSource> second);
        public static bool Contains<TSource>(this IEnumerable<TSource> source, TSource value);
        public static bool Contains<TSource>(this IEnumerable<TSource> source, TSource value, IEqualityComparer<TSource> comparer);
        public static int Count<TSource>(this IEnumerable<TSource> source);
        public static int Count<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
        public static IEnumerable<TSource> DefaultIfEmpty<TSource>(this IEnumerable<TSource> source);
        public static IEnumerable<TSource> DefaultIfEmpty<TSource>(this IEnumerable<TSource> source, TSource defaultValue);
        public static IEnumerable<TSource> Distinct<TSource>(this IEnumerable<TSource> source);
        public static IEnumerable<TSource> Distinct<TSource>(this IEnumerable<TSource> source, IEqualityComparer<TSource> comparer);
        public static TSource ElementAt<TSource>(this IEnumerable<TSource> source, int index);
        public static TSource ElementAtOrDefault<TSource>(this IEnumerable<TSource> source, int index);
        public static IEnumerable<TResult> Empty<TResult>();
        public static IEnumerable<TSource> Except<TSource>(this IEnumerable<TSource> first, IEnumerable<TSource> second);
        public static IEnumerable<TSource> Except<TSource>(this IEnumerable<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer);
        public static TSource First<TSource>(this IEnumerable<TSource> source);
        public static TSource First<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
        public static TSource FirstOrDefault<TSource>(this IEnumerable<TSource> source);
        public static TSource FirstOrDefault<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
        public static IEnumerable<TResult> GroupBy<TSource, TKey, TElement, TResult>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, Func<TKey, IEnumerable<TElement>, TResult> resultSelector);
        public static IEnumerable<TResult> GroupBy<TSource, TKey, TElement, TResult>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, Func<TKey, IEnumerable<TElement>, TResult> resultSelector, IEqualityComparer<TKey> comparer);
        public static IEnumerable<IGrouping<TKey, TElement>> GroupBy<TSource, TKey, TElement>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector);
        public static IEnumerable<IGrouping<TKey, TElement>> GroupBy<TSource, TKey, TElement>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, IEqualityComparer<TKey> comparer);
        public static IEnumerable<TResult> GroupBy<TSource, TKey, TResult>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TKey, IEnumerable<TSource>, TResult> resultSelector);
        public static IEnumerable<TResult> GroupBy<TSource, TKey, TResult>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TKey, IEnumerable<TSource>, TResult> resultSelector, IEqualityComparer<TKey> comparer);
        public static IEnumerable<IGrouping<TKey, TSource>> GroupBy<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector);
        public static IEnumerable<IGrouping<TKey, TSource>> GroupBy<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer);
        public static IEnumerable<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this IEnumerable<TOuter> outer, IEnumerable<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, IEnumerable<TInner>, TResult> resultSelector);
        public static IEnumerable<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this IEnumerable<TOuter> outer, IEnumerable<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, IEnumerable<TInner>, TResult> resultSelector, IEqualityComparer<TKey> comparer);
        public static IEnumerable<TSource> Intersect<TSource>(this IEnumerable<TSource> first, IEnumerable<TSource> second);
        public static IEnumerable<TSource> Intersect<TSource>(this IEnumerable<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer);
        public static IEnumerable<TResult> Join<TOuter, TInner, TKey, TResult>(this IEnumerable<TOuter> outer, IEnumerable<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, TInner, TResult> resultSelector);
        public static IEnumerable<TResult> Join<TOuter, TInner, TKey, TResult>(this IEnumerable<TOuter> outer, IEnumerable<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, TInner, TResult> resultSelector, IEqualityComparer<TKey> comparer);
        public static TSource Last<TSource>(this IEnumerable<TSource> source);
        public static TSource Last<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
        public static TSource LastOrDefault<TSource>(this IEnumerable<TSource> source);
        public static TSource LastOrDefault<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
        public static long LongCount<TSource>(this IEnumerable<TSource> source);
        public static long LongCount<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
        public static decimal Max(this IEnumerable<decimal> source);
        public static double Max(this IEnumerable<double> source);
        public static int Max(this IEnumerable<int> source);
        public static long Max(this IEnumerable<long> source);
        public static Nullable<decimal> Max(this IEnumerable<Nullable<decimal>> source);
        public static Nullable<double> Max(this IEnumerable<Nullable<double>> source);
        public static Nullable<int> Max(this IEnumerable<Nullable<int>> source);
        public static Nullable<long> Max(this IEnumerable<Nullable<long>> source);
        public static Nullable<float> Max(this IEnumerable<Nullable<float>> source);
        public static float Max(this IEnumerable<float> source);
        public static TResult Max<TSource, TResult>(this IEnumerable<TSource> source, Func<TSource, TResult> selector);
        public static TSource Max<TSource>(this IEnumerable<TSource> source);
        public static decimal Max<TSource>(this IEnumerable<TSource> source, Func<TSource, decimal> selector);
        public static double Max<TSource>(this IEnumerable<TSource> source, Func<TSource, double> selector);
        public static int Max<TSource>(this IEnumerable<TSource> source, Func<TSource, int> selector);
        public static long Max<TSource>(this IEnumerable<TSource> source, Func<TSource, long> selector);
        public static Nullable<decimal> Max<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<decimal>> selector);
        public static Nullable<double> Max<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<double>> selector);
        public static Nullable<int> Max<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<int>> selector);
        public static Nullable<long> Max<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<long>> selector);
        public static Nullable<float> Max<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<float>> selector);
        public static float Max<TSource>(this IEnumerable<TSource> source, Func<TSource, float> selector);
        public static decimal Min(this IEnumerable<decimal> source);
        public static double Min(this IEnumerable<double> source);
        public static int Min(this IEnumerable<int> source);
        public static long Min(this IEnumerable<long> source);
        public static Nullable<decimal> Min(this IEnumerable<Nullable<decimal>> source);
        public static Nullable<double> Min(this IEnumerable<Nullable<double>> source);
        public static Nullable<int> Min(this IEnumerable<Nullable<int>> source);
        public static Nullable<long> Min(this IEnumerable<Nullable<long>> source);
        public static Nullable<float> Min(this IEnumerable<Nullable<float>> source);
        public static float Min(this IEnumerable<float> source);
        public static TResult Min<TSource, TResult>(this IEnumerable<TSource> source, Func<TSource, TResult> selector);
        public static TSource Min<TSource>(this IEnumerable<TSource> source);
        public static decimal Min<TSource>(this IEnumerable<TSource> source, Func<TSource, decimal> selector);
        public static double Min<TSource>(this IEnumerable<TSource> source, Func<TSource, double> selector);
        public static int Min<TSource>(this IEnumerable<TSource> source, Func<TSource, int> selector);
        public static long Min<TSource>(this IEnumerable<TSource> source, Func<TSource, long> selector);
        public static Nullable<decimal> Min<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<decimal>> selector);
        public static Nullable<double> Min<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<double>> selector);
        public static Nullable<int> Min<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<int>> selector);
        public static Nullable<long> Min<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<long>> selector);
        public static Nullable<float> Min<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<float>> selector);
        public static float Min<TSource>(this IEnumerable<TSource> source, Func<TSource, float> selector);
        public static IEnumerable<TResult> OfType<TResult>(this IEnumerable source);
        public static IOrderedEnumerable<TSource> OrderBy<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector);
        public static IOrderedEnumerable<TSource> OrderBy<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
        public static IOrderedEnumerable<TSource> OrderByDescending<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector);
        public static IOrderedEnumerable<TSource> OrderByDescending<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
        public static IEnumerable<TSource> Prepend<TSource>(this IEnumerable<TSource> source, TSource element);
        public static IEnumerable<int> Range(int start, int count);
        public static IEnumerable<TResult> Repeat<TResult>(TResult element, int count);
        public static IEnumerable<TSource> Reverse<TSource>(this IEnumerable<TSource> source);
        public static IEnumerable<TResult> Select<TSource, TResult>(this IEnumerable<TSource> source, Func<TSource, int, TResult> selector);
        public static IEnumerable<TResult> Select<TSource, TResult>(this IEnumerable<TSource> source, Func<TSource, TResult> selector);
        public static IEnumerable<TResult> SelectMany<TSource, TCollection, TResult>(this IEnumerable<TSource> source, Func<TSource, IEnumerable<TCollection>> collectionSelector, Func<TSource, TCollection, TResult> resultSelector);
        public static IEnumerable<TResult> SelectMany<TSource, TCollection, TResult>(this IEnumerable<TSource> source, Func<TSource, int, IEnumerable<TCollection>> collectionSelector, Func<TSource, TCollection, TResult> resultSelector);
        public static IEnumerable<TResult> SelectMany<TSource, TResult>(this IEnumerable<TSource> source, Func<TSource, IEnumerable<TResult>> selector);
        public static IEnumerable<TResult> SelectMany<TSource, TResult>(this IEnumerable<TSource> source, Func<TSource, int, IEnumerable<TResult>> selector);
        public static bool SequenceEqual<TSource>(this IEnumerable<TSource> first, IEnumerable<TSource> second);
        public static bool SequenceEqual<TSource>(this IEnumerable<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer);
        public static TSource Single<TSource>(this IEnumerable<TSource> source);
        public static TSource Single<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
        public static TSource SingleOrDefault<TSource>(this IEnumerable<TSource> source);
        public static TSource SingleOrDefault<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
        public static IEnumerable<TSource> Skip<TSource>(this IEnumerable<TSource> source, int count);
        public static IEnumerable<TSource> SkipWhile<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
        public static IEnumerable<TSource> SkipWhile<TSource>(this IEnumerable<TSource> source, Func<TSource, int, bool> predicate);
        public static decimal Sum(this IEnumerable<decimal> source);
        public static double Sum(this IEnumerable<double> source);
        public static int Sum(this IEnumerable<int> source);
        public static long Sum(this IEnumerable<long> source);
        public static Nullable<decimal> Sum(this IEnumerable<Nullable<decimal>> source);
        public static Nullable<double> Sum(this IEnumerable<Nullable<double>> source);
        public static Nullable<int> Sum(this IEnumerable<Nullable<int>> source);
        public static Nullable<long> Sum(this IEnumerable<Nullable<long>> source);
        public static Nullable<float> Sum(this IEnumerable<Nullable<float>> source);
        public static float Sum(this IEnumerable<float> source);
        public static decimal Sum<TSource>(this IEnumerable<TSource> source, Func<TSource, decimal> selector);
        public static double Sum<TSource>(this IEnumerable<TSource> source, Func<TSource, double> selector);
        public static int Sum<TSource>(this IEnumerable<TSource> source, Func<TSource, int> selector);
        public static long Sum<TSource>(this IEnumerable<TSource> source, Func<TSource, long> selector);
        public static Nullable<decimal> Sum<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<decimal>> selector);
        public static Nullable<double> Sum<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<double>> selector);
        public static Nullable<int> Sum<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<int>> selector);
        public static Nullable<long> Sum<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<long>> selector);
        public static Nullable<float> Sum<TSource>(this IEnumerable<TSource> source, Func<TSource, Nullable<float>> selector);
        public static float Sum<TSource>(this IEnumerable<TSource> source, Func<TSource, float> selector);
        public static IEnumerable<TSource> Take<TSource>(this IEnumerable<TSource> source, int count);
        public static IEnumerable<TSource> TakeWhile<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
        public static IEnumerable<TSource> TakeWhile<TSource>(this IEnumerable<TSource> source, Func<TSource, int, bool> predicate);
        public static IOrderedEnumerable<TSource> ThenBy<TSource, TKey>(this IOrderedEnumerable<TSource> source, Func<TSource, TKey> keySelector);
        public static IOrderedEnumerable<TSource> ThenBy<TSource, TKey>(this IOrderedEnumerable<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
        public static IOrderedEnumerable<TSource> ThenByDescending<TSource, TKey>(this IOrderedEnumerable<TSource> source, Func<TSource, TKey> keySelector);
        public static IOrderedEnumerable<TSource> ThenByDescending<TSource, TKey>(this IOrderedEnumerable<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
        public static TSource[] ToArray<TSource>(this IEnumerable<TSource> source);
        public static Dictionary<TKey, TElement> ToDictionary<TSource, TKey, TElement>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector);
        public static Dictionary<TKey, TElement> ToDictionary<TSource, TKey, TElement>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, IEqualityComparer<TKey> comparer);
        public static Dictionary<TKey, TSource> ToDictionary<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector);
        public static Dictionary<TKey, TSource> ToDictionary<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer);
        public static List<TSource> ToList<TSource>(this IEnumerable<TSource> source);
        public static ILookup<TKey, TElement> ToLookup<TSource, TKey, TElement>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector);
        public static ILookup<TKey, TElement> ToLookup<TSource, TKey, TElement>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, IEqualityComparer<TKey> comparer);
        public static ILookup<TKey, TSource> ToLookup<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector);
        public static ILookup<TKey, TSource> ToLookup<TSource, TKey>(this IEnumerable<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer);
        public static IEnumerable<TSource> Union<TSource>(this IEnumerable<TSource> first, IEnumerable<TSource> second);
        public static IEnumerable<TSource> Union<TSource>(this IEnumerable<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer);
        public static IEnumerable<TSource> Where<TSource>(this IEnumerable<TSource> source, Func<TSource, bool> predicate);
        public static IEnumerable<TSource> Where<TSource>(this IEnumerable<TSource> source, Func<TSource, int, bool> predicate);
        public static IEnumerable<TResult> Zip<TFirst, TSecond, TResult>(this IEnumerable<TFirst> first, IEnumerable<TSecond> second, Func<TFirst, TSecond, TResult> resultSelector);
    }
    public abstract class EnumerableExecutor {
        protected EnumerableExecutor();
    }
    public class EnumerableExecutor<T> : EnumerableExecutor {
        public EnumerableExecutor(Expression expression);
    }
    public abstract class EnumerableQuery {
        protected EnumerableQuery();
    }
    public class EnumerableQuery<T> : EnumerableQuery, IEnumerable, IEnumerable<T>, IOrderedQueryable, IOrderedQueryable<T>, IQueryable, IQueryable<T>, IQueryProvider {
        public EnumerableQuery(IEnumerable<T> enumerable);
        public EnumerableQuery(Expression expression);
        Type System.Linq.IQueryable.ElementType { get; }
        Expression System.Linq.IQueryable.Expression { get; }
        IQueryProvider System.Linq.IQueryable.Provider { get; }
        IEnumerator<T> System.Collections.Generic.IEnumerable<T>.GetEnumerator();
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
        IQueryable System.Linq.IQueryProvider.CreateQuery(Expression expression);
        IQueryable<S> System.Linq.IQueryProvider.CreateQuery<S>(Expression expression);
        object System.Linq.IQueryProvider.Execute(Expression expression);
        S System.Linq.IQueryProvider.Execute<S>(Expression expression);
        public override string ToString();
    }
    public interface IGrouping<out TKey, out TElement> : IEnumerable, IEnumerable<TElement> {
        TKey Key { get; }
    }
    public interface ILookup<TKey, TElement> : IEnumerable, IEnumerable<IGrouping<TKey, TElement>> {
        int Count { get; }
        IEnumerable<TElement> this[TKey key] { get; }
        bool Contains(TKey key);
    }
    public interface IOrderedEnumerable<TElement> : IEnumerable, IEnumerable<TElement> {
        IOrderedEnumerable<TElement> CreateOrderedEnumerable<TKey>(Func<TElement, TKey> keySelector, IComparer<TKey> comparer, bool descending);
    }
    public interface IOrderedQueryable : IEnumerable, IQueryable {
    }
    public interface IOrderedQueryable<out T> : IEnumerable, IEnumerable<T>, IOrderedQueryable, IQueryable, IQueryable<T> {
    }
    public interface IQueryable : IEnumerable {
        Type ElementType { get; }
        Expression Expression { get; }
        IQueryProvider Provider { get; }
    }
    public interface IQueryable<out T> : IEnumerable, IEnumerable<T>, IQueryable {
    }
    public interface IQueryProvider {
        IQueryable CreateQuery(Expression expression);
        IQueryable<TElement> CreateQuery<TElement>(Expression expression);
        object Execute(Expression expression);
        TResult Execute<TResult>(Expression expression);
    }
    public class Lookup<TKey, TElement> : IEnumerable, IEnumerable<IGrouping<TKey, TElement>>, ILookup<TKey, TElement> {
        public int Count { get; }
        public IEnumerable<TElement> this[TKey key] { get; }
        public IEnumerable<TResult> ApplyResultSelector<TResult>(Func<TKey, IEnumerable<TElement>, TResult> resultSelector);
        public bool Contains(TKey key);
        public IEnumerator<IGrouping<TKey, TElement>> GetEnumerator();
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
    }
    public class OrderedParallelQuery<TSource> : ParallelQuery<TSource> {
        public override IEnumerator<TSource> GetEnumerator();
    }
    public static class ParallelEnumerable {
        public static TResult Aggregate<TSource, TAccumulate, TResult>(this ParallelQuery<TSource> source, Func<TAccumulate> seedFactory, Func<TAccumulate, TSource, TAccumulate> updateAccumulatorFunc, Func<TAccumulate, TAccumulate, TAccumulate> combineAccumulatorsFunc, Func<TAccumulate, TResult> resultSelector);
        public static TResult Aggregate<TSource, TAccumulate, TResult>(this ParallelQuery<TSource> source, TAccumulate seed, Func<TAccumulate, TSource, TAccumulate> updateAccumulatorFunc, Func<TAccumulate, TAccumulate, TAccumulate> combineAccumulatorsFunc, Func<TAccumulate, TResult> resultSelector);
        public static TResult Aggregate<TSource, TAccumulate, TResult>(this ParallelQuery<TSource> source, TAccumulate seed, Func<TAccumulate, TSource, TAccumulate> func, Func<TAccumulate, TResult> resultSelector);
        public static TAccumulate Aggregate<TSource, TAccumulate>(this ParallelQuery<TSource> source, TAccumulate seed, Func<TAccumulate, TSource, TAccumulate> func);
        public static TSource Aggregate<TSource>(this ParallelQuery<TSource> source, Func<TSource, TSource, TSource> func);
        public static bool All<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
        public static bool Any<TSource>(this ParallelQuery<TSource> source);
        public static bool Any<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
        public static IEnumerable<TSource> AsEnumerable<TSource>(this ParallelQuery<TSource> source);
        public static ParallelQuery AsOrdered(this ParallelQuery source);
        public static ParallelQuery<TSource> AsOrdered<TSource>(this ParallelQuery<TSource> source);
        public static ParallelQuery AsParallel(this IEnumerable source);
        public static ParallelQuery<TSource> AsParallel<TSource>(this Partitioner<TSource> source);
        public static ParallelQuery<TSource> AsParallel<TSource>(this IEnumerable<TSource> source);
        public static IEnumerable<TSource> AsSequential<TSource>(this ParallelQuery<TSource> source);
        public static ParallelQuery<TSource> AsUnordered<TSource>(this ParallelQuery<TSource> source);
        public static decimal Average(this ParallelQuery<decimal> source);
        public static double Average(this ParallelQuery<double> source);
        public static double Average(this ParallelQuery<int> source);
        public static double Average(this ParallelQuery<long> source);
        public static Nullable<decimal> Average(this ParallelQuery<Nullable<decimal>> source);
        public static Nullable<double> Average(this ParallelQuery<Nullable<double>> source);
        public static Nullable<double> Average(this ParallelQuery<Nullable<int>> source);
        public static Nullable<double> Average(this ParallelQuery<Nullable<long>> source);
        public static Nullable<float> Average(this ParallelQuery<Nullable<float>> source);
        public static float Average(this ParallelQuery<float> source);
        public static decimal Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, decimal> selector);
        public static double Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, double> selector);
        public static double Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, int> selector);
        public static double Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, long> selector);
        public static Nullable<decimal> Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<decimal>> selector);
        public static Nullable<double> Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<double>> selector);
        public static Nullable<double> Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<int>> selector);
        public static Nullable<double> Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<long>> selector);
        public static Nullable<float> Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<float>> selector);
        public static float Average<TSource>(this ParallelQuery<TSource> source, Func<TSource, float> selector);
        public static ParallelQuery<TResult> Cast<TResult>(this ParallelQuery source);
        public static ParallelQuery<TSource> Concat<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second);
        public static ParallelQuery<TSource> Concat<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second);
        public static bool Contains<TSource>(this ParallelQuery<TSource> source, TSource value);
        public static bool Contains<TSource>(this ParallelQuery<TSource> source, TSource value, IEqualityComparer<TSource> comparer);
        public static int Count<TSource>(this ParallelQuery<TSource> source);
        public static int Count<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
        public static ParallelQuery<TSource> DefaultIfEmpty<TSource>(this ParallelQuery<TSource> source);
        public static ParallelQuery<TSource> DefaultIfEmpty<TSource>(this ParallelQuery<TSource> source, TSource defaultValue);
        public static ParallelQuery<TSource> Distinct<TSource>(this ParallelQuery<TSource> source);
        public static ParallelQuery<TSource> Distinct<TSource>(this ParallelQuery<TSource> source, IEqualityComparer<TSource> comparer);
        public static TSource ElementAt<TSource>(this ParallelQuery<TSource> source, int index);
        public static TSource ElementAtOrDefault<TSource>(this ParallelQuery<TSource> source, int index);
        public static ParallelQuery<TResult> Empty<TResult>();
        public static ParallelQuery<TSource> Except<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second);
        public static ParallelQuery<TSource> Except<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer);
        public static ParallelQuery<TSource> Except<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second);
        public static ParallelQuery<TSource> Except<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second, IEqualityComparer<TSource> comparer);
        public static TSource First<TSource>(this ParallelQuery<TSource> source);
        public static TSource First<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
        public static TSource FirstOrDefault<TSource>(this ParallelQuery<TSource> source);
        public static TSource FirstOrDefault<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
        public static void ForAll<TSource>(this ParallelQuery<TSource> source, Action<TSource> action);
        public static ParallelQuery<TResult> GroupBy<TSource, TKey, TElement, TResult>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, Func<TKey, IEnumerable<TElement>, TResult> resultSelector);
        public static ParallelQuery<TResult> GroupBy<TSource, TKey, TElement, TResult>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, Func<TKey, IEnumerable<TElement>, TResult> resultSelector, IEqualityComparer<TKey> comparer);
        public static ParallelQuery<IGrouping<TKey, TElement>> GroupBy<TSource, TKey, TElement>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector);
        public static ParallelQuery<IGrouping<TKey, TElement>> GroupBy<TSource, TKey, TElement>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, IEqualityComparer<TKey> comparer);
        public static ParallelQuery<TResult> GroupBy<TSource, TKey, TResult>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TKey, IEnumerable<TSource>, TResult> resultSelector);
        public static ParallelQuery<TResult> GroupBy<TSource, TKey, TResult>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TKey, IEnumerable<TSource>, TResult> resultSelector, IEqualityComparer<TKey> comparer);
        public static ParallelQuery<IGrouping<TKey, TSource>> GroupBy<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector);
        public static ParallelQuery<IGrouping<TKey, TSource>> GroupBy<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer);
        public static ParallelQuery<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, IEnumerable<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, IEnumerable<TInner>, TResult> resultSelector);
        public static ParallelQuery<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, IEnumerable<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, IEnumerable<TInner>, TResult> resultSelector, IEqualityComparer<TKey> comparer);
        public static ParallelQuery<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, ParallelQuery<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, IEnumerable<TInner>, TResult> resultSelector);
        public static ParallelQuery<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, ParallelQuery<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, IEnumerable<TInner>, TResult> resultSelector, IEqualityComparer<TKey> comparer);
        public static ParallelQuery<TSource> Intersect<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second);
        public static ParallelQuery<TSource> Intersect<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer);
        public static ParallelQuery<TSource> Intersect<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second);
        public static ParallelQuery<TSource> Intersect<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second, IEqualityComparer<TSource> comparer);
        public static ParallelQuery<TResult> Join<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, IEnumerable<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, TInner, TResult> resultSelector);
        public static ParallelQuery<TResult> Join<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, IEnumerable<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, TInner, TResult> resultSelector, IEqualityComparer<TKey> comparer);
        public static ParallelQuery<TResult> Join<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, ParallelQuery<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, TInner, TResult> resultSelector);
        public static ParallelQuery<TResult> Join<TOuter, TInner, TKey, TResult>(this ParallelQuery<TOuter> outer, ParallelQuery<TInner> inner, Func<TOuter, TKey> outerKeySelector, Func<TInner, TKey> innerKeySelector, Func<TOuter, TInner, TResult> resultSelector, IEqualityComparer<TKey> comparer);
        public static TSource Last<TSource>(this ParallelQuery<TSource> source);
        public static TSource Last<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
        public static TSource LastOrDefault<TSource>(this ParallelQuery<TSource> source);
        public static TSource LastOrDefault<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
        public static long LongCount<TSource>(this ParallelQuery<TSource> source);
        public static long LongCount<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
        public static decimal Max(this ParallelQuery<decimal> source);
        public static double Max(this ParallelQuery<double> source);
        public static int Max(this ParallelQuery<int> source);
        public static long Max(this ParallelQuery<long> source);
        public static Nullable<decimal> Max(this ParallelQuery<Nullable<decimal>> source);
        public static Nullable<double> Max(this ParallelQuery<Nullable<double>> source);
        public static Nullable<int> Max(this ParallelQuery<Nullable<int>> source);
        public static Nullable<long> Max(this ParallelQuery<Nullable<long>> source);
        public static Nullable<float> Max(this ParallelQuery<Nullable<float>> source);
        public static float Max(this ParallelQuery<float> source);
        public static TResult Max<TSource, TResult>(this ParallelQuery<TSource> source, Func<TSource, TResult> selector);
        public static TSource Max<TSource>(this ParallelQuery<TSource> source);
        public static decimal Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, decimal> selector);
        public static double Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, double> selector);
        public static int Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, int> selector);
        public static long Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, long> selector);
        public static Nullable<decimal> Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<decimal>> selector);
        public static Nullable<double> Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<double>> selector);
        public static Nullable<int> Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<int>> selector);
        public static Nullable<long> Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<long>> selector);
        public static Nullable<float> Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<float>> selector);
        public static float Max<TSource>(this ParallelQuery<TSource> source, Func<TSource, float> selector);
        public static decimal Min(this ParallelQuery<decimal> source);
        public static double Min(this ParallelQuery<double> source);
        public static int Min(this ParallelQuery<int> source);
        public static long Min(this ParallelQuery<long> source);
        public static Nullable<decimal> Min(this ParallelQuery<Nullable<decimal>> source);
        public static Nullable<double> Min(this ParallelQuery<Nullable<double>> source);
        public static Nullable<int> Min(this ParallelQuery<Nullable<int>> source);
        public static Nullable<long> Min(this ParallelQuery<Nullable<long>> source);
        public static Nullable<float> Min(this ParallelQuery<Nullable<float>> source);
        public static float Min(this ParallelQuery<float> source);
        public static TResult Min<TSource, TResult>(this ParallelQuery<TSource> source, Func<TSource, TResult> selector);
        public static TSource Min<TSource>(this ParallelQuery<TSource> source);
        public static decimal Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, decimal> selector);
        public static double Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, double> selector);
        public static int Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, int> selector);
        public static long Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, long> selector);
        public static Nullable<decimal> Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<decimal>> selector);
        public static Nullable<double> Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<double>> selector);
        public static Nullable<int> Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<int>> selector);
        public static Nullable<long> Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<long>> selector);
        public static Nullable<float> Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<float>> selector);
        public static float Min<TSource>(this ParallelQuery<TSource> source, Func<TSource, float> selector);
        public static ParallelQuery<TResult> OfType<TResult>(this ParallelQuery source);
        public static OrderedParallelQuery<TSource> OrderBy<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector);
        public static OrderedParallelQuery<TSource> OrderBy<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
        public static OrderedParallelQuery<TSource> OrderByDescending<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector);
        public static OrderedParallelQuery<TSource> OrderByDescending<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
        public static ParallelQuery<int> Range(int start, int count);
        public static ParallelQuery<TResult> Repeat<TResult>(TResult element, int count);
        public static ParallelQuery<TSource> Reverse<TSource>(this ParallelQuery<TSource> source);
        public static ParallelQuery<TResult> Select<TSource, TResult>(this ParallelQuery<TSource> source, Func<TSource, int, TResult> selector);
        public static ParallelQuery<TResult> Select<TSource, TResult>(this ParallelQuery<TSource> source, Func<TSource, TResult> selector);
        public static ParallelQuery<TResult> SelectMany<TSource, TCollection, TResult>(this ParallelQuery<TSource> source, Func<TSource, IEnumerable<TCollection>> collectionSelector, Func<TSource, TCollection, TResult> resultSelector);
        public static ParallelQuery<TResult> SelectMany<TSource, TCollection, TResult>(this ParallelQuery<TSource> source, Func<TSource, int, IEnumerable<TCollection>> collectionSelector, Func<TSource, TCollection, TResult> resultSelector);
        public static ParallelQuery<TResult> SelectMany<TSource, TResult>(this ParallelQuery<TSource> source, Func<TSource, IEnumerable<TResult>> selector);
        public static ParallelQuery<TResult> SelectMany<TSource, TResult>(this ParallelQuery<TSource> source, Func<TSource, int, IEnumerable<TResult>> selector);
        public static bool SequenceEqual<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second);
        public static bool SequenceEqual<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer);
        public static bool SequenceEqual<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second);
        public static bool SequenceEqual<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second, IEqualityComparer<TSource> comparer);
        public static TSource Single<TSource>(this ParallelQuery<TSource> source);
        public static TSource Single<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
        public static TSource SingleOrDefault<TSource>(this ParallelQuery<TSource> source);
        public static TSource SingleOrDefault<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
        public static ParallelQuery<TSource> Skip<TSource>(this ParallelQuery<TSource> source, int count);
        public static ParallelQuery<TSource> SkipWhile<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
        public static ParallelQuery<TSource> SkipWhile<TSource>(this ParallelQuery<TSource> source, Func<TSource, int, bool> predicate);
        public static decimal Sum(this ParallelQuery<decimal> source);
        public static double Sum(this ParallelQuery<double> source);
        public static int Sum(this ParallelQuery<int> source);
        public static long Sum(this ParallelQuery<long> source);
        public static Nullable<decimal> Sum(this ParallelQuery<Nullable<decimal>> source);
        public static Nullable<double> Sum(this ParallelQuery<Nullable<double>> source);
        public static Nullable<int> Sum(this ParallelQuery<Nullable<int>> source);
        public static Nullable<long> Sum(this ParallelQuery<Nullable<long>> source);
        public static Nullable<float> Sum(this ParallelQuery<Nullable<float>> source);
        public static float Sum(this ParallelQuery<float> source);
        public static decimal Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, decimal> selector);
        public static double Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, double> selector);
        public static int Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, int> selector);
        public static long Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, long> selector);
        public static Nullable<decimal> Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<decimal>> selector);
        public static Nullable<double> Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<double>> selector);
        public static Nullable<int> Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<int>> selector);
        public static Nullable<long> Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<long>> selector);
        public static Nullable<float> Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, Nullable<float>> selector);
        public static float Sum<TSource>(this ParallelQuery<TSource> source, Func<TSource, float> selector);
        public static ParallelQuery<TSource> Take<TSource>(this ParallelQuery<TSource> source, int count);
        public static ParallelQuery<TSource> TakeWhile<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
        public static ParallelQuery<TSource> TakeWhile<TSource>(this ParallelQuery<TSource> source, Func<TSource, int, bool> predicate);
        public static OrderedParallelQuery<TSource> ThenBy<TSource, TKey>(this OrderedParallelQuery<TSource> source, Func<TSource, TKey> keySelector);
        public static OrderedParallelQuery<TSource> ThenBy<TSource, TKey>(this OrderedParallelQuery<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
        public static OrderedParallelQuery<TSource> ThenByDescending<TSource, TKey>(this OrderedParallelQuery<TSource> source, Func<TSource, TKey> keySelector);
        public static OrderedParallelQuery<TSource> ThenByDescending<TSource, TKey>(this OrderedParallelQuery<TSource> source, Func<TSource, TKey> keySelector, IComparer<TKey> comparer);
        public static TSource[] ToArray<TSource>(this ParallelQuery<TSource> source);
        public static Dictionary<TKey, TElement> ToDictionary<TSource, TKey, TElement>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector);
        public static Dictionary<TKey, TElement> ToDictionary<TSource, TKey, TElement>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, IEqualityComparer<TKey> comparer);
        public static Dictionary<TKey, TSource> ToDictionary<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector);
        public static Dictionary<TKey, TSource> ToDictionary<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer);
        public static List<TSource> ToList<TSource>(this ParallelQuery<TSource> source);
        public static ILookup<TKey, TElement> ToLookup<TSource, TKey, TElement>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector);
        public static ILookup<TKey, TElement> ToLookup<TSource, TKey, TElement>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, Func<TSource, TElement> elementSelector, IEqualityComparer<TKey> comparer);
        public static ILookup<TKey, TSource> ToLookup<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector);
        public static ILookup<TKey, TSource> ToLookup<TSource, TKey>(this ParallelQuery<TSource> source, Func<TSource, TKey> keySelector, IEqualityComparer<TKey> comparer);
        public static ParallelQuery<TSource> Union<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second);
        public static ParallelQuery<TSource> Union<TSource>(this ParallelQuery<TSource> first, IEnumerable<TSource> second, IEqualityComparer<TSource> comparer);
        public static ParallelQuery<TSource> Union<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second);
        public static ParallelQuery<TSource> Union<TSource>(this ParallelQuery<TSource> first, ParallelQuery<TSource> second, IEqualityComparer<TSource> comparer);
        public static ParallelQuery<TSource> Where<TSource>(this ParallelQuery<TSource> source, Func<TSource, bool> predicate);
        public static ParallelQuery<TSource> Where<TSource>(this ParallelQuery<TSource> source, Func<TSource, int, bool> predicate);
        public static ParallelQuery<TSource> WithCancellation<TSource>(this ParallelQuery<TSource> source, CancellationToken cancellationToken);
        public static ParallelQuery<TSource> WithDegreeOfParallelism<TSource>(this ParallelQuery<TSource> source, int degreeOfParallelism);
        public static ParallelQuery<TSource> WithExecutionMode<TSource>(this ParallelQuery<TSource> source, ParallelExecutionMode executionMode);
        public static ParallelQuery<TSource> WithMergeOptions<TSource>(this ParallelQuery<TSource> source, ParallelMergeOptions mergeOptions);
        public static ParallelQuery<TResult> Zip<TFirst, TSecond, TResult>(this ParallelQuery<TFirst> first, IEnumerable<TSecond> second, Func<TFirst, TSecond, TResult> resultSelector);
        public static ParallelQuery<TResult> Zip<TFirst, TSecond, TResult>(this ParallelQuery<TFirst> first, ParallelQuery<TSecond> second, Func<TFirst, TSecond, TResult> resultSelector);
    }
    public enum ParallelExecutionMode {
        Default = 0,
        ForceParallelism = 1,
    }
    public enum ParallelMergeOptions {
        AutoBuffered = 2,
        Default = 0,
        FullyBuffered = 3,
        NotBuffered = 1,
    }
    public class ParallelQuery : IEnumerable {
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
    }
    public class ParallelQuery<TSource> : ParallelQuery, IEnumerable, IEnumerable<TSource> {
        public virtual IEnumerator<TSource> GetEnumerator();
    }
    public static class Queryable {
        public static TResult Aggregate<TSource, TAccumulate, TResult>(this IQueryable<TSource> source, TAccumulate seed, Expression<Func<TAccumulate, TSource, TAccumulate>> func, Expression<Func<TAccumulate, TResult>> selector);
        public static TAccumulate Aggregate<TSource, TAccumulate>(this IQueryable<TSource> source, TAccumulate seed, Expression<Func<TAccumulate, TSource, TAccumulate>> func);
        public static TSource Aggregate<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, TSource, TSource>> func);
        public static bool All<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
        public static bool Any<TSource>(this IQueryable<TSource> source);
        public static bool Any<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
        public static IQueryable AsQueryable(this IEnumerable source);
        public static IQueryable<TElement> AsQueryable<TElement>(this IEnumerable<TElement> source);
        public static decimal Average(this IQueryable<decimal> source);
        public static double Average(this IQueryable<double> source);
        public static double Average(this IQueryable<int> source);
        public static double Average(this IQueryable<long> source);
        public static Nullable<decimal> Average(this IQueryable<Nullable<decimal>> source);
        public static Nullable<double> Average(this IQueryable<Nullable<double>> source);
        public static Nullable<double> Average(this IQueryable<Nullable<int>> source);
        public static Nullable<double> Average(this IQueryable<Nullable<long>> source);
        public static Nullable<float> Average(this IQueryable<Nullable<float>> source);
        public static float Average(this IQueryable<float> source);
        public static decimal Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, decimal>> selector);
        public static double Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, double>> selector);
        public static double Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, int>> selector);
        public static double Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, long>> selector);
        public static Nullable<decimal> Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<decimal>>> selector);
        public static Nullable<double> Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<double>>> selector);
        public static Nullable<double> Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<int>>> selector);
        public static Nullable<double> Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<long>>> selector);
        public static Nullable<float> Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<float>>> selector);
        public static float Average<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, float>> selector);
        public static IQueryable<TResult> Cast<TResult>(this IQueryable source);
        public static IQueryable<TSource> Concat<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2);
        public static bool Contains<TSource>(this IQueryable<TSource> source, TSource item);
        public static bool Contains<TSource>(this IQueryable<TSource> source, TSource item, IEqualityComparer<TSource> comparer);
        public static int Count<TSource>(this IQueryable<TSource> source);
        public static int Count<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
        public static IQueryable<TSource> DefaultIfEmpty<TSource>(this IQueryable<TSource> source);
        public static IQueryable<TSource> DefaultIfEmpty<TSource>(this IQueryable<TSource> source, TSource defaultValue);
        public static IQueryable<TSource> Distinct<TSource>(this IQueryable<TSource> source);
        public static IQueryable<TSource> Distinct<TSource>(this IQueryable<TSource> source, IEqualityComparer<TSource> comparer);
        public static TSource ElementAt<TSource>(this IQueryable<TSource> source, int index);
        public static TSource ElementAtOrDefault<TSource>(this IQueryable<TSource> source, int index);
        public static IQueryable<TSource> Except<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2);
        public static IQueryable<TSource> Except<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2, IEqualityComparer<TSource> comparer);
        public static TSource First<TSource>(this IQueryable<TSource> source);
        public static TSource First<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
        public static TSource FirstOrDefault<TSource>(this IQueryable<TSource> source);
        public static TSource FirstOrDefault<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
        public static IQueryable<TResult> GroupBy<TSource, TKey, TElement, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, Expression<Func<TSource, TElement>> elementSelector, Expression<Func<TKey, IEnumerable<TElement>, TResult>> resultSelector);
        public static IQueryable<TResult> GroupBy<TSource, TKey, TElement, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, Expression<Func<TSource, TElement>> elementSelector, Expression<Func<TKey, IEnumerable<TElement>, TResult>> resultSelector, IEqualityComparer<TKey> comparer);
        public static IQueryable<IGrouping<TKey, TElement>> GroupBy<TSource, TKey, TElement>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, Expression<Func<TSource, TElement>> elementSelector);
        public static IQueryable<IGrouping<TKey, TElement>> GroupBy<TSource, TKey, TElement>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, Expression<Func<TSource, TElement>> elementSelector, IEqualityComparer<TKey> comparer);
        public static IQueryable<TResult> GroupBy<TSource, TKey, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, Expression<Func<TKey, IEnumerable<TSource>, TResult>> resultSelector);
        public static IQueryable<TResult> GroupBy<TSource, TKey, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, Expression<Func<TKey, IEnumerable<TSource>, TResult>> resultSelector, IEqualityComparer<TKey> comparer);
        public static IQueryable<IGrouping<TKey, TSource>> GroupBy<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector);
        public static IQueryable<IGrouping<TKey, TSource>> GroupBy<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, IEqualityComparer<TKey> comparer);
        public static IQueryable<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this IQueryable<TOuter> outer, IEnumerable<TInner> inner, Expression<Func<TOuter, TKey>> outerKeySelector, Expression<Func<TInner, TKey>> innerKeySelector, Expression<Func<TOuter, IEnumerable<TInner>, TResult>> resultSelector);
        public static IQueryable<TResult> GroupJoin<TOuter, TInner, TKey, TResult>(this IQueryable<TOuter> outer, IEnumerable<TInner> inner, Expression<Func<TOuter, TKey>> outerKeySelector, Expression<Func<TInner, TKey>> innerKeySelector, Expression<Func<TOuter, IEnumerable<TInner>, TResult>> resultSelector, IEqualityComparer<TKey> comparer);
        public static IQueryable<TSource> Intersect<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2);
        public static IQueryable<TSource> Intersect<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2, IEqualityComparer<TSource> comparer);
        public static IQueryable<TResult> Join<TOuter, TInner, TKey, TResult>(this IQueryable<TOuter> outer, IEnumerable<TInner> inner, Expression<Func<TOuter, TKey>> outerKeySelector, Expression<Func<TInner, TKey>> innerKeySelector, Expression<Func<TOuter, TInner, TResult>> resultSelector);
        public static IQueryable<TResult> Join<TOuter, TInner, TKey, TResult>(this IQueryable<TOuter> outer, IEnumerable<TInner> inner, Expression<Func<TOuter, TKey>> outerKeySelector, Expression<Func<TInner, TKey>> innerKeySelector, Expression<Func<TOuter, TInner, TResult>> resultSelector, IEqualityComparer<TKey> comparer);
        public static TSource Last<TSource>(this IQueryable<TSource> source);
        public static TSource Last<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
        public static TSource LastOrDefault<TSource>(this IQueryable<TSource> source);
        public static TSource LastOrDefault<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
        public static long LongCount<TSource>(this IQueryable<TSource> source);
        public static long LongCount<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
        public static TResult Max<TSource, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, TResult>> selector);
        public static TSource Max<TSource>(this IQueryable<TSource> source);
        public static TResult Min<TSource, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, TResult>> selector);
        public static TSource Min<TSource>(this IQueryable<TSource> source);
        public static IQueryable<TResult> OfType<TResult>(this IQueryable source);
        public static IOrderedQueryable<TSource> OrderBy<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector);
        public static IOrderedQueryable<TSource> OrderBy<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, IComparer<TKey> comparer);
        public static IOrderedQueryable<TSource> OrderByDescending<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector);
        public static IOrderedQueryable<TSource> OrderByDescending<TSource, TKey>(this IQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, IComparer<TKey> comparer);
        public static IQueryable<TSource> Reverse<TSource>(this IQueryable<TSource> source);
        public static IQueryable<TResult> Select<TSource, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, int, TResult>> selector);
        public static IQueryable<TResult> Select<TSource, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, TResult>> selector);
        public static IQueryable<TResult> SelectMany<TSource, TCollection, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, IEnumerable<TCollection>>> collectionSelector, Expression<Func<TSource, TCollection, TResult>> resultSelector);
        public static IQueryable<TResult> SelectMany<TSource, TCollection, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, int, IEnumerable<TCollection>>> collectionSelector, Expression<Func<TSource, TCollection, TResult>> resultSelector);
        public static IQueryable<TResult> SelectMany<TSource, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, IEnumerable<TResult>>> selector);
        public static IQueryable<TResult> SelectMany<TSource, TResult>(this IQueryable<TSource> source, Expression<Func<TSource, int, IEnumerable<TResult>>> selector);
        public static bool SequenceEqual<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2);
        public static bool SequenceEqual<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2, IEqualityComparer<TSource> comparer);
        public static TSource Single<TSource>(this IQueryable<TSource> source);
        public static TSource Single<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
        public static TSource SingleOrDefault<TSource>(this IQueryable<TSource> source);
        public static TSource SingleOrDefault<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
        public static IQueryable<TSource> Skip<TSource>(this IQueryable<TSource> source, int count);
        public static IQueryable<TSource> SkipWhile<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
        public static IQueryable<TSource> SkipWhile<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, int, bool>> predicate);
        public static decimal Sum(this IQueryable<decimal> source);
        public static double Sum(this IQueryable<double> source);
        public static int Sum(this IQueryable<int> source);
        public static long Sum(this IQueryable<long> source);
        public static Nullable<decimal> Sum(this IQueryable<Nullable<decimal>> source);
        public static Nullable<double> Sum(this IQueryable<Nullable<double>> source);
        public static Nullable<int> Sum(this IQueryable<Nullable<int>> source);
        public static Nullable<long> Sum(this IQueryable<Nullable<long>> source);
        public static Nullable<float> Sum(this IQueryable<Nullable<float>> source);
        public static float Sum(this IQueryable<float> source);
        public static decimal Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, decimal>> selector);
        public static double Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, double>> selector);
        public static int Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, int>> selector);
        public static long Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, long>> selector);
        public static Nullable<decimal> Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<decimal>>> selector);
        public static Nullable<double> Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<double>>> selector);
        public static Nullable<int> Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<int>>> selector);
        public static Nullable<long> Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<long>>> selector);
        public static Nullable<float> Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, Nullable<float>>> selector);
        public static float Sum<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, float>> selector);
        public static IQueryable<TSource> Take<TSource>(this IQueryable<TSource> source, int count);
        public static IQueryable<TSource> TakeWhile<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
        public static IQueryable<TSource> TakeWhile<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, int, bool>> predicate);
        public static IOrderedQueryable<TSource> ThenBy<TSource, TKey>(this IOrderedQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector);
        public static IOrderedQueryable<TSource> ThenBy<TSource, TKey>(this IOrderedQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, IComparer<TKey> comparer);
        public static IOrderedQueryable<TSource> ThenByDescending<TSource, TKey>(this IOrderedQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector);
        public static IOrderedQueryable<TSource> ThenByDescending<TSource, TKey>(this IOrderedQueryable<TSource> source, Expression<Func<TSource, TKey>> keySelector, IComparer<TKey> comparer);
        public static IQueryable<TSource> Union<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2);
        public static IQueryable<TSource> Union<TSource>(this IQueryable<TSource> source1, IEnumerable<TSource> source2, IEqualityComparer<TSource> comparer);
        public static IQueryable<TSource> Where<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, bool>> predicate);
        public static IQueryable<TSource> Where<TSource>(this IQueryable<TSource> source, Expression<Func<TSource, int, bool>> predicate);
        public static IQueryable<TResult> Zip<TFirst, TSecond, TResult>(this IQueryable<TFirst> source1, IEnumerable<TSecond> source2, Expression<Func<TFirst, TSecond, TResult>> resultSelector);
    }
}
namespace System.Linq.Expressions {
    public class BinaryExpression : Expression {
        public override bool CanReduce { get; }
        public LambdaExpression Conversion { get; }
        public bool IsLifted { get; }
        public bool IsLiftedToNull { get; }
        public Expression Left { get; }
        public MethodInfo Method { get; }
        public Expression Right { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
        public override Expression Reduce();
        public BinaryExpression Update(Expression left, LambdaExpression conversion, Expression right);
    }
    public class BlockExpression : Expression {
        public ReadOnlyCollection<Expression> Expressions { get; }
        public sealed override ExpressionType NodeType { get; }
        public Expression Result { get; }
        public override Type Type { get; }
        public ReadOnlyCollection<ParameterExpression> Variables { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
        public BlockExpression Update(IEnumerable<ParameterExpression> variables, IEnumerable<Expression> expressions);
    }
    public sealed class CatchBlock {
        public Expression Body { get; }
        public Expression Filter { get; }
        public Type Test { get; }
        public ParameterExpression Variable { get; }
        public override string ToString();
        public CatchBlock Update(ParameterExpression variable, Expression filter, Expression body);
    }
    public class ConditionalExpression : Expression {
        public Expression IfFalse { get; }
        public Expression IfTrue { get; }
        public sealed override ExpressionType NodeType { get; }
        public Expression Test { get; }
        public override Type Type { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
        public ConditionalExpression Update(Expression test, Expression ifTrue, Expression ifFalse);
    }
    public class ConstantExpression : Expression {
        public sealed override ExpressionType NodeType { get; }
        public override Type Type { get; }
        public object Value { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
    }
    public class DebugInfoExpression : Expression {
        public SymbolDocumentInfo Document { get; }
        public virtual int EndColumn { get; }
        public virtual int EndLine { get; }
        public virtual bool IsClear { get; }
        public sealed override ExpressionType NodeType { get; }
        public virtual int StartColumn { get; }
        public virtual int StartLine { get; }
        public sealed override Type Type { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
    }
    public sealed class DefaultExpression : Expression {
        public sealed override ExpressionType NodeType { get; }
        public sealed override Type Type { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
    }
    public class DynamicExpression : Expression, IArgumentProvider, IDynamicExpression {
        public ReadOnlyCollection<Expression> Arguments { get; }
        public CallSiteBinder Binder { get; }
        public Type DelegateType { get; }
        public sealed override ExpressionType NodeType { get; }
        int System.Linq.Expressions.IArgumentProvider.ArgumentCount { get; }
        public override Type Type { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
        public static new DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, IEnumerable<Expression> arguments);
        public static new DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, Expression arg0);
        public static new DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, Expression arg0, Expression arg1);
        public static new DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, Expression arg0, Expression arg1, Expression arg2);
        public static new DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, Expression arg0, Expression arg1, Expression arg2, Expression arg3);
        public static new DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, params Expression[] arguments);
        public static new DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, IEnumerable<Expression> arguments);
        public static new DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, Expression arg0);
        public static new DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, Expression arg0, Expression arg1);
        public static new DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, Expression arg0, Expression arg1, Expression arg2);
        public static new DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, Expression arg0, Expression arg1, Expression arg2, Expression arg3);
        public static new DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, params Expression[] arguments);
        Expression System.Linq.Expressions.IArgumentProvider.GetArgument(int index);
        object System.Linq.Expressions.IDynamicExpression.CreateCallSite();
        Expression System.Linq.Expressions.IDynamicExpression.Rewrite(Expression[] args);
        public DynamicExpression Update(IEnumerable<Expression> arguments);
    }
    public abstract class DynamicExpressionVisitor : ExpressionVisitor {
        protected DynamicExpressionVisitor();
        protected internal override Expression VisitDynamic(DynamicExpression node);
    }
    public sealed class ElementInit : IArgumentProvider {
        public MethodInfo AddMethod { get; }
        public ReadOnlyCollection<Expression> Arguments { get; }
        int System.Linq.Expressions.IArgumentProvider.ArgumentCount { get; }
        Expression System.Linq.Expressions.IArgumentProvider.GetArgument(int index);
        public override string ToString();
        public ElementInit Update(IEnumerable<Expression> arguments);
    }
    public abstract class Expression {
        protected Expression();
        protected Expression(ExpressionType nodeType, Type type);
        public virtual bool CanReduce { get; }
        public virtual ExpressionType NodeType { get; }
        public virtual Type Type { get; }
        protected internal virtual Expression Accept(ExpressionVisitor visitor);
        public static BinaryExpression Add(Expression left, Expression right);
        public static BinaryExpression Add(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression AddAssign(Expression left, Expression right);
        public static BinaryExpression AddAssign(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression AddAssign(Expression left, Expression right, MethodInfo method, LambdaExpression conversion);
        public static BinaryExpression AddAssignChecked(Expression left, Expression right);
        public static BinaryExpression AddAssignChecked(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression AddAssignChecked(Expression left, Expression right, MethodInfo method, LambdaExpression conversion);
        public static BinaryExpression AddChecked(Expression left, Expression right);
        public static BinaryExpression AddChecked(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression And(Expression left, Expression right);
        public static BinaryExpression And(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression AndAlso(Expression left, Expression right);
        public static BinaryExpression AndAlso(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression AndAssign(Expression left, Expression right);
        public static BinaryExpression AndAssign(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression AndAssign(Expression left, Expression right, MethodInfo method, LambdaExpression conversion);
        public static IndexExpression ArrayAccess(Expression array, IEnumerable<Expression> indexes);
        public static IndexExpression ArrayAccess(Expression array, params Expression[] indexes);
        public static MethodCallExpression ArrayIndex(Expression array, IEnumerable<Expression> indexes);
        public static BinaryExpression ArrayIndex(Expression array, Expression index);
        public static MethodCallExpression ArrayIndex(Expression array, params Expression[] indexes);
        public static UnaryExpression ArrayLength(Expression array);
        public static BinaryExpression Assign(Expression left, Expression right);
        public static MemberAssignment Bind(MemberInfo member, Expression expression);
        public static MemberAssignment Bind(MethodInfo propertyAccessor, Expression expression);
        public static BlockExpression Block(IEnumerable<Expression> expressions);
        public static BlockExpression Block(IEnumerable<ParameterExpression> variables, IEnumerable<Expression> expressions);
        public static BlockExpression Block(IEnumerable<ParameterExpression> variables, params Expression[] expressions);
        public static BlockExpression Block(Expression arg0, Expression arg1);
        public static BlockExpression Block(Expression arg0, Expression arg1, Expression arg2);
        public static BlockExpression Block(Expression arg0, Expression arg1, Expression arg2, Expression arg3);
        public static BlockExpression Block(Expression arg0, Expression arg1, Expression arg2, Expression arg3, Expression arg4);
        public static BlockExpression Block(params Expression[] expressions);
        public static BlockExpression Block(Type type, IEnumerable<Expression> expressions);
        public static BlockExpression Block(Type type, IEnumerable<ParameterExpression> variables, IEnumerable<Expression> expressions);
        public static BlockExpression Block(Type type, IEnumerable<ParameterExpression> variables, params Expression[] expressions);
        public static BlockExpression Block(Type type, params Expression[] expressions);
        public static GotoExpression Break(LabelTarget target);
        public static GotoExpression Break(LabelTarget target, Expression value);
        public static GotoExpression Break(LabelTarget target, Expression value, Type type);
        public static GotoExpression Break(LabelTarget target, Type type);
        public static MethodCallExpression Call(Expression instance, MethodInfo method);
        public static MethodCallExpression Call(Expression instance, MethodInfo method, IEnumerable<Expression> arguments);
        public static MethodCallExpression Call(Expression instance, MethodInfo method, Expression arg0, Expression arg1);
        public static MethodCallExpression Call(Expression instance, MethodInfo method, Expression arg0, Expression arg1, Expression arg2);
        public static MethodCallExpression Call(Expression instance, MethodInfo method, params Expression[] arguments);
        public static MethodCallExpression Call(Expression instance, string methodName, Type[] typeArguments, params Expression[] arguments);
        public static MethodCallExpression Call(MethodInfo method, IEnumerable<Expression> arguments);
        public static MethodCallExpression Call(MethodInfo method, Expression arg0);
        public static MethodCallExpression Call(MethodInfo method, Expression arg0, Expression arg1);
        public static MethodCallExpression Call(MethodInfo method, Expression arg0, Expression arg1, Expression arg2);
        public static MethodCallExpression Call(MethodInfo method, Expression arg0, Expression arg1, Expression arg2, Expression arg3);
        public static MethodCallExpression Call(MethodInfo method, Expression arg0, Expression arg1, Expression arg2, Expression arg3, Expression arg4);
        public static MethodCallExpression Call(MethodInfo method, params Expression[] arguments);
        public static MethodCallExpression Call(Type type, string methodName, Type[] typeArguments, params Expression[] arguments);
        public static CatchBlock Catch(ParameterExpression variable, Expression body);
        public static CatchBlock Catch(ParameterExpression variable, Expression body, Expression filter);
        public static CatchBlock Catch(Type type, Expression body);
        public static CatchBlock Catch(Type type, Expression body, Expression filter);
        public static DebugInfoExpression ClearDebugInfo(SymbolDocumentInfo document);
        public static BinaryExpression Coalesce(Expression left, Expression right);
        public static BinaryExpression Coalesce(Expression left, Expression right, LambdaExpression conversion);
        public static ConditionalExpression Condition(Expression test, Expression ifTrue, Expression ifFalse);
        public static ConditionalExpression Condition(Expression test, Expression ifTrue, Expression ifFalse, Type type);
        public static ConstantExpression Constant(object value);
        public static ConstantExpression Constant(object value, Type type);
        public static GotoExpression Continue(LabelTarget target);
        public static GotoExpression Continue(LabelTarget target, Type type);
        public static UnaryExpression Convert(Expression expression, Type type);
        public static UnaryExpression Convert(Expression expression, Type type, MethodInfo method);
        public static UnaryExpression ConvertChecked(Expression expression, Type type);
        public static UnaryExpression ConvertChecked(Expression expression, Type type, MethodInfo method);
        public static DebugInfoExpression DebugInfo(SymbolDocumentInfo document, int startLine, int startColumn, int endLine, int endColumn);
        public static UnaryExpression Decrement(Expression expression);
        public static UnaryExpression Decrement(Expression expression, MethodInfo method);
        public static DefaultExpression Default(Type type);
        public static BinaryExpression Divide(Expression left, Expression right);
        public static BinaryExpression Divide(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression DivideAssign(Expression left, Expression right);
        public static BinaryExpression DivideAssign(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression DivideAssign(Expression left, Expression right, MethodInfo method, LambdaExpression conversion);
        public static DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, IEnumerable<Expression> arguments);
        public static DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, Expression arg0);
        public static DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, Expression arg0, Expression arg1);
        public static DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, Expression arg0, Expression arg1, Expression arg2);
        public static DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, Expression arg0, Expression arg1, Expression arg2, Expression arg3);
        public static DynamicExpression Dynamic(CallSiteBinder binder, Type returnType, params Expression[] arguments);
        public static ElementInit ElementInit(MethodInfo addMethod, IEnumerable<Expression> arguments);
        public static ElementInit ElementInit(MethodInfo addMethod, params Expression[] arguments);
        public static DefaultExpression Empty();
        public static BinaryExpression Equal(Expression left, Expression right);
        public static BinaryExpression Equal(Expression left, Expression right, bool liftToNull, MethodInfo method);
        public static BinaryExpression ExclusiveOr(Expression left, Expression right);
        public static BinaryExpression ExclusiveOr(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression ExclusiveOrAssign(Expression left, Expression right);
        public static BinaryExpression ExclusiveOrAssign(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression ExclusiveOrAssign(Expression left, Expression right, MethodInfo method, LambdaExpression conversion);
        public static MemberExpression Field(Expression expression, FieldInfo field);
        public static MemberExpression Field(Expression expression, string fieldName);
        public static MemberExpression Field(Expression expression, Type type, string fieldName);
        public static Type GetActionType(params Type[] typeArgs);
        public static Type GetDelegateType(params Type[] typeArgs);
        public static Type GetFuncType(params Type[] typeArgs);
        public static GotoExpression Goto(LabelTarget target);
        public static GotoExpression Goto(LabelTarget target, Expression value);
        public static GotoExpression Goto(LabelTarget target, Expression value, Type type);
        public static GotoExpression Goto(LabelTarget target, Type type);
        public static BinaryExpression GreaterThan(Expression left, Expression right);
        public static BinaryExpression GreaterThan(Expression left, Expression right, bool liftToNull, MethodInfo method);
        public static BinaryExpression GreaterThanOrEqual(Expression left, Expression right);
        public static BinaryExpression GreaterThanOrEqual(Expression left, Expression right, bool liftToNull, MethodInfo method);
        public static ConditionalExpression IfThen(Expression test, Expression ifTrue);
        public static ConditionalExpression IfThenElse(Expression test, Expression ifTrue, Expression ifFalse);
        public static UnaryExpression Increment(Expression expression);
        public static UnaryExpression Increment(Expression expression, MethodInfo method);
        public static InvocationExpression Invoke(Expression expression, IEnumerable<Expression> arguments);
        public static InvocationExpression Invoke(Expression expression, params Expression[] arguments);
        public static UnaryExpression IsFalse(Expression expression);
        public static UnaryExpression IsFalse(Expression expression, MethodInfo method);
        public static UnaryExpression IsTrue(Expression expression);
        public static UnaryExpression IsTrue(Expression expression, MethodInfo method);
        public static LabelTarget Label();
        public static LabelExpression Label(LabelTarget target);
        public static LabelExpression Label(LabelTarget target, Expression defaultValue);
        public static LabelTarget Label(string name);
        public static LabelTarget Label(Type type);
        public static LabelTarget Label(Type type, string name);
        public static LambdaExpression Lambda(Expression body, bool tailCall, IEnumerable<ParameterExpression> parameters);
        public static LambdaExpression Lambda(Expression body, bool tailCall, params ParameterExpression[] parameters);
        public static LambdaExpression Lambda(Expression body, IEnumerable<ParameterExpression> parameters);
        public static LambdaExpression Lambda(Expression body, params ParameterExpression[] parameters);
        public static LambdaExpression Lambda(Expression body, string name, bool tailCall, IEnumerable<ParameterExpression> parameters);
        public static LambdaExpression Lambda(Expression body, string name, IEnumerable<ParameterExpression> parameters);
        public static LambdaExpression Lambda(Type delegateType, Expression body, bool tailCall, IEnumerable<ParameterExpression> parameters);
        public static LambdaExpression Lambda(Type delegateType, Expression body, bool tailCall, params ParameterExpression[] parameters);
        public static LambdaExpression Lambda(Type delegateType, Expression body, IEnumerable<ParameterExpression> parameters);
        public static LambdaExpression Lambda(Type delegateType, Expression body, params ParameterExpression[] parameters);
        public static LambdaExpression Lambda(Type delegateType, Expression body, string name, bool tailCall, IEnumerable<ParameterExpression> parameters);
        public static LambdaExpression Lambda(Type delegateType, Expression body, string name, IEnumerable<ParameterExpression> parameters);
        public static Expression<TDelegate> Lambda<TDelegate>(Expression body, bool tailCall, IEnumerable<ParameterExpression> parameters);
        public static Expression<TDelegate> Lambda<TDelegate>(Expression body, bool tailCall, params ParameterExpression[] parameters);
        public static Expression<TDelegate> Lambda<TDelegate>(Expression body, IEnumerable<ParameterExpression> parameters);
        public static Expression<TDelegate> Lambda<TDelegate>(Expression body, params ParameterExpression[] parameters);
        public static Expression<TDelegate> Lambda<TDelegate>(Expression body, string name, bool tailCall, IEnumerable<ParameterExpression> parameters);
        public static Expression<TDelegate> Lambda<TDelegate>(Expression body, string name, IEnumerable<ParameterExpression> parameters);
        public static BinaryExpression LeftShift(Expression left, Expression right);
        public static BinaryExpression LeftShift(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression LeftShiftAssign(Expression left, Expression right);
        public static BinaryExpression LeftShiftAssign(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression LeftShiftAssign(Expression left, Expression right, MethodInfo method, LambdaExpression conversion);
        public static BinaryExpression LessThan(Expression left, Expression right);
        public static BinaryExpression LessThan(Expression left, Expression right, bool liftToNull, MethodInfo method);
        public static BinaryExpression LessThanOrEqual(Expression left, Expression right);
        public static BinaryExpression LessThanOrEqual(Expression left, Expression right, bool liftToNull, MethodInfo method);
        public static MemberListBinding ListBind(MemberInfo member, IEnumerable<ElementInit> initializers);
        public static MemberListBinding ListBind(MemberInfo member, params ElementInit[] initializers);
        public static MemberListBinding ListBind(MethodInfo propertyAccessor, IEnumerable<ElementInit> initializers);
        public static MemberListBinding ListBind(MethodInfo propertyAccessor, params ElementInit[] initializers);
        public static ListInitExpression ListInit(NewExpression newExpression, IEnumerable<ElementInit> initializers);
        public static ListInitExpression ListInit(NewExpression newExpression, IEnumerable<Expression> initializers);
        public static ListInitExpression ListInit(NewExpression newExpression, params ElementInit[] initializers);
        public static ListInitExpression ListInit(NewExpression newExpression, params Expression[] initializers);
        public static ListInitExpression ListInit(NewExpression newExpression, MethodInfo addMethod, IEnumerable<Expression> initializers);
        public static ListInitExpression ListInit(NewExpression newExpression, MethodInfo addMethod, params Expression[] initializers);
        public static LoopExpression Loop(Expression body);
        public static LoopExpression Loop(Expression body, LabelTarget @break);
        public static LoopExpression Loop(Expression body, LabelTarget @break, LabelTarget @continue);
        public static BinaryExpression MakeBinary(ExpressionType binaryType, Expression left, Expression right);
        public static BinaryExpression MakeBinary(ExpressionType binaryType, Expression left, Expression right, bool liftToNull, MethodInfo method);
        public static BinaryExpression MakeBinary(ExpressionType binaryType, Expression left, Expression right, bool liftToNull, MethodInfo method, LambdaExpression conversion);
        public static CatchBlock MakeCatchBlock(Type type, ParameterExpression variable, Expression body, Expression filter);
        public static DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, IEnumerable<Expression> arguments);
        public static DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, Expression arg0);
        public static DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, Expression arg0, Expression arg1);
        public static DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, Expression arg0, Expression arg1, Expression arg2);
        public static DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, Expression arg0, Expression arg1, Expression arg2, Expression arg3);
        public static DynamicExpression MakeDynamic(Type delegateType, CallSiteBinder binder, params Expression[] arguments);
        public static GotoExpression MakeGoto(GotoExpressionKind kind, LabelTarget target, Expression value, Type type);
        public static IndexExpression MakeIndex(Expression instance, PropertyInfo indexer, IEnumerable<Expression> arguments);
        public static MemberExpression MakeMemberAccess(Expression expression, MemberInfo member);
        public static TryExpression MakeTry(Type type, Expression body, Expression @finally, Expression fault, IEnumerable<CatchBlock> handlers);
        public static UnaryExpression MakeUnary(ExpressionType unaryType, Expression operand, Type type);
        public static UnaryExpression MakeUnary(ExpressionType unaryType, Expression operand, Type type, MethodInfo method);
        public static MemberMemberBinding MemberBind(MemberInfo member, IEnumerable<MemberBinding> bindings);
        public static MemberMemberBinding MemberBind(MemberInfo member, params MemberBinding[] bindings);
        public static MemberMemberBinding MemberBind(MethodInfo propertyAccessor, IEnumerable<MemberBinding> bindings);
        public static MemberMemberBinding MemberBind(MethodInfo propertyAccessor, params MemberBinding[] bindings);
        public static MemberInitExpression MemberInit(NewExpression newExpression, IEnumerable<MemberBinding> bindings);
        public static MemberInitExpression MemberInit(NewExpression newExpression, params MemberBinding[] bindings);
        public static BinaryExpression Modulo(Expression left, Expression right);
        public static BinaryExpression Modulo(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression ModuloAssign(Expression left, Expression right);
        public static BinaryExpression ModuloAssign(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression ModuloAssign(Expression left, Expression right, MethodInfo method, LambdaExpression conversion);
        public static BinaryExpression Multiply(Expression left, Expression right);
        public static BinaryExpression Multiply(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression MultiplyAssign(Expression left, Expression right);
        public static BinaryExpression MultiplyAssign(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression MultiplyAssign(Expression left, Expression right, MethodInfo method, LambdaExpression conversion);
        public static BinaryExpression MultiplyAssignChecked(Expression left, Expression right);
        public static BinaryExpression MultiplyAssignChecked(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression MultiplyAssignChecked(Expression left, Expression right, MethodInfo method, LambdaExpression conversion);
        public static BinaryExpression MultiplyChecked(Expression left, Expression right);
        public static BinaryExpression MultiplyChecked(Expression left, Expression right, MethodInfo method);
        public static UnaryExpression Negate(Expression expression);
        public static UnaryExpression Negate(Expression expression, MethodInfo method);
        public static UnaryExpression NegateChecked(Expression expression);
        public static UnaryExpression NegateChecked(Expression expression, MethodInfo method);
        public static NewExpression New(ConstructorInfo constructor);
        public static NewExpression New(ConstructorInfo constructor, IEnumerable<Expression> arguments);
        public static NewExpression New(ConstructorInfo constructor, IEnumerable<Expression> arguments, IEnumerable<MemberInfo> members);
        public static NewExpression New(ConstructorInfo constructor, IEnumerable<Expression> arguments, params MemberInfo[] members);
        public static NewExpression New(ConstructorInfo constructor, params Expression[] arguments);
        public static NewExpression New(Type type);
        public static NewArrayExpression NewArrayBounds(Type type, IEnumerable<Expression> bounds);
        public static NewArrayExpression NewArrayBounds(Type type, params Expression[] bounds);
        public static NewArrayExpression NewArrayInit(Type type, IEnumerable<Expression> initializers);
        public static NewArrayExpression NewArrayInit(Type type, params Expression[] initializers);
        public static UnaryExpression Not(Expression expression);
        public static UnaryExpression Not(Expression expression, MethodInfo method);
        public static BinaryExpression NotEqual(Expression left, Expression right);
        public static BinaryExpression NotEqual(Expression left, Expression right, bool liftToNull, MethodInfo method);
        public static UnaryExpression OnesComplement(Expression expression);
        public static UnaryExpression OnesComplement(Expression expression, MethodInfo method);
        public static BinaryExpression Or(Expression left, Expression right);
        public static BinaryExpression Or(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression OrAssign(Expression left, Expression right);
        public static BinaryExpression OrAssign(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression OrAssign(Expression left, Expression right, MethodInfo method, LambdaExpression conversion);
        public static BinaryExpression OrElse(Expression left, Expression right);
        public static BinaryExpression OrElse(Expression left, Expression right, MethodInfo method);
        public static ParameterExpression Parameter(Type type);
        public static ParameterExpression Parameter(Type type, string name);
        public static UnaryExpression PostDecrementAssign(Expression expression);
        public static UnaryExpression PostDecrementAssign(Expression expression, MethodInfo method);
        public static UnaryExpression PostIncrementAssign(Expression expression);
        public static UnaryExpression PostIncrementAssign(Expression expression, MethodInfo method);
        public static BinaryExpression Power(Expression left, Expression right);
        public static BinaryExpression Power(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression PowerAssign(Expression left, Expression right);
        public static BinaryExpression PowerAssign(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression PowerAssign(Expression left, Expression right, MethodInfo method, LambdaExpression conversion);
        public static UnaryExpression PreDecrementAssign(Expression expression);
        public static UnaryExpression PreDecrementAssign(Expression expression, MethodInfo method);
        public static UnaryExpression PreIncrementAssign(Expression expression);
        public static UnaryExpression PreIncrementAssign(Expression expression, MethodInfo method);
        public static MemberExpression Property(Expression expression, MethodInfo propertyAccessor);
        public static MemberExpression Property(Expression expression, PropertyInfo property);
        public static IndexExpression Property(Expression instance, PropertyInfo indexer, IEnumerable<Expression> arguments);
        public static IndexExpression Property(Expression instance, PropertyInfo indexer, params Expression[] arguments);
        public static MemberExpression Property(Expression expression, string propertyName);
        public static IndexExpression Property(Expression instance, string propertyName, params Expression[] arguments);
        public static MemberExpression Property(Expression expression, Type type, string propertyName);
        public static MemberExpression PropertyOrField(Expression expression, string propertyOrFieldName);
        public static UnaryExpression Quote(Expression expression);
        public virtual Expression Reduce();
        public Expression ReduceAndCheck();
        public Expression ReduceExtensions();
        public static BinaryExpression ReferenceEqual(Expression left, Expression right);
        public static BinaryExpression ReferenceNotEqual(Expression left, Expression right);
        public static UnaryExpression Rethrow();
        public static UnaryExpression Rethrow(Type type);
        public static GotoExpression Return(LabelTarget target);
        public static GotoExpression Return(LabelTarget target, Expression value);
        public static GotoExpression Return(LabelTarget target, Expression value, Type type);
        public static GotoExpression Return(LabelTarget target, Type type);
        public static BinaryExpression RightShift(Expression left, Expression right);
        public static BinaryExpression RightShift(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression RightShiftAssign(Expression left, Expression right);
        public static BinaryExpression RightShiftAssign(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression RightShiftAssign(Expression left, Expression right, MethodInfo method, LambdaExpression conversion);
        public static RuntimeVariablesExpression RuntimeVariables(IEnumerable<ParameterExpression> variables);
        public static RuntimeVariablesExpression RuntimeVariables(params ParameterExpression[] variables);
        public static BinaryExpression Subtract(Expression left, Expression right);
        public static BinaryExpression Subtract(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression SubtractAssign(Expression left, Expression right);
        public static BinaryExpression SubtractAssign(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression SubtractAssign(Expression left, Expression right, MethodInfo method, LambdaExpression conversion);
        public static BinaryExpression SubtractAssignChecked(Expression left, Expression right);
        public static BinaryExpression SubtractAssignChecked(Expression left, Expression right, MethodInfo method);
        public static BinaryExpression SubtractAssignChecked(Expression left, Expression right, MethodInfo method, LambdaExpression conversion);
        public static BinaryExpression SubtractChecked(Expression left, Expression right);
        public static BinaryExpression SubtractChecked(Expression left, Expression right, MethodInfo method);
        public static SwitchExpression Switch(Expression switchValue, Expression defaultBody, params SwitchCase[] cases);
        public static SwitchExpression Switch(Expression switchValue, Expression defaultBody, MethodInfo comparison, IEnumerable<SwitchCase> cases);
        public static SwitchExpression Switch(Expression switchValue, Expression defaultBody, MethodInfo comparison, params SwitchCase[] cases);
        public static SwitchExpression Switch(Expression switchValue, params SwitchCase[] cases);
        public static SwitchExpression Switch(Type type, Expression switchValue, Expression defaultBody, MethodInfo comparison, IEnumerable<SwitchCase> cases);
        public static SwitchExpression Switch(Type type, Expression switchValue, Expression defaultBody, MethodInfo comparison, params SwitchCase[] cases);
        public static SwitchCase SwitchCase(Expression body, IEnumerable<Expression> testValues);
        public static SwitchCase SwitchCase(Expression body, params Expression[] testValues);
        public static SymbolDocumentInfo SymbolDocument(string fileName);
        public static SymbolDocumentInfo SymbolDocument(string fileName, Guid language);
        public static SymbolDocumentInfo SymbolDocument(string fileName, Guid language, Guid languageVendor);
        public static SymbolDocumentInfo SymbolDocument(string fileName, Guid language, Guid languageVendor, Guid documentType);
        public static UnaryExpression Throw(Expression value);
        public static UnaryExpression Throw(Expression value, Type type);
        public override string ToString();
        public static TryExpression TryCatch(Expression body, params CatchBlock[] handlers);
        public static TryExpression TryCatchFinally(Expression body, Expression @finally, params CatchBlock[] handlers);
        public static TryExpression TryFault(Expression body, Expression fault);
        public static TryExpression TryFinally(Expression body, Expression @finally);
        public static bool TryGetActionType(Type[] typeArgs, out Type actionType);
        public static bool TryGetFuncType(Type[] typeArgs, out Type funcType);
        public static UnaryExpression TypeAs(Expression expression, Type type);
        public static TypeBinaryExpression TypeEqual(Expression expression, Type type);
        public static TypeBinaryExpression TypeIs(Expression expression, Type type);
        public static UnaryExpression UnaryPlus(Expression expression);
        public static UnaryExpression UnaryPlus(Expression expression, MethodInfo method);
        public static UnaryExpression Unbox(Expression expression, Type type);
        public static ParameterExpression Variable(Type type);
        public static ParameterExpression Variable(Type type, string name);
        protected internal virtual Expression VisitChildren(ExpressionVisitor visitor);
    }
    public sealed class Expression<TDelegate> : LambdaExpression {
        protected internal override Expression Accept(ExpressionVisitor visitor);
        public new TDelegate Compile();
        public new TDelegate Compile(bool preferInterpretation);
        public new TDelegate Compile(DebugInfoGenerator debugInfoGenerator);
        public Expression<TDelegate> Update(Expression body, IEnumerable<ParameterExpression> parameters);
    }
    public enum ExpressionType {
        Add = 0,
        AddAssign = 63,
        AddAssignChecked = 74,
        AddChecked = 1,
        And = 2,
        AndAlso = 3,
        AndAssign = 64,
        ArrayIndex = 5,
        ArrayLength = 4,
        Assign = 46,
        Block = 47,
        Call = 6,
        Coalesce = 7,
        Conditional = 8,
        Constant = 9,
        Convert = 10,
        ConvertChecked = 11,
        DebugInfo = 48,
        Decrement = 49,
        Default = 51,
        Divide = 12,
        DivideAssign = 65,
        Dynamic = 50,
        Equal = 13,
        ExclusiveOr = 14,
        ExclusiveOrAssign = 66,
        Extension = 52,
        Goto = 53,
        GreaterThan = 15,
        GreaterThanOrEqual = 16,
        Increment = 54,
        Index = 55,
        Invoke = 17,
        IsFalse = 84,
        IsTrue = 83,
        Label = 56,
        Lambda = 18,
        LeftShift = 19,
        LeftShiftAssign = 67,
        LessThan = 20,
        LessThanOrEqual = 21,
        ListInit = 22,
        Loop = 58,
        MemberAccess = 23,
        MemberInit = 24,
        Modulo = 25,
        ModuloAssign = 68,
        Multiply = 26,
        MultiplyAssign = 69,
        MultiplyAssignChecked = 75,
        MultiplyChecked = 27,
        Negate = 28,
        NegateChecked = 30,
        New = 31,
        NewArrayBounds = 33,
        NewArrayInit = 32,
        Not = 34,
        NotEqual = 35,
        OnesComplement = 82,
        Or = 36,
        OrAssign = 70,
        OrElse = 37,
        Parameter = 38,
        PostDecrementAssign = 80,
        PostIncrementAssign = 79,
        Power = 39,
        PowerAssign = 71,
        PreDecrementAssign = 78,
        PreIncrementAssign = 77,
        Quote = 40,
        RightShift = 41,
        RightShiftAssign = 72,
        RuntimeVariables = 57,
        Subtract = 42,
        SubtractAssign = 73,
        SubtractAssignChecked = 76,
        SubtractChecked = 43,
        Switch = 59,
        Throw = 60,
        Try = 61,
        TypeAs = 44,
        TypeEqual = 81,
        TypeIs = 45,
        UnaryPlus = 29,
        Unbox = 62,
    }
    public abstract class ExpressionVisitor {
        protected ExpressionVisitor();
        public ReadOnlyCollection<Expression> Visit(ReadOnlyCollection<Expression> nodes);
        public virtual Expression Visit(Expression node);
        public static ReadOnlyCollection<T> Visit<T>(ReadOnlyCollection<T> nodes, Func<T, T> elementVisitor);
        public ReadOnlyCollection<T> VisitAndConvert<T>(ReadOnlyCollection<T> nodes, string callerName) where T : Expression;
        public T VisitAndConvert<T>(T node, string callerName) where T : Expression;
        protected internal virtual Expression VisitBinary(BinaryExpression node);
        protected internal virtual Expression VisitBlock(BlockExpression node);
        protected virtual CatchBlock VisitCatchBlock(CatchBlock node);
        protected internal virtual Expression VisitConditional(ConditionalExpression node);
        protected internal virtual Expression VisitConstant(ConstantExpression node);
        protected internal virtual Expression VisitDebugInfo(DebugInfoExpression node);
        protected internal virtual Expression VisitDefault(DefaultExpression node);
        protected internal virtual Expression VisitDynamic(DynamicExpression node);
        protected virtual ElementInit VisitElementInit(ElementInit node);
        protected internal virtual Expression VisitExtension(Expression node);
        protected internal virtual Expression VisitGoto(GotoExpression node);
        protected internal virtual Expression VisitIndex(IndexExpression node);
        protected internal virtual Expression VisitInvocation(InvocationExpression node);
        protected internal virtual Expression VisitLabel(LabelExpression node);
        protected virtual LabelTarget VisitLabelTarget(LabelTarget node);
        protected internal virtual Expression VisitLambda<T>(Expression<T> node);
        protected internal virtual Expression VisitListInit(ListInitExpression node);
        protected internal virtual Expression VisitLoop(LoopExpression node);
        protected internal virtual Expression VisitMember(MemberExpression node);
        protected virtual MemberAssignment VisitMemberAssignment(MemberAssignment node);
        protected virtual MemberBinding VisitMemberBinding(MemberBinding node);
        protected internal virtual Expression VisitMemberInit(MemberInitExpression node);
        protected virtual MemberListBinding VisitMemberListBinding(MemberListBinding node);
        protected virtual MemberMemberBinding VisitMemberMemberBinding(MemberMemberBinding node);
        protected internal virtual Expression VisitMethodCall(MethodCallExpression node);
        protected internal virtual Expression VisitNew(NewExpression node);
        protected internal virtual Expression VisitNewArray(NewArrayExpression node);
        protected internal virtual Expression VisitParameter(ParameterExpression node);
        protected internal virtual Expression VisitRuntimeVariables(RuntimeVariablesExpression node);
        protected internal virtual Expression VisitSwitch(SwitchExpression node);
        protected virtual SwitchCase VisitSwitchCase(SwitchCase node);
        protected internal virtual Expression VisitTry(TryExpression node);
        protected internal virtual Expression VisitTypeBinary(TypeBinaryExpression node);
        protected internal virtual Expression VisitUnary(UnaryExpression node);
    }
    public sealed class GotoExpression : Expression {
        public GotoExpressionKind Kind { get; }
        public sealed override ExpressionType NodeType { get; }
        public LabelTarget Target { get; }
        public sealed override Type Type { get; }
        public Expression Value { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
        public GotoExpression Update(LabelTarget target, Expression value);
    }
    public enum GotoExpressionKind {
        Break = 2,
        Continue = 3,
        Goto = 0,
        Return = 1,
    }
    public interface IArgumentProvider {
        int ArgumentCount { get; }
        Expression GetArgument(int index);
    }
    public interface IDynamicExpression : IArgumentProvider {
        Type DelegateType { get; }
        object CreateCallSite();
        Expression Rewrite(Expression[] args);
    }
    public sealed class IndexExpression : Expression, IArgumentProvider {
        public ReadOnlyCollection<Expression> Arguments { get; }
        public PropertyInfo Indexer { get; }
        public sealed override ExpressionType NodeType { get; }
        public Expression Object { get; }
        int System.Linq.Expressions.IArgumentProvider.ArgumentCount { get; }
        public sealed override Type Type { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
        Expression System.Linq.Expressions.IArgumentProvider.GetArgument(int index);
        public IndexExpression Update(Expression @object, IEnumerable<Expression> arguments);
    }
    public sealed class InvocationExpression : Expression, IArgumentProvider {
        public ReadOnlyCollection<Expression> Arguments { get; }
        public Expression Expression { get; }
        public sealed override ExpressionType NodeType { get; }
        int System.Linq.Expressions.IArgumentProvider.ArgumentCount { get; }
        public sealed override Type Type { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
        Expression System.Linq.Expressions.IArgumentProvider.GetArgument(int index);
        public InvocationExpression Update(Expression expression, IEnumerable<Expression> arguments);
    }
    public sealed class LabelExpression : Expression {
        public Expression DefaultValue { get; }
        public sealed override ExpressionType NodeType { get; }
        public LabelTarget Target { get; }
        public sealed override Type Type { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
        public LabelExpression Update(LabelTarget target, Expression defaultValue);
    }
    public sealed class LabelTarget {
        public string Name { get; }
        public Type Type { get; }
        public override string ToString();
    }
    public abstract class LambdaExpression : Expression {
        public Expression Body { get; }
        public string Name { get; }
        public sealed override ExpressionType NodeType { get; }
        public ReadOnlyCollection<ParameterExpression> Parameters { get; }
        public Type ReturnType { get; }
        public bool TailCall { get; }
        public sealed override Type Type { get; }
        public Delegate Compile();
        public Delegate Compile(bool preferInterpretation);
        public Delegate Compile(DebugInfoGenerator debugInfoGenerator);
    }
    public sealed class ListInitExpression : Expression {
        public override bool CanReduce { get; }
        public ReadOnlyCollection<ElementInit> Initializers { get; }
        public NewExpression NewExpression { get; }
        public sealed override ExpressionType NodeType { get; }
        public sealed override Type Type { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
        public override Expression Reduce();
        public ListInitExpression Update(NewExpression newExpression, IEnumerable<ElementInit> initializers);
    }
    public sealed class LoopExpression : Expression {
        public Expression Body { get; }
        public LabelTarget BreakLabel { get; }
        public LabelTarget ContinueLabel { get; }
        public sealed override ExpressionType NodeType { get; }
        public sealed override Type Type { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
        public LoopExpression Update(LabelTarget breakLabel, LabelTarget continueLabel, Expression body);
    }
    public sealed class MemberAssignment : MemberBinding {
        public Expression Expression { get; }
        public MemberAssignment Update(Expression expression);
    }
    public abstract class MemberBinding {
        protected MemberBinding(MemberBindingType type, MemberInfo member);
        public MemberBindingType BindingType { get; }
        public MemberInfo Member { get; }
        public override string ToString();
    }
    public enum MemberBindingType {
        Assignment = 0,
        ListBinding = 2,
        MemberBinding = 1,
    }
    public class MemberExpression : Expression {
        public Expression Expression { get; }
        public MemberInfo Member { get; }
        public sealed override ExpressionType NodeType { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
        public MemberExpression Update(Expression expression);
    }
    public sealed class MemberInitExpression : Expression {
        public ReadOnlyCollection<MemberBinding> Bindings { get; }
        public override bool CanReduce { get; }
        public NewExpression NewExpression { get; }
        public sealed override ExpressionType NodeType { get; }
        public sealed override Type Type { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
        public override Expression Reduce();
        public MemberInitExpression Update(NewExpression newExpression, IEnumerable<MemberBinding> bindings);
    }
    public sealed class MemberListBinding : MemberBinding {
        public ReadOnlyCollection<ElementInit> Initializers { get; }
        public MemberListBinding Update(IEnumerable<ElementInit> initializers);
    }
    public sealed class MemberMemberBinding : MemberBinding {
        public ReadOnlyCollection<MemberBinding> Bindings { get; }
        public MemberMemberBinding Update(IEnumerable<MemberBinding> bindings);
    }
    public class MethodCallExpression : Expression, IArgumentProvider {
        public ReadOnlyCollection<Expression> Arguments { get; }
        public MethodInfo Method { get; }
        public sealed override ExpressionType NodeType { get; }
        public Expression Object { get; }
        int System.Linq.Expressions.IArgumentProvider.ArgumentCount { get; }
        public sealed override Type Type { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
        Expression System.Linq.Expressions.IArgumentProvider.GetArgument(int index);
        public MethodCallExpression Update(Expression @object, IEnumerable<Expression> arguments);
    }
    public class NewArrayExpression : Expression {
        public ReadOnlyCollection<Expression> Expressions { get; }
        public sealed override Type Type { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
        public NewArrayExpression Update(IEnumerable<Expression> expressions);
    }
    public class NewExpression : Expression, IArgumentProvider {
        public ReadOnlyCollection<Expression> Arguments { get; }
        public ConstructorInfo Constructor { get; }
        public ReadOnlyCollection<MemberInfo> Members { get; }
        public sealed override ExpressionType NodeType { get; }
        int System.Linq.Expressions.IArgumentProvider.ArgumentCount { get; }
        public override Type Type { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
        Expression System.Linq.Expressions.IArgumentProvider.GetArgument(int index);
        public NewExpression Update(IEnumerable<Expression> arguments);
    }
    public class ParameterExpression : Expression {
        public bool IsByRef { get; }
        public string Name { get; }
        public sealed override ExpressionType NodeType { get; }
        public override Type Type { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
    }
    public sealed class RuntimeVariablesExpression : Expression {
        public sealed override ExpressionType NodeType { get; }
        public sealed override Type Type { get; }
        public ReadOnlyCollection<ParameterExpression> Variables { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
        public RuntimeVariablesExpression Update(IEnumerable<ParameterExpression> variables);
    }
    public sealed class SwitchCase {
        public Expression Body { get; }
        public ReadOnlyCollection<Expression> TestValues { get; }
        public override string ToString();
        public SwitchCase Update(IEnumerable<Expression> testValues, Expression body);
    }
    public sealed class SwitchExpression : Expression {
        public ReadOnlyCollection<SwitchCase> Cases { get; }
        public MethodInfo Comparison { get; }
        public Expression DefaultBody { get; }
        public sealed override ExpressionType NodeType { get; }
        public Expression SwitchValue { get; }
        public sealed override Type Type { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
        public SwitchExpression Update(Expression switchValue, IEnumerable<SwitchCase> cases, Expression defaultBody);
    }
    public class SymbolDocumentInfo {
        public virtual Guid DocumentType { get; }
        public string FileName { get; }
        public virtual Guid Language { get; }
        public virtual Guid LanguageVendor { get; }
    }
    public sealed class TryExpression : Expression {
        public Expression Body { get; }
        public Expression Fault { get; }
        public Expression Finally { get; }
        public ReadOnlyCollection<CatchBlock> Handlers { get; }
        public sealed override ExpressionType NodeType { get; }
        public sealed override Type Type { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
        public TryExpression Update(Expression body, IEnumerable<CatchBlock> handlers, Expression @finally, Expression fault);
    }
    public sealed class TypeBinaryExpression : Expression {
        public Expression Expression { get; }
        public sealed override ExpressionType NodeType { get; }
        public sealed override Type Type { get; }
        public Type TypeOperand { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
        public TypeBinaryExpression Update(Expression expression);
    }
    public sealed class UnaryExpression : Expression {
        public override bool CanReduce { get; }
        public bool IsLifted { get; }
        public bool IsLiftedToNull { get; }
        public MethodInfo Method { get; }
        public sealed override ExpressionType NodeType { get; }
        public Expression Operand { get; }
        public sealed override Type Type { get; }
        protected internal override Expression Accept(ExpressionVisitor visitor);
        public override Expression Reduce();
        public UnaryExpression Update(Expression operand);
    }
}
namespace System.Net {
    public class AuthenticationManager {
        public static ICredentialPolicy CredentialPolicy { get; set; }
        public static StringDictionary CustomTargetNameDictionary { get; }
        public static IEnumerator RegisteredModules { get; }
        public static Authorization Authenticate(string challenge, WebRequest request, ICredentials credentials);
        public static Authorization PreAuthenticate(WebRequest request, ICredentials credentials);
        public static void Register(IAuthenticationModule authenticationModule);
        public static void Unregister(IAuthenticationModule authenticationModule);
        public static void Unregister(string authenticationScheme);
    }
    public enum AuthenticationSchemes {
        Anonymous = 32768,
        Basic = 8,
        Digest = 1,
        IntegratedWindowsAuthentication = 6,
        Negotiate = 2,
        None = 0,
        Ntlm = 4,
    }
    public delegate AuthenticationSchemes AuthenticationSchemeSelector(HttpListenerRequest httpRequest);
    public class Authorization {
        public Authorization(string token);
        public Authorization(string token, bool finished);
        public Authorization(string token, bool finished, string connectionGroupId);
        public bool Complete { get; }
        public string ConnectionGroupId { get; }
        public string Message { get; }
        public bool MutuallyAuthenticated { get; set; }
        public string[] ProtectionRealm { get; set; }
    }
    public delegate IPEndPoint BindIPEndPoint(ServicePoint servicePoint, IPEndPoint remoteEndPoint, int retryCount);
    public sealed class Cookie {
        public Cookie();
        public Cookie(string name, string value);
        public Cookie(string name, string value, string path);
        public Cookie(string name, string value, string path, string domain);
        public string Comment { get; set; }
        public Uri CommentUri { get; set; }
        public bool Discard { get; set; }
        public string Domain { get; set; }
        public bool Expired { get; set; }
        public DateTime Expires { get; set; }
        public bool HttpOnly { get; set; }
        public string Name { get; set; }
        public string Path { get; set; }
        public string Port { get; set; }
        public bool Secure { get; set; }
        public DateTime TimeStamp { get; }
        public string Value { get; set; }
        public int Version { get; set; }
        public override bool Equals(object comparand);
        public override int GetHashCode();
        public override string ToString();
    }
    public class CookieCollection : ICollection, IEnumerable {
        public CookieCollection();
        public int Count { get; }
        public bool IsReadOnly { get; }
        public bool IsSynchronized { get; }
        public object SyncRoot { get; }
        public Cookie this[int index] { get; }
        public Cookie this[string name] { get; }
        public void Add(Cookie cookie);
        public void Add(CookieCollection cookies);
        public void CopyTo(Array array, int index);
        public void CopyTo(Cookie[] array, int index);
        public IEnumerator GetEnumerator();
    }
    public class CookieContainer {
        public const int DefaultCookieLengthLimit = 4096;
        public const int DefaultCookieLimit = 300;
        public const int DefaultPerDomainCookieLimit = 20;
        public CookieContainer();
        public CookieContainer(int capacity);
        public CookieContainer(int capacity, int perDomainCapacity, int maxCookieSize);
        public int Capacity { get; set; }
        public int Count { get; }
        public int MaxCookieSize { get; set; }
        public int PerDomainCapacity { get; set; }
        public void Add(Cookie cookie);
        public void Add(CookieCollection cookies);
        public void Add(Uri uri, Cookie cookie);
        public void Add(Uri uri, CookieCollection cookies);
        public string GetCookieHeader(Uri uri);
        public CookieCollection GetCookies(Uri uri);
        public void SetCookies(Uri uri, string cookieHeader);
    }
    public class CookieException : FormatException, ISerializable {
        public CookieException();
        protected CookieException(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
    }
    public class CredentialCache : ICredentials, ICredentialsByHost, IEnumerable {
        public CredentialCache();
        public static ICredentials DefaultCredentials { get; }
        public static NetworkCredential DefaultNetworkCredentials { get; }
        public void Add(string host, int port, string authenticationType, NetworkCredential credential);
        public void Add(Uri uriPrefix, string authType, NetworkCredential cred);
        public NetworkCredential GetCredential(string host, int port, string authenticationType);
        public NetworkCredential GetCredential(Uri uriPrefix, string authType);
        public IEnumerator GetEnumerator();
        public void Remove(string host, int port, string authenticationType);
        public void Remove(Uri uriPrefix, string authType);
    }
    public enum DecompressionMethods {
        Deflate = 2,
        GZip = 1,
        None = 0,
    }
    public static class Dns {
        public static IAsyncResult BeginGetHostAddresses(string hostNameOrAddress, AsyncCallback requestCallback, object state);
        public static IAsyncResult BeginGetHostByName(string hostName, AsyncCallback requestCallback, object stateObject);
        public static IAsyncResult BeginGetHostEntry(IPAddress address, AsyncCallback requestCallback, object stateObject);
        public static IAsyncResult BeginGetHostEntry(string hostNameOrAddress, AsyncCallback requestCallback, object stateObject);
        public static IAsyncResult BeginResolve(string hostName, AsyncCallback requestCallback, object stateObject);
        public static IPAddress[] EndGetHostAddresses(IAsyncResult asyncResult);
        public static IPHostEntry EndGetHostByName(IAsyncResult asyncResult);
        public static IPHostEntry EndGetHostEntry(IAsyncResult asyncResult);
        public static IPHostEntry EndResolve(IAsyncResult asyncResult);
        public static IPAddress[] GetHostAddresses(string hostNameOrAddress);
        public static Task<IPAddress[]> GetHostAddressesAsync(string hostNameOrAddress);
        public static IPHostEntry GetHostByAddress(IPAddress address);
        public static IPHostEntry GetHostByAddress(string address);
        public static IPHostEntry GetHostByName(string hostName);
        public static IPHostEntry GetHostEntry(IPAddress address);
        public static IPHostEntry GetHostEntry(string hostNameOrAddress);
        public static Task<IPHostEntry> GetHostEntryAsync(IPAddress address);
        public static Task<IPHostEntry> GetHostEntryAsync(string hostNameOrAddress);
        public static string GetHostName();
        public static IPHostEntry Resolve(string hostName);
    }
    public class DnsEndPoint : EndPoint {
        public DnsEndPoint(string host, int port);
        public DnsEndPoint(string host, int port, AddressFamily addressFamily);
        public override AddressFamily AddressFamily { get; }
        public string Host { get; }
        public int Port { get; }
        public override bool Equals(object comparand);
        public override int GetHashCode();
        public override string ToString();
    }
    public class DownloadDataCompletedEventArgs : AsyncCompletedEventArgs {
        public byte[] Result { get; }
    }
    public delegate void DownloadDataCompletedEventHandler(object sender, DownloadDataCompletedEventArgs e);
    public class DownloadProgressChangedEventArgs : ProgressChangedEventArgs {
        public long BytesReceived { get; }
        public long TotalBytesToReceive { get; }
    }
    public delegate void DownloadProgressChangedEventHandler(object sender, DownloadProgressChangedEventArgs e);
    public class DownloadStringCompletedEventArgs : AsyncCompletedEventArgs {
        public string Result { get; }
    }
    public delegate void DownloadStringCompletedEventHandler(object sender, DownloadStringCompletedEventArgs e);
    public abstract class EndPoint {
        protected EndPoint();
        public virtual AddressFamily AddressFamily { get; }
        public virtual EndPoint Create(SocketAddress socketAddress);
        public virtual SocketAddress Serialize();
    }
    public class FileWebRequest : WebRequest, ISerializable {
        protected FileWebRequest(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public override string ConnectionGroupName { get; set; }
        public override long ContentLength { get; set; }
        public override string ContentType { get; set; }
        public override ICredentials Credentials { get; set; }
        public override WebHeaderCollection Headers { get; }
        public override string Method { get; set; }
        public override bool PreAuthenticate { get; set; }
        public override IWebProxy Proxy { get; set; }
        public override Uri RequestUri { get; }
        public override int Timeout { get; set; }
        public override bool UseDefaultCredentials { get; set; }
        public override void Abort();
        public override IAsyncResult BeginGetRequestStream(AsyncCallback callback, object state);
        public override IAsyncResult BeginGetResponse(AsyncCallback callback, object state);
        public override Stream EndGetRequestStream(IAsyncResult asyncResult);
        public override WebResponse EndGetResponse(IAsyncResult asyncResult);
        protected override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public override Stream GetRequestStream();
        public override WebResponse GetResponse();
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
    }
    public class FileWebResponse : WebResponse, ISerializable {
        protected FileWebResponse(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public override long ContentLength { get; }
        public override string ContentType { get; }
        public override WebHeaderCollection Headers { get; }
        public override Uri ResponseUri { get; }
        public override bool SupportsHeaders { get; }
        public override void Close();
        protected override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public override Stream GetResponseStream();
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
    }
    public enum FtpStatusCode {
        AccountNeeded = 532,
        ActionAbortedLocalProcessingError = 451,
        ActionAbortedUnknownPageType = 551,
        ActionNotTakenFilenameNotAllowed = 553,
        ActionNotTakenFileUnavailable = 550,
        ActionNotTakenFileUnavailableOrBusy = 450,
        ActionNotTakenInsufficientSpace = 452,
        ArgumentSyntaxError = 501,
        BadCommandSequence = 503,
        CantOpenData = 425,
        ClosingControl = 221,
        ClosingData = 226,
        CommandExtraneous = 202,
        CommandNotImplemented = 502,
        CommandOK = 200,
        CommandSyntaxError = 500,
        ConnectionClosed = 426,
        DataAlreadyOpen = 125,
        DirectoryStatus = 212,
        EnteringPassive = 227,
        FileActionAborted = 552,
        FileActionOK = 250,
        FileCommandPending = 350,
        FileStatus = 213,
        LoggedInProceed = 230,
        NeedLoginAccount = 332,
        NotLoggedIn = 530,
        OpeningData = 150,
        PathnameCreated = 257,
        RestartMarker = 110,
        SendPasswordCommand = 331,
        SendUserCommand = 220,
        ServerWantsSecureSession = 234,
        ServiceNotAvailable = 421,
        ServiceTemporarilyNotAvailable = 120,
        SystemType = 215,
        Undefined = 0,
    }
    public sealed class FtpWebRequest : WebRequest {
        public X509CertificateCollection ClientCertificates { get; set; }
        public override string ConnectionGroupName { get; set; }
        public override long ContentLength { get; set; }
        public long ContentOffset { get; set; }
        public override string ContentType { get; set; }
        public override ICredentials Credentials { get; set; }
        public static new RequestCachePolicy DefaultCachePolicy { get; set; }
        public bool EnableSsl { get; set; }
        public override WebHeaderCollection Headers { get; set; }
        public bool KeepAlive { get; set; }
        public override string Method { get; set; }
        public override bool PreAuthenticate { get; set; }
        public override IWebProxy Proxy { get; set; }
        public int ReadWriteTimeout { get; set; }
        public string RenameTo { get; set; }
        public override Uri RequestUri { get; }
        public ServicePoint ServicePoint { get; }
        public override int Timeout { get; set; }
        public bool UseBinary { get; set; }
        public override bool UseDefaultCredentials { get; set; }
        public bool UsePassive { get; set; }
        public override void Abort();
        public override IAsyncResult BeginGetRequestStream(AsyncCallback callback, object state);
        public override IAsyncResult BeginGetResponse(AsyncCallback callback, object state);
        public override Stream EndGetRequestStream(IAsyncResult asyncResult);
        public override WebResponse EndGetResponse(IAsyncResult asyncResult);
        public override Stream GetRequestStream();
        public override WebResponse GetResponse();
    }
    public class FtpWebResponse : WebResponse, IDisposable {
        public string BannerMessage { get; }
        public override long ContentLength { get; }
        public string ExitMessage { get; }
        public override WebHeaderCollection Headers { get; }
        public DateTime LastModified { get; }
        public override Uri ResponseUri { get; }
        public FtpStatusCode StatusCode { get; }
        public string StatusDescription { get; }
        public override bool SupportsHeaders { get; }
        public string WelcomeMessage { get; }
        public override void Close();
        public override Stream GetResponseStream();
    }
    public class GlobalProxySelection {
        public GlobalProxySelection();
        public static IWebProxy Select { get; set; }
        public static IWebProxy GetEmptyWebProxy();
    }
    public delegate void HttpContinueDelegate(int StatusCode, WebHeaderCollection httpHeaders);
    public sealed class HttpListener : IDisposable {
        public HttpListener();
        public AuthenticationSchemes AuthenticationSchemes { get; set; }
        public AuthenticationSchemeSelector AuthenticationSchemeSelectorDelegate { get; set; }
        public ServiceNameCollection DefaultServiceNames { get; }
        public ExtendedProtectionPolicy ExtendedProtectionPolicy { get; set; }
        public HttpListener.ExtendedProtectionSelector ExtendedProtectionSelectorDelegate { get; set; }
        public bool IgnoreWriteExceptions { get; set; }
        public bool IsListening { get; }
        public static bool IsSupported { get; }
        public HttpListenerPrefixCollection Prefixes { get; }
        public string Realm { get; set; }
        public HttpListenerTimeoutManager TimeoutManager { get; }
        public bool UnsafeConnectionNtlmAuthentication { get; set; }
        public void Abort();
        public IAsyncResult BeginGetContext(AsyncCallback callback, object state);
        public void Close();
        public HttpListenerContext EndGetContext(IAsyncResult asyncResult);
        public HttpListenerContext GetContext();
        public Task<HttpListenerContext> GetContextAsync();
        public void Start();
        public void Stop();
        void System.IDisposable.Dispose();
        public delegate ExtendedProtectionPolicy ExtendedProtectionSelector(HttpListenerRequest request);
    }
    public class HttpListenerBasicIdentity : GenericIdentity {
        public HttpListenerBasicIdentity(string username, string password);
        public virtual string Password { get; }
    }
    public sealed class HttpListenerContext {
        public HttpListenerRequest Request { get; }
        public HttpListenerResponse Response { get; }
        public IPrincipal User { get; }
        public Task<HttpListenerWebSocketContext> AcceptWebSocketAsync(string subProtocol);
        public Task<HttpListenerWebSocketContext> AcceptWebSocketAsync(string subProtocol, int receiveBufferSize, TimeSpan keepAliveInterval);
        public Task<HttpListenerWebSocketContext> AcceptWebSocketAsync(string subProtocol, int receiveBufferSize, TimeSpan keepAliveInterval, ArraySegment<byte> internalBuffer);
        public Task<HttpListenerWebSocketContext> AcceptWebSocketAsync(string subProtocol, TimeSpan keepAliveInterval);
    }
    public class HttpListenerException : Win32Exception {
        public HttpListenerException();
        public HttpListenerException(int errorCode);
        public HttpListenerException(int errorCode, string message);
        protected HttpListenerException(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public override int ErrorCode { get; }
    }
    public class HttpListenerPrefixCollection : ICollection<string>, IEnumerable, IEnumerable<string> {
        public int Count { get; }
        public bool IsReadOnly { get; }
        public bool IsSynchronized { get; }
        public void Add(string uriPrefix);
        public void Clear();
        public bool Contains(string uriPrefix);
        public void CopyTo(Array array, int offset);
        public void CopyTo(string[] array, int offset);
        public IEnumerator<string> GetEnumerator();
        public bool Remove(string uriPrefix);
        IEnumerator System.Collections.IEnumerable.GetEnumerator();
    }
    public sealed class HttpListenerRequest {
        public string[] AcceptTypes { get; }
        public int ClientCertificateError { get; }
        public Encoding ContentEncoding { get; }
        public long ContentLength64 { get; }
        public string ContentType { get; }
        public CookieCollection Cookies { get; }
        public bool HasEntityBody { get; }
        public NameValueCollection Headers { get; }
        public string HttpMethod { get; }
        public Stream InputStream { get; }
        public bool IsAuthenticated { get; }
        public bool IsLocal { get; }
        public bool IsSecureConnection { get; }
        public bool IsWebSocketRequest { get; }
        public bool KeepAlive { get; }
        public IPEndPoint LocalEndPoint { get; }
        public Version ProtocolVersion { get; }
        public NameValueCollection QueryString { get; }
        public string RawUrl { get; }
        public IPEndPoint RemoteEndPoint { get; }
        public Guid RequestTraceIdentifier { get; }
        public string ServiceName { get; }
        public TransportContext TransportContext { get; }
        public Uri Url { get; }
        public Uri UrlReferrer { get; }
        public string UserAgent { get; }
        public string UserHostAddress { get; }
        public string UserHostName { get; }
        public string[] UserLanguages { get; }
        public IAsyncResult BeginGetClientCertificate(AsyncCallback requestCallback, object state);
        public X509Certificate2 EndGetClientCertificate(IAsyncResult asyncResult);
        public X509Certificate2 GetClientCertificate();
        public Task<X509Certificate2> GetClientCertificateAsync();
    }
    public sealed class HttpListenerResponse : IDisposable {
        public Encoding ContentEncoding { get; set; }
        public long ContentLength64 { get; set; }
        public string ContentType { get; set; }
        public CookieCollection Cookies { get; set; }
        public WebHeaderCollection Headers { get; set; }
        public bool KeepAlive { get; set; }
        public Stream OutputStream { get; }
        public Version ProtocolVersion { get; set; }
        public string RedirectLocation { get; set; }
        public bool SendChunked { get; set; }
        public int StatusCode { get; set; }
        public string StatusDescription { get; set; }
        public void Abort();
        public void AddHeader(string name, string value);
        public void AppendCookie(Cookie cookie);
        public void AppendHeader(string name, string value);
        public void Close();
        public void Close(byte[] responseEntity, bool willBlock);
        public void CopyFrom(HttpListenerResponse templateResponse);
        public void Redirect(string url);
        public void SetCookie(Cookie cookie);
        void System.IDisposable.Dispose();
    }
    public class HttpListenerTimeoutManager {
        public TimeSpan DrainEntityBody { get; set; }
        public TimeSpan EntityBody { get; set; }
        public TimeSpan HeaderWait { get; set; }
        public TimeSpan IdleConnection { get; set; }
        public long MinSendBytesPerSecond { get; set; }
        public TimeSpan RequestQueue { get; set; }
    }
    public enum HttpRequestHeader {
        Accept = 20,
        AcceptCharset = 21,
        AcceptEncoding = 22,
        AcceptLanguage = 23,
        Allow = 10,
        Authorization = 24,
        CacheControl = 0,
        Connection = 1,
        ContentEncoding = 13,
        ContentLanguage = 14,
        ContentLength = 11,
        ContentLocation = 15,
        ContentMd5 = 16,
        ContentRange = 17,
        ContentType = 12,
        Cookie = 25,
        Date = 2,
        Expect = 26,
        Expires = 18,
        From = 27,
        Host = 28,
        IfMatch = 29,
        IfModifiedSince = 30,
        IfNoneMatch = 31,
        IfRange = 32,
        IfUnmodifiedSince = 33,
        KeepAlive = 3,
        LastModified = 19,
        MaxForwards = 34,
        Pragma = 4,
        ProxyAuthorization = 35,
        Range = 37,
        Referer = 36,
        Te = 38,
        Trailer = 5,
        TransferEncoding = 6,
        Translate = 39,
        Upgrade = 7,
        UserAgent = 40,
        Via = 8,
        Warning = 9,
    }
    public enum HttpResponseHeader {
        AcceptRanges = 20,
        Age = 21,
        Allow = 10,
        CacheControl = 0,
        Connection = 1,
        ContentEncoding = 13,
        ContentLanguage = 14,
        ContentLength = 11,
        ContentLocation = 15,
        ContentMd5 = 16,
        ContentRange = 17,
        ContentType = 12,
        Date = 2,
        ETag = 22,
        Expires = 18,
        KeepAlive = 3,
        LastModified = 19,
        Location = 23,
        Pragma = 4,
        ProxyAuthenticate = 24,
        RetryAfter = 25,
        Server = 26,
        SetCookie = 27,
        Trailer = 5,
        TransferEncoding = 6,
        Upgrade = 7,
        Vary = 28,
        Via = 8,
        Warning = 9,
        WwwAuthenticate = 29,
    }
    public enum HttpStatusCode {
        Accepted = 202,
        Ambiguous = 300,
        BadGateway = 502,
        BadRequest = 400,
        Conflict = 409,
        Continue = 100,
        Created = 201,
        ExpectationFailed = 417,
        Forbidden = 403,
        Found = 302,
        GatewayTimeout = 504,
        Gone = 410,
        HttpVersionNotSupported = 505,
        InternalServerError = 500,
        LengthRequired = 411,
        MethodNotAllowed = 405,
        Moved = 301,
        MovedPermanently = 301,
        MultipleChoices = 300,
        NoContent = 204,
        NonAuthoritativeInformation = 203,
        NotAcceptable = 406,
        NotFound = 404,
        NotImplemented = 501,
        NotModified = 304,
        OK = 200,
        PartialContent = 206,
        PaymentRequired = 402,
        PreconditionFailed = 412,
        ProxyAuthenticationRequired = 407,
        Redirect = 302,
        RedirectKeepVerb = 307,
        RedirectMethod = 303,
        RequestedRangeNotSatisfiable = 416,
        RequestEntityTooLarge = 413,
        RequestTimeout = 408,
        RequestUriTooLong = 414,
        ResetContent = 205,
        SeeOther = 303,
        ServiceUnavailable = 503,
        SwitchingProtocols = 101,
        TemporaryRedirect = 307,
        Unauthorized = 401,
        UnsupportedMediaType = 415,
        Unused = 306,
        UpgradeRequired = 426,
        UseProxy = 305,
    }
    public static class HttpVersion {
        public static readonly Version Version10;
        public static readonly Version Version11;
    }
    public class HttpWebRequest : WebRequest, ISerializable {
        protected HttpWebRequest(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public string Accept { get; set; }
        public Uri Address { get; }
        public virtual bool AllowAutoRedirect { get; set; }
        public virtual bool AllowReadStreamBuffering { get; set; }
        public virtual bool AllowWriteStreamBuffering { get; set; }
        public DecompressionMethods AutomaticDecompression { get; set; }
        public X509CertificateCollection ClientCertificates { get; set; }
        public string Connection { get; set; }
        public override string ConnectionGroupName { get; set; }
        public override long ContentLength { get; set; }
        public override string ContentType { get; set; }
        public HttpContinueDelegate ContinueDelegate { get; set; }
        public int ContinueTimeout { get; set; }
        public virtual CookieContainer CookieContainer { get; set; }
        public override ICredentials Credentials { get; set; }
        public DateTime Date { get; set; }
        public static new RequestCachePolicy DefaultCachePolicy { get; set; }
        public static int DefaultMaximumErrorResponseLength { get; set; }
        public static int DefaultMaximumResponseHeadersLength { get; set; }
        public string Expect { get; set; }
        public virtual bool HaveResponse { get; }
        public override WebHeaderCollection Headers { get; set; }
        public string Host { get; set; }
        public DateTime IfModifiedSince { get; set; }
        public bool KeepAlive { get; set; }
        public int MaximumAutomaticRedirections { get; set; }
        public int MaximumResponseHeadersLength { get; set; }
        public string MediaType { get; set; }
        public override string Method { get; set; }
        public bool Pipelined { get; set; }
        public override bool PreAuthenticate { get; set; }
        public Version ProtocolVersion { get; set; }
        public override IWebProxy Proxy { get; set; }
        public int ReadWriteTimeout { get; set; }
        public string Referer { get; set; }
        public override Uri RequestUri { get; }
        public bool SendChunked { get; set; }
        public RemoteCertificateValidationCallback ServerCertificateValidationCallback { get; set; }
        public ServicePoint ServicePoint { get; }
        public virtual bool SupportsCookieContainer { get; }
        public override int Timeout { get; set; }
        public string TransferEncoding { get; set; }
        public bool UnsafeAuthenticatedConnectionSharing { get; set; }
        public override bool UseDefaultCredentials { get; set; }
        public string UserAgent { get; set; }
        public override void Abort();
        public void AddRange(int range);
        public void AddRange(int from, int to);
        public void AddRange(long range);
        public void AddRange(long from, long to);
        public void AddRange(string rangeSpecifier, int range);
        public void AddRange(string rangeSpecifier, int from, int to);
        public void AddRange(string rangeSpecifier, long range);
        public void AddRange(string rangeSpecifier, long from, long to);
        public override IAsyncResult BeginGetRequestStream(AsyncCallback callback, object state);
        public override IAsyncResult BeginGetResponse(AsyncCallback callback, object state);
        public override Stream EndGetRequestStream(IAsyncResult asyncResult);
        public Stream EndGetRequestStream(IAsyncResult asyncResult, out TransportContext context);
        public override WebResponse EndGetResponse(IAsyncResult asyncResult);
        protected override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public override Stream GetRequestStream();
        public Stream GetRequestStream(out TransportContext context);
        public override WebResponse GetResponse();
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
    }
    public class HttpWebResponse : WebResponse, ISerializable {
        protected HttpWebResponse(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public string CharacterSet { get; }
        public string ContentEncoding { get; }
        public override long ContentLength { get; }
        public override string ContentType { get; }
        public virtual CookieCollection Cookies { get; set; }
        public override WebHeaderCollection Headers { get; }
        public override bool IsMutuallyAuthenticated { get; }
        public DateTime LastModified { get; }
        public virtual string Method { get; }
        public Version ProtocolVersion { get; }
        public override Uri ResponseUri { get; }
        public string Server { get; }
        public virtual HttpStatusCode StatusCode { get; }
        public virtual string StatusDescription { get; }
        public override bool SupportsHeaders { get; }
        public override void Close();
        protected override void Dispose(bool disposing);
        protected override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public string GetResponseHeader(string headerName);
        public override Stream GetResponseStream();
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
    }
    public interface IAuthenticationModule {
        string AuthenticationType { get; }
        bool CanPreAuthenticate { get; }
        Authorization Authenticate(string challenge, WebRequest request, ICredentials credentials);
        Authorization PreAuthenticate(WebRequest request, ICredentials credentials);
    }
    public interface ICredentialPolicy {
        bool ShouldSendCredential(Uri challengeUri, WebRequest request, NetworkCredential credential, IAuthenticationModule authenticationModule);
    }
    public interface ICredentials {
        NetworkCredential GetCredential(Uri uri, string authType);
    }
    public interface ICredentialsByHost {
        NetworkCredential GetCredential(string host, int port, string authenticationType);
    }
    public class IPAddress {
        public static readonly IPAddress Any;
        public static readonly IPAddress Broadcast;
        public static readonly IPAddress IPv6Any;
        public static readonly IPAddress IPv6Loopback;
        public static readonly IPAddress IPv6None;
        public static readonly IPAddress Loopback;
        public static readonly IPAddress None;
        public IPAddress(byte[] address);
        public IPAddress(byte[] address, long scopeid);
        public IPAddress(long newAddress);
        public long Address { get; set; }
        public AddressFamily AddressFamily { get; }
        public bool IsIPv4MappedToIPv6 { get; }
        public bool IsIPv6LinkLocal { get; }
        public bool IsIPv6Multicast { get; }
        public bool IsIPv6SiteLocal { get; }
        public bool IsIPv6Teredo { get; }
        public long ScopeId { get; set; }
        public override bool Equals(object comparand);
        public byte[] GetAddressBytes();
        public override int GetHashCode();
        public static short HostToNetworkOrder(short host);
        public static int HostToNetworkOrder(int host);
        public static long HostToNetworkOrder(long host);
        public static bool IsLoopback(IPAddress address);
        public IPAddress MapToIPv4();
        public IPAddress MapToIPv6();
        public static short NetworkToHostOrder(short network);
        public static int NetworkToHostOrder(int network);
        public static long NetworkToHostOrder(long network);
        public static IPAddress Parse(string ipString);
        public override string ToString();
        public static bool TryParse(string ipString, out IPAddress address);
    }
    public class IPEndPoint : EndPoint {
        public const int MaxPort = 65535;
        public const int MinPort = 0;
        public IPEndPoint(long address, int port);
        public IPEndPoint(IPAddress address, int port);
        public IPAddress Address { get; set; }
        public override AddressFamily AddressFamily { get; }
        public int Port { get; set; }
        public override EndPoint Create(SocketAddress socketAddress);
        public override bool Equals(object comparand);
        public override int GetHashCode();
        public override SocketAddress Serialize();
        public override string ToString();
    }
    public class IPHostEntry {
        public IPHostEntry();
        public IPAddress[] AddressList { get; set; }
        public string[] Aliases { get; set; }
        public string HostName { get; set; }
    }
    public interface IWebProxy {
        ICredentials Credentials { get; set; }
        Uri GetProxy(Uri destination);
        bool IsBypassed(Uri host);
    }
    public interface IWebProxyScript {
        void Close();
        bool Load(Uri scriptLocation, string script, Type helperType);
        string Run(string url, string host);
    }
    public interface IWebRequestCreate {
        WebRequest Create(Uri uri);
    }
    public class NetworkCredential : ICredentials, ICredentialsByHost {
        public NetworkCredential();
        public NetworkCredential(string userName, SecureString password);
        public NetworkCredential(string userName, SecureString password, string domain);
        public NetworkCredential(string userName, string password);
        public NetworkCredential(string userName, string password, string domain);
        public string Domain { get; set; }
        public string Password { get; set; }
        public SecureString SecurePassword { get; set; }
        public string UserName { get; set; }
        public NetworkCredential GetCredential(string host, int port, string authenticationType);
        public NetworkCredential GetCredential(Uri uri, string authType);
    }
    public class OpenReadCompletedEventArgs : AsyncCompletedEventArgs {
        public Stream Result { get; }
    }
    public delegate void OpenReadCompletedEventHandler(object sender, OpenReadCompletedEventArgs e);
    public class OpenWriteCompletedEventArgs : AsyncCompletedEventArgs {
        public Stream Result { get; }
    }
    public delegate void OpenWriteCompletedEventHandler(object sender, OpenWriteCompletedEventArgs e);
    public class ProtocolViolationException : InvalidOperationException, ISerializable {
        public ProtocolViolationException();
        protected ProtocolViolationException(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public ProtocolViolationException(string message);
        public override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
    }
    public enum SecurityProtocolType {
        Ssl3 = 48,
        Tls = 192,
        Tls11 = 768,
        Tls12 = 3072,
    }
    public class ServicePoint {
        public Uri Address { get; }
        public BindIPEndPoint BindIPEndPointDelegate { get; set; }
        public X509Certificate Certificate { get; }
        public X509Certificate ClientCertificate { get; }
        public int ConnectionLeaseTimeout { get; set; }
        public int ConnectionLimit { get; set; }
        public string ConnectionName { get; }
        public int CurrentConnections { get; }
        public bool Expect100Continue { get; set; }
        public DateTime IdleSince { get; }
        public int MaxIdleTime { get; set; }
        public virtual Version ProtocolVersion { get; }
        public int ReceiveBufferSize { get; set; }
        public bool SupportsPipelining { get; }
        public bool UseNagleAlgorithm { get; set; }
        public bool CloseConnectionGroup(string connectionGroupName);
        public void SetTcpKeepAlive(bool enabled, int keepAliveTime, int keepAliveInterval);
    }
    public class ServicePointManager {
        public const int DefaultNonPersistentConnectionLimit = 4;
        public const int DefaultPersistentConnectionLimit = 2;
        public static bool CheckCertificateRevocationList { get; set; }
        public static int DefaultConnectionLimit { get; set; }
        public static int DnsRefreshTimeout { get; set; }
        public static bool EnableDnsRoundRobin { get; set; }
        public static EncryptionPolicy EncryptionPolicy { get; }
        public static bool Expect100Continue { get; set; }
        public static int MaxServicePointIdleTime { get; set; }
        public static int MaxServicePoints { get; set; }
        public static bool ReusePort { get; set; }
        public static SecurityProtocolType SecurityProtocol { get; set; }
        public static RemoteCertificateValidationCallback ServerCertificateValidationCallback { get; set; }
        public static bool UseNagleAlgorithm { get; set; }
        public static ServicePoint FindServicePoint(string uriString, IWebProxy proxy);
        public static ServicePoint FindServicePoint(Uri address);
        public static ServicePoint FindServicePoint(Uri address, IWebProxy proxy);
        public static void SetTcpKeepAlive(bool enabled, int keepAliveTime, int keepAliveInterval);
    }
    public class SocketAddress {
        public SocketAddress(AddressFamily family);
        public SocketAddress(AddressFamily family, int size);
        public AddressFamily Family { get; }
        public int Size { get; }
        public byte this[int offset] { get; set; }
        public override bool Equals(object comparand);
        public override int GetHashCode();
        public override string ToString();
    }
    public abstract class TransportContext {
        protected TransportContext();
        public abstract ChannelBinding GetChannelBinding(ChannelBindingKind kind);
    }
    public class UploadDataCompletedEventArgs : AsyncCompletedEventArgs {
        public byte[] Result { get; }
    }
    public delegate void UploadDataCompletedEventHandler(object sender, UploadDataCompletedEventArgs e);
    public class UploadFileCompletedEventArgs : AsyncCompletedEventArgs {
        public byte[] Result { get; }
    }
    public delegate void UploadFileCompletedEventHandler(object sender, UploadFileCompletedEventArgs e);
    public class UploadProgressChangedEventArgs : ProgressChangedEventArgs {
        public long BytesReceived { get; }
        public long BytesSent { get; }
        public long TotalBytesToReceive { get; }
        public long TotalBytesToSend { get; }
    }
    public delegate void UploadProgressChangedEventHandler(object sender, UploadProgressChangedEventArgs e);
    public class UploadStringCompletedEventArgs : AsyncCompletedEventArgs {
        public string Result { get; }
    }
    public delegate void UploadStringCompletedEventHandler(object sender, UploadStringCompletedEventArgs e);
    public class UploadValuesCompletedEventArgs : AsyncCompletedEventArgs {
        public byte[] Result { get; }
    }
    public delegate void UploadValuesCompletedEventHandler(object sender, UploadValuesCompletedEventArgs e);
    public class WebClient : Component {
        public WebClient();
        public string BaseAddress { get; set; }
        public RequestCachePolicy CachePolicy { get; set; }
        public ICredentials Credentials { get; set; }
        public Encoding Encoding { get; set; }
        public WebHeaderCollection Headers { get; set; }
        public bool IsBusy { get; }
        public IWebProxy Proxy { get; set; }
        public NameValueCollection QueryString { get; set; }
        public WebHeaderCollection ResponseHeaders { get; }
        public bool UseDefaultCredentials { get; set; }
        public event DownloadDataCompletedEventHandler DownloadDataCompleted;
        public event AsyncCompletedEventHandler DownloadFileCompleted;
        public event DownloadProgressChangedEventHandler DownloadProgressChanged;
        public event DownloadStringCompletedEventHandler DownloadStringCompleted;
        public event OpenReadCompletedEventHandler OpenReadCompleted;
        public event OpenWriteCompletedEventHandler OpenWriteCompleted;
        public event UploadDataCompletedEventHandler UploadDataCompleted;
        public event UploadFileCompletedEventHandler UploadFileCompleted;
        public event UploadProgressChangedEventHandler UploadProgressChanged;
        public event UploadStringCompletedEventHandler UploadStringCompleted;
        public event UploadValuesCompletedEventHandler UploadValuesCompleted;
        public void CancelAsync();
        public byte[] DownloadData(string address);
        public byte[] DownloadData(Uri address);
        public void DownloadDataAsync(Uri address);
        public void DownloadDataAsync(Uri address, object userToken);
        public Task<byte[]> DownloadDataTaskAsync(string address);
        public Task<byte[]> DownloadDataTaskAsync(Uri address);
        public void DownloadFile(string address, string fileName);
        public void DownloadFile(Uri address, string fileName);
        public void DownloadFileAsync(Uri address, string fileName);
        public void DownloadFileAsync(Uri address, string fileName, object userToken);
        public Task DownloadFileTaskAsync(string address, string fileName);
        public Task DownloadFileTaskAsync(Uri address, string fileName);
        public string DownloadString(string address);
        public string DownloadString(Uri address);
        public void DownloadStringAsync(Uri address);
        public void DownloadStringAsync(Uri address, object userToken);
        public Task<string> DownloadStringTaskAsync(string address);
        public Task<string> DownloadStringTaskAsync(Uri address);
        protected virtual WebRequest GetWebRequest(Uri address);
        protected virtual WebResponse GetWebResponse(WebRequest request);
        protected virtual WebResponse GetWebResponse(WebRequest request, IAsyncResult result);
        protected virtual void OnDownloadDataCompleted(DownloadDataCompletedEventArgs e);
        protected virtual void OnDownloadFileCompleted(AsyncCompletedEventArgs e);
        protected virtual void OnDownloadProgressChanged(DownloadProgressChangedEventArgs e);
        protected virtual void OnDownloadStringCompleted(DownloadStringCompletedEventArgs e);
        protected virtual void OnOpenReadCompleted(OpenReadCompletedEventArgs e);
        protected virtual void OnOpenWriteCompleted(OpenWriteCompletedEventArgs e);
        protected virtual void OnUploadDataCompleted(UploadDataCompletedEventArgs e);
        protected virtual void OnUploadFileCompleted(UploadFileCompletedEventArgs e);
        protected virtual void OnUploadProgressChanged(UploadProgressChangedEventArgs e);
        protected virtual void OnUploadStringCompleted(UploadStringCompletedEventArgs e);
        protected virtual void OnUploadValuesCompleted(UploadValuesCompletedEventArgs e);
        public Stream OpenRead(string address);
        public Stream OpenRead(Uri address);
        public void OpenReadAsync(Uri address);
        public void OpenReadAsync(Uri address, object userToken);
        public Task<Stream> OpenReadTaskAsync(string address);
        public Task<Stream> OpenReadTaskAsync(Uri address);
        public Stream OpenWrite(string address);
        public Stream OpenWrite(string address, string method);
        public Stream OpenWrite(Uri address);
        public Stream OpenWrite(Uri address, string method);
        public void OpenWriteAsync(Uri address);
        public void OpenWriteAsync(Uri address, string method);
        public void OpenWriteAsync(Uri address, string method, object userToken);
        public Task<Stream> OpenWriteTaskAsync(string address);
        public Task<Stream> OpenWriteTaskAsync(string address, string method);
        public Task<Stream> OpenWriteTaskAsync(Uri address);
        public Task<Stream> OpenWriteTaskAsync(Uri address, string method);
        public byte[] UploadData(string address, byte[] data);
        public byte[] UploadData(string address, string method, byte[] data);
        public byte[] UploadData(Uri address, byte[] data);
        public byte[] UploadData(Uri address, string method, byte[] data);
        public void UploadDataAsync(Uri address, byte[] data);
        public void UploadDataAsync(Uri address, string method, byte[] data);
        public void UploadDataAsync(Uri address, string method, byte[] data, object userToken);
        public Task<byte[]> UploadDataTaskAsync(string address, byte[] data);
        public Task<byte[]> UploadDataTaskAsync(string address, string method, byte[] data);
        public Task<byte[]> UploadDataTaskAsync(Uri address, byte[] data);
        public Task<byte[]> UploadDataTaskAsync(Uri address, string method, byte[] data);
        public byte[] UploadFile(string address, string fileName);
        public byte[] UploadFile(string address, string method, string fileName);
        public byte[] UploadFile(Uri address, string fileName);
        public byte[] UploadFile(Uri address, string method, string fileName);
        public void UploadFileAsync(Uri address, string fileName);
        public void UploadFileAsync(Uri address, string method, string fileName);
        public void UploadFileAsync(Uri address, string method, string fileName, object userToken);
        public Task<byte[]> UploadFileTaskAsync(string address, string fileName);
        public Task<byte[]> UploadFileTaskAsync(string address, string method, string fileName);
        public Task<byte[]> UploadFileTaskAsync(Uri address, string fileName);
        public Task<byte[]> UploadFileTaskAsync(Uri address, string method, string fileName);
        public string UploadString(string address, string data);
        public string UploadString(string address, string method, string data);
        public string UploadString(Uri address, string data);
        public string UploadString(Uri address, string method, string data);
        public void UploadStringAsync(Uri address, string data);
        public void UploadStringAsync(Uri address, string method, string data);
        public void UploadStringAsync(Uri address, string method, string data, object userToken);
        public Task<string> UploadStringTaskAsync(string address, string data);
        public Task<string> UploadStringTaskAsync(string address, string method, string data);
        public Task<string> UploadStringTaskAsync(Uri address, string data);
        public Task<string> UploadStringTaskAsync(Uri address, string method, string data);
        public byte[] UploadValues(string address, NameValueCollection data);
        public byte[] UploadValues(string address, string method, NameValueCollection data);
        public byte[] UploadValues(Uri address, NameValueCollection data);
        public byte[] UploadValues(Uri address, string method, NameValueCollection data);
        public void UploadValuesAsync(Uri address, NameValueCollection data);
        public void UploadValuesAsync(Uri address, string method, NameValueCollection data);
        public void UploadValuesAsync(Uri address, string method, NameValueCollection data, object userToken);
        public Task<byte[]> UploadValuesTaskAsync(string address, NameValueCollection data);
        public Task<byte[]> UploadValuesTaskAsync(string address, string method, NameValueCollection data);
        public Task<byte[]> UploadValuesTaskAsync(Uri address, NameValueCollection data);
        public Task<byte[]> UploadValuesTaskAsync(Uri address, string method, NameValueCollection data);
    }
    public class WebException : InvalidOperationException, ISerializable {
        public WebException();
        protected WebException(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public WebException(string message);
        public WebException(string message, Exception innerException);
        public WebException(string message, Exception innerException, WebExceptionStatus status, WebResponse response);
        public WebException(string message, WebExceptionStatus status);
        public WebResponse Response { get; }
        public WebExceptionStatus Status { get; }
        public override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
    }
    public enum WebExceptionStatus {
        CacheEntryNotFound = 18,
        ConnectFailure = 2,
        ConnectionClosed = 8,
        KeepAliveFailure = 12,
        MessageLengthLimitExceeded = 17,
        NameResolutionFailure = 1,
        Pending = 13,
        PipelineFailure = 5,
        ProtocolError = 7,
        ProxyNameResolutionFailure = 15,
        ReceiveFailure = 3,
        RequestCanceled = 6,
        RequestProhibitedByCachePolicy = 19,
        RequestProhibitedByProxy = 20,
        SecureChannelFailure = 10,
        SendFailure = 4,
        ServerProtocolViolation = 11,
        Success = 0,
        Timeout = 14,
        TrustFailure = 9,
        UnknownError = 16,
    }
    public class WebHeaderCollection : NameValueCollection, ISerializable {
        public WebHeaderCollection();
        protected WebHeaderCollection(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public override string[] AllKeys { get; }
        public override int Count { get; }
        public override NameObjectCollectionBase.KeysCollection Keys { get; }
        public string this[HttpRequestHeader header] { get; set; }
        public string this[HttpResponseHeader header] { get; set; }
        public void Add(HttpRequestHeader header, string value);
        public void Add(HttpResponseHeader header, string value);
        public void Add(string header);
        public override void Add(string name, string value);
        protected void AddWithoutValidate(string headerName, string headerValue);
        public override void Clear();
        public override string Get(int index);
        public override string Get(string name);
        public override IEnumerator GetEnumerator();
        public override string GetKey(int index);
        public override void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public override string[] GetValues(int index);
        public override string[] GetValues(string header);
        public static bool IsRestricted(string headerName);
        public static bool IsRestricted(string headerName, bool response);
        public override void OnDeserialization(object sender);
        public void Remove(HttpRequestHeader header);
        public void Remove(HttpResponseHeader header);
        public override void Remove(string name);
        public void Set(HttpRequestHeader header, string value);
        public void Set(HttpResponseHeader header, string value);
        public override void Set(string name, string value);
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public byte[] ToByteArray();
        public override string ToString();
    }
    public class WebProxy : ISerializable, IWebProxy {
        public WebProxy();
        protected WebProxy(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public WebProxy(string Address);
        public WebProxy(string Address, bool BypassOnLocal);
        public WebProxy(string Address, bool BypassOnLocal, string[] BypassList);
        public WebProxy(string Address, bool BypassOnLocal, string[] BypassList, ICredentials Credentials);
        public WebProxy(string Host, int Port);
        public WebProxy(Uri Address);
        public WebProxy(Uri Address, bool BypassOnLocal);
        public WebProxy(Uri Address, bool BypassOnLocal, string[] BypassList);
        public WebProxy(Uri Address, bool BypassOnLocal, string[] BypassList, ICredentials Credentials);
        public Uri Address { get; set; }
        public ArrayList BypassArrayList { get; }
        public string[] BypassList { get; set; }
        public bool BypassProxyOnLocal { get; set; }
        public ICredentials Credentials { get; set; }
        public bool UseDefaultCredentials { get; set; }
        public static WebProxy GetDefaultProxy();
        protected virtual void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public Uri GetProxy(Uri destination);
        public bool IsBypassed(Uri host);
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
    }
    public abstract class WebRequest : MarshalByRefObject, ISerializable {
        protected WebRequest();
        protected WebRequest(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public AuthenticationLevel AuthenticationLevel { get; set; }
        public virtual RequestCachePolicy CachePolicy { get; set; }
        public virtual string ConnectionGroupName { get; set; }
        public virtual long ContentLength { get; set; }
        public virtual string ContentType { get; set; }
        public virtual ICredentials Credentials { get; set; }
        public static RequestCachePolicy DefaultCachePolicy { get; set; }
        public static IWebProxy DefaultWebProxy { get; set; }
        public virtual WebHeaderCollection Headers { get; set; }
        public TokenImpersonationLevel ImpersonationLevel { get; set; }
        public virtual string Method { get; set; }
        public virtual bool PreAuthenticate { get; set; }
        public virtual IWebProxy Proxy { get; set; }
        public virtual Uri RequestUri { get; }
        public virtual int Timeout { get; set; }
        public virtual bool UseDefaultCredentials { get; set; }
        public virtual void Abort();
        public virtual IAsyncResult BeginGetRequestStream(AsyncCallback callback, object state);
        public virtual IAsyncResult BeginGetResponse(AsyncCallback callback, object state);
        public static WebRequest Create(string requestUriString);
        public static WebRequest Create(Uri requestUri);
        public static WebRequest CreateDefault(Uri requestUri);
        public static HttpWebRequest CreateHttp(string requestUriString);
        public static HttpWebRequest CreateHttp(Uri requestUri);
        public virtual Stream EndGetRequestStream(IAsyncResult asyncResult);
        public virtual WebResponse EndGetResponse(IAsyncResult asyncResult);
        protected virtual void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public virtual Stream GetRequestStream();
        public virtual Task<Stream> GetRequestStreamAsync();
        public virtual WebResponse GetResponse();
        public virtual Task<WebResponse> GetResponseAsync();
        public static IWebProxy GetSystemWebProxy();
        public static bool RegisterPrefix(string prefix, IWebRequestCreate creator);
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
    }
    public static class WebRequestMethods {
        public static class File {
            public const string DownloadFile = "GET";
            public const string UploadFile = "PUT";
        }
        public static class Ftp {
            public const string AppendFile = "APPE";
            public const string DeleteFile = "DELE";
            public const string DownloadFile = "RETR";
            public const string GetDateTimestamp = "MDTM";
            public const string GetFileSize = "SIZE";
            public const string ListDirectory = "NLST";
            public const string ListDirectoryDetails = "LIST";
            public const string MakeDirectory = "MKD";
            public const string PrintWorkingDirectory = "PWD";
            public const string RemoveDirectory = "RMD";
            public const string Rename = "RENAME";
            public const string UploadFile = "STOR";
            public const string UploadFileWithUniqueName = "STOU";
        }
        public static class Http {
            public const string Connect = "CONNECT";
            public const string Get = "GET";
            public const string Head = "HEAD";
            public const string MkCol = "MKCOL";
            public const string Post = "POST";
            public const string Put = "PUT";
        }
    }
    public abstract class WebResponse : MarshalByRefObject, IDisposable, ISerializable {
        protected WebResponse();
        protected WebResponse(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public virtual long ContentLength { get; set; }
        public virtual string ContentType { get; set; }
        public virtual WebHeaderCollection Headers { get; }
        public virtual bool IsFromCache { get; }
        public virtual bool IsMutuallyAuthenticated { get; }
        public virtual Uri ResponseUri { get; }
        public virtual bool SupportsHeaders { get; }
        public virtual void Close();
        public void Dispose();
        protected virtual void Dispose(bool disposing);
        protected virtual void GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
        public virtual Stream GetResponseStream();
        void System.Runtime.Serialization.ISerializable.GetObjectData(SerializationInfo serializationInfo, StreamingContext streamingContext);
    }
    public static class WebUtility {
        public static string HtmlDecode(string value);
        public static void HtmlDecode(string value, TextWriter output);
        public static string HtmlEncode(string value);
        public static void HtmlEncode(string value, TextWriter output);
        public static string UrlDecode(string encodedValue);
        public static byte[] UrlDecodeToBytes(byte[] encodedValue, int offset, int count);
        public static string UrlEncode(string value);
        public static byte[] UrlEncodeToBytes(byte[] value, int offset, int count);
    }
}
namespace System.Net.Cache {
    public enum HttpCacheAgeControl {
        MaxAge = 2,
        MaxAgeAndMaxStale = 6,
        MaxAgeAndMinFresh = 3,
        MaxStale = 4,
        MinFresh = 1,
        None = 0,
    }
    public enum HttpRequestCacheLevel {
        BypassCache = 1,
        CacheIfAvailable = 3,
        CacheOnly = 2,
        CacheOrNextCacheOnly = 7,
        Default = 0,
        NoCacheNoStore = 6,
        Refresh = 8,
        Reload = 5,
        Revalidate = 4,
    }
    public class HttpRequestCachePolicy : RequestCachePolicy {
        public HttpRequestCachePolicy();
        public HttpRequestCachePolicy(DateTime cacheSyncDate);
        public HttpRequestCachePolicy(HttpCacheAgeControl cacheAgeControl, TimeSpan ageOrFreshOrStale);
        public HttpRequestCachePolicy(HttpCacheAgeControl cacheAgeControl, TimeSpan maxAge, TimeSpan freshOrStale);
        public HttpRequestCachePolicy(HttpCacheAgeControl cacheAgeControl, TimeSpan maxAge, TimeSpan freshOrStale, DateTime cacheSyncDate);
        public HttpRequestCachePolicy(HttpRequestCacheLevel level);
        public DateTime CacheSyncDate { get; }
        public new HttpRequestCacheLevel Level { get; }
        public TimeSpan MaxAge { get; }
        public TimeSp