# System.Reflection.Metadata.Ecma335

``` diff
+namespace System.Reflection.Metadata.Ecma335 {
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ArrayShapeEncoder {
+        public ArrayShapeEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public void Shape(int rank, ImmutableArray<int> sizes, ImmutableArray<int> lowerBounds);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct BlobEncoder {
+        public BlobEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public void CustomAttributeSignature(Action<FixedArgumentsEncoder> fixedArguments, Action<CustomAttributeNamedArgumentsEncoder> namedArguments);
+        public void CustomAttributeSignature(out FixedArgumentsEncoder fixedArguments, out CustomAttributeNamedArgumentsEncoder namedArguments);
+        public SignatureTypeEncoder FieldSignature();
+        public LocalVariablesEncoder LocalVariableSignature(int variableCount);
+        public MethodSignatureEncoder MethodSignature(SignatureCallingConvention convention=(SignatureCallingConvention)(0), int genericParameterCount=0, bool isInstanceMethod=false);
+        public GenericTypeArgumentsEncoder MethodSpecificationSignature(int genericArgumentCount);
+        public NamedArgumentsEncoder PermissionSetArguments(int argumentCount);
+        public PermissionSetEncoder PermissionSetBlob(int attributeCount);
+        public MethodSignatureEncoder PropertySignature(bool isInstanceProperty=false);
+        public SignatureTypeEncoder TypeSpecificationSignature();
+    }
+    public static class CodedIndex {
+        public static int CustomAttributeType(EntityHandle handle);
+        public static int HasConstant(EntityHandle handle);
+        public static int HasCustomAttribute(EntityHandle handle);
+        public static int HasCustomDebugInformation(EntityHandle handle);
+        public static int HasDeclSecurity(EntityHandle handle);
+        public static int HasFieldMarshal(EntityHandle handle);
+        public static int HasSemantics(EntityHandle handle);
+        public static int Implementation(EntityHandle handle);
+        public static int MemberForwarded(EntityHandle handle);
+        public static int MemberRefParent(EntityHandle handle);
+        public static int MethodDefOrRef(EntityHandle handle);
+        public static int ResolutionScope(EntityHandle handle);
+        public static int TypeDefOrRef(EntityHandle handle);
+        public static int TypeDefOrRefOrSpec(EntityHandle handle);
+        public static int TypeOrMethodDef(EntityHandle handle);
+    }
+    public sealed class ControlFlowBuilder {
+        public ControlFlowBuilder();
+        public void AddCatchRegion(LabelHandle tryStart, LabelHandle tryEnd, LabelHandle handlerStart, LabelHandle handlerEnd, EntityHandle catchType);
+        public void AddFaultRegion(LabelHandle tryStart, LabelHandle tryEnd, LabelHandle handlerStart, LabelHandle handlerEnd);
+        public void AddFilterRegion(LabelHandle tryStart, LabelHandle tryEnd, LabelHandle handlerStart, LabelHandle handlerEnd, LabelHandle filterStart);
+        public void AddFinallyRegion(LabelHandle tryStart, LabelHandle tryEnd, LabelHandle handlerStart, LabelHandle handlerEnd);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct CustomAttributeArrayTypeEncoder {
+        public CustomAttributeArrayTypeEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public CustomAttributeElementTypeEncoder ElementType();
+        public void ObjectArray();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct CustomAttributeElementTypeEncoder {
+        public CustomAttributeElementTypeEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public void Boolean();
+        public void Byte();
+        public void Char();
+        public void Double();
+        public void Enum(string enumTypeName);
+        public void Int16();
+        public void Int32();
+        public void Int64();
+        public void PrimitiveType(PrimitiveSerializationTypeCode type);
+        public void SByte();
+        public void Single();
+        public void String();
+        public void SystemType();
+        public void UInt16();
+        public void UInt32();
+        public void UInt64();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct CustomAttributeNamedArgumentsEncoder {
+        public CustomAttributeNamedArgumentsEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public NamedArgumentsEncoder Count(int count);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct CustomModifiersEncoder {
+        public CustomModifiersEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public CustomModifiersEncoder AddModifier(EntityHandle type, bool isOptional);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct EditAndContinueLogEntry : IEquatable<EditAndContinueLogEntry> {
+        public EditAndContinueLogEntry(EntityHandle handle, EditAndContinueOperation operation);
+        public EntityHandle Handle { get; }
+        public EditAndContinueOperation Operation { get; }
+        public override bool Equals(object obj);
+        public bool Equals(EditAndContinueLogEntry other);
+        public override int GetHashCode();
+    }
+    public enum EditAndContinueOperation {
+        AddEvent = 5,
+        AddField = 2,
+        AddMethod = 1,
+        AddParameter = 3,
+        AddProperty = 4,
+        Default = 0,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ExceptionRegionEncoder {
+        public BlobBuilder Builder { get; }
+        public bool HasSmallFormat { get; }
+        public ExceptionRegionEncoder Add(ExceptionRegionKind kind, int tryOffset, int tryLength, int handlerOffset, int handlerLength, EntityHandle catchType=default(EntityHandle), int filterOffset=0);
+        public ExceptionRegionEncoder AddCatch(int tryOffset, int tryLength, int handlerOffset, int handlerLength, EntityHandle catchType);
+        public ExceptionRegionEncoder AddFault(int tryOffset, int tryLength, int handlerOffset, int handlerLength);
+        public ExceptionRegionEncoder AddFilter(int tryOffset, int tryLength, int handlerOffset, int handlerLength, int filterOffset);
+        public ExceptionRegionEncoder AddFinally(int tryOffset, int tryLength, int handlerOffset, int handlerLength);
+        public static bool IsSmallExceptionRegion(int startOffset, int length);
+        public static bool IsSmallRegionCount(int exceptionRegionCount);
+    }
+    public static class ExportedTypeExtensions {
+        public static int GetTypeDefinitionId(this ExportedType exportedType);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct FixedArgumentsEncoder {
+        public FixedArgumentsEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public LiteralEncoder AddArgument();
+    }
+    public enum FunctionPointerAttributes {
+        HasExplicitThis = 96,
+        HasThis = 32,
+        None = 0,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct GenericTypeArgumentsEncoder {
+        public GenericTypeArgumentsEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public SignatureTypeEncoder AddArgument();
+    }
+    public enum HeapIndex {
+        Blob = 2,
+        Guid = 3,
+        String = 1,
+        UserString = 0,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct InstructionEncoder {
+        public InstructionEncoder(BlobBuilder codeBuilder, ControlFlowBuilder controlFlowBuilder=null);
+        public BlobBuilder CodeBuilder { get; }
+        public ControlFlowBuilder ControlFlowBuilder { get; }
+        public int Offset { get; }
+        public void Branch(ILOpCode code, LabelHandle label);
+        public void Call(EntityHandle methodHandle);
+        public void Call(MemberReferenceHandle methodHandle);
+        public void Call(MethodDefinitionHandle methodHandle);
+        public void Call(MethodSpecificationHandle methodHandle);
+        public void CallIndirect(StandaloneSignatureHandle signature);
+        public LabelHandle DefineLabel();
+        public void LoadArgument(int argumentIndex);
+        public void LoadArgumentAddress(int argumentIndex);
+        public void LoadConstantI4(int value);
+        public void LoadConstantI8(long value);
+        public void LoadConstantR4(float value);
+        public void LoadConstantR8(double value);
+        public void LoadLocal(int slotIndex);
+        public void LoadLocalAddress(int slotIndex);
+        public void LoadString(UserStringHandle handle);
+        public void MarkLabel(LabelHandle label);
+        public void OpCode(ILOpCode code);
+        public void StoreArgument(int argumentIndex);
+        public void StoreLocal(int slotIndex);
+        public void Token(int token);
+        public void Token(EntityHandle handle);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct LabelHandle : IEquatable<LabelHandle> {
+        public int Id { get; }
+        public bool IsNil { get; }
+        public override bool Equals(object obj);
+        public bool Equals(LabelHandle other);
+        public override int GetHashCode();
+        public static bool operator ==(LabelHandle left, LabelHandle right);
+        public static bool operator !=(LabelHandle left, LabelHandle right);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct LiteralEncoder {
+        public LiteralEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public ScalarEncoder Scalar();
+        public void TaggedScalar(Action<CustomAttributeElementTypeEncoder> type, Action<ScalarEncoder> scalar);
+        public void TaggedScalar(out CustomAttributeElementTypeEncoder type, out ScalarEncoder scalar);
+        public void TaggedVector(Action<CustomAttributeArrayTypeEncoder> arrayType, Action<VectorEncoder> vector);
+        public void TaggedVector(out CustomAttributeArrayTypeEncoder arrayType, out VectorEncoder vector);
+        public VectorEncoder Vector();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct LiteralsEncoder {
+        public LiteralsEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public LiteralEncoder AddLiteral();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct LocalVariablesEncoder {
+        public LocalVariablesEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public LocalVariableTypeEncoder AddVariable();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct LocalVariableTypeEncoder {
+        public LocalVariableTypeEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public CustomModifiersEncoder CustomModifiers();
+        public SignatureTypeEncoder Type(bool isByRef=false, bool isPinned=false);
+        public void TypedReference();
+    }
+    public sealed class MetadataAggregator {
+        public MetadataAggregator(IReadOnlyList<int> baseTableRowCounts, IReadOnlyList<int> baseHeapSizes, IReadOnlyList<MetadataReader> deltaReaders);
+        public MetadataAggregator(MetadataReader baseReader, IReadOnlyList<MetadataReader> deltaReaders);
+        public Handle GetGenerationHandle(Handle handle, out int generation);
+    }
+    public sealed class MetadataBuilder {
+        public MetadataBuilder(int userStringHeapStartOffset=0, int stringHeapStartOffset=0, int blobHeapStartOffset=0, int guidHeapStartOffset=0);
+        public AssemblyDefinitionHandle AddAssembly(StringHandle name, Version version, StringHandle culture, BlobHandle publicKey, AssemblyFlags flags, AssemblyHashAlgorithm hashAlgorithm);
+        public AssemblyFileHandle AddAssemblyFile(StringHandle name, BlobHandle hashValue, bool containsMetadata);
+        public AssemblyReferenceHandle AddAssemblyReference(StringHandle name, Version version, StringHandle culture, BlobHandle publicKeyOrToken, AssemblyFlags flags, BlobHandle hashValue);
+        public ConstantHandle AddConstant(EntityHandle parent, object value);
+        public CustomAttributeHandle AddCustomAttribute(EntityHandle parent, EntityHandle constructor, BlobHandle value);
+        public CustomDebugInformationHandle AddCustomDebugInformation(EntityHandle parent, GuidHandle kind, BlobHandle value);
+        public DeclarativeSecurityAttributeHandle AddDeclarativeSecurityAttribute(EntityHandle parent, DeclarativeSecurityAction action, BlobHandle permissionSet);
+        public DocumentHandle AddDocument(BlobHandle name, GuidHandle hashAlgorithm, BlobHandle hash, GuidHandle language);
+        public void AddEncLogEntry(EntityHandle entity, EditAndContinueOperation code);
+        public void AddEncMapEntry(EntityHandle entity);
+        public EventDefinitionHandle AddEvent(EventAttributes attributes, StringHandle name, EntityHandle type);
+        public void AddEventMap(TypeDefinitionHandle declaringType, EventDefinitionHandle eventList);
+        public ExportedTypeHandle AddExportedType(TypeAttributes attributes, StringHandle @namespace, StringHandle name, EntityHandle implementation, int typeDefinitionId);
+        public FieldDefinitionHandle AddFieldDefinition(FieldAttributes attributes, StringHandle name, BlobHandle signature);
+        public void AddFieldLayout(FieldDefinitionHandle field, int offset);
+        public void AddFieldRelativeVirtualAddress(FieldDefinitionHandle field, int offset);
+        public GenericParameterHandle AddGenericParameter(EntityHandle parent, GenericParameterAttributes attributes, StringHandle name, int index);
+        public GenericParameterConstraintHandle AddGenericParameterConstraint(GenericParameterHandle genericParameter, EntityHandle constraint);
+        public ImportScopeHandle AddImportScope(ImportScopeHandle parentScope, BlobHandle imports);
+        public InterfaceImplementationHandle AddInterfaceImplementation(TypeDefinitionHandle type, EntityHandle implementedInterface);
+        public LocalConstantHandle AddLocalConstant(StringHandle name, BlobHandle signature);
+        public LocalScopeHandle AddLocalScope(MethodDefinitionHandle method, ImportScopeHandle importScope, LocalVariableHandle variableList, LocalConstantHandle constantList, int startOffset, int length);
+        public LocalVariableHandle AddLocalVariable(LocalVariableAttributes attributes, int index, StringHandle name);
+        public ManifestResourceHandle AddManifestResource(ManifestResourceAttributes attributes, StringHandle name, EntityHandle implementation, uint offset);
+        public void AddMarshallingDescriptor(EntityHandle parent, BlobHandle descriptor);
+        public MemberReferenceHandle AddMemberReference(EntityHandle parent, StringHandle name, BlobHandle signature);
+        public MethodDebugInformationHandle AddMethodDebugInformation(DocumentHandle document, BlobHandle sequencePoints);
+        public MethodDefinitionHandle AddMethodDefinition(MethodAttributes attributes, MethodImplAttributes implAttributes, StringHandle name, BlobHandle signature, int bodyOffset, ParameterHandle parameterList);
+        public MethodImplementationHandle AddMethodImplementation(TypeDefinitionHandle type, EntityHandle methodBody, EntityHandle methodDeclaration);
+        public void AddMethodImport(MethodDefinitionHandle method, MethodImportAttributes attributes, StringHandle name, ModuleReferenceHandle module);
+        public void AddMethodSemantics(EntityHandle association, MethodSemanticsAttributes semantics, MethodDefinitionHandle methodDefinition);
+        public MethodSpecificationHandle AddMethodSpecification(EntityHandle method, BlobHandle instantiation);
+        public ModuleDefinitionHandle AddModule(int generation, StringHandle moduleName, GuidHandle mvid, GuidHandle encId, GuidHandle encBaseId);
+        public ModuleReferenceHandle AddModuleReference(StringHandle moduleName);
+        public void AddNestedType(TypeDefinitionHandle type, TypeDefinitionHandle enclosingType);
+        public ParameterHandle AddParameter(ParameterAttributes attributes, StringHandle name, int sequenceNumber);
+        public PropertyDefinitionHandle AddProperty(PropertyAttributes attributes, StringHandle name, BlobHandle signature);
+        public void AddPropertyMap(TypeDefinitionHandle declaringType, PropertyDefinitionHandle propertyList);
+        public StandaloneSignatureHandle AddStandaloneSignature(BlobHandle signature);
+        public void AddStateMachineMethod(MethodDefinitionHandle moveNextMethod, MethodDefinitionHandle kickoffMethod);
+        public TypeDefinitionHandle AddTypeDefinition(TypeAttributes attributes, StringHandle @namespace, StringHandle name, EntityHandle baseType, FieldDefinitionHandle fieldList, MethodDefinitionHandle methodList);
+        public void AddTypeLayout(TypeDefinitionHandle type, ushort packingSize, uint size);
+        public TypeReferenceHandle AddTypeReference(EntityHandle resolutionScope, StringHandle @namespace, StringHandle name);
+        public TypeSpecificationHandle AddTypeSpecification(BlobHandle signature);
+        public BlobHandle GetOrAddBlob(byte[] value);
+        public BlobHandle GetOrAddBlob(ImmutableArray<byte> value);
+        public BlobHandle GetOrAddBlob(BlobBuilder value);
+        public BlobHandle GetOrAddBlobUTF16(string value);
+        public BlobHandle GetOrAddBlobUTF8(string value, bool allowUnpairedSurrogates=true);
+        public BlobHandle GetOrAddConstantBlob(object value);
+        public BlobHandle GetOrAddDocumentName(string value);
+        public GuidHandle GetOrAddGuid(Guid guid);
+        public StringHandle GetOrAddString(string value);
+        public UserStringHandle GetOrAddUserString(string value);
+        public int GetRowCount(TableIndex table);
+        public ImmutableArray<int> GetRowCounts();
+        public ReservedBlob<GuidHandle> ReserveGuid();
+        public ReservedBlob<UserStringHandle> ReserveUserString(int length);
+        public void SetCapacity(HeapIndex heap, int byteCount);
+        public void SetCapacity(TableIndex table, int rowCount);
+    }
+    public static class MetadataReaderExtensions {
+        public static IEnumerable<EditAndContinueLogEntry> GetEditAndContinueLogEntries(this MetadataReader reader);
+        public static IEnumerable<EntityHandle> GetEditAndContinueMapEntries(this MetadataReader reader);
+        public static int GetHeapMetadataOffset(this MetadataReader reader, HeapIndex heapIndex);
+        public static int GetHeapSize(this MetadataReader reader, HeapIndex heapIndex);
+        public static BlobHandle GetNextHandle(this MetadataReader reader, BlobHandle handle);
+        public static StringHandle GetNextHandle(this MetadataReader reader, StringHandle handle);
+        public static UserStringHandle GetNextHandle(this MetadataReader reader, UserStringHandle handle);
+        public static int GetTableMetadataOffset(this MetadataReader reader, TableIndex tableIndex);
+        public static int GetTableRowCount(this MetadataReader reader, TableIndex tableIndex);
+        public static int GetTableRowSize(this MetadataReader reader, TableIndex tableIndex);
+        public static IEnumerable<TypeDefinitionHandle> GetTypesWithEvents(this MetadataReader reader);
+        public static IEnumerable<TypeDefinitionHandle> GetTypesWithProperties(this MetadataReader reader);
+        public static SignatureTypeKind ResolveSignatureTypeKind(this MetadataReader reader, EntityHandle typeHandle, byte rawTypeKind);
+    }
+    public sealed class MetadataRootBuilder {
+        public MetadataRootBuilder(MetadataBuilder tablesAndHeaps, string metadataVersion=null, bool suppressValidation=false);
+        public string MetadataVersion { get; }
+        public MetadataSizes Sizes { get; }
+        public bool SuppressValidation { get; }
+        public void Serialize(BlobBuilder builder, int methodBodyStreamRva, int mappedFieldDataStreamRva);
+    }
+    public sealed class MetadataSizes {
+        public ImmutableArray<int> ExternalRowCounts { get; }
+        public ImmutableArray<int> HeapSizes { get; }
+        public ImmutableArray<int> RowCounts { get; }
+        public int GetAlignedHeapSize(HeapIndex index);
+    }
+    public static class MetadataTokens {
+        public static readonly int HeapCount;
+        public static readonly int TableCount;
+        public static AssemblyFileHandle AssemblyFileHandle(int rowNumber);
+        public static AssemblyReferenceHandle AssemblyReferenceHandle(int rowNumber);
+        public static BlobHandle BlobHandle(int offset);
+        public static ConstantHandle ConstantHandle(int rowNumber);
+        public static CustomAttributeHandle CustomAttributeHandle(int rowNumber);
+        public static CustomDebugInformationHandle CustomDebugInformationHandle(int rowNumber);
+        public static DeclarativeSecurityAttributeHandle DeclarativeSecurityAttributeHandle(int rowNumber);
+        public static DocumentHandle DocumentHandle(int rowNumber);
+        public static DocumentNameBlobHandle DocumentNameBlobHandle(int offset);
+        public static EntityHandle EntityHandle(int token);
+        public static EntityHandle EntityHandle(TableIndex tableIndex, int rowNumber);
+        public static EventDefinitionHandle EventDefinitionHandle(int rowNumber);
+        public static ExportedTypeHandle ExportedTypeHandle(int rowNumber);
+        public static FieldDefinitionHandle FieldDefinitionHandle(int rowNumber);
+        public static GenericParameterConstraintHandle GenericParameterConstraintHandle(int rowNumber);
+        public static GenericParameterHandle GenericParameterHandle(int rowNumber);
+        public static int GetHeapOffset(BlobHandle handle);
+        public static int GetHeapOffset(GuidHandle handle);
+        public static int GetHeapOffset(Handle handle);
+        public static int GetHeapOffset(this MetadataReader reader, Handle handle);
+        public static int GetHeapOffset(StringHandle handle);
+        public static int GetHeapOffset(UserStringHandle handle);
+        public static int GetRowNumber(EntityHandle handle);
+        public static int GetRowNumber(this MetadataReader reader, EntityHandle handle);
+        public static int GetToken(EntityHandle handle);
+        public static int GetToken(Handle handle);
+        public static int GetToken(this MetadataReader reader, EntityHandle handle);
+        public static int GetToken(this MetadataReader reader, Handle handle);
+        public static GuidHandle GuidHandle(int offset);
+        public static Handle Handle(int token);
+        public static EntityHandle Handle(TableIndex tableIndex, int rowNumber);
+        public static ImportScopeHandle ImportScopeHandle(int rowNumber);
+        public static InterfaceImplementationHandle InterfaceImplementationHandle(int rowNumber);
+        public static LocalConstantHandle LocalConstantHandle(int rowNumber);
+        public static LocalScopeHandle LocalScopeHandle(int rowNumber);
+        public static LocalVariableHandle LocalVariableHandle(int rowNumber);
+        public static ManifestResourceHandle ManifestResourceHandle(int rowNumber);
+        public static MemberReferenceHandle MemberReferenceHandle(int rowNumber);
+        public static MethodDebugInformationHandle MethodDebugInformationHandle(int rowNumber);
+        public static MethodDefinitionHandle MethodDefinitionHandle(int rowNumber);
+        public static MethodImplementationHandle MethodImplementationHandle(int rowNumber);
+        public static MethodSpecificationHandle MethodSpecificationHandle(int rowNumber);
+        public static ModuleReferenceHandle ModuleReferenceHandle(int rowNumber);
+        public static ParameterHandle ParameterHandle(int rowNumber);
+        public static PropertyDefinitionHandle PropertyDefinitionHandle(int rowNumber);
+        public static StandaloneSignatureHandle StandaloneSignatureHandle(int rowNumber);
+        public static StringHandle StringHandle(int offset);
+        public static bool TryGetHeapIndex(HandleKind type, out HeapIndex index);
+        public static bool TryGetTableIndex(HandleKind type, out TableIndex index);
+        public static TypeDefinitionHandle TypeDefinitionHandle(int rowNumber);
+        public static TypeReferenceHandle TypeReferenceHandle(int rowNumber);
+        public static TypeSpecificationHandle TypeSpecificationHandle(int rowNumber);
+        public static UserStringHandle UserStringHandle(int offset);
+    }
+    public enum MethodBodyAttributes {
+        InitLocals = 1,
+        None = 0,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct MethodBodyStreamEncoder {
+        public MethodBodyStreamEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public MethodBodyStreamEncoder.MethodBody AddMethodBody(int codeSize, int maxStack=8, int exceptionRegionCount=0, bool hasSmallExceptionRegions=true, StandaloneSignatureHandle localVariablesSignature=default(StandaloneSignatureHandle), MethodBodyAttributes attributes=(MethodBodyAttributes)(1));
+        public int AddMethodBody(InstructionEncoder instructionEncoder, int maxStack=8, StandaloneSignatureHandle localVariablesSignature=default(StandaloneSignatureHandle), MethodBodyAttributes attributes=(MethodBodyAttributes)(1));
+        [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+        public struct MethodBody {
+            public ExceptionRegionEncoder ExceptionRegions { get; }
+            public Blob Instructions { get; }
+            public int Offset { get; }
+        }
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct MethodSignatureEncoder {
+        public MethodSignatureEncoder(BlobBuilder builder, bool hasVarArgs);
+        public BlobBuilder Builder { get; }
+        public bool HasVarArgs { get; }
+        public void Parameters(int parameterCount, Action<ReturnTypeEncoder> returnType, Action<ParametersEncoder> parameters);
+        public void Parameters(int parameterCount, out ReturnTypeEncoder returnType, out ParametersEncoder parameters);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct NamedArgumentsEncoder {
+        public NamedArgumentsEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public void AddArgument(bool isField, Action<NamedArgumentTypeEncoder> type, Action<NameEncoder> name, Action<LiteralEncoder> literal);
+        public void AddArgument(bool isField, out NamedArgumentTypeEncoder type, out NameEncoder name, out LiteralEncoder literal);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct NamedArgumentTypeEncoder {
+        public NamedArgumentTypeEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public void Object();
+        public CustomAttributeElementTypeEncoder ScalarType();
+        public CustomAttributeArrayTypeEncoder SZArray();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct NameEncoder {
+        public NameEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public void Name(string name);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ParametersEncoder {
+        public ParametersEncoder(BlobBuilder builder, bool hasVarArgs=false);
+        public BlobBuilder Builder { get; }
+        public bool HasVarArgs { get; }
+        public ParameterTypeEncoder AddParameter();
+        public ParametersEncoder StartVarArgs();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ParameterTypeEncoder {
+        public ParameterTypeEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public CustomModifiersEncoder CustomModifiers();
+        public SignatureTypeEncoder Type(bool isByRef=false);
+        public void TypedReference();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct PermissionSetEncoder {
+        public PermissionSetEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public PermissionSetEncoder AddPermission(string typeName, ImmutableArray<byte> encodedArguments);
+        public PermissionSetEncoder AddPermission(string typeName, BlobBuilder encodedArguments);
+    }
+    public sealed class PortablePdbBuilder {
+        public PortablePdbBuilder(MetadataBuilder tablesAndHeaps, ImmutableArray<int> typeSystemRowCounts, MethodDefinitionHandle entryPoint, Func<IEnumerable<Blob>, BlobContentId> idProvider=null);
+        public ushort FormatVersion { get; }
+        public Func<IEnumerable<Blob>, BlobContentId> IdProvider { get; }
+        public string MetadataVersion { get; }
+        public BlobContentId Serialize(BlobBuilder builder);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ReturnTypeEncoder {
+        public ReturnTypeEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public CustomModifiersEncoder CustomModifiers();
+        public SignatureTypeEncoder Type(bool isByRef=false);
+        public void TypedReference();
+        public void Void();
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct ScalarEncoder {
+        public ScalarEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public void Constant(object value);
+        public void NullArray();
+        public void SystemType(string serializedTypeName);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SignatureDecoder<TType, TGenericContext> {
+        public SignatureDecoder(ISignatureTypeProvider<TType, TGenericContext> provider, MetadataReader metadataReader, TGenericContext genericContext);
+        public TType DecodeFieldSignature(ref BlobReader blobReader);
+        public ImmutableArray<TType> DecodeLocalSignature(ref BlobReader blobReader);
+        public MethodSignature<TType> DecodeMethodSignature(ref BlobReader blobReader);
+        public ImmutableArray<TType> DecodeMethodSpecificationSignature(ref BlobReader blobReader);
+        public TType DecodeType(ref BlobReader blobReader, bool allowTypeSpecifications=false);
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct SignatureTypeEncoder {
+        public SignatureTypeEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public void Array(Action<SignatureTypeEncoder> elementType, Action<ArrayShapeEncoder> arrayShape);
+        public void Array(out SignatureTypeEncoder elementType, out ArrayShapeEncoder arrayShape);
+        public void Boolean();
+        public void Byte();
+        public void Char();
+        public CustomModifiersEncoder CustomModifiers();
+        public void Double();
+        public MethodSignatureEncoder FunctionPointer(SignatureCallingConvention convention=(SignatureCallingConvention)(0), FunctionPointerAttributes attributes=(FunctionPointerAttributes)(0), int genericParameterCount=0);
+        public GenericTypeArgumentsEncoder GenericInstantiation(EntityHandle genericType, int genericArgumentCount, bool isValueType);
+        public void GenericMethodTypeParameter(int parameterIndex);
+        public void GenericTypeParameter(int parameterIndex);
+        public void Int16();
+        public void Int32();
+        public void Int64();
+        public void IntPtr();
+        public void Object();
+        public SignatureTypeEncoder Pointer();
+        public void PrimitiveType(PrimitiveTypeCode type);
+        public void SByte();
+        public void Single();
+        public void String();
+        public SignatureTypeEncoder SZArray();
+        public void Type(EntityHandle type, bool isValueType);
+        public void UInt16();
+        public void UInt32();
+        public void UInt64();
+        public void UIntPtr();
+        public void VoidPointer();
+    }
+    public enum TableIndex : byte {
+        Assembly = (byte)32,
+        AssemblyOS = (byte)34,
+        AssemblyProcessor = (byte)33,
+        AssemblyRef = (byte)35,
+        AssemblyRefOS = (byte)37,
+        AssemblyRefProcessor = (byte)36,
+        ClassLayout = (byte)15,
+        Constant = (byte)11,
+        CustomAttribute = (byte)12,
+        CustomDebugInformation = (byte)55,
+        DeclSecurity = (byte)14,
+        Document = (byte)48,
+        EncLog = (byte)30,
+        EncMap = (byte)31,
+        Event = (byte)20,
+        EventMap = (byte)18,
+        EventPtr = (byte)19,
+        ExportedType = (byte)39,
+        Field = (byte)4,
+        FieldLayout = (byte)16,
+        FieldMarshal = (byte)13,
+        FieldPtr = (byte)3,
+        FieldRva = (byte)29,
+        File = (byte)38,
+        GenericParam = (byte)42,
+        GenericParamConstraint = (byte)44,
+        ImplMap = (byte)28,
+        ImportScope = (byte)53,
+        InterfaceImpl = (byte)9,
+        LocalConstant = (byte)52,
+        LocalScope = (byte)50,
+        LocalVariable = (byte)51,
+        ManifestResource = (byte)40,
+        MemberRef = (byte)10,
+        MethodDebugInformation = (byte)49,
+        MethodDef = (byte)6,
+        MethodImpl = (byte)25,
+        MethodPtr = (byte)5,
+        MethodSemantics = (byte)24,
+        MethodSpec = (byte)43,
+        Module = (byte)0,
+        ModuleRef = (byte)26,
+        NestedClass = (byte)41,
+        Param = (byte)8,
+        ParamPtr = (byte)7,
+        Property = (byte)23,
+        PropertyMap = (byte)21,
+        PropertyPtr = (byte)22,
+        StandAloneSig = (byte)17,
+        StateMachineMethod = (byte)54,
+        TypeDef = (byte)2,
+        TypeRef = (byte)1,
+        TypeSpec = (byte)27,
+    }
+    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
+    public struct VectorEncoder {
+        public VectorEncoder(BlobBuilder builder);
+        public BlobBuilder Builder { get; }
+        public LiteralsEncoder Count(int count);
+    }
+}
```

