# Microsoft.VisualBasic.FileIO

``` diff
+namespace Microsoft.VisualBasic.FileIO {
+    public enum DeleteDirectoryOption {
+        DeleteAllContents = 5,
+        ThrowIfDirectoryNonEmpty = 4,
+    }
+    public enum FieldType {
+        Delimited = 0,
+        FixedWidth = 1,
+    }
+    public class FileSystem {
+        public FileSystem();
+        public static string CurrentDirectory { get; set; }
+        public static ReadOnlyCollection<DriveInfo> Drives { get; }
+        public static string CombinePath(string baseDirectory, string relativePath);
+        public static void CopyDirectory(string sourceDirectoryName, string destinationDirectoryName);
+        public static void CopyDirectory(string sourceDirectoryName, string destinationDirectoryName, UIOption showUI);
+        public static void CopyDirectory(string sourceDirectoryName, string destinationDirectoryName, UIOption showUI, UICancelOption onUserCancel);
+        public static void CopyDirectory(string sourceDirectoryName, string destinationDirectoryName, bool overwrite);
+        public static void CopyFile(string sourceFileName, string destinationFileName);
+        public static void CopyFile(string sourceFileName, string destinationFileName, UIOption showUI);
+        public static void CopyFile(string sourceFileName, string destinationFileName, UIOption showUI, UICancelOption onUserCancel);
+        public static void CopyFile(string sourceFileName, string destinationFileName, bool overwrite);
+        public static void CreateDirectory(string directory);
+        public static void DeleteDirectory(string directory, DeleteDirectoryOption onDirectoryNotEmpty);
+        public static void DeleteDirectory(string directory, UIOption showUI, RecycleOption recycle);
+        public static void DeleteDirectory(string directory, UIOption showUI, RecycleOption recycle, UICancelOption onUserCancel);
+        public static void DeleteFile(string file);
+        public static void DeleteFile(string file, UIOption showUI, RecycleOption recycle);
+        public static void DeleteFile(string file, UIOption showUI, RecycleOption recycle, UICancelOption onUserCancel);
+        public static bool DirectoryExists(string directory);
+        public static bool FileExists(string file);
+        public static ReadOnlyCollection<string> FindInFiles(string directory, string containsText, bool ignoreCase, SearchOption searchType);
+        public static ReadOnlyCollection<string> FindInFiles(string directory, string containsText, bool ignoreCase, SearchOption searchType, params string[] fileWildcards);
+        public static ReadOnlyCollection<string> GetDirectories(string directory);
+        public static ReadOnlyCollection<string> GetDirectories(string directory, SearchOption searchType, params string[] wildcards);
+        public static DirectoryInfo GetDirectoryInfo(string directory);
+        public static DriveInfo GetDriveInfo(string drive);
+        public static FileInfo GetFileInfo(string file);
+        public static ReadOnlyCollection<string> GetFiles(string directory);
+        public static ReadOnlyCollection<string> GetFiles(string directory, SearchOption searchType, params string[] wildcards);
+        public static string GetName(string path);
+        public static string GetParentPath(string path);
+        public static string GetTempFileName();
+        public static void MoveDirectory(string sourceDirectoryName, string destinationDirectoryName);
+        public static void MoveDirectory(string sourceDirectoryName, string destinationDirectoryName, UIOption showUI);
+        public static void MoveDirectory(string sourceDirectoryName, string destinationDirectoryName, UIOption showUI, UICancelOption onUserCancel);
+        public static void MoveDirectory(string sourceDirectoryName, string destinationDirectoryName, bool overwrite);
+        public static void MoveFile(string sourceFileName, string destinationFileName);
+        public static void MoveFile(string sourceFileName, string destinationFileName, UIOption showUI);
+        public static void MoveFile(string sourceFileName, string destinationFileName, UIOption showUI, UICancelOption onUserCancel);
+        public static void MoveFile(string sourceFileName, string destinationFileName, bool overwrite);
+        public static TextFieldParser OpenTextFieldParser(string file);
+        public static TextFieldParser OpenTextFieldParser(string file, params int[] fieldWidths);
+        public static TextFieldParser OpenTextFieldParser(string file, params string[] delimiters);
+        public static StreamReader OpenTextFileReader(string file);
+        public static StreamReader OpenTextFileReader(string file, Encoding encoding);
+        public static StreamWriter OpenTextFileWriter(string file, bool append);
+        public static StreamWriter OpenTextFileWriter(string file, bool append, Encoding encoding);
+        public static byte[] ReadAllBytes(string file);
+        public static string ReadAllText(string file);
+        public static string ReadAllText(string file, Encoding encoding);
+        public static void RenameDirectory(string directory, string newName);
+        public static void RenameFile(string file, string newName);
+        public static void WriteAllBytes(string file, byte[] data, bool append);
+        public static void WriteAllText(string file, string text, bool append);
+        public static void WriteAllText(string file, string text, bool append, Encoding encoding);
+    }
+    public class MalformedLineException : Exception {
+        public MalformedLineException();
+        protected MalformedLineException(SerializationInfo info, StreamingContext context);
+        public MalformedLineException(string message);
+        public MalformedLineException(string message, Exception innerException);
+        public MalformedLineException(string message, long lineNumber);
+        public MalformedLineException(string message, long lineNumber, Exception innerException);
+        public long LineNumber { get; set; }
+        public override void GetObjectData(SerializationInfo info, StreamingContext context);
+        public override string ToString();
+    }
+    public enum RecycleOption {
+        DeletePermanently = 2,
+        SendToRecycleBin = 3,
+    }
+    public enum SearchOption {
+        SearchAllSubDirectories = 3,
+        SearchTopLevelOnly = 2,
+    }
+    public class SpecialDirectories {
+        public SpecialDirectories();
+        public static string AllUsersApplicationData { get; }
+        public static string CurrentUserApplicationData { get; }
+        public static string Desktop { get; }
+        public static string MyDocuments { get; }
+        public static string MyMusic { get; }
+        public static string MyPictures { get; }
+        public static string ProgramFiles { get; }
+        public static string Programs { get; }
+        public static string Temp { get; }
+    }
+    public class TextFieldParser : IDisposable {
+        public TextFieldParser(Stream stream);
+        public TextFieldParser(Stream stream, Encoding defaultEncoding);
+        public TextFieldParser(Stream stream, Encoding defaultEncoding, bool detectEncoding);
+        public TextFieldParser(Stream stream, Encoding defaultEncoding, bool detectEncoding, bool leaveOpen);
+        public TextFieldParser(TextReader reader);
+        public TextFieldParser(string path);
+        public TextFieldParser(string path, Encoding defaultEncoding);
+        public TextFieldParser(string path, Encoding defaultEncoding, bool detectEncoding);
+        public string[] CommentTokens { get; set; }
+        public string[] Delimiters { get; set; }
+        public bool EndOfData { get; }
+        public string ErrorLine { get; }
+        public long ErrorLineNumber { get; }
+        public int[] FieldWidths { get; set; }
+        public bool HasFieldsEnclosedInQuotes { get; set; }
+        public long LineNumber { get; }
+        public FieldType TextFieldType { get; set; }
+        public bool TrimWhiteSpace { get; set; }
+        public void Close();
+        void Dispose();
+        protected virtual void Dispose(bool disposing);
+        ~TextFieldParser();
+        public string PeekChars(int numberOfChars);
+        public string[] ReadFields();
+        public string ReadLine();
+        public string ReadToEnd();
+        public void SetDelimiters(params string[] delimiters);
+        public void SetFieldWidths(params int[] fieldWidths);
+    }
+    public enum UICancelOption {
+        DoNothing = 2,
+        ThrowException = 3,
+    }
+    public enum UIOption {
+        AllDialogs = 3,
+        OnlyErrorDialogs = 2,
+    }
+}
```

