CI Trigger Phrases
===

When submitting a pull request (PR) to the CoreCLR repo, you may want to run more test suites than are included in the default set of checks run with each PR. In this document you will find a list of all possible jobs to trigger, as well as the phrase that will trigger that job. 

Note that this document can quickly become out-of-date. You can ask the CI system to show you all the available trigger phrases by using `@dotnet-bot help`.

The trigger phrases are usually in the form of "test {OS} {Architecture} {Configuration} {Scenario}", so use that format if you are trying to find a particular job.

To trigger a job, post a comment on your PR with "@dotnet-bot {trigger-phrase}".

- **CentOS7.1 x64 Checked Build and Test**: "test CentOS7.1 x64 Build and Test"
- **CentOS7.1 x64 Checked Innerloop Build and Test**: "test CentOS7.1 x64 Checked Innerloop Build and Test"
- **CentOS7.1 x64 Checked R2R Build & Test**: "test CentOS7.1 x64 Checked r2r"
- **CentOS7.1 x64 Checked R2R gcstress15 Build & Test**: "test CentOS7.1 x64 Checked r2r_gcstress15"
- **CentOS7.1 x64 Checked R2R jitforcerelocs Build & Test**: "test CentOS7.1 x64 Checked r2r_jitforcerelocs"
- **CentOS7.1 x64 Checked R2R jitminopts Build & Test**: "test CentOS7.1 x64 Checked r2r_jitminopts"
- **CentOS7.1 x64 Checked R2R jitstress1 Build & Test**: "test CentOS7.1 x64 Checked r2r_jitstress1"
- **CentOS7.1 x64 Checked R2R jitstress1_tiered Build & Test**: "test CentOS7.1 x64 Checked r2r_jitstress1_tiered"
- **CentOS7.1 x64 Checked R2R jitstress2 Build & Test**: "test CentOS7.1 x64 Checked r2r_jitstress2"
- **CentOS7.1 x64 Checked R2R jitstress2_tiered Build & Test**: "test CentOS7.1 x64 Checked r2r_jitstress2_tiered"
- **CentOS7.1 x64 Checked R2R jitstressregs0x10 Build & Test**: "test CentOS7.1 x64 Checked r2r_jitstressregs0x10"
- **CentOS7.1 x64 Checked R2R jitstressregs0x1000 Build & Test**: "test CentOS7.1 x64 Checked r2r_jitstressregs0x1000"
- **CentOS7.1 x64 Checked R2R jitstressregs0x80 Build & Test**: "test CentOS7.1 x64 Checked r2r_jitstressregs0x80"
- **CentOS7.1 x64 Checked R2R jitstressregs1 Build & Test**: "test CentOS7.1 x64 Checked r2r_jitstressregs1"
- **CentOS7.1 x64 Checked R2R jitstressregs2 Build & Test**: "test CentOS7.1 x64 Checked r2r_jitstressregs2"
- **CentOS7.1 x64 Checked R2R jitstressregs3 Build & Test**: "test CentOS7.1 x64 Checked r2r_jitstressregs3"
- **CentOS7.1 x64 Checked R2R jitstressregs4 Build & Test**: "test CentOS7.1 x64 Checked r2r_jitstressregs4"
- **CentOS7.1 x64 Checked R2R jitstressregs8 Build & Test**: "test CentOS7.1 x64 Checked r2r_jitstressregs8"
- **CentOS7.1 x64 Checked R2R no_tiered_compilation Build & Test**: "test CentOS7.1 x64 Checked r2r_no_tiered_compilation"
- **CentOS7.1 x64 Debug Innerloop Build**: "test CentOS7.1 x64 Debug Innerloop Build"
- **CentOS7.1 x64 Release R2R Build & Test**: "test CentOS7.1 x64 Release r2r"
- **Debian8.4 x64 Checked Build**: "test Debian8.4 x64"
- **Debian8.4 x64 Debug Build**: "test Debian8.4 x64"
- **Debian8.4 x64 Release Build**: "test Debian8.4 x64"
- **Fedora24 x64 Checked Build**: "test Fedora24"
- **Fedora24 x64 Debug Build**: "test Fedora24"
- **Fedora24 x64 Release Build**: "test Fedora24"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 EnableAVX=0 EnableSSE3_4=0)**: "test OSX10.12 x64 Checked jitsse2only"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 EnableIncompleteISAClass=1 EnableAVX=0)**: "test OSX10.12 x64 Checked jitx86hwintrinsicnoavx"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 EnableIncompleteISAClass=1 EnableAVX2=0)**: "test OSX10.12 x64 Checked jitx86hwintrinsicnoavx2"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 EnableIncompleteISAClass=1 EnableSSE=0 EnableSSE2=0 EnableSSE3=0 EnableSSSE3=0 EnableSSE41=0 EnableSSE42=0 EnableAVX=0 EnableAVX2=0 EnableAES=0 EnableBMI1=0 EnableBMI2=0 EnableFMA=0 EnableLZCNT=0 EnablePCLMULQDQ=0 EnablePOPCNT=0)**: "test OSX10.12 x64 Checked jitnox86hwintrinsic"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 EnableIncompleteISAClass=1 FeatureSIMD=0)**: "test OSX10.12 x64 Checked jitx86hwintrinsicnosimd"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 EnableIncompleteISAClass=1)**: "test OSX10.12 x64 Checked jitincompletehwintrinsic"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 FeatureSIMD=0)**: "test OSX10.12 x64 Checked jitnosimd"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 ForceRelocs=1)**: "test OSX10.12 x64 Checked forcerelocs"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0x3)**: "test OSX10.12 x64 Checked gcstress0x3"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC JITMinOpts=1 HeapVerify=1)**: "test OSX10.12 x64 Checked gcstress0xc_minopts_heapverify1"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC JitStress=1)**: "test OSX10.12 x64 Checked gcstress0xc_jitstress1"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC JitStress=2)**: "test OSX10.12 x64 Checked gcstress0xc_jitstress2"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC ZapDisable=1 ReadyToRun=0 HeapVerify=1)**: "test OSX10.12 x64 Checked gcstress0xc_zapdisable_heapverify1"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC ZapDisable=1 ReadyToRun=0 JitStress=2)**: "test OSX10.12 x64 Checked gcstress0xc_zapdisable_jitstress2"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC ZapDisable=1 ReadyToRun=0)**: "test OSX10.12 x64 Checked gcstress0xc_zapdisable"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC)**: "test OSX10.12 x64 Checked gcstress0xc"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 HeapVerify=1)**: "test OSX10.12 x64 Checked heapverify1"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 JITMinOpts=1)**: "test OSX10.12 x64 Checked minopts"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=1)**: "test OSX10.12 x64 Checked jitstress1"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=0x10)**: "test OSX10.12 x64 Checked jitstress2_jitstressregs0x10"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=0x1000)**: "test OSX10.12 x64 Checked jitstress2_jitstressregs0x1000"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=0x80)**: "test OSX10.12 x64 Checked jitstress2_jitstressregs0x80"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=1)**: "test OSX10.12 x64 Checked jitstress2_jitstressregs1"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=2)**: "test OSX10.12 x64 Checked jitstress2_jitstressregs2"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=3)**: "test OSX10.12 x64 Checked jitstress2_jitstressregs3"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=4)**: "test OSX10.12 x64 Checked jitstress2_jitstressregs4"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=8)**: "test OSX10.12 x64 Checked jitstress2_jitstressregs8"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2)**: "test OSX10.12 x64 Checked jitstress2"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=0x10)**: "test OSX10.12 x64 Checked jitstressregs0x10"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=0x1000)**: "test OSX10.12 x64 Checked jitstressregs0x1000"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=0x80)**: "test OSX10.12 x64 Checked jitstressregs0x80"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=1)**: "test OSX10.12 x64 Checked jitstressregs1"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=2)**: "test OSX10.12 x64 Checked jitstressregs2"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=3)**: "test OSX10.12 x64 Checked jitstressregs3"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=4)**: "test OSX10.12 x64 Checked jitstressregs4"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=8)**: "test OSX10.12 x64 Checked jitstressregs8"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 TailcallStress=1)**: "test OSX10.12 x64 Checked tailcallstress"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0 ZapDisable=1 ReadyToRun=0)**: "test OSX10.12 x64 Checked zapdisable"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0)**: "test OSX10.12 x64 Checked no_tiered_compilation"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=0)**: "test OSX10.12 x64 Checked no_tiered_compilation_innerloop"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=1 JitStress=1)**: "test OSX10.12 x64 Checked jitstress1_tiered"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=1 JitStress=2)**: "test OSX10.12 x64 Checked jitstress2_tiered"
- **OSX10.12 x64 Checked Build and Test (Jit - TieredCompilation=1)**: "test OSX10.12 x64 Checked tieredcompilation"
- **OSX10.12 x64 Checked Build and Test**: "test OSX10.12 x64 Build and Test"
- **OSX10.12 x64 Checked CoreFX Tests**: "test OSX10.12 x64 Checked CoreFX Tests"
- **OSX10.12 x64 Checked GC Reliability Framework**: "test OSX10.12 Checked gc_reliability_framework"
- **OSX10.12 x64 Checked Innerloop Build and Test**: "test OSX10.12 x64 Checked Innerloop Build and Test"
- **OSX10.12 x64 Checked R2R Build and Test**: "test OSX10.12 x64 Checked r2r"
- **OSX10.12 x64 Checked R2R gcstress15 Build and Test**: "test OSX10.12 x64 Checked r2r_gcstress15"
- **OSX10.12 x64 Checked R2R jitforcerelocs Build and Test**: "test OSX10.12 x64 Checked r2r_jitforcerelocs"
- **OSX10.12 x64 Checked R2R jitminopts Build and Test**: "test OSX10.12 x64 Checked r2r_jitminopts"
- **OSX10.12 x64 Checked R2R jitstress1 Build and Test**: "test OSX10.12 x64 Checked r2r_jitstress1"
- **OSX10.12 x64 Checked R2R jitstress1_tiered Build and Test**: "test OSX10.12 x64 Checked r2r_jitstress1_tiered"
- **OSX10.12 x64 Checked R2R jitstress2 Build and Test**: "test OSX10.12 x64 Checked r2r_jitstress2"
- **OSX10.12 x64 Checked R2R jitstress2_tiered Build and Test**: "test OSX10.12 x64 Checked r2r_jitstress2_tiered"
- **OSX10.12 x64 Checked R2R jitstressregs0x10 Build and Test**: "test OSX10.12 x64 Checked r2r_jitstressregs0x10"
- **OSX10.12 x64 Checked R2R jitstressregs0x1000 Build and Test**: "test OSX10.12 x64 Checked r2r_jitstressregs0x1000"
- **OSX10.12 x64 Checked R2R jitstressregs0x80 Build and Test**: "test OSX10.12 x64 Checked r2r_jitstressregs0x80"
- **OSX10.12 x64 Checked R2R jitstressregs1 Build and Test**: "test OSX10.12 x64 Checked r2r_jitstressregs1"
- **OSX10.12 x64 Checked R2R jitstressregs2 Build and Test**: "test OSX10.12 x64 Checked r2r_jitstressregs2"
- **OSX10.12 x64 Checked R2R jitstressregs3 Build and Test**: "test OSX10.12 x64 Checked r2r_jitstressregs3"
- **OSX10.12 x64 Checked R2R jitstressregs4 Build and Test**: "test OSX10.12 x64 Checked r2r_jitstressregs4"
- **OSX10.12 x64 Checked R2R jitstressregs8 Build and Test**: "test OSX10.12 x64 Checked r2r_jitstressregs8"
- **OSX10.12 x64 Checked R2R no_tiered_compilation Build and Test**: "test OSX10.12 x64 Checked r2r_no_tiered_compilation"
- **OSX10.12 x64 Checked Standalone GC**: "test OSX10.12 Checked standalone_gc"
- **OSX10.12 x64 Release GC Reliability Framework**: "test OSX10.12 Release gc_reliability_framework"
- **OSX10.12 x64 Release GC Simulator**: "test OSX10.12 Release gcsimulator"
- **OSX10.12 x64 Release IL RoundTrip Build and Test**: "test OSX10.12 ilrt"
- **OSX10.12 x64 Release Long-Running GC Build & Test**: "test OSX10.12 Release longgc"
- **OSX10.12 x64 Release R2R Build and Test**: "test OSX10.12 x64 Release r2r"
- **OSX10.12 x64 Release Standalone GC**: "test OSX10.12 Release standalone_gc"
- **RHEL7.2 x64 Checked Build**: "test RHEL7.2 x64"
- **RHEL7.2 x64 Debug Build**: "test RHEL7.2 x64"
- **RHEL7.2 x64 Release Build**: "test RHEL7.2 x64"
- **Tizen armel Cross Checked Build**: "test Tizen armel Cross Checked Build"
- **Tizen armel Cross Checked Innerloop Build and Test**: "test Tizen armel Cross Checked Innerloop Build and Test"
- **Tizen armel Cross Debug Build**: "test Tizen armel Cross Debug Build"
- **Tizen armel Cross Release Build**: "test Tizen armel Cross Release Build"
- **Ubuntu arm Cross Checked corefx_baseline Build and Test**: "test Ubuntu arm Cross Checked corefx_baseline Build and Test"
- **Ubuntu arm Cross Checked corefx_jitstress1 Build and Test**: "test Ubuntu arm Cross Checked corefx_jitstress1 Build and Test"
- **Ubuntu arm Cross Checked corefx_jitstress2 Build and Test**: "test Ubuntu arm Cross Checked corefx_jitstress2 Build and Test"
- **Ubuntu arm Cross Checked corefx_jitstressregs0x10 Build and Test**: "test Ubuntu arm Cross Checked corefx_jitstressregs0x10 Build and Test"
- **Ubuntu arm Cross Checked corefx_jitstressregs0x1000 Build and Test**: "test Ubuntu arm Cross Checked corefx_jitstressregs0x1000 Build and Test"
- **Ubuntu arm Cross Checked corefx_jitstressregs0x80 Build and Test**: "test Ubuntu arm Cross Checked corefx_jitstressregs0x80 Build and Test"
- **Ubuntu arm Cross Checked corefx_jitstressregs1 Build and Test**: "test Ubuntu arm Cross Checked corefx_jitstressregs1 Build and Test"
- **Ubuntu arm Cross Checked corefx_jitstressregs2 Build and Test**: "test Ubuntu arm Cross Checked corefx_jitstressregs2 Build and Test"
- **Ubuntu arm Cross Checked corefx_jitstressregs3 Build and Test**: "test Ubuntu arm Cross Checked corefx_jitstressregs3 Build and Test"
- **Ubuntu arm Cross Checked corefx_jitstressregs4 Build and Test**: "test Ubuntu arm Cross Checked corefx_jitstressregs4 Build and Test"
- **Ubuntu arm Cross Checked corefx_jitstressregs8 Build and Test**: "test Ubuntu arm Cross Checked corefx_jitstressregs8 Build and Test"
- **Ubuntu arm Cross Checked corefx_minopts Build and Test**: "test Ubuntu arm Cross Checked corefx_minopts Build and Test"
- **Ubuntu arm Cross Checked corefx_tieredcompilation Build and Test**: "test Ubuntu arm Cross Checked corefx_tieredcompilation Build and Test"
- **Ubuntu arm Cross Checked forcerelocs Build and Test**: "test Ubuntu arm Cross Checked forcerelocs Build and Test"
- **Ubuntu arm Cross Checked gcstress0x3 Build and Test**: "test Ubuntu arm Cross Checked gcstress0x3 Build and Test"
- **Ubuntu arm Cross Checked gcstress0xc Build and Test**: "test Ubuntu arm Cross Checked gcstress0xc Build and Test"
- **Ubuntu arm Cross Checked gcstress0xc_jitstress1 Build and Test**: "test Ubuntu arm Cross Checked gcstress0xc_jitstress1 Build and Test"
- **Ubuntu arm Cross Checked gcstress0xc_jitstress2 Build and Test**: "test Ubuntu arm Cross Checked gcstress0xc_jitstress2 Build and Test"
- **Ubuntu arm Cross Checked gcstress0xc_minopts_heapverify1 Build and Test**: "test Ubuntu arm Cross Checked gcstress0xc_minopts_heapverify1 Build and Test"
- **Ubuntu arm Cross Checked gcstress0xc_zapdisable Build and Test**: "test Ubuntu arm Cross Checked gcstress0xc_zapdisable Build and Test"
- **Ubuntu arm Cross Checked gcstress0xc_zapdisable_heapverify1 Build and Test**: "test Ubuntu arm Cross Checked gcstress0xc_zapdisable_heapverify1 Build and Test"
- **Ubuntu arm Cross Checked gcstress0xc_zapdisable_jitstress2 Build and Test**: "test Ubuntu arm Cross Checked gcstress0xc_zapdisable_jitstress2 Build and Test"
- **Ubuntu arm Cross Checked heapverify1 Build and Test**: "test Ubuntu arm Cross Checked heapverify1 Build and Test"
- **Ubuntu arm Cross Checked Innerloop Build and Test**: "test Ubuntu arm Cross Checked Innerloop Build and Test"
- **Ubuntu arm Cross Checked jitstress1 Build and Test**: "test Ubuntu arm Cross Checked jitstress1 Build and Test"
- **Ubuntu arm Cross Checked jitstress1_tiered Build and Test**: "test Ubuntu arm Cross Checked jitstress1_tiered Build and Test"
- **Ubuntu arm Cross Checked jitstress2 Build and Test**: "test Ubuntu arm Cross Checked jitstress2 Build and Test"
- **Ubuntu arm Cross Checked jitstress2_jitstressregs0x10 Build and Test**: "test Ubuntu arm Cross Checked jitstress2_jitstressregs0x10 Build and Test"
- **Ubuntu arm Cross Checked jitstress2_jitstressregs0x1000 Build and Test**: "test Ubuntu arm Cross Checked jitstress2_jitstressregs0x1000 Build and Test"
- **Ubuntu arm Cross Checked jitstress2_jitstressregs0x80 Build and Test**: "test Ubuntu arm Cross Checked jitstress2_jitstressregs0x80 Build and Test"
- **Ubuntu arm Cross Checked jitstress2_jitstressregs1 Build and Test**: "test Ubuntu arm Cross Checked jitstress2_jitstressregs1 Build and Test"
- **Ubuntu arm Cross Checked jitstress2_jitstressregs2 Build and Test**: "test Ubuntu arm Cross Checked jitstress2_jitstressregs2 Build and Test"
- **Ubuntu arm Cross Checked jitstress2_jitstressregs3 Build and Test**: "test Ubuntu arm Cross Checked jitstress2_jitstressregs3 Build and Test"
- **Ubuntu arm Cross Checked jitstress2_jitstressregs4 Build and Test**: "test Ubuntu arm Cross Checked jitstress2_jitstressregs4 Build and Test"
- **Ubuntu arm Cross Checked jitstress2_jitstressregs8 Build and Test**: "test Ubuntu arm Cross Checked jitstress2_jitstressregs8 Build and Test"
- **Ubuntu arm Cross Checked jitstress2_tiered Build and Test**: "test Ubuntu arm Cross Checked jitstress2_tiered Build and Test"
- **Ubuntu arm Cross Checked jitstressregs0x10 Build and Test**: "test Ubuntu arm Cross Checked jitstressregs0x10 Build and Test"
- **Ubuntu arm Cross Checked jitstressregs0x1000 Build and Test**: "test Ubuntu arm Cross Checked jitstressregs0x1000 Build and Test"
- **Ubuntu arm Cross Checked jitstressregs0x80 Build and Test**: "test Ubuntu arm Cross Checked jitstressregs0x80 Build and Test"
- **Ubuntu arm Cross Checked jitstressregs1 Build and Test**: "test Ubuntu arm Cross Checked jitstressregs1 Build and Test"
- **Ubuntu arm Cross Checked jitstressregs2 Build and Test**: "test Ubuntu arm Cross Checked jitstressregs2 Build and Test"
- **Ubuntu arm Cross Checked jitstressregs3 Build and Test**: "test Ubuntu arm Cross Checked jitstressregs3 Build and Test"
- **Ubuntu arm Cross Checked jitstressregs4 Build and Test**: "test Ubuntu arm Cross Checked jitstressregs4 Build and Test"
- **Ubuntu arm Cross Checked jitstressregs8 Build and Test**: "test Ubuntu arm Cross Checked jitstressregs8 Build and Test"
- **Ubuntu arm Cross Checked minopts Build and Test**: "test Ubuntu arm Cross Checked minopts Build and Test"
- **Ubuntu arm Cross Checked no_tiered_compilation Build and Test**: "test Ubuntu arm Cross Checked no_tiered_compilation Build and Test"
- **Ubuntu arm Cross Checked no_tiered_compilation_innerloop Build and Test**: "test Ubuntu arm Cross Checked no_tiered_compilation_innerloop Build and Test"
- **Ubuntu arm Cross Checked normal Build and Test**: "test Ubuntu arm Cross Checked normal Build and Test"
- **Ubuntu arm Cross Checked r2r Build and Test**: "test Ubuntu arm Cross Checked r2r Build and Test"
- **Ubuntu arm Cross Checked r2r_gcstress15 Build and Test**: "test Ubuntu arm Cross Checked r2r_gcstress15 Build and Test"
- **Ubuntu arm Cross Checked r2r_jitforcerelocs Build and Test**: "test Ubuntu arm Cross Checked r2r_jitforcerelocs Build and Test"
- **Ubuntu arm Cross Checked r2r_jitminopts Build and Test**: "test Ubuntu arm Cross Checked r2r_jitminopts Build and Test"
- **Ubuntu arm Cross Checked r2r_jitstress1 Build and Test**: "test Ubuntu arm Cross Checked r2r_jitstress1 Build and Test"
- **Ubuntu arm Cross Checked r2r_jitstress1_tiered Build and Test**: "test Ubuntu arm Cross Checked r2r_jitstress1_tiered Build and Test"
- **Ubuntu arm Cross Checked r2r_jitstress2 Build and Test**: "test Ubuntu arm Cross Checked r2r_jitstress2 Build and Test"
- **Ubuntu arm Cross Checked r2r_jitstress2_tiered Build and Test**: "test Ubuntu arm Cross Checked r2r_jitstress2_tiered Build and Test"
- **Ubuntu arm Cross Checked r2r_jitstressregs0x10 Build and Test**: "test Ubuntu arm Cross Checked r2r_jitstressregs0x10 Build and Test"
- **Ubuntu arm Cross Checked r2r_jitstressregs0x1000 Build and Test**: "test Ubuntu arm Cross Checked r2r_jitstressregs0x1000 Build and Test"
- **Ubuntu arm Cross Checked r2r_jitstressregs0x80 Build and Test**: "test Ubuntu arm Cross Checked r2r_jitstressregs0x80 Build and Test"
- **Ubuntu arm Cross Checked r2r_jitstressregs1 Build and Test**: "test Ubuntu arm Cross Checked r2r_jitstressregs1 Build and Test"
- **Ubuntu arm Cross Checked r2r_jitstressregs2 Build and Test**: "test Ubuntu arm Cross Checked r2r_jitstressregs2 Build and Test"
- **Ubuntu arm Cross Checked r2r_jitstressregs3 Build and Test**: "test Ubuntu arm Cross Checked r2r_jitstressregs3 Build and Test"
- **Ubuntu arm Cross Checked r2r_jitstressregs4 Build and Test**: "test Ubuntu arm Cross Checked r2r_jitstressregs4 Build and Test"
- **Ubuntu arm Cross Checked r2r_jitstressregs8 Build and Test**: "test Ubuntu arm Cross Checked r2r_jitstressregs8 Build and Test"
- **Ubuntu arm Cross Checked r2r_no_tiered_compilation Build and Test**: "test Ubuntu arm Cross Checked r2r_no_tiered_compilation Build and Test"
- **Ubuntu arm Cross Checked tailcallstress Build and Test**: "test Ubuntu arm Cross Checked tailcallstress Build and Test"
- **Ubuntu arm Cross Checked tieredcompilation Build and Test**: "test Ubuntu arm Cross Checked tieredcompilation Build and Test"
- **Ubuntu arm Cross Checked zapdisable Build and Test**: "test Ubuntu arm Cross Checked zapdisable Build and Test"
- **Ubuntu arm Cross Debug normal Build**: "test Ubuntu arm Cross Debug normal Build"
- **Ubuntu arm Cross Release normal Build and Test**: "test Ubuntu arm Cross Release normal Build and Test"
- **Ubuntu arm Cross Release r2r Build and Test**: "test Ubuntu arm Cross Release r2r Build and Test"
- **Ubuntu arm64 Checked R2R Build and Test**: "test Ubuntu arm64 Cross Checked r2r Build and Test"
- **Ubuntu arm64 Checked R2R gcstress15 Build and Test**: "test Ubuntu arm64 Cross Checked r2r_gcstress15 Build and Test"
- **Ubuntu arm64 Checked R2R jitforcerelocs Build and Test**: "test Ubuntu arm64 Cross Checked r2r_jitforcerelocs Build and Test"
- **Ubuntu arm64 Checked R2R jitminopts Build and Test**: "test Ubuntu arm64 Cross Checked r2r_jitminopts Build and Test"
- **Ubuntu arm64 Checked R2R jitstress1 Build and Test**: "test Ubuntu arm64 Cross Checked r2r_jitstress1 Build and Test"
- **Ubuntu arm64 Checked R2R jitstress1_tiered Build and Test**: "test Ubuntu arm64 Cross Checked r2r_jitstress1_tiered Build and Test"
- **Ubuntu arm64 Checked R2R jitstress2 Build and Test**: "test Ubuntu arm64 Cross Checked r2r_jitstress2 Build and Test"
- **Ubuntu arm64 Checked R2R jitstress2_tiered Build and Test**: "test Ubuntu arm64 Cross Checked r2r_jitstress2_tiered Build and Test"
- **Ubuntu arm64 Checked R2R jitstressregs0x10 Build and Test**: "test Ubuntu arm64 Cross Checked r2r_jitstressregs0x10 Build and Test"
- **Ubuntu arm64 Checked R2R jitstressregs0x1000 Build and Test**: "test Ubuntu arm64 Cross Checked r2r_jitstressregs0x1000 Build and Test"
- **Ubuntu arm64 Checked R2R jitstressregs0x80 Build and Test**: "test Ubuntu arm64 Cross Checked r2r_jitstressregs0x80 Build and Test"
- **Ubuntu arm64 Checked R2R jitstressregs1 Build and Test**: "test Ubuntu arm64 Cross Checked r2r_jitstressregs1 Build and Test"
- **Ubuntu arm64 Checked R2R jitstressregs2 Build and Test**: "test Ubuntu arm64 Cross Checked r2r_jitstressregs2 Build and Test"
- **Ubuntu arm64 Checked R2R jitstressregs3 Build and Test**: "test Ubuntu arm64 Cross Checked r2r_jitstressregs3 Build and Test"
- **Ubuntu arm64 Checked R2R jitstressregs4 Build and Test**: "test Ubuntu arm64 Cross Checked r2r_jitstressregs4 Build and Test"
- **Ubuntu arm64 Checked R2R jitstressregs8 Build and Test**: "test Ubuntu arm64 Cross Checked r2r_jitstressregs8 Build and Test"
- **Ubuntu arm64 Cross Checked normal Build and Test**: "test Ubuntu arm64 Cross Checked normal Build and Test"
- **Ubuntu arm64 Cross Debug Innerloop Build**: "test Ubuntu arm64 Cross Debug Innerloop Build"
- **Ubuntu arm64 Cross Debug normal Build**: "test Ubuntu arm64 Cross Debug normal Build"
- **Ubuntu arm64 Cross Release normal Build and Test**: "test Ubuntu arm64 Cross Release normal Build and Test"
- **Ubuntu arm64 Release R2R Build and Test**: "test Ubuntu arm64 Cross Release r2r Build and Test"
- **Ubuntu x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JITMinOpts=1)**: "test Ubuntu x64 Checked corefx_minopts"
- **Ubuntu x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStress=1)**: "test Ubuntu x64 Checked corefx_jitstress1"
- **Ubuntu x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStress=2)**: "test Ubuntu x64 Checked corefx_jitstress2"
- **Ubuntu x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=0x10)**: "test Ubuntu x64 Checked corefx_jitstressregs0x10"
- **Ubuntu x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=0x1000)**: "test Ubuntu x64 Checked corefx_jitstressregs0x1000"
- **Ubuntu x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=0x80)**: "test Ubuntu x64 Checked corefx_jitstressregs0x80"
- **Ubuntu x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=1)**: "test Ubuntu x64 Checked corefx_jitstressregs1"
- **Ubuntu x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=2)**: "test Ubuntu x64 Checked corefx_jitstressregs2"
- **Ubuntu x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=3)**: "test Ubuntu x64 Checked corefx_jitstressregs3"
- **Ubuntu x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=4)**: "test Ubuntu x64 Checked corefx_jitstressregs4"
- **Ubuntu x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=8)**: "test Ubuntu x64 Checked corefx_jitstressregs8"
- **Ubuntu x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0)**: "test Ubuntu x64 Checked corefx_baseline"
- **Ubuntu x64 Checked Build and Test (Jit - CoreFx TieredCompilation=1)**: "test Ubuntu x64 Checked corefx_tieredcompilation"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 EnableAVX=0 EnableSSE3_4=0)**: "test Ubuntu x64 Checked jitsse2only"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 EnableIncompleteISAClass=1 EnableAVX=0)**: "test Ubuntu x64 Checked jitx86hwintrinsicnoavx"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 EnableIncompleteISAClass=1 EnableAVX2=0)**: "test Ubuntu x64 Checked jitx86hwintrinsicnoavx2"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 EnableIncompleteISAClass=1 EnableSSE=0 EnableSSE2=0 EnableSSE3=0 EnableSSSE3=0 EnableSSE41=0 EnableSSE42=0 EnableAVX=0 EnableAVX2=0 EnableAES=0 EnableBMI1=0 EnableBMI2=0 EnableFMA=0 EnableLZCNT=0 EnablePCLMULQDQ=0 EnablePOPCNT=0)**: "test Ubuntu x64 Checked jitnox86hwintrinsic"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 EnableIncompleteISAClass=1 FeatureSIMD=0)**: "test Ubuntu x64 Checked jitx86hwintrinsicnosimd"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 EnableIncompleteISAClass=1)**: "test Ubuntu x64 Checked jitincompletehwintrinsic"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 FeatureSIMD=0)**: "test Ubuntu x64 Checked jitnosimd"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 ForceRelocs=1)**: "test Ubuntu x64 Checked forcerelocs"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0x3)**: "test Ubuntu x64 Checked gcstress0x3"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC JITMinOpts=1 HeapVerify=1)**: "test Ubuntu x64 Checked gcstress0xc_minopts_heapverify1"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC JitStress=1)**: "test Ubuntu x64 Checked gcstress0xc_jitstress1"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC JitStress=2)**: "test Ubuntu x64 Checked gcstress0xc_jitstress2"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC ZapDisable=1 ReadyToRun=0 HeapVerify=1)**: "test Ubuntu x64 Checked gcstress0xc_zapdisable_heapverify1"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC ZapDisable=1 ReadyToRun=0 JitStress=2)**: "test Ubuntu x64 Checked gcstress0xc_zapdisable_jitstress2"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC ZapDisable=1 ReadyToRun=0)**: "test Ubuntu x64 Checked gcstress0xc_zapdisable"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC)**: "test Ubuntu x64 Checked gcstress0xc"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 HeapVerify=1)**: "test Ubuntu x64 Checked heapverify1"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 JITMinOpts=1)**: "test Ubuntu x64 Checked minopts"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=1)**: "test Ubuntu x64 Checked jitstress1"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=0x10)**: "test Ubuntu x64 Checked jitstress2_jitstressregs0x10"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=0x1000)**: "test Ubuntu x64 Checked jitstress2_jitstressregs0x1000"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=0x80)**: "test Ubuntu x64 Checked jitstress2_jitstressregs0x80"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=1)**: "test Ubuntu x64 Checked jitstress2_jitstressregs1"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=2)**: "test Ubuntu x64 Checked jitstress2_jitstressregs2"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=3)**: "test Ubuntu x64 Checked jitstress2_jitstressregs3"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=4)**: "test Ubuntu x64 Checked jitstress2_jitstressregs4"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=8)**: "test Ubuntu x64 Checked jitstress2_jitstressregs8"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2)**: "test Ubuntu x64 Checked jitstress2"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=0x10)**: "test Ubuntu x64 Checked jitstressregs0x10"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=0x1000)**: "test Ubuntu x64 Checked jitstressregs0x1000"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=0x80)**: "test Ubuntu x64 Checked jitstressregs0x80"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=1)**: "test Ubuntu x64 Checked jitstressregs1"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=2)**: "test Ubuntu x64 Checked jitstressregs2"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=3)**: "test Ubuntu x64 Checked jitstressregs3"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=4)**: "test Ubuntu x64 Checked jitstressregs4"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=8)**: "test Ubuntu x64 Checked jitstressregs8"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 TailcallStress=1)**: "test Ubuntu x64 Checked tailcallstress"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0 ZapDisable=1 ReadyToRun=0)**: "test Ubuntu x64 Checked zapdisable"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=0)**: "test Ubuntu x64 Checked no_tiered_compilation"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=1 JitStress=1)**: "test Ubuntu x64 Checked jitstress1_tiered"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=1 JitStress=2)**: "test Ubuntu x64 Checked jitstress2_tiered"
- **Ubuntu x64 Checked Build and Test (Jit - TieredCompilation=1)**: "test Ubuntu x64 Checked tieredcompilation"
- **Ubuntu x64 Checked Build and Test**: "test Ubuntu x64 Build and Test"
- **Ubuntu x64 Checked CoreFX Tests**: "test Ubuntu x64 Checked CoreFX Tests"
- **Ubuntu x64 Checked GC Reliability Framework**: "test Ubuntu Checked gc_reliability_framework"
- **Ubuntu x64 Checked Innerloop Build and Test (Jit - TieredCompilation=0)**: "test Ubuntu x64 Checked Innerloop Build and Test (Jit - TieredCompilation=0)"
- **Ubuntu x64 Checked Innerloop Build and Test**: "test Ubuntu x64 Checked Innerloop Build and Test"
- **Ubuntu x64 Checked R2R Build and Test**: "test Ubuntu x64 Checked r2r"
- **Ubuntu x64 Checked R2R gcstress15 Build and Test**: "test Ubuntu x64 Checked r2r_gcstress15"
- **Ubuntu x64 Checked R2R jitforcerelocs Build and Test**: "test Ubuntu x64 Checked r2r_jitforcerelocs"
- **Ubuntu x64 Checked R2R jitminopts Build and Test**: "test Ubuntu x64 Checked r2r_jitminopts"
- **Ubuntu x64 Checked R2R jitstress1 Build and Test**: "test Ubuntu x64 Checked r2r_jitstress1"
- **Ubuntu x64 Checked R2R jitstress1_tiered Build and Test**: "test Ubuntu x64 Checked r2r_jitstress1_tiered"
- **Ubuntu x64 Checked R2R jitstress2 Build and Test**: "test Ubuntu x64 Checked r2r_jitstress2"
- **Ubuntu x64 Checked R2R jitstress2_tiered Build and Test**: "test Ubuntu x64 Checked r2r_jitstress2_tiered"
- **Ubuntu x64 Checked R2R jitstressregs0x10 Build and Test**: "test Ubuntu x64 Checked r2r_jitstressregs0x10"
- **Ubuntu x64 Checked R2R jitstressregs0x1000 Build and Test**: "test Ubuntu x64 Checked r2r_jitstressregs0x1000"
- **Ubuntu x64 Checked R2R jitstressregs0x80 Build and Test**: "test Ubuntu x64 Checked r2r_jitstressregs0x80"
- **Ubuntu x64 Checked R2R jitstressregs1 Build and Test**: "test Ubuntu x64 Checked r2r_jitstressregs1"
- **Ubuntu x64 Checked R2R jitstressregs2 Build and Test**: "test Ubuntu x64 Checked r2r_jitstressregs2"
- **Ubuntu x64 Checked R2R jitstressregs3 Build and Test**: "test Ubuntu x64 Checked r2r_jitstressregs3"
- **Ubuntu x64 Checked R2R jitstressregs4 Build and Test**: "test Ubuntu x64 Checked r2r_jitstressregs4"
- **Ubuntu x64 Checked R2R jitstressregs8 Build and Test**: "test Ubuntu x64 Checked r2r_jitstressregs8"
- **Ubuntu x64 Checked R2R no_tiered_compilation Build and Test**: "test Ubuntu x64 Checked r2r_no_tiered_compilation"
- **Ubuntu x64 Checked Standalone GC**: "test Ubuntu Checked standalone_gc"
- **Ubuntu x64 Checked via ILLink**: "test Ubuntu x64 Checked illink"
- **Ubuntu x64 Debug CoreFX Tests**: "test Ubuntu x64 Debug CoreFX Tests"
- **Ubuntu x64 Debug via ILLink**: "test Ubuntu x64 Debug illink"
- **Ubuntu x64 Formatting**: "test Ubuntu x64 Formatting"
- **Ubuntu x64 Release CoreFX Tests**: "test Ubuntu x64 Release CoreFX Tests"
- **Ubuntu x64 Release GC Reliability Framework**: "test Ubuntu Release gc_reliability_framework"
- **Ubuntu x64 Release GC Simulator**: "test Ubuntu Release gcsimulator"
- **Ubuntu x64 Release IL RoundTrip Build and Test**: "test Ubuntu ilrt"
- **Ubuntu x64 Release Long-Running GC Build & Test**: "test Ubuntu Release longgc"
- **Ubuntu x64 Release R2R Build and Test**: "test Ubuntu x64 Release r2r"
- **Ubuntu x64 Release Standalone GC**: "test Ubuntu Release standalone_gc"
- **Ubuntu x64 Release via ILLink**: "test Ubuntu x64 Release illink"
- **Ubuntu x86 Checked Build**: "test Ubuntu x86 Checked"
- **Ubuntu x86 Debug Build**: "test Ubuntu x86 Debug"
- **Ubuntu x86 Release Build**: "test Ubuntu x86 Release"
- **Ubuntu16.04 x64 Checked Build**: "test Ubuntu16.04 x64"
- **Ubuntu16.04 x64 Debug Build**: "test Ubuntu16.04 x64"
- **Ubuntu16.04 x64 Release Build**: "test Ubuntu16.04 x64"
- **Ubuntu16.10 x64 Checked Build**: "test Ubuntu16.10"
- **Ubuntu16.10 x64 Debug Build**: "test Ubuntu16.10"
- **Ubuntu16.10 x64 Release Build**: "test Ubuntu16.10"
- **Windows_NT arm Cross Checked corefx_baseline Build and Test**: "test Windows_NT arm Cross Checked corefx_baseline Build and Test"
- **Windows_NT arm Cross Checked corefx_jitstress1 Build and Test**: "test Windows_NT arm Cross Checked corefx_jitstress1 Build and Test"
- **Windows_NT arm Cross Checked corefx_jitstress2 Build and Test**: "test Windows_NT arm Cross Checked corefx_jitstress2 Build and Test"
- **Windows_NT arm Cross Checked corefx_jitstressregs0x10 Build and Test**: "test Windows_NT arm Cross Checked corefx_jitstressregs0x10 Build and Test"
- **Windows_NT arm Cross Checked corefx_jitstressregs0x1000 Build and Test**: "test Windows_NT arm Cross Checked corefx_jitstressregs0x1000 Build and Test"
- **Windows_NT arm Cross Checked corefx_jitstressregs0x80 Build and Test**: "test Windows_NT arm Cross Checked corefx_jitstressregs0x80 Build and Test"
- **Windows_NT arm Cross Checked corefx_jitstressregs1 Build and Test**: "test Windows_NT arm Cross Checked corefx_jitstressregs1 Build and Test"
- **Windows_NT arm Cross Checked corefx_jitstressregs2 Build and Test**: "test Windows_NT arm Cross Checked corefx_jitstressregs2 Build and Test"
- **Windows_NT arm Cross Checked corefx_jitstressregs3 Build and Test**: "test Windows_NT arm Cross Checked corefx_jitstressregs3 Build and Test"
- **Windows_NT arm Cross Checked corefx_jitstressregs4 Build and Test**: "test Windows_NT arm Cross Checked corefx_jitstressregs4 Build and Test"
- **Windows_NT arm Cross Checked corefx_jitstressregs8 Build and Test**: "test Windows_NT arm Cross Checked corefx_jitstressregs8 Build and Test"
- **Windows_NT arm Cross Checked corefx_minopts Build and Test**: "test Windows_NT arm Cross Checked corefx_minopts Build and Test"
- **Windows_NT arm Cross Checked corefx_tieredcompilation Build and Test**: "test Windows_NT arm Cross Checked corefx_tieredcompilation Build and Test"
- **Windows_NT arm Cross Checked forcerelocs Build and Test**: "test Windows_NT arm Cross Checked forcerelocs Build and Test"
- **Windows_NT arm Cross Checked gcstress0x3 Build and Test**: "test Windows_NT arm Cross Checked gcstress0x3 Build and Test"
- **Windows_NT arm Cross Checked gcstress0xc Build and Test**: "test Windows_NT arm Cross Checked gcstress0xc Build and Test"
- **Windows_NT arm Cross Checked gcstress0xc_jitstress1 Build and Test**: "test Windows_NT arm Cross Checked gcstress0xc_jitstress1 Build and Test"
- **Windows_NT arm Cross Checked gcstress0xc_jitstress2 Build and Test**: "test Windows_NT arm Cross Checked gcstress0xc_jitstress2 Build and Test"
- **Windows_NT arm Cross Checked gcstress0xc_minopts_heapverify1 Build and Test**: "test Windows_NT arm Cross Checked gcstress0xc_minopts_heapverify1 Build and Test"
- **Windows_NT arm Cross Checked gcstress0xc_zapdisable Build and Test**: "test Windows_NT arm Cross Checked gcstress0xc_zapdisable Build and Test"
- **Windows_NT arm Cross Checked gcstress0xc_zapdisable_heapverify1 Build and Test**: "test Windows_NT arm Cross Checked gcstress0xc_zapdisable_heapverify1 Build and Test"
- **Windows_NT arm Cross Checked gcstress0xc_zapdisable_jitstress2 Build and Test**: "test Windows_NT arm Cross Checked gcstress0xc_zapdisable_jitstress2 Build and Test"
- **Windows_NT arm Cross Checked heapverify1 Build and Test**: "test Windows_NT arm Cross Checked heapverify1 Build and Test"
- **Windows_NT arm Cross Checked Innerloop Build and Test**: "test Windows_NT arm Cross Checked Innerloop Build and Test"
- **Windows_NT arm Cross Checked jitnosimd Build and Test**: "test Windows_NT arm Cross Checked jitnosimd Build and Test"
- **Windows_NT arm Cross Checked jitstress1 Build and Test**: "test Windows_NT arm Cross Checked jitstress1 Build and Test"
- **Windows_NT arm Cross Checked jitstress1_tiered Build and Test**: "test Windows_NT arm Cross Checked jitstress1_tiered Build and Test"
- **Windows_NT arm Cross Checked jitstress2 Build and Test**: "test Windows_NT arm Cross Checked jitstress2 Build and Test"
- **Windows_NT arm Cross Checked jitstress2_jitstressregs0x10 Build and Test**: "test Windows_NT arm Cross Checked jitstress2_jitstressregs0x10 Build and Test"
- **Windows_NT arm Cross Checked jitstress2_jitstressregs0x1000 Build and Test**: "test Windows_NT arm Cross Checked jitstress2_jitstressregs0x1000 Build and Test"
- **Windows_NT arm Cross Checked jitstress2_jitstressregs0x80 Build and Test**: "test Windows_NT arm Cross Checked jitstress2_jitstressregs0x80 Build and Test"
- **Windows_NT arm Cross Checked jitstress2_jitstressregs1 Build and Test**: "test Windows_NT arm Cross Checked jitstress2_jitstressregs1 Build and Test"
- **Windows_NT arm Cross Checked jitstress2_jitstressregs2 Build and Test**: "test Windows_NT arm Cross Checked jitstress2_jitstressregs2 Build and Test"
- **Windows_NT arm Cross Checked jitstress2_jitstressregs3 Build and Test**: "test Windows_NT arm Cross Checked jitstress2_jitstressregs3 Build and Test"
- **Windows_NT arm Cross Checked jitstress2_jitstressregs4 Build and Test**: "test Windows_NT arm Cross Checked jitstress2_jitstressregs4 Build and Test"
- **Windows_NT arm Cross Checked jitstress2_jitstressregs8 Build and Test**: "test Windows_NT arm Cross Checked jitstress2_jitstressregs8 Build and Test"
- **Windows_NT arm Cross Checked jitstress2_tiered Build and Test**: "test Windows_NT arm Cross Checked jitstress2_tiered Build and Test"
- **Windows_NT arm Cross Checked jitstressregs0x10 Build and Test**: "test Windows_NT arm Cross Checked jitstressregs0x10 Build and Test"
- **Windows_NT arm Cross Checked jitstressregs0x1000 Build and Test**: "test Windows_NT arm Cross Checked jitstressregs0x1000 Build and Test"
- **Windows_NT arm Cross Checked jitstressregs0x80 Build and Test**: "test Windows_NT arm Cross Checked jitstressregs0x80 Build and Test"
- **Windows_NT arm Cross Checked jitstressregs1 Build and Test**: "test Windows_NT arm Cross Checked jitstressregs1 Build and Test"
- **Windows_NT arm Cross Checked jitstressregs2 Build and Test**: "test Windows_NT arm Cross Checked jitstressregs2 Build and Test"
- **Windows_NT arm Cross Checked jitstressregs3 Build and Test**: "test Windows_NT arm Cross Checked jitstressregs3 Build and Test"
- **Windows_NT arm Cross Checked jitstressregs4 Build and Test**: "test Windows_NT arm Cross Checked jitstressregs4 Build and Test"
- **Windows_NT arm Cross Checked jitstressregs8 Build and Test**: "test Windows_NT arm Cross Checked jitstressregs8 Build and Test"
- **Windows_NT arm Cross Checked minopts Build and Test**: "test Windows_NT arm Cross Checked minopts Build and Test"
- **Windows_NT arm Cross Checked no_tiered_compilation Build and Test**: "test Windows_NT arm Cross Checked no_tiered_compilation Build and Test"
- **Windows_NT arm Cross Checked no_tiered_compilation_innerloop Build and Test**: "test Windows_NT arm Cross Checked no_tiered_compilation_innerloop Build and Test"
- **Windows_NT arm Cross Checked normal Build and Test**: "test Windows_NT arm Cross Checked normal Build and Test"
- **Windows_NT arm Cross Checked r2r Build and Test**: "test Windows_NT arm Cross Checked r2r Build and Test"
- **Windows_NT arm Cross Checked r2r_gcstress15 Build and Test**: "test Windows_NT arm Cross Checked r2r_gcstress15 Build and Test"
- **Windows_NT arm Cross Checked r2r_jitforcerelocs Build and Test**: "test Windows_NT arm Cross Checked r2r_jitforcerelocs Build and Test"
- **Windows_NT arm Cross Checked r2r_jitminopts Build and Test**: "test Windows_NT arm Cross Checked r2r_jitminopts Build and Test"
- **Windows_NT arm Cross Checked r2r_jitstress1 Build and Test**: "test Windows_NT arm Cross Checked r2r_jitstress1 Build and Test"
- **Windows_NT arm Cross Checked r2r_jitstress1_tiered Build and Test**: "test Windows_NT arm Cross Checked r2r_jitstress1_tiered Build and Test"
- **Windows_NT arm Cross Checked r2r_jitstress2 Build and Test**: "test Windows_NT arm Cross Checked r2r_jitstress2 Build and Test"
- **Windows_NT arm Cross Checked r2r_jitstress2_tiered Build and Test**: "test Windows_NT arm Cross Checked r2r_jitstress2_tiered Build and Test"
- **Windows_NT arm Cross Checked r2r_jitstressregs0x10 Build and Test**: "test Windows_NT arm Cross Checked r2r_jitstressregs0x10 Build and Test"
- **Windows_NT arm Cross Checked r2r_jitstressregs0x1000 Build and Test**: "test Windows_NT arm Cross Checked r2r_jitstressregs0x1000 Build and Test"
- **Windows_NT arm Cross Checked r2r_jitstressregs0x80 Build and Test**: "test Windows_NT arm Cross Checked r2r_jitstressregs0x80 Build and Test"
- **Windows_NT arm Cross Checked r2r_jitstressregs1 Build and Test**: "test Windows_NT arm Cross Checked r2r_jitstressregs1 Build and Test"
- **Windows_NT arm Cross Checked r2r_jitstressregs2 Build and Test**: "test Windows_NT arm Cross Checked r2r_jitstressregs2 Build and Test"
- **Windows_NT arm Cross Checked r2r_jitstressregs3 Build and Test**: "test Windows_NT arm Cross Checked r2r_jitstressregs3 Build and Test"
- **Windows_NT arm Cross Checked r2r_jitstressregs4 Build and Test**: "test Windows_NT arm Cross Checked r2r_jitstressregs4 Build and Test"
- **Windows_NT arm Cross Checked r2r_jitstressregs8 Build and Test**: "test Windows_NT arm Cross Checked r2r_jitstressregs8 Build and Test"
- **Windows_NT arm Cross Checked r2r_no_tiered_compilation Build and Test**: "test Windows_NT arm Cross Checked r2r_no_tiered_compilation Build and Test"
- **Windows_NT arm Cross Checked tailcallstress Build and Test**: "test Windows_NT arm Cross Checked tailcallstress Build and Test"
- **Windows_NT arm Cross Checked tieredcompilation Build and Test**: "test Windows_NT arm Cross Checked tieredcompilation Build and Test"
- **Windows_NT arm Cross Checked zapdisable Build and Test**: "test Windows_NT arm Cross Checked zapdisable Build and Test"
- **Windows_NT arm Cross Debug Innerloop Build**: "test Windows_NT arm Cross Debug Innerloop Build"
- **Windows_NT arm Cross Debug normal Build**: "test Windows_NT arm Cross Debug normal Build"
- **Windows_NT arm Cross Release normal Build and Test**: "test Windows_NT arm Cross Release normal Build and Test"
- **Windows_NT arm Cross Release r2r Build and Test**: "test Windows_NT arm Cross Release r2r Build and Test"
- **Windows_NT arm64 Cross Checked corefx_baseline Build and Test**: "test Windows_NT arm64 Cross Checked corefx_baseline Build and Test"
- **Windows_NT arm64 Cross Checked corefx_jitstress1 Build and Test**: "test Windows_NT arm64 Cross Checked corefx_jitstress1 Build and Test"
- **Windows_NT arm64 Cross Checked corefx_jitstress2 Build and Test**: "test Windows_NT arm64 Cross Checked corefx_jitstress2 Build and Test"
- **Windows_NT arm64 Cross Checked corefx_jitstressregs0x10 Build and Test**: "test Windows_NT arm64 Cross Checked corefx_jitstressregs0x10 Build and Test"
- **Windows_NT arm64 Cross Checked corefx_jitstressregs0x1000 Build and Test**: "test Windows_NT arm64 Cross Checked corefx_jitstressregs0x1000 Build and Test"
- **Windows_NT arm64 Cross Checked corefx_jitstressregs0x80 Build and Test**: "test Windows_NT arm64 Cross Checked corefx_jitstressregs0x80 Build and Test"
- **Windows_NT arm64 Cross Checked corefx_jitstressregs1 Build and Test**: "test Windows_NT arm64 Cross Checked corefx_jitstressregs1 Build and Test"
- **Windows_NT arm64 Cross Checked corefx_jitstressregs2 Build and Test**: "test Windows_NT arm64 Cross Checked corefx_jitstressregs2 Build and Test"
- **Windows_NT arm64 Cross Checked corefx_jitstressregs3 Build and Test**: "test Windows_NT arm64 Cross Checked corefx_jitstressregs3 Build and Test"
- **Windows_NT arm64 Cross Checked corefx_jitstressregs4 Build and Test**: "test Windows_NT arm64 Cross Checked corefx_jitstressregs4 Build and Test"
- **Windows_NT arm64 Cross Checked corefx_jitstressregs8 Build and Test**: "test Windows_NT arm64 Cross Checked corefx_jitstressregs8 Build and Test"
- **Windows_NT arm64 Cross Checked corefx_minopts Build and Test**: "test Windows_NT arm64 Cross Checked corefx_minopts Build and Test"
- **Windows_NT arm64 Cross Checked corefx_tieredcompilation Build and Test**: "test Windows_NT arm64 Cross Checked corefx_tieredcompilation Build and Test"
- **Windows_NT arm64 Cross Checked forcerelocs Build and Test**: "test Windows_NT arm64 Cross Checked forcerelocs Build and Test"
- **Windows_NT arm64 Cross Checked gcstress0x3 Build and Test**: "test Windows_NT arm64 Cross Checked gcstress0x3 Build and Test"
- **Windows_NT arm64 Cross Checked gcstress0xc Build and Test**: "test Windows_NT arm64 Cross Checked gcstress0xc Build and Test"
- **Windows_NT arm64 Cross Checked gcstress0xc_jitstress1 Build and Test**: "test Windows_NT arm64 Cross Checked gcstress0xc_jitstress1 Build and Test"
- **Windows_NT arm64 Cross Checked gcstress0xc_jitstress2 Build and Test**: "test Windows_NT arm64 Cross Checked gcstress0xc_jitstress2 Build and Test"
- **Windows_NT arm64 Cross Checked gcstress0xc_minopts_heapverify1 Build and Test**: "test Windows_NT arm64 Cross Checked gcstress0xc_minopts_heapverify1 Build and Test"
- **Windows_NT arm64 Cross Checked gcstress0xc_zapdisable Build and Test**: "test Windows_NT arm64 Cross Checked gcstress0xc_zapdisable Build and Test"
- **Windows_NT arm64 Cross Checked gcstress0xc_zapdisable_heapverify1 Build and Test**: "test Windows_NT arm64 Cross Checked gcstress0xc_zapdisable_heapverify1 Build and Test"
- **Windows_NT arm64 Cross Checked gcstress0xc_zapdisable_jitstress2 Build and Test**: "test Windows_NT arm64 Cross Checked gcstress0xc_zapdisable_jitstress2 Build and Test"
- **Windows_NT arm64 Cross Checked heapverify1 Build and Test**: "test Windows_NT arm64 Cross Checked heapverify1 Build and Test"
- **Windows_NT arm64 Cross Checked Innerloop Build and Test**: "test Windows_NT arm64 Cross Checked Innerloop Build and Test"
- **Windows_NT arm64 Cross Checked jitnosimd Build and Test**: "test Windows_NT arm64 Cross Checked jitnosimd Build and Test"
- **Windows_NT arm64 Cross Checked jitstress1 Build and Test**: "test Windows_NT arm64 Cross Checked jitstress1 Build and Test"
- **Windows_NT arm64 Cross Checked jitstress1_tiered Build and Test**: "test Windows_NT arm64 Cross Checked jitstress1_tiered Build and Test"
- **Windows_NT arm64 Cross Checked jitstress2 Build and Test**: "test Windows_NT arm64 Cross Checked jitstress2 Build and Test"
- **Windows_NT arm64 Cross Checked jitstress2_jitstressregs0x10 Build and Test**: "test Windows_NT arm64 Cross Checked jitstress2_jitstressregs0x10 Build and Test"
- **Windows_NT arm64 Cross Checked jitstress2_jitstressregs0x1000 Build and Test**: "test Windows_NT arm64 Cross Checked jitstress2_jitstressregs0x1000 Build and Test"
- **Windows_NT arm64 Cross Checked jitstress2_jitstressregs0x80 Build and Test**: "test Windows_NT arm64 Cross Checked jitstress2_jitstressregs0x80 Build and Test"
- **Windows_NT arm64 Cross Checked jitstress2_jitstressregs1 Build and Test**: "test Windows_NT arm64 Cross Checked jitstress2_jitstressregs1 Build and Test"
- **Windows_NT arm64 Cross Checked jitstress2_jitstressregs2 Build and Test**: "test Windows_NT arm64 Cross Checked jitstress2_jitstressregs2 Build and Test"
- **Windows_NT arm64 Cross Checked jitstress2_jitstressregs3 Build and Test**: "test Windows_NT arm64 Cross Checked jitstress2_jitstressregs3 Build and Test"
- **Windows_NT arm64 Cross Checked jitstress2_jitstressregs4 Build and Test**: "test Windows_NT arm64 Cross Checked jitstress2_jitstressregs4 Build and Test"
- **Windows_NT arm64 Cross Checked jitstress2_jitstressregs8 Build and Test**: "test Windows_NT arm64 Cross Checked jitstress2_jitstressregs8 Build and Test"
- **Windows_NT arm64 Cross Checked jitstress2_tiered Build and Test**: "test Windows_NT arm64 Cross Checked jitstress2_tiered Build and Test"
- **Windows_NT arm64 Cross Checked jitstressregs0x10 Build and Test**: "test Windows_NT arm64 Cross Checked jitstressregs0x10 Build and Test"
- **Windows_NT arm64 Cross Checked jitstressregs0x1000 Build and Test**: "test Windows_NT arm64 Cross Checked jitstressregs0x1000 Build and Test"
- **Windows_NT arm64 Cross Checked jitstressregs0x80 Build and Test**: "test Windows_NT arm64 Cross Checked jitstressregs0x80 Build and Test"
- **Windows_NT arm64 Cross Checked jitstressregs1 Build and Test**: "test Windows_NT arm64 Cross Checked jitstressregs1 Build and Test"
- **Windows_NT arm64 Cross Checked jitstressregs2 Build and Test**: "test Windows_NT arm64 Cross Checked jitstressregs2 Build and Test"
- **Windows_NT arm64 Cross Checked jitstressregs3 Build and Test**: "test Windows_NT arm64 Cross Checked jitstressregs3 Build and Test"
- **Windows_NT arm64 Cross Checked jitstressregs4 Build and Test**: "test Windows_NT arm64 Cross Checked jitstressregs4 Build and Test"
- **Windows_NT arm64 Cross Checked jitstressregs8 Build and Test**: "test Windows_NT arm64 Cross Checked jitstressregs8 Build and Test"
- **Windows_NT arm64 Cross Checked minopts Build and Test**: "test Windows_NT arm64 Cross Checked minopts Build and Test"
- **Windows_NT arm64 Cross Checked no_tiered_compilation Build and Test**: "test Windows_NT arm64 Cross Checked no_tiered_compilation Build and Test"
- **Windows_NT arm64 Cross Checked no_tiered_compilation_innerloop Build and Test**: "test Windows_NT arm64 Cross Checked no_tiered_compilation_innerloop Build and Test"
- **Windows_NT arm64 Cross Checked normal Build and Test**: "test Windows_NT arm64 Cross Checked normal Build and Test"
- **Windows_NT arm64 Cross Checked r2r Build and Test**: "test Windows_NT arm64 Cross Checked r2r Build and Test"
- **Windows_NT arm64 Cross Checked r2r_gcstress15 Build and Test**: "test Windows_NT arm64 Cross Checked r2r_gcstress15 Build and Test"
- **Windows_NT arm64 Cross Checked r2r_jitforcerelocs Build and Test**: "test Windows_NT arm64 Cross Checked r2r_jitforcerelocs Build and Test"
- **Windows_NT arm64 Cross Checked r2r_jitminopts Build and Test**: "test Windows_NT arm64 Cross Checked r2r_jitminopts Build and Test"
- **Windows_NT arm64 Cross Checked r2r_jitstress1 Build and Test**: "test Windows_NT arm64 Cross Checked r2r_jitstress1 Build and Test"
- **Windows_NT arm64 Cross Checked r2r_jitstress1_tiered Build and Test**: "test Windows_NT arm64 Cross Checked r2r_jitstress1_tiered Build and Test"
- **Windows_NT arm64 Cross Checked r2r_jitstress2 Build and Test**: "test Windows_NT arm64 Cross Checked r2r_jitstress2 Build and Test"
- **Windows_NT arm64 Cross Checked r2r_jitstress2_tiered Build and Test**: "test Windows_NT arm64 Cross Checked r2r_jitstress2_tiered Build and Test"
- **Windows_NT arm64 Cross Checked r2r_jitstressregs0x10 Build and Test**: "test Windows_NT arm64 Cross Checked r2r_jitstressregs0x10 Build and Test"
- **Windows_NT arm64 Cross Checked r2r_jitstressregs0x1000 Build and Test**: "test Windows_NT arm64 Cross Checked r2r_jitstressregs0x1000 Build and Test"
- **Windows_NT arm64 Cross Checked r2r_jitstressregs0x80 Build and Test**: "test Windows_NT arm64 Cross Checked r2r_jitstressregs0x80 Build and Test"
- **Windows_NT arm64 Cross Checked r2r_jitstressregs1 Build and Test**: "test Windows_NT arm64 Cross Checked r2r_jitstressregs1 Build and Test"
- **Windows_NT arm64 Cross Checked r2r_jitstressregs2 Build and Test**: "test Windows_NT arm64 Cross Checked r2r_jitstressregs2 Build and Test"
- **Windows_NT arm64 Cross Checked r2r_jitstressregs3 Build and Test**: "test Windows_NT arm64 Cross Checked r2r_jitstressregs3 Build and Test"
- **Windows_NT arm64 Cross Checked r2r_jitstressregs4 Build and Test**: "test Windows_NT arm64 Cross Checked r2r_jitstressregs4 Build and Test"
- **Windows_NT arm64 Cross Checked r2r_jitstressregs8 Build and Test**: "test Windows_NT arm64 Cross Checked r2r_jitstressregs8 Build and Test"
- **Windows_NT arm64 Cross Checked r2r_no_tiered_compilation Build and Test**: "test Windows_NT arm64 Cross Checked r2r_no_tiered_compilation Build and Test"
- **Windows_NT arm64 Cross Checked tailcallstress Build and Test**: "test Windows_NT arm64 Cross Checked tailcallstress Build and Test"
- **Windows_NT arm64 Cross Checked tieredcompilation Build and Test**: "test Windows_NT arm64 Cross Checked tieredcompilation Build and Test"
- **Windows_NT arm64 Cross Checked zapdisable Build and Test**: "test Windows_NT arm64 Cross Checked zapdisable Build and Test"
- **Windows_NT arm64 Cross Debug Innerloop Build**: "test Windows_NT arm64 Cross Debug Innerloop Build"
- **Windows_NT arm64 Cross Debug normal Build**: "test Windows_NT arm64 Cross Debug normal Build"
- **Windows_NT arm64 Cross Release normal Build and Test**: "test Windows_NT arm64 Cross Release normal Build and Test"
- **Windows_NT arm64 Cross Release r2r Build and Test**: "test Windows_NT arm64 Cross Release r2r Build and Test"
- **Windows_NT x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JITMinOpts=1)**: "test Windows_NT x64 Checked corefx_minopts"
- **Windows_NT x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStress=1)**: "test Windows_NT x64 Checked corefx_jitstress1"
- **Windows_NT x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStress=2)**: "test Windows_NT x64 Checked corefx_jitstress2"
- **Windows_NT x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=0x10)**: "test Windows_NT x64 Checked corefx_jitstressregs0x10"
- **Windows_NT x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=0x1000)**: "test Windows_NT x64 Checked corefx_jitstressregs0x1000"
- **Windows_NT x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=0x80)**: "test Windows_NT x64 Checked corefx_jitstressregs0x80"
- **Windows_NT x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=1)**: "test Windows_NT x64 Checked corefx_jitstressregs1"
- **Windows_NT x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=2)**: "test Windows_NT x64 Checked corefx_jitstressregs2"
- **Windows_NT x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=3)**: "test Windows_NT x64 Checked corefx_jitstressregs3"
- **Windows_NT x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=4)**: "test Windows_NT x64 Checked corefx_jitstressregs4"
- **Windows_NT x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=8)**: "test Windows_NT x64 Checked corefx_jitstressregs8"
- **Windows_NT x64 Checked Build and Test (Jit - CoreFx TieredCompilation=0)**: "test Windows_NT x64 Checked corefx_baseline"
- **Windows_NT x64 Checked Build and Test (Jit - CoreFx TieredCompilation=1)**: "test Windows_NT x64 Checked corefx_tieredcompilation"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 EnableAVX=0 EnableSSE3_4=0)**: "test Windows_NT x64 Checked jitsse2only"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 EnableIncompleteISAClass=1 EnableAVX=0)**: "test Windows_NT x64 Checked jitx86hwintrinsicnoavx"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 EnableIncompleteISAClass=1 EnableAVX2=0)**: "test Windows_NT x64 Checked jitx86hwintrinsicnoavx2"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 EnableIncompleteISAClass=1 EnableSSE=0 EnableSSE2=0 EnableSSE3=0 EnableSSSE3=0 EnableSSE41=0 EnableSSE42=0 EnableAVX=0 EnableAVX2=0 EnableAES=0 EnableBMI1=0 EnableBMI2=0 EnableFMA=0 EnableLZCNT=0 EnablePCLMULQDQ=0 EnablePOPCNT=0)**: "test Windows_NT x64 Checked jitnox86hwintrinsic"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 EnableIncompleteISAClass=1 FeatureSIMD=0)**: "test Windows_NT x64 Checked jitx86hwintrinsicnosimd"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 EnableIncompleteISAClass=1)**: "test Windows_NT x64 Checked jitincompletehwintrinsic"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 FeatureSIMD=0)**: "test Windows_NT x64 Checked jitnosimd"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 ForceRelocs=1)**: "test Windows_NT x64 Checked forcerelocs"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0x3)**: "test Windows_NT x64 Checked gcstress0x3"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC JITMinOpts=1 HeapVerify=1)**: "test Windows_NT x64 Checked gcstress0xc_minopts_heapverify1"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC JitStress=1)**: "test Windows_NT x64 Checked gcstress0xc_jitstress1"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC JitStress=2)**: "test Windows_NT x64 Checked gcstress0xc_jitstress2"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC ZapDisable=1 ReadyToRun=0 HeapVerify=1)**: "test Windows_NT x64 Checked gcstress0xc_zapdisable_heapverify1"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC ZapDisable=1 ReadyToRun=0 JitStress=2)**: "test Windows_NT x64 Checked gcstress0xc_zapdisable_jitstress2"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC ZapDisable=1 ReadyToRun=0)**: "test Windows_NT x64 Checked gcstress0xc_zapdisable"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC)**: "test Windows_NT x64 Checked gcstress0xc"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 HeapVerify=1)**: "test Windows_NT x64 Checked heapverify1"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 JITMinOpts=1)**: "test Windows_NT x64 Checked minopts"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=1)**: "test Windows_NT x64 Checked jitstress1"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=0x10)**: "test Windows_NT x64 Checked jitstress2_jitstressregs0x10"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=0x1000)**: "test Windows_NT x64 Checked jitstress2_jitstressregs0x1000"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=0x80)**: "test Windows_NT x64 Checked jitstress2_jitstressregs0x80"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=1)**: "test Windows_NT x64 Checked jitstress2_jitstressregs1"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=2)**: "test Windows_NT x64 Checked jitstress2_jitstressregs2"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=3)**: "test Windows_NT x64 Checked jitstress2_jitstressregs3"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=4)**: "test Windows_NT x64 Checked jitstress2_jitstressregs4"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=8)**: "test Windows_NT x64 Checked jitstress2_jitstressregs8"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2)**: "test Windows_NT x64 Checked jitstress2"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=0x10)**: "test Windows_NT x64 Checked jitstressregs0x10"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=0x1000)**: "test Windows_NT x64 Checked jitstressregs0x1000"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=0x80)**: "test Windows_NT x64 Checked jitstressregs0x80"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=1)**: "test Windows_NT x64 Checked jitstressregs1"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=2)**: "test Windows_NT x64 Checked jitstressregs2"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=3)**: "test Windows_NT x64 Checked jitstressregs3"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=4)**: "test Windows_NT x64 Checked jitstressregs4"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=8)**: "test Windows_NT x64 Checked jitstressregs8"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 TailcallStress=1)**: "test Windows_NT x64 Checked tailcallstress"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0 ZapDisable=1 ReadyToRun=0)**: "test Windows_NT x64 Checked zapdisable"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=0)**: "test Windows_NT x64 Checked no_tiered_compilation"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=1 JitStress=1)**: "test Windows_NT x64 Checked jitstress1_tiered"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=1 JitStress=2)**: "test Windows_NT x64 Checked jitstress2_tiered"
- **Windows_NT x64 Checked Build and Test (Jit - TieredCompilation=1)**: "test Windows_NT x64 Checked tieredcompilation"
- **Windows_NT x64 Checked Build and Test**: "test Windows_NT x64 Build and Test"
- **Windows_NT x64 Checked CoreFX Tests**: "test Windows_NT x64 Checked CoreFX Tests"
- **Windows_NT x64 Checked GC Reliability Framework**: "test Windows_NT Checked gc_reliability_framework"
- **Windows_NT x64 Checked Innerloop Build and Test (Jit - TieredCompilation=0)**: "test Windows_NT x64 Checked Innerloop Build and Test (Jit - TieredCompilation=0)"
- **Windows_NT x64 Checked Innerloop Build and Test**: "test Windows_NT x64 Checked Innerloop Build and Test"
- **Windows_NT x64 Checked R2R Build & Test**: "test Windows_NT x64 Checked r2r"
- **Windows_NT x64 Checked R2R gcstress15 Build & Test**: "test Windows_NT x64 Checked r2r_gcstress15"
- **Windows_NT x64 Checked R2R jitforcerelocs Build & Test**: "test Windows_NT x64 Checked r2r_jitforcerelocs"
- **Windows_NT x64 Checked R2R jitminopts Build & Test**: "test Windows_NT x64 Checked r2r_jitminopts"
- **Windows_NT x64 Checked R2R jitstress1 Build & Test**: "test Windows_NT x64 Checked r2r_jitstress1"
- **Windows_NT x64 Checked R2R jitstress1_tiered Build & Test**: "test Windows_NT x64 Checked r2r_jitstress1_tiered"
- **Windows_NT x64 Checked R2R jitstress2 Build & Test**: "test Windows_NT x64 Checked r2r_jitstress2"
- **Windows_NT x64 Checked R2R jitstress2_tiered Build & Test**: "test Windows_NT x64 Checked r2r_jitstress2_tiered"
- **Windows_NT x64 Checked R2R jitstressregs0x10 Build & Test**: "test Windows_NT x64 Checked r2r_jitstressregs0x10"
- **Windows_NT x64 Checked R2R jitstressregs0x1000 Build & Test**: "test Windows_NT x64 Checked r2r_jitstressregs0x1000"
- **Windows_NT x64 Checked R2R jitstressregs0x80 Build & Test**: "test Windows_NT x64 Checked r2r_jitstressregs0x80"
- **Windows_NT x64 Checked R2R jitstressregs1 Build & Test**: "test Windows_NT x64 Checked r2r_jitstressregs1"
- **Windows_NT x64 Checked R2R jitstressregs2 Build & Test**: "test Windows_NT x64 Checked r2r_jitstressregs2"
- **Windows_NT x64 Checked R2R jitstressregs3 Build & Test**: "test Windows_NT x64 Checked r2r_jitstressregs3"
- **Windows_NT x64 Checked R2R jitstressregs4 Build & Test**: "test Windows_NT x64 Checked r2r_jitstressregs4"
- **Windows_NT x64 Checked R2R jitstressregs8 Build & Test**: "test Windows_NT x64 Checked r2r_jitstressregs8"
- **Windows_NT x64 Checked R2R no_tiered_compilation Build & Test**: "test Windows_NT x64 Checked r2r_no_tiered_compilation"
- **Windows_NT x64 Checked Standalone GC**: "test Windows_NT Checked standalone_gc"
- **Windows_NT x64 Checked via ILLink**: "test Windows_NT x64 Checked illink"
- **Windows_NT x64 Debug via ILLink**: "test Windows_NT x64 Debug illink"
- **Windows_NT x64 Formatting**: "test Windows_NT x64 Formatting"
- **Windows_NT x64 Release GC Reliability Framework**: "test Windows_NT Release gc_reliability_framework"
- **Windows_NT x64 Release GC Simulator**: "test Windows_NT Release gcsimulator"
- **Windows_NT x64 Release IL RoundTrip Build and Test**: "test Windows_NT ilrt"
- **Windows_NT x64 Release Long-Running GC Build & Test**: "test Windows_NT Release longgc"
- **Windows_NT x64 Release R2R Build & Test**: "test Windows_NT x64 Release r2r"
- **Windows_NT x64 Release Standalone GC**: "test Windows_NT Release standalone_gc"
- **Windows_NT x64 Release via ILLink**: "test Windows_NT x64 Release illink"
- **Windows_NT x64_arm64_altjit Checked Build and Test**: "test Windows_NT x64_arm64_altjit Checked Build and Test"
- **Windows_NT x64_arm64_altjit Checked corefx_baseline**: "test Windows_NT x64_arm64_altjit Checked corefx_baseline"
- **Windows_NT x64_arm64_altjit Checked corefx_jitstress1**: "test Windows_NT x64_arm64_altjit Checked corefx_jitstress1"
- **Windows_NT x64_arm64_altjit Checked corefx_jitstress2**: "test Windows_NT x64_arm64_altjit Checked corefx_jitstress2"
- **Windows_NT x64_arm64_altjit Checked corefx_jitstressregs0x10**: "test Windows_NT x64_arm64_altjit Checked corefx_jitstressregs0x10"
- **Windows_NT x64_arm64_altjit Checked corefx_jitstressregs0x1000**: "test Windows_NT x64_arm64_altjit Checked corefx_jitstressregs0x1000"
- **Windows_NT x64_arm64_altjit Checked corefx_jitstressregs0x80**: "test Windows_NT x64_arm64_altjit Checked corefx_jitstressregs0x80"
- **Windows_NT x64_arm64_altjit Checked corefx_jitstressregs1**: "test Windows_NT x64_arm64_altjit Checked corefx_jitstressregs1"
- **Windows_NT x64_arm64_altjit Checked corefx_jitstressregs2**: "test Windows_NT x64_arm64_altjit Checked corefx_jitstressregs2"
- **Windows_NT x64_arm64_altjit Checked corefx_jitstressregs3**: "test Windows_NT x64_arm64_altjit Checked corefx_jitstressregs3"
- **Windows_NT x64_arm64_altjit Checked corefx_jitstressregs4**: "test Windows_NT x64_arm64_altjit Checked corefx_jitstressregs4"
- **Windows_NT x64_arm64_altjit Checked corefx_jitstressregs8**: "test Windows_NT x64_arm64_altjit Checked corefx_jitstressregs8"
- **Windows_NT x64_arm64_altjit Checked corefx_minopts**: "test Windows_NT x64_arm64_altjit Checked corefx_minopts"
- **Windows_NT x64_arm64_altjit Checked corefx_tieredcompilation**: "test Windows_NT x64_arm64_altjit Checked corefx_tieredcompilation"
- **Windows_NT x64_arm64_altjit Checked forcerelocs**: "test Windows_NT x64_arm64_altjit Checked forcerelocs"
- **Windows_NT x64_arm64_altjit Checked jitincompletehwintrinsic**: "test Windows_NT x64_arm64_altjit Checked jitincompletehwintrinsic"
- **Windows_NT x64_arm64_altjit Checked jitnosimd**: "test Windows_NT x64_arm64_altjit Checked jitnosimd"
- **Windows_NT x64_arm64_altjit Checked jitnox86hwintrinsic**: "test Windows_NT x64_arm64_altjit Checked jitnox86hwintrinsic"
- **Windows_NT x64_arm64_altjit Checked jitsse2only**: "test Windows_NT x64_arm64_altjit Checked jitsse2only"
- **Windows_NT x64_arm64_altjit Checked jitstress1**: "test Windows_NT x64_arm64_altjit Checked jitstress1"
- **Windows_NT x64_arm64_altjit Checked jitstress1_tiered**: "test Windows_NT x64_arm64_altjit Checked jitstress1_tiered"
- **Windows_NT x64_arm64_altjit Checked jitstress2**: "test Windows_NT x64_arm64_altjit Checked jitstress2"
- **Windows_NT x64_arm64_altjit Checked jitstress2_jitstressregs0x10**: "test Windows_NT x64_arm64_altjit Checked jitstress2_jitstressregs0x10"
- **Windows_NT x64_arm64_altjit Checked jitstress2_jitstressregs0x1000**: "test Windows_NT x64_arm64_altjit Checked jitstress2_jitstressregs0x1000"
- **Windows_NT x64_arm64_altjit Checked jitstress2_jitstressregs0x80**: "test Windows_NT x64_arm64_altjit Checked jitstress2_jitstressregs0x80"
- **Windows_NT x64_arm64_altjit Checked jitstress2_jitstressregs1**: "test Windows_NT x64_arm64_altjit Checked jitstress2_jitstressregs1"
- **Windows_NT x64_arm64_altjit Checked jitstress2_jitstressregs2**: "test Windows_NT x64_arm64_altjit Checked jitstress2_jitstressregs2"
- **Windows_NT x64_arm64_altjit Checked jitstress2_jitstressregs3**: "test Windows_NT x64_arm64_altjit Checked jitstress2_jitstressregs3"
- **Windows_NT x64_arm64_altjit Checked jitstress2_jitstressregs4**: "test Windows_NT x64_arm64_altjit Checked jitstress2_jitstressregs4"
- **Windows_NT x64_arm64_altjit Checked jitstress2_jitstressregs8**: "test Windows_NT x64_arm64_altjit Checked jitstress2_jitstressregs8"
- **Windows_NT x64_arm64_altjit Checked jitstress2_tiered**: "test Windows_NT x64_arm64_altjit Checked jitstress2_tiered"
- **Windows_NT x64_arm64_altjit Checked jitstressregs0x10**: "test Windows_NT x64_arm64_altjit Checked jitstressregs0x10"
- **Windows_NT x64_arm64_altjit Checked jitstressregs0x1000**: "test Windows_NT x64_arm64_altjit Checked jitstressregs0x1000"
- **Windows_NT x64_arm64_altjit Checked jitstressregs0x80**: "test Windows_NT x64_arm64_altjit Checked jitstressregs0x80"
- **Windows_NT x64_arm64_altjit Checked jitstressregs1**: "test Windows_NT x64_arm64_altjit Checked jitstressregs1"
- **Windows_NT x64_arm64_altjit Checked jitstressregs2**: "test Windows_NT x64_arm64_altjit Checked jitstressregs2"
- **Windows_NT x64_arm64_altjit Checked jitstressregs3**: "test Windows_NT x64_arm64_altjit Checked jitstressregs3"
- **Windows_NT x64_arm64_altjit Checked jitstressregs4**: "test Windows_NT x64_arm64_altjit Checked jitstressregs4"
- **Windows_NT x64_arm64_altjit Checked jitstressregs8**: "test Windows_NT x64_arm64_altjit Checked jitstressregs8"
- **Windows_NT x64_arm64_altjit Checked jitx86hwintrinsicnoavx**: "test Windows_NT x64_arm64_altjit Checked jitx86hwintrinsicnoavx"
- **Windows_NT x64_arm64_altjit Checked jitx86hwintrinsicnoavx2**: "test Windows_NT x64_arm64_altjit Checked jitx86hwintrinsicnoavx2"
- **Windows_NT x64_arm64_altjit Checked jitx86hwintrinsicnosimd**: "test Windows_NT x64_arm64_altjit Checked jitx86hwintrinsicnosimd"
- **Windows_NT x64_arm64_altjit Checked minopts**: "test Windows_NT x64_arm64_altjit Checked minopts"
- **Windows_NT x64_arm64_altjit Checked no_tiered_compilation**: "test Windows_NT x64_arm64_altjit Checked no_tiered_compilation"
- **Windows_NT x64_arm64_altjit Checked no_tiered_compilation_innerloop**: "test Windows_NT x64_arm64_altjit Checked no_tiered_compilation_innerloop"
- **Windows_NT x64_arm64_altjit Checked r2r**: "test Windows_NT x64_arm64_altjit Checked r2r"
- **Windows_NT x64_arm64_altjit Checked r2r_jitforcerelocs**: "test Windows_NT x64_arm64_altjit Checked r2r_jitforcerelocs"
- **Windows_NT x64_arm64_altjit Checked r2r_jitminopts**: "test Windows_NT x64_arm64_altjit Checked r2r_jitminopts"
- **Windows_NT x64_arm64_altjit Checked r2r_jitstress1**: "test Windows_NT x64_arm64_altjit Checked r2r_jitstress1"
- **Windows_NT x64_arm64_altjit Checked r2r_jitstress1_tiered**: "test Windows_NT x64_arm64_altjit Checked r2r_jitstress1_tiered"
- **Windows_NT x64_arm64_altjit Checked r2r_jitstress2**: "test Windows_NT x64_arm64_altjit Checked r2r_jitstress2"
- **Windows_NT x64_arm64_altjit Checked r2r_jitstress2_tiered**: "test Windows_NT x64_arm64_altjit Checked r2r_jitstress2_tiered"
- **Windows_NT x64_arm64_altjit Checked r2r_jitstressregs0x10**: "test Windows_NT x64_arm64_altjit Checked r2r_jitstressregs0x10"
- **Windows_NT x64_arm64_altjit Checked r2r_jitstressregs0x1000**: "test Windows_NT x64_arm64_altjit Checked r2r_jitstressregs0x1000"
- **Windows_NT x64_arm64_altjit Checked r2r_jitstressregs0x80**: "test Windows_NT x64_arm64_altjit Checked r2r_jitstressregs0x80"
- **Windows_NT x64_arm64_altjit Checked r2r_jitstressregs1**: "test Windows_NT x64_arm64_altjit Checked r2r_jitstressregs1"
- **Windows_NT x64_arm64_altjit Checked r2r_jitstressregs2**: "test Windows_NT x64_arm64_altjit Checked r2r_jitstressregs2"
- **Windows_NT x64_arm64_altjit Checked r2r_jitstressregs3**: "test Windows_NT x64_arm64_altjit Checked r2r_jitstressregs3"
- **Windows_NT x64_arm64_altjit Checked r2r_jitstressregs4**: "test Windows_NT x64_arm64_altjit Checked r2r_jitstressregs4"
- **Windows_NT x64_arm64_altjit Checked r2r_jitstressregs8**: "test Windows_NT x64_arm64_altjit Checked r2r_jitstressregs8"
- **Windows_NT x64_arm64_altjit Checked r2r_no_tiered_compilation**: "test Windows_NT x64_arm64_altjit Checked r2r_no_tiered_compilation"
- **Windows_NT x64_arm64_altjit Checked tailcallstress**: "test Windows_NT x64_arm64_altjit Checked tailcallstress"
- **Windows_NT x64_arm64_altjit Checked tieredcompilation**: "test Windows_NT x64_arm64_altjit Checked tieredcompilation"
- **Windows_NT x64_arm64_altjit Debug Build and Test**: "test Windows_NT x64_arm64_altjit Debug Build and Test"
- **Windows_NT x64_arm64_altjit Release Build and Test**: "test Windows_NT x64_arm64_altjit Release Build and Test"
- **Windows_NT x64_arm64_altjit Release r2r**: "test Windows_NT x64_arm64_altjit Release r2r"
- **Windows_NT x86 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JITMinOpts=1)**: "test Windows_NT x86 Checked corefx_minopts"
- **Windows_NT x86 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStress=1)**: "test Windows_NT x86 Checked corefx_jitstress1"
- **Windows_NT x86 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStress=2)**: "test Windows_NT x86 Checked corefx_jitstress2"
- **Windows_NT x86 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=0x10)**: "test Windows_NT x86 Checked corefx_jitstressregs0x10"
- **Windows_NT x86 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=0x1000)**: "test Windows_NT x86 Checked corefx_jitstressregs0x1000"
- **Windows_NT x86 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=0x80)**: "test Windows_NT x86 Checked corefx_jitstressregs0x80"
- **Windows_NT x86 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=1)**: "test Windows_NT x86 Checked corefx_jitstressregs1"
- **Windows_NT x86 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=2)**: "test Windows_NT x86 Checked corefx_jitstressregs2"
- **Windows_NT x86 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=3)**: "test Windows_NT x86 Checked corefx_jitstressregs3"
- **Windows_NT x86 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=4)**: "test Windows_NT x86 Checked corefx_jitstressregs4"
- **Windows_NT x86 Checked Build and Test (Jit - CoreFx TieredCompilation=0 JitStressRegs=8)**: "test Windows_NT x86 Checked corefx_jitstressregs8"
- **Windows_NT x86 Checked Build and Test (Jit - CoreFx TieredCompilation=0)**: "test Windows_NT x86 Checked corefx_baseline"
- **Windows_NT x86 Checked Build and Test (Jit - CoreFx TieredCompilation=1)**: "test Windows_NT x86 Checked corefx_tieredcompilation"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 EnableAVX=0 EnableSSE3_4=0)**: "test Windows_NT x86 Checked jitsse2only"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 EnableIncompleteISAClass=1 EnableAVX=0)**: "test Windows_NT x86 Checked jitx86hwintrinsicnoavx"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 EnableIncompleteISAClass=1 EnableAVX2=0)**: "test Windows_NT x86 Checked jitx86hwintrinsicnoavx2"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 EnableIncompleteISAClass=1 EnableSSE=0 EnableSSE2=0 EnableSSE3=0 EnableSSSE3=0 EnableSSE41=0 EnableSSE42=0 EnableAVX=0 EnableAVX2=0 EnableAES=0 EnableBMI1=0 EnableBMI2=0 EnableFMA=0 EnableLZCNT=0 EnablePCLMULQDQ=0 EnablePOPCNT=0)**: "test Windows_NT x86 Checked jitnox86hwintrinsic"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 EnableIncompleteISAClass=1 FeatureSIMD=0)**: "test Windows_NT x86 Checked jitx86hwintrinsicnosimd"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 EnableIncompleteISAClass=1)**: "test Windows_NT x86 Checked jitincompletehwintrinsic"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 FeatureSIMD=0)**: "test Windows_NT x86 Checked jitnosimd"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 ForceRelocs=1)**: "test Windows_NT x86 Checked forcerelocs"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0x3)**: "test Windows_NT x86 Checked gcstress0x3"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC JITMinOpts=1 HeapVerify=1)**: "test Windows_NT x86 Checked gcstress0xc_minopts_heapverify1"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC JitStress=1)**: "test Windows_NT x86 Checked gcstress0xc_jitstress1"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC JitStress=2)**: "test Windows_NT x86 Checked gcstress0xc_jitstress2"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC ZapDisable=1 ReadyToRun=0 HeapVerify=1)**: "test Windows_NT x86 Checked gcstress0xc_zapdisable_heapverify1"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC ZapDisable=1 ReadyToRun=0 JitStress=2)**: "test Windows_NT x86 Checked gcstress0xc_zapdisable_jitstress2"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC ZapDisable=1 ReadyToRun=0)**: "test Windows_NT x86 Checked gcstress0xc_zapdisable"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 GCStress=0xC)**: "test Windows_NT x86 Checked gcstress0xc"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 HeapVerify=1)**: "test Windows_NT x86 Checked heapverify1"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 JITMinOpts=1)**: "test Windows_NT x86 Checked minopts"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 JitStress=1)**: "test Windows_NT x86 Checked jitstress1"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=0x10)**: "test Windows_NT x86 Checked jitstress2_jitstressregs0x10"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=0x1000)**: "test Windows_NT x86 Checked jitstress2_jitstressregs0x1000"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=0x80)**: "test Windows_NT x86 Checked jitstress2_jitstressregs0x80"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=1)**: "test Windows_NT x86 Checked jitstress2_jitstressregs1"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=2)**: "test Windows_NT x86 Checked jitstress2_jitstressregs2"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=3)**: "test Windows_NT x86 Checked jitstress2_jitstressregs3"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=4)**: "test Windows_NT x86 Checked jitstress2_jitstressregs4"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2 JitStressRegs=8)**: "test Windows_NT x86 Checked jitstress2_jitstressregs8"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 JitStress=2)**: "test Windows_NT x86 Checked jitstress2"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=0x10)**: "test Windows_NT x86 Checked jitstressregs0x10"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=0x1000)**: "test Windows_NT x86 Checked jitstressregs0x1000"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=0x80)**: "test Windows_NT x86 Checked jitstressregs0x80"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=1)**: "test Windows_NT x86 Checked jitstressregs1"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=2)**: "test Windows_NT x86 Checked jitstressregs2"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=3)**: "test Windows_NT x86 Checked jitstressregs3"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=4)**: "test Windows_NT x86 Checked jitstressregs4"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 JitStressRegs=8)**: "test Windows_NT x86 Checked jitstressregs8"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 TailcallStress=1)**: "test Windows_NT x86 Checked tailcallstress"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0 ZapDisable=1 ReadyToRun=0)**: "test Windows_NT x86 Checked zapdisable"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=0)**: "test Windows_NT x86 Checked no_tiered_compilation"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=1 JitStress=1)**: "test Windows_NT x86 Checked jitstress1_tiered"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=1 JitStress=2)**: "test Windows_NT x86 Checked jitstress2_tiered"
- **Windows_NT x86 Checked Build and Test (Jit - TieredCompilation=1)**: "test Windows_NT x86 Checked tieredcompilation"
- **Windows_NT x86 Checked Build and Test**: "test Windows_NT x86 Checked Build and Test"
- **Windows_NT x86 Checked Innerloop Build and Test (Jit - TieredCompilation=0)**: "test Windows_NT x86 Checked Innerloop Build and Test (Jit - TieredCompilation=0)"
- **Windows_NT x86 Checked Innerloop Build and Test**: "test Windows_NT x86 Checked Innerloop Build and Test"
- **Windows_NT x86 Checked R2R Build & Test**: "test Windows_NT x86 Checked r2r"
- **Windows_NT x86 Checked R2R gcstress15 Build & Test**: "test Windows_NT x86 Checked r2r_gcstress15"
- **Windows_NT x86 Checked R2R jitforcerelocs Build & Test**: "test Windows_NT x86 Checked r2r_jitforcerelocs"
- **Windows_NT x86 Checked R2R jitminopts Build & Test**: "test Windows_NT x86 Checked r2r_jitminopts"
- **Windows_NT x86 Checked R2R jitstress1 Build & Test**: "test Windows_NT x86 Checked r2r_jitstress1"
- **Windows_NT x86 Checked R2R jitstress1_tiered Build & Test**: "test Windows_NT x86 Checked r2r_jitstress1_tiered"
- **Windows_NT x86 Checked R2R jitstress2 Build & Test**: "test Windows_NT x86 Checked r2r_jitstress2"
- **Windows_NT x86 Checked R2R jitstress2_tiered Build & Test**: "test Windows_NT x86 Checked r2r_jitstress2_tiered"
- **Windows_NT x86 Checked R2R jitstressregs0x10 Build & Test**: "test Windows_NT x86 Checked r2r_jitstressregs0x10"
- **Windows_NT x86 Checked R2R jitstressregs0x1000 Build & Test**: "test Windows_NT x86 Checked r2r_jitstressregs0x1000"
- **Windows_NT x86 Checked R2R jitstressregs0x80 Build & Test**: "test Windows_NT x86 Checked r2r_jitstressregs0x80"
- **Windows_NT x86 Checked R2R jitstressregs1 Build & Test**: "test Windows_NT x86 Checked r2r_jitstressregs1"
- **Windows_NT x86 Checked R2R jitstressregs2 Build & Test**: "test Windows_NT x86 Checked r2r_jitstressregs2"
- **Windows_NT x86 Checked R2R jitstressregs3 Build & Test**: "test Windows_NT x86 Checked r2r_jitstressregs3"
- **Windows_NT x86 Checked R2R jitstressregs4 Build & Test**: "test Windows_NT x86 Checked r2r_jitstressregs4"
- **Windows_NT x86 Checked R2R jitstressregs8 Build & Test**: "test Windows_NT x86 Checked r2r_jitstressregs8"
- **Windows_NT x86 Checked R2R no_tiered_compilation Build & Test**: "test Windows_NT x86 Checked r2r_no_tiered_compilation"
- **Windows_NT x86 Checked via ILLink**: "test Windows_NT x86 Checked illink"
- **Windows_NT x86 Debug via ILLink**: "test Windows_NT x86 Debug illink"
- **Windows_NT x86 Release Innerloop Build and Test**: "test Windows_NT x86 Release Innerloop Build and Test"
- **Windows_NT x86 Release R2R Build & Test**: "test Windows_NT x86 Release r2r"
- **Windows_NT x86 Release via ILLink**: "test Windows_NT x86 Release illink"
- **Windows_NT x86_arm_altjit Checked Build and Test**: "test Windows_NT x86_arm_altjit Checked Build and Test"
- **Windows_NT x86_arm_altjit Checked corefx_baseline**: "test Windows_NT x86_arm_altjit Checked corefx_baseline"
- **Windows_NT x86_arm_altjit Checked corefx_jitstress1**: "test Windows_NT x86_arm_altjit Checked corefx_jitstress1"
- **Windows_NT x86_arm_altjit Checked corefx_jitstress2**: "test Windows_NT x86_arm_altjit Checked corefx_jitstress2"
- **Windows_NT x86_arm_altjit Checked corefx_jitstressregs0x10**: "test Windows_NT x86_arm_altjit Checked corefx_jitstressregs0x10"
- **Windows_NT x86_arm_altjit Checked corefx_jitstressregs0x1000**: "test Windows_NT x86_arm_altjit Checked corefx_jitstressregs0x1000"
- **Windows_NT x86_arm_altjit Checked corefx_jitstressregs0x80**: "test Windows_NT x86_arm_altjit Checked corefx_jitstressregs0x80"
- **Windows_NT x86_arm_altjit Checked corefx_jitstressregs1**: "test Windows_NT x86_arm_altjit Checked corefx_jitstressregs1"
- **Windows_NT x86_arm_altjit Checked corefx_jitstressregs2**: "test Windows_NT x86_arm_altjit Checked corefx_jitstressregs2"
- **Windows_NT x86_arm_altjit Checked corefx_jitstressregs3**: "test Windows_NT x86_arm_altjit Checked corefx_jitstressregs3"
- **Windows_NT x86_arm_altjit Checked corefx_jitstressregs4**: "test Windows_NT x86_arm_altjit Checked corefx_jitstressregs4"
- **Windows_NT x86_arm_altjit Checked corefx_jitstressregs8**: "test Windows_NT x86_arm_altjit Checked corefx_jitstressregs8"
- **Windows_NT x86_arm_altjit Checked corefx_minopts**: "test Windows_NT x86_arm_altjit Checked corefx_minopts"
- **Windows_NT x86_arm_altjit Checked corefx_tieredcompilation**: "test Windows_NT x86_arm_altjit Checked corefx_tieredcompilation"
- **Windows_NT x86_arm_altjit Checked forcerelocs**: "test Windows_NT x86_arm_altjit Checked forcerelocs"
- **Windows_NT x86_arm_altjit Checked jitincompletehwintrinsic**: "test Windows_NT x86_arm_altjit Checked jitincompletehwintrinsic"
- **Windows_NT x86_arm_altjit Checked jitnosimd**: "test Windows_NT x86_arm_altjit Checked jitnosimd"
- **Windows_NT x86_arm_altjit Checked jitnox86hwintrinsic**: "test Windows_NT x86_arm_altjit Checked jitnox86hwintrinsic"
- **Windows_NT x86_arm_altjit Checked jitsse2only**: "test Windows_NT x86_arm_altjit Checked jitsse2only"
- **Windows_NT x86_arm_altjit Checked jitstress1**: "test Windows_NT x86_arm_altjit Checked jitstress1"
- **Windows_NT x86_arm_altjit Checked jitstress1_tiered**: "test Windows_NT x86_arm_altjit Checked jitstress1_tiered"
- **Windows_NT x86_arm_altjit Checked jitstress2**: "test Windows_NT x86_arm_altjit Checked jitstress2"
- **Windows_NT x86_arm_altjit Checked jitstress2_jitstressregs0x10**: "test Windows_NT x86_arm_altjit Checked jitstress2_jitstressregs0x10"
- **Windows_NT x86_arm_altjit Checked jitstress2_jitstressregs0x1000**: "test Windows_NT x86_arm_altjit Checked jitstress2_jitstressregs0x1000"
- **Windows_NT x86_arm_altjit Checked jitstress2_jitstressregs0x80**: "test Windows_NT x86_arm_altjit Checked jitstress2_jitstressregs0x80"
- **Windows_NT x86_arm_altjit Checked jitstress2_jitstressregs1**: "test Windows_NT x86_arm_altjit Checked jitstress2_jitstressregs1"
- **Windows_NT x86_arm_altjit Checked jitstress2_jitstressregs2**: "test Windows_NT x86_arm_altjit Checked jitstress2_jitstressregs2"
- **Windows_NT x86_arm_altjit Checked jitstress2_jitstressregs3**: "test Windows_NT x86_arm_altjit Checked jitstress2_jitstressregs3"
- **Windows_NT x86_arm_altjit Checked jitstress2_jitstressregs4**: "test Windows_NT x86_arm_altjit Checked jitstress2_jitstressregs4"
- **Windows_NT x86_arm_altjit Checked jitstress2_jitstressregs8**: "test Windows_NT x86_arm_altjit Checked jitstress2_jitstressregs8"
- **Windows_NT x86_arm_altjit Checked jitstress2_tiered**: "test Windows_NT x86_arm_altjit Checked jitstress2_tiered"
- **Windows_NT x86_arm_altjit Checked jitstressregs0x10**: "test Windows_NT x86_arm_altjit Checked jitstressregs0x10"
- **Windows_NT x86_arm_altjit Checked jitstressregs0x1000**: "test Windows_NT x86_arm_altjit Checked jitstressregs0x1000"
- **Windows_NT x86_arm_altjit Checked jitstressregs0x80**: "test Windows_NT x86_arm_altjit Checked jitstressregs0x80"
- **Windows_NT x86_arm_altjit Checked jitstressregs1**: "test Windows_NT x86_arm_altjit Checked jitstressregs1"
- **Windows_NT x86_arm_altjit Checked jitstressregs2**: "test Windows_NT x86_arm_altjit Checked jitstressregs2"
- **Windows_NT x86_arm_altjit Checked jitstressregs3**: "test Windows_NT x86_arm_altjit Checked jitstressregs3"
- **Windows_NT x86_arm_altjit Checked jitstressregs4**: "test Windows_NT x86_arm_altjit Checked jitstressregs4"
- **Windows_NT x86_arm_altjit Checked jitstressregs8**: "test Windows_NT x86_arm_altjit Checked jitstressregs8"
- **Windows_NT x86_arm_altjit Checked jitx86hwintrinsicnoavx**: "test Windows_NT x86_arm_altjit Checked jitx86hwintrinsicnoavx"
- **Windows_NT x86_arm_altjit Checked jitx86hwintrinsicnoavx2**: "test Windows_NT x86_arm_altjit Checked jitx86hwintrinsicnoavx2"
- **Windows_NT x86_arm_altjit Checked jitx86hwintrinsicnosimd**: "test Windows_NT x86_arm_altjit Checked jitx86hwintrinsicnosimd"
- **Windows_NT x86_arm_altjit Checked minopts**: "test Windows_NT x86_arm_altjit Checked minopts"
- **Windows_NT x86_arm_altjit Checked no_tiered_compilation**: "test Windows_NT x86_arm_altjit Checked no_tiered_compilation"
- **Windows_NT x86_arm_altjit Checked no_tiered_compilation_innerloop**: "test Windows_NT x86_arm_altjit Checked no_tiered_compilation_innerloop"
- **Windows_NT x86_arm_altjit Checked r2r**: "test Windows_NT x86_arm_altjit Checked r2r"
- **Windows_NT x86_arm_altjit Checked r2r_jitforcerelocs**: "test Windows_NT x86_arm_altjit Checked r2r_jitforcerelocs"
- **Windows_NT x86_arm_altjit Checked r2r_jitminopts**: "test Windows_NT x86_arm_altjit Checked r2r_jitminopts"
- **Windows_NT x86_arm_altjit Checked r2r_jitstress1**: "test Windows_NT x86_arm_altjit Checked r2r_jitstress1"
- **Windows_NT x86_arm_altjit Checked r2r_jitstress1_tiered**: "test Windows_NT x86_arm_altjit Checked r2r_jitstress1_tiered"
- **Windows_NT x86_arm_altjit Checked r2r_jitstress2**: "test Windows_NT x86_arm_altjit Checked r2r_jitstress2"
- **Windows_NT x86_arm_altjit Checked r2r_jitstress2_tiered**: "test Windows_NT x86_arm_altjit Checked r2r_jitstress2_tiered"
- **Windows_NT x86_arm_altjit Checked r2r_jitstressregs0x10**: "test Windows_NT x86_arm_altjit Checked r2r_jitstressregs0x10"
- **Windows_NT x86_arm_altjit Checked r2r_jitstressregs0x1000**: "test Windows_NT x86_arm_altjit Checked r2r_jitstressregs0x1000"
- **Windows_NT x86_arm_altjit Checked r2r_jitstressregs0x80**: "test Windows_NT x86_arm_altjit Checked r2r_jitstressregs0x80"
- **Windows_NT x86_arm_altjit Checked r2r_jitstressregs1**: "test Windows_NT x86_arm_altjit Checked r2r_jitstressregs1"
- **Windows_NT x86_arm_altjit Checked r2r_jitstressregs2**: "test Windows_NT x86_arm_altjit Checked r2r_jitstressregs2"
- **Windows_NT x86_arm_altjit Checked r2r_jitstressregs3**: "test Windows_NT x86_arm_altjit Checked r2r_jitstressregs3"
- **Windows_NT x86_arm_altjit Checked r2r_jitstressregs4**: "test Windows_NT x86_arm_altjit Checked r2r_jitstressregs4"
- **Windows_NT x86_arm_altjit Checked r2r_jitstressregs8**: "test Windows_NT x86_arm_altjit Checked r2r_jitstressregs8"
- **Windows_NT x86_arm_altjit Checked r2r_no_tiered_compilation**: "test Windows_NT x86_arm_altjit Checked r2r_no_tiered_compilation"
- **Windows_NT x86_arm_altjit Checked tailcallstress**: "test Windows_NT x86_arm_altjit Checked tailcallstress"
- **Windows_NT x86_arm_altjit Checked tieredcompilation**: "test Windows_NT x86_arm_altjit Checked tieredcompilation"
- **Windows_NT x86_arm_altjit Debug Build and Test**: "test Windows_NT x86_arm_altjit Debug Build and Test"
- **Windows_NT x86_arm_altjit Release Build and Test**: "test Windows_NT x86_arm_altjit Release Build and Test"
- **Windows_NT x86_arm_altjit Release r2r**: "test Windows_NT x86_arm_altjit Release r2r"
