// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

// This file is used by Code Analysis to maintain SuppressMessage
// attributes that are applied to this project.
// Project-level suppressions either have no target or are given
// a specific target and scoped to a namespace, type, member, etc.

using System.Diagnostics.CodeAnalysis;

[assembly: System.Diagnostics.CodeAnalysis.SuppressMessage("Usage", "VSTHRD003:Avoid awaiting foreign Tasks", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageLoadContext.GetInstalledPackagesAsync~System.Threading.Tasks.Task{NuGet.PackageManagement.VisualStudio.PackageCollection}")]
[assembly: SuppressMessage("Build", "CA2213:'PackageSourcesOptionsControl' contains field '_machineWidepackageSources' that is of IDisposable type 'BindingSource', but it is never disposed. Change the Dispose method on 'PackageSourcesOptionsControl' to call Close or Dispose on this field.", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.Options.PackageSourcesOptionsControl._machineWidepackageSources")]
[assembly: SuppressMessage("Build", "CA2213:'PackageSourcesOptionsControl' contains field '_packageSources' that is of IDisposable type 'BindingSource', but it is never disposed. Change the Dispose method on 'PackageSourcesOptionsControl' to call Close or Dispose on this field.", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.Options.PackageSourcesOptionsControl._packageSources")]
[assembly: SuppressMessage("Build", "CA1051:Do not declare visible instance fields", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.UI.DetailControlModel._projectVersionConstraints")]
[assembly: SuppressMessage("Build", "CA1051:Do not declare visible instance fields", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.UI.DisplayVersion.AdditionalInfo")]
[assembly: SuppressMessage("Build", "CA1051:Do not declare visible instance fields", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.UI.PreviewWindowModel.CopyGestures")]
[assembly: SuppressMessage("Build", "CA1051:Do not declare visible instance fields", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.UI.ProgressDialogData.CurrentStep")]
[assembly: SuppressMessage("Build", "CA1051:Do not declare visible instance fields", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.UI.ProgressDialogData.IsCancelable")]
[assembly: SuppressMessage("Build", "CA1051:Do not declare visible instance fields", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.UI.ProgressDialogData.ProgressText")]
[assembly: SuppressMessage("Build", "CA1051:Do not declare visible instance fields", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.UI.ProgressDialogData.TotalSteps")]
[assembly: SuppressMessage("Build", "CA1051:Do not declare visible instance fields", Justification = "<Pending>", Scope = "member", Target = "~F:NuGet.PackageManagement.UI.ProgressDialogData.WaitMessage")]
[assembly: SuppressMessage("Build", "CA1801:Parameter flags of method SelectChild is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Options.CheckedListBoxAccessibleObject.SelectChild(System.Windows.Forms.AccessibleSelection,System.Int32)")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, params object[])' could vary based on the current user's locale settings. Replace this call in 'GeneralOptionControl.localsCommandButton_OnClick(object, EventArgs)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Options.GeneralOptionControl.OnLocalsCommandButtonOnClick(System.Object,System.EventArgs)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'localsCommandButton_OnClick' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Options.GeneralOptionControl.OnLocalsCommandButtonOnClick(System.Object,System.EventArgs)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'OnActivated' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Options.GeneralOptionControl.OnActivated")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'OnApply' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Options.GeneralOptionControl.OnApply~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void GeneralOptionPage.OnApply(PageApplyEventArgs e)', validate parameter 'e' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Options.GeneralOptionPage.OnApply(Microsoft.VisualStudio.Shell.DialogPage.PageApplyEventArgs)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void PackageSourceOptionsPage.OnApply(PageApplyEventArgs e)', validate parameter 'e' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Options.PackageSourceOptionsPage.OnApply(Microsoft.VisualStudio.Shell.DialogPage.PageApplyEventArgs)")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'sourceRepositoryProvider'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Options.PackageSourcesOptionsControl.#ctor(NuGet.Protocol.Core.Types.ISourceRepositoryProvider,System.IServiceProvider)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'ApplyChangedSettings' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Options.PackageSourcesOptionsControl.ApplyChangedSettings~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1822:Member GetCheckBoxRectangleForListBoxItem does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Options.PackageSourcesOptionsControl.GetCheckBoxRectangleForListBoxItem(NuGet.Options.PackageSourceCheckedListBox,System.Int32)~System.Drawing.Rectangle")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'InitializeOnActivated' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.Options.PackageSourcesOptionsControl.InitializeOnActivated")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'AccessiblePackageIdentity.AccessiblePackageIdentity(PackageIdentity id)', validate parameter 'id' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.AccessiblePackageIdentity.#ctor(NuGet.Packaging.Core.PackageIdentity)")]
[assembly: SuppressMessage("Build", "CA1305:'AccessiblePackageIdentity.AccessiblePackageIdentity(PackageIdentity)' passes 'CultureInfo.CurrentUICulture' as the 'IFormatProvider' parameter to 'string.Format(IFormatProvider, string, object, object)'. This property returns a culture that is inappropriate for formatting methods.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.AccessiblePackageIdentity.#ctor(NuGet.Packaging.Core.PackageIdentity)")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'Convert.ToDouble(object)' could vary based on the current user's locale settings. Replace this call in 'AdditionConverter.Convert(object[], Type, object, CultureInfo)' with a call to 'Convert.ToDouble(object, IFormatProvider)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.AdditionConverter.Convert(System.Object[],System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'object AdditionConverter.Convert(object[] values, Type targetType, object parameter, CultureInfo culture)', validate parameter 'values' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.AdditionConverter.Convert(System.Object[],System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<AlternativePackageManagerProviders> AlternativePackageManagerProviders.CalculateAlternativePackageManagersAsync(IEnumerable<IVsPackageManagerProvider> packageManagerProviders, string packageId, NuGetProject project)', validate parameter 'packageManagerProviders' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.AlternativePackageManagerProviders.CalculateAlternativePackageManagersAsync(System.Collections.Generic.IEnumerable{NuGet.VisualStudio.IVsPackageManagerProvider},System.String,NuGet.ProjectManagement.NuGetProject)~System.Threading.Tasks.Task{NuGet.PackageManagement.UI.AlternativePackageManagerProviders}")]
[assembly: SuppressMessage("Build", "CA1307:The behavior of 'string.IndexOf(string)' could vary based on the current user's locale settings. Replace this call in 'NuGet.PackageManagement.UI.AuthorAndDownloadCount.UpdateControl()' with a call to 'string.IndexOf(string, System.StringComparison)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.AuthorAndDownloadCount.UpdateControl")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'object DateTimeConverter.Convert(object value, Type targetType, object parameter, CultureInfo culture)', validate parameter 'culture' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.DateTimeConverter.Convert(System.Object,System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1307:The behavior of 'string.Equals(string, string)' could vary based on the current user's locale settings. Replace this call in 'NuGet.PackageManagement.UI.DateTimeConverter.Convert(object, System.Type, object, System.Globalization.CultureInfo)' with a call to 'string.Equals(string, string, System.StringComparison)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.DateTimeConverter.Convert(System.Object,System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void DetailControlModel.AddBlockedVersions(NuGetVersion[] blockedVersions)', validate parameter 'blockedVersions' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.DetailControlModel.AddBlockedVersions(NuGet.Versioning.NuGetVersion[])")]
[assembly: SuppressMessage("Build", "CA1822:Member ExplainPackageDeprecationReasons does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.DetailControlModel.ExplainPackageDeprecationReasons(System.Collections.Generic.IReadOnlyCollection{System.String})~System.String")]
[assembly: SuppressMessage("Build", "CA1822:Member GetPackageDeprecationAlternatePackageText does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.DetailControlModel.GetPackageDeprecationAlternatePackageText(NuGet.Protocol.AlternatePackageMetadata)~System.String")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task DetailControlModel.SetCurrentPackage(PackageItemListViewModel searchResultPackage, ItemFilter filter, Func<PackageItemListViewModel> getPackageItemListViewModel)', validate parameter 'getPackageItemListViewModel' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.DetailControlModel.SetCurrentPackage(NuGet.PackageManagement.UI.PackageItemListViewModel,NuGet.PackageManagement.UI.ItemFilter,System.Func{NuGet.PackageManagement.UI.PackageItemListViewModel})~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'DetailedPackageMetadata.DetailedPackageMetadata(IPackageSearchMetadata serverData, PackageDeprecationMetadata deprecationMetadata, long? downloadCount)', validate parameter 'serverData' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.DetailedPackageMetadata.#ctor(NuGet.Protocol.Core.Types.IPackageSearchMetadata,NuGet.Protocol.PackageDeprecationMetadata,System.Nullable{System.Int64})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'DisplayVersion.DisplayVersion(VersionRange range, string additionalInfo, bool isValidVersion = true, bool isCurrentInstalled = false, bool autoReferenced = false, bool isDeprecated = false, string versionFormat = \"N\")', validate parameter 'range' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.DisplayVersion.#ctor(NuGet.Versioning.VersionRange,System.String,System.Boolean,System.Boolean,System.Boolean,System.Boolean,System.String)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'Convert' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.IconUrlToImageCacheConverter.Convert(System.Object[],System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'FinishImageProcessing' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.IconUrlToImageCacheConverter.FinishImageProcessing(System.Windows.Media.Imaging.BitmapImage,System.Uri,System.Windows.Media.Imaging.BitmapSource)~System.Windows.Media.Imaging.BitmapSource")]
[assembly: SuppressMessage("Build", "CA1822:Member WaitForInitialResultsAsync does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.InfiniteScrollList.WaitForInitialResultsAsync(NuGet.PackageManagement.UI.IItemLoader{NuGet.PackageManagement.UI.PackageItemListViewModel},System.IProgress{NuGet.PackageManagement.UI.IItemLoaderState},System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1801:Parameter parameter of method Convert is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.MessageLevelToBrushConverter.Convert(System.Object[],System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1303:Method 'object NotEqualConverter.Convert(object value, Type targetType, object parameter, CultureInfo culture)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message)'. Retrieve the following string(s) from a resource table instead: \"Parameter should not be null and should inherit from IComparable\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.NotEqualConverter.Convert(System.Object,System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'NuGetProjectUpgradeDependencyItem.NuGetProjectUpgradeDependencyItem(PackageIdentity package, PackageWithDependants packageWithDependants)', validate parameter 'packageWithDependants' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.NuGetProjectUpgradeDependencyItem.#ctor(NuGet.Packaging.Core.PackageIdentity,NuGet.PackageManagement.PackageWithDependants)")]
[assembly: SuppressMessage("Build", "CA1822:Member PromoteToTopLevelIfNeeded does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.NuGetProjectUpgradeWindowModel.PromoteToTopLevelIfNeeded(NuGet.Packaging.PackageArchiveReader,NuGet.PackageManagement.UI.NuGetProjectUpgradeDependencyItem)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void NuGetUI.ShowError(Exception ex)', validate parameter 'ex' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.NuGetUI.ShowError(System.Exception)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task NuGetUI.UpdateNuGetProjectToPackageRef(IEnumerable<NuGetProject> msBuildProjects)', validate parameter 'msBuildProjects' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.NuGetUI.UpdateNuGetProjectToPackageRef(System.Collections.Generic.IEnumerable{NuGet.ProjectManagement.NuGetProject})~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task<IModalProgressDialogSession> NuGetUIContext.StartModalProgressDialogAsync(string caption, ProgressDialogData initialData, INuGetUI uiService)', validate parameter 'initialData' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.NuGetUIContext.StartModalProgressDialogAsync(System.String,NuGet.PackageManagement.UI.ProgressDialogData,NuGet.PackageManagement.UI.INuGetUI)~System.Threading.Tasks.Task{NuGet.PackageManagement.UI.IModalProgressDialogSession}")]
[assembly: SuppressMessage("Build", "CA1822:Member ShowFileConflictResolution does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.NuGetUIProjectContext.ShowFileConflictResolution(System.String)~NuGet.ProjectManagement.FileConflictAction")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PackageDependencyMetadata.PackageDependencyMetadata(PackageDependency serverData)', validate parameter 'serverData' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageDependencyMetadata.#ctor(NuGet.Packaging.Core.PackageDependency)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PackageDetailControlModel.PackageDetailControlModel(ISolutionManager solutionManager, IEnumerable<NuGetProject> nugetProjects)', validate parameter 'solutionManager' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageDetailControlModel.#ctor(NuGet.PackageManagement.ISolutionManager,System.Collections.Generic.IEnumerable{NuGet.ProjectManagement.NuGetProject})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task PackageDetailControlModel.SetCurrentPackage(PackageItemListViewModel searchResultPackage, ItemFilter filter, Func<PackageItemListViewModel> getPackageItemListViewModel)', validate parameter 'getPackageItemListViewModel' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageDetailControlModel.SetCurrentPackage(NuGet.PackageManagement.UI.PackageItemListViewModel,NuGet.PackageManagement.UI.ItemFilter,System.Func{NuGet.PackageManagement.UI.PackageItemListViewModel})~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PackageInstallationInfo.PackageInstallationInfo(NuGetProject project)', validate parameter 'project' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageInstallationInfo.#ctor(NuGet.ProjectManagement.NuGetProject)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'int PackageInstallationInfo.CompareTo(PackageInstallationInfo other)', validate parameter 'other' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageInstallationInfo.CompareTo(NuGet.PackageManagement.UI.PackageInstallationInfo)~System.Int32")]
[assembly: SuppressMessage("Build", "CA1822:Member VersionEquals does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageItemListViewModel.VersionEquals(NuGet.Versioning.NuGetVersion,NuGet.Versioning.NuGetVersion)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1307:The behavior of 'string.IndexOf(string)' could vary based on the current user's locale settings. Replace this call in 'NuGet.PackageManagement.UI.PackageLicenseUtilities.GenerateLicenseLinks(NuGet.Packaging.LicenseMetadata, string, System.Func<string, string>)' with a call to 'string.IndexOf(string, System.StringComparison)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageLicenseUtilities.GenerateLicenseLinks(NuGet.Packaging.LicenseMetadata,System.String,System.Func{System.String,System.String})~System.Collections.Generic.IReadOnlyList{NuGet.PackageManagement.UI.IText}")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object)' could vary based on the current user's locale settings. Replace this call in 'PackageLicenseUtilities.GenerateLicenseLinks(LicenseMetadata, string, Func<string, string>)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageLicenseUtilities.GenerateLicenseLinks(NuGet.Packaging.LicenseMetadata,System.String,System.Func{System.String,System.String})~System.Collections.Generic.IReadOnlyList{NuGet.PackageManagement.UI.IText}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PackageManagerControl.PackageManagerControl(PackageManagerModel model, ISettings nugetSettings, IVsWindowSearchHostFactory searchFactory, IVsShell4 vsShell, INuGetUILogger uiLogger = null)', validate parameter 'model' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageManagerControl.#ctor(NuGet.PackageManagement.UI.PackageManagerModel,NuGet.Configuration.ISettings,Microsoft.VisualStudio.Shell.Interop.IVsWindowSearchHostFactory,Microsoft.VisualStudio.Shell.Interop.IVsShell4,NuGet.PackageManagement.VisualStudio.INuGetUILogger)")]
[assembly: SuppressMessage("Build", "CA1303:Method 'Task<IPackageFeed> PackageManagerControl.CreatePackageFeedAsync(PackageLoadContext context, ItemFilter filter, INuGetUILogger uiLogger)' passes a literal string as parameter 'message' of a call to 'InvalidOperationException.InvalidOperationException(string message)'. Retrieve the following string(s) from a resource table instead: \"Unsupported feed type\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageManagerControl.CreatePackageFeedAsync(NuGet.PackageManagement.UI.PackageLoadContext,NuGet.PackageManagement.UI.ItemFilter,NuGet.PackageManagement.VisualStudio.INuGetUILogger)~System.Threading.Tasks.Task{NuGet.PackageManagement.VisualStudio.IPackageFeed}")]
[assembly: SuppressMessage("Build", "CA1303:Method 'void PackageManagerProvidersLabel.UpdateControl()' passes a literal string as parameter 'text' of a call to 'Run.Run(string text)'. Retrieve the following string(s) from a resource table instead: \", \".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageManagerProvidersLabel.UpdateControl")]
[assembly: SuppressMessage("Build", "CA1307:The behavior of 'string.IndexOf(string)' could vary based on the current user's locale settings. Replace this call in 'NuGet.PackageManagement.UI.PackageManagerProvidersLabel.UpdateControl()' with a call to 'string.IndexOf(string, System.StringComparison)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageManagerProvidersLabel.UpdateControl")]
[assembly: SuppressMessage("Build", "CA1822:Member SetConsolidationAutomationProperties does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageManagerTopPanel.SetConsolidationAutomationProperties(System.Windows.Controls.TabItem,System.Int32)")]
[assembly: SuppressMessage("Build", "CA1816:PackageManagerWindowPane.Dispose(bool) calls GC.SuppressFinalize(object), a method that is typically only called within an implementation of 'IDisposable.Dispose'. Refer to the IDisposable pattern for more information.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageManagerWindowPane.Dispose(System.Boolean)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'UIRestorePackagesAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageRestoreBar.UIRestorePackagesAsync(System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'UserControl_Loaded' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageRestoreBar.UserControl_Loaded(System.Object,System.Windows.RoutedEventArgs)")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'DoUpgradeAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackagesConfigToPackageReferenceMigrator.DoUpgradeAsync(NuGet.PackageManagement.UI.INuGetUIContext,NuGet.PackageManagement.UI.INuGetUI,NuGet.ProjectManagement.NuGetProject,System.Collections.Generic.IEnumerable{NuGet.PackageManagement.UI.NuGetProjectUpgradeDependencyItem},System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageIdentity},System.IProgress{NuGet.PackageManagement.UI.ProgressDialogData},System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.String}")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'UpdateInstalledVersions' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageSolutionDetailControlModel.UpdateInstalledVersions")]
[assembly: SuppressMessage("Build", "CA1303:Method 'PackageSourceMoniker.PackageSourceMoniker(string sourceName, IEnumerable<SourceRepository> sourceRepositories)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message, string paramName)'. Retrieve the following string(s) from a resource table instead: \"List of sources cannot be empty\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PackageSourceMoniker.#ctor(System.String,System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository})")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PreviewResult.PreviewResult(NuGetProject target, IEnumerable<AccessiblePackageIdentity> added, IEnumerable<AccessiblePackageIdentity> deleted, IEnumerable<UpdatePreviewResult> updated)', validate parameter 'target' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.PreviewResult.#ctor(NuGet.ProjectManagement.NuGetProject,System.Collections.Generic.IEnumerable{NuGet.PackageManagement.UI.AccessiblePackageIdentity},System.Collections.Generic.IEnumerable{NuGet.PackageManagement.UI.AccessiblePackageIdentity},System.Collections.Generic.IEnumerable{NuGet.PackageManagement.UI.UpdatePreviewResult})")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'productUpdateService'", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.ProductUpdateBar.#ctor(NuGet.PackageManagement.IProductUpdateService)")]
[assembly: SuppressMessage("Build", "CA1801:Parameter currentVersion of method ShowUpdateBar is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.ProductUpdateBar.ShowUpdateBar(System.Version,System.Version)")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'int.Parse(string)' could vary based on the current user's locale settings. Replace this call in 'RadioBoolToIntConverter.Convert(object, Type, object, CultureInfo)' with a call to 'int.Parse(string, IFormatProvider)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.RadioBoolToIntConverter.Convert(System.Object,System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'object RadioBoolToIntConverter.Convert(object value, Type targetType, object parameter, CultureInfo culture)', validate parameter 'parameter' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.RadioBoolToIntConverter.Convert(System.Object,System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'RestartRequestBar.RestartRequestBar(IDeleteOnRestartManager deleteOnRestartManager, IVsShell4 vsRestarter)', validate parameter 'deleteOnRestartManager' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.RestartRequestBar.#ctor(NuGet.PackageManagement.IDeleteOnRestartManager,Microsoft.VisualStudio.Shell.Interop.IVsShell4)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void SolutionView.RestoreUserSettings(UserSettings userSettings)', validate parameter 'userSettings' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.SolutionView.RestoreUserSettings(NuGet.PackageManagement.UI.UserSettings)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void SolutionView.SaveSettings(UserSettings settings)', validate parameter 'settings' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.SolutionView.SaveSettings(NuGet.PackageManagement.UI.UserSettings)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'object StringFormatConverter.Convert(object[] values, Type targetType, object parameter, CultureInfo culture)', validate parameter 'values' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.StringFormatConverter.Convert(System.Object[],System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, params object[])' could vary based on the current user's locale settings. Replace this call in 'StringFormatConverter.Convert(object[], Type, object, CultureInfo)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.StringFormatConverter.Convert(System.Object[],System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'Convert.ToDouble(object)' could vary based on the current user's locale settings. Replace this call in 'SubstractionConverter.Convert(object[], Type, object, CultureInfo)' with a call to 'Convert.ToDouble(object, IFormatProvider)'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.SubstractionConverter.Convert(System.Object[],System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'object SubstractionConverter.Convert(object[] values, Type targetType, object parameter, CultureInfo culture)', validate parameter 'values' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.SubstractionConverter.Convert(System.Object[],System.Type,System.Object,System.Globalization.CultureInfo)~System.Object")]
[assembly: SuppressMessage("Build", "CA1308:In method 'AddUiActionEngineTelemetryProperties', replace the call to 'ToLowerInvariant' with 'ToUpperInvariant'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UIActionEngine.AddUiActionEngineTelemetryProperties(NuGet.VisualStudio.VSActionsTelemetryEvent,System.Boolean,System.Boolean,NuGet.PackageManagement.UI.UserAction,System.Collections.Generic.HashSet{System.Tuple{System.String,System.String}},System.Collections.Generic.List{System.Tuple{System.String,System.String}},System.Collections.Generic.List{System.String},System.Collections.Generic.List{System.Tuple{System.String,System.String}},System.Collections.Generic.List{System.Tuple{System.String,System.String}})")]
[assembly: SuppressMessage("Build", "CA1822:Member CheckPackageManagementFormat does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UIActionEngine.CheckPackageManagementFormat(NuGet.PackageManagement.UI.INuGetUI,System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Boolean}")]
[assembly: SuppressMessage("Build", "CA1822:Member GeneratePackageLicenseInfo does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UIActionEngine.GeneratePackageLicenseInfo(NuGet.Protocol.Core.Types.IPackageSearchMetadata)~NuGet.PackageManagement.UI.PackageLicenseInfo")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'string.Format(string, object)' could vary based on the current user's locale settings. Replace this call in 'UIActionEngine.GetPackageMetadataAsync(IEnumerable<SourceRepository>, IEnumerable<PackageIdentity>, CancellationToken)' with a call to 'string.Format(IFormatProvider, string, params object[])'.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UIActionEngine.GetPackageMetadataAsync(System.Collections.Generic.IEnumerable{NuGet.Protocol.Core.Types.SourceRepository},System.Collections.Generic.IEnumerable{NuGet.Packaging.Core.PackageIdentity},System.Threading.CancellationToken)~System.Threading.Tasks.Task{System.Collections.Generic.List{NuGet.Protocol.Core.Types.IPackageSearchMetadata}}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task UIActionEngine.PerformActionAsync(INuGetUI uiService, UserAction userAction, CancellationToken token)', validate parameter 'uiService' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UIActionEngine.PerformActionAsync(NuGet.PackageManagement.UI.INuGetUI,NuGet.PackageManagement.UI.UserAction,System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'PerformActionImplAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UIActionEngine.PerformActionImplAsync(NuGet.PackageManagement.UI.INuGetUI,System.Func{NuGet.Protocol.Core.Types.SourceCacheContext,System.Threading.Tasks.Task{System.Collections.Generic.IReadOnlyList{NuGet.PackageManagement.ResolvedAction}}},System.Func{System.Collections.Generic.IReadOnlyList{NuGet.PackageManagement.ResolvedAction},NuGet.Protocol.Core.Types.SourceCacheContext,System.Threading.Tasks.Task},NuGet.PackageManagement.NuGetOperationType,NuGet.PackageManagement.UI.UserAction,System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task UIActionEngine.PerformUpdateAsync(INuGetUI uiService, List<PackageIdentity> packagesToUpdate, CancellationToken token)', validate parameter 'uiService' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UIActionEngine.PerformUpdateAsync(NuGet.PackageManagement.UI.INuGetUI,System.Collections.Generic.List{NuGet.Packaging.Core.PackageIdentity},System.Threading.CancellationToken)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1822:Member ShouldContinueDueToDotnetDeprecation does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UIActionEngine.ShouldContinueDueToDotnetDeprecation(NuGet.PackageManagement.UI.INuGetUI,System.Collections.Generic.IEnumerable{NuGet.PackageManagement.ResolvedAction},System.Threading.CancellationToken)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1801:Parameter token of method ShouldContinueDueToDotnetDeprecation is never used. Remove the parameter or use it in the method body.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UIActionEngine.ShouldContinueDueToDotnetDeprecation(NuGet.PackageManagement.UI.INuGetUI,System.Collections.Generic.IEnumerable{NuGet.PackageManagement.ResolvedAction},System.Threading.CancellationToken)~System.Boolean")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'Task UIActionEngine.UpgradeNuGetProjectAsync(INuGetUI uiService, NuGetProject nuGetProject)', validate parameter 'nuGetProject' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UIActionEngine.UpgradeNuGetProjectAsync(NuGet.PackageManagement.UI.INuGetUI,NuGet.ProjectManagement.NuGetProject)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1822:Member UpgradeNuGetProjectAsync does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UIActionEngine.UpgradeNuGetProjectAsync(NuGet.PackageManagement.UI.INuGetUI,NuGet.ProjectManagement.NuGetProject)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'UpgradeNuGetProjectAsync' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UIActionEngine.UpgradeNuGetProjectAsync(NuGet.PackageManagement.UI.INuGetUI,NuGet.ProjectManagement.NuGetProject)~System.Threading.Tasks.Task")]
[assembly: SuppressMessage("Build", "CA1031:Modify 'LaunchExternalLink' to catch a more specific allowed exception type, or rethrow the exception.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UIUtility.LaunchExternalLink(System.Uri)")]
[assembly: SuppressMessage("Build", "CA1305:'UpdatePreviewResult.UpdatePreviewResult(PackageIdentity, PackageIdentity)' passes 'CultureInfo.CurrentUICulture' as the 'IFormatProvider' parameter to 'string.Format(IFormatProvider, string, params object[])'. This property returns a culture that is inappropriate for formatting methods.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UpdatePreviewResult.#ctor(NuGet.Packaging.Core.PackageIdentity,NuGet.Packaging.Core.PackageIdentity)")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'UpdatePreviewResult.UpdatePreviewResult(PackageIdentity oldPackage, PackageIdentity newPackage)', validate parameter 'oldPackage' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UpdatePreviewResult.#ctor(NuGet.Packaging.Core.PackageIdentity,NuGet.Packaging.Core.PackageIdentity)")]
[assembly: SuppressMessage("Build", "CA1303:Method 'UpgradeLogger.UpgradeLogger(string reportName, string backupPath)' passes a literal string as parameter 'message' of a call to 'ArgumentException.ArgumentException(string message)'. Retrieve the following string(s) from a resource table instead: \"reportName\".", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UpgradeLogger.#ctor(System.String,System.String)")]
[assembly: SuppressMessage("Build", "CA2208:Method .ctor passes parameter name 'reportName' as the message argument to a ArgumentException constructor. Replace this argument with a descriptive message and pass the parameter name in the correct position.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UpgradeLogger.#ctor(System.String,System.String)")]
[assembly: SuppressMessage("Build", "CA3075:Unsafe overload of 'LoadXml' method", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UpgradeLogger.#ctor(System.String,System.String)")]
[assembly: SuppressMessage("Build", "CA2208:Method CreateInstallAction passes 'Version' as the paramName argument to a ArgumentNullException constructor. Replace this argument with one of the method's parameter names. Note that the provided parameter name should have the exact casing as declared on the method.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.UserAction.CreateInstallAction(System.String,NuGet.Versioning.NuGetVersion)~NuGet.PackageManagement.UI.UserAction")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'IEnumerable<IVsWindowFrame> VsUtility.GetDocumentWindows(IVsUIShell uiShell)', validate parameter 'uiShell' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.VsUtility.GetDocumentWindows(Microsoft.VisualStudio.Shell.Interop.IVsUIShell)~System.Collections.Generic.IEnumerable{Microsoft.VisualStudio.Shell.Interop.IVsWindowFrame}")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'PackageManagerControl VsUtility.GetPackageManagerControl(IVsWindowFrame windowFrame)', validate parameter 'windowFrame' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.VsUtility.GetPackageManagerControl(Microsoft.VisualStudio.Shell.Interop.IVsWindowFrame)~NuGet.PackageManagement.UI.PackageManagerControl")]
[assembly: SuppressMessage("Build", "CA1806:get_Bounds calls ClientToScreen but does not use the HRESULT or error code that the method returns. This could lead to unexpected behavior in error conditions or low-resource situations. Use the result in a conditional statement, assign the result to a variable, or pass it as an argument to another method.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Options.CheckedListBoxItemAccessibleObject.Bounds")]
[assembly: SuppressMessage("Build", "CA1305:The behavior of 'bool.ToString()' could vary based on the current user's locale settings. Replace this call in 'CheckedListBoxItemAccessibleObject.Value.get' with a call to 'bool.ToString(IFormatProvider)'.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Options.CheckedListBoxItemAccessibleObject.Value")]
[assembly: SuppressMessage("Build", "CA1303:Method 'int PackageSourceCheckedListBox.ItemHeight.get' passes a literal string as parameter 'text' of a call to 'SizeF Graphics.MeasureString(string text, Font font)'. Retrieve the following string(s) from a resource table instead: \"SampleText\".", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.Options.PackageSourceCheckedListBox.ItemHeight")]
[assembly: SuppressMessage("Build", "CA1062:In externally visible method 'void DetailControl.Control.set', validate parameter 'value' is non-null before using it. If appropriate, throw an ArgumentNullException when the argument is null or add a Code Contract precondition asserting non-null argument.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.PackageManagement.UI.DetailControl.Control")]
[assembly: SuppressMessage("Build", "CA1056:Change the type of property DetailControlModel.OptionsBlockedUrlText from string to System.Uri.", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.PackageManagement.UI.DetailControlModel.OptionsBlockedUrlText")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'InstallAsTopLevel'", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.PackageManagement.UI.NuGetProjectUpgradeDependencyItem.InstallAsTopLevel")]
[assembly: SuppressMessage("Build", "CA1507:Use nameof in place of string literal 'HasNotFoundPackages'", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.PackageManagement.UI.NuGetProjectUpgradeWindowModel.HasNotFoundPackages")]
[assembly: SuppressMessage("Build", "CA1822:Member ButtonMinWidth does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.PackageManagement.UI.PreviewWindowModel.ButtonMinWidth")]
[assembly: SuppressMessage("Build", "CA1822:Member DoNotShowAgainMinWidth does not access instance data and can be marked as static (Shared in VisualBasic)", Justification = "<Pending>", Scope = "member", Target = "~P:NuGet.PackageManagement.UI.PreviewWindowModel.DoNotShowAgainMinWidth")]
[assembly: SuppressMessage("Build", "CA1501:'GeneralOptionControl' has an object hierarchy '7' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContainerControl, ScrollableControl, Control, Component, MarshalByRefObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Options.GeneralOptionControl")]
[assembly: SuppressMessage("Build", "CA1501:'PackageSourceCheckedListBox' has an object hierarchy '7' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'CheckedListBox, ListBox, ListControl, Control, Component, MarshalByRefObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Options.PackageSourceCheckedListBox")]
[assembly: SuppressMessage("Build", "CA1501:'PackageSourcesOptionsControl' has an object hierarchy '7' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContainerControl, ScrollableControl, Control, Component, MarshalByRefObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.Options.PackageSourcesOptionsControl")]
[assembly: SuppressMessage("Build", "CA1501:'ActionsAndVersions' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.ActionsAndVersions")]
[assembly: SuppressMessage("Build", "CA1501:'ArrowGlyphAdorner' has an object hierarchy '7' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'Adorner, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.ArrowGlyphAdorner")]
[assembly: SuppressMessage("Build", "CA1501:'AuthorAndDownloadCount' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.AuthorAndDownloadCount")]
[assembly: SuppressMessage("Build", "CA1501:'DeprecatedFrameworkWindow' has an object hierarchy '12' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'VsDialogWindow, DialogWindow, DialogWindowBase, Window, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.DeprecatedFrameworkWindow")]
[assembly: SuppressMessage("Build", "CA1501:'DeprecationControl' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.DeprecationControl")]
[assembly: SuppressMessage("Build", "CA1501:'DetailControl' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.DetailControl")]
[assembly: SuppressMessage("Build", "CA1501:'FileConflictDialog' has an object hierarchy '12' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'VsDialogWindow, DialogWindow, DialogWindowBase, Window, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.FileConflictDialog")]
[assembly: SuppressMessage("Build", "CA1501:'InfiniteScrollList' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.InfiniteScrollList")]
[assembly: SuppressMessage("Build", "CA1501:'InfiniteScrollListBox' has an object hierarchy '10' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'ListBox, Selector, ItemsControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.InfiniteScrollListBox")]
[assembly: SuppressMessage("Build", "CA1501:'LicenseAcceptanceWindow' has an object hierarchy '12' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'VsDialogWindow, DialogWindow, DialogWindowBase, Window, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.LicenseAcceptanceWindow")]
[assembly: SuppressMessage("Build", "CA1501:'LicenseFileWindow' has an object hierarchy '12' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'VsDialogWindow, DialogWindow, DialogWindowBase, Window, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.LicenseFileWindow")]
[assembly: SuppressMessage("Build", "CA1501:'LoadingStatusBar' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.LoadingStatusBar")]
[assembly: SuppressMessage("Build", "CA1501:'NuGetProjectUpgradeWindow' has an object hierarchy '12' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'VsDialogWindow, DialogWindow, DialogWindowBase, Window, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.NuGetProjectUpgradeWindow")]
[assembly: SuppressMessage("Build", "CA1501:'OptionsControl' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.OptionsControl")]
[assembly: SuppressMessage("Build", "CA1501:'PackageItemControl' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.PackageItemControl")]
[assembly: SuppressMessage("Build", "CA1501:'PackageManagementFormatWindow' has an object hierarchy '12' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'VsDialogWindow, DialogWindow, DialogWindowBase, Window, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.PackageManagementFormatWindow")]
[assembly: SuppressMessage("Build", "CA1001:Type 'PackageManagerControl' owns disposable field(s) '_loadCts, _refreshCts' but is not disposable", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.PackageManagerControl")]
[assembly: SuppressMessage("Build", "CA1501:'PackageManagerControl' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.PackageManagerControl")]
[assembly: SuppressMessage("Build", "CA1501:'PackageManagerProvidersLabel' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.PackageManagerProvidersLabel")]
[assembly: SuppressMessage("Build", "CA1501:'PackageManagerTopPanel' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.PackageManagerTopPanel")]
[assembly: SuppressMessage("Build", "CA1501:'PackageMetadataControl' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.PackageMetadataControl")]
[assembly: SuppressMessage("Build", "CA1501:'PackageRestoreBar' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.PackageRestoreBar")]
[assembly: SuppressMessage("Build", "CA1501:'PreviewWindow' has an object hierarchy '12' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'VsDialogWindow, DialogWindow, DialogWindowBase, Window, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.PreviewWindow")]
[assembly: SuppressMessage("Build", "CA1501:'PRMigratorBar' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.PRMigratorBar")]
[assembly: SuppressMessage("Build", "CA1501:'ProductUpdateBar' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.ProductUpdateBar")]
[assembly: SuppressMessage("Build", "CA1501:'ProjectView' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.ProjectView")]
[assembly: SuppressMessage("Build", "CA1501:'RestartRequestBar' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.RestartRequestBar")]
[assembly: SuppressMessage("Build", "CA1501:'SolutionView' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.SolutionView")]
[assembly: SuppressMessage("Build", "CA1501:'Spinner' has an object hierarchy '9' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'UserControl, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.Spinner")]
[assembly: SuppressMessage("Build", "CA1501:'TabItemButton' has an object hierarchy '10' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'Button, ButtonBase, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.TabItemButton")]
[assembly: SuppressMessage("Build", "CA1501:'VsDialogWindow' has an object hierarchy '11' levels deep within the defining module. If possible, eliminate base classes within the hierarchy to decrease its hierarchy level below '6': 'DialogWindow, DialogWindowBase, Window, ContentControl, Control, FrameworkElement, UIElement, Visual, DependencyObject, DispatcherObject, Object'", Justification = "<Pending>", Scope = "type", Target = "~T:NuGet.PackageManagement.UI.VsDialogWindow")]
[assembly: SuppressMessage("Build", "CA1821:Remove empty Finalizers", Justification = "<Pending>", Scope = "member", Target = "~M:NuGet.PackageManagement.UI.DataStreamFromComStream.Finalize")]
