// Copyright (c) .NET Foundation. All rights reserved.
// Licensed under the Apache License, Version 2.0. See License.txt in the project root for license information.

using System.Collections.Generic;

namespace NuGet.Packaging.Licenses
{

    // Auto-Generated by the GenerateLicenseList tool. DO NOT EDIT this manually. Use the update script at $repositoryRoot/scripts/utils/UpdateNuGetLicenseSPDXList.ps1
    internal class NuGetLicenseData
    {
        public static string LicenseListVersion = "v3.1-67-geb2589b";

        public static readonly IReadOnlyDictionary<string, LicenseData> LicenseList = new Dictionary<string, LicenseData>()
        {
            { "0BSD", new LicenseData(licenseID: "0BSD", referenceNumber: 1, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "AAL", new LicenseData(licenseID: "AAL", referenceNumber: 2, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "ADSL", new LicenseData(licenseID: "ADSL", referenceNumber: 3, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "AFL-1.1", new LicenseData(licenseID: "AFL-1.1", referenceNumber: 4, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "AFL-1.2", new LicenseData(licenseID: "AFL-1.2", referenceNumber: 5, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "AFL-2.0", new LicenseData(licenseID: "AFL-2.0", referenceNumber: 6, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "AFL-2.1", new LicenseData(licenseID: "AFL-2.1", referenceNumber: 7, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "AFL-3.0", new LicenseData(licenseID: "AFL-3.0", referenceNumber: 8, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "AGPL-1.0-only", new LicenseData(licenseID: "AGPL-1.0-only", referenceNumber: 9, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "AGPL-1.0-or-later", new LicenseData(licenseID: "AGPL-1.0-or-later", referenceNumber: 10, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "AGPL-3.0-only", new LicenseData(licenseID: "AGPL-3.0-only", referenceNumber: 11, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "AGPL-3.0-or-later", new LicenseData(licenseID: "AGPL-3.0-or-later", referenceNumber: 12, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "AMDPLPA", new LicenseData(licenseID: "AMDPLPA", referenceNumber: 13, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "AML", new LicenseData(licenseID: "AML", referenceNumber: 14, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "AMPAS", new LicenseData(licenseID: "AMPAS", referenceNumber: 15, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "ANTLR-PD", new LicenseData(licenseID: "ANTLR-PD", referenceNumber: 16, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "APAFML", new LicenseData(licenseID: "APAFML", referenceNumber: 17, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "APL-1.0", new LicenseData(licenseID: "APL-1.0", referenceNumber: 18, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "APSL-1.0", new LicenseData(licenseID: "APSL-1.0", referenceNumber: 19, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "APSL-1.1", new LicenseData(licenseID: "APSL-1.1", referenceNumber: 20, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "APSL-1.2", new LicenseData(licenseID: "APSL-1.2", referenceNumber: 21, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "APSL-2.0", new LicenseData(licenseID: "APSL-2.0", referenceNumber: 22, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Abstyles", new LicenseData(licenseID: "Abstyles", referenceNumber: 23, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Adobe-2006", new LicenseData(licenseID: "Adobe-2006", referenceNumber: 24, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Adobe-Glyph", new LicenseData(licenseID: "Adobe-Glyph", referenceNumber: 25, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Afmparse", new LicenseData(licenseID: "Afmparse", referenceNumber: 26, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Aladdin", new LicenseData(licenseID: "Aladdin", referenceNumber: 27, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Apache-1.0", new LicenseData(licenseID: "Apache-1.0", referenceNumber: 28, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Apache-1.1", new LicenseData(licenseID: "Apache-1.1", referenceNumber: 29, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Apache-2.0", new LicenseData(licenseID: "Apache-2.0", referenceNumber: 30, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Artistic-1.0-Perl", new LicenseData(licenseID: "Artistic-1.0-Perl", referenceNumber: 31, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Artistic-1.0-cl8", new LicenseData(licenseID: "Artistic-1.0-cl8", referenceNumber: 32, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Artistic-1.0", new LicenseData(licenseID: "Artistic-1.0", referenceNumber: 33, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Artistic-2.0", new LicenseData(licenseID: "Artistic-2.0", referenceNumber: 34, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "BSD-1-Clause", new LicenseData(licenseID: "BSD-1-Clause", referenceNumber: 35, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "BSD-2-Clause-FreeBSD", new LicenseData(licenseID: "BSD-2-Clause-FreeBSD", referenceNumber: 36, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "BSD-2-Clause-NetBSD", new LicenseData(licenseID: "BSD-2-Clause-NetBSD", referenceNumber: 37, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "BSD-2-Clause-Patent", new LicenseData(licenseID: "BSD-2-Clause-Patent", referenceNumber: 38, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "BSD-2-Clause", new LicenseData(licenseID: "BSD-2-Clause", referenceNumber: 39, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "BSD-3-Clause-Attribution", new LicenseData(licenseID: "BSD-3-Clause-Attribution", referenceNumber: 40, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "BSD-3-Clause-Clear", new LicenseData(licenseID: "BSD-3-Clause-Clear", referenceNumber: 41, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "BSD-3-Clause-LBNL", new LicenseData(licenseID: "BSD-3-Clause-LBNL", referenceNumber: 42, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "BSD-3-Clause-No-Nuclear-License-2014", new LicenseData(licenseID: "BSD-3-Clause-No-Nuclear-License-2014", referenceNumber: 43, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "BSD-3-Clause-No-Nuclear-License", new LicenseData(licenseID: "BSD-3-Clause-No-Nuclear-License", referenceNumber: 44, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "BSD-3-Clause-No-Nuclear-Warranty", new LicenseData(licenseID: "BSD-3-Clause-No-Nuclear-Warranty", referenceNumber: 45, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "BSD-3-Clause", new LicenseData(licenseID: "BSD-3-Clause", referenceNumber: 46, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "BSD-4-Clause-UC", new LicenseData(licenseID: "BSD-4-Clause-UC", referenceNumber: 47, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "BSD-4-Clause", new LicenseData(licenseID: "BSD-4-Clause", referenceNumber: 48, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "BSD-Protection", new LicenseData(licenseID: "BSD-Protection", referenceNumber: 49, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "BSD-Source-Code", new LicenseData(licenseID: "BSD-Source-Code", referenceNumber: 50, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "BSL-1.0", new LicenseData(licenseID: "BSL-1.0", referenceNumber: 51, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Bahyph", new LicenseData(licenseID: "Bahyph", referenceNumber: 52, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Barr", new LicenseData(licenseID: "Barr", referenceNumber: 53, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Beerware", new LicenseData(licenseID: "Beerware", referenceNumber: 54, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "BitTorrent-1.0", new LicenseData(licenseID: "BitTorrent-1.0", referenceNumber: 55, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "BitTorrent-1.1", new LicenseData(licenseID: "BitTorrent-1.1", referenceNumber: 56, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Borceux", new LicenseData(licenseID: "Borceux", referenceNumber: 57, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CATOSL-1.1", new LicenseData(licenseID: "CATOSL-1.1", referenceNumber: 58, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "CC-BY-1.0", new LicenseData(licenseID: "CC-BY-1.0", referenceNumber: 59, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-2.0", new LicenseData(licenseID: "CC-BY-2.0", referenceNumber: 60, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-2.5", new LicenseData(licenseID: "CC-BY-2.5", referenceNumber: 61, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-3.0", new LicenseData(licenseID: "CC-BY-3.0", referenceNumber: 62, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-4.0", new LicenseData(licenseID: "CC-BY-4.0", referenceNumber: 63, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-NC-1.0", new LicenseData(licenseID: "CC-BY-NC-1.0", referenceNumber: 64, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-NC-2.0", new LicenseData(licenseID: "CC-BY-NC-2.0", referenceNumber: 65, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-NC-2.5", new LicenseData(licenseID: "CC-BY-NC-2.5", referenceNumber: 66, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-NC-3.0", new LicenseData(licenseID: "CC-BY-NC-3.0", referenceNumber: 67, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-NC-4.0", new LicenseData(licenseID: "CC-BY-NC-4.0", referenceNumber: 68, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-NC-ND-1.0", new LicenseData(licenseID: "CC-BY-NC-ND-1.0", referenceNumber: 69, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-NC-ND-2.0", new LicenseData(licenseID: "CC-BY-NC-ND-2.0", referenceNumber: 70, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-NC-ND-2.5", new LicenseData(licenseID: "CC-BY-NC-ND-2.5", referenceNumber: 71, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-NC-ND-3.0", new LicenseData(licenseID: "CC-BY-NC-ND-3.0", referenceNumber: 72, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-NC-ND-4.0", new LicenseData(licenseID: "CC-BY-NC-ND-4.0", referenceNumber: 73, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-NC-SA-1.0", new LicenseData(licenseID: "CC-BY-NC-SA-1.0", referenceNumber: 74, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-NC-SA-2.0", new LicenseData(licenseID: "CC-BY-NC-SA-2.0", referenceNumber: 75, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-NC-SA-2.5", new LicenseData(licenseID: "CC-BY-NC-SA-2.5", referenceNumber: 76, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-NC-SA-3.0", new LicenseData(licenseID: "CC-BY-NC-SA-3.0", referenceNumber: 77, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-NC-SA-4.0", new LicenseData(licenseID: "CC-BY-NC-SA-4.0", referenceNumber: 78, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-ND-1.0", new LicenseData(licenseID: "CC-BY-ND-1.0", referenceNumber: 79, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-ND-2.0", new LicenseData(licenseID: "CC-BY-ND-2.0", referenceNumber: 80, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-ND-2.5", new LicenseData(licenseID: "CC-BY-ND-2.5", referenceNumber: 81, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-ND-3.0", new LicenseData(licenseID: "CC-BY-ND-3.0", referenceNumber: 82, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-ND-4.0", new LicenseData(licenseID: "CC-BY-ND-4.0", referenceNumber: 83, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-SA-1.0", new LicenseData(licenseID: "CC-BY-SA-1.0", referenceNumber: 84, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-SA-2.0", new LicenseData(licenseID: "CC-BY-SA-2.0", referenceNumber: 85, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-SA-2.5", new LicenseData(licenseID: "CC-BY-SA-2.5", referenceNumber: 86, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-SA-3.0", new LicenseData(licenseID: "CC-BY-SA-3.0", referenceNumber: 87, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC-BY-SA-4.0", new LicenseData(licenseID: "CC-BY-SA-4.0", referenceNumber: 88, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CC0-1.0", new LicenseData(licenseID: "CC0-1.0", referenceNumber: 89, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CDDL-1.0", new LicenseData(licenseID: "CDDL-1.0", referenceNumber: 90, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "CDDL-1.1", new LicenseData(licenseID: "CDDL-1.1", referenceNumber: 91, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CDLA-Permissive-1.0", new LicenseData(licenseID: "CDLA-Permissive-1.0", referenceNumber: 92, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CDLA-Sharing-1.0", new LicenseData(licenseID: "CDLA-Sharing-1.0", referenceNumber: 93, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CECILL-1.0", new LicenseData(licenseID: "CECILL-1.0", referenceNumber: 94, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CECILL-1.1", new LicenseData(licenseID: "CECILL-1.1", referenceNumber: 95, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CECILL-2.0", new LicenseData(licenseID: "CECILL-2.0", referenceNumber: 96, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CECILL-2.1", new LicenseData(licenseID: "CECILL-2.1", referenceNumber: 97, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "CECILL-B", new LicenseData(licenseID: "CECILL-B", referenceNumber: 98, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CECILL-C", new LicenseData(licenseID: "CECILL-C", referenceNumber: 99, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CNRI-Jython", new LicenseData(licenseID: "CNRI-Jython", referenceNumber: 100, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CNRI-Python-GPL-Compatible", new LicenseData(licenseID: "CNRI-Python-GPL-Compatible", referenceNumber: 101, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CNRI-Python", new LicenseData(licenseID: "CNRI-Python", referenceNumber: 102, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "CPAL-1.0", new LicenseData(licenseID: "CPAL-1.0", referenceNumber: 103, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "CPL-1.0", new LicenseData(licenseID: "CPL-1.0", referenceNumber: 104, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "CPOL-1.02", new LicenseData(licenseID: "CPOL-1.02", referenceNumber: 105, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CUA-OPL-1.0", new LicenseData(licenseID: "CUA-OPL-1.0", referenceNumber: 106, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Caldera", new LicenseData(licenseID: "Caldera", referenceNumber: 107, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "ClArtistic", new LicenseData(licenseID: "ClArtistic", referenceNumber: 108, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Condor-1.1", new LicenseData(licenseID: "Condor-1.1", referenceNumber: 109, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Crossword", new LicenseData(licenseID: "Crossword", referenceNumber: 110, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "CrystalStacker", new LicenseData(licenseID: "CrystalStacker", referenceNumber: 111, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Cube", new LicenseData(licenseID: "Cube", referenceNumber: 112, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "D-FSL-1.0", new LicenseData(licenseID: "D-FSL-1.0", referenceNumber: 113, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "DOC", new LicenseData(licenseID: "DOC", referenceNumber: 114, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "DSDP", new LicenseData(licenseID: "DSDP", referenceNumber: 115, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Dotseqn", new LicenseData(licenseID: "Dotseqn", referenceNumber: 116, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "ECL-1.0", new LicenseData(licenseID: "ECL-1.0", referenceNumber: 117, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "ECL-2.0", new LicenseData(licenseID: "ECL-2.0", referenceNumber: 118, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "EFL-1.0", new LicenseData(licenseID: "EFL-1.0", referenceNumber: 119, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "EFL-2.0", new LicenseData(licenseID: "EFL-2.0", referenceNumber: 120, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "EPL-1.0", new LicenseData(licenseID: "EPL-1.0", referenceNumber: 121, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "EPL-2.0", new LicenseData(licenseID: "EPL-2.0", referenceNumber: 122, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "EUDatagrid", new LicenseData(licenseID: "EUDatagrid", referenceNumber: 123, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "EUPL-1.0", new LicenseData(licenseID: "EUPL-1.0", referenceNumber: 124, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "EUPL-1.1", new LicenseData(licenseID: "EUPL-1.1", referenceNumber: 125, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "EUPL-1.2", new LicenseData(licenseID: "EUPL-1.2", referenceNumber: 126, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Entessa", new LicenseData(licenseID: "Entessa", referenceNumber: 127, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "ErlPL-1.1", new LicenseData(licenseID: "ErlPL-1.1", referenceNumber: 128, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Eurosym", new LicenseData(licenseID: "Eurosym", referenceNumber: 129, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "FSFAP", new LicenseData(licenseID: "FSFAP", referenceNumber: 130, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "FSFUL", new LicenseData(licenseID: "FSFUL", referenceNumber: 131, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "FSFULLR", new LicenseData(licenseID: "FSFULLR", referenceNumber: 132, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "FTL", new LicenseData(licenseID: "FTL", referenceNumber: 133, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Fair", new LicenseData(licenseID: "Fair", referenceNumber: 134, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Frameworx-1.0", new LicenseData(licenseID: "Frameworx-1.0", referenceNumber: 135, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "FreeImage", new LicenseData(licenseID: "FreeImage", referenceNumber: 136, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "GFDL-1.1-only", new LicenseData(licenseID: "GFDL-1.1-only", referenceNumber: 137, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "GFDL-1.1-or-later", new LicenseData(licenseID: "GFDL-1.1-or-later", referenceNumber: 138, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "GFDL-1.2-only", new LicenseData(licenseID: "GFDL-1.2-only", referenceNumber: 139, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "GFDL-1.2-or-later", new LicenseData(licenseID: "GFDL-1.2-or-later", referenceNumber: 140, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "GFDL-1.3-only", new LicenseData(licenseID: "GFDL-1.3-only", referenceNumber: 141, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "GFDL-1.3-or-later", new LicenseData(licenseID: "GFDL-1.3-or-later", referenceNumber: 142, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "GL2PS", new LicenseData(licenseID: "GL2PS", referenceNumber: 143, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "GPL-1.0-only", new LicenseData(licenseID: "GPL-1.0-only", referenceNumber: 144, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "GPL-1.0-or-later", new LicenseData(licenseID: "GPL-1.0-or-later", referenceNumber: 145, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "GPL-2.0-only", new LicenseData(licenseID: "GPL-2.0-only", referenceNumber: 146, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "GPL-2.0-or-later", new LicenseData(licenseID: "GPL-2.0-or-later", referenceNumber: 147, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "GPL-3.0-only", new LicenseData(licenseID: "GPL-3.0-only", referenceNumber: 148, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "GPL-3.0-or-later", new LicenseData(licenseID: "GPL-3.0-or-later", referenceNumber: 149, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Giftware", new LicenseData(licenseID: "Giftware", referenceNumber: 150, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Glide", new LicenseData(licenseID: "Glide", referenceNumber: 151, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Glulxe", new LicenseData(licenseID: "Glulxe", referenceNumber: 152, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "HPND", new LicenseData(licenseID: "HPND", referenceNumber: 153, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "HaskellReport", new LicenseData(licenseID: "HaskellReport", referenceNumber: 154, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "IBM-pibs", new LicenseData(licenseID: "IBM-pibs", referenceNumber: 155, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "ICU", new LicenseData(licenseID: "ICU", referenceNumber: 156, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "IJG", new LicenseData(licenseID: "IJG", referenceNumber: 157, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "IPA", new LicenseData(licenseID: "IPA", referenceNumber: 158, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "IPL-1.0", new LicenseData(licenseID: "IPL-1.0", referenceNumber: 159, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "ISC", new LicenseData(licenseID: "ISC", referenceNumber: 160, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "ImageMagick", new LicenseData(licenseID: "ImageMagick", referenceNumber: 161, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Imlib2", new LicenseData(licenseID: "Imlib2", referenceNumber: 162, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Info-ZIP", new LicenseData(licenseID: "Info-ZIP", referenceNumber: 163, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Intel-ACPI", new LicenseData(licenseID: "Intel-ACPI", referenceNumber: 164, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Intel", new LicenseData(licenseID: "Intel", referenceNumber: 165, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Interbase-1.0", new LicenseData(licenseID: "Interbase-1.0", referenceNumber: 166, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "JSON", new LicenseData(licenseID: "JSON", referenceNumber: 167, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "JasPer-2.0", new LicenseData(licenseID: "JasPer-2.0", referenceNumber: 168, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "LAL-1.2", new LicenseData(licenseID: "LAL-1.2", referenceNumber: 169, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "LAL-1.3", new LicenseData(licenseID: "LAL-1.3", referenceNumber: 170, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "LGPL-2.0-only", new LicenseData(licenseID: "LGPL-2.0-only", referenceNumber: 171, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "LGPL-2.0-or-later", new LicenseData(licenseID: "LGPL-2.0-or-later", referenceNumber: 172, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "LGPL-2.1-only", new LicenseData(licenseID: "LGPL-2.1-only", referenceNumber: 173, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "LGPL-2.1-or-later", new LicenseData(licenseID: "LGPL-2.1-or-later", referenceNumber: 174, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "LGPL-3.0-only", new LicenseData(licenseID: "LGPL-3.0-only", referenceNumber: 175, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "LGPL-3.0-or-later", new LicenseData(licenseID: "LGPL-3.0-or-later", referenceNumber: 176, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "LGPLLR", new LicenseData(licenseID: "LGPLLR", referenceNumber: 177, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "LPL-1.0", new LicenseData(licenseID: "LPL-1.0", referenceNumber: 178, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "LPL-1.02", new LicenseData(licenseID: "LPL-1.02", referenceNumber: 179, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "LPPL-1.0", new LicenseData(licenseID: "LPPL-1.0", referenceNumber: 180, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "LPPL-1.1", new LicenseData(licenseID: "LPPL-1.1", referenceNumber: 181, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "LPPL-1.2", new LicenseData(licenseID: "LPPL-1.2", referenceNumber: 182, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "LPPL-1.3a", new LicenseData(licenseID: "LPPL-1.3a", referenceNumber: 183, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "LPPL-1.3c", new LicenseData(licenseID: "LPPL-1.3c", referenceNumber: 184, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Latex2e", new LicenseData(licenseID: "Latex2e", referenceNumber: 185, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Leptonica", new LicenseData(licenseID: "Leptonica", referenceNumber: 186, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "LiLiQ-P-1.1", new LicenseData(licenseID: "LiLiQ-P-1.1", referenceNumber: 187, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "LiLiQ-R-1.1", new LicenseData(licenseID: "LiLiQ-R-1.1", referenceNumber: 188, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "LiLiQ-Rplus-1.1", new LicenseData(licenseID: "LiLiQ-Rplus-1.1", referenceNumber: 189, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Libpng", new LicenseData(licenseID: "Libpng", referenceNumber: 190, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Linux-OpenIB", new LicenseData(licenseID: "Linux-OpenIB", referenceNumber: 191, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "MIT-0", new LicenseData(licenseID: "MIT-0", referenceNumber: 192, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "MIT-CMU", new LicenseData(licenseID: "MIT-CMU", referenceNumber: 193, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "MIT-advertising", new LicenseData(licenseID: "MIT-advertising", referenceNumber: 194, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "MIT-enna", new LicenseData(licenseID: "MIT-enna", referenceNumber: 195, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "MIT-feh", new LicenseData(licenseID: "MIT-feh", referenceNumber: 196, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "MIT", new LicenseData(licenseID: "MIT", referenceNumber: 197, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "MITNFA", new LicenseData(licenseID: "MITNFA", referenceNumber: 198, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "MPL-1.0", new LicenseData(licenseID: "MPL-1.0", referenceNumber: 199, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "MPL-1.1", new LicenseData(licenseID: "MPL-1.1", referenceNumber: 200, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "MPL-2.0-no-copyleft-exception", new LicenseData(licenseID: "MPL-2.0-no-copyleft-exception", referenceNumber: 201, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "MPL-2.0", new LicenseData(licenseID: "MPL-2.0", referenceNumber: 202, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "MS-PL", new LicenseData(licenseID: "MS-PL", referenceNumber: 203, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "MS-RL", new LicenseData(licenseID: "MS-RL", referenceNumber: 204, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "MTLL", new LicenseData(licenseID: "MTLL", referenceNumber: 205, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "MakeIndex", new LicenseData(licenseID: "MakeIndex", referenceNumber: 206, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "MirOS", new LicenseData(licenseID: "MirOS", referenceNumber: 207, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Motosoto", new LicenseData(licenseID: "Motosoto", referenceNumber: 208, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Multics", new LicenseData(licenseID: "Multics", referenceNumber: 209, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Mup", new LicenseData(licenseID: "Mup", referenceNumber: 210, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "NASA-1.3", new LicenseData(licenseID: "NASA-1.3", referenceNumber: 211, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "NBPL-1.0", new LicenseData(licenseID: "NBPL-1.0", referenceNumber: 212, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "NCSA", new LicenseData(licenseID: "NCSA", referenceNumber: 213, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "NGPL", new LicenseData(licenseID: "NGPL", referenceNumber: 214, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "NLOD-1.0", new LicenseData(licenseID: "NLOD-1.0", referenceNumber: 215, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "NLPL", new LicenseData(licenseID: "NLPL", referenceNumber: 216, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "NOSL", new LicenseData(licenseID: "NOSL", referenceNumber: 217, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "NPL-1.0", new LicenseData(licenseID: "NPL-1.0", referenceNumber: 218, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "NPL-1.1", new LicenseData(licenseID: "NPL-1.1", referenceNumber: 219, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "NPOSL-3.0", new LicenseData(licenseID: "NPOSL-3.0", referenceNumber: 220, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "NRL", new LicenseData(licenseID: "NRL", referenceNumber: 221, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "NTP", new LicenseData(licenseID: "NTP", referenceNumber: 222, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Naumen", new LicenseData(licenseID: "Naumen", referenceNumber: 223, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Net-SNMP", new LicenseData(licenseID: "Net-SNMP", referenceNumber: 224, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "NetCDF", new LicenseData(licenseID: "NetCDF", referenceNumber: 225, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Newsletr", new LicenseData(licenseID: "Newsletr", referenceNumber: 226, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Nokia", new LicenseData(licenseID: "Nokia", referenceNumber: 227, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Noweb", new LicenseData(licenseID: "Noweb", referenceNumber: 228, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OCCT-PL", new LicenseData(licenseID: "OCCT-PL", referenceNumber: 229, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OCLC-2.0", new LicenseData(licenseID: "OCLC-2.0", referenceNumber: 230, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "ODC-By-1.0", new LicenseData(licenseID: "ODC-By-1.0", referenceNumber: 231, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "ODbL-1.0", new LicenseData(licenseID: "ODbL-1.0", referenceNumber: 232, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OFL-1.0", new LicenseData(licenseID: "OFL-1.0", referenceNumber: 233, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OFL-1.1", new LicenseData(licenseID: "OFL-1.1", referenceNumber: 234, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "OGTSL", new LicenseData(licenseID: "OGTSL", referenceNumber: 235, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "OLDAP-1.1", new LicenseData(licenseID: "OLDAP-1.1", referenceNumber: 236, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OLDAP-1.2", new LicenseData(licenseID: "OLDAP-1.2", referenceNumber: 237, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OLDAP-1.3", new LicenseData(licenseID: "OLDAP-1.3", referenceNumber: 238, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OLDAP-1.4", new LicenseData(licenseID: "OLDAP-1.4", referenceNumber: 239, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OLDAP-2.0.1", new LicenseData(licenseID: "OLDAP-2.0.1", referenceNumber: 240, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OLDAP-2.0", new LicenseData(licenseID: "OLDAP-2.0", referenceNumber: 241, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OLDAP-2.1", new LicenseData(licenseID: "OLDAP-2.1", referenceNumber: 242, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OLDAP-2.2.1", new LicenseData(licenseID: "OLDAP-2.2.1", referenceNumber: 243, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OLDAP-2.2.2", new LicenseData(licenseID: "OLDAP-2.2.2", referenceNumber: 244, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OLDAP-2.2", new LicenseData(licenseID: "OLDAP-2.2", referenceNumber: 245, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OLDAP-2.3", new LicenseData(licenseID: "OLDAP-2.3", referenceNumber: 246, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OLDAP-2.4", new LicenseData(licenseID: "OLDAP-2.4", referenceNumber: 247, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OLDAP-2.5", new LicenseData(licenseID: "OLDAP-2.5", referenceNumber: 248, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OLDAP-2.6", new LicenseData(licenseID: "OLDAP-2.6", referenceNumber: 249, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OLDAP-2.7", new LicenseData(licenseID: "OLDAP-2.7", referenceNumber: 250, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OLDAP-2.8", new LicenseData(licenseID: "OLDAP-2.8", referenceNumber: 251, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OML", new LicenseData(licenseID: "OML", referenceNumber: 252, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OPL-1.0", new LicenseData(licenseID: "OPL-1.0", referenceNumber: 253, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OSET-PL-2.1", new LicenseData(licenseID: "OSET-PL-2.1", referenceNumber: 254, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "OSL-1.0", new LicenseData(licenseID: "OSL-1.0", referenceNumber: 255, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "OSL-1.1", new LicenseData(licenseID: "OSL-1.1", referenceNumber: 256, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "OSL-2.0", new LicenseData(licenseID: "OSL-2.0", referenceNumber: 257, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "OSL-2.1", new LicenseData(licenseID: "OSL-2.1", referenceNumber: 258, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "OSL-3.0", new LicenseData(licenseID: "OSL-3.0", referenceNumber: 259, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "OpenSSL", new LicenseData(licenseID: "OpenSSL", referenceNumber: 260, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "PDDL-1.0", new LicenseData(licenseID: "PDDL-1.0", referenceNumber: 261, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "PHP-3.0", new LicenseData(licenseID: "PHP-3.0", referenceNumber: 262, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "PHP-3.01", new LicenseData(licenseID: "PHP-3.01", referenceNumber: 263, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Plexus", new LicenseData(licenseID: "Plexus", referenceNumber: 264, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "PostgreSQL", new LicenseData(licenseID: "PostgreSQL", referenceNumber: 265, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Python-2.0", new LicenseData(licenseID: "Python-2.0", referenceNumber: 266, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "QPL-1.0", new LicenseData(licenseID: "QPL-1.0", referenceNumber: 267, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Qhull", new LicenseData(licenseID: "Qhull", referenceNumber: 268, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "RHeCos-1.1", new LicenseData(licenseID: "RHeCos-1.1", referenceNumber: 269, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "RPL-1.1", new LicenseData(licenseID: "RPL-1.1", referenceNumber: 270, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "RPL-1.5", new LicenseData(licenseID: "RPL-1.5", referenceNumber: 271, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "RPSL-1.0", new LicenseData(licenseID: "RPSL-1.0", referenceNumber: 272, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "RSA-MD", new LicenseData(licenseID: "RSA-MD", referenceNumber: 273, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "RSCPL", new LicenseData(licenseID: "RSCPL", referenceNumber: 274, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Rdisc", new LicenseData(licenseID: "Rdisc", referenceNumber: 275, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Ruby", new LicenseData(licenseID: "Ruby", referenceNumber: 276, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "SAX-PD", new LicenseData(licenseID: "SAX-PD", referenceNumber: 277, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "SCEA", new LicenseData(licenseID: "SCEA", referenceNumber: 278, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "SGI-B-1.0", new LicenseData(licenseID: "SGI-B-1.0", referenceNumber: 279, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "SGI-B-1.1", new LicenseData(licenseID: "SGI-B-1.1", referenceNumber: 280, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "SGI-B-2.0", new LicenseData(licenseID: "SGI-B-2.0", referenceNumber: 281, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "SISSL-1.2", new LicenseData(licenseID: "SISSL-1.2", referenceNumber: 282, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "SISSL", new LicenseData(licenseID: "SISSL", referenceNumber: 283, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "SMLNJ", new LicenseData(licenseID: "SMLNJ", referenceNumber: 284, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "SMPPL", new LicenseData(licenseID: "SMPPL", referenceNumber: 285, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "SNIA", new LicenseData(licenseID: "SNIA", referenceNumber: 286, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "SPL-1.0", new LicenseData(licenseID: "SPL-1.0", referenceNumber: 287, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "SWL", new LicenseData(licenseID: "SWL", referenceNumber: 288, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Saxpath", new LicenseData(licenseID: "Saxpath", referenceNumber: 289, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Sendmail", new LicenseData(licenseID: "Sendmail", referenceNumber: 290, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "SimPL-2.0", new LicenseData(licenseID: "SimPL-2.0", referenceNumber: 291, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Sleepycat", new LicenseData(licenseID: "Sleepycat", referenceNumber: 292, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Spencer-86", new LicenseData(licenseID: "Spencer-86", referenceNumber: 293, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Spencer-94", new LicenseData(licenseID: "Spencer-94", referenceNumber: 294, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Spencer-99", new LicenseData(licenseID: "Spencer-99", referenceNumber: 295, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "SugarCRM-1.1.3", new LicenseData(licenseID: "SugarCRM-1.1.3", referenceNumber: 296, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "TCL", new LicenseData(licenseID: "TCL", referenceNumber: 297, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "TCP-wrappers", new LicenseData(licenseID: "TCP-wrappers", referenceNumber: 298, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "TMate", new LicenseData(licenseID: "TMate", referenceNumber: 299, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "TORQUE-1.1", new LicenseData(licenseID: "TORQUE-1.1", referenceNumber: 300, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "TOSL", new LicenseData(licenseID: "TOSL", referenceNumber: 301, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "TU-Berlin-1.0", new LicenseData(licenseID: "TU-Berlin-1.0", referenceNumber: 302, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "TU-Berlin-2.0", new LicenseData(licenseID: "TU-Berlin-2.0", referenceNumber: 303, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "UPL-1.0", new LicenseData(licenseID: "UPL-1.0", referenceNumber: 304, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Unicode-DFS-2015", new LicenseData(licenseID: "Unicode-DFS-2015", referenceNumber: 305, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Unicode-DFS-2016", new LicenseData(licenseID: "Unicode-DFS-2016", referenceNumber: 306, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Unicode-TOU", new LicenseData(licenseID: "Unicode-TOU", referenceNumber: 307, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Unlicense", new LicenseData(licenseID: "Unlicense", referenceNumber: 308, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "VOSTROM", new LicenseData(licenseID: "VOSTROM", referenceNumber: 309, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "VSL-1.0", new LicenseData(licenseID: "VSL-1.0", referenceNumber: 310, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Vim", new LicenseData(licenseID: "Vim", referenceNumber: 311, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "W3C-19980720", new LicenseData(licenseID: "W3C-19980720", referenceNumber: 312, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "W3C-20150513", new LicenseData(licenseID: "W3C-20150513", referenceNumber: 313, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "W3C", new LicenseData(licenseID: "W3C", referenceNumber: 314, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "WTFPL", new LicenseData(licenseID: "WTFPL", referenceNumber: 315, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Watcom-1.0", new LicenseData(licenseID: "Watcom-1.0", referenceNumber: 316, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "Wsuipa", new LicenseData(licenseID: "Wsuipa", referenceNumber: 317, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "X11", new LicenseData(licenseID: "X11", referenceNumber: 318, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "XFree86-1.1", new LicenseData(licenseID: "XFree86-1.1", referenceNumber: 319, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "XSkat", new LicenseData(licenseID: "XSkat", referenceNumber: 320, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Xerox", new LicenseData(licenseID: "Xerox", referenceNumber: 321, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Xnet", new LicenseData(licenseID: "Xnet", referenceNumber: 322, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "YPL-1.0", new LicenseData(licenseID: "YPL-1.0", referenceNumber: 323, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "YPL-1.1", new LicenseData(licenseID: "YPL-1.1", referenceNumber: 324, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "ZPL-1.1", new LicenseData(licenseID: "ZPL-1.1", referenceNumber: 325, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "ZPL-2.0", new LicenseData(licenseID: "ZPL-2.0", referenceNumber: 326, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "ZPL-2.1", new LicenseData(licenseID: "ZPL-2.1", referenceNumber: 327, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Zed", new LicenseData(licenseID: "Zed", referenceNumber: 328, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Zend-2.0", new LicenseData(licenseID: "Zend-2.0", referenceNumber: 329, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Zimbra-1.3", new LicenseData(licenseID: "Zimbra-1.3", referenceNumber: 330, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Zimbra-1.4", new LicenseData(licenseID: "Zimbra-1.4", referenceNumber: 331, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "Zlib", new LicenseData(licenseID: "Zlib", referenceNumber: 332, isOsiApproved: true, isDeprecatedLicenseId: false) },
            { "bzip2-1.0.5", new LicenseData(licenseID: "bzip2-1.0.5", referenceNumber: 333, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "bzip2-1.0.6", new LicenseData(licenseID: "bzip2-1.0.6", referenceNumber: 334, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "curl", new LicenseData(licenseID: "curl", referenceNumber: 335, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "diffmark", new LicenseData(licenseID: "diffmark", referenceNumber: 336, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "dvipdfm", new LicenseData(licenseID: "dvipdfm", referenceNumber: 337, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "eGenix", new LicenseData(licenseID: "eGenix", referenceNumber: 338, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "gSOAP-1.3b", new LicenseData(licenseID: "gSOAP-1.3b", referenceNumber: 339, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "gnuplot", new LicenseData(licenseID: "gnuplot", referenceNumber: 340, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "iMatix", new LicenseData(licenseID: "iMatix", referenceNumber: 341, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "libtiff", new LicenseData(licenseID: "libtiff", referenceNumber: 342, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "mpich2", new LicenseData(licenseID: "mpich2", referenceNumber: 343, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "psfrag", new LicenseData(licenseID: "psfrag", referenceNumber: 344, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "psutils", new LicenseData(licenseID: "psutils", referenceNumber: 345, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "xinetd", new LicenseData(licenseID: "xinetd", referenceNumber: 346, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "xpp", new LicenseData(licenseID: "xpp", referenceNumber: 347, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "zlib-acknowledgement", new LicenseData(licenseID: "zlib-acknowledgement", referenceNumber: 348, isOsiApproved: false, isDeprecatedLicenseId: false) },
            { "AGPL-1.0", new LicenseData(licenseID: "AGPL-1.0", referenceNumber: 349, isOsiApproved: false, isDeprecatedLicenseId: true) },
            { "AGPL-3.0", new LicenseData(licenseID: "AGPL-3.0", referenceNumber: 350, isOsiApproved: true, isDeprecatedLicenseId: true) },
            { "GFDL-1.1", new LicenseData(licenseID: "GFDL-1.1", referenceNumber: 351, isOsiApproved: false, isDeprecatedLicenseId: true) },
            { "GFDL-1.2", new LicenseData(licenseID: "GFDL-1.2", referenceNumber: 352, isOsiApproved: false, isDeprecatedLicenseId: true) },
            { "GFDL-1.3", new LicenseData(licenseID: "GFDL-1.3", referenceNumber: 353, isOsiApproved: false, isDeprecatedLicenseId: true) },
            { "GPL-1.0+", new LicenseData(licenseID: "GPL-1.0+", referenceNumber: 354, isOsiApproved: false, isDeprecatedLicenseId: true) },
            { "GPL-1.0", new LicenseData(licenseID: "GPL-1.0", referenceNumber: 355, isOsiApproved: false, isDeprecatedLicenseId: true) },
            { "GPL-2.0+", new LicenseData(licenseID: "GPL-2.0+", referenceNumber: 356, isOsiApproved: true, isDeprecatedLicenseId: true) },
            { "GPL-2.0-with-GCC-exception", new LicenseData(licenseID: "GPL-2.0-with-GCC-exception", referenceNumber: 357, isOsiApproved: false, isDeprecatedLicenseId: true) },
            { "GPL-2.0-with-autoconf-exception", new LicenseData(licenseID: "GPL-2.0-with-autoconf-exception", referenceNumber: 358, isOsiApproved: false, isDeprecatedLicenseId: true) },
            { "GPL-2.0-with-bison-exception", new LicenseData(licenseID: "GPL-2.0-with-bison-exception", referenceNumber: 359, isOsiApproved: false, isDeprecatedLicenseId: true) },
            { "GPL-2.0-with-classpath-exception", new LicenseData(licenseID: "GPL-2.0-with-classpath-exception", referenceNumber: 360, isOsiApproved: false, isDeprecatedLicenseId: true) },
            { "GPL-2.0-with-font-exception", new LicenseData(licenseID: "GPL-2.0-with-font-exception", referenceNumber: 361, isOsiApproved: false, isDeprecatedLicenseId: true) },
            { "GPL-2.0", new LicenseData(licenseID: "GPL-2.0", referenceNumber: 362, isOsiApproved: true, isDeprecatedLicenseId: true) },
            { "GPL-3.0+", new LicenseData(licenseID: "GPL-3.0+", referenceNumber: 363, isOsiApproved: true, isDeprecatedLicenseId: true) },
            { "GPL-3.0-with-GCC-exception", new LicenseData(licenseID: "GPL-3.0-with-GCC-exception", referenceNumber: 364, isOsiApproved: true, isDeprecatedLicenseId: true) },
            { "GPL-3.0-with-autoconf-exception", new LicenseData(licenseID: "GPL-3.0-with-autoconf-exception", referenceNumber: 365, isOsiApproved: false, isDeprecatedLicenseId: true) },
            { "GPL-3.0", new LicenseData(licenseID: "GPL-3.0", referenceNumber: 366, isOsiApproved: true, isDeprecatedLicenseId: true) },
            { "LGPL-2.0+", new LicenseData(licenseID: "LGPL-2.0+", referenceNumber: 367, isOsiApproved: true, isDeprecatedLicenseId: true) },
            { "LGPL-2.0", new LicenseData(licenseID: "LGPL-2.0", referenceNumber: 368, isOsiApproved: true, isDeprecatedLicenseId: true) },
            { "LGPL-2.1+", new LicenseData(licenseID: "LGPL-2.1+", referenceNumber: 369, isOsiApproved: true, isDeprecatedLicenseId: true) },
            { "LGPL-2.1", new LicenseData(licenseID: "LGPL-2.1", referenceNumber: 370, isOsiApproved: true, isDeprecatedLicenseId: true) },
            { "LGPL-3.0+", new LicenseData(licenseID: "LGPL-3.0+", referenceNumber: 371, isOsiApproved: true, isDeprecatedLicenseId: true) },
            { "LGPL-3.0", new LicenseData(licenseID: "LGPL-3.0", referenceNumber: 372, isOsiApproved: true, isDeprecatedLicenseId: true) },
            { "Nunit", new LicenseData(licenseID: "Nunit", referenceNumber: 373, isOsiApproved: false, isDeprecatedLicenseId: true) },
            { "StandardML-NJ", new LicenseData(licenseID: "StandardML-NJ", referenceNumber: 374, isOsiApproved: false, isDeprecatedLicenseId: true) },
            { "eCos-2.0", new LicenseData(licenseID: "eCos-2.0", referenceNumber: 375, isOsiApproved: false, isDeprecatedLicenseId: true) },
            { "wxWindows", new LicenseData(licenseID: "wxWindows", referenceNumber: 376, isOsiApproved: false, isDeprecatedLicenseId: true) },
        };

        public static readonly IReadOnlyDictionary<string, ExceptionData> ExceptionList = new Dictionary<string, ExceptionData>()
        {
            { "389-exception", new ExceptionData(licenseID: "389-exception", referenceNumber: 1, isDeprecatedLicenseId: false) },
            { "Autoconf-exception-2.0", new ExceptionData(licenseID: "Autoconf-exception-2.0", referenceNumber: 2, isDeprecatedLicenseId: false) },
            { "Autoconf-exception-3.0", new ExceptionData(licenseID: "Autoconf-exception-3.0", referenceNumber: 3, isDeprecatedLicenseId: false) },
            { "Bison-exception-2.2", new ExceptionData(licenseID: "Bison-exception-2.2", referenceNumber: 4, isDeprecatedLicenseId: false) },
            { "Bootloader-exception", new ExceptionData(licenseID: "Bootloader-exception", referenceNumber: 5, isDeprecatedLicenseId: false) },
            { "CLISP-exception-2.0", new ExceptionData(licenseID: "CLISP-exception-2.0", referenceNumber: 6, isDeprecatedLicenseId: false) },
            { "Classpath-exception-2.0", new ExceptionData(licenseID: "Classpath-exception-2.0", referenceNumber: 7, isDeprecatedLicenseId: false) },
            { "DigiRule-FOSS-exception", new ExceptionData(licenseID: "DigiRule-FOSS-exception", referenceNumber: 8, isDeprecatedLicenseId: false) },
            { "FLTK-exception", new ExceptionData(licenseID: "FLTK-exception", referenceNumber: 9, isDeprecatedLicenseId: false) },
            { "Fawkes-Runtime-exception", new ExceptionData(licenseID: "Fawkes-Runtime-exception", referenceNumber: 10, isDeprecatedLicenseId: false) },
            { "Font-exception-2.0", new ExceptionData(licenseID: "Font-exception-2.0", referenceNumber: 11, isDeprecatedLicenseId: false) },
            { "GCC-exception-2.0", new ExceptionData(licenseID: "GCC-exception-2.0", referenceNumber: 12, isDeprecatedLicenseId: false) },
            { "GCC-exception-3.1", new ExceptionData(licenseID: "GCC-exception-3.1", referenceNumber: 13, isDeprecatedLicenseId: false) },
            { "LLVM-exception", new ExceptionData(licenseID: "LLVM-exception", referenceNumber: 14, isDeprecatedLicenseId: false) },
            { "LZMA-exception", new ExceptionData(licenseID: "LZMA-exception", referenceNumber: 15, isDeprecatedLicenseId: false) },
            { "Libtool-exception", new ExceptionData(licenseID: "Libtool-exception", referenceNumber: 16, isDeprecatedLicenseId: false) },
            { "Linux-syscall-note", new ExceptionData(licenseID: "Linux-syscall-note", referenceNumber: 17, isDeprecatedLicenseId: false) },
            { "Nokia-Qt-exception-1.1", new ExceptionData(licenseID: "Nokia-Qt-exception-1.1", referenceNumber: 18, isDeprecatedLicenseId: false) },
            { "OCCT-exception-1.0", new ExceptionData(licenseID: "OCCT-exception-1.0", referenceNumber: 19, isDeprecatedLicenseId: false) },
            { "OpenJDK-assembly-exception-1.0", new ExceptionData(licenseID: "OpenJDK-assembly-exception-1.0", referenceNumber: 20, isDeprecatedLicenseId: false) },
            { "PS-or-PDF-font-exception-20170817", new ExceptionData(licenseID: "PS-or-PDF-font-exception-20170817", referenceNumber: 21, isDeprecatedLicenseId: false) },
            { "Qt-GPL-exception-1.0", new ExceptionData(licenseID: "Qt-GPL-exception-1.0", referenceNumber: 22, isDeprecatedLicenseId: false) },
            { "Qt-LGPL-exception-1.1", new ExceptionData(licenseID: "Qt-LGPL-exception-1.1", referenceNumber: 23, isDeprecatedLicenseId: false) },
            { "Qwt-exception-1.0", new ExceptionData(licenseID: "Qwt-exception-1.0", referenceNumber: 24, isDeprecatedLicenseId: false) },
            { "WxWindows-exception-3.1", new ExceptionData(licenseID: "WxWindows-exception-3.1", referenceNumber: 25, isDeprecatedLicenseId: false) },
            { "eCos-exception-2.0", new ExceptionData(licenseID: "eCos-exception-2.0", referenceNumber: 26, isDeprecatedLicenseId: false) },
            { "freertos-exception-2.0", new ExceptionData(licenseID: "freertos-exception-2.0", referenceNumber: 27, isDeprecatedLicenseId: false) },
            { "gnu-javamail-exception", new ExceptionData(licenseID: "gnu-javamail-exception", referenceNumber: 28, isDeprecatedLicenseId: false) },
            { "i2p-gpl-java-exception", new ExceptionData(licenseID: "i2p-gpl-java-exception", referenceNumber: 29, isDeprecatedLicenseId: false) },
            { "mif-exception", new ExceptionData(licenseID: "mif-exception", referenceNumber: 30, isDeprecatedLicenseId: false) },
            { "openvpn-openssl-exception", new ExceptionData(licenseID: "openvpn-openssl-exception", referenceNumber: 31, isDeprecatedLicenseId: false) },
            { "u-boot-exception-2.0", new ExceptionData(licenseID: "u-boot-exception-2.0", referenceNumber: 32, isDeprecatedLicenseId: false) },
        };
    }

    internal class LicenseData
    {
        public LicenseData(string licenseID, int referenceNumber, bool isOsiApproved, bool isDeprecatedLicenseId)
        {
            LicenseID = licenseID;
            ReferenceNumber = referenceNumber;
            IsOsiApproved = isOsiApproved;
            IsDeprecatedLicenseId = isDeprecatedLicenseId;
        }

        internal string LicenseID
        {
            get;
        }

        internal int ReferenceNumber
        {
            get;
        }

        internal bool IsOsiApproved
        {
            get;
        }

        internal bool IsDeprecatedLicenseId
        {
            get;
        }
    }

    internal class ExceptionData
    {
        public ExceptionData(string licenseID, int referenceNumber, bool isDeprecatedLicenseId)
        {
            LicenseExceptionID = licenseID;
            ReferenceNumber = referenceNumber;
            IsDeprecatedLicenseId = isDeprecatedLicenseId;
        }

        internal string LicenseExceptionID
        {
            get;
        }

        internal int ReferenceNumber
        {
            get;
        }

        internal bool IsDeprecatedLicenseId
        {
            get;
        }
    }
}
