.CI Trigger Phrases
===

When submitting a PR to the CoreCLR repo, you may want to run more test suites than are included in the default set of checks run with each PR. In this document you will find a list of all possible jobs to trigger, as well as the phrase that will trigger that job. 

You can also ask the CI system to show you all to available trigger phrases by using `@dotnet-bot help`.

These phrases are ordered by OS. They will usually be in the form of "{OS} {Architecture} {Configuration} {Scenario}", so use that format if you are trying to ctrl-f a certain job.

To trigger a job, post a comment on your PR with "@dotnet-bot {trigger-phrase}".

- **Windows_NT x64 Release Priority 1 Build & Test:** "test Windows_NT pri1"
- **Windows_NT x64 Release IL RoundTrip Build & Test:** "test Windows_NT ilrt"
- **Windows_NT x64 Release Long-Running GC Build & Test:**: "test Windows_NT Release longgc"
- **Windows_NT x64 Release GC Simulator:**: "test Windows_NT Release gcsimulator"
- **Windows_NT x64 Release Standalone GC:**: "test Windows_NT Release standalone_gc"
- **Windows_NT x64 Release GC Reliability Framework:**: "test Windows_NT Release gc_reliability_framework"
- **Windows_NT x64 Release Ready-To-Run Priority 0 Build & Test:** "test Windows_NT Release r2r"
- **Windows_NT x64 Checked Ready-To-Run Priority 0 Build & Test:** "test Windows_NT Checked r2r"
- **Windows_NT x64 Release Ready-To-Run Priority 1 Build & Test:** "test Windows_NT Release pri1r2r"
- **Windows_NT x64 Checked Ready-To-Run Priority 1 Build & Test:** "test Windows_NT Checked pri1r2r"
- **Windows_NT x64 Release GCStress=15 Ready-To-Run Priority 1 Build & Test:** "test Windows_NT Release gcstress15_pri1r2r"
- **Windows_NT x64 Checked GCStress=15 Ready-To-Run Priority 1 Build & Test:** "test Windows_NT Checked gcstress15_pri1r2r"
- **Windows_NT x64 Release jitstress1 R2R Build & Test:** "test Windows_NT Release jitstress1 R2R"
- **Windows_NT x64 Checked jitstress1 R2R Build & Test:** "test Windows_NT Checked jitstress1 R2R"
- **Windows_NT x64 Release jitstress2 R2R Build & Test:** "test Windows_NT Release jitstress2 R2R"
- **Windows_NT x64 Checked jitstress2 R2R Build & Test:** "test Windows_NT Checked jitstress2 R2R"
- **Windows_NT x64 Release jitstressregs1 R2R Build & Test:** "test Windows_NT Release jitstressregs1 R2R"
- **Windows_NT x64 Checked jitstressregs1 R2R Build & Test:** "test Windows_NT Checked jitstressregs1 R2R"
- **Windows_NT x64 Release jitstressregs2 R2R Build & Test:** "test Windows_NT Release jitstressregs2 R2R"
- **Windows_NT x64 Checked jitstressregs2 R2R Build & Test:** "test Windows_NT Checked jitstressregs2 R2R"
- **Windows_NT x64 Release jitstressregs3 R2R Build & Test:** "test Windows_NT Release jitstressregs3 R2R"
- **Windows_NT x64 Checked jitstressregs3 R2R Build & Test:** "test Windows_NT Checked jitstressregs3 R2R"
- **Windows_NT x64 Release jitstressregs4 R2R Build & Test:** "test Windows_NT Release jitstressregs4 R2R"
- **Windows_NT x64 Checked jitstressregs4 R2R Build & Test:** "test Windows_NT Checked jitstressregs4 R2R"
- **Windows_NT x64 Release jitstressregs8 R2R Build & Test:** "test Windows_NT Release jitstressregs8 R2R"
- **Windows_NT x64 Checked jitstressregs8 R2R Build & Test:** "test Windows_NT Checked jitstressregs8 R2R"
- **Windows_NT x64 Release jitstressregsx10 R2R Build & Test:** "test Windows_NT Release jitstressregsx10 R2R"
- **Windows_NT x64 Checked jitstressregsx10 R2R Build & Test:** "test Windows_NT Checked jitstressregsx10 R2R"
- **Windows_NT x64 Release jitstressregsx80 R2R Build & Test:** "test Windows_NT Release jitstressregsx80 R2R"
- **Windows_NT x64 Checked jitstressregsx80 R2R Build & Test:** "test Windows_NT Checked jitstressregsx80 R2R"
- **Windows_NT x64 Release JITMinOpts R2R Build & Test:** "test Windows_NT Release JITMinOpts R2R"
- **Windows_NT x64 Checked JITMinOpts R2R Build & Test:** "test Windows_NT Checked JITMinOpts R2R"
- **Windows_NT x64 Release ForceRelocs R2R Build & Test:** "test Windows_NT Release ForceRelocs R2R"
- **Windows_NT x64 Checked ForceRelocs R2R Build & Test:** "test Windows_NT Checked ForceRelocs R2R"
- **Windows_NT x64 Checked JIT MinOpts Build & Test:** "test Windows_NT minopts"
- **Windows_NT x64 Checked JITStress=1 Build & Test:** "test Windows_NT jitstress1"
- **Windows_NT x64 Checked JITStress=2 Build & Test:** "test Windows_NT jitstress2"
- **Windows_NT x64 Checked Jit ForceRelocs Build & Test:** "test Windows_NT forcerelocs"
- **Windows_NT x64 Checked JITStressRegs=1 Build & Test:** "test Windows_NT jitstressregs1"
- **Windows_NT x64 Checked JITStressRegs=2 Build & Test:** "test Windows_NT jitstressregs2"
- **Windows_NT x64 Checked JITStressRegs=3 Build & Test:** "test Windows_NT jitstressregs3"
- **Windows_NT x64 Checked JITStressRegs=4 Build & Test:** "test Windows_NT jitstressregs4"
- **Windows_NT x64 Checked JITStressRegs=8 Build & Test:** "test Windows_NT jitstressregs8"
- **Windows_NT x64 Checked JITStressRegs=0x10 Build & Test:** "test Windows_NT jitstressregs0x10"
- **Windows_NT x64 Checked JITStressRegs=0x80 Build & Test:** "test Windows_NT jitstressregs0x80"
- **Windows_NT x64 Checked JitStress=2 JITStressRegs=1 Build & Test:** "test Windows_NT jitstress2_jitstressregs1"
- **Windows_NT x64 Checked JitStress=2 JITStressRegs=2 Build & Test:** "test Windows_NT jitstress2_jitstressregs2"
- **Windows_NT x64 Checked JitStress=2 JITStressRegs=3 Build & Test:** "test Windows_NT jitstress2_jitstressregs3"
- **Windows_NT x64 Checked JitStress=2 JITStressRegs=4 Build & Test:** "test Windows_NT jitstress2_jitstressregs4"
- **Windows_NT x64 Checked JitStress=2 JITStressRegs=8 Build & Test:** "test Windows_NT jitstress2_jitstressregs8"
- **Windows_NT x64 Checked JitStress=2 JITStressRegs=0x10 Build & Test:** "test Windows_NT jitstress2_jitstressregs0x10"
- **Windows_NT x64 Checked JitStress=2 JITStressRegs=0x80 Build & Test:** "test Windows_NT jitstress2_jitstressregs0x80"
- **Windows_NT x64 Checked GCStress=0x3 Build & Test:** "test Windows_NT gcstress0x3"
- **Windows_NT x64 Checked GCStress=0xc Build & Test:** "test Windows_NT gcstress0xc"
- **Windows_NT x64 Checked zapdisable Build & Test:** "test Windows_NT zapdisable"
- **Windows_NT x64 Checked Heap Verify 1 Build & Test:** "test Windows_NT heapverify1"
- **Windows_NT x64 Checked GCStress=0xc zapdisable Build & Test:** "test Windows_NT gcstress0xc_zapdisable"
- **Windows_NT x64 Checked GCStress=0xc JitStress=2 zapdisable Build & Test:** "test Windows_NT gcstress0xc_zapdisable_jitstress2"
- **Windows_NT x64 Checked GCStress=0xc zapdisable Heap Verify 1 Build & Test:** "test Windows_NT gcstress0xc_zapdisable_heapverify1"
- **Windows_NT x64 Checked GCStress=0xc JitStress=1 Build & Test:** "test Windows_NT gcstress0xc_jitstress1"
- **Windows_NT x64 Checked GCStress=0xc JitStress=2 Build & Test:** "test Windows_NT gcstress0xc_jitstress2"
- **Windows_NT x64 Checked GCStress=0xc MinOpts Heap Verify 1 Build & Test:** "test Windows_NT gcstress0xc_minopts_heapverify1"
- **Windows_NT x64 Checked Long-Running GC Build & Test:**: "test Windows_NT x64 Checked longgc"
- **Windows_NT x64 Checked Standalone GC:**: "test Windows_NT Checked standalone_gc"
- **Windows_NT x64 Checked GC Reliability Framework:**: "test Windows_NT Checked gc_reliability_framework"
- **Windows_NT x64 Formatting:**: "test Windows_NT formatting"
- **Windows_NT x64 Checked CoreFX Baseline Build & Test:** "test Windows_NT corefx_baseline"
- **Windows_NT x64 Checked CoreFX MinOpts Build & Test:** "test Windows_NT corefx_minopts"
- **Windows_NT x64 Checked CoreFX JitStress=1 Build & Test:** "test Windows_NT corefx_jitstress1"
- **Windows_NT x64 Checked CoreFX JitStress=2 Build & Test:** "test Windows_NT corefx_jitstress2"
- **Windows_NT x64 Checked CoreFX JitStressRegs=1 Build & Test:** "test Windows_NT corefx_jitstressregs1"
- **Windows_NT x64 Checked CoreFX JitStressRegs=2 Build & Test:** "test Windows_NT corefx_jitstressregs2"
- **Windows_NT x64 Checked CoreFX JitStressRegs=3 Build & Test:** "test Windows_NT corefx_jitstressregs3"
- **Windows_NT x64 Checked CoreFX JitStressRegs=4 Build & Test:** "test Windows_NT corefx_jitstressregs4"
- **Windows_NT x64 Checked CoreFX JitStressRegs=8 Build & Test:** "test Windows_NT corefx_jitstressregs8"
- **Windows_NT x64 Checked CoreFX JitStressRegs=0x10 Build & Test:** "test Windows_NT corefx_jitstressregs0x10"
- **Windows_NT x64 Checked CoreFX JitStressRegs=0x80 Build & Test:** "test Windows_NT corefx_jitstressregs0x80"
- **Windows_NT x86 Checked Priority 0 Build & Test:** "test Windows_NT x86"
- **Windows_NT x86 legacy_backend Checked Priority 0 Build & Test:** "test Windows_NT x86 legacy_backend"
- **Windows_NT x86 Release Ready-To-Run Priority 0 Build & Test:** "test Windows_NT x86 Release r2r"
- **Windows_NT x86 legacy_backend Release Ready-To-Run Priority 0 Build & Test:** "test Windows_NT x86 legacy_backend Release r2r"
- **Windows_NT x86 Release Ready-To-Run Priority 1 Build & Test:** "test Windows_NT x86 Release pri1r2r"
- **Windows_NT x86 legacy_backend Release Ready-To-Run Priority 1 Build & Test:** "test Windows_NT x86 legacy_backend Release pri1r2r"
- **Windows_NT x86 Release GCStress=15 Ready-To-Run Priority 1 Build & Test:** "test Windows_NT x86 Release gcstress15_pri1r2r"
- **Windows_NT x86 legacy_backend Release GCStress=15 Ready-To-Run Priority 1 Build & Test:** "test Windows_NT x86 legacy_backend Release gcstress15_pri1r2r"
- **Windows_NT x86 Release jitstress1 R2R Build & Test:** "test Windows_NT x86 Release jitstress1 R2R"
- **Windows_NT x86 Checked jitstress1 R2R Build & Test:** "test Windows_NT x86 Checked jitstress1 R2R"
- **Windows_NT x86 Release jitstress2 R2R Build & Test:** "test Windows_NT x86 Release jitstress2 R2R"
- **Windows_NT x86 Checked jitstress2 R2R Build & Test:** "test Windows_NT x86 Checked jitstress2 R2R"
- **Windows_NT x86 Release jitstressregs1 R2R Build & Test:** "test Windows_NT x86 Release jitstressregs1 R2R"
- **Windows_NT x86 Checked jitstressregs1 R2R Build & Test:** "test Windows_NT x86 Checked jitstressregs1 R2R"
- **Windows_NT x86 Release jitstressregs2 R2R Build & Test:** "test Windows_NT x86 Release jitstressregs2 R2R"
- **Windows_NT x86 Checked jitstressregs2 R2R Build & Test:** "test Windows_NT x86 Checked jitstressregs2 R2R"
- **Windows_NT x86 Release jitstressregs3 R2R Build & Test:** "test Windows_NT x86 Release jitstressregs3 R2R"
- **Windows_NT x86 Checked jitstressregs3 R2R Build & Test:** "test Windows_NT x86 Checked jitstressregs3 R2R"
- **Windows_NT x86 Release jitstressregs4 R2R Build & Test:** "test Windows_NT x86 Release jitstressregs4 R2R"
- **Windows_NT x86 Checked jitstressregs4 R2R Build & Test:** "test Windows_NT x86 Checked jitstressregs4 R2R"
- **Windows_NT x86 Release jitstressregs8 R2R Build & Test:** "test Windows_NT x86 Release jitstressregs8 R2R"
- **Windows_NT x86 Checked jitstressregs8 R2R Build & Test:** "test Windows_NT x86 Checked jitstressregs8 R2R"
- **Windows_NT x86 Release jitstressregsx10 R2R Build & Test:** "test Windows_NT x86 Release jitstressregsx10 R2R"
- **Windows_NT x86 Checked jitstressregsx10 R2R Build & Test:** "test Windows_NT x86 Checked jitstressregsx10 R2R"
- **Windows_NT x86 Release jitstressregsx80 R2R Build & Test:** "test Windows_NT x86 Release jitstressregsx80 R2R"
- **Windows_NT x86 Checked jitstressregsx80 R2R Build & Test:** "test Windows_NT x86 Checked jitstressregsx80 R2R"
- **Windows_NT x86 Release JITMinOpts R2R Build & Test:** "test Windows_NT x86 Release JITMinOpts R2R"
- **Windows_NT x86 Checked JITMinOpts R2R Build & Test:** "test Windows_NT x86 Checked JITMinOpts R2R"
- **Windows_NT x86 Release ForceRelocs R2R Build & Test:** "test Windows_NT x86 Release ForceRelocs R2R"
- **Windows_NT x86 Checked ForceRelocs R2R Build & Test:** "test Windows_NT x86 Checked ForceRelocs R2R"
- **Windows_NT x86 Checked JIT MinOpts Build & Test:** "test Windows_NT x86 minopts"
- **Windows_NT x86 Checked JITStress=1 Build & Test:** "test Windows_NT x86 jitstress1"
- **Windows_NT x86 Checked JITStress=2 Build & Test:** "test Windows_NT x86 jitstress2"
- **Windows_NT x86 Checked Jit ForceRelocs Build & Test:** "test Windows_NT x86 forcerelocs"
- **Windows_NT x86 Checked JITStressRegs=1 Build & Test:** "test Windows_NT x86 jitstressregs1"
- **Windows_NT x86 Checked JITStressRegs=2 Build & Test:** "test Windows_NT x86 jitstressregs2"
- **Windows_NT x86 Checked JITStressRegs=3 Build & Test:** "test Windows_NT x86 jitstressregs3"
- **Windows_NT x86 Checked JITStressRegs=4 Build & Test:** "test Windows_NT x86 jitstressregs4"
- **Windows_NT x86 Checked JITStressRegs=8 Build & Test:** "test Windows_NT x86 jitstressregs8"
- **Windows_NT x86 Checked JITStressRegs=0x10 Build & Test:** "test Windows_NT x86 jitstressregs0x10"
- **Windows_NT x86 Checked JITStressRegs=0x80 Build & Test:** "test Windows_NT x86 jitstressregs0x80"
- **Windows_NT x86 Checked JitStress=2 JITStressRegs=1 Build & Test:** "test Windows_NT x86 jitstress2_jitstressregs1"
- **Windows_NT x86 Checked JitStress=2 JITStressRegs=2 Build & Test:** "test Windows_NT x86 jitstress2_jitstressregs2"
- **Windows_NT x86 Checked JitStress=2 JITStressRegs=3 Build & Test:** "test Windows_NT x86 jitstress2_jitstressregs3"
- **Windows_NT x86 Checked JitStress=2 JITStressRegs=4 Build & Test:** "test Windows_NT x86 jitstress2_jitstressregs4"
- **Windows_NT x86 Checked JitStress=2 JITStressRegs=8 Build & Test:** "test Windows_NT x86 jitstress2_jitstressregs8"
- **Windows_NT x86 Checked JitStress=2 JITStressRegs=0x10 Build & Test:** "test Windows_NT x86 jitstress2_jitstressregs0x10"
- **Windows_NT x86 Checked JitStress=2 JITStressRegs=0x80 Build & Test:** "test Windows_NT x86 jitstress2_jitstressregs0x80"
- **Windows_NT x86 Checked GCStress=0x3 Build & Test:** "test Windows_NT x86 gcstress0x3"
- **Windows_NT x86 Checked GCStress=0xc Build & Test:** "test Windows_NT x86 gcstress0xc"
- **Windows_NT x86 Checked zapdisable Build & Test:** "test Windows_NT x86 zapdisable"
- **Windows_NT x86 Checked Heap Verify 1 Build & Test:** "test Windows_NT x86 heapverify1"
- **Windows_NT x86 Checked GCStress=0xc zapdisable Build & Test:** "test Windows_NT x86 gcstress0xc_zapdisable"
- **Windows_NT x86 Checked GCStress=0xc JitStress=2 zapdisable Build & Test:** "test Windows_NT x86 gcstress0xc_zapdisable_jitstress2"
- **Windows_NT x86 Checked GCStress=0xc zapdisable Heap Verify 1 Build & Test:** "test Windows_NT x86 gcstress0xc_zapdisable_heapverify1"
- **Windows_NT x86 Checked GCStress=0xc JitStress=1 Build & Test:** "test Windows_NT x86 gcstress0xc_jitstress1"
- **Windows_NT x86 Checked GCStress=0xc JitStress=2 Build & Test:** "test Windows_NT x86 gcstress0xc_jitstress2"
- **Windows_NT x86 Checked GCStress=0xc MinOpts Heap Verify 1 Build & Test:** "test Windows_NT x86 gcstress0xc_minopts_heapverify1"
- **Windows_NT x86 legacy_backend Release jitstress1 R2R Build & Test:** "test Windows_NT x86 legacy_backend Release jitstress1 R2R"
- **Windows_NT x86 legacy_backend Checked jitstress1 R2R Build & Test:** "test Windows_NT x86 legacy_backend Checked jitstress1 R2R"
- **Windows_NT x86 legacy_backend Release jitstress2 R2R Build & Test:** "test Windows_NT x86 legacy_backend Release jitstress2 R2R"
- **Windows_NT x86 legacy_backend Checked jitstress2 R2R Build & Test:** "test Windows_NT x86 legacy_backend Checked jitstress2 R2R"
- **Windows_NT x86 legacy_backend Release jitstressregs1 R2R Build & Test:** "test Windows_NT x86 legacy_backend Release jitstressregs1 R2R"
- **Windows_NT x86 legacy_backend Checked jitstressregs1 R2R Build & Test:** "test Windows_NT x86 legacy_backend Checked jitstressregs1 R2R"
- **Windows_NT x86 legacy_backend Release jitstressregs2 R2R Build & Test:** "test Windows_NT x86 legacy_backend Release jitstressregs2 R2R"
- **Windows_NT x86 legacy_backend Checked jitstressregs2 R2R Build & Test:** "test Windows_NT x86 legacy_backend Checked jitstressregs2 R2R"
- **Windows_NT x86 legacy_backend Release jitstressregs3 R2R Build & Test:** "test Windows_NT x86 legacy_backend Release jitstressregs3 R2R"
- **Windows_NT x86 legacy_backend Checked jitstressregs3 R2R Build & Test:** "test Windows_NT x86 legacy_backend Checked jitstressregs3 R2R"
- **Windows_NT x86 legacy_backend Release jitstressregs4 R2R Build & Test:** "test Windows_NT x86 legacy_backend Release jitstressregs4 R2R"
- **Windows_NT x86 legacy_backend Checked jitstressregs4 R2R Build & Test:** "test Windows_NT x86 legacy_backend Checked jitstressregs4 R2R"
- **Windows_NT x86 legacy_backend Release jitstressregs8 R2R Build & Test:** "test Windows_NT x86 legacy_backend Release jitstressregs8 R2R"
- **Windows_NT x86 legacy_backend Checked jitstressregs8 R2R Build & Test:** "test Windows_NT x86 legacy_backend Checked jitstressregs8 R2R"
- **Windows_NT x86 legacy_backend Release jitstressregsx10 R2R Build & Test:** "test Windows_NT x86 legacy_backend Release jitstressregsx10 R2R"
- **Windows_NT x86 legacy_backend Checked jitstressregsx10 R2R Build & Test:** "test Windows_NT x86 legacy_backend Checked jitstressregsx10 R2R"
- **Windows_NT x86 legacy_backend Release jitstressregsx80 R2R Build & Test:** "test Windows_NT x86 legacy_backend Release jitstressregsx80 R2R"
- **Windows_NT x86 legacy_backend Checked jitstressregsx80 R2R Build & Test:** "test Windows_NT x86 legacy_backend Checked jitstressregsx80 R2R"
- **Windows_NT x86 legacy_backend Release JITMinOpts R2R Build & Test:** "test Windows_NT x86 legacy_backend Release JITMinOpts R2R"
- **Windows_NT x86 legacy_backend Checked JITMinOpts R2R Build & Test:** "test Windows_NT x86 legacy_backend Checked JITMinOpts R2R"
- **Windows_NT x86 legacy_backend Release ForceRelocs R2R Build & Test:** "test Windows_NT x86 legacy_backend Release ForceRelocs R2R"
- **Windows_NT x86 legacy_backend Checked ForceRelocs R2R Build & Test:** "test Windows_NT x86 legacy_backend Checked ForceRelocs R2R"
- **Windows_NT x86 Release Long-Running GC Build & Test:** "test Windows_NT x86 Release longgc"
- **Windows_NT x86 legacy_backend Release Long-Running GC Build & Test:** "test Windows_NT x86 legacy_backend Release longgc"
- **Ubuntu x64 Release Priority 1 Build & Test:** "test Ubuntu pri1"
- **Ubuntu x64 Release IL RoundTrip Build & Test:** "test Ubuntu ilrt"
- **Ubuntu x64 Release Long-Running GC Build & Test:**: "test Ubuntu Release longgc"
- **Ubuntu x64 Release GC Simulator:**: "test Ubuntu Release gcsimulator"
- **Ubuntu x64 Release Standalone GC:**: "test Ubuntu Release standalone_gc"
- **Ubuntu x64 Checked Standalone GC:**: "test Ubuntu Checked standalone_gc"
- **Ubuntu x64 Release GC Reliability Framework:**: "test Ubuntu Release gc_reliability_framework"
- **Ubuntu x64 Checked GC Reliability Framework:**: "test Ubuntu Checked gc_reliability_framework"
- **Ubuntu x64 Release Ready-To-Run Priority 0 Build & Test:** "test Ubuntu Release r2r"
- **Ubuntu x64 Checked Ready-To-Run Priority 0 Build & Test:** "test Ubuntu Checked r2r"
- **Ubuntu x64 Release Ready-To-Run Priority 1 Build & Test:** "test Ubuntu Release pri1r2r"
- **Ubuntu x64 Checked Ready-To-Run Priority 1 Build & Test:** "test Ubuntu Checked pri1r2r"
- **Ubuntu x64 Release GCStress=15 Ready-To-Run Priority 1 Build & Test:** "test Ubuntu Release gcstress15_pri1r2r"
- **Ubuntu x64 Checked GCStress=15 Ready-To-Run Priority 1 Build & Test:** "test Ubuntu Checked gcstress15_pri1r2r"
- **Ubuntu x64 Release jitstress1 R2R Build & Test:** "test Ubuntu Release jitstress1 R2R"
- **Ubuntu x64 Checked jitstress1 R2R Build & Test:** "test Ubuntu Checked jitstress1 R2R"
- **Ubuntu x64 Release jitstress2 R2R Build & Test:** "test Ubuntu Release jitstress2 R2R"
- **Ubuntu x64 Checked jitstress2 R2R Build & Test:** "test Ubuntu Checked jitstress2 R2R"
- **Ubuntu x64 Release jitstressregs1 R2R Build & Test:** "test Ubuntu Release jitstressregs1 R2R"
- **Ubuntu x64 Checked jitstressregs1 R2R Build & Test:** "test Ubuntu Checked jitstressregs1 R2R"
- **Ubuntu x64 Release jitstressregs2 R2R Build & Test:** "test Ubuntu Release jitstressregs2 R2R"
- **Ubuntu x64 Checked jitstressregs2 R2R Build & Test:** "test Ubuntu Checked jitstressregs2 R2R"
- **Ubuntu x64 Release jitstressregs3 R2R Build & Test:** "test Ubuntu Release jitstressregs3 R2R"
- **Ubuntu x64 Checked jitstressregs3 R2R Build & Test:** "test Ubuntu Checked jitstressregs3 R2R"
- **Ubuntu x64 Release jitstressregs4 R2R Build & Test:** "test Ubuntu Release jitstressregs4 R2R"
- **Ubuntu x64 Checked jitstressregs4 R2R Build & Test:** "test Ubuntu Checked jitstressregs4 R2R"
- **Ubuntu x64 Release jitstressregs8 R2R Build & Test:** "test Ubuntu Release jitstressregs8 R2R"
- **Ubuntu x64 Checked jitstressregs8 R2R Build & Test:** "test Ubuntu Checked jitstressregs8 R2R"
- **Ubuntu x64 Release jitstressregsx10 R2R Build & Test:** "test Ubuntu Release jitstressregsx10 R2R"
- **Ubuntu x64 Checked jitstressregsx10 R2R Build & Test:** "test Ubuntu Checked jitstressregsx10 R2R"
- **Ubuntu x64 Release jitstressregsx80 R2R Build & Test:** "test Ubuntu Release jitstressregsx80 R2R"
- **Ubuntu x64 Checked jitstressregsx80 R2R Build & Test:** "test Ubuntu Checked jitstressregsx80 R2R"
- **Ubuntu x64 Release JITMinOpts R2R Build & Test:** "test Ubuntu Release JITMinOpts R2R"
- **Ubuntu x64 Checked JITMinOpts R2R Build & Test:** "test Ubuntu Checked JITMinOpts R2R"
- **Ubuntu x64 Release ForceRelocs R2R Build & Test:** "test Ubuntu Release ForceRelocs R2R"
- **Ubuntu x64 Checked ForceRelocs R2R Build & Test:** "test Ubuntu x64 Checked ForceRelocs R2R"
- **Ubuntu x64 Checked JIT MinOpts Build & Test:** "test Ubuntu minopts"
- **Ubuntu x64 Checked JITStress=1 Build & Test:** "test Ubuntu jitstress1"
- **Ubuntu x64 Checked JITStress=2 Build & Test:** "test Ubuntu jitstress2"
- **Ubuntu x64 Checked Jit ForceRelocs Build & Test:** "test Ubuntu forcerelocs"
- **Ubuntu x64 Checked JITStressRegs=1 Build & Test:** "test Ubuntu jitstressregs1"
- **Ubuntu x64 Checked JITStressRegs=2 Build & Test:** "test Ubuntu jitstressregs2"
- **Ubuntu x64 Checked JITStressRegs=3 Build & Test:** "test Ubuntu jitstressregs3"
- **Ubuntu x64 Checked JITStressRegs=4 Build & Test:** "test Ubuntu jitstressregs4"
- **Ubuntu x64 Checked JITStressRegs=8 Build & Test:** "test Ubuntu jitstressregs8"
- **Ubuntu x64 Checked JITStressRegs=0x10 Build & Test:** "test Ubuntu jitstressregs0x10"
- **Ubuntu x64 Checked JITStressRegs=0x80 Build & Test:** "test Ubuntu jitstressregs0x80"
- **Ubuntu x64 Checked JitStress=2 JITStressRegs=1 Build & Test:** "test Ubuntu jitstress2_jitstressregs1"
- **Ubuntu x64 Checked JitStress=2 JITStressRegs=2 Build & Test:** "test Ubuntu jitstress2_jitstressregs2"
- **Ubuntu x64 Checked JitStress=2 JITStressRegs=3 Build & Test:** "test Ubuntu jitstress2_jitstressregs3"
- **Ubuntu x64 Checked JitStress=2 JITStressRegs=4 Build & Test:** "test Ubuntu jitstress2_jitstressregs4"
- **Ubuntu x64 Checked JitStress=2 JITStressRegs=8 Build & Test:** "test Ubuntu jitstress2_jitstressregs8"
- **Ubuntu x64 Checked JitStress=2 JITStressRegs=0x10 Build & Test:** "test Ubuntu jitstress2_jitstressregs0x10"
- **Ubuntu x64 Checked JitStress=2 JITStressRegs=0x80 Build & Test:** "test Ubuntu jitstress2_jitstressregs0x80"
- **Ubuntu x64 Checked GCStress=0x3 Build & Test:** "test Ubuntu gcstress0x3"
- **Ubuntu x64 Checked GCStress=0xc Build & Test:** "test Ubuntu gcstress0xc"
- **Ubuntu x64 Checked zapdisable Build & Test:** "test Ubuntu zapdisable"
- **Ubuntu x64 Checked Heap Verify 1 Build & Test:** "test Ubuntu heapverify1"
- **Ubuntu x64 Checked GCStress=0xc zapdisable Build & Test:** "test Ubuntu gcstress0xc_zapdisable"
- **Ubuntu x64 Checked GCStress=0xc JitStress=2 zapdisable Build & Test:** "test Ubuntu gcstress0xc_zapdisable_jitstress2"
- **Ubuntu x64 Checked GCStress=0xc zapdisable Heap Verify 1 Build & Test:** "test Ubuntu gcstress0xc_zapdisable_heapverify1"
- **Ubuntu x64 Checked GCStress=0xc JitStress=1 Build & Test:** "test Ubuntu gcstress0xc_jitstress1"
- **Ubuntu x64 Checked GCStress=0xc JitStress=2 Build & Test:** "test Ubuntu gcstress0xc_jitstress2"
- **Ubuntu x64 Checked GCStress=0xc MinOpts Heap Verify 1 Build & Test:** "test Ubuntu gcstress0xc_minopts_heapverify1"
- **Ubuntu x64 Checked Long-Running GC Build & Test:**: "test Ubuntu Checked longgc"
- **Ubuntu x64 Formatting:**: "test Ubuntu formatting"
- **Ubuntu x64 Checked CoreFX Baseline Build & Test:** "test Ubuntu corefx_baseline"
- **Ubuntu x64 Checked CoreFX MinOpts Build & Test:** "test Ubuntu corefx_minopts"
- **Ubuntu x64 Checked CoreFX JitStress=1 Build & Test:** "test Ubuntu corefx_jitstress1"
- **Ubuntu x64 Checked CoreFX JitStress=2 Build & Test:** "test Ubuntu corefx_jitstress2"
- **Ubuntu x64 Checked CoreFX JitStressRegs=1 Build & Test:** "test Ubuntu corefx_jitstressregs1"
- **Ubuntu x64 Checked CoreFX JitStressRegs=2 Build & Test:** "test Ubuntu corefx_jitstressregs2"
- **Ubuntu x64 Checked CoreFX JitStressRegs=3 Build & Test:** "test Ubuntu corefx_jitstressregs3"
- **Ubuntu x64 Checked CoreFX JitStressRegs=4 Build & Test:** "test Ubuntu corefx_jitstressregs4"
- **Ubuntu x64 Checked CoreFX JitStressRegs=8 Build & Test:** "test Ubuntu corefx_jitstressregs8"
- **Ubuntu x64 Checked CoreFX JitStressRegs=0x10 Build & Test:** "test Ubuntu corefx_jitstressregs0x10"
- **Ubuntu x64 Checked CoreFX JitStressRegs=0x80 Build & Test:** "test Ubuntu corefx_jitstressregs0x80"
- **Ubuntu x86 Debug Build:** "test Ubuntu x86 Debug"
- **Ubuntu x86 Checked Build:** "test Ubuntu x86 Checked"
- **Ubuntu x86 Release Build:** "test Ubuntu x86 Release"
- **Ubuntu arm Cross Debug Build & Small Test:** "test Ubuntu arm Cross Debug Build"
- **Ubuntu arm Cross Checked Build & Small Test:** "test Ubuntu arm Cross Checked Build"
- **Ubuntu arm64 Release Cross Build:** "test Ubuntu arm64"
- **Ubuntu16.04 x64 Release Priority 0 Build:** "test Ubuntu16.04 x64"
- **Ubuntu16.04 arm Cross Checked Build & Small Test:** "test Ubuntu16.04 arm Cross Checked Build"
- **Ubuntu16.04 arm Cross Release Build & Small Test:** "test Ubuntu16.04 arm Cross Release Build"
- **Ubuntu16.10 x64 Release Priority 0 Build:** "test Ubuntu16.10"
- **OSX x64 Release Priority 1 Build & Test:** "test OSX pri1"
- **OSX x64 Release IL RoundTrip Build & Test:** "test OSX ilrt"
- **OSX x64 Release Long-Running GC Build & Test:**: "test OSX Release longgc"
- **OSX x64 Release GC Simulator:**: "test OSX10.12 Release gcsimulator"
- **OSX x64 Release Standalone GC:**: "test OSX10.12 Release standalone_gc"
- **OSX x64 Checked Standalone GC:**: "test OSX10.12 Checked standalone_gc"
- **OSX x64 Release GC Reliability Framework:**: "test OSX10.12 Release gc_reliability_framework"
- **OSX x64 Checked GC Reliability Framework:**: "test OSX10.12 Checked gc_reliability_framework"
- **OSX x64 Release Ready-To-Run Priority 0 Build & Test:** "test OSX Release r2r"
- **OSX x64 Checked Ready-To-Run Priority 0 Build & Test:** "test OSX Checked r2r"
- **OSX x64 Release Ready-To-Run Priority 1 Build & Test:** "test OSX Release pri1r2r"
- **OSX x64 Checked Ready-To-Run Priority 1 Build & Test:** "test OSX Checked pri1r2r"
- **OSX x64 Release GCStress=15 Ready-To-Run Priority 1 Build & Test:** "test OSX Release gcstress15_pri1r2r"
- **OSX x64 Checked GCStress=15 Ready-To-Run Priority 1 Build & Test:** "test OSX Checked gcstress15_pri1r2r"
- **OSX x64 Release jitstress1 R2R Build & Test:** "test OSX x64 Release jitstress1 R2R"
- **OSX x64 Checked jitstress1 R2R Build & Test:** "test OSX x64 Checked jitstress1 R2R"
- **OSX x64 Release jitstress2 R2R Build & Test:** "test OSX x64 Release jitstress2 R2R"
- **OSX x64 Checked jitstress2 R2R Build & Test:** "test OSX x64 Checked jitstress2 R2R"
- **OSX x64 Release jitstressregs1 R2R Build & Test:** "test OSX x64 Release jitstressregs1 R2R"
- **OSX x64 Checked jitstressregs1 R2R Build & Test:** "test OSX x64 Checked jitstressregs1 R2R"
- **OSX x64  Release jitstressregs2 R2R Build & Test:** "test OSX x64 Release jitstressregs2 R2R"
- **OSX x64 Checked jitstressregs2 R2R Build & Test:** "test OSX x64 Checked jitstressregs2 R2R"
- **OSX x64 Release jitstressregs3 R2R Build & Test:** "test OSX x64 Release jitstressregs3 R2R"
- **OSX x64 Checked jitstressregs3 R2R Build & Test:** "test OSX x64 Checked jitstressregs3 R2R"
- **OSX x64 Release jitstressregs4 R2R Build & Test:** "test OSX x64 Release jitstressregs4 R2R"
- **OSX x64 Checked jitstressregs4 R2R Build & Test:** "test OSX x64 Checked jitstressregs4 R2R"
- **OSX x64 Release jitstressregs8 R2R Build & Test:** "test OSX x64 Release jitstressregs8 R2R"
- **OSX x64 Checked jitstressregs8 R2R Build & Test:** "test OSX x64 Checked jitstressregs8 R2R"
- **OSX x64 Release jitstressregsx10 R2R Build & Test:** "test OSX x64 Release jitstressregsx10 R2R"
- **OSX x64 Checked jitstressregsx10 R2R Build & Test:** "test OSX x64 Checked jitstressregsx10 R2R"
- **OSX x64 Release jitstressregsx80 R2R Build & Test:** "test OSX x64 Release jitstressregsx80 R2R"
- **OSX x64 Checked jitstressregsx80 R2R Build & Test:** "test OSX x64 Checked jitstressregsx80 R2R"
- **OSX x64 Release JITMinOpts R2R Build & Test:** "test OSX x64 Release JITMinOpts R2R"
- **OSX x64 Checked JITMinOpts R2R Build & Test:** "test OSX x64 Checked JITMinOpts R2R"
- **OSX x64 Release ForceRelocs R2R Build & Test:** "test OSX x64 Release ForceRelocs R2R"
- **OSX x64 Checked ForceRelocs R2R Build & Test:** "test OSX x64 Checked ForceRelocs R2R"
- **OSX x64 Checked JIT MinOpts Build & Test:** "test OSX minopts"
- **OSX x64 Checked JITStress=1 Build & Test:** "test OSX jitstress1"
- **OSX x64 Checked JITStress=2 Build & Test:** "test OSX jitstress2"
- **OSX x64 Checked Jit ForceRelocs Build & Test:** "test OSX forcerelocs"
- **OSX x64 Checked JITStressRegs=1 Build & Test:** "test OSX jitstressregs1"
- **OSX x64 Checked JITStressRegs=2 Build & Test:** "test OSX jitstressregs2"
- **OSX x64 Checked JITStressRegs=3 Build & Test:** "test OSX jitstressregs3"
- **OSX x64 Checked JITStressRegs=4 Build & Test:** "test OSX jitstressregs4"
- **OSX x64 Checked JITStressRegs=8 Build & Test:** "test OSX jitstressregs8"
- **OSX x64 Checked JITStressRegs=0x10 Build & Test:** "test OSX jitstressregs0x10"
- **OSX x64 Checked JITStressRegs=0x80 Build & Test:** "test OSX jitstressregs0x80"
- **OSX x64 Checked JitStress=2 JITStressRegs=1 Build & Test:** "test OSX jitstress2_jitstressregs1"
- **OSX x64 Checked JitStress=2 JITStressRegs=2 Build & Test:** "test OSX jitstress2_jitstressregs2"
- **OSX x64 Checked JitStress=2 JITStressRegs=3 Build & Test:** "test OSX jitstress2_jitstressregs3"
- **OSX x64 Checked JitStress=2 JITStressRegs=4 Build & Test:** "test OSX jitstress2_jitstressregs4"
- **OSX x64 Checked JitStress=2 JITStressRegs=8 Build & Test:** "test OSX jitstress2_jitstressregs8"
- **OSX x64 Checked JitStress=2 JITStressRegs=0x10 Build & Test:** "test OSX jitstress2_jitstressregs0x10"
- **OSX x64 Checked JitStress=2 JITStressRegs=0x80 Build & Test:** "test OSX jitstress2_jitstressregs0x80"
- **OSX x64 Checked GCStress=0x3 Build & Test:** "test OSX gcstress0x3"
- **OSX x64 Checked GCStress=0xc Build & Test:** "test OSX gcstress0xc"
- **OSX x64 Checked zapdisable Build & Test:** "test OSX zapdisable"
- **OSX x64 Checked Heap Verify 1 Build & Test:** "test OSX heapverify1"
- **OSX x64 Checked GCStress=0xc zapdisable Build & Test:** "test OSX gcstress0xc_zapdisable"
- **OSX x64 Checked GCStress=0xc JitStress=2 zapdisable Build & Test:** "test OSX gcstress0xc_zapdisable_jitstress2"
- **OSX x64 Checked GCStress=0xc zapdisable Heap Verify 1 Build & Test:** "test OSX gcstress0xc_zapdisable_heapverify1"
- **OSX x64 Checked GCStress=0xc JitStress=1 Build & Test:** "test OSX gcstress0xc_jitstress1"
- **OSX x64 Checked GCStress=0xc JitStress=2 Build & Test:** "test OSX gcstress0xc_jitstress2"
- **OSX x64 Checked GCStress=0xc MinOpts Heap Verify 1 Build & Test:** "test OSX gcstress0xc_minopts_heapverify1"
- **OSX x64 Checked Long-Running GC Build & Test:**: "test OSX Checked longgc"
- **OSX x64 Checked CoreFX Baseline Build & Test:** "test OSX corefx_baseline"
- **OSX x64 Checked CoreFX MinOpts Build & Test:** "test OSX corefx_minopts"
- **OSX x64 Checked CoreFX JitStress=1 Build & Test:** "test OSX corefx_jitstress1"
- **OSX x64 Checked CoreFX JitStress=2 Build & Test:** "test OSX corefx_jitstress2"
- **OSX x64 Checked CoreFX JitStressRegs=1 Build & Test:** "test OSX corefx_jitstressregs1"
- **OSX x64 Checked CoreFX JitStressRegs=2 Build & Test:** "test OSX corefx_jitstressregs2"
- **OSX x64 Checked CoreFX JitStressRegs=3 Build & Test:** "test OSX corefx_jitstressregs3"
- **OSX x64 Checked CoreFX JitStressRegs=4 Build & Test:** "test OSX corefx_jitstressregs4"
- **OSX x64 Checked CoreFX JitStressRegs=8 Build & Test:** "test OSX corefx_jitstressregs8"
- **OSX x64 Checked CoreFX JitStressRegs=0x10 Build & Test:** "test OSX corefx_jitstressregs0x10"
- **OSX x64 Checked CoreFX JitStressRegs=0x80 Build & Test:** "test OSX corefx_jitstressregs0x80"
- **CentOS x64 Release Priority 1 Build & Test:** "test CentOS7.1 pri1"
- **CentOS x64 Release Ready-To-Run Priority 0 Build & Test:** "test CentOS7.1 Release r2r"
- **CentOS x64 Checked Ready-To-Run Priority 0 Build & Test:** "test CentOS7.1 Checked r2r"
- **CentOS x64 Release Ready-To-Run Priority 1 Build & Test:** "test CentOS7.1 Release pri1r2r"
- **CentOS x64 Checked Ready-To-Run Priority 1 Build & Test:** "test CentOS7.1 Checked pri1r2r"
- **CentOS x64 Release GCStress=15 Ready-To-Run Priority 1 Build & Test:** "test CentOS7.1 Release gcstress15_pri1r2r"
- **CentOS x64 Checked GCStress=15 Ready-To-Run Priority 1 Build & Test:** "test CentOS7.1 Checked gcstress15_pri1r2r"
- **CentOS x64 Release jitstress1 R2R Build & Test:** "test CentOS x64 Release jitstress1 R2R"
- **CentOS x64 Checked jitstress1 R2R Build & Test:** "test CentOS x64 Checked jitstress1 R2R"
- **CentOS x64 Release jitstress2 R2R Build & Test:** "test CentOS x64 Release jitstress2 R2R"
- **CentOS x64 Checked jitstress2 R2R Build & Test:** "test CentOS x64 Checked jitstress2 R2R"
- **CentOS x64 Release jitstressregs1 R2R Build & Test:** "test CentOS x64 Release jitstressregs1 R2R"
- **CentOS x64 Checked jitstressregs1 R2R Build & Test:** "test CentOS x64 Checked jitstressregs1 R2R"
- **CentOS x64  Release jitstressregs2 R2R Build & Test:** "test CentOS x64 Release jitstressregs2 R2R"
- **CentOS x64 Checked jitstressregs2 R2R Build & Test:** "test CentOS x64 Checked jitstressregs2 R2R"
- **CentOS x64 Release jitstressregs3 R2R Build & Test:** "test CentOS x64 Release jitstressregs3 R2R"
- **CentOS x64 Checked jitstressregs3 R2R Build & Test:** "test CentOS x64 Checked jitstressregs3 R2R"
- **CentOS x64 Release jitstressregs4 R2R Build & Test:** "test CentOS x64 Release jitstressregs4 R2R"
- **CentOS x64 Checked jitstressregs4 R2R Build & Test:** "test CentOS x64 Checked jitstressregs4 R2R"
- **CentOS x64 Release jitstressregs8 R2R Build & Test:** "test CentOS x64 Release jitstressregs8 R2R"
- **CentOS x64 Checked jitstressregs8 R2R Build & Test:** "test CentOS x64 Checked jitstressregs8 R2R"
- **CentOS x64 Release jitstressregsx10 R2R Build & Test:** "test CentOS x64 Release jitstressregsx10 R2R"
- **CentOS x64 Checked jitstressregsx10 R2R Build & Test:** "test CentOS x64 Checked jitstressregsx10 R2R"
- **CentOS x64 Release jitstressregsx80 R2R Build & Test:** "test CentOS x64 Release jitstressregsx80 R2R"
- **CentOS x64 Checked jitstressregsx80 R2R Build & Test:** "test CentOS x64 Checked jitstressregsx80 R2R"
- **CentOS x64 Release JITMinOpts R2R Build & Test:** "test CentOS x64 Release JITMinOpts R2R"
- **CentOS x64 Checked JITMinOpts R2R Build & Test:** "test CentOS x64 Checked JITMinOpts R2R"
- **CentOS x64 Release ForceRelocs R2R Build & Test:** "test CentOS x64 Release ForceRelocs R2R"
- **CentOS x64 Checked ForceRelocs R2R Build & Test:** "test CentOS x64 Checked ForceRelocs R2R"
- **OpenSUSE x64 Release Priority 0 Build:** "test OpenSUSE13.2"
- **OpenSUSE x64 Release Priority 1 Build & Test:** "test OpenSUSE13.2 pri1"
- **Debian x64 Release Priority 0 Build:** "test Debian8.2"
- **Debian x64 Release Priority 1 Build & Test:** "test Debian8.2 pri1"
- **RedHat x64 Release Priority 0 Build:** "test RHEL7.2"
- **RedHat x64 Release Priority 1 Build & Test:** "test RHEL7.2 pri1"
- **Tizen arm Cross Checked Build & Small Test:** "test Tizen armel Cross Checked Build"
