﻿// Copyright (c) Microsoft. All rights reserved.
// Licensed under the MIT license. See LICENSE file in the project root for full license information.
// FxCop Suppression file
// To Use:
// Add module level suppressions to this file to have them suppressed in the assembly
//

using System.Diagnostics.CodeAnalysis;

#if CODE_ANALYSIS
[module: SuppressMessage("Microsoft.Naming","CA1703:ResourceStringsShouldBeSpelledCorrectly", MessageId="wrn", Scope="resource", Target="MSBuild.Strings.resources", Justification="These are correct for the help text, they are file paths extensions and switches")]
[module: SuppressMessage("Microsoft.Naming","CA1703:ResourceStringsShouldBeSpelledCorrectly", MessageId="warningsonly", Scope="resource", Target="MSBuild.Strings.resources", Justification="These are correct for the help text, they are file paths extensions and switches")]
[module: SuppressMessage("Microsoft.Naming","CA1703:ResourceStringsShouldBeSpelledCorrectly", MessageId="logfile", Scope="resource", Target="MSBuild.Strings.resources", Justification="These are correct for the help text, they are file paths extensions and switches")]
[module: SuppressMessage("Microsoft.Naming","CA1703:ResourceStringsShouldBeSpelledCorrectly", MessageId="filelogger", Scope="resource", Target="MSBuild.Strings.resources", Justification="These are correct for the help text, they are file paths extensions and switches")]
[module: SuppressMessage("Microsoft.Naming","CA1703:ResourceStringsShouldBeSpelledCorrectly", MessageId="errorsonly", Scope="resource", Target="MSBuild.Strings.resources", Justification="These are correct for the help text, they are file paths extensions and switches")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="nologo", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="nostic", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="consoleloggerparameters", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="val", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="maxcpucount", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="ormal", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="ignoreprojectextensions", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="noconsolelogger", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="noautoresponse", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="nodeid", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="fileloggerparameters", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="noautorsp", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="nodereuse", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="diag", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="noconlog", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="etailed", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="flp", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="uiet", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="clp", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="distributedlogger", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="ver", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="toolsversion", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="inimal", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming", "CA1703:ResourceStringsShouldBeSpelledCorrectly", Scope="resource", Target="MSBuild.Strings.resources", MessageId="rsp", Justification="These are spelled correctly for the help text")]
[module: SuppressMessage("Microsoft.Naming","CA1703:ResourceStringsShouldBeSpelledCorrectly", MessageId="dsp", Scope="resource", Target="MSBuild.Strings.resources", Justification=".dsp is a file extension, and is spelled correctly")]
[module: SuppressMessage("Microsoft.Naming","CA1703:ResourceStringsShouldBeSpelledCorrectly", MessageId="inlining", Scope="resource", Target="MSBuild.Strings.resources", Justification="A valid form of the verb 'to inline', and perfectly understandable to the user even if it may not technically be in the dictionary.")]
[module: SuppressMessage("Microsoft.Design", "CA2210:AssembliesShouldHaveValidStrongNames", Justification="Our assemblies are delay signed.")]
[module: SuppressMessage("Microsoft.MSInternal", "CA905:SystemAndMicrosoftNamespacesRequireApproval", Scope="namespace", Target="Microsoft.Build.CommandLine", Justification="This is an approved namespace.")]
[module: SuppressMessage("Microsoft.Naming","CA1703:ResourceStringsShouldBeSpelledCorrectly", MessageId="detailedsummary", Scope="resource", Target="MSBuild.Strings.resources")]
[module: SuppressMessage("Microsoft.Naming","CA1703:ResourceStringsShouldBeSpelledCorrectly", MessageId="metaproj", Scope="resource", Target="MSBuild.Strings.resources")]

#endif

