page_title: Accounts on Docker Hub
page_description: Docker Hub accounts
page_keywords: Docker, docker, registry, accounts, plans, Dockerfile, Docker Hub, docs, documentation

# Accounts on Docker Hub

## Docker Hub Accounts

You can `search` for Docker images and `pull` them from [Docker
Hub](https://hub.docker.com) without signing in or even having an
account. However, in order to `push` images, leave comments or to *star*
a repository, you are going to need a [Docker
Hub](https://hub.docker.com) account.

### Registration for a Docker Hub Account

You can get a [Docker Hub](https://hub.docker.com) account by
[signing up for one here](https://hub.docker.com/account/signup/). A valid
email address is required to register, which you will need to verify for
account activation.

### Email activation process

You need to have at least one verified email address to be able to use your
[Docker Hub](https://hub.docker.com) account. If you can't find the validation email,
you can request another by visiting the [Resend Email Confirmation](
https://hub.docker.com/account/resend-email-confirmation/) page.

### Password reset process

If you can't access your account for some reason, you can reset your password
from the [*Password Reset*](https://hub.docker.com/account/forgot-password/)
page.

## Organizations & Groups

Also available on the Docker Hub are organizations and groups that allow
you to collaborate across your organization or team. You can see what
organizations [you belong to and add new organizations](
https://hub.docker.com/account/organizations/) from the Account Settings
tab. They are also listed below your user name on your repositories page and in your account profile.

![organizations](/docker-hub/orgs.png)

From within your organizations you can create groups that allow you to
further manage who can interact with your repositories.

![groups](/docker-hub/groups.png)

You can add or invite users to join groups by clicking on the organization and then clicking the edit button for the group to which you want to add members. Enter a user-name (for current Hub users) or email address (if they are not yet Hub users) for the person you want to invite. They will receive an email invitation to join the group.

![invite members](/docker-hub/invite.png)


