// Code generated by protoc-gen-gogo.
// source: ca.proto
// DO NOT EDIT!

package api

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import _ "github.com/docker/swarmkit/protobuf/plugin"

import strings "strings"
import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"
import sort "sort"
import strconv "strconv"
import reflect "reflect"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

import raftpicker "github.com/docker/swarmkit/manager/raftpicker"
import codes "google.golang.org/grpc/codes"
import metadata "google.golang.org/grpc/metadata"
import transport "google.golang.org/grpc/transport"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type NodeCertificateStatusRequest struct {
	NodeID string `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
}

func (m *NodeCertificateStatusRequest) Reset()                    { *m = NodeCertificateStatusRequest{} }
func (*NodeCertificateStatusRequest) ProtoMessage()               {}
func (*NodeCertificateStatusRequest) Descriptor() ([]byte, []int) { return fileDescriptorCa, []int{0} }

type NodeCertificateStatusResponse struct {
	Status      *IssuanceStatus `protobuf:"bytes,1,opt,name=status" json:"status,omitempty"`
	Certificate *Certificate    `protobuf:"bytes,2,opt,name=certificate" json:"certificate,omitempty"`
}

func (m *NodeCertificateStatusResponse) Reset()                    { *m = NodeCertificateStatusResponse{} }
func (*NodeCertificateStatusResponse) ProtoMessage()               {}
func (*NodeCertificateStatusResponse) Descriptor() ([]byte, []int) { return fileDescriptorCa, []int{1} }

type IssueNodeCertificateRequest struct {
	// DEPRECATED: Role is now selected based on which secret is matched.
	Role NodeRole `protobuf:"varint,1,opt,name=role,proto3,enum=docker.swarmkit.v1.NodeRole" json:"role,omitempty"`
	// CSR is the certificate signing request.
	CSR []byte `protobuf:"bytes,2,opt,name=csr,proto3" json:"csr,omitempty"`
	// Token represents a user-provided string that is necessary for new
	// nodes to join the cluster
	Token string `protobuf:"bytes,3,opt,name=token,proto3" json:"token,omitempty"`
}

func (m *IssueNodeCertificateRequest) Reset()                    { *m = IssueNodeCertificateRequest{} }
func (*IssueNodeCertificateRequest) ProtoMessage()               {}
func (*IssueNodeCertificateRequest) Descriptor() ([]byte, []int) { return fileDescriptorCa, []int{2} }

type IssueNodeCertificateResponse struct {
	NodeID         string              `protobuf:"bytes,1,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	NodeMembership NodeSpec_Membership `protobuf:"varint,2,opt,name=node_membership,json=nodeMembership,proto3,enum=docker.swarmkit.v1.NodeSpec_Membership" json:"node_membership,omitempty"`
}

func (m *IssueNodeCertificateResponse) Reset()                    { *m = IssueNodeCertificateResponse{} }
func (*IssueNodeCertificateResponse) ProtoMessage()               {}
func (*IssueNodeCertificateResponse) Descriptor() ([]byte, []int) { return fileDescriptorCa, []int{3} }

type GetRootCACertificateRequest struct {
}

func (m *GetRootCACertificateRequest) Reset()                    { *m = GetRootCACertificateRequest{} }
func (*GetRootCACertificateRequest) ProtoMessage()               {}
func (*GetRootCACertificateRequest) Descriptor() ([]byte, []int) { return fileDescriptorCa, []int{4} }

type GetRootCACertificateResponse struct {
	Certificate []byte `protobuf:"bytes,1,opt,name=certificate,proto3" json:"certificate,omitempty"`
}

func (m *GetRootCACertificateResponse) Reset()                    { *m = GetRootCACertificateResponse{} }
func (*GetRootCACertificateResponse) ProtoMessage()               {}
func (*GetRootCACertificateResponse) Descriptor() ([]byte, []int) { return fileDescriptorCa, []int{5} }

func init() {
	proto.RegisterType((*NodeCertificateStatusRequest)(nil), "docker.swarmkit.v1.NodeCertificateStatusRequest")
	proto.RegisterType((*NodeCertificateStatusResponse)(nil), "docker.swarmkit.v1.NodeCertificateStatusResponse")
	proto.RegisterType((*IssueNodeCertificateRequest)(nil), "docker.swarmkit.v1.IssueNodeCertificateRequest")
	proto.RegisterType((*IssueNodeCertificateResponse)(nil), "docker.swarmkit.v1.IssueNodeCertificateResponse")
	proto.RegisterType((*GetRootCACertificateRequest)(nil), "docker.swarmkit.v1.GetRootCACertificateRequest")
	proto.RegisterType((*GetRootCACertificateResponse)(nil), "docker.swarmkit.v1.GetRootCACertificateResponse")
}

type authenticatedWrapperCAServer struct {
	local     CAServer
	authorize func(context.Context, []string) error
}

func NewAuthenticatedWrapperCAServer(local CAServer, authorize func(context.Context, []string) error) CAServer {
	return &authenticatedWrapperCAServer{
		local:     local,
		authorize: authorize,
	}
}

func (p *authenticatedWrapperCAServer) GetRootCACertificate(ctx context.Context, r *GetRootCACertificateRequest) (*GetRootCACertificateResponse, error) {

	return p.local.GetRootCACertificate(ctx, r)
}

type authenticatedWrapperNodeCAServer struct {
	local     NodeCAServer
	authorize func(context.Context, []string) error
}

func NewAuthenticatedWrapperNodeCAServer(local NodeCAServer, authorize func(context.Context, []string) error) NodeCAServer {
	return &authenticatedWrapperNodeCAServer{
		local:     local,
		authorize: authorize,
	}
}

func (p *authenticatedWrapperNodeCAServer) IssueNodeCertificate(ctx context.Context, r *IssueNodeCertificateRequest) (*IssueNodeCertificateResponse, error) {

	return p.local.IssueNodeCertificate(ctx, r)
}

func (p *authenticatedWrapperNodeCAServer) NodeCertificateStatus(ctx context.Context, r *NodeCertificateStatusRequest) (*NodeCertificateStatusResponse, error) {

	return p.local.NodeCertificateStatus(ctx, r)
}

func (m *NodeCertificateStatusRequest) Copy() *NodeCertificateStatusRequest {
	if m == nil {
		return nil
	}

	o := &NodeCertificateStatusRequest{
		NodeID: m.NodeID,
	}

	return o
}

func (m *NodeCertificateStatusResponse) Copy() *NodeCertificateStatusResponse {
	if m == nil {
		return nil
	}

	o := &NodeCertificateStatusResponse{
		Status:      m.Status.Copy(),
		Certificate: m.Certificate.Copy(),
	}

	return o
}

func (m *IssueNodeCertificateRequest) Copy() *IssueNodeCertificateRequest {
	if m == nil {
		return nil
	}

	o := &IssueNodeCertificateRequest{
		Role:  m.Role,
		CSR:   m.CSR,
		Token: m.Token,
	}

	return o
}

func (m *IssueNodeCertificateResponse) Copy() *IssueNodeCertificateResponse {
	if m == nil {
		return nil
	}

	o := &IssueNodeCertificateResponse{
		NodeID:         m.NodeID,
		NodeMembership: m.NodeMembership,
	}

	return o
}

func (m *GetRootCACertificateRequest) Copy() *GetRootCACertificateRequest {
	if m == nil {
		return nil
	}

	o := &GetRootCACertificateRequest{}

	return o
}

func (m *GetRootCACertificateResponse) Copy() *GetRootCACertificateResponse {
	if m == nil {
		return nil
	}

	o := &GetRootCACertificateResponse{
		Certificate: m.Certificate,
	}

	return o
}

func (this *NodeCertificateStatusRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.NodeCertificateStatusRequest{")
	s = append(s, "NodeID: "+fmt.Sprintf("%#v", this.NodeID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *NodeCertificateStatusResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.NodeCertificateStatusResponse{")
	if this.Status != nil {
		s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	}
	if this.Certificate != nil {
		s = append(s, "Certificate: "+fmt.Sprintf("%#v", this.Certificate)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *IssueNodeCertificateRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&api.IssueNodeCertificateRequest{")
	s = append(s, "Role: "+fmt.Sprintf("%#v", this.Role)+",\n")
	s = append(s, "CSR: "+fmt.Sprintf("%#v", this.CSR)+",\n")
	s = append(s, "Token: "+fmt.Sprintf("%#v", this.Token)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *IssueNodeCertificateResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.IssueNodeCertificateResponse{")
	s = append(s, "NodeID: "+fmt.Sprintf("%#v", this.NodeID)+",\n")
	s = append(s, "NodeMembership: "+fmt.Sprintf("%#v", this.NodeMembership)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetRootCACertificateRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&api.GetRootCACertificateRequest{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GetRootCACertificateResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.GetRootCACertificateResponse{")
	s = append(s, "Certificate: "+fmt.Sprintf("%#v", this.Certificate)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringCa(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func extensionToGoStringCa(e map[int32]github_com_gogo_protobuf_proto.Extension) string {
	if e == nil {
		return "nil"
	}
	s := "map[int32]proto.Extension{"
	keys := make([]int, 0, len(e))
	for k := range e {
		keys = append(keys, int(k))
	}
	sort.Ints(keys)
	ss := []string{}
	for _, k := range keys {
		ss = append(ss, strconv.Itoa(k)+": "+e[int32(k)].GoString())
	}
	s += strings.Join(ss, ",") + "}"
	return s
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion2

// Client API for CA service

type CAClient interface {
	GetRootCACertificate(ctx context.Context, in *GetRootCACertificateRequest, opts ...grpc.CallOption) (*GetRootCACertificateResponse, error)
}

type cAClient struct {
	cc *grpc.ClientConn
}

func NewCAClient(cc *grpc.ClientConn) CAClient {
	return &cAClient{cc}
}

func (c *cAClient) GetRootCACertificate(ctx context.Context, in *GetRootCACertificateRequest, opts ...grpc.CallOption) (*GetRootCACertificateResponse, error) {
	out := new(GetRootCACertificateResponse)
	err := grpc.Invoke(ctx, "/docker.swarmkit.v1.CA/GetRootCACertificate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for CA service

type CAServer interface {
	GetRootCACertificate(context.Context, *GetRootCACertificateRequest) (*GetRootCACertificateResponse, error)
}

func RegisterCAServer(s *grpc.Server, srv CAServer) {
	s.RegisterService(&_CA_serviceDesc, srv)
}

func _CA_GetRootCACertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRootCACertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CAServer).GetRootCACertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.CA/GetRootCACertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CAServer).GetRootCACertificate(ctx, req.(*GetRootCACertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CA_serviceDesc = grpc.ServiceDesc{
	ServiceName: "docker.swarmkit.v1.CA",
	HandlerType: (*CAServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetRootCACertificate",
			Handler:    _CA_GetRootCACertificate_Handler,
		},
	},
	Streams: []grpc.StreamDesc{},
}

// Client API for NodeCA service

type NodeCAClient interface {
	IssueNodeCertificate(ctx context.Context, in *IssueNodeCertificateRequest, opts ...grpc.CallOption) (*IssueNodeCertificateResponse, error)
	NodeCertificateStatus(ctx context.Context, in *NodeCertificateStatusRequest, opts ...grpc.CallOption) (*NodeCertificateStatusResponse, error)
}

type nodeCAClient struct {
	cc *grpc.ClientConn
}

func NewNodeCAClient(cc *grpc.ClientConn) NodeCAClient {
	return &nodeCAClient{cc}
}

func (c *nodeCAClient) IssueNodeCertificate(ctx context.Context, in *IssueNodeCertificateRequest, opts ...grpc.CallOption) (*IssueNodeCertificateResponse, error) {
	out := new(IssueNodeCertificateResponse)
	err := grpc.Invoke(ctx, "/docker.swarmkit.v1.NodeCA/IssueNodeCertificate", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeCAClient) NodeCertificateStatus(ctx context.Context, in *NodeCertificateStatusRequest, opts ...grpc.CallOption) (*NodeCertificateStatusResponse, error) {
	out := new(NodeCertificateStatusResponse)
	err := grpc.Invoke(ctx, "/docker.swarmkit.v1.NodeCA/NodeCertificateStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for NodeCA service

type NodeCAServer interface {
	IssueNodeCertificate(context.Context, *IssueNodeCertificateRequest) (*IssueNodeCertificateResponse, error)
	NodeCertificateStatus(context.Context, *NodeCertificateStatusRequest) (*NodeCertificateStatusResponse, error)
}

func RegisterNodeCAServer(s *grpc.Server, srv NodeCAServer) {
	s.RegisterService(&_NodeCA_serviceDesc, srv)
}

func _NodeCA_IssueNodeCertificate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IssueNodeCertificateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeCAServer).IssueNodeCertificate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.NodeCA/IssueNodeCertificate",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeCAServer).IssueNodeCertificate(ctx, req.(*IssueNodeCertificateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeCA_NodeCertificateStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(NodeCertificateStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeCAServer).NodeCertificateStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.NodeCA/NodeCertificateStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeCAServer).NodeCertificateStatus(ctx, req.(*NodeCertificateStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _NodeCA_serviceDesc = grpc.ServiceDesc{
	ServiceName: "docker.swarmkit.v1.NodeCA",
	HandlerType: (*NodeCAServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "IssueNodeCertificate",
			Handler:    _NodeCA_IssueNodeCertificate_Handler,
		},
		{
			MethodName: "NodeCertificateStatus",
			Handler:    _NodeCA_NodeCertificateStatus_Handler,
		},
	},
	Streams: []grpc.StreamDesc{},
}

func (m *NodeCertificateStatusRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *NodeCertificateStatusRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintCa(data, i, uint64(len(m.NodeID)))
		i += copy(data[i:], m.NodeID)
	}
	return i, nil
}

func (m *NodeCertificateStatusResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *NodeCertificateStatusResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Status != nil {
		data[i] = 0xa
		i++
		i = encodeVarintCa(data, i, uint64(m.Status.Size()))
		n1, err := m.Status.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.Certificate != nil {
		data[i] = 0x12
		i++
		i = encodeVarintCa(data, i, uint64(m.Certificate.Size()))
		n2, err := m.Certificate.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}

func (m *IssueNodeCertificateRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *IssueNodeCertificateRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Role != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintCa(data, i, uint64(m.Role))
	}
	if len(m.CSR) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintCa(data, i, uint64(len(m.CSR)))
		i += copy(data[i:], m.CSR)
	}
	if len(m.Token) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintCa(data, i, uint64(len(m.Token)))
		i += copy(data[i:], m.Token)
	}
	return i, nil
}

func (m *IssueNodeCertificateResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *IssueNodeCertificateResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.NodeID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintCa(data, i, uint64(len(m.NodeID)))
		i += copy(data[i:], m.NodeID)
	}
	if m.NodeMembership != 0 {
		data[i] = 0x10
		i++
		i = encodeVarintCa(data, i, uint64(m.NodeMembership))
	}
	return i, nil
}

func (m *GetRootCACertificateRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *GetRootCACertificateRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *GetRootCACertificateResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *GetRootCACertificateResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Certificate) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintCa(data, i, uint64(len(m.Certificate)))
		i += copy(data[i:], m.Certificate)
	}
	return i, nil
}

func encodeFixed64Ca(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Ca(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintCa(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}

type raftProxyCAServer struct {
	local        CAServer
	connSelector raftpicker.Interface
	cluster      raftpicker.RaftCluster
	ctxMods      []func(context.Context) (context.Context, error)
}

func NewRaftProxyCAServer(local CAServer, connSelector raftpicker.Interface, cluster raftpicker.RaftCluster, ctxMod func(context.Context) (context.Context, error)) CAServer {
	redirectChecker := func(ctx context.Context) (context.Context, error) {
		s, ok := transport.StreamFromContext(ctx)
		if !ok {
			return ctx, grpc.Errorf(codes.InvalidArgument, "remote addr is not found in context")
		}
		addr := s.ServerTransport().RemoteAddr().String()
		md, ok := metadata.FromContext(ctx)
		if ok && len(md["redirect"]) != 0 {
			return ctx, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
		}
		if !ok {
			md = metadata.New(map[string]string{})
		}
		md["redirect"] = append(md["redirect"], addr)
		return metadata.NewContext(ctx, md), nil
	}
	mods := []func(context.Context) (context.Context, error){redirectChecker}
	mods = append(mods, ctxMod)

	return &raftProxyCAServer{
		local:        local,
		cluster:      cluster,
		connSelector: connSelector,
		ctxMods:      mods,
	}
}
func (p *raftProxyCAServer) runCtxMods(ctx context.Context) (context.Context, error) {
	var err error
	for _, mod := range p.ctxMods {
		ctx, err = mod(ctx)
		if err != nil {
			return ctx, err
		}
	}
	return ctx, nil
}

func (p *raftProxyCAServer) GetRootCACertificate(ctx context.Context, r *GetRootCACertificateRequest) (*GetRootCACertificateResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.GetRootCACertificate(ctx, r)
	}
	ctx, err := p.runCtxMods(ctx)
	if err != nil {
		return nil, err
	}
	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}

	defer func() {
		if err != nil {
			errStr := err.Error()
			if strings.Contains(errStr, grpc.ErrClientConnClosing.Error()) ||
				strings.Contains(errStr, grpc.ErrClientConnTimeout.Error()) ||
				strings.Contains(errStr, "connection error") ||
				grpc.Code(err) == codes.Internal {
				p.connSelector.Reset()
			}
		}
	}()

	return NewCAClient(conn).GetRootCACertificate(ctx, r)
}

type raftProxyNodeCAServer struct {
	local        NodeCAServer
	connSelector raftpicker.Interface
	cluster      raftpicker.RaftCluster
	ctxMods      []func(context.Context) (context.Context, error)
}

func NewRaftProxyNodeCAServer(local NodeCAServer, connSelector raftpicker.Interface, cluster raftpicker.RaftCluster, ctxMod func(context.Context) (context.Context, error)) NodeCAServer {
	redirectChecker := func(ctx context.Context) (context.Context, error) {
		s, ok := transport.StreamFromContext(ctx)
		if !ok {
			return ctx, grpc.Errorf(codes.InvalidArgument, "remote addr is not found in context")
		}
		addr := s.ServerTransport().RemoteAddr().String()
		md, ok := metadata.FromContext(ctx)
		if ok && len(md["redirect"]) != 0 {
			return ctx, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
		}
		if !ok {
			md = metadata.New(map[string]string{})
		}
		md["redirect"] = append(md["redirect"], addr)
		return metadata.NewContext(ctx, md), nil
	}
	mods := []func(context.Context) (context.Context, error){redirectChecker}
	mods = append(mods, ctxMod)

	return &raftProxyNodeCAServer{
		local:        local,
		cluster:      cluster,
		connSelector: connSelector,
		ctxMods:      mods,
	}
}
func (p *raftProxyNodeCAServer) runCtxMods(ctx context.Context) (context.Context, error) {
	var err error
	for _, mod := range p.ctxMods {
		ctx, err = mod(ctx)
		if err != nil {
			return ctx, err
		}
	}
	return ctx, nil
}

func (p *raftProxyNodeCAServer) IssueNodeCertificate(ctx context.Context, r *IssueNodeCertificateRequest) (*IssueNodeCertificateResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.IssueNodeCertificate(ctx, r)
	}
	ctx, err := p.runCtxMods(ctx)
	if err != nil {
		return nil, err
	}
	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}

	defer func() {
		if err != nil {
			errStr := err.Error()
			if strings.Contains(errStr, grpc.ErrClientConnClosing.Error()) ||
				strings.Contains(errStr, grpc.ErrClientConnTimeout.Error()) ||
				strings.Contains(errStr, "connection error") ||
				grpc.Code(err) == codes.Internal {
				p.connSelector.Reset()
			}
		}
	}()

	return NewNodeCAClient(conn).IssueNodeCertificate(ctx, r)
}

func (p *raftProxyNodeCAServer) NodeCertificateStatus(ctx context.Context, r *NodeCertificateStatusRequest) (*NodeCertificateStatusResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.NodeCertificateStatus(ctx, r)
	}
	ctx, err := p.runCtxMods(ctx)
	if err != nil {
		return nil, err
	}
	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}

	defer func() {
		if err != nil {
			errStr := err.Error()
			if strings.Contains(errStr, grpc.ErrClientConnClosing.Error()) ||
				strings.Contains(errStr, grpc.ErrClientConnTimeout.Error()) ||
				strings.Contains(errStr, "connection error") ||
				grpc.Code(err) == codes.Internal {
				p.connSelector.Reset()
			}
		}
	}()

	return NewNodeCAClient(conn).NodeCertificateStatus(ctx, r)
}

func (m *NodeCertificateStatusRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeID)
	if l > 0 {
		n += 1 + l + sovCa(uint64(l))
	}
	return n
}

func (m *NodeCertificateStatusResponse) Size() (n int) {
	var l int
	_ = l
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovCa(uint64(l))
	}
	if m.Certificate != nil {
		l = m.Certificate.Size()
		n += 1 + l + sovCa(uint64(l))
	}
	return n
}

func (m *IssueNodeCertificateRequest) Size() (n int) {
	var l int
	_ = l
	if m.Role != 0 {
		n += 1 + sovCa(uint64(m.Role))
	}
	l = len(m.CSR)
	if l > 0 {
		n += 1 + l + sovCa(uint64(l))
	}
	l = len(m.Token)
	if l > 0 {
		n += 1 + l + sovCa(uint64(l))
	}
	return n
}

func (m *IssueNodeCertificateResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.NodeID)
	if l > 0 {
		n += 1 + l + sovCa(uint64(l))
	}
	if m.NodeMembership != 0 {
		n += 1 + sovCa(uint64(m.NodeMembership))
	}
	return n
}

func (m *GetRootCACertificateRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *GetRootCACertificateResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.Certificate)
	if l > 0 {
		n += 1 + l + sovCa(uint64(l))
	}
	return n
}

func sovCa(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozCa(x uint64) (n int) {
	return sovCa(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *NodeCertificateStatusRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NodeCertificateStatusRequest{`,
		`NodeID:` + fmt.Sprintf("%v", this.NodeID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *NodeCertificateStatusResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&NodeCertificateStatusResponse{`,
		`Status:` + strings.Replace(fmt.Sprintf("%v", this.Status), "IssuanceStatus", "IssuanceStatus", 1) + `,`,
		`Certificate:` + strings.Replace(fmt.Sprintf("%v", this.Certificate), "Certificate", "Certificate", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *IssueNodeCertificateRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&IssueNodeCertificateRequest{`,
		`Role:` + fmt.Sprintf("%v", this.Role) + `,`,
		`CSR:` + fmt.Sprintf("%v", this.CSR) + `,`,
		`Token:` + fmt.Sprintf("%v", this.Token) + `,`,
		`}`,
	}, "")
	return s
}
func (this *IssueNodeCertificateResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&IssueNodeCertificateResponse{`,
		`NodeID:` + fmt.Sprintf("%v", this.NodeID) + `,`,
		`NodeMembership:` + fmt.Sprintf("%v", this.NodeMembership) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GetRootCACertificateRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetRootCACertificateRequest{`,
		`}`,
	}, "")
	return s
}
func (this *GetRootCACertificateResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GetRootCACertificateResponse{`,
		`Certificate:` + fmt.Sprintf("%v", this.Certificate) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringCa(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *NodeCertificateStatusRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCa
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeCertificateStatusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeCertificateStatusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCa
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCa
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCa(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCa
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeCertificateStatusResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCa
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeCertificateStatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeCertificateStatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCa
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCa
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &IssuanceStatus{}
			}
			if err := m.Status.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Certificate", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCa
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthCa
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Certificate == nil {
				m.Certificate = &Certificate{}
			}
			if err := m.Certificate.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCa(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCa
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IssueNodeCertificateRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCa
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IssueNodeCertificateRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IssueNodeCertificateRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			m.Role = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCa
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Role |= (NodeRole(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CSR", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCa
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthCa
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CSR = append(m.CSR[:0], data[iNdEx:postIndex]...)
			if m.CSR == nil {
				m.CSR = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Token", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCa
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCa
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Token = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCa(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCa
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IssueNodeCertificateResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCa
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IssueNodeCertificateResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IssueNodeCertificateResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCa
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthCa
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeMembership", wireType)
			}
			m.NodeMembership = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCa
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.NodeMembership |= (NodeSpec_Membership(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipCa(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCa
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetRootCACertificateRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCa
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetRootCACertificateRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetRootCACertificateRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipCa(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCa
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetRootCACertificateResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowCa
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetRootCACertificateResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetRootCACertificateResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Certificate", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowCa
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthCa
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Certificate = append(m.Certificate[:0], data[iNdEx:postIndex]...)
			if m.Certificate == nil {
				m.Certificate = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipCa(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthCa
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipCa(data []byte) (n int, err error) {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowCa
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCa
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if data[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowCa
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthCa
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowCa
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipCa(data[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthCa = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowCa   = fmt.Errorf("proto: integer overflow")
)

var fileDescriptorCa = []byte{
	// 490 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x94, 0x94, 0xcf, 0x8e, 0xd3, 0x30,
	0x10, 0xc6, 0x71, 0x0a, 0xdd, 0x65, 0xba, 0x2a, 0xc8, 0x14, 0xa9, 0x74, 0xb3, 0xdd, 0x95, 0x39,
	0xc0, 0x29, 0xdd, 0x0d, 0x9c, 0x38, 0xd1, 0x06, 0x09, 0xf5, 0x00, 0x42, 0xee, 0x03, 0xa0, 0x6c,
	0x6a, 0x4a, 0xd4, 0x6d, 0x1c, 0x62, 0x07, 0xc4, 0x0d, 0x09, 0xc4, 0x81, 0x3b, 0x82, 0x13, 0x8f,
	0xc0, 0x73, 0xac, 0x38, 0x71, 0xe4, 0x84, 0xd8, 0x7d, 0x00, 0xc4, 0x23, 0x60, 0x3b, 0x29, 0xdd,
	0x3f, 0x4e, 0x55, 0x0e, 0xa3, 0xc6, 0xe3, 0xf9, 0xbe, 0xfe, 0x32, 0x63, 0x07, 0xd6, 0xa3, 0xd0,
	0x4b, 0x33, 0x2e, 0x39, 0xc6, 0x63, 0x1e, 0x4d, 0x59, 0xe6, 0x89, 0x57, 0x61, 0x36, 0x9b, 0xc6,
	0xd2, 0x7b, 0xb9, 0xd7, 0x69, 0xc8, 0xd7, 0x29, 0x13, 0x45, 0x41, 0xa7, 0x21, 0x52, 0x16, 0xcd,
	0x17, 0xad, 0x09, 0x9f, 0x70, 0xf3, 0xd8, 0xd3, 0x4f, 0x65, 0xf6, 0x5a, 0x7a, 0x90, 0x4f, 0xe2,
	0xa4, 0x57, 0xfc, 0x14, 0x49, 0x12, 0x80, 0xfb, 0x98, 0x8f, 0x59, 0xc0, 0x32, 0x19, 0x3f, 0x8b,
	0xa3, 0x50, 0xb2, 0x91, 0x0c, 0x65, 0x2e, 0x28, 0x7b, 0x91, 0x33, 0x21, 0xf1, 0x4d, 0x58, 0x4b,
	0xd4, 0xfe, 0xd3, 0x78, 0xdc, 0x46, 0x3b, 0xe8, 0xf6, 0xe5, 0x01, 0x1c, 0xff, 0xdc, 0xae, 0x6b,
	0xc9, 0xf0, 0x01, 0xad, 0xeb, 0xad, 0xe1, 0x98, 0x7c, 0x41, 0xb0, 0x55, 0xe1, 0x22, 0x52, 0x9e,
	0x08, 0x86, 0xef, 0x41, 0x5d, 0x98, 0x8c, 0x71, 0x69, 0xf8, 0xc4, 0x3b, 0xff, 0x42, 0xde, 0x50,
	0x88, 0x3c, 0x4c, 0xa2, 0xb9, 0xb6, 0x54, 0xe0, 0x3e, 0x34, 0xa2, 0x85, 0x71, 0xdb, 0x31, 0x06,
	0xdb, 0x36, 0x83, 0x13, 0xff, 0x4f, 0x4f, 0x6a, 0xc8, 0x3b, 0x04, 0x9b, 0xda, 0x9d, 0x9d, 0xa1,
	0x9c, 0xbf, 0xe5, 0x5d, 0xb8, 0x98, 0xf1, 0x03, 0x66, 0xe0, 0x9a, 0xbe, 0x6b, 0xf3, 0xd6, 0x4a,
	0xaa, 0x6a, 0x06, 0x4e, 0x1b, 0x51, 0x53, 0x8d, 0x6f, 0x40, 0x2d, 0x12, 0x99, 0x01, 0xda, 0x18,
	0xac, 0xa9, 0xbe, 0xd4, 0x82, 0x11, 0xa5, 0x3a, 0x87, 0x5b, 0x70, 0x49, 0xf2, 0x29, 0x4b, 0xda,
	0x35, 0xdd, 0x34, 0x5a, 0x2c, 0xc8, 0x47, 0x04, 0xae, 0x1d, 0xa3, 0x6c, 0xd3, 0x2a, 0xdd, 0xc6,
	0x4f, 0xe0, 0x8a, 0x29, 0x9a, 0xb1, 0xd9, 0x3e, 0xcb, 0xc4, 0xf3, 0x38, 0x35, 0x08, 0x4d, 0xff,
	0x56, 0x15, 0xf7, 0x48, 0x9d, 0x0d, 0xef, 0xd1, 0xbf, 0x72, 0xda, 0xd4, 0xfa, 0xc5, 0x9a, 0x6c,
	0xc1, 0xe6, 0x43, 0x26, 0x29, 0xe7, 0x32, 0xe8, 0x9f, 0xef, 0x0e, 0xb9, 0x0f, 0xae, 0x7d, 0xbb,
	0xa4, 0xde, 0x39, 0x3d, 0x20, 0x4d, 0xbe, 0x71, 0xaa, 0xff, 0xfe, 0x07, 0x04, 0x4e, 0xd0, 0xc7,
	0x6f, 0x11, 0xb4, 0x6c, 0x4e, 0xb8, 0x67, 0x23, 0x5f, 0x82, 0xd4, 0xd9, 0x5d, 0x5d, 0x50, 0x40,
	0x92, 0xf5, 0x6f, 0x5f, 0x7f, 0x7f, 0x76, 0x9c, 0xab, 0xc8, 0xff, 0xe4, 0x80, 0x69, 0x69, 0x09,
	0x64, 0x1b, 0x88, 0x1d, 0x68, 0xc9, 0x09, 0xb2, 0x03, 0x2d, 0x9b, 0xf5, 0x02, 0x08, 0xbf, 0x47,
	0x70, 0xdd, 0x7a, 0x7d, 0xf0, 0x6e, 0xd5, 0x44, 0xab, 0xee, 0x6b, 0x67, 0xef, 0x3f, 0x14, 0x67,
	0x41, 0x06, 0xee, 0xe1, 0x51, 0xf7, 0xc2, 0x0f, 0x15, 0x7f, 0x8e, 0xba, 0xe8, 0xcd, 0x71, 0x17,
	0x1d, 0xaa, 0xf8, 0xae, 0xe2, 0x97, 0x8a, 0xfd, 0xba, 0xf9, 0x62, 0xdc, 0xf9, 0x1b, 0x00, 0x00,
	0xff, 0xff, 0xb3, 0xf8, 0x41, 0xef, 0x96, 0x04, 0x00, 0x00,
}
