// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/api/metric/metric.proto
// DO NOT EDIT!

/*
Package google_api is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/genproto/googleapis/api/metric/metric.proto

It has these top-level messages:
	MetricDescriptor
	Metric
*/
package google_api // import "google.golang.org/genproto/googleapis/api/metric"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_api1 "google.golang.org/genproto/googleapis/api/label"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The kind of measurement. It describes how the data is reported.
type MetricDescriptor_MetricKind int32

const (
	// Do not use this default value.
	MetricDescriptor_METRIC_KIND_UNSPECIFIED MetricDescriptor_MetricKind = 0
	// An instantaneous measurement of a value.
	MetricDescriptor_GAUGE MetricDescriptor_MetricKind = 1
	// The change in a value during a time interval.
	MetricDescriptor_DELTA MetricDescriptor_MetricKind = 2
	// A value accumulated over a time interval.  Cumulative
	// measurements in a time series should have the same start time
	// and increasing end times, until an event resets the cumulative
	// value to zero and sets a new start time for the following
	// points.
	MetricDescriptor_CUMULATIVE MetricDescriptor_MetricKind = 3
)

var MetricDescriptor_MetricKind_name = map[int32]string{
	0: "METRIC_KIND_UNSPECIFIED",
	1: "GAUGE",
	2: "DELTA",
	3: "CUMULATIVE",
}
var MetricDescriptor_MetricKind_value = map[string]int32{
	"METRIC_KIND_UNSPECIFIED": 0,
	"GAUGE":                   1,
	"DELTA":                   2,
	"CUMULATIVE":              3,
}

func (x MetricDescriptor_MetricKind) String() string {
	return proto.EnumName(MetricDescriptor_MetricKind_name, int32(x))
}
func (MetricDescriptor_MetricKind) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{0, 0}
}

// The value type of a metric.
type MetricDescriptor_ValueType int32

const (
	// Do not use this default value.
	MetricDescriptor_VALUE_TYPE_UNSPECIFIED MetricDescriptor_ValueType = 0
	// The value is a boolean.
	// This value type can be used only if the metric kind is `GAUGE`.
	MetricDescriptor_BOOL MetricDescriptor_ValueType = 1
	// The value is a signed 64-bit integer.
	MetricDescriptor_INT64 MetricDescriptor_ValueType = 2
	// The value is a double precision floating point number.
	MetricDescriptor_DOUBLE MetricDescriptor_ValueType = 3
	// The value is a text string.
	// This value type can be used only if the metric kind is `GAUGE`.
	MetricDescriptor_STRING MetricDescriptor_ValueType = 4
	// The value is a [`Distribution`][google.api.Distribution].
	MetricDescriptor_DISTRIBUTION MetricDescriptor_ValueType = 5
	// The value is money.
	MetricDescriptor_MONEY MetricDescriptor_ValueType = 6
)

var MetricDescriptor_ValueType_name = map[int32]string{
	0: "VALUE_TYPE_UNSPECIFIED",
	1: "BOOL",
	2: "INT64",
	3: "DOUBLE",
	4: "STRING",
	5: "DISTRIBUTION",
	6: "MONEY",
}
var MetricDescriptor_ValueType_value = map[string]int32{
	"VALUE_TYPE_UNSPECIFIED": 0,
	"BOOL":         1,
	"INT64":        2,
	"DOUBLE":       3,
	"STRING":       4,
	"DISTRIBUTION": 5,
	"MONEY":        6,
}

func (x MetricDescriptor_ValueType) String() string {
	return proto.EnumName(MetricDescriptor_ValueType_name, int32(x))
}
func (MetricDescriptor_ValueType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{0, 1}
}

// Defines a metric type and its schema.
type MetricDescriptor struct {
	// Resource name. The format of the name may vary between different
	// implementations. For examples:
	//
	//     projects/{project_id}/metricDescriptors/{type=**}
	//     metricDescriptors/{type=**}
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// The metric type including a DNS name prefix, for example
	// `"compute.googleapis.com/instance/cpu/utilization"`. Metric types
	// should use a natural hierarchical grouping such as the following:
	//
	//     compute.googleapis.com/instance/cpu/utilization
	//     compute.googleapis.com/instance/disk/read_ops_count
	//     compute.googleapis.com/instance/network/received_bytes_count
	//
	// Note that if the metric type changes, the monitoring data will be
	// discontinued, and anything depends on it will break, such as monitoring
	// dashboards, alerting rules and quota limits. Therefore, once a metric has
	// been published, its type should be immutable.
	Type string `protobuf:"bytes,8,opt,name=type" json:"type,omitempty"`
	// The set of labels that can be used to describe a specific instance of this
	// metric type. For example, the
	// `compute.googleapis.com/instance/network/received_bytes_count` metric type
	// has a label, `loadbalanced`, that specifies whether the traffic was
	// received through a load balanced IP address.
	Labels []*google_api1.LabelDescriptor `protobuf:"bytes,2,rep,name=labels" json:"labels,omitempty"`
	// Whether the metric records instantaneous values, changes to a value, etc.
	MetricKind MetricDescriptor_MetricKind `protobuf:"varint,3,opt,name=metric_kind,json=metricKind,enum=google.api.MetricDescriptor_MetricKind" json:"metric_kind,omitempty"`
	// Whether the measurement is an integer, a floating-point number, etc.
	ValueType MetricDescriptor_ValueType `protobuf:"varint,4,opt,name=value_type,json=valueType,enum=google.api.MetricDescriptor_ValueType" json:"value_type,omitempty"`
	// The unit in which the metric value is reported. It is only applicable
	// if the `value_type` is `INT64`, `DOUBLE`, or `DISTRIBUTION`. The
	// supported units are a subset of [The Unified Code for Units of
	// Measure](http://unitsofmeasure.org/ucum.html) standard:
	//
	// **Basic units (UNIT)**
	//
	// * `bit`   bit
	// * `By`    byte
	// * `s`     second
	// * `min`   minute
	// * `h`     hour
	// * `d`     day
	//
	// **Prefixes (PREFIX)**
	//
	// * `k`     kilo    (10**3)
	// * `M`     mega    (10**6)
	// * `G`     giga    (10**9)
	// * `T`     tera    (10**12)
	// * `P`     peta    (10**15)
	// * `E`     exa     (10**18)
	// * `Z`     zetta   (10**21)
	// * `Y`     yotta   (10**24)
	// * `m`     milli   (10**-3)
	// * `u`     micro   (10**-6)
	// * `n`     nano    (10**-9)
	// * `p`     pico    (10**-12)
	// * `f`     femto   (10**-15)
	// * `a`     atto    (10**-18)
	// * `z`     zepto   (10**-21)
	// * `y`     yocto   (10**-24)
	// * `Ki`    kibi    (2**10)
	// * `Mi`    mebi    (2**20)
	// * `Gi`    gibi    (2**30)
	// * `Ti`    tebi    (2**40)
	//
	// **Grammar**
	//
	// The grammar includes the dimensionless unit `1`, such as `1/s`.
	//
	// The grammar also includes these connectors:
	//
	// * `/`    division (as an infix operator, e.g. `1/s`).
	// * `.`    multiplication (as an infix operator, e.g. `GBy.d`)
	//
	// The grammar for a unit is as follows:
	//
	//     Expression = Component { "." Component } { "/" Component } ;
	//
	//     Component = [ PREFIX ] UNIT [ Annotation ]
	//               | Annotation
	//               | "1"
	//               ;
	//
	//     Annotation = "{" NAME "}" ;
	//
	// Notes:
	//
	// * `Annotation` is just a comment if it follows a `UNIT` and is
	//    equivalent to `1` if it is used alone. For examples,
	//    `{requests}/s == 1/s`, `By{transmitted}/s == By/s`.
	// * `NAME` is a sequence of non-blank printable ASCII characters not
	//    containing '{' or '}'.
	Unit string `protobuf:"bytes,5,opt,name=unit" json:"unit,omitempty"`
	// A detailed description of the metric, which can be used in documentation.
	Description string `protobuf:"bytes,6,opt,name=description" json:"description,omitempty"`
	// A concise name for the metric, which can be displayed in user interfaces.
	// Use sentence case without an ending period, for example "Request count".
	DisplayName string `protobuf:"bytes,7,opt,name=display_name,json=displayName" json:"display_name,omitempty"`
}

func (m *MetricDescriptor) Reset()                    { *m = MetricDescriptor{} }
func (m *MetricDescriptor) String() string            { return proto.CompactTextString(m) }
func (*MetricDescriptor) ProtoMessage()               {}
func (*MetricDescriptor) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *MetricDescriptor) GetLabels() []*google_api1.LabelDescriptor {
	if m != nil {
		return m.Labels
	}
	return nil
}

// A specific metric identified by specifying values for all of the
// labels of a [`MetricDescriptor`][google.api.MetricDescriptor].
type Metric struct {
	// An existing metric type, see [google.api.MetricDescriptor][google.api.MetricDescriptor].
	// For example, `compute.googleapis.com/instance/cpu/usage_time`.
	Type string `protobuf:"bytes,3,opt,name=type" json:"type,omitempty"`
	// The set of labels that uniquely identify a metric. To specify a
	// metric, all labels enumerated in the `MetricDescriptor` must be
	// assigned values.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *Metric) Reset()                    { *m = Metric{} }
func (m *Metric) String() string            { return proto.CompactTextString(m) }
func (*Metric) ProtoMessage()               {}
func (*Metric) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Metric) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func init() {
	proto.RegisterType((*MetricDescriptor)(nil), "google.api.MetricDescriptor")
	proto.RegisterType((*Metric)(nil), "google.api.Metric")
	proto.RegisterEnum("google.api.MetricDescriptor_MetricKind", MetricDescriptor_MetricKind_name, MetricDescriptor_MetricKind_value)
	proto.RegisterEnum("google.api.MetricDescriptor_ValueType", MetricDescriptor_ValueType_name, MetricDescriptor_ValueType_value)
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/api/metric/metric.proto", fileDescriptor0)
}

var fileDescriptor0 = []byte{
	// 498 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x8c, 0x52, 0xdf, 0x6b, 0x9b, 0x50,
	0x14, 0x9e, 0x89, 0x71, 0xcd, 0x49, 0x09, 0x72, 0x19, 0x9b, 0xa4, 0x30, 0xb2, 0x3c, 0x74, 0x7d,
	0x4a, 0xa0, 0x1d, 0x65, 0x3f, 0xd8, 0x83, 0xc6, 0xbb, 0x4c, 0x6a, 0x54, 0xac, 0x06, 0xfa, 0x24,
	0x36, 0x11, 0x91, 0x1a, 0x75, 0x6a, 0x0b, 0xf9, 0x2b, 0xf6, 0x17, 0xec, 0x65, 0x7f, 0xe9, 0xee,
	0x0f, 0x9b, 0x48, 0x06, 0x63, 0x2f, 0xe6, 0xbb, 0xdf, 0x39, 0xe7, 0xbb, 0xdf, 0xb9, 0xf9, 0xe0,
	0x6b, 0x9c, 0xe7, 0x71, 0x1a, 0x4d, 0xe3, 0x3c, 0x0d, 0xb3, 0x78, 0x9a, 0x97, 0xf1, 0x2c, 0x8e,
	0xb2, 0xa2, 0xcc, 0xeb, 0x7c, 0xc6, 0x4b, 0x61, 0x91, 0x54, 0x33, 0xf2, 0x99, 0x6d, 0xa3, 0xba,
	0x4c, 0xd6, 0xcd, 0xcf, 0x94, 0xb5, 0x20, 0x68, 0xc6, 0x49, 0x7d, 0xf4, 0xe5, 0xff, 0xa5, 0xd2,
	0xf0, 0x3e, 0x4a, 0xf9, 0x97, 0x0b, 0x4d, 0x7e, 0x89, 0x20, 0x2f, 0x99, 0xb2, 0x1e, 0x55, 0xeb,
	0x32, 0x29, 0xea, 0xbc, 0x44, 0x08, 0xc4, 0x2c, 0xdc, 0x46, 0x8a, 0x30, 0x16, 0x2e, 0xfa, 0x2e,
	0xc3, 0x94, 0xab, 0x77, 0x45, 0xa4, 0x9c, 0x70, 0x8e, 0x62, 0x74, 0x05, 0x12, 0xd3, 0xaa, 0x94,
	0xce, 0xb8, 0x7b, 0x31, 0xb8, 0x3c, 0x9b, 0x1e, 0x6c, 0x4d, 0x4d, 0x5a, 0x39, 0x88, 0xba, 0x4d,
	0x2b, 0xfa, 0x0e, 0x03, 0xbe, 0x4a, 0xf0, 0x90, 0x64, 0x1b, 0xa5, 0x4b, 0xf4, 0x86, 0x97, 0xef,
	0xdb, 0x93, 0xc7, 0x7e, 0x1a, 0xe2, 0x86, 0xb4, 0xbb, 0xb0, 0xdd, 0x63, 0x84, 0x01, 0x9e, 0xc2,
	0xf4, 0x31, 0x0a, 0x98, 0x31, 0x91, 0x09, 0x9d, 0xff, 0x53, 0x68, 0x45, 0xdb, 0x3d, 0xd2, 0xed,
	0xf6, 0x9f, 0x9e, 0x21, 0xdd, 0xec, 0x31, 0x4b, 0x6a, 0xa5, 0xc7, 0x37, 0xa3, 0x18, 0x8d, 0x61,
	0xb0, 0x69, 0xc6, 0x92, 0x3c, 0x53, 0x24, 0x56, 0x6a, 0x53, 0xe8, 0x1d, 0x9c, 0x6e, 0x92, 0xaa,
	0x48, 0xc3, 0x5d, 0xc0, 0xde, 0xea, 0x65, 0xd3, 0xc2, 0x39, 0x8b, 0x50, 0x13, 0x1b, 0xe0, 0xe0,
	0x1c, 0x9d, 0xc1, 0x9b, 0x25, 0xf6, 0x5c, 0x63, 0x1e, 0xdc, 0x18, 0x96, 0x1e, 0xf8, 0xd6, 0xad,
	0x83, 0xe7, 0xc6, 0x37, 0x03, 0xeb, 0xf2, 0x0b, 0xd4, 0x87, 0xde, 0x42, 0xf5, 0x17, 0x58, 0x16,
	0x28, 0xd4, 0xb1, 0xe9, 0xa9, 0x72, 0x07, 0x0d, 0x01, 0xe6, 0xfe, 0xd2, 0x37, 0x55, 0xcf, 0x58,
	0x61, 0xb9, 0x3b, 0xf9, 0x01, 0xfd, 0xfd, 0x06, 0x68, 0x04, 0xaf, 0x57, 0xaa, 0xe9, 0xe3, 0xc0,
	0xbb, 0x73, 0xf0, 0x91, 0xdc, 0x09, 0x88, 0x9a, 0x6d, 0x9b, 0x5c, 0xcd, 0xb0, 0xbc, 0xeb, 0x0f,
	0x44, 0x0d, 0x40, 0xd2, 0x6d, 0x5f, 0x33, 0x89, 0x12, 0xc5, 0xb7, 0xc4, 0x8b, 0xb5, 0x90, 0x45,
	0x24, 0xc3, 0xa9, 0x6e, 0xd0, 0x93, 0xe6, 0x7b, 0x86, 0x6d, 0xc9, 0x3d, 0x3a, 0xb4, 0xb4, 0x2d,
	0x7c, 0x27, 0x4b, 0x93, 0x9f, 0x02, 0x48, 0x7c, 0x89, 0x7d, 0x02, 0xba, 0xad, 0x04, 0x5c, 0x1f,
	0x25, 0xe0, 0xed, 0xdf, 0xcf, 0xcf, 0x83, 0x50, 0xe1, 0xac, 0x2e, 0x77, 0xcf, 0x21, 0x18, 0x7d,
	0x82, 0x41, 0x8b, 0x26, 0x16, 0xba, 0x0f, 0xd1, 0xae, 0xc9, 0x1b, 0x85, 0xe8, 0x15, 0xf4, 0xd8,
	0x3f, 0x44, 0x74, 0x29, 0xc7, 0x0f, 0x9f, 0x3b, 0x1f, 0x05, 0xed, 0x1c, 0x86, 0xeb, 0x7c, 0xdb,
	0xba, 0x47, 0x1b, 0xf0, 0x8b, 0x1c, 0x1a, 0x68, 0x47, 0xf8, 0xdd, 0x11, 0x17, 0xaa, 0x63, 0xdc,
	0x4b, 0x2c, 0xe0, 0x57, 0x7f, 0x02, 0x00, 0x00, 0xff, 0xff, 0x9e, 0x86, 0xb0, 0x69, 0x6a, 0x03,
	0x00, 0x00,
}
