// Code generated by protoc-gen-gogo.
// source: dispatcher.proto
// DO NOT EDIT!

package api

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/gogo/protobuf/gogoproto"
import _ "github.com/docker/swarmkit/protobuf/plugin"
import docker_swarmkit_v11 "github.com/docker/swarmkit/api/duration"

import strings "strings"
import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"
import sort "sort"
import strconv "strconv"
import reflect "reflect"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

import raftpicker "github.com/docker/swarmkit/manager/raftpicker"
import codes "google.golang.org/grpc/codes"
import metadata "google.golang.org/grpc/metadata"
import transport "google.golang.org/grpc/transport"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// SessionRequest starts a session.
type SessionRequest struct {
	Description *NodeDescription `protobuf:"bytes,1,opt,name=description" json:"description,omitempty"`
}

func (m *SessionRequest) Reset()                    { *m = SessionRequest{} }
func (*SessionRequest) ProtoMessage()               {}
func (*SessionRequest) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{0} }

// SessionMessage instructs an agent on various actions as part of the current
// session. An agent should act immediately on the contents.
type SessionMessage struct {
	// SessionID is allocated after a successful registration. It should be
	// used on all RPC calls after registration. A dispatcher may choose to
	// change the SessionID, at which time an agent must re-register and obtain
	// a new one.
	//
	// All Dispatcher calls after register should include the SessionID. If the
	// Dispatcher so chooses, it may reject the call with an InvalidArgument
	// error code, at which time the agent should call Register to start a new
	// session.
	//
	// As a rule, once an agent has a SessionID, it should never save it to
	// disk or try to otherwise reuse. If the agent loses its SessionID, it
	// must start a new session through a call to Register. A Dispatcher may
	// choose to reuse the SessionID, if it sees fit, but it is not advised.
	//
	// The actual implementation of the SessionID is Dispatcher specific and
	// should be treated as opaque by agents.
	//
	// From a Dispatcher perspective, there are many ways to use the SessionID
	// to ensure uniqueness of a set of client RPC calls. One method is to keep
	// the SessionID unique to every call to Register in a single Dispatcher
	// instance. This ensures that the SessionID represents the unique
	// session from a single Agent to Manager. If the Agent restarts, we
	// allocate a new session, since the restarted Agent is not aware of the
	// new SessionID.
	//
	// The most compelling use case is to support duplicate node detection. If
	// one clones a virtual machine, including certificate material, two nodes
	// may end up with the same identity. This can also happen if two identical
	// agent processes are coming from the same node. If the SessionID is
	// replicated through the cluster, we can immediately detect the condition
	// and address it.
	//
	// Extending from the case above, we can actually detect a compromised
	// identity. Coupled with provisions to rebuild node identity, we can ban
	// the compromised node identity and have the nodes re-authenticate and
	// build a new identity. At this time, an administrator can then
	// re-authorize the compromised nodes, if it was a mistake or ensure that a
	// misbehaved node can no longer connect to the cluster.
	//
	// We considered placing this field in a GRPC header. Because this is a
	// critical feature of the protocol, we thought it should be represented
	// directly in the RPC message set.
	SessionID string `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	// Node identifies the registering node.
	Node *Node `protobuf:"bytes,2,opt,name=node" json:"node,omitempty"`
	// Managers provides a weight list of alternative dispatchers
	Managers []*WeightedPeer `protobuf:"bytes,3,rep,name=managers" json:"managers,omitempty"`
	// Symmetric encryption key distributed by the lead manager. Used by agents
	// for securing network bootstrapping and communication.
	NetworkBootstrapKeys []*EncryptionKey `protobuf:"bytes,4,rep,name=network_bootstrap_keys,json=networkBootstrapKeys" json:"network_bootstrap_keys,omitempty"`
}

func (m *SessionMessage) Reset()                    { *m = SessionMessage{} }
func (*SessionMessage) ProtoMessage()               {}
func (*SessionMessage) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{1} }

// HeartbeatRequest provides identifying properties for a single heartbeat.
type HeartbeatRequest struct {
	SessionID string `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
}

func (m *HeartbeatRequest) Reset()                    { *m = HeartbeatRequest{} }
func (*HeartbeatRequest) ProtoMessage()               {}
func (*HeartbeatRequest) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{2} }

type HeartbeatResponse struct {
	// Period is the duration to wait before sending the next heartbeat.
	// Well-behaved agents should update this on every heartbeat round trip.
	Period docker_swarmkit_v11.Duration `protobuf:"bytes,1,opt,name=period" json:"period"`
}

func (m *HeartbeatResponse) Reset()                    { *m = HeartbeatResponse{} }
func (*HeartbeatResponse) ProtoMessage()               {}
func (*HeartbeatResponse) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{3} }

type UpdateTaskStatusRequest struct {
	// Tasks should contain all statuses for running tasks. Only the status
	// field must be set. The spec is not required.
	SessionID string                                      `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
	Updates   []*UpdateTaskStatusRequest_TaskStatusUpdate `protobuf:"bytes,3,rep,name=updates" json:"updates,omitempty"`
}

func (m *UpdateTaskStatusRequest) Reset()      { *m = UpdateTaskStatusRequest{} }
func (*UpdateTaskStatusRequest) ProtoMessage() {}
func (*UpdateTaskStatusRequest) Descriptor() ([]byte, []int) {
	return fileDescriptorDispatcher, []int{4}
}

type UpdateTaskStatusRequest_TaskStatusUpdate struct {
	TaskID string      `protobuf:"bytes,1,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	Status *TaskStatus `protobuf:"bytes,2,opt,name=status" json:"status,omitempty"`
}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) Reset() {
	*m = UpdateTaskStatusRequest_TaskStatusUpdate{}
}
func (*UpdateTaskStatusRequest_TaskStatusUpdate) ProtoMessage() {}
func (*UpdateTaskStatusRequest_TaskStatusUpdate) Descriptor() ([]byte, []int) {
	return fileDescriptorDispatcher, []int{4, 0}
}

type UpdateTaskStatusResponse struct {
}

func (m *UpdateTaskStatusResponse) Reset()      { *m = UpdateTaskStatusResponse{} }
func (*UpdateTaskStatusResponse) ProtoMessage() {}
func (*UpdateTaskStatusResponse) Descriptor() ([]byte, []int) {
	return fileDescriptorDispatcher, []int{5}
}

type TasksRequest struct {
	SessionID string `protobuf:"bytes,1,opt,name=session_id,json=sessionId,proto3" json:"session_id,omitempty"`
}

func (m *TasksRequest) Reset()                    { *m = TasksRequest{} }
func (*TasksRequest) ProtoMessage()               {}
func (*TasksRequest) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{6} }

type TasksMessage struct {
	// Tasks is the set of tasks that should be running on the node.
	// Tasks outside of this set running on the node should be terminated.
	Tasks []*Task `protobuf:"bytes,1,rep,name=tasks" json:"tasks,omitempty"`
}

func (m *TasksMessage) Reset()                    { *m = TasksMessage{} }
func (*TasksMessage) ProtoMessage()               {}
func (*TasksMessage) Descriptor() ([]byte, []int) { return fileDescriptorDispatcher, []int{7} }

func init() {
	proto.RegisterType((*SessionRequest)(nil), "docker.swarmkit.v1.SessionRequest")
	proto.RegisterType((*SessionMessage)(nil), "docker.swarmkit.v1.SessionMessage")
	proto.RegisterType((*HeartbeatRequest)(nil), "docker.swarmkit.v1.HeartbeatRequest")
	proto.RegisterType((*HeartbeatResponse)(nil), "docker.swarmkit.v1.HeartbeatResponse")
	proto.RegisterType((*UpdateTaskStatusRequest)(nil), "docker.swarmkit.v1.UpdateTaskStatusRequest")
	proto.RegisterType((*UpdateTaskStatusRequest_TaskStatusUpdate)(nil), "docker.swarmkit.v1.UpdateTaskStatusRequest.TaskStatusUpdate")
	proto.RegisterType((*UpdateTaskStatusResponse)(nil), "docker.swarmkit.v1.UpdateTaskStatusResponse")
	proto.RegisterType((*TasksRequest)(nil), "docker.swarmkit.v1.TasksRequest")
	proto.RegisterType((*TasksMessage)(nil), "docker.swarmkit.v1.TasksMessage")
}

type authenticatedWrapperDispatcherServer struct {
	local     DispatcherServer
	authorize func(context.Context, []string) error
}

func NewAuthenticatedWrapperDispatcherServer(local DispatcherServer, authorize func(context.Context, []string) error) DispatcherServer {
	return &authenticatedWrapperDispatcherServer{
		local:     local,
		authorize: authorize,
	}
}

func (p *authenticatedWrapperDispatcherServer) Session(r *SessionRequest, stream Dispatcher_SessionServer) error {

	if err := p.authorize(stream.Context(), []string{"swarm-worker", "swarm-manager"}); err != nil {
		return err
	}
	return p.local.Session(r, stream)
}

func (p *authenticatedWrapperDispatcherServer) Heartbeat(ctx context.Context, r *HeartbeatRequest) (*HeartbeatResponse, error) {

	if err := p.authorize(ctx, []string{"swarm-worker", "swarm-manager"}); err != nil {
		return nil, err
	}
	return p.local.Heartbeat(ctx, r)
}

func (p *authenticatedWrapperDispatcherServer) UpdateTaskStatus(ctx context.Context, r *UpdateTaskStatusRequest) (*UpdateTaskStatusResponse, error) {

	if err := p.authorize(ctx, []string{"swarm-worker", "swarm-manager"}); err != nil {
		return nil, err
	}
	return p.local.UpdateTaskStatus(ctx, r)
}

func (p *authenticatedWrapperDispatcherServer) Tasks(r *TasksRequest, stream Dispatcher_TasksServer) error {

	if err := p.authorize(stream.Context(), []string{"swarm-worker", "swarm-manager"}); err != nil {
		return err
	}
	return p.local.Tasks(r, stream)
}

func (m *SessionRequest) Copy() *SessionRequest {
	if m == nil {
		return nil
	}

	o := &SessionRequest{
		Description: m.Description.Copy(),
	}

	return o
}

func (m *SessionMessage) Copy() *SessionMessage {
	if m == nil {
		return nil
	}

	o := &SessionMessage{
		SessionID: m.SessionID,
		Node:      m.Node.Copy(),
	}

	if m.Managers != nil {
		o.Managers = make([]*WeightedPeer, 0, len(m.Managers))
		for _, v := range m.Managers {
			o.Managers = append(o.Managers, v.Copy())
		}
	}

	if m.NetworkBootstrapKeys != nil {
		o.NetworkBootstrapKeys = make([]*EncryptionKey, 0, len(m.NetworkBootstrapKeys))
		for _, v := range m.NetworkBootstrapKeys {
			o.NetworkBootstrapKeys = append(o.NetworkBootstrapKeys, v.Copy())
		}
	}

	return o
}

func (m *HeartbeatRequest) Copy() *HeartbeatRequest {
	if m == nil {
		return nil
	}

	o := &HeartbeatRequest{
		SessionID: m.SessionID,
	}

	return o
}

func (m *HeartbeatResponse) Copy() *HeartbeatResponse {
	if m == nil {
		return nil
	}

	o := &HeartbeatResponse{
		Period: *m.Period.Copy(),
	}

	return o
}

func (m *UpdateTaskStatusRequest) Copy() *UpdateTaskStatusRequest {
	if m == nil {
		return nil
	}

	o := &UpdateTaskStatusRequest{
		SessionID: m.SessionID,
	}

	if m.Updates != nil {
		o.Updates = make([]*UpdateTaskStatusRequest_TaskStatusUpdate, 0, len(m.Updates))
		for _, v := range m.Updates {
			o.Updates = append(o.Updates, v.Copy())
		}
	}

	return o
}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) Copy() *UpdateTaskStatusRequest_TaskStatusUpdate {
	if m == nil {
		return nil
	}

	o := &UpdateTaskStatusRequest_TaskStatusUpdate{
		TaskID: m.TaskID,
		Status: m.Status.Copy(),
	}

	return o
}

func (m *UpdateTaskStatusResponse) Copy() *UpdateTaskStatusResponse {
	if m == nil {
		return nil
	}

	o := &UpdateTaskStatusResponse{}

	return o
}

func (m *TasksRequest) Copy() *TasksRequest {
	if m == nil {
		return nil
	}

	o := &TasksRequest{
		SessionID: m.SessionID,
	}

	return o
}

func (m *TasksMessage) Copy() *TasksMessage {
	if m == nil {
		return nil
	}

	o := &TasksMessage{}

	if m.Tasks != nil {
		o.Tasks = make([]*Task, 0, len(m.Tasks))
		for _, v := range m.Tasks {
			o.Tasks = append(o.Tasks, v.Copy())
		}
	}

	return o
}

func (this *SessionRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.SessionRequest{")
	if this.Description != nil {
		s = append(s, "Description: "+fmt.Sprintf("%#v", this.Description)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *SessionMessage) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&api.SessionMessage{")
	s = append(s, "SessionID: "+fmt.Sprintf("%#v", this.SessionID)+",\n")
	if this.Node != nil {
		s = append(s, "Node: "+fmt.Sprintf("%#v", this.Node)+",\n")
	}
	if this.Managers != nil {
		s = append(s, "Managers: "+fmt.Sprintf("%#v", this.Managers)+",\n")
	}
	if this.NetworkBootstrapKeys != nil {
		s = append(s, "NetworkBootstrapKeys: "+fmt.Sprintf("%#v", this.NetworkBootstrapKeys)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HeartbeatRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.HeartbeatRequest{")
	s = append(s, "SessionID: "+fmt.Sprintf("%#v", this.SessionID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *HeartbeatResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.HeartbeatResponse{")
	s = append(s, "Period: "+strings.Replace(this.Period.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UpdateTaskStatusRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.UpdateTaskStatusRequest{")
	s = append(s, "SessionID: "+fmt.Sprintf("%#v", this.SessionID)+",\n")
	if this.Updates != nil {
		s = append(s, "Updates: "+fmt.Sprintf("%#v", this.Updates)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UpdateTaskStatusRequest_TaskStatusUpdate) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.UpdateTaskStatusRequest_TaskStatusUpdate{")
	s = append(s, "TaskID: "+fmt.Sprintf("%#v", this.TaskID)+",\n")
	if this.Status != nil {
		s = append(s, "Status: "+fmt.Sprintf("%#v", this.Status)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *UpdateTaskStatusResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&api.UpdateTaskStatusResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TasksRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.TasksRequest{")
	s = append(s, "SessionID: "+fmt.Sprintf("%#v", this.SessionID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *TasksMessage) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.TasksMessage{")
	if this.Tasks != nil {
		s = append(s, "Tasks: "+fmt.Sprintf("%#v", this.Tasks)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringDispatcher(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func extensionToGoStringDispatcher(e map[int32]github_com_gogo_protobuf_proto.Extension) string {
	if e == nil {
		return "nil"
	}
	s := "map[int32]proto.Extension{"
	keys := make([]int, 0, len(e))
	for k := range e {
		keys = append(keys, int(k))
	}
	sort.Ints(keys)
	ss := []string{}
	for _, k := range keys {
		ss = append(ss, strconv.Itoa(k)+": "+e[int32(k)].GoString())
	}
	s += strings.Join(ss, ",") + "}"
	return s
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion2

// Client API for Dispatcher service

type DispatcherClient interface {
	// Session starts an agent session with the dispatcher. The session is
	// started after the first SessionMessage is received.
	//
	// Once started, the agent is controlled with a stream of SessionMessage.
	// Agents should list on the stream at all times for instructions.
	Session(ctx context.Context, in *SessionRequest, opts ...grpc.CallOption) (Dispatcher_SessionClient, error)
	// Heartbeat is heartbeat method for nodes. It returns new TTL in response.
	// Node should send new heartbeat earlier than now + TTL, otherwise it will
	// be deregistered from dispatcher and its status will be updated to NodeStatus_DOWN
	Heartbeat(ctx context.Context, in *HeartbeatRequest, opts ...grpc.CallOption) (*HeartbeatResponse, error)
	// UpdateTaskStatus updates status of task. Node should send such updates
	// on every status change of its tasks.
	//
	// Whether receiving batch updates or single status updates, this method
	// should be accepting. Errors should only be returned if the entire update
	// should be retried, due to data loss or other problems.
	//
	// If a task is unknown the dispatcher, the status update should be
	// accepted regardless.
	UpdateTaskStatus(ctx context.Context, in *UpdateTaskStatusRequest, opts ...grpc.CallOption) (*UpdateTaskStatusResponse, error)
	// Tasks is a stream of tasks state for node. Each message contains full list
	// of tasks which should be run on node, if task is not present in that list,
	// it should be terminated.
	Tasks(ctx context.Context, in *TasksRequest, opts ...grpc.CallOption) (Dispatcher_TasksClient, error)
}

type dispatcherClient struct {
	cc *grpc.ClientConn
}

func NewDispatcherClient(cc *grpc.ClientConn) DispatcherClient {
	return &dispatcherClient{cc}
}

func (c *dispatcherClient) Session(ctx context.Context, in *SessionRequest, opts ...grpc.CallOption) (Dispatcher_SessionClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Dispatcher_serviceDesc.Streams[0], c.cc, "/docker.swarmkit.v1.Dispatcher/Session", opts...)
	if err != nil {
		return nil, err
	}
	x := &dispatcherSessionClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Dispatcher_SessionClient interface {
	Recv() (*SessionMessage, error)
	grpc.ClientStream
}

type dispatcherSessionClient struct {
	grpc.ClientStream
}

func (x *dispatcherSessionClient) Recv() (*SessionMessage, error) {
	m := new(SessionMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *dispatcherClient) Heartbeat(ctx context.Context, in *HeartbeatRequest, opts ...grpc.CallOption) (*HeartbeatResponse, error) {
	out := new(HeartbeatResponse)
	err := grpc.Invoke(ctx, "/docker.swarmkit.v1.Dispatcher/Heartbeat", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dispatcherClient) UpdateTaskStatus(ctx context.Context, in *UpdateTaskStatusRequest, opts ...grpc.CallOption) (*UpdateTaskStatusResponse, error) {
	out := new(UpdateTaskStatusResponse)
	err := grpc.Invoke(ctx, "/docker.swarmkit.v1.Dispatcher/UpdateTaskStatus", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dispatcherClient) Tasks(ctx context.Context, in *TasksRequest, opts ...grpc.CallOption) (Dispatcher_TasksClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Dispatcher_serviceDesc.Streams[1], c.cc, "/docker.swarmkit.v1.Dispatcher/Tasks", opts...)
	if err != nil {
		return nil, err
	}
	x := &dispatcherTasksClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type Dispatcher_TasksClient interface {
	Recv() (*TasksMessage, error)
	grpc.ClientStream
}

type dispatcherTasksClient struct {
	grpc.ClientStream
}

func (x *dispatcherTasksClient) Recv() (*TasksMessage, error) {
	m := new(TasksMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for Dispatcher service

type DispatcherServer interface {
	// Session starts an agent session with the dispatcher. The session is
	// started after the first SessionMessage is received.
	//
	// Once started, the agent is controlled with a stream of SessionMessage.
	// Agents should list on the stream at all times for instructions.
	Session(*SessionRequest, Dispatcher_SessionServer) error
	// Heartbeat is heartbeat method for nodes. It returns new TTL in response.
	// Node should send new heartbeat earlier than now + TTL, otherwise it will
	// be deregistered from dispatcher and its status will be updated to NodeStatus_DOWN
	Heartbeat(context.Context, *HeartbeatRequest) (*HeartbeatResponse, error)
	// UpdateTaskStatus updates status of task. Node should send such updates
	// on every status change of its tasks.
	//
	// Whether receiving batch updates or single status updates, this method
	// should be accepting. Errors should only be returned if the entire update
	// should be retried, due to data loss or other problems.
	//
	// If a task is unknown the dispatcher, the status update should be
	// accepted regardless.
	UpdateTaskStatus(context.Context, *UpdateTaskStatusRequest) (*UpdateTaskStatusResponse, error)
	// Tasks is a stream of tasks state for node. Each message contains full list
	// of tasks which should be run on node, if task is not present in that list,
	// it should be terminated.
	Tasks(*TasksRequest, Dispatcher_TasksServer) error
}

func RegisterDispatcherServer(s *grpc.Server, srv DispatcherServer) {
	s.RegisterService(&_Dispatcher_serviceDesc, srv)
}

func _Dispatcher_Session_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SessionRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DispatcherServer).Session(m, &dispatcherSessionServer{stream})
}

type Dispatcher_SessionServer interface {
	Send(*SessionMessage) error
	grpc.ServerStream
}

type dispatcherSessionServer struct {
	grpc.ServerStream
}

func (x *dispatcherSessionServer) Send(m *SessionMessage) error {
	return x.ServerStream.SendMsg(m)
}

func _Dispatcher_Heartbeat_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(HeartbeatRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DispatcherServer).Heartbeat(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.Dispatcher/Heartbeat",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DispatcherServer).Heartbeat(ctx, req.(*HeartbeatRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dispatcher_UpdateTaskStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTaskStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DispatcherServer).UpdateTaskStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.Dispatcher/UpdateTaskStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DispatcherServer).UpdateTaskStatus(ctx, req.(*UpdateTaskStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Dispatcher_Tasks_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(TasksRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(DispatcherServer).Tasks(m, &dispatcherTasksServer{stream})
}

type Dispatcher_TasksServer interface {
	Send(*TasksMessage) error
	grpc.ServerStream
}

type dispatcherTasksServer struct {
	grpc.ServerStream
}

func (x *dispatcherTasksServer) Send(m *TasksMessage) error {
	return x.ServerStream.SendMsg(m)
}

var _Dispatcher_serviceDesc = grpc.ServiceDesc{
	ServiceName: "docker.swarmkit.v1.Dispatcher",
	HandlerType: (*DispatcherServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Heartbeat",
			Handler:    _Dispatcher_Heartbeat_Handler,
		},
		{
			MethodName: "UpdateTaskStatus",
			Handler:    _Dispatcher_UpdateTaskStatus_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Session",
			Handler:       _Dispatcher_Session_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "Tasks",
			Handler:       _Dispatcher_Tasks_Handler,
			ServerStreams: true,
		},
	},
}

func (m *SessionRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *SessionRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Description != nil {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(m.Description.Size()))
		n1, err := m.Description.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	return i, nil
}

func (m *SessionMessage) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *SessionMessage) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SessionID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(len(m.SessionID)))
		i += copy(data[i:], m.SessionID)
	}
	if m.Node != nil {
		data[i] = 0x12
		i++
		i = encodeVarintDispatcher(data, i, uint64(m.Node.Size()))
		n2, err := m.Node.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if len(m.Managers) > 0 {
		for _, msg := range m.Managers {
			data[i] = 0x1a
			i++
			i = encodeVarintDispatcher(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.NetworkBootstrapKeys) > 0 {
		for _, msg := range m.NetworkBootstrapKeys {
			data[i] = 0x22
			i++
			i = encodeVarintDispatcher(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *HeartbeatRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *HeartbeatRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SessionID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(len(m.SessionID)))
		i += copy(data[i:], m.SessionID)
	}
	return i, nil
}

func (m *HeartbeatResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *HeartbeatResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	data[i] = 0xa
	i++
	i = encodeVarintDispatcher(data, i, uint64(m.Period.Size()))
	n3, err := m.Period.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	return i, nil
}

func (m *UpdateTaskStatusRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *UpdateTaskStatusRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SessionID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(len(m.SessionID)))
		i += copy(data[i:], m.SessionID)
	}
	if len(m.Updates) > 0 {
		for _, msg := range m.Updates {
			data[i] = 0x1a
			i++
			i = encodeVarintDispatcher(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.TaskID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(len(m.TaskID)))
		i += copy(data[i:], m.TaskID)
	}
	if m.Status != nil {
		data[i] = 0x12
		i++
		i = encodeVarintDispatcher(data, i, uint64(m.Status.Size()))
		n4, err := m.Status.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	return i, nil
}

func (m *UpdateTaskStatusResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *UpdateTaskStatusResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *TasksRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *TasksRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.SessionID) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintDispatcher(data, i, uint64(len(m.SessionID)))
		i += copy(data[i:], m.SessionID)
	}
	return i, nil
}

func (m *TasksMessage) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *TasksMessage) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Tasks) > 0 {
		for _, msg := range m.Tasks {
			data[i] = 0xa
			i++
			i = encodeVarintDispatcher(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func encodeFixed64Dispatcher(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Dispatcher(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintDispatcher(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}

type raftProxyDispatcherServer struct {
	local        DispatcherServer
	connSelector raftpicker.Interface
	cluster      raftpicker.RaftCluster
	ctxMods      []func(context.Context) (context.Context, error)
}

func NewRaftProxyDispatcherServer(local DispatcherServer, connSelector raftpicker.Interface, cluster raftpicker.RaftCluster, ctxMod func(context.Context) (context.Context, error)) DispatcherServer {
	redirectChecker := func(ctx context.Context) (context.Context, error) {
		s, ok := transport.StreamFromContext(ctx)
		if !ok {
			return ctx, grpc.Errorf(codes.InvalidArgument, "remote addr is not found in context")
		}
		addr := s.ServerTransport().RemoteAddr().String()
		md, ok := metadata.FromContext(ctx)
		if ok && len(md["redirect"]) != 0 {
			return ctx, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
		}
		if !ok {
			md = metadata.New(map[string]string{})
		}
		md["redirect"] = append(md["redirect"], addr)
		return metadata.NewContext(ctx, md), nil
	}
	mods := []func(context.Context) (context.Context, error){redirectChecker}
	mods = append(mods, ctxMod)

	return &raftProxyDispatcherServer{
		local:        local,
		cluster:      cluster,
		connSelector: connSelector,
		ctxMods:      mods,
	}
}
func (p *raftProxyDispatcherServer) runCtxMods(ctx context.Context) (context.Context, error) {
	var err error
	for _, mod := range p.ctxMods {
		ctx, err = mod(ctx)
		if err != nil {
			return ctx, err
		}
	}
	return ctx, nil
}

func (p *raftProxyDispatcherServer) Session(r *SessionRequest, stream Dispatcher_SessionServer) error {

	if p.cluster.IsLeader() {
		return p.local.Session(r, stream)
	}
	ctx, err := p.runCtxMods(stream.Context())
	if err != nil {
		return err
	}
	conn, err := p.connSelector.Conn()
	if err != nil {
		return err
	}

	defer func() {
		if err != nil {
			errStr := err.Error()
			if strings.Contains(errStr, grpc.ErrClientConnClosing.Error()) ||
				strings.Contains(errStr, grpc.ErrClientConnTimeout.Error()) ||
				strings.Contains(errStr, "connection error") ||
				grpc.Code(err) == codes.Internal {
				p.connSelector.Reset()
			}
		}
	}()

	clientStream, err := NewDispatcherClient(conn).Session(ctx, r)

	if err != nil {
		return err
	}

	for {
		msg, err := clientStream.Recv()
		if err == io.EOF {
			break
		}
		if err != nil {
			return err
		}
		if err := stream.Send(msg); err != nil {
			return err
		}
	}
	return nil
}

func (p *raftProxyDispatcherServer) Heartbeat(ctx context.Context, r *HeartbeatRequest) (*HeartbeatResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.Heartbeat(ctx, r)
	}
	ctx, err := p.runCtxMods(ctx)
	if err != nil {
		return nil, err
	}
	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}

	defer func() {
		if err != nil {
			errStr := err.Error()
			if strings.Contains(errStr, grpc.ErrClientConnClosing.Error()) ||
				strings.Contains(errStr, grpc.ErrClientConnTimeout.Error()) ||
				strings.Contains(errStr, "connection error") ||
				grpc.Code(err) == codes.Internal {
				p.connSelector.Reset()
			}
		}
	}()

	return NewDispatcherClient(conn).Heartbeat(ctx, r)
}

func (p *raftProxyDispatcherServer) UpdateTaskStatus(ctx context.Context, r *UpdateTaskStatusRequest) (*UpdateTaskStatusResponse, error) {

	if p.cluster.IsLeader() {
		return p.local.UpdateTaskStatus(ctx, r)
	}
	ctx, err := p.runCtxMods(ctx)
	if err != nil {
		return nil, err
	}
	conn, err := p.connSelector.Conn()
	if err != nil {
		return nil, err
	}

	defer func() {
		if err != nil {
			errStr := err.Error()
			if strings.Contains(errStr, grpc.ErrClientConnClosing.Error()) ||
				strings.Contains(errStr, grpc.ErrClientConnTimeout.Error()) ||
				strings.Contains(errStr, "connection error") ||
				grpc.Code(err) == codes.Internal {
				p.connSelector.Reset()
			}
		}
	}()

	return NewDispatcherClient(conn).UpdateTaskStatus(ctx, r)
}

func (p *raftProxyDispatcherServer) Tasks(r *TasksRequest, stream Dispatcher_TasksServer) error {

	if p.cluster.IsLeader() {
		return p.local.Tasks(r, stream)
	}
	ctx, err := p.runCtxMods(stream.Context())
	if err != nil {
		return err
	}
	conn, err := p.connSelector.Conn()
	if err != nil {
		return err
	}

	defer func() {
		if err != nil {
			errStr := err.Error()
			if strings.Contains(errStr, grpc.ErrClientConnClosing.Error()) ||
				strings.Contains(errStr, grpc.ErrClientConnTimeout.Error()) ||
				strings.Contains(errStr, "connection error") ||
				grpc.Code(err) == codes.Internal {
				p.connSelector.Reset()
			}
		}
	}()

	clientStream, err := NewDispatcherClient(conn).Tasks(ctx, r)

	if err != nil {
		return err
	}

	for {
		msg, err := clientStream.Recv()
		if err == io.EOF {
			break
		}
		if err != nil {
			return err
		}
		if err := stream.Send(msg); err != nil {
			return err
		}
	}
	return nil
}

func (m *SessionRequest) Size() (n int) {
	var l int
	_ = l
	if m.Description != nil {
		l = m.Description.Size()
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}

func (m *SessionMessage) Size() (n int) {
	var l int
	_ = l
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	if m.Node != nil {
		l = m.Node.Size()
		n += 1 + l + sovDispatcher(uint64(l))
	}
	if len(m.Managers) > 0 {
		for _, e := range m.Managers {
			l = e.Size()
			n += 1 + l + sovDispatcher(uint64(l))
		}
	}
	if len(m.NetworkBootstrapKeys) > 0 {
		for _, e := range m.NetworkBootstrapKeys {
			l = e.Size()
			n += 1 + l + sovDispatcher(uint64(l))
		}
	}
	return n
}

func (m *HeartbeatRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}

func (m *HeartbeatResponse) Size() (n int) {
	var l int
	_ = l
	l = m.Period.Size()
	n += 1 + l + sovDispatcher(uint64(l))
	return n
}

func (m *UpdateTaskStatusRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	if len(m.Updates) > 0 {
		for _, e := range m.Updates {
			l = e.Size()
			n += 1 + l + sovDispatcher(uint64(l))
		}
	}
	return n
}

func (m *UpdateTaskStatusRequest_TaskStatusUpdate) Size() (n int) {
	var l int
	_ = l
	l = len(m.TaskID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	if m.Status != nil {
		l = m.Status.Size()
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}

func (m *UpdateTaskStatusResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *TasksRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.SessionID)
	if l > 0 {
		n += 1 + l + sovDispatcher(uint64(l))
	}
	return n
}

func (m *TasksMessage) Size() (n int) {
	var l int
	_ = l
	if len(m.Tasks) > 0 {
		for _, e := range m.Tasks {
			l = e.Size()
			n += 1 + l + sovDispatcher(uint64(l))
		}
	}
	return n
}

func sovDispatcher(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozDispatcher(x uint64) (n int) {
	return sovDispatcher(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *SessionRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SessionRequest{`,
		`Description:` + strings.Replace(fmt.Sprintf("%v", this.Description), "NodeDescription", "NodeDescription", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *SessionMessage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&SessionMessage{`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`Node:` + strings.Replace(fmt.Sprintf("%v", this.Node), "Node", "Node", 1) + `,`,
		`Managers:` + strings.Replace(fmt.Sprintf("%v", this.Managers), "WeightedPeer", "WeightedPeer", 1) + `,`,
		`NetworkBootstrapKeys:` + strings.Replace(fmt.Sprintf("%v", this.NetworkBootstrapKeys), "EncryptionKey", "EncryptionKey", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HeartbeatRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HeartbeatRequest{`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *HeartbeatResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&HeartbeatResponse{`,
		`Period:` + strings.Replace(strings.Replace(this.Period.String(), "Duration", "docker_swarmkit_v11.Duration", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateTaskStatusRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateTaskStatusRequest{`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`Updates:` + strings.Replace(fmt.Sprintf("%v", this.Updates), "UpdateTaskStatusRequest_TaskStatusUpdate", "UpdateTaskStatusRequest_TaskStatusUpdate", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateTaskStatusRequest_TaskStatusUpdate) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateTaskStatusRequest_TaskStatusUpdate{`,
		`TaskID:` + fmt.Sprintf("%v", this.TaskID) + `,`,
		`Status:` + strings.Replace(fmt.Sprintf("%v", this.Status), "TaskStatus", "TaskStatus", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *UpdateTaskStatusResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&UpdateTaskStatusResponse{`,
		`}`,
	}, "")
	return s
}
func (this *TasksRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TasksRequest{`,
		`SessionID:` + fmt.Sprintf("%v", this.SessionID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *TasksMessage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&TasksMessage{`,
		`Tasks:` + strings.Replace(fmt.Sprintf("%v", this.Tasks), "Task", "Task", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringDispatcher(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *SessionRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SessionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SessionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Description", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Description == nil {
				m.Description = &NodeDescription{}
			}
			if err := m.Description.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SessionMessage) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SessionMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SessionMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Node", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Node == nil {
				m.Node = &Node{}
			}
			if err := m.Node.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Managers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Managers = append(m.Managers, &WeightedPeer{})
			if err := m.Managers[len(m.Managers)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NetworkBootstrapKeys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NetworkBootstrapKeys = append(m.NetworkBootstrapKeys, &EncryptionKey{})
			if err := m.NetworkBootstrapKeys[len(m.NetworkBootstrapKeys)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeartbeatRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeartbeatRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeartbeatRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeartbeatResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeartbeatResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeartbeatResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Period", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Period.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateTaskStatusRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateTaskStatusRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateTaskStatusRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Updates", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Updates = append(m.Updates, &UpdateTaskStatusRequest_TaskStatusUpdate{})
			if err := m.Updates[len(m.Updates)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateTaskStatusRequest_TaskStatusUpdate) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TaskStatusUpdate: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TaskStatusUpdate: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TaskID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Status == nil {
				m.Status = &TaskStatus{}
			}
			if err := m.Status.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UpdateTaskStatusResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UpdateTaskStatusResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UpdateTaskStatusResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TasksRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TasksRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TasksRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SessionID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SessionID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TasksMessage) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TasksMessage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TasksMessage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tasks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthDispatcher
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tasks = append(m.Tasks, &Task{})
			if err := m.Tasks[len(m.Tasks)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipDispatcher(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthDispatcher
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipDispatcher(data []byte) (n int, err error) {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowDispatcher
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if data[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowDispatcher
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthDispatcher
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowDispatcher
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipDispatcher(data[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthDispatcher = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowDispatcher   = fmt.Errorf("proto: integer overflow")
)

var fileDescriptorDispatcher = []byte{
	// 626 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x9c, 0x54, 0xdf, 0x6e, 0x12, 0x4f,
	0x14, 0xee, 0x02, 0x85, 0x1f, 0x87, 0xf2, 0x0b, 0x8e, 0x8d, 0xdd, 0x6c, 0x2a, 0xc5, 0x45, 0x13,
	0x13, 0xeb, 0xa2, 0x35, 0xf1, 0xc2, 0x10, 0x63, 0x08, 0x4d, 0x6c, 0x8c, 0x7f, 0xb2, 0x55, 0xb9,
	0x24, 0x0b, 0x3b, 0xa1, 0x2b, 0x76, 0x67, 0x9d, 0x19, 0xac, 0x5c, 0x98, 0x98, 0x78, 0x6f, 0x8c,
	0x57, 0x3e, 0x85, 0xcf, 0x41, 0xbc, 0xf2, 0xd2, 0xab, 0xc6, 0xf6, 0x01, 0x8c, 0x8f, 0xe0, 0xec,
	0xec, 0x2c, 0x20, 0x5d, 0xb4, 0xf4, 0x62, 0xc2, 0xcc, 0x99, 0xef, 0xfb, 0xce, 0xc7, 0x39, 0x67,
	0x16, 0x4a, 0xae, 0xc7, 0x02, 0x87, 0x77, 0xf7, 0x30, 0xb5, 0x02, 0x4a, 0x38, 0x41, 0xc8, 0x25,
	0xdd, 0xbe, 0x38, 0xb1, 0x03, 0x87, 0xee, 0xf7, 0x3d, 0x6e, 0xbd, 0xbe, 0x69, 0x14, 0xf8, 0x30,
	0xc0, 0x2c, 0x02, 0x18, 0x45, 0xd2, 0x79, 0x81, 0xbb, 0x3c, 0x3e, 0xae, 0xf6, 0x48, 0x8f, 0xc8,
	0x6d, 0x2d, 0xdc, 0xa9, 0xe8, 0xf9, 0xe0, 0xe5, 0xa0, 0xe7, 0xf9, 0xb5, 0xe8, 0x47, 0x05, 0xd7,
	0xdc, 0x01, 0x75, 0xb8, 0x47, 0xfc, 0x5a, 0xbc, 0x89, 0x2e, 0xcc, 0x16, 0xfc, 0xbf, 0x8b, 0x19,
	0x13, 0x01, 0x1b, 0xbf, 0x1a, 0x60, 0xc6, 0xd1, 0x36, 0x14, 0x5c, 0xcc, 0xba, 0xd4, 0x0b, 0x42,
	0x98, 0xae, 0x55, 0xb4, 0xab, 0x85, 0xad, 0xaa, 0x75, 0xd2, 0x9b, 0xf5, 0x88, 0xb8, 0xb8, 0x39,
	0x81, 0xda, 0xd3, 0x3c, 0xf3, 0x7d, 0x6a, 0xac, 0xfc, 0x50, 0xfc, 0x38, 0x3d, 0x8c, 0x36, 0x01,
	0x58, 0x14, 0x69, 0x7b, 0xae, 0x14, 0xce, 0x37, 0x8a, 0xc7, 0x87, 0x1b, 0x79, 0x85, 0xdb, 0x69,
	0xda, 0x79, 0x05, 0xd8, 0x71, 0x05, 0x3a, 0xe3, 0x8b, 0x04, 0x7a, 0x4a, 0x1a, 0xd0, 0xe7, 0x19,
	0xb0, 0x25, 0x0a, 0xd5, 0xe1, 0xbf, 0x7d, 0xc7, 0x17, 0x59, 0x28, 0xd3, 0xd3, 0x95, 0xb4, 0x60,
	0x54, 0x92, 0x18, 0x2d, 0xec, 0xf5, 0xf6, 0x38, 0x76, 0x9f, 0x60, 0x4c, 0xed, 0x31, 0x03, 0xb5,
	0xe0, 0x82, 0x8f, 0xf9, 0x01, 0xa1, 0xfd, 0x76, 0x87, 0x10, 0xce, 0x38, 0x75, 0x82, 0x76, 0x1f,
	0x0f, 0x99, 0x9e, 0x91, 0x5a, 0x97, 0x92, 0xb4, 0xb6, 0xfd, 0x2e, 0x1d, 0xca, 0x3f, 0xfb, 0x00,
	0x0f, 0xed, 0x55, 0x25, 0xd0, 0x88, 0xf9, 0x22, 0xc8, 0xcc, 0x7b, 0x50, 0xba, 0x8f, 0x1d, 0xca,
	0x3b, 0xd8, 0xe1, 0x71, 0x81, 0x17, 0x2a, 0x83, 0xf9, 0x18, 0xce, 0x4d, 0x29, 0xb0, 0x80, 0xf8,
	0x0c, 0xa3, 0x3b, 0x90, 0x0d, 0x30, 0xf5, 0x88, 0xab, 0xda, 0xb3, 0x9e, 0xe4, 0xaf, 0xa9, 0x3a,
	0xdd, 0xc8, 0x8c, 0x0e, 0x37, 0x96, 0x6c, 0xc5, 0x30, 0x3f, 0xa6, 0x60, 0xed, 0x59, 0xe0, 0x3a,
	0x1c, 0x3f, 0x75, 0x58, 0x7f, 0x97, 0x3b, 0x7c, 0xc0, 0xce, 0x64, 0x0d, 0x3d, 0x87, 0xdc, 0x40,
	0x0a, 0xc5, 0x25, 0xaf, 0x27, 0xd9, 0x98, 0x93, 0xcb, 0x9a, 0x44, 0x22, 0x84, 0x1d, 0x8b, 0x19,
	0x04, 0x4a, 0xb3, 0x97, 0xa8, 0x0a, 0x39, 0x2e, 0x62, 0x13, 0x5b, 0x20, 0x6c, 0x65, 0x43, 0x98,
	0xf0, 0x94, 0x0d, 0xaf, 0x84, 0xa1, 0xdb, 0x90, 0x65, 0x92, 0xa4, 0x86, 0xa6, 0x9c, 0xe4, 0x67,
	0xca, 0x89, 0x42, 0x9b, 0x06, 0xe8, 0x27, 0x5d, 0x46, 0xa5, 0x36, 0xeb, 0xb0, 0x12, 0x46, 0xcf,
	0x56, 0x22, 0xf3, 0xae, 0x62, 0xc7, 0x4f, 0xc0, 0x82, 0xe5, 0xd0, 0x2b, 0x13, 0xc4, 0xf4, 0xbc,
	0xa9, 0x0e, 0x09, 0x76, 0x04, 0xdb, 0xfa, 0x90, 0x01, 0x68, 0x8e, 0xbf, 0x13, 0xe8, 0x0d, 0xe4,
	0x54, 0x1a, 0x64, 0x26, 0x51, 0xff, 0x7c, 0xca, 0xc6, 0xdf, 0x30, 0xca, 0x91, 0x59, 0xfd, 0xfa,
	0xe5, 0xe7, 0xe7, 0xd4, 0x45, 0x58, 0x91, 0x98, 0xeb, 0xe1, 0x08, 0x63, 0x0a, 0xc5, 0xe8, 0xa4,
	0x1e, 0xc8, 0x0d, 0x0d, 0xbd, 0x85, 0xfc, 0x78, 0x0c, 0xd1, 0xe5, 0x24, 0xdd, 0xd9, 0x39, 0x37,
	0xae, 0xfc, 0x03, 0xa5, 0x0a, 0x7c, 0x1a, 0x03, 0xe8, 0x93, 0x06, 0xa5, 0xd9, 0x16, 0xa1, 0x6b,
	0x0b, 0x8c, 0x9b, 0xb1, 0x79, 0x3a, 0xf0, 0x22, 0xa6, 0x28, 0x2c, 0xcb, 0xe6, 0xa2, 0xca, 0xbc,
	0x36, 0x8e, 0xb3, 0xcf, 0x47, 0x2c, 0xd6, 0x87, 0xc6, 0xfa, 0xe8, 0xa8, 0xbc, 0xf4, 0x5d, 0xac,
	0x5f, 0x47, 0x65, 0xed, 0xdd, 0x71, 0x59, 0x1b, 0x89, 0xf5, 0x4d, 0xac, 0x1f, 0x62, 0x75, 0xb2,
	0xf2, 0xa3, 0x7e, 0xeb, 0x77, 0x00, 0x00, 0x00, 0xff, 0xff, 0x3f, 0x41, 0x8f, 0x02, 0x5c, 0x06,
	0x00, 0x00,
}
