<!--[metadata]>
+++
title = "Understand how to contribute"
description = "Explains basic workflow for Docker contributions"
keywords = ["contribute, maintainers, review, workflow,  process"]
[menu.main]
parent = "smn_contribute"
+++
<![end-metadata]-->

# Understand how to contribute

Contributing is a process where you work with Docker maintainers and the
community to improve Docker. The maintainers are experienced contributors
who specialize in one or more Docker components. Maintainers play a big role
in reviewing contributions.

There is a formal process for contributing. We try to keep our contribution
process simple so you'll want to contribute frequently.


## The basic contribution workflow

In this guide, you work through Docker's basic contribution workflow by fixing a
single *beginner* issue in the `docker/docker` repository. The workflow
for fixing simple issues looks like this:

![Simple process](/project/images/existing_issue.png)

All Docker repositories have code and documentation. You use this same workflow
for either content type. For example, you can find and fix doc or code issues.
Also, you can propose a new Docker feature or propose a new Docker tutorial. 

Some workflow stages do have slight differences for code or documentation
contributions. When you reach that point in the flow, we make sure to tell you.


## Where to go next

Now that you know a little about the contribution process, go to the next section
to [find an issue you want to work on](/project/find-an-issue/).
