<!--[metadata]>
+++
title = "The Docker user guide"
description = "The Docker user guide home page"
keywords = ["docker, introduction, documentation, about, technology, docker.io, user, guide, user's, manual, platform, framework, virtualization, home,  intro"]
[menu.main]
parent = "mn_fun_docker"
+++
<![end-metadata]-->

# Welcome to the Docker user guide

In the [Introduction](../misc) you got a taste of what Docker is and how it
works. This guide takes you through the fundamentals of using Docker and
integrating it into your environment. You'll learn how to use Docker to:

* Dockerize your applications.
* Run your own containers.
* Build Docker images.
* Share your Docker images with others.
* And a whole lot more!

This guide is broken into major sections that take you through the Docker life
cycle:

## Getting started with Docker Hub

*How do I use Docker Hub?*

Docker Hub is the central hub for Docker. It hosts public Docker images
and provides services to help you build and manage your Docker
environment. To learn more:

Go to [Using Docker Hub](https://docs.docker.com/docker-hub).

## Dockerizing applications: A "Hello world"

*How do I run applications inside containers?*

Docker offers a *container-based* virtualization platform to power your
applications. To learn how to Dockerize applications and run them:

Go to [Dockerizing Applications](dockerizing.md).


## Working with containers

*How do I manage my containers?*

Once you get a grip on running your applications in Docker containers
we're going to show you how to manage those containers. To find out
about how to inspect, monitor and manage containers:

Go to [Working With Containers](usingdocker.md).

## Working with Docker images

*How can I access, share and build my own images?*

Once you've learnt how to use Docker it's time to take the next step and
learn how to build your own application images with Docker.

Go to [Working with Docker Images](dockerimages.md).

## Networking containers

Until now we've seen how to build individual applications inside Docker
containers. Now learn how to build whole application stacks with Docker
networking.

Go to [Networking Containers](networkingcontainers.md).

## Managing data in containers

Now we know how to link Docker containers together the next step is
learning how to manage data, volumes and mounts inside our containers.

Go to [Managing Data in Containers](dockervolumes.md).

## Working with Docker Hub

Now we've learned a bit more about how to use Docker we're going to see
how to combine Docker with the services available on Docker Hub including
Trusted Builds and private repositories.

Go to [Working with Docker Hub](dockerrepos.md).

## Docker Compose

Docker Compose allows you to define a application's components -- their containers,
configuration, links and volumes -- in a single file. Then a single command
will set everything up and start your application running.

Go to [Docker Compose user guide](https://docs.docker.com/compose/).

## Docker Machine

Docker Machine helps you get Docker Engines up and running quickly. Machine
can set up hosts for Docker Engines on your computer, on cloud providers,
and/or in your data center, and then configure your Docker client to securely
talk to them.

Go to [Docker Machine user guide](https://docs.docker.com/machine/).

## Docker Swarm

Docker Swarm pools several Docker Engines together and exposes them as a single
virtual Docker Engine. It serves the standard Docker API, so any tool that already
works with Docker can now transparently scale up to multiple hosts.

Go to [Docker Swarm user guide](https://docs.docker.com/swarm/).

## Getting help

* [Docker homepage](https://www.docker.com/)
* [Docker Hub](https://hub.docker.com)
* [Docker blog](https://blog.docker.com/)
* [Docker documentation](https://docs.docker.com/)
* [Docker Getting Started Guide](https://docs.docker.com/mac/started/)
* [Docker code on GitHub](https://github.com/docker/docker)
* [Docker mailing
  list](https://groups.google.com/forum/#!forum/docker-user)
* Docker on IRC: irc.freenode.net and channel #docker
* [Docker on Twitter](https://twitter.com/docker)
* Get [Docker help](https://stackoverflow.com/search?q=docker) on
  StackOverflow
* [Docker.com](https://www.docker.com/)
