.TH FORWARD-JOURNALD 8 2016-03-03 REDHAT "System Manager's Manual"
.SH NAME
forward-journald \- forward stdin to journald
.SH SYNOPSIS
.B forward-journald
[\fIOPTION\fR]...
.SH DESCRIPTION
Forward lines received from stdin to journald
.SH OPTIONS
.TP
.B -1
Use the priority of informational when writing to journald (default)
.TP
.B -2
Use the priority of error when writing to journald
.TP
.BI -tag= TAG
Add field
.B OBJECT_EXE
to journald entry using
.B TAG
.SH "EXIT STATUS"
.TP
0
No errors occurred
.TP
1
Unable to connect to journald.
.SH NOTES
Workaround for
.BR SIGPIPE
issue with < go 1.6rc2, where writing 10 times to stdout or stderr will cause the
.BR SIGPIPE
events to be
converted to a non-trappable
.BR SIGPIPE
killing any process written in
.BR go(1).
.SH BUGS
Docker command crashes after journald is stopped (https://bugzilla.redhat.com/show_bug.cgi?id=1300076)
.SH "EXAMPLE"
Update docker.service to guard
.BR docker(1)
from the
.BR SIGPIPE
issue:
.SS "docker.service"
.nf
:
[Service]
Type=notify
NotifyAccess=all
ExecStart=/bin/sh -c '/usr/bin/docker daemon \\
          $OPTIONS \\
          $DOCKER_STORAGE_OPTIONS \\
          $DOCKER_NETWORK_OPTIONS \\
          $INSECURE_REGISTRY \\
          2>&1 | /usr/bin/forward-journald -tag docker'
StandardOutput=null
StandardError=null
:
.fi
.SH "SEE ALSO"
.BR go(1),
.BR docker(1),
.BR systemd(1),
.BR journald(1)
.BR systemd-journald(8),

