// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/api/serviceconfig/logging.proto
// DO NOT EDIT!

package google_api // import "google.golang.org/genproto/googleapis/api/serviceconfig"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Logging configuration of the service.
//
// The following example shows how to configure logs to be sent to the
// producer and consumer projects. In the example,
// the `library.googleapis.com/activity_history` log is
// sent to both the producer and consumer projects, whereas
// the `library.googleapis.com/purchase_history` log is only sent to the
// producer project:
//
//     monitored_resources:
//     - type: library.googleapis.com/branch
//       labels:
//       - key: /city
//         description: The city where the library branch is located in.
//       - key: /name
//         description: The name of the branch.
//     logs:
//     - name: library.googleapis.com/activity_history
//       labels:
//       - key: /customer_id
//     - name: library.googleapis.com/purchase_history
//     logging:
//       producer_destinations:
//       - monitored_resource: library.googleapis.com/branch
//         logs:
//         - library.googleapis.com/activity_history
//         - library.googleapis.com/purchase_history
//       consumer_destinations:
//       - monitored_resource: library.googleapis.com/branch
//         logs:
//         - library.googleapis.com/activity_history
type Logging struct {
	// Logging configurations for sending logs to the producer project.
	// There can be multiple producer destinations, each one must have a
	// different monitored resource type. A log can be used in at most
	// one producer destination.
	ProducerDestinations []*Logging_LoggingDestination `protobuf:"bytes,1,rep,name=producer_destinations,json=producerDestinations" json:"producer_destinations,omitempty"`
	// Logging configurations for sending logs to the consumer project.
	// There can be multiple consumer destinations, each one must have a
	// different monitored resource type. A log can be used in at most
	// one consumer destination.
	ConsumerDestinations []*Logging_LoggingDestination `protobuf:"bytes,2,rep,name=consumer_destinations,json=consumerDestinations" json:"consumer_destinations,omitempty"`
}

func (m *Logging) Reset()                    { *m = Logging{} }
func (m *Logging) String() string            { return proto.CompactTextString(m) }
func (*Logging) ProtoMessage()               {}
func (*Logging) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{0} }

func (m *Logging) GetProducerDestinations() []*Logging_LoggingDestination {
	if m != nil {
		return m.ProducerDestinations
	}
	return nil
}

func (m *Logging) GetConsumerDestinations() []*Logging_LoggingDestination {
	if m != nil {
		return m.ConsumerDestinations
	}
	return nil
}

// Configuration of a specific logging destination (the producer project
// or the consumer project).
type Logging_LoggingDestination struct {
	// The monitored resource type. The type must be defined in
	// [Service.monitored_resources][google.api.Service.monitored_resources] section.
	MonitoredResource string `protobuf:"bytes,3,opt,name=monitored_resource,json=monitoredResource" json:"monitored_resource,omitempty"`
	// Names of the logs to be sent to this destination. Each name must
	// be defined in the [Service.logs][google.api.Service.logs] section.
	Logs []string `protobuf:"bytes,1,rep,name=logs" json:"logs,omitempty"`
}

func (m *Logging_LoggingDestination) Reset()                    { *m = Logging_LoggingDestination{} }
func (m *Logging_LoggingDestination) String() string            { return proto.CompactTextString(m) }
func (*Logging_LoggingDestination) ProtoMessage()               {}
func (*Logging_LoggingDestination) Descriptor() ([]byte, []int) { return fileDescriptor11, []int{0, 0} }

func init() {
	proto.RegisterType((*Logging)(nil), "google.api.Logging")
	proto.RegisterType((*Logging_LoggingDestination)(nil), "google.api.Logging.LoggingDestination")
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/api/serviceconfig/logging.proto", fileDescriptor11)
}

var fileDescriptor11 = []byte{
	// 264 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x9c, 0x90, 0xc1, 0x4a, 0xc4, 0x30,
	0x10, 0x86, 0x69, 0x77, 0x51, 0x36, 0x8a, 0x60, 0x50, 0x58, 0xf6, 0xb4, 0x78, 0xd0, 0xbd, 0xd8,
	0x80, 0x3e, 0x81, 0x8b, 0x22, 0x0b, 0x1e, 0x4a, 0x2f, 0x1e, 0x3c, 0x2c, 0x35, 0x1d, 0x87, 0x40,
	0x9b, 0x59, 0x92, 0xd4, 0xa7, 0xf1, 0xe4, 0x93, 0x9a, 0x6d, 0x52, 0x5b, 0xf4, 0xa4, 0x97, 0x24,
	0xcc, 0xfc, 0xf3, 0xcd, 0x9f, 0x9f, 0x3d, 0x20, 0x11, 0xd6, 0x90, 0x21, 0xd5, 0xa5, 0xc6, 0x8c,
	0x0c, 0x0a, 0x04, 0xbd, 0x33, 0xe4, 0x48, 0x84, 0x56, 0xb9, 0x53, 0x56, 0xf8, 0x43, 0x58, 0x30,
	0xef, 0x4a, 0x82, 0x24, 0xfd, 0xa6, 0x50, 0xd4, 0x84, 0xa8, 0xfc, 0x44, 0x27, 0xe5, 0x2c, 0x62,
	0xbc, 0x6e, 0xb1, 0xf9, 0x2f, 0xb2, 0xd4, 0x9a, 0x5c, 0xe9, 0x14, 0x69, 0x1b, 0xb0, 0x17, 0x1f,
	0x29, 0x3b, 0x7c, 0x0a, 0x8b, 0xf8, 0x0b, 0x3b, 0xf7, 0xc5, 0xaa, 0x95, 0x60, 0xb6, 0x15, 0x58,
	0xa7, 0x74, 0x90, 0xce, 0x93, 0xe5, 0x64, 0x75, 0x74, 0x73, 0x99, 0x0d, 0x16, 0xb2, 0x38, 0xd3,
	0xdf, 0xf7, 0x83, 0xbc, 0x38, 0xeb, 0x21, 0xa3, 0xa2, 0xdd, 0xc3, 0xbd, 0x09, 0xdb, 0x36, 0x3f,
	0xe1, 0xe9, 0xdf, 0xe0, 0x3d, 0x64, 0x0c, 0x5f, 0x3c, 0x33, 0xfe, 0x5b, 0xcb, 0xaf, 0x19, 0x6f,
	0x48, 0x2b, 0x47, 0x06, 0xaa, 0xad, 0x01, 0x4b, 0xad, 0x91, 0x30, 0x9f, 0x2c, 0x93, 0xd5, 0xac,
	0x38, 0xfd, 0xee, 0x14, 0xb1, 0xc1, 0x39, 0x9b, 0xfa, 0xc8, 0xc3, 0x6f, 0x67, 0x45, 0xf7, 0x5e,
	0x5f, 0xb1, 0x13, 0x49, 0xcd, 0xc8, 0xdb, 0xfa, 0x38, 0x2e, 0xca, 0xf7, 0xf1, 0xe5, 0xc9, 0x67,
	0x3a, 0x7d, 0xbc, 0xcb, 0x37, 0xaf, 0x07, 0x5d, 0x9c, 0xb7, 0x5f, 0x01, 0x00, 0x00, 0xff, 0xff,
	0x48, 0x22, 0x03, 0x10, 0xee, 0x01, 0x00, 0x00,
}
