// Code generated by protoc-gen-go.
// source: google.golang.org/genproto/googleapis/logging/type/log_severity.proto
// DO NOT EDIT!

package google_logging_type // import "google.golang.org/genproto/googleapis/logging/type"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/serviceconfig"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// The severity of the event described in a log entry, expressed as one of the
// standard severity levels listed below.  For your reference, the levels are
// assigned the listed numeric values. The effect of using numeric values other
// than those listed is undefined.
//
// You can filter for log entries by severity.  For example, the following
// filter expression will match log entries with severities `INFO`, `NOTICE`,
// and `WARNING`:
//
//     severity > DEBUG AND severity <= WARNING
//
// If you are writing log entries, you should map other severity encodings to
// one of these standard levels. For example, you might map all of Java's FINE,
// FINER, and FINEST levels to `LogSeverity.DEBUG`. You can preserve the
// original severity level in the log entry payload if you wish.
type LogSeverity int32

const (
	// (0) The log entry has no assigned severity level.
	LogSeverity_DEFAULT LogSeverity = 0
	// (100) Debug or trace information.
	LogSeverity_DEBUG LogSeverity = 100
	// (200) Routine information, such as ongoing status or performance.
	LogSeverity_INFO LogSeverity = 200
	// (300) Normal but significant events, such as start up, shut down, or
	// a configuration change.
	LogSeverity_NOTICE LogSeverity = 300
	// (400) Warning events might cause problems.
	LogSeverity_WARNING LogSeverity = 400
	// (500) Error events are likely to cause problems.
	LogSeverity_ERROR LogSeverity = 500
	// (600) Critical events cause more severe problems or outages.
	LogSeverity_CRITICAL LogSeverity = 600
	// (700) A person must take an action immediately.
	LogSeverity_ALERT LogSeverity = 700
	// (800) One or more systems are unusable.
	LogSeverity_EMERGENCY LogSeverity = 800
)

var LogSeverity_name = map[int32]string{
	0:   "DEFAULT",
	100: "DEBUG",
	200: "INFO",
	300: "NOTICE",
	400: "WARNING",
	500: "ERROR",
	600: "CRITICAL",
	700: "ALERT",
	800: "EMERGENCY",
}
var LogSeverity_value = map[string]int32{
	"DEFAULT":   0,
	"DEBUG":     100,
	"INFO":      200,
	"NOTICE":    300,
	"WARNING":   400,
	"ERROR":     500,
	"CRITICAL":  600,
	"ALERT":     700,
	"EMERGENCY": 800,
}

func (x LogSeverity) String() string {
	return proto.EnumName(LogSeverity_name, int32(x))
}
func (LogSeverity) EnumDescriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func init() {
	proto.RegisterEnum("google.logging.type.LogSeverity", LogSeverity_name, LogSeverity_value)
}

func init() {
	proto.RegisterFile("google.golang.org/genproto/googleapis/logging/type/log_severity.proto", fileDescriptor1)
}

var fileDescriptor1 = []byte{
	// 278 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xe2, 0x72, 0x4d, 0xcf, 0xcf, 0x4f,
	0xcf, 0x49, 0xd5, 0x4b, 0xcf, 0xcf, 0x49, 0xcc, 0x4b, 0xd7, 0xcb, 0x2f, 0x4a, 0xd7, 0x4f, 0x4f,
	0xcd, 0x2b, 0x28, 0xca, 0x2f, 0xc9, 0xd7, 0x87, 0x48, 0x25, 0x16, 0x64, 0x16, 0xeb, 0xe7, 0xe4,
	0xa7, 0xa7, 0x67, 0xe6, 0xa5, 0xeb, 0x97, 0x54, 0x16, 0xa4, 0x82, 0x38, 0xf1, 0xc5, 0xa9, 0x65,
	0xa9, 0x45, 0x99, 0x25, 0x95, 0x7a, 0x60, 0xa5, 0x42, 0xc2, 0x50, 0x63, 0xa0, 0xea, 0xf4, 0x40,
	0xea, 0xa4, 0x3c, 0x89, 0x33, 0x1b, 0x48, 0xe8, 0x17, 0xa7, 0x16, 0x95, 0x65, 0x26, 0xa7, 0x26,
	0xe7, 0xe7, 0xa5, 0x65, 0xa6, 0xeb, 0x27, 0xe6, 0xe5, 0xe5, 0x97, 0x24, 0x96, 0x64, 0xe6, 0xe7,
	0x15, 0x43, 0xcc, 0xd7, 0x6a, 0x62, 0xe4, 0xe2, 0xf6, 0xc9, 0x4f, 0x0f, 0x86, 0xda, 0x2a, 0xc4,
	0xcd, 0xc5, 0xee, 0xe2, 0xea, 0xe6, 0x18, 0xea, 0x13, 0x22, 0xc0, 0x20, 0xc4, 0xc9, 0xc5, 0xea,
	0xe2, 0xea, 0x14, 0xea, 0x2e, 0x90, 0x02, 0x64, 0xb2, 0x78, 0xfa, 0xb9, 0xf9, 0x0b, 0x9c, 0x60,
	0x04, 0x2a, 0x61, 0xf3, 0xf3, 0x0f, 0xf1, 0x74, 0x76, 0x15, 0x58, 0xc3, 0x24, 0xc4, 0xc3, 0xc5,
	0x1e, 0xee, 0x18, 0xe4, 0xe7, 0xe9, 0xe7, 0x2e, 0x30, 0x81, 0x59, 0x88, 0x8b, 0x8b, 0xd5, 0x35,
	0x28, 0xc8, 0x3f, 0x48, 0xe0, 0x0b, 0xb3, 0x10, 0x2f, 0x17, 0x87, 0x73, 0x90, 0x27, 0x50, 0x9d,
	0xa3, 0x8f, 0xc0, 0x0d, 0x16, 0x90, 0x94, 0xa3, 0x8f, 0x6b, 0x50, 0x88, 0xc0, 0x1e, 0x56, 0x21,
	0x3e, 0x2e, 0x4e, 0x57, 0x5f, 0xd7, 0x20, 0x77, 0x57, 0x3f, 0xe7, 0x48, 0x81, 0x05, 0x6c, 0x4e,
	0xba, 0x5c, 0xe2, 0xc9, 0xf9, 0xb9, 0x7a, 0x58, 0xbc, 0xea, 0x24, 0x80, 0xe4, 0xb8, 0x00, 0x90,
	0x8b, 0x03, 0x18, 0x93, 0xd8, 0xc0, 0x4e, 0x37, 0x06, 0x04, 0x00, 0x00, 0xff, 0xff, 0x01, 0xa8,
	0xad, 0x71, 0x63, 0x01, 0x00, 0x00,
}
