// Code generated by protoc-gen-gogo.
// source: raft.proto
// DO NOT EDIT!

package api

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import raftpb "github.com/coreos/etcd/raft/raftpb"

// skipping weak import gogoproto "github.com/gogo/protobuf/gogoproto"
// skipping weak import docker_protobuf_plugin "github.com/docker/swarmkit/protobuf/plugin"

import strings "strings"
import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"
import sort "sort"
import strconv "strconv"
import reflect "reflect"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

import raftselector "github.com/docker/swarmkit/manager/raftselector"
import codes "google.golang.org/grpc/codes"
import metadata "google.golang.org/grpc/metadata"
import transport "google.golang.org/grpc/transport"
import time "time"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// StoreActionKind defines the operation to take on the store for the target of
// a storage action.
type StoreActionKind int32

const (
	StoreActionKindUnknown StoreActionKind = 0
	StoreActionKindCreate  StoreActionKind = 1
	StoreActionKindUpdate  StoreActionKind = 2
	StoreActionKindRemove  StoreActionKind = 3
)

var StoreActionKind_name = map[int32]string{
	0: "UNKNOWN",
	1: "STORE_ACTION_CREATE",
	2: "STORE_ACTION_UPDATE",
	3: "STORE_ACTION_REMOVE",
}
var StoreActionKind_value = map[string]int32{
	"UNKNOWN":             0,
	"STORE_ACTION_CREATE": 1,
	"STORE_ACTION_UPDATE": 2,
	"STORE_ACTION_REMOVE": 3,
}

func (x StoreActionKind) String() string {
	return proto.EnumName(StoreActionKind_name, int32(x))
}
func (StoreActionKind) EnumDescriptor() ([]byte, []int) { return fileDescriptorRaft, []int{0} }

type RaftMember struct {
	// RaftID specifies the internal ID used by the manager in a raft context, it can never be modified
	// and is used only for information purposes
	RaftID uint64 `protobuf:"varint,1,opt,name=raft_id,json=raftId,proto3" json:"raft_id,omitempty"`
	// NodeID is the node's ID.
	NodeID string `protobuf:"bytes,2,opt,name=node_id,json=nodeId,proto3" json:"node_id,omitempty"`
	// Addr specifies the address of the member
	Addr string `protobuf:"bytes,3,opt,name=addr,proto3" json:"addr,omitempty"`
	// Status provides the current status of the manager from the perspective of another manager.
	Status RaftMemberStatus `protobuf:"bytes,4,opt,name=status" json:"status"`
}

func (m *RaftMember) Reset()                    { *m = RaftMember{} }
func (*RaftMember) ProtoMessage()               {}
func (*RaftMember) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{0} }

type JoinRequest struct {
	// Addr specifies the address of the member
	Addr string `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
}

func (m *JoinRequest) Reset()                    { *m = JoinRequest{} }
func (*JoinRequest) ProtoMessage()               {}
func (*JoinRequest) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{1} }

type JoinResponse struct {
	// RaftID is the ID assigned to the new member.
	RaftID uint64 `protobuf:"varint,1,opt,name=raft_id,json=raftId,proto3" json:"raft_id,omitempty"`
	// Members is the membership set of the cluster.
	Members []*RaftMember `protobuf:"bytes,2,rep,name=members" json:"members,omitempty"`
	// RemovedMembers is a list of members that have been removed from
	// the cluster, so the new node can avoid communicating with them.
	RemovedMembers []uint64 `protobuf:"varint,3,rep,name=removed_members,json=removedMembers" json:"removed_members,omitempty"`
}

func (m *JoinResponse) Reset()                    { *m = JoinResponse{} }
func (*JoinResponse) ProtoMessage()               {}
func (*JoinResponse) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{2} }

type LeaveRequest struct {
	Node *RaftMember `protobuf:"bytes,1,opt,name=node" json:"node,omitempty"`
}

func (m *LeaveRequest) Reset()                    { *m = LeaveRequest{} }
func (*LeaveRequest) ProtoMessage()               {}
func (*LeaveRequest) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{3} }

type LeaveResponse struct {
}

func (m *LeaveResponse) Reset()                    { *m = LeaveResponse{} }
func (*LeaveResponse) ProtoMessage()               {}
func (*LeaveResponse) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{4} }

type ProcessRaftMessageRequest struct {
	Message *raftpb.Message `protobuf:"bytes,1,opt,name=message" json:"message,omitempty"`
}

func (m *ProcessRaftMessageRequest) Reset()                    { *m = ProcessRaftMessageRequest{} }
func (*ProcessRaftMessageRequest) ProtoMessage()               {}
func (*ProcessRaftMessageRequest) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{5} }

type ProcessRaftMessageResponse struct {
}

func (m *ProcessRaftMessageResponse) Reset()                    { *m = ProcessRaftMessageResponse{} }
func (*ProcessRaftMessageResponse) ProtoMessage()               {}
func (*ProcessRaftMessageResponse) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{6} }

type ResolveAddressRequest struct {
	// raft_id is the ID to resolve to an address.
	RaftID uint64 `protobuf:"varint,1,opt,name=raft_id,json=raftId,proto3" json:"raft_id,omitempty"`
}

func (m *ResolveAddressRequest) Reset()                    { *m = ResolveAddressRequest{} }
func (*ResolveAddressRequest) ProtoMessage()               {}
func (*ResolveAddressRequest) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{7} }

type ResolveAddressResponse struct {
	// Addr specifies the address of the member
	Addr string `protobuf:"bytes,1,opt,name=addr,proto3" json:"addr,omitempty"`
}

func (m *ResolveAddressResponse) Reset()                    { *m = ResolveAddressResponse{} }
func (*ResolveAddressResponse) ProtoMessage()               {}
func (*ResolveAddressResponse) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{8} }

// Contains one of many protobuf encoded objects to replicate
// over the raft backend with a request ID to track when the
// action is effectively applied
type InternalRaftRequest struct {
	ID     uint64         `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	Action []*StoreAction `protobuf:"bytes,2,rep,name=action" json:"action,omitempty"`
}

func (m *InternalRaftRequest) Reset()                    { *m = InternalRaftRequest{} }
func (*InternalRaftRequest) ProtoMessage()               {}
func (*InternalRaftRequest) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{9} }

// StoreAction defines a target and operation to apply on the storage system.
type StoreAction struct {
	Action StoreActionKind `protobuf:"varint,1,opt,name=action,proto3,enum=docker.swarmkit.v1.StoreActionKind" json:"action,omitempty"`
	// Types that are valid to be assigned to Target:
	//	*StoreAction_Node
	//	*StoreAction_Service
	//	*StoreAction_Task
	//	*StoreAction_Network
	//	*StoreAction_Cluster
	//	*StoreAction_Secret
	Target isStoreAction_Target `protobuf_oneof:"target"`
}

func (m *StoreAction) Reset()                    { *m = StoreAction{} }
func (*StoreAction) ProtoMessage()               {}
func (*StoreAction) Descriptor() ([]byte, []int) { return fileDescriptorRaft, []int{10} }

type isStoreAction_Target interface {
	isStoreAction_Target()
	MarshalTo([]byte) (int, error)
	Size() int
}

type StoreAction_Node struct {
	Node *Node `protobuf:"bytes,2,opt,name=node,oneof"`
}
type StoreAction_Service struct {
	Service *Service `protobuf:"bytes,3,opt,name=service,oneof"`
}
type StoreAction_Task struct {
	Task *Task `protobuf:"bytes,4,opt,name=task,oneof"`
}
type StoreAction_Network struct {
	Network *Network `protobuf:"bytes,5,opt,name=network,oneof"`
}
type StoreAction_Cluster struct {
	Cluster *Cluster `protobuf:"bytes,6,opt,name=cluster,oneof"`
}
type StoreAction_Secret struct {
	Secret *Secret `protobuf:"bytes,7,opt,name=secret,oneof"`
}

func (*StoreAction_Node) isStoreAction_Target()    {}
func (*StoreAction_Service) isStoreAction_Target() {}
func (*StoreAction_Task) isStoreAction_Target()    {}
func (*StoreAction_Network) isStoreAction_Target() {}
func (*StoreAction_Cluster) isStoreAction_Target() {}
func (*StoreAction_Secret) isStoreAction_Target()  {}

func (m *StoreAction) GetTarget() isStoreAction_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *StoreAction) GetNode() *Node {
	if x, ok := m.GetTarget().(*StoreAction_Node); ok {
		return x.Node
	}
	return nil
}

func (m *StoreAction) GetService() *Service {
	if x, ok := m.GetTarget().(*StoreAction_Service); ok {
		return x.Service
	}
	return nil
}

func (m *StoreAction) GetTask() *Task {
	if x, ok := m.GetTarget().(*StoreAction_Task); ok {
		return x.Task
	}
	return nil
}

func (m *StoreAction) GetNetwork() *Network {
	if x, ok := m.GetTarget().(*StoreAction_Network); ok {
		return x.Network
	}
	return nil
}

func (m *StoreAction) GetCluster() *Cluster {
	if x, ok := m.GetTarget().(*StoreAction_Cluster); ok {
		return x.Cluster
	}
	return nil
}

func (m *StoreAction) GetSecret() *Secret {
	if x, ok := m.GetTarget().(*StoreAction_Secret); ok {
		return x.Secret
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StoreAction) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StoreAction_OneofMarshaler, _StoreAction_OneofUnmarshaler, _StoreAction_OneofSizer, []interface{}{
		(*StoreAction_Node)(nil),
		(*StoreAction_Service)(nil),
		(*StoreAction_Task)(nil),
		(*StoreAction_Network)(nil),
		(*StoreAction_Cluster)(nil),
		(*StoreAction_Secret)(nil),
	}
}

func _StoreAction_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StoreAction)
	// target
	switch x := m.Target.(type) {
	case *StoreAction_Node:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Node); err != nil {
			return err
		}
	case *StoreAction_Service:
		_ = b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Service); err != nil {
			return err
		}
	case *StoreAction_Task:
		_ = b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Task); err != nil {
			return err
		}
	case *StoreAction_Network:
		_ = b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Network); err != nil {
			return err
		}
	case *StoreAction_Cluster:
		_ = b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Cluster); err != nil {
			return err
		}
	case *StoreAction_Secret:
		_ = b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Secret); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("StoreAction.Target has unexpected type %T", x)
	}
	return nil
}

func _StoreAction_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StoreAction)
	switch tag {
	case 2: // target.node
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Node)
		err := b.DecodeMessage(msg)
		m.Target = &StoreAction_Node{msg}
		return true, err
	case 3: // target.service
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Service)
		err := b.DecodeMessage(msg)
		m.Target = &StoreAction_Service{msg}
		return true, err
	case 4: // target.task
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Task)
		err := b.DecodeMessage(msg)
		m.Target = &StoreAction_Task{msg}
		return true, err
	case 5: // target.network
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Network)
		err := b.DecodeMessage(msg)
		m.Target = &StoreAction_Network{msg}
		return true, err
	case 6: // target.cluster
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Cluster)
		err := b.DecodeMessage(msg)
		m.Target = &StoreAction_Cluster{msg}
		return true, err
	case 7: // target.secret
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Secret)
		err := b.DecodeMessage(msg)
		m.Target = &StoreAction_Secret{msg}
		return true, err
	default:
		return false, nil
	}
}

func _StoreAction_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StoreAction)
	// target
	switch x := m.Target.(type) {
	case *StoreAction_Node:
		s := proto.Size(x.Node)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StoreAction_Service:
		s := proto.Size(x.Service)
		n += proto.SizeVarint(3<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StoreAction_Task:
		s := proto.Size(x.Task)
		n += proto.SizeVarint(4<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StoreAction_Network:
		s := proto.Size(x.Network)
		n += proto.SizeVarint(5<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StoreAction_Cluster:
		s := proto.Size(x.Cluster)
		n += proto.SizeVarint(6<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StoreAction_Secret:
		s := proto.Size(x.Secret)
		n += proto.SizeVarint(7<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*RaftMember)(nil), "docker.swarmkit.v1.RaftMember")
	proto.RegisterType((*JoinRequest)(nil), "docker.swarmkit.v1.JoinRequest")
	proto.RegisterType((*JoinResponse)(nil), "docker.swarmkit.v1.JoinResponse")
	proto.RegisterType((*LeaveRequest)(nil), "docker.swarmkit.v1.LeaveRequest")
	proto.RegisterType((*LeaveResponse)(nil), "docker.swarmkit.v1.LeaveResponse")
	proto.RegisterType((*ProcessRaftMessageRequest)(nil), "docker.swarmkit.v1.ProcessRaftMessageRequest")
	proto.RegisterType((*ProcessRaftMessageResponse)(nil), "docker.swarmkit.v1.ProcessRaftMessageResponse")
	proto.RegisterType((*ResolveAddressRequest)(nil), "docker.swarmkit.v1.ResolveAddressRequest")
	proto.RegisterType((*ResolveAddressResponse)(nil), "docker.swarmkit.v1.ResolveAddressResponse")
	proto.RegisterType((*InternalRaftRequest)(nil), "docker.swarmkit.v1.InternalRaftRequest")
	proto.RegisterType((*StoreAction)(nil), "docker.swarmkit.v1.StoreAction")
	proto.RegisterEnum("docker.swarmkit.v1.StoreActionKind", StoreActionKind_name, StoreActionKind_value)
}

type authenticatedWrapperRaftServer struct {
	local     RaftServer
	authorize func(context.Context, []string) error
}

func NewAuthenticatedWrapperRaftServer(local RaftServer, authorize func(context.Context, []string) error) RaftServer {
	return &authenticatedWrapperRaftServer{
		local:     local,
		authorize: authorize,
	}
}

func (p *authenticatedWrapperRaftServer) ProcessRaftMessage(ctx context.Context, r *ProcessRaftMessageRequest) (*ProcessRaftMessageResponse, error) {

	if err := p.authorize(ctx, []string{"swarm-manager"}); err != nil {
		return nil, err
	}
	return p.local.ProcessRaftMessage(ctx, r)
}

func (p *authenticatedWrapperRaftServer) ResolveAddress(ctx context.Context, r *ResolveAddressRequest) (*ResolveAddressResponse, error) {

	if err := p.authorize(ctx, []string{"swarm-manager"}); err != nil {
		return nil, err
	}
	return p.local.ResolveAddress(ctx, r)
}

type authenticatedWrapperRaftMembershipServer struct {
	local     RaftMembershipServer
	authorize func(context.Context, []string) error
}

func NewAuthenticatedWrapperRaftMembershipServer(local RaftMembershipServer, authorize func(context.Context, []string) error) RaftMembershipServer {
	return &authenticatedWrapperRaftMembershipServer{
		local:     local,
		authorize: authorize,
	}
}

func (p *authenticatedWrapperRaftMembershipServer) Join(ctx context.Context, r *JoinRequest) (*JoinResponse, error) {

	if err := p.authorize(ctx, []string{"swarm-manager"}); err != nil {
		return nil, err
	}
	return p.local.Join(ctx, r)
}

func (p *authenticatedWrapperRaftMembershipServer) Leave(ctx context.Context, r *LeaveRequest) (*LeaveResponse, error) {

	if err := p.authorize(ctx, []string{"swarm-manager"}); err != nil {
		return nil, err
	}
	return p.local.Leave(ctx, r)
}

func (m *RaftMember) Copy() *RaftMember {
	if m == nil {
		return nil
	}

	o := &RaftMember{
		RaftID: m.RaftID,
		NodeID: m.NodeID,
		Addr:   m.Addr,
		Status: *m.Status.Copy(),
	}

	return o
}

func (m *JoinRequest) Copy() *JoinRequest {
	if m == nil {
		return nil
	}

	o := &JoinRequest{
		Addr: m.Addr,
	}

	return o
}

func (m *JoinResponse) Copy() *JoinResponse {
	if m == nil {
		return nil
	}

	o := &JoinResponse{
		RaftID: m.RaftID,
	}

	if m.Members != nil {
		o.Members = make([]*RaftMember, 0, len(m.Members))
		for _, v := range m.Members {
			o.Members = append(o.Members, v.Copy())
		}
	}

	if m.RemovedMembers != nil {
		o.RemovedMembers = make([]uint64, 0, len(m.RemovedMembers))
		o.RemovedMembers = append(o.RemovedMembers, m.RemovedMembers...)
	}

	return o
}

func (m *LeaveRequest) Copy() *LeaveRequest {
	if m == nil {
		return nil
	}

	o := &LeaveRequest{
		Node: m.Node.Copy(),
	}

	return o
}

func (m *LeaveResponse) Copy() *LeaveResponse {
	if m == nil {
		return nil
	}

	o := &LeaveResponse{}

	return o
}

func (m *ProcessRaftMessageResponse) Copy() *ProcessRaftMessageResponse {
	if m == nil {
		return nil
	}

	o := &ProcessRaftMessageResponse{}

	return o
}

func (m *ResolveAddressRequest) Copy() *ResolveAddressRequest {
	if m == nil {
		return nil
	}

	o := &ResolveAddressRequest{
		RaftID: m.RaftID,
	}

	return o
}

func (m *ResolveAddressResponse) Copy() *ResolveAddressResponse {
	if m == nil {
		return nil
	}

	o := &ResolveAddressResponse{
		Addr: m.Addr,
	}

	return o
}

func (m *InternalRaftRequest) Copy() *InternalRaftRequest {
	if m == nil {
		return nil
	}

	o := &InternalRaftRequest{
		ID: m.ID,
	}

	if m.Action != nil {
		o.Action = make([]*StoreAction, 0, len(m.Action))
		for _, v := range m.Action {
			o.Action = append(o.Action, v.Copy())
		}
	}

	return o
}

func (m *StoreAction) Copy() *StoreAction {
	if m == nil {
		return nil
	}

	o := &StoreAction{
		Action: m.Action,
	}

	switch m.Target.(type) {
	case *StoreAction_Node:
		i := &StoreAction_Node{
			Node: m.GetNode().Copy(),
		}

		o.Target = i
	case *StoreAction_Service:
		i := &StoreAction_Service{
			Service: m.GetService().Copy(),
		}

		o.Target = i
	case *StoreAction_Task:
		i := &StoreAction_Task{
			Task: m.GetTask().Copy(),
		}

		o.Target = i
	case *StoreAction_Network:
		i := &StoreAction_Network{
			Network: m.GetNetwork().Copy(),
		}

		o.Target = i
	case *StoreAction_Cluster:
		i := &StoreAction_Cluster{
			Cluster: m.GetCluster().Copy(),
		}

		o.Target = i
	case *StoreAction_Secret:
		i := &StoreAction_Secret{
			Secret: m.GetSecret().Copy(),
		}

		o.Target = i
	}

	return o
}

func (this *RaftMember) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&api.RaftMember{")
	s = append(s, "RaftID: "+fmt.Sprintf("%#v", this.RaftID)+",\n")
	s = append(s, "NodeID: "+fmt.Sprintf("%#v", this.NodeID)+",\n")
	s = append(s, "Addr: "+fmt.Sprintf("%#v", this.Addr)+",\n")
	s = append(s, "Status: "+strings.Replace(this.Status.GoString(), `&`, ``, 1)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *JoinRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.JoinRequest{")
	s = append(s, "Addr: "+fmt.Sprintf("%#v", this.Addr)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *JoinResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&api.JoinResponse{")
	s = append(s, "RaftID: "+fmt.Sprintf("%#v", this.RaftID)+",\n")
	if this.Members != nil {
		s = append(s, "Members: "+fmt.Sprintf("%#v", this.Members)+",\n")
	}
	s = append(s, "RemovedMembers: "+fmt.Sprintf("%#v", this.RemovedMembers)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LeaveRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.LeaveRequest{")
	if this.Node != nil {
		s = append(s, "Node: "+fmt.Sprintf("%#v", this.Node)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *LeaveResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&api.LeaveResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ProcessRaftMessageRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.ProcessRaftMessageRequest{")
	if this.Message != nil {
		s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ProcessRaftMessageResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&api.ProcessRaftMessageResponse{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResolveAddressRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.ResolveAddressRequest{")
	s = append(s, "RaftID: "+fmt.Sprintf("%#v", this.RaftID)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ResolveAddressResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&api.ResolveAddressResponse{")
	s = append(s, "Addr: "+fmt.Sprintf("%#v", this.Addr)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *InternalRaftRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&api.InternalRaftRequest{")
	s = append(s, "ID: "+fmt.Sprintf("%#v", this.ID)+",\n")
	if this.Action != nil {
		s = append(s, "Action: "+fmt.Sprintf("%#v", this.Action)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *StoreAction) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 11)
	s = append(s, "&api.StoreAction{")
	s = append(s, "Action: "+fmt.Sprintf("%#v", this.Action)+",\n")
	if this.Target != nil {
		s = append(s, "Target: "+fmt.Sprintf("%#v", this.Target)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *StoreAction_Node) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.StoreAction_Node{` +
		`Node:` + fmt.Sprintf("%#v", this.Node) + `}`}, ", ")
	return s
}
func (this *StoreAction_Service) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.StoreAction_Service{` +
		`Service:` + fmt.Sprintf("%#v", this.Service) + `}`}, ", ")
	return s
}
func (this *StoreAction_Task) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.StoreAction_Task{` +
		`Task:` + fmt.Sprintf("%#v", this.Task) + `}`}, ", ")
	return s
}
func (this *StoreAction_Network) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.StoreAction_Network{` +
		`Network:` + fmt.Sprintf("%#v", this.Network) + `}`}, ", ")
	return s
}
func (this *StoreAction_Cluster) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.StoreAction_Cluster{` +
		`Cluster:` + fmt.Sprintf("%#v", this.Cluster) + `}`}, ", ")
	return s
}
func (this *StoreAction_Secret) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&api.StoreAction_Secret{` +
		`Secret:` + fmt.Sprintf("%#v", this.Secret) + `}`}, ", ")
	return s
}
func valueToGoStringRaft(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func extensionToGoStringRaft(m github_com_gogo_protobuf_proto.Message) string {
	e := github_com_gogo_protobuf_proto.GetUnsafeExtensionsMap(m)
	if e == nil {
		return "nil"
	}
	s := "proto.NewUnsafeXXX_InternalExtensions(map[int32]proto.Extension{"
	keys := make([]int, 0, len(e))
	for k := range e {
		keys = append(keys, int(k))
	}
	sort.Ints(keys)
	ss := []string{}
	for _, k := range keys {
		ss = append(ss, strconv.Itoa(k)+": "+e[int32(k)].GoString())
	}
	s += strings.Join(ss, ",") + "})"
	return s
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion3

// Client API for Raft service

type RaftClient interface {
	// ProcessRaftMessage sends a raft message to be processed on a raft member, it is
	// called from the RaftMember willing to send a message to its destination ('To' field)
	ProcessRaftMessage(ctx context.Context, in *ProcessRaftMessageRequest, opts ...grpc.CallOption) (*ProcessRaftMessageResponse, error)
	// ResolveAddress returns the address where the node with the given ID can be reached.
	ResolveAddress(ctx context.Context, in *ResolveAddressRequest, opts ...grpc.CallOption) (*ResolveAddressResponse, error)
}

type raftClient struct {
	cc *grpc.ClientConn
}

func NewRaftClient(cc *grpc.ClientConn) RaftClient {
	return &raftClient{cc}
}

func (c *raftClient) ProcessRaftMessage(ctx context.Context, in *ProcessRaftMessageRequest, opts ...grpc.CallOption) (*ProcessRaftMessageResponse, error) {
	out := new(ProcessRaftMessageResponse)
	err := grpc.Invoke(ctx, "/docker.swarmkit.v1.Raft/ProcessRaftMessage", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *raftClient) ResolveAddress(ctx context.Context, in *ResolveAddressRequest, opts ...grpc.CallOption) (*ResolveAddressResponse, error) {
	out := new(ResolveAddressResponse)
	err := grpc.Invoke(ctx, "/docker.swarmkit.v1.Raft/ResolveAddress", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Raft service

type RaftServer interface {
	// ProcessRaftMessage sends a raft message to be processed on a raft member, it is
	// called from the RaftMember willing to send a message to its destination ('To' field)
	ProcessRaftMessage(context.Context, *ProcessRaftMessageRequest) (*ProcessRaftMessageResponse, error)
	// ResolveAddress returns the address where the node with the given ID can be reached.
	ResolveAddress(context.Context, *ResolveAddressRequest) (*ResolveAddressResponse, error)
}

func RegisterRaftServer(s *grpc.Server, srv RaftServer) {
	s.RegisterService(&_Raft_serviceDesc, srv)
}

func _Raft_ProcessRaftMessage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ProcessRaftMessageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RaftServer).ProcessRaftMessage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.Raft/ProcessRaftMessage",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RaftServer).ProcessRaftMessage(ctx, req.(*ProcessRaftMessageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Raft_ResolveAddress_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResolveAddressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RaftServer).ResolveAddress(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.Raft/ResolveAddress",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RaftServer).ResolveAddress(ctx, req.(*ResolveAddressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Raft_serviceDesc = grpc.ServiceDesc{
	ServiceName: "docker.swarmkit.v1.Raft",
	HandlerType: (*RaftServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ProcessRaftMessage",
			Handler:    _Raft_ProcessRaftMessage_Handler,
		},
		{
			MethodName: "ResolveAddress",
			Handler:    _Raft_ResolveAddress_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: fileDescriptorRaft,
}

// Client API for RaftMembership service

type RaftMembershipClient interface {
	// Join adds a RaftMember to the raft cluster.
	Join(ctx context.Context, in *JoinRequest, opts ...grpc.CallOption) (*JoinResponse, error)
	// Leave removes a RaftMember from the raft cluster.
	Leave(ctx context.Context, in *LeaveRequest, opts ...grpc.CallOption) (*LeaveResponse, error)
}

type raftMembershipClient struct {
	cc *grpc.ClientConn
}

func NewRaftMembershipClient(cc *grpc.ClientConn) RaftMembershipClient {
	return &raftMembershipClient{cc}
}

func (c *raftMembershipClient) Join(ctx context.Context, in *JoinRequest, opts ...grpc.CallOption) (*JoinResponse, error) {
	out := new(JoinResponse)
	err := grpc.Invoke(ctx, "/docker.swarmkit.v1.RaftMembership/Join", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *raftMembershipClient) Leave(ctx context.Context, in *LeaveRequest, opts ...grpc.CallOption) (*LeaveResponse, error) {
	out := new(LeaveResponse)
	err := grpc.Invoke(ctx, "/docker.swarmkit.v1.RaftMembership/Leave", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for RaftMembership service

type RaftMembershipServer interface {
	// Join adds a RaftMember to the raft cluster.
	Join(context.Context, *JoinRequest) (*JoinResponse, error)
	// Leave removes a RaftMember from the raft cluster.
	Leave(context.Context, *LeaveRequest) (*LeaveResponse, error)
}

func RegisterRaftMembershipServer(s *grpc.Server, srv RaftMembershipServer) {
	s.RegisterService(&_RaftMembership_serviceDesc, srv)
}

func _RaftMembership_Join_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(JoinRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RaftMembershipServer).Join(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.RaftMembership/Join",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RaftMembershipServer).Join(ctx, req.(*JoinRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _RaftMembership_Leave_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LeaveRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(RaftMembershipServer).Leave(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/docker.swarmkit.v1.RaftMembership/Leave",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(RaftMembershipServer).Leave(ctx, req.(*LeaveRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _RaftMembership_serviceDesc = grpc.ServiceDesc{
	ServiceName: "docker.swarmkit.v1.RaftMembership",
	HandlerType: (*RaftMembershipServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Join",
			Handler:    _RaftMembership_Join_Handler,
		},
		{
			MethodName: "Leave",
			Handler:    _RaftMembership_Leave_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: fileDescriptorRaft,
}

func (m *RaftMember) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *RaftMember) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RaftID != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintRaft(data, i, uint64(m.RaftID))
	}
	if len(m.NodeID) > 0 {
		data[i] = 0x12
		i++
		i = encodeVarintRaft(data, i, uint64(len(m.NodeID)))
		i += copy(data[i:], m.NodeID)
	}
	if len(m.Addr) > 0 {
		data[i] = 0x1a
		i++
		i = encodeVarintRaft(data, i, uint64(len(m.Addr)))
		i += copy(data[i:], m.Addr)
	}
	data[i] = 0x22
	i++
	i = encodeVarintRaft(data, i, uint64(m.Status.Size()))
	n1, err := m.Status.MarshalTo(data[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	return i, nil
}

func (m *JoinRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *JoinRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Addr) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintRaft(data, i, uint64(len(m.Addr)))
		i += copy(data[i:], m.Addr)
	}
	return i, nil
}

func (m *JoinResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *JoinResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RaftID != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintRaft(data, i, uint64(m.RaftID))
	}
	if len(m.Members) > 0 {
		for _, msg := range m.Members {
			data[i] = 0x12
			i++
			i = encodeVarintRaft(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.RemovedMembers) > 0 {
		for _, num := range m.RemovedMembers {
			data[i] = 0x18
			i++
			i = encodeVarintRaft(data, i, uint64(num))
		}
	}
	return i, nil
}

func (m *LeaveRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *LeaveRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Node != nil {
		data[i] = 0xa
		i++
		i = encodeVarintRaft(data, i, uint64(m.Node.Size()))
		n2, err := m.Node.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	return i, nil
}

func (m *LeaveResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *LeaveResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ProcessRaftMessageRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ProcessRaftMessageRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Message != nil {
		data[i] = 0xa
		i++
		i = encodeVarintRaft(data, i, uint64(m.Message.Size()))
		n3, err := m.Message.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	return i, nil
}

func (m *ProcessRaftMessageResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ProcessRaftMessageResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ResolveAddressRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ResolveAddressRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RaftID != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintRaft(data, i, uint64(m.RaftID))
	}
	return i, nil
}

func (m *ResolveAddressResponse) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *ResolveAddressResponse) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Addr) > 0 {
		data[i] = 0xa
		i++
		i = encodeVarintRaft(data, i, uint64(len(m.Addr)))
		i += copy(data[i:], m.Addr)
	}
	return i, nil
}

func (m *InternalRaftRequest) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *InternalRaftRequest) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ID != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintRaft(data, i, uint64(m.ID))
	}
	if len(m.Action) > 0 {
		for _, msg := range m.Action {
			data[i] = 0x12
			i++
			i = encodeVarintRaft(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *StoreAction) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *StoreAction) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Action != 0 {
		data[i] = 0x8
		i++
		i = encodeVarintRaft(data, i, uint64(m.Action))
	}
	if m.Target != nil {
		nn4, err := m.Target.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += nn4
	}
	return i, nil
}

func (m *StoreAction_Node) MarshalTo(data []byte) (int, error) {
	i := 0
	if m.Node != nil {
		data[i] = 0x12
		i++
		i = encodeVarintRaft(data, i, uint64(m.Node.Size()))
		n5, err := m.Node.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}
func (m *StoreAction_Service) MarshalTo(data []byte) (int, error) {
	i := 0
	if m.Service != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintRaft(data, i, uint64(m.Service.Size()))
		n6, err := m.Service.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}
func (m *StoreAction_Task) MarshalTo(data []byte) (int, error) {
	i := 0
	if m.Task != nil {
		data[i] = 0x22
		i++
		i = encodeVarintRaft(data, i, uint64(m.Task.Size()))
		n7, err := m.Task.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}
func (m *StoreAction_Network) MarshalTo(data []byte) (int, error) {
	i := 0
	if m.Network != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintRaft(data, i, uint64(m.Network.Size()))
		n8, err := m.Network.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	return i, nil
}
func (m *StoreAction_Cluster) MarshalTo(data []byte) (int, error) {
	i := 0
	if m.Cluster != nil {
		data[i] = 0x32
		i++
		i = encodeVarintRaft(data, i, uint64(m.Cluster.Size()))
		n9, err := m.Cluster.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}
func (m *StoreAction_Secret) MarshalTo(data []byte) (int, error) {
	i := 0
	if m.Secret != nil {
		data[i] = 0x3a
		i++
		i = encodeVarintRaft(data, i, uint64(m.Secret.Size()))
		n10, err := m.Secret.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	return i, nil
}
func encodeFixed64Raft(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Raft(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintRaft(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}

type raftProxyRaftServer struct {
	local        RaftServer
	connSelector raftselector.ConnProvider
	ctxMods      []func(context.Context) (context.Context, error)
}

func NewRaftProxyRaftServer(local RaftServer, connSelector raftselector.ConnProvider, ctxMod func(context.Context) (context.Context, error)) RaftServer {
	redirectChecker := func(ctx context.Context) (context.Context, error) {
		s, ok := transport.StreamFromContext(ctx)
		if !ok {
			return ctx, grpc.Errorf(codes.InvalidArgument, "remote addr is not found in context")
		}
		addr := s.ServerTransport().RemoteAddr().String()
		md, ok := metadata.FromContext(ctx)
		if ok && len(md["redirect"]) != 0 {
			return ctx, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
		}
		if !ok {
			md = metadata.New(map[string]string{})
		}
		md["redirect"] = append(md["redirect"], addr)
		return metadata.NewContext(ctx, md), nil
	}
	mods := []func(context.Context) (context.Context, error){redirectChecker}
	mods = append(mods, ctxMod)

	return &raftProxyRaftServer{
		local:        local,
		connSelector: connSelector,
		ctxMods:      mods,
	}
}
func (p *raftProxyRaftServer) runCtxMods(ctx context.Context) (context.Context, error) {
	var err error
	for _, mod := range p.ctxMods {
		ctx, err = mod(ctx)
		if err != nil {
			return ctx, err
		}
	}
	return ctx, nil
}
func (p *raftProxyRaftServer) pollNewLeaderConn(ctx context.Context) (*grpc.ClientConn, error) {
	ticker := time.NewTicker(500 * time.Millisecond)
	defer ticker.Stop()
	for {
		select {
		case <-ticker.C:
			conn, err := p.connSelector.LeaderConn(ctx)
			if err != nil {
				return nil, err
			}

			client := NewHealthClient(conn)

			resp, err := client.Check(ctx, &HealthCheckRequest{Service: "Raft"})
			if err != nil || resp.Status != HealthCheckResponse_SERVING {
				continue
			}
			return conn, nil
		case <-ctx.Done():
			return nil, ctx.Err()
		}
	}
}

func (p *raftProxyRaftServer) ProcessRaftMessage(ctx context.Context, r *ProcessRaftMessageRequest) (*ProcessRaftMessageResponse, error) {

	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			return p.local.ProcessRaftMessage(ctx, r)
		}
		return nil, err
	}
	modCtx, err := p.runCtxMods(ctx)
	if err != nil {
		return nil, err
	}

	resp, err := NewRaftClient(conn).ProcessRaftMessage(modCtx, r)
	if err != nil {
		if !strings.Contains(err.Error(), "is closing") && !strings.Contains(err.Error(), "the connection is unavailable") && !strings.Contains(err.Error(), "connection error") {
			return resp, err
		}
		conn, err := p.pollNewLeaderConn(ctx)
		if err != nil {
			if err == raftselector.ErrIsLeader {
				return p.local.ProcessRaftMessage(ctx, r)
			}
			return nil, err
		}
		return NewRaftClient(conn).ProcessRaftMessage(modCtx, r)
	}
	return resp, err
}

func (p *raftProxyRaftServer) ResolveAddress(ctx context.Context, r *ResolveAddressRequest) (*ResolveAddressResponse, error) {

	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			return p.local.ResolveAddress(ctx, r)
		}
		return nil, err
	}
	modCtx, err := p.runCtxMods(ctx)
	if err != nil {
		return nil, err
	}

	resp, err := NewRaftClient(conn).ResolveAddress(modCtx, r)
	if err != nil {
		if !strings.Contains(err.Error(), "is closing") && !strings.Contains(err.Error(), "the connection is unavailable") && !strings.Contains(err.Error(), "connection error") {
			return resp, err
		}
		conn, err := p.pollNewLeaderConn(ctx)
		if err != nil {
			if err == raftselector.ErrIsLeader {
				return p.local.ResolveAddress(ctx, r)
			}
			return nil, err
		}
		return NewRaftClient(conn).ResolveAddress(modCtx, r)
	}
	return resp, err
}

type raftProxyRaftMembershipServer struct {
	local        RaftMembershipServer
	connSelector raftselector.ConnProvider
	ctxMods      []func(context.Context) (context.Context, error)
}

func NewRaftProxyRaftMembershipServer(local RaftMembershipServer, connSelector raftselector.ConnProvider, ctxMod func(context.Context) (context.Context, error)) RaftMembershipServer {
	redirectChecker := func(ctx context.Context) (context.Context, error) {
		s, ok := transport.StreamFromContext(ctx)
		if !ok {
			return ctx, grpc.Errorf(codes.InvalidArgument, "remote addr is not found in context")
		}
		addr := s.ServerTransport().RemoteAddr().String()
		md, ok := metadata.FromContext(ctx)
		if ok && len(md["redirect"]) != 0 {
			return ctx, grpc.Errorf(codes.ResourceExhausted, "more than one redirect to leader from: %s", md["redirect"])
		}
		if !ok {
			md = metadata.New(map[string]string{})
		}
		md["redirect"] = append(md["redirect"], addr)
		return metadata.NewContext(ctx, md), nil
	}
	mods := []func(context.Context) (context.Context, error){redirectChecker}
	mods = append(mods, ctxMod)

	return &raftProxyRaftMembershipServer{
		local:        local,
		connSelector: connSelector,
		ctxMods:      mods,
	}
}
func (p *raftProxyRaftMembershipServer) runCtxMods(ctx context.Context) (context.Context, error) {
	var err error
	for _, mod := range p.ctxMods {
		ctx, err = mod(ctx)
		if err != nil {
			return ctx, err
		}
	}
	return ctx, nil
}
func (p *raftProxyRaftMembershipServer) pollNewLeaderConn(ctx context.Context) (*grpc.ClientConn, error) {
	ticker := time.NewTicker(500 * time.Millisecond)
	defer ticker.Stop()
	for {
		select {
		case <-ticker.C:
			conn, err := p.connSelector.LeaderConn(ctx)
			if err != nil {
				return nil, err
			}

			client := NewHealthClient(conn)

			resp, err := client.Check(ctx, &HealthCheckRequest{Service: "Raft"})
			if err != nil || resp.Status != HealthCheckResponse_SERVING {
				continue
			}
			return conn, nil
		case <-ctx.Done():
			return nil, ctx.Err()
		}
	}
}

func (p *raftProxyRaftMembershipServer) Join(ctx context.Context, r *JoinRequest) (*JoinResponse, error) {

	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			return p.local.Join(ctx, r)
		}
		return nil, err
	}
	modCtx, err := p.runCtxMods(ctx)
	if err != nil {
		return nil, err
	}

	resp, err := NewRaftMembershipClient(conn).Join(modCtx, r)
	if err != nil {
		if !strings.Contains(err.Error(), "is closing") && !strings.Contains(err.Error(), "the connection is unavailable") && !strings.Contains(err.Error(), "connection error") {
			return resp, err
		}
		conn, err := p.pollNewLeaderConn(ctx)
		if err != nil {
			if err == raftselector.ErrIsLeader {
				return p.local.Join(ctx, r)
			}
			return nil, err
		}
		return NewRaftMembershipClient(conn).Join(modCtx, r)
	}
	return resp, err
}

func (p *raftProxyRaftMembershipServer) Leave(ctx context.Context, r *LeaveRequest) (*LeaveResponse, error) {

	conn, err := p.connSelector.LeaderConn(ctx)
	if err != nil {
		if err == raftselector.ErrIsLeader {
			return p.local.Leave(ctx, r)
		}
		return nil, err
	}
	modCtx, err := p.runCtxMods(ctx)
	if err != nil {
		return nil, err
	}

	resp, err := NewRaftMembershipClient(conn).Leave(modCtx, r)
	if err != nil {
		if !strings.Contains(err.Error(), "is closing") && !strings.Contains(err.Error(), "the connection is unavailable") && !strings.Contains(err.Error(), "connection error") {
			return resp, err
		}
		conn, err := p.pollNewLeaderConn(ctx)
		if err != nil {
			if err == raftselector.ErrIsLeader {
				return p.local.Leave(ctx, r)
			}
			return nil, err
		}
		return NewRaftMembershipClient(conn).Leave(modCtx, r)
	}
	return resp, err
}

func (m *RaftMember) Size() (n int) {
	var l int
	_ = l
	if m.RaftID != 0 {
		n += 1 + sovRaft(uint64(m.RaftID))
	}
	l = len(m.NodeID)
	if l > 0 {
		n += 1 + l + sovRaft(uint64(l))
	}
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovRaft(uint64(l))
	}
	l = m.Status.Size()
	n += 1 + l + sovRaft(uint64(l))
	return n
}

func (m *JoinRequest) Size() (n int) {
	var l int
	_ = l
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovRaft(uint64(l))
	}
	return n
}

func (m *JoinResponse) Size() (n int) {
	var l int
	_ = l
	if m.RaftID != 0 {
		n += 1 + sovRaft(uint64(m.RaftID))
	}
	if len(m.Members) > 0 {
		for _, e := range m.Members {
			l = e.Size()
			n += 1 + l + sovRaft(uint64(l))
		}
	}
	if len(m.RemovedMembers) > 0 {
		for _, e := range m.RemovedMembers {
			n += 1 + sovRaft(uint64(e))
		}
	}
	return n
}

func (m *LeaveRequest) Size() (n int) {
	var l int
	_ = l
	if m.Node != nil {
		l = m.Node.Size()
		n += 1 + l + sovRaft(uint64(l))
	}
	return n
}

func (m *LeaveResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ProcessRaftMessageRequest) Size() (n int) {
	var l int
	_ = l
	if m.Message != nil {
		l = m.Message.Size()
		n += 1 + l + sovRaft(uint64(l))
	}
	return n
}

func (m *ProcessRaftMessageResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ResolveAddressRequest) Size() (n int) {
	var l int
	_ = l
	if m.RaftID != 0 {
		n += 1 + sovRaft(uint64(m.RaftID))
	}
	return n
}

func (m *ResolveAddressResponse) Size() (n int) {
	var l int
	_ = l
	l = len(m.Addr)
	if l > 0 {
		n += 1 + l + sovRaft(uint64(l))
	}
	return n
}

func (m *InternalRaftRequest) Size() (n int) {
	var l int
	_ = l
	if m.ID != 0 {
		n += 1 + sovRaft(uint64(m.ID))
	}
	if len(m.Action) > 0 {
		for _, e := range m.Action {
			l = e.Size()
			n += 1 + l + sovRaft(uint64(l))
		}
	}
	return n
}

func (m *StoreAction) Size() (n int) {
	var l int
	_ = l
	if m.Action != 0 {
		n += 1 + sovRaft(uint64(m.Action))
	}
	if m.Target != nil {
		n += m.Target.Size()
	}
	return n
}

func (m *StoreAction_Node) Size() (n int) {
	var l int
	_ = l
	if m.Node != nil {
		l = m.Node.Size()
		n += 1 + l + sovRaft(uint64(l))
	}
	return n
}
func (m *StoreAction_Service) Size() (n int) {
	var l int
	_ = l
	if m.Service != nil {
		l = m.Service.Size()
		n += 1 + l + sovRaft(uint64(l))
	}
	return n
}
func (m *StoreAction_Task) Size() (n int) {
	var l int
	_ = l
	if m.Task != nil {
		l = m.Task.Size()
		n += 1 + l + sovRaft(uint64(l))
	}
	return n
}
func (m *StoreAction_Network) Size() (n int) {
	var l int
	_ = l
	if m.Network != nil {
		l = m.Network.Size()
		n += 1 + l + sovRaft(uint64(l))
	}
	return n
}
func (m *StoreAction_Cluster) Size() (n int) {
	var l int
	_ = l
	if m.Cluster != nil {
		l = m.Cluster.Size()
		n += 1 + l + sovRaft(uint64(l))
	}
	return n
}
func (m *StoreAction_Secret) Size() (n int) {
	var l int
	_ = l
	if m.Secret != nil {
		l = m.Secret.Size()
		n += 1 + l + sovRaft(uint64(l))
	}
	return n
}

func sovRaft(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozRaft(x uint64) (n int) {
	return sovRaft(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *RaftMember) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&RaftMember{`,
		`RaftID:` + fmt.Sprintf("%v", this.RaftID) + `,`,
		`NodeID:` + fmt.Sprintf("%v", this.NodeID) + `,`,
		`Addr:` + fmt.Sprintf("%v", this.Addr) + `,`,
		`Status:` + strings.Replace(strings.Replace(this.Status.String(), "RaftMemberStatus", "RaftMemberStatus", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *JoinRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&JoinRequest{`,
		`Addr:` + fmt.Sprintf("%v", this.Addr) + `,`,
		`}`,
	}, "")
	return s
}
func (this *JoinResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&JoinResponse{`,
		`RaftID:` + fmt.Sprintf("%v", this.RaftID) + `,`,
		`Members:` + strings.Replace(fmt.Sprintf("%v", this.Members), "RaftMember", "RaftMember", 1) + `,`,
		`RemovedMembers:` + fmt.Sprintf("%v", this.RemovedMembers) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LeaveRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LeaveRequest{`,
		`Node:` + strings.Replace(fmt.Sprintf("%v", this.Node), "RaftMember", "RaftMember", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *LeaveResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&LeaveResponse{`,
		`}`,
	}, "")
	return s
}
func (this *ProcessRaftMessageRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ProcessRaftMessageRequest{`,
		`Message:` + strings.Replace(fmt.Sprintf("%v", this.Message), "Message", "raftpb.Message", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ProcessRaftMessageResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ProcessRaftMessageResponse{`,
		`}`,
	}, "")
	return s
}
func (this *ResolveAddressRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResolveAddressRequest{`,
		`RaftID:` + fmt.Sprintf("%v", this.RaftID) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ResolveAddressResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ResolveAddressResponse{`,
		`Addr:` + fmt.Sprintf("%v", this.Addr) + `,`,
		`}`,
	}, "")
	return s
}
func (this *InternalRaftRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&InternalRaftRequest{`,
		`ID:` + fmt.Sprintf("%v", this.ID) + `,`,
		`Action:` + strings.Replace(fmt.Sprintf("%v", this.Action), "StoreAction", "StoreAction", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StoreAction) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StoreAction{`,
		`Action:` + fmt.Sprintf("%v", this.Action) + `,`,
		`Target:` + fmt.Sprintf("%v", this.Target) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StoreAction_Node) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StoreAction_Node{`,
		`Node:` + strings.Replace(fmt.Sprintf("%v", this.Node), "Node", "Node", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StoreAction_Service) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StoreAction_Service{`,
		`Service:` + strings.Replace(fmt.Sprintf("%v", this.Service), "Service", "Service", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StoreAction_Task) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StoreAction_Task{`,
		`Task:` + strings.Replace(fmt.Sprintf("%v", this.Task), "Task", "Task", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StoreAction_Network) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StoreAction_Network{`,
		`Network:` + strings.Replace(fmt.Sprintf("%v", this.Network), "Network", "Network", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StoreAction_Cluster) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StoreAction_Cluster{`,
		`Cluster:` + strings.Replace(fmt.Sprintf("%v", this.Cluster), "Cluster", "Cluster", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *StoreAction_Secret) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&StoreAction_Secret{`,
		`Secret:` + strings.Replace(fmt.Sprintf("%v", this.Secret), "Secret", "Secret", 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringRaft(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *RaftMember) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftMember: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftMember: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftID", wireType)
			}
			m.RaftID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.RaftID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NodeID = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Status.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JoinRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JoinRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JoinRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JoinResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JoinResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JoinResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftID", wireType)
			}
			m.RaftID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.RaftID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Members", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Members = append(m.Members, &RaftMember{})
			if err := m.Members[len(m.Members)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RemovedMembers", wireType)
			}
			var v uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.RemovedMembers = append(m.RemovedMembers, v)
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LeaveRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LeaveRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LeaveRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Node", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Node == nil {
				m.Node = &RaftMember{}
			}
			if err := m.Node.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LeaveResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LeaveResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LeaveResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessRaftMessageRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessRaftMessageRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessRaftMessageRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Message == nil {
				m.Message = &raftpb.Message{}
			}
			if err := m.Message.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessRaftMessageResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessRaftMessageResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessRaftMessageResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResolveAddressRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResolveAddressRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResolveAddressRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftID", wireType)
			}
			m.RaftID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.RaftID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResolveAddressResponse) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResolveAddressResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResolveAddressResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addr = string(data[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InternalRaftRequest) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InternalRaftRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InternalRaftRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.ID |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Action = append(m.Action, &StoreAction{})
			if err := m.Action[len(m.Action)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreAction) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreAction: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreAction: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Action", wireType)
			}
			m.Action = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				m.Action |= (StoreActionKind(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Node", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Node{}
			if err := v.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Target = &StoreAction_Node{v}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Service", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Service{}
			if err := v.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Target = &StoreAction_Service{v}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Task", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Task{}
			if err := v.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Target = &StoreAction_Task{v}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Network", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Network{}
			if err := v.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Target = &StoreAction_Network{v}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Cluster", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Cluster{}
			if err := v.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Target = &StoreAction_Cluster{v}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secret", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthRaft
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &Secret{}
			if err := v.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Target = &StoreAction_Secret{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipRaft(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthRaft
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipRaft(data []byte) (n int, err error) {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowRaft
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if data[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowRaft
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthRaft
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowRaft
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipRaft(data[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthRaft = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowRaft   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("raft.proto", fileDescriptorRaft) }

var fileDescriptorRaft = []byte{
	// 890 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x8c, 0x95, 0xcf, 0x73, 0xdb, 0x44,
	0x14, 0xc7, 0xbd, 0xb2, 0x2a, 0xc3, 0x73, 0x13, 0x67, 0x36, 0x24, 0xb8, 0xa2, 0xa3, 0xb8, 0x2a,
	0x33, 0x75, 0x3b, 0x44, 0x1e, 0x0c, 0x33, 0x65, 0x80, 0x4b, 0x9c, 0x78, 0x26, 0xa6, 0xad, 0xd3,
	0x51, 0x12, 0xe8, 0x2d, 0xc8, 0xd2, 0xc6, 0x15, 0x8e, 0xb5, 0x66, 0x77, 0xed, 0x0c, 0x17, 0xa6,
	0x47, 0x26, 0x57, 0x86, 0x1f, 0x97, 0x9e, 0xe0, 0xdc, 0x3f, 0x80, 0xbf, 0x20, 0xc3, 0x89, 0x1b,
	0x9c, 0x32, 0xc4, 0x7f, 0x00, 0xf0, 0x27, 0x30, 0xbb, 0x92, 0x92, 0xd4, 0x51, 0x1c, 0x5f, 0x92,
	0xf5, 0xea, 0xf3, 0x7d, 0xdf, 0x7d, 0x6f, 0xf5, 0x9e, 0x00, 0x98, 0xb7, 0x2f, 0x9c, 0x01, 0xa3,
	0x82, 0x62, 0x1c, 0x50, 0xbf, 0x47, 0x98, 0xc3, 0x0f, 0x3d, 0xd6, 0xef, 0x85, 0xc2, 0x19, 0xbd,
	0x6f, 0xce, 0xd1, 0xce, 0x57, 0xc4, 0x17, 0x3c, 0x46, 0xcc, 0xa2, 0xf8, 0x66, 0x40, 0xd2, 0x1f,
	0xab, 0xdd, 0x50, 0x3c, 0x1f, 0x76, 0x1c, 0x9f, 0xf6, 0x6b, 0x3e, 0x65, 0x84, 0xf2, 0x1a, 0x11,
	0x7e, 0x50, 0x93, 0x21, 0xd5, 0x9f, 0x41, 0xa7, 0x76, 0x1e, 0xde, 0x7c, 0xab, 0x4b, 0xbb, 0x54,
	0x2d, 0x6b, 0x72, 0x95, 0xec, 0x2e, 0x0e, 0x0e, 0x86, 0xdd, 0x30, 0xaa, 0xc5, 0xff, 0xe2, 0x4d,
	0xfb, 0x15, 0x02, 0x70, 0xbd, 0x7d, 0xf1, 0x84, 0xf4, 0x3b, 0x84, 0xe1, 0xbb, 0x50, 0x90, 0x71,
	0xf6, 0xc2, 0xa0, 0x8c, 0x2a, 0xa8, 0xaa, 0x37, 0x60, 0x7c, 0xb2, 0x62, 0x48, 0xa0, 0xb5, 0xe1,
	0x1a, 0xf2, 0x51, 0x2b, 0x90, 0x50, 0x44, 0x03, 0x22, 0x21, 0xad, 0x82, 0xaa, 0x6f, 0xc6, 0x50,
	0x9b, 0x06, 0x44, 0x42, 0xf2, 0x51, 0x2b, 0xc0, 0x18, 0x74, 0x2f, 0x08, 0x58, 0x39, 0x2f, 0x09,
	0x57, 0xad, 0x71, 0x03, 0x0c, 0x2e, 0x3c, 0x31, 0xe4, 0x65, 0xbd, 0x82, 0xaa, 0xc5, 0xfa, 0xbb,
	0xce, 0xe5, 0x3a, 0x38, 0xe7, 0xa7, 0xd9, 0x56, 0x6c, 0x43, 0x3f, 0x3e, 0x59, 0xc9, 0xb9, 0x89,
	0xd2, 0xbe, 0x03, 0xc5, 0xcf, 0x68, 0x18, 0xb9, 0xe4, 0xeb, 0x21, 0xe1, 0xe2, 0xcc, 0x06, 0x9d,
	0xdb, 0xd8, 0x3f, 0x22, 0xb8, 0x19, 0x33, 0x7c, 0x40, 0x23, 0x4e, 0x66, 0xcb, 0xea, 0x23, 0x28,
	0xf4, 0x95, 0x2d, 0x2f, 0x6b, 0x95, 0x7c, 0xb5, 0x58, 0xb7, 0xa6, 0x9f, 0xce, 0x4d, 0x71, 0x7c,
	0x0f, 0x4a, 0x8c, 0xf4, 0xe9, 0x88, 0x04, 0x7b, 0x69, 0x84, 0x7c, 0x25, 0x5f, 0xd5, 0xdd, 0xf9,
	0x64, 0x3b, 0x16, 0x70, 0xbb, 0x01, 0x37, 0x1f, 0x13, 0x6f, 0x44, 0xd2, 0xc3, 0xd7, 0x41, 0x97,
	0xd5, 0x52, 0x87, 0xba, 0xde, 0x4f, 0xb1, 0x76, 0x09, 0xe6, 0x92, 0x18, 0x71, 0x72, 0xf6, 0x63,
	0xb8, 0xf5, 0x94, 0x51, 0x9f, 0x70, 0x1e, 0xb3, 0x9c, 0x7b, 0xdd, 0x33, 0x87, 0xfb, 0x32, 0x29,
	0xb5, 0x93, 0x98, 0x94, 0x9c, 0xf8, 0x75, 0x71, 0x52, 0x30, 0x7d, 0xfe, 0xb1, 0xfe, 0xe2, 0x27,
	0x3b, 0x67, 0xdf, 0x06, 0x33, 0x2b, 0x5a, 0xe2, 0xf5, 0x29, 0x2c, 0xb9, 0x84, 0xd3, 0x83, 0x11,
	0x59, 0x0b, 0x02, 0x26, 0xa1, 0xc4, 0x67, 0x96, 0x0a, 0xdb, 0xef, 0xc1, 0xf2, 0xa4, 0x3a, 0xb9,
	0xa0, 0xac, 0x5b, 0xdc, 0x87, 0xc5, 0x56, 0x24, 0x08, 0x8b, 0xbc, 0x03, 0x19, 0x27, 0x75, 0x5a,
	0x06, 0xed, 0xcc, 0xc4, 0x18, 0x9f, 0xac, 0x68, 0xad, 0x0d, 0x57, 0x0b, 0x03, 0xfc, 0x10, 0x0c,
	0xcf, 0x17, 0x21, 0x8d, 0x92, 0xdb, 0x5b, 0xc9, 0xaa, 0xe6, 0xb6, 0xa0, 0x8c, 0xac, 0x29, 0xcc,
	0x4d, 0x70, 0xfb, 0x87, 0x3c, 0x14, 0x2f, 0xec, 0xe3, 0x4f, 0xce, 0x02, 0x49, 0x93, 0xf9, 0xfa,
	0xdd, 0x6b, 0x02, 0x3d, 0x0a, 0xa3, 0x20, 0x0d, 0x86, 0x9d, 0xe4, 0x46, 0x35, 0x55, 0xec, 0x72,
	0x96, 0x54, 0xf6, 0xc9, 0x66, 0x2e, 0xbe, 0x4d, 0xfc, 0x10, 0x0a, 0x9c, 0xb0, 0x51, 0xe8, 0x13,
	0xd5, 0x28, 0xc5, 0xfa, 0x3b, 0x99, 0x6e, 0x31, 0xb2, 0x99, 0x73, 0x53, 0x5a, 0x1a, 0x09, 0x8f,
	0xf7, 0x92, 0x46, 0xca, 0x34, 0xda, 0xf1, 0x78, 0x4f, 0x1a, 0x49, 0x4e, 0x1a, 0x45, 0x44, 0x1c,
	0x52, 0xd6, 0x2b, 0xdf, 0xb8, 0xda, 0xa8, 0x1d, 0x23, 0xd2, 0x28, 0xa1, 0xa5, 0xd0, 0x3f, 0x18,
	0x72, 0x41, 0x58, 0xd9, 0xb8, 0x5a, 0xb8, 0x1e, 0x23, 0x52, 0x98, 0xd0, 0xf8, 0x43, 0x30, 0x38,
	0xf1, 0x19, 0x11, 0xe5, 0x82, 0xd2, 0x99, 0xd9, 0x99, 0x49, 0x62, 0x53, 0xb6, 0xb7, 0x5a, 0x35,
	0xde, 0x00, 0x43, 0x78, 0xac, 0x4b, 0xc4, 0x83, 0x7f, 0x11, 0x94, 0x26, 0xca, 0x8c, 0xef, 0x41,
	0x61, 0xb7, 0xfd, 0xa8, 0xbd, 0xf5, 0x45, 0x7b, 0x21, 0x67, 0x9a, 0x47, 0x2f, 0x2b, 0xcb, 0x13,
	0xc4, 0x6e, 0xd4, 0x8b, 0xe8, 0x61, 0x84, 0xeb, 0xb0, 0xb8, 0xbd, 0xb3, 0xe5, 0x36, 0xf7, 0xd6,
	0xd6, 0x77, 0x5a, 0x5b, 0xed, 0xbd, 0x75, 0xb7, 0xb9, 0xb6, 0xd3, 0x5c, 0x40, 0xe6, 0xad, 0xa3,
	0x97, 0x95, 0xa5, 0x09, 0xd1, 0x3a, 0x23, 0x9e, 0x20, 0x97, 0x34, 0xbb, 0x4f, 0x37, 0xa4, 0x46,
	0xcb, 0xd4, 0xec, 0x0e, 0x82, 0x2c, 0x8d, 0xdb, 0x7c, 0xb2, 0xf5, 0x79, 0x73, 0x21, 0x9f, 0xa9,
	0x71, 0xd5, 0x34, 0x30, 0xdf, 0xfe, 0xee, 0x17, 0x2b, 0xf7, 0xdb, 0xaf, 0xd6, 0x64, 0x76, 0xf5,
	0xef, 0x35, 0xd0, 0xe5, 0xab, 0x8e, 0x8f, 0x10, 0xe0, 0xcb, 0x5d, 0x88, 0x57, 0xb3, 0x2a, 0x78,
	0x65, 0xef, 0x9b, 0xce, 0xac, 0x78, 0xd2, 0xdc, 0x4b, 0xbf, 0xbf, 0xfa, 0xe7, 0x67, 0xad, 0x04,
	0x73, 0x8a, 0x5f, 0xed, 0x7b, 0x91, 0xd7, 0x25, 0x0c, 0x7f, 0x0b, 0xf3, 0xaf, 0x77, 0x2d, 0xbe,
	0x9f, 0x39, 0xa8, 0xb2, 0xe6, 0x82, 0xf9, 0x60, 0x16, 0x74, 0xaa, 0x7f, 0xfd, 0x4f, 0x04, 0xf3,
	0xe7, 0x53, 0x90, 0x3f, 0x0f, 0x07, 0xf8, 0x4b, 0xd0, 0xe5, 0x7c, 0xc7, 0x99, 0x3d, 0x7e, 0xe1,
	0xeb, 0x60, 0x56, 0xae, 0x06, 0xa6, 0x27, 0xed, 0xc3, 0x0d, 0x35, 0x65, 0x71, 0x66, 0x84, 0x8b,
	0x43, 0xdc, 0xbc, 0x33, 0x85, 0x98, 0x6a, 0xd2, 0xb8, 0x7d, 0x7c, 0x6a, 0xe5, 0xfe, 0x3a, 0xb5,
	0x72, 0xff, 0x9d, 0x5a, 0xe8, 0xc5, 0xd8, 0x42, 0xc7, 0x63, 0x0b, 0xfd, 0x31, 0xb6, 0xd0, 0xdf,
	0x63, 0x0b, 0x3d, 0xcb, 0x3f, 0xd3, 0x3b, 0x86, 0xfa, 0x48, 0x7f, 0xf0, 0x7f, 0x00, 0x00, 0x00,
	0xff, 0xff, 0x53, 0x4c, 0x9e, 0xad, 0x3c, 0x08, 0x00, 0x00,
}
