/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2013-2014 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.glassfish.jersey.media.htmljson;

import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.glassfish.jersey.test.TestProperties;

import org.junit.Test;
import static org.junit.Assert.assertEquals;

import net.java.html.json.Model;
import net.java.html.json.Property;

/**
 * Reading and writing class generated by {@link Model}.
 *
 * @author Jaroslav Tulach
 */
public class ModelEntityTest extends AbstractTypeTester {

    @Model(className = "MyBean", properties = {
            @Property(name = "value", type = String.class)
    })
    static class MB {
    }

    @Path("empty")
    public static class TestResource {
        @POST
        @Path("mybean")
        public String myBean(MyBean bean) {
            return (bean.getValue().equals("Hello")) ? "PASSED" : "ERROR";
        }

        @GET
        @Path("getbean")
        public Response getBean(@Context HttpHeaders headers) {
            MyBean teb = new MyBean();
            teb.setValue("hello");
            return Response.ok().type(MediaType.APPLICATION_JSON_TYPE).entity(teb).build();
        }
    }

    public ModelEntityTest() {
        enable(TestProperties.LOG_TRAFFIC);
    }

    @Test
    public void myBeanAndPut() {
        WebTarget target = target("empty/mybean");

        MyBean mb = new MyBean();
        mb.setValue("Hello");

        final Response response = target.request().post(Entity.entity(mb, MediaType.APPLICATION_JSON_TYPE));

        assertEquals(200, response.getStatus());
        assertEquals("PASSED", response.readEntity(String.class));
    }

    @Test
    public void myBeanAndGet() {
        WebTarget target = target("empty/getbean");
        final Response response = target.request(MediaType.APPLICATION_JSON).get();
        assertEquals(200, response.getStatus());
        final MyBean teb = response.readEntity(MyBean.class);

        assertEquals("value", "hello", teb.getValue());
    }
}
