/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2015 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package org.glassfish.hk2.xml.test.customizer;

import javax.inject.Inject;
import javax.inject.Singleton;

import org.jvnet.hk2.annotations.Contract;

/**
 * @author jwells
 *
 */
@Contract @Singleton
public class CustomizerOne {
    @Inject
    private MuseumBean customized;
    
    private boolean customizer2Called = false;
    private boolean fauxAddCalled = false;
    
    public String customizer1(String prefix, String postfix) {
        return prefix + customized.getName() + postfix;
    }
    
    public void customizer2() {
        customizer2Called = true;
    }
    
    public boolean getCustomizer2Called() {
        return customizer2Called;
    }
    
    public long[] customizer3(String[][] anArray) {
        return new long[0];
    }
    
    public boolean customizer4() {
        return CustomizerTest.C4;
    }
    public int customizer5(){
        return CustomizerTest.C5;
    }
    public long customizer6(){
        return CustomizerTest.C6;
    }
    public float customizer7(){
        return CustomizerTest.C7;
    }
    public double customizer8(){
        return CustomizerTest.C8;
    }
    
    public byte customizer9(){
        return CustomizerTest.C9;
    }
    public short customizer10(){
        return CustomizerTest.C10;
    }
    public char customizer11(){
        return CustomizerTest.C11;
    }
    
    public int customizer12(boolean z, int i, long j, float f, double d, byte b, short s, char c, int[]... var) {
        return var.length;
    }
    
    public String[] toUpper(String lowers[]) {
        if (lowers == null) return null;
        
        String[] retVal = new String[lowers.length];
        
        int lcv = 0;
        for (String lower : lowers) {
            retVal[lcv++] = lower.toUpperCase();
        }
        
        return retVal;
    }

    public void addListener(BeanListener listener) {
        fauxAddCalled = true;
    }
    
    public boolean getFauxAddCalled() {
        return fauxAddCalled;
    }
}
