/**
 * Copyright (c) 2005-2012 by Appcelerator, Inc. All Rights Reserved.
 * Licensed under the terms of the Eclipse Public License (EPL).
 * Please see the license.txt included with this distribution for details.
 * Any modifications to this file must keep this entire header intact.
 */
/*
 * Created on Sep 16, 2006
 * @author Fabio
 */
package org.python.pydev.parser;

import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.SimpleNode;

/**
 * Interface for the grammar used.
 * 
 * @author Fabio
 */
public interface IGrammar {

    void enable_tracing();

    public static Object parseLock = new Object();

    /**
     * Important: code that calls this function must be synchronized with the parseLock object in this interface.
     * This is needed because there are optimizations within the parser that require it to be accessed 
     * sequentially.
     * 
     * (optimization: openNode in the tree builder)
     * 
     * @return the tree structure generated by parsing the file.
     * 
     * @throws ParseException
     */
    SimpleNode file_input() throws ParseException;

    /**
     * @return the 1st error that occurred while parsing.
     */
    Throwable getErrorOnParsing();

}
