// Autogenerated AST node
package org.python.pydev.parser.jython.ast;

import org.python.pydev.parser.jython.SimpleNode;
import java.util.Arrays;

public final class FunctionDef extends stmtType {
    public NameTokType name;
    public argumentsType args;
    public stmtType[] body;
    public decoratorsType[] decs;
    public exprType returns;

    public FunctionDef(NameTokType name, argumentsType args, stmtType[] body, decoratorsType[] decs, exprType returns) {
        this.name = name;
        this.args = args;
        this.body = body;
        this.decs = decs;
        this.returns = returns;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((name == null) ? 0 : name.hashCode());
        result = prime * result + ((args == null) ? 0 : args.hashCode());
        result = prime * result + Arrays.hashCode(body);
        result = prime * result + Arrays.hashCode(decs);
        result = prime * result + ((returns == null) ? 0 : returns.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        FunctionDef other = (FunctionDef) obj;
        if (name == null) {
            if (other.name != null)
                return false;
        } else if (!name.equals(other.name))
            return false;
        if (args == null) {
            if (other.args != null)
                return false;
        } else if (!args.equals(other.args))
            return false;
        if (!Arrays.equals(body, other.body))
            return false;
        if (!Arrays.equals(decs, other.decs))
            return false;
        if (returns == null) {
            if (other.returns != null)
                return false;
        } else if (!returns.equals(other.returns))
            return false;
        return true;
    }

    @Override
    public FunctionDef createCopy() {
        return createCopy(true);
    }

    @Override
    public FunctionDef createCopy(boolean copyComments) {
        stmtType[] new0;
        if (this.body != null) {
            new0 = new stmtType[this.body.length];
            for (int i = 0; i < this.body.length; i++) {
                new0[i] = (stmtType) (this.body[i] != null ? this.body[i].createCopy(copyComments) : null);
            }
        } else {
            new0 = this.body;
        }
        decoratorsType[] new1;
        if (this.decs != null) {
            new1 = new decoratorsType[this.decs.length];
            for (int i = 0; i < this.decs.length; i++) {
                new1[i] = (decoratorsType) (this.decs[i] != null ? this.decs[i].createCopy(copyComments) : null);
            }
        } else {
            new1 = this.decs;
        }
        FunctionDef temp = new FunctionDef(name != null ? (NameTokType) name.createCopy(copyComments) : null,
                args != null ? (argumentsType) args.createCopy(copyComments) : null, new0, new1,
                returns != null ? (exprType) returns.createCopy(copyComments) : null);
        temp.beginLine = this.beginLine;
        temp.beginColumn = this.beginColumn;
        if (this.specialsBefore != null && copyComments) {
            for (Object o : this.specialsBefore) {
                if (o instanceof commentType) {
                    commentType commentType = (commentType) o;
                    temp.getSpecialsBefore().add(commentType.createCopy(copyComments));
                }
            }
        }
        if (this.specialsAfter != null && copyComments) {
            for (Object o : this.specialsAfter) {
                if (o instanceof commentType) {
                    commentType commentType = (commentType) o;
                    temp.getSpecialsAfter().add(commentType.createCopy(copyComments));
                }
            }
        }
        return temp;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("FunctionDef[");
        sb.append("name=");
        sb.append(dumpThis(this.name));
        sb.append(", ");
        sb.append("args=");
        sb.append(dumpThis(this.args));
        sb.append(", ");
        sb.append("body=");
        sb.append(dumpThis(this.body));
        sb.append(", ");
        sb.append("decs=");
        sb.append(dumpThis(this.decs));
        sb.append(", ");
        sb.append("returns=");
        sb.append(dumpThis(this.returns));
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitFunctionDef(this);
    }

    @Override
    public void traverse(VisitorIF visitor) throws Exception {
        if (name != null) {
            name.accept(visitor);
        }
        if (args != null) {
            args.accept(visitor);
        }
        if (body != null) {
            for (int i = 0; i < body.length; i++) {
                if (body[i] != null) {
                    body[i].accept(visitor);
                }
            }
        }
        if (decs != null) {
            for (int i = 0; i < decs.length; i++) {
                if (decs[i] != null) {
                    decs[i].accept(visitor);
                }
            }
        }
        if (returns != null) {
            returns.accept(visitor);
        }
    }

}
