/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.plugin.http;

import HTTPClient.NVPair;
import java.net.InetAddress;
import java.net.UnknownHostException;
import net.grinder.plugin.http.HTTPPluginConnection;
import net.grinder.plugin.http.URLException;

final class HTTPPluginConnectionDefaults
implements HTTPPluginConnection {
    private boolean m_followRedirects = false;
    private boolean m_useCookies = true;
    private boolean m_useContentEncoding = false;
    private boolean m_useTransferEncoding = false;
    private boolean m_useAuthorizationModule = false;
    private NVPair[] m_defaultHeaders = new NVPair[0];
    private int m_timeout = 0;
    private String m_proxyHost;
    private int m_proxyPort;
    private boolean m_verifyServerDistinguishedName = false;
    private InetAddress m_localAddress;
    private int m_slowClientTargetBPS;
    private static final HTTPPluginConnectionDefaults s_defaultConnectionDefaults = new HTTPPluginConnectionDefaults();

    HTTPPluginConnectionDefaults() {
    }

    public void setFollowRedirects(boolean followRedirects) {
        this.m_followRedirects = followRedirects;
    }

    boolean getFollowRedirects() {
        return this.m_followRedirects;
    }

    public void setUseCookies(boolean useCookies) {
        this.m_useCookies = useCookies;
    }

    boolean getUseCookies() {
        return this.m_useCookies;
    }

    public void setUseContentEncoding(boolean useContentEncoding) {
        this.m_useContentEncoding = useContentEncoding;
    }

    boolean getUseContentEncoding() {
        return this.m_useContentEncoding;
    }

    public void setUseTransferEncoding(boolean useTransferEncoding) {
        this.m_useTransferEncoding = useTransferEncoding;
    }

    boolean getUseAuthorizationModule() {
        return this.m_useAuthorizationModule;
    }

    public void setUseAuthorizationModule(boolean b) {
        this.m_useAuthorizationModule = b;
    }

    boolean getUseTransferEncoding() {
        return this.m_useTransferEncoding;
    }

    public void setDefaultHeaders(NVPair[] defaultHeaders) {
        this.m_defaultHeaders = defaultHeaders;
    }

    NVPair[] getDefaultHeaders() {
        return this.m_defaultHeaders;
    }

    public void setTimeout(int timeout) {
        this.m_timeout = timeout;
    }

    int getTimeout() {
        return this.m_timeout;
    }

    public void setVerifyServerDistinguishedName(boolean b) {
        this.m_verifyServerDistinguishedName = b;
    }

    boolean getVerifyServerDistinguishedName() {
        return this.m_verifyServerDistinguishedName;
    }

    public void setProxyServer(String host, int port) {
        this.m_proxyHost = host;
        this.m_proxyPort = port;
    }

    String getProxyHost() {
        return this.m_proxyHost;
    }

    int getProxyPort() {
        return this.m_proxyPort;
    }

    public void setLocalAddress(String localAddress) throws URLException {
        try {
            this.m_localAddress = InetAddress.getByName(localAddress);
        }
        catch (UnknownHostException e) {
            throw new URLException(e.getMessage(), e);
        }
    }

    InetAddress getLocalAddress() {
        return this.m_localAddress;
    }

    public void setBandwidthLimit(int targetBPS) {
        this.m_slowClientTargetBPS = targetBPS;
    }

    int getBandwidthLimit() {
        return this.m_slowClientTargetBPS;
    }

    public static HTTPPluginConnectionDefaults getConnectionDefaults() {
        return s_defaultConnectionDefaults;
    }

    public void close() {
    }
}

