/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import java.io.InputStream;
import net.grinder.common.GrinderException;
import net.grinder.common.Logger;
import net.grinder.communication.StreamReceiver;
import net.grinder.engine.process.GrinderProcess;

public class WorkerProcessEntryPoint {
    public static void main(String[] args) {
        if (args.length > 1) {
            System.err.println("Usage: java " + GrinderProcess.class.getName());
            System.exit(-1);
        }
        int exitCode = new WorkerProcessEntryPoint().run(System.in);
        System.exit(exitCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(InputStream agentCommunicationStream) {
        GrinderProcess grinderProcess;
        try {
            grinderProcess = new GrinderProcess(new StreamReceiver(agentCommunicationStream));
        }
        catch (GrinderException e) {
            System.err.println("Error initialising worker process (" + e.getMessage() + ")");
            e.printStackTrace();
            return -2;
        }
        Logger logger = grinderProcess.getLogger();
        try {
            grinderProcess.run();
            int n = 0;
            grinderProcess.shutdown(agentCommunicationStream == System.in);
            return n;
        }
        catch (Exception e) {
            try {
                logger.error("Error running worker process (" + e.getMessage() + ")", 3);
                e.printStackTrace(logger.getErrorLogWriter());
                int n = -3;
                grinderProcess.shutdown(agentCommunicationStream == System.in);
                return n;
            }
            catch (Throwable throwable) {
                grinderProcess.shutdown(agentCommunicationStream == System.in);
                throw throwable;
            }
        }
    }
}

