/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import net.grinder.common.Test;
import net.grinder.engine.process.TestStatisticsHelper;
import net.grinder.statistics.ImmutableStatisticsSet;
import net.grinder.statistics.StatisticsIndexMap;
import net.grinder.statistics.StatisticsSet;
import net.grinder.statistics.TestStatisticsMap;

final class TestStatisticsHelperImplementation
implements TestStatisticsHelper {
    private final StatisticsIndexMap m_statisticsIndexMap;
    private final StatisticsIndexMap.LongIndex m_errorsIndex;
    private final StatisticsIndexMap.LongIndex m_untimedTestsIndex;
    private final StatisticsIndexMap.LongSampleIndex m_timedTestsIndex;

    public TestStatisticsHelperImplementation(StatisticsIndexMap indexMap) {
        this.m_statisticsIndexMap = indexMap;
        this.m_errorsIndex = indexMap.getLongIndex("errors");
        this.m_untimedTestsIndex = indexMap.getLongIndex("untimedTests");
        this.m_timedTestsIndex = indexMap.getLongSampleIndex("timedTests");
    }

    public boolean getSuccess(ImmutableStatisticsSet statistics) {
        return statistics.getValue(this.m_errorsIndex) == 0L;
    }

    public void setSuccess(StatisticsSet statistics, boolean success) {
        statistics.setValue(this.m_errorsIndex, success ? 0L : 1L);
    }

    public void recordTest(StatisticsSet statistics, long elapsedTime) {
        statistics.reset(this.m_timedTestsIndex);
        statistics.addSample(this.m_timedTestsIndex, elapsedTime);
        this.setSuccess(statistics, this.getSuccess(statistics));
        statistics.setValue(this.m_untimedTestsIndex, 0L);
    }

    public long getTestTime(ImmutableStatisticsSet statistics) {
        return statistics.getSum(this.m_timedTestsIndex);
    }

    public void removeTestTimeFromSample(TestStatisticsMap sample) {
        new TestStatisticsMap.ForEach(sample){

            public void next(Test test, StatisticsSet statistics) {
                statistics.addValue(TestStatisticsHelperImplementation.this.m_untimedTestsIndex, statistics.getCount(TestStatisticsHelperImplementation.this.m_timedTestsIndex));
                statistics.reset(TestStatisticsHelperImplementation.this.m_timedTestsIndex);
            }
        }.iterate();
    }

    public StatisticsIndexMap getStatisticsIndexMap() {
        return this.m_statisticsIndexMap;
    }

    public void incrementErrors(StatisticsSet testStatistics) {
        testStatistics.addValue(this.m_errorsIndex, 1L);
    }
}

