/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.engine.process;

import net.grinder.common.Test;
import net.grinder.common.UncheckedGrinderException;
import net.grinder.engine.common.EngineException;
import net.grinder.engine.process.DispatchContext;
import net.grinder.engine.process.DispatchResultReporter;
import net.grinder.engine.process.Instrumenter;
import net.grinder.engine.process.ScriptEngine;
import net.grinder.engine.process.ShutdownException;
import net.grinder.engine.process.StatisticsForTestImplementation;
import net.grinder.engine.process.StopWatch;
import net.grinder.engine.process.StopWatchImplementation;
import net.grinder.engine.process.TestStatisticsHelper;
import net.grinder.engine.process.ThreadContext;
import net.grinder.engine.process.ThreadContextLocator;
import net.grinder.script.NotWrappableTypeException;
import net.grinder.script.Statistics;
import net.grinder.script.TestRegistry;
import net.grinder.statistics.StatisticsSet;
import net.grinder.statistics.StatisticsSetFactory;
import net.grinder.util.TimeAuthority;

final class TestData
implements TestRegistry.RegisteredTest,
ScriptEngine.Dispatcher {
    private final StatisticsSetFactory m_statisticsSetFactory;
    private final TestStatisticsHelper m_testStatisticsHelper;
    private final TimeAuthority m_timeAuthority;
    private final Instrumenter m_instrumenter;
    private final ThreadContextLocator m_threadContextLocator;
    private final Test m_test;
    private final StatisticsSet m_testStatistics;
    private final DispatcherHolderThreadLocal m_dispatcherHolderThreadLocal = new DispatcherHolderThreadLocal();

    TestData(ThreadContextLocator threadContextLocator, StatisticsSetFactory statisticsSetFactory, TestStatisticsHelper testStatisticsHelper, TimeAuthority timeAuthority, Instrumenter instrumenter, Test testDefinition) {
        this.m_statisticsSetFactory = statisticsSetFactory;
        this.m_testStatisticsHelper = testStatisticsHelper;
        this.m_timeAuthority = timeAuthority;
        this.m_instrumenter = instrumenter;
        this.m_threadContextLocator = threadContextLocator;
        this.m_test = testDefinition;
        this.m_testStatistics = this.m_statisticsSetFactory.create();
    }

    Test getTest() {
        return this.m_test;
    }

    StatisticsSet getTestStatistics() {
        return this.m_testStatistics;
    }

    public Object createProxy(Object o) throws NotWrappableTypeException {
        return this.m_instrumenter.createInstrumentedProxy(this.getTest(), this, o);
    }

    public Object dispatch(ScriptEngine.Dispatcher.Callable callable) throws EngineException {
        DispatcherHolder dispatcherHolder = this.m_dispatcherHolderThreadLocal.getDispatcherHolder();
        return dispatcherHolder.dispatch(callable);
    }

    private static final class UncheckedException
    extends UncheckedGrinderException {
        public UncheckedException(String message) {
            super(message);
        }
    }

    private final class Dispatcher
    implements DispatchContext {
        private final DispatchResultReporter m_resultReporter;
        private final StopWatch m_pauseTimer;
        private long m_startTime = -1L;
        private long m_dispatchTime = -1L;
        private StatisticsForTestImplementation m_statisticsForTest;

        public Dispatcher(DispatchResultReporter resultReporter, StopWatch pauseTimer) {
            this.m_resultReporter = resultReporter;
            this.m_pauseTimer = pauseTimer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object dispatch(ScriptEngine.Dispatcher.Callable callable) throws DispatchContext.DispatchStateException {
            if (this.m_startTime != -1L || this.m_dispatchTime != -1L) {
                throw new DispatchContext.DispatchStateException("Last statistics were not reported");
            }
            this.m_pauseTimer.reset();
            this.m_statisticsForTest = new StatisticsForTestImplementation(this, TestData.this.m_testStatisticsHelper, TestData.this.m_statisticsSetFactory.create());
            try {
                Thread.yield();
                this.m_startTime = TestData.this.m_timeAuthority.getTimeInMilliseconds();
                try {
                    Object object = callable.call();
                    Object var4_4 = null;
                    this.m_dispatchTime = TestData.this.m_timeAuthority.getTimeInMilliseconds() - this.m_startTime;
                    return object;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    this.m_dispatchTime = TestData.this.m_timeAuthority.getTimeInMilliseconds() - this.m_startTime;
                    throw throwable;
                }
            }
            catch (RuntimeException e) {
                if (this.m_pauseTimer.isRunning()) {
                    this.m_pauseTimer.stop();
                }
                TestData.this.m_testStatisticsHelper.setSuccess(this.m_statisticsForTest.getStatistics(), false);
                throw e;
            }
        }

        public void report() throws DispatchContext.DispatchStateException {
            if (this.m_dispatchTime < 0L) {
                throw new DispatchContext.DispatchStateException("No statistics to report");
            }
            StatisticsSet statistics = this.m_statisticsForTest.getStatistics();
            TestData.this.m_testStatisticsHelper.recordTest(statistics, this.getElapsedTime());
            this.m_resultReporter.report(this.getTest(), this.m_startTime, statistics);
            if (TestData.this.m_testStatisticsHelper.getSuccess(statistics)) {
                TestData.this.getTestStatistics().add(statistics);
            } else {
                TestData.this.m_testStatisticsHelper.incrementErrors(TestData.this.getTestStatistics());
            }
            this.m_statisticsForTest.freeze();
            this.m_statisticsForTest = null;
            this.m_startTime = -1L;
            this.m_dispatchTime = -1L;
        }

        public Test getTest() {
            return TestData.this.getTest();
        }

        public StopWatch getPauseTimer() {
            return this.m_pauseTimer;
        }

        public long getElapsedTime() {
            if (this.m_startTime == -1L) {
                return -1L;
            }
            long unadjustedTime = this.m_dispatchTime == -1L ? TestData.this.m_timeAuthority.getTimeInMilliseconds() - this.m_startTime : this.m_dispatchTime;
            return Math.max(unadjustedTime - this.m_pauseTimer.getTime(), 0L);
        }

        public Statistics.StatisticsForTest getStatisticsForTest() {
            return this.m_statisticsForTest;
        }

        public void setHasNestedContexts() {
            TestData.this.m_testStatistics.setIsComposite();
        }
    }

    private static final class DispatcherHolder {
        private final ThreadContext m_threadContext;
        private Dispatcher m_dispatcher;

        public DispatcherHolder(ThreadContext threadContext, Dispatcher dispatcher) {
            this.m_threadContext = threadContext;
            this.m_dispatcher = dispatcher;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object dispatch(ScriptEngine.Dispatcher.Callable callable) throws DispatchContext.DispatchStateException, ShutdownException {
            if (this.m_dispatcher != null) {
                Dispatcher dispatcher = this.m_dispatcher;
                this.m_threadContext.pushDispatchContext(dispatcher);
                this.m_dispatcher = null;
                try {
                    Object object = dispatcher.dispatch(callable);
                    return object;
                }
                finally {
                    this.m_threadContext.popDispatchContext();
                    this.m_dispatcher = dispatcher;
                }
            }
            return callable.call();
        }
    }

    private final class DispatcherHolderThreadLocal {
        private final ThreadLocal m_threadLocal = new ThreadLocal(){

            public Object initialValue() {
                ThreadContext threadContext = TestData.this.m_threadContextLocator.get();
                if (threadContext == null) {
                    throw new UncheckedException("Only Worker Threads can invoke tests");
                }
                Dispatcher dispatcher = new Dispatcher(threadContext.getDispatchResultReporter(), new StopWatchImplementation(TestData.this.m_timeAuthority));
                return new DispatcherHolder(threadContext, dispatcher);
            }
        };

        private DispatcherHolderThreadLocal() {
        }

        public DispatcherHolder getDispatcherHolder() throws EngineException {
            try {
                return (DispatcherHolder)this.m_threadLocal.get();
            }
            catch (UncheckedException e) {
                throw new EngineException(e.getMessage());
            }
        }
    }
}

