/*
 * Decompiled with CFR 0.152.
 */
package net.grinder.console.swingui;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.table.AbstractTableModel;
import net.grinder.common.processidentity.ProcessReport;
import net.grinder.common.processidentity.WorkerProcessReport;
import net.grinder.console.common.ConsoleException;
import net.grinder.console.common.ProcessReportDescriptionFactory;
import net.grinder.console.common.Resources;
import net.grinder.console.communication.ProcessControl;
import net.grinder.console.swingui.SwingDispatcherFactory;
import net.grinder.console.swingui.Table;
import net.grinder.messages.console.AgentAndCacheReport;

class ProcessStatusTableModel
extends AbstractTableModel
implements Table.TableModel {
    private static final int NAME_COLUMN_INDEX = 0;
    private static final int TYPE_COLUMN_INDEX = 1;
    private static final int STATE_COLUMN_INDEX = 2;
    private final Comparator m_processReportComparator = new ProcessReport.StateThenNameThenNumberComparator();
    private final Comparator m_processReportsComparator = new ProcessControl.ProcessReportsComparator();
    private final ProcessReportDescriptionFactory m_descriptionFactory;
    private final String[] m_columnHeadings;
    private final String m_workerProcessesString;
    private final String m_threadsString;
    private Row[] m_data = new Row[0];

    public ProcessStatusTableModel(Resources resources, ProcessControl processControl, SwingDispatcherFactory swingDispatcherFactory) throws ConsoleException {
        this.m_descriptionFactory = new ProcessReportDescriptionFactory(resources);
        this.m_columnHeadings = new String[3];
        this.m_columnHeadings[0] = resources.getString("processTable.nameColumn.label");
        this.m_columnHeadings[1] = resources.getString("processTable.processTypeColumn.label");
        this.m_columnHeadings[2] = resources.getString("processTable.stateColumn.label");
        this.m_workerProcessesString = resources.getString("processTable.processes.label");
        this.m_threadsString = resources.getString("processTable.threads.label");
        processControl.addProcessStatusListener((ProcessControl.Listener)swingDispatcherFactory.create(new ProcessControl.Listener(){

            public void update(ProcessControl.ProcessReports[] processReports) {
                ArrayList<Row> rows = new ArrayList<Row>();
                int runningThreads = 0;
                int totalThreads = 0;
                int workerProcesses = 0;
                Arrays.sort(processReports, ProcessStatusTableModel.this.m_processReportsComparator);
                for (int i = 0; i < processReports.length; ++i) {
                    AgentAndCacheReport agentProcessStatus = processReports[i].getAgentProcessReport();
                    rows.add(new ProcessDescriptionRow(ProcessStatusTableModel.this.m_descriptionFactory.create(agentProcessStatus)));
                    WorkerProcessReport[] workerProcessStatuses = processReports[i].getWorkerProcessReports();
                    Arrays.sort(workerProcessStatuses, ProcessStatusTableModel.this.m_processReportComparator);
                    for (int j = 0; j < workerProcessStatuses.length; ++j) {
                        runningThreads += workerProcessStatuses[j].getNumberOfRunningThreads();
                        totalThreads += workerProcessStatuses[j].getMaximumNumberOfThreads();
                        rows.add(new IndentedNameRow("  ", new ProcessDescriptionRow(ProcessStatusTableModel.this.m_descriptionFactory.create(workerProcessStatuses[j]))));
                    }
                    workerProcesses += workerProcessStatuses.length;
                }
                rows.add(new TotalRow(runningThreads, totalThreads, workerProcesses));
                ProcessStatusTableModel.access$302(ProcessStatusTableModel.this, rows.toArray(new Row[rows.size()]));
                ProcessStatusTableModel.this.fireTableDataChanged();
            }
        }));
    }

    public int getColumnCount() {
        return this.m_columnHeadings.length;
    }

    public String getColumnName(int column) {
        return this.m_columnHeadings[column];
    }

    public int getRowCount() {
        return this.m_data.length;
    }

    public Object getValueAt(int row, int column) {
        if (row < this.m_data.length) {
            return this.m_data[row].getValueForColumn(column);
        }
        return "";
    }

    public boolean isBold(int row, int column) {
        return row == this.m_data.length - 1;
    }

    public Color getForeground(int row, int column) {
        return null;
    }

    public Color getBackground(int row, int column) {
        return null;
    }

    static /* synthetic */ Row[] access$302(ProcessStatusTableModel x0, Row[] x1) {
        x0.m_data = x1;
        return x1;
    }

    private final class TotalRow
    extends Row {
        private final int m_runningThreads;
        private final int m_totalThreads;
        private final int m_workerProcesses;

        public TotalRow(int runningThreads, int totalThreads, int workerProcesses) {
            this.m_runningThreads = runningThreads;
            this.m_totalThreads = totalThreads;
            this.m_workerProcesses = workerProcesses;
        }

        public String getName() {
            return "";
        }

        public String getProcessType() {
            return "" + this.m_workerProcesses + " " + ProcessStatusTableModel.this.m_workerProcessesString;
        }

        public String getState() {
            return "" + this.m_runningThreads + "/" + this.m_totalThreads + " " + ProcessStatusTableModel.this.m_threadsString;
        }
    }

    private class IndentedNameRow
    extends Row {
        private final String m_indent;
        private final Row m_delegate;

        public IndentedNameRow(String indent, Row row) {
            this.m_indent = indent;
            this.m_delegate = row;
        }

        public String getName() {
            return this.m_indent + this.m_delegate.getName();
        }

        public String getProcessType() {
            return this.m_delegate.getProcessType();
        }

        public String getState() {
            return this.m_delegate.getState();
        }
    }

    private class ProcessDescriptionRow
    extends Row {
        private final ProcessReportDescriptionFactory.ProcessDescription m_description;

        public ProcessDescriptionRow(ProcessReportDescriptionFactory.ProcessDescription description) {
            this.m_description = description;
        }

        public String getName() {
            return this.m_description.getName();
        }

        public String getProcessType() {
            return this.m_description.getProcessType();
        }

        public String getState() {
            return this.m_description.getState();
        }
    }

    private abstract class Row {
        private Row() {
        }

        abstract String getName();

        abstract String getProcessType();

        abstract String getState();

        public String getValueForColumn(int column) {
            switch (column) {
                case 0: {
                    return this.getName();
                }
                case 1: {
                    return this.getProcessType();
                }
                case 2: {
                    return this.getState();
                }
            }
            return "?";
        }
    }
}

